/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.binding.swingx;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jdesktop.binding.DataModel;
import org.jdesktop.binding.swingx.AbstractBinding;

public class TextBinding
extends AbstractBinding {
    private JComponent component;
    private Document document;
    private boolean wasNull;

    public TextBinding(JTextComponent jTextComponent, DataModel dataModel, String string) {
        super(jTextComponent, dataModel, string, 0);
        this.initDocument(jTextComponent.getDocument());
    }

    public TextBinding(JTextComponent jTextComponent, DataModel dataModel, String string, int n) {
        super(jTextComponent, dataModel, string, n);
        this.initDocument(jTextComponent.getDocument());
    }

    public TextBinding(JComponent jComponent, Document document, DataModel dataModel, String string, int n) {
        super(jComponent, dataModel, string, n);
        this.initDocument(document);
    }

    public JComponent getComponent() {
        return this.component;
    }

    protected void setComponent(JComponent jComponent) {
        this.component = jComponent;
        this.configureEditability();
    }

    protected void configureEditability() {
        if (!(this.component instanceof JTextComponent)) {
            return;
        }
        JTextComponent jTextComponent = (JTextComponent)this.component;
        jTextComponent.setEditable(!this.metaData.isReadOnly());
    }

    protected void installMetaDataListener() {
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("readOnly".equals(propertyChangeEvent.getPropertyName())) {
                    TextBinding.this.configureEditability();
                }
            }
        };
        this.metaData.addPropertyChangeListener(propertyChangeListener);
    }

    protected Object getComponentValue() {
        String string;
        try {
            string = this.document.getText(0, this.document.getLength());
            if (this.wasNull && string != null && string.equals("")) {
                string = null;
            }
        }
        catch (BadLocationException badLocationException) {
            string = null;
        }
        return string;
    }

    protected void setComponentValue(Object object) {
        this.wasNull = object == null;
        try {
            this.document.remove(0, this.document.getLength());
            this.document.insertString(0, this.convertFromModelType(object), null);
        }
        catch (BadLocationException badLocationException) {
            UIManager.getLookAndFeel().provideErrorFeedback(this.component);
        }
    }

    private void initDocument(Document document) {
        this.document = document;
        document.addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.maybeModified();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.maybeModified();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.maybeModified();
            }

            public void maybeModified() {
                if (!TextBinding.this.pulling) {
                    TextBinding.this.setModified(true);
                }
            }
        });
    }
}

