/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.binding.swingx;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.jdesktop.binding.DataModel;
import org.jdesktop.binding.IndexMapper;
import org.jdesktop.binding.SelectionModel;
import org.jdesktop.binding.TabularDataModel;
import org.jdesktop.binding.metadata.TabularMetaData;
import org.jdesktop.binding.swingx.AbstractBinding;
import org.jdesktop.binding.swingx.Binding;
import org.jdesktop.binding.swingx.adapter.DataModelToTableModelAdapter;
import org.jdesktop.binding.swingx.adapter.ListSelectionBinding;
import org.jdesktop.swingx.JXTable;

public class TableBinding
extends AbstractBinding
implements Binding {
    private JTable table;

    protected TableBinding(JComponent jComponent, DataModel dataModel, String string) {
        super(jComponent, dataModel, string, 2);
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    protected void setComponent(JComponent jComponent) {
        this.table = (JTable)jComponent;
        this.configureSelection();
    }

    private void configureSelection() {
        Object object = this.metaData.getCustomProperty("selectionModel");
        if (object instanceof SelectionModel) {
            new ListSelectionBinding((SelectionModel)object, this.table.getSelectionModel(), this.createIndexMapper(this.table));
        }
    }

    private IndexMapper createIndexMapper(JTable jTable) {
        if (!(jTable instanceof JXTable)) {
            return null;
        }
        final JXTable jXTable = (JXTable)jTable;
        IndexMapper indexMapper = new IndexMapper(){

            public int viewToModel(int n) {
                return jXTable.convertRowIndexToModel(n);
            }

            public int modelToView(int n) {
                return jXTable.convertRowIndexToView(n);
            }
        };
        return indexMapper;
    }

    protected void installMetaDataListener() {
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("selectionModel".equals(propertyChangeEvent.getPropertyName())) {
                    TableBinding.this.configureSelection();
                }
            }
        };
        this.metaData.addPropertyChangeListener(propertyChangeListener);
    }

    protected Object getComponentValue() {
        throw new UnsupportedOperationException("must not call: TableBinding does not support getComponentValue");
    }

    protected void setComponentValue(Object object) {
        if (object == this.table.getModel()) {
            return;
        }
        if (object instanceof TabularDataModel) {
            TableModel tableModel = this.createTabularAdapter((TabularDataModel)object);
            this.table.setModel(tableModel);
        }
    }

    private TableModel createTabularAdapter(TabularDataModel tabularDataModel) {
        String[] stringArray = null;
        if (this.metaData instanceof TabularMetaData) {
            stringArray = ((TabularMetaData)this.metaData).getFieldNames();
        }
        return new DataModelToTableModelAdapter(tabularDataModel, stringArray);
    }

    public JComponent getComponent() {
        return this.table;
    }
}

