/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.binding.swingx;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import org.jdesktop.binding.DataModel;
import org.jdesktop.binding.SelectionModel;
import org.jdesktop.binding.TabularDataModel;
import org.jdesktop.binding.metadata.ListMetaData;
import org.jdesktop.binding.swingx.AbstractBinding;
import org.jdesktop.binding.swingx.adapter.DataModelToListModelAdapter;
import org.jdesktop.binding.swingx.adapter.ListSelectionBinding;

public class ListBinding
extends AbstractBinding {
    private JList list;

    public ListBinding(JList jList, DataModel dataModel, String string) {
        super(jList, dataModel, string, 2);
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public JComponent getComponent() {
        return this.list;
    }

    protected void setComponent(JComponent jComponent) {
        this.list = (JList)jComponent;
        this.configureSelection();
    }

    private void configureSelection() {
        Object object = this.metaData.getCustomProperty("selectionModel");
        if (object instanceof SelectionModel) {
            new ListSelectionBinding((SelectionModel)object, this.list.getSelectionModel());
        }
    }

    protected void installMetaDataListener() {
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("selectionModel".equals(propertyChangeEvent.getPropertyName())) {
                    ListBinding.this.configureSelection();
                }
            }
        };
        this.metaData.addPropertyChangeListener(propertyChangeListener);
    }

    protected Object getComponentValue() {
        ListModel listModel = this.list.getModel();
        Class clazz = this.metaData.getElementClass();
        if (clazz.equals(List.class)) {
            ArrayList arrayList = new ArrayList();
            int n = listModel.getSize();
            for (int i = 0; i < n; ++i) {
                arrayList.add(listModel.getElementAt(i));
            }
            return arrayList;
        }
        if (clazz.isArray()) {
            int n = listModel.getSize();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = listModel.getElementAt(i);
            }
            return objectArray;
        }
        return null;
    }

    protected void setComponentValue(Object object) {
        if (this.metaData instanceof ListMetaData) {
            this.setComponentValueFromTabularDataModel((TabularDataModel)object);
            return;
        }
        Class clazz = this.metaData.getElementClass();
        if (clazz.equals(List.class)) {
            List list = (List)object;
            if (list != null) {
                this.list.setListData(list.toArray());
            }
        } else if (clazz.isArray()) {
            Object[] objectArray = (Object[])object;
            if (objectArray != null) {
                this.list.setListData(objectArray);
            } else {
                this.list.setModel(new DefaultListModel());
            }
        }
    }

    private void setComponentValueFromTabularDataModel(TabularDataModel tabularDataModel) {
        ListMetaData listMetaData = (ListMetaData)this.metaData;
        this.list.setModel(new DataModelToListModelAdapter(tabularDataModel, listMetaData.getRendererFieldName()));
    }
}

