/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.binding.metadata;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jdesktop.binding.metadata.Converter;
import org.jdesktop.binding.metadata.Converters;
import org.jdesktop.binding.metadata.Validator;

public class MetaData {
    protected String name;
    protected Class klass = String.class;
    protected String label;
    protected Converter converter = null;
    protected Object decodeFormat = null;
    protected Object encodeFormat = null;
    protected boolean readOnly = false;
    protected int minValueCount = 0;
    protected int maxValueCount = 1;
    protected int displayWidth = 24;
    protected ArrayList validators = null;
    protected Map customProps = new HashMap();
    protected PropertyChangeSupport pcs;

    public MetaData() {
        this("value");
    }

    public MetaData(String string) {
        this.name = string;
    }

    public MetaData(String string, Class clazz) {
        this(string);
        this.klass = clazz;
    }

    public MetaData(String string, Class clazz, String string2) {
        this(string, clazz);
        this.label = string2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        this.firePropertyChange("name", string2, string);
    }

    public Class getElementClass() {
        return this.klass;
    }

    public void setElementClass(Class clazz) {
        Class clazz2 = this.klass;
        this.klass = clazz;
        this.firePropertyChange("elementClass", clazz2, clazz);
    }

    public String getLabel() {
        return this.label == null ? this.name : this.label;
    }

    public void setLabel(String string) {
        String string2 = this.label;
        this.label = string;
        this.firePropertyChange("label", string2, string);
    }

    public Converter getConverter() {
        if (this.converter == null) {
            return Converters.get(this.klass);
        }
        return this.converter;
    }

    public void setConverter(Converter converter) {
        Converter converter2 = this.converter;
        this.converter = converter;
        this.firePropertyChange("converter", converter2, converter);
    }

    public Object getDecodeFormat() {
        return this.decodeFormat;
    }

    public void setDecodeFormat(Object object) {
        Object object2 = this.decodeFormat;
        this.decodeFormat = object;
        this.firePropertyChange("decodeFormat", object2, object);
    }

    public Object getEncodeFormat() {
        return this.encodeFormat;
    }

    public void setEncodeFormat(Object object) {
        Object object2 = this.encodeFormat;
        this.encodeFormat = object;
        this.firePropertyChange("encodeFormat", object2, object);
    }

    public int getDisplayWidth() {
        return this.displayWidth;
    }

    public void setDisplayWidth(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("displayWidth must be >= 0");
        }
        int n2 = this.displayWidth;
        this.displayWidth = n;
        this.firePropertyChange("displayWidth", n2, n);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        boolean bl2 = this.readOnly;
        this.readOnly = bl;
        this.firePropertyChange("readOnly", bl2, bl);
    }

    public int getMinValueCount() {
        return this.minValueCount;
    }

    public void setMinValueCount(int n) {
        int n2 = this.minValueCount;
        this.minValueCount = n;
        this.firePropertyChange("minValueCount", n2, n);
    }

    public boolean isRequired() {
        return this.getMinValueCount() > 0;
    }

    public void setRequired(boolean bl) {
        if (bl) {
            if (this.getMinValueCount() <= 0) {
                this.setMinValueCount(1);
            }
        } else if (this.getMinValueCount() > 0) {
            this.setMinValueCount(0);
        }
    }

    public int getMaxValueCount() {
        return this.maxValueCount;
    }

    public void setMaxValueCount(int n) {
        int n2 = this.maxValueCount;
        this.maxValueCount = n;
        this.firePropertyChange("maxValueCount", n2, n);
    }

    public void setCustomProperty(String string, Object object) {
        if (string == null) {
            throw new NullPointerException("The propertyName for a custom property on MetaData cannot be null");
        }
        Object v = this.customProps.get(string);
        this.customProps.put(string, object);
        this.firePropertyChange(string, v, object);
    }

    public Object getCustomProperty(String string) {
        if (string == null) {
            throw new NullPointerException("The propertyName for a custom property on MetaData cannot be null");
        }
        return this.customProps.get(string);
    }

    public Object getCustomProperty(String string, Object object) {
        if (string == null) {
            throw new NullPointerException("The propertyName for a custom property on MetaData cannot be null");
        }
        return this.customProps.containsKey(string) ? this.customProps.get(string) : object;
    }

    public void removeCustomProperty(String string) {
        if (string == null) {
            throw new NullPointerException("The propertyName for a custom property on MetaData cannot be null");
        }
        Object v = this.customProps.get(string);
        this.customProps.remove(string);
        this.firePropertyChange(string, v, null);
    }

    public String[] getCustomPropertyKeys() {
        Object[] objectArray = this.customProps.keySet().toArray();
        String[] stringArray = new String[objectArray.length];
        System.arraycopy(objectArray, 0, stringArray, 0, objectArray.length);
        return stringArray;
    }

    public void addValidator(Validator validator) {
        if (this.validators == null) {
            this.validators = new ArrayList();
        }
        this.validators.add(validator);
    }

    public void removeValidator(Validator validator) {
        if (this.validators != null) {
            this.validators.remove(validator);
            if (this.validators.size() == 0) {
                this.validators = null;
            }
        }
    }

    public Validator[] getValidators() {
        if (this.validators != null) {
            return this.validators.toArray(new Validator[1]);
        }
        return new Validator[0];
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.pcs != null) {
            return this.pcs.getPropertyChangeListeners();
        }
        return new PropertyChangeListener[0];
    }

    protected void firePropertyChange(String string, int n, int n2) {
        if (n2 != n) {
            this.firePropertyChange(string, new Integer(n), new Integer(n2));
        }
    }

    protected void firePropertyChange(String string, boolean bl, boolean bl2) {
        if (bl2 != bl) {
            this.firePropertyChange(string, (Object)bl, (Object)bl2);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(string, object, object2);
        }
    }
}

