/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jcodings.Encoding;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.specific.ASCIIEncoding;

public final class ByteList
implements Comparable,
CharSequence,
Serializable {
    private static final long serialVersionUID = -1286166947275543731L;
    public static final byte[] NULL_ARRAY = new byte[0];
    public static final ByteList EMPTY_BYTELIST = new ByteList(0);
    @Deprecated
    public byte[] bytes;
    @Deprecated
    public int begin;
    @Deprecated
    public int realSize;
    @Deprecated
    public Encoding encoding = ASCIIEncoding.INSTANCE;
    int hash;
    String stringValue;
    private static final int DEFAULT_SIZE = 4;
    private static final ConcurrentMap<String, Charset> charsetsByAlias = new ConcurrentHashMap<String, Charset>();

    public ByteList() {
        this(4);
    }

    public ByteList(int size) {
        this.bytes = new byte[size];
        this.realSize = 0;
    }

    public ByteList(byte[] bytes, Encoding encoding) {
        this.bytes = bytes;
        this.realSize = bytes.length;
        this.encoding = ByteList.safeEncoding(encoding);
    }

    public ByteList(byte[] wrap) {
        this(wrap, true);
    }

    public ByteList(byte[] wrap, boolean copy) {
        this(wrap, (Encoding)ASCIIEncoding.INSTANCE, copy);
    }

    public ByteList(byte[] wrap, Encoding encoding, boolean copy) {
        assert (wrap != null);
        this.bytes = copy ? (byte[])wrap.clone() : wrap;
        this.realSize = wrap.length;
        this.encoding = ByteList.safeEncoding(encoding);
    }

    public ByteList(ByteList wrap) {
        this(wrap.bytes, wrap.begin, wrap.realSize, wrap.encoding, true);
    }

    @Deprecated
    public ByteList(ByteList wrap, boolean copy) {
        this(wrap.bytes, wrap.begin, wrap.realSize, wrap.encoding, false);
    }

    public ByteList(byte[] wrap, int index, int len) {
        this(wrap, index, len, true);
    }

    public ByteList(byte[] wrap, int index, int len, boolean copy) {
        this(wrap, index, len, (Encoding)ASCIIEncoding.INSTANCE, copy);
    }

    public ByteList(byte[] wrap, int index, int len, Encoding encoding, boolean copy) {
        assert (wrap != null) : "'wrap' must not be null";
        assert (index >= 0 && index <= wrap.length) : "'index' is not without bounds of 'wrap' array";
        assert (wrap.length >= index + len) : "'index' + 'len' is longer than the 'wrap' array";
        if (copy || index != 0) {
            this.bytes = new byte[len];
            System.arraycopy(wrap, index, this.bytes, 0, len);
        } else {
            this.bytes = wrap;
        }
        this.realSize = len;
        this.encoding = ByteList.safeEncoding(encoding);
    }

    public ByteList(ByteList wrap, int index, int len) {
        this(wrap.bytes, wrap.begin + index, len);
    }

    public void delete(int start, int len) {
        assert (start >= this.begin && start < this.realSize) : "'start' is at invalid index";
        assert (len >= 0) : "'len' must be positive";
        assert (start + len <= this.begin + this.realSize) : "too many bytes requested";
        this.realSize -= len;
        System.arraycopy(this.bytes, start + len, this.bytes, start, this.realSize);
    }

    public void fill(int b, int len) {
        while (--len >= 0) {
            this.append(b);
        }
    }

    public Object clone() {
        return this.dup();
    }

    public ByteList dup() {
        ByteList dup = this.dup(this.realSize);
        dup.hash = this.hash;
        dup.stringValue = this.stringValue;
        return dup;
    }

    public ByteList shallowDup() {
        ByteList dup = new ByteList(this.bytes, false);
        dup.realSize = this.realSize;
        dup.begin = this.begin;
        dup.encoding = ByteList.safeEncoding(this.encoding);
        dup.hash = this.hash;
        dup.stringValue = this.stringValue;
        return dup;
    }

    public ByteList dup(int length) {
        ByteList dup = new ByteList(length);
        dup.append(this.bytes, this.begin, this.realSize);
        dup.encoding = ByteList.safeEncoding(this.encoding);
        return dup;
    }

    public void ensure(int length) {
        if (length >= this.bytes.length) {
            byte[] tmp = new byte[length + (length >>> 1)];
            System.arraycopy(this.bytes, this.begin, tmp, 0, this.realSize);
            this.bytes = tmp;
        }
    }

    public ByteList makeShared(int index, int len) {
        ByteList shared = new ByteList(this.bytes, this.encoding);
        shared.realSize = len;
        shared.begin = this.begin + index;
        return shared;
    }

    public void view(int index, int len) {
        this.realSize = len;
        this.begin += index;
    }

    public void unshare() {
        this.unshare(this.realSize);
    }

    public void unshare(int length) {
        byte[] tmp = new byte[length];
        System.arraycopy(this.bytes, this.begin, tmp, 0, Math.min(this.realSize, length));
        this.bytes = tmp;
        this.begin = 0;
    }

    public void invalidate() {
        this.hash = 0;
        this.stringValue = null;
    }

    public void prepend(byte b) {
        this.grow(1);
        System.arraycopy(this.bytes, 0, this.bytes, 1, this.realSize);
        this.bytes[0] = b;
        ++this.realSize;
    }

    public ByteList append(byte b) {
        this.grow(1);
        this.bytes[this.realSize++] = b;
        return this;
    }

    public ByteList append(int b) {
        this.append((byte)b);
        return this;
    }

    public ByteList append(InputStream input, int length) throws IOException {
        int read;
        int n;
        this.grow(length);
        for (read = 0; read < length; read += n) {
            n = input.read(this.bytes, this.begin + read, length - read);
            if (n != -1) continue;
            if (read != 0) break;
            throw new EOFException();
        }
        this.realSize += read;
        return this;
    }

    public void append(ByteBuffer buffer, int len) {
        this.grow(len);
        buffer.get(this.bytes, this.realSize, len);
        this.realSize += len;
    }

    public void append(byte[] moreBytes) {
        assert (moreBytes != null) : "moreBytes is null";
        this.grow(moreBytes.length);
        System.arraycopy(moreBytes, 0, this.bytes, this.realSize, moreBytes.length);
        this.realSize += moreBytes.length;
    }

    public void append(ByteList moreBytes) {
        this.append(moreBytes.bytes, moreBytes.begin, moreBytes.realSize);
    }

    public void append(ByteList moreBytes, int index, int len) {
        this.append(moreBytes.bytes, moreBytes.begin + index, len);
    }

    public void append(byte[] moreBytes, int start, int len) {
        assert (moreBytes != null) : "moreBytes is null";
        assert (len >= 0 && moreBytes.length - start >= len) : "Bad length";
        this.grow(len);
        System.arraycopy(moreBytes, start, this.bytes, this.realSize, len);
        this.realSize += len;
    }

    public void realloc(int length) {
        assert (length >= 0) : "Invalid length";
        assert (length >= this.realSize) : "length is too small";
        byte[] tmp = new byte[length];
        System.arraycopy(this.bytes, 0, tmp, 0, this.realSize);
        this.bytes = tmp;
    }

    public int length() {
        return this.realSize;
    }

    public void length(int newLength) {
        this.grow(newLength - this.realSize);
        this.realSize = newLength;
    }

    public int lengthEnc() {
        return this.encoding.strLength(this.bytes, this.begin, this.begin + this.realSize);
    }

    public int get(int index) {
        assert (index >= 0) : "index must be positive";
        return this.bytes[this.begin + index];
    }

    public int getEnc(int index) {
        return this.encoding.strCodeAt(this.bytes, this.begin, this.begin + this.realSize, index);
    }

    public void set(int index, int b) {
        assert (index >= 0) : "index must be positive";
        assert (this.begin + index < this.begin + this.realSize) : "index is too large";
        this.bytes[this.begin + index] = (byte)b;
    }

    @Deprecated
    public void replace(byte[] newBytes) {
        assert (newBytes != null);
        this.bytes = newBytes;
        this.realSize = newBytes.length;
    }

    public void unsafeReplace(int beg, int len, ByteList nbytes) {
        this.unsafeReplace(beg, len, nbytes.bytes, nbytes.begin, nbytes.realSize);
    }

    public void unsafeReplace(int beg, int len, byte[] buf) {
        this.unsafeReplace(beg, len, buf, 0, buf.length);
    }

    public void unsafeReplace(int beg, int len, byte[] nbytes, int index, int count) {
        this.grow(count - len);
        int newSize = this.realSize + count - len;
        System.arraycopy(this.bytes, beg + len, this.bytes, beg + count, this.realSize - (len + beg));
        System.arraycopy(nbytes, index, this.bytes, beg, count);
        this.realSize = newSize;
    }

    public void replace(int beg, int len, ByteList nbytes) {
        this.replace(beg, len, nbytes.bytes, nbytes.begin, nbytes.realSize);
    }

    public void replace(int beg, int len, byte[] buf) {
        this.replace(beg, len, buf, 0, buf.length);
    }

    public void replace(int beg, int len, byte[] nbytes, int index, int count) {
        this.unsafeReplace(beg, len, nbytes, index, count);
    }

    public void insert(int index, int b) {
        this.grow(1);
        System.arraycopy(this.bytes, index, this.bytes, index + 1, this.realSize - index);
        this.bytes[index] = (byte)b;
        ++this.realSize;
    }

    public int indexOf(int c) {
        return this.indexOf(c, 0);
    }

    public int indexOf(int c, int pos) {
        if (c > 255) {
            return -1;
        }
        byte b = (byte)(c & 0xFF);
        int size = this.begin + this.realSize;
        byte[] buf = this.bytes;
        pos += this.begin;
        while (pos < size && buf[pos] != b) {
            ++pos;
        }
        return pos < size ? pos - this.begin : -1;
    }

    public int indexOf(ByteList find) {
        return this.indexOf(find, 0);
    }

    public int indexOf(ByteList find, int i) {
        return ByteList.indexOf(this.bytes, this.begin, this.realSize, find.bytes, find.begin, find.realSize, i);
    }

    static int indexOf(byte[] source, int sourceOffset, int sourceCount, byte[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        byte first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    public int lastIndexOf(int c) {
        return this.lastIndexOf(c, this.realSize - 1);
    }

    public int lastIndexOf(int c, int pos) {
        if (c > 255) {
            return -1;
        }
        byte b = (byte)(c & 0xFF);
        int size = this.begin + this.realSize;
        byte[] buf = this.bytes;
        pos = (pos += this.begin) >= size ? size : ++pos;
        while (--pos >= this.begin && buf[pos] != b) {
        }
        return pos - this.begin;
    }

    public int lastIndexOf(ByteList find) {
        return this.lastIndexOf(find, this.realSize);
    }

    public int lastIndexOf(ByteList find, int pos) {
        return ByteList.lastIndexOf(this.bytes, this.begin, this.realSize, find.bytes, find.begin, find.realSize, pos);
    }

    static int lastIndexOf(byte[] source, int sourceOffset, int sourceCount, byte[] target, int targetOffset, int targetCount, int fromIndex) {
        int start;
        int rightIndex = sourceCount - targetCount;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        int strLastIndex = targetOffset + targetCount - 1;
        byte strLastChar = target[strLastIndex];
        int min = sourceOffset + targetCount - 1;
        int i = min + fromIndex;
        block0: while (true) {
            if (i >= min && source[i] != strLastChar) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetCount - 1);
            int k = strLastIndex - 1;
            while (j > start) {
                if (source[j--] == target[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start - sourceOffset + 1;
    }

    public boolean startsWith(ByteList other, int toffset) {
        if (this.realSize == 0) {
            return false;
        }
        byte[] ta = this.bytes;
        int to = this.begin + toffset;
        byte[] pa = other.bytes;
        int po = other.begin;
        int pc = other.realSize;
        while (--pc >= 0) {
            if (ta[to++] == pa[po++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(ByteList other) {
        return this.startsWith(other, 0);
    }

    public boolean endsWith(ByteList other) {
        return this.startsWith(other, this.realSize - other.realSize);
    }

    public boolean equals(Object other) {
        if (other instanceof ByteList) {
            return this.equal((ByteList)other);
        }
        return false;
    }

    public boolean equal(ByteList other) {
        if (other == this) {
            return true;
        }
        if (this.hash != 0 && other.hash != 0 && this.hash != other.hash) {
            return false;
        }
        int last = this.realSize;
        if (last == other.realSize) {
            byte[] buf = this.bytes;
            byte[] otherBuf = other.bytes;
            int first = -1;
            while (--last > first && buf[this.begin + last] == otherBuf[other.begin + last] && ++first < last && buf[this.begin + first] == otherBuf[other.begin + first]) {
            }
            return first >= last;
        }
        return false;
    }

    public boolean sample_equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ByteList) {
            ByteList b = (ByteList)other;
            int size = this.realSize;
            if (size == b.realSize) {
                byte[] buf = this.bytes;
                int first = -1;
                int last = size + 1 & 0xFFFFFFFE;
                while ((last -= 2) >= 0 && buf[this.begin + last] == b.bytes[b.begin + last] && (first += 2) < size && buf[this.begin + first] == b.bytes[b.begin + first]) {
                }
                return last < 0 || first == size;
            }
        }
        return false;
    }

    public int compareTo(Object other) {
        return this.cmp((ByteList)other);
    }

    public int cmp(ByteList other) {
        if (other == this) {
            return 0;
        }
        int size = this.realSize;
        int len = Math.min(size, other.realSize);
        int offset = -1;
        while (++offset < len && this.bytes[this.begin + offset] == other.bytes[other.begin + offset]) {
        }
        if (offset < len) {
            return (this.bytes[this.begin + offset] & 0xFF) > (other.bytes[other.begin + offset] & 0xFF) ? 1 : -1;
        }
        return size == other.realSize ? 0 : (size == len ? -1 : 1);
    }

    public int caseInsensitiveCmp(ByteList other) {
        if (other == this) {
            return 0;
        }
        int size = this.realSize;
        int len = Math.min(size, other.realSize);
        int other_begin = other.begin;
        byte[] other_bytes = other.bytes;
        int offset = -1;
        while (++offset < len) {
            byte myCharIgnoreCase = AsciiTables.ToLowerCaseTable[this.bytes[this.begin + offset] & 0xFF];
            byte otherCharIgnoreCase = AsciiTables.ToLowerCaseTable[other_bytes[other_begin + offset] & 0xFF];
            if (myCharIgnoreCase < otherCharIgnoreCase) {
                return -1;
            }
            if (myCharIgnoreCase <= otherCharIgnoreCase) continue;
            return 1;
        }
        return size == other.realSize ? 0 : (size == len ? -1 : 1);
    }

    public byte[] unsafeBytes() {
        return this.bytes;
    }

    public byte[] bytes() {
        byte[] newBytes = new byte[this.realSize];
        System.arraycopy(this.bytes, this.begin, newBytes, 0, this.realSize);
        return newBytes;
    }

    public int begin() {
        return this.begin;
    }

    private void grow(int increaseRequested) {
        if (increaseRequested < 0) {
            return;
        }
        int newSize = this.realSize + increaseRequested;
        if (newSize > this.bytes.length) {
            byte[] newBytes = new byte[newSize + (newSize >> 1)];
            if (this.bytes.length != 0) {
                System.arraycopy(this.bytes, 0, newBytes, 0, this.realSize);
            }
            this.bytes = newBytes;
        }
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int key = 0;
        int index = this.begin;
        int end = this.begin + this.realSize;
        while (index < end) {
            key = (key << 16) + (key << 6) - key + this.bytes[index++];
        }
        key += key >> 5;
        this.hash = key;
        return this.hash;
    }

    public String toString() {
        if (this.stringValue == null) {
            this.stringValue = ByteList.decode(this.bytes, this.begin, this.realSize, "ISO-8859-1");
        }
        return this.stringValue;
    }

    public static ByteList create(CharSequence s) {
        return new ByteList(ByteList.plain(s), false);
    }

    public static byte[] plain(CharSequence s) {
        if (s instanceof String) {
            return ByteList.encode(s, "ISO-8859-1");
        }
        byte[] bytes = new byte[s.length()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)s.charAt(i);
        }
        return bytes;
    }

    public static byte[] plain(char[] s) {
        byte[] bytes = new byte[s.length];
        for (int i = 0; i < s.length; ++i) {
            bytes[i] = (byte)s[i];
        }
        return bytes;
    }

    public static char[] plain(byte[] b, int start, int length) {
        assert (b != null) : "byte array cannot be null";
        assert (start >= 0 && start + length <= b.length) : "Invalid start or start+length too long";
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)(b[start + i] & 0xFF);
        }
        return chars;
    }

    public static char[] plain(byte[] b) {
        assert (b != null) : "byte array cannot be null";
        char[] chars = new char[b.length];
        for (int i = 0; i < b.length; ++i) {
            chars[i] = (char)(b[i] & 0xFF);
        }
        return chars;
    }

    public static String decode(byte[] data, int offset, int length, String charsetName) {
        return ByteList.lookup(charsetName).decode(ByteBuffer.wrap(data, offset, length)).toString();
    }

    public static String decode(byte[] data, String charsetName) {
        return ByteList.lookup(charsetName).decode(ByteBuffer.wrap(data)).toString();
    }

    public static byte[] encode(CharSequence data, String charsetName) {
        return ByteList.lookup(charsetName).encode(CharBuffer.wrap(data)).array();
    }

    private static Charset lookup(String alias) {
        Charset cs = (Charset)charsetsByAlias.get(alias);
        if (cs == null) {
            cs = Charset.forName(alias);
            charsetsByAlias.putIfAbsent(alias, cs);
        }
        return cs;
    }

    public char charAt(int ix) {
        return (char)(this.bytes[this.begin + ix] & 0xFF);
    }

    public CharSequence subSequence(int start, int end) {
        return new ByteList(this, start, end - start);
    }

    public static int memcmp(byte[] first, int firstStart, int firstLen, byte[] second, int secondStart, int secondLen) {
        if (first == second) {
            return 0;
        }
        int len = Math.min(firstLen, secondLen);
        int offset = -1;
        while (++offset < len && first[firstStart + offset] == second[secondStart + offset]) {
        }
        if (offset < len) {
            return (first[firstStart + offset] & 0xFF) > (second[secondStart + offset] & 0xFF) ? 1 : -1;
        }
        return firstLen == secondLen ? 0 : (firstLen == len ? -1 : 1);
    }

    public static int memcmp(byte[] first, int firstStart, byte[] second, int secondStart, int len) {
        if (first == second) {
            return 0;
        }
        int offset = -1;
        while (++offset < len && first[firstStart + offset] == second[secondStart + offset]) {
        }
        if (offset < len) {
            return (first[firstStart + offset] & 0xFF) > (second[secondStart + offset] & 0xFF) ? 1 : -1;
        }
        return 0;
    }

    public final byte[] getUnsafeBytes() {
        return this.bytes;
    }

    public final void setUnsafeBytes(byte[] bytes) {
        assert (bytes != null);
        this.bytes = bytes;
    }

    public final int getBegin() {
        return this.begin;
    }

    public final void setBegin(int begin) {
        assert (begin >= 0);
        this.begin = begin;
    }

    public final int getRealSize() {
        return this.realSize;
    }

    public final void setRealSize(int realSize) {
        assert (realSize >= 0);
        this.realSize = realSize;
    }

    public final Encoding getEncoding() {
        return this.encoding;
    }

    public final void setEncoding(Encoding encoding) {
        assert (encoding != null);
        this.encoding = ByteList.safeEncoding(encoding);
    }

    public static Encoding safeEncoding(Encoding incoming) {
        if (incoming == null) {
            return ASCIIEncoding.INSTANCE;
        }
        return incoming;
    }
}

