# kytea で漢方薬の変換結果が 漢方/かんぽう 薬/く となる

`薬/く` が wikipedia の変換結果に含まれている。
これは、kytea がそういう出力をしているのだろうということが予想がつく。

https://kanji.jitenon.jp/kanji/418.html

漢和辞典でも、薬の読み方に「く」は登録されていない。

https://ja.wikipedia.org/wiki/%E6%95%91%E5%BF%83%E8%A3%BD%E8%96%AC

によれば、

> 生薬・漢方薬を中心にしたOTC医薬品を数多く手がけている。

という文章が kytea では

```
生薬・漢方薬を中心にしたOTC医薬品を数多く手がけている。
生薬/名詞/しょうやく ・/補助記号/・ 漢方/名詞/かんぽう 薬/接尾辞/く を/助詞/を 中心/名詞/ちゅうしん に/助詞/に し/動詞/し た/助動詞/た OTC/名詞/おーてぃーしー 医薬/名詞/いやく 品/接尾辞/ひん を/助詞/を 数/名詞/かず 多く/名詞/おおく 手がけ/動詞/てがけ て/助詞/て い/動 詞/い る/語尾/る 。/補助記号/。
```

と分かち書きされていることが原因だ。

本来ならこれは「漢方薬/かんぽうやく」になってほしい。

既存の kytea のモデルを元に一部だけ変更を加えるというのは簡単なのだが、計算機資源をわりと必要とする処理となる。

kytea の素性ファイルが http://www.phontron.com/kytea/train-ja.html からダウンロードできるのでこれを活用する。

これを元に

```shell
time train-kytea -feat work/kytea/kytea-0.4.2.feat -full corpus/kytea.txt -model work/kytea/train.mod
```

などとして、追加のコーパスを食わせて学習させる。

だいたい5分ぐらいで学習が終わるようだ。

このモデルを利用すると以下のように、適切に分割されるようになる。

```
$ echo 生薬・漢方薬を中心にしたOTC医薬品を数 多く手がけている。|kytea -model work/kytea/train.mod
生薬/名詞/しょうやく ・/補助記号/・ 漢方薬/名詞/かんぽうやく を/助詞/を 中心/名詞/ちゅうしん に/助詞/に し/動詞/し た/助動詞/た OTC/名詞/おーてぃーしー 医薬/名詞/いやく 品/接尾辞/ひん を/助詞/を 数/名詞/かず 多く/名詞/おおく 手がけ/動詞/てがけ て/助詞/て い/動/い る/語尾/る 。/補助記号/。
```

kytea は単漢字の読み間違いがそこそこあるような気がする。
単漢字の間違った登録は、直接的に変換速度の低下につながるので、できるだけ防いだ方が良い。

このようなケースについては、corpus/kytea.txt に追加していけば学習できるようにしておいた。

ところで、ひらがな一文字の文字の単漢字の誤登録は SKK-JISYO.L などと突合させれば、わりと見つけることができそうである。
つまり、かな漢字辞書に対して一文字のものを列挙し、SKK-JISYO.L に無い物を報告するスクリプトを作れば良い。

よって、tests/kanpoyaku.rs を追加した。

以下の様なケースで、へんな漢字が登録されていることがわかった。

```
moji="か", system_dict_len=["乎", "借", "刈", "勝", "咬", "噛", "掻", "書", "欠", "歟", "穫", "缺", "苅", "買", "貸", "購", "飼", "駆", "駈"]
moji="し", system_dict_len=["如", "敷", "沁", "識"]
moji="お", system_dict_len=["峰", "折", "押", "捺", "推", "置", "負", "追", "逐"]
moji="あ", system_dict_len=["会", "合", "在", "惡", "有", "空", "編", "逢", "遇", "遭", "開"]
moji="い", system_dict_len=["云", "入", "可", "往", "快", "煎", "生", "藺", "行", "要", "言", "逝"]
moji="こ", system_dict_len=["好喜", "琥珀", "乞", "凝", "混", "漉", "漕", "超", "越"]
moji="た", system_dict_len=["建", "断", "炊", "立", "経", "絶", "誰", "起", "足"]
moji="さ", system_dict_len=["刺", "割", "去", "咲", "射", "指", "挿", "裂"]
moji="き", system_dict_len=["切", "利", "効", "截", "斫", "斬", "炫", "聴", "葱", "訊"]
moji="と", system_dict_len=["取", "問", "執", "島", "捕", "採", "摂", "撮", "溶", "獲", "翔", "解", "説", "跳", "録", "飛"]
moji="な", system_dict_len=["亡", "勿", "啼", "成", "无", "汝", "泣", "莫", "薙", "鳴"]
moji="み", system_dict_len=["満", "観", "診", "躬"]
moji="は", system_dict_len=["河", "匐", "吐", "履", "掃", "穿", "貼", "蹈", "這"]
moji="ふ", system_dict_len=["伏", "吹", "噴", "振", "臥", "践", "踏", "降"]
moji="ま", system_dict_len=["俟", "増", "室", "巻", "待", "撒", "舞", "蒔"]
moji="ひ", system_dict_len=["引", "弾", "彎", "惹", "挽", "曳", "轢", "魅"]
moji="う", system_dict_len=["栩", "倦", "売", "打", "撃", "泛", "浮", "産", "討", "賣"]
moji="く", system_dict_len=["具", "喰", "拱", "汲", "組", "繰", "酌", "食"]
moji="ち", system_dict_len=["散"]
moji="す", system_dict_len=["住", "刷", "吸", "好", "擂", "擦", "済", "澄", "濟", "馬尾"]
moji="ほ", system_dict_len=["干", "彫", "掘"]
moji="つ", system_dict_len=["就", "摘", "撞", "次", "着", "突", "継", "釣"]
moji="て", system_dict_len=["照"]
moji="だ", system_dict_len=["勃", "抱"]
moji="そ", system_dict_len=["剃", "沿", "添"]
moji="け", system_dict_len=["笥", "蹶"]
moji="の", system_dict_len=["−", "乗", "乘", "呑", "延", "載", "飲"]
moji="ど", system_dict_len=["砥", "秉"]
moji="ご", system_dict_len=["棊", "込"]
moji="が", system_dict_len=["貸"]
moji="ぜ", system_dict_len=["瀬"]
moji="ね", system_dict_len=["練", "錬"]
moji="へ", system_dict_len=["減"]
moji="ぷ", system_dict_len=["譜"]
moji="ぬ", system_dict_len=["塗", "抜", "拔", "縫", "脱"]
moji="ぽ", system_dict_len=["浦"]
```

kytea にいくらかの用意したコーパスを学習させることによって、変換精度を高めることができると思うけれど、kytea 用のデータを用意すること自体がちょっと手間なのと、
kytea の学習に5分ぐらい時間がかかるのと、それを使って学習しなおすのに時間が結構かかるという問題があります。

- work/annotated/AD/wiki_36
