package org.jruby.parser;

public class Ruby19YyTables {
   private static short[] combine(short[] t1, short[] t2, 
                                  short[] t3, short[] t4) {
      short[] t = new short[t1.length + t2.length + t3.length + t4.length];
      int index = 0;
      System.arraycopy(t1, 0, t, index, t1.length);
      index += t1.length;
      System.arraycopy(t2, 0, t, index, t2.length);
      index += t2.length;
      System.arraycopy(t3, 0, t, index, t3.length);
      index += t3.length;
      System.arraycopy(t4, 0, t, index, t4.length);
      return t;
   }

   public static final short[] yyTable() {
      return combine(yyTable1(), yyTable2(), yyTable3(), yyTable4());
   }

   public static final short[] yyCheck() {
      return combine(yyCheck1(), yyCheck2(), yyCheck3(), yyCheck4());
   }
   private static final short[] yyTable1() {
      return new short[] {

          196,  196,  263,  293,  266,  195,  260,  262,  265,  601, 
          502,  366,  540,  589,  612,  423,  480,  209,  282,  540, 
          284,  196,   85,   85,  117,  117,  403,  505,   85,  221, 
          221,  221,  540,  211,  236,  221,  221,  209,  540,  221, 
          283,  286,  375,   98,  456,  227,  196,  457,   92,   92, 
          315,  301,  770,  211,   92,  344,  231,  295,  246,  246, 
          238,  540,  246,  764,   72,   85,  221,  651,  557,  291, 
          777,  221,  312,  116,  116,  312,  227,  775,  540,  785, 
          267,  369,  453,  116,  502,  225,  228,  540,  498,  480, 
          319,   92,  588,  227,  226,  547,  553,  618,  560,  561, 
          227,  472,  630,  575,  835,  477,  373,  673,  540,  609, 
          374,  832,  486,  447,  291,   72,  452,   64,  116,  583, 
           70,   62,  255,  623,  231,  226,  596,  540,  897,  221, 
          685,   85,  258,  258,  300,  630,  547,  553,  480,   68, 
          505,  480,  226,   90,  500,  715,  486,   65,   63,  226, 
          583,  360,  337,  313,  480,  661,  313,   92,  434,  330, 
          379,  486,  262,  116,  335,  338,  736,  688,   64,  333, 
          453,   70,   60,  709,  650,  654,  674,  540,  500,  852, 
          743,  583,   75,  300,  881,  268,   73,  502,  336,  505, 
           68,  331,   90,  500,  897,   66,   71,  334,   65,   61, 
          332,  583,  570,  480,  455,  796,  460,  751,  680,  540, 
          277,  800,  714,  415,  416,  417,  486,  540,   69,  540, 
           67,  770,  835,  720,  518,  435,  436,  492,  359,  737, 
          535,  486,   75,  909,  274,  360,  777,   73,  775,  404, 
          480,  681,  492,  272,  273,  481,   66,   71,  535,   61, 
           65,   65,  221,  221,  775,  306,   65,   65,   65,   65, 
          308,  930,  480,   65,   65,  665,  540,   65,  540,   69, 
           53,   67,  386,  231,  354,  221,  655,  221,  221,  387, 
          262,  221,  419,  221,  466,  467,  468,  419,   85,  361, 
          502,  469,  540,   65,   65,   85,  540,  540,  246,   65, 
          246,  246,  600,  362,  405,  363,  540,  408,  409,  291, 
          789,  367,  806,  587,   92,  629,  615,  368,  629,  572, 
          389,   92,  376,   85,  281,  285,  505,  661,  761,  261, 
          540,  480,  400,   72,  569,  568,  390,  261,  569,  576, 
           85,  221,  221,  221,  221,   85,  221,  221,  326,  327, 
          394,  555,  392,  540,  344,  540,  401,   65,  116,   65, 
          509,  569,  597,  540,  540,  514,   92,  562,  718,  565, 
          270,   92,  393,  574,  577,  555,  613,  568,  221,  540, 
          784,  221,  460,  221,   85,  291,   64,  221,  221,   70, 
          625,  627,  555,  746,  284,   72,  510,  511,  512,  513, 
           90,  246,  221,   85,  221,  749,  555,  486,   68,  540, 
           92,  267,  628,  518,  740,   85,   65,   89,  635,  221, 
          480,  580,  377,   85,  627,  246,  358,  284,  661,   92, 
          661,  196,  829,  221,  116,  505,  876,  555,  866,  500, 
          277,   92,  246,  486,  874,  644,  360,  209,   64,   92, 
          402,   70,   62,  617,  617,   73,  246,  555,  221,   80, 
           85,  518,  927,  211,   66,   71,   89,   61,  518,  382, 
           68,  505,  480,  518,  540,  500,  486,  405,   65,   63, 
           65,   65,  360,  337,  221,  291,   92,   69,  460,   67, 
          330,  407,  500,   80,  518,  335,  338,  900,  384,  360, 
          333,  661,  883,   65,  505,   65,   65,  246,  500,   65, 
           80,   65,  502,  466,  467,  360,   65,   73,  687,  336, 
          469,  410,  331,   65,  414,  819,   66,   71,  334,  277, 
          486,  332,  692,  700,  116,  429,  705,  399,  698,  418, 
          456,  492,  370,  371,  419,  701,  703,  422,  661,   69, 
          661,   67,  440,   63,   63,  112,  112,  112,   93,   63, 
          326,  327,  750,  540,  700,  235,  730,  600,   65,   65, 
           65,   65,   65,   65,   65,   65,  722,  328,  661,  413, 
          444,  905,    6,  540,  540,  700,  540,  540,  196,  196, 
          445,  291,    6,  721,  304,  305,   63,  448,  745,  700, 
          290,  221,   85,  540,  394,  209,   65,  270,  583,   65, 
          259,   65,   65,   85,  270,   65,   65,   97,   97,  519, 
           85,  211,  873,   97,  712,  446,  700,  460,   92,  758, 
           65,   65,   65,  527,  540,  429,  451,  719,  250,   92, 
          116,    6,  328,   65,  221,  290,   92,   65,  466,  467, 
          471,   65,  540,  394,  314,  469,  713,  459,  540,  429, 
           97,   65,   63,  356,  458,  291,  399,  599,  602,  465, 
          357,  475,   85,  343,   89,  479,  429,  345,  346,  805, 
          702,  704,   78,  464,  507,  760,   65,  384,   65,  573, 
          429,  438,  259,   85,   85,  792,  794,  600,   92,  744, 
          604,  797,  314,   85,   85,   85,  380,  540,   85,  221, 
          221,  825,   65,  381,  116,  221,  614,  632,  638,   92, 
           92,  645,  540,   92,  656,  276,   97,  871,   80,   92, 
          291,   92,  657,  666,   92,  384,  667,  668,   85,  466, 
          467,  429,  384,  816,  670,  540,  469,   85,  676,  474, 
          221,  678,   80,  393,  393,   85,  689,  690,  809,  393, 
           85,   85,   85,  247,  253,  707,  695,  254,  384,  818, 
          710,  540,   92,   92,  397,  671,  865,  456,   87,  116, 
          696,  398,  684,  684,  456,  270,   92,   92,   92,  617, 
           80,  276,  116,  716,  540,   86,  432,  723,  733,  456, 
           89,   89,  118,  118,  519,  821,   89,  863,  382,   85, 
          727,  734,  237,  449,  735,  748,  411,  738,  762,   63, 
          684,  221,  790,  412,  694,  264,   63,  528,   85,   65, 
           65,  801,  810,  802,  812,   92,   91,  694,  694,   85, 
          290,   65,  271,   89,    6,    6,    6,  292,   65,  822, 
            6,    6,  823,    6,   92,  540,  540,  540,  830,  824, 
          694,  394,  540,  833,  555,   92,  837,  839,  840,  890, 
          841,   63,   65,  882,  842,  725,   63,  844,  729,  846, 
          602,  700,  849,   97,  850,   91,  853,   85,  602,  855, 
           97,  221,  292,   85,   82,  527,  527,  527,  858,   85, 
           65,  527,  527,  442,  527,  859,  857,  862,  868,   89, 
          443,  555,  540,   92,  246,   63,  290,  522,  116,   92, 
          462,   65,   65,    6,  877,   92,   87,  463,  878,  880, 
          892,   65,  394,   65,   63,   97,   65,   65,   65,  898, 
           97,  518,  671,   65,    6,  549,   63,  658,  441,  483, 
          484,  485,  486,  899,   63,  276,  910,  912,  671,  631, 
           87,  916,  919,  684,  869,  633,  634,  921,  923,  549, 
          926,  870,  227,   85,  527,   65,  540,   87,   65,   97, 
           92,  540,  642,  540,  929,  643,  549,   88,   65,   65, 
           65,   63,  940,  519,  527,  527,  670,  540,   97,  540, 
          549,   93,    8,  424,  540,  427,  739,  264,  540,  529, 
           97,   88,    8,   95,  528,  529,  290,  533,   97,  533, 
          535,  226,  270,  529,  522,  466,  467,  473,  529,  270, 
           94,  549,  469,  540,  519,   85,  456,   65,  317,  522, 
          540,  519,  119,  456,  276,  380,  928,  198,  519,   65, 
           93,  549,  917,  519,   40,   97,   65,  774,  671,  867, 
           88,    8,  264,  318,   40,  894,   89,   65,  906,  264, 
          239,  522,  759,   89,  519,  603,  884,  320,    0,  271, 
            0,    0,  270,  611,    0,    0,  271,  292,    0,  528, 
          528,  528,  456,   91,    0,  528,  528,    0,  528,    0, 
          466,  467,  476,  602,    0,  708,  522,  469,    0,    0, 
          677,  679,    0,   40,    0,   65,    0,    0,   89,   65, 
          637,   65,  290,   89,    0,  717,    0,   65,   95,   90, 
          518,    0,    0,   63,    0,  658,  691,  483,  484,  485, 
          486,    0,  697,    0,   63,    0,    0,    0,  429,  691, 
          691,   63,  753,  754,  522,  755,    0,  423,  423,  423, 
            0,  522,   89,  292,  423,    0,  518,    0,  528,   32, 
            0,  747,  691,    0,    0,  697,   81,   95,  518,   32, 
            0,   89,    0,    0,  602,  518,    0,  522,    0,  528, 
          518,   94,    0,   89,    0,   87,  290,   97,    0,  763, 
            0,   89,    0,   63,    0,  219,  219,  219,   97,  264, 
            0,  518,    0,  250,    0,   97,    7,    0,    0,   59, 
           60,    0,    0,  384,   63,   63,    7,    0,   32,  394, 
          413,  413,  413,    0,   63,    0,   63,  413,   89,   63, 
           94,    0,  279,  779,  264,  483,  484,  485,  486,    0, 
            0,  264,    0,  811,    0,    0,    0,   87,   93,    0, 
          522,  290,    0,  292,    8,    8,    8,   97,   88,    0, 
            8,    8,  271,    8,  815,    7,  487,    0,   63,    0, 
          726,    0,    0,    0,  489,  490,  491,  492,   97,   97, 
          172,   63,   63,   63,  831,    0,    0,    0,   97,  836, 
           97,    0,  226,   97,    0,  372,    0,    0,  522,    0, 
            0,    0,  226,    0,    0,  522,   40,   40,   40,  270, 
          518,   40,   40,   40,    0,   40,  270,   84,    0,  456, 
            0,  519,  752,    0,    0,   40,  456,    0,  522,  172, 
           63,  522,   97,    8,   40,   40,  226,   40,   40,   40, 
           40,   40,    0,  771,  772,   97,   97,   97,    0,   63, 
          226,  226,    0,  787,    8,  788,    0,    0,  791,  292, 
           63,    0,    0,    0,  519,  838,    0,    0,    0,  270, 
           89,    0,    0,  843,  845,   95,  847,    0,  848,    0, 
          851,   89,  854,  856,  270,   40,    0,    0,   89,    0, 
          112,    0,    0,    0,   97,    0,    0,  820,    0,  245, 
          245,   89,  384,  245,    0,    0,   40,   42,   63,    0, 
          826,  827,  828,   97,   63,    0,  270,   42,  219,  219, 
           63,   32,   32,   32,   97,  269,  271,   32,   32,    0, 
           32,  245,  245,  292,  294,  296,  264,    0,   94,    0, 
           89,  757,    0,  264,    0,    0,    0,  431,  549,  433, 
          384,    0,   32,   32,   32,   32,   32,  384,    0,  860, 
            0,   89,   89,    0,    0,    0,   42,    0,    7,    7, 
            7,   89,   97,   89,    7,    7,   89,    7,   97,    0, 
            0,    0,    0,  384,   97,  911,  913,  914,  915,  872, 
           82,  918,    0,  920,  922,  924,  925,    0,  292,  271, 
           32,  321,  322,  323,  324,  325,  271,  219,  219,  219, 
          219,  817,  515,  516,    0,   89,    0,  773,    0,  776, 
            0,   32,  780,    0,   82,    0,    0,    0,   89,   89, 
           89,  938,    0,    0,  939,  941,  942,  943,    0,    0, 
            0,   82,    0,  907,  945,    0,    0,    7,    0,  908, 
            0,    0,   92,  519,  226,  226,  226,    0,    0,  226, 
          226,  226,  658,  226,  483,  484,  485,  486,    7,    0, 
          590,  518,    0,  226,  226,    0,  172,   89,  172,  172, 
          172,  172,  226,  226,    0,  226,  226,  226,  226,  226, 
            0,    0,    0,  540,    0,  659,   89,  226,  450,    0, 
            0,  519,    0,  540,    0,  450,    0,   89,  519,  172, 
          172,    0,    0,  519,    0,    0,    0,  172,  172,  172, 
          172,    0,    0,    0,  636,  245,  245,  245,  296,    0, 
          226,    0,    0,  226,  519,    0,  226,  118,  226,  245, 
            0,  245,  245,  767,    0,  483,  484,  485,  486,    0, 
          439,    0,  540,  270,  226,   89,    0,   84,    0,    0, 
          270,   89,    0,    0,    0,  519,  226,   89,    0,   42, 
           42,   42,    0,    0,   42,   42,   42,    0,   42,    0, 
            0,    0,    0,  270,    0,  886,    0,    0,   42,    0, 
            0,   84,    0,    0,  893,    0,  895,   42,   42,    0, 
           42,   42,   42,   42,   42,    0,    0,    0,   84,    0, 
            0,    0,  517,  518,  519,  520,  521,  522,  523,  524, 
          525,  526,  527,  528,  529,  530,  531,  532,  533,  534, 
          535,  536,  537,  538,  539,  540,  541,  542,  519,    0, 
            0,    0,  245,    0,    0,  563,    0,  566,   42,    0, 
            0,  245,  578,   83,    0,    0,    0,  328,   83,   82, 
          518,    0,  935,  765,    0,  194,  245,  219,    0,   42, 
            0,    0,    0,  778,  245,  194,  782,    0,    0,    0, 
            0,    0,    0,  245,  563,  610,  578,   83,  343,  245, 
            0,    0,  345,  346,  347,  348,    0,  245,    0,    0, 
            0,    0,  245,  245,   83,  522,  245,    0,  518,  194, 
          219,    0,    0,    0,    0,  518,    0,    0,    0,    0, 
          518,   82,    0,  194,  194,    0,    0,    0,  639,  640, 
          641,    0,    0,    0,  522,    0,  245,    0,    0,  245, 
            0,  518,    0,    0,    0,    0,    0,    0,  245,    0, 
          244,  244,  244,    0,  244,  540,  540,  540,  244,  244, 
          540,  540,  540,  244,  540,  244,  244,  244,  244,  244, 
          244,  244,    0,    0,  540,    0,  244,  244,  244,  244, 
          244,  244,  244,  540,  540,  244,  540,  540,  540,  540, 
          540,    0,  244,    0,    0,  244,  244,  244,    0,  244, 
          244,  244,  244,  244,  244,  244,  244,  244,  244,  244, 
          658,    0,  483,  484,  485,  486,  219,    0,    0,    0, 
            0,  540,    0,    0,    0,    0,   84,  519,  540,  244, 
            0,    0,  244,    0,  540,  244,  244,  885,  244,  887, 
          244,  888,  244,  659,  244,  891,    0,    0,  245,    0, 
          896,  660,  244,    0,  444,  540,    0,  244,  244,  244, 
          244,  244,  244,    0,  444,    0,  244,    0,  244,  244, 
            0,  244,  244,    0,    0,  519,  658,    0,  483,  484, 
          485,  486,  519,    0,    0,    0,    0,  519,   84,    0, 
            0,    0,    0,   91,  522,    0,    0,  658,  444,  483, 
          484,  485,  486,    0,    0,    0,    0,  931,  519,  487, 
          245,    0,  444,  444,  934,  444,  936,  444,  937,  491, 
          492,    0,   83,  522,    0,    0,    0,  194,  194,  194, 
          659,    0,  194,  194,  194,  944,  194,    0,  834,    0, 
            0,  245,  522,    0,    0,  444,  194,  194,    0,  522, 
            0,    0,    0,    0,  518,  194,  194,    0,  194,  194, 
          194,  194,  194,    0,    0,    0,    0,    0,    0,    0, 
          194,  522,    0,  793,  795,  522,    0,  447,  522,  798, 
          799,    0,    0,  518,   83,    0,    0,  447,    0,    0, 
          803,  245,    0,    0,    0,  807,    0,    0,    0,    0, 
            0,    0,    0,  194,  522,    0,  194,    0,    0,  194, 
            0,  194,    0,    0,    0,    0,    0,  793,  795,  798, 
            0,  447,    0,  245,    0,    0,    0,  194,    0,    0, 
            0,    0,    0,    0,    0,  447,  447,    0,  447,  194, 
          447,    0,    0,    0,    0,  544,  545,    0,    0,  546, 
            0,    0,  262,  165,  166,    0,  167,  168,  169,  170, 
          171,  172,  173,    0,    0,  174,  175,    0,  447,    0, 
          176,  177,  178,  179,  861,    0,    0,    0,    0,  258, 
            0,    0,    0,    0,    0,  864,  181,  182,  245,  183, 
          184,  185,  186,  187,  188,  189,  190,  191,  192,  193, 
            0,    0,  194,    0,    0,  353,    0,  864,    0,    0, 
            0,  515,  515,  515,    0,  515,  444,  444,  444,  515, 
          515,  444,  444,  444,  515,  444,  515,  515,  515,  515, 
          515,  515,  515,  444,  515,  444,  444,  515,  515,  515, 
          515,  515,  515,  515,  444,  444,  515,  444,  444,  444, 
          444,  444,    0,  515,    0,  245,  515,  515,  515,  444, 
          515,  515,  515,  515,  515,  515,  515,  515,  515,  515, 
          515,  444,  444,  444,  444,  444,  444,  444,  444,  444, 
          444,  444,  444,  444,  444,    0,    0,  444,  444,  444, 
          515,  444,  444,  515,  515,  444,  515,  515,  444,  515, 
          444,  515,  444,  515,  444,  515,  444,  444,  444,  444, 
          444,  444,  444,  515,  444,  515,  444,    0,  515,  515, 
          515,  515,  515,  515,    0,    0,  165,  515,  444,  515, 
          515,    0,  515,  515,  516,  516,  516,    0,  516,  447, 
          447,  447,  516,  516,  447,  447,  447,  516,  447,  516, 
          516,  516,  516,  516,  516,  516,  447,  516,  447,  447, 
          516,  516,  516,  516,  516,  516,  516,  447,  447,  516, 
          447,  447,  447,  447,  447,  165,  516,    0,    0,  516, 
          516,  516,  447,  516,  516,  516,  516,  516,  516,  516, 
          516,  516,  516,  516,  447,  447,  447,  447,  447,  447, 
          447,  447,  447,  447,  447,  447,  447,  447,    0,    0, 
          447,  447,  447,  516,  447,  447,  516,  516,  447,  516, 
          516,  447,  516,  447,  516,  447,  516,  447,  516,  447, 
          447,  447,  447,  447,  447,  447,  516,  447,  516,  447, 
            0,  516,  516,  516,  516,  516,  516,  518,    0,    0, 
          516,  447,  516,  516,    0,  516,  516,  518,    0,  328, 
          329,  330,  331,  332,  333,  334,  335,  336,  337,  338, 
            0,  339,  340,    0,    0,  341,  342,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          343,  518,  344,    0,  345,  346,  347,  348,  349,  350, 
          351,    0,  352,  550,  551,  518,  518,  552,   90,    0, 
          518,  165,  166,    0,  167,  168,  169,  170,  171,  172, 
          173,    0,    0,  174,  175,    0,    0,    0,  176,  177, 
          178,  179,    0,    0,    0,    0,    0,  258,  518,    0, 
            0,    0,    0,    0,  181,  182,    0,  183,  184,  185, 
          186,  187,  188,  189,  190,  191,  192,  193,    0,  482, 
          194,  483,  484,  485,  486,    0,    0,    0,    0,    0, 
          519,    0,    0,    0,  482,    0,  483,  484,  485,  486, 
          519,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  487,  488,    0,    0,    0,    0,    0,    0, 
          489,  490,  491,  492,    0,    0,    0,  487,  591,    0, 
            0,    0,    0,    0,  519,  489,  490,  491,  492,    0, 
            0,    0,  165,    0,  165,  165,  165,  165,  519,  519, 
            0,   92,    0,  519,    0,    0,    0,  482,    0,  483, 
          484,  485,  486,  779,  449,  483,  484,  485,  486,    0, 
            0,  449,    0,    0,    0,  165,  165,  328,    0,    0, 
            0,  519,    0,  165,  165,  165,  165,    0,    0,    0, 
          487,    0,    0,  341,  342,    0,  487,  175,  489,  490, 
          491,  492,    0,    0,  489,  490,  491,  492,  343,    0, 
          344,    0,  345,  346,  347,  348,    0,    0,  351,    0, 
          352,    0,    0,    0,  518,  518,  518,    0,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  175,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,    0,  518,    0,    0,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,    0,    0, 
          518,  518,  518,  518,    0,  518,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
            0,  518,  518,  518,  518,  518,  518,    0,    0,  160, 
          518,  518,  518,  518,    0,  518,  518,  519,  519,  519, 
            0,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,    0, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,  519,  519,  519,  519,  160,  519, 
            0,    0,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,    0,    0,  519,  519,  519,  519,    0,  519,  519, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,    0,  519,  519,  519,  519,  519,  519, 
          522,    0,    0,  519,  519,  519,  519,    0,  519,  519, 
          522,    0,  328,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  341,  342, 
            0,    0,    0,  175,    0,  175,  175,  175,  175,    0, 
            0,    0,    0,  343,  522,  344,    0,  345,  346,  347, 
          348,    0,  328,    0,    0,  451,    0,    0,  522,  522, 
            0,   91,  451,  522,    0,    0,  175,  175,  341,  342, 
            0,    0,    0,    0,  175,  175,  175,  175,    0,    0, 
            0,    0,    0,  343,    0,    0,    0,  345,  346,  347, 
          348,  522,    0,  558,  545,    0,    0,  559,    0,    0, 
            0,  165,  166,    0,  167,  168,  169,  170,  171,  172, 
          173,    0,    0,  174,  175,    0,    0,    0,  176,  177, 
          178,  179,    0,  265,    0,    0,    0,  258,    0,    0, 
            0,    0,    0,  265,  181,  182,    0,  183,  184,  185, 
          186,  187,  188,  189,  190,  191,  192,  193,    0,    0, 
          194,    0,  328,  329,  330,  331,  332,  333,  334,  335, 
          336,  337,  338,    0,    0,    0,    0,  265,  341,  342, 
            0,    0,    0,    0,    0,  160,    0,  160,  160,  160, 
          160,  265,  265,  343,    0,  344,  265,  345,  346,  347, 
          348,  349,  350,  351,  328,  352,    0,  452,    0,  333, 
          334,    0,    0,    0,  452,    0,    0,    0,  160,  160, 
          341,  342,    0,    0,  265,    0,  160,  160,  160,  160, 
            0,    0,    0,    0,    0,  343,    0,  344,    0,  345, 
          346,  347,  348,  349,  350,  351,    0,  352,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  518,  518,  518, 
            0,  518,  522,  522,  522,  518,  518,  522,  522,  522, 
          518,  522,  518,  518,  518,  518,  518,  518,  518,    0, 
          522,  522,  522,  518,  518,  518,  518,  518,  518,  518, 
          522,  522,  518,  522,  522,  522,  522,  522,  262,  518, 
            0,    0,  518,  518,  518,  522,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  522,  522,  522, 
          522,  522,  522,  522,  522,  522,  522,  522,  522,  522, 
          522,    0,    0,  522,  522,  522,  518,    0,  522,  518, 
          518,  522,  518,  518,  522,  518,  522,  518,  522,  518, 
          522,  518,  522,  522,  522,  522,  522,  522,  522,  518, 
          522,  522,  522,    0,  518,  518,  518,  518,  518,  518, 
            0,    0,  142,  518,  522,  518,  518,    0,  518,  518, 
          517,  517,  517,    0,  517,  265,  265,  265,  517,  517, 
          265,  265,  265,  517,  265,  517,  517,  517,  517,  517, 
          517,  517,    0,  517,  265,  265,  517,  517,  517,  517, 
          517,  517,  517,  265,  265,  517,  265,  265,  265,  265, 
          265,  142,  517,    0,    0,  517,  517,  517,  265,  517, 
          517,  517,  517,  517,  517,  517,  517,  517,  517,  517, 
          265,  265,  265,  265,  265,  265,  265,  265,  265,  265, 
          265,  265,  265,  265,    0,    0,  265,  265,  265,  517, 
            0,  265,  517,  517,  265,  517,  517,  265,  517,  265, 
          517,  265,  517,  265,  517,  265,  265,  265,  265,  265, 
          265,  265,  517,  265,  517,  265,    0,  517,  517,  517, 
          517,  517,  517,  523,    0,    0,  517,  265,  517,  517, 
            0,  517,  517,  523,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  523,    0,    0, 
            0,    0,    0,    0,    0,    4,    5,    6,    0,    8, 
            0,  523,  523,    9,   10,    0,  523,    0,   11,    0, 
           12,   13,   14,   99,  100,   17,   18,    0,    0,    0, 
            0,  101,   20,   21,   22,   23,   24,   25,    0,    0, 
          104,    0,    0,    0,  523,    0,    0,   28,    0,    0, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
          241,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  524,    0,    0,    0, 
            0,    0,    0,    0,  217,    0,  524,  111,    0,    0, 
           46,   47,    0,   48,    0,  242,    0,  243,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  244,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
          524,   58,    0,   59,   60,    0,   61,   62,  142,    0, 
          142,  142,  142,  142,  524,  524,    0,    0,    0,  524, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          454,    0,    0,    0,    0,    0,    0,  454,    0,    0, 
            0,  142,  142,    0,    0,    0,    0,  524,    0,  142, 
          142,  142,  142,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  143,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          520,  520,  520,    0,  520,  523,  523,  523,  520,  520, 
          523,  523,  523,  520,  523,  520,  520,  520,  520,  520, 
          520,  520,  143,  523,  523,  523,  520,  520,  520,  520, 
          520,  520,  520,  523,  523,  520,  523,  523,  523,  523, 
          523,    0,  520,    0,    0,  520,  520,  520,  523,  520, 
          520,  520,  520,  520,  520,  520,  520,  520,  520,  520, 
          523,  523,  523,  523,  523,  523,  523,  523,  523,  523, 
          523,  523,  523,  523,    0,    0,  523,  523,  523,  520, 
            0,  523,  520,  520,  523,  520,  520,  523,  520,  523, 
          520,  523,  520,  523,  520,  523,  523,  523,  523,  523, 
          523,  523,  520,  523,  523,  523,    0,  520,  520,  520, 
          520,  520,  520,    0,    0,  144,  520,  523,  520,  520, 
            0,  520,  520,  521,  521,  521,    0,  521,  524,  524, 
          524,  521,  521,  524,  524,  524,  521,  524,  521,  521, 
          521,  521,  521,  521,  521,    0,  524,  524,  524,  521, 
          521,  521,  521,  521,  521,  521,  524,  524,  521,  524, 
          524,  524,  524,  524,  144,  521,    0,    0,  521,  521, 
          521,  524,  521,  521,  521,  521,  521,  521,  521,  521, 
          521,  521,  521,  524,  524,  524,  524,  524,  524,  524, 
          524,  524,  524,  524,  524,  524,  524,    0,    0,  524, 
          524,  524,  521,    0,  524,  521,  521,  524,  521,  521, 
          524,  521,  524,  521,  524,  521,  524,  521,  524,  524, 
          524,  524,  524,  524,  524,  521,  524,  524,  524,    0, 
          521,  521,  521,  521,  521,  521,  270,    0,    0,  521, 
          524,  521,  521,    0,  521,  521,  270,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  143, 
            0,  143,  143,  143,  143,    0,    0,    0,    0,    0, 
          270,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  453,    0,    0,  270,  270,    0,   93,  453,  270, 
            0,    0,  143,  143,    0,    0,    0,    0,    0,    0, 
          143,  143,  143,  143,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  270,    0,  584, 
          551,    0,    0,  585,    0,    0,    0,  165,  166,    0, 
          167,  168,  169,  170,  171,  172,  173,    0,    0,  174, 
          175,    0,    0,    0,  176,  177,  178,  179,    0,  383, 
            0,    0,    0,  258,    0,    0,    0,    0,    0,  383, 
          181,  182,    0,  183,  184,  185,  186,  187,  188,  189, 
          190,  191,  192,  193,    0,    0,  194,    0,  328,  329, 
          330,  331,  332,  333,  334,  335,    0,  337,  338,    0, 
            0,    0,    0,  383,  341,  342,    0,    0,    0,    0, 
            0,  144,    0,  144,  144,  144,  144,    0,  383,  343, 
            0,  344,  383,  345,  346,  347,  348,  349,  350,  351, 
            0,  352,    0,  455,    0,    0,    0,    0,    0,    0, 
          455,    0,    0,    0,  144,  144,    0,    0,    0,    0, 
          383,    0,  144,  144,  144,  144,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  519,  519,  519,    0,  519,  270,  270, 
          270,  519,  519,  270,  270,  270,  519,  270,  519,  519, 
          519,  519,  519,  519,  519,    0,    0,  270,  270,  519, 
          519,  519,  519,  519,  519,  519,  270,  270,  519,  270, 
          270,  270,  270,  270,  262,  519,    0,    0,  519,  519, 
          519,  270,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  270,  270,  270,  270,  270,  270,  270, 
          270,  270,  270,  270,  270,  270,  270,    0,    0,  270, 
          270,  270,  519,    0,  270,  519,  519,  270,  519,  519, 
          270,  519,  270,  519,  270,  519,  270,  519,  270,  270, 
          270,  270,  270,  270,  270,  519,  270,    0,  270,    0, 
          519,  519,  519,  519,  519,  519,    0,    0,  101,  519, 
          270,  519,  519,    0,  519,  519,  244,  244,  244,    0, 
          244,  383,  383,  383,  244,  244,  383,  383,  383,  244, 
          383,  244,  244,  244,  244,  244,  244,  244,    0,  383, 
          383,  383,  244,  244,  244,  244,  244,  244,  244,  383, 
          383,  244,  383,  383,  383,  383,  383,  101,  244,    0, 
            0,  244,  244,  244,    0,  244,  244,  244,  244,  244, 
          244,  244,  244,  244,  244,  244,  383,  383,  383,  383, 
          383,  383,  383,  383,  383,  383,  383,  383,  383,  383, 
            0,    0,  383,  383,  383,  244,    0,  383,  244,    0, 
          383,  244,  244,  383,  244,  383,  244,  383,  244,  383, 
          244,  383,  383,  383,  383,  383,  383,  383,  244,  383, 
          383,  383,    0,  244,  244,  244,  244,  244,  244,  540, 
            0,    0,  244,    0,  244,  244,    0,  244,  244,  540, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  540,    0,    0,    0,    0,    0,    0, 
            0,    4,    5,    6,    0,    8,    0,    0,  540,    9, 
           10,    0,  540,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,   26,    0,    0,    0, 
          540,    0,    0,   28,    0,    0,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  277,    0,    0,    0,    0,    0,    0,    0, 
          217,    0,  277,  111,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,   51,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,  277,   58,    0,   59, 
           60,    0,   61,   62,  101,    0,  101,  101,  101,  101, 
            0,  277,    0,    0,    0,  277,    0,    0,  328,  329, 
          330,  331,  332,  333,  334,    0,  444,  337,  338,    0, 
            0,    0,    0,  444,  341,  342,    0,  101,  101,    0, 
            0,    0,    0,  277,    0,  101,  101,  101,  101,  343, 
            0,  344,    0,  345,  346,  347,  348,  349,  350,  351, 
            0,  352,    0,    0,    0,    0,    0,    0,    0,    0, 
          541,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          541,    0,    0,    0,    0,    0,  244,  244,  244,    0, 
          244,  540,  540,  540,  244,  244,  540,  540,  540,  244, 
          540,  244,  244,  244,  244,  244,  244,  244,    0,  540, 
          540,  540,  244,  244,  244,  244,  244,  244,  244,  540, 
          540,  244,  540,  540, 
      };
   }

   private static final short[] yyTable2() {
      return new short[] {

          540,  540,  540,    0,  244,  541,  353,  244,  244,  244, 
            0,  244,  244,  244,  244,  244,  244,  244,  244,  244, 
          244,  244,  540,  540,  540,  540,  540,  540,  540,  540, 
          540,  540,  540,  540,  540,  540,    0,    0,  540,  540, 
          540,  244,    0,  540,  244,    0,  540,  244,  244,  540, 
          244,  540,  244,  540,  244,  540,  244,  540,  540,  540, 
          540,  540,  540,  540,  244,  540,  540,  540,    0,  244, 
          244,  244,  244,  244,  244,  353,    0,    0,  244,    0, 
          244,  244,    0,  244,  244,  244,  244,  244,    0,  244, 
          277,  277,  277,  244,  244,  277,  277,  277,  244,  277, 
          244,  244,  244,  244,  244,  244,  244,    0,    0,  277, 
          277,  244,  244,  244,  244,  244,  244,  244,  277,  277, 
          244,  277,  277,  277,  277,  277,    0,  244,    0,    0, 
          244,  244,  244,    0,  244,  244,  244,  244,  244,  244, 
          244,  244,  244,  244,  244,  277,  277,  277,  277,  277, 
          277,  277,  277,  277,  277,  277,  277,  277,  277,    0, 
            0,  277,  277,  277,  244,    0,  277,  244,    0,  277, 
          244,  244,  277,  244,  277,  244,  277,  244,  277,  244, 
          277,  277,  277,  277,  277,  277,  277,  244,  277,  518, 
          277,    0,  244,  244,  244,  244,  244,  244,    0,  518, 
            0,  244,    0,  244,  244,    0,  244,  244,  541,  541, 
          541,    0,    0,  541,  541,  541,    0,  541,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  541,  541,    0, 
            0,    0,    0,   82,    0,    0,  541,  541,    0,  541, 
          541,  541,  541,  541,    0,    0,    0,    0,  518,    0, 
           90,    0,  518,    0,    0,    0,    0,    0,    0,    0, 
          328,  329,  330,  331,  332,  333,  334,  335,  336,  337, 
          338,    0,  339,  340,    0,    0,  341,  342,    0,    0, 
          518,    0,    0,    0,    0,    0,    0,  541,    0,    0, 
          541,  343,  541,  344,    0,  345,  346,  347,  348,  349, 
          350,  351,    0,  352,    0,    0,    0,    0,  541,  706, 
            0,    0,  519,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  519,    0,    0,   86,    0,    0,    0,  328, 
          329,  330,  331,  332,  333,  334,  335,  336,  337,  338, 
            0,  339,  340,    0,    0,  341,  342,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   84,    0,    0,   86, 
          343,    0,  344,    0,  345,  346,  347,  348,  349,  350, 
          351,  519,  352,   92,    0,  519,   86,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  519,    0,    0,  271,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  102, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   41,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   41,  518,  518,  518,    0, 
          518,  518,  518,  518,  518,  518,    0,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  102,  518, 
            0,    0,  518,  518,  518,  518,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,    0,  518,    0, 
            0,  518,  518,  518,   41,  518,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
            0,    0,  518,  518,  518,  518,    0,    0,  518,  518, 
          518,  518,  518,    0,  518,    0,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
          518,  518,    0,  518,  518,  518,  518,  518,  518,    0, 
            0,    0,  518,    0,  518,  518,  353,  518,  518,  519, 
          519,  519,    0,  519,  519,  519,  519,  519,  519,    0, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,    0,  519,    0,   86,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
            0,  519,    0,    0,  519,  519,  519,    0,  519,  519, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  271,    0,  519,  519,  519,  519,    0, 
          271,  519,  519,  519,  519,  519,   86,  519,    0,  519, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,  519,    0,  519,  519,  519,  519, 
          519,  519,  522,    0,    0,  519,    0,  519,  519,    0, 
          519,  519,  522,    0,    0,    0,    0,   41,   41,   41, 
            0,    0,   41,   41,   41,    0,   41,    0,    0,    0, 
            0,    0,    0,    0,    0,  102,   41,  102,  102,  102, 
          102,    0,    0,    0,    0,    0,   83,    0,   41,   41, 
           41,   41,   41,    0,    0,    0,    0,  447,    0,    0, 
            0,  522,    0,   91,  447,  522,    0,    0,  102,  102, 
            0,    0,    0,    0,    0,    0,  102,  102,  102,  102, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  522,    0,    0,   41,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   41,    0,    0, 
          711,    0,    0,    0,    0,  270,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  270,    0,    0,    0,    0, 
          328,  329,  330,  331,  332,  333,  334,  335,  336,  337, 
          338,    0,  339,  340,    0,    0,  341,  342,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   85, 
            0,  343,    0,  344,    0,  345,  346,  347,  348,  349, 
          350,  351,    0,  352,  270,    0,   93,    0,  270,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  270,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  248,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  248,    0,    0,    0,    0,  518, 
          518,  518,    0,  518,  522,  522,  522,  518,  518,    0, 
          522,  522,  518,  522,  518,  518,  518,  518,  518,  518, 
          518,    0,  522,    0,    0,  518,  518,  518,  518,  518, 
          518,  518,  522,  522,  518,  522,  522,  522,  522,  522, 
            0,  518,    0,  248,  518,  518,  518,    0,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  522, 
          522,  522,  522,  522,  522,  522,  522,  522,  522,  522, 
          522,  522,  522,    0,    0,  522,  522,  522,  518,    0, 
            0,  518,  518,  522,  518,  518,    0,  518,    0,  518, 
          522,  518,  522,  518,  522,  522,  522,  522,  522,  522, 
          522,  518,  522,  522,  522,    0,  518,  518,  518,  518, 
          518,  518,    0,    0,    0,  518,    0,  518,  518,    0, 
          518,  518,  519,  519,  519,    0,  519,  270,  270,  270, 
          519,  519,    0,  270,  270,  519,  270,  519,  519,  519, 
          519,  519,  519,  519,    0,    0,    0,    0,  519,  519, 
          519,  519,  519,  519,  519,  270,  270,  519,  270,  270, 
          270,  270,  270,    0,  519,    0,    0,  519,  519,  519, 
            0,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  270,  270,  270,  270,  270,  270,  270,  270, 
          270,  270,  270,  270,  270,  270,    0,    0,  270,  270, 
          270,  519,    0,    0,  519,  519,  270,  519,  519,    0, 
          519,   81,  519,  270,  519,  270,  519,  270,  270,  270, 
          270,  270,  270,  270,  519,  270,  384,  270,    0,  519, 
          519,  519,  519,  519,  519,    0,  384,    0,  519,    0, 
          519,  519,    0,  519,  519,   81,  248,  248,  248,    0, 
            0,  248,  248,  248,    0,  248,    0,    0,    0,    0, 
            0,    0,   81,    0,    0,  248,  248,    0,    0,    0, 
          384,    0,    0,    0,  248,  248,    0,  248,  248,  248, 
          248,  248,    0,    0,  384,  384,    0,   89,    0,  384, 
            0,    0,  384,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  384,    0,    0, 
            0,    0,    0,    0,    0,  248,    0,  383,  248,    0, 
          248,    0,    0,    0,    0,    0,    0,  383,    0,    0, 
            0,    0,    0,    0,    0,    0,  248,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   99,  100,   17,   18,    0, 
            0,  383,    0,  101,  102,  103,   22,   23,   24,   25, 
            0,    0,  104,    0,    0,  383,  383,    0,    0,  105, 
          383,    0,   31,   32,   33,    0,  106,   35,   36,   37, 
          107,   39,    0,   40,    0,    0,  108,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  383,    0, 
            0,    0,    0,  109,    0,    0,  110,    0,    0,  111, 
            0,    0,   46,   47,    0,   48,    0,    0,    0,    0, 
            0,  456,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  456,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           81,  384,    0,    0,    0,  456,    0,    0,  384,  384, 
          384,    0,    0,  384,  384,  384,    0,  384,    0,  456, 
          456,    0,   88,    0,  456,    0,  384,  384,  384,    0, 
            0,    0,    0,    0,    0,    0,  384,  384,    0,  384, 
          384,  384,  384,  384,    0,    0,    0,    0,    0,  384, 
            0,  384,  456,    0,    0,    0,  384,    0,    0,    0, 
            0,    0,   81,  384,  384,  384,  384,  384,  384,  384, 
          384,  384,  384,  384,  384,  384,  384,    0,    0,  384, 
          384,  384,  384,    0,  384,    0,    0,  384,    0,    0, 
          384,    0,  384,    0,  384,  540,  384,    0,  384,  384, 
          384,  384,  384,  384,  384,  540,  384,  384,  384,  383, 
          383,  383,    0,    0,  383,  383,  383,    0,  383,    0, 
          384,    0,    0,    0,    0,    0,    0,  383,  383,  383, 
            0,    0,    0,    0,    0,    0,    0,  383,  383,  540, 
          383,  383,  383,  383,  383,    0,    0,    0,    0,    0, 
            0,    0,  383,  540,  540,    0,    0,    0,  540,    0, 
            0,    0,    0,    0,  383,  383,  383,  383,  383,  383, 
          383,  383,  383,  383,  383,  383,  383,  383,    0,    0, 
          383,  383,  383,    0,    0,  383,  540,    0,  383,    0, 
            0,  383,    0,  383,    0,  383,    0,  383,    0,  383, 
          383,  383,  383,  383,  383,  383,    0,  383,  383,  383, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  383,    0,  456,  456,  456,    0,    0,  456,  456, 
          456,    0,  456,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  456,  456,    0,    0,    0,    0,    0,    0, 
            0,  456,  456,    0,  456,  456,  456,  456,  456,    0, 
            0,    0,    0,    0,    0,    0,  456,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  456,  456, 
          456,  456,  456,  456,  456,  456,  456,  456,  456,  456, 
          456,  456,    0,  264,  456,  456,  456,    0,  457,  456, 
            0,    0,  456,  264,    0,  456,    0,  456,    0,  456, 
            0,  456,    0,  456,  456,  456,  456,  456,  456,  456, 
            0,  456,    0,  456,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  456,    0,  264,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  264,  264,    0,   95,    0,  264,  540,  540,  540, 
            0,    0,  540,  540,  540,    0,  540,    0,    0,    0, 
            0,    0,    0,    0,    0,  540,  540,  540,    0,    0, 
            0,    0,    0,    0,  264,  540,  540,    0,  540,  540, 
          540,  540,  540,    0,    0,    0,    0,    0,    0,    0, 
          540,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  540,  540,  540,  540,  540,  540,  540,  540, 
          540,  540,  540,  540,  540,  540,    0,  271,  540,  540, 
          540,    0,    0,  540,    0,    0,  540,  271,    0,  540, 
            0,  540,    0,  540,    0,  540,    0,  540,  540,  540, 
          540,  540,  540,  540,    0,  540,  540,  540,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  540, 
            0,  271,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  605,  545,  271,  271,  606,   94,    0, 
          271,  165,  166,    0,  167,  168,  169,  170,  171,  172, 
          173,    0,    0,  174,  175,    0,    0,    0,  176,  177, 
          178,  179,    0,    0,    0,    0,    0,  258,  271,    0, 
            0,    0,    0,    0,  181,  182,    0,  183,  184,  185, 
          186,  187,  188,  189,  190,  191,  192,  193,    0,    0, 
          194,  404,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  404,    0,    0,    0,  264,  264,  264,    0,    0, 
          264,  264,  264,    0,  264,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  264,  264,    0,    0,    0,    0, 
            0,    0,    0,  264,  264,  404,  264,  264,  264,  264, 
          264,    0,    0,    0,    0,    0,    0,    0,  264,  404, 
          404,    0,    0,    0,  404,    0,    0,    0,    0,    0, 
          264,  264,  264,  264,  264,  264,  264,  264,  264,  264, 
          264,  264,  264,  264,    0,    0,  264,  264,  264,    0, 
            0,  264,  404,    0,  264,    0,    0,  264,    0,  264, 
            0,  264,  282,  264,    0,  264,  264,  264,  264,  264, 
          264,  264,  282,  264,    0,  264,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  264,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  282,    0,    0,  271, 
          271,  271,    0,    0,  271,  271,  271,    0,  271,    0, 
          282,  282,    0,    0,    0,  282,    0,    0,  271,  271, 
            0,    0,    0,    0,    0,    0,    0,  271,  271,    0, 
          271,  271,  271,  271,  271,    0,    0,    0,    0,    0, 
            0,    0,  271,  282,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  271,  271,  271,  271,  271,  271, 
          271,  271,  271,  271,  271,  271,  271,  271,    0,    0, 
          271,  271,  271,    0,    0,  271,    0,    0,  271,    0, 
            0,  271,    0,  271,    0,  271,    0,  271,    0,  271, 
          271,  271,  271,  271,  271,  271,  228,  271,    0,  271, 
            0,    0,    0,    0,    0,    0,  228,    0,    0,    0, 
            0,  271,    0,  404,  404,  404,    0,    0,  404,  404, 
          404,    0,  404,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  404,  404,    0,    0,    0,    0,    0,    0, 
          228,  404,  404,    0,  404,  404,  404,  404,  404,    0, 
            0,    0,    0,    0,  228,  228,  404,    0,    0,  228, 
            0,    0,    0,    0,    0,    0,    0,    0,  404,  404, 
          404,  404,  404,  404,  404,  404,  404,  404,  404,  404, 
          404,  404,    0,    0,  404,  404,  404,  314,    0,  404, 
            0,    0,  404,    0,    0,  404,    0,  404,    0,  404, 
          277,  404,    0,  404,  404,  404,  404,  404,  404,  404, 
          277,  404,    0,  404,  282,  282,  282,    0,    0,  282, 
          282,  282,    0,  282,    0,  404,    0,    0,    0,    0, 
            0,    0,    0,  282,  282,    0,    0,    0,    0,    0, 
            0,    0,  282,  282,  277,  282,  282,  282,  282,  282, 
            0,    0,    0,    0,    0,    0,    0,  282,  277,  277, 
            0,    0,    0,  277,    0,    0,    0,    0,    0,  282, 
          282,  282,  282,  282,  282,  282,  282,  282,  282,  282, 
          282,  282,  282,    0,    0,  282,  282,  282,    0,    0, 
          282,  277,    0,  282,    0,    0,  282,    0,  282,    0, 
          282,    0,  282,    0,  282,  282,  282,  282,  282,  282, 
          282,    0,  282,  442,  282,    0,    0,    0,    0,    0, 
            0,    0,    0,  442,    0,    0,  282,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  442,  228,  228, 
          228,    0,    0,  228,  228,  228,    0,  228,    0,    0, 
            0,  442,  442,    0,    0,    0,  442,  228,  228,    0, 
            0,    0,    0,    0,    0,    0,  228,  228,    0,  228, 
          228,  228,  228,  228,    0,    0,    0,    0,    0,    0, 
            0,  228,    0,    0,  442,    0,    0,    0,    0,    0, 
            0,    0,    0,  228,  228,  228,  228,  228,  228,  228, 
          228,  228,  228,  228,  314,  228,  228,    0,    0,  228, 
          228,  314,    0,    0,  228,    0,    0,  228,    0,    0, 
          228,    0,  228,    0,  228,  443,  228,    0,  228,  228, 
          228,  228,  228,  228,  228,  443,  228,    0,  228,    0, 
            0,    0,  277,  277,  277,    0,    0,  277,  277,  277, 
          228,  277,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  277,  277,    0,    0,    0,    0,    0,    0,  443, 
          277,  277,    0,  277,  277,  277,  277,  277,    0,    0, 
            0,    0,    0,  443,  443,  277,    0,    0,  443,    0, 
            0,    0,    0,    0,    0,    0,    0,  277,  277,  277, 
          277,  277,  277,  277,  277,  277,  277,  277,  277,  277, 
          277,    0,    0,  277,  277,  277,  443,    0,  277,    0, 
            0,  277,    0,    0,  277,    0,  277,    0,  277,    0, 
          277,    0,  277,  277,  277,  277,  277,  277,  277,    0, 
          277,  206,  277,    0,    0,    0,    0,    0,    0,    0, 
            0,  206,    0,    0,  277,  442,  442,  442,    0,    0, 
          442,  442,  442,    0,  442,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  442,  442,    0,    0,    0,    0, 
            0,    0,    0,  442,  442,  206,  442,  442,  442,  442, 
          442,    0,    0,    0,    0,    0,    0,    0,  442,  206, 
          206,    0,    0,    0,  206,    0,    0,    0,    0,    0, 
            0,  442,  442,  442,  442,  442,  442,  442,  442,  442, 
          442,  442,  442,  442,    0,    0,  442,  442,  442,    0, 
            0,  442,    0,    0,  442,    0,    0,  442,    0,  442, 
            0,  442,  202,  442,    0,  442,  442,  442,  442,  442, 
          442,  442,  202,  442,    0,  442,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  442,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  202,  443,  443,  443, 
            0,    0,  443,  443,  443,    0,  443,    0,    0,    0, 
          202,  202,    0,    0,    0,  202,  443,  443,    0,    0, 
            0,    0,    0,    0,    0,  443,  443,    0,  443,  443, 
          443,  443,  443,    0,    0,    0,    0,    0,    0,    0, 
          443,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  443,  443,  443,  443,  443,  443,  443, 
          443,  443,  443,  443,  443,  443,    0,  199,  443,  443, 
          443,    0,    0,  443,    0,    0,  443,  199,    0,  443, 
            0,  443,    0,  443,    0,  443,    0,  443,  443,  443, 
          443,  443,  443,  443,    0,  443,    0,  443,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  443, 
            0,  199,    0,  206,  206,  206,    0,    0,  206,  206, 
          206,    0,  206,    0,    0,  199,  199,    0,    0,    0, 
          199,    0,  206,  206,    0,    0,    0,    0,    0,    0, 
            0,  206,  206,    0,  206,  206,  206,  206,  206,    0, 
            0,    0,    0,    0,    0,    0,  206,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  206, 
          206,  206,  206,  206,  206,  206,  206,  206,  206,    0, 
          206,  206,    0,    0,  206,  206,    0,    0,    0,  206, 
            0,    0,  206,    0,    0,  206,    0,  206,    0,  206, 
          201,  206,    0,  206,  206,  206,  206,  206,  206,  206, 
          201,  206,    0,  206,  202,  202,  202,    0,    0,  202, 
          202,  202,    0,  202,    0,  206,    0,    0,    0,    0, 
            0,    0,    0,  202,  202,    0,    0,    0,    0,    0, 
            0,    0,  202,  202,  201,  202,  202,  202,  202,  202, 
            0,    0,    0,    0,    0,    0,    0,  202,  201,  201, 
            0,    0,    0,  201,    0,    0,    0,    0,    0,    0, 
          202,  202,  202,  202,  202,  202,  202,  202,  202,  202, 
            0,  202,  202,    0,    0,  202,  202,    0,    0,    0, 
          202,    0,    0,  202,    0,    0,  202,    0,  202,    0, 
          202,    0,  202,    0,  202,  202,  202,  202,  202,  202, 
          202,    0,  202,    0,  202,  200,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  200,  202,    0,    0,  199, 
          199,  199,    0,    0,  199,  199,  199,    0,  199,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  199,  199, 
            0,    0,    0,    0,    0,    0,    0,  199,  199,  200, 
          199,  199,  199,  199,  199,    0,    0,    0,    0,    0, 
            0,    0,  199,  200,  200,    0,    0,    0,  200,    0, 
            0,    0,    0,    0,    0,  199,  199,  199,  199,  199, 
          199,  199,  199,  199,  199,    0,  199,  199,    0,    0, 
          199,  199,    0,    0,    0,  199,    0,    0,  199,    0, 
            0,  199,    0,  199,    0,  199,  203,  199,    0,  199, 
          199,  199,  199,  199,  199,  199,  203,  199,    0,  199, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  199,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          203,    0,  201,  201,  201,    0,    0,  201,  201,  201, 
            0,  201,    0,    0,  203,  203,    0,    0,    0,  203, 
            0,  201,  201,    0,    0,    0,    0,    0,    0,    0, 
          201,  201,    0,  201,  201,  201,  201,  201,    0,    0, 
            0,    0,    0,    0,    0,  201,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  201,  201, 
          201,  201,  201,  201,  201,  201,  201,  201,    0,  201, 
          201,    0,  204,  201,  201,    0,    0,    0,  201,    0, 
            0,  201,  204,    0,  201,    0,  201,    0,  201,    0, 
          201,    0,  201,  201,  201,  201,  201,  201,  201,    0, 
          201,    0,  201,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  201,    0,  204,  200,  200,  200, 
            0,    0,  200,  200,  200,    0,  200,    0,    0,    0, 
          204,  204,    0,    0,    0,  204,  200,  200,    0,    0, 
            0,    0,    0,    0,    0,  200,  200,    0,  200,  200, 
          200,  200,  200,    0,    0,    0,    0,    0,    0,    0, 
          200,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  200,  200,  200,  200,  200,  200,  200, 
          200,  200,  200,    0,  200,  200,    0,    0,  200,  200, 
            0,    0,    0,  200,    0,    0,  200,    0,    0,  200, 
            0,  200,    0,  200,  197,  200,    0,  200,  200,  200, 
          200,  200,  200,  200,  197,  200,    0,  200,  203,  203, 
          203,    0,    0,  203,  203,  203,    0,  203,    0,  200, 
            0,    0,    0,    0,    0,    0,    0,  203,  203,    0, 
            0,    0,    0,    0,    0,    0,  203,  203,  197,  203, 
          203,  203,  203,  203,    0,    0,    0,    0,    0,    0, 
            0,  203,  197,  197,    0,    0,    0,  197,    0,    0, 
            0,    0,    0,    0,  203,  203,  203,  203,  203,  203, 
          203,  203,  203,  203,    0,  203,  203,    0,    0,  203, 
          203,    0,    0,    0,  203,    0,    0,  203,    0,    0, 
          203,    0,  203,    0,  203,    0,  203,    0,  203,  203, 
          203,  203,  203,  203,  203,    0,  203,  198,  203,    0, 
            0,    0,    0,    0,    0,    0,    0,  198,    0,    0, 
          203,    0,    0,    0,  204,  204,  204,    0,    0,  204, 
          204,  204,    0,  204,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  204,  204,    0,    0,    0,    0,    0, 
            0,  198,  204,  204,    0,  204,  204,  204,  204,  204, 
            0,    0,    0,    0,    0,  198,  198,  204,    0,    0, 
          198,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          204,  204,  204,  204,  204,  204,  204,  204,  204,  204, 
            0,  204,  204,    0,    0,  204,  204,    0,    0,    0, 
          204,    0,    0,  204,    0,    0,  204,    0,  204,    0, 
          204,  222,  204,    0,  204,  204,  204,  204,  204,  204, 
          204,  222,  204,    0,  204,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  204,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  222,  197,  197,  197,    0, 
            0,  197,  197,  197,    0,  197,    0,    0,    0,  222, 
          222,    0,    0,    0,  222,  197,  197,    0,    0,    0, 
            0,    0,    0,    0,  197,  197,    0,  197,  197,  197, 
          197,  197,    0,    0,    0,    0,    0,    0,    0,  197, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  197,  197,  197,  197,  197,  197,  197,  197, 
          197,  197,    0,  197,  197,    0,    0,  197,  197,    0, 
            0,    0,  197,  223,    0,  197,    0,    0,  197,    0, 
          197,    0,    0,  223,  197,    0,    0,    0,  197,  197, 
          197,  197,  197,    0,  197,    0,  197,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  197,  198, 
          198,  198,    0,    0,  198,  198,  198,  223,  198,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  198,  198, 
            0,  223,  223,    0,    0,    0,  223,  198,  198,    0, 
          198,  198,  198,  198,  198,    0,    0,    0,    0,    0, 
            0,    0,  198,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  198,  198,  198,  198,  198, 
          198,  198,  198,  198,  198,    0,  198,  198,    0,    0, 
          198,  198,    0,    0,    0,  198,    0,    0,  198,    0, 
            0,  198,    0,  198,    0,    0,  209,  198,    0,    0, 
            0,  198,  198,  198,  198,  198,  209,  198,    0,  198, 
            0,    0,    0,  222,  222,  222,    0,    0,  222,  222, 
          222,  198,  222,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  222,  222,    0,    0,    0,    0,    0,    0, 
          209,  222,  222,    0,  222,  222,  222,  222,  222,    0, 
            0,    0,    0,    0,  209,  209,  222,    0,    0,  209, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  222, 
          222,  222,  222,  222,  222,  222,  222,  222,  222,    0, 
          222,  222,    0,    0,  222,  222,    0,    0,    0,  222, 
            0,    0,  222,    0,    0,  222,    0,  222,    0,    0, 
            0,  222,    0,    0,    0,    0,    0,  222,  222,  222, 
            0,  222,    0,  222,  207,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  207,  222,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  223,  223,  223,    0,    0, 
          223,  223,  223,    0,  223,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  223,  223,    0,    0,  207,    0, 
            0,    0,    0,  223,  223,    0,  223,  223,  223,  223, 
          223,    0,  207,  207,    0,    0,    0,  207,  223,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  223,  223,  223,  223,  223,  223,  223,  223,  223, 
          223,    0,  223,  223,    0,    0,  223,  223,    0,    0, 
            0,  223,    0,    0,  223,    0,    0,  223,    0,  223, 
            0,    0,  208,  223,    0,    0,    0,    0,    0,  223, 
          223,  223,  208,  223,    0,  223,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  223,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  209,  209, 
          209,    0,    0,  209,  209,  209,  208,  209,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  209,  209,    0, 
          208,  208,    0,    0,    0,  208,  209,  209,    0,  209, 
          209,  209,  209,  209,    0,    0,    0,    0,    0,    0, 
            0,  209,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  209,  209,  209,  209,  209,  209, 
          209,  209,  209,  209,    0,  209,  209,    0,    0,    0, 
            0,  212,    0,    0,  209,    0,    0,  209,    0,    0, 
          209,  212,  209,    0,    0,    0,  209,    0,    0,    0, 
            0,    0,  209,  209,  209,    0,  209,    0,  209,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          209,    0,    0,    0,    0,  212,  207,  207,  207,    0, 
            0,  207,  207,  207,    0,  207,    0,    0,    0,  212, 
          212,    0,    0,    0,  212,  207,  207,    0,    0,    0, 
            0,    0,    0,    0,  207,  207,    0,  207,  207,  207, 
          207,  207,    0,    0,    0,    0,    0,    0,    0,  207, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  207,  207,  207,  207,  207,  207,  207,  207, 
          207,  207,    0,  207,  207,    0,    0,    0,    0,    0, 
            0,  214,  207,    0,    0,  207,    0,    0,  207,    0, 
          207,  214,    0,    0,    0,    0,    0,    0,    0,    0, 
          207,  207,  207,    0,  207,    0,  207,    0,    0,    0, 
            0,    0,    0,    0,  208,  208,  208,    0,  207,  208, 
          208,  208,    0,  208,    0,  214,    0,    0,    0,    0, 
            0,    0,    0,  208,  208,    0,    0,    0,    0,  214, 
          214,    0,  208,  208,  214,  208,  208,  208,  208,  208, 
            0,    0,    0,    0,    0,    0,    0,  208,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          208,  208,  208,  208,  208,  208,  208,  208,  208,  208, 
            0,  208,  208,    0,    0,    0,    0,    0,    0,    0, 
          208,    0,    0,  208,    0,    0,  208,    0,  208,    0, 
            0,  213,    0,    0,    0,    0,    0,    0,  208,  208, 
          208,  213,  208,    0,  208,    0,    0,    0,    0,    0, 
            0,    0,    0,  212,  212,  212,  208,    0,  212,  212, 
          212,    0,  212,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  212,  212,    0,  213,    0,    0,    0,    0, 
            0,  212,  212,    0,  212,  212,  212,  212,  212,  213, 
          213,    0,    0,    0,  213,    0,  212,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  212, 
          212,  212,  212,  212,  212,  212,  212,  212,  212,    0, 
          212,  212,    0,    0,    0,    0,    0,    0,  211,  212, 
            0,    0,  212,    0,    0,  212,    0,  212,  211,    0, 
            0,    0,    0,    0,    0,    0,    0,  212,  212,    0, 
            0,    0,    0,  212,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  212,    0,    0,    0,    0, 
            0,    0,  211,  214,  214,  214,    0,    0,  214,  214, 
          214,    0,  214,    0,    0,    0,  211,  211,    0,    0, 
            0,  211,  214,  214,    0,    0,    0,    0,    0,    0, 
            0,  214,  214,    0,  214,  214,  214,  214,  214,    0, 
            0,    0,    0,    0,    0,    0,  214,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  214, 
          214,  214,  214,  214, 
      };
   }

   private static final short[] yyTable3() {
      return new short[] {

          214,  214,  214,  214,  214,    0,  214,  214,    0,    0, 
            0,    0,  210,    0,    0,  214,    0,    0,  214,    0, 
            0,  214,  210,  214,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  214,  214,    0,    0,    0,    0,  214, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  214,    0,    0,    0,    0,  210,    0,    0,  213, 
          213,  213,    0,    0,  213,  213,  213,    0,  213,    0, 
          210,  210,    0,    0,    0,  210,    0,    0,  213,  213, 
            0,    0,    0,    0,    0,    0,    0,  213,  213,    0, 
          213,  213,  213,  213,  213,    0,    0,    0,    0,    0, 
            0,    0,  213,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  213,  213,  213,  213,  213, 
          213,  213,  213,  213,  213,    0,  213,  213,    0,    0, 
            0,    0,    0,    0,  215,  213,    0,    0,  213,    0, 
            0,  213,    0,  213,  215,    0,    0,    0,    0,    0, 
            0,    0,    0,  213,  213,    0,  211,  211,  211,  213, 
            0,  211,  211,  211,    0,  211,    0,    0,    0,    0, 
            0,  213,    0,    0,    0,  211,  211,    0,  215,    0, 
            0,    0,    0,    0,  211,  211,    0,  211,  211,  211, 
          211,  211,  215,  215,    0,    0,    0,  215,    0,  211, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  211,  211,  211,  211,  211,  211,  211,  211, 
          211,  211,    0,  211,  211,    0,    0,    0,    0,    0, 
            0,    0,  211,    0,    0,  211,    0,    0,  211,    0, 
          211,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          211,  211,  216,    0,    0,    0,  211,    0,    0,    0, 
            0,    0,  216,    0,    0,    0,    0,    0,  211,    0, 
            0,    0,    0,    0,  210,  210,  210,    0,    0,  210, 
          210,  210,    0,  210,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  210,  210,    0,  216,    0,    0,    0, 
            0,    0,  210,  210,    0,  210,  210,  210,  210,  210, 
          216,  216,    0,    0,    0,  216,    0,  210,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  210,  210,    0,    0, 
            0,  210,  210,    0,    0,    0,    0,    0,    0,  217, 
          210,    0,    0,  210,    0,    0,  210,    0,  210,  217, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  210,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  210,    0,    0,    0, 
            0,    0,    0,  217,    0,    0,  215,  215,  215,    0, 
            0,  215,  215,  215,    0,  215,    0,  217,  217,    0, 
            0,    0,  217,    0,    0,  215,  215,    0,    0,    0, 
            0,    0,    0,    0,  215,  215,    0,  215,  215,  215, 
          215,  215,    0,    0,    0,  224,    0,    0,    0,  215, 
            0,    0,    0,    0,    0,  224,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  215,  215, 
            0,    0,    0,  215,  215,    0,    0,    0,    0,    0, 
            0,    0,  215,    0,    0,  215,    0,    0,  215,  224, 
          215,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  224,  224,    0,  215,    0,  224,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  215,    0, 
            0,    0,    0,    0,  216,  216,  216,    0,    0,  216, 
          216,  216,    0,  216,    0,  218,    0,    0,    0,    0, 
            0,    0,    0,  216,  216,  218,    0,    0,    0,    0, 
            0,    0,  216,  216,    0,  216,  216,  216,  216,  216, 
            0,    0,    0,    0,    0,    0,    0,  216,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  218, 
            0,    0,    0,    0,    0,    0,  216,  216,    0,    0, 
            0,  216,  216,  218,  218,    0,    0,    0,  218,    0, 
          216,    0,    0,  216,    0,    0,  216,    0,  216,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  217,  217,  217,  216,    0,  217,  217,  217,    0, 
          217,    0,  219,    0,    0,    0,  216,    0,    0,    0, 
          217,  217,  219,    0,    0,    0,    0,    0,    0,  217, 
          217,    0,  217,  217,  217,  217,  217,    0,    0,    0, 
            0,    0,    0,    0,  217,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  219,    0,    0,    0, 
            0,    0,    0,  217,  217,    0,    0,    0,  217,  217, 
          219,  219,    0,    0,    0,  219,    0,  217,    0,    0, 
          217,    0,    0,  217,    0,  217,    0,  224,  224,  224, 
            0,    0,  224,  224,  224,    0,  224,    0,  225,    0, 
            0,  217,    0,    0,    0,    0,  224,  224,  225,    0, 
            0,    0,    0,  217,    0,  224,  224,    0,  224,  224, 
          224,  224,  224,    0,    0,    0,    0,    0,    0,    0, 
          224,    0,    0,    0,    0,    0,   34,    0,    0,    0, 
            0,    0,  225,    0,    0,    0,   34,    0,    0,  224, 
          224,    0,    0,    0,  224,  224,  225,  225,    0,    0, 
            0,  225,    0,  224,    0,    0,  224,    0,    0,  224, 
            0,  224,    0,    0,    0,    0,    0,  218,  218,  218, 
            0,    0,  218,  218,  218,    0,  218,  224,  195,    0, 
            0,    0,    0,    0,    0,   34,  218,  218,  195,  224, 
            0,    0,    0,    0,    0,  218,  218,    0,  218,  218, 
          218,  218,  218,    0,    0,    0,    0,    0,    0,    0, 
          218,    0,    0,    0,    0,    0,    0,    0,  196,    0, 
            0,    0,  195,    0,    0,    0,    0,    0,  196,  218, 
          218,    0,    0,    0,  218,  218,  195,  195,    0,    0, 
            0,  195,    0,  218,    0,    0,  218,    0,    0,  218, 
            0,  218,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  196,    0,  219,  219,  219,  218,    0,  219, 
          219,  219,    0,  219,    0,    0,  196,  196,    0,  218, 
            0,  196,    0,  219,  219,    0,    0,    0,    0,    0, 
            0,    0,  219,  219,    0,  219,  219,  219,  219,  219, 
            0,    0,    0,  193,    0,    0,    0,  219,    0,    0, 
            0,    0,    0,  193,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  219,  219,    0,    0, 
            0,  219,  219,    0,    0,    0,    0,    0,    0,    0, 
          219,    0,    0,  219,    0,    0,  219,  193,  219,    0, 
          225,  225,  225,    0,    0,  225,  225,  225,    0,  225, 
            0,  193,  193,    0,  219,    0,    0,    0,    0,  225, 
          225,    0,    0,    0,    0,    0,  219,    0,  225,  225, 
            0,  225,  225,  225,  225,  225,    0,    0,   34,   34, 
           34,    0,    0,  225,   34,   34,    0,   34,    0,  189, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  189, 
            0,    0,    0,  225,    0,    0,    0,  225,  225,   34, 
           34,   34,   34,   34,    0,    0,  225,    0,    0,  225, 
            0,    0,  225,    0,  225,    0,    0,    0,    0,    0, 
          195,  195,  195,  189,    0,  195,  195,  195,    0,  195, 
          225,    0,    0,    0,    0,    0,    0,  189,  189,  195, 
          195,    0,  225,    0,    0,    0,    0,   34,  195,  195, 
            0,  195,  195,  195,  195,  195,    0,    0,    0,    0, 
          196,  196,  196,  195,  190,  196,  196,  196,   34,  196, 
            0,    0,    0,    0,  190,    0,    0,    0,    0,  196, 
          196,    0,    0,    0,    0,    0,    0,    0,  196,  196, 
            0,  196,  196,  196,  196,  196,  195,    0,    0,  195, 
            0,    0,  195,  196,  195,    0,    0,    0,  190,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          195,    0,  190,  190,    0,  191,    0,    0,    0,    0, 
            0,    0,  195,    0,    0,  191,  196,    0,    0,  196, 
            0,    0,  196,    0,  196,  193,  193,  193,    0,    0, 
          193,  193,  193,    0,  193,    0,    0,    0,    0,    0, 
          196,    0,    0,    0,  193,  193,    0,    0,    0,  191, 
            0,    0,  196,  193,  193,    0,  193,  193,  193,  193, 
          193,    0,    0,  191,  191,    0,    0,    0,  193,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  193,  192,    0,  193,    0,    0,  193,    0,  193, 
            0,    0,  192,    0,    0,    0,    0,    0,    0,    0, 
            0,  189,  189,  189,    0,  193,  189,  189,  189,    0, 
          189,    0,    0,    0,    0,    0,    0,  193,    0,    0, 
          189,  189,    0,    0,    0,    0,  192,    0,    0,  189, 
          189,    0,  189,  189,  189,  189,  189,    0,    0,    0, 
          192,  192,    0,    0,  189,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  185,    0, 
            0,    0,    0,    0,    0,    0,    0,  189,  185,    0, 
          189,    0,    0,  189,    0,  189,  190,  190,  190,    0, 
            0,  190,  190,  190,    0,  190,    0,    0,    0,    0, 
            0,  189,    0,    0,    0,  190,  190,    0,    0,    0, 
            0,    0,  185,  189,  190,  190,    0,  190,  190,  190, 
          190,  190,    0,    0,    0,    0,  185,  185,    0,  190, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  191,  191,  191, 
            0,    0,  191,  191,  191,    0,  191,    0,    0,    0, 
            0,    0,  190,    0,    0,  190,  191,  191,  190,    0, 
          190,    0,    0,    0,    0,  191,  191,  187,  191,  191, 
          191,  191,  191,    0,    0,    0,  190,  187,    0,    0, 
          191,    0,    0,    0,    0,    0,    0,    0,  190,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  187,    0,  191,    0,    0,  191,    0,    0,  191, 
            0,  191,    0,    0,    0,  187,  187,    0,  227,    0, 
            0,    0,    0,    0,  192,  192,  192,  191,  227,  192, 
          192,  192,    0,  192,    0,    0,    0,    0,    0,  191, 
            0,    0,    0,  192,  192,    0,    0,    0,    0,    0, 
            0,    0,  192,  192,    0,  192,  192,  192,  192,  192, 
            0,    0,  227,    0,    0,    0,    0,  192,    0,    0, 
            0,    0,    0,    0,    0,    0,  227,  227,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          192,    0,    0,  192,  188,    0,  192,    0,  192,    0, 
          185,  185,  185,    0,  188,  185,  185,  185,    0,  185, 
            0,    0,    0,    0,  192,    0,    0,    0,    0,  185, 
          185,    0,    0,    0,    0,    0,  192,    0,  185,  185, 
            0,  185,  185,  185,  185,  185,    0,    0,  188,    0, 
            0,    0,    0,  185,    0,    0,    0,    0,    0,    0, 
            0,    0,  188,  188,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  185,    0,    0,  185, 
          229,    0,  185,    0,  185,    0,    0,    0,    0,    0, 
          229,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          185,    0,    0,    0,    0,    0,    0,    0,    0,  187, 
          187,  187,  185,    0,  187,  187,  187,    0,  187,    0, 
            0,    0,    0,    0,  229,    0,    0,    0,  187,  187, 
            0,    0,    0,    0,    0,    0,    0,  187,  187,  229, 
          187,  187,  187,  187,  187,    0,    0,    0,    0,    0, 
            0,   14,  187,    0,    0,    0,    0,    0,    0,    0, 
            0,   14,    0,    0,    0,    0,    0,    0,  186,    0, 
          227,  227,  227,    0,    0,  227,  227,  227,  186,  227, 
            0,    0,    0,    0,    0,  187,    0,    0,  187,  227, 
          227,  187,    0,  187,    0,    0,    0,    0,  227,  227, 
            0,  227,  227,  227,  227,  227,    0,    0,    0,  187, 
           14,    0,  186,  227,    0,    0,    0,    0,    0,    0, 
            0,  187,    0,    0,    0,    0,  186,  186,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  227,    0,    0,  227, 
            0,    0,  227,    0,  227,    0,  188,  188,  188,    0, 
            0,  188,  188,  188,  184,  188,    0,    0,    0,    0, 
          227,    0,    0,    0,  184,  188,  188,    0,    0,    0, 
            0,    0,  227,    0,  188,  188,    0,  188,  188,  188, 
          188,  188,    0,    0,    0,    0,    0,    0,    0,  188, 
            0,    0,    0,    0,    0,    0,    0,    0,  184,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  184,  184,    0,    0,    0,    0,    0,    0, 
            0,    0,  188,    0,    0,  188,    0,    0,  188,    0, 
          188,    0,  229,  229,  229,    0,    0,  229,  229,  229, 
            0,  229,    0,    0,    0,    0,  188,    0,    0,    0, 
            0,  229,  229,    0,    0,    0,    0,    0,  188,    0, 
          229,  229,    0,  229,  229,  229,  229,  229,    0,    0, 
            0,    0,    0,    0,    0,  229,    0,    0,    0,    0, 
            0,    0,    0,    0,   96,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   14,   14,   14,    0,    0,  229,   14, 
           14,  229,   14,    0,  229,    0,  229,    0,    0,    0, 
          186,  186,  186,    0,    0,  186,  186,  186,    0,  186, 
            0,    0,  229,   96,   14,   14,   14,   14,   14,  186, 
          186,    0,    0,    0,  229,    0,    0,    0,  186,  186, 
            0,  186,  186,  186,  186,    0,    0,    0,    0,    0, 
            0,    0,    0,  186,    0,  444,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   14,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  186,    0,    0,  186, 
            0,    0,  186,   14,  186,    0,    0,    0,   97,    0, 
            0,    0,    0,    0,    0,    0,  184,  184,  184,    0, 
          186,  184,  184,  184,    0,  184,    0,    0,    0,    0, 
            0,    0,  186,    0,    0,  184,  184,    0,    0,    0, 
            0,    0,    0,    0,  184,  184,    0,  184,  184,  184, 
          184,    0,    0,    0,    0,    0,    0,   97,    0,  184, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  447, 
            0,    0,  184,    0,    0,  184,    0,    0,  184,    0, 
          184,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  184,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  184,    0, 
           96,   96,   96,   96,   96,   96,   96,   96,   96,   96, 
           96,    0,   96,   96,   96,    0,   96,   96,   96,   96, 
           96,   96,   96,    0,  515,    0,    0,   96,   96,   96, 
           96,   96,   96,   96,    0,    0,   96,    0,    0,    0, 
            0,    0,   96,   96,   96,   96,   96,   96,   96,    0, 
           96,   96,   96,   96,   96,   96,    0,   96,   96,   96, 
           96,   96,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  444,    0,    0,    0,    0,    0,    0,  444, 
           96,    0,    0,   96,  515,    0,   96,   96,    0,   96, 
            0,   96,    0,  522,    0,   96,    0,    0,    0,    0, 
           96,    0,    0,   96,    0,  515,    0,    0,   96,   96, 
           96,   96,   96,   96,    0,    0,    0,   96,    0,   96, 
           96,    0,   96,   96,   97,   97,   97,   97,   97,   97, 
           97,   97,   97,   97,   97,    0,   97,   97,   97,    0, 
           97,   97,   97,   97,   97,   97,   97,    0,  516,    0, 
            0,   97,   97,   97,   97,   97,   97,   97,    0,    0, 
           97,    0,    0,    0,    0,    0,   97,   97,   97,   97, 
           97,   97,   97,    0,   97,   97,   97,   97,   97,   97, 
            0,   97,   97,   97,   97,   97,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  447,    0,    0,    0, 
            0,    0,    0,  447,   97,    0,    0,   97,  516,    0, 
           97,   97,    0,   97,    0,   97,    0,  270,    0,   97, 
            0,    0,    0,    0,   97,    0,    0,   97,    0,  516, 
            0,    0,   97,   97,   97,   97,   97,   97,    0,    0, 
            0,   97,    0,   97,   97,    0,   97,   97,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   96,   96, 
           96,   96,   96,   96,   96,   96,   96,   96,   96,    0, 
           97,   96,   96,    0,   96,   96,   96,   96,   96,   96, 
           96,    0,  522,    0,    0,   96,   96,   96,   96,   96, 
           96,   96,    0,    0,   96,    0,    0,    0,    0,    0, 
           96,   96,   96,   96,   96,   96,   96,    0,   96,   96, 
           96,   96,   96,   96,    0,   96,   96,   96,   96,   97, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          522,    0,    0,    0,    0,    0,    0,  522,   96,    0, 
            0,   96,  518,    0,   96,   96,    0,   96,    0,   96, 
            0,  271,    0,   96,    0,    0,    0,    0,   96,    0, 
            0,   96,    0,  522,    0,    0,   96,   96,   96,   96, 
           96,   96,    0,    0,    0,   96,    0,   96,   96,    0, 
           96,   96,   97,   97,   97,   97,   97,   97,   97,   97, 
           97,   97,   97,    0,  315,   97,   97,    0,   97,   97, 
           97,   97,   97,   97,   97,    0,    0,    0,    0,   97, 
           97,   97,   97,   97,   97,   97,    0,    0,   97,    0, 
            0,    0,    0,    0,   97,   97,   97,   97,   97,   97, 
           97,    0,   97,   97,   97,   97,   97,   97,    0,   97, 
           97,   97,   97,  315,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  270,    0,    0,    0,    0,    0, 
            0,  270,   97,    0,    0,   97,  519,    0,   97,   97, 
            0,   97,    0,   97,    0,    0,    0,   97,    0,    0, 
            0,    0,   97,    0,    0,   97,    0,    0,    0,    0, 
           97,   97,   97,   97,   97,   97,    0,    0,    0,   97, 
            0,   97,   97,    0,   97,   97,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   97,   97,   97,   97, 
           97,   97,   97,   97,   97,   97,   97,    0,  540,   97, 
           97,    0,   97,   97,   97,   97,   97,   97,   97,    0, 
            0,    0,    0,   97,   97,   97,   97,   97,   97,   97, 
            0,    0,   97,    0,    0,    0,    0,    0,   97,   97, 
           97,   97,   97,   97,   97,    0,   97,   97,   97,   97, 
           97,   97,    0,   97,   97,   97,   97,  540,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  271,    0, 
            0,    0,    0,    0,    0,  271,   97,    0,    0,   97, 
            0,    0,   97,   97,    0,   97,    0,   97,    0,    0, 
            0,   97,    0,    0,    0,    0,   97,    0,    0,   97, 
            0,    0,    0,    0,   97,   97,   97,   97,   97,   97, 
            0,    0,    0,   97,    0,   97,   97,    0,   97,   97, 
          315,  315,  315,  315,  315,  315,  315,  315,  315,  315, 
          315,    0,  315,  315,  315,  315,  315,  315,  315,  315, 
          315,  315,  315,  540,    0,    0,    0,  315,  315,  315, 
          315,  315,  315,  315,    0,    0,  315,    0,    0,    0, 
            0,    0,  315,  315,  315,  315,  315,  315,  315,    0, 
          315,  315,  315,  315,  315,  315,    0,  315,  315,  315, 
          315,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  540,    0,    0,    0,    0,    0,    0,    0, 
          315,    0,    0,  315,    0,    0,  315,  315,    0,  315, 
            0,  315,    0,    0,    0,  315,    0,    0,    0,    0, 
            0,    0,    0,  315,    0,    0,    0,    0,  315,  315, 
          315,  315,  315,  315,    0,    0,    0,  315,    0,  315, 
          315,    0,  315,  315,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  540,  540,  540,  540,  540,  540, 
            0,    0,  540,  540,  540,    0,  227,    0,  540,    0, 
          540,  540,  540,  540,  540,  540,  540,    0,    0,    0, 
            0,  540,  540,  540,  540,  540,  540,  540,    0,    0, 
          540,    0,    0,    0,    0,    0,  540,  540,  540,  540, 
          540,  540,  540,    0,  540,  540,  540,  540,  540,  540, 
            0,  540,  540,  540,  540,  226,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  540,    0,    0,  540,    0,    0, 
          540,  540,    0,  540,    0,  540,    0,    0,    0,  540, 
            0,    0,    0,    0,    0,    0,    0,  540,    0,    0, 
            0,    0,  540,  540,  540,  540,  540,  540,    0,    0, 
            0,  540,    0,  540,  540,    0,  540,  540,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  540, 
          540,  540,  540,  540,  540,    0,    0,    0,  540,  540, 
            0,    0,    0,  540,    0,  540,  540,  540,  540,  540, 
          540,  540,    0,    0,    0,    0,  540,  540,  540,  540, 
          540,  540,  540,    0,    0,  540,    0,    0,    0,    0, 
            0,  540,  540,  540,  540,  540,  540,  540,    0,  540, 
          540,  540,  540,  540,  540,    0,  540,  540,  540,  540, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  540, 
            0,    0,  540,  289,    0,  540,  540,    0,  540,    0, 
          540,    0,    0,    0,  540,    0,    0,    0,    0,    0, 
            0,    0,  540,  384,    0,  540,    0,  540,  540,  540, 
          540,  540,  540,  384,    0,    0,  540,    0,  540,  540, 
            0,  540,  540,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   15,   16,   17,   18,    0,    0,   81,    0,   19, 
           20,   21,   22,   23,   24,   25,    0,    0,   26,    0, 
            0,    0,  384,    0,   89,   28,  384,    0,   31,   32, 
           33,    0,   34,   35,   36,   37,   38,   39,    0,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  384,    0,    0,    0,    0,    0, 
            0,    0,  217,    0,  310,  111,    0,    0,   46,   47, 
            0,   48,    0,    0,  310,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,   51,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,    0,    0,  310,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  310,    0,    0,    0,  310,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  310,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
          311,   12,   13,   14,   99,  100,   17,   18,    0,    0, 
          311,    0,  101,  102,  103,   22,   23,   24,   25,    0, 
            0,  104,    0,    0,    0,    0,    0,    0,  105,    0, 
            0,   31,   32,   33,    0,   34,   35,   36,   37,   38, 
           39,    0,   40,    0,  311,  108,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  384,  384,  384,    0,  311, 
            0,  384,  384,  311,  384,  288,    0,    0,  111,    0, 
            0,   46,   47,  384,   48,    0,    0,    0,    0,    0, 
            0,    0,    0,  384,  384,    0,  384,  384,  384,  384, 
          384,  311,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,    0, 
          384,  384,  384,  384,  384,  384,  384,  384,  384,  384, 
          384,  384,  384,  384,    0,    0,  384,  384,  384,    0, 
            0,    0,    0,    0,  384,    0,    0,    0,    0,    0, 
            0,  384,  274,  384,    0,  384,  384,  384,  384,  384, 
          384,  384,  274,  384,  384,  384,  310,  310,  310,    0, 
            0,  310,  310,  310,    0,  310,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  310,    0,    0,    0,    0, 
            0,    0,    0,    0,  310,  310,  274,  310,  310,  310, 
          310,  310,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  274,    0,    0,    0,  274,    0,    0,    0,    0, 
            0,  310,  310,  310,  310,  310,  310,  310,  310,  310, 
          310,  310,  310,  310,  310,    0,    0,  310,  310,  310, 
            0,    0,    0,  274,    0,  310,    0,    0,    0,    0, 
            0,    0,  310,    0,  310,  456,  310,  310,  310,  310, 
          310,  310,  310,    0,  310,  456,  310,    0,    0,    0, 
            0,    0,  311,  311,  311,    0,    0,  311,  311,  311, 
            0,  311,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  311,    0,    0,    0,    0,    0,    0,    0,   80, 
          311,  311,    0,  311,  311,  311,  311,  311,    0,    0, 
            0,    0,    0,    0,  456,    0,   88,    0,  456,    0, 
            0,    0,    0,    0,    0,    0,    0,  311,  311,  311, 
          311,  311,  311,  311,  311,  311,  311,  311,  311,  311, 
          311,    0,    0,  311,  311,  311,  456,    0,    0,    0, 
            0,  311,    0,    0,    0,    0,    0,    0,  311,    0, 
          311,    0,  311,  311,  311,  311,  311,  311,  311,  264, 
          311,    0,  311,    0,    0,    0,    0,    0,    0,  264, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   87,  274,  274,  274,    0,    0,  274, 
          274,  274,    0,  274,    0,    0,    0,    0,  264,    0, 
           95,    0,  264,  274,    0,    0,    0,    0,    0,    0, 
            0,    0,  274,  274,    0,  274,  274,  274,  274,  274, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          264,    0,    0,    0,    0,    0,    0,    0,    0,  274, 
          274,  274,  274,  274,  274,  274,  274,  274,  274,  274, 
          274,  274,  274,    0,    0,  274,  274,  274,    0,    0, 
            0,    0,    0,  274,    0,    0,    0,    0,    0,    0, 
          274,    0,  274,  271,  274,  274,  274,  274,  274,  274, 
          274,    0,  274,  271,  274,    0,    0,  456,  456,  456, 
            0,    0,    0,  456,  456,    0,  456,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  456,  456,   86,  456,  456, 
          456,  456,  456,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  271,    0,   94,    0,  271,    0,    0,    0, 
            0,    0,  456,  456,  456,  456,  456,  456,  456,  456, 
          456,  456,  456,  456,  456,  456,    0,    0,  456,  456, 
          456,    0,  457,    0,  271,    0,  456,    0,    0,    0, 
            0,    0,    0,  456,    0,  456,    0,  456,  456,  456, 
          456,  456,  456,  456,  250,  456,    0,  456,    0,    0, 
            0,    0,    0,    0,  250,    0,    0,    0,    0,    0, 
            0,  264,  264,  264,    0,    0,    0,  264,  264,    0, 
          264,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  252,  250,  264, 
          264,    0,  264,  264,  264,  264,  264,  252,    0,    0, 
            0,    0,    0,  250,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  264,  264,  264,  264, 
          264,  264,  264,  264,  264,  264,  264,  264,  264,  264, 
            0,  252,  264,  264,  264,    0,    0,    0,    0,    0, 
          264,    0,    0,    0,    0,    0,  252,  264,   52,  264, 
            0,  264,  264,  264,  264,  264,  264,  264,   52,  264, 
            0,  264,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   54,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   54,  271,  271,  271,    0,    0, 
            0,  271,  271,    0,  271,    0,    0,   52,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  271,  271,    0,  271,  271,  271,  271, 
          271,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   54,    0,    0,    0,    0,    0,    0, 
          271,  271,  271,  271,  271,  271,  271,  271,  271,  271, 
          271,  271,  271,  271,    0,    0,  271,  271,  271,   56, 
            0,    0,    0,    0,  271,    0,    0,    0,    0,   56, 
            0,  271,    0,  271,    0,  271,  271,  271,  271,  271, 
          271,  271,    0,  271,    0,  271,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  250,  250,  250,    0, 
            0,  250,  250,  250,    0,  250,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  250,  250,    0,   56,    0, 
            0,    0,    0,   47,  250,  250,    0,  250,  250,  250, 
          250,  250,    0,   47,    0,    0,    0,    0,    0,  252, 
          252,  252,    0,    0,  252,  252,  252,    0,  252,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  252,  252, 
            0,    0,    0,    0,    0,    0,  256,  252,  252,    0, 
          252,  252,  252,  252,  252,  250,  256,    0,  250,    0, 
          250,    0,   47,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  250,    0,    0,    0, 
           52,   52,   52,  254,    0,   52,   52,   52,    0,   52, 
          251,    0,    0,  254,    0,    0,    0,    0,  252,   52, 
           52,  252,    0,  252,    0,  256,    0,    0,   52,   52, 
            0,   52,   52,   52,   52,   52,   54,   54,   54,  252, 
            0,   54,   54,   54,    0,   54,    0,  252,    0,    0, 
            0,    0,    0,  255,    0,   54,   54,    0,    0,    0, 
            0,    0,  254,  255,   54,   54,    0,   54,   54,   54, 
           54,   54,    0,    0,    0,    0,    0,    0,    0,   52, 
            0,    0,   52,    0,    0,    0,    0,    0,    0,  184, 
            0,    0,    0,    0,    0,    0,    0,  253,    0,  184, 
           52,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  255,    0,    0,   54,    0,    0,   54,    0, 
            0,   56,   56,   56,    0,    0,   56,   56,   56,    0, 
           56,    0,    0,  229,    0,    0,   54,    0,    0,    0, 
           56,   56,    0,    0,    0,    0,    0,    0,  184,   56, 
           56,    0,   56,   56,   56,   56,   56,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   47,   47,   47,    0,    0, 
           47,   47,   47,    0,   47,  571,    0,    0,    0,    0, 
           56,    0,    0,   56,   47,    0,    0,    0,    0,    0, 
            0,    0,    0,   47,   47,    0,   47,   47,   47,   47, 
           47,   56,    0,    0,    0,    0,    0,    0,  256,  256, 
          256,    0,    0,  256,  256,  256,    0,  256,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  256, 
          256,  256,  256,  256,   47,  254,  254,  254,    0,    0, 
          254,  254,  254,    0,  254,    0,    0,    0,    0,    0, 
            0,    0,    0,    0, 
      };
   }

   private static final short[] yyTable4() {
      return new short[] {

            0,   47,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  254,  254,  254,  254,  254,    0,    0,    0, 
          256,    0,    0,  256,    0,    0,    0,    0,    0,    0, 
            0,  255,  255,  255,    0,    0,  255,  255,  255,    0, 
          255,    0,    0,    0,  256,    0,    0,    0,    0,  407, 
            0,    0,    0,    0,    0,    0,    0,  254,    0,    0, 
          254,    0,  255,  255,  255,  255,  255,  184,  184,  184, 
            0,    0,    0,  184,  184,    0,  184,    0,    0,    0, 
            0,  254,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  184,  184,    0,  184,  184, 
          184,  184,    0,    0,    0,    0,    0,  255,    0,    0, 
          255,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    4,    5,    6,    0,    8,    0, 
            0,  255,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   99,  100,   17,   18,  184,    0,    0,    0, 
          101,  102,  103,   22,   23,   24,   25,    0,    0,  104, 
            0,    0,    0,    0,    0,    0,  105,  184,    0,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,    0,    0,  108,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  288,    0,    0,  111,    0,    0,   46, 
           47,    0,   48,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,    4,    5,    6, 
            7,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
            0,    0,    0,   19,   20,   21,   22,   23,   24,   25, 
            0,    0,   26,    0,    0,    0,    0,    0,   27,   28, 
           29,   30,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   44,    0,    0,   45, 
            0,    0,   46,   47,    0,   48,    0,   49,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,   51, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
            3,    4,    5,    6,    7,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,   26,    0,    0,    0, 
            0,    0,   27,   28,   29,   30,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           44,    0,    0,   45,    0,    0,   46,   47,    0,   48, 
            0,   49,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,   51,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,    3,    4,    5,    6,    7,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
           26,    0,    0,    0,    0,    0,   27,   28,   29,   30, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   44,    0,    0,  275,    0,    0, 
           46,   47,    0,   48,    0,   49,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,   51,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,    4,    5, 
            6,    7,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,   22,   23,   24, 
           25,    0,    0,   26,    0,    0,    0,    0,    0,   27, 
           28,   29,   30,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   44,    0,    0, 
           45,    0,    0,   46,   47,    0,   48,    0,   49,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
           51,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   99, 
          100,   17,   18,    0,    0,    0,    0,  101,   20,   21, 
           22,   23,   24,   25,    0,    0,  104,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,  241,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          217,    0,    0,  111,    0,    0,   46,   47,    0,   48, 
            0,  242,    0,  243,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  244,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   99,  100,   17,   18,    0,    0,    0,    0, 
          101,  102,  103,   22,   23,   24,   25,    0,    0,  104, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,  241, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  217,    0,    0,  111,    0,    0,   46, 
           47,    0,   48,    0,  626,    0,  243,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  244,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,  244,  244,  244, 
            0,  244,    0,    0,    0,  244,  244,    0,    0,    0, 
          244,    0,  244,  244,  244,  244,  244,  244,  244,    0, 
            0,    0,    0,  244,  244,  244,  244,  244,  244,  244, 
            0,    0,  244,    0,    0,    0,    0,    0,    0,  244, 
            0,    0,  244,  244,  244,    0,  244,  244,  244,  244, 
          244,  244,  244,  244,  244,  244,  244,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  244,    0,    0,  244, 
            0,    0,  244,  244,    0,  244,    0,  244,    0,  244, 
            0,  244,    0,    0,    0,    0,    0,    0,    0,  244, 
            0,    0,    0,    0,  244,  244,  244,  244,  244,  244, 
            0,    0,    0,  244,    0,  244,  244,    0,  244,  244, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   99,  100, 
           17,   18,    0,    0,    0,    0,  101,  102,  103,   22, 
           23,   24,   25,    0,    0,  104,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,  241,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  217, 
            0,    0,  111,    0,    0,   46,   47,    0,   48,    0, 
          242,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,  244,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   99,  100,   17,   18,    0,    0,    0,    0,  101, 
          102,  103,   22,   23,   24,   25,    0,    0,  104,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
           33,    0,   34,   35,   36,   37,   38,   39,  241,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  217,    0,    0,  111,    0,    0,   46,   47, 
            0,   48,    0,    0,    0,  243,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,  244,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   99,  100,   17,   18,    0,    0, 
            0,    0,  101,  102,  103,   22,   23,   24,   25,    0, 
            0,  104,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,   33,    0,   34,   35,   36,   37,   38, 
           39,  241,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  217,    0,    0,  111,    0, 
            0,   46,   47,    0,   48,    0,  626,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,  244,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   99,  100,   17, 
           18,    0,    0,    0,    0,  101,  102,  103,   22,   23, 
           24,   25,    0,    0,  104,    0,    0,    0,    0,    0, 
            0,   28,    0,    0,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,  241,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  217,    0, 
            0,  111,    0,    0,   46,   47,    0,   48,    0,    0, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,  244,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           99,  100,   17,   18,    0,    0,    0,    0,  101,  102, 
          103,   22,   23,   24,   25,    0,    0,  104,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,   31,   32,   33, 
            0,   34,   35,   36,   37,   38,   39,    0,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  217,    0,    0,  111,  438,    0,   46,   47,    0, 
           48,    0,    0,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,  244,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
          104,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  217,    0,    0,  111,    0,    0, 
           46,   47,    0,   48,    0,  564,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  244,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   99,  100,   17,   18, 
            0,    0,    0,    0,  101,  102,  103,   22,   23,   24, 
           25,    0,    0,  104,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  217,    0,    0, 
          111,    0,    0,   46,   47,    0,   48,    0,  564,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          244,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   99, 
          100,   17,   18,    0,    0,    0,    0,  101,  102,  103, 
           22,   23,   24,   25,    0,    0,  104,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          217,    0,    0,  111,    0,    0,   46,   47,    0,   48, 
            0,  242,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  244,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   99,  100,   17,   18,    0,    0,    0,    0, 
          101,  102,  103,   22,   23,   24,   25,    0,    0,  104, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  217,    0,    0,  111,    0,    0,   46, 
           47,    0,   48,    0,  804,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  244,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   99,  100,   17,   18,    0, 
            0,    0,    0,  101,  102,  103,   22,   23,   24,   25, 
            0,    0,  104,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  217,    0,    0,  111, 
            0,    0,   46,   47,    0,   48,    0,  626,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,  244, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
          529,  529,  529,    0,  529,    0,    0,    0,  529,  529, 
            0,    0,    0,  529,    0,  529,  529,  529,  529,  529, 
          529,  529,    0,    0,    0,    0,  529,  529,  529,  529, 
          529,  529,  529,    0,    0,  529,    0,    0,    0,    0, 
            0,    0,  529,    0,    0,  529,  529,  529,    0,  529, 
          529,  529,  529,  529,  529,    0,  529,  529,  529,  529, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  529, 
            0,    0,  529,  529,    0,  529,  529,    0,  529,    0, 
            0,    0,    0,    0,  529,    0,    0,    0,    0,    0, 
            0,    0,  529,    0,    0,    0,    0,  529,  529,  529, 
          529,  529,  529,    0,    0,    0,  529,    0,  529,  529, 
            0,  529,  529,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   15,   16,   17,   18,    0,    0,    0,    0,   19, 
           20,   21,   22,   23,   24,   25,    0,    0,   26,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
           33,    0,   34,   35,   36,   37,   38,   39,    0,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  217,    0,    0,  111,    0,    0,   46,   47, 
            0,   48,    0,    0,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,   51,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   99,  100,   17,   18,    0,    0, 
            0,    0,  101,  102,  103,   22,   23,   24,   25,    0, 
            0,  104,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,   33,    0,   34,   35,   36,   37,   38, 
           39,    0,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  217,    0,    0,  111,    0, 
            0,   46,   47,    0,   48,    0,    0,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,  244,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,    0,    0,   19,   20,   21,   22,   23, 
           24,   25,    0,    0,  104,    0,    0,    0,    0,    0, 
            0,   28,    0,    0,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  217,    0, 
            0,  111,    0,    0,   46,   47,    0,   48,    0,    0, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,  244,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,  529,  529,  529,    0,  529,    0,    0,    0, 
          529,  529,    0,    0,    0,  529,    0,  529,  529,  529, 
          529,  529,  529,  529,    0,    0,    0,    0,  529,  529, 
          529,  529,  529,  529,  529,    0,    0,  529,    0,    0, 
            0,    0,    0,    0,  529,    0,    0,  529,  529,  529, 
            0,  529,  529,  529,  529,  529,  529,    0,  529,  529, 
          529,  529,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  529,    0,    0,  529,    0,    0,  529,  529,    0, 
          529,    0,    0,    0,    0,    0,  529,    0,    0,    0, 
            0,    0,    0,    0,  529,    0,    0,    0,    0,  529, 
          529,  529,  529,  529,  529,    0,    0,    0,  529,    0, 
          529,  529,    0,  529,  529,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   99,  100,   17,   18,    0,    0,    0, 
            0,  101,  102,  103,   22,   23,   24,   25,    0,    0, 
          104,    0,    0,    0,    0,    0,    0,  105,    0,    0, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,    0,    0,  108,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  234,    0,    0,   45,    0,    0, 
           46,   47,    0,   48,    0,   49,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   99,  100,   17,   18, 
            0,    0,    0,    0,  101,  102,  103,   22,   23,   24, 
           25,    0,    0,  104,    0,    0,    0,    0,    0,    0, 
          105,    0,    0,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,    0,   40,    0,    0,  108,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  288,    0,    0, 
          364,    0,    0,   46,   47,    0,   48,    0,  365,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   99, 
          100,   17,   18,    0,    0,    0,    0,  101,  102,  103, 
           22,   23,   24,   25,    0,    0,  104,    0,    0,    0, 
            0,    0,    0,  105,    0,    0,   31,   32,   33,    0, 
          106,   35,   36,   37,  107,   39,    0,   40,    0,    0, 
          108,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          110,    0,    0,  111,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   99,  100,   17,   18,    0,    0,    0,    0, 
          101,  102,  103,   22,   23,   24,   25,    0,    0,  104, 
            0,    0,    0,    0,    0,    0,  105,    0,    0,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,    0,    0,  108,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  288,    0,    0,  364,    0,    0,   46, 
           47,    0,   48,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   99,  100,   17,   18,    0, 
            0,    0,    0,  101,  102,  103,   22,   23,   24,   25, 
            0,    0,  104,    0,    0,    0,    0,    0,    0,  105, 
            0,    0,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,    0,   40,    0,    0,  108,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  814,    0,    0,  111, 
            0,    0,   46,   47,    0,   48,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   99,  100, 
           17,   18,    0,    0,    0,    0,  101,  102,  103,   22, 
           23,   24,   25,    0,    0,  104,    0,    0,    0,    0, 
            0,    0,  105,    0,    0,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,    0,    0,  108, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  889, 
            0,    0,  111,    0,    0,   46,   47,    0,   48,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,  120,  121,  122,  123,  124,  125,  126, 
          127,    0,    0,  128,  129,  130,  131,  132,    0,    0, 
          133,  134,  135,  136,  137,  138,  139,    0,    0,  140, 
          141,  142,  200,  201,  202,  203,  147,  148,  149,  150, 
          151,  152,  153,  154,  155,  156,  157,  158,  204,  205, 
          206,    0,  207,  163,  264,    0,  208,    0,    0,    0, 
          165,  166,    0,  167,  168,  169,  170,  171,  172,  173, 
            0,    0,  174,  175,    0,    0,    0,  176,  177,  178, 
          179,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  181,  182,    0,  183,  184,  185,  186, 
          187,  188,  189,  190,  191,  192,  193,    0,    0,  194, 
           52,  120,  121,  122,  123,  124,  125,  126,  127,    0, 
            0,  128,  129,  130,  131,  132,    0,    0,  133,  134, 
          135,  136,  137,  138,  139,    0,    0,  140,  141,  142, 
          200,  201,  202,  203,  147,  148,  149,  150,  151,  152, 
          153,  154,  155,  156,  157,  158,  204,  205,  206,    0, 
          207,  163,    0,    0,  208,    0,    0,    0,  165,  166, 
            0,  167,  168,  169,  170,  171,  172,  173,    0,    0, 
          174,  175,    0,    0,    0,  176,  177,  178,  179,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  181,  182,    0,  183,  184,  185,  186,  187,  188, 
          189,  190,  191,  192,  193,    0,    0,  194,   52,  120, 
          121,  122,  123,  124,  125,  126,  127,    0,    0,  128, 
          129,  130,  131,  132,    0,    0,  133,  134,  135,  136, 
          137,  138,  139,    0,    0,  140,  141,  142,  143,  144, 
          145,  146,  147,  148,  149,  150,  151,  152,  153,  154, 
          155,  156,  157,  158,  159,  160,  161,    0,  162,  163, 
           36,   37,  164,   39,    0,    0,  165,  166,    0,  167, 
          168,  169,  170,  171,  172,  173,    0,    0,  174,  175, 
            0,    0,    0,  176,  177,  178,  179,    0,    0,    0, 
            0,    0,  180,    0,    0,    0,    0,    0,    0,  181, 
          182,    0,  183,  184,  185,  186,  187,  188,  189,  190, 
          191,  192,  193,    0,    0,  194,  120,  121,  122,  123, 
          124,  125,  126,  127,    0,    0,  128,  129,  130,  131, 
          132,    0,    0,  133,  134,  135,  136,  137,  138,  139, 
            0,    0,  140,  141,  142,  200,  201,  202,  203,  147, 
          148,  149,  150,  151,  152,  153,  154,  155,  156,  157, 
          158,  204,  205,  206,    0,  207,  163,  297,  298,  208, 
          299,    0,    0,  165,  166,    0,  167,  168,  169,  170, 
          171,  172,  173,    0,    0,  174,  175,    0,    0,    0, 
          176,  177,  178,  179,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  181,  182,    0,  183, 
          184,  185,  186,  187,  188,  189,  190,  191,  192,  193, 
            0,    0,  194,  120,  121,  122,  123,  124,  125,  126, 
          127,    0,    0,  128,  129,  130,  131,  132,    0,    0, 
          133,  134,  135,  136,  137,  138,  139,    0,    0,  140, 
          141,  142,  200,  201,  202,  203,  147,  148,  149,  150, 
          151,  152,  153,  154,  155,  156,  157,  158,  204,  205, 
          206,    0,  207,  163,    0,    0,  208,    0,    0,    0, 
          165,  166,    0,  167,  168,  169,  170,  171,  172,  173, 
            0,    0,  174,  175,    0,    0,    0,  176,  177,  178, 
          179,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  181,  182,    0,  183,  184,  185,  186, 
          187,  188,  189,  190,  191,  192,  193,  607,  551,  194, 
            0,  608,    0,    0,    0,  165,  166,    0,  167,  168, 
          169,  170,  171,  172,  173,    0,    0,  174,  175,    0, 
            0,    0,  176,  177,  178,  179,    0,    0,    0,    0, 
            0,  258,    0,    0,    0,    0,    0,    0,  181,  182, 
            0,  183,  184,  185,  186,  187,  188,  189,  190,  191, 
          192,  193,  619,  545,  194,    0,  620,    0,    0,    0, 
          165,  166,    0,  167,  168,  169,  170,  171,  172,  173, 
            0,    0,  174,  175,    0,    0,    0,  176,  177,  178, 
          179,    0,    0,    0,    0,    0,  258,    0,    0,    0, 
            0,    0,    0,  181,  182,    0,  183,  184,  185,  186, 
          187,  188,  189,  190,  191,  192,  193,  621,  551,  194, 
            0,  622,    0,    0,    0,  165,  166,    0,  167,  168, 
          169,  170,  171,  172,  173,    0,    0,  174,  175,    0, 
            0,    0,  176,  177,  178,  179,    0,    0,    0,    0, 
            0,  258,    0,    0,    0,    0,    0,    0,  181,  182, 
            0,  183,  184,  185,  186,  187,  188,  189,  190,  191, 
          192,  193,  646,  545,  194,    0,  647,    0,    0,    0, 
          165,  166,    0,  167,  168,  169,  170,  171,  172,  173, 
            0,    0,  174,  175,    0,    0,    0,  176,  177,  178, 
          179,    0,    0,    0,    0,    0,  258,    0,    0,    0, 
            0,    0,    0,  181,  182,    0,  183,  184,  185,  186, 
          187,  188,  189,  190,  191,  192,  193,  648,  551,  194, 
            0,  649,    0,    0,    0,  165,  166,    0,  167,  168, 
          169,  170,  171,  172,  173,    0,    0,  174,  175,    0, 
            0,    0,  176,  177,  178,  179,    0,    0,    0,    0, 
            0,  258,    0,    0,    0,    0,    0,    0,  181,  182, 
            0,  183,  184,  185,  186,  187,  188,  189,  190,  191, 
          192,  193,  901,  545,  194,    0,  902,    0,    0,    0, 
          165,  166,    0,  167,  168,  169,  170,  171,  172,  173, 
            0,    0,  174,  175,    0,    0,    0,  176,  177,  178, 
          179,    0,    0,    0,    0,    0,  258,    0,    0,    0, 
            0,    0,    0,  181,  182,    0,  183,  184,  185,  186, 
          187,  188,  189,  190,  191,  192,  193,  903,  551,  194, 
            0,  904,    0,    0,    0,  165,  166,    0,  167,  168, 
          169,  170,  171,  172,  173,    0,    0,  174,  175,    0, 
            0,    0,  176,  177,  178,  179,    0,    0,    0,    0, 
            0,  258,    0,    0,    0,    0,    0,    0,  181,  182, 
            0,  183,  184,  185,  186,  187,  188,  189,  190,  191, 
          192,  193,  932,  551,  194,    0,  933,    0,    0,    0, 
          165,  166,    0,  167,  168,  169,  170,  171,  172,  173, 
            0,    0,  174,  175,    0,    0,    0,  176,  177,  178, 
          179,    0,    0,    0,    0,    0,  258,    0,    0,    0, 
            0,    0,    0,  181,  182,    0,  183,  184,  185,  186, 
          187,  188,  189,  190,  191,  192,  193,  558,  545,  194, 
            0,  559,    0,    0,    0,  165,  166,    0,  167,  168, 
          169,  170,  171,  172,  173,    0,    0,  174,  175,    0, 
            0,    0,  176,  177,  178,  179,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  181,  182, 
            0,  183,  184,  185,  186,  187,  188,  189,  190,  191, 
          192,  193,    0,    0,  194, 
      };
   }

   private static final short[] yyCheck1() {
      return new short[] {

            6,    7,   26,   49,   28,    6,   21,   10,   27,  391, 
          311,   94,   10,  383,  404,  250,   59,    7,   47,   10, 
           48,   27,    2,    3,    4,    5,  225,   59,    8,    9, 
           10,   11,   10,    7,   14,   15,   16,   27,   10,   19, 
           47,   48,  110,    3,  283,   10,   52,  286,    2,    3, 
           65,   52,  670,   27,    8,   59,   11,   51,   15,   16, 
           14,   59,   19,  665,   10,   45,   46,  465,  358,   49, 
          678,   51,  280,    4,    5,  280,   10,  676,   10,  681, 
           10,  105,   10,   14,  385,   10,   11,   59,  311,   10, 
           79,   45,  382,   10,   59,  356,  357,  409,  359,  360, 
           10,  303,  422,  367,  762,  307,  306,  305,  305,  399, 
          310,  760,   10,  275,   94,   61,   44,   10,   49,  380, 
           10,   10,  340,  413,   79,   59,  390,   59,  855,  109, 
          506,  111,  340,  340,   10,  455,  397,  398,   59,   10, 
           10,   10,   59,   10,   10,  588,   44,   10,   10,   59, 
          411,   10,   10,  361,   10,  487,  361,  111,  308,   10, 
          115,   59,   10,   94,   10,   10,  609,  543,   61,   10, 
           10,   61,   61,  571,  464,   32,  374,  374,   44,  781, 
          623,  442,   44,   59,  833,  361,   10,  488,   10,   59, 
           61,   10,   59,   59,  921,   10,   10,   10,   61,   61, 
           10,  462,  364,   59,   44,  692,  289,  650,  325,    0, 
           45,  698,  582,  241,  242,  243,   44,   10,   10,   10, 
           10,  839,  880,  593,   91,  375,  376,   44,  328,  611, 
          344,   59,   44,  882,  310,  335,  844,   61,  837,  228, 
          372,  358,   59,  378,  379,  377,   61,   61,  362,   61, 
            2,    3,  232,  233,  853,   32,    8,    9,   10,   11, 
           32,  910,  305,   15,   16,  488,   59,   19,   59,   61, 
          365,   61,  328,  228,  282,  255,  478,  257,  258,  335, 
           10,  261,  372,  263,  370,  371,  372,  377,  268,  337, 
          591,  377,  264,   45,   46,  275,  268,  269,  255,   51, 
          257,  258,  269,   44,  271,   61,   10,  232,  233,  289, 
          686,   61,  710,  381,  268,  419,  281,  337,  422,  365, 
           44,  275,  256,   44,   47,   48,  358,  659,  660,  340, 
           10,  374,  337,  279,  363,  363,  262,  340,  367,  367, 
          320,  321,  322,  323,  324,  325,  326,  327,  290,  291, 
          267,  357,  264,  344,  358,   59,   61,  109,  289,  111, 
          320,  390,  390,  341,  362,  325,  320,  361,  591,  363, 
           91,  325,  310,  367,  368,  381,  405,  405,  358,   59, 
          681,  361,  465,  363,  364,  365,  279,  367,  368,  279, 
          418,  419,  398,  628,  422,  341,  321,  322,  323,  324, 
          267,  358,  382,  383,  384,  644,  412,  305,  279,  341, 
          364,  341,  419,  280,  613,  395,  279,   10,  437,  399, 
          341,  376,  356,  403,  452,  382,   91,  455,  760,  383, 
          762,  437,  744,  413,  365,  305,  826,  443,  808,  305, 
          275,  395,  399,  341,  826,  452,  305,  437,  341,  403, 
          337,  341,  341,  408,  409,  279,  413,  463,  438,   10, 
          440,  328,  905,  437,  279,  279,   59,  279,  335,   91, 
          341,  341,  341,  340,  267,  341,  374,  271,  341,  341, 
          232,  233,  341,  341,  464,  465,  440,  279,  571,  279, 
          341,   59,  358,   44,  361,  341,  341,  867,   91,  358, 
          341,  833,  834,  255,  374,  257,  258,  464,  374,  261, 
           61,  263,  813,  370,  371,  374,  268,  341,  542,  341, 
          377,  310,  341,  275,  279,  724,  341,  341,  341,  364, 
          358,  341,  547,  557,  465,  258,  564,   91,  553,  338, 
           91,  358,  378,  379,   44,  560,  561,   44,  880,  341, 
          882,  341,  361,    2,    3,    4,    5,    6,  279,    8, 
          290,  291,  645,  267,  588,   14,  268,  269,  320,  321, 
          322,  323,  324,  325,  326,  327,  595,  317,  910,   91, 
          317,  871,    0,  263,  264,  609,  263,  264,  594,  595, 
          317,  571,   10,  594,   54,   55,   45,  341,  626,  623, 
           49,  581,  582,   10,   10,  595,  358,  328,  869,  361, 
           21,  363,  364,  593,  335,  367,  368,    2,    3,  340, 
          600,  595,  821,    8,  579,  337,  650,  710,  582,  657, 
          382,  383,  384,    0,  338,  358,  344,  592,   44,  593, 
          571,   59,  317,  395,  624,   94,  600,  399,  370,  371, 
          372,  403,   59,   59,   65,  377,  581,  310,   10,  382, 
           45,  413,  111,  328,  362,  645,   91,  390,  391,   44, 
          335,  372,  652,  348,  267,  372,  399,  352,  353,  707, 
          560,  561,    2,   91,  346,   44,  438,  280,  440,   44, 
          413,  340,  103,  673,  674,  689,  690,  269,  652,  624, 
          267,  695,  113,  683,   10,  685,  328,   59,  688,  689, 
          690,  739,  464,  335,  645,  695,  264,  341,  362,  673, 
          674,   44,   10,   10,   32,   45,  111,   91,  279,  683, 
          710,  685,   61,  306,  688,  328,  306,   44,   44,  370, 
          371,  464,  335,  723,   59,   10,  377,  727,   44,  380, 
          730,   44,   44,  263,  264,   61,  337,  337,  713,  269, 
          740,  741,  742,   15,   16,   44,  337,   19,  361,  723, 
           44,   59,   59,  727,  328,  498,  804,  328,   44,  710, 
          337,  335,  505,  506,  335,   91,  740,  741,  742,  744, 
          341,  111,  723,  264,   59,   44,  261,  338,  337,   91, 
            2,    3,    4,    5,   91,  730,    8,  801,   91,  789, 
          263,  337,   14,  278,  337,  362,  328,  264,   44,  268, 
          543,  801,   58,  335,  547,   91,  275,    0,  808,  581, 
          582,  337,  264,  344,  264,  789,   10,  560,  561,  819, 
          289,  593,   91,   45,  262,  263,  264,   49,  600,  264, 
          268,  269,  337,  271,  808,  262,  263,  264,  362,  264, 
          583,  267,  269,   44,  870,  819,   44,   44,  264,  849, 
          362,  320,  624,   44,   44,  598,  325,   44,  601,   44, 
          603,  905,   61,  268,   44,   59,   44,  867,  611,   44, 
          275,  871,   94,  873,   44,  262,  263,  264,  264,  879, 
          652,  268,  269,  328,  271,  362,  358,  264,  310,  111, 
          335,  917,  264,  867,  871,  364,  365,   91,  849,  873, 
          328,  673,  674,  341,  264,  879,   10,  335,  264,   44, 
          358,  683,  338,  685,  383,  320,  688,  689,  690,  362, 
          325,   91,  665,  695,  362,  356,  395,  306,  268,  308, 
          309,  310,  311,  264,  403,  275,   44,   44,  681,  424, 
           44,  310,   44,  686,  328,  430,  431,   44,   44,  380, 
          264,  335,   10,  279,  341,  727,  264,   61,  730,  364, 
          267,  269,  447,  271,  264,  450,  397,  279,  740,  741, 
          742,  440,   44,  280,  271,  362,   59,  344,  383,  264, 
          411,   10,    0,  255,  269,  257,   44,   91,  362,  340, 
          395,   10,   10,  279,  271,  341,  465,  344,  403,  362, 
          344,   59,  328,   58,   44,  370,  371,  372,  344,  335, 
          279,  442,  377,  264,  340,  341,  328,  789,   67,   59, 
          358,  328,    5,  335,  364,  328,  907,    6,  335,  801, 
           59,  462,  335,  340,    0,  440,  808,  676,  781,  813, 
           59,   59,  328,   71,   10,  853,  268,  819,  872,  335, 
           14,   91,  659,  275,  361,  395,  839,   79,   -1,  328, 
           -1,   -1,   91,  403,   -1,   -1,  335,  289,   -1,  262, 
          263,  264,   91,  267,   -1,  268,  269,   -1,  271,   -1, 
          370,  371,  372,  826,   -1,  570,  280,  377,   -1,   -1, 
          500,  501,   -1,   59,   -1,  867,   -1,   -1,  320,  871, 
          440,  873,  571,  325,   -1,  590,   -1,  879,   10,  279, 
          280,   -1,   -1,  582,   -1,  306,  547,  308,  309,  310, 
          311,   -1,  553,   -1,  593,   -1,   -1,   -1,  871,  560, 
          561,  600,  308,  309,  328,  311,   -1,  370,  371,  372, 
           -1,  335,  364,  365,  377,   -1,  340,   -1,  341,    0, 
           -1,  636,  583,   -1,   -1,  586,   44,   59,  328,   10, 
           -1,  383,   -1,   -1,  907,  335,   -1,  361,   -1,  362, 
          340,   10,   -1,  395,   -1,  279,  645,  582,   -1,  664, 
           -1,  403,   -1,  652,   -1,    9,   10,   11,  593,   91, 
           -1,  361,   -1,   44,   -1,  600,    0,   -1,   -1,  375, 
          376,   -1,   -1,   91,  673,  674,   10,   -1,   59,  267, 
          370,  371,  372,   -1,  683,   -1,  685,  377,  440,  688, 
           59,   -1,   46,  306,  328,  308,  309,  310,  311,   -1, 
           -1,  335,   -1,  718,   -1,   -1,   -1,  341,  267,   -1, 
          280,  710,   -1,  465,  262,  263,  264,  652,  267,   -1, 
          268,  269,   91,  271,  723,   59,  339,   -1,  727,   -1, 
          600,   -1,   -1,   -1,  347,  348,  349,  350,  673,  674, 
           10,  740,  741,  742,  759,   -1,   -1,   -1,  683,  764, 
          685,   -1,    0,  688,   -1,  109,   -1,   -1,  328,   -1, 
           -1,   -1,   10,   -1,   -1,  335,  262,  263,  264,  328, 
          340,  267,  268,  269,   -1,  271,  335,   44,   -1,  328, 
           -1,  340,  652,   -1,   -1,  281,  335,   -1,  358,   59, 
          789,  361,  727,  341,  290,  291,   44,  293,  294,  295, 
          296,  297,   -1,  673,  674,  740,  741,  742,   -1,  808, 
           58,   59,   -1,  683,  362,  685,   -1,   -1,  688,  571, 
          819,   -1,   -1,   -1,   91,  765,   -1,   -1,   -1,   44, 
          582,   -1,   -1,  773,  774,  267,  776,   -1,  778,   -1, 
          780,  593,  782,  783,   59,  341,   -1,   -1,  600,   -1, 
          849,   -1,   -1,   -1,  789,   -1,   -1,  727,   -1,   15, 
           16,  279,  280,   19,   -1,   -1,  362,    0,  867,   -1, 
          740,  741,  742,  808,  873,   -1,   91,   10,  232,  233, 
          879,  262,  263,  264,  819,   41,   42,  268,  269,   -1, 
          271,   47,   48,  645,   50,   51,  328,   -1,  267,   -1, 
          652,  653,   -1,  335,   -1,   -1,   -1,  261,  869,  263, 
          328,   -1,  293,  294,  295,  296,  297,  335,   -1,  789, 
           -1,  673,  674,   -1,   -1,   -1,   59,   -1,  262,  263, 
          264,  683,  867,  685,  268,  269,  688,  271,  873,   -1, 
           -1,   -1,   -1,  361,  879,  885,  886,  887,  888,  819, 
           10,  891,   -1,  893,  894,  895,  896,   -1,  710,  328, 
          341,  293,  294,  295,  296,  297,  335,  321,  322,  323, 
          324,  723,  326,  327,   -1,  727,   -1,  676,   -1,  678, 
           -1,  362,  681,   -1,   44,   -1,   -1,   -1,  740,  741, 
          742,  931,   -1,   -1,  934,  935,  936,  937,   -1,   -1, 
           -1,   61,   -1,  873,  944,   -1,   -1,  341,   -1,  879, 
           -1,   -1,  279,  280,  262,  263,  264,   -1,   -1,  267, 
          268,  269,  306,  271,  308,  309,  310,  311,  362,   -1, 
          384,   91,   -1,  281,  282,   -1,  306,  789,  308,  309, 
          310,  311,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,    0,   -1,  339,  808,  305,  328,   -1, 
           -1,  328,   -1,   10,   -1,  335,   -1,  819,  335,  339, 
          340,   -1,   -1,  340,   -1,   -1,   -1,  347,  348,  349, 
          350,   -1,   -1,   -1,  438,  241,  242,  243,  244,   -1, 
          338,   -1,   -1,  341,  361,   -1,  344,  849,  346,  255, 
           -1,  257,  258,  306,   -1,  308,  309,  310,  311,   -1, 
          266,   -1,   59,  328,  362,  867,   -1,   10,   -1,   -1, 
          335,  873,   -1,   -1,   -1,  340,  374,  879,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,  358,   -1,  844,   -1,   -1,  281,   -1, 
           -1,   44,   -1,   -1,  853,   -1,  855,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   61,   -1, 
           -1,   -1,  328,  329,  330,  331,  332,  333,  334,  335, 
          336,  337,  338,  339,  340,  341,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,   91,   -1, 
           -1,   -1,  358,   -1,   -1,  361,   -1,  363,  341,   -1, 
           -1,  367,  368,   10,   -1,   -1,   -1,  317,   44,  279, 
          280,   -1,  921,  668,   -1,    0,  382,  581,   -1,  362, 
           -1,   -1,   -1,  678,  390,   10,  681,   -1,   -1,   -1, 
           -1,   -1,   -1,  399,  400,  401,  402,   44,  348,  405, 
           -1,   -1,  352,  353,  354,  355,   -1,  413,   -1,   -1, 
           -1,   -1,  418,  419,   61,   91,  422,   -1,  328,   44, 
          624,   -1,   -1,   -1,   -1,  335,   -1,   -1,   -1,   -1, 
          340,  341,   -1,   58,   59,   -1,   -1,   -1,  444,  445, 
          446,   -1,   -1,   -1,   91,   -1,  452,   -1,   -1,  455, 
           -1,  361,   -1,   -1,   -1,   -1,   -1,   -1,  464,   -1, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,  281,   -1,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          306,   -1,  308,  309,  310,  311,  730,   -1,   -1,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,  279,  280,  335,  336, 
           -1,   -1,  339,   -1,  341,  342,  343,  842,  345,  844, 
          347,  846,  349,  339,  351,  850,   -1,   -1,  564,   -1, 
          855,  347,  359,   -1,    0,  362,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   10,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,   -1,   -1,  328,  306,   -1,  308,  309, 
          310,  311,  335,   -1,   -1,   -1,   -1,  340,  341,   -1, 
           -1,   -1,   -1,  279,  280,   -1,   -1,  306,   44,  308, 
          309,  310,  311,   -1,   -1,   -1,   -1,  912,  361,  339, 
          626,   -1,   58,   59,  919,   61,  921,   63,  923,  349, 
          350,   -1,  279,  280,   -1,   -1,   -1,  262,  263,  264, 
          339,   -1,  267,  268,  269,  940,  271,   -1,  347,   -1, 
           -1,  657,  328,   -1,   -1,   91,  281,  282,   -1,  335, 
           -1,   -1,   -1,   -1,  340,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,  328,   -1,  689,  690,  361,   -1,    0,  335,  695, 
          696,   -1,   -1,  340,  341,   -1,   -1,   10,   -1,   -1, 
          706,  707,   -1,   -1,   -1,  711,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  338,  361,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,  733,  734,  735, 
           -1,   44,   -1,  739,   -1,   -1,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   61,  374, 
           63,   -1,   -1,   -1,   -1,  306,  307,   -1,   -1,  310, 
           -1,   -1,   10,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   91,   -1, 
          331,  332,  333,  334,  790,   -1,   -1,   -1,   -1,  340, 
           -1,   -1,   -1,   -1,   -1,  801,  347,  348,  804,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
           -1,   -1,  363,   -1,   -1,   63,   -1,  823,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,  279,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   -1,  299,   -1,  871,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,  337,  338,  339,  340,  341,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   10,  373,  374,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,  267,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,  279,  280,  281,  282, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   59,  299,   -1,   -1,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,  337,  338,  339,  340,  341,  342, 
          343,  344,  345,  346,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
           -1,  364,  365,  366,  367,  368,  369,    0,   -1,   -1, 
          373,  374,  375,  376,   -1,  378,  379,   10,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          348,   44,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,  306,  307,   58,   59,  310,   61,   -1, 
           63,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,  340,   91,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,   -1,  306, 
          363,  308,  309,  310,  311,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,  306,   -1,  308,  309,  310,  311, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,  340,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,  348,  349,  350,   -1,   -1,   -1,  339,  340,   -1, 
           -1,   -1,   -1,   -1,   44,  347,  348,  349,  350,   -1, 
           -1,   -1,  306,   -1,  308,  309,  310,  311,   58,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,  306,   -1,  308, 
          309,  310,  311,  306,  328,  308,  309,  310,  311,   -1, 
           -1,  335,   -1,   -1,   -1,  339,  340,  317,   -1,   -1, 
           -1,   91,   -1,  347,  348,  349,  350,   -1,   -1,   -1, 
          339,   -1,   -1,  333,  334,   -1,  339,   10,  347,  348, 
          349,  350,   -1,   -1,  347,  348,  349,  350,  348,   -1, 
          350,   -1,  352,  353,  354,  355,   -1,   -1,  358,   -1, 
          360,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,  267,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   59,  280,  281,  282, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   -1,  299,   -1,   -1,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,  338,  339,  340,  341,  342, 
          343,  344,  345,  346,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   10, 
          373,  374,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   59,  299, 
           -1,   -1,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,  338,  339, 
          340,  341,  342,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,   -1,  364,  365,  366,  367,  368,  369, 
            0,   -1,   -1,  373,  374,  375,  376,   -1,  378,  379, 
           10,   -1,  317,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,  334, 
           -1,   -1,   -1,  306,   -1,  308,  309,  310,  311,   -1, 
           -1,   -1,   -1,  348,   44,  350,   -1,  352,  353,  354, 
          355,   -1,  317,   -1,   -1,  328,   -1,   -1,   58,   59, 
           -1,   61,  335,   63,   -1,   -1,  339,  340,  333,  334, 
           -1,   -1,   -1,   -1,  347,  348,  349,  350,   -1,   -1, 
           -1,   -1,   -1,  348,   -1,   -1,   -1,  352,  353,  354, 
          355,   91,   -1,  306,  307,   -1,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,    0,   -1,   -1,   -1,  340,   -1,   -1, 
           -1,   -1,   -1,   10,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,   -1,   -1, 
          363,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,   -1,   -1,   -1,   44,  333,  334, 
           -1,   -1,   -1,   -1,   -1,  306,   -1,  308,  309,  310, 
          311,   58,   59,  348,   -1,  350,   63,  352,  353,  354, 
          355,  356,  357,  358,  317,  360,   -1,  328,   -1,  322, 
          323,   -1,   -1,   -1,  335,   -1,   -1,   -1,  339,  340, 
          333,  334,   -1,   -1,   91,   -1,  347,  348,  349,  350, 
           -1,   -1,   -1,   -1,   -1,  348,   -1,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   10,  299, 
           -1,   -1,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,  338,  339, 
          340,  341,  342,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   10,  373,  374,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   59,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,  338,  339,  340,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,   -1,  364,  365,  366, 
          367,  368,  369,    0,   -1,   -1,  373,  374,  375,  376, 
           -1,  378,  379,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
           -1,   58,   59,  265,  266,   -1,   63,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   91,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   10,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,  349,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           44,  373,   -1,  375,  376,   -1,  378,  379,  306,   -1, 
          308,  309,  310,  311,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          328,   -1,   -1,   -1,   -1,   -1,   -1,  335,   -1,   -1, 
           -1,  339,  340,   -1,   -1,   -1,   -1,   91,   -1,  347, 
          348,  349,  350,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   59,  280,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,  338,  339,  340,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   10,  373,  374,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   59,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,  339,  340,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,   -1, 
          364,  365,  366,  367,  368,  369,    0,   -1,   -1,  373, 
          374,  375,  376,   -1,  378,  379,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  306, 
           -1,  308,  309,  310,  311,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  328,   -1,   -1,   58,   59,   -1,   61,  335,   63, 
           -1,   -1,  339,  340,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,  348,  349,  350,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,  306, 
          307,   -1,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,  333,  334,   -1,    0, 
           -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   10, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,   -1,   -1,  363,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,   -1,  326,  327,   -1, 
           -1,   -1,   -1,   44,  333,  334,   -1,   -1,   -1,   -1, 
           -1,  306,   -1,  308,  309,  310,  311,   -1,   59,  348, 
           -1,  350,   63,  352,  353,  354,  355,  356,  357,  358, 
           -1,  360,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1, 
          335,   -1,   -1,   -1,  339,  340,   -1,   -1,   -1,   -1, 
           91,   -1,  347,  348,  349,  350,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   10,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,  339,  340,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,   -1,  362,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   10,  373, 
          374,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   59,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,  338,  339,   -1, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,   -1,  364,  365,  366,  367,  368,  369,    0, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,   -1,   59,  265, 
          266,   -1,   63,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           91,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   10,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,   -1,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   44,  373,   -1,  375, 
          376,   -1,  378,  379,  306,   -1,  308,  309,  310,  311, 
           -1,   59,   -1,   -1,   -1,   63,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,  328,  326,  327,   -1, 
           -1,   -1,   -1,  335,  333,  334,   -1,  339,  340,   -1, 
           -1,   -1,   -1,   91,   -1,  347,  348,  349,  350,  348, 
           -1,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           -1,  360,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294, 
      };
   }

   private static final short[] yyCheck2() {
      return new short[] {

          295,  296,  297,   -1,  299,   59,   63,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,  338,  339,   -1,  341,  342,  343,  344, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,   -1,  364, 
          365,  366,  367,  368,  369,   63,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,  338,  339,   -1,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,    0, 
          362,   -1,  364,  365,  366,  367,  368,  369,   -1,   10, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1, 
          344,  348,  346,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   -1,   -1,   -1,   -1,  362,  297, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   10,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   44, 
          348,   -1,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   59,  360,   61,   -1,   63,   61,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,   -1,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   59,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,   59,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,   -1,  339,  340, 
          341,  342,  343,   -1,  345,   -1,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   63,  378,  379,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,   -1, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,   -1,  279,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,  328,   -1,  333,  334,  335,  336,   -1, 
          335,  339,  340,  341,  342,  343,  341,  345,   -1,  347, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,   -1,  364,  365,  366,  367, 
          368,  369,    0,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,   10,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  306,  281,  308,  309,  310, 
          311,   -1,   -1,   -1,   -1,   -1,   44,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,   59,   -1,   61,  335,   63,   -1,   -1,  339,  340, 
           -1,   -1,   -1,   -1,   -1,   -1,  347,  348,  349,  350, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1, 
          297,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   59,   -1,   61,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,   -1, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           -1,  299,   -1,   59,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
           -1,  339,  340,  341,  342,  343,   -1,  345,   -1,  347, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,   -1,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,   -1,  339,  340,  341,  342,  343,   -1, 
          345,   10,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,    0,  362,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   10,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,   44,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   61,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   58,   59,   -1,   61,   -1,   63, 
           -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  341,   -1,    0,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  362,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   44,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   58,   59,   -1,   -1,  299, 
           63,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,  333,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          279,  280,   -1,   -1,   -1,   44,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   58, 
           59,   -1,   61,   -1,   63,   -1,  280,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,  328, 
           -1,  305,   91,   -1,   -1,   -1,  335,   -1,   -1,   -1, 
           -1,   -1,  341,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  361,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,  348,    0,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   10,  360,  361,  362,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
          374,   -1,   -1,   -1,   -1,   -1,   -1,  280,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   44, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,   -1,   -1,  338,   91,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,   -1,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,  361,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  374,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,    0,  333,  334,  335,   -1,  337,  338, 
           -1,   -1,  341,   10,   -1,  344,   -1,  346,   -1,  348, 
           -1,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           -1,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  374,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   61,   -1,   63,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  280,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,    0,  333,  334, 
          335,   -1,   -1,  338,   -1,   -1,  341,   10,   -1,  344, 
           -1,  346,   -1,  348,   -1,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   -1,  360,  361,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  306,  307,   58,   59,  310,   61,   -1, 
           63,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,  340,   91,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,   -1,   -1, 
          363,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   44,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,   -1, 
           -1,  338,   91,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,    0,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,   -1,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,    0,  360,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,  374,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   58,   59,  305,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,   91,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348, 
            0,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           10,  360,   -1,  362,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,  374,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   44,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   58,   59, 
           -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,   -1,   -1, 
          338,   91,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,   -1,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,    0,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,  374,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,  348,    0,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   10,  360,   -1,  362,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
          374,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   58,   59,  305,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,   91,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   -1, 
          360,    0,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,  374,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   44,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,    0,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   63,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,    0,  333,  334, 
          335,   -1,   -1,  338,   -1,   -1,  341,   10,   -1,  344, 
           -1,  346,   -1,  348,   -1,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   -1,  360,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374, 
           -1,   44,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           63,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348, 
            0,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           10,  360,   -1,  362,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,  374,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   44,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   58,   59, 
           -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,   -1,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   -1,  362,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,  374,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   44, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
          333,  334,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,    0,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   10,  360,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  374,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,    0,  333,  334,   -1,   -1,   -1,  338,   -1, 
           -1,  341,   10,   -1,  344,   -1,  346,   -1,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   -1, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  374,   -1,   44,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   63,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,   -1,  333,  334, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,  348,    0,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   10,  360,   -1,  362,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,  374, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   44,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,  348,   -1,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,    0,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
          374,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   58,   59,  305,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,    0,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   63,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,  333,  334,   -1, 
           -1,   -1,  338,    0,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,   10,  350,   -1,   -1,   -1,  354,  355, 
          356,  357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   44,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   58,   59,   -1,   -1,   -1,   63,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
          333,  334,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,   -1,    0,  350,   -1,   -1, 
           -1,  354,  355,  356,  357,  358,   10,  360,   -1,  362, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,  374,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   58,   59,  305,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1, 
           -1,  350,   -1,   -1,   -1,   -1,   -1,  356,  357,  358, 
           -1,  360,   -1,  362,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,  374,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   58,   59,   -1,   -1,   -1,   63,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,   -1,    0,  350,   -1,   -1,   -1,   -1,   -1,  356, 
          357,  358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   44,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           58,   59,   -1,   -1,   -1,   63,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   10,  346,   -1,   -1,   -1,  350,   -1,   -1,   -1, 
           -1,   -1,  356,  357,  358,   -1,  360,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          374,   -1,   -1,   -1,   -1,   44,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   63,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          356,  357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,  374,  267, 
          268,  269,   -1,  271,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   58, 
           59,   -1,  290,  291,   63,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,  356,  357, 
          358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,  374,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   -1,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,   -1,   -1,   -1,   -1,    0,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  356,  357,   -1, 
           -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   63,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322, 
      };
   }

   private static final short[] yyCheck3() {
      return new short[] {

          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   10,  346,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  356,  357,   -1,   -1,   -1,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  374,   -1,   -1,   -1,   -1,   44,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  356,  357,   -1,  262,  263,  264,  362, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,  374,   -1,   -1,   -1,  281,  282,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   58,   59,   -1,   -1,   -1,   63,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          356,  357,    0,   -1,   -1,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           58,   59,   -1,   -1,   -1,   63,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  324,  325,   -1,   -1, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,    0,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  324,  325, 
           -1,   -1,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   44, 
          346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,  362,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,  324,  325,   -1,   -1, 
           -1,  329,  330,   58,   59,   -1,   -1,   -1,   63,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,  362,   -1,  267,  268,  269,   -1, 
          271,   -1,    0,   -1,   -1,   -1,  374,   -1,   -1,   -1, 
          281,  282,   10,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,  324,  325,   -1,   -1,   -1,  329,  330, 
           58,   59,   -1,   -1,   -1,   63,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,    0,   -1, 
           -1,  362,   -1,   -1,   -1,   -1,  281,  282,   10,   -1, 
           -1,   -1,   -1,  374,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   10,   -1,   -1,  324, 
          325,   -1,   -1,   -1,  329,  330,   58,   59,   -1,   -1, 
           -1,   63,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,  362,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,  281,  282,   10,  374, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   10,  324, 
          325,   -1,   -1,   -1,  329,  330,   58,   59,   -1,   -1, 
           -1,   63,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,  262,  263,  264,  362,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   58,   59,   -1,  374, 
           -1,   63,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  324,  325,   -1,   -1, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   44,  346,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   58,   59,   -1,  362,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,  374,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,  262,  263, 
          264,   -1,   -1,  305,  268,  269,   -1,  271,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,  325,   -1,   -1,   -1,  329,  330,  293, 
          294,  295,  296,  297,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   44,   -1,  267,  268,  269,   -1,  271, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,  281, 
          282,   -1,  374,   -1,   -1,   -1,   -1,  341,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
          262,  263,  264,  305,    0,  267,  268,  269,  362,  271, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,  338,   -1,   -1,  341, 
           -1,   -1,  344,  305,  346,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          362,   -1,   58,   59,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,  374,   -1,   -1,   10,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
          362,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   44, 
           -1,   -1,  374,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   58,   59,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,    0,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,  362,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   44,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           58,   59,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   10,   -1, 
          341,   -1,   -1,  344,   -1,  346,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   44,  374,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   58,   59,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,  281,  282,  344,   -1, 
          346,   -1,   -1,   -1,   -1,  290,  291,    0,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,  362,   10,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,   -1,   -1,   58,   59,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,  362,   10,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  374, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          338,   -1,   -1,  341,    0,   -1,  344,   -1,  346,   -1, 
          262,  263,  264,   -1,   10,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,  374,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
            0,   -1,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,  374,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   59, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   10,  271, 
           -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341,  281, 
          282,  344,   -1,  346,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,  362, 
           59,   -1,   44,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  374,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,    0,  271,   -1,   -1,   -1,   -1, 
          362,   -1,   -1,   -1,   10,  281,  282,   -1,   -1,   -1, 
           -1,   -1,  374,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  338,  268, 
          269,  341,  271,   -1,  344,   -1,  346,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,  362,   59,  293,  294,  295,  296,  297,  281, 
          282,   -1,   -1,   -1,  374,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,  362,  346,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
          362,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,  374,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
          256,  257,  258,  259,  260,  261,  262,  263,  264,  265, 
          266,   -1,   10,  269,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,  300,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335, 
          336,   -1,   -1,  339,  340,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   91,   -1,  351,   -1,   -1,   -1,   -1, 
          356,   -1,   -1,  359,   -1,  361,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  256,  257,  258,  259,  260,  261, 
          262,  263,  264,  265,  266,   -1,   10,  269,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1, 
           -1,   -1,   -1,  335,  336,   -1,   -1,  339,  340,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   91,   -1,  351, 
           -1,   -1,   -1,   -1,  356,   -1,   -1,  359,   -1,  361, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,  257, 
          258,  259,  260,  261,  262,  263,  264,  265,  266,   -1, 
           10,  269,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,  300,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1, 
           -1,  339,  340,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,   91,   -1,  351,   -1,   -1,   -1,   -1,  356,   -1, 
           -1,  359,   -1,  361,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   10,  269,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,  300,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,  336,   -1,   -1,  339,  340,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,  356,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259, 
          260,  261,  262,  263,  264,  265,  266,   -1,   10,  269, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299, 
          300,  301,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1, 
           -1,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,  356,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          256,  257,  258,  259,  260,  261,  262,  263,  264,  265, 
          266,   -1,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   10,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,  300,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  256,  257,  258,  259,  260,  261, 
           -1,   -1,  264,  265,  266,   -1,   10,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256, 
          257,  258,  259,  260,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,  298,  299,  300,  301,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   44,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,    0,   -1,  362,   -1,  364,  365,  366, 
          367,  368,  369,   10,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   44,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   59,   -1,   61,  299,   63,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,    0,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,   -1,   10,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
            0,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           10,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,   -1,   44,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   59, 
           -1,  268,  269,   63,  271,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,  280,  345,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   91,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,   -1, 
           -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1, 
           -1,  348,    0,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   10,  360,  361,  362,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   44,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
           -1,   -1,   -1,   91,   -1,  341,   -1,   -1,   -1,   -1, 
           -1,   -1,  348,   -1,  350,    0,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,   10,  362,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   -1,   61,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,   91,   -1,   -1,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,    0, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   59,   -1, 
           61,   -1,   63,  281,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,   -1,   -1, 
           -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1, 
          348,   -1,  350,    0,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   10,  362,   -1,   -1,  262,  263,  264, 
           -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   44,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,   -1,  337,   -1,   91,   -1,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,  348,   -1,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,    0,  360,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   44,  290, 
          291,   -1,  293,  294,  295,  296,  297,   10,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   44,  333,  334,  335,   -1,   -1,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   59,  348,    0,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   10,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,  262,  263,  264,   -1,   -1, 
           -1,  268,  269,   -1,  271,   -1,   -1,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,    0, 
           -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   10, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   59,   -1, 
           -1,   -1,   -1,    0,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   10,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,  290,  291,   -1, 
          293,  294,  295,  296,  297,  341,   10,   -1,  344,   -1, 
          346,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1, 
          262,  263,  264,    0,   -1,  267,  268,  269,   -1,  271, 
           44,   -1,   -1,   10,   -1,   -1,   -1,   -1,  341,  281, 
          282,  344,   -1,  346,   -1,   59,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,  262,  263,  264,  362, 
           -1,  267,  268,  269,   -1,  271,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   59,   10,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  341, 
           -1,   -1,  344,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   10, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   -1,  341,   -1,   -1,  344,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   44,   -1,   -1,  362,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   59,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   44,   -1,   -1,   -1,   -1, 
          341,   -1,   -1,  344,  281,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,  362,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  293, 
          294,  295,  296,  297,  341,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1, 
      };
   }

   private static final short[] yyCheck4() {
      return new short[] {

           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,  293,  294,  295,  296,  297,  262,  263,  264, 
           -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1, 
           -1,  362,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,  341,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,  362,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
          260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299, 
          300,  301,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          256,  257,  258,  259,  260,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,  300,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  256,  257,  258,  259,  260,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,  260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,  300,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,  349,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,  349,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,  349, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,   -1,   -1,  349,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,  340,   -1,  342,  343,   -1, 
          345,   -1,   -1,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,  340,   -1,  342,  343,   -1,  345,   -1, 
           -1,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,   -1,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,   -1,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,   -1,   -1, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,   -1,   -1,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,  260,  261,  262,  263, 
          264,   -1,   -1,  267,  268,  269,  270,  271,   -1,   -1, 
          274,  275,  276,  277,  278,  279,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,  298,  299,  300,  301,  302,  303, 
          304,   -1,  306,  307,  308,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,   -1,   -1,  363, 
          364,  257,  258,  259,  260,  261,  262,  263,  264,   -1, 
           -1,  267,  268,  269,  270,  271,   -1,   -1,  274,  275, 
          276,  277,  278,  279,  280,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,  298,  299,  300,  301,  302,  303,  304,   -1, 
          306,  307,   -1,   -1,  310,   -1,   -1,   -1,  314,  315, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,   -1, 
          326,  327,   -1,   -1,   -1,  331,  332,  333,  334,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  347,  348,   -1,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,   -1,   -1,  363,  364,  257, 
          258,  259,  260,  261,  262,  263,  264,   -1,   -1,  267, 
          268,  269,  270,  271,   -1,   -1,  274,  275,  276,  277, 
          278,  279,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
          298,  299,  300,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,   -1,   -1,  363,  257,  258,  259,  260, 
          261,  262,  263,  264,   -1,   -1,  267,  268,  269,  270, 
          271,   -1,   -1,  274,  275,  276,  277,  278,  279,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,  298,  299,  300, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
           -1,   -1,  363,  257,  258,  259,  260,  261,  262,  263, 
          264,   -1,   -1,  267,  268,  269,  270,  271,   -1,   -1, 
          274,  275,  276,  277,  278,  279,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,  298,  299,  300,  301,  302,  303, 
          304,   -1,  306,  307,   -1,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  306,  307,  363, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
           -1,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  306,  307,  363,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  306,  307,  363, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
           -1,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  306,  307,  363,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  306,  307,  363, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
           -1,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  306,  307,  363,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  306,  307,  363, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
           -1,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  306,  307,  363,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  306,  307,  363, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
           -1,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,   -1,   -1,  363, 
      };
   }

}
