/* ***** BEGIN LICENSE BLOCK *****
 * Distributed under the BSD license:
 *
 * Copyright (c) 2012, Ajax.org B.V.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Ajax.org B.V. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL AJAX.ORG B.V. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ***** END LICENSE BLOCK ***** */

/* This file was autogenerated from clue.json (uuid: ) */
/****************************************************************************************
 * IT MIGHT NOT BE PERFECT ...But it's a good start from an existing *.tmlanguage file. *
 * fileTypes                                                                            *
 ****************************************************************************************/

"use strict";

var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;

var ClueHighlightRules = function () {
    // regexp must not have capturing parentheses. Use (?:) instead.
    // regexps are ordered -> the first match is used

    this.$rules = {
        start: [{
            token: [
                "keyword.control.directive.clue",
                "text",
                "text"
            ],
            regex: /(@version)( )(.+?(?=\n))/
        }, {
            token: ["keyword.control.macro.clue", "text", "text"],
            regex: /(@macro)( )([A-Za-z_][0-9A-Za-z_]*)/
        }, {
            token: [
                "keyword.control.import.clue",
                "text",
                "string"
            ],
            regex: /(@import)( )(".*")/
        }, {
            token: "meta.preprocessor.macro.invocation.clue",
            regex: /\$[A-Za-z_][0-9A-Za-z_]*!/
        }, {
            token: "keyword.control.directive.clue",
            regex: /@(?:(?:else_)?(?:ifos|iflua|ifdef|ifndef|ifcmp|ifos|iflua|ifdef|ifcmp|if)|else|define|macro|error|print)/
        }, {
            token: "constant.numeric.integer.hexadecimal.clue",
            regex: /\b0[xX][0-9A-Fa-f]+(?![pPeE.0-9])\b/

        }, {
            token: "constant.numeric.float.hexadecimal.clue",
            regex: /\b0[xX][0-9A-Fa-f]+(?:\.[0-9A-Fa-f]+)?(?:[eE]-?\d*)?(?:[pP][-+]\d+)?\b/
        }, {
            token: "constant.numeric.integer.clue",
            regex: /\b\d+(?![pPeE.0-9])/
        }, {
            token: "constant.numeric.float.clue",
            regex: /\b\d+(?:\.\d+)?(?:[eE]-?\d*)?/
        }, {
            token: "punctuation.definition.string.multilined.begin.clue",
            regex: /'/,
            push: [{
                token: "punctuation.definition.string.multilined.end.clue",
                regex: /'/,
                next: "pop"
            }, {
                include: "#escaped_char"
            }, {
                defaultToken: "string.quoted.single.clue"
            }]
        }, {
            token: "punctuation.definition.string.multilined.begin.clue",
            regex: /"/,
            push: [{
                token: "punctuation.definition.string.multilined.end.clue",
                regex: /"/,
                next: "pop"
            }, {
                include: "#escaped_char"
            }, {
                defaultToken: "string.quoted.double.clue"
            }]
        }, {
            token: "punctuation.definition.string.multilined.begin.clue",
            regex: /`/,
            push: [{
                token: "punctuation.definition.string.multilined.end.clue",
                regex: /`/,
                next: "pop"
            }, {
                include: "#escaped_char"
            }, {
                defaultToken: "string.multiline.clue"
            }]
        }, {
            token: "comment.line.double-dash.clue",
            regex: /\/\/.*/
        }, {
            token: "punctuation.definition.comment.begin.clue",
            regex: /\/\*/,
            push: [{
                token: "punctuation.definition.comment.end.clue",
                regex: /\*\//,
                next: "pop"
            }, {
                include: "#escaped_char"
            }, {
                defaultToken: "comment.block.clue"
            }]
        }, {
            token: "keyword.control.clue",
            regex: /\b(?:if|elseif|else|for|of|in|with|while|meta|until|fn|method|return|loop|enum|goto|continue|break|try|catch|match|default|macro)\b/
        }, {
            token: "keyword.scope.clue",
            regex: /\b(?:local|global|static)\b/
        }, {
            token: "constant.language.clue",
            regex: /\b(?:false|nil|true|_G|_VERSION|math\.(?:pi|huge))\b/
        }, {
            token: "constant.language.ellipsis.clue",
            regex: /\.{3}(?!\.)/
        }, {
            token: "keyword.operator.property.clue",
            regex: /\.|::/,
            next: "property_identifier"
        }, {
            token: "keyword.operator.clue",
            regex: /\/_|\&|\||\!|\~|\?|\$|@|\+|-|%|#|\*|\/|\^|==?|<=?|>=?|\.{2}|\?\?=?|(?:&&|\|\|)=?/
        }, {
            token: "variable.language.self.clue",
            regex: /\bself\b/
        }, {
            token: "support.function.any-method.clue",
            regex: /\b[a-zA-Z_][a-zA-Z0-9_]*\b(?=\(\s*)/
        }, {
            token: "variable.other.clue",
            regex: /[A-Za-z_][0-9A-Za-z_]*/
        }],
        "#escaped_char": [{
            token: "constant.character.escape.clue",
            regex: /\\[abfnrtvz\\"'$]/
        }, {
            token: "constant.character.escape.byte.clue",
            regex: /\\\d{1,3}/
        }, {
            token: "constant.character.escape.byte.clue",
            regex: /\\x[0-9A-Fa-f][0-9A-Fa-f]/
        }, {
            token: "constant.character.escape.unicode.clue",
            regex: /\\u\{[0-9A-Fa-f]+\}/
        }, {
            token: "invalid.illegal.character.escape.clue",
            regex: /\\./
        }],
        property_identifier: [{
            token: "variable.other.property.clue",
            regex: /[A-Za-z_][0-9A-Za-z_]*/,
            next: "start"
        }, {
            token: "",
            regex: "",
            next: "start"
        }],
    };

    this.normalizeRules();
};

ClueHighlightRules.metaData = {
    name: "Clue",
    scopeName: "source.clue"
};


oop.inherits(ClueHighlightRules, TextHighlightRules);

exports.ClueHighlightRules = ClueHighlightRules;
