# GraphQL Code Generation CLI Commands

This package contains standalone CLI commands for generating GraphQL-related code from schema files. These commands can
be used independently or integrated into custom build systems.

## Commands Overview

### KotlinGRTsGenerator

Generates **Kotlin source code** for GraphQL Runtime Types (GRTs) as an alternative to bytecode generation.

**Key Benefits:**

- Full IDE support (autocomplete, navigation, refactoring)
- Source-level debugging capabilities
- Easier code inspection and understanding
- Better integration with static analysis tools
- Compile-time verification of generated code

**Usage:**

```bash
java -cp $CLASSPATH viaduct.tenant.codegen.cli.KotlinGRTsGenerator \
  --output_archive build/generated/grt-sources.zip \
  --generated_directory build/tmp/kotlin-grt \
  --schema_files src/main/graphql/schema.graphql \
  --pkg_for_generated_classes com.mycompany.graphql.types
```

**Parameters:**

- `--output_archive` (required): ZIP file containing generated Kotlin source files
- `--generated_directory` (required): Temporary directory for generation (auto-cleaned)
- `--schema_files` (required): Comma-separated GraphQL schema files
- `--pkg_for_generated_classes`: Package for generated classes (default: com.airbnb.viaduct.schema.generated)

### SchemaObjectsBytecode

Generates **JVM bytecode** for GraphQL schema objects (GRTs) directly without intermediate source files.

**Key Benefits:**

- Faster build times (no source compilation step)
- Smaller build artifacts
- Runtime-only generation
- Supports parallel worker-based generation

**Usage:**

```bash
java -cp $CLASSPATH viaduct.tenant.codegen.cli.SchemaObjectsBytecode \
  --generated_directory build/tmp/bytecode-grt \
  --schema_files src/main/graphql/schema.graphql \
  --pkg_for_generated_classes com.mycompany.graphql.generated \
  --bytecode_worker_number 0 \
  --bytecode_worker_count 1
```

**Parameters:**

- `--generated_directory` (required): Directory where bytecode files are generated
- `--schema_files` (required): Comma-separated GraphQL schema files
- `--pkg_for_generated_classes` (required): Package for generated classes
- `--bytecode_worker_number` (required): Worker ID for parallel generation (0-based)
- `--bytecode_worker_count` (required): Total number of parallel workers
- `--output_archive`: Optional ZIP archive containing generated bytecode
- `--pkg_for_generated_classes_as_file`: Package specification via file instead of parameter
- `--module_name`: Optional module name for scoped generation
- `--applied_scopes`: Comma-separated scopes to filter generation
- `--include_ineligible_for_testing_only`: Include normally excluded types for testing
- `--compilation_schema`: Use specific compilation schema instead of source schemas

### ViaductGenerator

Generates **tenant-specific resolver code** including field resolvers, node resolvers, and module metadata for
multi-tenant GraphQL architectures.

**Key Benefits:**

- Tenant-scoped code generation with proper isolation
- Resolver implementations for GraphQL fields and nodes
- Module metadata and service registration
- Support for feature app testing scenarios

**Usage:**

```bash
java -cp $CLASSPATH viaduct.tenant.codegen.cli.ViaductGenerator \
  --tenant_pkg my_tenant \
  --modern_module_generated_directory build/tmp/modern-module \
  --metainf_generated_directory build/tmp/metainf \
  --resolver_generated_directory build/tmp/resolvers \
  --schema_files src/main/graphql/schema.graphql \
  --tenant_package_prefix com.mycompany.tenants
```

**Required Parameters:**

- `--tenant_pkg`: Tenant package identifier (e.g., "user_service")
- `--modern_module_generated_directory`: Directory for modern module code
- `--metainf_generated_directory`: Directory for metadata files
- `--resolver_generated_directory`: Directory for resolver implementations
- `--schema_files`: Comma-separated GraphQL schema files

**Optional Parameters:**

- `--modern_module_output_archive`: ZIP archive for modern module output
- `--metainf_output_archive`: ZIP archive for metadata output
- `--resolver_output_archive`: ZIP archive for resolver output
- `--tenant_package_prefix`: Base package prefix for tenant code
- `--tenant_package_prefix_in_file`: Package prefix read from file
- `--tenant_from_source_name_regex`: Regex for extracting tenant from source names
- `--isFeatureAppTest`: Enable feature app test mode generation

## Generated Output

### KotlinGRTsGenerator Output

The ZIP archive contains Kotlin source files with:

- **Data classes** for GraphQL object types
- **Sealed classes** for GraphQL union types
- **Enum classes** for GraphQL enums
- **Interface definitions** for GraphQL interfaces
- **Input classes** for GraphQL input types

### SchemaObjectsBytecode Output

The output contains JVM bytecode (.class files) for:

- GraphQL object type implementations
- GraphQL union type handlers
- GraphQL enum implementations
- GraphQL interface definitions
- GraphQL input type classes

### ViaductGenerator Output

#### Resolver Directory:

- Field resolver implementations for GraphQL fields
- Node resolver implementations for GraphQL nodes
- Tenant-specific resolver configuration

#### Modern Module Directory:

- Module definition and configuration files
- Tenant package structure
- Integration points with the Viaduct framework

#### Metainf Directory:

- META-INF service provider configuration
- Tenant registration metadata
- Package and module discovery information

## Advanced Features

### Parallel Generation (SchemaObjectsBytecode)

Support for worker-based parallel generation to improve performance on large schemas:

```bash
# Worker 1 of 4
--bytecode_worker_number 0 --bytecode_worker_count 4

# Worker 2 of 4
--bytecode_worker_number 1 --bytecode_worker_count 4

# etc...
```

- Each worker handles a subset of types based on worker number/count
- Results can be combined by your build system
- Significantly faster for complex schemas

### Scoped Generation (SchemaObjectsBytecode)

Filter generation based on applied scopes:

```bash
--applied_scopes scope1,scope2,scope3
```

Supports:

- Module-specific type generation
- Feature-flagged schema subsets
- Cross-module field exclusion control

## Source vs Bytecode Trade-offs

| Aspect         | Kotlin Source        | Bytecode             |
|----------------|----------------------|----------------------|
| IDE Support    | Full support         | Limited              |
| Debugging      | Source-level         | Runtime only         |
| Build Time     | Slower (compilation) | Faster               |
| Inspection     | Easy                 | Requires decompiling |
| Analysis Tools | Full support         | Limited              |
| Artifact Size  | Larger               | Smaller              |
