# flake8: noqa
from langchain.prompts.prompt import PromptTemplate

_DEFAULT_ENTITY_SUMMARIZATION_TEMPLATE = """Ты - AI-ассистент, помогающий человеку отслеживать факты о релевантных людях, местах и концепциях в их жизни. Обнови резюме предоставленной сущности в разделе "Сущность" на основе последней строки твоего разговора с человеком. Если ты пишешь резюме в первый раз, верни одно предложение.
Обновление должно включать только факты, которые передаются в последней строке разговора о предоставленной сущности, и должно содержать только факты о предоставленной сущности.

Если нет новой информации о предоставленной сущности или информация не стоит отмечать (не важный или релевантный факт для долгосрочного запоминания), верни существующее резюме без изменений.

Полная история разговора (для контекста):
{history}

Сущность для резюме:
{entity}

Существующее резюме {entity}:
{summary}

Последняя строка разговора:
Человек: {input}
Обновленное резюме:"""

ENTITY_SUMMARIZATION_PROMPT = PromptTemplate(
    input_variables=["entity", "summary", "history", "input"],
    template=_DEFAULT_ENTITY_SUMMARIZATION_TEMPLATE,
)
