# flake8: noqa
from langchain.prompts import PromptTemplate

template = """Ты учитель, проверяющий тест.
Тебе дан вопрос, ответ ученика и правильный ответ, и тебе нужно оценить ответ ученика как ПРАВИЛЬНЫЙ или НЕПРАВИЛЬНЫЙ.

Пример формата:
ВОПРОС: вопрос здесь
ОТВЕТ УЧЕНИКА: ответ ученика здесь
ПРАВИЛЬНЫЙ ОТВЕТ: правильный ответ здесь
ОЦЕНКА: ПРАВИЛЬНЫЙ или НЕПРАВИЛЬНЫЙ здесь

Оценивай ответы учеников ТОЛЬКО на основе их фактической точности. Игнорируй различия в пунктуации и формулировках между ответом ученика и правильным ответом. Это нормально, если ответ ученика содержит больше информации, чем правильный ответ, при условии, что он не содержит противоречивых утверждений. Начни! 

ВОПРОС: {query}
ОТВЕТ УЧЕНИКА: {result}
ПРАВИЛЬНЫЙ ОТВЕТ: {answer}
ОЦЕНКА:"""
PROMPT = PromptTemplate(
    input_variables=["query", "result", "answer"], template=template
)

context_template = """Ты учитель, проверяющий тест.
Тебе дан вопрос, контекст, к которому относится вопрос, и ответ ученика. Тебе нужно оценить ответ ученика как ПРАВИЛЬНЫЙ или НЕПРАВИЛЬНЫЙ, исходя из контекста.

Пример формата:
ВОПРОС: вопрос здесь
КОНТЕКСТ: контекст, к которому относится вопрос, здесь
ОТВЕТ УЧЕНИКА: ответ ученика здесь
ОЦЕНКА: ПРАВИЛЬНЫЙ или НЕПРАВИЛЬНЫЙ здесь

Оценивай ответы учеников ТОЛЬКО на основе их фактической точности. Игнорируй различия в пунктуации и формулировках между ответом ученика и правильным ответом. Это нормально, если ответ ученика содержит больше информации, чем правильный ответ, при условии, что он не содержит противоречивых утверждений. Начни! 

ВОПРОС: {query}
КОНТЕКСТ: {context}
ОТВЕТ УЧЕНИКА: {result}
ОЦЕНКА:"""
CONTEXT_PROMPT = PromptTemplate(
    input_variables=["query", "context", "result"], template=context_template
)


cot_template = """Ты учитель, проверяющий тест.
Тебе дан вопрос, контекст, к которому относится вопрос, и ответ ученика. Тебе нужно оценить ответ ученика как ПРАВИЛЬНЫЙ или НЕПРАВИЛЬНЫЙ, исходя из контекста.
Опиши пошагово свое рассуждение, чтобы убедиться, что твой вывод верен. Избегай простого указания правильного ответа сразу.

Пример формата:
ВОПРОС: вопрос здесь
КОНТЕКСТ: контекст, к которому относится вопрос, здесь
ОТВЕТ УЧЕНИКА: ответ ученика здесь
ОБЪЯСНЕНИЕ: пошаговое рассуждение здесь
ОЦЕНКА: ПРАВИЛЬНЫЙ или НЕПРАВИЛЬНЫЙ здесь

Оценивай ответы учеников ТОЛЬКО на основе их фактической точности. Игнорируй различия в пунктуации и формулировках между ответом ученика и правильным ответом. Это нормально, если ответ ученика содержит больше информации, чем правильный ответ, при условии, что он не содержит противоречивых утверждений. Начни! 

ВОПРОС: {query}
КОНТЕКСТ: {context}
ОТВЕТ УЧЕНИКА: {result}
ОБЪЯСНЕНИЕ:"""
COT_PROMPT = PromptTemplate(
    input_variables=["query", "context", "result"], template=cot_template
)


template = """Ты сравниваешь представленный ответ с ответом эксперта на заданный вопрос по SQL. Вот данные:
[НАЧАЛО ДАННЫХ]
***
[Вопрос]: {query}
***
[Эксперт]: {answer}
***
[Ответ]: {result}
***
[КОНЕЦ ДАННЫХ]
Сравни содержание и правильность представленного SQL с ответом эксперта. Игнорируй любые различия в пробелах, стиле или именах столбцов вывода. Представленный ответ может быть либо правильным, либо неправильным. Определи, какой случай применим. Сначала подробно объясни сходства или различия между ответом эксперта и представленным ответом, игнорируя поверхностные аспекты, такие как пробелы, стиль или имена столбцов вывода. Не указывай окончательный ответ в своем первоначальном объяснении. Затем ответь либо "ПРАВИЛЬНЫЙ", либо "НЕПРАВИЛЬНЫЙ" (без кавычек или знаков препинания) на отдельной строке. Это должно соответствовать тому, являются ли представленный SQL и ответ эксперта семантически одинаковыми или различными. Затем повтори свой окончательный ответ на новой строке."""

SQL_PROMPT = PromptTemplate(
    input_variables=["query", "answer", "result"], template=template
)
