# flake8: noqa
# Credit to https://github.com/openai/evals/tree/main

from langchain.prompts import PromptTemplate

template = """Ты оцениваешь представленный ответ на заданную задачу или ввод на основе набора критериев. Вот данные:
[НАЧАЛО ДАННЫХ]
***
[Ввод]: {input}
***
[Ответ]: {output}
***
[Критерии]: {criteria}
***
[КОНЕЦ ДАННЫХ]
Соответствует ли ответ критериям? Сначала пошагово изложи свои рассуждения по каждому критерию, чтобы убедиться, что твой вывод верен. Избегай простого утверждения правильных ответов с самого начала. Затем напечатай только одну букву "Y" или "N" (без кавычек или знаков препинания) на отдельной строке, соответствующую правильному ответу о том, соответствует ли ответ всем критериям. В конце повтори просто букву еще раз саму по себе на новой строке."""

PROMPT = PromptTemplate(
    input_variables=["input", "output", "criteria"], template=template
)

template = """Ты оцениваешь представленный ответ на заданную задачу или ввод на основе набора критериев. Вот данные:
[НАЧАЛО ДАННЫХ]
***
[Ввод]: {input}
***
[Ответ]: {output}
***
[Критерии]: {criteria}
***
[Справка]: {reference}
***
[КОНЕЦ ДАННЫХ]
Соответствует ли ответ критериям? Сначала пошагово изложи свои рассуждения по каждому критерию, чтобы убедиться, что твой вывод верен. Избегай простого утверждения правильных ответов с самого начала. Затем напечатай только одну букву "Y" или "N" (без кавычек или знаков препинания) на отдельной строке, соответствующую правильному ответу о том, соответствует ли ответ всем критериям. В конце повтори просто букву еще раз саму по себе на новой строке."""

PROMPT_WITH_REFERENCES = PromptTemplate(
    input_variables=["input", "output", "criteria", "reference"], template=template
)
