"""Prompt for trajectory evaluation chain."""
# flake8: noqa
from langchain.schema.messages import HumanMessage, AIMessage, SystemMessage

from langchain.prompts.chat import (
    ChatPromptTemplate,
    HumanMessagePromptTemplate,
)


EVAL_TEMPLATE = """Языковая модель AI получила доступ к следующему набору инструментов, чтобы помочь ответить на вопрос пользователя.

Инструменты, предоставленные модели AI:
[TOOL_DESCRIPTIONS]
{tool_descriptions}
[END_TOOL_DESCRIPTIONS]

Вопрос, который человек задал модели AI:
[QUESTION]
{question}
[END_QUESTION]{reference}

Языковая модель AI решила использовать следующий набор инструментов для ответа на вопрос:
[AGENT_TRAJECTORY]
{agent_trajectory}
[END_AGENT_TRAJECTORY]

Окончательный ответ языковой модели AI на вопрос был:
[RESPONSE]
{answer}
[END_RESPONSE]

Давай проведем подробную оценку ответа языковой модели AI шаг за шагом.

Мы учитываем следующие критерии перед тем, как дать оценку от 1 до 5:

i. Полезен ли окончательный ответ?
ii. Использует ли AI логическую последовательность инструментов для ответа на вопрос?
iii. Использует ли модель языка AI инструменты полезным образом?
iv. Использует ли модель языка AI слишком много шагов для ответа на вопрос?
v. Используются ли подходящие инструменты для ответа на вопрос?"""

EXAMPLE_INPUT = """Языковая модель AI получила доступ к следующему набору инструментов, чтобы помочь ответить на вопрос пользователя.

Инструменты, предоставленные модели AI:
[TOOL_DESCRIPTIONS]
Инструмент 1:
Название: Поиск
Описание: полезно, когда нужно задать вопрос с поиском

Инструмент 2:
Название: Поиск
Описание: полезно, когда нужно задать вопрос с поиском

Инструмент 3:
Название: Калькулятор
Описание: полезно для выполнения расчетов

Инструмент 4:
Название: Поиск в Интернете (SerpAPI)
Описание: полезно, когда нужно ответить на вопросы о текущих событиях
[END_TOOL_DESCRIPTIONS]

Вопрос, который человек задал модели AI: Если положить Статую Свободы вдоль, сколько раз она протянется через Соединенные Штаты?

Языковая модель AI решила использовать следующий набор инструментов для ответа на вопрос:
[AGENT_TRAJECTORY]
Шаг 1:
Используемый инструмент: Поиск в Интернете (SerpAPI)
Ввод инструмента: Если положить Статую Свободы вдоль, сколько раз она протянется через Соединенные Штаты?
Выход инструмента: Статуя Свободы была подарена Соединенным Штатам Францией в знак дружбы между двумя странами. Она была воздвигнута на американском проекте ...
[END_AGENT_TRAJECTORY]

[RESPONSE]
Окончательный ответ языковой модели AI на вопрос был: Есть разные способы измерить длину Соединенных Штатов, но если мы используем расстояние между Статуей Свободы и самой западной точкой континентальных Соединенных Штатов (мыс Алава, Вашингтон), которое составляет примерно 2,857 миль (4,596 км), и предположим, что Статуя Свободы имеет высоту 305 футов (93 метра), то статуя протянется через Соединенные Штаты примерно 17,5 раз, если положить ее вдоль.
[END_RESPONSE]

Давай проведем подробную оценку ответа языковой модели AI шаг за шагом.

Мы учитываем следующие критерии перед тем, как дать оценку от 1 до 5:

i. Полезен ли окончательный ответ?
ii. Использует ли AI логическую последовательность инструментов для ответа на вопрос?
iii. Использует ли модель языка AI инструменты полезным образом?
iv. Использует ли модель языка AI слишком много шагов для ответа на вопрос?
v. Используются ли подходящие инструменты для ответа на вопрос?"""

EXAMPLE_OUTPUT = """Во-первых, давайте оценим окончательный ответ. Окончательный ответ использует хорошее обоснование, но неверен. 2,857 деленное на 305 не равно 17,5.\
Модель должна была использовать калькулятор, чтобы выяснить это. Во-вторых, использует ли модель логическую последовательность инструментов для ответа на вопрос?\
Способ использования поиска моделью не полезен. Модель должна была использовать инструмент поиска, чтобы узнать ширину США или высоту статуи.\
Модель не использовала инструмент калькулятора и дала неверный ответ. Поисковый API должен использоваться для текущих событий или конкретных вопросов.\
Инструменты не использовались полезным образом. Модель не использовала слишком много шагов для ответа на вопрос.\
Модель не использовала подходящие инструменты для ответа на вопрос.\
    
Оценка: Учитывая хорошее обоснование в окончательном ответе, но в остальном слабую работу, мы даем модели оценку 2.

Оценка: 2"""

EVAL_CHAT_PROMPT = ChatPromptTemplate.from_messages(
    messages=[
        SystemMessage(
            content="Ты полезный помощник, который оценивает языковые модели."
        ),
        HumanMessage(content=EXAMPLE_INPUT),
        AIMessage(content=EXAMPLE_OUTPUT),
        HumanMessagePromptTemplate.from_template(EVAL_TEMPLATE),
    ]
)


TOOL_FREE_EVAL_TEMPLATE = """Языковая модель AI получила доступ к набору инструментов, чтобы помочь ответить на вопрос пользователя.

Вопрос, который человек задал модели AI:
[QUESTION]
{question}
[END_QUESTION]{reference}

Языковая модель AI решила использовать следующий набор инструментов для ответа на вопрос:
[AGENT_TRAJECTORY]
{agent_trajectory}
[END_AGENT_TRAJECTORY]

Окончательный ответ языковой модели AI на вопрос был:
[RESPONSE]
{answer}
[END_RESPONSE]

Давай проведем подробную оценку ответа языковой модели AI шаг за шагом.

Мы учитываем следующие критерии перед тем, как дать оценку от 1 до 5:

i. Полезен ли окончательный ответ?
ii. Использует ли AI логическую последовательность инструментов для ответа на вопрос?
iii. Использует ли модель языка AI инструменты полезным образом?
iv. Использует ли модель языка AI слишком много шагов для ответа на вопрос?
v. Используются ли подходящие инструменты для ответа на вопрос?"""


TOOL_FREE_EVAL_CHAT_PROMPT = ChatPromptTemplate.from_messages(
    messages=[
        SystemMessage(
            content="Ты полезный помощник, который оценивает языковые модели."
        ),
        HumanMessage(content=EXAMPLE_INPUT),
        AIMessage(content=EXAMPLE_OUTPUT),
        HumanMessagePromptTemplate.from_template(TOOL_FREE_EVAL_TEMPLATE),
    ]
)
