# flake8: noqa
from langchain.prompts import PromptTemplate

question_prompt_template = """Используй следующий фрагмент длинного документа, чтобы увидеть, содержит ли текст информацию, относящуюся к ответу на вопрос. 
Верни любой релевантный текст дословно.
{context}
Вопрос: {question}
Релевантный текст, если таковой имеется:"""
QUESTION_PROMPT = PromptTemplate(
    template=question_prompt_template, input_variables=["context", "question"]
)

combine_prompt_template = """Учитывая следующие извлеченные части длинного документа и вопрос, создай окончательный ответ с ссылками ("ИСТОЧНИКИ"). 
Если ты не знаешь ответа, просто скажи, что не знаешь. Не пытайся выдумать ответ.
ВСЕГДА возвращай часть "ИСТОЧНИКИ" в своем ответе.

ВОПРОС: Какое государственное/страновое законодательство регулирует толкование контракта?
=========
Содержание: Это Соглашение регулируется английским законодательством, и стороны подчиняются исключительной юрисдикции английских судов в отношении любого спора (контрактного или внеконтрактного) по данному Соглашению, за исключением того, что любая из сторон может обратиться в любой суд за получением судебного запрета или иного средства защиты своих прав интеллектуальной собственности.
Источник: 28-pl
Содержание: Неотзыв. Несоблюдение или задержка в осуществлении любого права или средства правовой защиты по данному Соглашению не составляет отказа от такого (или любого другого) права или средства правовой защиты.\n\n11.7 Разделимость. Недействительность, незаконность или неосуществимость любого условия (или его части) данного Соглашения не влияет на продолжение действия остатка условия (если таковой имеется) и данного Соглашения.\n\n11.8 Нет агентства. За исключением случаев, прямо указанных в противном случае, ничто в данном Соглашении не создает агентства, партнерства или совместного предприятия любого рода между сторонами.\n\n11.9 Нет третьих лиц-бенефициаров.
Источник: 30-pl
Содержание: (b) если Google верит, в доброй вере, что Дистрибьютор нарушил или заставил Google нарушить любые Антикоррупционные законы (как определено в пункте 8.5) или что такое нарушение вполне вероятно,
Источник: 4-pl
=========
ОКОНЧАТЕЛЬНЫЙ ОТВЕТ: Это Соглашение регулируется английским законодательством.
ИСТОЧНИКИ: 28-pl

ВОПРОС: {question}
=========
{summaries}
=========
ОКОНЧАТЕЛЬНЫЙ ОТВЕТ:"""
COMBINE_PROMPT = PromptTemplate(
    template=combine_prompt_template, input_variables=["summaries", "question"]
)

EXAMPLE_PROMPT = PromptTemplate(
    template="Содержание: {page_content}\nИсточник: {source}",
    input_variables=["page_content", "source"],
)
