# flake8: noqa
from langchain.prompts.prompt import PromptTemplate

EXAMPLES = [
    """Настройка: Ты сейчас играешь в быстрый раунд TextWorld! Вот твоя задача на
сегодня. Прежде всего, ты можешь, например, попробовать отправиться на восток. После этого, возьми
папку из шкафчика. С папкой, положи папку на каминную полку.
Хорошо, спасибо!

-= Хранилище =-
Ты только что вошел в хранилище. Ты начинаешь оценивать, что здесь есть.

Здесь есть открытый сейф. Какое разочарование! Сейф пуст! Ты разглядываешь полку.
Но на ней ничего нет. Что, ты думаешь, что в TextWorld
должны быть вещи?

Тебе не нравятся двери? Почему бы тебе не попробовать пойти на восток, этот вход не охраняется.

Мысль: Мне нужно отправиться на восток
Действие: Играть[идти на восток]
Наблюдение: -= Офис =-
Ты прибываешь в офис. Обычный.

Ты можешь разглядеть шкафчик. В шкафчике есть папка. Ты видишь чемодан. Чемодан
пуст, какой ужасный день! Ты прислоняешься к стене, случайно нажимая на секретную кнопку. Стена открывается, открывая каминную полку. Ты задумчиво спрашиваешься, кто оставил это здесь. Каминная полка стандартная. Каминная полка, похоже, пуста. Если ты еще не заметил, кажется, что у стены есть что-то, это стол. К сожалению, на нем ничего нет. Хм. Ну да ладно
Есть выход на запад. Не волнуйся, он не охраняется.

Мысль: Мне нужно взять папку из шкафчика
Действие: Играть[взять папку]
Наблюдение: Ты берешь папку из шкафчика.

Мысль: Мне нужно положить папку на каминную полку
Действие: Играть[положить папку на каминную полку]

Наблюдение: Ты кладешь папку на каминную полку.
Твой счет только что увеличился на одно очко.
*** Конец ***
Мысль: Произошел Конец
Действие: Закончить[да]

"""
]
SUFFIX = """\n\nНастройка: {input}
{agent_scratchpad}"""

TEXTWORLD_PROMPT = PromptTemplate.from_examples(
    EXAMPLES, SUFFIX, ["input", "agent_scratchpad"]
)
