# Examples

This webpage contains the notebook examples for the `aeon` library. The examples are
organised into categories based on module and functionality. The examples are designed
to provide a comprehensive overview of a module, functionality or a specific algorithm.

## Forecasting

::::{grid} 2 3 4 4
:gutter: 1

:::{grid-item-card}
:img-top: /examples/forecasting/img/forecasting.png
:class-img-top: aeon-card-image-m
:link: /examples/forecasting/forecasting.ipynb
:link-type: ref
:text-align: center

Overview of forecasting

:::

:::{grid-item-card}
:img-top: examples/forecasting/img/proba.png
:class-img-top: aeon-card-image-m
:link: /examples/forecasting/forecasting_proba.ipynb
:link-type: ref
:text-align: center

Probabilistic forecasting

:::

:::{grid-item-card}
:img-top: examples/forecasting/img/hierarchytree_grouped.png
:class-img-top: aeon-card-image-m
:link: /examples/forecasting/forecasting_hierarchical_global.ipynb
:link-type: ref
:text-align: center

Hierarchical, global, and panel forecasting

:::

:::{grid-item-card}
:img-top: examples/forecasting/img/forecasting-to-regression-reduction.png
:class-img-top: aeon-card-image-m
:link: /examples/forecasting/forecasting_sklearn.ipynb
:link-type: ref
:text-align: center

Forecasting with aeon and scikit-learn

:::

:::{grid-item-card}
:img-top: examples/forecasting/img/splitter.png
:class-img-top: aeon-card-image-m
:link: /examples/forecasting/window_splitters.ipynb
:link-type: ref
:text-align: center

Window splitters for forecasting

:::

::::

## Classification

::::{grid} 2 3 4 4
:gutter: 1

:::{grid-item-card}
:img-top: examples/classification/img/tsc.png
:class-img-top: aeon-card-image-m
:link: /examples/classification/classification.ipynb
:link-type: ref
:text-align: center

Overview of Time Series Classification (TSC)

:::

:::{grid-item-card}
:img-top: examples/classification/img/convolution.png
:class-img-top: aeon-card-image-m
:link: /examples/classification/convolution_based.ipynb
:link-type: ref
:text-align: center

Convolution based TSC

:::

:::{grid-item-card}
:img-top: examples/classification/img/it.png
:class-img-top: aeon-card-image-m
:link: /examples/classification/deep_learning.ipynb
:link-type: ref
:text-align: center
Deep learning based TSC

:::

:::{grid-item-card}
:img-top: examples/classification/img/hist.png
:class-img-top: aeon-card-image-m
:link: /examples/classification/dictionary_based.ipynb
:link-type: ref
:text-align: center

Dictionary based TSC

:::

:::{grid-item-card}
:img-top: examples/classification/img/dtw.png
:class-img-top: aeon-card-image-m
:link: /examples/classification/distance_based.ipynb
:link-type: ref
:text-align: center

Distance based TSC

:::

:::{grid-item-card}
:img-top: examples/classification/img/pipeline.png
:class-img-top: aeon-card-image-m
:link: /examples/classification/feature_based.ipynb
:link-type: ref
:text-align: center

Feature based TSC

:::

:::{grid-item-card}
:img-top: examples/classification/img/hc2.png
:class-img-top: aeon-card-image-m
:link: /examples/classification/hybrid.ipynb
:link-type: ref
:text-align: center

Hybrid TSC

:::

:::{grid-item-card}
:img-top: examples/classification/img/interval.png
:class-img-top: aeon-card-image-m
:link: /examples/classification/interval_based.ipynb
:link-type: ref
:text-align: center

Interval based TSC

:::

:::{grid-item-card}
:img-top: examples/classification/img/shapelet.png
:class-img-top: aeon-card-image-m
:link: /examples/classification/shapelet_based.ipynb
:link-type: ref
:text-align: center

Shapelet based TSC

:::

:::{grid-item-card}
:img-top: images/logo/aeon-logo-blue-2-transparent.png
:class-img-top: aeon-card-image-m
:link: /examples/classification/early_classification.ipynb
:link-type: ref
:text-align: center

Early TSC

:::

::::

## Regression

::::{grid} 2 3 4 4
:gutter: 1

:::{grid-item-card}
:img-top: /examples/regression/img/tser.png
:class-img-top: aeon-card-image-m
:link: /examples/regression/regression.ipynb
:link-type: ref
:text-align: center

Overview of Time Series Regression (TSR)

:::

::::

## Clustering

::::{grid} 2 3 4 4
:gutter: 1

:::{grid-item-card}
:img-top: examples/clustering/img/tscl.png
:class-img-top: aeon-card-image-m
:link: /examples/clustering/clustering.ipynb
:link-type: ref
:text-align: center

Overview of Time Series Clustering (TSCL)

:::

:::{grid-item-card}
:img-top: images/logo/aeon-logo-blue-2-transparent.png
:class-img-top: aeon-card-image-m
:link: /examples/clustering/partitional_clustering.ipynb
:link-type: ref
:text-align: center

Partitional TSCL

:::

::::

## Transformation

::::{grid} 2 3 4 4
:gutter: 1

:::{grid-item-card}
:img-top: examples/transformations/img/transformations.png
:class-img-top: aeon-card-image-m
:link: /examples/transformations/transformations.ipynb
:link-type: ref
:text-align: center

Overview of Transformations

:::

:::{grid-item-card}
:img-top: examples/transformations/img/tsfresh.png
:class-img-top: aeon-card-image-m
:link: /examples/transformations/feature_extraction_with_tsfresh.ipynb
:link-type: ref
:text-align: center

TSFresh transform

:::

:::{grid-item-card}
:img-top: images/logo/aeon-logo-blue-2-transparent.png
:class-img-top: aeon-card-image-m
:link: /examples/transformations/catch22.ipynb
:link-type: ref
:text-align: center

Catch22 transform

:::

:::{grid-item-card}
:img-top: examples/transformations/img/rocket.png
:class-img-top: aeon-card-image-m
:link: /examples/transformations/rocket.ipynb
:link-type: ref
:text-align: center

Rocket transform

:::

:::{grid-item-card}
:img-top: images/logo/aeon-logo-blue-2-transparent.png
:class-img-top: aeon-card-image-m
:link: /examples/transformations/minirocket.ipynb
:link-type: ref
:text-align: center

MiniRocket transform

:::

:::{grid-item-card}
:img-top: images/logo/aeon-logo-blue-2-transparent.png
:class-img-top: aeon-card-image-m
:link: /examples/transformations/sast.ipynb
:link-type: ref
:text-align: center

SAST transform

:::

:::{grid-item-card}
:img-top: examples/transformations/img/interpolation.png
:class-img-top: aeon-card-image-m
:link: /examples/transformations/interpolation.ipynb
:link-type: ref
:text-align: center

Interpolation

:::

:::{grid-item-card}
:img-top: examples/transformations/img/signature.png
:class-img-top: aeon-card-image-m
:link: /examples/transformations/signature_method.ipynb
:link-type: ref
:text-align: center

Signature method

:::

:::{grid-item-card}
:img-top: examples/transformations/img/theta.png
:class-img-top: aeon-card-image-m
:link: /examples/transformations/theta_transform.ipynb
:link-type: ref
:text-align: center

Theta transform

:::

::::

## Segmentation

::::{grid} 2 3 4 4
:gutter: 1

:::{grid-item-card}
:img-top: examples/segmentation/img/segmentation.png
:class-img-top: aeon-card-image-m
:link: /examples/segmentation/segmentation.ipynb
:link-type: ref
:text-align: center

Intro to segmentation

:::

:::{grid-item-card}
:img-top: examples/segmentation/img/clasp.png
:class-img-top: aeon-card-image-m
:link: /examples/segmentation/segmentation_with_clasp.ipynb
:link-type: ref
:text-align: center

ClaSP segmentation

:::

:::{grid-item-card}
:img-top: images/logo/aeon-logo-blue-2-transparent.png
:class-img-top: aeon-card-image-m
:link: /examples/segmentation/hidalgo_segmentation.ipynb
:link-type: ref
:text-align: center

Hidalgo segmentation

:::


::::


## Distances

::::{grid} 2 3 4 4
:gutter: 1

:::{grid-item-card}
:img-top: examples/distances/img/distances.png
:class-img-top: aeon-card-image-m
:link: /examples/distances/distances.ipynb
:link-type: ref
:text-align: center

Distance functions

:::


:::{grid-item-card}
:img-top: examples/distances/img/svm.png
:class-img-top: aeon-card-image-m
:link: /examples/distances/sklearn_distances.ipynb
:link-type: ref
:text-align: center

Using aeon distances with scikit-learn

::::

## Similarity search

::::{grid} 2 3 4 4
:gutter: 1


:::{grid-item-card}
:img-top: images/logo/aeon-logo-blue-2-transparent.png
:class-img-top: aeon-card-image-m
:link: /examples/similarity_search/similarity_search.ipynb
:link-type: ref
:text-align: center

Intro to similarity search

:::

:::{grid-item-card}
:img-top: images/logo/aeon-logo-blue-2-transparent.png
:class-img-top: aeon-card-image-m
:link: /examples/similarity_search/distance_profiles.ipynb
:link-type: ref
:text-align: center

Deep dive into distance profiles

:::

:::{grid-item-card}
:img-top: images/logo/aeon-logo-blue-2-transparent.png
:class-img-top: aeon-card-image-m
:link: /examples/similarity_search/code_speed.ipynb
:link-type: ref
:text-align: center

Benchmarking of similarity search speed-ups

:::


::::


## Data Formatting and Loading

::::{grid} 2 3 4 4
:gutter: 1

:::{grid-item-card}
:img-top: examples/datasets/img/data.png
:class-img-top: aeon-card-image-m
:link: /examples/datasets/datasets.ipynb
:link-type: ref
:text-align: center

Data in aeon

:::

:::{grid-item-card}
:img-top: images/logo/aeon-logo-blue-2-transparent.png
:class-img-top: aeon-card-image-m
:link: /examples/datasets/data_structures.ipynb
:link-type: ref
:text-align: center

Data structures and containers used in aeon

:::

:::{grid-item-card}
:img-top: images/logo/aeon-logo-blue-2-transparent.png
:class-img-top: aeon-card-image-m
:link: /examples/datasets/data_conversions.ipynb
:link-type: ref
:text-align: center

Conversions between data structures

:::

:::{grid-item-card}
:img-top: images/logo/aeon-logo-blue-2-transparent.png
:class-img-top: aeon-card-image-m
:link: /examples/datasets/data_loading.ipynb
:link-type: ref
:text-align: center

How series are stored in file and loaded into memory

:::

:::{grid-item-card}
:img-top: images/logo/aeon-logo-blue-2-transparent.png
:class-img-top: aeon-card-image-m
:link: /examples/datasets/provided_data.ipynb
:link-type: ref
:text-align: center

Example data sets

:::

:::

:::{grid-item-card}
:img-top: images/logo/aeon-logo-blue-2-transparent.png
:class-img-top: aeon-card-image-m
:link: /examples/datasets/load_data_from_web.ipynb
:link-type: ref
:text-align: center

Loading data from the web

:::

:::{grid-item-card}
:img-top: images/logo/aeon-logo-blue-2-transparent.png
:class-img-top: aeon-card-image-m
:link: /examples/datasets/data_unequal.ipynb
:link-type: ref
:text-align: center

Unequal length series

:::


::::

## Benchmarking

::::{grid} 2 3 4 4
:gutter: 1

:::{grid-item-card}
:img-top: images/logo/aeon-logo-blue-2-transparent.png
:class-img-top: aeon-card-image-m
:link: /examples/benchmarking/benchmarking.ipynb
:link-type: ref
:text-align: center

Benchmarking algorithms

:::

:::{grid-item-card}
:img-top: images/logo/aeon-logo-blue-2-transparent.png
:class-img-top: aeon-card-image-m
:link: /examples/benchmarking/forecasting.ipynb
:link-type: ref
:text-align: center

Benchmarking forecasting algorithms

:::

:::{grid-item-card}
:img-top: images/logo/aeon-logo-blue-2-transparent.png
:class-img-top: aeon-card-image-m
:link: /examples/benchmarking/regression.ipynb
:link-type: ref
:text-align: center

Benchmarking extrinsic regression algorithms

:::

:::{grid-item-card}
:img-top: images/logo/aeon-logo-blue-2-transparent.png
:class-img-top: aeon-card-image-m
:link: /examples/benchmarking/regression_results_per_dataset.ipynb
:link-type: ref
:text-align: center

Compare regression algorithms on a single dataset

:::

:::{grid-item-card}
:img-top: images/logo/aeon-logo-blue-2-transparent.png
:class-img-top: aeon-card-image-m
:link: /examples/benchmarking/reference_results.ipynb
:link-type: ref
:text-align: center

Getting estimator reference results

:::

:::{grid-item-card}
:img-top: images/logo/aeon-logo-blue-2-transparent.png
:class-img-top: aeon-card-image-m
:link: /examples/benchmarking/bakeoff_results.ipynb
:link-type: ref
:text-align: center

Getting published bakeoff results

:::

::::

## Base

::::{grid} 2 3 4 4
:gutter: 1

:::{grid-item-card}
:img-top: images/logo/aeon-logo-blue-2-transparent.png
:class-img-top: aeon-card-image-m
:link: /examples/base/base_classes.ipynb
:link-type: ref
:text-align: center

`aeon` base classes

:::

:::{grid-item-card}
:img-top: images/logo/aeon-logo-blue-2-transparent.png
:class-img-top: aeon-card-image-m
:link: /examples/base/series_estimator.ipynb
:link-type: ref
:text-align: center

Series base classes

:::

::::

## Utils

::::{grid} 2 3 4 4
:gutter: 1

:::{grid-item-card}
:img-top: images/logo/aeon-logo-blue-2-transparent.png
:class-img-top: aeon-card-image-m
:link: /examples/utils/preprocessing.ipynb
:link-type: ref
:text-align: center

Preprocessing collections of time series

:::

::::