# Developer Guide

Welcome to the `aeon` developer guide. This guide is intended for new developers and
current developers who want to learn about specific topics for code and non-code
developments.

For a step-by-step guide for setting up a development version of `aeon`
and creating a pull request, see the [contributing guide](contributing.md). At any point
during the process, feel free to post questions on Slack or ask [core developers](./about.md#core-developers)
for help.

`aeon` aims to follow the `scikit-learn` API and conventions whenever possible. If
you’re new to `scikit-learn`, take a look at their [getting-started guide](https://scikit-learn.org/stable/getting_started.html).
If you’re already familiar with `scikit-learn`, you may still learn something new from
their [developer's guide](https://scikit-learn.org/stable/developers/index.html).

::::{grid} 1 2 3 3
:gutter: 3

:::{grid-item-card}
:text-align: center

Adding Estimators

^^^

A guide to creating new `aeon` estimators.

+++

```{button-ref} developer_guide/add_estimators
:color: primary
:click-parent:
:expand:

Adding Estimators
```

:::

:::{grid-item-card}
:text-align: center

AEP's

^^^

Writing `aeon` Enhancement Proposals (AEP).

+++

```{button-ref} developer_guide/aep
:color: primary
:click-parent:
:expand:

AEP's
```

:::

:::{grid-item-card}
:text-align: center

Coding Standards

^^^

Coding standards for the `aeon` code base.

+++

```{button-ref} developer_guide/coding_standards
:color: primary
:click-parent:
:expand:

Coding Standards
```

:::

:::{grid-item-card}
:text-align: center

CI/CD

^^^

A description of the `aeon` CI/CD pipeline.

+++

```{button-ref} developer_guide/continuous_integration
:color: primary
:click-parent:
:expand:

CI/CD
```

:::

:::{grid-item-card}
:text-align: center

Dependencies

^^^

A guide to the types of `aeon` dependencies.

+++

```{button-ref} developer_guide/dependencies
:color: primary
:click-parent:
:expand:

Dependencies
```

:::

:::{grid-item-card}
:text-align: center

Deprecation

^^^

Deprecation policy for `aeon`.

+++

```{button-ref} developer_guide/deprecation
:color: primary
:click-parent:
:expand:

Deprecation
```

:::

:::{grid-item-card}
:text-align: center

Developer Installation

^^^

A guide to installing `aeon` for development.

+++

```{button-ref} developer_guide/dev_installation
:color: primary
:click-parent:
:expand:

Developer Installation
```

:::

:::{grid-item-card}
:text-align: center

Documentation

^^^

A guide to writing `aeon` documentation and docstrings.

+++

```{button-ref} developer_guide/documentation
:color: primary
:click-parent:
:expand:

Documentation
```

:::

:::{grid-item-card}
:text-align: center

Release

^^^

The `aeon` release process.

+++

```{button-ref} developer_guide/release
:color: primary
:click-parent:
:expand:

Release
```

:::

:::{grid-item-card}
:text-align: center

Testing

^^^

The `aeon` testing framework.

+++

```{button-ref} developer_guide/testing
:color: primary
:click-parent:
:expand:

Testing
```

:::

::::

```{toctree}
:hidden:

developer_guide/add_estimators.md
developer_guide/aep.md
developer_guide/coding_standards.md
developer_guide/continuous_integration.md
developer_guide/dependencies.md
developer_guide/deprecation.md
developer_guide/dev_installation.md
developer_guide/documentation.md
developer_guide/release.md
developer_guide/testing_framework.md
```
