# v0.8.1

April 2024

The following modules are still considered experimental, and the deprecation policy does
not apply:

`annotation`, `anomaly_detection`, `benchmarking`, `segmentation`, `similarity_search`,
`testing`, `transformations/series`, `visualisation`

## Highlights

- Mostly bug fixes, documentation improvements and new deprecations
- Subgradient barycentre averaging is available for clustering ({user}`chrisholder`)

## Anomaly Detection

### Enhancements

- [ENH] `BaseSeriesEstimator` rework ({pr}`1394`) {user}`MatthewMiddlehurst`

## Classification

### Documentation

- [DOC] Correct `WeightedEnsembleClassifier` parameter docstring ({pr}`1418`) {user}`wayneadams`

### Enhancements

- [ENH] `fit_predict` for FreshPRINCE and RotationForest ({pr}`1456`) {user}`MatthewMiddlehurst`

### Other

- [BUG] Fix RDST doctest failure & numba deprecration warning ({pr}`1445`) {user}`baraline`

## Clustering

### Enhancements

- [ENH] Subgradient barycentre averaging ({pr}`1339`) {user}`chrisholder`
- [ENH] Kmeans allow empty clusters ({pr}`1400`) {user}`chrisholder`

### Maintenance

- [MNT] split up and simplified ba test ({pr}`1432`) {user}`chrisholder`

## Datasets

### Bug Fixes

- [BUG] fix loader ({pr}`1428`) {user}`TonyBagnall`

### Documentation

- [DOC] PR #1452 ({pr}`1462`) {user}`RishavKumarSinha`

## Distances

### Enhancements

- [ENH] Subgradient barycentre averaging ({pr}`1339`) {user}`chrisholder`
- [ENH] Distance module pairwise unequal length support ({pr}`1356`) {user}`chrisholder`

## Forecasting

### Deprecation

- [ENH] replace convert/convert_to with convert_series ({pr}`1338`) {user}`TonyBagnall`
- [DEP] deprecate check_scorer ({pr}`1439`) {user}`TonyBagnall`
- [DEP] deprecate probabilistic performance metric classes ({pr}`1436`) {user}`TonyBagnall`

### Enhancements

- [ENH] replace convert/convert_to with convert_series ({pr}`1338`) {user}`TonyBagnall`
- [ENH] remove conversion in get_cutoff ({pr}`1342`) {user}`TonyBagnall`
- [ENH] remove convert_to and vectorized import from index_functions ({pr}`1433`) {user}`TonyBagnall`

### Other

- [COV] Tests for testing/utils/data_gen ({pr}`1347`) {user}`TonyBagnall`

## Regression

### Enhancements

- [ENH] `fit_predict` for FreshPRINCE and RotationForest ({pr}`1456`) {user}`MatthewMiddlehurst`

## Segmentation

### Enhancements

- [ENH] `BaseSeriesEstimator` rework ({pr}`1394`) {user}`MatthewMiddlehurst`

## Similarity Search

### Enhancements

- [ENH] `BaseSeriesEstimator` rework ({pr}`1394`) {user}`MatthewMiddlehurst`

## Transformations

### Bug Fixes

- [BUG] Fix MultiRocketMultivariate failures ({pr}`1453`) {user}`baraline`

### Deprecation

- [DEP] deprecate check_scorer ({pr}`1439`) {user}`TonyBagnall`

### Documentation

- [DOC] PR #1452 ({pr}`1462`) {user}`RishavKumarSinha`

### Enhancements

- [ENH] BaseSeriesTransformer maintains axis for user determined output with BaseSeriesEstimator function ({pr}`1372`) {user}`TonyBagnall`
- [ENH,REF] Refactor `univariate-only` tag ({pr}`1363`) {user}`itsdivya1309`
- [ENH] `BaseSeriesEstimator` rework ({pr}`1394`) {user}`MatthewMiddlehurst`
- [ENH] remove datatypes call from transformations test function ({pr}`1434`) {user}`TonyBagnall`
- [ENH] Add support for array-like and statistical inputs as arguments in fill_value of Padding Transformer ({pr}`1373`) {user}`aadya940`
- [ENH] Autocorrelation SeriesTransformer ({pr}`1380`) {user}`TonyBagnall`

### Refactored

- [ENH,REF] Refactor `univariate-only` tag ({pr}`1363`) {user}`itsdivya1309`

### Other

- [BUG] Fix RDST doctest failure & numba deprecration warning ({pr}`1445`) {user}`baraline`

## Unit Testing

### Maintenance

- [MNT] Add Classifiers For Result Comparison ({pr}`1379`) {user}`harshithasudhakar`

### Other

- [COV] Tests for testing/utils/data_gen ({pr}`1347`) {user}`TonyBagnall`

## Other

### Bug Fixes

- [BUG] allow np.ndarray with ndim>1 to convert to pd.series when squeezable to 1D ({pr}`1427`) {user}`TonyBagnall`

### Deprecation

- [DEP] Make `VectorizedDF` private ({pr}`1369`) {user}`MatthewMiddlehurst`

### Documentation

- [DOCS] Update the mentoring projects ({pr}`1366`) {user}`TonyBagnall`
- [DOC] Fixes mis-wording/typo in mentoring docs ({pr}`1396`) {user}`wayneadams`
- [DOC] Adds previously implemented classifiers to docs/api_references ({pr}`1401`) {user}`wayneadams`
- [DOC] About Us webpage update ({pr}`1419`) {user}`MatthewMiddlehurst`
- [DOC] Add estimator overview table with capabilities ({pr}`1426`) {user}`baraline`
- [DOC] Remove optional from docstrings ({pr}`1458`) {user}`griegner`

### Enhancements

- [DEP] Deprecate _serialize file and load function ({pr}`1378`) {user}`TonyBagnall`
- [ENH] remove datatypes call from test_interval_wrappers ({pr}`1435`) {user}`TonyBagnall`

### Maintenance

- [MNT] Notebook test exclusion tag and stale branch removal ({pr}`1316`) {user}`MatthewMiddlehurst`
- [MNT] Update branch clean action ({pr}`1422`) {user}`MatthewMiddlehurst`
- [MNT] `dask` CI fix, ReadTheDocs fix and expanded full pytest actions tag ({pr}`1420`) {user}`MatthewMiddlehurst`
- [MNT] Update cache restore action ({pr}`1431`) {user}`aadya940`

### Refactored

- [REF] Move tag deprecation to registry ({pr}`1460`) {user}`MatthewMiddlehurst`

## Contributors

The following have contributed to this release through a collective 38 GitHub Pull Requests:

{user}`aadya940`,
{user}`baraline`,
{user}`chrisholder`,
{user}`griegner`,
{user}`harshithasudhakar`,
{user}`itsdivya1309`,
{user}`MatthewMiddlehurst`,
{user}`RishavKumarSinha`,
{user}`TonyBagnall`,
{user}`wayneadams`

# v0.8.0

April 2024

## Highlights

- Deprecations from `0.7.0` have been removed, see the package deprecation sections for more details
- `typing-extensions` has been added as a core dependency
- The following deep learners are now available for regression: `IndividualLITERegressor`, `LITETimeRegressor` and `EncoderRegressor` (({user}`aadya940`) & {user}`AnonymousCodes911`)
- The `HydraRegressor` and `MultiRocketHydraRegressor` algorithms have been implemented for regression module ({user}`MatthewMiddlehurst`)
- A wrapper for the `tslearn` `LearningShapelets` classifier has been added ({user}`itsdivya1309`)
- Support for unequal length in pairwise distance calculation for the SBD and MSM distances is now available, this will be expanded to other distances in time ({user}`CodeLionX`)

## Benchmarking

### Documentation

- [DOC] Fix benchmarking notebooks ({pr}`1305`) {user}`TonyBagnall`

### Maintenance

- [MNT] xfail website reads that return a connection error ({pr}`1357`) {user}`TonyBagnall`

## Classification

### Bug Fixes

- [BUG] Fix random state for deep learning models in classification/regression and clustering ({pr}`1271`) {user}`hadifawaz1999`
- [BUG] ElasticEnsemble with `euclidean` and `twe` distance measures ({pr}`1288`) {user}`itsdivya1309`
- [BUG] fixed sqr error ({pr}`1240`) {user}`AnonymousCodes911`
- [BUG] LearningShapeletClassifier fixes ({pr}`1370`) {user}`MatthewMiddlehurst`

### Deprecation

- [DEP] Remove deprecated overloaded multiplication  and sklearnpipeline ({pr}`1265`) {user}`TonyBagnall`
- [DEP] remove deprecated the save_train_predictions parameter in BOSSEnsemble, CBOSS, T… ({pr}`1333`) {user}`TonyBagnall`
- [DEP] remove support probabilities from weasel2 ({pr}`1335`) {user}`TonyBagnall`
- [DEP] Deprecating ShapeDTW classifier, to be replaced with a newer correct version ({pr}`1367`) {user}`hadifawaz1999`

### Documentation

- [DOCS] hard code shapelet classifiers in notebook ({pr}`1331`) {user}`TonyBagnall`

### Enhancements

- [ENH] Update regression pipeline ({pr}`1279`) {user}`MatthewMiddlehurst`
- [ENH] Loading unequal length, no missing values classification problems ({pr}`1157`) {user}`TonyBagnall`
- [ENH] Tidy dummy estimators for classification and regression ({pr}`1281`) {user}`MatthewMiddlehurst`
- [ENH] Learning Shapelet Classifier ({pr}`1247`) {user}`itsdivya1309`

### Maintenance

- [MNT] Changing deep learning save format from `.hdf5` to `.keras` ({pr}`1292`) {user}`hadifawaz1999`

## Clustering

### Bug Fixes

- [BUG] fixed dba test ({pr}`1319`) {user}`chrisholder`
- [BUG] Fix random state for deep learning models in classification/regression and clustering ({pr}`1271`) {user}`hadifawaz1999`

### Maintenance

- [MNT] Changing deep learning save format from `.hdf5` to `.keras` ({pr}`1292`) {user}`hadifawaz1999`
- [MNT] Distance test refactor ({pr}`1294`) {user}`chrisholder`
- [MNT] Type hint distance module ({pr}`1326`) {user}`chrisholder`

## Datasets

### Bug Fixes

- [BUG] write_to_tsfile not writing header ({pr}`1329`) {user}`vNtzYy`
- [BUG] Stop joining Nones ({pr}`1353`) {user}`TonyBagnall`

### Enhancements

- [ENH] Loading unequal length, no missing values classification problems ({pr}`1157`) {user}`TonyBagnall`

### Maintenance

[MNT] xfail website reads that return a connection error ({pr}`1357`) {user}`TonyBagnall`

## Distances

### Bug Fixes

- [BUG] Unequal length bounding matrix fixes ({pr}`1161`) {user}`chrisholder`

### Enhancements

- [ENH] SBD and MSM: Support pairwise distance calculation for unequal length time series ({pr}`1287`) {user}`CodeLionX`
- [ENH] Capability to use shape-dtw on precomputed transformation ({pr}`1323`) {user}`hadifawaz1999`

### Maintenance

- [MNT] Distance test refactor ({pr}`1294`) {user}`chrisholder`
- [MNT] Type hint distance module ({pr}`1326`) {user}`chrisholder`

## Regression

### Bug Fixes

- [BUG] Fix random state for deep learning models in classification/regression and clustering ({pr}`1271`) {user}`hadifawaz1999`

### Enhancements

- [ENH] Remove regression delegate file ({pr}`1280`) {user}`MatthewMiddlehurst`
- [ENH] Updated EncoderRegressor ({pr}`1226`) {user}`AnonymousCodes911`
- [ENH] Hydra and MultiRocketHydra for regression ({pr}`1207`) {user}`MatthewMiddlehurst`
- [ENH] Refactored  _TestRegressor in regression testing module to be a MockRegressor in testing/mock_estimators ({pr}`1213`) {user}`tvilight4`
- [ENH] Add IndividualLITERegressor and LITETimeRegressor ({pr}`1221`) {user}`aadya940`
- [ENH] Update regression pipeline ({pr}`1279`) {user}`MatthewMiddlehurst`
- [ENH] Tidy dummy estimators for classification and regression ({pr}`1281`) {user}`MatthewMiddlehurst`
- [ENH] Initializing metrics to "mean_squared_error" In Deep Learning Models ({pr}`1317`) {user}`harshithasudhakar`

### Maintenance

- [MNT] Changing deep learning save format from `.hdf5` to `.keras` ({pr}`1292`) {user}`hadifawaz1999`

## Segmentation

### Deprecation

- [ENH] Deprecate annotators ({pr}`1306`) {user}`TonyBagnall`

## Transformations

### Bug Fixes

- [BUG] RandomShapeletTransform stdev fix ({pr}`1324`) {user}`MatthewMiddlehurst`

### Deprecation

- [ENH] Deprecate transformers ({pr}`1307`) {user}`TonyBagnall`
- [DEP] deprecate ElbowClass prior to move to dedicated package ({pr}`1336`) {user}`TonyBagnall`

### Enhancements

- [ENH] Enhancing `BaseCollectionTransformers`+Tidying `Utils` dir ({pr}`1328`) {user}`AnonymousCodes911`
- [ENH] remove call to update in BaseCollectionTransformer ({pr}`1344`) {user}`TonyBagnall`

### Maintenance

- [MNT] Modified `test_base_rocketGPU.py` ({pr}`1325`) {user}`AnonymousCodes911`

## Unit Testing

### Enhancements

- [ENH] Refactored  _TestRegressor in regression testing module to be a MockRegressor in testing/mock_estimators ({pr}`1213`) {user}`tvilight4`

### Maintenance

- [MNT] added unequal length utils function ({pr}`1303`) {user}`chrisholder`
- [MNT] Move estimator_checks to the Testing Module ({pr}`1312`) {user}`aadya940`

## Visualisations

### Enhancements

- [ENH] Add plot_spectrogram ({pr}`1237`) {user}`aadya940`

### Deprecation

- [DEP] remove plotting from utils ({pr}`1334`) {user}`TonyBagnall`

## Other

### Deprecation

- [DEP] Remove `mlflow` ({pr}`1285`) {user}`MatthewMiddlehurst`
- [ENH] Remove deprecated performance metric classes ({pr}`1261`) {user}`TonyBagnall`
- [DEP]  remove deprecated 'save_transformed_data' and 'transformed_data_' in BaseIntervalForest, FreshPrince, STC, ({pr}`1332`) {user}`TonyBagnall`

### Documentation

- [DOC] Missing link for aeon-neuro ({pr}`1299`) {user}`harshithasudhakar`
- [DOC] Updates to conform to `ruff` - `pydocstyle` hook ({pr}`1277`) {user}`AnonymousCodes911`
- [DOC] Add clustering example to the README ({pr}`1354`) {user}`chrisholder`
- [DOC] Update papers page and remove GSoC advertisements ({pr}`1368`) {user}`MatthewMiddlehurst`

### Enhancements

- [ENH] Remove deprecated performance metric classes ({pr}`1261`) {user}`TonyBagnall`
- [ENH] Refactor dask converters ({pr}`1302`) {user}`TonyBagnall`
- [ENH] Replace calls to check_is_scitype that return metadata with validate_input ({pr}`1290`) {user}`TonyBagnall`
- [ENH] reduce warnings ({pr}`1337`) {user}`TonyBagnall`
- [ENH] Replace mtype to scitype function ({pr}`1298`) {user}`TonyBagnall`

### Maintenance

- [MNT] Refactored any occurrence of '_instances' to '_cases'. 'series_length' to 'n_timepoints' and 'n_dims' to 'n_channels' ({pr}`1304`) {user}`chrisholder`
- [MNT] Changes to `pyarrow` and `dask` in `all_extras` to fix CI ({pr}`1309`) {user}`MatthewMiddlehurst`
- [MNT] Cleanup code in aeon.util.conversion module ({pr}`1289`) {user}`CodeLionX`
- [MNT] Add new dependency: typing-extensions ({pr}`1327`) {user}`chrisholder`

### Refactored

- [ENH] Replace calls to check_is_scitype that return metadata with validate_input ({pr}`1290`) {user}`TonyBagnall`

## Contributors

The following have contributed to this release through a collective 58 GitHub Pull Requests:

{user}`aadya940`,
{user}`AnonymousCodes911`,
{user}`chrisholder`,
{user}`CodeLionX`,
{user}`hadifawaz1999`,
{user}`harshithasudhakar`,
{user}`itsdivya1309`,
{user}`MatthewMiddlehurst`,
{user}`TonyBagnall`,
{user}`tvilight4`,
{user}`vNtzYy`
