# v0.5.0

September 2023

Following this release the deprecation policy remains suspended. Future releases may
have breaking changes, so it may be wise to set an upper bound on the package version.
It is likely a deprecation policy will be implemented and enforced starting v0.6.0,
however.

## Highlights

- New distance measures with ADTW and ShapeDTW (@chrisholder, @hadifawaz1999)
- Multiple new functions in the benchmarking module for creating figures i.e. Critical
  difference diagrams (@dguijo)
- New example notebooks and tidied versions of existing ones
- Lots of new bugfixes and testing to keep our estimators bug free (as much as possible
  at least)!

## Annotation

### Bug Fixes

- [Bugfix] Deprecation of tick.label in matplotlib >3.8.0 ({pr}`750`) {user}`patrickzib`

## Benchmarking

### Documentation

- [DOC] Adding examples to the benchmarking functions docstrings. ({pr}`774`)
  {user}`dguijo`
- [DOC] Adds notebook examples to benchmarking module ({pr}`771`) {user}`dguijo`

### Enhancements

- [ENH] Adds CD diagrams, violin plots, boxplots and some other graphs.  ({pr}`582`)
  {user}`dguijo`

### Maintenance

- [ENH] Coverage for benchmarking ({pr}`719`) {user}`TonyBagnall`

## Classification

### Bug Fixes

- [BUG] Fix EE test edge case ({pr}`738`) {user}`TonyBagnall`
- [BUG] TDE and boxplot bugfixes ({pr}`786`) {user}`MatthewMiddlehurst`

### Documentation

- [DOC] Add example inception time classifier and regressor ({pr}`675`)
  {user}`hadifawaz1999`

### Enhancements

- [ENH] Revisions to classifier base class ({pr}`551`) {user}`TonyBagnall`
- [ENH] New BaseCollectionEstimator class ({pr}`650`) {user}`TonyBagnall`
- [ENH] reconfig HC tests ({pr}`735`) {user}`TonyBagnall`

### Maintenance

- [ENH] Improved ContinuousIntervalTree coverage ({pr}`720`) {user}`TonyBagnall`
- [ENH] Improved coverage for classification ({pr}`727`) {user}`TonyBagnall`

## Clustering

### Bug Fixes

- [BUG] add soft dep check to tslearn clusterers ({pr}`628`) {user}`TonyBagnall`
- [BUG] Clustering notebook (and a few docstring typos) ({pr}`673`) {user}`TonyBagnall`
- [BUG] Medoids empty cluster bug fix ({pr}`760`) {user}`chrisholder`

### Documentation

- [DOC] Update clustering notebook ({pr}`659`) {user}`TonyBagnall`

### Enhancements

- [ENH] New BaseCollectionEstimator class ({pr}`650`) {user}`TonyBagnall`

### Maintenance

- [MNT] reduce examples time for clusterers ({pr}`621`) {user}`TonyBagnall`
- [MNT] Kmeans refactor ({pr}`762`) {user}`chrisholder`
- [ENH] add clusterer base test ({pr}`768`) {user}`TonyBagnall`

## Datasets

### Bug Fixes

- [BUG] typo in doctest skip ({pr}`634`) {user}`TonyBagnall`
- [BUG] remove unnecessary call to os.path.dirname ({pr}`679`) {user}`TonyBagnall`
- [BUG] fixes multivariate dataframe tsfile writes (#732) ({pr}`740`)
  {user}`hedeershowk`

### Maintenance

- [ENH] Improve coverage for datasets module ({pr}`665`) {user}`TonyBagnall`
- [ENH] Improve coverage for datasets module ({pr}`733`) {user}`TonyBagnall`

## Distances

### Bug Fixes

- [BUG] shapedtw using assert_almost_equal in test_distances ({pr}`767`)
  {user}`hadifawaz1999`
- [BUG] Precision error on dist tests on mac ({pr}`791`) {user}`TonyBagnall`

### Documentation

- [DOC] Reformat distances docs ({pr}`646`) {user}`TonyBagnall`
- [ENH] Docstrings for distances ({pr}`692`) {user}`TonyBagnall`
- [DOC] Lets do the time warp again notebook ({pr}`743`) {user}`chrisholder`

### Enhancements

- [ENH] Itakura parallelogram bounding ({pr}`512`) {user}`chrisholder`
- [ENH] ShapeDTW as a distance function ! ({pr}`754`) {user}`hadifawaz1999`
- [ENH] Adtw distance ({pr}`759`) {user}`chrisholder`

## Forecasting

### Documentation

- [DOC] Tidy and speed up forecasting example notebooks ({pr}`693`)
  {user}`MatthewMiddlehurst`

### Maintenance

- [MNT] Switch test configs on MATRIXDESIGN ({pr}`437`) {user}`TonyBagnall`
- [ENH] Speed up forecasting tests ({pr}`701`) {user}`TonyBagnall`

## Networks

### Bug Fixes

- [BUG] Fix bug in resnet network, strides ({pr}`690`) {user}`hadifawaz1999`

### Maintenance

- [ENH] Add a test for network module ({pr}`674`) {user}`hadifawaz1999`

## Regression

### Documentation

- [DOC] Add example inception time classifier and regressor ({pr}`675`)
  {user}`hadifawaz1999`
- [DOC] Regression notebook update ({pr}`686`) {user}`MatthewMiddlehurst`

### Enhancements

- [ENH] New BaseCollectionEstimator class ({pr}`650`) {user}`TonyBagnall`

## Transformations

### Bug Fixes

- [BUG] Fixes a bug with numba's typed dict in SFA when numba is disabled ({pr}`753`)
  {user}`patrickzib`
- [BUG] Expected results rework and Shapelet Transform bugfix ({pr}`758`)
  {user}`MatthewMiddlehurst`

### Documentation

- [ENH] speed up signatures notebook ({pr}`662`) {user}`TonyBagnall`

### Enhancements

- [ENH] Change Dictionary transformers base class to `BaseCollectionTransformer` (
  {pr}`638`) {user}`MatthewMiddlehurst`
- [ENH] remove ColumnTransformer ({pr}`657`) {user}`TonyBagnall`
- [ENH] Add normalisation transformer for time series ({pr}`612`) {user}`TonyBagnall`
- [ENH] Change Rocket transformers base class to `BaseCollectionTransformer` ({pr}`637`)
  {user}`MatthewMiddlehurst`
- [ENH] Change signature transform base class to `BaseCollectionTransformer` ({pr}`682`)
  {user}`MatthewMiddlehurst`
- [ENH] Collection transformer `compose.py` cleanup ({pr}`683`)
  {user}`MatthewMiddlehurst`
- [ENH] refactor shapelet transform ({pr}`718`) {user}`TonyBagnall`
- [ENH] New BaseCollectionEstimator class ({pr}`650`) {user}`TonyBagnall`
- [ENH] Efficiency slope transformer ({pr}`746`) {user}`steenrotsman`

### Maintenance

- [MNT] Collection transformation `summarize` refactor and removal ({pr}`643`)
  {user}`MatthewMiddlehurst`
- [ENH] Test for efficiency slope transformer ({pr}`763`) {user}`steenrotsman`

### Refactored

- [MNT] Collection transformation `summarize` refactor and removal ({pr}`643`)
  {user}`MatthewMiddlehurst`

## Other

### Bug Fixes

- [DOC] Update documentation for new devs and documentation build fixes ({pr}`739`)
  {user}`hedeershowk`

### Documentation

- [DOCS] pre-processing notebook and collections validations ({pr}`606`)
  {user}`TonyBagnall`
- [DOC] Add Papers using Aeon section. ({pr}`611`) {user}`haskarb`
- [MNT] Remove auto generated API page from toctree ({pr}`620`)
  {user}`MatthewMiddlehurst`
- [DOC] Configure website cards to scale images ({pr}`631`) {user}`MatthewMiddlehurst`
- [ENH] some minor edits of notebook text ({pr}`635`) {user}`TonyBagnall`
- [DOC] Add @dguijo to core developer table and CODEOWNERS ({pr}`678`)
  {user}`MatthewMiddlehurst`
- [DOC] Developer and `conda` install instructions  ({pr}`680`)
  {user}`MatthewMiddlehurst`
- [DOC] Fix README test badge ({pr}`687`) {user}`MatthewMiddlehurst`
- [DOC] README conda badge ({pr}`688`) {user}`MatthewMiddlehurst`
- [DOC] Remove related software page ({pr}`681`) {user}`MatthewMiddlehurst`
- [DOC] Glossary rewrite ({pr}`694`) {user}`MatthewMiddlehurst`
- [DOC] Update slack links ({pr}`729`) {user}`MatthewMiddlehurst`
- [DOC] Update documentation for new devs and documentation build fixes ({pr}`739`)
  {user}`hedeershowk`
- [DOC][Sweep] Update papers_using_aeon.md with new publication for time series
  clustering ({pr}`737`) {user}`sweep-ai[bot]`
- added plot visualizing the Italy power data ({pr}`745`) {user}`kgmuzungu`
- [DOC] Update API page in docs/api_reference/distances.rst ({pr}`776`)
  {user}`sweep-ai[bot]`
- [DOC] add papers to papers using aeon page ({pr}`780`) {user}`TonyBagnall`
- [DOC] A couple of typos ({pr}`775`) {user}`TonyBagnall`
- [DOC] Tidy up referencing in doc strings ({pr}`781`) {user}`TonyBagnall`
- [DOC] Various small documentation fixes ({pr}`792`) {user}`MatthewMiddlehurst`

### Enhancements

- [ENH] centralise and tidy up the converters ({pr}`576`) {user}`TonyBagnall`
- [ENH] Remove `all` directory from packages ({pr}`642`) {user}`MatthewMiddlehurst`
- [ENH] Testing revision version 1 ({pr}`597`) {user}`TonyBagnall`
- [ENH] Remove top of file warnings for soft dependencies ({pr}`641`)
  {user}`MatthewMiddlehurst`
- [ENH] Improve coverage of base directory ({pr}`716`) {user}`TonyBagnall`

### Maintenance

- [MNT] Remove auto generated API page from toctree ({pr}`620`)
  {user}`MatthewMiddlehurst`
- [MNT] Add runtime list for notebook test ({pr}`619`) {user}`MatthewMiddlehurst`
- [MNT] Skip code coverage test failures ({pr}`624`) {user}`MatthewMiddlehurst`
- [ENH] Speed up test all estimators ({pr}`595`) {user}`TonyBagnall`
- [ENH] remove interval based fails ({pr}`629`) {user}`TonyBagnall`
- [MNT] Skip tests for PRs which do not touch any important or `aeon/` files ({pr}`636`)
  {user}`MatthewMiddlehurst`
- [MNT] Remove InceptionTime estimators from test exclusion ({pr}`640`)
  {user}`MatthewMiddlehurst`
- [ENH] Speed up inception time tests ({pr}`689`) {user}`TonyBagnall`
- [ENH] Speed up resnet tests ({pr}`691`) {user}`TonyBagnall`
- [MNT] Rename `--matrixdesign` and update documentation ({pr}`639`)
  {user}`MatthewMiddlehurst`
- [MNT] Update contributors file ({pr}`684`) {user}`MatthewMiddlehurst`
- [MNT] fixed precommit stack level warnings ({pr}`706`) {user}`chrisholder`
- [MNT] Sweep issue template ({pr}`731`) {user}`MatthewMiddlehurst`
- [MNT] Update Sweep config ({pr}`764`) {user}`MatthewMiddlehurst`
- [MNT] Add pre-commit bot which pushes fixes to PRs ({pr}`770`)
  {user}`MatthewMiddlehurst`
- [MNT] Uncomment `pytest` config ({pr}`783`) {user}`MatthewMiddlehurst`

### Refactored

- [MNT] Remove calls to aeon.datatypes ({pr}`710`) {user}`TonyBagnall`

### Other

- [ENH] remove exclusions from testing in tests/_config.py ({pr}`661`)
  {user}`TonyBagnall`
- [BUG] Update _show_versions.py (aeon-toolkit#670) ({pr}`671`) {user}`sylvaincom`
- [MNT] remove exclusions ({pr}`696`) {user}`TonyBagnall`
- Configure Sweep ({pr}`736`) {user}`sweep-ai[bot]`
- [ENH] Update sweep.yaml to improve Sweep Sandbox ({pr}`777`) {user}`kevinlu1248`

## Contributors

The following have contributed to this release through a collective 97 GitHub Pull
Requests:

{user}`chrisholder`,
{user}`dguijo`,
{user}`hadifawaz1999`,
{user}`haskarb`,
{user}`hedeershowk`,
{user}`kevinlu1248`,
{user}`kgmuzungu`,
{user}`MatthewMiddlehurst`,
{user}`patrickzib`,
{user}`steenrotsman`,
{user}`sylvaincom`,
{user}`TonyBagnall`
