# v0.2.0

May 2023

Following this release the deprecation policy remains suspended. Future releases may have breaking changes, so it may be wise to set an upper bound on the package version.

## Highlights

- `aeon` now supports Python 3.11!
- New estimators are available in the regression package, including `InceptionTime` ({user}`hadifawaz1999`) and `FreshPRINCE` ({user}`dguijo`)
- The distances module has been reworked, and the distances available are now faster ({user}`chrisholder`)
- The `RandomDilatedShapeletTransform` for collections of series is now available ({user}`baraline`)
- The 'Getting Started' page on the documentation has been rewritten with clearer introductions to each module

## Enhancements

- [ENH] remove regression mentions of nested_univ ({pr}`279`) {user}`TonyBagnall`
- [ENH] Bounding matrix for distances module ({pr}`305`) {user}`chrisholder`
- [ENH] added inceptionTime as regressor ({pr}`260`) {user}`hadifawaz1999`
- [ENH] Convert Catch22 and Catch22Wrapper to use numpy internally ({pr}`294`) {user}`TonyBagnall`
- [ENH] Update euclidean and squared distance ({pr}`308`) {user}`chrisholder`
- [ENH] Update distance alignment paths ({pr}`309`) {user}`chrisholder`
- [ENH] Convert HOG1DTransformer and DerivativeSlopeTransformer to use numpy arrays internally ({pr}`261`) {user}`TonyBagnall`
- [ENH] Convert DWTTransformer to use numpy format internally ({pr}`293`) {user}`TonyBagnall`
- [ENH] RDST transformer ({pr}`310`) {user}`baraline`
- [ENH] Update dtw distance ({pr}`316`) {user}`chrisholder`
- [ENH] added ReduceLROnPlateau callback by default to InceptionTime deep classifier ({pr}`327`) {user}`hadifawaz1999`
- [ENH] Introduce list of numpy arrays data type for classification/regression/clustering ({pr}`296`) {user}`TonyBagnall`
- [ENH] refactor param_est to live in forecasting module ({pr}`330`) {user}`TonyBagnall`
- [ENH] Removes nested dataframes from shape dtw ({pr}`329`) {user}`TonyBagnall`
- [ENH] Add reduce on plateau learning rate decay for FCN ResNet and MLP deep classifiers ({pr}`351`) {user}`hadifawaz1999`
- [ENH] Refactor pairwise distance ({pr}`357`) {user}`chrisholder`
- [ENH] purge mentions of Panel in classification ({pr}`331`) {user}`TonyBagnall`
- [ENH] Update ddtw distance ({pr}`319`) {user}`chrisholder`
- [ENH] Update wdtw distance ({pr}`322`) {user}`chrisholder`
- [ENH] Update wddtw distance ({pr}`323`) {user}`chrisholder`
- [ENH] Update lcss distance ({pr}`332`) {user}`chrisholder`
- [ENH] Update erp distance ({pr}`333`) {user}`chrisholder`
- [ENH] Update edr distance ({pr}`366`) {user}`chrisholder`
- [ENH] add model checkpoint to inceptionTime deep classifier ({pr}`362`) {user}`hadifawaz1999`
- [ENH] Update twe distance ({pr}`367`) {user}`chrisholder`
- [ENH] Update msm distance ({pr}`369`) {user}`chrisholder`
- [ENH] Distance module cleanup ({pr}`372`) {user}`chrisholder`
- [MNT] Remove any reference of pykalman ({pr}`380`) {user}`hadifawaz1999`
- [ENH] removes the param_est package ({pr}`356`) {user}`TonyBagnall`
- [ENH] added modelcheckpoint and reduce learning rate to inceptionTime regressor ({pr}`397`) {user}`hadifawaz1999`
- [ENH] Add model checkpoint for the rest of the deep learning classifiers ({pr}`394`) {user}`hadifawaz1999`
- [ENH] convert TSInterpolator to np-list/numpy3D ({pr}`388`) {user}`TonyBagnall`
- [ENH] Adapt PlateauFinder to use numpy3D ({pr}`392`) {user}`TonyBagnall
- [ENH] FreshPRINCERegressor, RotationForestRegressor and minor changes to FreshPRINCEClassifier ({pr}`384`) {user}`dguijo`
- [ENH] remove more mentions of nested_univ ({pr}`295`) {user}`TonyBagnall`
- [ENH] combine test_returns_self with test_fit_updates_state ({pr}`300`) {user}`TonyBagnall`
- [ENH] Change data loaders and writers to minimize use of "nested_univ" input type ({pr}`355`) {user}`TonyBagnall`
- [ENH] TruncationTransformer, PaddingTransformer and TSFresh internal type to np-list ({pr}`364`) {user}`TonyBagnall`
-
## Fixes

- [BUG] Fix test overwrite inception time classifier ({pr}`315`) {user}`hadifawaz1999`
- [ENH] Update distance alignment paths ({pr}`309`) {user}`chrisholder`
- [BUG] Forecasting base circular import ({pr}`328`) {user}`MatthewMiddlehurst`
- [BUG] Fixes `show_versions` error ({pr}`353`) {user}`GuiArcencio`
- [BUG] Fixes `load_covid_3month` returning a non-numeric `y` ({pr}`354`) {user}`GuiArcencio`
- [ENH] Update twe distance ({pr}`367`) {user}`chrisholder`
- [MNT] Remove any reference of pykalman ({pr}`380`) {user}`hadifawaz1999`
- [BUG] fix tsfresh "kind" feature extractor  ({pr}`400`) {user}`TonyBagnall`
- [BUG] fix all_estimators to work with tags that are lists of strings not just single strings ({pr}`399`) {user}`TonyBagnall`

## Documentation

- [DOC] Change web documentation colours ({pr}`301`) {user}`MatthewMiddlehurst`
- [DOC] New `aeon` logo and replacement for current usage ({pr}`298`) {user}`MatthewMiddlehurst`
- [DOC] Update README ({pr}`303`) {user}`MatthewMiddlehurst`
- [DOC] Fix rocket examples imports ({pr}`325`) {user}`hadifawaz1999`
- [DOC] Remove meetup and sponsor cards from get involved ({pr}`344`) {user}`MatthewMiddlehurst`
- & TonyBagnall [DOC] Remake `get_started` page ({pr}`346`) {user}`MatthewMiddlehurst`
- [DOC] Add contrib.rocks image to `contributors.md` and lower all-contributors table/image size ({pr}`352`) {user}`MatthewMiddlehurst`
- [MNT] docs update to fix readthedocs fail ({pr}`386`) {user}`TonyBagnall`
- [DOC] Tidy up classification docs ({pr}`398`) {user}`TonyBagnall`
- [DOC] Update section names in examples.md ({pr}`404`) {user}`GuzalBulatova`

## Maintenance

- [MNT] Update issue templates to use issue forms ({pr}`311`) {user}`MatthewMiddlehurst`
- [MNT] Fix Binder Dockerfile ({pr}`306`) {user}`MatthewMiddlehurst`
- [MNT] Update contributors.md ({pr}`312`) {user}`MatthewMiddlehurst`
- [MNT] Cleanup the forecasting tests ({pr}`192`) {user}`lmmentel`
- [MNT] Update file change action and cancel workflow  ({pr}`339`) {user}`MatthewMiddlehurst`
- [MNT] Remove test_fit_does_not_overwrite_hyper_params and test_methods_have_no_side_effects from config for most deep learners CNN MLP Encoder and FCN classifiers ({pr}`348`) {user}`hadifawaz1999`
- [MNT] Remove the test_methods_have_no_side_effects for inceptionTime classifier from _config ({pr}`338`) {user}`hadifawaz1999`
- [MNT] Fix workflow concurrency ({pr}`350`) {user}`MatthewMiddlehurst`
- [MNT] Change `update_contributors.yml` to create PRs ({pr}`349`) {user}`MatthewMiddlehurst`
- [MNT] Changes repo owner to aeon-toolkit in `.all-contributorsrc` ({pr}`359`) {user}`GuiArcencio`
- [MNT] docs update to fix readthedocs fail ({pr}`386`) {user}`TonyBagnall`
- [MNT] Add python 3.11 support ({pr}`191`) {user}`lmmentel`
- [MNT] Remove any reference of pykalman ({pr}`380`) {user}`hadifawaz1999`
- [MNT] Unstable extras ({pr}`365`) {user}`MatthewMiddlehurst`
- [MNT] Remove the test_methods_have_no_side_effects for inceptionTime classifier from _config ({pr}`338`) {user}`hadifawaz1999`

## Contributors

{user}`baraline`,
{user}`chrisholder`,
{user}`dguijo`,
{user}`GuiArcencio`,
{user}`GuzalBulatova`,
{user}`hadifawaz1999`,
{user}`lmmentel`,
{user}`MatthewMiddlehurst`,
{user}`TonyBagnall`
