# Reporting Bugs and Opening Issues

We use [GitHub issues](https://github.com/aeon-toolkit/aeon/issues) to track all bugs
and feature requests; feel free to open an issue if you have found a bug or wish to see
a feature implemented. We use the following tags and labels to categorise issues:

- [Bugs [BUG]](https://github.com/aeon-toolkit/aeon/issues?q=is%3Aissue+is%3Aopen+label%3Abug): Bug reports and fixes
- [Enhancements [ENH]](https://github.com/aeon-toolkit/aeon/issues?q=is%3Aissue+is%3Aopen+label%3Aenhancement): Features requests and enhancements to code
- [Maintenance [MNT]](https://github.com/aeon-toolkit/aeon/issues?q=is%3Aissue+is%3Aopen+label%3Amaintenance): Repository, CI and package maintenance
- [Documentation [DOC]](https://github.com/aeon-toolkit/aeon/issues?q=is%3Aissue+is%3Aopen+label%3Adocumentation): Documentation improvements and requests
- [Refactoring [REF]](https://github.com/aeon-toolkit/aeon/issues?q=is%3Aissue+is%3Aopen+label%3Arefactor): Code refactoring and clean-up
- [Deprecation [DEP]](https://github.com/aeon-toolkit/aeon/issues?q=is%3Aissue+is%3Aopen+label%3Adeprecation): Deprecation of code and features
- [Governance [GOV]](https://github.com/aeon-toolkit/aeon/issues?q=is%3Aissue+is%3Aopen+label%3Agovernance): Project governance and community issues

Most issues come with [templates](https://github.com/aeon-toolkit/aeon/issues/new/choose)
which we recommend following. Generally though, it is recommended to check that your
issue complies with the following rules before submitting:

- Verify that your issue is not being currently addressed by other [issues](https://github.com/aeon-toolkit/aeon/issues)
or [pull requests](https://github.com/aeon-toolkit/aeon/pulls).
- Ensure all code snippets and error messages are formatted in appropriate code blocks.
See [Creating and highlighting code blocks](https://help.github.com/articles/creating-and-highlighting-code-blocks).
- Please be specific about what estimators and/or functions are involved and the shape
of the data.
- When appropriate, please include a [reproducible](https://stackoverflow.com/help/mcve)
code snippet or link to a [gist](https://gist.github.com). If an exception is raised,
please provide the traceback.
