# v0.9.0

May 2024

## Highlights

- New anomaly detection base class and MERLIN anomaly detector
- Implementation for the RSAST classifier
- Fixes for pipelines and new clustering and collection transformer pipeline classes
- Improved model loading ability for deep learning modules
- Large number of deprecations as we port transformations over to a new interface

## Anomaly Detection

### Enhancements

- [ENH] Anomaly detection base class and MERLIN detector ({pr}`1343`) {user}`MatthewMiddlehurst`

## Benchmarking

### Enhancements

- [ENH] Results lists and loading ({pr}`1549`) {user}`TonyBagnall`

## Classification

### Bug Fixes

- [BUG] Set dynamic tag after `__init__` for classifiers and regressors. ({pr}`1483`) {user}`MatthewMiddlehurst`

### Deprecation

- [DEP] Remove shapeDTW ({pr}`1470`) {user}`TonyBagnall`

### Documentation

- [DOC] Fixing `random_state` in docstrings ({pr}`1417`) {user}`AnonymousCodes911`
- [DOC] Add reference to paper in FreshPRINCEClassifier ({pr}`1515`) {user}`jasonmokk`
- [DOC] Update the `ElasticEnsemble` documentation ({pr}`1544`) {user}`itsdivya1309`
- [DOC] Typos in shapelet notebook ({pr}`1572`) {user}`TonyBagnall`

### Enhancements

- [ENH] Type hints for primitives and string arguments:Part1 ({pr}`1472`) {user}`nileenagp`
- [ENH] Add control over the score method of classification and regression ({pr}`1443`) {user}`aadya940`
- [ENH] Type hints for primitives and string arguments:Part2 ({pr}`1487`) {user}`nileenagp`
- [ENH] Included RSAST as a alternative to SAST (2.0) ({pr}`1383`) {user}`nirojasva`
- [ENH] Loading ability in deep learning modules for classification/regression/clustering ({pr}`1374`) {user}`hadifawaz1999`
- [ENH] Type hints for primitives and string arguments:Part3 ({pr}`1525`) {user}`nileenagp`

### Maintenance

- [MNT] Update `ElasticEnsemble` test to work with all distances ({pr}`1532`) {user}`itsdivya1309`

## Clustering

### Bug Fixes

- [ENH,BUG] Fixes for pipeline utilities and additional pipeline classes for collection based estimators ({pr}`1533`) {user}`MatthewMiddlehurst`
- [ENH,BUG] added weighted elastic barycenter and fix cache issue in subgradient method ({pr}`1563`) {user}`maxwell1503`

### Enhancements

- [ENH,BUG] Fixes for pipeline utilities and additional pipeline classes for collection based estimators ({pr}`1533`) {user}`MatthewMiddlehurst`
- [ENH,BUG] added weighted elastic barycenter and fix cache issue in subgradient method ({pr}`1563`) {user}`maxwell1503`
- [ENH] Loading ability in deep learning modules for classification/regression/clustering ({pr}`1374`) {user}`hadifawaz1999`

### Maintenance

- [MNT] Add tests for BA weight parameters ({pr}`1570`) {user}`chrisholder`

## Datasets

### Enhancements

- [ENH] Load tsc problems from zenodo as a back up to tsc.com ({pr}`1531`) {user}`TonyBagnall`
- [ENH] Results lists and loading ({pr}`1549`) {user}`TonyBagnall`

## Distances

### Bug Fixes

- [BUG] mpdist window length ({pr}`1513`) {user}`TonyBagnall`

### Enhancements

- [ENH] Update MPDist function ({pr}`1415`) {user}`itsdivya1309`

## Regression

### Bug Fixes

- [BUG] Set dynamic tag after `__init__` for classifiers and regressors. ({pr}`1483`) {user}`MatthewMiddlehurst`

### Deprecation

- [DEP] deprecation V9 actions ({pr}`1464`) {user}`TonyBagnall`

### Documentation

- [MNT] Add note in project README ({pr}`1391`) {user}`aadya940`

### Enhancements

- [ENH] Add control over the score method of classification and regression ({pr}`1443`) {user}`aadya940`
- [ENH] Loading ability in deep learning modules for classification/regression/clustering ({pr}`1374`) {user}`hadifawaz1999`

## Transformations

### Bug Fixes

- [ENH,BUG] Fixes for pipeline utilities and additional pipeline classes for collection based estimators ({pr}`1533`) {user}`MatthewMiddlehurst`

### Deprecation

- [DEP] Move ElbowClass channel selection algorithms ({pr}`1466`) {user}`TonyBagnall`
- [DEP] Move BoxCox and Log transformer to series transformers ({pr}`1493`) {user}`TonyBagnall`
- [DEP] Deprecate the ACF and PACF BaseTransformer wrappers ({pr}`1473`) {user}`TonyBagnall`
- [DEP] Deprecate simple wrapper transformers ({pr}`1494`) {user}`TonyBagnall`
- [DEP] Deprecate Differencer transformer ({pr}`1535`) {user}`TonyBagnall`
- [DEP] Convert DOBIN to a BaseSeriesTransformer ({pr}`1539`) {user}`TonyBagnall`
- [DEP] convert Scaled Logit ({pr}`1552`) {user}`TonyBagnall`
- [ENH] Convert Theta transform to series transformer ({pr}`1550`) {user}`TonyBagnall`
- [DEP] Move and deprecate pca ({pr}`1558`) {user}`TonyBagnall`
- [DEP] Deprecate TimeSince ({pr}`1559`) {user}`TonyBagnall`
- [DEP] Move and deprecate BKFilter ({pr}`1560`) {user}`TonyBagnall`
- [DEP] Deprecate kalman filter ({pr}`1561`) {user}`TonyBagnall`

### Enhancements

- [ENH] BaseSeriesEstimator and BaseSeriesTransformer ({pr}`1490`) {user}`TonyBagnall`
- [ENH] Changes to series base classes from #1490 ({pr}`1506`) {user}`MatthewMiddlehurst`
- [ENH] Channel selection ({pr}`1486`) {user}`TonyBagnall`
- [ENH,BUG] Fixes for pipeline utilities and additional pipeline classes for collection based estimators ({pr}`1533`) {user}`MatthewMiddlehurst`
- [ENH] Included RSAST as a alternative to SAST (2.0) ({pr}`1383`) {user}`nirojasva`
- [ENH] Convert Theta transform to series transformer ({pr}`1550`) {user}`TonyBagnall`

## Unit Testing

### Maintenance

- [MNT] Changes to no soft dependency tests ({pr}`1476`) {user}`MatthewMiddlehurst`

## Other

### Bug Fixes

- [BUG] Dependencies version checking not handling python release candidate correctly ({pr}`1450`) {user}`baraline`

### Deprecation

- [DEP] Remove annotation module ({pr}`1441`) {user}`TonyBagnall`
- [DEP] remove deprecation for datatypes adapter functions ({pr}`1489`) {user}`TonyBagnall`
- [DEP] deprecate SKLearnRegression pipeline ({pr}`1488`) {user}`TonyBagnall`
- [DEP] Removal of various annotation mentions and functions ({pr}`1505`) {user}`MatthewMiddlehurst`
- [DEP] Deprecate `exceptions.py` ({pr}`1517`) {user}`MatthewMiddlehurst`
- [ENH] Remove duplicate check estimator ({pr}`1545`) {user}`TonyBagnall`

### Documentation

- [DOC] Change about text, add a link from docs to repo ({pr}`1485`) {user}`TonyBagnall`
- [DOC] add distance and channel selection projects ({pr}`1468`) {user}`TonyBagnall`
- [DOC] Update classification API docs ({pr}`1510`) {user}`itsdivya1309`

### Enhancements

- [ENH] Exclude notebooks from PR testing that load from tsc.com ({pr}`1501`) {user}`TonyBagnall`
- [ENH] Remove duplicate check estimator ({pr}`1545`) {user}`TonyBagnall`
- [ENH] Lower bound scipy to 1.9 ({pr}`1546`) {user}`TonyBagnall`

### Maintenance

- [MNT] Adds an Issue/PR Assigning Bot ({pr}`1459`) {user}`AnonymousCodes911`
- [MNT] Fix issue assign action and general maintenance ({pr}`1509`) {user}`MatthewMiddlehurst`
- [MNT] Update CODEOWNERS ({pr}`1507`) {user}`MatthewMiddlehurst`
- [MNT] Fix `BaseSeriesEstimator` test ({pr}`1512`) {user}`MatthewMiddlehurst`

## Contributors

The following have contributed to this release through a collective 55 GitHub Pull Requests:

{user}`aadya940`,
{user}`AnonymousCodes911`,
{user}`baraline`,
{user}`chrisholder`,
{user}`CodeLionX`,
{user}`hadifawaz1999`,
{user}`itsdivya1309`,
{user}`jasonmokk`,
{user}`MatthewMiddlehurst`,
{user}`maxwell1503`,
{user}`nileenagp`,
{user}`nirojasva`,
{user}`TonyBagnall`
