# v0.7.1

March 2024

## Highlights

- Adds the `RIST`, `Hydra`, `MR-Hydra` and `QUANT` classifiers ({user}`MatthewMiddlehurst`)
- Adds the above for regression also, as well as `MLPRegressor`, `RDSTRegressor` and simple feature-based regressors ({user}`MatthewMiddlehurst`, {user}`aadya940` )
- Adds the `SBD` distance ({user}`CodeLionX`)
- Website updates and improvements, including advertisement for GSoC 2024! ({user}`MatthewMiddlehurst`)

## Classification

### Documentation

- [DOC] Fix typo in _lite_time.py ({pr}`1224`) {user}`aadya940`
- [DOC] updated shapedtw ({pr}`1245`) {user}`AnonymousCodes911`
- [DOC] Conformed to new-standards ({pr}`1256`) {user}`AnonymousCodes911`
- [DOC] classification notebooks upgrade ({pr}`1185`) {user}`TonyBagnall`

### Enhancements

- [ENH] Refactored series_length and n_instances to n_timepoints and n_cases ({pr}`1163`) {user}`Raya679`
- [ENH] RIST classifier and regressor ({pr}`1180`) {user}`MatthewMiddlehurst`
- [ENH] Implement Hydra and MR-Hydra transform and classifier ({pr}`1173`) {user}`MatthewMiddlehurst`
- [ENH] QUANT classifier and transformer ({pr}`1174`) {user}`MatthewMiddlehurst`
- [ENH] Refactored series_length and n_instances to n_timepoints and n_cases in dictionary based classifiers #1151 ({pr}`1203`) {user}`Vedant222`
- [ENH] Refactoring Deep learning classifier/clusterer/regression parameters ({pr}`1188`) {user}`itsdivya1309`
- [ENH] Changes to `BaseClassifier` and `BaseRegressor` ({pr}`1200`) {user}`MatthewMiddlehurst`
- [ENH] Add minibatch param in MLPClassifier ({pr}`1257`) {user}`aadya940`

### Maintenance

- [MNT] Remove random_state from aeon.networks module ({pr}`1222`) {user}`aadya940`

## Datasets

### Enhancements

- [ENH] Refactored n_instances to n_cases and series_length to n_timepoints ({pr}`1166`) {user}`Raya679`
- [ENH] Function to write to Monash tsf style ({pr}`1146`) {user}`itsdivya1309`

## Distances

### Bug Fixes

- [BUG] make metric precomputed in distances sklearn tests ({pr}`1193`) {user}`TonyBagnall`

### Enhancements

- [ENH] Add implementation for sbd distance (from k-Shape) ({pr}`1231`) {user}`CodeLionX`

## Forecasting

### Enhancements

- [ENH] Remove use of PinballLoss object ({pr}`1175`) {user}`TonyBagnall`
- [ENH] Purge check_is_mtype ({pr}`1160`) {user}`TonyBagnall`

## Networks

### Documentation

- [DOC] Fix typo in networks._lite module ({pr}`1216`) {user}`aadya940`

### Maintenance

- [MNT] Remove random_state from aeon.networks module ({pr}`1222`) {user}`aadya940`

## Regression

### Enhancements

- [ENH] RIST classifier and regressor ({pr}`1180`) {user}`MatthewMiddlehurst`
- [ENH] Refactoring Deep learning classifier/clusterer/regression parameters ({pr}`1188`) {user}`itsdivya1309`
- [ENH] Port RDST for regression ({pr}`1209`) {user}`MatthewMiddlehurst`
- [ENH] Changes to `BaseClassifier` and `BaseRegressor` ({pr}`1200`) {user}`MatthewMiddlehurst`
- [ENH] Add feature-based regressors ({pr}`1208`) {user}`MatthewMiddlehurst`
- [ENH] Add MLPRegressor  ({pr}`1214`) {user}`aadya940`

### Maintenance

- [MNT] Remove random_state from aeon.networks module ({pr}`1222`) {user}`aadya940`

## Transformations

### Documentation

- [DOC] Fix typos, misspellings & capitalizations in doctrings ({pr}`1192`) {user}`nimanzik`

### Enhancements

- [ENH] Purge check_is_mtype ({pr}`1160`) {user}`TonyBagnall`
- [ENH] Implement Hydra and MR-Hydra transform and classifier ({pr}`1173`) {user}`MatthewMiddlehurst`
- [ENH] QUANT classifier and transformer ({pr}`1174`) {user}`MatthewMiddlehurst`
- [ENH] Added rocket on gpu ({pr}`1199`) {user}`hadifawaz1999`

### Maintenance

- [MNT] replacing __author__ by __maintainer__ in rocket gpu new merge ({pr}`1250`) {user}`hadifawaz1999`

## Unit Testing

### Bug Fixes

- [BUG] make metric precomputed in distances sklearn tests ({pr}`1193`) {user}`TonyBagnall`

### Maintenance

- [MNT] Force all numba functions to cache during CI runs ({pr}`1262`) {user}`chrisholder`

## Other

### Bug Fixes

- [BUG] Fix registry.all_estimators() function if pytest is not installed ({pr}`1236`) {user}`CodeLionX`

### Documentation

- [DOC] Fix broken links in changelog.md ({pr}`1159`) {user}`baraline`
- [DOC] Various docstring fixes ({pr}`1196`) {user}`MatthewMiddlehurst`
- [DOC] Fix Typo in testing docs ({pr}`1215`) {user}`aadya940`
- [DOC] Update `Contributing to aeon` webpage ({pr}`1212`) {user}`MatthewMiddlehurst`
- [DOC] Update website developer guide ({pr}`1259`) {user}`MatthewMiddlehurst`
- [DOC] Tidy up examples page ({pr}`1268`) {user}`MatthewMiddlehurst`
- [DOC] Final webpage update for GSoC advertisement ({pr}`1276`) {user}`MatthewMiddlehurst`

### Enhancements

- [ENH] Gather definitions of abstract datatypes. ({pr}`1179`) {user}`TonyBagnall`

### Maintenance

- [MNT] Revert workflow images to `ubuntu-20.04` and change `pytest-xdist` config ({pr}`1162`) {user}`MatthewMiddlehurst`
- [MNT] Numba workflow caching ({pr}`849`) {user}`chrisholder`
- [MNT] Numba cache add OS to key ({pr}`1252`) {user}`chrisholder`
- [MNT] Numba workflow caching for examples ({pr}`1253`) {user}`chrisholder`

### Refactored

- [REF] Refactoring some bits of code ({pr}`1275`) {user}`AnonymousCodes911`

### Other

- [ENH] Replace check_is_scitype with is_single_series and is_collection ({pr}`1190`) {user}`TonyBagnall`

## Contributors

The following have contributed to this release through a collective 42 GitHub Pull Requests:

{user}`aadya940`,
{user}`AnonymousCodes911`,
{user}`baraline`,
{user}`chrisholder`,
{user}`CodeLionX`,
{user}`hadifawaz1999`,
{user}`itsdivya1309`,
{user}`MatthewMiddlehurst`,
{user}`nimanzik`,
{user}`Raya679`,
{user}`TonyBagnall`,
{user}`Vedant222`

# v0.7.0

February 2024

## Highlights

- Implementations of the `SASTTransformer` and `SASTClassifier` ({user}`frankl1`)
- `fit_predict`/`fit_predict_proba` methods in `BaseClassifier` for (sensibly) estimating accuracy on train data ({user}`MatthewMiddlehurst`)
- ResNet based auto-encoder to deep learning `clustering` module ({user}`xiaopu222`)
- Introducing `BaseSegmenter` for segmentation module ({user}`TonyBagnall`)
- Python 3.12 is now available!
- Various additions, documentation updates, and implementations for the `visualisation` module
- Many deprecations of old and unmaintained functionality (if you wish to help maintaining these, please get in touch!)

## Benchmarking

### Bug Fixes

- [BUG] Allow upper case cluster aliases ({pr}`1008`) {user}`TonyBagnall`

### Enhancements

- [ENH] Improvements to scatterplot when lower is better ({pr}`1010`) {user}`dguijo`
- [ENH] Load the regression results from tsc.com ({pr}`1034`) {user}`TonyBagnall`
- [ENH] speed up testing ({pr}`1096`) {user}`TonyBagnall`
- [ENH] Data and results loading update ({pr}`1115`) {user}`TonyBagnall`
- [ENH] Remove name RSTSF ({pr}`1128`) {user}`TonyBagnall`
- [ENH] New plot for significance relationships ({pr}`954`) {user}`TonyBagnall`

### Other

- [ENH] Improve Pairwise-Visualizations in plot_scatter() ({pr}`1021`) {user}`patrickzib`

## Classification

### Bug Fixes

- [ENH][BUG] Change predict_proba of WEASEL_v2 to the default behavior, as in RocketClassifier ({pr}`1022`) {user}`patrickzib`
- [BUG] Fixed missing z-normalisation for SFA in RED CoMETS ({pr}`1057`) {user}`zy18811`
- [BUG] remove base classifier shortcut and new test ({pr}`741`) {user}`hedeershowk`
- [BUG] Wrong bound on sklearn for sparse argument ({pr}`1112`) {user}`julu98`

### Deprecation

- [DEP] Deprecate `MatrixProfileClassifier` ({pr}`1082`) {user}`MatthewMiddlehurst`
- [ENH] Adds missing deprecation for parameter support_probabilities ({pr}`1028`) {user}`patrickzib`

### Documentation

- [DOC] Updated paper reference for RED CoMETS ({pr}`1058`) {user}`zy18811`

### Enhancements

- [ENH] ADD SAST transformer and SASTClassifier ({pr}`958`) {user}`frankl1`
- [ENH] Test code for code in test directories ({pr}`989`) {user}`TonyBagnall`
- [ENH] Reorganise mock estimators in utils ({pr}`1045`) {user}`TonyBagnall`
- [ENH] The Default value for use_mini_batch_size should be set to False ({pr}`1065`) {user}`andregdmitri`
- [ENH] Adds missing deprecation for parameter support_probabilities ({pr}`1028`) {user}`patrickzib`
- [ENH] Classification `_fit_predict` mockup ({pr}`1107`) {user}`MatthewMiddlehurst`
- [ENH] Remove conversion decorators from SignaturesClassifier ({pr}`1101`) {user}`TonyBagnall`
- [ENH] Base classifier class docstrings ({pr}`1131`) {user}`TonyBagnall`
- [ENH] Classifier pipeline rework, remove operator overload and delegate class ({pr}`401`) {user}`MatthewMiddlehurst`
- [ENH] `BaseClassifier` testing for `fit_predict`/`fit_predict_proba` and classifier conversions to use said methods ({pr}`1116`) {user}`MatthewMiddlehurst`

### Maintenance

- [MNT] Fixes deprecation warnings for save_transformed_data in interval based classifiers ({pr}`1145`) {user}`TonyBagnall`

### Refactored

- [REF] Fixed the default use_mini_batch_size value in resnet ({pr}`1073`) {user}`jose-gilberto`

## Clustering

### Bug Fixes

- [BUG] Allow upper case cluster aliases ({pr}`1008`) {user}`TonyBagnall`

### Documentation

- [DOC, REF] Add `TimeSeriesKernelKMeans` and `TimeSeriesKShapes` to `clustering/__init__.py` and also adds examples to dosctring ({pr}`1097`) {user}`andregdmitri`

### Enhancements

- [ENH] Clustering testing ({pr}`1003`) {user}`TonyBagnall`
- [ENH] Introducing visualisation module ({pr}`1002`) {user}`TonyBagnall`
- [ENH] Add `clustering_accuracy_score` to metrics ({pr}`1048`) {user}`MatthewMiddlehurst`
- [ENH] speed up testing ({pr}`1096`) {user}`TonyBagnall`
- [ENH] Add ResNet based auto-encoder to deep clustering module ({pr}`1124`) {user}`xiaopu222`

### Refactored

- [DOC, REF] Add `TimeSeriesKernelKMeans` and `TimeSeriesKShapes` to `clustering/__init__.py` and also adds examples to dosctring ({pr}`1097`) {user}`andregdmitri`

## Datasets

### Enhancements

- [ENH] New regression problems ({pr}`1006`) {user}`TonyBagnall`
- [ENH] Retrieve metadata for datasets from tsc.com ({pr}`1025`) {user}`TonyBagnall`
- [ENH] Centralise testing data generation ({pr}`1105`) {user}`TonyBagnall`
- [ENH] `.arff` writer function ({pr}`1023`) {user}`MatthewMiddlehurst`
- [ENH] Data and results loading update ({pr}`1115`) {user}`TonyBagnall`

### Maintenance

- [MNT] remove distutils ({pr}`1084`) {user}`TonyBagnall`

### Other

- [BUG] Fix overnight loading test ({pr}`1127`) {user}`TonyBagnall`

## Distances

### Enhancements

- [ENH] speed up testing ({pr}`1096`) {user}`TonyBagnall`

## Forecasting

### Deprecation

- [ENH] Deprecate functors from performance metrics and replace with function calls ({pr}`1081`) {user}`TonyBagnall`

### Enhancements

- [ENH] Reorganise mock estimators in utils ({pr}`1045`) {user}`TonyBagnall`
- [ENH] Exclude MockUnivariateForecasterLogger from test_non_state_changing_method_contract ({pr}`1068`) {user}`TonyBagnall`
- [ENH] Tidy up the utils directory ({pr}`1042`) {user}`TonyBagnall`
- [ENH] Remove tensor flow probability, replace with scipy ({pr}`1087`) {user}`TonyBagnall`
- [ENH] Deprecate functors from performance metrics and replace with function calls ({pr}`1081`) {user}`TonyBagnall`

## Networks

### Enhancements

- [ENH] Some fixes network module ({pr}`1122`) {user}`hadifawaz1999`
- [ENH] Add ResNet based auto-encoder to deep clustering module ({pr}`1124`) {user}`xiaopu222`

## Regression

### Enhancements

- [ENH] New regression problems ({pr}`1006`) {user}`TonyBagnall`
- [ENH] The Default value for use_mini_batch_size should be set to False ({pr}`1065`) {user}`andregdmitri`

### Refactored

- [REF] Fixed the default use_mini_batch_size value in resnet ({pr}`1073`) {user}`jose-gilberto`

## Segmentation

### Enhancements

- [ENH] Introducing BaseSegmenter for segmentation module ({pr}`946`) {user}`TonyBagnall`

### Maintenance

- [MNT] Add upper bounds for main dependencies and replace `attrs` ({pr}`1106`) {user}`MatthewMiddlehurst`

## Similarity Search

### Bug Fixes

- [ENH, BUG, DOC] Refactor distance profiles, introduce STD threshold for numba ({pr}`957`) {user}`baraline`

### Documentation

- [ENH, BUG, DOC] Refactor distance profiles, introduce STD threshold for numba ({pr}`957`) {user}`baraline`
- [ENH, DOC] Add Euclidean distance with convolution for similarity search ({pr}`1009`) {user}`baraline`

### Enhancements

- [ENH, BUG, DOC] Refactor distance profiles, introduce STD threshold for numba ({pr}`957`) {user}`baraline`
- [ENH, DOC] Add Euclidean distance with convolution for similarity search ({pr}`1009`) {user}`baraline`

## Transformations

### Bug Fixes

- [ENH, BUG, DOC] Refactor distance profiles, introduce STD threshold for numba ({pr}`957`) {user}`baraline`
- [BUG] Collection transformer wrapper bugfixing and `PlateauFinder` refactor ({pr}`804`) {user}`MatthewMiddlehurst`

### Documentation

- [ENH, BUG, DOC] Refactor distance profiles, introduce STD threshold for numba ({pr}`957`) {user}`baraline`
- [ENH] Removes a whole load of references to "scitype" and "mtype" ({pr}`1035`) {user}`TonyBagnall`

### Enhancements

- [ENH] remove unnecessary call to check_X in SFA and SFA_Fast ({pr}`994`) {user}`TonyBagnall`
- [ENH] ADD SAST transformer and SASTClassifier ({pr}`958`) {user}`frankl1`
- [ENH, BUG, DOC] Refactor distance profiles, introduce STD threshold for numba ({pr}`957`) {user}`baraline`
- [ENH] Introducing visualisation module ({pr}`1002`) {user}`TonyBagnall`
- [ENH] Removes a whole load of references to "scitype" and "mtype" ({pr}`1035`) {user}`TonyBagnall`
- [ENH] Deprecate Filter transformer ({pr}`1110`) {user}`TonyBagnall`
- [ENH] Remove conversion decorators from SignaturesClassifier ({pr}`1101`) {user}`TonyBagnall`
- [ENH] New base classes: base series estimator , segmenters and base series transformers ({pr}`996`) {user}`TonyBagnall`

### Maintenance

- [MNT] remove is_numeric ({pr}`1083`) {user}`TonyBagnall`
- [MNT] remove distutils ({pr}`1084`) {user}`TonyBagnall`

## Unit Testing

### Bug Fixes

- [BUG] Correct imports for `visualisation` testing ({pr}`1090`) {user}`MatthewMiddlehurst`

### Enhancements

- [ENH] Clustering testing ({pr}`1003`) {user}`TonyBagnall`
- [ENH] Reorganise mock estimators in utils ({pr}`1045`) {user}`TonyBagnall`
- [ENH] Exclude MockUnivariateForecasterLogger from test_non_state_changing_method_contract ({pr}`1068`) {user}`TonyBagnall`
- [ENH] Testing and basic notebooks for series and learning task specific plotting functions ({pr}`1051`) {user}`MatthewMiddlehurst`
- [ENH] Testing for estimator specific plotting functions ({pr}`1071`) {user}`MatthewMiddlehurst`
- [ENH] Centralise testing data generation ({pr}`1105`) {user}`TonyBagnall`
- [ENH] Testing and changes for results plotting functions ({pr}`1092`) {user}`MatthewMiddlehurst`
- [ENH] `BaseClassifier` testing for `fit_predict`/`fit_predict_proba` and classifier conversions to use said methods ({pr}`1116`) {user}`MatthewMiddlehurst`
- [ENH] Tidy up data_gen ({pr}`1129`) {user}`TonyBagnall`

### Maintenance

- [MNT] Add `pytest` plugin to retry failed tests ({pr}`1043`) {user}`MatthewMiddlehurst`
- [MNT] Legacy deprecation ({pr}`1114`) {user}`TonyBagnall`

### Refactored

- [REF] Rename `tests` to `testing` and move utilities for generating expected results to the folder. ({pr}`1041`) {user}`MatthewMiddlehurst`
- [REF] Refactor `utils._testing` to `testing.utils` ({pr}`1047`) {user}`MatthewMiddlehurst`

## Visualisations

### Bug Fixes

- [BUG] Correct imports for `visualisation` testing ({pr}`1090`) {user}`MatthewMiddlehurst`

### Deprecation

- [MNT] Deprecate old `plot_series` functions and policy clarification ({pr}`1054`) {user}`MatthewMiddlehurst`

### Enhancements

- [ENH] scatter plots enhancement.  ({pr}`1033`) {user}`dguijo`
- [ENH,REF] Refactor `visualisation` and add temporal importance curves function ({pr}`1050`) {user}`MatthewMiddlehurst`
- [ENH] Testing and basic notebooks for series and learning task specific plotting functions ({pr}`1051`) {user}`MatthewMiddlehurst`
- [ENH] Testing for estimator specific plotting functions ({pr}`1071`) {user}`MatthewMiddlehurst`
- [ENH] Testing and changes for results plotting functions ({pr}`1092`) {user}`MatthewMiddlehurst`
- [ENH, MNT] Changes to docs in significance plots and stats. ({pr}`1141`) {user}`dguijo`

### Maintenance

- [MNT] Deprecate old `plot_series` functions and policy clarification ({pr}`1054`) {user}`MatthewMiddlehurst`
- [ENH, MNT] Changes to docs in significance plots and stats. ({pr}`1141`) {user}`dguijo`

### Refactored

- [ENH,REF] Refactor `visualisation` and add temporal importance curves function ({pr}`1050`) {user}`MatthewMiddlehurst`

## Other

### Bug Fixes

- [BUG] fix tag errors, refactor comments np.array -> np.ndarray ({pr}`1014`) {user}`TonyBagnall`
- [MNT, BUG] Modify njit func generator to support python functions ({pr}`1044`) {user}`baraline`

### Deprecation

- [MNT] Deprecate `mlflow` functionality ({pr}`968`) {user}`MatthewMiddlehurst`

### Documentation

- [DOC] remove plot_critical_difference from benchmarking API ({pr}`1040`) {user}`TonyBagnall`
- [DOC,MNT] Tidy up GitHub txt links and update dockerfile version ({pr}`1075`) {user}`MatthewMiddlehurst`
- [DOC] Update index page and images ({pr}`1080`) {user}`MatthewMiddlehurst`
- [DOC] `aeon` mentoring/project webpage ({pr}`1085`) {user}`baraline`
- [DOC] API tidy ({pr}`1140`) {user}`TonyBagnall`
- [DOC] Tidy up developers  guide ({pr}`1139`) {user}`TonyBagnall`

### Enhancements

- [ENH] purge todo ({pr}`995`) {user}`TonyBagnall`
- [ENH] More purging of datatypes ({pr}`993`) {user}`TonyBagnall`
- [ENH] Purge datatypes from utils ({pr}`1015`) {user}`TonyBagnall`
- [ENH] Remove the PODS adaptor ({pr}`1038`) {user}`TonyBagnall`
- [ENH] Update `scikit-learn` version ({pr}`1093`) {user}`MatthewMiddlehurst`
- [MNT] Allow Python 3.12 ({pr}`861`) {user}`MatthewMiddlehurst`
- [DOC] Tidy up developers  guide ({pr}`1139`) {user}`TonyBagnall`
- [ENH] deprecates conversion functions in datatypes ({pr}`1143`) {user}`TonyBagnall`
- [ENH] Split validation and conversion in utils ({pr}`1134`) {user}`TonyBagnall`

### Maintenance

- [MNT] Release workflow typo fix ({pr}`991`) {user}`MatthewMiddlehurst`
- [MNT] Remove ! marks ({pr}`1027`) {user}`TonyBagnall`
- [MNT, BUG] Modify njit func generator to support python functions ({pr}`1044`) {user}`baraline`
- [MNT] Set upper bound for `tensorflow` ({pr}`1070`) {user}`MatthewMiddlehurst`
- [DOC,MNT] Tidy up GitHub txt links and update dockerfile version ({pr}`1075`) {user}`MatthewMiddlehurst`
- [MNT] Stop the bot from commenting on other bots PRs ({pr}`1079`) {user}`MatthewMiddlehurst`
- [MNT] Add `pyupgrade` hook ({pr}`1056`) {user}`MatthewMiddlehurst`
- [MNT] Update `numba` bound ({pr}`1133`) {user}`MatthewMiddlehurst`
- [MNT] Disable `sweep` and other small maintenance bits ({pr}`1132`) {user}`MatthewMiddlehurst`
- [MNT] Allow Python 3.12 ({pr}`861`) {user}`MatthewMiddlehurst`
- [MNT] Deprecate `mlflow` functionality ({pr}`968`) {user}`MatthewMiddlehurst`
- [MNT] Further isolation of datatypes ({pr}`1117`) {user}`TonyBagnall`

## Contributors

The following have contributed to this release through a collective 91 GitHub Pull Requests:

{user}`andregdmitri`,
{user}`baraline`,
{user}`dguijo`,
{user}`frankl1`,
{user}`hadifawaz1999`,
{user}`hedeershowk`,
{user}`jose-gilberto`,
{user}`julu98`,
{user}`MatthewMiddlehurst`,
{user}`patrickzib`,
{user}`TonyBagnall`,
{user}`xiaopu222`,
{user}`zy18811`
