# v0.11.0

August 2024

Reminder: This release will be the last 0.X minor release. Other than patches, the next release will be 1.0.0 which contains a large amount of framework changes.

## Highlights

- Added Proximity Forest classifier ({user}`itsdivya1309`)
- Added a composable ensemble for classification and regression ({user}`MatthewMiddlehurst`)
- New deep learning networks in AEBiGRUNetwork, AEDRNNNetwork and AEAttentionBiGRUNetwork ({user}`aadya940`)
- Lots of bug and documentation fixes

## Anomaly Detection

### Enhancements

- [ENH/DOC] Unsupervised and semi-supervised usage of PyODAdapter ({pr}`1932`) {user}`CodeLionX`

## Classification

### Bug Fixes

- [BUG] Check data shape in `predict`-like functions ({pr}`1865`) {user}`MatthewMiddlehurst`

### Deprecation

- [DEP] Move MRSQM to dictionary based ({pr}`1821`) {user}`TonyBagnall`

### Documentation

- [DOC] Fix DL classification notebook ({pr}`1862`) {user}`MatthewMiddlehurst`
- [DOC] Update paper referenced in Arsenal docs ({pr}`1892`) {user}`Cyril-Meyer`
- [ENH] Remove BaseClassifier unnecessary declarations ({pr}`1887`) {user}`TonyBagnall`
- [DOC] Correct sast tags to shapelet ({pr}`1935`) {user}`IRKnyazev`

### Enhancements

- [ENH] Change HC2 test to balance class ({pr}`1795`) {user}`TonyBagnall`
- [ENH] at kwargs to fit_predict to allow setting of the cv_size parameter in default ({pr}`1767`) {user}`TonyBagnall`
- [ENH,MNT,DOC] Tidying up deep learning modules clasification/regression ({pr}`1826`) {user}`hadifawaz1999`
- [ENH] Implement Proximity Forest classifier ({pr}`1729`) {user}`itsdivya1309`
- [ENH] Remove BaseClassifier unnecessary declarations ({pr}`1887`) {user}`TonyBagnall`
- [ENH] Composable ensemble for classification and regression ({pr}`1853`) {user}`MatthewMiddlehurst`
- [ENH] Adds the option of using callable distances for kNN regressor ({pr}`1965`) {user}`dguijo`

### Maintenance

- [MNT] Unit testing revamp part 2: classification ({pr}`1770`) {user}`MatthewMiddlehurst`

## Clustering

### Bug Fixes

- [BUG] Kmeans pass through random state to averaging methods ({pr}`1850`) {user}`chrisholder`
- [BUG] Fixed CLARA issue ({pr}`1924`) {user}`chrisholder`
- [BUG] Check data shape in `predict`-like functions ({pr}`1865`) {user}`MatthewMiddlehurst`

### Documentation

- [DOC][REF] K-Shape rename and add references ({pr}`1899`) {user}`Cyril-Meyer`

### Maintenance

- [MNT] Make input clustering algorithm for deep leaning an estimator parameter instead of string ({pr}`1944`) {user}`hadifawaz1999`
- [MNT] Add metrics parameter for deep clustering module (#1945) ({pr}`1958`) {user}`ghost`

### Refactored

- [DOC][REF] K-Shape rename and add references ({pr}`1899`) {user}`Cyril-Meyer`

## Datasets

### Documentation

- [DOC] Removed incomplete line from write_to_tsfile ({pr}`1808`) {user}`harshithasudhakar`
- [DOC] Resolved issue 1829 - corrected docstring param return_metadata to False ({pr}`1843`) {user}`IRKnyazev`

### Other

- [ENH] Add support for handling file extensions in load_from_tsfile ({pr}`1953`) {user}`Sharathchenna`

## Distances

### Bug Fixes

- [BUG] Fixed incorrect bounding enforcement ({pr}`1871`) {user}`chrisholder`
- [BUG] Fix bug in shape dtw pairwise function ({pr}`1975`) {user}`hadifawaz1999`

### Documentation

- [DOC] Fix 2 typos in distances notebook ({pr}`1873`) {user}`Datadote`
- [DOC, ENH] Updating distance's notebooks + tests to ensure sklearn compatibility ({pr}`1838`) {user}`dguijo`

### Enhancements

- [ENH] Plot the pairwise distance between two time series ({pr}`1977`) {user}`dguijo`

## Forecasting

### Documentation

- [DOC] Converging towards numpy doc standards V2 - issue #1540  ({pr}`1863`) {user}`IRKnyazev`

## Networks

### Bug Fixes

- [BUG] Fix config of AEBiGRUNetwork from encoder to auto-encoder ({pr}`1786`) {user}`hadifawaz1999`

### Deprecation

- [DEP] Remove old class base deep network ({pr}`1817`) {user}`hadifawaz1999`

### Documentation

- [DOC] Converging towards numpy doc standards V2 - issue #1540  ({pr}`1863`) {user}`IRKnyazev`

### Enhancements

- [ENH] Add AEBiGRUNetwork ({pr}`1583`) {user}`aadya940`
- [ENH,MNT,DOC] Tidying up deep learning modules clasification/regression ({pr}`1826`) {user}`hadifawaz1999`
- [ENH] Improve deep learning networks test coverage for parameters which can be list ({pr}`1851`) {user}`Cyril-Meyer`
- [ENH] Improve deep learning networks test coverage ({pr}`1870`) {user}`Cyril-Meyer`
- [ENH] Add AEDRNNNetwork ({pr}`1577`) {user}`aadya940`
- [ENH] Implement AEAttentionBiGRUNetwork ({pr}`1608`) {user}`aadya940`

### Maintenance

- [MNT] Remove tensorflow-addons dependency ({pr}`1869`) {user}`Cyril-Meyer`
- [MNT] Make input clustering algorithm for deep leaning an estimator parameter instead of string ({pr}`1944`) {user}`hadifawaz1999`

## Regression

### Bug Fixes

- [BUG] Check data shape in `predict`-like functions ({pr}`1865`) {user}`MatthewMiddlehurst`

### Enhancements

- [ENH,MNT,DOC] Tidying up deep learning modules clasification/regression ({pr}`1826`) {user}`hadifawaz1999`
- [ENH] Composable ensemble for classification and regression ({pr}`1853`) {user}`MatthewMiddlehurst`
- [ENH] Adds the option of using callable distances for kNN regressor ({pr}`1965`) {user}`dguijo`

### Maintenance

- [MNT] Unit testing revamp part 3: regression ({pr}`1875`) {user}`MatthewMiddlehurst`

## Segmentation

### Documentation

- [DOC] Update the docstring for BaseSegmenter ({pr}`1741`) {user}`TonyBagnall`

## Similarity Search

### Documentation

- [DOC] Update type hints for similarity search ({pr}`1939`) {user}`phershbe`
- [DOC] Update type hints for distance profiles ({pr}`1981`) {user}`phershbe`

## Transformations

### Bug Fixes

- [BUG] Add names to create steps_ in CollectionPipeline ({pr}`1796`) {user}`TonyBagnall`
- [BUG] Bug fixes for interval classes ({pr}`1988`) {user}`MatthewMiddlehurst`

### Deprecation

- [DEP] Remove legacy PandasAdaptor, move TabularToSeriesAdaptor to legacy ({pr}`1789`) {user}`TonyBagnall`
- [DEP] Remove BKFilter BaseTransformer, redesign equivalent series transformer ({pr}`1788`) {user}`TonyBagnall`
- [DEP] Remove Split mixin ({pr}`1613`) {user}`TonyBagnall`
- [DEP] Remove redundant multivariate rockets ({pr}`1791`) {user}`TonyBagnall`
- [DEP] Remove DateTime and FourierFeatures ({pr}`1792`) {user}`TonyBagnall`
- [DEP] Move transformations.compose to legacy and isolate uses to forecasting. ({pr}`1790`) {user}`TonyBagnall`
- [DEP] Move summarizer to legacy ({pr}`1833`) {user}`TonyBagnall`
- [DEP] Remove Theta ({pr}`1832`) {user}`TonyBagnall`
- [DEP] Move HampelFilter to legacy ({pr}`1830`) {user}`TonyBagnall`
- [DEP] Move Lag to legacy ({pr}`1827`) {user}`TonyBagnall`
- [DEP] Remove _IndexSubset ({pr}`1831`) {user}`TonyBagnall`
- [DEP] Move exponent transformer to legacy ({pr}`1822`) {user}`TonyBagnall`
- [DEP] deprecated bootstrap to legacy ({pr}`1818`) {user}`TonyBagnall`
- [DEP] detrenders to legacy ({pr}`1819`) {user}`TonyBagnall`
- [DEP] Remove hierarchical transformers to legacy ({pr}`1820`) {user}`TonyBagnall`
- [DEP] Move impute to legacy ({pr}`1823`) {user}`TonyBagnall`
- [DEP] Remove FeatureSelection transformer ({pr}`1890`) {user}`TonyBagnall`
- [DEP] Remove FunctionTransformer ({pr}`1891`) {user}`TonyBagnall`
- [DEP] Remove update in BaseCollectionTransformer ({pr}`1894`) {user}`TonyBagnall`

### Documentation

- [DOC] DFT instead of PAA in SFA docstring ({pr}`1849`) {user}`hadifawaz1999`
- [DOC] Correct sast tags to shapelet ({pr}`1935`) {user}`IRKnyazev`
- [DOC] Added Type Hints for _dilated_shapelet_transform  ({pr}`1949`) {user}`aryanpola`

### Enhancements

- [ENH] channel selector test ({pr}`1783`) {user}`TonyBagnall`
- [ENH] Fixes in Catch22 ({pr}`1809`) {user}`Moonzyyy`
- [ENH] Import RandomChannelSelector through init ({pr}`1933`) {user}`TonyBagnall`
- [ENH] Added useful attributes to extracted shapelets for RDST ({pr}`1959`) {user}`IRKnyazev`
- [ENH] Discrete Fourier Approximation Transformer ({pr}`1967`) {user}`Cyril-Meyer`
- [ENH] add type hints to _shapelet_transform.py __init__ method ({pr}`1926`) {user}`Datadote`

### Other

- Added type hints for rsast and sast files ({pr}`1994`) {user}`aryanpola`

## Unit Testing

### Bug Fixes

- [BUG] Fixed incorrect bounding enforcement ({pr}`1871`) {user}`chrisholder`

### Enhancements

- [ENH] Add minimum number of class labels for numpy data generators ({pr}`1974`) {user}`MatthewMiddlehurst`

### Maintenance

- [MNT] Add Regressor Results For Comparison ({pr}`1787`) {user}`harshithasudhakar`
- [MNT] Fix sporadic PF breakage and `matplotlib` version bound ({pr}`1906`) {user}`MatthewMiddlehurst`
- [MNT] Unit testing revamp part 2: classification ({pr}`1770`) {user}`MatthewMiddlehurst`
- [MNT] Unit testing revamp part 3: regression ({pr}`1875`) {user}`MatthewMiddlehurst`

## Visualisations

### Bug Fixes

- [BUG] Mapped input index to class index for shapelet viz  ({pr}`1943`) {user}`IRKnyazev`
- [BUG] Corrected shapelet plot for RDST  ({pr}`1971`) {user}`IRKnyazev`

### Documentation

- [DOC] Update shapelet notebook ({pr}`1824`) {user}`baraline`

### Enhancements

- [ENH] Plot the pairwise distance between two time series ({pr}`1977`) {user}`dguijo`

## Other

### Bug Fixes

- [BUG] get_n_channels check channels consistent ({pr}`1895`) {user}`Cyril-Meyer`

### Documentation

- [DOC] Typo correction in getting started guide ({pr}`1842`) {user}`IRKnyazev`
- [DOC] Correct info for issue assign bot ({pr}`1860`) {user}`MatthewMiddlehurst`
- [Doc] Corrected mis-rendered double references. ({pr}`1883`) {user}`IRKnyazev`
- [DOC] Add ddtw distance to the API references ({pr}`1897`) {user}`Cyril-Meyer`
- [DOC] Change order of build and install instructions for clarity ({pr}`1915`) {user}`phershbe`
- [DOC] Grammar corrections to developer installation and installation ({pr}`1918`) {user}`phershbe`
- [DOC] Shapelet classifier notebook extensions & minor docstring corrections ({pr}`1930`) {user}`IRKnyazev`

### Enhancements

- [ENH] Documentation fixes and function changes for `BaseCollectionEstimator` ({pr}`1864`) {user}`MatthewMiddlehurst`

### Maintenance

- [MNT] Adding Scorecard.yml Workflow and Scorecard Badge GOSST ({pr}`1619`) {user}`PatriceJada`
- [MNT] `mrsqm` and `pycatch22` bounds ({pr}`1753`) {user}`MatthewMiddlehurst`
- [MNT] Scorecard badge fix ({pr}`1804`) {user}`MatthewMiddlehurst`
- [MNT] Update `scikit-learn` version ({pr}`1803`) {user}`MatthewMiddlehurst`
- [MNT] Raise `numba` version bound ({pr}`1814`) {user}`MatthewMiddlehurst`
- [MNT] Try shifting to Ubuntu 22.04 ({pr}`1929`) {user}`hadifawaz1999`

## Contributors

The following have contributed to this release through a collective 91 GitHub Pull Requests:

{user}`aadya940`,
{user}`aryanpola`,
{user}`baraline`,
{user}`chrisholder`,
{user}`CodeLionX`,
{user}`Cyril-Meyer`,
{user}`Datadote`,
{user}`dguijo`,
{user}`ghost`,
{user}`hadifawaz1999`,
{user}`harshithasudhakar`,
{user}`IRKnyazev`,
{user}`itsdivya1309`,
{user}`MatthewMiddlehurst`,
{user}`Moonzyyy`,
{user}`PatriceJada`,
{user}`phershbe`,
{user}`Sharathchenna`,
{user}`TonyBagnall`
