# v0.10.0

July 2024

## Highlights

- Dropped support for Python 3.8
- Announcement of deprecations for v1.0.0, includes removal and rework of the current forecasting and transformation frameworks
- New anomaly detection methods: DWT-MLEAD, K-Means, and an adapter for PyOD ({user}`CodeLionX`)
- New data loaders for anomaly detection and segmentation benchmark archives ({user}`CodeLionX`, {user}`ermshaua`)
- New Proximity Tree classifier using aeon distances, Proximity Forest to follow. ({user}`itsdivya1309`)
- New feature-based and dummy clusterers ({user}`MatthewMiddlehurst`, {user}`aadya940`)
- New FLUSS and BinSeg segmenters ({user}`patrickzib`)
- Addition of visualisation tools for shapelets ({user}`baraline`)

## Anomaly Detection

### Documentation

- [DOC] Improve anomaly detector documentation ({pr}`1647`) {user}`CodeLionX`
- [DOC] added reference to docstring of MERLIN anomaly detection ({pr}`1707`) {user}`adm-unl`

### Enhancements

- [MNT] Move haar wavelet transform to aeon.utils.numba package ({pr}`1579`) {user}`CodeLionX`
- [ENH] Convert stray and add max iterations for MERLIN ({pr}`1571`) {user}`MatthewMiddlehurst`
- [ENH] DWT-MLEAD anomaly detection method ({pr}`1580`) {user}`CodeLionX`
- [ENH] Add sliding window utils for anomaly detection module ({pr}`1605`) {user}`CodeLionX`
- [ENH] K-Means anomaly detector ({pr}`1607`) {user}`CodeLionX`
- [ENH] Loader for TimeEval (anomaly detection) datasets ({pr}`1588`) {user}`CodeLionX`
- [ENH] Add PyOD adapter for anomaly detection ({pr}`1586`) {user}`CodeLionX`

## Classification

### Bug Fixes

- [BUG] Fixing wrong output activation in MLPClassifier ({pr}`1597`) {user}`hadifawaz1999`
- [ENH,BUG] LearnedShapelets interfaced functions ({pr}`1687`) {user}`TonyBagnall`
- [BUG] Adding modelcheckpoint callback by default to deep learners when user chooses their own callbacks list ({pr}`1763`) {user}`hadifawaz1999`
- [BUG] Store n_timepoints and n_channels in fit to check in transform ({pr}`1758`) {user}`TonyBagnall`

### Deprecation

- [DEP] Rocket,RotationForest and FreshPrince deprecations (plus a bug fix) ({pr}`1648`) {user}`TonyBagnall`

### Documentation

- [DOC] remove ProximityTree from distance classifier notebook results display ({pr}`1745`) {user}`TonyBagnall`
- [DOC] typo in convolutions notebook ({pr}`1769`) {user}`TonyBagnall`

### Enhancements

- [ENH,BUG] LearnedShapelets interfaced functions ({pr}`1687`) {user}`TonyBagnall`
- [ENH] Tidy, deprecation actions and testing for sklearn estimators ({pr}`1701`) {user}`MatthewMiddlehurst`
- [ENH] Implement Proximity Tree classifier using aeon distances ({pr}`1566`) {user}`itsdivya1309`
- [ENH] REDCOMETS tweaks / fixes ({pr}`1722`) {user}`zy18811`
- [ENH] change input type for MrSQMClassifier and deprecate prior to moving package ({pr}`1735`) {user}`TonyBagnall`
- [ENH] Adds class_weight to those classifier that support it. Required for imbalanced datasets. ({pr}`1776`) {user}`patrickzib`

## Clustering

### Bug Fixes

- [BUG] Remove feature extraction from `TSFreshClusterer` ({pr}`1716`) {user}`MatthewMiddlehurst`
- [BUG] Cluster predict proba edge cases ({pr}`1739`) {user}`chrisholder`
- [BUG] Adding modelcheckpoint callback by default to deep learners when user chooses their own callbacks list ({pr}`1763`) {user}`hadifawaz1999`

### Documentation

- [DOC] Wrong number of reference in Clara ({pr}`1640`) {user}`futuer-szd`

### Enhancements

- [ENH] Add DummyClusterer ({pr}`1567`) {user}`aadya940`
- [ENH] Simple feature based clusterers ({pr}`1548`) {user}`MatthewMiddlehurst`
- [ENH] removed unused attribute from k-means ({pr}`1727`) {user}`chrisholder`

## Datasets

### Bug Fixes

- [BUG] Fix TSAD data loading tests and example notebooks ({pr}`1695`) {user}`CodeLionX`

### Enhancements

- [ENH] Loader for TimeEval (anomaly detection) datasets ({pr}`1588`) {user}`CodeLionX`
- [ENH] Time Series Segmentation Benchmark + Human Activity Segmentation Challenge data loaders ({pr}`1755`) {user}`ermshaua`

### Maintenance

- [MNT] Set segmentation data loaders for overnight tests only ({pr}`1772`) {user}`TonyBagnall`

## Distances

### Bug Fixes

- [BUG] lcss bounded below to 0 ({pr}`1610`) {user}`TonyBagnall`
- [BUG] Bugfix MinDist doctests by setting word_length to 8 ({pr}`1690`) {user}`patrickzib`

### Enhancements

- [ENH] Lower Bounding Distances for SAX and SFA ({pr}`1622`) {user}`patrickzib`

## Forecasting

WARNING: The current forecasting framework is being removed in v1.0.0. To be replaced
with a new framework. See the index page for more information.

### Bug Fixes

- [BUG] remove none argument for coerce to period ({pr}`1514`) {user}`TonyBagnall`
- [BUG] unexclude mock forecaster ({pr}`1609`) {user}`TonyBagnall`

## Networks

### Deprecation

- [DEP] Rename `BaseDeepNetwork` and deprecate inheritance of `BaseObject` ({pr}`1524`) {user}`MatthewMiddlehurst`

### Maintenance

- [MNT] Enhance networks module testing suite ({pr}`1631`) {user}`aadya940`

## Regression

### Bug Fixes

- [BUG] Remove squaring distances in KNN regression ({pr}`1697`) {user}`TonyBagnall`
- [BUG] Adding modelcheckpoint callback by default to deep learners when user chooses their own callbacks list ({pr}`1763`) {user}`hadifawaz1999`

### Deprecation

- [DEP] Rocket,RotationForest and FreshPrince deprecations (plus a bug fix) ({pr}`1648`) {user}`TonyBagnall`

### Documentation

- [DOC] Added All Regressors (2nd Attempt) ({pr}`1663`) {user}`Moonzyyy`

### Enhancements

- [ENH] Tidy, deprecation actions and testing for sklearn estimators ({pr}`1701`) {user}`MatthewMiddlehurst`

## Segmentation

### Enhancements

- [ENH] `axis=1` function default and removal of axis class default for series transformation and segmentation ({pr}`1625`) {user}`MatthewMiddlehurst`
- [ENH] Add FLUSS segmenter from stumpy ({pr}`1693`) {user}`patrickzib`
- [ENH] ClaSP: Adds parallelization for distance computations and numbarize function calls ({pr}`1692`) {user}`patrickzib`
- [ENH] Adds BinSeg Segmenter from Ruptures library ({pr}`1694`) {user}`patrickzib`
- [ENH] Time Series Segmentation Benchmark + Human Activity Segmentation Challenge data loaders ({pr}`1755`) {user}`ermshaua`

## Similarity Search

### Enhancements

- [ENH] Update similarity search with new base classes : Query Search ({pr}`1508`) {user}`baraline`

## Transformations

WARNING: The current `BaseTransformer` framework is being removed in v1.0.0. To be
replaced with individual frameworks for collection and series transformations. See the
index page for more information.

### Bug Fixes

- [BUG] Convert rockets to only use 32 bit floats internally ({pr}`1612`) {user}`TonyBagnall`
- [BUG] add check y to BaseSeriesTransformer ({pr}`1624`) {user}`TonyBagnall`
- [BUG] removed njit test exclusions ({pr}`1598`) {user}`TonyBagnall`
- [BUG] fix padder fit_values ({pr}`1752`) {user}`TonyBagnall`
- [BUG] Hydra bugfix ({pr}`1771`) {user}`MatthewMiddlehurst`

### Deprecation

- [DEP] Tidy up BaseTransformer testing ({pr}`1541`) {user}`TonyBagnall`
- [DEP] Convert clear sky transformer to new base class ({pr}`1565`) {user}`MatthewMiddlehurst`
- [DEP] Rocket,RotationForest and FreshPrince deprecations (plus a bug fix) ({pr}`1648`) {user}`TonyBagnall`
- [DEP] deprecate PandasAdaptor ({pr}`1614`) {user}`TonyBagnall`
- [DEP] remove Differencer ({pr}`1645`) {user}`TonyBagnall`
- [DEP] Remove augmenters, binning, cos, sqrt ({pr}`1668`) {user}`TonyBagnall`
- [DEP] Remove kalman filter and time since ({pr}`1669`) {user}`TonyBagnall`
- [DEP] Remove ClearSky ({pr}`1673`) {user}`TonyBagnall`
- [DEP] make BoxCox legacy ({pr}`1672`) {user}`TonyBagnall`
- [DEP] remove PCA ({pr}`1674`) {user}`TonyBagnall`
- [DEP] v0.10 move ColumnSelect and IndexSelect to legacy ({pr}`1675`) {user}`TonyBagnall`
- [DEP] deprecate compose ({pr}`1679`) {user}`TonyBagnall`
- [DEP] V0.10 remove ACF/PACF ({pr}`1678`) {user}`TonyBagnall`
- [DEP] Dep fest ({pr}`1680`) {user}`TonyBagnall`
- [DEP] dep fest2 ({pr}`1681`) {user}`TonyBagnall`
- [DEP] dep fest3 ({pr}`1682`) {user}`TonyBagnall`
- [ENH] Add missing import for deprecation ({pr}`1721`) {user}`TonyBagnall`
- [DEP] V0.10 Move DOBIN to legacy ({pr}`1731`) {user}`TonyBagnall`
- [DEP] Deprecate the update function in BaseCollectionTransformer ({pr}`1744`) {user}`TonyBagnall`
- [DEP] Exclusion list  ({pr}`1730`) {user}`TonyBagnall`

### Documentation

- [DOC] Add SlidingWindowSegmenter to API reference ({pr}`1600`) {user}`CodeLionX`
- [Doc] Images for "Transformations"  ({pr}`1736`) {user}`Abhash297`
- [DOC] Improve BaseCollectionTransformer docstrings ({pr}`1733`) {user}`TonyBagnall`

### Enhancements

- [MNT] Move haar wavelet transform to aeon.utils.numba package ({pr}`1579`) {user}`CodeLionX`
- [ENH] Lower Bounding Distances for SAX and SFA ({pr}`1622`) {user}`patrickzib`
- [ENH] `axis=1` function default and removal of axis class default for series transformation and segmentation ({pr}`1625`) {user}`MatthewMiddlehurst`
- [ENH] Remove two  hard coded arrays from minirocket ({pr}`1698`) {user}`TonyBagnall`
- [ENH] Merge MiniRocket and MiniRocketMultivariate ({pr}`1708`) {user}`TonyBagnall`
- [ENH] Merge MultiRocket and MultiRocketMultivariate ({pr}`1711`) {user}`TonyBagnall`
- [ENH] Channel selection rocket wrapper ({pr}`1504`) {user}`TonyBagnall`
- [ENH] Shapelet visualization tools ({pr}`1715`) {user}`baraline`
- [ENH] Revert mini rocket to separate functions for univariate and multivariate ({pr}`1781`) {user}`TonyBagnall`

## Unit Testing

### Bug Fixes

- [BUG] Fix TSAD data loading tests and example notebooks ({pr}`1695`) {user}`CodeLionX`
- [BUG] Use almost equal in random state testing of deep learning ({pr}`1773`) {user}`hadifawaz1999`

### Deprecation

- [ENH] Exclude deprecated estimators ({pr}`1547`) {user}`TonyBagnall`

### Enhancements

- [ENH] Exclude deprecated estimators ({pr}`1547`) {user}`TonyBagnall`
- [ENH] Improve and refactor collection test data generation utilities ({pr}`1564`) {user}`MatthewMiddlehurst`
- [ENH] Moves a test file  ({pr}`1665`) {user}`TonyBagnall`
- [ENH] Rework series test data generators ({pr}`1592`) {user}`MatthewMiddlehurst`

### Maintenance

- [MNT] Add threads limit for numba and TF ({pr}`1604`) {user}`baraline`
- [MNT] Drop Python 3.8 ({pr}`1659`) {user}`MatthewMiddlehurst`
- [MNT] Replace Intel macOS runners with m1 macOS runners in CI ({pr}`1585`) {user}`chrisholder`
- [MNT] Unit testing revamp part 1: `check_estimator` ({pr}`1479`) {user}`MatthewMiddlehurst`

### Refactored

- [ENH] Improve and refactor collection test data generation utilities ({pr}`1564`) {user}`MatthewMiddlehurst`
- [REF] Refactor `testing.utils.data_gen` into `testing.data_generation` ({pr}`1589`) {user}`MatthewMiddlehurst`

## Visualisations

### Enhancements

- [ENH] Shapelet visualization tools ({pr}`1715`) {user}`baraline`

## Other

### Bug Fixes

- [BUG] Fix broken import causing CI to fail ({pr}`1717`) {user}`MatthewMiddlehurst`

### Deprecation

- [DEP] Remove probablistic class based metrics ({pr}`1630`) {user}`TonyBagnall`
- [DEP] remove public VectorizedDF ({pr}`1666`) {user}`TonyBagnall`
- [DEP] Remove _serialize ({pr}`1667`) {user}`TonyBagnall`
- [DEP] v0.10 move ThetaLinesTransformer to legacy ({pr}`1676`) {user}`TonyBagnall`

### Documentation

- [DOC] Fixed a typo in mentoring.md ({pr}`1700`) {user}`futuer-szd`
- [MNT,DOC] Remove `extension_templates` ({pr}`1657`) {user}`MatthewMiddlehurst`
- [DOCS] Add any papers ({pr}`1526`) {user}`TonyBagnall`
- [DOC,MNT] Documentation updates and deprecation warning for `v1.0.0` ({pr}`1743`) {user}`MatthewMiddlehurst`

### Maintenance

- [MNT] Remove stale branches ({pr}`1543`) {user}`MatthewMiddlehurst`
- [MNT] Fix `pre-commit` pushes for forks (hopefully) and easier CI label interactions ({pr}`1601`) {user}`MatthewMiddlehurst`
- [MNT] Change pre-commit trigger type ({pr}`1661`) {user}`MatthewMiddlehurst`
- [MNT] Disable `pytest` threading by default for local runs ({pr}`1656`) {user}`MatthewMiddlehurst`
- [MNT,DOC] Remove `extension_templates` ({pr}`1657`) {user}`MatthewMiddlehurst`
- [MNT] Exclude `docs` and `examples` from release source ({pr}`1658`) {user}`MatthewMiddlehurst`
- [MNT] Change `pre-commit` workflow checkout ref ({pr}`1704`) {user}`MatthewMiddlehurst`
- [MNT] Set `keras` bound to fix CI ({pr}`1723`) {user}`MatthewMiddlehurst`
- [DOC,MNT] Documentation updates and deprecation warning for `v1.0.0` ({pr}`1743`) {user}`MatthewMiddlehurst`
- [MNT] Removing `tensorflow_addons` dependency ({pr}`1421`) {user}`MatthewMiddlehurst`
- [MNT] Fix certain workflow actions for forks and add button for resetting CI ({pr}`1764`) {user}`MatthewMiddlehurst`

### Other

- [DEP] Simple removals for deprecation list for 0.10 ({pr}`1644`) {user}`TonyBagnall`
- [MNT] Raise tensorflow bound to >2.13 ({pr}`1765`) {user}`TonyBagnall`

## Contributors

The following have contributed to this release through a collective 107 GitHub Pull Requests:

{user}`aadya940`,
{user}`Abhash297`,
{user}`adm-unl`,
{user}`baraline`,
{user}`chrisholder`,
{user}`CodeLionX`,
{user}`ermshaua`,
{user}`futuer-szd`,
{user}`hadifawaz1999`,
{user}`itsdivya1309`,
{user}`MatthewMiddlehurst`,
{user}`Moonzyyy`,
{user}`patrickzib`,
{user}`TonyBagnall`,
{user}`zy18811`
