# v0.1.0

April 2023

This release follows on from [sktime v0.16.0](https://github.com/aeon-toolkit/aeon/releases/tag/sktime-v0.16.0).

Following this release the deprecation policy remains suspended. Future releases may have breaking changes, so it may be wise to set an upper bound on the package version.

## Highlights

- `aeon` is now available on PyPI!
- `pandas` 2 support is available for core functionality
- Deep learning approaches in the classification module have been reworked and are more configurable
- New estimators for classification in Inception Time ({user}`hadifawaz1999`) and WEASEL 2.0 ({user}`patrickzib`)
- Improved transformers for selecting channels of multivariate time series ({user}`haskarb`)

## Interface and breaking changes from ``sktime`` v0.16.0

### Framework

Removed separate `mlflow` install via `pip install aeon[mlfow]`. The `mlflow` dependency is now integrated in `all_extras` when doing `pip install aeon[all_extras]`, see [#81](https://github.com/aeon-toolkit/aeon/pull/81)

Removed support for Python 3.7, see [#103](https://github.com/aeon-toolkit/aeon/pull/103)

Increment `scikit-learn` lower bound version from `scikit-learn>=0.24` to `scikit-learn>=1.0.0`, see [#103](https://github.com/aeon-toolkit/aeon/pull/103)

Remove `statsforecast` from `all_extras` install temporarily because non-compliance with `pandas==2.0.0`

Increment lower bound of `pandas` to `>=1.5.3`

### Forecasting

Removed hcrystalball wrapper [#115](https://github.com/scikit-time/scikit-time/pull/115)

Renamed parameter `sktime_model` in the `mlflow` module to `estimator`.This parameter was renamed in the functions `save_model` and `log_model`. See [#221](https://github.com/aeon-toolkit/aeon/pull/221)

Forecaster `VARMAX` still requires `pandas<2.0.0`, will be relaxed in future releases.

### Classification

kNN Classifier and Regressor reimplementations [#66](https://github.com/aeon-toolkit/aeon/pull/66)
- With the removal of dists_kerns the kNN implementation had to be reworked somewhat. The old version was unnecessarily memory intensive, which has been improved. With this change comes the removal of some parameters used in the old implementation.

Remove ProximityForest classifier [#86](https://github.com/scikit-time/scikit-time/pull/86)
- This is an old implementation which crashes on the majority of UCR datasets, skips all testing and struggles to reach equivalence to its published results. While we would like an implementation of the algorithm, there is currently no one willing to maintain this version.

convolution_based rename [#90](https://github.com/aeon-toolkit/aeon/pull/90)
- The `kernel_based` package has been renamed to the more commonly used (and applicable to the classifiers) `convolution_based`. `RandomIntervalClassifier` has also moved to `interval_based`.

Remove TimeSeriesSVC [#105](https://github.com/scikit-time/scikit-time/pull/105)
- This implementation is a wrapper of the sklearn SVC for distances. Elastic distances for time series data do not generate semi-positive definite kernels, which breaks SVC assumptions. The wrapper does not align with our outlook for the distances module and has been removed for now.

Remove fit_predict in BaseClassifier [#117](https://github.com/scikit-time/scikit-time/pull/117)
- fit_predict in BaseClassifier was an inefficient alternative to simply using scikit-learn cross validation that involved coverting everything to dataframes. We think it is easier to just use scikit-learn functionality rather than reinvent the wheel (inefficiently).

Remove plotting [#127](https://github.com/aeon-toolkit/aeon/pull/127)
- The classification plotting folder adds a single file to draw a graph for CIF added without review. While we do want functionality for plotting, there was no framework or discussion with this niche and estimator specific addition.

Refactor ColumnEnsemble to ChannelEnsemble [#162](https://github.com/aeon-toolkit/aeon/pull/162)
- The term column has relevance only for pandas, if the data are stored in numpy[n_cases][n_channels][n_timepoints], calling dimension 2 "column" makes no sense. After discussion on slack, we chose channel rather than dimension (because dimension overloads on dimension of the array)

For classification: Adding InceptionTime, CNN and ResNet along with other classifiers and removing LSTM-FCN [#134](https://github.com/aeon-toolkit/aeon/pull/134)
- This is mostly new functionality, but some parameter names have been simplified, i.e. n_conv_layers > n_layers

Refactor DummyClassifier and Compose classifiers [#163](https://github.com/aeon-toolkit/aeon/pull/163)
- This PR moved the dummy classifier to the base classification directory from classification/dummy.

### Regression

kNN Classifier and Regressor reimplementations [#66](https://github.com/aeon-toolkit/aeon/pull/66)
- See classification section.

convolution_based rename [#90](https://github.com/aeon-toolkit/aeon/pull/90)
- See classification section.

Remove ComposableTimeSeriesForestRegressor [#92](https://github.com/scikit-time/scikit-time/pull/92)
- This regressor is a duplicate, and for a long time has been unusable on any dataset. The decision was made to remove it rather than maintain.

### Datasets

make single problem loaders for equal length problems return numpy arrays [#109](https://github.com/aeon-toolkit/aeon/pull/109)
- The default datatype for classification and clustering are 3D numpy arrays, so we have changed the default return type for these types of dataset. The option to return as a DataFrame is still available as a parameter.

### Clustering

Clean up clustering module [#132](https://github.com/aeon-toolkit/aeon/pull/132/)

### Transformations

Refactored PCATransformer [#26](https://github.com/aeon-toolkit/aeon/pull/26)

Removed summary function `mad` in `WindowSummarizer` and `SummaryTransformer` as in `pandas>=2.0.0` the function `mad` is not supported anymore [#153](https://github.com/aeon-toolkit/aeon/pull/153)

Remove the DistanceFeatures transformer [#143](https://github.com/aeon-toolkit/aeon/pull/143)
- The distance features transformer was a wrapper for Dists_Kerns function, [see #144](https://github.com/aeon-toolkit/aeon/issues/144).

Change output type of numerous Panel transformers [#209](https://github.com/aeon-toolkit/aeon/pull/209), [#185](https://github.com/aeon-toolkit/aeon/pull/185), [#196](https://github.com/aeon-toolkit/aeon/pull/196).
- Over time we will be changing the output type of Panel transformers to primary be numpy arrays where possible, rather than converting to DataFrames.

### Alignment

Remove the alignment module [#87](https://github.com/scikit-time/scikit-time/pull/87)
- The alignment module used an external package (python_dtw) to find alignments between series in a complex set of classes. It was not used anywhere else in the toolkit. The distance functions already have the ability to extract an alignment, and they do it four times faster than python_dtw. If there is a use case for a more structured alignment module then it should be based on distances, but there have been no issues raised to provide one.

### Dists_kerns

Removes the dist_kerns module [179](https://github.com/aeon-toolkit/aeon/pull/179)
- We are currently not willing to maintain this module, distance measures are still available in the distances module.

### Tags

Add tags for estimators using the taxonomy of classification [#129](https://github.com/aeon-toolkit/aeon/pull/129)
- classifier_type changed to algorithm_type for use with regression/clustering.

## Maintenance

- [FORK] Update config files ({pr}`48`) {user}`MatthewMiddlehurst`
- [MNT] Fix wrong mail ({pr}`83`) {user}`aiwalter`
- [MNT] ``convolution_based`` rename ({pr}`90`) {user}`MatthewMiddlehurst`
- [MNT] Remove duplicate function  ({pr}`120`) {user}`scorcism`
- [ENH] Remove fit_predict_proba from Base-Class, Use sklearn cross_val_predict instead ({pr}`117`) {user}`patrickzib`
- [MNT] removed separate mlflow dependencies and testing ({pr}`81`) {user}`aiwalter`
- [ENH] Early classification updates ({pr}`88`) {user}`MatthewMiddlehurst`
- [FORK] Changed all Slack links ({pr}`138`) {user}`aiwalter`
- [MNT] Remove Python 3.7 support ({pr}`103`) {user}`aiwalter`
- [MNT] Pandas 2.0.0 deprecation actions (part 1) ({pr}`153`) {user}`aiwalter`
- [MNT] Rename package to aeon ({pr}`184`) {user}`MatthewMiddlehurst`
- [MNT] Fix pytest by setting upper bound on ``dash`` ({pr}`206`) {user}`MatthewMiddlehurst`
- [MNT] Pandas 2.0.0 deprecation actions (part 2) ({pr}`189`) {user}`aiwalter`
- [MNT] Extension template rename ({pr}`201`) {user}`MatthewMiddlehurst`
- [MNT] Update email and social media links ({pr}`281`) {user}`MatthewMiddlehurst`
- [BUG] Include ``packaging`` as a dependency ({pr}`284`) {user}`MatthewMiddlehurst`
- [MNT] Update release workflow and remove old release files ({pr}`259`) {user}`MatthewMiddlehurst`
- [MNT] GitHub templates ({pr}`285`) {user}`MatthewMiddlehurst`
- [MNT] remove shellcheck from pre-commit checks ({pr}`60`) {user}`lmmentel`
- [MNT] Bump versions of pre-commit checks  ({pr}`62`) {user}`lmmentel`
- [MNT] Update name to ``aeon`` in config files ({pr}`157`) {user}`MatthewMiddlehurst`

## Documentation

- [FORK] Update README (IN PROGRESS) ({pr}`43`) {user}`MatthewMiddlehurst`
- [DOC] Docs disclaimer ({pr}`64`) {user}`MatthewMiddlehurst`
- [BUG] Fix documentation build errors  ({pr}`73`) {user}`lmmentel`
- [DOC] Classifier docs tidy up ({pr}`52`) {user}`TonyBagnall`
- [DOC] Fix docstring of TabularToSeriesAdaptor ({pr}`131`) {user}`aiwalter`
- [DOC] Rename some occurrences of ``sktime`` to ``aeon`` ({pr}`161`) {user}`MatthewMiddlehurst`
- [ENH] first rework of the classification notebook ({pr}`123`) {user}`TonyBagnall`
- [DOC] Update landing page ({pr}`122`) {user}`MatthewMiddlehurst`
- [DOC] Add website warning again. ({pr}`205`) {user}`MatthewMiddlehurst`
- [DOC] Refactor documentation out of ``source`` directory ({pr}`200`) {user}`MatthewMiddlehurst`
- [DOC] Disclaimer for markdown ({pr}`244`) {user}`MatthewMiddlehurst`
- [DOC] Remove local table of contents ({pr}`243`) {user}`MatthewMiddlehurst`
- [DOC] Webpage link fixes ({pr}`245`) {user}`MatthewMiddlehurst`
- [DOC] Update ``about`` pages ({pr}`241`) {user}`MatthewMiddlehurst`
- [DOC] Remove GSoC and meetups pages, update mentoring with placeholder ({pr}`242`) {user}`MatthewMiddlehurst`

## Fixes

- [BUG] Update check_n_jobs ({pr}`14`) {user}`MatthewMiddlehurst`
- [BUG] Fix Imputer bugs ({pr}`24`) {user}`aiwalter`
- [BUG] Remove ``ComposableTimeSeriesForestRegressor`` ({pr}`92`) {user}`MatthewMiddlehurst`
- [BUG] Fix tag in FeatureSelection and added tests ({pr}`13`) {user}`aiwalter`
- [BUG] fix class values for SFA tests ({pr}`224`) {user}`TonyBagnall`
- [BUG] change Imputer to allow for 0 to be the missing value to replace ({pr}`268`) {user}`TonyBagnall`
- [BUG] ``attrs`` quick fix ({pr}`283`) {user}`MatthewMiddlehurst`

## Refactored

- [MNT] Automated refactorings ({pr}`190`) {user}`lmmentel`
- [DOC] Refactor documentation out of ``source`` directory ({pr}`200`) {user}`MatthewMiddlehurst`

## Enhancements

- [ENH] Dictionary Classifiers ({pr}`58`) {user}`patrickzib`
- [ENH] ``_fit_transform`` method in ``BaseTransformer``  ({pr}`91`) {user}`MatthewMiddlehurst`
- [ENH] Add ``prefer="threads"`` to classification ``Parallel`` usage ({pr}`93`) {user}`MatthewMiddlehurst`
- [ENH] Speedup EAgglo by factor 5-10x ({pr}`139`) {user}`patrickzib`
- [ENH] Adds WEASEL v2 (with dilation) ({pr}`160`) {user}`patrickzib`

## Other

- Update FUNDING.yml ({pr}`10`) {user}`MatthewMiddlehurst`
- Comment out all GitHub actions workflows. ({pr}`3`) {user}`MatthewMiddlehurst`
- Remove workflow files ({pr}`15`) {user}`MatthewMiddlehurst`
- Delete contrib (and update codeowners) ({pr}`12`) {user}`TonyBagnall`
- [GOV] Revert CoC to remove FK changes ({pr}`17`) {user}`aiwalter`
- [GOV] Removed 7 days discussion period before votings. Removed weekend rule by adding 2 days instead ({pr}`41`) {user}`aiwalter`
- [GOV] CC and CoC term limitation to 2 years ({pr}`22`) {user}`aiwalter`
- [GOV] Updated team page ({pr}`19`) {user}`aiwalter`
- [FORK] Revert #15 "Remove workflow files" (MERGE WHEN REPO PUBLIC) ({pr}`16`) {user}`MatthewMiddlehurst`
- License Update ({pr}`56`) {user}`MatthewMiddlehurst`
- [GOV] Added CoCC members as voted by core developers ({pr}`57`) {user}`aiwalter`
- [GOV] Removed CC Observer role ({pr}`49`) {user}`aiwalter`
- [ENH] kNN Classifier and Regressor reimplementations ({pr}`66`) {user}`GuiArcencio`
- [GOV] proposal: CC and CoC should have disjoint membership ({pr}`23`) {user}`aiwalter`
- Update README ({pr}`63`) {user}`MatthewMiddlehurst`
- [ENH] Remove ProximityForest classifier ({pr}`86`) {user}`TonyBagnall`
- [Bug] ClaSP Bugfixes ({pr}`95`) {user}`patrickzib`
- [GOV] Appointment of CC and CoC members ({pr}`20`) {user}`aiwalter`
- [ENH] remove TimeSeriesSVC ({pr}`105`) {user}`TonyBagnall`
- [ENH] Remove the alignment module ({pr}`87`) {user}`TonyBagnall`
- [ENH] Changed grid search parallelization to use backend param from e… ({pr}`82`) {user}`aiwalter`
- [MNT] Remove hcrystalball wrapper ({pr}`115`) {user}`aiwalter`
- [ENH] make single problem loaders for equal length problems return numpy arrays ({pr}`109`) {user}`TonyBagnall`
- [ENH] Remove plotting ({pr}`127`) {user}`TonyBagnall`
- [ENH] Refactored PCATransformer ({pr}`26`) {user}`aiwalter`
- [ENH] Classifier tests for ``capability:contractable`` and ``capability:train_estimate`` tags ({pr}`89`) {user}`MatthewMiddlehurst`
- [FORK] removed discord links ({pr}`137`) {user}`aiwalter`
- [ENH] Clean up clustering module ({pr}`132`) {user}`chrisholder`
- Remove the DistanceFeatures transformer ({pr}`143`) {user}`TonyBagnall`
- [ENH] [BUG] Improving Runtime of Elastic Ensemble by 20x (by fixing the closure issue) ({pr}`142`) {user}`patrickzib`
- [ENH] Add tags for estimators using the taxonomy of classification ({pr}`129`) {user}`TonyBagnall`
- [ENH] Refactor ColumnEnsemble to ChannelEnsemble ({pr}`162`) {user}`TonyBagnall`
- [ENH] Switch from pandas iteritems() to items() due to warning ({pr}`165`) {user}`TonyBagnall`
- [ENH] Refactor DummyClassifier and Compose classifiers ({pr}`163`) {user}`TonyBagnall`
- [ENH] Remove old Transformer Minxin Classes ({pr}`169`) {user}`MatthewMiddlehurst`
- [ENH]Update Channel Selection code ({pr}`135`) {user}`haskarb`
- [MNT] Fix random test failure in FeatureSelection ({pr}`180`) {user}`aiwalter`
- [ENH] Removes the dist_kerns module ({pr}`179`) {user}`TonyBagnall`
- [ENH] For classification: Adding InceptionTime, CNN and ResNet along with other classifiers and removing LSTM-FCN ({pr}`134`) {user}`hadifawaz1999`
- [ENH] Switch SFA Transformer to use numpy ({pr}`196`) {user}`TonyBagnall`
- [ENH] Shapelet Transform improvements ({pr}`185`) {user}`TonyBagnall`
- Pre-release 0.1.0rc0 ({pr}`207`) {user}`MatthewMiddlehurst`
- [BUG] added missing dl tag to inceptionTime classifier ({pr}`203`) {user}`hadifawaz1999`
- [ENH] switch paa tests to use numpy ({pr}`199`) {user}`TonyBagnall`
- [ENH] remove incorrect iloc calls ({pr}`213`) {user}`TonyBagnall`
- [FORK] Rename sktime to aeon, keep some links ({pr}`218`) {user}`aiwalter`
- [FORK] Fix disclaimer ({pr}`220`) {user}`aiwalter`
- [DOC] Fix rename aeon/sktime ({pr}`238`) {user}`aiwalter`
- [MNT] Remove Python version restriction of tsfresh ({pr}`237`) {user}`aiwalter`
- [ENH] switch test of PaddingTransformer to use numpy ({pr}`198`) {user}`TonyBagnall`
- [ENH] Tidy BaseClassifier and classifier template ({pr}`178`) {user}`TonyBagnall`
- [ENH] remove front end from distances ({pr}`236`) {user}`TonyBagnall`
- [ENH] Converts RocketClassifier back to being a sklearn pipeline classifier ({pr}`234`) {user}`TonyBagnall`
- [MNT] Renamed parameter in mlflow module ({pr}`221`) {user}`aiwalter`
- [ENH] add numba function to find slope derivative ({pr}`252`) {user}`TonyBagnall`
- [DOC] Add myself contributor and codeowners ({pr}`254`) {user}`hadifawaz1999`
- [ENH] Adapt rocket classifiers to return numpy arrays instead of data frames ({pr}`209`) {user}`TonyBagnall`
- [ENH] Catch22Classifier back to being a sklearn pipeline classifier ({pr}`235`) {user}`TonyBagnall`
- [MNT] Test pandas<2.1.0 ({pr}`194`) {user}`aiwalter`
- [ENH] remove test_fit_transform_output ({pr}`273`) {user}`TonyBagnall`
- [ENH] Convert ShapeTransformer to use numpy internally ({pr}`250`) {user}`TonyBagnall`
- [ENH] Convert SlidingWindowTransformer to use numpy internally ({pr}`262`) {user}`TonyBagnall`
- [ENH] remove clustering mentions of nested_univ ({pr}`278`) {user}`TonyBagnall`
- [ENH] Convert PAA to use numpy internally ({pr}`269`) {user}`TonyBagnall`
- [MNT] pandas>=1.5.3,<2.1.0 ({pr}`286`) {user}`aiwalter`
- [ENH] Removal of mentions of nested_univ from classifier package (except shapeDTW) ({pr}`277`) {user}`TonyBagnall`

## Contributors

{user}`aiwalter`,
{user}`chrisholder`,
{user}`GuiArcencio`,
{user}`hadifawaz1999`,
{user}`haskarb`,
{user}`lmmentel`,
{user}`MatthewMiddlehurst`,
{user}`patrickzib`,
{user}`scorcism`,
{user}`TonyBagnall`
