# v0.6.0

December 2023

## Highlights

- A [deprecation policy](../developer_guide/deprecation.md) is now in place for `aeon` and its subpackages.
- New `classification` algorithms are available in `RED CoMETS` and `LITETime`.
- A `clustering` subpackage for deep learning clustering has been added.
- A new experimental `similarity search` subpackage has been added, and the `annotation` module has been split into `segmentation` and `anomaly detection`.
- Minkowski distance has been added to `distances`.
- Lots of small improvements and bug fixes!

## Anomaly Detection

### Other

- [ENH] refactor annotation into segmentation and anomaly detection ({pr}`782`) {user}`TonyBagnall`

## Benchmarking

### Bug Fixes

- [ENH,BUG] CD plot function has been simplified, fixing some errors.  ({pr}`902`) {user}`dguijo`
- [BUG, ENH] Fixes several issues and enhances plotting module ({pr}`950`) {user}`dguijo`

### Enhancements

- [ENH,BUG] CD plot function has been simplified, fixing some errors.  ({pr}`902`) {user}`dguijo`
- [ENH] remove two calls to convert_to ({pr}`947`) {user}`TonyBagnall`
- [BUG, ENH] Fixes several issues and enhances plotting module ({pr}`950`) {user}`dguijo`

## Classification

### Bug Fixes

- [BUG] Correct pipeline test fails ({pr}`855`) {user}`TonyBagnall`
- [BUG] Callables for KNN ({pr}`967`) {user}`TonyBagnall`

### Documentation

- [DOC] Enhance distance function related docs ({pr}`969`) {user}`TonyBagnall`

### Enhancements

- [ENH] Adds RED CoMETS classifier  ({pr}`779`) {user}`zy18811`
- [ENH] Shapelet transform changes ({pr}`857`) {user}`TonyBagnall`
- [ENH] change collection conversions from convert_to to convert_collection ({pr}`838`) {user}`TonyBagnall`
- [ENH] Support unequal length for rdst ({pr}`891`) {user}`baraline`
- [ENH] Remove case sensitivity from Rocket transform argument ({pr}`911`) {user}`TonyBagnall`
- [ENH] Adding LITETime for Deep Learning classifiers ({pr}`923`) {user}`hadifawaz1999`
- [ENH] DL Refactor ({pr}`937`) {user}`TonyBagnall`
- [ENH] Swap transformer used in `SummaryClassifier` ({pr}`978`) {user}`MatthewMiddlehurst`

### Other

- [ENH] Adapt ShapeletTransform to work with unequal length ({pr}`820`) {user}`TonyBagnall`

## Clustering

### Bug Fixes

- [ENH] Allow callables in TimeSeriesKMedoids ({pr}`925`) {user}`TonyBagnall`

### Documentation

- [DOC] Kmeans updated default for averaging method ({pr}`880`) {user}`chrisholder`
- [DOC] Enhance distance function related docs ({pr}`969`) {user}`TonyBagnall`

### Enhancements

- [ENH] Deep Clustering module basis with an auto encoder FCN based example ({pr}`697`) {user}`hadifawaz1999`
- [ENH] Allow callables in TimeSeriesKMedoids ({pr}`925`) {user}`TonyBagnall`
- [ENH] Make clustering files private ({pr}`943`) {user}`TonyBagnall`

### Maintenance

- [MNT] Reduce test params for `AEFCNClusterer` ({pr}`868`) {user}`hadifawaz1999`
- [MNT] Replacing BA by Mean in AEFCNClusterer test params ({pr}`879`) {user}`hadifawaz1999`

## Datasets

### Bug Fixes

- [BUG] Ignore extra whitespace in loader ({pr}`884`) {user}`TonyBagnall`
- [ENH] Add timestamped data loading for collections ({pr}`887`) {user}`TonyBagnall`
- [BUG] Check if multiindex store unequal length series ({pr}`928`) {user}`TonyBagnall`
- [BUG] test forecasting loader return meta data ({pr}`972`) {user}`TonyBagnall`

### Enhancements

- [ENH] Error message for incorrect unequal length multivariate input ({pr}`867`) {user}`TonyBagnall`
- [ENH] Improve coverage for datasets module ({pr}`888`) {user}`TonyBagnall`
- [ENH] Add timestamped data loading for collections ({pr}`887`) {user}`TonyBagnall`
- [ENH] Add download_dataset function to _data_loaders.py ({pr}`906`) {user}`PaulRabich`
- [ENH] Results loaders for published results ({pr}`890`) {user}`TonyBagnall`
- [ENH] default loaders to not return meta data ({pr}`953`) {user}`TonyBagnall`
- [ENH] Tidy up and restructure load to nested univariate ({pr}`987`) {user}`TonyBagnall`

## Distances

### Bug Fixes

- [ENH] Allow callables in TimeSeriesKMedoids ({pr}`925`) {user}`TonyBagnall`
- [BUG] Callables for KNN ({pr}`967`) {user}`TonyBagnall`

### Documentation

- [DOC] Enhance distance function related docs ({pr}`969`) {user}`TonyBagnall`

### Enhancements

- [ENH] Allow callables in TimeSeriesKMedoids ({pr}`925`) {user}`TonyBagnall`
- [ENH] Minkowski distance ({pr}`904`) {user}`akshatvishu`

## Networks

### Enhancements

- [ENH] Adding LITETime for Deep Learning classifiers ({pr}`923`) {user}`hadifawaz1999`
- [ENH] DL Refactor ({pr}`937`) {user}`TonyBagnall`

### Maintenance

- [MNT] Default InceptionTime to use original model and not H version ({pr}`921`) {user}`hadifawaz1999`
- [MNT] Update custom filters in H-InceptionTime and LITETime ot work with new tf versions ({pr}`949`) {user}`hadifawaz1999`

## Regression

### Bug Fixes

- [BUG] Correct pipeline test fails ({pr}`855`) {user}`TonyBagnall`

### Enhancements

- [ENH] Shapelet transform changes ({pr}`857`) {user}`TonyBagnall`
- [ENH] Speed up regression pipeline example ({pr}`860`) {user}`TonyBagnall`
- [ENH] change collection conversions from convert_to to convert_collection ({pr}`838`) {user}`TonyBagnall`
- [ENH] DL Refactor ({pr}`937`) {user}`TonyBagnall`

## Segmentation

### Other

- [ENH] refactor annotation into segmentation and anomaly detection ({pr}`782`) {user}`TonyBagnall`

## Similarity Search

### Enhancements

- [ENH] New similarity search module ({pr}`724`) {user}`TonyBagnall`

## Transformations

### Bug Fixes

- [BUG] shapelet transform square root ({pr}`915`) {user}`TonyBagnall`

### Documentation

- [ENH] Introduce the "Tabular" output type tag and convert remaining Transformers to CollectionTransformers ({pr}`825`) {user}`TonyBagnall`

### Enhancements

- [ENH] BaseCollectionTransformer inherits from BaseCollectionEstimator and BaseTransformer ({pr}`709`) {user}`TonyBagnall`
- [ENH] Shapelet transform changes ({pr}`857`) {user}`TonyBagnall`
- [ENH] Support unequal length for rdst ({pr}`891`) {user}`baraline`
- [ENH] remove nested_univ from Tabularizer ({pr}`897`) {user}`TonyBagnall`
- [ENH]   Add algorithm type tag to convolutional transformers ({pr}`930`) {user}`TonyBagnall`
- [ENH] Add algorithm type tag to dictionary transformers ({pr}`931`) {user}`TonyBagnall`
- [ENH] Add algorithm type tag to shapelet transformers ({pr}`932`) {user}`TonyBagnall`
- [ENH] remove nested_univ from TSFresh test ({pr}`945`) {user}`TonyBagnall`
- [ENH] Remove the TimeBinner transformer ({pr}`933`) {user}`TonyBagnall`
- [ENH] Refactor polymorphic transformers out of series directory into root ({pr}`959`) {user}`TonyBagnall`

### Refactored

- [ENH] Refactor interval based transformers into their own subpackage ({pr}`916`) {user}`TonyBagnall`
- [ENH] Refactor feature based transformers into their own subpackage ({pr}`929`) {user}`TonyBagnall`

### Other

- [ENH] Make MiniRocketMultivariateVariable conform to API ({pr}`839`) {user}`TonyBagnall`
- [ENH] Adapt ShapeletTransform to work with unequal length ({pr}`820`) {user}`TonyBagnall`

## Other

### Bug Fixes

- [BUG] Improve sweep.yaml comment trigger ({pr}`843`) {user}`wwzeng1`
- [BUG] Update sweep.yaml spacing ({pr}`901`) {user}`wwzeng1`

### Documentation

- [DOC] network docstrings ({pr}`799`) {user}`TonyBagnall`
- [DOC] Add a notebook to describe inheritance structure of base classes ({pr}`789`) {user}`TonyBagnall`
- [ENH] scitype variable name and doc string purge ({pr}`798`) {user}`TonyBagnall`
- [DOC] Update documentation files to allow easier local builds and raise `sphinx` bound ({pr}`796`) {user}`MatthewMiddlehurst`
- [MNT] Proposed aeon deprecation policy ({pr}`723`) {user}`TonyBagnall`
- [GOV] Code of Conduct revision ({pr}`806`) {user}`MatthewMiddlehurst`
- [DOC] Update documentation to add workgroups ({pr}`842`) {user}`MatthewMiddlehurst`
- [DOC] Updates remaining first level website pages ({pr}`847`) {user}`MatthewMiddlehurst`
- [Sweep Rules] Remove commented code and improve instructive comments ({pr}`850`) {user}`sweep-ai[bot]`
- [DOC] change n_dimensions to n_channels in all files ({pr}`918`) {user}`xiaopu222`
- [DOC] Add warning to installation guide for some shells ({pr}`963`) {user}`MatthewMiddlehurst`
- [DOC] Remove "Time series" from API titles ({pr}`980`) {user}`TonyBagnall`

### Enhancements

- [ENH] Fix pre-commit fails ({pr}`851`) {user}`TonyBagnall`
- [ENH] Refactor X_inner_mtype ({pr}`859`) {user}`TonyBagnall`
- [ENH] Set Draft to true in sweep.yaml ({pr}`900`) {user}`wwzeng1`
- [ENH] Remove upper bounds for `tslearn` and `pmdarima` ({pr}`939`) {user}`MatthewMiddlehurst`
- [ENH] Update `numpy` version ({pr}`935`) {user}`MatthewMiddlehurst`
- [ENH] Update `scikit-learn` version ({pr}`940`) {user}`MatthewMiddlehurst`
- [ENH] Update `tensorflow`  ({pr}`912`) {user}`MatthewMiddlehurst`
- [ENH] Refactor numpyflat to be numpy2D ({pr}`941`) {user}`TonyBagnall`
- [ENH] Remove the alignment ADT from datatypes ({pr}`979`) {user}`TonyBagnall`

### Maintenance

- [MNT] Consolidate config files and add new pre-commit functionality ({pr}`340`) {user}`MatthewMiddlehurst`
- [MNT] Comment out `mypy` pre-commit hook and run pre-commit on all files. Remove individual copyright notices ({pr}`801`) {user}`MatthewMiddlehurst`
- [MNT] Update sweep.yaml ({pr}`821`) {user}`kevinlu1248`
- [MNT] Add PR testing to `test-nosoftdeps-full` ({pr}`823`) {user}`MatthewMiddlehurst`
- [MNT] Update Pull Request template ({pr}`829`) {user}`MatthewMiddlehurst`
- [MNT] Add new `sweep` rules and make current rules more specific ({pr}`828`) {user}`MatthewMiddlehurst`
- [MNT] Add auto label and welcoming comment workflow for PRs  ({pr}`832`) {user}`MatthewMiddlehurst`
- [MNT] Add new periodic tests and tidy workflows ({pr}`830`) {user}`MatthewMiddlehurst`
- [MNT] Add workflow to update `pre-commit` hooks and make a PR ({pr}`831`) {user}`MatthewMiddlehurst`
- [MNT] Improve coverage for utils/validation ({pr}`793`) {user}`TonyBagnall`
- [MNT] Stop pre-commit bot on draft PR ({pr}`854`) {user}`MatthewMiddlehurst`
- [MNT] Always create a pull request on `pre-commit` update even if full run fails ({pr}`863`) {user}`MatthewMiddlehurst`
- [MNT] Allow manual run of certain workflows ({pr}`865`) {user}`MatthewMiddlehurst`
- [MNT] Remove `sweep` rules and sandbox options ({pr}`874`) {user}`MatthewMiddlehurst`
- [MNT] Always generate token for `pre-commit` version update workflow ({pr}`876`) {user}`MatthewMiddlehurst`
- [MNT] Give more time for codecov workflow tests ({pr}`877`) {user}`MatthewMiddlehurst`
- [MNT] Try to fix `pre-commit` auto update ({pr}`881`) {user}`MatthewMiddlehurst`
- [MNT] Use app token for other GitHub workflows ({pr}`886`) {user}`MatthewMiddlehurst`
- [MNT] Retry aeon install on failure for GitHub workflows ({pr}`885`) {user}`MatthewMiddlehurst`
- [MNT] Setup file for Dependabot (automatic dependency updates) ({pr}`892`) {user}`MatthewMiddlehurst`
- [MNT] Dependabot validation workflow ({pr}`903`) {user}`MatthewMiddlehurst`

### Refactored

- [MNT] Proposed aeon deprecation policy ({pr}`723`) {user}`TonyBagnall`

### Other

- [ENH] Bug and coverage for BaseCollectionTransformer ({pr}`808`) {user}`TonyBagnall`
- [ENH] Refactor tags to remove scitype ({pr}`800`) {user}`TonyBagnall`
- Improve docstrings formatting in deep learning classifiers ({pr}`814`) {user}`sweep-ai[bot]`
- [ENH] Refactor scitype:y to y_input_type and y_inner_mtype to y_inner_type ({pr}`810`) {user}`TonyBagnall`
- [GOV] New `aeon` governance document. ({pr}`195`) {user}`MatthewMiddlehurst`
- Update sweep.yaml to disable rules and fix sandbox ({pr}`878`) {user}`kevinlu1248`

## Contributors

The following have contributed to this release through a collective 100 GitHub Pull Requests:

{user}`akshatvishu`,
{user}`baraline`,
{user}`chrisholder`,
{user}`dguijo`,
{user}`hadifawaz1999`,
{user}`kevinlu1248`,
{user}`MatthewMiddlehurst`,
{user}`PaulRabich`,
{user}`TonyBagnall`,
{user}`wwzeng1`,
{user}`xiaopu222`,
{user}`zy18811`
