# v0.4.0

July 2023

Following this release the deprecation policy remains suspended. Future releases may have breaking changes, so it may be wise to set an upper bound on the package version.

## Highlights

- Data downloading functions for popular classification, regression and forecasting archives are now available
- Implementations for the RSTSF interval-based and the RDST shapelet-based classifiers have been added to the classification module
- Time series adaptations for the PAM, CLARA, CLARANS clustering algorithms have been added to the clustering module
- The interval-based forests in the classification module have been reworked to use a new base class, including speed-ups and also allowing the implementation of regression versions (RISERegressor, CIFRegressor and DrCIFRegressor)
- ResNet and FCN deep learning regressors are now available
- Large portions of the website documentation have been overhauled, including the examples page and introduction notebooks for data types and data loading

## Annotation

### Documentation

- [DOC] Restructure annotation and transformation notebooks ({pr}`531`) {user}`TonyBagnall`

## Benchmarking

### Enhancements

- [ENH] Result loader from tsc.com ({pr}`452`) {user}`TonyBagnall`
- [ENH] Data downloaders for classification/regression and forecasting ({pr}`478`) {user}`TonyBagnall`
- [ENH] Full classifier results ({pr}`571`) {user}`TonyBagnall`

## Classification

### Bug Fixes

- [BUG] HIVECOTEV1 cross-validation bugfix ({pr}`518`) {user}`MatthewMiddlehurst`
- [BUG] RotationForest bugfix and doc improvements ({pr}`517`) {user}`MatthewMiddlehurst`
- [ENH] Updates to `Catch22` and fixes to collection converters ({pr}`509`) {user}`MatthewMiddlehurst`
- [BUG] Add `non-deterministic` tag to RDSTClassifier ({pr}`577`) {user}`MatthewMiddlehurst`

### Documentation

- [BUG] RotationForest bugfix and doc improvements ({pr}`517`) {user}`MatthewMiddlehurst`
- [DOC] Add correct images for classification ({pr}`514`) {user}`TonyBagnall`

### Enhancements

- [ENH] Updates to `Catch22` and fixes to collection converters ({pr}`509`) {user}`MatthewMiddlehurst`
- [ENH] Update interval extraction transformers and pipelines ({pr}`511`) {user}`MatthewMiddlehurst`
- [ENH] Implement RSTSF classifier ({pr}`544`) {user}`MatthewMiddlehurst`
- [ENH] Add deep networks/classifiers/regressors to init ({pr}`554`) {user}`TonyBagnall`
- [ENH] Implement configurable interval base class with classifier and regressor ({pr}`545`) {user}`MatthewMiddlehurst`
- [ENH] RDSTClassifier and transformer tests ({pr}`529`) {user}`baraline`
- [ENH] Replace TSF estimators with base class version and remove `series_as_features` package ({pr}`575`) {user}`MatthewMiddlehurst`
- [ENH] Full classifier results ({pr}`571`) {user}`TonyBagnall`
- [ENH] Move CIF and DrCIF to use the interval base class ({pr}`573`) {user}`MatthewMiddlehurst`
- [ENH] Updates the RISE classifier to use new interval base class ({pr}`584`) {user}`MatthewMiddlehurst`
- [ENH] Updates the STSF classifier to use new interval base class ({pr}`585`) {user}`MatthewMiddlehurst`

### Maintenance

- [MNT] Avoid CI fail on deep test by generating at least 2 classes in random data ({pr}`485`) {user}`hadifawaz1999`

### Refactored

- [REF] change single class use case ({pr}`497`) {user}`TonyBagnall`

## Clustering

### Bug Fixes

- [BUG] DBA numba error ({pr}`541`) {user}`chrisholder`

### Documentation

- [DOC] clustering and regression notebooks ({pr}`516`) {user}`TonyBagnall`

### Enhancements

- [ENH] Kmedoids refactor and speed up ({pr}`498`) {user}`chrisholder`
- [ENH] Pam kmedoids clusterer ({pr}`500`) {user}`chrisholder`
- [ENH] CLARA clusterer ({pr}`501`) {user}`chrisholder`
- [ENH] CLARANS clusterer ({pr}`503`) {user}`chrisholder`

### Refactored

- [ENH] Kmedoids refactor and speed up ({pr}`498`) {user}`chrisholder`
- [ENH] Pam kmedoids clusterer ({pr}`500`) {user}`chrisholder`

## Distances

### Bug Fixes

- [BUG] RDST bugfixes ({pr}`483`) {user}`baraline`
- [BUG] DBA numba error ({pr}`541`) {user}`chrisholder`

### Documentation

- [DOC] Update distances notebook ({pr}`491`) {user}`TonyBagnall`
- [DOC] Tidy up the datasets and distances examples ({pr}`513`) {user}`TonyBagnall`
- [DOCS] Add docs for function transformer with distances, and tests for distances with sklearn ({pr}`581`) {user}`TonyBagnall`
- [DOC] Distance function template ({pr}`583`) {user}`TonyBagnall`

## Forecasting

### Documentation

- [DOC] Move forecasting notebooks ({pr}`536`) {user}`TonyBagnall`

### Maintenance

- [MNT] BATS parameter test ({pr}`568`) {user}`TonyBagnall`
- [MNT] Add `statsforecast` back to all_extras ({pr}`552`) {user}`MatthewMiddlehurst`

## Regression

### Bug Fixes

- [BUG] RotationForest bugfix and doc improvements ({pr}`517`) {user}`MatthewMiddlehurst`
- [ENH] Updates to `Catch22` and fixes to collection converters ({pr}`509`) {user}`MatthewMiddlehurst`
- [BUG] Regression base class score function ({pr}`549`) {user}`TonyBagnall`

### Documentation

- [BUG] RotationForest bugfix and doc improvements ({pr}`517`) {user}`MatthewMiddlehurst`
- [DOC] clustering and regression notebooks ({pr}`516`) {user}`TonyBagnall`

### Enhancements

- [ENH] Updates to `Catch22` and fixes to collection converters ({pr}`509`) {user}`MatthewMiddlehurst`
- [ENH] Update interval extraction transformers and pipelines ({pr}`511`) {user}`MatthewMiddlehurst`
- [ENH] Add deep networks/classifiers/regressors to init ({pr}`554`) {user}`TonyBagnall`
- [ENH] Add ResNet deep learning regressor ({pr}`558`) {user}`hadifawaz1999`
- [ENH] Add FCN deep learning regressor ({pr}`560`) {user}`hadifawaz1999`
- [ENH] Implement configurable interval base class with classifier and regressor ({pr}`545`) {user}`MatthewMiddlehurst`
- [MNT-ENH] Fixed stuff in CNN deep learning regressor ({pr}`559`) {user}`hadifawaz1999`
- [ENH] Replace TSF estimators with base class version and remove `series_as_features` package ({pr}`575`) {user}`MatthewMiddlehurst`
- [ENH] Move CIF and DrCIF to use the interval base class ({pr}`573`) {user}`MatthewMiddlehurst`
- [ENH] Updates the RISE classifier to use new interval base class ({pr}`584`) {user}`MatthewMiddlehurst`

### Maintenance

- [MNT] Avoid CI fail on deep test by generating at least 2 classes in random data ({pr}`485`) {user}`hadifawaz1999`
- [MNT-ENH] Fixed stuff in CNN deep learning regressor ({pr}`559`) {user}`hadifawaz1999`

### Other

- [ENH] Removes the delegate structure from regression ({pr}`580`) {user}`TonyBagnall`

## Transformations

### Bug Fixes

- [BUG] RDST bugfixes ({pr}`483`) {user}`baraline`
- [BUG] reduce test size for MultiRocket ({pr}`520`) {user}`TonyBagnall`
- [ENH] Updates to `Catch22` and fixes to collection converters ({pr}`509`) {user}`MatthewMiddlehurst`

### Documentation

- [DOC] Restructure annotation and transformation notebooks ({pr}`531`) {user}`TonyBagnall`

### Enhancements

- [ENH] Collection transformer wrapper and basic base class testing ({pr}`467`) {user}`MatthewMiddlehurst`
- [ENH] Updates to `Catch22` and fixes to collection converters ({pr}`509`) {user}`MatthewMiddlehurst`
- [ENH] Add some simple collection transformers ({pr}`508`) {user}`MatthewMiddlehurst`
- [ENH] Update interval extraction transformers and pipelines ({pr}`511`) {user}`MatthewMiddlehurst`
- [ENH] RDSTClassifier and transformer tests ({pr}`529`) {user}`baraline`

### Maintenance

- [MNT] Add test for transformer numpy input ({pr}`555`) {user}`MatthewMiddlehurst`

### Refactored

- [ENH] Refactoring PAA ({pr}`489`) {user}`hadifawaz1999`

## Other

### Bug Fixes

- [MNT] tidy up resnet and fix failures ({pr}`486`) {user}`hadifawaz1999`
- [BUG] Update gunpoint arff ({pr}`496`) {user}`TonyBagnall`
- [BUG] Doctest formatting bug 546 ({pr}`548`) {user}`TonyBagnall`
- [BUG] Scenarios string fix ({pr}`594`) {user}`TonyBagnall`

### Documentation

- [DOC] Change README logo link ({pr}`482`) {user}`MatthewMiddlehurst`
- [DOC] InceptionTime docstrings ({pr}`494`) {user}`TonyBagnall`
- [DOCS] Update the API ({pr}`495`) {user}`TonyBagnall`
- [DOC] Add transformations to getting started page and add opengraph sphinx package ({pr}`522`) {user}`MatthewMiddlehurst`
- [DOC] Added Deep Learning notebook and images ({pr}`493`) {user}`hadifawaz1999`
- [DOC] Remove the tutorials and users webpages ({pr}`525`) {user}`MatthewMiddlehurst`
- [DOC] Remove stray user_guide dir and _mission webpage ({pr}`526`) {user}`MatthewMiddlehurst`
- [DOC] fixed path of image ({pr}`535`) {user}`hadifawaz1999`
- [BUG] Doctest formatting bug 546 ({pr}`548`) {user}`TonyBagnall`
- [DOC] Rewrite current user installation guide and move dev installation guide to its own file ({pr}`524`) {user}`MatthewMiddlehurst`
- [DOC] Remove mentoring and estimator overview webpages ({pr}`527`) {user}`MatthewMiddlehurst`
- [DOC] Auto generate `about` page teams ({pr}`532`) {user}`MatthewMiddlehurst`
- [DOC] Utils notebook directory ({pr}`561`) {user}`TonyBagnall`
- [DOCS] attempt to minimise docstring warnings ({pr}`572`) {user}`TonyBagnall`
- [DOC] Datatypes docs ({pr}`538`) {user}`TonyBagnall`
- [DOC] purge AA_datatypes_and_datasets.ipynb ({pr}`540`) {user}`TonyBagnall`
- [DOC] Tidy up the docs ({pr}`591`) {user}`TonyBagnall`
- [DOC] Full examples debug ({pr}`598`) {user}`TonyBagnall`

### Enhancements

- [ENH] Add function to make example 3D numpy problems ({pr}`510`) {user}`MatthewMiddlehurst`
- [ENH] Tidy up test exclusions ({pr}`473`) {user}`TonyBagnall`

### Maintenance

- [MNT] Loosen upper bound for `esig` and update Python version for notebook tests. ({pr}`487`) {user}`MatthewMiddlehurst`
- [MNT] Revert `holidays` and `dash` dependency changes ({pr}`445`) {user}`MatthewMiddlehurst`
- [MNT] Add `non-deterministic` and `cant-pickle` tag for estimators ({pr}`371`) {user}`hadifawaz1999`
- [MNT] Replace `handles-missing-data` tag with `capability:missing_values` ({pr}`505`) {user}`MatthewMiddlehurst`
- [MNT] Set upper bound for `tslearn` to fix CI ({pr}`534`) {user}`MatthewMiddlehurst`
- [MNT] Change `esig` dependency version requirements to fix CI ({pr}`539`) {user}`MatthewMiddlehurst`
- [MNT] Setting more upper bounds to fix CI ({pr}`542`) {user}`MatthewMiddlehurst`
- [MNT] Exclude results loading notebook ({pr}`562`) {user}`MatthewMiddlehurst`
- [MNT] estimator checks deprecation ({pr}`556`) {user}`TonyBagnall`
- [MNT] Add periodic test workflow and remove Makefile ({pr}`553`) {user}`MatthewMiddlehurst`
- [MNT] Update codeowners ({pr}`547`) {user}`TonyBagnall`
- [MNT] DL OOM test failure fix and remove Makefile ({pr}`593`) {user}`MatthewMiddlehurst`

## Contributors

The following have contributed to this release through a collective 79 GitHub Pull Requests:

{user}`baraline`,
{user}`chrisholder`,
{user}`hadifawaz1999`,
{user}`MatthewMiddlehurst`,
{user}`TonyBagnall`
