# v0.3.0

June 2023

Following this release the deprecation policy remains suspended. Future releases may have breaking changes, so it may be wise to set an upper bound on the package version.

## Highlights

- An interface to the MrSQM algorithm has been added to the classification module.
- k-NN estimators and the Elastic Ensemble classifier now support unequal length series.
- The SAX transformation has been refactored to improve performance.
- A new collection transformer base class has been added to the transformations module for more efficient transformation using collections of time series.
- A rework of the benchmarking module has begun, starting with the introduction of functionality from `kotsu`

## Benchmarking

### Enhancements

- [ENH] Implement simple(r) benchmarking ({pr}`379`) {user}`DBCerigo`
- [ENH] remove unsupported legacy benchmarking code ({pr}`439`) {user}`TonyBagnall`
- [ENH] Rework datasets package notebooks ({pr}`468`) {user}`TonyBagnall`

## Classification

### Bug Fixes

- [BUG] refactored params usage resnet ({pr}`433`) {user}`hadifawaz1999`
- [BUG] Ordinal TDE _n_jobs ({pr}`471`) {user}`MatthewMiddlehurst`

### Enhancements

- [ENH] Parametrize model saving for deep classifiers and regressors ({pr}`430`) {user}`hadifawaz1999`
- [ENH] Ordinal TDE algorithm and extension of SFA transformer ({pr}`335`) {user}`RafaAyGar`
- [ENH] Facilitate multivariate and unequal length with ElasticEnsemble classifier ({pr}`415`) {user}`TonyBagnall`
- [ENH] refactor _threads_to_use to _n_jobs ({pr}`377`) {user}`TonyBagnall`
- [ENH] MrSQM classification wrapper ({pr}`476`) {user}`MatthewMiddlehurst`

### Refactored

- [ENH] refactor _threads_to_use to _n_jobs ({pr}`377`) {user}`TonyBagnall`

### Other

- [ENH] Allow KNN to take unequal length series.  ({pr}`412`) {user}`TonyBagnall`

## Clustering

### Bug Fixes

- [BUG] Tslearn clusterers update ({pr}`457`) {user}`chrisholder`

## Distances

### Bug Fixes

- [BUG] KNN distance params  ({pr}`447`) {user}`chrisholder`

### Enhancements

- [ENH] updated dba to support custom parameters ({pr}`454`) {user}`chrisholder`

### Other

- [ENH] Allow KNN to take unequal length series.  ({pr}`412`) {user}`TonyBagnall`

## Regression

### Enhancements

- [ENH] Parametrize model saving for deep classifiers and regressors ({pr}`430`) {user}`hadifawaz1999`
- [ENH] Enable knn regressor to take unequal length ({pr}`442`) {user}`TonyBagnall`
- [MNT] Add deep learning regression/classification test ({pr}`443`) {user}`hadifawaz1999`

## Transformations

### Bug Fixes

- [ENH] Convert IntervalSegmenter and RandomIntervalSegmenter to use numpy3D internally ({pr}`391`) {user}`TonyBagnall`
- [BUG] Fixes RDST bug and small docstring changes ({pr}`475`) {user}`MatthewMiddlehurst`

### Enhancements

- [ENH] Ordinal TDE algorithm and extension of SFA transformer ({pr}`335`) {user}`RafaAyGar`
- [ENH] Collection transformer base class ({pr}`263`) {user}`MatthewMiddlehurst`
- [ENH] Refactor sax ({pr}`417`) {user}`hadifawaz1999`

### Maintenance

- [MNT] Rename `panel` transformers folder to `collection` ({pr}`466`) {user}`MatthewMiddlehurst`

### Refactored

- [ENH] Refactor sax ({pr}`417`) {user}`hadifawaz1999`
- [MNT] Rename `panel` transformers folder to `collection` ({pr}`466`) {user}`MatthewMiddlehurst`

## Other

### Bug Fixes

- [BUG] `plot_series` bugfix and tests ({pr}`318`) {user}`MatthewMiddlehurst`
- [BUG] Fixes `stratified_resample` so that it works with 3D numpy ({pr}`460`) {user}`GuiArcencio`

### Documentation

- [DOC] Add to getting_started page ({pr}`393`) {user}`TonyBagnall`
- [DOC] README deprecation policy disclaimer ({pr}`453`) {user}`MatthewMiddlehurst`
- [DOC] README getting started section ({pr}`462`) {user}`MatthewMiddlehurst`
- [DOC] Getting started page pipeline examples ({pr}`461`) {user}`MatthewMiddlehurst`

### Enhancements

- [ENH] `numba` utility functions ({pr}`465`) {user}`MatthewMiddlehurst`
- [ENH] data loaders and writers ({pr}`463`) {user}`TonyBagnall`

### Maintenance

- [MNT] Set upper bound on `holidays` to fix CI ({pr}`436`) {user}`MatthewMiddlehurst`
- [MNT] Recursively find notebooks for testing ({pr}`470`) {user}`MatthewMiddlehurst`

### Other

- [EN] Hard code deep learning exclusions from tests ({pr}`419`) {user}`TonyBagnall`
- [ENH] Remove the uses of the nested univariate data generator ({pr}`373`) {user}`TonyBagnall`

## Contributors

The following have contributed to this release through a collective 33 GitHub Pull Requests:

{user}`chrisholder`,
{user}`DBCerigo`,
{user}`GuiArcencio`,
{user}`hadifawaz1999`,
{user}`MatthewMiddlehurst`,
{user}`RafaAyGar`,
{user}`TonyBagnall`
