"""Tests for BKfilter wrapper annotation estimator."""

__maintainer__ = []

import pandas as pd
import pytest
from numpy import array_equal

from aeon.utils.validation._dependencies import _check_soft_dependencies


@pytest.mark.skipif(
    not _check_soft_dependencies("statsmodels", severity="none"),
    reason="skip test if required soft dependency for statsmodels.api not available",
)
def test_BKFilter_wrapper():
    """Verify that the wrapped BKFilter estimator agrees with statsmodel."""
    # moved all potential soft dependency import inside the test:
    import statsmodels.api as sm

    from aeon.transformations.series._bkfilter import BKFilter

    dta = sm.datasets.macrodata.load_pandas().data
    index = pd.date_range(start="1959Q1", end="2009Q4", freq="Q")
    dta.set_index(index, inplace=True)
    sm_cycles = sm.tsa.filters.bkfilter(dta[["realinv"]], 6, 24, 12)
    bk = BKFilter(6, 24, 12)
    sk_cycles = bk.fit_transform(X=dta[["realinv"]], axis=0)
    assert array_equal(sm_cycles, sk_cycles)
