"""Config for forecasting tags.

Uses PR_TESTING flag to switch between full parameter combinations
(PR_TESTING==False) and running a reduced parameter combination (PR_TESTING==True).
"""

from aeon.testing.test_config import PR_TESTING

__all__ = [
    "TEST_CUTOFFS_INT_LIST",
    "TEST_CUTOFFS_INT_ARR",
    "TEST_CUTOFFS_TIMESTAMP",
    "TEST_CUTOFFS",
    "TEST_WINDOW_LENGTHS_INT",
    "TEST_WINDOW_LENGTHS_TIMEDELTA",
    "TEST_WINDOW_LENGTHS_DATEOFFSET",
    "TEST_WINDOW_LENGTHS",
    "TEST_INITIAL_WINDOW_INT",
    "TEST_INITIAL_WINDOW_TIMEDELTA",
    "TEST_INITIAL_WINDOW_DATEOFFSET",
    "TEST_INITIAL_WINDOW",
    "TEST_STEP_LENGTHS_INT",
    "TEST_STEP_LENGTHS_TIMEDELTA",
    "TEST_STEP_LENGTHS_DATEOFFSET",
    "TEST_STEP_LENGTHS",
    "TEST_OOS_FHS",
    "TEST_INS_FHS",
    "TEST_FHS",
    "TEST_OOS_FHS_TIMEDELTA",
    "TEST_INS_FHS_TIMEDELTA",
    "TEST_FHS_TIMEDELTA",
    "TEST_SPS",
    "TEST_ALPHAS",
    "TEST_YS",
    "TEST_N_ITERS",
    "VALID_INDEX_FH_COMBINATIONS",
    "INDEX_TYPE_LOOKUP",
]

if not PR_TESTING:
    from aeon.forecasting.tests.test_config_full import (
        INDEX_TYPE_LOOKUP,
        TEST_ALPHAS,
        TEST_CUTOFFS,
        TEST_CUTOFFS_INT_ARR,
        TEST_CUTOFFS_INT_LIST,
        TEST_CUTOFFS_TIMESTAMP,
        TEST_FHS,
        TEST_FHS_TIMEDELTA,
        TEST_INITIAL_WINDOW,
        TEST_INITIAL_WINDOW_DATEOFFSET,
        TEST_INITIAL_WINDOW_INT,
        TEST_INITIAL_WINDOW_TIMEDELTA,
        TEST_INS_FHS,
        TEST_INS_FHS_TIMEDELTA,
        TEST_N_ITERS,
        TEST_OOS_FHS,
        TEST_OOS_FHS_TIMEDELTA,
        TEST_SPS,
        TEST_STEP_LENGTHS,
        TEST_STEP_LENGTHS_DATEOFFSET,
        TEST_STEP_LENGTHS_INT,
        TEST_STEP_LENGTHS_TIMEDELTA,
        TEST_WINDOW_LENGTHS,
        TEST_WINDOW_LENGTHS_DATEOFFSET,
        TEST_WINDOW_LENGTHS_INT,
        TEST_WINDOW_LENGTHS_TIMEDELTA,
        TEST_YS,
        VALID_INDEX_FH_COMBINATIONS,
    )
else:
    from aeon.forecasting.tests.test_config import (
        INDEX_TYPE_LOOKUP,
        TEST_ALPHAS,
        TEST_CUTOFFS,
        TEST_CUTOFFS_INT_ARR,
        TEST_CUTOFFS_INT_LIST,
        TEST_CUTOFFS_TIMESTAMP,
        TEST_FHS,
        TEST_FHS_TIMEDELTA,
        TEST_INITIAL_WINDOW,
        TEST_INITIAL_WINDOW_DATEOFFSET,
        TEST_INITIAL_WINDOW_INT,
        TEST_INITIAL_WINDOW_TIMEDELTA,
        TEST_INS_FHS,
        TEST_INS_FHS_TIMEDELTA,
        TEST_N_ITERS,
        TEST_OOS_FHS,
        TEST_OOS_FHS_TIMEDELTA,
        TEST_SPS,
        TEST_STEP_LENGTHS,
        TEST_STEP_LENGTHS_DATEOFFSET,
        TEST_STEP_LENGTHS_INT,
        TEST_STEP_LENGTHS_TIMEDELTA,
        TEST_WINDOW_LENGTHS,
        TEST_WINDOW_LENGTHS_DATEOFFSET,
        TEST_WINDOW_LENGTHS_INT,
        TEST_WINDOW_LENGTHS_TIMEDELTA,
        TEST_YS,
        VALID_INDEX_FH_COMBINATIONS,
    )
