## ACSF1
#
#The dataset is compiled from ACS-F1, the first version of the database of appliance consumption signatures. The dataset contains the power consumption of typical appliances. The recordings are characterized by long idle periods and some high bursts of enery consumption when the appliance is active.
#
#The classes correspond to 10 categories of home appliances: mobile phones (via chargers), coffee machines, computer stations (including monitor), fridges and freezers, Hi-Fi systems (CD players), lamp (CFL), laptops (via chargers), microwave ovens, printers, and televisions (LCD or LED).
#
#Train size: 100
#
#Test size: 100
#
#Missing value: No
#
#Number of classses: 10
#
#Time series length: 1460
#
#There is nothing to infer from the order of examples in the train and test set.
#
#Data created by Gisler, Christophe, et al. (see [1], [2]). Data edited by Patrick Schafer and Ulf Leser (see [3]).
#
#[1] Gisler, Christophe, et al. "Appliance consumption signature database and recognition test protocols." Systems, Signal Processing and their Applications (WoSSPA), 2013 8th International Workshop on. IEEE, 2013.
#
#[2] http://www.wattict.com/web/index.php/databases/acs-f1
#
#[3] Schäfer, Patrick, and Ulf Leser. "Fast and accurate time series classification with weasel." Proceedings of the 2017 ACM on Conference on Information and Knowledge Management. ACM, 2017.
@problemName ACSF1
@timeStamps false
@missing false
@univariate true
@equalLength true
@seriesLength 1460
@classLabel true 0 1 2 3 4 5 6 7 8 9
@data
-0.57796699,-0.57796699,1.7381622,-0.57796699,-0.57796699,-0.57796699,1.7363327,-0.57796699,-0.57796699,-0.57796699,1.7389632,-0.57796699,-0.57796699,-0.57796699,1.7393884,-0.57796699,-0.57796699,-0.57796699,1.7387654,-0.57796699,-0.57796699,-0.57796699,1.7368074,-0.57796699,-0.57796699,-0.57796699,1.7374601,-0.57796699,-0.57796699,-0.57796699,1.7366591,-0.57796699,-0.57796699,-0.57796699,1.7362437,-0.57796699,-0.57796699,-0.57796699,1.7368667,-0.57796699,-0.57796699,-0.57796699,1.7375293,-0.57796699,-0.57796699,-0.57796699,1.7358086,-0.57796699,-0.57796699,-0.57796699,1.7360163,-0.57796699,-0.57796699,-0.55430295,1.734622,-0.5778681,-0.57796699,-0.56047359,1.7350076,-0.57789776,-0.57796699,-0.56150204,1.7314971,-0.57789776,-0.57693854,-0.56355892,1.7340286,-0.57790765,-0.57693854,-0.56768257,1.7340583,-0.57792743,-0.57693854,-0.56768257,1.7348692,-0.57792743,-0.57693854,-0.56973946,1.7342561,-0.57793732,-0.57693854,-0.5707679,1.7360262,-0.57793732,-0.57693854,-0.5707679,1.7383402,-0.57793732,-0.57693854,-0.5707679,1.7400213,-0.57793732,-0.57693854,-0.5707679,1.7386764,-0.57793732,-0.57693854,-0.5707679,1.7424342,-0.57793732,-0.57693854,-0.5707679,1.7415343,-0.57793732,-0.57693854,-0.5707679,1.7423946,-0.57793732,-0.57693854,-0.5707679,1.7408025,-0.57793732,-0.57693854,-0.5707679,1.7384588,-0.57793732,-0.57693854,-0.5707679,1.7395169,-0.57793732,-0.57693854,-0.5707679,1.7403575,-0.57793732,-0.57693854,-0.57179634,1.7394873,-0.57794721,-0.57693854,-0.57179634,1.7401004,-0.57794721,-0.57693854,-0.57179634,1.7383698,-0.57794721,-0.57693854,-0.57179634,1.740219,-0.57794721,-0.57693854,-0.57179634,1.7395367,-0.57794721,-0.57693854,-0.57179634,1.7408519,-0.57794721,-0.57693854,-0.57179634,1.7398433,-0.57794721,-0.57693854,-0.57179634,1.7384193,-0.57794721,-0.57693854,-0.57179634,1.7386962,-0.57794721,-0.57693854,-0.57179634,1.7364712,-0.57794721,-0.57693854,-0.57179634,1.7371436,-0.57794721,-0.57693854,-0.57179634,1.7371931,-0.57794721,-0.57796699,-0.57179634,1.7379248,-0.57794721,-0.57693854,-0.57282478,1.7371535,-0.57794721,-0.57693854,-0.57179634,1.7302511,-0.57794721,-0.57693854,-0.57179634,1.7318036,-0.57794721,-0.57796699,-0.57796699,1.7322091,-0.57796699,-0.57796699,-0.57796699,1.730439,-0.57796699,-0.57796699,-0.57796699,1.7378853,-0.57796699,-0.57796699,-0.57796699,1.7359372,-0.57796699,-0.57796699,-0.57796699,1.7330892,-0.57796699,-0.57796699,-0.57796699,1.7304192,-0.57796699,-0.57796699,-0.57796699,1.7329903,-0.57796699,-0.57796699,-0.57796699,1.7366986,-0.57796699,-0.57796699,-0.57796699,1.7370052,-0.57796699,-0.57796699,-0.57796699,1.7376776,-0.57796699,-0.57796699,-0.57796699,1.7374205,-0.57796699,-0.57796699,-0.57796699,1.7369063,-0.57796699,-0.57796699,-0.57796699,1.7384885,-0.57796699,-0.57796699,-0.57796699,1.7376479,-0.57796699,-0.57796699,-0.57796699,1.7369359,-0.57796699,-0.57796699,-0.57796699,1.7408618,-0.57796699,-0.57796699,-0.57796699,1.7410003,-0.57796699,-0.57796699,-0.57796699,1.7387951,-0.57796699,-0.57796699,-0.57796699,1.7419199,-0.57796699,-0.57796699,-0.57796699,1.7389731,-0.57796699,-0.57796699,-0.57796699,1.7393488,-0.57796699,-0.57796699,-0.57796699,1.7379644,-0.57796699,-0.57796699,-0.57796699,1.7386269,-0.57796699,-0.57693854,-0.56355892,1.7392895,-0.57790765,-0.57693854,-0.56458736,1.7375787,-0.57791754,-0.57693854,-0.5707679,1.740308,-0.57793732,-0.57693854,-0.5707679,1.7397345,-0.57793732,-0.57693854,-0.57179634,1.7379743,-0.57794721,-0.57796699,-0.57796699,1.7410003,-0.57796699,-0.57796699,-0.57796699,1.7388841,-0.57796699,-0.57796699,-0.57796699,1.7398927,-0.57796699,-0.57796699,-0.57796699,1.7395763,-0.57796699,-0.57796699,-0.57796699,1.7377963,-0.57796699,-0.57796699,-0.57796699,1.7398334,-0.57796699,-0.57796699,-0.57796699,1.7382314,-0.57796699,-0.57796699,-0.57796699,1.7372623,-0.57796699,-0.57796699,-0.57796699,1.7378457,-0.57796699,-0.57796699,-0.57796699,1.7385973,-0.57796699,-0.57796699,-0.57796699,1.7370546,-0.57796699,-0.57796699,-0.57796699,1.7368964,-0.57796699,-0.57796699,-0.57796699,1.7345923,-0.57796699,-0.57796699,-0.57796699,1.7357592,-0.57796699,-0.57796699,-0.57796699,1.7361251,-0.57796699,-0.57796699,-0.57796699,1.7324068,-0.57796699,-0.57796699,-0.57796699,1.7366393,-0.57796699,-0.57796699,-0.57796699,1.7340187,-0.57796699,-0.57796699,-0.57796699,1.7354823,-0.57796699,-0.57796699,-0.57796699,1.7362734,-0.57796699,-0.57796699,-0.57796699,1.7342264,-0.57796699,-0.57796699,-0.57796699,1.7362437,-0.57796699,-0.57796699,-0.57796699,1.7328914,-0.57796699,-0.57796699,-0.57796699,1.7294303,-0.57796699,-0.57796699,-0.57796699,1.7311114,-0.57796699,-0.57796699,-0.57796699,1.7305675,-0.57796699,-0.57796699,-0.57796699,1.7272449,-0.57796699,-0.57796699,-0.57796699,1.7324464,-0.57796699,-0.57796699,-0.57796699,1.7322684,-0.57796699,-0.57796699,-0.57796699,1.7326442,-0.57796699,-0.57796699,-0.57796699,1.7342066,-0.57796699,-0.57796699,-0.57796699,1.7341868,-0.57796699,-0.57796699,-0.57796699,1.7355911,-0.57796699,-0.57796699,-0.57796699,1.7344044,-0.57796699,-0.57796699,-0.57796699,1.7278382,-0.57796699,-0.57796699,-0.57796699,1.7272745,-0.57796699,-0.57796699,-0.57796699,1.7264636,-0.57796699,-0.57796699,-0.57796699,1.7324563,-0.57796699,-0.57796699,-0.57796699,1.733198,-0.57796699,-0.57796699,-0.57796699,1.7328815,-0.57796699,-0.57796699,-0.57796699,1.7315267,-0.57796699,-0.57796699,-0.57796699,1.7308543,-0.57796699,-0.57796699,-0.57796699,1.7325651,-0.57796699,-0.57796699,-0.57796699,1.7332968,-0.57796699,-0.57796699,-0.57796699,1.7303895,-0.57796699,-0.57796699,-0.57796699,1.7298951,-0.57796699,-0.57796699,-0.57796699,1.7348098,-0.57796699,-0.57796699,-0.57796699,1.7329013,-0.57796699,-0.57796699,-0.57796699,1.7351362,-0.57796699,-0.57693854,-0.55635983,1.734978,-0.57788788,-0.57693854,-0.56458736,1.7335342,-0.57791754,-0.57693854,-0.56973946,1.7328914,-0.57793732,-0.57693854,-0.5707679,1.7344341,-0.57793732,-0.57693854,-0.5707679,1.7272745,-0.57793732,-0.57693854,-0.57179634,1.7335836,-0.57794721,-0.57693854,-0.57179634,1.7339001,-0.57794721,-0.57693854,-0.57179634,1.7314279,-0.57794721,-0.57693854,-0.57179634,1.7319618,-0.57794721,-0.57693854,-0.57179634,1.734889,-0.57794721,-0.57693854,-0.57179634,1.7339693,-0.57794721,-0.57693854,-0.57282478,1.7336133,-0.57794721,-0.57693854,-0.57282478,1.734355,-0.57794721,-0.57693854,-0.57282478,1.7358877,-0.57794721,-0.57693854,-0.57179634,1.7356306,-0.57794721,-0.57693854,-0.57282478,1.7356702,-0.57794721,-0.57796699,-0.57796699,1.7355812,-0.57796699,-0.57796699,-0.57796699,1.734177,-0.57796699,-0.57796699,-0.57796699,1.7323178,-0.57796699,-0.57796699,-0.57796699,1.731685,-0.57796699,-0.57693854,-0.56871101,1.7312499,-0.57793732,-0.57796699,-0.57796699,1.7329705,-0.57796699,-0.57796699,-0.57796699,1.7351362,-0.57796699,-0.57796699,-0.57796699,1.7336528,-0.57796699,-0.57693854,-0.56871101,1.7342561,-0.57793732,-0.57796699,-0.57796699,1.7351065,-0.57796699,-0.57796699,-0.57796699,1.7290842,-0.57796699,-0.57796699,-0.57796699,1.7308049,-0.57796699,-0.57796699,-0.57796699,1.7291435,-0.57796699,-0.57796699,-0.57796699,1.7306466,-0.57796699,-0.57796699,-0.57796699,1.7292127,-0.57796699,-0.57796699,-0.57796699,1.7307851,-0.57796699,-0.57796699,-0.57796699,1.7289062,-0.57796699,-0.57796699,-0.57796699,1.7299841,-0.57796699,-0.57796699,-0.57796699,1.7311015,-0.57796699,-0.57796699,-0.57796699,1.7310521,-0.57796699,-0.57796699,-0.57796699,1.7318234,-0.57796699,-0.57796699,-0.57796699,1.7306961,-0.57796699,-0.57796699,-0.57796699,1.7292226,-0.57796699,-0.57796699,-0.57796699,1.7309136,-0.57796699,-0.57796699,-0.57796699,1.728748,-0.57796699,-0.57796699,-0.57796699,1.7315366,-0.57796699,-0.57796699,-0.57796699,1.7312499,-0.57796699,-0.57796699,-0.57796699,1.7306763,-0.57796699,-0.57796699,-0.57796699,1.732219,-0.57796699,-0.57796699,-0.57796699,1.732041,-0.57796699,-0.57796699,-0.57796699,1.7293314,-0.57796699,-0.57796699,-0.57796699,1.7289952,-0.57796699,-0.57796699,-0.57796699,1.732842,-0.57796699,-0.57796699,-0.57796699,1.733999,-0.57796699,-0.57796699,-0.57796699,1.731774,-0.57796699,-0.57796699,-0.57796699,1.7314476,-0.57796699,-0.57796699,-0.57796699,1.7267999,-0.57796699,-0.57796699,-0.57796699,1.72501,-0.57796699,-0.57796699,-0.57796699,1.7281447,-0.57796699,-0.57796699,-0.57796699,1.7343154,-0.57796699,-0.57796699,-0.57796699,1.7317443,-0.57796699,-0.57796699,-0.57796699,1.7317146,-0.57796699,-0.57796699,-0.57796699,1.7323871,-0.57796699,-0.57796699,-0.57796699,1.7325651,-0.57796699,-0.57796699,-0.57796699,1.7325848,-0.57796699,-0.57796699,-0.57796699,1.7309136,-0.57796699,-0.57796699,-0.57796699,1.7312499,-0.57796699,-0.57796699,-0.57796699,1.7342462,-0.57796699,-0.57796699,-0.57796699,1.7329903,-0.57796699,-0.57796699,-0.57796699,1.7335144,-0.57796699,-0.57796699,-0.57796699,1.7333166,-0.57796699,-0.57796699,-0.57796699,1.7297467,-0.57796699,-0.57796699,-0.57796699,1.730083,-0.57796699,-0.57796699,-0.57796699,1.7343648,-0.57796699,-0.57796699,-0.57796699,1.7338506,-0.57796699,-0.57796699,-0.57796699,1.7335638,-0.57796699,-0.57796699,-0.57796699,1.7348988,-0.57796699,-0.57796699,-0.57796699,1.7338605,-0.57796699,-0.57796699,-0.57796699,1.733643,-0.57796699,-0.57796699,-0.57796699,1.7348692,-0.57796699,-0.57796699,-0.57796699,1.7325156,-0.57796699,-0.57796699,-0.57796699,1.7325156,-0.57796699,-0.57796699,-0.57796699,1.7331386,-0.57796699,-0.57796699,-0.57796699,1.7329705,-0.57796699,-0.57796699,-0.57796699,1.7317838,-0.57796699,-0.57796699,-0.57796699,1.7318234,-0.57796699,-0.57796699,-0.57796699,1.7297665,-0.57796699,-0.57796699,-0.57796699,1.7327727,-0.57796699,-0.57796699,-0.57796699,1.7299742,-0.57796699,-0.57796699,-0.57796699,1.7318926,-0.57796699,-0.57796699,-0.57796699,1.7328716,-0.57796699,-0.57796699,-0.57796699,1.7314773,-0.57796699,-0.57796699,-0.57796699,1.7292919,-0.57796699,-0.57796699,-0.57796699,1.7256132,-0.57796699,-0.57796699,-0.57796699,1.7264439,-0.57796699,-0.57796699,-0.57796699,1.7259494,-0.57796699,-0.57796699,-0.57796699,1.7265131,-0.57796699,-0.57796699,-0.57796699,1.7292721,-0.57796699,-0.57796699,-0.57796699,1.7304686,-0.57796699,-0.57796699,-0.57796699,1.7312993,-0.57796699,-0.57796699,-0.57796699,1.731774,-0.57796699,-0.57796699,-0.57796699,1.7312795,-0.57796699,-0.57796699,-0.57796699,1.731062,-0.57796699,-0.57796699,-0.57796699,1.7304686,-0.57796699,-0.57796699,-0.57796699,1.7298852,-0.57796699,-0.57796699,-0.57796699,1.7302214,-0.57796699,-0.57796699,-0.57796699,1.7305477,-0.57796699,-0.57796699,-0.57796699,1.7314081,-0.57796699,-0.57796699,-0.57796699,1.7341671,-0.57796699,-0.57796699,-0.57796699,1.7340978,-0.57796699,-0.57796699,-0.57796699,1.7337122,-0.57796699,-0.57796699,-0.57796699,1.7352548,-0.57796699,-0.57796699,-0.57796699,1.7356108,-0.57796699,-0.57796699,-0.57796699,1.7344934,-0.57796699,-0.57796699,-0.57796699,1.7331683,-0.57796699,-0.57796699,-0.57796699,1.733999,-0.57796699,-0.57796699,-0.57796699,1.7372919,-0.57796699,-0.57796699,-0.57796699,1.7369953,-0.57796699,-0.57796699,-0.57796699,1.7366986,-0.57796699,-0.57796699,-0.57796699,1.7378853,-0.57796699,-0.57796699,-0.57796699,1.7356009,-0.57796699,-0.57796699,-0.57796699,1.7369359,-0.57796699,-0.57796699,-0.57796699,1.7379446,-0.57796699,-0.57796699,-0.57796699,1.7374798,-0.57796699,-0.57796699,-0.57796699,1.7372326,-0.57796699,-0.57796699,-0.57796699,1.7365701,-0.57796699,-0.57796699,-0.57796699,1.7357987,-0.57796699,-0.57796699,-0.57796699,1.7350373,-0.57796699,-0.57796699,-0.57796699,1.7349186,-0.57796699,-0.57796699,-0.57796699,1.7311806,-0.57796699,-0.57796699,-0.57796699,1.7291336,-0.57796699,-0.57796699,-0.57796699,1.7303104,-0.57796699,-0.57796699,-0.57796699,1.728214,-0.57796699,-0.57796699,-0.57796699,1.7327134,-0.57796699,-0.57796699,-0.57796699,1.733732,-0.57796699,-0.57796699,-0.57796699,1.7328123,-0.57796699,-0.57796699,-0.57796699,1.7328222,-0.57796699,-0.57796699,-0.57796699,1.7319618,-0.57796699,-0.57796699,-0.57796699,1.7325947,-0.57796699,-0.57796699,-0.57796699,1.732842,-0.57796699,-0.57796699,-0.57796699,1.7341868,-0.57796699,-0.57796699,-0.57796699,1.7355317,-0.57796699,-0.57796699,-0.57796699,1.7331782,-0.57796699,-0.57796699,-0.57796699,1.7356899,-0.57796699,-0.57796699,-0.57796699,1.7337814,-0.57796699,-0.57796699,-0.57796699,1.7356009,-0.57796699,-0.57796699,-0.57796699,1.7339594,-0.57796699,-0.57796699,-0.57796699,1.7320607,-0.57796699,-0.57796699,-0.57796699,1.7289457,-0.57796699,-0.57796699,-0.57796699,1.7340187,-0.57796699,-0.57796699,-0.57796699,1.7285799,-0.57796699,-0.57796699,-0.57796699,1.7307257,-0.57796699,-0.57796699,-0.57796699,1.7273141,-0.57796699,-0.57796699,-0.57796699,1.7333957,-0.57796699,-0.57796699,-0.57796699,1.7311114,-0.57796699,-0.57796699,-0.57796699,1.7256923,-0.57796699,-0.57796699,-0.57796699,1.7291435,-0.57796699,-0.57796699,-0.57796699,1.7290941,-0.57796699,-0.57796699,-0.57796699,1.7315465,-0.57796699,-0.57796699,-0.57796699,1.7300731,-0.57796699,-0.57796699,-0.57796699,1.7303401,-0.57796699,-0.57796699,-0.57796699,1.7284612,-0.57796699,-0.57796699,-0.57796699,1.7281447,-0.57796699,-0.57796699,-0.57796699,1.72768,-0.57796699,-0.57796699,-0.57796699,1.7293907,-0.57796699,-0.57796699,-0.57796699,1.7281744,-0.57796699,-0.57796699,-0.57796699,1.7276602,-0.57796699,-0.57796699,-0.57796699,1.7286985,-0.57796699,-0.57796699,-0.57796699,1.7318234,-0.57796699,-0.57796699,-0.57796699,1.7307653,-0.57796699,-0.57796699,-0.57796699,1.7318926,-0.57796699,-0.57796699,-0.57796699,1.7312993,-0.57796699,-0.57796699,-0.57796699,1.730617,-0.57796699,-0.57796699,-0.57796699,1.7291732,-0.57796699,-0.57796699,-0.57796699,1.7297072,-0.57796699,-0.57796699,-0.57796699,1.7268889,-0.57796699,-0.57796699,-0.57796699,1.728125,-0.57796699,-0.57796699,-0.57796699,1.7318926,-0.57796699,-0.57796699,-0.57796699,1.7326145,-0.57796699,-0.57796699,-0.57796699,1.7313191,-0.57796699,-0.57796699,-0.57796699,1.731151,-0.57796699,-0.57796699,-0.57796699,1.7314476,-0.57796699,-0.57796699,-0.57796699,1.7320607,-0.57796699,-0.57796699,-0.57796699,1.7296281,-0.57796699,-0.57796699,-0.57796699,1.7318827,-0.57796699,-0.57796699,-0.57796699,1.7354922,-0.57796699,-0.57796699,-0.57796699,1.7339198,-0.57796699,-0.57796699,-0.57796699,1.7324266,-0.57796699,-0.57796699,-0.57796699,1.7348593,-0.57796699,-0.57796699,-0.57796699,1.7340583,-0.57796699,-0.57796699,-0.57796699,1.7360657,-0.57796699,-0.57796699,-0.57796699,1.7352054,-0.57796699,-0.57796699,-0.57796699,1.7369063,-0.57796699,-0.57796699,-0.57796699,1.7374897,-0.57796699,-0.57796699,-0.57796699,1.7355218,-0.57796699,-0.57796699,-0.57796699,1.7370645,-0.57796699,-0.57796699,-0.57796699,1.7356207,-0.57796699,-0.57796699,-0.57796699,1.7289359,-0.57796699,-0.57796699,-0.57796699,1.7259989,-0.57796699,-0.57796699,-0.57796699,1.7250199,-0.57796699,-0.57796699,-0.57796699,1.7254253,-0.57796699,-0.57796699,-0.57796699,1.7250199,-0.57796699,-0.57796699,-0.57796699,1.7200952,-0.57796699,-0.57796699,-0.57796699,1.7267504,-0.57796699,-0.57796699,-0.57796699,1.7269779,-0.57796699,-0.57796699,-0.57796699,1.7259989,-0.57796699,-0.57796699,-0.57796699,1.720293,-0.57796699,-0.57796699,-0.57796699,1.7210347,-0.57796699,-0.57796699,-0.57796699,1.7204215,-0.57796699,-0.57796699,-0.57796699,1.721895,-0.57796699,-0.57796699,-0.57796699,1.7249902,-0.57796699,-0.57796699,-0.57796699,1.7262659,-0.57796699,-0.57796699,-0.57796699,1.7259989,-0.57796699,-0.57796699,-0.57796699,1.7266219,-0.57796699,-0.57796699,-0.57796699,1.726167,-0.57796699,-0.57796699,-0.55635983,1.7239519,-0.57787799,-0.57693854,-0.56973946,1.7256923,-0.57793732,-0.57693854,-0.56973946,1.7256824,-0.57793732,-0.57693854,-0.5707679,1.7199172,-0.57793732,-0.57693854,-0.5707679,1.7207479,-0.57793732,-0.57693854,-0.57179634,1.7224685,-0.57794721,-0.57693854,-0.57179634,1.7234377,-0.57794721,-0.57693854,-0.57179634,1.722696,-0.57794721,-0.57693854,-0.57179634,1.7191854,-0.57794721,-0.57693854,-0.57179634,1.7174747,-0.57794721,-0.57693854,-0.57179634,1.7157936,-0.57794721,-0.57693854,-0.57282478,1.7189184,-0.57794721,-0.57693854,-0.57282478,1.7195414,-0.57794721,-0.57693854,-0.57282478,1.7189283,-0.57794721,-0.57693854,-0.57179634,1.717356,-0.57794721,-0.57693854,-0.57282478,1.7142608,-0.57794721,-0.57693854,-0.57282478,1.7182262,-0.57794721,-0.57693854,-0.57282478,1.7191162,-0.57794721,-0.57693854,-0.57282478,1.7178406,-0.57794721,-0.57693854,-0.57282478,1.7182163,-0.57794721,-0.57796699,-0.57796699,1.7159617,-0.57796699,-0.57796699,-0.57796699,1.7139443,-0.57796699,-0.57796699,-0.57796699,1.7156749,-0.57796699,-0.57796699,-0.57796699,1.7167429,-0.57796699,-0.57796699,-0.57796699,1.7167429,-0.57796699,-0.57796699,-0.57796699,1.7167429,-0.57796699,-0.57796699,-0.57796699,1.7167429,-0.57796699,-0.57796699,-0.57796699,1.7167429,-0.57796699,-0.57796699,-0.57796699,1.7167429,-0.57796699,-0.57796699,-0.57796699,1.7167429,-0.57796699:9
-0.58857465,-0.58857465,1.7231335,-0.58857465,-0.58857465,-0.58857465,1.7242074,-0.58857465,-0.58857465,-0.58857465,1.7208618,-0.58857465,-0.58857465,-0.58857465,1.7226275,-0.58857465,-0.58857465,-0.58857465,1.7225449,-0.58857465,-0.58857465,-0.58857465,1.7104534,-0.58857465,-0.58857465,-0.58857465,1.7102882,-0.58857465,-0.58857465,-0.58857465,1.7100094,-0.58857465,-0.59716571,-0.52946979,1.713355,-0.5883165,-0.59716571,-0.53054367,1.7134272,-0.5883165,-0.59716571,-0.53161756,1.713737,-0.5883165,-0.59716571,-0.53269144,1.7110936,-0.58832683,-0.59823959,-0.53054367,1.7138609,-0.5883165,-0.59609182,-0.53484953,1.7143669,-0.58833715,-0.59716571,-0.53376532,1.712312,-0.58832683,-0.59609182,-0.53376532,1.7094002,-0.58832683,-0.59609182,-0.53376532,1.7120229,-0.58832683,-0.59609182,-0.53484953,1.7115066,-0.58833715,-0.59501794,-0.53592341,1.7102366,-0.58833715,-0.59609182,-0.53592341,1.7113104,-0.58833715,-0.59609182,-0.53592341,1.7124876,-0.58833715,-0.59609182,-0.53592341,1.7051253,-0.58833715,-0.59609182,-0.53592341,1.7111452,-0.58833715,-0.59501794,-0.5369973,1.7075415,-0.58834748,-0.59501794,-0.5369973,1.7132723,-0.58834748,-0.59609182,-0.5369973,1.7189825,-0.58834748,-0.59609182,-0.5369973,1.7200461,-0.58834748,-0.59501794,-0.5369973,1.7214814,-0.58834748,-0.59609182,-0.5369973,1.7244655,-0.58834748,-0.59287018,-0.54773612,1.721564,-0.58839911,-0.59287018,-0.54773612,1.7201803,-0.58839911,-0.59287018,-0.54773612,1.7216156,-0.58839911,-0.59287018,-0.54773612,1.7121365,-0.58839911,-0.59287018,-0.54773612,1.7129626,-0.58839911,-0.59179629,-0.54773612,1.7101127,-0.58839911,-0.59287018,-0.54773612,1.7098958,-0.58839911,-0.59394406,-0.54773612,1.7012738,-0.58838878,-0.59394406,-0.54773612,1.7073453,-0.58839911,-0.59287018,-0.54773612,1.706478,-0.58839911,-0.59394406,-0.54773612,1.7056416,-0.58839911,-0.59287018,-0.54773612,1.7135821,-0.58839911,-0.59287018,-0.54773612,1.711042,-0.58839911,-0.59287018,-0.54773612,1.7106702,-0.58839911,-0.59287018,-0.54773612,1.7172065,-0.58839911,-0.59287018,-0.54773612,1.7052595,-0.58839911,-0.59287018,-0.54773612,1.7025542,-0.58839911,-0.59287018,-0.54773612,1.7011602,-0.58839911,-0.59287018,-0.54773612,1.7014183,-0.58839911,-0.59287018,-0.54773612,1.6983309,-0.58839911,-0.59287018,-0.54773612,1.7010982,-0.58839911,-0.59287018,-0.54773612,1.7329843,-0.58839911,-0.59287018,-0.54773612,1.7337381,-0.58839911,-0.59394406,-0.54773612,1.732024,-0.58839911,-0.59287018,-0.54773612,1.7341718,-0.58839911,-0.59287018,-0.54773612,1.735225,-0.58839911,-0.59287018,-0.54773612,1.7348842,-0.58839911,-0.59287018,-0.54773612,1.7361543,-0.58839911,-0.59394406,-0.54773612,1.7338517,-0.58839911,-0.59394406,-0.54773612,1.732499,-0.58839911,-0.59287018,-0.54773612,1.7212335,-0.58839911,-0.59394406,-0.54773612,1.7308675,-0.58839911,-0.59287018,-0.54773612,1.726572,-0.58839911,-0.59287018,-0.54773612,1.7293393,-0.58839911,-0.59287018,-0.54773612,1.7324783,-0.58839911,-0.59287018,-0.54773612,1.7289779,-0.58839911,-0.59287018,-0.54773612,1.7303409,-0.58839911,-0.59287018,-0.54773612,1.7311979,-0.58839911,-0.59287018,-0.54773612,1.7327674,-0.58839911,-0.59287018,-0.54882033,1.7317555,-0.58839911,-0.59287018,-0.54773612,1.7385705,-0.58839911,-0.59179629,-0.54773612,1.733831,-0.58839911,-0.59287018,-0.54882033,1.7393553,-0.58839911,-0.59287018,-0.54882033,1.7428248,-0.58839911,-0.59287018,-0.54882033,1.7398819,-0.58839911,-0.59287018,-0.54882033,1.7319311,-0.58839911,-0.59287018,-0.54882033,1.7296078,-0.58839911,-0.59287018,-0.54882033,1.7293083,-0.58839911,-0.59287018,-0.54882033,1.7303925,-0.58839911,-0.59287018,-0.54882033,1.7262519,-0.58839911,-0.59287018,-0.54882033,1.7331495,-0.58839911,-0.59287018,-0.54882033,1.7338517,-0.58839911,-0.59287018,-0.54882033,1.7358652,-0.58839911,-0.59287018,-0.54882033,1.7236704,-0.58839911,-0.59287018,-0.54882033,1.735731,-0.58839911,-0.59394406,-0.54882033,1.7355761,-0.58839911,-0.59287018,-0.54882033,1.7360511,-0.58839911,-0.59287018,-0.54882033,1.7348636,-0.58839911,-0.59287018,-0.54882033,1.7327674,-0.58839911,-0.59287018,-0.54882033,1.7364331,-0.58839911,-0.59287018,-0.54882033,1.7355761,-0.58839911,-0.59287018,-0.54882033,1.7371043,-0.58839911,-0.59287018,-0.54882033,1.7357723,-0.58839911,-0.59287018,-0.54882033,1.7316936,-0.58839911,-0.59287018,-0.54882033,1.731611,-0.58839911,-0.59287018,-0.54882033,1.7339446,-0.58839911,-0.59287018,-0.54882033,1.7357723,-0.58839911,-0.59287018,-0.54882033,1.7347603,-0.58839911,-0.59287018,-0.54882033,1.7336348,-0.58839911,-0.59287018,-0.54882033,1.7356174,-0.58839911,-0.59287018,-0.54882033,1.7349668,-0.58839911,-0.59287018,-0.54882033,1.7358136,-0.58839911,-0.59287018,-0.54882033,1.7363815,-0.58839911,-0.59287018,-0.54882033,1.7373624,-0.58839911,-0.59287018,-0.54882033,1.7399542,-0.58839911,-0.59287018,-0.54882033,1.7365983,-0.58839911,-0.59287018,-0.54882033,1.7330566,-0.58839911,-0.59287018,-0.54882033,1.7348636,-0.58839911,-0.59287018,-0.54989422,1.733893,-0.58840943,-0.59287018,-0.54882033,1.7346467,-0.58839911,-0.59287018,-0.54882033,1.7327881,-0.58839911,-0.59287018,-0.54882033,1.7335522,-0.58839911,-0.59287018,-0.54989422,1.7324473,-0.58840943,-0.59287018,-0.54989422,1.7302686,-0.58840943,-0.59287018,-0.54989422,1.7316729,-0.58840943,-0.59287018,-0.54989422,1.7306197,-0.58840943,-0.59287018,-0.54989422,1.7316419,-0.58840943,-0.59287018,-0.54989422,1.736619,-0.58840943,-0.59287018,-0.54989422,1.7359581,-0.58840943,-0.59287018,-0.54989422,1.7328294,-0.58840943,-0.59287018,-0.54989422,1.7304751,-0.58840943,-0.59287018,-0.54989422,1.733356,-0.58840943,-0.59287018,-0.54989422,1.7276975,-0.58840943,-0.59287018,-0.54989422,1.7279969,-0.58840943,-0.59287018,-0.54989422,1.7260247,-0.58840943,-0.59287018,-0.54989422,1.7214607,-0.58840943,-0.59287018,-0.54989422,1.7222351,-0.58840943,-0.59287018,-0.54989422,1.719282,-0.58840943,-0.59287018,-0.54989422,1.7209031,-0.58840943,-0.59287018,-0.54989422,1.7207069,-0.58840943,-0.59394406,-0.54989422,1.7222558,-0.58840943,-0.59287018,-0.54989422,1.7263758,-0.58840943,-0.59287018,-0.54989422,1.7268095,-0.58840943,-0.59287018,-0.54989422,1.7259421,-0.58840943,-0.59287018,-0.54989422,1.7285442,-0.58840943,-0.59287018,-0.54989422,1.7277388,-0.58840943,-0.59287018,-0.54989422,1.7282034,-0.58840943,-0.59287018,-0.54989422,1.726128,-0.58840943,-0.59287018,-0.54989422,1.726923,-0.58840943,-0.59287018,-0.54989422,1.7271296,-0.58840943,-0.59287018,-0.54989422,1.731993,-0.58840943,-0.59287018,-0.54989422,1.7294632,-0.58840943,-0.59287018,-0.54989422,1.7330256,-0.58840943,-0.59287018,-0.5509681,1.7305268,-0.58840943,-0.59287018,-0.54989422,1.7297007,-0.58840943,-0.59287018,-0.54989422,1.7275529,-0.58840943,-0.59394406,-0.54989422,1.7246927,-0.58840943,-0.59287018,-0.54989422,1.7305268,-0.58840943,-0.59287018,-0.54989422,1.733356,-0.58840943,-0.59287018,-0.54989422,1.7346054,-0.58840943,-0.59287018,-0.54989422,1.7333044,-0.58840943,-0.59287018,-0.54989422,1.7362576,-0.58840943,-0.59287018,-0.5509681,1.7403672,-0.58840943,-0.59287018,-0.5509681,1.7273258,-0.58840943,-0.59287018,-0.5509681,1.7294322,-0.58840943,-0.59287018,-0.5509681,1.7268611,-0.58840943,-0.59287018,-0.54989422,1.7276045,-0.58840943,-0.59287018,-0.5509681,1.7299072,-0.58840943,-0.59287018,-0.5509681,1.7285442,-0.58840943,-0.59287018,-0.5509681,1.7304441,-0.58840943,-0.59287018,-0.5509681,1.7317142,-0.58840943,-0.59287018,-0.5509681,1.7313115,-0.58840943,-0.59287018,-0.5509681,1.7302893,-0.58840943,-0.59287018,-0.5509681,1.7339239,-0.58840943,-0.59287018,-0.5509681,1.7342544,-0.58840943,-0.59179629,-0.5509681,1.7390455,-0.58840943,-0.59179629,-0.5509681,1.7333354,-0.58840943,-0.59179629,-0.5509681,1.7347087,-0.58840943,-0.59179629,-0.5509681,1.7374863,-0.58840943,-0.59287018,-0.5509681,1.736082,-0.58840943,-0.59179629,-0.5509681,1.7336658,-0.58840943,-0.59179629,-0.5509681,1.7389629,-0.58840943,-0.59179629,-0.5509681,1.7385912,-0.58840943,-0.59179629,-0.5509681,1.7352353,-0.58840943,-0.59287018,-0.5509681,1.7318071,-0.58840943,-0.59287018,-0.5509681,1.7364847,-0.58840943,-0.59287018,-0.5509681,1.7382608,-0.58840943,-0.59179629,-0.5509681,1.7338826,-0.58840943,-0.59179629,-0.5509681,1.734688,-0.58840943,-0.59179629,-0.5509681,1.7389733,-0.58840943,-0.59179629,-0.5509681,1.7338413,-0.58840943,-0.59179629,-0.5509681,1.7317968,-0.58840943,-0.59287018,-0.5509681,1.733862,-0.58840943,-0.59287018,-0.5509681,1.7278317,-0.58840943,-0.59179629,-0.5509681,1.7306197,-0.58840943,-0.59179629,-0.5509681,1.7309295,-0.58840943,-0.59179629,-0.5509681,1.7331289,-0.58840943,-0.59179629,-0.5509681,1.7339756,-0.58840943,-0.59179629,-0.5509681,1.7226791,-0.58840943,-0.59179629,-0.5509681,1.7207999,-0.58840943,-0.59179629,-0.5509681,1.721564,-0.58840943,-0.59179629,-0.5509681,1.7163804,-0.58840943,-0.59179629,-0.5509681,1.7160603,-0.58840943,-0.59179629,-0.5509681,1.7245791,-0.58840943,-0.59179629,-0.5509681,1.7229992,-0.58840943,-0.59179629,-0.5509681,1.7234639,-0.58840943,-0.59179629,-0.5509681,1.7322615,-0.58840943,-0.59179629,-0.55204198,1.7268611,-0.58841976,-0.59179629,-0.5509681,1.7254878,-0.58840943,-0.59179629,-0.5509681,1.7355967,-0.58840943,-0.59179629,-0.5509681,1.7374347,-0.58840943,-0.59179629,-0.55204198,1.737094,-0.58841976,-0.59179629,-0.5509681,1.7394586,-0.58840943,-0.59179629,-0.55204198,1.7339446,-0.58841976,-0.59179629,-0.55204198,1.7313322,-0.58841976,-0.59179629,-0.55204198,1.7332837,-0.58841976,-0.59179629,-0.55204198,1.7386532,-0.58841976,-0.59179629,-0.55204198,1.7405015,-0.58841976,-0.59179629,-0.55204198,1.7399335,-0.58841976,-0.59179629,-0.55204198,1.7370217,-0.58841976,-0.59179629,-0.55204198,1.7357,-0.58841976,-0.59179629,-0.55204198,1.7356174,-0.58841976,-0.59179629,-0.55204198,1.7319207,-0.58841976,-0.59287018,-0.55204198,1.732881,-0.58841976,-0.59179629,-0.55204198,1.7359581,-0.58841976,-0.59287018,-0.55204198,1.7359478,-0.58841976,-0.59287018,-0.55204198,1.7369907,-0.58841976,-0.59179629,-0.55204198,1.7390559,-0.58841976,-0.59179629,-0.55204198,1.7362782,-0.58841976,-0.59179629,-0.55204198,1.7319207,-0.58841976,-0.59179629,-0.55204198,1.7397374,-0.58841976,-0.59179629,-0.55204198,1.7284616,-0.58841976,-0.59179629,-0.55204198,1.7281931,-0.58841976,-0.59179629,-0.55204198,1.7330979,-0.58841976,-0.59179629,-0.55204198,1.7334799,-0.58841976,-0.59179629,-0.55204198,1.7364641,-0.58841976,-0.59179629,-0.55204198,1.7249818,-0.58841976,-0.59179629,-0.55204198,1.7322305,-0.58841976,-0.59179629,-0.55204198,1.7383744,-0.58841976,-0.59287018,-0.55204198,1.7406047,-0.58841976,-0.59179629,-0.55204198,1.7404395,-0.58841976,-0.59179629,-0.55204198,1.7405428,-0.58841976,-0.59179629,-0.55204198,1.7459225,-0.58841976,-0.59179629,-0.55204198,1.7412139,-0.58841976,-0.59179629,-0.55204198,1.7450655,-0.58841976,-0.59179629,-0.55204198,1.7292257,-0.58841976,-0.59287018,-0.55204198,1.7238873,-0.58841976,-0.59179629,-0.55204198,1.727016,-0.58841976,-0.59179629,-0.55204198,1.7244139,-0.58841976,-0.59179629,-0.55204198,1.7271812,-0.58841976,-0.59179629,-0.55204198,1.7254361,-0.58841976,-0.59179629,-0.55204198,1.726035,-0.58841976,-0.59179629,-0.55204198,1.724734,-0.58841976,-0.59179629,-0.55204198,1.7152756,-0.58841976,-0.59179629,-0.55204198,1.7205107,-0.58841976,-0.59179629,-0.55204198,1.7177124,-0.58841976,-0.59072241,-0.55204198,1.7168657,-0.58841976,-0.59179629,-0.55204198,1.7196743,-0.58841976,-0.59179629,-0.55204198,1.719664,-0.58841976,-0.59072241,-0.55204198,1.7269024,-0.58841976,-0.59179629,-0.55204198,1.7270263,-0.58841976,-0.59179629,-0.55204198,1.7289676,-0.58841976,-0.59179629,-0.55204198,1.7313941,-0.58841976,-0.59179629,-0.55204198,1.7303099,-0.58841976,-0.59179629,-0.55204198,1.7327261,-0.58841976,-0.59179629,-0.55311586,1.731074,-0.58841976,-0.59179629,-0.55204198,1.7323544,-0.58841976,-0.59179629,-0.55204198,1.7304028,-0.58841976,-0.59179629,-0.55204198,1.7294838,-0.58841976,-0.59179629,-0.55204198,1.7340478,-0.58841976,-0.59179629,-0.55204198,1.7325093,-0.58841976,-0.59179629,-0.55204198,1.728379,-0.58841976,-0.59179629,-0.55204198,1.7248579,-0.58841976,-0.59179629,-0.55204198,1.7224726,-0.58841976,-0.59179629,-0.55311586,1.7219254,-0.58841976,-0.59179629,-0.55204198,1.7301653,-0.58841976,-0.59179629,-0.55311586,1.733325,-0.58841976,-0.59179629,-0.55311586,1.710949,-0.58841976,-0.59179629,-0.55311586,1.7386635,-0.58841976,-0.59179629,-0.55204198,1.7398303,-0.58841976,-0.59179629,-0.55311586,1.7377858,-0.58841976,-0.59179629,-0.55311586,1.7402227,-0.58841976,-0.59179629,-0.55311586,1.7348326,-0.58841976,-0.59179629,-0.55311586,1.7330359,-0.58841976,-0.59179629,-0.55311586,1.7392417,-0.58841976,-0.59179629,-0.55311586,1.7307126,-0.58841976,-0.59179629,-0.55311586,1.7225036,-0.58841976,-0.59179629,-0.55311586,1.7273051,-0.58841976,-0.59179629,-0.55311586,1.7291121,-0.58841976,-0.59179629,-0.55311586,1.723815,-0.58841976,-0.59179629,-0.55311586,1.7316523,-0.58841976,-0.59179629,-0.55311586,1.7389733,-0.58841976,-0.59287018,-0.55311586,1.7351734,-0.58841976,-0.59179629,-0.55311586,1.7336968,-0.58841976,-0.59179629,-0.55311586,1.7382195,-0.58841976,-0.59179629,-0.55311586,1.7377445,-0.58841976,-0.59179629,-0.55311586,1.7342131,-0.58841976,-0.59179629,-0.55311586,1.7328191,-0.58841976,-0.59179629,-0.55311586,1.7280589,-0.58841976,-0.59179629,-0.55311586,1.736619,-0.58841976,-0.59179629,-0.55311586,1.7327778,-0.58841976,-0.59179629,-0.55311586,1.7371146,-0.58841976,-0.59179629,-0.55311586,1.7399955,-0.58841976,-0.59179629,-0.55311586,1.7378064,-0.58841976,-0.59179629,-0.55311586,1.7308985,-0.58841976,-0.59179629,-0.55311586,1.7407699,-0.58841976,-0.59179629,-0.55311586,1.7408112,-0.58841976,-0.59179629,-0.55311586,1.7420194,-0.58841976,-0.59179629,-0.55311586,1.7363092,-0.58841976,-0.59179629,-0.55311586,1.73792,-0.58841976,-0.59179629,-0.55311586,1.7384157,-0.58841976,-0.59179629,-0.55311586,1.7427628,-0.58841976,-0.59287018,-0.55311586,1.7391901,-0.58841976,-0.59179629,-0.55311586,1.7432275,-0.58841976,-0.59179629,-0.55311586,1.7385396,-0.58841976,-0.59179629,-0.55311586,1.7405634,-0.58841976,-0.59179629,-0.55311586,1.7409455,-0.58841976,-0.59179629,-0.55311586,1.7417922,-0.58841976,-0.59179629,-0.55311586,1.7456747,-0.58841976,-0.59179629,-0.55311586,1.743816,-0.58841976,-0.59179629,-0.55311586,1.7446834,-0.58841976,-0.59179629,-0.55311586,1.7456953,-0.58841976,-0.59179629,-0.55311586,1.7422156,-0.58841976,-0.59179629,-0.55311586,1.7433204,-0.58841976,-0.59179629,-0.55311586,1.7488757,-0.58841976,-0.59179629,-0.55311586,1.7492681,-0.58841976,-0.59179629,-0.55311586,1.7507343,-0.58841976,-0.59179629,-0.55311586,1.7491029,-0.58841976,-0.59179629,-0.55311586,1.7458606,-0.58841976,-0.59179629,-0.55311586,1.7500425,-0.58841976,-0.59179629,-0.55311586,1.7492164,-0.58841976,-0.59179629,-0.55311586,1.7511474,-0.58841976,-0.59179629,-0.55311586,1.7480083,-0.58841976,-0.59179629,-0.55311586,1.7462013,-0.58841976,-0.59179629,-0.55311586,1.7443427,-0.58841976,-0.59179629,-0.55311586,1.7413585,-0.58841976,-0.59179629,-0.55311586,1.7297833,-0.58841976,-0.59179629,-0.55311586,1.7271915,-0.58841976,-0.59179629,-0.55311586,1.7440329,-0.58841976,-0.59179629,-0.55311586,1.7402227,-0.58841976,-0.59179629,-0.55311586,1.7479464,-0.58841976,-0.59179629,-0.55311586,1.7520664,-0.58841976,-0.59179629,-0.55311586,1.7479257,-0.58841976,-0.59179629,-0.55311586,1.7491648,-0.58841976,-0.59179629,-0.55311586,1.7496708,-0.58841976,-0.59179629,-0.55311586,1.7505072,-0.58841976,-0.59179629,-0.55311586,1.750786,-0.58841976,-0.59179629,-0.55311586,1.7488757,-0.58841976,-0.59179629,-0.55311586,1.7451274,-0.58841976,-0.59179629,-0.55311586,1.7510441,-0.58841976,-0.59179629,-0.55311586,1.7503626,-0.58841976,-0.59179629,-0.55311586,1.7547924,-0.58841976,-0.59179629,-0.55311586,1.7477399,-0.58841976,-0.59179629,-0.55311586,1.7505278,-0.58841976,-0.59179629,-0.55311586,1.7529854,-0.58841976,-0.59179629,-0.55311586,1.7492474,-0.58841976,-0.59179629,-0.55311586,1.7500425,-0.58841976,-0.59179629,-0.55311586,1.7495056,-0.58841976,-0.59179629,-0.55311586,1.7430829,-0.58841976,-0.59179629,-0.55311586,1.7445389,-0.58841976,-0.59179629,-0.55311586,1.7468312,-0.58841976,-0.59179629,-0.55311586,1.7568988,-0.58841976,-0.59179629,-0.55311586,1.7546272,-0.58841976,-0.59179629,-0.55311586,1.7499805,-0.58841976,-0.59179629,-0.55311586,1.7536565,-0.58841976,-0.59179629,-0.55311586,1.7447247,-0.58841976,-0.59179629,-0.55311586,1.7525826,-0.58841976,-0.59179629,-0.55311586,1.7497224,-0.58841976,-0.59179629,-0.55418975,1.7480909,-0.58843008,-0.59179629,-0.55418975,1.7424324,-0.58843008,-0.59179629,-0.55418975,1.7424324,-0.58843008,-0.59179629,-0.55418975,1.7424324,-0.58843008,-0.59179629,-0.55418975,1.7424324,-0.58843008,-0.59179629,-0.55418975,1.7424324,-0.58843008,-0.59179629,-0.55418975,1.7424324,-0.58843008,-0.59179629,-0.55418975,1.7424324,-0.58843008:9
-0.58289722,-0.57376097,1.7534016,-0.58283834,-0.58289722,-0.58289722,1.7545007,-0.58289722,-0.58593937,-0.55546885,1.7500552,-0.58271077,-0.58593937,-0.55648944,1.750487,-0.58271077,-0.58593937,-0.55648944,1.7503987,-0.58271077,-0.58593937,-0.55546885,1.7474056,-0.58271077,-0.58492859,-0.55546885,1.7512917,-0.58271077,-0.58593937,-0.55546885,1.7480042,-0.58271077,-0.58492859,-0.55546885,1.7484556,-0.58271077,-0.58593937,-0.55546885,1.7474252,-0.58271077,-0.58492859,-0.55648944,1.7525086,-0.58271077,-0.58492859,-0.55546885,1.7539707,-0.58271077,-0.58492859,-0.55546885,1.7538922,-0.58271077,-0.58593937,-0.55546885,1.7538726,-0.58271077,-0.58492859,-0.55648944,1.7535684,-0.58271077,-0.58492859,-0.55546885,1.7540394,-0.58271077,-0.58492859,-0.55546885,1.7536567,-0.58271077,-0.58593937,-0.55546885,1.7519099,-0.58271077,-0.58593937,-0.55546885,1.7516744,-0.58271077,-0.58593937,-0.55546885,1.7539511,-0.58271077,-0.58492859,-0.55648944,1.7548441,-0.58271077,-0.58593937,-0.55648944,1.755639,-0.58271077,-0.58492859,-0.55648944,1.755639,-0.58271077,-0.58593937,-0.55546885,1.753588,-0.58271077,-0.58492859,-0.55546885,1.7536077,-0.58271077,-0.58593937,-0.55546885,1.7546577,-0.58271077,-0.58593937,-0.55546885,1.7534408,-0.58271077,-0.58593937,-0.55546885,1.755953,-0.58271077,-0.58492859,-0.55648944,1.7558745,-0.58271077,-0.58593937,-0.55546885,1.7546381,-0.58271077,-0.58289722,-0.58289722,1.7548834,-0.58289722,-0.58289722,-0.58289722,1.7557077,-0.58289722,-0.58289722,-0.58289722,1.7557666,-0.58289722,-0.58289722,-0.58289722,1.7554624,-0.58289722,-0.58289722,-0.58289722,1.7536371,-0.58289722,-0.58289722,-0.58289722,1.7521945,-0.58289722,-0.58289722,-0.58289722,1.7511347,-0.58289722,-0.58289722,-0.58289722,1.7485341,-0.58289722,-0.58289722,-0.58289722,1.7486813,-0.58289722,-0.58289722,-0.58289722,1.7505263,-0.58289722,-0.58289722,-0.58289722,1.7500748,-0.58289722,-0.58289722,-0.58289722,1.7491916,-0.58289722,-0.58289722,-0.58289722,1.7472878,-0.58289722,-0.58289722,-0.58289722,1.7488972,-0.58289722,-0.58289722,-0.58289722,1.7495449,-0.58289722,-0.58289722,-0.58289722,1.7463359,-0.58289722,-0.58289722,-0.58289722,1.7481907,-0.58289722,-0.58289722,-0.58289722,1.7494762,-0.58289722,-0.58289722,-0.58289722,1.7495351,-0.58289722,-0.58289722,-0.58289722,1.74928,-0.58289722,-0.58289722,-0.58289722,1.7493977,-0.58289722,-0.58289722,-0.58289722,1.7483084,-0.58289722,-0.58289722,-0.58289722,1.7515763,-0.58289722,-0.58289722,-0.58289722,1.7485734,-0.58289722,-0.58289722,-0.58289722,1.7498197,-0.58289722,-0.58289722,-0.58289722,1.7477098,-0.58289722,-0.58289722,-0.58289722,1.7496823,-0.58289722,-0.58289722,-0.58289722,1.746542,-0.58289722,-0.58289722,-0.58289722,1.7503791,-0.58289722,-0.58289722,-0.58289722,1.7494959,-0.58289722,-0.58289722,-0.58289722,1.747386,-0.58289722,-0.58289722,-0.58289722,1.748907,-0.58289722,-0.58289722,-0.58289722,1.7496234,-0.58289722,-0.58289722,-0.58289722,1.7488285,-0.58289722,-0.58289722,-0.58289722,1.7510562,-0.58289722,-0.58289722,-0.58289722,1.7473369,-0.58289722,-0.58289722,-0.58289722,1.7467481,-0.58289722,-0.58289722,-0.58289722,1.7494272,-0.58289722,-0.58289722,-0.58289722,1.750958,-0.58289722,-0.58289722,-0.58289722,1.7504968,-0.58289722,-0.58289722,-0.58289722,1.7504085,-0.58289722,-0.58289722,-0.58289722,1.7530189,-0.58289722,-0.58289722,-0.58289722,1.7548736,-0.58289722,-0.58289722,-0.58289722,1.756061,-0.58289722,-0.58289722,-0.58289722,1.7576998,-0.58289722,-0.58289722,-0.58289722,1.757268,-0.58289722,-0.58289722,-0.58289722,1.7561984,-0.58289722,-0.58289722,-0.58289722,1.756061,-0.58289722,-0.58289722,-0.58289722,1.7550698,-0.58289722,-0.58289722,-0.58289722,1.7544025,-0.58289722,-0.58289722,-0.58289722,1.7509384,-0.58289722,-0.58289722,-0.58289722,1.7504183,-0.58289722,-0.58289722,-0.58289722,1.7549128,-0.58289722,-0.58289722,-0.58289722,1.7566694,-0.58289722,-0.58289722,-0.58289722,1.7558255,-0.58289722,-0.58289722,-0.58289722,1.7563554,-0.58289722,-0.58289722,-0.58289722,1.7570129,-0.58289722,-0.58289722,-0.58289722,1.7568363,-0.58289722,-0.58289722,-0.58289722,1.7561002,-0.58289722,-0.58289722,-0.58289722,1.7554329,-0.58289722,-0.58289722,-0.58289722,1.7575232,-0.58289722,-0.58289722,-0.58289722,1.7574447,-0.58289722,-0.58289722,-0.58289722,1.7563456,-0.58289722,-0.58289722,-0.58289722,1.7503496,-0.58289722,-0.58289722,-0.58289722,1.7562474,-0.58289722,-0.58289722,-0.58289722,1.7563456,-0.58289722,-0.58289722,-0.58289722,1.7538235,-0.58289722,-0.58289722,-0.58289722,1.7555409,-0.58289722,-0.58289722,-0.58289722,1.7542063,-0.58289722,-0.58289722,-0.58289722,1.7511347,-0.58289722,-0.58289722,-0.58289722,1.7512623,-0.58289722,-0.58289722,-0.58289722,1.7508501,-0.58289722,-0.58289722,-0.58289722,1.7496529,-0.58289722,-0.58289722,-0.58289722,1.7499571,-0.58289722,-0.58289722,-0.58289722,1.7510562,-0.58289722,-0.58289722,-0.58289722,1.75506,-0.58289722,-0.58289722,-0.58289722,1.7528226,-0.58289722,-0.58289722,-0.58289722,1.7464243,-0.58289722,-0.58289722,-0.58289722,1.7464243,-0.58289722,-0.58289722,-0.58289722,1.7513113,-0.58289722,-0.58289722,-0.58289722,1.7505949,-0.58289722,-0.58289722,-0.58289722,1.7510071,-0.58289722,-0.58289722,-0.58289722,1.7511151,-0.58289722,-0.58289722,-0.58289722,1.7506342,-0.58289722,-0.58289722,-0.58289722,1.7528324,-0.58289722,-0.58289722,-0.58289722,1.7219105,-0.58289722,-0.58289722,-0.58289722,1.7204875,-0.58289722,-0.58289722,-0.58289722,1.7213609,-0.58289722,-0.58289722,-0.58289722,1.7250311,-0.58289722,-0.58289722,-0.58289722,1.7253353,-0.58289722,-0.58289722,-0.58289722,1.7270527,-0.58289722,-0.58289722,-0.58289722,1.7262283,-0.58289722,-0.58289722,-0.58289722,1.7288387,-0.58289722,-0.58289722,-0.58289722,1.731822,-0.58289722,-0.58289722,-0.58289722,1.7277298,-0.58289722,-0.58289722,-0.58289722,1.7282205,-0.58289722,-0.58289722,-0.58289722,1.7236278,-0.58289722,-0.58289722,-0.58289722,1.7190842,-0.58289722,-0.58289722,-0.58289722,1.7182991,-0.58289722,-0.58289722,-0.58289722,1.7190646,-0.58289722,-0.58289722,-0.58289722,1.718309,-0.58289722,-0.58289722,-0.58289722,1.7185347,-0.58289722,-0.58289722,-0.58289722,1.7194669,-0.58289722,-0.58289722,-0.58289722,1.7195945,-0.58289722,-0.58289722,-0.58289722,1.7188781,-0.58289722,-0.58289722,-0.58289722,1.7196436,-0.58289722,-0.58289722,-0.58289722,1.7203011,-0.58289722,-0.58289722,-0.58289722,1.7212235,-0.58289722,-0.58289722,-0.58289722,1.72614,-0.58289722,-0.58289722,-0.58289722,1.7270723,-0.58289722,-0.58289722,-0.58289722,1.7310958,-0.58289722,-0.58289722,-0.58289722,1.7302911,-0.58289722,-0.58289722,-0.58289722,1.7285443,-0.58289722,-0.58289722,-0.58289722,1.7276218,-0.58289722,-0.58289722,-0.58289722,1.7233138,-0.58289722,-0.58289722,-0.58289722,1.725247,-0.58289722,-0.58289722,-0.58289722,1.7267779,-0.58289722,-0.58289722,-0.58289722,1.7259928,-0.58289722,-0.58289722,-0.58289722,1.7290055,-0.58289722,-0.58289722,-0.58289722,1.7290742,-0.58289722,-0.58289722,-0.58289722,1.7304775,-0.58289722,-0.58289722,-0.58289722,1.7309093,-0.58289722,-0.58289722,-0.58289722,1.7290939,-0.58289722,-0.58289722,-0.58289722,1.7324598,-0.58289722,-0.58289722,-0.58289722,1.7324893,-0.58289722,-0.58289722,-0.58289722,1.7341772,-0.58289722,-0.58289722,-0.58289722,1.7350408,-0.58289722,-0.58289722,-0.58289722,1.7344421,-0.58289722,-0.58593937,-0.5524267,1.7324206,-0.58268133,-0.58593937,-0.5524267,1.730929,-0.58268133,-0.58593937,-0.5524267,1.7302715,-0.58267151,-0.58695996,-0.55140611,1.7276709,-0.58267151,-0.58695996,-0.55140611,1.726984,-0.58267151,-0.58695996,-0.55140611,1.7276709,-0.58267151,-0.58593937,-0.5524267,1.7298985,-0.58267151,-0.58695996,-0.55140611,1.7282303,-0.58267151,-0.58593937,-0.55445807,1.7311547,-0.58270095,-0.58593937,-0.55445807,1.7288093,-0.58269114,-0.58593937,-0.55445807,1.7278377,-0.58270095,-0.58593937,-0.55445807,1.7277004,-0.58270095,-0.58593937,-0.55343748,1.7277494,-0.58270095,-0.58593937,-0.55445807,1.7289565,-0.58270095,-0.58593937,-0.55445807,1.7286915,-0.58270095,-0.58593937,-0.55445807,1.7267779,-0.58269114,-0.58593937,-0.55445807,1.721724,-0.58270095,-0.58593937,-0.55445807,1.7205955,-0.58269114,-0.58593937,-0.55445807,1.7212432,-0.58270095,-0.58593937,-0.55445807,1.7198006,-0.58270095,-0.58593937,-0.55445807,1.7179949,-0.58269114,-0.58593937,-0.55445807,1.7174944,-0.58269114,-0.58593937,-0.55445807,1.7176809,-0.58269114,-0.58593937,-0.55445807,1.717887,-0.58269114,-0.58593937,-0.55445807,1.7172687,-0.58270095,-0.58593937,-0.55445807,1.716994,-0.58269114,-0.58593937,-0.55445807,1.7185641,-0.58270095,-0.58593937,-0.55445807,1.7200754,-0.58270095,-0.58593937,-0.55343748,1.7237946,-0.58269114,-0.58593937,-0.55445807,1.7261597,-0.58269114,-0.58593937,-0.55445807,1.7244031,-0.58269114,-0.58593937,-0.55445807,1.7238437,-0.58270095,-0.58593937,-0.55445807,1.7285934,-0.58270095,-0.58593937,-0.55445807,1.7267681,-0.58269114,-0.58593937,-0.55445807,1.7244325,-0.58270095,-0.58593937,-0.55343748,1.7289368,-0.58269114,-0.58593937,-0.55445807,1.7298789,-0.58270095,-0.58593937,-0.55445807,1.7290939,-0.58270095,-0.58593937,-0.55445807,1.7226955,-0.58269114,-0.58593937,-0.55445807,1.7255512,-0.58269114,-0.58593937,-0.55445807,1.7287798,-0.58269114,-0.58593937,-0.55445807,1.7285639,-0.58269114,-0.58593937,-0.55445807,1.7273274,-0.58270095,-0.58593937,-0.55445807,1.7269251,-0.58270095,-0.58593937,-0.55445807,1.7284854,-0.58269114,-0.58593937,-0.55445807,1.729084,-0.58269114,-0.58593937,-0.55445807,1.7269545,-0.58270095,-0.58593937,-0.55445807,1.729349,-0.58270095,-0.58593937,-0.55445807,1.7310271,-0.58269114,-0.58593937,-0.55445807,1.7256297,-0.58269114,-0.58593937,-0.55445807,1.7292116,-0.58269114,-0.58593937,-0.55343748,1.7278868,-0.58269114,-0.58593937,-0.55445807,1.7278868,-0.58270095,-0.58593937,-0.55343748,1.7255807,-0.58269114,-0.58593937,-0.55445807,1.7268564,-0.58270095,-0.58593937,-0.55445807,1.727033,-0.58270095,-0.58593937,-0.55445807,1.72877,-0.58270095,-0.58593937,-0.55445807,1.7277789,-0.58269114,-0.58593937,-0.55445807,1.7269251,-0.58270095,-0.58593937,-0.55343748,1.7295158,-0.58269114,-0.58593937,-0.55445807,1.7280831,-0.58270095,-0.58593937,-0.55445807,1.7284854,-0.58269114,-0.58593937,-0.55445807,1.7287896,-0.58269114,-0.58593937,-0.55445807,1.7274845,-0.58269114,-0.58593937,-0.55445807,1.7278868,-0.58269114,-0.58593937,-0.55343748,1.7303009,-0.58269114,-0.58593937,-0.55445807,1.7283873,-0.58269114,-0.58593937,-0.55445807,1.7315079,-0.58270095,-0.58593937,-0.55445807,1.7326855,-0.58269114,-0.58593937,-0.55445807,1.7349426,-0.58270095,-0.58593937,-0.55445807,1.7371212,-0.58270095,-0.58593937,-0.55445807,1.736395,-0.58270095,-0.58593937,-0.55445807,1.7350408,-0.58270095,-0.58593937,-0.55445807,1.7353057,-0.58270095,-0.58593937,-0.55343748,1.7320673,-0.58269114,-0.58593937,-0.55445807,1.7319201,-0.58270095,-0.58593937,-0.55445807,1.7317238,-0.58269114,-0.58593937,-0.55445807,1.7325678,-0.58269114,-0.58593937,-0.55445807,1.7284952,-0.58269114,-0.58593937,-0.55343748,1.7293392,-0.58270095,-0.58593937,-0.55445807,1.7272489,-0.58270095,-0.58593937,-0.55445807,1.726876,-0.58270095,-0.58593937,-0.55343748,1.7273863,-0.58269114,-0.58593937,-0.55445807,1.7271999,-0.58270095,-0.58593937,-0.55343748,1.7241774,-0.58269114,-0.58593937,-0.55343748,1.725355,-0.58269114,-0.58593937,-0.55445807,1.7270036,-0.58269114,-0.58593937,-0.55343748,1.7268073,-0.58269114,-0.58593937,-0.55445807,1.7282303,-0.58269114,-0.58593937,-0.55445807,1.7290252,-0.58269114,-0.58593937,-0.55445807,1.7283382,-0.58269114,-0.58593937,-0.55445807,1.7282008,-0.58269114,-0.58593937,-0.55445807,1.7285934,-0.58270095,-0.58593937,-0.55445807,1.7271802,-0.58270095,-0.58593937,-0.55445807,1.7235493,-0.58269114,-0.58593937,-0.55445807,1.7219006,-0.58269114,-0.58593937,-0.55445807,1.7208506,-0.58269114,-0.58593937,-0.55445807,1.7193001,-0.58269114,-0.58593937,-0.55445807,1.7195454,-0.58269114,-0.58593937,-0.55343748,1.7172786,-0.58269114,-0.58593937,-0.55445807,1.7151687,-0.58269114,-0.58593937,-0.55445807,1.7132747,-0.58269114,-0.58593937,-0.55445807,1.7142658,-0.58269114,-0.58593937,-0.55445807,1.714992,-0.58270095,-0.58593937,-0.55445807,1.7161598,-0.58269114,-0.58593937,-0.55445807,1.717779,-0.58269114,-0.58593937,-0.55445807,1.7157379,-0.58269114,-0.58593937,-0.55445807,1.7182403,-0.58269114,-0.58593937,-0.55445807,1.7181716,-0.58269114,-0.58593937,-0.55445807,1.7186819,-0.58269114,-0.58593937,-0.55445807,1.7178477,-0.58269114,-0.58593937,-0.55343748,1.7176711,-0.58268133,-0.58593937,-0.55445807,1.7163855,-0.58269114,-0.58593937,-0.55343748,1.7090844,-0.58268133,-0.58593937,-0.55445807,1.7116555,-0.58269114,-0.58593937,-0.55343748,1.7142658,-0.58269114,-0.58593937,-0.55445807,1.7118125,-0.58269114,-0.58593937,-0.55343748,1.7113905,-0.58269114,-0.58593937,-0.55343748,1.7110078,-0.58268133,-0.58593937,-0.55343748,1.7104583,-0.58269114,-0.58593937,-0.55343748,1.7113611,-0.58269114,-0.58593937,-0.55343748,1.7090549,-0.58269114,-0.58593937,-0.55343748,1.710733,-0.58269114,-0.58593937,-0.55343748,1.7097223,-0.58269114,-0.58593937,-0.55343748,1.7113022,-0.58268133,-0.58593937,-0.55343748,1.7140107,-0.58268133,-0.58593937,-0.55343748,1.714256,-0.58269114,-0.58593937,-0.55343748,1.7145602,-0.58268133,-0.58593937,-0.55343748,1.715836,-0.58269114,-0.58593937,-0.55343748,1.7158654,-0.58269114,-0.58593937,-0.55343748,1.7105073,-0.58268133,-0.58593937,-0.55343748,1.7114298,-0.58269114,-0.58593937,-0.55343748,1.7127448,-0.58269114,-0.58593937,-0.55343748,1.7134808,-0.58269114,-0.58593937,-0.55343748,1.7176613,-0.58269114,-0.58593937,-0.55343748,1.7156201,-0.58269114,-0.58593937,-0.55343748,1.7183188,-0.58269114,-0.58593937,-0.55343748,1.718044,-0.58269114,-0.58593937,-0.55343748,1.715728,-0.58269114,-0.58593937,-0.55343748,1.7173767,-0.58269114,-0.58593937,-0.55343748,1.7166407,-0.58268133,-0.58593937,-0.55343748,1.7175043,-0.58269114,-0.58593937,-0.55343748,1.7155416,-0.58269114,-0.58593937,-0.55343748,1.7139224,-0.58269114,-0.58593937,-0.55343748,1.7151785,-0.58269114,-0.58593937,-0.55343748,1.7144916,-0.58268133,-0.58593937,-0.55343748,1.7120677,-0.58269114,-0.58593937,-0.55343748,1.7096732,-0.58269114,-0.58593937,-0.55343748,1.7140107,-0.58269114,-0.58593937,-0.55343748,1.7131471,-0.58269114,-0.58593937,-0.55343748,1.7118714,-0.58269114,-0.58593937,-0.55343748,1.713628,-0.58269114,-0.58593937,-0.55343748,1.7122149,-0.58269114,-0.58593937,-0.55343748,1.7114788,-0.58269114,-0.58593937,-0.55343748,1.7123326,-0.58268133,-0.58593937,-0.55343748,1.7143738,-0.58268133,-0.58593937,-0.55343748,1.7110569,-0.58269114,-0.58593937,-0.55343748,1.708368,-0.58268133,-0.58593937,-0.55343748,1.7129705,-0.58268133,-0.58593937,-0.55343748,1.7074063,-0.58268133,-0.58593937,-0.55343748,1.7112335,-0.58268133,-0.58593937,-0.55343748,1.7127644,-0.58269114,-0.58593937,-0.55343748,1.7118714,-0.58268133,-0.58593937,-0.55343748,1.7156986,-0.58268133,-0.58593937,-0.55343748,1.7145995,-0.58269114,-0.58593937,-0.55343748,1.718044,-0.58269114,-0.58593937,-0.55343748,1.7209095,-0.58268133,-0.58593937,-0.55343748,1.721302,-0.58268133,-0.58593937,-0.55343748,1.7213511,-0.58268133,-0.58593937,-0.55343748,1.7211254,-0.58268133,-0.58593937,-0.55343748,1.7217338,-0.58268133,-0.58593937,-0.55343748,1.7223324,-0.58268133,-0.58593937,-0.55343748,1.7228624,-0.58268133,-0.58593937,-0.55343748,1.7222147,-0.58268133,-0.58593937,-0.55343748,1.7226759,-0.58269114,-0.58593937,-0.55343748,1.7217534,-0.58268133,-0.58593937,-0.55343748,1.721881,-0.58269114,-0.58593937,-0.55343748,1.7215179,-0.58268133,-0.58593937,-0.55343748,1.7229801,-0.58269114,-0.58593937,-0.55343748,1.7248741,-0.58268133,-0.58593937,-0.55343748,1.7250017,-0.58268133,-0.58593937,-0.55343748,1.7235002,-0.58268133,-0.58593937,-0.55343748,1.72246,-0.58268133,-0.58593937,-0.55343748,1.7229605,-0.58268133,-0.58593937,-0.55343748,1.7213118,-0.58268133,-0.58593937,-0.55343748,1.7224109,-0.58268133,-0.58593937,-0.55343748,1.7211352,-0.58268133,-0.58593937,-0.55343748,1.7218123,-0.58268133,-0.58593937,-0.55343748,1.7219988,-0.58269114,-0.58593937,-0.55343748,1.7216161,-0.58268133,-0.58593937,-0.55343748,1.724619,-0.58269114,-0.58593937,-0.55343748,1.7244423,-0.58268133,-0.58593937,-0.55343748,1.7242264,-0.58268133,-0.58593937,-0.55343748,1.7220086,-0.58268133,-0.58593937,-0.55343748,1.7220086,-0.58268133,-0.58593937,-0.55343748,1.7229997,-0.58268133,-0.58593937,-0.55343748,1.7230881,-0.58268133,-0.58593937,-0.55343748,1.7236671,-0.58268133,-0.58593937,-0.55343748,1.7236965,-0.58268133,-0.58593937,-0.55343748,1.72404,-0.58268133,-0.58593937,-0.55343748,1.72404,-0.58268133,-0.58593937,-0.55343748,1.72404,-0.58268133,-0.58593937,-0.55343748,1.72404,-0.58268133,-0.58593937,-0.55343748,1.72404,-0.58268133,-0.58593937,-0.55343748,1.72404,-0.58268133,-0.58593937,-0.55343748,1.72404,-0.58268133,-0.58593937,-0.55343748,1.72404,-0.58268133:9
-0.59095054,-0.5374745,1.7439328,-0.59073316,-0.59197817,-0.52719825,1.7153865,-0.59068376,-0.59197817,-0.52719825,1.7160881,-0.59068376,-0.59197817,-0.52719825,1.7162264,-0.59068376,-0.59197817,-0.52822588,1.7171947,-0.59068376,-0.59197817,-0.52822588,1.7167896,-0.59068376,-0.59095054,-0.55187114,1.7178172,-0.59079245,-0.59197817,-0.52719825,1.7196946,-0.59068376,-0.59095054,-0.5292535,1.7183014,-0.59069364,-0.59197817,-0.5292535,1.7172935,-0.59069364,-0.59095054,-0.5292535,1.7171849,-0.59069364,-0.59197817,-0.5292535,1.7163845,-0.59069364,-0.59095054,-0.53028113,1.7172145,-0.59069364,-0.59095054,-0.5292535,1.7465512,-0.59069364,-0.59095054,-0.5292535,1.7450592,-0.59069364,-0.59095054,-0.5292535,1.7430138,-0.59069364,-0.59095054,-0.5292535,1.7419071,-0.59069364,-0.59095054,-0.5292535,1.742668,-0.59069364,-0.59095054,-0.52822588,1.7415415,-0.59069364,-0.59095054,-0.5292535,1.7403262,-0.59069364,-0.59095054,-0.5292535,1.7413835,-0.59069364,-0.59095054,-0.5292535,1.7425,-0.59069364,-0.59095054,-0.5292535,1.7415218,-0.59069364,-0.59095054,-0.5292535,1.7424407,-0.59069364,-0.59095054,-0.5292535,1.7418182,-0.59069364,-0.59095054,-0.5292535,1.7409289,-0.59069364,-0.59095054,-0.53028113,1.7418676,-0.59069364,-0.59095054,-0.5292535,1.740919,-0.59069364,-0.59095054,-0.5292535,1.7408202,-0.59069364,-0.59095054,-0.5292535,1.7416008,-0.59069364,-0.59095054,-0.5292535,1.7428557,-0.59069364,-0.59095054,-0.5292535,1.7427668,-0.59069364,-0.59095054,-0.5292535,1.7408993,-0.59069364,-0.59095054,-0.5292535,1.7419664,-0.59069364,-0.59095054,-0.5292535,1.7421443,-0.59069364,-0.59095054,-0.53028113,1.7417886,-0.59069364,-0.59095054,-0.53028113,1.7427569,-0.59069364,-0.59095054,-0.53028113,1.7439723,-0.59069364,-0.59095054,-0.53130875,1.7429842,-0.59070352,-0.59095054,-0.53028113,1.7426186,-0.59069364,-0.59095054,-0.53028113,1.7417787,-0.59069364,-0.59095054,-0.53028113,1.7374409,-0.59069364,-0.59095054,-0.53130875,1.732451,-0.59070352,-0.59095054,-0.53130875,1.7332909,-0.59070352,-0.59095054,-0.53028113,1.7321743,-0.59069364,-0.59095054,-0.53130875,1.7317099,-0.59070352,-0.59095054,-0.53028113,1.7327771,-0.59069364,-0.59095054,-0.53028113,1.7312752,-0.59069364,-0.59095054,-0.53028113,1.7316803,-0.59069364,-0.59095054,-0.5374745,1.7327376,-0.59072328,-0.59095054,-0.53028113,1.7336565,-0.59069364,-0.59095054,-0.53028113,1.7322238,-0.59069364,-0.59095054,-0.53028113,1.7321743,-0.59069364,-0.59095054,-0.53028113,1.7320459,-0.59069364,-0.59095054,-0.53130875,1.7318878,-0.59070352,-0.58992292,-0.54262251,1.7331723,-0.59075292,-0.59095054,-0.53130875,1.732372,-0.59070352,-0.59095054,-0.5292535,1.7309787,-0.59069364,-0.59095054,-0.53028113,1.730623,-0.59069364,-0.59095054,-0.53130875,1.7318186,-0.59070352,-0.59095054,-0.53028113,1.7297733,-0.59069364,-0.59095054,-0.533364,1.729378,-0.5907134,-0.59095054,-0.53028113,1.7300302,-0.59069364,-0.59095054,-0.53028113,1.7304254,-0.59069364,-0.59095054,-0.53130875,1.7303859,-0.59070352,-0.59095054,-0.53028113,1.7318285,-0.59069364,-0.59095054,-0.53028113,1.7301389,-0.59069364,-0.59095054,-0.53028113,1.7312949,-0.59069364,-0.59095054,-0.53028113,1.7301784,-0.59069364,-0.59095054,-0.53028113,1.7298622,-0.59069364,-0.59095054,-0.53130875,1.7299412,-0.59070352,-0.59095054,-0.53130875,1.728884,-0.59070352,-0.59095054,-0.53130875,1.7296843,-0.59070352,-0.59095054,-0.53130875,1.7290223,-0.59070352,-0.59095054,-0.53130875,1.7291606,-0.59070352,-0.59095054,-0.53130875,1.731374,-0.59070352,-0.59095054,-0.53028113,1.7309985,-0.59069364,-0.59095054,-0.53028113,1.7334095,-0.59069364,-0.59095054,-0.53028113,1.7323522,-0.59069364,-0.59095054,-0.53028113,1.7301092,-0.59069364,-0.59095054,-0.53028113,1.7314728,-0.59069364,-0.59095054,-0.53028113,1.7312949,-0.59069364,-0.59095054,-0.53130875,1.7322238,-0.59070352,-0.59095054,-0.53130875,1.732698,-0.59070352,-0.59095054,-0.53130875,1.7327771,-0.59070352,-0.59095054,-0.53130875,1.7331822,-0.59070352,-0.59095054,-0.53028113,1.7314728,-0.59069364,-0.59095054,-0.53130875,1.7331427,-0.59070352,-0.59095054,-0.53130875,1.7329451,-0.59070352,-0.59095054,-0.53028113,1.7321447,-0.59069364,-0.59095054,-0.53130875,1.732698,-0.59070352,-0.59095054,-0.53028113,1.732698,-0.59069364,-0.59095054,-0.53028113,1.7320755,-0.59069364,-0.59095054,-0.53130875,1.732372,-0.59070352,-0.59095054,-0.53130875,1.7318582,-0.59070352,-0.59095054,-0.53130875,1.7313443,-0.59070352,-0.59095054,-0.5374745,1.7315321,-0.59072328,-0.59095054,-0.53233638,1.7317396,-0.59070352,-0.59095054,-0.53541925,1.7330735,-0.59072328,-0.59095054,-0.53233638,1.7332613,-0.59070352,-0.59095054,-0.53130875,1.7319965,-0.59070352,-0.59095054,-0.53130875,1.7319965,-0.59070352,-0.59095054,-0.53130875,1.7321249,-0.59070352,-0.59095054,-0.53233638,1.7312357,-0.59070352,-0.59095054,-0.53130875,1.7317495,-0.59070352,-0.59095054,-0.53850213,1.732787,-0.59073316,-0.58992292,-0.54159489,1.7328067,-0.59074304,-0.59095054,-0.5374745,1.7336763,-0.59072328,-0.59095054,-0.53850213,1.7332613,-0.59073316,-0.59095054,-0.5374745,1.7336071,-0.59072328,-0.59095054,-0.5374745,1.7341506,-0.59072328,-0.59095054,-0.53541925,1.7336763,-0.59072328,-0.59095054,-0.53644688,1.7335083,-0.59072328,-0.59095054,-0.53644688,1.7311764,-0.59072328,-0.59095054,-0.5374745,1.728963,-0.59072328,-0.59095054,-0.53850213,1.730959,-0.59073316,-0.59095054,-0.53850213,1.7295756,-0.59073316,-0.59095054,-0.5374745,1.7294077,-0.59072328,-0.59095054,-0.53644688,1.7322534,-0.59072328,-0.59095054,-0.53439163,1.7332909,-0.5907134,-0.59095054,-0.5374745,1.7327277,-0.59072328,-0.59095054,-0.53850213,1.7317791,-0.59073316,-0.59095054,-0.53850213,1.7308701,-0.59073316,-0.58992292,-0.54878826,1.7314926,-0.59077269,-0.59095054,-0.53953964,1.730297,-0.59073316,-0.59095054,-0.53953964,1.7309886,-0.59073316,-0.59095054,-0.5374745,1.7326882,-0.59072328,-0.59095054,-0.53850213,1.7327771,-0.59073316,-0.59095054,-0.53850213,1.7340715,-0.59073316,-0.58992292,-0.53953964,1.7332613,-0.59073316,-0.59095054,-0.53850213,1.7337751,-0.59073316,-0.58992292,-0.53953964,1.733034,-0.59073316,-0.59095054,-0.53953964,1.7346248,-0.59073316,-0.59095054,-0.5374745,1.733528,-0.59072328,-0.59095054,-0.5374745,1.7338146,-0.59072328,-0.59095054,-0.5374745,1.732372,-0.59072328,-0.59095054,-0.5374745,1.7341308,-0.59072328,-0.59095054,-0.5374745,1.7321151,-0.59072328,-0.59095054,-0.53953964,1.7324016,-0.59073316,-0.59095054,-0.5374745,1.7334885,-0.59072328,-0.59095054,-0.53953964,1.7347632,-0.59073316,-0.59095054,-0.54056726,1.7334292,-0.59074304,-0.58992292,-0.54056726,1.7343383,-0.59074304,-0.59095054,-0.53233638,1.7346742,-0.59070352,-0.58992292,-0.54056726,1.7344173,-0.59074304,-0.58992292,-0.54365014,1.7332119,-0.59075292,-0.58992292,-0.54467776,1.7351683,-0.59076281,-0.58992292,-0.54570539,1.7364331,-0.59076281,-0.58992292,-0.54570539,1.734447,-0.59076281,-0.58992292,-0.54570539,1.7350398,-0.59076281,-0.58992292,-0.54570539,1.7343679,-0.59076281,-0.58992292,-0.54673301,1.7334391,-0.59076281,-0.58992292,-0.54673301,1.735277,-0.59076281,-0.58992292,-0.54673301,1.7366801,-0.59076281,-0.58992292,-0.57655391,1.737352,-0.59089126,-0.58992292,-0.54673301,1.7357216,-0.59076281,-0.58889529,-0.54673301,1.7363935,-0.59076281,-0.58992292,-0.54776064,1.736107,-0.59077269,-0.58992292,-0.54776064,1.7365912,-0.59076281,-0.58992292,-0.54365014,1.7371741,-0.59075292,-0.58889529,-0.54467776,1.7377176,-0.59078257,-0.58992292,-0.54570539,1.7400298,-0.59076281,-0.58992292,-0.54570539,1.741176,-0.59076281,-0.58889529,-0.54981589,1.7384883,-0.59078257,-0.58889529,-0.54981589,1.7386761,-0.59078257,-0.58889529,-0.55084351,1.73835,-0.59078257,-0.58889529,-0.55084351,1.7393381,-0.59078257,-0.58889529,-0.55084351,1.7383203,-0.59078257,-0.58889529,-0.55084351,1.7374903,-0.59078257,-0.58889529,-0.55084351,1.734111,-0.59078257,-0.58889529,-0.55084351,1.7350596,-0.59078257,-0.58889529,-0.55187114,1.7328957,-0.59079245,-0.58889529,-0.54981589,1.7339925,-0.59078257,-0.58889529,-0.55187114,1.7339826,-0.59079245,-0.58889529,-0.54981589,1.7323522,-0.59078257,-0.58889529,-0.55290865,1.7336071,-0.59079245,-0.58889529,-0.55290865,1.7341703,-0.59079245,-0.58889529,-0.55290865,1.7352671,-0.59079245,-0.58889529,-0.55290865,1.7355833,-0.59079245,-0.58889529,-0.55290865,1.7352869,-0.59079245,-0.58889529,-0.55290865,1.7345952,-0.59079245,-0.58889529,-0.55290865,1.7365022,-0.59079245,-0.58889529,-0.55393627,1.7350892,-0.59080233,-0.58889529,-0.55393627,1.7354944,-0.59080233,-0.58889529,-0.5549639,1.7340616,-0.59080233,-0.58889529,-0.5549639,1.7342098,-0.59080233,-0.58992292,-0.57449866,1.7359687,-0.59088138,-0.58889529,-0.5549639,1.7385476,-0.59080233,-0.58889529,-0.5549639,1.7376978,-0.59080233,-0.58889529,-0.5549639,1.7375101,-0.59080233,-0.58889529,-0.5549639,1.7364232,-0.59080233,-0.58889529,-0.5549639,1.7353462,-0.59080233,-0.58889529,-0.5549639,1.7361959,-0.59080233,-0.58889529,-0.5549639,1.7373026,-0.59080233,-0.58889529,-0.55599152,1.736937,-0.59080233,-0.58889529,-0.55599152,1.7383302,-0.59080233,-0.58889529,-0.55599152,1.7365714,-0.59081221,-0.58889529,-0.55701915,1.7367097,-0.59081221,-0.58889529,-0.55701915,1.736937,-0.59081221,-0.58889529,-0.55701915,1.7367394,-0.59081221,-0.58889529,-0.55701915,1.7372038,-0.59081221,-0.58889529,-0.55701915,1.7369469,-0.59081221,-0.58889529,-0.55804677,1.7354548,-0.59081221,-0.58889529,-0.55701915,1.7378559,-0.59081221,-0.58889529,-0.55804677,1.7382808,-0.59081221,-0.58889529,-0.55804677,1.7387847,-0.59081221,-0.58889529,-0.55804677,1.7389428,-0.59081221,-0.58889529,-0.5590744,1.7399507,-0.59082209,-0.58889529,-0.5590744,1.7354153,-0.59082209,-0.58889529,-0.5590744,1.7418577,-0.59082209,-0.58889529,-0.5590744,1.7407906,-0.59082209,-0.58889529,-0.56730528,1.7412945,-0.59085173,-0.58889529,-0.5590744,1.7398717,-0.59082209,-0.58889529,-0.56010202,1.7414921,-0.59082209,-0.58889529,-0.5590744,1.7395357,-0.59082209,-0.58786767,-0.56010202,1.7388144,-0.59082209,-0.58786767,-0.56010202,1.7380437,-0.59082209,-0.58889529,-0.5631849,1.7370654,-0.59084185,-0.58889529,-0.56010202,1.7346446,-0.59082209,-0.58786767,-0.56010202,1.7286369,-0.59082209,-0.58786767,-0.56112965,1.7239632,-0.59083197,-0.58889529,-0.55599152,1.7214238,-0.59080233,-0.58889529,-0.55599152,1.7177481,-0.59080233,-0.58889529,-0.55804677,1.715515,-0.59081221,-0.58889529,-0.55804677,1.713934,-0.59081221,-0.58889529,-0.55804677,1.7131238,-0.59081221,-0.58889529,-0.5590744,1.715841,-0.59082209,-0.58889529,-0.56215727,1.7159102,-0.59083197,-0.58889529,-0.55290865,1.7227083,-0.59079245,-0.58889529,-0.56215727,1.7287753,-0.59083197,-0.58889529,-0.56215727,1.7262655,-0.59083197,-0.58889529,-0.56215727,1.7245067,-0.59083197,-0.59095054,-0.53953964,1.7276884,-0.59073316,-0.58889529,-0.56010202,1.7290421,-0.59082209,-0.58889529,-0.56010202,1.7286567,-0.59082209,-0.58889529,-0.56010202,1.7283899,-0.59082209,-0.58786767,-0.56215727,1.7306626,-0.59083197,-0.58889529,-0.5631849,1.7309689,-0.59083197,-0.58889529,-0.56112965,1.730208,-0.59083197,-0.58889529,-0.5631849,1.7295658,-0.59083197,-0.58786767,-0.56421252,1.7302772,-0.59084185,-0.58889529,-0.56421252,1.7295559,-0.59084185,-0.58889529,-0.56421252,1.7290421,-0.59084185,-0.58889529,-0.56421252,1.7287259,-0.59084185,-0.58889529,-0.56421252,1.72921,-0.59084185,-0.58889529,-0.5631849,1.727965,-0.59083197,-0.58889529,-0.56421252,1.727639,-0.59084185,-0.58786767,-0.56421252,1.72755,-0.59084185,-0.58889529,-0.56525003,1.7278069,-0.59084185,-0.58889529,-0.56525003,1.7256825,-0.59084185,-0.58889529,-0.56525003,1.7270263,-0.59084185,-0.58889529,-0.56627766,1.7263742,-0.59085173,-0.58889529,-0.56627766,1.7262556,-0.59085173,-0.58889529,-0.56627766,1.7249316,-0.59085173,-0.58889529,-0.56627766,1.7265323,-0.59085173,-0.58889529,-0.56627766,1.7254256,-0.59085173,-0.58889529,-0.56627766,1.7262655,-0.59085173,-0.58889529,-0.56627766,1.7262951,-0.59085173,-0.58889529,-0.56627766,1.7277773,-0.59085173,-0.58889529,-0.56627766,1.7259888,-0.59085173,-0.58889529,-0.56627766,1.7269967,-0.59085173,-0.58889529,-0.56730528,1.7260778,-0.59085173,-0.58889529,-0.56730528,1.7273327,-0.59085173,-0.58889529,-0.56730528,1.7255343,-0.59085173,-0.58786767,-0.56730528,1.7222143,-0.59085173,-0.58786767,-0.56730528,1.7233506,-0.59085173,-0.58889529,-0.56730528,1.7233407,-0.59085173,-0.58889529,-0.56730528,1.7247438,-0.59085173,-0.58889529,-0.56730528,1.7251391,-0.59085173,-0.58889529,-0.56730528,1.7250798,-0.59085173,-0.58889529,-0.56833291,1.724477,-0.59086162,-0.58889529,-0.56833291,1.7245561,-0.59086162,-0.58889529,-0.56833291,1.7235779,-0.59086162,-0.58889529,-0.56833291,1.722402,-0.59086162,-0.58889529,-0.56833291,1.723568,-0.59086162,-0.58889529,-0.56833291,1.7228071,-0.59086162,-0.58889529,-0.56833291,1.7225008,-0.59086162,-0.58889529,-0.56936053,1.7226787,-0.59086162,-0.58889529,-0.56936053,1.7237458,-0.59086162,-0.58889529,-0.56936053,1.7250897,-0.59086162,-0.58889529,-0.57038816,1.7246747,-0.5908715,-0.58889529,-0.56936053,1.7259691,-0.59086162,-0.58889529,-0.56936053,1.7248822,-0.59086162,-0.58889529,-0.56936053,1.7241905,-0.59086162,-0.58889529,-0.57038816,1.7268287,-0.5908715,-0.58889529,-0.57038816,1.7267101,-0.5908715,-0.58992292,-0.56627766,1.7259493,-0.59091102,-0.58889529,-0.56627766,1.7259592,-0.59085173,-0.58889529,-0.57038816,1.7275303,-0.5908715,-0.58889529,-0.57038816,1.7285381,-0.5908715,-0.58889529,-0.57038816,1.7267793,-0.5908715,-0.58889529,-0.57038816,1.7275006,-0.5908715,-0.58889529,-0.57038816,1.7262853,-0.5908715,-0.58786767,-0.57038816,1.728469,-0.5908715,-0.58889529,-0.57038816,1.7301685,-0.5908715,-0.58889529,-0.57038816,1.7288642,-0.5908715,-0.58889529,-0.57141578,1.7286468,-0.5908715,-0.58889529,-0.57141578,1.7294373,-0.5908715,-0.58889529,-0.57141578,1.7296843,-0.5908715,-0.58889529,-0.56936053,1.7292298,-0.59086162,-0.58889529,-0.56833291,1.7291409,-0.59086162,-0.58889529,-0.57141578,1.728884,-0.5908715,-0.58889529,-0.57038816,1.7287852,-0.5908715,-0.58889529,-0.57038816,1.7294867,-0.5908715,-0.58889529,-0.57141578,1.7300697,-0.5908715,-0.58992292,-0.57964667,1.7306922,-0.59091102,-0.58889529,-0.56936053,1.7315617,-0.59086162,-0.58889529,-0.57141578,1.7328957,-0.5908715,-0.58889529,-0.57141578,1.7339826,-0.5908715,-0.58889529,-0.57141578,1.7327474,-0.5908715,-0.58889529,-0.57141578,1.7319076,-0.5908715,-0.58786767,-0.56112965,1.7317495,-0.59083197,-0.58889529,-0.56730528,1.7286567,-0.59085173,-0.58889529,-0.56010202,1.7290618,-0.59082209,-0.58889529,-0.55187114,1.7284196,-0.59079245,-0.58889529,-0.56936053,1.7295361,-0.59086162,-0.58889529,-0.56627766,1.7292693,-0.59084185,-0.58889529,-0.57038816,1.7294373,-0.5908715,-0.58786767,-0.56730528,1.7292397,-0.59085173,-0.58889529,-0.57038816,1.7286172,-0.5908715,-0.58889529,-0.57244341,1.7304353,-0.5908715,-0.58889529,-0.57244341,1.7308997,-0.5908715,-0.58889529,-0.57244341,1.7288642,-0.5908715,-0.58889529,-0.57347103,1.730376,-0.59088138,-0.58889529,-0.57244341,1.7300203,-0.5908715,-0.58889529,-0.57347103,1.7294472,-0.59088138,-0.58889529,-0.57347103,1.7280046,-0.59088138,-0.58889529,-0.57347103,1.730297,-0.59088138,-0.58889529,-0.57347103,1.7293484,-0.59088138,-0.58889529,-0.57347103,1.731127,-0.59088138,-0.58889529,-0.57347103,1.7307614,-0.59088138,-0.58889529,-0.57038816,1.7347632,-0.5908715,-0.58889529,-0.56833291,1.7345754,-0.59086162,-0.58889529,-0.57038816,1.7358402,-0.5908715,-0.58889529,-0.57038816,1.7348225,-0.5908715,-0.58786767,-0.56627766,1.7349015,-0.59085173,-0.58889529,-0.57244341,1.7360477,-0.5908715,-0.58889529,-0.57038816,1.734279,-0.5908715,-0.58889529,-0.56936053,1.7313147,-0.59086162,-0.58786767,-0.56833291,1.7339035,-0.59086162,-0.58889529,-0.57141578,1.7335083,-0.5908715,-0.58889529,-0.57141578,1.7328166,-0.5908715,-0.58889529,-0.57141578,1.7325498,-0.5908715,-0.58889529,-0.57347103,1.733617,-0.59088138,-0.58889529,-0.57449866,1.732036,-0.59088138,-0.58889529,-0.57449866,1.7331427,-0.59088138,-0.58889529,-0.57449866,1.733281,-0.59088138,-0.58889529,-0.57449866,1.7336861,-0.59088138,-0.58889529,-0.5631849,1.7329253,-0.59084185,-0.58889529,-0.57449866,1.7333798,-0.59088138,-0.58889529,-0.57552628,1.7331032,-0.59089126,-0.58889529,-0.57552628,1.7313839,-0.59089126,-0.58889529,-0.57552628,1.7315914,-0.59089126,-0.58889529,-0.57552628,1.7322929,-0.59089126,-0.58889529,-0.57552628,1.7322139,-0.59089126,-0.58889529,-0.57552628,1.731868,-0.59089126,-0.58889529,-0.57552628,1.7284294,-0.59089126,-0.58889529,-0.57449866,1.7277674,-0.59088138,-0.58889529,-0.57552628,1.7291508,-0.59089126,-0.58889529,-0.57552628,1.7281231,-0.59089126,-0.58889529,-0.57552628,1.7281231,-0.59089126,-0.58889529,-0.57552628,1.7281231,-0.59089126,-0.58889529,-0.57552628,1.7281231,-0.59089126,-0.58889529,-0.57552628,1.7281231,-0.59089126,-0.58889529,-0.57552628,1.7281231,-0.59089126:9
-0.5768208,-0.56366489,1.7305657,-0.57771024,-0.5768208,-0.56366489,1.7294123,-0.57771024,-0.5768208,-0.56366489,1.7314844,-0.57771024,-0.5768208,-0.56366489,1.7300672,-0.57771024,-0.5758043,-0.56366489,1.7300965,-0.57771024,-0.5768208,-0.56366489,1.7307123,-0.57771024,-0.5768208,-0.56366489,1.7322175,-0.57772002,-0.5768208,-0.56366489,1.7297055,-0.57772002,-0.5768208,-0.56366489,1.7311326,-0.57771024,-0.5768208,-0.56366489,1.7301063,-0.57772002,-0.5768208,-0.56468139,1.7304777,-0.57772002,-0.5768208,-0.56366489,1.729471,-0.57771024,-0.5768208,-0.56366489,1.7316408,-0.57772002,-0.5768208,-0.56670463,1.7311326,-0.57777866,-0.5768208,-0.56670463,1.7295687,-0.57777866,-0.5768208,-0.56670463,1.7283665,-0.57777866,-0.5768208,-0.56670463,1.7311814,-0.57777866,-0.5768208,-0.56670463,1.7318558,-0.57777866,-0.5768208,-0.56670463,1.730722,-0.57777866,-0.5768208,-0.56670463,1.7317679,-0.57777866,-0.5768208,-0.56670463,1.7296567,-0.57777866,-0.5768208,-0.56670463,1.7266854,-0.57777866,-0.5768208,-0.56670463,1.7269102,-0.57778844,-0.5768208,-0.56670463,1.7259718,-0.57777866,-0.5768208,-0.56670463,1.7264703,-0.57777866,-0.5768208,-0.56670463,1.7245937,-0.57778844,-0.5768208,-0.56670463,1.7257959,-0.57778844,-0.5768208,-0.56771136,1.7246035,-0.57778844,-0.5768208,-0.56771136,1.724496,-0.57778844,-0.5768208,-0.56771136,1.7249358,-0.57778844,-0.5768208,-0.56771136,1.7240464,-0.57778844,-0.57782753,-0.57782753,1.7242614,-0.57782753,-0.57782753,-0.57782753,1.7253854,-0.57782753,-0.57782753,-0.57782753,1.721681,-0.57782753,-0.57782753,-0.57782753,1.7226975,-0.57782753,-0.57782753,-0.57782753,1.7235772,-0.57782753,-0.57782753,-0.57782753,1.7242614,-0.57782753,-0.57782753,-0.57782753,1.7230983,-0.57782753,-0.57782753,-0.57782753,1.7272132,-0.57782753,-0.57782753,-0.57782753,1.7281221,-0.57782753,-0.57782753,-0.57782753,1.7263824,-0.57782753,-0.57782753,-0.57782753,1.7272718,-0.57782753,-0.57782753,-0.57782753,1.7254636,-0.57782753,-0.57782753,-0.57782753,1.7277116,-0.57782753,-0.57782753,-0.57782753,1.7314649,-0.57782753,-0.57782753,-0.57782753,1.7310739,-0.57782753,-0.57782753,-0.57782753,1.7318167,-0.57782753,-0.57782753,-0.57782753,1.7314062,-0.57782753,-0.57782753,-0.57782753,1.7293439,-0.57782753,-0.57782753,-0.57782753,1.7278387,-0.57782753,-0.57782753,-0.57782753,1.7259523,-0.57782753,-0.57782753,-0.57782753,1.7291875,-0.57782753,-0.57782753,-0.57782753,1.7262162,-0.57782753,-0.57782753,-0.57782753,1.7268906,-0.57782753,-0.57782753,-0.57782753,1.7272816,-0.57782753,-0.57782753,-0.57782753,1.7292168,-0.57782753,-0.57782753,-0.57782753,1.7295883,-0.57782753,-0.57782753,-0.57782753,1.7285522,-0.57782753,-0.57782753,-0.57782753,1.7298228,-0.57782753,-0.57782753,-0.57782753,1.7295394,-0.57782753,-0.57782753,-0.57782753,1.7299499,-0.57782753,-0.57782753,-0.57782753,1.7286499,-0.57782753,-0.57782753,-0.57782753,1.7281906,-0.57782753,-0.57782753,-0.57782753,1.7229126,-0.57782753,-0.57782753,-0.57782753,1.7226878,-0.57782753,-0.57782753,-0.57782753,1.7219449,-0.57782753,-0.57782753,-0.57782753,1.7205179,-0.57782753,-0.57782753,-0.57782753,1.7182308,-0.57782753,-0.57782753,-0.57782753,1.7208991,-0.57782753,-0.57782753,-0.57782753,1.7213487,-0.57782753,-0.57782753,-0.57782753,1.7204006,-0.57782753,-0.57782753,-0.57782753,1.7207916,-0.57782753,-0.57782753,-0.57782753,1.7204104,-0.57782753,-0.57782753,-0.57782753,1.7208111,-0.57782753,-0.57782753,-0.57782753,1.7213096,-0.57782753,-0.57782753,-0.57782753,1.7190909,-0.57782753,-0.57782753,-0.57782753,1.7259914,-0.57782753,-0.57782753,-0.57782753,1.7256395,-0.57782753,-0.57782753,-0.57782753,1.7253756,-0.57782753,-0.57782753,-0.57782753,1.724017,-0.57782753,-0.57782753,-0.57782753,1.7249553,-0.57782753,-0.57782753,-0.57782753,1.7252192,-0.57782753,-0.57782753,-0.57782753,1.725317,-0.57782753,-0.57782753,-0.57782753,1.7260207,-0.57782753,-0.57782753,-0.57782753,1.726226,-0.57782753,-0.5768208,-0.56164166,1.7272229,-0.57770047,-0.57782753,-0.57782753,1.7274771,-0.57782753,-0.57782753,-0.57782753,1.7273011,-0.57782753,-0.57782753,-0.57782753,1.7286499,-0.57782753,-0.57782753,-0.57782753,1.7299303,-0.57782753,-0.57782753,-0.57782753,1.7309859,-0.57782753,-0.57782753,-0.57782753,1.732628,-0.57782753,-0.57782753,-0.57782753,1.7327551,-0.57782753,-0.57782753,-0.57782753,1.7323543,-0.57782753,-0.57782753,-0.57782753,1.7332438,-0.57782753,-0.57782753,-0.57782753,1.734749,-0.57782753,-0.57782753,-0.57782753,1.7335859,-0.57782753,-0.57782753,-0.57782753,1.7305559,-0.57782753,-0.57782753,-0.57782753,1.7309664,-0.57782753,-0.5768208,-0.56670463,1.730722,-0.57782753,-0.57782753,-0.57782753,1.7326573,-0.57782753,-0.57782753,-0.57782753,1.7317092,-0.57782753,-0.57782753,-0.57782753,1.7327453,-0.57782753,-0.57782753,-0.57782753,1.7316506,-0.57782753,-0.57782753,-0.57782753,1.7323054,-0.57782753,-0.57782753,-0.57782753,1.7318852,-0.57782753,-0.57782753,-0.57782753,1.7305266,-0.57782753,-0.57782753,-0.57782753,1.731328,-0.57782753,-0.57782753,-0.57782753,1.7301747,-0.57782753,-0.57782753,-0.57782753,1.7299108,-0.57782753,-0.57782753,-0.57782753,1.7299792,-0.57782753,-0.57782753,-0.57782753,1.7300672,-0.57782753,-0.57782753,-0.57782753,1.7303604,-0.57782753,-0.57782753,-0.57782753,1.7297055,-0.57782753,-0.57782753,-0.57782753,1.7297251,-0.57782753,-0.57782753,-0.57782753,1.733146,-0.57782753,-0.57782753,-0.57782753,1.730507,-0.57782753,-0.57782753,-0.57782753,1.7330971,-0.57782753,-0.57782753,-0.57782753,1.7330385,-0.57782753,-0.57782753,-0.57782753,1.7325889,-0.57782753,-0.57782753,-0.57782753,1.732843,-0.57782753,-0.57782753,-0.57782753,1.7330678,-0.57782753,-0.57782753,-0.57782753,1.7341039,-0.57782753,-0.57782753,-0.57782753,1.7324912,-0.57782753,-0.57782753,-0.57782753,1.7333513,-0.57782753,-0.57782753,-0.57782753,1.7337031,-0.57782753,-0.57782753,-0.57782753,1.7357557,-0.57782753,-0.57782753,-0.57782753,1.7350617,-0.57782753,-0.57782753,-0.57782753,1.7356677,-0.57782753,-0.57782753,-0.57782753,1.7358925,-0.57782753,-0.57782753,-0.57782753,1.7350715,-0.57782753,-0.57782753,-0.57782753,1.7354918,-0.57782753,-0.57782753,-0.57782753,1.7354332,-0.57782753,-0.57782753,-0.57782753,1.735785,-0.57782753,-0.57782753,-0.57782753,1.7370557,-0.57782753,-0.57782753,-0.57782753,1.738424,-0.57782753,-0.57782753,-0.57782753,1.7389909,-0.57782753,-0.57782753,-0.57782753,1.7384729,-0.57782753,-0.57782753,-0.57782753,1.739724,-0.57782753,-0.57782753,-0.57782753,1.7399976,-0.57782753,-0.57782753,-0.57782753,1.7391082,-0.57782753,-0.57782753,-0.57782753,1.739939,-0.57782753,-0.57782753,-0.57782753,1.7387954,-0.57782753,-0.57782753,-0.57782753,1.7374075,-0.57782753,-0.57782753,-0.57782753,1.7357948,-0.57782753,-0.57782753,-0.57782753,1.7290409,-0.57782753,-0.57782753,-0.57782753,1.7294612,-0.57782753,-0.57782753,-0.57782753,1.7313476,-0.57782753,-0.57782753,-0.57782753,1.7269981,-0.57782753,-0.57782753,-0.57782753,1.7279755,-0.57782753,-0.57782753,-0.57782753,1.7282394,-0.57782753,-0.57782753,-0.57782753,1.7336249,-0.57782753,-0.57782753,-0.57782753,1.7315137,-0.57782753,-0.57782753,-0.57782753,1.7334001,-0.57782753,-0.57782753,-0.57782753,1.7352474,-0.57782753,-0.57782753,-0.57782753,1.7342407,-0.57782753,-0.57782753,-0.57782753,1.734573,-0.57782753,-0.57782753,-0.57782753,1.736,-0.57782753,-0.57782753,-0.57782753,1.7363617,-0.57782753,-0.57782753,-0.57782753,1.7346219,-0.57782753,-0.57782753,-0.57782753,1.7355211,-0.57782753,-0.57782753,-0.57782753,1.7346024,-0.57782753,-0.57782753,-0.57782753,1.7358632,-0.57782753,-0.57782753,-0.57782753,1.7354038,-0.57782753,-0.57782753,-0.57782753,1.7343482,-0.57782753,-0.57782753,-0.57782753,1.7354918,-0.57782753,-0.57782753,-0.57782753,1.7359219,-0.57782753,-0.57782753,-0.57782753,1.7352768,-0.57782753,-0.57782753,-0.57782753,1.7358828,-0.57782753,-0.57782753,-0.57782753,1.7355211,-0.57782753,-0.57782753,-0.57782753,1.7365963,-0.57782753,-0.57782753,-0.57782753,1.7362346,-0.57782753,-0.57782753,-0.57782753,1.7367917,-0.57782753,-0.57782753,-0.57782753,1.7365572,-0.57782753,-0.57782753,-0.57782753,1.7357459,-0.57782753,-0.5768208,-0.56670463,1.735961,-0.57782753,-0.5768208,-0.56568813,1.7334295,-0.57777866,-0.5768208,-0.56568813,1.7341527,-0.57777866,-0.5768208,-0.56568813,1.7346219,-0.57777866,-0.5768208,-0.56568813,1.7329896,-0.57777866,-0.57782753,-0.57782753,1.7342994,-0.57782753,-0.57782753,-0.57782753,1.7376225,-0.57782753,-0.57782753,-0.57782753,1.7359707,-0.57782753,-0.57782753,-0.57782753,1.7375835,-0.57782753,-0.57782753,-0.57782753,1.7359414,-0.57782753,-0.57782753,-0.57782753,1.7346024,-0.57782753,-0.57782753,-0.57782753,1.7361173,-0.57782753,-0.57782753,-0.57782753,1.7370459,-0.57782753,-0.57782753,-0.57782753,1.736782,-0.57782753,-0.57782753,-0.57782753,1.7347196,-0.57782753,-0.57782753,-0.57782753,1.7332047,-0.57782753,-0.57782753,-0.57782753,1.7329408,-0.57782753,-0.57782753,-0.57782753,1.7330581,-0.57782753,-0.57782753,-0.57782753,1.7293146,-0.57782753,-0.57782753,-0.57782753,1.7332438,-0.57782753,-0.57782753,-0.57782753,1.7330971,-0.57782753,-0.57782753,-0.57782753,1.7321295,-0.57782753,-0.57782753,-0.57782753,1.7319927,-0.57782753,-0.57782753,-0.57782753,1.7323054,-0.57782753,-0.57782753,-0.57782753,1.7320611,-0.57782753,-0.57782753,-0.57782753,1.7340355,-0.57782753,-0.57782753,-0.57782753,1.7322761,-0.57782753,-0.57782753,-0.57782753,1.7315137,-0.57782753,-0.57782753,-0.57782753,1.7318656,-0.57782753,-0.57782753,-0.57782753,1.7323543,-0.57782753,-0.57782753,-0.57782753,1.7325791,-0.57782753,-0.57782753,-0.57782753,1.7322761,-0.57782753,-0.57782753,-0.57782753,1.734358,-0.57782753,-0.57782753,-0.57782753,1.7329017,-0.57782753,-0.57782753,-0.57782753,1.7347099,-0.57782753,-0.57782753,-0.57782753,1.7335468,-0.57782753,-0.57782753,-0.57782753,1.7330092,-0.57782753,-0.57782753,-0.57782753,1.7356091,-0.57782753,-0.57782753,-0.57782753,1.7370361,-0.57782753,-0.57782753,-0.57782753,1.7373977,-0.57782753,-0.57782753,-0.57782753,1.7358828,-0.57782753,-0.57782753,-0.57782753,1.736088,-0.57782753,-0.57782753,-0.57782753,1.7365376,-0.57782753,-0.57782753,-0.57782753,1.7364203,-0.57782753,-0.57782753,-0.57782753,1.7348369,-0.57782753,-0.57782753,-0.57782753,1.7347881,-0.57782753,-0.57782753,-0.57782753,1.7361662,-0.57782753,-0.57782753,-0.57782753,1.7349249,-0.57782753,-0.57782753,-0.57782753,1.7354918,-0.57782753,-0.57782753,-0.57782753,1.7327844,-0.57782753,-0.57782753,-0.57782753,1.7341234,-0.57782753,-0.57782753,-0.57782753,1.7329505,-0.57782753,-0.57782753,-0.57782753,1.7314258,-0.57782753,-0.57782753,-0.57782753,1.7351399,-0.57782753,-0.57782753,-0.57782753,1.7340648,-0.57782753,-0.57782753,-0.57782753,1.7347587,-0.57782753,-0.57782753,-0.57782753,1.7310446,-0.57782753,-0.57782753,-0.57782753,1.7321002,-0.57782753,-0.57782753,-0.57782753,1.735785,-0.57782753,-0.57782753,-0.57782753,1.7371436,-0.57782753,-0.57782753,-0.57782753,1.7376323,-0.57782753,-0.57782753,-0.57782753,1.7389811,-0.57782753,-0.57782753,-0.57782753,1.7296176,-0.57782753,-0.57782753,-0.57782753,1.72778,-0.57782753,-0.57782753,-0.57782753,1.7324912,-0.57782753,-0.57782753,-0.57782753,1.7319634,-0.57782753,-0.57782753,-0.57782753,1.7317581,-0.57782753,-0.57782753,-0.57782753,1.73211,-0.57782753,-0.57782753,-0.57782753,1.7316408,-0.57782753,-0.57782753,-0.57782753,1.7314649,-0.57782753,-0.57782753,-0.57782753,1.7331265,-0.57782753,-0.57782753,-0.57782753,1.7321295,-0.57782753,-0.57782753,-0.57782753,1.7335174,-0.57782753,-0.57782753,-0.57782753,1.7330971,-0.57782753,-0.57782753,-0.57782753,1.7322957,-0.57782753,-0.57782753,-0.57782753,1.7330874,-0.57782753,-0.57782753,-0.57782753,1.7331851,-0.57782753,-0.57782753,-0.57782753,1.7345828,-0.57782753,-0.57782753,-0.57782753,1.7349151,-0.57782753,-0.57782753,-0.57782753,1.7337813,-0.57782753,-0.57782753,-0.57782753,1.7339279,-0.57782753,-0.57782753,-0.57782753,1.7328039,-0.57782753,-0.57782753,-0.57782753,1.7338107,-0.57782753,-0.57782753,-0.57782753,1.7354234,-0.57782753,-0.57782753,-0.57782753,1.7373391,-0.57782753,-0.57782753,-0.57782753,1.7358241,-0.57782753,-0.57782753,-0.57782753,1.7347001,-0.57782753,-0.57782753,-0.57782753,1.7315137,-0.57782753,-0.57782753,-0.57782753,1.7352963,-0.57782753,-0.57782753,-0.57782753,1.7332438,-0.57782753,-0.57782753,-0.57782753,1.732843,-0.57782753,-0.57782753,-0.57782753,1.7302627,-0.57782753,-0.57782753,-0.57782753,1.7324912,-0.57782753,-0.57782753,-0.57782753,1.731416,-0.57782753,-0.57782753,-0.57782753,1.730077,-0.57782753,-0.57782753,-0.57782753,1.7310935,-0.57782753,-0.57782753,-0.57782753,1.7318461,-0.57782753,-0.57782753,-0.57782753,1.7315333,-0.57782753,-0.57782753,-0.57782753,1.7314942,-0.57782753,-0.57782753,-0.57782753,1.7368699,-0.57782753,-0.57782753,-0.57782753,1.7346805,-0.57782753,-0.57782753,-0.57782753,1.7346512,-0.57782753,-0.57782753,-0.57782753,1.7344753,-0.57782753,-0.57782753,-0.57782753,1.7376323,-0.57782753,-0.57782753,-0.57782753,1.7368993,-0.57782753,-0.57782753,-0.57782753,1.7337813,-0.57782753,-0.57782753,-0.57782753,1.7301649,-0.57782753,-0.57782753,-0.57782753,1.731631,-0.57782753,-0.57782753,-0.57782753,1.7299694,-0.57782753,-0.57782753,-0.57782753,1.7276921,-0.57782753,-0.57782753,-0.57782753,1.7287379,-0.57782753,-0.57782753,-0.57782753,1.7264605,-0.57782753,-0.57782753,-0.57782753,1.7288845,-0.57782753,-0.57782753,-0.57782753,1.7286988,-0.57782753,-0.57782753,-0.57782753,1.727741,-0.57782753,-0.57782753,-0.57782753,1.7276823,-0.57782753,-0.57782753,-0.57782753,1.7278387,-0.57782753,-0.57782753,-0.57782753,1.7268906,-0.57782753,-0.57782753,-0.57782753,1.7288063,-0.57782753,-0.57782753,-0.57782753,1.7301552,-0.57782753,-0.57782753,-0.57782753,1.7289529,-0.57782753,-0.57782753,-0.57782753,1.7298717,-0.57782753,-0.57782753,-0.57782753,1.7303213,-0.57782753,-0.57782753,-0.57782753,1.7307905,-0.57782753,-0.57782753,-0.57782753,1.7320122,-0.57782753,-0.57782753,-0.57782753,1.7306145,-0.57782753,-0.57782753,-0.57782753,1.73081,-0.57782753,-0.57782753,-0.57782753,1.7320415,-0.57782753,-0.57782753,-0.57782753,1.7323934,-0.57782753,-0.57782753,-0.57782753,1.7284251,-0.57782753,-0.57782753,-0.57782753,1.7271838,-0.57782753,-0.57782753,-0.57782753,1.7284447,-0.57782753,-0.57782753,-0.57782753,1.7243787,-0.57782753,-0.57782753,-0.57782753,1.7261087,-0.57782753,-0.57782753,-0.57782753,1.723587,-0.57782753,-0.57782753,-0.57782753,1.725444,-0.57782753,-0.57782753,-0.57782753,1.7323054,-0.57782753,-0.57782753,-0.57782753,1.7303213,-0.57782753,-0.57782753,-0.57782753,1.7353354,-0.57782753,-0.57782753,-0.57782753,1.7338888,-0.57782753,-0.57782753,-0.57782753,1.7338986,-0.57782753,-0.57782753,-0.57782753,1.7334979,-0.57782753,-0.57782753,-0.57782753,1.7336445,-0.57782753,-0.57782753,-0.57782753,1.7329505,-0.57782753,-0.57782753,-0.57782753,1.732931,-0.57782753,-0.57782753,-0.57782753,1.7352474,-0.57782753,-0.57782753,-0.57782753,1.7358241,-0.57782753,-0.57782753,-0.57782753,1.736303,-0.57782753,-0.57782753,-0.57782753,1.7332438,-0.57782753,-0.57782753,-0.57782753,1.733537,-0.57782753,-0.57782753,-0.57782753,1.7349542,-0.57782753,-0.57782753,-0.57782753,1.7350813,-0.57782753,-0.57782753,-0.57782753,1.7303311,-0.57782753,-0.57782753,-0.57782753,1.7320415,-0.57782753,-0.57782753,-0.57782753,1.7337813,-0.57782753,-0.57782753,-0.57782753,1.7324716,-0.57782753,-0.57782753,-0.57782753,1.7326769,-0.57782753,-0.57782753,-0.57782753,1.7321588,-0.57782753,-0.57782753,-0.57782753,1.7326769,-0.57782753,-0.57782753,-0.57782753,1.7326084,-0.57782753,-0.57782753,-0.57782753,1.7306536,-0.57782753,-0.5768208,-0.56164166,1.7321393,-0.57770047,-0.57782753,-0.57782753,1.7332144,-0.57782753,-0.57782753,-0.57782753,1.734446,-0.57782753,-0.57782753,-0.57782753,1.7336152,-0.57782753,-0.57782753,-0.57782753,1.7393819,-0.57782753,-0.57782753,-0.57782753,1.7373,-0.57782753,-0.57782753,-0.57782753,1.7376714,-0.57782753,-0.57782753,-0.57782753,1.7381503,-0.57782753,-0.57782753,-0.57782753,1.7369677,-0.57782753,-0.57782753,-0.57782753,1.7371241,-0.57782753,-0.57782753,-0.57782753,1.7390789,-0.57782753,-0.57782753,-0.57782753,1.7389616,-0.57782753,-0.57782753,-0.57782753,1.7353159,-0.57782753,-0.57782753,-0.57782753,1.7396653,-0.57782753,-0.57782753,-0.57782753,1.7424803,-0.57782753,-0.57782753,-0.57782753,1.7411608,-0.57782753,-0.57782753,-0.57782753,1.7430081,-0.57782753,-0.57782753,-0.57782753,1.7417374,-0.57782753,-0.57782753,-0.57782753,1.7414247,-0.57782753,-0.57782753,-0.57782753,1.741972,-0.57782753,-0.57782753,-0.57782753,1.7406623,-0.57782753,-0.57782753,-0.57782753,1.7408969,-0.57782753,-0.57782753,-0.57782753,1.7406721,-0.57782753,-0.57782753,-0.57782753,1.73903,-0.57782753,-0.57782753,-0.57782753,1.73903,-0.57782753,-0.57782753,-0.57782753,1.73903,-0.57782753,-0.57782753,-0.57782753,1.73903,-0.57782753,-0.57782753,-0.57782753,1.73903,-0.57782753,-0.57782753,-0.57782753,1.73903,-0.57782753:9
-0.59236604,-0.53109278,1.7461813,-0.58879419,-0.59236604,-0.53109278,1.7446864,-0.58880422,-0.59236604,-0.53109278,1.7444556,-0.58880422,-0.59133261,-0.54252069,1.7374825,-0.58885439,-0.5934095,-0.53109278,1.7467633,-0.58879419,-0.5934095,-0.53109278,1.7376932,-0.58880422,-0.5934095,-0.53109278,1.7393085,-0.58880422,-0.59236604,-0.53109278,1.742168,-0.58880422,-0.59236604,-0.53109278,1.7326264,-0.58880422,-0.5934095,-0.53109278,1.7317535,-0.58879419,-0.5934095,-0.53109278,1.7302987,-0.58880422,-0.5934095,-0.53109278,1.7309809,-0.58880422,-0.59236604,-0.53109278,1.7301682,-0.58880422,-0.59236604,-0.53109278,1.7352049,-0.58880422,-0.59236604,-0.53109278,1.7327267,-0.58880422,-0.5934095,-0.53109278,1.7324859,-0.58879419,-0.59236604,-0.53109278,1.7352651,-0.58880422,-0.5934095,-0.53109278,1.7326464,-0.58879419,-0.5934095,-0.53109278,1.7385661,-0.58880422,-0.59236604,-0.53109278,1.732205,-0.58880422,-0.59236604,-0.53109278,1.7385059,-0.58880422,-0.59236604,-0.53109278,1.7354558,-0.58879419,-0.59236604,-0.53109278,1.7400109,-0.58880422,-0.5934095,-0.53109278,1.7413252,-0.58879419,-0.5934095,-0.53109278,1.7372016,-0.58879419,-0.5934095,-0.53109278,1.7387065,-0.58879419,-0.59236604,-0.53109278,1.7360277,-0.58879419,-0.59236604,-0.53109278,1.7388871,-0.58880422,-0.59236604,-0.53109278,1.7355962,-0.58879419,-0.59236604,-0.53109278,1.7389674,-0.58880422,-0.59236604,-0.53109278,1.7320143,-0.58879419,-0.59236604,-0.53109278,1.7353956,-0.58880422,-0.59236604,-0.53109278,1.7317133,-0.58879419,-0.5934095,-0.53109278,1.7360578,-0.58880422,-0.5934095,-0.53109278,1.7341414,-0.58880422,-0.5934095,-0.53109278,1.728904,-0.58879419,-0.59236604,-0.53109278,1.7319842,-0.58880422,-0.59236604,-0.53005936,1.7282017,-0.58879419,-0.5934095,-0.53109278,1.7405527,-0.58880422,-0.5934095,-0.53005936,1.7359675,-0.58880422,-0.59236604,-0.53109278,1.7401513,-0.58880422,-0.59236604,-0.53109278,1.7343822,-0.58879419,-0.5934095,-0.53109278,1.7406931,-0.58880422,-0.5934095,-0.53109278,1.7395594,-0.58880422,-0.5934095,-0.53005936,1.7396296,-0.58880422,-0.59236604,-0.53109278,1.7402015,-0.58880422,-0.59236604,-0.53109278,1.7344825,-0.58880422,-0.59236604,-0.53109278,1.7396396,-0.58880422,-0.59236604,-0.53109278,1.7380845,-0.58880422,-0.59236604,-0.53109278,1.7407232,-0.58880422,-0.5934095,-0.53005936,1.7374524,-0.58880422,-0.59236604,-0.53109278,1.7420075,-0.58879419,-0.59236604,-0.53005936,1.7382952,-0.58880422,-0.59236604,-0.53005936,1.741867,-0.58880422,-0.59236604,-0.53109278,1.7389774,-0.58880422,-0.59236604,-0.53005936,1.7446462,-0.58880422,-0.5934095,-0.53005936,1.7424389,-0.58880422,-0.59236604,-0.53005936,1.746091,-0.58880422,-0.59236604,-0.53005936,1.752101,-0.58880422,-0.59236604,-0.53005936,1.748198,-0.58880422,-0.59236604,-0.53005936,1.7553819,-0.58880422,-0.59236604,-0.53005936,1.7517398,-0.58880422,-0.59236604,-0.53005936,1.7537765,-0.58880422,-0.59236604,-0.53005936,1.7517799,-0.58880422,-0.59236604,-0.53005936,1.7544387,-0.58880422,-0.59236604,-0.53005936,1.7506161,-0.58880422,-0.59236604,-0.53005936,1.7578902,-0.58880422,-0.59236604,-0.53005936,1.7568969,-0.58880422,-0.59236604,-0.53005936,1.7514889,-0.58880422,-0.59236604,-0.53005936,1.7559839,-0.58880422,-0.59236604,-0.53005936,1.7516595,-0.58880422,-0.59236604,-0.53005936,1.7546996,-0.58880422,-0.59236604,-0.53005936,1.752422,-0.58880422,-0.59236604,-0.53005936,1.7547598,-0.58881426,-0.59236604,-0.53005936,1.7503351,-0.58880422,-0.59236604,-0.53005936,1.75182,-0.58880422,-0.59236604,-0.53005936,1.7563651,-0.58881426,-0.5934095,-0.53005936,1.7426998,-0.58880422,-0.59236604,-0.53005936,1.7470241,-0.58880422,-0.59236604,-0.53005936,1.7407333,-0.58880422,-0.59236604,-0.53005936,1.7428503,-0.58880422,-0.59236604,-0.53005936,1.7380243,-0.58880422,-0.59236604,-0.53005936,1.743071,-0.58880422,-0.59236604,-0.53005936,1.7412751,-0.58880422,-0.59236604,-0.53005936,1.7374424,-0.58880422,-0.59236604,-0.53005936,1.7417366,-0.58880422,-0.59236604,-0.53005936,1.7383353,-0.58880422,-0.59236604,-0.53005936,1.7416965,-0.58880422,-0.59236604,-0.53005936,1.738536,-0.58880422,-0.5934095,-0.53005936,1.7434222,-0.58880422,-0.5934095,-0.53005936,1.7408035,-0.58880422,-0.59236604,-0.53005936,1.7436128,-0.58880422,-0.59236604,-0.53005936,1.7419072,-0.58880422,-0.5934095,-0.53005936,1.7397099,-0.58879419,-0.5934095,-0.53005936,1.742148,-0.58879419,-0.5934095,-0.53005936,1.7384958,-0.58879419,-0.59236604,-0.53005936,1.7418771,-0.58880422,-0.59236604,-0.53005936,1.7377133,-0.58879419,-0.59236604,-0.53005936,1.7404925,-0.58879419,-0.5934095,-0.53005936,1.7390477,-0.58880422,-0.5934095,-0.53005936,1.7405828,-0.58879419,-0.5934095,-0.53005936,1.7382952,-0.58879419,-0.5934095,-0.53005936,1.7422282,-0.58879419,-0.5934095,-0.53005936,1.7378838,-0.58879419,-0.5934095,-0.53005936,1.7441446,-0.58879419,-0.5934095,-0.53005936,1.7433921,-0.58879419,-0.5934095,-0.53005936,1.7421078,-0.58879419,-0.59236604,-0.53005936,1.7438637,-0.58879419,-0.5934095,-0.53005936,1.738847,-0.58879419,-0.5934095,-0.53005936,1.7428403,-0.58879419,-0.5934095,-0.53005936,1.7392584,-0.58879419,-0.5934095,-0.53005936,1.7420175,-0.58879419,-0.59236604,-0.53005936,1.7384356,-0.58879419,-0.5934095,-0.53005936,1.7425092,-0.58879419,-0.5934095,-0.53005936,1.7386764,-0.58879419,-0.5934095,-0.53005936,1.7422483,-0.58879419,-0.5934095,-0.5290159,1.7393085,-0.58879419,-0.5934095,-0.53005936,1.7434322,-0.58879419,-0.5934095,-0.53005936,1.7427098,-0.58879419,-0.5934095,-0.53005936,1.73673,-0.58879419,-0.5934095,-0.53005936,1.7432617,-0.58879419,-0.5934095,-0.5290159,1.7388972,-0.58879419,-0.5934095,-0.53005936,1.743071,-0.58879419,-0.5934095,-0.53005936,1.7357166,-0.58879419,-0.5934095,-0.53005936,1.7410242,-0.58879419,-0.5934095,-0.5290159,1.7365695,-0.58879419,-0.5934095,-0.5290159,1.7425794,-0.58879419,-0.5934095,-0.5290159,1.7383855,-0.58879419,-0.5934095,-0.5290159,1.7428603,-0.58879419,-0.59028915,-0.55810238,1.7414155,-0.58893466,-0.58925572,-0.57368407,1.7385861,-0.58904502,-0.59133261,-0.55082825,1.7413955,-0.58889452,-0.5934095,-0.53316967,1.7380142,-0.58880422,-0.5934095,-0.53316967,1.7433018,-0.58880422,-0.5934095,-0.53316967,1.7311114,-0.58880422,-0.5934095,-0.53316967,1.7348638,-0.58880422,-0.5934095,-0.53213625,1.7300679,-0.58879419,-0.5934095,-0.53316967,1.732827,-0.58880422,-0.5934095,-0.53316967,1.7332685,-0.58880422,-0.5934095,-0.53213625,1.7274793,-0.58879419,-0.5934095,-0.53316967,1.7326565,-0.58880422,-0.5934095,-0.53213625,1.732807,-0.58880422,-0.5934095,-0.53213625,1.7290545,-0.58880422,-0.5934095,-0.53213625,1.7344926,-0.58880422,-0.5934095,-0.53213625,1.7290947,-0.58879419,-0.5934095,-0.53213625,1.734021,-0.58879419,-0.5934095,-0.53213625,1.7281917,-0.58879419,-0.5934095,-0.53213625,1.7326765,-0.58879419,-0.5934095,-0.53213625,1.7298472,-0.58879419,-0.5934095,-0.53213625,1.7346531,-0.58879419,-0.5934095,-0.53213625,1.7341213,-0.58879419,-0.5934095,-0.53213625,1.7301783,-0.58879419,-0.5934095,-0.53213625,1.7313823,-0.58879419,-0.5934095,-0.53213625,1.7275596,-0.58879419,-0.5934095,-0.53213625,1.7307803,-0.58879419,-0.5934095,-0.53213625,1.7268171,-0.58879419,-0.5934095,-0.53213625,1.7308104,-0.58879419,-0.5934095,-0.53213625,1.7274793,-0.58879419,-0.5934095,-0.53213625,1.7309809,-0.58879419,-0.5934095,-0.53213625,1.7298973,-0.58879419,-0.5934095,-0.53213625,1.7272887,-0.58879419,-0.5934095,-0.53213625,1.7299274,-0.58879419,-0.5934095,-0.53213625,1.7333688,-0.58879419,-0.5934095,-0.53213625,1.725874,-0.58879419,-0.5934095,-0.53213625,1.7261248,-0.58879419,-0.5934095,-0.53213625,1.7227837,-0.58878416,-0.5934095,-0.53213625,1.7277903,-0.58879419,-0.5934095,-0.53213625,1.7122187,-0.58878416,-0.5934095,-0.53213625,1.7170648,-0.58878416,-0.5934095,-0.53213625,1.7155397,-0.58878416,-0.5934095,-0.53213625,1.7115866,-0.58878416,-0.5934095,-0.53213625,1.7178474,-0.58878416,-0.5934095,-0.53213625,1.7110548,-0.58878416,-0.59236604,-0.54564104,1.7192721,-0.58885439,-0.5934095,-0.53213625,1.7155999,-0.58878416,-0.5934095,-0.53213625,1.7147872,-0.58878416,-0.5934095,-0.53213625,1.7212988,-0.58878416,-0.5934095,-0.53213625,1.7253623,-0.58879419,-0.5934095,-0.53213625,1.7262853,-0.58879419,-0.5934095,-0.53109278,1.7215095,-0.58879419,-0.5934095,-0.53213625,1.7280512,-0.58879419,-0.5934095,-0.53213625,1.7215797,-0.58878416,-0.5934095,-0.53109278,1.7272485,-0.58878416,-0.5934095,-0.53213625,1.7236366,-0.58878416,-0.5934095,-0.53213625,1.725282,-0.58879419,-0.5934095,-0.53109278,1.7254726,-0.58878416,-0.5934095,-0.53109278,1.7221817,-0.58878416,-0.5934095,-0.53109278,1.7246299,-0.58878416,-0.5934095,-0.53109278,1.7167939,-0.58878416,-0.5934095,-0.53109278,1.7233155,-0.58878416,-0.5934095,-0.53109278,1.7181785,-0.58878416,-0.5934095,-0.53109278,1.7233255,-0.58878416,-0.5934095,-0.53109278,1.7178173,-0.58878416,-0.5934095,-0.53109278,1.7222118,-0.58878416,-0.5934095,-0.53109278,1.7142855,-0.58878416,-0.5934095,-0.53109278,1.7223824,-0.58878416,-0.5934095,-0.53109278,1.7176868,-0.58878416,-0.5934095,-0.53109278,1.7187503,-0.58878416,-0.5934095,-0.53109278,1.7251917,-0.58878416,-0.5934095,-0.53109278,1.7170447,-0.58878416,-0.5934095,-0.53109278,1.7244593,-0.58878416,-0.5934095,-0.53109278,1.7226332,-0.58878416,-0.5934095,-0.53109278,1.7287836,-0.58878416,-0.5934095,-0.53109278,1.7179276,-0.58878416,-0.59444293,-0.53109278,1.7212085,-0.58878416,-0.5934095,-0.53109278,1.7179276,-0.58878416,-0.5934095,-0.53109278,1.7218105,-0.58878416,-0.5934095,-0.53109278,1.7229944,-0.58878416,-0.5934095,-0.53109278,1.7201951,-0.58878416,-0.5934095,-0.53109278,1.7239677,-0.58878416,-0.59444293,-0.53109278,1.7194025,-0.58877412,-0.5934095,-0.53109278,1.7230847,-0.58877412,-0.5934095,-0.53109278,1.7178474,-0.58878416,-0.5934095,-0.53109278,1.724379,-0.58878416,-0.5934095,-0.53109278,1.7180982,-0.58877412,-0.5934095,-0.53109278,1.7235262,-0.58878416,-0.5934095,-0.53109278,1.7219209,-0.58878416,-0.59444293,-0.53109278,1.7232051,-0.58877412,-0.5934095,-0.53109278,1.7208674,-0.58878416,-0.5934095,-0.53109278,1.7178273,-0.58877412,-0.5934095,-0.53109278,1.7202252,-0.58877412,-0.5934095,-0.53005936,1.7202754,-0.58877412,-0.59444293,-0.53109278,1.7233556,-0.58877412,-0.5934095,-0.53524656,1.7189911,-0.58879419,-0.59236604,-0.5404438,1.7194527,-0.58882429,-0.59236604,-0.54459758,1.7189811,-0.58884436,-0.59133261,-0.54979482,1.7227235,-0.58887446,-0.59133261,-0.5539486,1.7242988,-0.58889452,-0.59133261,-0.5539486,1.7245195,-0.58889452,-0.59133261,-0.55498203,1.7178072,-0.58889452,-0.59133261,-0.5539486,1.7162119,-0.58889452,-0.59133261,-0.5539486,1.7257435,-0.58889452,-0.59133261,-0.5539486,1.7190012,-0.58889452,-0.59133261,-0.5539486,1.7289642,-0.58889452,-0.59133261,-0.55705892,1.7271181,-0.58890456,-0.59028915,-0.5612127,1.7274592,-0.58893466,-0.59028915,-0.56328959,1.7258439,-0.58895472,-0.59028915,-0.56433305,1.7263857,-0.58895472,-0.59028915,-0.56328959,1.7308806,-0.58895472,-0.59028915,-0.56328959,1.7290545,-0.58895472,-0.59028915,-0.56328959,1.729185,-0.58895472,-0.59028915,-0.56328959,1.7259843,-0.58895472,-0.59028915,-0.56328959,1.7306097,-0.58895472,-0.59028915,-0.56433305,1.7291147,-0.58895472,-0.59133261,-0.56328959,1.7248406,-0.58895472,-0.59028915,-0.56848683,1.7284124,-0.58899486,-0.59028915,-0.56848683,1.7245496,-0.58898482,-0.59028915,-0.56848683,1.7275897,-0.58899486,-0.59028915,-0.56848683,1.7252017,-0.58898482,-0.59028915,-0.56848683,1.729185,-0.58898482,-0.59028915,-0.56848683,1.7265562,-0.58898482,-0.59028915,-0.56848683,1.7245095,-0.58898482,-0.59028915,-0.57056372,1.7296967,-0.58900489,-0.59028915,-0.57056372,1.727389,-0.58900489,-0.59028915,-0.57056372,1.7292452,-0.58900489,-0.59028915,-0.57056372,1.7352952,-0.58900489,-0.59028915,-0.57056372,1.7379942,-0.58900489,-0.59028915,-0.57056372,1.7320545,-0.58900489,-0.59028915,-0.57056372,1.7369708,-0.58900489,-0.59028915,-0.57056372,1.7316632,-0.58900489,-0.59028915,-0.57368407,1.7364089,-0.58902496,-0.59028915,-0.57368407,1.7320946,-0.58902496,-0.58925572,-0.58925572,1.7374624,-0.58925572,-0.58925572,-0.58925572,1.7320444,-0.58925572,-0.58925572,-0.58925572,1.7361882,-0.58925572,-0.58925572,-0.58925572,1.7252218,-0.58925572,-0.58925572,-0.58406851,1.7333688,-0.58923566,-0.58925572,-0.58406851,1.7322551,-0.58923566,-0.58925572,-0.58302505,1.7234058,-0.58914536,-0.58925572,-0.58302505,1.7257937,-0.58914536,-0.58925572,-0.58302505,1.7260646,-0.58913532,-0.58925572,-0.58925572,1.7290044,-0.58925572,-0.58925572,-0.58925572,1.730991,-0.58925572,-0.58925572,-0.58925572,1.7328872,-0.58925572,-0.58925572,-0.58925572,1.7309408,-0.58925572,-0.58925572,-0.58925572,1.7288137,-0.58925572,-0.58925572,-0.58925572,1.7290545,-0.58925572,-0.58925572,-0.58925572,1.7295963,-0.58925572,-0.58925572,-0.58925572,1.7294157,-0.58925572,-0.58925572,-0.58925572,1.7315729,-0.58925572,-0.58925572,-0.58925572,1.7248606,-0.58925572,-0.58925572,-0.58925572,1.7199443,-0.58925572,-0.58925572,-0.58925572,1.717436,-0.58925572,-0.58925572,-0.58925572,1.71562,-0.58925572,-0.58925572,-0.58925572,1.7166634,-0.58925572,-0.58925572,-0.58925572,1.7163624,-0.58925572,-0.58925572,-0.58925572,1.7172654,-0.58925572,-0.58925572,-0.58925572,1.7255027,-0.58925572,-0.58925572,-0.58925572,1.7247904,-0.58925572,-0.58925572,-0.58925572,1.7158307,-0.58925572,-0.58925572,-0.58925572,1.7159109,-0.58925572,-0.58925572,-0.58925572,1.724971,-0.58925572,-0.58925572,-0.58925572,1.7247603,-0.58925572,-0.58925572,-0.58925572,1.7241884,-0.58925572,-0.58925572,-0.58925572,1.7239677,-0.58925572,-0.58925572,-0.58925572,1.7236767,-0.58925572,-0.58925572,-0.58925572,1.7247503,-0.58925572,-0.58925572,-0.58925572,1.7157404,-0.58925572,-0.58925572,-0.58925572,1.7144862,-0.58925572,-0.58925572,-0.58925572,1.7233857,-0.58925572,-0.58925572,-0.58925572,1.7250312,-0.58925572,-0.58925572,-0.58925572,1.7240379,-0.58925572,-0.58925572,-0.58925572,1.722854,-0.58925572,-0.58925572,-0.58925572,1.7161016,-0.58925572,-0.58925572,-0.58925572,1.7133625,-0.58925572,-0.58925572,-0.58925572,1.7219008,-0.58925572,-0.58925572,-0.58925572,1.7230045,-0.58925572,-0.58925572,-0.58925572,1.721951,-0.58925572,-0.58925572,-0.58925572,1.7225931,-0.58925572,-0.58925572,-0.58925572,1.7233055,-0.58925572,-0.58925572,-0.58925572,1.7208272,-0.58925572,-0.58925572,-0.58925572,1.7227035,-0.58925572,-0.58925572,-0.58925572,1.7225229,-0.58925572,-0.58925572,-0.58925572,1.7223021,-0.58925572,-0.58925572,-0.58925572,1.7217102,-0.58925572,-0.58925572,-0.58925572,1.7222821,-0.58925572,-0.58925572,-0.58925572,1.7226132,-0.58925572,-0.58925572,-0.58925572,1.7223122,-0.58925572,-0.58925572,-0.58925572,1.7235864,-0.58925572,-0.58925572,-0.58925572,1.7220212,-0.58925572,-0.58925572,-0.58925572,1.7212486,-0.58925572,-0.58925572,-0.58925572,1.721349,-0.58925572,-0.58925572,-0.58925572,1.7215296,-0.58925572,-0.58925572,-0.58925572,1.7221015,-0.58925572,-0.58925572,-0.58925572,1.7208473,-0.58925572,-0.58925572,-0.58925572,1.721961,-0.58925572,-0.58925572,-0.58925572,1.7211884,-0.58925572,-0.58925572,-0.58925572,1.7226533,-0.58925572,-0.58925572,-0.58925572,1.7214593,-0.58925572,-0.58925572,-0.58925572,1.7217302,-0.58925572,-0.58925572,-0.58925572,1.7212286,-0.58925572,-0.58925572,-0.58925572,1.7200848,-0.58925572,-0.58925572,-0.58925572,1.7303789,-0.58925572,-0.58925572,-0.58925572,1.732225,-0.58925572,-0.58925572,-0.58925572,1.7306197,-0.58925572,-0.58925572,-0.58925572,1.7308204,-0.58925572,-0.58925572,-0.58925572,1.731623,-0.58925572,-0.58925572,-0.58925572,1.7391179,-0.58925572,-0.58925572,-0.58925572,1.7405828,-0.58925572,-0.58925572,-0.58925572,1.7395192,-0.58925572,-0.58925572,-0.58925572,1.737924,-0.58925572,-0.58925572,-0.58925572,1.7383052,-0.58925572,-0.58925572,-0.58925572,1.7366297,-0.58925572,-0.58925572,-0.58925572,1.7380243,-0.58925572,-0.58925572,-0.58925572,1.7394891,-0.58925572,-0.58925572,-0.58925572,1.7387166,-0.58925572,-0.58925572,-0.58925572,1.7383453,-0.58925572,-0.58925572,-0.58925572,1.7328772,-0.58925572,-0.58925572,-0.58925572,1.7328571,-0.58925572,-0.58925572,-0.58925572,1.7339809,-0.58925572,-0.58925572,-0.58925572,1.7327267,-0.58925572,-0.58925572,-0.58925572,1.7367099,-0.58925572,-0.58925572,-0.58925572,1.7375126,-0.58925572,-0.58925572,-0.58925572,1.7374624,-0.58925572,-0.58925572,-0.58925572,1.7380945,-0.58925572,-0.58925572,-0.58925572,1.7371313,-0.58925572,-0.58925572,-0.58925572,1.7357467,-0.58925572,-0.58925572,-0.58925572,1.7353755,-0.58925572,-0.58925572,-0.58925572,1.7353755,-0.58925572,-0.58925572,-0.58925572,1.7353755,-0.58925572,-0.58925572,-0.58925572,1.7353755,-0.58925572,-0.58925572,-0.58925572,1.7353755,-0.58925572,-0.58925572,-0.58925572,1.7353755,-0.58925572,-0.58925572,-0.58925572,1.7353755,-0.58925572,-0.58925572,-0.58925572,1.7353755,-0.58925572:9
-0.58380936,-0.58380936,1.7469599,-0.58380936,-0.58380936,-0.58380936,1.7439698,-0.58380936,-0.58380936,-0.58380936,1.7411226,-0.58380936,-0.58380936,-0.58380936,1.7433881,-0.58380936,-0.58380936,-0.58380936,1.7506235,-0.58380936,-0.58380936,-0.58380936,1.744878,-0.58380936,-0.58380936,-0.58380936,1.7505623,-0.58380936,-0.58380936,-0.58380936,1.7536748,-0.58380936,-0.58380936,-0.58380936,1.7422247,-0.58380936,-0.58380936,-0.58380936,1.7531646,-0.58380936,-0.58380936,-0.58380936,1.7464394,-0.58380936,-0.58380936,-0.58380936,1.7408878,-0.58380936,-0.58380936,-0.58380936,1.7537973,-0.58380936,-0.58380936,-0.58380936,1.7473885,-0.58380936,-0.58380936,-0.58380936,1.7501643,-0.58380936,-0.58380936,-0.58380936,1.7493581,-0.58380936,-0.58380936,-0.58380936,1.7496846,-0.58380936,-0.58380936,-0.58380936,1.7517052,-0.58380936,-0.58380936,-0.58380936,1.7471946,-0.58380936,-0.58380936,-0.58380936,1.7468374,-0.58380936,-0.58380936,-0.58380936,1.7521951,-0.58380936,-0.58380936,-0.58380936,1.7467047,-0.58380936,-0.58380936,-0.58380936,1.7513072,-0.58380936,-0.58380936,-0.58380936,1.7523379,-0.58380936,-0.58380936,-0.58380936,1.7440922,-0.58380936,-0.58380936,-0.58380936,1.7510317,-0.58380936,-0.58380936,-0.58380936,1.7523584,-0.58380936,-0.58380936,-0.58380936,1.7488376,-0.58380936,-0.58380936,-0.58380936,1.751593,-0.58380936,-0.58380936,-0.58380936,1.7512256,-0.58380936,-0.58380936,-0.58380936,1.7559097,-0.58380936,-0.58380936,-0.58380936,1.7550729,-0.58380936,-0.58380936,-0.58380936,1.7509909,-0.58380936,-0.58380936,-0.58380936,1.7488988,-0.58380936,-0.58380936,-0.58380936,1.7540422,-0.58380936,-0.58380936,-0.58380936,1.7520828,-0.58380936,-0.58380936,-0.58380936,1.7301827,-0.58380936,-0.58380936,-0.58380936,1.7479498,-0.58380936,-0.58380936,-0.58380936,1.7419186,-0.58380936,-0.58380936,-0.58380936,1.7345403,-0.58380936,-0.58380936,-0.58380936,1.744776,-0.58380936,-0.58380936,-0.58380936,1.7414185,-0.58380936,-0.58380936,-0.58380936,1.7404184,-0.58380936,-0.58380936,-0.58380936,1.7289887,-0.58380936,-0.58380936,-0.58380936,1.7269987,-0.58380936,-0.58380936,-0.58380936,1.7310501,-0.58380936,-0.58380936,-0.58380936,1.7296418,-0.58380936,-0.58380936,-0.58380936,1.7258149,-0.58380936,-0.58380936,-0.58380936,1.7345301,-0.58380936,-0.58380936,-0.58380936,1.7242331,-0.58380936,-0.58380936,-0.58380936,1.7278355,-0.58380936,-0.58380936,-0.58380936,1.7332442,-0.58380936,-0.58380936,-0.58380936,1.728356,-0.58380936,-0.58380936,-0.58380936,1.7309277,-0.58380936,-0.58380936,-0.58380936,1.7333055,-0.58380936,-0.58380936,-0.58380936,1.7240597,-0.58380936,-0.58380936,-0.58380936,1.7361731,-0.58380936,-0.58380936,-0.58380936,1.7287438,-0.58380936,-0.58380936,-0.58380936,1.7247842,-0.58380936,-0.58380936,-0.58380936,1.7272641,-0.58380936,-0.58380936,-0.58380936,1.7315502,-0.58380936,-0.58380936,-0.58380936,1.7249679,-0.58380936,-0.58380936,-0.58380936,1.7363058,-0.58380936,-0.58380936,-0.58380936,1.7308052,-0.58380936,-0.58380936,-0.58380936,1.7297643,-0.58380936,-0.58380936,-0.58380936,1.7263864,-0.58380936,-0.58380936,-0.58380936,1.730346,-0.58380936,-0.58380936,-0.58380936,1.7322747,-0.58380936,-0.58380936,-0.58380936,1.7305399,-0.58380936,-0.58380936,-0.58380936,1.7360302,-0.58380936,-0.58380936,-0.58380936,1.7370201,-0.58380936,-0.58380936,-0.58380936,1.7337749,-0.58380936,-0.58380936,-0.58380936,1.7338974,-0.58380936,-0.58380936,-0.58380936,1.7276723,-0.58380936,-0.58380936,-0.58380936,1.7333055,-0.58380936,-0.58380936,-0.58380936,1.7281927,-0.58380936,-0.58380936,-0.58380936,1.7297847,-0.58380936,-0.58380936,-0.58380936,1.7344893,-0.58380936,-0.58380936,-0.58380936,1.7353771,-0.58380936,-0.58380936,-0.58380936,1.734326,-0.58380936,-0.58380936,-0.58380936,1.7305705,-0.58380936,-0.58380936,-0.58380936,1.7355404,-0.58380936,-0.58380936,-0.58380936,1.7346117,-0.58380936,-0.58380936,-0.58380936,1.7306419,-0.58380936,-0.58380936,-0.57008353,1.7356628,-0.58186019,-0.58380936,-0.58380936,1.7309583,-0.58380936,-0.58380936,-0.58380936,1.7317441,-0.58380936,-0.58380936,-0.58380936,1.737265,-0.58380936,-0.58380936,-0.58380936,1.7353669,-0.58380936,-0.58380936,-0.58380936,1.731938,-0.58380936,-0.58380936,-0.58380936,1.7356424,-0.58380936,-0.58380936,-0.58380936,1.7396428,-0.58380936,-0.58380936,-0.58380936,1.7344382,-0.58380936,-0.58380936,-0.58380936,1.7344995,-0.58380936,-0.58380936,-0.58380936,1.7392448,-0.58380936,-0.58380936,-0.58380936,1.7356628,-0.58380936,-0.58380936,-0.58380936,1.7350199,-0.58380936,-0.58380936,-0.58380936,1.7366833,-0.58380936,-0.58380936,-0.58380936,1.7308052,-0.58380936,-0.58380936,-0.58380936,1.735622,-0.58380936,-0.58380936,-0.58380936,1.7393979,-0.58380936,-0.58380936,-0.58380936,1.7353873,-0.58380936,-0.58380936,-0.58380936,1.74199,-0.58380936,-0.58380936,-0.58380936,1.7397857,-0.58380936,-0.58380936,-0.58380936,1.7231718,-0.58380936,-0.58380936,-0.58380936,1.7301317,-0.58380936,-0.58380936,-0.58380936,1.7189367,-0.58380936,-0.58380936,-0.58380936,1.7180183,-0.58380936,-0.58380936,-0.58380936,1.7184673,-0.58380936,-0.58380936,-0.58380936,1.7216615,-0.58380936,-0.58380936,-0.58380936,1.721539,-0.58380936,-0.58380936,-0.58380936,1.7182836,-0.58380936,-0.58380936,-0.58380936,1.721539,-0.58380936,-0.58380936,-0.58380936,1.7254067,-0.58380936,-0.58380936,-0.58380936,1.7152935,-0.58380936,-0.58380936,-0.58380936,1.7220391,-0.58380936,-0.58380936,-0.58380936,1.7264068,-0.58380936,-0.58380936,-0.58380936,1.7139566,-0.58380936,-0.58380936,-0.58380936,1.720743,-0.58380936,-0.58380936,-0.58380936,1.7239576,-0.58380936,-0.58592182,-0.55106126,1.7134566,-0.58354403,-0.58592182,-0.55001013,1.7141505,-0.58354403,-0.58592182,-0.55001013,1.7206308,-0.58353383,-0.58592182,-0.55106126,1.7156609,-0.58354403,-0.58592182,-0.55106126,1.7315706,-0.58354403,-0.58592182,-0.55106126,1.7310808,-0.58354403,-0.58592182,-0.55106126,1.7274784,-0.58354403,-0.58592182,-0.55106126,1.7325605,-0.58354403,-0.58592182,-0.55106126,1.7282233,-0.58354403,-0.58592182,-0.55106126,1.7191306,-0.58354403,-0.58592182,-0.55106126,1.7225493,-0.58354403,-0.58592182,-0.55212259,1.7217329,-0.58354403,-0.58592182,-0.55212259,1.7226309,-0.58354403,-0.58592182,-0.55212259,1.7263966,-0.58355424,-0.58592182,-0.55212259,1.726417,-0.58354403,-0.58592182,-0.55212259,1.7266517,-0.58355424,-0.58592182,-0.55212259,1.7148445,-0.58354403,-0.58592182,-0.55212259,1.701435,-0.58354403,-0.58592182,-0.55212259,1.7009043,-0.58355424,-0.58592182,-0.55212259,1.6972101,-0.58355424,-0.58592182,-0.55212259,1.7034148,-0.58355424,-0.58592182,-0.55212259,1.7073233,-0.58355424,-0.58592182,-0.55212259,1.6988429,-0.58355424,-0.58592182,-0.55212259,1.7038536,-0.58355424,-0.58592182,-0.55317371,1.7099664,-0.58355424,-0.58592182,-0.55317371,1.6954752,-0.58355424,-0.58592182,-0.55317371,1.7000879,-0.58355424,-0.58592182,-0.55317371,1.7046292,-0.58355424,-0.58592182,-0.55317371,1.7080173,-0.58355424,-0.58486049,-0.55317371,1.7117727,-0.58355424,-0.58486049,-0.55317371,1.720743,-0.58356444,-0.58486049,-0.55317371,1.7237841,-0.58356444,-0.58486049,-0.55317371,1.7245087,-0.58356444,-0.58486049,-0.55317371,1.7181611,-0.58356444,-0.58486049,-0.55317371,1.7184367,-0.58355424,-0.58592182,-0.55317371,1.7205797,-0.58356444,-0.58486049,-0.55317371,1.7198858,-0.58355424,-0.58486049,-0.55317371,1.7192531,-0.58356444,-0.58486049,-0.55317371,1.7259578,-0.58356444,-0.58592182,-0.55317371,1.7217635,-0.58356444,-0.58486049,-0.55317371,1.7179978,-0.58356444,-0.58592182,-0.55317371,1.7215696,-0.58356444,-0.58486049,-0.55317371,1.7223554,-0.58356444,-0.58486049,-0.55317371,1.7273151,-0.58356444,-0.58486049,-0.55317371,1.7282437,-0.58356444,-0.58486049,-0.55317371,1.7310399,-0.58356444,-0.58486049,-0.55317371,1.727509,-0.58356444,-0.58486049,-0.55317371,1.7205083,-0.58356444,-0.58486049,-0.55317371,1.7177937,-0.58356444,-0.58486049,-0.55423504,1.7254578,-0.58356444,-0.58486049,-0.55317371,1.7112115,-0.58355424,-0.58486049,-0.55317371,1.7213757,-0.58356444,-0.58486049,-0.55423504,1.7292643,-0.58356444,-0.58486049,-0.55423504,1.7124361,-0.58356444,-0.58486049,-0.55423504,1.7314175,-0.58356444,-0.58486049,-0.55423504,1.7187734,-0.58356444,-0.58486049,-0.55423504,1.7273661,-0.58356444,-0.58486049,-0.55423504,1.728305,-0.58356444,-0.58486049,-0.55423504,1.7264374,-0.58356444,-0.58486049,-0.55423504,1.7283968,-0.58356444,-0.58486049,-0.55423504,1.7274477,-0.58356444,-0.58486049,-0.55423504,1.722784,-0.58356444,-0.58486049,-0.55423504,1.7268456,-0.58356444,-0.58486049,-0.55423504,1.731142,-0.58356444,-0.58486049,-0.55423504,1.7237127,-0.58356444,-0.58486049,-0.55423504,1.7238556,-0.58356444,-0.58486049,-0.55423504,1.7272436,-0.58356444,-0.58486049,-0.55423504,1.7280192,-0.58357465,-0.58486049,-0.55423504,1.7244168,-0.58356444,-0.58486049,-0.55423504,1.7287132,-0.58356444,-0.58486049,-0.55423504,1.735571,-0.58356444,-0.58486049,-0.55423504,1.7288152,-0.58356444,-0.58486049,-0.55423504,1.7275294,-0.58357465,-0.58486049,-0.55423504,1.7262538,-0.58357465,-0.58486049,-0.55423504,1.7174468,-0.58356444,-0.58486049,-0.55423504,1.7178754,-0.58357465,-0.58486049,-0.55423504,1.7260905,-0.58357465,-0.58486049,-0.55423504,1.7266109,-0.58356444,-0.58486049,-0.55423504,1.7216819,-0.58357465,-0.58486049,-0.55423504,1.7293153,-0.58357465,-0.58486049,-0.55423504,1.7128953,-0.58356444,-0.58486049,-0.55423504,1.7174264,-0.58356444,-0.58486049,-0.55423504,1.7242025,-0.58357465,-0.58486049,-0.55423504,1.7293459,-0.58357465,-0.58486049,-0.55423504,1.7273865,-0.58357465,-0.58486049,-0.55423504,1.7276416,-0.58357465,-0.58486049,-0.55423504,1.7295908,-0.58357465,-0.58486049,-0.55423504,1.7301827,-0.58357465,-0.58486049,-0.55423504,1.7303154,-0.58357465,-0.58486049,-0.55423504,1.7260292,-0.58357465,-0.58486049,-0.55423504,1.7277641,-0.58357465,-0.58486049,-0.55423504,1.7282846,-0.58357465,-0.58486049,-0.55423504,1.7262538,-0.58357465,-0.58486049,-0.55423504,1.7313257,-0.58357465,-0.58486049,-0.55423504,1.7275702,-0.58357465,-0.58486049,-0.55423504,1.7307032,-0.58357465,-0.58486049,-0.55423504,1.7220697,-0.58357465,-0.58486049,-0.55423504,1.7267028,-0.58357465,-0.58486049,-0.55423504,1.7312644,-0.58357465,-0.58486049,-0.55423504,1.7011595,-0.58357465,-0.58486049,-0.55423504,1.7113339,-0.58357465,-0.58486049,-0.55423504,1.7141607,-0.58357465,-0.58486049,-0.55423504,1.7111604,-0.58357465,-0.58486049,-0.55423504,1.7119054,-0.58357465,-0.58486049,-0.55423504,1.7235392,-0.58357465,-0.58486049,-0.55423504,1.720743,-0.58357465,-0.58486049,-0.55423504,1.718355,-0.58356444,-0.58486049,-0.55423504,1.720692,-0.58357465,-0.58486049,-0.55423504,1.7226616,-0.58357465,-0.58486049,-0.55423504,1.7190694,-0.58356444,-0.58486049,-0.55423504,1.7197123,-0.58357465,-0.58486049,-0.55423504,1.7301521,-0.58356444,-0.58486049,-0.55423504,1.7216921,-0.58357465,-0.58486049,-0.55423504,1.7236106,-0.58357465,-0.58486049,-0.55423504,1.7438983,-0.58357465,-0.58486049,-0.55423504,1.7395204,-0.58357465,-0.58486049,-0.55423504,1.7386529,-0.58357465,-0.58486049,-0.55423504,1.7401327,-0.58357465,-0.58486049,-0.55423504,1.74597,-0.58357465,-0.58486049,-0.55423504,1.7494907,-0.58357465,-0.58486049,-0.55423504,1.7401123,-0.58357465,-0.58486049,-0.55423504,1.7371222,-0.58357465,-0.58486049,-0.55423504,1.7436024,-0.58357465,-0.58486049,-0.55423504,1.7362343,-0.58357465,-0.58486049,-0.55423504,1.7172835,-0.58357465,-0.58486049,-0.55423504,1.7241107,-0.58357465,-0.58486049,-0.55423504,1.7282233,-0.58357465,-0.58486049,-0.55423504,1.7243964,-0.58357465,-0.58486049,-0.55423504,1.7261109,-0.58357465,-0.58486049,-0.55423504,1.7261007,-0.58357465,-0.58486049,-0.55423504,1.7200491,-0.58357465,-0.58486049,-0.55423504,1.7241719,-0.58357465,-0.58486049,-0.55423504,1.7158037,-0.58357465,-0.58486049,-0.55423504,1.7266722,-0.58357465,-0.58486049,-0.55423504,1.7238862,-0.58357465,-0.58486049,-0.55423504,1.7233147,-0.58357465,-0.58486049,-0.55423504,1.7248148,-0.58357465,-0.58486049,-0.55423504,1.715467,-0.58357465,-0.58486049,-0.55423504,1.7160385,-0.58357465,-0.58486049,-0.55423504,1.7238249,-0.58357465,-0.58486049,-0.55423504,1.7193347,-0.58357465,-0.58486049,-0.55423504,1.7139464,-0.58357465,-0.58486049,-0.55423504,1.7263966,-0.58357465,-0.58486049,-0.55423504,1.7179978,-0.58357465,-0.58486049,-0.55423504,1.7216002,-0.58357465,-0.58486049,-0.55423504,1.7207022,-0.58357465,-0.58486049,-0.55423504,1.7180183,-0.58357465,-0.58486049,-0.55423504,1.727458,-0.58357465,-0.58486049,-0.55423504,1.7199776,-0.58357465,-0.58486049,-0.55423504,1.7172325,-0.58357465,-0.58486049,-0.55423504,1.7328564,-0.58357465,-0.58486049,-0.55423504,1.7231922,-0.58357465,-0.58486049,-0.55423504,1.7186816,-0.58357465,-0.58486049,-0.55423504,1.7281621,-0.58357465,-0.58486049,-0.55423504,1.7247128,-0.58357465,-0.58486049,-0.55423504,1.7229677,-0.58357465,-0.58486049,-0.55423504,1.7257639,-0.58357465,-0.58486049,-0.55423504,1.7451332,-0.58357465,-0.58486049,-0.55423504,1.7503888,-0.58357465,-0.58486049,-0.55423504,1.7467149,-0.58357465,-0.58486049,-0.55423504,1.7500928,-0.58357465,-0.58486049,-0.55423504,1.7437657,-0.58357465,-0.58486049,-0.55423504,1.7391428,-0.58357465,-0.58486049,-0.55423504,1.744031,-0.58357465,-0.58486049,-0.55423504,1.7445208,-0.58357465,-0.58486049,-0.55423504,1.7361425,-0.58357465,-0.58486049,-0.55423504,1.7417655,-0.58357465,-0.58486049,-0.55423504,1.7420002,-0.58357465,-0.58486049,-0.55423504,1.7384896,-0.58357465,-0.58486049,-0.55423504,1.7376936,-0.58357465,-0.58486049,-0.55423504,1.7392142,-0.58357465,-0.58486049,-0.55423504,1.7404184,-0.58357465,-0.58486049,-0.55423504,1.7434391,-0.58357465,-0.58486049,-0.55423504,1.7422757,-0.58357465,-0.58486049,-0.55423504,1.7396632,-0.58357465,-0.58486049,-0.55423504,1.7445106,-0.58357465,-0.58486049,-0.55423504,1.7442045,-0.58357465,-0.58486049,-0.55423504,1.7368568,-0.58357465,-0.58486049,-0.55423504,1.7527257,-0.58357465,-0.58486049,-0.55423504,1.7454699,-0.58357465,-0.58486049,-0.55423504,1.744827,-0.58357465,-0.58486049,-0.55423504,1.7527461,-0.58357465,-0.58486049,-0.55423504,1.7459904,-0.58357465,-0.58486049,-0.55423504,1.7453679,-0.58357465,-0.58486049,-0.55423504,1.7460822,-0.58357465,-0.58486049,-0.55423504,1.7446331,-0.58357465,-0.58486049,-0.55423504,1.7490111,-0.58357465,-0.58486049,-0.55423504,1.7452352,-0.58357465,-0.58486049,-0.55423504,1.7524808,-0.58357465,-0.58486049,-0.55423504,1.7527257,-0.58357465,-0.58486049,-0.55423504,1.7453373,-0.58357465,-0.58486049,-0.55423504,1.7530523,-0.58357465,-0.58486049,-0.55423504,1.7518175,-0.58357465,-0.58486049,-0.55423504,1.7402755,-0.58357465,-0.58486049,-0.55423504,1.7521849,-0.58357465,-0.58486049,-0.55423504,1.7512358,-0.58357465,-0.58486049,-0.55423504,1.7481743,-0.58357465,-0.58486049,-0.55423504,1.7477457,-0.58357465,-0.58486049,-0.55423504,1.7458985,-0.58357465,-0.58486049,-0.55423504,1.7513685,-0.58357465,-0.58486049,-0.55423504,1.7481232,-0.58357465,-0.58486049,-0.55423504,1.7362037,-0.58357465,-0.58486049,-0.55423504,1.7281825,-0.58357465,-0.58486049,-0.55423504,1.7343362,-0.58356444,-0.58486049,-0.55423504,1.7405,-0.58356444,-0.58486049,-0.55423504,1.7371324,-0.58357465,-0.58486049,-0.55423504,1.7437146,-0.58356444,-0.58486049,-0.55423504,1.746868,-0.58356444,-0.58486049,-0.55423504,1.734775,-0.58356444,-0.58486049,-0.55423504,1.7478069,-0.58357465,-0.58486049,-0.55423504,1.7427145,-0.58357465,-0.58486049,-0.55423504,1.7361017,-0.58356444,-0.58486049,-0.55423504,1.7417553,-0.58356444,-0.58486049,-0.55423504,1.7421227,-0.58356444,-0.58486049,-0.55423504,1.7420818,-0.58356444,-0.58486049,-0.55423504,1.7396428,-0.58357465,-0.58486049,-0.55423504,1.7402347,-0.58357465,-0.58486049,-0.55423504,1.7401633,-0.58357465,-0.58486049,-0.55423504,1.732387,-0.58356444,-0.58486049,-0.55423504,1.7426941,-0.58356444,-0.58486049,-0.55423504,1.7449188,-0.58357465,-0.58486049,-0.55423504,1.7368364,-0.58356444,-0.58486049,-0.55423504,1.7470619,-0.58356444,-0.58486049,-0.55423504,1.7379896,-0.58357465,-0.58486049,-0.55423504,1.7374283,-0.58356444,-0.58486049,-0.55423504,1.7374181,-0.58356444,-0.58486049,-0.55423504,1.7279376,-0.58356444,-0.58486049,-0.55423504,1.7398775,-0.58357465,-0.58486049,-0.55423504,1.7346729,-0.58356444,-0.58486049,-0.55423504,1.7318563,-0.58356444,-0.58486049,-0.55423504,1.736418,-0.58357465,-0.58486049,-0.55423504,1.7341423,-0.58356444,-0.58486049,-0.55423504,1.73602,-0.58356444,-0.58486049,-0.55423504,1.730693,-0.58356444,-0.58486049,-0.55423504,1.7315502,-0.58356444,-0.58486049,-0.55423504,1.7295194,-0.58356444,-0.58486049,-0.55423504,1.7334585,-0.58357465,-0.58486049,-0.55423504,1.7319176,-0.58356444,-0.58486049,-0.55423504,1.7337443,-0.58356444,-0.58486049,-0.55423504,1.7451229,-0.58357465,-0.58486049,-0.55423504,1.7451229,-0.58357465,-0.58486049,-0.55423504,1.7451229,-0.58357465,-0.58486049,-0.55423504,1.7451229,-0.58357465,-0.58486049,-0.55423504,1.7451229,-0.58357465,-0.58486049,-0.55423504,1.7451229,-0.58357465:9
-0.59312151,-0.59312151,1.7428417,-0.59312151,-0.59312151,-0.59312151,1.743558,-0.59312151,-0.59312151,-0.59312151,1.7434975,-0.59312151,-0.59312151,-0.59312151,1.7453841,-0.59312151,-0.59312151,-0.59312151,1.7449402,-0.59312151,-0.59312151,-0.59312151,1.7451319,-0.59312151,-0.59312151,-0.59312151,1.7433462,-0.59312151,-0.60565165,-0.52419564,1.7470184,-0.59258681,-0.60356329,-0.53046071,1.7475128,-0.59263725,-0.60356329,-0.53046071,1.7484208,-0.59262716,-0.60356329,-0.53046071,1.7457574,-0.59262716,-0.60356329,-0.53046071,1.7463728,-0.59262716,-0.60356329,-0.53046071,1.7462517,-0.59262716,-0.60356329,-0.53046071,1.7480374,-0.59263725,-0.60356329,-0.53046071,1.7495406,-0.59263725,-0.60356329,-0.53046071,1.7492581,-0.59262716,-0.60356329,-0.53046071,1.7475632,-0.59263725,-0.60356329,-0.53046071,1.7470588,-0.59262716,-0.60356329,-0.53046071,1.7467259,-0.59263725,-0.60356329,-0.53046071,1.7493893,-0.59263725,-0.60356329,-0.53046071,1.7477448,-0.59263725,-0.60356329,-0.53046071,1.7469478,-0.59263725,-0.60356329,-0.53046071,1.747422,-0.59263725,-0.60356329,-0.53046071,1.7477953,-0.59263725,-0.60356329,-0.53046071,1.7488848,-0.59262716,-0.60356329,-0.53046071,1.747987,-0.59263725,-0.60356329,-0.53046071,1.7463829,-0.59262716,-0.60356329,-0.53046071,1.7464837,-0.59263725,-0.60356329,-0.53046071,1.7468469,-0.59263725,-0.60356329,-0.53046071,1.7459793,-0.59262716,-0.60356329,-0.53046071,1.7468469,-0.59263725,-0.60356329,-0.53046071,1.7485923,-0.59262716,-0.60356329,-0.53046071,1.7486528,-0.59263725,-0.60356329,-0.53046071,1.7486831,-0.59262716,-0.60356329,-0.53046071,1.7449604,-0.59263725,-0.60356329,-0.53046071,1.7454446,-0.59262716,-0.60356329,-0.53046071,1.7428518,-0.59262716,-0.60356329,-0.53046071,1.7422364,-0.59262716,-0.60356329,-0.53046071,1.743215,-0.59263725,-0.60356329,-0.53046071,1.7443853,-0.59262716,-0.60356329,-0.53046071,1.7452227,-0.59262716,-0.60356329,-0.53046071,1.7466048,-0.59262716,-0.60356329,-0.53046071,1.7456666,-0.59262716,-0.60356329,-0.53046071,1.7459188,-0.59262716,-0.60356329,-0.53046071,1.7472505,-0.59262716,-0.60356329,-0.53046071,1.7494902,-0.59262716,-0.60356329,-0.53046071,1.748673,-0.59262716,-0.60356329,-0.53046071,1.7471799,-0.59262716,-0.60356329,-0.53046071,1.7509228,-0.59262716,-0.60356329,-0.53046071,1.7498029,-0.59262716,-0.60356329,-0.53046071,1.7485317,-0.59262716,-0.60356329,-0.53046071,1.7485923,-0.59262716,-0.60356329,-0.53046071,1.7486932,-0.59263725,-0.60356329,-0.53046071,1.7501964,-0.59263725,-0.60356329,-0.53046071,1.7494498,-0.59263725,-0.60356329,-0.53046071,1.7471597,-0.59262716,-0.60356329,-0.53046071,1.747422,-0.59262716,-0.60356329,-0.53046071,1.7474422,-0.59262716,-0.60356329,-0.53046071,1.7453235,-0.59262716,-0.60356329,-0.53046071,1.7451722,-0.59263725,-0.60356329,-0.53046071,1.7412175,-0.59262716,-0.60356329,-0.53046071,1.7422768,-0.59262716,-0.60356329,-0.53046071,1.7404204,-0.59261707,-0.60356329,-0.53046071,1.7414596,-0.59262716,-0.60356329,-0.53046071,1.7416008,-0.59262716,-0.60356329,-0.53046071,1.7380698,-0.59261707,-0.60356329,-0.53046071,1.740602,-0.59261707,-0.60356329,-0.53046071,1.7369701,-0.59261707,-0.60356329,-0.53046071,1.7371013,-0.59261707,-0.60356329,-0.53150994,1.7369701,-0.59262716,-0.60356329,-0.53046071,1.7357595,-0.59261707,-0.60356329,-0.53046071,1.73696,-0.59262716,-0.60356329,-0.53046071,1.7364959,-0.59262716,-0.60356329,-0.53046071,1.7363144,-0.59262716,-0.60356329,-0.53046071,1.7374846,-0.59262716,-0.60356329,-0.53046071,1.7371921,-0.59262716,-0.60356329,-0.53046071,1.7356989,-0.59262716,-0.60356329,-0.53046071,1.7361933,-0.59262716,-0.60356329,-0.53046071,1.7358604,-0.59262716,-0.60356329,-0.53046071,1.7373333,-0.59262716,-0.60356329,-0.53046071,1.737303,-0.59262716,-0.60356329,-0.53046071,1.7380597,-0.59262716,-0.60356329,-0.53046071,1.7372627,-0.59262716,-0.60356329,-0.53046071,1.7377469,-0.59262716,-0.60356329,-0.53046071,1.7371315,-0.59262716,-0.60356329,-0.53046071,1.7364455,-0.59262716,-0.60356329,-0.53046071,1.7373938,-0.59262716,-0.60356329,-0.53046071,1.7364859,-0.59262716,-0.60356329,-0.53150994,1.7367784,-0.59262716,-0.60356329,-0.53046071,1.7365565,-0.59262716,-0.60251407,-0.53150994,1.7368087,-0.59262716,-0.60356329,-0.53046071,1.7379185,-0.59262716,-0.60356329,-0.53046071,1.7383624,-0.59262716,-0.60356329,-0.53046071,1.7389172,-0.59262716,-0.60356329,-0.53150994,1.7408946,-0.59262716,-0.60356329,-0.53046071,1.7429224,-0.59262716,-0.60356329,-0.53150994,1.7391392,-0.59262716,-0.60356329,-0.53046071,1.7412175,-0.59262716,-0.60356329,-0.53046071,1.739916,-0.59262716,-0.60356329,-0.53150994,1.740592,-0.59262716,-0.60356329,-0.53046071,1.7389576,-0.59262716,-0.60356329,-0.53150994,1.7374645,-0.59262716,-0.60356329,-0.53150994,1.7390686,-0.59263725,-0.60356329,-0.53046071,1.7360218,-0.59262716,-0.60356329,-0.53046071,1.7360218,-0.59262716,-0.60251407,-0.53150994,1.7354669,-0.59262716,-0.60356329,-0.53046071,1.7364859,-0.59262716,-0.60251407,-0.53046071,1.7318652,-0.59262716,-0.60251407,-0.53150994,1.7296155,-0.59263725,-0.60251407,-0.53046071,1.7307757,-0.59262716,-0.60356329,-0.53150994,1.732178,-0.59263725,-0.60251407,-0.53046071,1.7332272,-0.59263725,-0.60251407,-0.53150994,1.7270832,-0.59263725,-0.60251407,-0.53150994,1.7266393,-0.59263725,-0.60251407,-0.53150994,1.7269218,-0.59263725,-0.60356329,-0.53150994,1.7283746,-0.59263725,-0.60251407,-0.53046071,1.7291716,-0.59263725,-0.60251407,-0.53046071,1.7295751,-0.59263725,-0.60251407,-0.53150994,1.7297466,-0.59263725,-0.60251407,-0.53150994,1.7293027,-0.59263725,-0.60356329,-0.53150994,1.7289093,-0.59263725,-0.60251407,-0.53046071,1.7294843,-0.59263725,-0.60356329,-0.53046071,1.7289597,-0.59263725,-0.60251407,-0.53150994,1.7307151,-0.59263725,-0.60251407,-0.53150994,1.7304327,-0.59263725,-0.60251407,-0.53150994,1.7318148,-0.59263725,-0.60356329,-0.53150994,1.7309472,-0.59263725,-0.60356329,-0.53150994,1.7314415,-0.59263725,-0.60356329,-0.53150994,1.7324907,-0.59263725,-0.60251407,-0.53150994,1.7332676,-0.59263725,-0.60251407,-0.53150994,1.7354366,-0.59263725,-0.60356329,-0.53150994,1.7258019,-0.59263725,-0.60251407,-0.53150994,1.725812,-0.59263725,-0.60251407,-0.53150994,1.7256002,-0.59263725,-0.60356329,-0.53150994,1.7250957,-0.59263725,-0.60356329,-0.53150994,1.7247023,-0.59263725,-0.60251407,-0.53150994,1.7241474,-0.59263725,-0.60356329,-0.53150994,1.7232495,-0.59263725,-0.60356329,-0.53150994,1.7224424,-0.59263725,-0.60251407,-0.53150994,1.724218,-0.59263725,-0.60356329,-0.53150994,1.7242786,-0.59262716,-0.60356329,-0.53150994,1.7243492,-0.59263725,-0.60356329,-0.53150994,1.7233201,-0.59263725,-0.60356329,-0.53150994,1.7240364,-0.59263725,-0.60356329,-0.53150994,1.724218,-0.59262716,-0.60356329,-0.53150994,1.7229973,-0.59263725,-0.60356329,-0.53150994,1.7221801,-0.59262716,-0.60251407,-0.53150994,1.7223516,-0.59263725,-0.60356329,-0.53150994,1.7219884,-0.59263725,-0.60251407,-0.53150994,1.7235824,-0.59263725,-0.60251407,-0.53150994,1.722392,-0.59263725,-0.60251407,-0.53150994,1.7230376,-0.59263725,-0.60251407,-0.53150994,1.7242987,-0.59263725,-0.60356329,-0.53150994,1.7215647,-0.59263725,-0.60251407,-0.53150994,1.7216353,-0.59263725,-0.60356329,-0.53150994,1.7218371,-0.59263725,-0.60251407,-0.53150994,1.7220288,-0.59263725,-0.60251407,-0.53150994,1.7225029,-0.59263725,-0.60251407,-0.53150994,1.7218371,-0.59263725,-0.60251407,-0.53150994,1.7218068,-0.59263725,-0.60251407,-0.53150994,1.7223314,-0.59263725,-0.60251407,-0.53150994,1.7218169,-0.59263725,-0.60251407,-0.53150994,1.7227552,-0.59263725,-0.60251407,-0.53150994,1.7219279,-0.59263725,-0.60251407,-0.53150994,1.7239658,-0.59263725,-0.60251407,-0.53150994,1.7250655,-0.59263725,-0.60251407,-0.53150994,1.724894,-0.59263725,-0.60251407,-0.53150994,1.7279105,-0.59263725,-0.60251407,-0.53150994,1.7294944,-0.59263725,-0.60251407,-0.53150994,1.7282535,-0.59263725,-0.60251407,-0.53150994,1.7286066,-0.59263725,-0.60251407,-0.53150994,1.7285461,-0.59263725,-0.60251407,-0.53150994,1.7281728,-0.59263725,-0.60251407,-0.53150994,1.7281022,-0.59263725,-0.60251407,-0.53150994,1.7280315,-0.59263725,-0.60251407,-0.53150994,1.7258322,-0.59263725,-0.60251407,-0.53150994,1.7281022,-0.59263725,-0.60251407,-0.53150994,1.7288588,-0.59263725,-0.60251407,-0.53150994,1.7290606,-0.59263725,-0.60251407,-0.53150994,1.725812,-0.59263725,-0.60251407,-0.53150994,1.72558,-0.59263725,-0.60251407,-0.53150994,1.7240263,-0.59263725,-0.60251407,-0.53150994,1.7258322,-0.59263725,-0.60251407,-0.53150994,1.725812,-0.59263725,-0.60251407,-0.53150994,1.7247931,-0.59263725,-0.60251407,-0.53150994,1.7251361,-0.59263725,-0.60251407,-0.53150994,1.7261954,-0.59263725,-0.60251407,-0.53254907,1.7274868,-0.59263725,-0.60251407,-0.53254907,1.7276078,-0.59263725,-0.60251407,-0.53150994,1.7303116,-0.59263725,-0.60251407,-0.53150994,1.7305234,-0.59264734,-0.60251407,-0.53150994,1.731835,-0.59263725,-0.60251407,-0.53150994,1.7308059,-0.59263725,-0.60251407,-0.53150994,1.7333281,-0.59263725,-0.60251407,-0.53150994,1.7315121,-0.59263725,-0.60251407,-0.53150994,1.731381,-0.59263725,-0.60251407,-0.53254907,1.7315525,-0.59263725,-0.60251407,-0.53150994,1.7321578,-0.59263725,-0.60251407,-0.53150994,1.732975,-0.59263725,-0.60251407,-0.53150994,1.7361731,-0.59263725,-0.60251407,-0.53254907,1.7349726,-0.59263725,-0.60251407,-0.53150994,1.7350533,-0.59263725,-0.60251407,-0.53254907,1.7320771,-0.59263725,-0.60251407,-0.53254907,1.7307353,-0.59263725,-0.60251407,-0.53254907,1.7305537,-0.59263725,-0.60251407,-0.53254907,1.7296155,-0.59263725,-0.60251407,-0.53254907,1.7294944,-0.59263725,-0.60251407,-0.53150994,1.7277289,-0.59263725,-0.60251407,-0.53254907,1.7246821,-0.59263725,-0.60251407,-0.53254907,1.7248032,-0.59263725,-0.60251407,-0.53254907,1.7258927,-0.59263725,-0.60251407,-0.53254907,1.7255296,-0.59263725,-0.60251407,-0.53254907,1.7246417,-0.59263725,-0.60251407,-0.53254907,1.7239658,-0.59263725,-0.60251407,-0.53254907,1.7248133,-0.59263725,-0.60251407,-0.53254907,1.7237439,-0.59263725,-0.60251407,-0.53254907,1.7235723,-0.59263725,-0.60251407,-0.53254907,1.7239456,-0.59263725,-0.60251407,-0.53254907,1.721373,-0.59263725,-0.60251407,-0.53254907,1.7202633,-0.59263725,-0.60251407,-0.53254907,1.7214941,-0.59263725,-0.60251407,-0.53254907,1.7210502,-0.59264734,-0.60251407,-0.53254907,1.7188508,-0.59263725,-0.60251407,-0.53254907,1.7165405,-0.59264734,-0.60251407,-0.53254907,1.7158545,-0.59264734,-0.60251407,-0.53254907,1.7171055,-0.59264734,-0.60251407,-0.53254907,1.7178622,-0.59264734,-0.60251407,-0.53254907,1.7177411,-0.59264734,-0.60251407,-0.53254907,1.7190526,-0.59264734,-0.60251407,-0.53254907,1.7182859,-0.59264734,-0.60251407,-0.53254907,1.7184977,-0.59264734,-0.60251407,-0.53254907,1.7182354,-0.59264734,-0.60251407,-0.53254907,1.7189416,-0.59264734,-0.60251407,-0.53254907,1.7192544,-0.59264734,-0.60251407,-0.53254907,1.7190526,-0.59264734,-0.60251407,-0.53254907,1.7174586,-0.59264734,-0.60251407,-0.53254907,1.7168936,-0.59264734,-0.60251407,-0.53254907,1.7180135,-0.59264734,-0.60251407,-0.53254907,1.716702,-0.59264734,-0.60251407,-0.53254907,1.7166313,-0.59264734,-0.60251407,-0.53254907,1.7170954,-0.59264734,-0.60251407,-0.53254907,1.7166616,-0.59264734,-0.60251407,-0.53359829,1.7168432,-0.59264734,-0.60251407,-0.53254907,1.717277,-0.59264734,-0.60251407,-0.53254907,1.7182556,-0.59264734,-0.60251407,-0.53254907,1.7174183,-0.59264734,-0.60251407,-0.53359829,1.718871,-0.59264734,-0.60251407,-0.53359829,1.7178823,-0.59264734,-0.60251407,-0.53359829,1.7170147,-0.59264734,-0.60251407,-0.53359829,1.7168028,-0.59264734,-0.60251407,-0.53359829,1.7176705,-0.59264734,-0.60251407,-0.53359829,1.7162278,-0.59264734,-0.60251407,-0.53359829,1.7177108,-0.59264734,-0.60251407,-0.53359829,1.7204348,-0.59264734,-0.60251407,-0.53359829,1.7189114,-0.59264734,-0.60251407,-0.53359829,1.7171055,-0.59264734,-0.60251407,-0.53359829,1.7174082,-0.59264734,-0.60251407,-0.53359829,1.7179429,-0.59264734,-0.60251407,-0.53359829,1.7153299,-0.59264734,-0.60251407,-0.53359829,1.7164397,-0.59265743,-0.60251407,-0.53359829,1.7173073,-0.59265743,-0.60251407,-0.53359829,1.7148154,-0.59265743,-0.60251407,-0.53359829,1.7168634,-0.59265743,-0.60251407,-0.53359829,1.7164699,-0.59265743,-0.60251407,-0.53359829,1.7163589,-0.59265743,-0.60251407,-0.53359829,1.7196075,-0.59265743,-0.60147493,-0.53359829,1.7212217,-0.59265743,-0.60147493,-0.53463743,1.7194461,-0.59266752,-0.60147493,-0.53463743,1.7207374,-0.59265743,-0.60147493,-0.53463743,1.7215445,-0.59266752,-0.60147493,-0.53568665,1.720919,-0.59266752,-0.60147493,-0.53568665,1.7190829,-0.5926776,-0.60147493,-0.53568665,1.7180538,-0.5926776,-0.60147493,-0.53672579,1.7195571,-0.5926776,-0.60147493,-0.53672579,1.7205861,-0.59268769,-0.60147493,-0.53672579,1.7235017,-0.59268769,-0.60042571,-0.53777501,1.7228359,-0.59268769,-0.60042571,-0.53881414,1.7186592,-0.59269778,-0.60042571,-0.53881414,1.7223214,-0.59269778,-0.60042571,-0.53881414,1.7189114,-0.59269778,-0.60042571,-0.53881414,1.7187802,-0.59270787,-0.60042571,-0.53986336,1.7171055,-0.59270787,-0.60042571,-0.53986336,1.7250554,-0.59270787,-0.60042571,-0.53986336,1.725469,-0.59270787,-0.60042571,-0.5409025,1.7236732,-0.59271796,-0.60042571,-0.5409025,1.7225332,-0.59271796,-0.60042571,-0.53986336,1.7224323,-0.59270787,-0.59938658,-0.54195172,1.7250251,-0.59272805,-0.59938658,-0.54195172,1.727063,-0.59272805,-0.59938658,-0.54195172,1.728193,-0.59273814,-0.59938658,-0.54300094,1.7289395,-0.59273814,-0.59938658,-0.54300094,1.7296558,-0.59273814,-0.59938658,-0.54300094,1.7283039,-0.59273814,-0.59938658,-0.54404008,1.7296962,-0.59274823,-0.59938658,-0.54404008,1.7326824,-0.59274823,-0.59938658,-0.54404008,1.731613,-0.59274823,-0.59938658,-0.54404008,1.7323697,-0.59274823,-0.59833735,-0.5450893,1.7315828,-0.59275831,-0.59833735,-0.54612843,1.73127,-0.59275831,-0.59833735,-0.54612843,1.7308967,-0.59275831,-0.59833735,-0.54612843,1.7307555,-0.5927684,-0.59833735,-0.54717766,1.7312397,-0.5927684,-0.59833735,-0.54717766,1.7325715,-0.5927684,-0.59833735,-0.54717766,1.7313406,-0.59277849,-0.59833735,-0.54821679,1.7309573,-0.59277849,-0.59833735,-0.54821679,1.7311691,-0.59277849,-0.59833735,-0.54821679,1.730584,-0.59278858,-0.59729822,-0.54926601,1.7287781,-0.59278858,-0.59729822,-0.54926601,1.7300896,-0.59278858,-0.59729822,-0.55030515,1.7297164,-0.59279867,-0.59729822,-0.55030515,1.7314718,-0.59279867,-0.59729822,-0.55030515,1.7315121,-0.59279867,-0.59729822,-0.55135437,1.7315021,-0.59280876,-0.59729822,-0.55135437,1.7320065,-0.59280876,-0.59729822,-0.55135437,1.7333886,-0.59280876,-0.59729822,-0.55135437,1.7351642,-0.59280876,-0.59729822,-0.55239351,1.7343571,-0.59281885,-0.59729822,-0.55239351,1.7343773,-0.59281885,-0.59729822,-0.55344273,1.7341352,-0.59281885,-0.59833735,-0.54821679,1.735245,-0.59278858,-0.59729822,-0.55030515,1.733429,-0.59279867,-0.59729822,-0.55030515,1.7329952,-0.59279867,-0.59729822,-0.55030515,1.7351945,-0.59280876,-0.59729822,-0.55135437,1.7351138,-0.59280876,-0.59729822,-0.55135437,1.7363043,-0.59280876,-0.59729822,-0.55135437,1.7362336,-0.59281885,-0.59729822,-0.55135437,1.7365968,-0.59280876,-0.59729822,-0.55239351,1.7348515,-0.59281885,-0.59729822,-0.55239351,1.7368793,-0.59281885,-0.596249,-0.55239351,1.7370004,-0.59282893,-0.596249,-0.55344273,1.735709,-0.59282893,-0.596249,-0.55344273,1.7342764,-0.59282893,-0.596249,-0.55344273,1.734004,-0.59282893,-0.596249,-0.55344273,1.734226,-0.59282893,-0.596249,-0.55448186,1.7329346,-0.59283902,-0.59833735,-0.54717766,1.7345287,-0.59277849,-0.596249,-0.55448186,1.733429,-0.59283902,-0.596249,-0.55448186,1.7350331,-0.59283902,-0.596249,-0.55448186,1.7343067,-0.59283902,-0.596249,-0.55448186,1.7305134,-0.59283902,-0.596249,-0.55553108,1.7308261,-0.59284911,-0.596249,-0.55553108,1.7305033,-0.59284911,-0.596249,-0.55553108,1.7324807,-0.59284911,-0.596249,-0.55553108,1.7331162,-0.59284911,-0.596249,-0.55657022,1.7343571,-0.59284911,-0.596249,-0.55657022,1.7342361,-0.59284911,-0.596249,-0.55657022,1.7334794,-0.5928592,-0.59520986,-0.55657022,1.734337,-0.5928592,-0.59520986,-0.5597078,1.7330557,-0.59287938,-0.59520986,-0.5597078,1.7374645,-0.59287938,-0.59520986,-0.56074693,1.7341251,-0.59288947,-0.59520986,-0.56074693,1.7342966,-0.59288947,-0.59520986,-0.56074693,1.7352349,-0.59288947,-0.59520986,-0.56179615,1.7354467,-0.59288947,-0.59520986,-0.56074693,1.7337518,-0.59288947,-0.59416064,-0.56179615,1.7349625,-0.59289956,-0.59520986,-0.56179615,1.7331667,-0.59289956,-0.596249,-0.55553108,1.7351037,-0.59284911,-0.596249,-0.55553108,1.7351037,-0.59284911,-0.596249,-0.55553108,1.7351037,-0.59284911,-0.596249,-0.55553108,1.7351037,-0.59284911,-0.596249,-0.55553108,1.7351037,-0.59284911,-0.596249,-0.55553108,1.7351037,-0.59284911,-0.596249,-0.55553108,1.7351037,-0.59284911,-0.596249,-0.55553108,1.7351037,-0.59284911:9
-0.58988253,-0.58988253,1.7390046,-0.58988253,-0.58988253,-0.58988253,1.7371011,-0.58988253,-0.58988253,-0.58988253,1.7377118,-0.58988253,-0.58988253,-0.58988253,1.7371825,-0.58988253,-0.58988253,-0.58566838,1.7386687,-0.58988253,-0.6004179,-0.52771875,1.7349228,-0.58939394,-0.59831083,-0.53614705,1.7342815,-0.58946519,-0.59831083,-0.53614705,1.731869,-0.58946519,-0.59831083,-0.53614705,1.735961,-0.58946519,-0.59831083,-0.53614705,1.733915,-0.58946519,-0.59935928,-0.5319329,1.7373352,-0.58942447,-0.59831083,-0.53614705,1.7350144,-0.58946519,-0.59831083,-0.53614705,1.7318181,-0.58946519,-0.59831083,-0.53508842,1.7360425,-0.58944483,-0.59831083,-0.53614705,1.7407452,-0.58946519,-0.59831083,-0.53614705,1.7377526,-0.58946519,-0.59831083,-0.53614705,1.7348922,-0.58946519,-0.59831083,-0.53614705,1.7407758,-0.58946519,-0.59831083,-0.53508842,1.7419973,-0.58945501,-0.59831083,-0.53614705,1.7395237,-0.58946519,-0.59831083,-0.53614705,1.7401039,-0.58946519,-0.59831083,-0.53508842,1.740959,-0.58945501,-0.59831083,-0.53614705,1.7441145,-0.58946519,-0.59831083,-0.53614705,1.7434529,-0.58946519,-0.59831083,-0.53508842,1.7383531,-0.58945501,-0.59831083,-0.53614705,1.7372945,-0.58946519,-0.59831083,-0.53614705,1.7357269,-0.58946519,-0.59831083,-0.53614705,1.743402,-0.58946519,-0.59831083,-0.53614705,1.7413051,-0.58945501,-0.59831083,-0.53614705,1.7383226,-0.58946519,-0.59831083,-0.53614705,1.7448678,-0.58946519,-0.59831083,-0.53614705,1.7415494,-0.58946519,-0.59831083,-0.53614705,1.7407045,-0.58945501,-0.59831083,-0.53614705,1.742893,-0.58945501,-0.59831083,-0.53614705,1.7436055,-0.58946519,-0.59831083,-0.53614705,1.7393914,-0.58946519,-0.59831083,-0.53614705,1.7405518,-0.58945501,-0.59831083,-0.53614705,1.7407656,-0.58945501,-0.59831083,-0.53614705,1.7386789,-0.58945501,-0.59831083,-0.53614705,1.7396968,-0.58945501,-0.59831083,-0.53508842,1.7393914,-0.58944483,-0.59831083,-0.53614705,1.7431577,-0.58945501,-0.59831083,-0.53614705,1.7432187,-0.58945501,-0.59831083,-0.53614705,1.7422212,-0.58946519,-0.59831083,-0.53614705,1.741071,-0.58945501,-0.59831083,-0.53614705,1.7415188,-0.58945501,-0.59831083,-0.53614705,1.7404093,-0.58945501,-0.59831083,-0.53614705,1.7423739,-0.58945501,-0.59831083,-0.53614705,1.7395746,-0.58946519,-0.59831083,-0.53508842,1.739086,-0.58945501,-0.59831083,-0.53614705,1.7418242,-0.58945501,-0.59831083,-0.53614705,1.7401447,-0.58945501,-0.59831083,-0.53614705,1.742038,-0.58945501,-0.59831083,-0.53614705,1.7460587,-0.58945501,-0.59831083,-0.53614705,1.7439211,-0.58945501,-0.59831083,-0.53614705,1.7439924,-0.58945501,-0.59831083,-0.53614705,1.7461401,-0.58945501,-0.59831083,-0.53614705,1.744542,-0.58945501,-0.59831083,-0.53614705,1.7455396,-0.58945501,-0.59831083,-0.53614705,1.7443995,-0.58945501,-0.59831083,-0.53614705,1.7461401,-0.58945501,-0.59831083,-0.53614705,1.7406536,-0.58945501,-0.59831083,-0.53614705,1.7470868,-0.58946519,-0.59831083,-0.53508842,1.7416003,-0.58945501,-0.59831083,-0.53614705,1.7405213,-0.58945501,-0.59831083,-0.53614705,1.743463,-0.58945501,-0.59831083,-0.53614705,1.7405824,-0.58945501,-0.59831083,-0.53614705,1.7408165,-0.58945501,-0.59831083,-0.53614705,1.7422924,-0.58945501,-0.59831083,-0.53614705,1.7427709,-0.58945501,-0.59831083,-0.53614705,1.7407656,-0.58945501,-0.59831083,-0.53508842,1.7443283,-0.58945501,-0.59831083,-0.53614705,1.7434223,-0.58945501,-0.59831083,-0.53614705,1.7389333,-0.58945501,-0.59831083,-0.53614705,1.7439007,-0.58945501,-0.59831083,-0.53614705,1.7412338,-0.58945501,-0.59831083,-0.53614705,1.7370095,-0.58945501,-0.59831083,-0.53614705,1.7381801,-0.58945501,-0.59831083,-0.53614705,1.7373352,-0.58945501,-0.59831083,-0.53508842,1.739483,-0.58945501,-0.59831083,-0.53614705,1.7417835,-0.58945501,-0.59831083,-0.53508842,1.7433511,-0.58945501,-0.59831083,-0.53614705,1.7419565,-0.58945501,-0.59831083,-0.53614705,1.7413051,-0.58945501,-0.59831083,-0.53508842,1.7396153,-0.58945501,-0.59831083,-0.53614705,1.7386992,-0.58945501,-0.59831083,-0.53508842,1.7415188,-0.58945501,-0.59831083,-0.53614705,1.7398087,-0.58945501,-0.59831083,-0.53614705,1.742496,-0.58945501,-0.59831083,-0.53508842,1.7444199,-0.58945501,-0.59831083,-0.53614705,1.7440941,-0.58945501,-0.59831083,-0.53614705,1.7416206,-0.58945501,-0.59831083,-0.53508842,1.7434121,-0.58945501,-0.59831083,-0.53614705,1.7385465,-0.58945501,-0.59831083,-0.53508842,1.7412949,-0.58945501,-0.59831083,-0.53508842,1.7415494,-0.58944483,-0.59831083,-0.53508842,1.7434325,-0.58944483,-0.59831083,-0.53614705,1.741753,-0.58944483,-0.59831083,-0.53508842,1.7399614,-0.58944483,-0.59831083,-0.53614705,1.7397782,-0.58944483,-0.59831083,-0.53508842,1.7396357,-0.58944483,-0.59831083,-0.53508842,1.737549,-0.58944483,-0.59831083,-0.53614705,1.7373149,-0.58944483,-0.59831083,-0.53508842,1.736358,-0.58944483,-0.59831083,-0.53508842,1.741641,-0.58944483,-0.59831083,-0.53508842,1.7411727,-0.58944483,-0.59831083,-0.53508842,1.7425266,-0.58944483,-0.59831083,-0.53508842,1.7417326,-0.58944483,-0.59831083,-0.53508842,1.7424044,-0.58944483,-0.59831083,-0.53508842,1.7421499,-0.58944483,-0.59831083,-0.53508842,1.7436972,-0.58943465,-0.59831083,-0.53508842,1.7445318,-0.58944483,-0.59831083,-0.53614705,1.7432595,-0.58944483,-0.59831083,-0.53508842,1.7432086,-0.58944483,-0.59831083,-0.53508842,1.7452851,-0.58944483,-0.59831083,-0.53508842,1.7457126,-0.58944483,-0.59831083,-0.53508842,1.7448372,-0.58944483,-0.59831083,-0.53508842,1.745845,-0.58944483,-0.59831083,-0.53508842,1.7453869,-0.58944483,-0.59831083,-0.53508842,1.7465677,-0.58944483,-0.59831083,-0.53508842,1.747209,-0.58944483,-0.59831083,-0.53508842,1.7462114,-0.58944483,-0.59831083,-0.53508842,1.7448983,-0.58944483,-0.59831083,-0.53508842,1.7460384,-0.58944483,-0.59831083,-0.53508842,1.7467,-0.58944483,-0.59831083,-0.53508842,1.7460791,-0.58944483,-0.59831083,-0.53508842,1.7421296,-0.58944483,-0.59831083,-0.53508842,1.7453462,-0.58944483,-0.59831083,-0.53508842,1.7426589,-0.58944483,-0.59831083,-0.53508842,1.7437582,-0.58943465,-0.59935928,-0.53403997,1.7408674,-0.58943465,-0.59935928,-0.53508842,1.742781,-0.58943465,-0.59935928,-0.53508842,1.7420074,-0.58944483,-0.59935928,-0.53508842,1.7431271,-0.58944483,-0.59831083,-0.53508842,1.7411931,-0.58944483,-0.59831083,-0.53508842,1.7411524,-0.58943465,-0.59831083,-0.53508842,1.7391675,-0.58943465,-0.59831083,-0.53508842,1.7415087,-0.58943465,-0.59831083,-0.53508842,1.7422823,-0.58943465,-0.59831083,-0.53614705,1.7418038,-0.58944483,-0.59831083,-0.53614705,1.7391267,-0.58944483,-0.59831083,-0.53614705,1.7373556,-0.58944483,-0.59831083,-0.53508842,1.7381597,-0.58943465,-0.59831083,-0.53508842,1.7363987,-0.58944483,-0.59831083,-0.53508842,1.7370197,-0.58943465,-0.59831083,-0.53614705,1.7336198,-0.58944483,-0.59831083,-0.53614705,1.7314619,-0.58944483,-0.59935928,-0.53508842,1.735961,-0.58943465,-0.59831083,-0.53614705,1.7350449,-0.58944483,-0.59831083,-0.53614705,1.7358898,-0.58944483,-0.59831083,-0.53614705,1.7358084,-0.58944483,-0.59831083,-0.53614705,1.7374472,-0.58944483,-0.59831083,-0.53614705,1.7369993,-0.58944483,-0.59831083,-0.53508842,1.7384346,-0.58944483,-0.59831083,-0.53508842,1.7326325,-0.58943465,-0.59831083,-0.53614705,1.7367652,-0.58944483,-0.59831083,-0.53614705,1.733569,-0.58944483,-0.59831083,-0.53614705,1.7362257,-0.58944483,-0.59831083,-0.53614705,1.7343426,-0.58944483,-0.59831083,-0.5371955,1.7314212,-0.58945501,-0.59831083,-0.53614705,1.7324391,-0.58945501,-0.59831083,-0.5371955,1.7312888,-0.58945501,-0.59831083,-0.5371955,1.7282656,-0.58945501,-0.5972522,-0.5371955,1.7298332,-0.58946519,-0.59831083,-0.5371955,1.7283064,-0.58946519,-0.5972522,-0.5371955,1.7260771,-0.58946519,-0.59831083,-0.5371955,1.7265861,-0.58945501,-0.5972522,-0.53825412,1.72908,-0.58946519,-0.5972522,-0.53825412,1.7306984,-0.58946519,-0.5972522,-0.53825412,1.7278687,-0.58947537,-0.5972522,-0.53825412,1.7284183,-0.58947537,-0.5972522,-0.53931275,1.7277363,-0.58947537,-0.5972522,-0.53931275,1.7284285,-0.58947537,-0.5972522,-0.53931275,1.7277669,-0.58947537,-0.5972522,-0.53931275,1.7275836,-0.58947537,-0.5972522,-0.53931275,1.731014,-0.58947537,-0.5972522,-0.53931275,1.7246826,-0.58948555,-0.5972522,-0.53825412,1.7293853,-0.58946519,-0.5972522,-0.53825412,1.7244383,-0.58946519,-0.5972522,-0.53931275,1.7233084,-0.58947537,-0.5972522,-0.5403612,1.7221684,-0.58948555,-0.5972522,-0.5403612,1.7190027,-0.58948555,-0.5972522,-0.54141982,1.7182494,-0.58949573,-0.5972522,-0.54141982,1.7186667,-0.58949573,-0.5972522,-0.5403612,1.7180153,-0.58948555,-0.59620376,-0.54141982,1.7195116,-0.58949573,-0.59620376,-0.54246827,1.7204888,-0.58950591,-0.59620376,-0.54246827,1.7212319,-0.58950591,-0.59620376,-0.54246827,1.7198781,-0.58950591,-0.59620376,-0.54246827,1.721639,-0.58950591,-0.59620376,-0.54246827,1.7242144,-0.58951609,-0.59620376,-0.54246827,1.7254053,-0.58951609,-0.59620376,-0.5435269,1.7222702,-0.58951609,-0.59620376,-0.5435269,1.7265759,-0.58951609,-0.59620376,-0.54246827,1.7269525,-0.58951609,-0.59620376,-0.5435269,1.7288255,-0.58951609,-0.59620376,-0.5435269,1.7185242,-0.58951609,-0.59620376,-0.54457535,1.7304745,-0.58952626,-0.59620376,-0.54457535,1.7287237,-0.58952626,-0.59620376,-0.54457535,1.7314619,-0.58952626,-0.59620376,-0.54457535,1.7322151,-0.58952626,-0.59514513,-0.54457535,1.7324493,-0.58953644,-0.59620376,-0.54457535,1.7321642,-0.58952626,-0.59620376,-0.54457535,1.7339049,-0.58953644,-0.59514513,-0.54563397,1.7329277,-0.58953644,-0.59514513,-0.54563397,1.7306883,-0.58953644,-0.59514513,-0.54563397,1.7316451,-0.58954662,-0.59514513,-0.54563397,1.7298943,-0.58953644,-0.59514513,-0.54563397,1.7323067,-0.58953644,-0.59514513,-0.54668242,1.7328055,-0.58954662,-0.59514513,-0.54668242,1.7329277,-0.58954662,-0.59514513,-0.54668242,1.7321541,-0.5895568,-0.59514513,-0.54668242,1.7307188,-0.58954662,-0.59514513,-0.54668242,1.7326834,-0.5895568,-0.59514513,-0.54668242,1.7316553,-0.5895568,-0.59514513,-0.54774105,1.7308308,-0.5895568,-0.59514513,-0.54774105,1.7300979,-0.5895568,-0.59514513,-0.54774105,1.729823,-0.5895568,-0.59514513,-0.54774105,1.7311565,-0.5895568,-0.59514513,-0.54774105,1.7310344,-0.58956698,-0.59514513,-0.54774105,1.7289171,-0.5895568,-0.59409668,-0.54878949,1.7312481,-0.58956698,-0.59409668,-0.54878949,1.7307188,-0.58956698,-0.59514513,-0.54878949,1.7286728,-0.58956698,-0.59409668,-0.54878949,1.7330804,-0.58956698,-0.59409668,-0.54878949,1.7314822,-0.58957716,-0.59514513,-0.54563397,1.7186667,-0.58953644,-0.59409668,-0.54984812,1.718453,-0.58957716,-0.59409668,-0.54878949,1.718626,-0.58956698,-0.59409668,-0.54984812,1.715501,-0.58957716,-0.59409668,-0.54984812,1.7169261,-0.58957716,-0.59409668,-0.54984812,1.713394,-0.58957716,-0.59409668,-0.54984812,1.7167327,-0.58957716,-0.59409668,-0.54984812,1.7180356,-0.58957716,-0.59409668,-0.54984812,1.7167734,-0.58957716,-0.59409668,-0.55089657,1.7167531,-0.58958734,-0.59409668,-0.55089657,1.7176183,-0.58958734,-0.59409668,-0.55089657,1.7178015,-0.58958734,-0.59409668,-0.55089657,1.7195218,-0.58958734,-0.59409668,-0.55089657,1.7197152,-0.58958734,-0.59409668,-0.55089657,1.7201936,-0.58958734,-0.59409668,-0.5519552,1.7197864,-0.58959752,-0.59409668,-0.5519552,1.7176997,-0.58959752,-0.59409668,-0.5519552,1.719023,-0.58959752,-0.59409668,-0.5519552,1.7133431,-0.58959752,-0.59409668,-0.5519552,1.720611,-0.58959752,-0.59409668,-0.5519552,1.7195218,-0.58959752,-0.59409668,-0.5519552,1.7147885,-0.58959752,-0.59409668,-0.5519552,1.7159387,-0.58959752,-0.59409668,-0.55300364,1.7157861,-0.58959752,-0.59409668,-0.55300364,1.7183614,-0.58959752,-0.59303805,-0.55300364,1.7125898,-0.5896077,-0.59303805,-0.55300364,1.7097906,-0.5896077,-0.59303805,-0.55300364,1.7123964,-0.5896077,-0.59303805,-0.55300364,1.7089559,-0.5896077,-0.59303805,-0.55300364,1.7167531,-0.5896077,-0.59303805,-0.55300364,1.7186159,-0.5896077,-0.59303805,-0.55406227,1.7170076,-0.5896077,-0.59303805,-0.55406227,1.7148394,-0.5896077,-0.59303805,-0.55406227,1.7171195,-0.5896077,-0.59303805,-0.55406227,1.7156334,-0.58961788,-0.59303805,-0.55406227,1.7153789,-0.58961788,-0.59303805,-0.55406227,1.7127018,-0.58961788,-0.59303805,-0.55406227,1.7118366,-0.58961788,-0.59303805,-0.55406227,1.713394,-0.58961788,-0.59303805,-0.55511072,1.7148089,-0.58961788,-0.59303805,-0.55511072,1.7136586,-0.58962806,-0.59303805,-0.55511072,1.7137095,-0.58962806,-0.59303805,-0.55511072,1.7112665,-0.58962806,-0.59303805,-0.55511072,1.7148903,-0.58962806,-0.59303805,-0.55511072,1.7148598,-0.58962806,-0.59303805,-0.55511072,1.7209367,-0.58962806,-0.59303805,-0.55616934,1.7198984,-0.58962806,-0.59303805,-0.55616934,1.7189009,-0.58962806,-0.59303805,-0.55616934,1.7159998,-0.58963823,-0.59303805,-0.55616934,1.7159489,-0.58962806,-0.59303805,-0.55616934,1.7150532,-0.58963823,-0.59198961,-0.55616934,1.7101265,-0.58963823,-0.59198961,-0.55616934,1.7125796,-0.58963823,-0.59198961,-0.55721779,1.7134245,-0.58963823,-0.59198961,-0.55721779,1.7126305,-0.58963823,-0.59198961,-0.55721779,1.7163968,-0.58963823,-0.59198961,-0.55721779,1.7135568,-0.58963823,-0.59198961,-0.55721779,1.7158268,-0.58964841,-0.59198961,-0.55721779,1.7160609,-0.58964841,-0.59198961,-0.55827642,1.7161322,-0.58964841,-0.59198961,-0.55827642,1.7160405,-0.58964841,-0.59198961,-0.55827642,1.7163357,-0.58964841,-0.59198961,-0.55827642,1.71544,-0.58964841,-0.59198961,-0.55827642,1.7142796,-0.58964841,-0.59198961,-0.55932487,1.7148699,-0.58965859,-0.59198961,-0.55932487,1.7155418,-0.58964841,-0.59198961,-0.55932487,1.7156639,-0.58965859,-0.59198961,-0.55932487,1.7276854,-0.58965859,-0.59198961,-0.55932487,1.7274106,-0.58965859,-0.59198961,-0.55932487,1.7285812,-0.58965859,-0.59198961,-0.55932487,1.7273597,-0.58965859,-0.59198961,-0.55932487,1.7280213,-0.58965859,-0.59093098,-0.56038349,1.725273,-0.58966877,-0.59093098,-0.56038349,1.7271968,-0.58966877,-0.59093098,-0.56038349,1.7266675,-0.58966877,-0.59093098,-0.56038349,1.7241431,-0.58966877,-0.59093098,-0.56038349,1.7269933,-0.58966877,-0.59093098,-0.56038349,1.72681,-0.58966877,-0.59093098,-0.56143194,1.7248455,-0.58967895,-0.59093098,-0.56143194,1.7274106,-0.58967895,-0.59093098,-0.56143194,1.726749,-0.58967895,-0.59093098,-0.56143194,1.7251305,-0.58967895,-0.59093098,-0.56143194,1.7260466,-0.58967895,-0.59093098,-0.56249057,1.7268609,-0.58967895,-0.59093098,-0.56143194,1.7275735,-0.58967895,-0.59093098,-0.56249057,1.728398,-0.58967895,-0.59093098,-0.56249057,1.7288764,-0.58968913,-0.59093098,-0.56249057,1.7274411,-0.58968913,-0.59093098,-0.56249057,1.7257616,-0.58968913,-0.59093098,-0.56249057,1.7284081,-0.58968913,-0.59093098,-0.56353901,1.7268507,-0.58968913,-0.59093098,-0.56353901,1.7280824,-0.58968913,-0.59093098,-0.56353901,1.7270849,-0.58968913,-0.59093098,-0.56353901,1.7316044,-0.58969931,-0.59093098,-0.56353901,1.7291614,-0.58969931,-0.59093098,-0.56353901,1.7290189,-0.58969931,-0.59093098,-0.56459764,1.7249167,-0.58969931,-0.59093098,-0.56459764,1.7266879,-0.58969931,-0.59093098,-0.56353901,1.7267388,-0.58968913,-0.59093098,-0.56459764,1.7278585,-0.58969931,-0.58988253,-0.56459764,1.7242856,-0.58969931,-0.58988253,-0.56459764,1.72567,-0.58969931,-0.58988253,-0.56459764,1.7252832,-0.58970949,-0.58988253,-0.56565627,1.7272376,-0.58970949,-0.58988253,-0.56565627,1.7279704,-0.58970949,-0.58988253,-0.56565627,1.7313906,-0.58970949,-0.58988253,-0.56565627,1.7331618,-0.58970949,-0.58988253,-0.56565627,1.7315739,-0.58970949,-0.58988253,-0.56670472,1.7330295,-0.58970949,-0.58988253,-0.56565627,1.7339049,-0.58970949,-0.58988253,-0.56670472,1.7360221,-0.58970949,-0.58988253,-0.56670472,1.7334977,-0.58971967,-0.58988253,-0.56670472,1.7342204,-0.58971967,-0.58988253,-0.56670472,1.7352485,-0.58970949,-0.58988253,-0.56670472,1.731299,-0.58971967,-0.58988253,-0.56670472,1.7332432,-0.58971967,-0.58988253,-0.56670472,1.7348821,-0.58971967,-0.58988253,-0.56670472,1.7325714,-0.58971967,-0.58988253,-0.56776334,1.7316451,-0.58971967,-0.58988253,-0.56670472,1.7337827,-0.58971967,-0.58988253,-0.56776334,1.7356251,-0.58971967,-0.58988253,-0.56776334,1.7359712,-0.58971967,-0.58988253,-0.56776334,1.7317062,-0.58971967,-0.58988253,-0.56776334,1.7293752,-0.58972985,-0.58988253,-0.56776334,1.7283573,-0.58972985,-0.58988253,-0.56776334,1.7291818,-0.58972985,-0.58988253,-0.56776334,1.7295177,-0.58972985,-0.58988253,-0.56881179,1.7300572,-0.58972985,-0.58988253,-0.56776334,1.7338641,-0.58972985,-0.58988253,-0.56881179,1.7321133,-0.58972985,-0.58988253,-0.56881179,1.7348922,-0.58972985,-0.58988253,-0.56881179,1.7359,-0.58972985,-0.58988253,-0.56881179,1.7359712,-0.58972985,-0.58988253,-0.56881179,1.7359712,-0.58972985,-0.58988253,-0.56881179,1.7359712,-0.58972985,-0.58988253,-0.56881179,1.7359712,-0.58972985,-0.58988253,-0.56881179,1.7359712,-0.58972985,-0.58988253,-0.56881179,1.7359712,-0.58972985,-0.58988253,-0.56881179,1.7359712,-0.58972985:9
-0.59752076,-0.54160795,1.7235041,-0.59205028,-0.59650917,-0.54160795,1.721972,-0.59205028,-0.59752076,-0.54160795,1.7244273,-0.59205028,-0.59752076,-0.54160795,1.7245452,-0.59205028,-0.59752076,-0.54160795,1.724388,-0.59205028,-0.59752076,-0.54160795,1.7241327,-0.5920601,-0.59752076,-0.54160795,1.7237987,-0.59205028,-0.59752076,-0.54160795,1.7244862,-0.59205028,-0.59752076,-0.54160795,1.7240443,-0.59205028,-0.59752076,-0.54160795,1.7253407,-0.59205028,-0.59752076,-0.54160795,1.7249184,-0.59205028,-0.59752076,-0.54160795,1.7243684,-0.59205028,-0.59752076,-0.54160795,1.7249577,-0.59205028,-0.59752076,-0.54160795,1.7257335,-0.5920601,-0.59752076,-0.54160795,1.7257434,-0.59205028,-0.59752076,-0.54160795,1.7235827,-0.59205028,-0.59752076,-0.54160795,1.7254684,-0.59205028,-0.59752076,-0.54160795,1.7279826,-0.59205028,-0.59752076,-0.54160795,1.7259791,-0.59205028,-0.59752076,-0.54160795,1.724938,-0.59205028,-0.59752076,-0.54160795,1.7262835,-0.59205028,-0.59752076,-0.54160795,1.7263621,-0.59205028,-0.59752076,-0.54160795,1.7279139,-0.59205028,-0.59752076,-0.54160795,1.7287192,-0.5920601,-0.59752076,-0.54160795,1.730163,-0.5920601,-0.59752076,-0.54160795,1.7287585,-0.5920601,-0.59752076,-0.54160795,1.730713,-0.5920601,-0.59752076,-0.54160795,1.7303201,-0.5920601,-0.59650917,-0.54262937,1.7300451,-0.5920601,-0.59752076,-0.54160795,1.7294755,-0.59205028,-0.59752076,-0.54160795,1.729063,-0.5920601,-0.59752076,-0.54160795,1.7287683,-0.5920601,-0.59752076,-0.54160795,1.7283951,-0.5920601,-0.59752076,-0.54160795,1.7284737,-0.59205028,-0.59752076,-0.54262937,1.7288567,-0.5920601,-0.59752076,-0.54160795,1.7288862,-0.5920601,-0.59752076,-0.54262937,1.7286112,-0.5920601,-0.59752076,-0.54160795,1.731096,-0.5920601,-0.59752076,-0.54160795,1.7310763,-0.5920601,-0.59752076,-0.54160795,1.7314004,-0.5920601,-0.59752076,-0.54262937,1.7306147,-0.5920601,-0.59752076,-0.54160795,1.7298781,-0.5920601,-0.59752076,-0.54160795,1.7293773,-0.5920601,-0.59752076,-0.54160795,1.7278549,-0.5920601,-0.59650917,-0.54160795,1.7275603,-0.5920601,-0.59650917,-0.54160795,1.7247514,-0.59205028,-0.59752076,-0.54160795,1.7256943,-0.5920601,-0.59752076,-0.54160795,1.7266469,-0.59205028,-0.59752076,-0.54160795,1.7244862,-0.5920601,-0.59752076,-0.54160795,1.7247023,-0.59205028,-0.59752076,-0.54160795,1.7262246,-0.5920601,-0.59752076,-0.54160795,1.7266273,-0.59205028,-0.59752076,-0.54160795,1.72483,-0.59205028,-0.59752076,-0.54160795,1.7259889,-0.59205028,-0.59752076,-0.54160795,1.7272558,-0.59205028,-0.59752076,-0.54160795,1.7262541,-0.59205028,-0.59752076,-0.54160795,1.7275505,-0.59205028,-0.59752076,-0.54160795,1.7281201,-0.59205028,-0.59752076,-0.54160795,1.7278648,-0.59205028,-0.59752076,-0.54160795,1.7274425,-0.59205028,-0.59752076,-0.54160795,1.7278255,-0.59205028,-0.59752076,-0.54160795,1.7293969,-0.59205028,-0.59650917,-0.54160795,1.7299272,-0.59205028,-0.59752076,-0.54160795,1.7285621,-0.59205028,-0.59752076,-0.54160795,1.7310174,-0.59205028,-0.59752076,-0.54160795,1.7314692,-0.59205028,-0.59752076,-0.54160795,1.7321763,-0.59205028,-0.59752076,-0.54160795,1.7313317,-0.59205028,-0.59650917,-0.54160795,1.7294853,-0.59205028,-0.59752076,-0.54160795,1.7321665,-0.59205028,-0.59752076,-0.54160795,1.7322844,-0.59205028,-0.59752076,-0.54160795,1.7331781,-0.59205028,-0.59752076,-0.54160795,1.7324513,-0.59205028,-0.59752076,-0.54160795,1.7319603,-0.59205028,-0.59752076,-0.54160795,1.7330013,-0.59205028,-0.59752076,-0.54160795,1.7341406,-0.59205028,-0.59752076,-0.54160795,1.7358495,-0.59205028,-0.59752076,-0.54160795,1.7363209,-0.59205028,-0.59752076,-0.54160795,1.7377647,-0.59205028,-0.59752076,-0.54160795,1.7368513,-0.59205028,-0.59752076,-0.54160795,1.7366058,-0.59205028,-0.59752076,-0.54160795,1.7371263,-0.59205028,-0.59752076,-0.54160795,1.7366843,-0.59204046,-0.59752076,-0.54160795,1.7366254,-0.59205028,-0.59752076,-0.54160795,1.7365861,-0.59205028,-0.59752076,-0.54160795,1.7360165,-0.59205028,-0.59650917,-0.54160795,1.7331683,-0.59205028,-0.59752076,-0.54160795,1.7325201,-0.59205028,-0.59752076,-0.54160795,1.7339147,-0.59205028,-0.59752076,-0.54160795,1.7333451,-0.59205028,-0.59752076,-0.54160795,1.7326478,-0.59205028,-0.59752076,-0.54160795,1.7315871,-0.59205028,-0.59752076,-0.54160795,1.7321272,-0.59205028,-0.59752076,-0.54160795,1.7327165,-0.59205028,-0.59752076,-0.54160795,1.732579,-0.59205028,-0.59752076,-0.54160795,1.7329228,-0.59205028,-0.59752076,-0.54160795,1.7314692,-0.59205028,-0.59752076,-0.54160795,1.7323237,-0.59205028,-0.59752076,-0.54160795,1.7326183,-0.59205028,-0.59752076,-0.54160795,1.7321862,-0.59205028,-0.59752076,-0.54160795,1.7330897,-0.59205028,-0.59752076,-0.54160795,1.7322942,-0.59205028,-0.59752076,-0.54160795,1.7329228,-0.59205028,-0.59752076,-0.54160795,1.732687,-0.59205028,-0.59752076,-0.54160795,1.7339933,-0.59205028,-0.59752076,-0.54160795,1.7346611,-0.59205028,-0.59752076,-0.54160795,1.7337576,-0.59205028,-0.59752076,-0.54160795,1.7340326,-0.59205028,-0.59752076,-0.54160795,1.7330504,-0.59205028,-0.59752076,-0.54160795,1.734121,-0.59205028,-0.59752076,-0.54160795,1.7330995,-0.59205028,-0.59752076,-0.54160795,1.734337,-0.59205028,-0.59752076,-0.54160795,1.7342486,-0.59205028,-0.59752076,-0.54160795,1.7328147,-0.59205028,-0.59752076,-0.54160795,1.7336004,-0.59205028,-0.59752076,-0.54160795,1.7285621,-0.59205028,-0.59752076,-0.54160795,1.7310076,-0.59205028,-0.59752076,-0.54160795,1.7291317,-0.59204046,-0.59752076,-0.54160795,1.7300746,-0.59204046,-0.59752076,-0.54160795,1.7292692,-0.59204046,-0.59752076,-0.54160795,1.7310371,-0.59204046,-0.59752076,-0.54160795,1.7327656,-0.59205028,-0.59752076,-0.54160795,1.7320683,-0.59204046,-0.59752076,-0.54160795,1.7307817,-0.59204046,-0.59752076,-0.54160795,1.7295246,-0.59204046,-0.59752076,-0.54160795,1.7282183,-0.59204046,-0.59752076,-0.54160795,1.7302022,-0.59204046,-0.59752076,-0.54160795,1.7303299,-0.59204046,-0.59752076,-0.54160795,1.7306835,-0.59205028,-0.59752076,-0.54160795,1.730988,-0.59204046,-0.59752076,-0.54059636,1.7309781,-0.59204046,-0.59752076,-0.54160795,1.7278746,-0.59204046,-0.59752076,-0.54160795,1.7269219,-0.59204046,-0.59752076,-0.54160795,1.7270692,-0.59204046,-0.59752076,-0.54160795,1.7275505,-0.59204046,-0.59752076,-0.54160795,1.727796,-0.59204046,-0.59752076,-0.54160795,1.7296523,-0.59205028,-0.59752076,-0.54160795,1.7285228,-0.59204046,-0.59752076,-0.54160795,1.7288862,-0.59204046,-0.59752076,-0.54160795,1.7288469,-0.59205028,-0.59752076,-0.54160795,1.7279237,-0.59204046,-0.59752076,-0.54160795,1.728346,-0.59204046,-0.59752076,-0.54160795,1.7291121,-0.59204046,-0.59752076,-0.54160795,1.7300058,-0.59204046,-0.59752076,-0.54160795,1.7302808,-0.59204046,-0.59752076,-0.54160795,1.7297603,-0.59204046,-0.59752076,-0.54160795,1.7284933,-0.59204046,-0.59752076,-0.54160795,1.7287683,-0.59204046,-0.59752076,-0.54160795,1.7284737,-0.59204046,-0.59752076,-0.54160795,1.7287683,-0.59204046,-0.59752076,-0.54160795,1.7299272,-0.59205028,-0.59752076,-0.54160795,1.7307326,-0.59204046,-0.59752076,-0.54160795,1.7308505,-0.59204046,-0.59752076,-0.54160795,1.7301139,-0.59204046,-0.59752076,-0.54160795,1.7312924,-0.59204046,-0.59752076,-0.54160795,1.7311255,-0.59204046,-0.59752076,-0.54160795,1.732196,-0.59204046,-0.59752076,-0.54160795,1.7321272,-0.59204046,-0.59752076,-0.54160795,1.7317147,-0.59204046,-0.59752076,-0.54160795,1.7311647,-0.59205028,-0.59752076,-0.54160795,1.7297701,-0.59205028,-0.59752076,-0.54160795,1.7304478,-0.59205028,-0.59752076,-0.54160795,1.7306344,-0.59204046,-0.59752076,-0.54160795,1.729829,-0.59205028,-0.59752076,-0.54160795,1.729829,-0.59205028,-0.59752076,-0.54160795,1.7311647,-0.59204046,-0.59752076,-0.54160795,1.7307031,-0.59204046,-0.59752076,-0.54160795,1.7320094,-0.59204046,-0.59752076,-0.54160795,1.7323826,-0.59204046,-0.59752076,-0.54160795,1.732137,-0.59204046,-0.59752076,-0.54160795,1.7315674,-0.59204046,-0.59752076,-0.54160795,1.7330013,-0.59204046,-0.59752076,-0.54160795,1.7323335,-0.59204046,-0.59752076,-0.54160795,1.7319701,-0.59205028,-0.59752076,-0.54160795,1.7327361,-0.59204046,-0.59752076,-0.54160795,1.7305067,-0.59205028,-0.59752076,-0.54160795,1.7320192,-0.59205028,-0.59752076,-0.54160795,1.7266371,-0.59205028,-0.59752076,-0.54160795,1.7296719,-0.59204046,-0.59752076,-0.54160795,1.7301826,-0.59205028,-0.59752076,-0.54160795,1.7303201,-0.59205028,-0.59752076,-0.54160795,1.7297603,-0.59205028,-0.59752076,-0.54160795,1.729279,-0.59205028,-0.59752076,-0.54059636,1.7295737,-0.59205028,-0.59752076,-0.54160795,1.7285719,-0.59205028,-0.59752076,-0.54160795,1.728346,-0.59205028,-0.59752076,-0.54160795,1.7282871,-0.59205028,-0.59752076,-0.54160795,1.7295639,-0.59204046,-0.59752076,-0.54160795,1.7291317,-0.59205028,-0.59752076,-0.54160795,1.7287389,-0.59204046,-0.59752076,-0.54059636,1.7281889,-0.59204046,-0.59752076,-0.54160795,1.7297308,-0.59204046,-0.59752076,-0.54160795,1.7313219,-0.59204046,-0.59752076,-0.54160795,1.7305558,-0.59204046,-0.59752076,-0.54160795,1.7306049,-0.59204046,-0.59752076,-0.54160795,1.7301826,-0.59204046,-0.59752076,-0.54160795,1.7304183,-0.59204046,-0.59752076,-0.54160795,1.7308996,-0.59204046,-0.59752076,-0.54160795,1.7315772,-0.59204046,-0.59752076,-0.54160795,1.7325888,-0.59204046,-0.59752076,-0.54160795,1.7315379,-0.59204046,-0.59752076,-0.54160795,1.7311942,-0.59204046,-0.59752076,-0.54059636,1.7308112,-0.59204046,-0.59752076,-0.54160795,1.7327951,-0.59204046,-0.59752076,-0.54059636,1.7301826,-0.59204046,-0.59752076,-0.54059636,1.7314201,-0.59204046,-0.59752076,-0.54160795,1.7302808,-0.59204046,-0.59752076,-0.54160795,1.7323433,-0.59204046,-0.59752076,-0.54059636,1.7304478,-0.59204046,-0.59752076,-0.54059636,1.7302514,-0.59204046,-0.59752076,-0.54059636,1.7339049,-0.59204046,-0.59752076,-0.54059636,1.7312138,-0.59204046,-0.59752076,-0.54160795,1.7320487,-0.59204046,-0.59752076,-0.54059636,1.7332174,-0.59204046,-0.59752076,-0.54160795,1.732962,-0.59204046,-0.59752076,-0.54059636,1.7334236,-0.59204046,-0.59752076,-0.54059636,1.7333647,-0.59204046,-0.59752076,-0.54160795,1.7339933,-0.59205028,-0.59752076,-0.54059636,1.7345236,-0.59204046,-0.59752076,-0.54160795,1.7334531,-0.59204046,-0.59752076,-0.54059636,1.7346709,-0.59205028,-0.59752076,-0.54059636,1.7331978,-0.59204046,-0.59752076,-0.54160795,1.7341308,-0.59205028,-0.59752076,-0.54059636,1.7339933,-0.59204046,-0.59752076,-0.54059636,1.7336299,-0.59204046,-0.59752076,-0.54160795,1.7314987,-0.59204046,-0.59752076,-0.54059636,1.7304478,-0.59204046,-0.59752076,-0.54059636,1.7297406,-0.59204046,-0.59752076,-0.54059636,1.7323335,-0.59204046,-0.59752076,-0.54059636,1.7297505,-0.59204046,-0.59752076,-0.54059636,1.7303201,-0.59204046,-0.59752076,-0.54059636,1.7312531,-0.59204046,-0.59752076,-0.54059636,1.7301237,-0.59204046,-0.59752076,-0.54059636,1.7294853,-0.59204046,-0.59752076,-0.54059636,1.7296326,-0.59204046,-0.59752076,-0.54059636,1.7296228,-0.59204046,-0.59752076,-0.54059636,1.7292398,-0.59204046,-0.59752076,-0.54059636,1.7289746,-0.59204046,-0.59752076,-0.54059636,1.7283755,-0.59204046,-0.59752076,-0.54059636,1.7304576,-0.59204046,-0.59752076,-0.54059636,1.7305067,-0.59205028,-0.59752076,-0.54160795,1.7310174,-0.59204046,-0.59752076,-0.54059636,1.7291415,-0.59204046,-0.59752076,-0.54059636,1.7277666,-0.59203064,-0.59752076,-0.54059636,1.727138,-0.59204046,-0.59752076,-0.54059636,1.7278157,-0.59204046,-0.59752076,-0.54059636,1.7275505,-0.59204046,-0.59752076,-0.54059636,1.7272558,-0.59203064,-0.59752076,-0.54059636,1.7284737,-0.59204046,-0.59752076,-0.54059636,1.7271184,-0.59204046,-0.59752076,-0.54059636,1.7275407,-0.59204046,-0.59752076,-0.54059636,1.7277666,-0.59204046,-0.59752076,-0.54059636,1.7298487,-0.59204046,-0.59752076,-0.54059636,1.7306442,-0.59204046,-0.59752076,-0.54059636,1.7313415,-0.59204046,-0.59752076,-0.54059636,1.7305264,-0.59204046,-0.59752076,-0.54059636,1.7294558,-0.59203064,-0.59752076,-0.54059636,1.7321174,-0.59204046,-0.59854218,-0.54059636,1.7344352,-0.59203064,-0.59752076,-0.54059636,1.7334236,-0.59203064,-0.59752076,-0.54059636,1.7351522,-0.59203064,-0.59752076,-0.54059636,1.7339147,-0.59204046,-0.59854218,-0.54059636,1.7333942,-0.59203064,-0.59752076,-0.54059636,1.733129,-0.59204046,-0.59752076,-0.54059636,1.7330406,-0.59204046,-0.59752076,-0.54059636,1.7334236,-0.59204046,-0.59752076,-0.54059636,1.7328147,-0.59204046,-0.59752076,-0.54059636,1.7322353,-0.59203064,-0.59752076,-0.54059636,1.7318129,-0.59203064,-0.59752076,-0.54059636,1.7317049,-0.59204046,-0.59752076,-0.54059636,1.7271576,-0.59204046,-0.59752076,-0.54059636,1.7277273,-0.59203064,-0.59752076,-0.54059636,1.7282969,-0.59204046,-0.59752076,-0.54059636,1.7321665,-0.59203064,-0.59752076,-0.54059636,1.7332076,-0.59204046,-0.59752076,-0.54059636,1.7330603,-0.59204046,-0.59752076,-0.54059636,1.7315379,-0.59204046,-0.59752076,-0.54059636,1.7330406,-0.59203064,-0.59752076,-0.54059636,1.7350442,-0.59204046,-0.59752076,-0.54059636,1.7360852,-0.59204046,-0.59752076,-0.54059636,1.7360263,-0.59203064,-0.59752076,-0.54059636,1.735545,-0.59204046,-0.59752076,-0.54059636,1.7344843,-0.59204046,-0.59752076,-0.54059636,1.736812,-0.59204046,-0.59752076,-0.54059636,1.7348968,-0.59204046,-0.59752076,-0.54059636,1.7355254,-0.59203064,-0.59752076,-0.54059636,1.7369397,-0.59203064,-0.59752076,-0.54059636,1.7365174,-0.59204046,-0.59752076,-0.54059636,1.7342585,-0.59204046,-0.59752076,-0.54059636,1.7359772,-0.59203064,-0.59752076,-0.54059636,1.7364584,-0.59204046,-0.59752076,-0.54059636,1.7378727,-0.59203064,-0.59752076,-0.54059636,1.7366745,-0.59204046,-0.59752076,-0.54059636,1.7366647,-0.59203064,-0.59752076,-0.54059636,1.7368513,-0.59203064,-0.59752076,-0.54059636,1.737745,-0.59203064,-0.59752076,-0.54059636,1.7383147,-0.59203064,-0.59752076,-0.54059636,1.7375781,-0.59203064,-0.59752076,-0.54059636,1.7377057,-0.59203064,-0.59752076,-0.54059636,1.7387468,-0.59203064,-0.59752076,-0.54059636,1.7386584,-0.59203064,-0.59752076,-0.53957494,1.7386682,-0.59203064,-0.59752076,-0.54059636,1.7372638,-0.59203064,-0.59752076,-0.54059636,1.7367334,-0.59203064,-0.59854218,-0.53957494,1.7383834,-0.59203064,-0.59752076,-0.54059636,1.7386879,-0.59203064,-0.59752076,-0.54059636,1.7393164,-0.59203064,-0.59854218,-0.53957494,1.7378923,-0.59202082,-0.59854218,-0.53856334,1.7381182,-0.592011,-0.59854218,-0.53957494,1.7385307,-0.59202082,-0.59854218,-0.53957494,1.738953,-0.59202082,-0.59854218,-0.54059636,1.7378629,-0.59203064,-0.59752076,-0.54059636,1.7383539,-0.59203064,-0.59854218,-0.53957494,1.7399057,-0.59202082,-0.59854218,-0.53856334,1.7391102,-0.592011,-0.59854218,-0.53957494,1.7391789,-0.59202082,-0.59752076,-0.54059636,1.7366941,-0.59203064,-0.59752076,-0.54160795,1.7349459,-0.59204046,-0.59854218,-0.53957494,1.7361441,-0.59202082,-0.59854218,-0.53856334,1.7357022,-0.592011,-0.59854218,-0.53957494,1.7358986,-0.59203064,-0.59854218,-0.53856334,1.7355647,-0.59202082,-0.59854218,-0.53957494,1.7352013,-0.59203064,-0.59650917,-0.5456838,1.7358593,-0.59207975,-0.59752076,-0.54059636,1.7360459,-0.59204046,-0.59752076,-0.54365079,1.734504,-0.5920601,-0.59854218,-0.54059636,1.7365763,-0.59203064,-0.59650917,-0.54771682,1.7364977,-0.59208957,-0.59752076,-0.54365079,1.7368906,-0.5920601,-0.59650917,-0.5466954,1.7343272,-0.59208957,-0.59650917,-0.54771682,1.7359674,-0.59208957,-0.59752076,-0.54160795,1.7354959,-0.59204046,-0.59650917,-0.54771682,1.7364977,-0.59208957,-0.59650917,-0.5456838,1.7367727,-0.59206993,-0.59650917,-0.54771682,1.7350933,-0.59209939,-0.59650917,-0.54771682,1.7361245,-0.59209939,-0.59548775,-0.54974983,1.7379415,-0.59210921,-0.59548775,-0.54974983,1.7370772,-0.59210921,-0.59548775,-0.55076143,1.7373915,-0.59211903,-0.59548775,-0.55076143,1.7374798,-0.59211903,-0.59548775,-0.55076143,1.7380986,-0.59211903,-0.59548775,-0.55076143,1.7389334,-0.59211903,-0.59548775,-0.55178285,1.7368906,-0.59211903,-0.59548775,-0.55178285,1.7358299,-0.59212885,-0.59548775,-0.55178285,1.7334826,-0.59212885,-0.59548775,-0.55178285,1.7342192,-0.59212885,-0.59447615,-0.55279444,1.7356531,-0.59212885,-0.59447615,-0.55279444,1.7374504,-0.59213868,-0.59548775,-0.55279444,1.7376861,-0.59212885,-0.59447615,-0.55279444,1.7374504,-0.59213868,-0.59447615,-0.55279444,1.7351326,-0.59213868,-0.59447615,-0.55381586,1.7305853,-0.59213868,-0.59447615,-0.55381586,1.7309585,-0.59213868,-0.59548775,-0.55076143,1.7297603,-0.59210921,-0.59447615,-0.55381586,1.7312335,-0.59213868,-0.59447615,-0.55381586,1.730821,-0.5921485,-0.59447615,-0.55482746,1.729171,-0.5921485,-0.59447615,-0.55482746,1.7302415,-0.5921485,-0.59447615,-0.55482746,1.7314299,-0.5921485,-0.59447615,-0.55482746,1.7314299,-0.5921485,-0.59447615,-0.55482746,1.7314299,-0.5921485,-0.59447615,-0.55482746,1.7314299,-0.5921485,-0.59447615,-0.55482746,1.7314299,-0.5921485,-0.59447615,-0.55482746,1.7314299,-0.5921485,-0.59447615,-0.55482746,1.7314299,-0.5921485:9
-0.56490175,-0.48681417,1.3833392,-0.48981569,-0.56490175,-0.48681417,1.382344,-0.48981569,-0.56407513,-0.48598755,1.3789091,-0.48982372,-0.56407513,-0.48598755,1.3721517,-0.48982372,-0.56407513,-0.48681417,1.3742704,-0.48982372,-0.56407513,-0.48598755,1.3711887,-0.48982372,-0.56407513,-0.48598755,1.3707713,-0.48982372,-0.56407513,-0.48681417,1.3729061,-0.48982372,-0.56407513,-0.48681417,1.372545,-0.48982372,-0.56407513,-0.48598755,1.3736204,-0.48982372,-0.56324049,-0.48681417,1.3723122,-0.48982372,-0.56324049,-0.48681417,1.3702978,-0.48982372,-0.56407513,-0.48681417,1.3702497,-0.48982372,-0.56324049,-0.48681417,1.3697922,-0.48982372,-0.56407513,-0.48681417,1.3726172,-0.48982372,-0.56407513,-0.48598755,1.3751693,-0.48982372,-0.56407513,-0.48598755,1.3782591,-0.48982372,-0.56407513,-0.48598755,1.3770472,-0.48982372,-0.56407513,-0.48598755,1.3779942,-0.48982372,-0.56407513,-0.48681417,1.375707,-0.48982372,-0.56407513,-0.48681417,1.3733635,-0.48982372,-0.56407513,-0.48598755,1.3732351,-0.48982372,-0.56407513,-0.48598755,1.3717585,-0.48982372,-0.56407513,-0.48598755,1.3736846,-0.48982372,-0.56407513,-0.48681417,1.3746717,-0.48982372,-0.56407513,-0.48681417,1.3719591,-0.48982372,-0.56407513,-0.48681417,1.3746155,-0.48982372,-0.56407513,-0.48681417,1.3746637,-0.48982372,-0.56407513,-0.48598755,1.3731148,-0.48982372,-0.56407513,-0.48681417,1.3726172,-0.48982372,-0.56407513,-0.48598755,1.3715418,-0.48982372,-0.56324049,-0.48681417,1.3690057,-0.48982372,-0.56324049,-0.48681417,1.3681871,-0.48982372,-0.56324049,-0.48681417,1.3642868,-0.48982372,-0.56324049,-0.48598755,1.3667265,-0.48982372,-0.56324049,-0.48598755,1.3668629,-0.48982372,-0.56324049,-0.48681417,1.3670074,-0.48982372,-0.56324049,-0.48681417,1.3679383,-0.48982372,-0.56324049,-0.48681417,1.3668308,-0.48982372,-0.56324049,-0.48681417,1.3683637,-0.48982372,-0.56324049,-0.48598755,1.3708516,-0.48982372,-0.56407513,-0.48681417,1.3734679,-0.48982372,-0.56407513,-0.48681417,1.3765577,-0.48982372,-0.56407513,-0.48598755,1.3801531,-0.48982372,-0.56490175,-0.48681417,1.383596,-0.48982372,-0.56407513,-0.48598755,1.3816859,-0.48981569,-0.56490175,-0.48598755,1.3810198,-0.48981569,-0.56407513,-0.48681417,1.3798722,-0.48981569,-0.56407513,-0.48681417,1.37919,-0.48982372,-0.56407513,-0.48598755,1.3813007,-0.48982372,-0.56490175,-0.48598755,1.3843343,-0.48981569,-0.56490175,-0.48598755,1.3822477,-0.48981569,-0.56490175,-0.48681417,1.3827533,-0.48981569,-0.56490175,-0.48598755,1.3815656,-0.48981569,-0.56490175,-0.48598755,1.3839491,-0.48981569,-0.56490175,-0.48681417,1.38423,-0.48981569,-0.56490175,-0.48598755,1.3851609,-0.48981569,-0.56490175,-0.48681417,1.3848961,-0.48981569,-0.56490175,-0.48598755,1.3839331,-0.48981569,-0.56490175,-0.48681417,1.3857709,-0.48981569,-0.56490175,-0.48598755,1.3867821,-0.48981569,-0.56490175,-0.48681417,1.3863808,-0.48981569,-0.56490175,-0.48598755,1.3851449,-0.48981569,-0.56490175,-0.48598755,1.3855783,-0.48981569,-0.56490175,-0.48598755,1.3853215,-0.48981569,-0.56490175,-0.48598755,1.3867821,-0.48981569,-0.56490175,-0.48598755,1.385811,-0.48981569,-0.56490175,-0.48598755,1.3868864,-0.48981569,-0.56490175,-0.48598755,1.3865333,-0.48981569,-0.56490175,-0.48598755,1.3861401,-0.48981569,-0.56490175,-0.48681417,1.3879217,-0.48981569,-0.56490175,-0.48598755,1.3869185,-0.48981569,-0.56490175,-0.48598755,1.3869506,-0.48973544,-0.56490175,-0.48598755,1.3876007,-0.48981569,-0.56490175,-0.48681417,1.3877371,-0.48981569,-0.56490175,-0.48598755,1.3874402,-0.48981569,-0.56490175,-0.48598755,1.387697,-0.48981569,-0.56490175,-0.48681417,1.3878816,-0.48981569,-0.56490175,-0.48681417,1.3886921,-0.48981569,-0.56490175,-0.48598755,1.3869747,-0.48981569,-0.56490175,-0.48598755,1.388002,-0.48981569,-0.56490175,-0.48598755,1.3871914,-0.48981569,-0.56490175,-0.48681417,1.3871753,-0.48981569,-0.56490175,-0.48681417,1.3875525,-0.48981569,-0.56490175,-0.48598755,1.3870068,-0.48981569,-0.56490175,-0.48681417,1.3866136,-0.48981569,-0.56490175,-0.48598755,1.3867179,-0.48981569,-0.56490175,-0.48598755,1.3873278,-0.48981569,-0.56490175,-0.48598755,1.3859555,-0.48981569,-0.56490175,-0.48598755,1.3849202,-0.48981569,-0.56490175,-0.48598755,1.3857629,-0.48981569,-0.56490175,-0.48598755,1.3855622,-0.48981569,-0.56490175,-0.48598755,1.3857308,-0.48981569,-0.56490175,-0.48598755,1.3867018,-0.48981569,-0.56490175,-0.48598755,1.3844226,-0.48981569,-0.56490175,-0.48598755,1.384543,-0.48981569,-0.56490175,-0.48681417,1.3846955,-0.48981569,-0.56490175,-0.48598755,1.384856,-0.48981569,-0.56490175,-0.48598755,1.3848881,-0.48981569,-0.56490175,-0.48681417,1.3858672,-0.48981569,-0.56490175,-0.48598755,1.3854418,-0.48981569,-0.56490175,-0.48598755,1.384222,-0.48981569,-0.56490175,-0.48598755,1.382649,-0.48981569,-0.56490175,-0.48598755,1.3816217,-0.48981569,-0.56490175,-0.48598755,1.3816458,-0.48981569,-0.56407513,-0.48681417,1.3811482,-0.48981569,-0.56407513,-0.48598755,1.3821755,-0.48981569,-0.56407513,-0.48598755,1.380434,-0.48981569,-0.56490175,-0.48598755,1.3806266,-0.48981569,-0.56407513,-0.48598755,1.3814452,-0.48981569,-0.56490175,-0.48598755,1.3834836,-0.48981569,-0.56490175,-0.48598755,1.3842059,-0.48981569,-0.56490175,-0.48598755,1.3837244,-0.48981569,-0.56490175,-0.48598755,1.3853696,-0.48981569,-0.56490175,-0.48598755,1.383901,-0.48981569,-0.56490175,-0.48598755,1.383909,-0.48981569,-0.56490175,-0.48598755,1.3846553,-0.48981569,-0.56157922,-0.38878337,1.3842701,-0.48556221,-0.56490175,-0.48598755,1.3839812,-0.48981569,-0.56490175,-0.48681417,1.3849202,-0.48981569,-0.56490175,-0.48598755,1.3839892,-0.48981569,-0.56490175,-0.48598755,1.3867901,-0.48981569,-0.56490175,-0.48681417,1.3847276,-0.48981569,-0.56490175,-0.48598755,1.3851128,-0.48981569,-0.56490175,-0.48598755,1.3838046,-0.48981569,-0.56490175,-0.48598755,1.384848,-0.48981569,-0.56490175,-0.48598755,1.3838127,-0.48981569,-0.56490175,-0.48681417,1.3851048,-0.48981569,-0.56490175,-0.48598755,1.3841176,-0.48981569,-0.56490175,-0.48681417,1.384238,-0.48981569,-0.56490175,-0.48598755,1.3847035,-0.48981569,-0.56490175,-0.48598755,1.3831706,-0.48981569,-0.56490175,-0.48598755,1.3840374,-0.48981569,-0.56490175,-0.48681417,1.3827453,-0.48981569,-0.56407513,-0.48681417,1.3824564,-0.48981569,-0.56490175,-0.48598755,1.3820391,-0.48981569,-0.56490175,-0.48681417,1.3824323,-0.48981569,-0.56490175,-0.48598755,1.3840615,-0.48981569,-0.56490175,-0.48598755,1.3845671,-0.48981569,-0.56490175,-0.48598755,1.3841016,-0.48981569,-0.56490175,-0.48598755,1.3843424,-0.48981569,-0.56490175,-0.48598755,1.3828576,-0.48981569,-0.56490175,-0.48681417,1.3825286,-0.48981569,-0.56490175,-0.48598755,1.3823922,-0.48981569,-0.56490175,-0.48598755,1.3827613,-0.48981569,-0.56490175,-0.48598755,1.3829058,-0.48981569,-0.56490175,-0.48598755,1.3837645,-0.48981569,-0.56490175,-0.48598755,1.3829138,-0.48981569,-0.56490175,-0.48598755,1.3838368,-0.48981569,-0.56490175,-0.48598755,1.3845189,-0.48981569,-0.56490175,-0.48598755,1.3838689,-0.48981569,-0.56490175,-0.48598755,1.3839652,-0.48981569,-0.56407513,-0.48681417,1.3797759,-0.48981569,-0.56407513,-0.48598755,1.3805062,-0.48981569,-0.56407513,-0.48598755,1.3795271,-0.48982372,-0.56407513,-0.48598755,1.3797357,-0.48981569,-0.56407513,-0.48598755,1.3807309,-0.48981569,-0.56407513,-0.48681417,1.3750409,-0.48982372,-0.56407513,-0.48598755,1.3779862,-0.48982372,-0.56407513,-0.48681417,1.3794147,-0.48981569,-0.56407513,-0.48681417,1.3790616,-0.48981569,-0.56407513,-0.48598755,1.3788851,-0.48981569,-0.54745444,2.9734527,1.3688131,-0.4629465,-0.56407513,-0.48681417,1.3785881,-0.48981569,-0.56407513,-0.48681417,1.3780745,-0.48982372,-0.56407513,-0.48598755,1.3790215,-0.48981569,-0.56407513,-0.48598755,1.3792061,-0.48982372,-0.56407513,-0.48598755,1.3788128,-0.48981569,-0.56407513,-0.48598755,1.3799605,-0.48981569,-0.56407513,-0.48598755,1.3790456,-0.48981569,-0.56407513,-0.48598755,1.3769589,-0.48981569,-0.56407513,-0.48598755,1.3756829,-0.48982372,-0.56407513,-0.48681417,1.3784035,-0.48982372,-0.56407513,-0.48681417,1.3810599,-0.48981569,-0.56407513,-0.48598755,1.3824885,-0.48981569,-0.56490175,-0.48681417,1.3823681,-0.48981569,-0.56407513,-0.48598755,1.3824724,-0.48981569,-0.56490175,-0.48598755,1.3850807,-0.48981569,-0.56490175,-0.48598755,1.3880421,-0.48981569,-0.56490175,-0.48598755,1.3874081,-0.48981569,-0.56490175,-0.48681417,1.38801,-0.48981569,-0.56490175,-0.48598755,1.3887563,-0.48981569,-0.5657364,-0.48598755,1.392416,-0.48981569,-0.56490175,-0.48681417,1.3916375,-0.48981569,-0.56490175,-0.48598755,1.3922394,-0.48981569,-0.56490175,-0.48598755,1.3858832,-0.48981569,-0.56490175,-0.48598755,1.3850004,-0.48981569,-0.56490175,-0.48598755,1.3833954,-0.48981569,-0.56490175,-0.48598755,1.3845992,-0.48981569,-0.56490175,-0.48681417,1.383909,-0.48981569,-0.56490175,-0.48681417,1.3843825,-0.48981569,-0.56490175,-0.48598755,1.3855221,-0.48981569,-0.56490175,-0.48598755,1.3848239,-0.48981569,-0.56490175,-0.48681417,1.3861722,-0.48981569,-0.56490175,-0.48598755,1.3865574,-0.48981569,-0.56490175,-0.48598755,1.3870469,-0.48981569,-0.56490175,-0.48681417,1.3880421,-0.48981569,-0.56490175,-0.48681417,1.3880421,-0.48981569,-0.56490175,-0.48598755,1.3880822,-0.48981569,-0.56490175,-0.48598755,1.3878254,-0.48981569,-0.56490175,-0.48681417,1.3883471,-0.48981569,-0.56490175,-0.48681417,1.3876809,-0.48981569,-0.56490175,-0.48598755,1.3865253,-0.48981569,-0.56490175,-0.48598755,1.3874883,-0.48981569,-0.56490175,-0.48598755,1.3874803,-0.48981569,-0.56490175,-0.48598755,1.3866457,-0.48981569,-0.56490175,-0.48598755,1.387689,-0.48981569,-0.56490175,-0.48598755,1.3895348,-0.48981569,-0.56490175,-0.48598755,1.3906905,-0.48981569,-0.56490175,-0.48598755,1.3898077,-0.48981569,-0.56490175,-0.48598755,1.3901929,-0.48981569,-0.56490175,-0.48598755,1.3915733,-0.48981569,-0.5657364,-0.48681417,1.3910195,-0.48981569,-0.56490175,-0.48598755,1.3907707,-0.48981569,-0.56490175,-0.48598755,1.3879458,-0.48981569,-0.56490175,-0.48598755,1.3863728,-0.48981569,-0.56490175,-0.48598755,1.3868302,-0.48981569,-0.56490175,-0.48598755,1.3864691,-0.48981569,-0.56490175,-0.48681417,1.3878816,-0.48981569,-0.56490175,-0.48598755,1.3889971,-0.48981569,-0.56490175,-0.48598755,1.3890212,-0.48981569,-0.56490175,-0.48598755,1.3887804,-0.48981569,-0.56490175,-0.48598755,1.3874723,-0.48981569,-0.56490175,-0.48598755,1.3894786,-0.48981569,-0.56490175,-0.48598755,1.3894706,-0.48981569,-0.56490175,-0.48598755,1.3898077,-0.48981569,-0.11129559,8.6054289,1.3617748,-0.44539485,-0.28743002,11.095323,1.35395,-0.43967271,-0.5657364,-0.48598755,1.3919425,-0.48981569,-0.5657364,-0.48681417,1.3928413,-0.48981569,-0.5657364,-0.48598755,1.3930179,-0.48981569,-0.5657364,-0.48598755,1.3940772,-0.48981569,-0.5657364,-0.48598755,1.394013,-0.48981569,-0.5657364,-0.48598755,1.3946711,-0.48981569,-0.5657364,-0.48598755,1.3941896,-0.48981569,-0.5657364,-0.48598755,1.3960435,-0.48981569,-0.5657364,-0.48598755,1.395907,-0.48981569,-0.1453636,11.340412,1.3601697,-0.43878189,-0.13954515,3.0964105,1.3852091,-0.46322739,-0.5707202,2.6959649,1.3867018,-0.46410217,-0.5657364,-0.48598755,1.3975522,-0.48981569,-0.5657364,-0.48598755,1.3971429,-0.48981569,-0.5657364,-0.48598755,1.397151,-0.48981569,-0.5657364,-0.48598755,1.3966052,-0.48981569,-0.5657364,-0.48598755,1.396541,-0.48981569,-0.5657364,-0.48598755,1.3950403,-0.48981569,-0.5657364,-0.48598755,1.3952409,-0.48981569,-0.5657364,-0.48598755,1.3959792,-0.48981569,-0.5657364,-0.48515291,1.3963966,-0.48981569,-0.5657364,-0.48515291,1.3961719,-0.48981569,-0.5657364,-0.48598755,1.3970707,-0.48981569,-0.5657364,-0.48515291,1.3966454,-0.48981569,-0.5657364,-0.48515291,1.3973355,-0.48981569,-0.5657364,-0.48515291,1.3976325,-0.48981569,-0.5657364,-0.48515291,1.3959632,-0.48981569,-0.5657364,-0.48515291,1.3972874,-0.48981569,-0.5657364,-0.48598755,1.3972874,-0.48981569,-0.5657364,-0.48598755,1.3967497,-0.48981569,-0.5657364,-0.48598755,1.3974238,-0.48981569,-0.5657364,-0.48598755,1.3978171,-0.48981569,-0.5657364,-0.48598755,1.3976887,-0.48981569,-0.5657364,-0.48598755,1.3985634,-0.48981569,-0.5657364,-0.48598755,1.3990851,-0.48981569,-0.5657364,-0.48598755,1.3987641,-0.48981569,-0.5657364,-0.48598755,1.397488,-0.48981569,-0.5657364,-0.48598755,1.3981862,-0.48981569,-0.5657364,-0.48598755,1.3961959,-0.48981569,-0.5657364,-0.48598755,1.3964367,-0.48981569,-0.5657364,-0.48598755,1.3973677,-0.48981569,-0.5657364,-0.48598755,1.3960274,-0.48981569,-0.5657364,-0.48598755,1.3958428,-0.48981569,-0.5657364,-0.48598755,1.3961558,-0.48981569,-0.5657364,-0.48681417,1.396228,-0.48981569,-0.5657364,-0.48681417,1.3952329,-0.48981569,-0.5657364,-0.48681417,1.3956743,-0.48981569,-0.5657364,-0.48598755,1.3955057,-0.48981569,-0.5657364,-0.48598755,1.3964608,-0.48981569,-0.5657364,-0.48598755,1.3962601,-0.48981569,-0.5657364,-0.48598755,1.396541,-0.48981569,-0.5657364,-0.48598755,1.3968942,-0.48981569,-0.5657364,-0.48598755,1.3970627,-0.48981569,-0.5657364,-0.48598755,1.3970707,-0.48981569,-0.5657364,-0.48598755,1.3961157,-0.48981569,-0.5657364,-0.48598755,1.3953292,-0.48981569,-0.5657364,-0.48598755,1.3975924,-0.48981569,-0.5657364,-0.48598755,1.3985394,-0.48981569,-0.5657364,-0.48598755,1.3968942,-0.48981569,-0.5657364,-0.48598755,1.3954335,-0.48981569,-0.5657364,-0.48598755,1.3968781,-0.48981569,-0.5657364,-0.48598755,1.3985394,-0.48981569,-0.5657364,-0.48598755,1.3985474,-0.48981569,-0.5657364,-0.48598755,1.3978893,-0.48981569,-0.5657364,-0.48598755,1.3973596,-0.48981569,-0.5657364,-0.48598755,1.397167,-0.48981569,-0.5657364,-0.48598755,1.3967818,-0.48981569,-0.5657364,-0.48598755,1.3960996,-0.48981569,-0.5657364,-0.48598755,1.3978813,-0.48981569,-0.5657364,-0.48598755,1.3983949,-0.48981569,-0.5657364,-0.48598755,1.3987962,-0.48981569,-0.5657364,-0.48598755,1.4000722,-0.48981569,-0.5657364,-0.48598755,1.3989406,-0.48981569,-0.5657364,-0.48598755,1.3999037,-0.48981569,-0.5657364,-0.48598755,1.3998475,-0.48981569,-0.5657364,-0.48598755,1.3975362,-0.48981569,-0.5657364,-0.48598755,1.3969503,-0.48981569,-0.5657364,-0.48598755,1.397488,-0.48981569,-0.5657364,-0.48598755,1.3976004,-0.48981569,-0.5657364,-0.48598755,1.3970466,-0.48981569,-0.5657364,-0.48598755,1.3986597,-0.48981569,-0.5657364,-0.48598755,1.3999117,-0.48981569,-0.5657364,-0.48598755,1.3996068,-0.48981569,-0.5657364,-0.48598755,1.3986357,-0.48981569,-0.5657364,-0.48598755,1.395281,-0.48981569,-0.5657364,-0.48598755,1.3957305,-0.48981569,-0.5657364,-0.48598755,1.3956422,-0.48981569,-0.56490175,-0.48598755,1.3897916,-0.48981569,-0.5657364,-0.48598755,1.395578,-0.48981569,-0.5657364,-0.48598755,1.3954014,-0.48981569,-0.5657364,-0.48598755,1.3935716,-0.48981569,-0.5657364,-0.48598755,1.3935395,-0.48981569,-0.5657364,-0.48598755,1.3936438,-0.48981569,-0.5657364,-0.48598755,1.3936679,-0.48981569,-0.5657364,-0.48598755,1.3947032,-0.48981569,-0.5657364,-0.48598755,1.3944624,-0.48981569,-0.56490175,-0.48598755,1.3942297,-0.48981569,-0.5657364,-0.48598755,1.396204,-0.48981569,-0.5657364,-0.48598755,1.395891,-0.48981569,-0.5657364,-0.48598755,1.3962601,-0.48981569,-0.5657364,-0.48598755,1.3952329,-0.48981569,-0.5657364,-0.48598755,1.3957385,-0.48981569,-0.5657364,-0.48598755,1.3969343,-0.48981569,-0.5657364,-0.48598755,1.3972312,-0.48981569,-0.5657364,-0.48598755,1.3962842,-0.48981569,-0.5657364,-0.48598755,1.3960595,-0.48981569,-0.5657364,-0.48598755,1.3960756,-0.48981569,-0.5657364,-0.48598755,1.3964929,-0.48981569,-0.5657364,-0.48598755,1.3948798,-0.48981569,-0.5657364,-0.48598755,1.3953533,-0.48981569,-0.5657364,-0.48598755,1.3950643,-0.48981569,-0.5657364,-0.48598755,1.3968299,-0.48981569,-0.5657364,-0.48598755,1.3978091,-0.48981569,-0.5657364,-0.48598755,1.3983468,-0.48981569,-0.5657364,-0.48598755,1.3980659,-0.48981569,-0.5657364,-0.48598755,1.3980017,-0.48981569,-0.5657364,-0.48598755,1.3975603,-0.48981569,-0.5657364,-0.48598755,1.3968299,-0.48981569,-0.5657364,-0.48598755,1.3973837,-0.48981569,-0.5657364,-0.48598755,1.3972633,-0.48981569,-0.5657364,-0.48598755,1.3985153,-0.48981569,-0.5657364,-0.48598755,1.3988122,-0.48981569,-0.56822429,10.898427,1.3631873,-0.4408043,-0.5657364,-0.48598755,1.3983949,-0.48981569,-0.5657364,-0.48598755,1.3972392,-0.48981569,-0.5657364,-0.48598755,1.3975201,-0.48981569,-0.5657364,-0.48598755,1.3986517,-0.48981569,-0.5657364,-0.48598755,1.3982264,-0.48981569,-0.5657364,-0.48598755,1.397801,-0.48981569,-0.5657364,-0.48598755,1.3975522,-0.48981569,-0.5657364,-0.48598755,1.3975522,-0.48981569,-0.5657364,-0.48598755,1.3975522,-0.48981569,-0.5657364,-0.48598755,1.3975522,-0.48981569,-0.5657364,-0.48598755,1.3975522,-0.48981569,-0.5657364,-0.48598755,1.3975522,-0.48981569,-0.5657364,-0.48598755,1.3975522,-0.48981569,-0.5657364,-0.48598755,1.3975522,-0.48981569:3
-0.49650957,-0.49650957,0.90460897,-0.49650957,-0.49650957,-0.49650957,0.90075248,-0.49650957,-0.47791711,4.8676488,0.88723014,-0.47272995,-0.47791711,4.8516191,0.88854849,-0.4728162,-0.47791711,4.8458467,0.8894356,-0.47285933,-0.47791711,4.8157094,0.88670649,-0.47294557,-0.47791711,4.8349487,0.89036584,-0.47292709,-0.47791711,4.8041707,0.88718085,-0.47300718,-0.47791711,4.8125059,0.88938632,-0.47300718,-0.47791711,4.7919852,0.88759977,-0.47306878,-0.49650957,-0.49650957,0.90356168,-0.49650957,-0.49650957,-0.49650957,0.89928012,-0.49650957,-0.49650957,-0.49650957,0.90250207,-0.49650957,-0.49650957,-0.49650957,0.89331673,-0.49650957,-0.20220907,-0.20862217,0.89422849,-0.49468606,-0.15925174,5.0215325,0.87909208,-0.471849,-0.16501799,5.0215325,0.88288081,-0.47191677,-0.17399387,5.0106345,0.88148853,-0.47194141,-0.47791711,4.8022486,0.8844579,-0.47297021,-0.47855781,4.786219,0.88295473,-0.47301334,-0.47855781,4.7791652,0.88288697,-0.47304414,-0.49650957,-0.49650957,0.89731491,-0.49650957,-0.49650957,-0.49650957,0.89925548,-0.49650957,-0.49650957,-0.49650957,0.89562077,-0.49650957,-0.49650957,-0.49650957,0.89852237,-0.49650957,-0.20605324,-0.20990356,0.89562077,-0.49469838,-0.16565869,5.0375621,0.88201833,-0.47183052,-0.17912559,5.0035807,0.87996072,-0.47194757,-0.18425731,5.0266642,0.88216002,-0.47188596,-0.18810147,5.0003711,0.87872861,-0.47194757,-0.18810147,5.0215325,0.88127907,-0.47189212,-0.47855781,4.7868597,0.8814146,-0.47300718,-0.47855781,4.80353,0.88487065,-0.47298254,-0.47855781,4.7733928,0.88210458,-0.4730503,-0.49650957,-0.49650957,0.89738884,-0.49650957,-0.49650957,-0.49650957,0.89714858,-0.49650957,-0.49650957,-0.49650957,0.89923083,-0.49650957,-0.49650957,-0.49650957,0.89574398,-0.49650957,-0.49650957,-0.49650957,0.89969287,-0.49650957,-0.49650957,-0.49650957,0.89727179,-0.49650957,-0.49650957,-0.49650957,0.89983457,-0.49650957,-0.49650957,-0.49650957,0.89862094,-0.49650957,-0.49650957,-0.49650957,0.89751821,-0.49650957,-0.49650957,-0.49650957,0.89684055,-0.49650957,-0.49650957,-0.49650957,0.89779543,-0.49650957,-0.49650957,-0.49650957,0.89732107,-0.49650957,-0.49650957,-0.49650957,0.90038285,-0.49650957,-0.49650957,-0.49650957,0.89754901,-0.49650957,-0.49650957,-0.49650957,0.90195378,-0.49650957,-0.49650957,-0.49650957,0.89870103,-0.49650957,-0.49650957,-0.486893,0.90011179,-0.49647261,-0.49650957,-0.49650957,0.8987996,-0.49650957,-0.49650957,-0.49650957,0.90045678,-0.49650957,-0.49650957,-0.49650957,0.89900289,-0.49650957,-0.49650957,-0.486893,0.90490468,-0.49647261,-0.49650957,-0.486893,0.90274233,-0.49647261,-0.49650957,-0.49650957,0.90238502,-0.49650957,-0.49650957,-0.49650957,0.90094962,-0.49650957,-0.49650957,-0.49650957,0.90127613,-0.49650957,-0.49650957,-0.49650957,0.89910146,-0.49650957,-0.49650957,-0.49650957,0.90259448,-0.49650957,-0.49650957,-0.49650957,0.90064775,-0.49650957,-0.49650957,-0.49650957,0.90244047,-0.49650957,-0.47855781,4.8131466,0.88521564,-0.47293325,-0.47791711,4.9009895,0.89885504,-0.47277924,-0.49650957,-0.486893,0.91001175,-0.49647261,-0.49650957,-0.486893,0.91482928,-0.49647261,-0.49650957,-0.486893,0.90663578,-0.49647261,-0.49650957,-0.486893,0.90977149,-0.49647261,-0.49650957,-0.486893,0.90866259,-0.49647261,-0.49650957,-0.486893,0.91351709,-0.49647261,-0.49650957,-0.486893,0.91328299,-0.49647261,-0.49650957,-0.486893,0.91473687,-0.49647261,-0.49650957,-0.486893,0.91195847,-0.49647261,-0.49650957,-0.486893,0.91546381,-0.49647261,-0.49650957,-0.486893,0.91473071,-0.49647261,-0.49650957,-0.486893,0.91647414,-0.49647261,-0.49650957,-0.486893,0.91527284,-0.49647261,-0.49650957,-0.486893,0.91611067,-0.49647261,-0.49650957,-0.486893,0.91213097,-0.49647261,-0.49650957,-0.486893,0.91516811,-0.49647261,-0.49650957,-0.486893,0.91267309,-0.49647261,-0.49650957,-0.486893,0.91389904,-0.49647261,-0.49650957,-0.486893,0.9158396,-0.49647261,-0.49650957,-0.486893,0.91749678,-0.49647261,-0.49650957,-0.486893,0.91449045,-0.49647261,-0.49650957,-0.486893,0.91573487,-0.49647261,-0.49650957,-0.486893,0.91195847,-0.49647261,-0.49650957,-0.486893,0.91081878,-0.49647261,-0.49650957,-0.486893,0.91186607,-0.49647261,-0.49650957,-0.486893,0.91334459,-0.49647261,-0.49650957,-0.486893,0.9108003,-0.49647261,-0.49650957,-0.486893,0.91463214,-0.49647261,-0.49650957,-0.486893,0.91583344,-0.49647261,-0.49650957,-0.486893,0.91337539,-0.49647261,-0.49650957,-0.486893,0.91539605,-0.49647261,-0.49650957,-0.486893,0.91495865,-0.49647261,-0.49650957,-0.486893,0.91645566,-0.49647261,-0.49650957,-0.486893,0.91500793,-0.49647261,-0.49650957,-0.486893,0.91542069,-0.49647261,-0.49650957,-0.486893,0.9146075,-0.49647261,-0.49650957,-0.486893,0.9164495,-0.49647261,-0.47791711,4.9881917,0.90155951,-0.47248353,-0.47791711,4.9035523,0.89978528,-0.4727854,-0.47855781,4.9080433,0.90218172,-0.47280388,-0.49650957,-0.486893,0.91587041,-0.49647261,-0.49650957,-0.486893,0.91230962,-0.49647261,-0.49650957,-0.486893,0.91442268,-0.49647261,-0.49650957,-0.486893,0.91594433,-0.49647261,-0.49650957,-0.486893,0.91348628,-0.49647261,-0.49650957,-0.486893,0.91546997,-0.49647261,-0.49650957,-0.486893,0.91592585,-0.49647261,-0.49650957,-0.486893,0.9129996,-0.49647261,-0.49650957,-0.486893,0.91649878,-0.49647261,-0.49650957,-0.486893,0.91544533,-0.49647261,-0.49650957,-0.486893,0.91307969,-0.49647261,-0.49650957,-0.486893,0.91289487,-0.49647261,-0.49650957,-0.486893,0.9136403,-0.49647261,-0.49650957,-0.486893,0.91508802,-0.49647261,-0.49650957,-0.486893,0.91474919,-0.49647261,-0.49650957,-0.486893,0.91511266,-0.49647261,-0.49650957,-0.486893,0.90876116,-0.49647261,-0.49650957,-0.486893,0.90782476,-0.49647261,-0.49650957,-0.49650957,0.90233574,-0.49650957,-0.49650957,-0.486893,0.91482312,-0.49647261,-0.49650957,-0.486893,0.906414,-0.49647261,-0.49650957,-0.486893,0.90808351,-0.49647261,-0.49650957,-0.486893,0.913437,-0.49647261,-0.49650957,-0.486893,0.90927865,-0.49647261,-0.49650957,-0.486893,0.91495865,-0.49647261,-0.49650957,-0.486893,0.91615995,-0.49647261,-0.49650957,-0.486893,0.91477999,-0.49647261,-0.49650957,-0.486893,0.91593201,-0.49647261,-0.49650957,-0.486893,0.91045531,-0.49647261,-0.49650957,-0.486893,0.91437956,-0.49647261,-0.49650957,-0.486893,0.91448429,-0.49647261,-0.49650957,-0.486893,0.91404689,-0.49647261,-0.49650957,-0.486893,0.91127466,-0.49647261,-0.49650957,-0.486893,0.91548845,-0.49647261,-0.49650957,-0.486893,0.91174902,-0.49647261,-0.49650957,-0.486893,0.91319674,-0.49647261,-0.49650957,-0.486893,0.91535908,-0.49647261,-0.49650957,-0.486893,0.9164803,-0.49647261,-0.49650957,-0.486893,0.91391136,-0.49647261,-0.47791711,4.9644675,0.90161496,-0.47254514,-0.47855781,4.9330489,0.90223717,-0.47269299,-0.4862523,0.85189954,0.91469991,-0.49062627,-0.49650957,-0.486893,0.91327067,-0.49647261,-0.49650957,-0.486893,0.91433644,-0.49647261,-0.49650957,-0.486893,0.91592585,-0.49647261,-0.49650957,-0.486893,0.91713331,-0.49647261,-0.49650957,-0.486893,0.91837774,-0.49647261,-0.49650957,-0.486893,0.9203183,-0.49647261,-0.49650957,-0.486893,0.91865496,-0.49647261,-0.49650957,-0.486893,0.91927102,-0.49647261,-0.49650957,-0.486893,0.92062017,-0.49647261,-0.49650957,-0.486893,0.92076802,-0.49647261,-0.49650957,-0.486893,0.92044151,-0.49647261,-0.49650957,-0.486893,0.9214272,-0.49647261,-0.49650957,-0.486893,0.91839006,-0.49647261,-0.49650957,-0.486893,0.91819908,-0.49647261,-0.49650957,-0.486893,0.91846399,-0.49647261,-0.49650957,-0.486893,0.91603058,-0.49647261,-0.49650957,-0.486893,0.91545765,-0.49647261,-0.49650957,-0.486893,0.91779865,-0.49647261,-0.49650957,-0.486893,0.91792186,-0.49647261,-0.49650957,-0.4862523,0.91974538,-0.49646645,-0.49650957,-0.49650957,0.91486008,-0.49650957,-0.49650957,-0.49650957,0.92060169,-0.49650957,-0.49650957,-0.49650957,0.92128551,-0.49650957,-0.49650957,-0.49650957,0.92168594,-0.49650957,-0.49650957,-0.49650957,0.91925869,-0.49650957,-0.49650957,-0.49650957,0.92258538,-0.49650957,-0.49650957,-0.49650957,0.92149496,-0.49650957,-0.49650957,-0.49650957,0.9210206,-0.49650957,-0.49650957,-0.49650957,0.91665279,-0.49650957,-0.49650957,-0.49650957,0.91591969,-0.49650957,-0.49650957,-0.49650957,0.91628316,-0.49650957,-0.49650957,-0.49650957,0.91968377,-0.49650957,-0.49650957,-0.49650957,0.9209282,-0.49650957,-0.49650957,-0.49650957,0.91832229,-0.49650957,-0.49650957,-0.49650957,0.91912932,-0.49650957,-0.49650957,-0.49650957,0.91656655,-0.49650957,-0.49650957,-0.49650957,0.91936342,-0.49650957,-0.49650957,-0.49650957,0.91914164,-0.49650957,-0.49650957,-0.49650957,0.91755223,-0.49650957,-0.49650957,-0.49650957,0.91829149,-0.49650957,-0.49650957,-0.49650957,0.92051544,-0.49650957,-0.49650957,-0.49650957,0.91843318,-0.49650957,-0.49650957,-0.49650957,0.92128551,-0.49650957,-0.49650957,-0.49650957,0.91758919,-0.49650957,-0.49650957,-0.49650957,0.9209898,-0.49650957,-0.49650957,-0.49650957,0.91745366,-0.49650957,-0.49650957,-0.49650957,0.92145184,-0.49650957,-0.49650957,-0.49650957,0.91932646,-0.49650957,-0.49650957,-0.49650957,0.91911084,-0.49650957,-0.49650957,-0.49650957,0.91528516,-0.49650957,-0.49650957,-0.49650957,0.91798347,-0.49650957,-0.49650957,-0.49650957,0.91404689,-0.49650957,-0.49650957,-0.49650957,0.91721956,-0.49650957,-0.49650957,-0.49650957,0.91588273,-0.49650957,-0.49650957,-0.49650957,0.915778,-0.49650957,-0.49650957,-0.49650957,0.91544533,-0.49650957,-0.49650957,-0.49650957,0.91757071,-0.49650957,-0.49650957,-0.49650957,0.91735509,-0.49650957,-0.49650957,-0.49650957,0.9174475,-0.49650957,-0.49650957,-0.49650957,0.91636941,-0.49650957,-0.49650957,-0.49650957,0.91688689,-0.49650957,-0.49650957,-0.49650957,0.91617227,-0.49650957,-0.49650957,-0.49650957,0.91704091,-0.49650957,-0.49650957,-0.49650957,0.91540221,-0.49650957,-0.49650957,-0.49650957,0.91478615,-0.49650957,-0.49650957,-0.49650957,0.91502641,-0.49650957,-0.49650957,-0.49650957,0.91452741,-0.49650957,-0.49650957,-0.49650957,0.91662815,-0.49650957,-0.49650957,-0.49650957,0.91411466,-0.49650957,-0.49650957,-0.49650957,0.91529748,-0.49650957,-0.49650957,-0.49650957,0.91433028,-0.49650957,-0.49650957,-0.49650957,0.91207552,-0.49650957,-0.49650957,-0.49650957,0.91565479,-0.49650957,-0.47855781,4.9291985,0.90113444,-0.47269299,-0.47855781,4.888804,0.89830676,-0.47282236,-0.4791985,4.8586729,0.89587951,-0.47291477,-0.49650957,-0.486893,0.91376351,-0.49647261,-0.49650957,-0.486893,0.91486624,-0.49647261,-0.49650957,-0.486893,0.91495249,-0.49647261,-0.49650957,-0.486893,0.91306737,-0.49647261,-0.49650957,-0.486893,0.91400377,-0.49647261,-0.49650957,-0.486893,0.91609835,-0.49647261,-0.49650957,-0.486893,0.91452741,-0.49647261,-0.49650957,-0.486893,0.90816359,-0.49647261,-0.49650957,-0.486893,0.91003639,-0.49647261,-0.49650957,-0.486893,0.90707318,-0.49647261,-0.49650957,-0.486893,0.91183526,-0.49647261,-0.49650957,-0.486893,0.91428715,-0.49647261,-0.49650957,-0.486893,0.91255605,-0.49647261,-0.49650957,-0.486893,0.91095431,-0.49647261,-0.49650957,-0.486893,0.90647561,-0.49647261,-0.49650957,-0.486893,0.91099127,-0.49647261,-0.49650957,-0.486893,0.90757218,-0.49647261,-0.49650957,-0.486893,0.91027049,-0.49647261,-0.49650957,-0.486893,0.91001175,-0.49647261,-0.49650957,-0.486893,0.91187223,-0.49647261,-0.49650957,-0.486893,0.91094815,-0.49647261,-0.49650957,-0.486893,0.9099255,-0.49647261,-0.49650957,-0.486893,0.91151492,-0.49647261,-0.49650957,-0.486893,0.91060316,-0.49647261,-0.49650957,-0.486893,0.90777548,-0.49647261,-0.49650957,-0.486893,0.9061799,-0.49647261,-0.49650957,-0.486893,0.90457817,-0.49647261,-0.49650957,-0.486893,0.90724567,-0.49647261,-0.49650957,-0.486893,0.9063216,-0.49647261,-0.49650957,-0.486893,0.90804038,-0.49647261,-0.49650957,-0.486893,0.90721487,-0.49647261,-0.49650957,-0.486893,0.90587188,-0.49647261,-0.49650957,-0.49650957,0.89539283,-0.49650957,-0.49650957,-0.49650957,0.89766606,-0.49650957,-0.49650957,-0.49650957,0.89380957,-0.49650957,-0.49650957,-0.49650957,0.89855318,-0.49650957,-0.49650957,-0.486893,0.8974258,-0.49647261,-0.49650957,-0.49650957,0.89700072,-0.49650957,-0.49650957,-0.49650957,0.89766606,-0.49650957,-0.47855781,4.8086556,0.88432853,-0.47293941,-0.4791985,4.755441,0.88101417,-0.47311807,-0.49650957,-0.486893,0.89687751,-0.49647261,-0.49650957,-0.486893,0.89980992,-0.49647261,-0.49650957,-0.49650957,0.89826363,-0.49650957,-0.49650957,-0.49650957,0.90012411,-0.49650957,-0.49650957,-0.49650957,0.900235,-0.49650957,-0.49650957,-0.49650957,0.90050606,-0.49650957,-0.49650957,-0.486893,0.89998858,-0.49647261,-0.49650957,-0.49650957,0.90232342,-0.49650957,-0.49650957,-0.49650957,0.89828827,-0.49650957,-0.49650957,-0.49650957,0.89987769,-0.49650957,-0.49650957,-0.49650957,0.89828827,-0.49650957,-0.49650957,-0.49650957,0.90100506,-0.49650957,-0.49650957,-0.49650957,0.89999474,-0.49650957,-0.49650957,-0.49650957,0.90135621,-0.49650957,-0.49650957,-0.486893,0.89759213,-0.49647261,-0.49650957,-0.49650957,0.89897825,-0.49650957,-0.49650957,-0.49650957,0.90061079,-0.49650957,-0.49650957,-0.49650957,0.89732107,-0.49650957,-0.49650957,-0.49650957,0.90033357,-0.49650957,-0.49650957,-0.486893,0.90139934,-0.49647261,-0.49650957,-0.49650957,0.89207231,-0.49650957,-0.49650957,-0.49650957,0.89018719,-0.49650957,-0.49650957,-0.49650957,0.89231873,-0.49650957,-0.49650957,-0.49650957,0.89685287,-0.49650957,-0.49650957,-0.49650957,0.89746892,-0.49650957,-0.49650957,-0.49650957,0.89771535,-0.49650957,-0.49650957,-0.49650957,0.89623682,-0.49650957,-0.49650957,-0.49650957,0.89603352,-0.49650957,-0.49650957,-0.49650957,0.89915075,-0.49650957,-0.49650957,-0.486893,0.89891665,-0.49647261,-0.49650957,-0.486893,0.89884272,-0.49647261,-0.49650957,-0.49650957,0.8934153,-0.49650957,-0.49650957,-0.49650957,0.89514641,-0.49650957,-0.49650957,-0.486893,0.89870719,-0.49647261,-0.49650957,-0.49650957,0.90085721,-0.49650957,-0.49650957,-0.49650957,0.89592879,-0.49650957,-0.49650957,-0.49650957,0.89755517,-0.49650957,-0.49650957,-0.486893,0.89491847,-0.49647261,-0.49650957,-0.486893,0.89920619,-0.49647261,-0.49650957,-0.49650957,0.89631691,-0.49650957,-0.49650957,-0.49650957,0.89688367,-0.49650957,-0.4791985,4.7926259,0.88227707,-0.47297638,-0.47855781,4.7823686,0.88458111,-0.4730503,-0.49650957,0.10555834,0.89868871,-0.49647261,-0.49650957,-0.49650957,0.90107283,-0.49650957,-0.49650957,-0.486893,0.90043214,-0.49650957,-0.49650957,-0.49650957,0.89958198,-0.49650957,-0.49650957,-0.49650957,0.90064159,-0.49650957,-0.49650957,-0.486893,0.90099274,-0.49647261,-0.49650957,-0.49650957,0.89922467,-0.49650957,-0.49650957,-0.486893,0.90178129,-0.49647261,-0.49650957,-0.486893,0.90130693,-0.49647261,-0.49650957,-0.49650957,0.90246511,-0.49650957,-0.49650957,-0.486893,0.90201539,-0.49647261,-0.49650957,-0.486893,0.90303188,-0.49647261,-0.49650957,-0.486893,0.90126381,-0.49647261,-0.49650957,-0.486893,0.90344463,-0.49647261,-0.49650957,-0.486893,0.89923699,-0.49647261,-0.49650957,-0.49650957,0.90047526,-0.49650957,-0.49650957,-0.486893,0.90155951,-0.49647261,-0.49650957,-0.486893,0.9035124,-0.49647261,-0.49650957,-0.49650957,0.90010563,-0.49650957,-0.49650957,-0.486893,0.90251439,-0.49647261,-0.49650957,-0.486893,0.90113444,-0.49647261,-0.49650957,-0.486893,0.90192298,-0.49647261,-0.49650957,-0.486893,0.90059847,-0.49647261,-0.49650957,-0.486893,0.900734,-0.49647261,-0.49650957,-0.486893,0.90264992,-0.49647261,-0.49650957,-0.49650957,0.90308732,-0.49650957,-0.49650957,-0.49650957,0.90221253,-0.49650957,-0.49650957,-0.486893,0.90409765,-0.49647261,-0.49650957,-0.486893,0.9040114,-0.49647261,-0.49650957,-0.49650957,0.88814805,-0.49650957,-0.49650957,-0.49650957,0.89220168,-0.49650957,-0.49650957,-0.49650957,0.88521564,-0.49650957,-0.49650957,-0.49650957,0.88674961,-0.49650957,-0.49650957,-0.49650957,0.89142545,-0.49650957,-0.49650957,-0.49650957,0.89274996,-0.49650957,-0.49650957,-0.49650957,0.89128376,-0.49650957,-0.49650957,-0.49650957,0.8845195,-0.49650957,-0.49650957,-0.49650957,0.89195526,-0.49650957,-0.49650957,-0.486893,0.9053852,-0.49647261,-0.49650957,-0.486893,0.90274849,-0.49647261,-0.49650957,-0.486893,0.90558849,-0.49647261,-0.49650957,-0.486893,0.90755986,-0.49647261,-0.49650957,-0.486893,0.90497244,-0.49647261,-0.47855781,4.8676488,0.89257131,-0.4728162,-0.47855781,4.8413556,0.89262059,-0.47293325,-0.49650957,-0.486893,0.90526815,-0.49647261,-0.49650957,-0.49650957,0.90402372,-0.49650957,-0.49650957,-0.49650957,0.90570554,-0.49650957,-0.49650957,-0.49650957,0.90134389,-0.49650957,-0.49650957,-0.49650957,0.90513261,-0.49650957,-0.49650957,-0.49650957,0.90138086,-0.49650957,-0.49650957,-0.49650957,0.90467674,-0.49650957,-0.49650957,-0.49650957,0.90467674,-0.49650957,-0.49650957,-0.49650957,0.90467674,-0.49650957,-0.49650957,-0.49650957,0.90467674,-0.49650957,-0.49650957,-0.49650957,0.90467674,-0.49650957,-0.49650957,-0.49650957,0.90467674,-0.49650957,-0.49650957,-0.49650957,0.90467674,-0.49650957:3
-0.59602638,-0.49163985,1.3478205,-0.49697093,-0.59602638,-0.49163985,1.3463988,-0.49697093,-0.58041224,6.814399,1.3071384,-0.46180948,-0.59602638,-0.49163985,1.3500635,-0.49697093,-0.59602638,-0.48999708,1.3500161,-0.49697093,-0.5730119,6.5620374,1.310187,-0.46243341,-0.59602638,-0.49163985,1.3512639,-0.49697093,-0.21297825,8.8291453,1.2983164,-0.45651789,-0.20311378,8.7995598,1.2962551,-0.45659686,-0.59602638,-0.49163985,1.351106,-0.49697093,-0.59602638,-0.49163985,1.3501108,-0.49697093,-0.57219052,1.6003795,1.3383667,-0.48834642,-0.59602638,-0.49163985,1.349171,-0.49697093,-0.59602638,-0.49163985,1.3494474,-0.49697093,-0.59602638,-0.49163985,1.348397,-0.49697093,-0.59602638,-0.49163985,1.3493526,-0.49697093,-0.59602638,-0.49163985,1.3492816,-0.49697093,-0.59602638,-0.49163985,1.3498818,-0.49697093,-0.59602638,-0.49163985,1.3515878,-0.49697093,-0.59684777,-0.49163985,1.3555683,-0.49697093,-0.59684777,-0.49163985,1.3542888,-0.49697093,-0.59684777,-0.49163985,1.3549602,-0.49697093,-0.59684777,-0.49163985,1.3544784,-0.49697093,-0.59684777,-0.49163985,1.3541546,-0.49697093,-0.59684777,-0.49163985,1.3540914,-0.49697093,-0.59602638,-0.49163985,1.3531199,-0.49697093,-0.59602638,-0.49163985,1.3494869,-0.49697093,-0.59684777,-0.49163985,1.3558131,-0.49697093,-0.59684777,-0.49163985,1.3543836,-0.49697093,-0.59684777,-0.49163985,1.3543283,-0.49697093,-0.59602638,-0.49163985,1.3536886,-0.49697093,-0.59684777,-0.49163985,1.3535069,-0.49697093,-0.59684777,-0.49163985,1.3537913,-0.49697093,-0.59602638,-0.49163985,1.351722,-0.49697093,-0.59602638,-0.49163985,1.3523775,-0.49697093,-0.59684777,-0.49163985,1.3531199,-0.49697093,-0.59684777,-0.49163985,1.3537439,-0.49697093,-0.59602638,-0.49163985,1.3492895,-0.49697093,-0.59602638,-0.49163985,1.3521011,-0.49697093,-0.59602638,-0.49163985,1.3512639,-0.49697093,-0.59602638,-0.49163985,1.3522986,-0.49697093,-0.59602638,-0.49163985,1.3491236,-0.49697093,-0.59602638,-0.49163985,1.3497475,-0.49697093,-0.59602638,-0.49163985,1.3504741,-0.49697093,-0.59602638,-0.49163985,1.349637,-0.49697093,-0.59602638,-0.49163985,1.348089,-0.49697093,-0.59602638,-0.49163985,1.3451431,-0.49697093,-0.59602638,-0.49163985,1.3466042,-0.49697093,-0.59602638,-0.49163985,1.3522354,-0.49697093,-0.59602638,-0.49163985,1.3515009,-0.49697093,-0.59602638,-0.49163985,1.3497002,-0.49697093,-0.59602638,-0.49163985,1.3472597,-0.49697093,-0.59602638,-0.49163985,1.3494316,-0.49697093,-0.59602638,-0.49163985,1.3509401,-0.49697093,-0.59602638,-0.49163985,1.3498107,-0.49697093,-0.59602638,-0.49163985,1.3510033,-0.49697093,-0.59602638,-0.49163985,1.3521643,-0.49697093,-0.59602638,-0.49163985,1.3513192,-0.49697093,-0.59602638,-0.49163985,1.3532384,-0.49697093,-0.59602638,-0.49163985,1.3512008,-0.49697093,-0.59684777,-0.49163985,1.3549602,-0.49697093,-0.59684777,-0.49163985,1.3555367,-0.49697093,-0.59684777,-0.49163985,1.3551813,-0.49697093,-0.59684777,-0.49163985,1.3559316,-0.49697093,-0.59684777,-0.49163985,1.3549286,-0.49697093,-0.5688971,2.7964058,1.3352944,-0.47351417,-0.59684777,-0.49163985,1.3540598,-0.49697093,-0.59684777,-0.49163985,1.3529699,-0.49697093,-0.59602638,-0.49163985,1.3534911,-0.49697093,-0.59684777,-0.49163985,1.3547627,-0.49697093,-0.59684777,-0.49163985,1.3546363,-0.49697093,-0.56972638,2.7470834,1.3375532,-0.47370372,-0.59684777,-0.49163985,1.3547627,-0.49697093,-0.59684777,-0.49163985,1.3544547,-0.49697093,-0.59684777,-0.49163985,1.3546995,-0.49697093,-0.59684777,-0.49163985,1.3548575,-0.49697093,-0.59684777,-0.49163985,1.3547311,-0.49697093,-0.59602638,-0.49163985,1.3517773,-0.49697093,-0.59602638,-0.49163985,1.3518642,-0.49697093,-0.59602638,-0.49163985,1.3501582,-0.49697093,-0.56972638,2.7257117,1.3304688,-0.4737748,-0.59602638,-0.49163985,1.3485155,-0.49697093,-0.59602638,-0.49163985,1.3489814,-0.49697093,-0.59602638,-0.49163985,1.3505057,-0.49697093,-0.59602638,-0.49163985,1.3499134,-0.49697093,-0.59602638,-0.49163985,1.3489657,-0.49697093,-0.59602638,-0.49163985,1.349013,-0.49697093,-0.59602638,-0.49163985,1.3500556,-0.49697093,-0.59602638,-0.49163985,1.3496844,-0.49697093,-0.59602638,-0.49163985,1.3502293,-0.49697093,-0.59602638,-0.49163985,1.3508296,-0.49697093,-0.59602638,-0.49163985,1.3518563,-0.49697093,-0.59684777,-0.49163985,1.3543994,-0.49697093,-0.59684777,-0.49163985,1.3553945,-0.49697093,-0.59684777,-0.49163985,1.3560975,-0.49697093,-0.59684777,-0.49163985,1.3562791,-0.49697093,-0.60671224,-0.49163985,1.3553235,-0.49697093,-0.59684777,-0.49163985,1.3547469,-0.49697093,-0.59684777,-0.49163985,1.3574954,-0.49697093,-0.59684777,-0.49163985,1.3577165,-0.49697093,-0.59684777,-0.49163985,1.3580719,-0.49697093,-0.59684777,-0.49163985,1.3585537,-0.49697093,-0.60671224,-0.49163985,1.3578034,-0.49697093,-0.59684777,-0.49163985,1.3568004,-0.49697093,-0.59684777,-0.49163985,1.3575428,-0.49697093,-0.59684777,-0.49163985,1.3578034,-0.49697093,-0.59684777,-0.49163985,1.3570926,-0.49697093,-0.59684777,-0.49163985,1.3580008,-0.49697093,-0.59684777,-0.49163985,1.3571558,-0.49697093,-0.59684777,-0.49163985,1.3594936,-0.49697093,-0.59684777,-0.49163985,1.3587117,-0.49697093,-0.59684777,-0.49163985,1.3573453,-0.49697093,-0.59684777,-0.49163985,1.3577007,-0.49697093,-0.59766915,2.937794,1.3407834,-0.49696303,-0.59602638,-0.49163985,1.358451,-0.49585732,-0.1932493,8.9047756,1.3071305,-0.45641521,-0.45300332,-0.15707692,1.3442506,-0.48908882,-0.59684777,-0.49163985,1.3577323,-0.49697093,-0.59684777,-0.49163985,1.3598095,-0.49697093,-0.57958296,-0.49163985,1.3331225,-0.46929669,-0.59684777,-0.49163985,1.3599358,-0.49697093,-0.59684777,-0.49163985,1.357219,-0.49697093,-0.59602638,-0.49163985,1.3521801,-0.49697093,-0.59602638,-0.49163985,1.3492026,-0.49697093,-0.59602638,-0.49163985,1.3518642,-0.49697093,-0.59602638,-0.49163985,1.3525671,-0.49697093,-0.59684777,-0.49163985,1.3551734,-0.49697093,-0.59684777,-0.49163985,1.356445,-0.49697093,-0.59684777,-0.49163985,1.3570215,-0.49697093,-0.59684777,-0.49163985,1.3566424,-0.49697093,-0.59684777,-0.49163985,1.3572348,-0.49697093,-0.59684777,-0.49163985,1.3575902,-0.49697093,-0.59684777,-0.49163985,1.3555525,-0.49697093,-0.59684777,-0.49163985,1.3578745,-0.49697093,-0.59684777,-0.49163985,1.356982,-0.49697093,-0.59684777,-0.49163985,1.3569188,-0.49697093,-0.59684777,-0.49163985,1.3564923,-0.49697093,-0.59684777,-0.49163985,1.3579219,-0.49697093,-0.59766915,-0.49163985,1.3624711,-0.49696303,-0.59766915,-0.49163985,1.3618471,-0.49696303,-0.59684777,-0.49163985,1.3603228,-0.49697093,-0.59684777,-0.49163985,1.3605203,-0.49697093,-0.59684777,-0.49163985,1.3608046,-0.49697093,-0.59766915,-0.49163985,1.3614048,-0.49696303,-0.59684777,-0.49163985,1.3593909,-0.49697093,-0.59684777,-0.49163985,1.3582694,-0.49697093,-0.59684777,-0.49163985,1.358451,-0.49697093,-0.59684777,-0.49163985,1.3584826,-0.49697093,-0.59766915,-0.49163985,1.3599516,-0.49696303,-0.59684777,-0.49163985,1.3581351,-0.49697093,-0.59684777,-0.49163985,1.3584905,-0.49697093,-0.59684777,-0.49163985,1.3586959,-0.49697093,-0.59684777,-0.49163985,1.3585616,-0.49697093,-0.59684777,-0.49163985,1.359383,-0.49697093,-0.59684777,-0.49163985,1.3573848,-0.49697093,-0.59684777,-0.49163985,1.3583326,-0.49697093,-0.59684777,-0.49163985,1.3566661,-0.49697093,-0.59684777,-0.49163985,1.357219,-0.49697093,-0.59684777,-0.49163985,1.3547706,-0.49697093,-0.59684777,-0.49163985,1.3549128,-0.49697093,-0.59602638,-0.49163985,1.3534517,-0.49697093,-0.59684777,-0.49163985,1.3557184,-0.49697093,-0.59684777,-0.49163985,1.3551181,-0.49697093,-0.59684777,-0.49163985,1.3551102,-0.49697093,-0.59684777,-0.49163985,1.3552998,-0.49697093,-0.59684777,-0.49163985,1.3542493,-0.49697093,-0.59684777,-0.49163985,1.3543678,-0.49697093,-0.59684777,-0.49163985,1.3539966,-0.49697093,-0.59684777,-0.49163985,1.3543836,-0.49697093,-0.59602638,-0.49163985,1.3525829,-0.49697093,-0.59684777,-0.49163985,1.3536254,-0.49697093,-0.59602638,-0.49163985,1.3527014,-0.49697093,-0.59602638,-0.49163985,1.3522749,-0.49697093,-0.59684777,-0.49163985,1.3546442,-0.49697093,-0.59684777,-0.49163985,1.3547074,-0.49697093,-0.59684777,-0.49163985,1.3542257,-0.49697093,-0.59684777,-0.49163985,1.3575191,-0.49697093,-0.59684777,-0.49163985,1.3556631,-0.49697093,-0.59684777,-0.49163985,1.3554893,-0.49697093,-0.57958296,4.0277831,1.3301292,-0.46939146,-0.59602638,-0.49163985,1.3539571,-0.49697093,-0.59684777,-0.49163985,1.3545416,-0.49697093,-0.59684777,-0.49163985,1.3557736,-0.49697093,-0.59684777,-0.49163985,1.3583168,-0.49697093,-0.59684777,-0.49163985,1.3587038,-0.49697093,-0.59684777,-0.49163985,1.3591855,-0.49697093,-0.59766915,-0.49163985,1.3608125,-0.49696303,-0.59684777,-0.49163985,1.3599358,-0.49697093,-0.59684777,-0.49163985,1.3601491,-0.49697093,-0.59766915,-0.49163985,1.3611442,-0.49696303,-0.59684777,-0.49163985,1.3596041,-0.49697093,-0.59684777,-0.49163985,1.359304,-0.49697093,-0.59684777,-0.49163985,1.360544,-0.49697093,-0.59684777,-0.49163985,1.360694,-0.49697093,-0.59766915,-0.49163985,1.3610968,-0.49696303,-0.59684777,-0.49163985,1.358917,-0.49697093,-0.59684777,-0.49163985,1.3592961,-0.49697093,-0.59684777,-0.49163985,1.3572742,-0.49697093,-0.59684777,-0.49163985,1.3574717,-0.49697093,-0.59684777,-0.49163985,1.3580877,-0.49697093,-0.59684777,-0.49163985,1.3569188,-0.49697093,-0.59684777,-0.49163985,1.3578192,-0.49697093,-0.59684777,-0.49163985,1.3574085,-0.49697093,-0.59602638,-0.49163985,1.3529541,-0.49697093,-0.59602638,-0.49163985,1.3547232,-0.49697093,-0.59602638,-0.49163985,1.3533095,-0.49697093,-0.59684777,-0.49163985,1.3570057,-0.49697093,-0.59684777,-0.49163985,1.3574164,-0.49697093,-0.59684777,-0.49163985,1.357756,-0.49697093,-0.59684777,-0.49163985,1.3583878,-0.49697093,-0.59684777,-0.49163985,1.3578034,-0.49697093,-0.59684777,-0.49163985,1.3594857,-0.49697093,-0.59684777,-0.49163985,1.3589881,-0.49697093,-0.59684777,-0.49163985,1.3566503,-0.49697093,-0.59684777,-0.49163985,1.3562791,-0.49697093,-0.59684777,-0.49163985,1.3568399,-0.49697093,-0.59602638,-0.49163985,1.3523538,-0.49697093,-0.59684777,-0.49163985,1.3572505,-0.49697093,-0.59684777,-0.49163985,1.3564529,-0.49697093,-0.59684777,-0.49163985,1.356516,-0.49697093,-0.59684777,-0.49163985,1.3558842,-0.49697093,-0.59684777,-0.49163985,1.3566819,-0.49697093,-0.59684777,-0.49163985,1.3576849,-0.49697093,-0.59684777,-0.49163985,1.358372,-0.49697093,-0.59684777,-0.49163985,1.3590671,-0.49697093,-0.59684777,-0.49163985,1.356832,-0.49697093,-0.59684777,-0.49163985,1.3572821,-0.49697093,-0.59684777,-0.49163985,1.3569267,-0.49697093,-0.59684777,-0.49163985,1.3582062,-0.49697093,-0.59684777,-0.49163985,1.3590434,-0.49697093,-0.59684777,-0.49163985,1.3597542,-0.49697093,-0.59684777,-0.49163985,1.3596752,-0.49697093,-0.59684777,-0.49163985,1.3600543,-0.49697093,-0.59684777,-0.49163985,1.3589723,-0.49697093,-0.59684777,-0.49163985,1.3577718,-0.49697093,-0.59684777,-0.49163985,1.3569267,-0.49697093,-0.59684777,-0.49163985,1.3569583,-0.49697093,-0.59684777,-0.49163985,1.3580008,-0.49697093,-0.59684777,-0.49163985,1.3572584,-0.49697093,-0.59684777,-0.49163985,1.3561922,-0.49697093,-0.59684777,-0.49163985,1.3563502,-0.49697093,-0.59684777,-0.49163985,1.3550865,-0.49697093,-0.59684777,-0.49163985,1.3558289,-0.49697093,-0.59684777,-0.49163985,1.3556947,-0.49697093,-0.59684777,-0.49163985,1.3553314,-0.49697093,-0.59684777,-0.49163985,1.3563186,-0.49697093,-0.59684777,-0.49163985,1.3572111,-0.49697093,-0.59684777,-0.49163985,1.356903,-0.49697093,-0.59684777,-0.49163985,1.357219,-0.49697093,-0.59684777,-0.49163985,1.358143,-0.49697093,-0.59684777,-0.49163985,1.3588854,-0.49697093,-0.59766915,-0.49163985,1.3610178,-0.49696303,-0.59766915,-0.49163985,1.3611126,-0.49696303,-0.59684777,-0.49163985,1.3584352,-0.49697093,-0.59684777,-0.49163985,1.3595567,-0.49697093,-0.59684777,-0.49163985,1.3608283,-0.49697093,-0.59684777,-0.49163985,1.360694,-0.49697093,-0.59766915,-0.49163985,1.3616892,-0.49696303,-0.59684777,-0.49163985,1.3596041,-0.49697093,-0.59766915,-0.49163985,1.3600622,-0.49696303,-0.59766915,-0.49163985,1.3621472,-0.49696303,-0.59766915,-0.49163985,1.3615391,-0.49696303,-0.59766915,-0.49163985,1.3609784,-0.49696303,-0.59766915,-0.49163985,1.3613733,-0.49696303,-0.59684777,-0.49163985,1.3613417,-0.49697093,-0.59766915,-0.49163985,1.3623763,-0.49696303,-0.59766915,-0.49163985,1.3617366,-0.49696303,-0.59684777,-0.49163985,1.3601807,-0.49697093,-0.59684777,-0.49163985,1.3614522,-0.49697093,-0.59684777,-0.49163985,1.3616813,-0.49697093,-0.59684777,-0.49163985,1.3615549,-0.49697093,-0.59766915,-0.49163985,1.361776,-0.49696303,-0.59684777,-0.49163985,1.3611205,-0.49697093,-0.59766915,-0.49163985,1.3645719,-0.49696303,-0.59766915,-0.49163985,1.3628817,-0.49696303,-0.59684777,-0.49163985,1.360694,-0.49697093,-0.59684777,-0.49163985,1.3600385,-0.49697093,-0.59684777,-0.49163985,1.3614759,-0.49697093,-0.59766915,-0.49163985,1.3610494,-0.49697093,-0.59766915,-0.49163985,1.3617287,-0.49696303,-0.59766915,-0.49163985,1.3621472,-0.49696303,-0.59684777,-0.49163985,1.3615707,-0.49696303,-0.59684777,-0.49163985,1.360694,-0.49697093,-0.59684777,-0.49163985,1.35977,-0.49697093,-0.59766915,-0.49163985,1.3613733,-0.49696303,-0.59684777,-0.49163985,1.3615312,-0.49696303,-0.59684777,-0.49163985,1.3579851,-0.49697093,-0.59684777,-0.49163985,1.3573295,-0.49697093,-0.59684777,-0.49163985,1.3580561,-0.49697093,-0.59766915,-0.49163985,1.3623605,-0.49696303,-0.59766915,-0.49163985,1.3625895,-0.49696303,-0.59766915,-0.49163985,1.3636794,-0.49696303,-0.59684777,-0.49163985,1.3609389,-0.49697093,-0.59684777,-0.49163985,1.3595962,-0.49697093,-0.59766915,-0.49163985,1.3628581,-0.49696303,-0.59766915,-0.49163985,1.3615075,-0.49696303,-0.59766915,-0.49163985,1.3637031,-0.49696303,-0.59766915,-0.49163985,1.3632135,-0.49696303,-0.59766915,-0.49163985,1.3627475,-0.49696303,-0.59766915,-0.49163985,1.3631266,-0.49696303,-0.59766915,-0.49163985,1.362321,-0.49696303,-0.59766915,-0.49163985,1.3635926,-0.49696303,-0.59766915,-0.49163985,1.3622578,-0.49696303,-0.59684777,-0.49163985,1.3611758,-0.49697093,-0.59684777,-0.49163985,1.3613259,-0.49697093,-0.59684777,-0.49163985,1.3600938,-0.49697093,-0.59684777,-0.49163985,1.3595567,-0.49697093,-0.59684777,-0.49163985,1.3603781,-0.49697093,-0.59766915,-0.49163985,1.3634425,-0.49696303,-0.59766915,-0.49163985,1.3617366,-0.49696303,-0.59684777,-0.49163985,1.3594857,-0.49697093,-0.59684777,-0.49163985,1.3604018,-0.49697093,-0.59766915,-0.49163985,1.3617602,-0.49696303,-0.60260533,-0.45711813,1.3609547,-0.49691564,-0.59684777,-0.49163985,1.360386,-0.49697093,-0.58616191,-0.15132725,1.3594541,-0.49587312,-0.60013329,-0.48177537,1.3589881,-0.49695513,-0.19407068,8.850517,1.3082599,-0.45651789,-0.59766915,-0.49163985,1.3611284,-0.49696303,-0.59684777,-0.49163985,1.3595488,-0.49697093,-0.59684777,-0.49163985,1.3581272,-0.49697093,-0.59684777,-0.49163985,1.3599832,-0.49697093,-0.59684777,-0.49163985,1.3599516,-0.49697093,-0.59684777,-0.49163985,1.3604808,-0.49697093,-0.59684777,-0.49163985,1.3585932,-0.49697093,-0.59766915,-0.49163985,1.3606466,-0.49696303,-0.59684777,-0.49163985,1.3607177,-0.49697093,-0.59766915,-0.49163985,1.3626527,-0.49696303,-0.59766915,-0.49163985,1.3621551,-0.49696303,-0.59766915,-0.49163985,1.363403,-0.49696303,-0.59766915,-0.49163985,1.3633872,-0.49696303,-0.59684777,-0.49163985,1.3624158,-0.49697093,-0.59766915,-0.49163985,1.3621157,-0.49696303,-0.59766915,-0.49163985,1.3625737,-0.49696303,-0.59766915,-0.49163985,1.363711,-0.49696303,-0.57958296,4.1017628,1.3413284,-0.46916242,-0.59766915,-0.49163985,1.3686077,-0.49697093,-0.59766915,-0.49163985,1.3651484,-0.49696303,-0.59766915,-0.49163985,1.3655196,-0.49696303,-0.59766915,-0.49163985,1.3654091,-0.49696303,-0.59766915,-0.49163985,1.3649115,-0.49696303,-0.57958296,4.1017628,1.3410993,-0.46916242,-0.59766915,-0.49163985,1.3679285,-0.49697093,-0.59766915,-0.49163985,1.367968,-0.49697093,-0.59849053,-0.49163985,1.3700372,-0.49696303,-0.59766915,-0.49163985,1.3665701,-0.49697093,-0.59766915,-0.49163985,1.3670202,-0.49697093,-0.59766915,-0.49163985,1.3663489,-0.49696303,-0.59766915,-0.49163985,1.365883,-0.49696303,-0.59849053,-0.49163985,1.3750366,-0.49696303,-0.59766915,-0.49163985,1.3658751,-0.49696303,-0.59849053,-0.49163985,1.3742468,-0.49696303,-0.59766915,-0.49163985,1.3619972,-0.49696303,-0.59766915,-0.49163985,1.3626369,-0.49696303,-0.59849053,-0.49163985,1.3712377,-0.49696303,-0.59849053,-0.49163985,1.3687815,-0.49696303,-0.59849053,-0.49163985,1.3717037,-0.49696303,-0.59766915,-0.49163985,1.3631187,-0.49696303,-0.59684777,-0.49163985,1.3579851,-0.49697093,-0.59684777,-0.49163985,1.3579851,-0.49697093,-0.59684777,-0.49163985,1.3579851,-0.49697093,-0.59684777,-0.49163985,1.3579851,-0.49697093,-0.59684777,-0.49163985,1.3579851,-0.49697093,-0.59684777,-0.49163985,1.3579851,-0.49697093,-0.59684777,-0.49163985,1.3579851,-0.49697093:3
-0.43374239,-0.52203203,1.230249,-0.55617545,-0.43453008,-0.52203203,1.2290826,-0.55617545,-0.43453008,-0.52203203,1.2281131,-0.55617545,-0.43453008,-0.52203203,1.2283328,-0.55617545,-0.43610546,-0.52281973,1.2264772,-0.55618302,-0.43453008,-0.52203203,1.2287721,-0.55617545,-0.45108675,0.65410546,1.2208421,-0.55152503,-0.43531777,-0.52203203,1.2272573,-0.55618302,-0.43531777,-0.52203203,1.227386,-0.55618302,-0.43531777,-0.52203203,1.2281359,-0.55618302,-0.43531777,-0.52203203,1.2273027,-0.55618302,-0.43531777,-0.52203203,1.2285676,-0.55618302,-0.43531777,-0.52203203,1.2285373,-0.55618302,-0.43453008,-0.52203203,1.2290447,-0.55617545,-0.43531777,-0.52281973,1.2272043,-0.55618302,-0.43531777,-0.52281973,1.2278253,-0.55618302,-0.43610546,-0.52281973,1.2270907,-0.55618302,-0.43374239,-0.52203203,1.2298703,-0.55617545,-0.43374239,-0.52203203,1.2302717,-0.55617545,-0.43295469,-0.52203203,1.2314987,-0.55617545,-0.43453008,-0.52203203,1.2294537,-0.55617545,-0.43531777,-0.52203203,1.2271058,-0.55618302,-0.43374239,-0.52203203,1.2298021,-0.55617545,-0.43453008,-0.52203203,1.2289311,-0.55617545,-0.43374239,-0.52203203,1.2302566,-0.55617545,-0.43295469,-0.52203203,1.2314381,-0.55617545,-0.43374239,-0.52203203,1.2308776,-0.55617545,-0.43453008,-0.52203203,1.2293098,-0.55617545,-0.43374239,-0.52203203,1.23112,-0.55617545,-0.43374239,-0.52203203,1.2307034,-0.55617545,-0.43453008,-0.52203203,1.2291962,-0.55617545,-0.43531777,-0.52203203,1.2277723,-0.55618302,-0.43689315,-0.52281973,1.2252123,-0.55619059,-0.43847611,-0.52281973,1.222978,-0.55619059,-0.45344983,0.17561298,1.217699,-0.55355486,-0.43847611,-0.52281973,1.2224478,-0.55619059,-0.43847611,-0.52281973,1.2227053,-0.55619059,-0.4392638,-0.52281973,1.2218949,-0.55619817,-0.43847611,-0.52281973,1.2227432,-0.55619059,-0.4392638,-0.52281973,1.2212966,-0.55619817,-0.4392638,-0.52281973,1.2207361,-0.55619817,-0.4392638,-0.52281973,1.2211906,-0.55619817,-0.43847611,-0.52281973,1.2227129,-0.55619059,-0.4392638,-0.52281973,1.220827,-0.55619817,-0.44005149,-0.52360742,1.220115,-0.55619817,-0.4392638,-0.52281973,1.2209861,-0.55619817,-0.45344983,-0.12788317,1.2174187,-0.55483485,-0.4392638,-0.52281973,1.2218646,-0.55619817,-0.44083919,-0.52360742,1.2190395,-0.55620574,-0.44005149,-0.52281973,1.2210088,-0.55619817,-0.4392638,-0.52281973,1.2219479,-0.55619817,-0.43768084,-0.52281973,1.2238111,-0.55619059,-0.4392638,-0.52281973,1.2218192,-0.55619817,-0.4392638,-0.52281973,1.2209558,-0.55619817,-0.43768084,-0.52281973,1.2238945,-0.55619059,-0.43847611,-0.52281973,1.221645,-0.55619059,-0.43847611,-0.52281973,1.221751,-0.55619059,-0.4392638,-0.52281973,1.2210391,-0.55619817,-0.4392638,-0.52281973,1.2207285,-0.55619817,-0.4392638,-0.52281973,1.2208043,-0.55619817,-0.43689315,-0.52281973,1.2248563,-0.55619059,-0.43689315,-0.52281973,1.2245155,-0.55619059,-0.43768084,-0.52281973,1.2233264,-0.55619059,-0.43847611,-0.52281973,1.2231143,-0.55619059,-0.44005149,-0.52281973,1.2203423,-0.55619817,-0.43847611,-0.52281973,1.2216071,-0.55619059,-0.43847611,-0.52281973,1.2219479,-0.55619059,-0.4392638,-0.52281973,1.2208421,-0.55619817,-0.43847611,-0.52281973,1.2224781,-0.55619059,-0.43847611,-0.52281973,1.2215768,-0.55619059,-0.43768084,-0.52281973,1.2236975,-0.55619059,-0.43768084,-0.52281973,1.2230462,-0.55619059,-0.43768084,-0.52281973,1.2227053,-0.55619059,-0.43768084,-0.52281973,1.2235763,-0.55619059,-0.43689315,-0.52281973,1.2238945,-0.55619059,-0.43689315,-0.52281973,1.2245761,-0.55619059,-0.43610546,-0.52281973,1.2257122,-0.55618302,-0.43768084,-0.52281973,1.2234552,-0.55619059,-0.43768084,-0.52281973,1.2230386,-0.55619059,-0.43689315,-0.52281973,1.2242429,-0.55619059,-0.43768084,-0.52281973,1.223493,-0.55619059,-0.43768084,-0.52281973,1.2231598,-0.55619059,-0.43768084,-0.52281973,1.2238187,-0.55619059,-0.43768084,-0.52281973,1.2232582,-0.55619059,-0.43768084,-0.52281973,1.2229174,-0.55619059,-0.43768084,-0.52281973,1.2226523,-0.55619059,-0.43847611,-0.52281973,1.2225387,-0.55619059,-0.43768084,-0.52281973,1.2232279,-0.55619059,-0.43847611,-0.52281973,1.2219631,-0.55619059,-0.43768084,-0.52281973,1.222569,-0.55619059,-0.4392638,-0.52281973,1.2211224,-0.55619817,-0.43847611,-0.52281973,1.2220237,-0.55619059,-0.4392638,-0.52281973,1.220774,-0.55619817,-0.43847611,-0.52281973,1.2209785,-0.55619059,-0.43847611,-0.52281973,1.2213117,-0.55619059,-0.43847611,-0.52281973,1.2221979,-0.55619059,-0.43847611,-0.52281973,1.2215465,-0.55619059,-0.43847611,-0.52281973,1.2218874,-0.55619059,-0.43847611,-0.52281973,1.2225008,-0.55619059,-0.43847611,-0.52281973,1.2214405,-0.55619059,-0.44005149,-0.52360742,1.2195773,-0.55619817,-0.44320226,-0.52360742,1.2149345,-0.55621332,-0.4392638,-0.52281973,1.2211451,-0.55619817,-0.43847611,-0.52281973,1.221539,-0.55619059,-0.43847611,-0.52281973,1.2224403,-0.55619059,-0.43847611,-0.52281973,1.2220919,-0.55619059,-0.43768084,-0.52281973,1.2231371,-0.55619059,-0.43768084,-0.52281973,1.222675,-0.55619059,-0.43768084,-0.52281973,1.223902,-0.55619059,-0.43768084,-0.52281973,1.2233113,-0.55619059,-0.43847611,-0.52281973,1.2226902,-0.55619059,-0.43768084,-0.52203203,1.2230083,-0.55619059,-0.4392638,-0.52281973,1.2201378,-0.55619817,-0.43768084,-0.52281973,1.2232128,-0.55619059,-0.43610546,-0.52281973,1.2259091,-0.55618302,-0.43768084,-0.52281973,1.2240914,-0.55619059,-0.43689315,-0.52281973,1.2238566,-0.55619059,-0.43689315,-0.52281973,1.2239096,-0.55619059,-0.43689315,-0.52281973,1.2240156,-0.55619059,-0.43768084,-0.52281973,1.2237581,-0.55619059,-0.43689315,-0.52281973,1.2244852,-0.55619059,-0.43768084,-0.52281973,1.2240535,-0.55619059,-0.43689315,-0.52281973,1.2250836,-0.55619059,-0.43531777,-0.52203203,1.226871,-0.55618302,-0.43610546,-0.52281973,1.2264696,-0.55618302,-0.43689315,-0.52281973,1.2256743,-0.55619059,-0.43531777,-0.52281973,1.2267801,-0.55618302,-0.43610546,-0.52281973,1.2261969,-0.55618302,-0.43531777,-0.52203203,1.227174,-0.55618302,-0.43453008,-0.52203203,1.2285449,-0.55617545,-0.43689315,-0.52281973,1.2254623,-0.55619059,-0.43531777,-0.52203203,1.2272497,-0.55618302,-0.43610546,-0.52281973,1.2258788,-0.55618302,-0.43453008,-0.52203203,1.2291205,-0.55617545,-0.43610546,-0.52281973,1.2268483,-0.55618302,-0.43689315,-0.52281973,1.2254926,-0.55619059,-0.43689315,-0.52281973,1.2248033,-0.55619059,-0.43768084,-0.52281973,1.2240762,-0.55619059,-0.43768084,-0.52281973,1.2245231,-0.55619059,-0.43768084,-0.52281973,1.2241823,-0.55619059,-0.43847611,-0.52281973,1.2233037,-0.55619059,-0.43847611,-0.52281973,1.2227508,-0.55619059,-0.43768084,-0.52281973,1.2241671,-0.55619059,-0.43610546,-0.51572293,1.2262575,-0.55617545,-0.43610546,-0.52281973,1.2261666,-0.55618302,-0.43610546,-0.52281973,1.2271058,-0.55618302,-0.43610546,-0.52281973,1.2266892,-0.55618302,-0.43689315,-0.52281973,1.2253032,-0.55619059,-0.43610546,-0.52281973,1.2263787,-0.55618302,-0.43847611,-0.52281973,1.2220767,-0.55619059,-0.43689315,-0.52281973,1.2248563,-0.55619059,-0.43689315,-0.50942139,1.2240384,-0.55616787,-0.43768084,-0.52281973,1.2237884,-0.55619059,-0.43610546,-0.52281973,1.2263484,-0.55618302,-0.43689315,-0.52281973,1.2249397,-0.55619059,-0.43689315,-0.52281973,1.2259546,-0.55618302,-0.43768084,-0.52281973,1.2246973,-0.55619059,-0.43689315,-0.52281973,1.2254471,-0.55619059,-0.43847611,-0.52281973,1.2231674,-0.55619059,-0.43768084,-0.49996152,1.2237657,-0.55615272,-0.43768084,-0.52281973,1.22472,-0.55619059,-0.43689315,-0.52281973,1.2236521,-0.55619059,-0.43847611,-0.52281973,1.2222358,-0.55619817,-0.43768084,-0.52281973,1.2241368,-0.55619059,-0.43768084,-0.52281973,1.2246519,-0.55619059,-0.43689315,-0.52281973,1.2243262,-0.55619059,-0.43768084,-0.52281973,1.2243868,-0.55619059,-0.43768084,-0.48104176,1.2232355,-0.55611485,-0.43768084,-0.52281973,1.2231522,-0.55619059,-0.43689315,-0.52281973,1.2230992,-0.55619059,-0.43531777,-0.52203203,1.2266589,-0.55618302,-0.43610546,-0.52281973,1.2260758,-0.55619059,-0.4392638,-0.52281973,1.2259924,-0.55619059,-0.44005149,-0.52360742,1.2210012,-0.55619817,-0.28396733,8.3486578,1.166961,-0.51218589,-0.44398995,-0.50705074,1.2210618,-0.55618302,-0.034079675,9.6162433,1.1575693,-0.51195109,-0.032496718,10.086851,1.1567816,-0.50980009,-0.037230443,10.051382,1.1561757,-0.50994399,-0.44162688,-0.50232459,1.222819,-0.55617545,-0.356488,0.14407501,1.2191001,-0.55358515,-0.025407491,10.067932,1.1580692,-0.50992127,-0.042744285,10.019057,1.1547063,-0.51008033,-0.44162688,-0.50626305,1.2205846,-0.55619059,-0.43768084,-0.52281973,1.2248639,-0.55619059,-0.43768084,-0.52281973,1.2237657,-0.55619059,-0.43689315,-0.52281973,1.2258485,-0.55619059,-0.43610546,-0.52281973,1.2270301,-0.55618302,-0.43689315,-0.52281973,1.2255759,-0.55619059,-0.43610546,-0.52281973,1.2270907,-0.55618302,-0.43531777,-0.52203203,1.2273027,-0.55618302,-0.43689315,-0.52281973,1.2257046,-0.55619059,-0.43610546,-0.52203203,1.226515,-0.55618302,-0.43453008,-0.52203203,1.2288024,-0.55617545,-0.43531777,-0.52203203,1.2278556,-0.55618302,-0.43531777,-0.52203203,1.2277723,-0.55618302,-0.43453008,-0.52203203,1.2292341,-0.55617545,-0.43453008,-0.52203203,1.2282798,-0.55617545,-0.43374239,-0.52203203,1.2287494,-0.55617545,-0.43453008,-0.52281973,1.2279768,-0.55617545,-0.43453008,-0.52203203,1.2278102,-0.55617545,-0.43453008,-0.52203203,1.2287948,-0.55617545,-0.43453008,-0.52203203,1.2283404,-0.55617545,-0.43531777,-0.52203203,1.2271437,-0.55618302,-0.43453008,-0.52203203,1.2280147,-0.55617545,-0.43689315,2.2519838,1.2109203,-0.53321877,-0.43531777,-0.52203203,1.2272573,-0.55618302,-0.43453008,-0.52203203,1.2285979,-0.55617545,-0.43453008,-0.52203203,1.228507,-0.55617545,-0.43689315,2.3544594,1.2104885,-0.53280978,-0.43610546,-0.52281973,1.2268104,-0.55618302,-0.43531777,-0.52203203,1.2271816,-0.55618302,-0.43531777,-0.52203203,1.227174,-0.55618302,-0.43531777,-0.52203203,1.2277875,-0.55618302,-0.43768084,-0.52281973,1.2231976,-0.55619059,-0.43689315,-0.52281973,1.2255001,-0.55619059,-0.43768084,-0.52281973,1.2239702,-0.55619059,-0.43847611,2.2401532,1.2078452,-0.53326422,-0.43689315,-0.52281973,1.2245988,-0.55619059,-0.43689315,-0.52281973,1.225235,-0.55619059,-0.43847611,-0.52281973,1.2237657,-0.55619059,-0.43689315,-0.52281973,1.2246443,-0.55619059,-0.43689315,-0.52281973,1.2249321,-0.55619059,-0.43768084,-0.52281973,1.2235006,-0.55619059,-0.43689315,-0.52281973,1.2254547,-0.55619059,-0.43689315,-0.52281973,1.2247958,-0.55619059,-0.43531777,-0.52203203,1.2283858,-0.55618302,-0.43531777,-0.52203203,1.2284237,-0.55618302,-0.43531777,-0.52203203,1.2281662,-0.55618302,-0.43610546,-0.52281973,1.2275678,-0.55618302,-0.43531777,-0.52203203,1.2286736,-0.55618302,-0.43531777,-0.52203203,1.2288175,-0.55618302,-0.43610546,-0.52281973,1.2272043,-0.55618302,-0.43531777,-0.52203203,1.2284994,-0.55618302,-0.43768084,-0.52281973,1.224614,-0.55619059,-0.43531777,-0.52203203,1.2282116,-0.55618302,-0.43610546,-0.52281973,1.2271058,-0.55618302,-0.4392638,2.2385778,1.207724,-0.53327179,-0.43689315,-0.52281973,1.2255759,-0.55619059,-0.43689315,-0.52281973,1.2256062,-0.55619059,-0.43847611,-0.52281973,1.224152,-0.55619059,-0.43768084,-0.52281973,1.2249018,-0.55619059,-0.43689315,-0.52281973,1.2256668,-0.55619059,-0.43531777,-0.52203203,1.2286206,-0.55618302,-0.43610546,-0.52203203,1.2275981,-0.55618302,-0.43768084,2.2480377,1.2108067,-0.53323392,-0.43531777,-0.52203203,1.2286206,-0.55618302,-0.43610546,-0.52281973,1.2264014,-0.55618302,-0.43610546,-0.52203203,1.2274391,-0.55618302,-0.43610546,-0.52281973,1.2273027,-0.55618302,-0.43610546,-0.52281973,1.2277799,-0.55618302,-0.43531777,-0.52203203,1.2281965,-0.55618302,-0.43689315,-0.52281973,1.2265832,-0.55619059,-0.43847611,2.2401532,1.208436,-0.53326422,-0.43689315,-0.52281973,1.2255304,-0.55619059,-0.43610546,-0.52281973,1.2266438,-0.55618302,-0.43610546,-0.52281973,1.2264847,-0.55618302,-0.43689315,-0.52281973,1.226,-0.55619059,-0.43531777,-0.52203203,1.2275754,-0.55618302,-0.43610546,-0.52203203,1.226,-0.55618302,-0.43768084,-0.52281973,1.2246443,-0.55619059,-0.43689315,-0.52281973,1.2262121,-0.55619059,-0.43531777,-0.52203203,1.2288402,-0.55618302,-0.43531777,-0.52203203,1.2282268,-0.55618302,-0.43531777,-0.52203203,1.2283404,-0.55618302,-0.43768084,-0.52281973,1.2250305,-0.55619059,-0.43689315,-0.52281973,1.2261742,-0.55619059,-0.43531777,-0.52203203,1.22881,-0.55618302,-0.43374239,-0.52203203,1.2306201,-0.55617545,-0.43374239,-0.52203203,1.2308473,-0.55617545,-0.43374239,-0.52203203,1.2309534,-0.55617545,-0.43374239,-0.52203203,1.2310746,-0.55617545,-0.43374239,-0.52203203,1.2310216,-0.55617545,-0.43689315,2.3607685,1.213094,-0.53274161,-0.43295469,-0.52203203,1.2316578,-0.55617545,-0.43295469,-0.52203203,1.232241,-0.55617545,-0.43295469,-0.52203203,1.2318395,-0.55617545,-0.43295469,-0.52203203,1.2318698,-0.55617545,-0.43453008,-0.52203203,1.228666,-0.55617545,-0.43531777,-0.52203203,1.227583,-0.55618302,-0.43531777,-0.52203203,1.2276814,-0.55618302,-0.44005149,2.1416236,1.2097539,-0.53366564,-0.43531777,-0.52281973,1.2271967,-0.55618302,-0.43610546,-0.52281973,1.2265756,-0.55618302,-0.43610546,-0.52203203,1.2266741,-0.55618302,-0.43610546,-0.52281973,1.2268559,-0.55618302,-0.43531777,-0.52281973,1.2271513,-0.55618302,-0.43453008,-0.52203203,1.228969,-0.55617545,-0.43453008,-0.52203203,1.2287039,-0.55617545,-0.43374239,-0.52203203,1.2302339,-0.55617545,-0.43531777,-0.52203203,1.2283479,-0.55618302,-0.43531777,-0.52203203,1.2281207,-0.55618302,-0.43531777,-0.52203203,1.2288478,-0.55618302,-0.43453008,-0.52203203,1.2291887,-0.55617545,-0.43453008,-0.52203203,1.2288402,-0.55617545,-0.43689315,-0.52281973,1.2258561,-0.55619059,-0.43610546,-0.52281973,1.2264014,-0.55618302,-0.43610546,-0.52281973,1.2263105,-0.55618302,-0.43689315,-0.52281973,1.2255607,-0.55619059,-0.4392638,-0.52281973,1.2220085,-0.55619817,-0.43847611,-0.52281973,1.2227205,-0.55619059,-0.44005149,2.3434242,1.207512,-0.53280978,-0.43689315,-0.52281973,1.2252578,-0.55619059,-0.43689315,-0.52281973,1.2245155,-0.55619059,-0.43847611,-0.52281973,1.2229098,-0.55619059,-0.43689315,-0.52281973,1.2249094,-0.55619059,-0.43689315,-0.52281973,1.225235,-0.55619059,-0.43768084,-0.52281973,1.2244171,-0.55619059,-0.43768084,-0.52281973,1.2249094,-0.55619059,-0.43847611,2.2425239,1.2092161,-0.53325664,-0.43531777,-0.52203203,1.2283025,-0.55618302,-0.43610546,-0.52281973,1.2271513,-0.55618302,-0.43610546,-0.52281973,1.2277117,-0.55618302,-0.43610546,-0.52203203,1.2278556,-0.55618302,-0.43531777,-0.52203203,1.2281207,-0.55618302,-0.43610546,-0.52281973,1.2271967,-0.55618302,-0.43610546,-0.52281973,1.2271058,-0.55618302,-0.43610546,-0.52281973,1.2265908,-0.55618302,-0.43610546,-0.52281973,1.2277723,-0.55618302,-0.43610546,-0.52281973,1.2272876,-0.55618302,-0.43531777,-0.52281973,1.2278708,-0.55618302,-0.43453008,-0.52203203,1.2286888,-0.55617545,-0.43453008,-0.52203203,1.2295976,-0.55617545,-0.43610546,-0.52281973,1.2273179,-0.55618302,-0.43531777,-0.52203203,1.2285979,-0.55618302,-0.43453008,-0.52203203,1.2300066,-0.55617545,-0.43531777,-0.52203203,1.2284085,-0.55618302,-0.43531777,-0.52281973,1.2279238,-0.55618302,-0.43610546,-0.52203203,1.2272573,-0.55618302,-0.43847611,2.3536717,1.2111248,-0.53277191,-0.43374239,-0.52203203,1.2304081,-0.55617545,-0.43531777,-0.52203203,1.228401,-0.55618302,-0.43453008,-0.52203203,1.2291053,-0.55617545,-0.43453008,-0.52203203,1.2298779,-0.55617545,-0.43453008,-0.52203203,1.2298249,-0.55617545,-0.43374239,-0.52203203,1.2308246,-0.55617545,-0.43453008,-0.52203203,1.2307262,-0.55617545,-0.43531777,2.2559222,1.214268,-0.53320363,-0.43531777,-0.52203203,1.2281434,-0.55618302,-0.43610546,-0.52281973,1.227636,-0.55618302,-0.43531777,-0.52203203,1.2295219,-0.55618302,-0.43531777,-0.52203203,1.2285524,-0.55618302,-0.43531777,-0.52203203,1.2284313,-0.55618302,-0.43531777,-0.52203203,1.2283101,-0.55618302,-0.43531777,-0.52203203,1.229272,-0.55618302,-0.43768084,2.2464623,1.2105188,-0.5332415,-0.43610546,-0.52281973,1.2268634,-0.55618302,-0.43689315,-0.52281973,1.226924,-0.55619059,-0.43689315,-0.52281973,1.2258258,-0.55619059,-0.43689315,-0.52281973,1.2258334,-0.55619059,-0.43610546,-0.52281973,1.2274845,-0.55618302,-0.43610546,-0.52281973,1.2272194,-0.55618302,-0.43531777,-0.52203203,1.228666,-0.55618302,-0.43689315,2.2464623,1.2109203,-0.5332415,-0.43531777,-0.52203203,1.2288327,-0.55618302,-0.43531777,-0.52281973,1.2281965,-0.55618302,-0.43374239,-0.52203203,1.2305217,-0.55617545,-0.43453008,-0.52203203,1.2304081,-0.55617545,-0.43453008,-0.52203203,1.2298703,-0.55617545,-0.43453008,-0.52203203,1.2298703,-0.55617545,-0.43453008,-0.52203203,1.2298703,-0.55617545,-0.43453008,-0.52203203,1.2298703,-0.55617545,-0.43453008,-0.52203203,1.2298703,-0.55617545,-0.43453008,-0.52203203,1.2298703,-0.55617545,-0.43453008,-0.52203203,1.2298703,-0.55617545:3
-0.50813188,-0.50813188,1.2728018,-0.50813188,-0.50813188,-0.50813188,1.2720475,-0.50813188,-0.50813188,-0.50813188,1.2699598,-0.50813188,-0.50813188,-0.50813188,1.2699598,-0.50813188,-0.50813188,-0.50813188,1.2707598,-0.50813188,-0.50813188,-0.50813188,1.2755906,-0.50813188,-0.50813188,-0.50813188,1.2742876,-0.50813188,-0.50813188,-0.50813188,1.2712322,-0.50813188,-0.50813188,-0.50813188,1.2748743,-0.50813188,-0.50813188,-0.50813188,1.2761392,-0.50813188,-0.50813188,-0.50813188,1.2749277,-0.50813188,-0.50813188,-0.50813188,1.2755982,-0.50813188,-0.50813188,-0.50813188,1.2759335,-0.50813188,-0.50813188,-0.50813188,1.275842,-0.50813188,-0.50813188,-0.50813188,1.275042,-0.50813188,-0.50813188,-0.50813188,1.2752629,-0.50813188,-0.52626634,-0.34249109,1.2744477,-0.50307251,-0.53100568,-0.50261534,1.2730838,-0.50803282,-0.53100568,-0.50261534,1.2753468,-0.50803282,-0.53100568,-0.50261534,1.2755525,-0.50803282,-0.53100568,-0.50261534,1.2751029,-0.50803282,-0.12084682,8.125015,1.2367158,-0.47037715,-0.12479373,8.1344861,1.2382244,-0.47036953,-0.53100568,-0.50340015,1.2765811,-0.50803282,-0.53100568,-0.50340015,1.2772821,-0.50803282,-0.53100568,-0.50261534,1.2782879,-0.50803282,-0.53100568,-0.50261534,1.274181,-0.50803282,-0.53809946,1.2618754,1.2662567,-0.4914375,-0.53100568,-0.50261534,1.2736324,-0.50803282,-0.53100568,-0.50261534,1.2726342,-0.50803282,-0.53100568,-0.50261534,1.2740819,-0.50803282,-0.53100568,-0.50261534,1.274021,-0.50803282,-0.53100568,-0.50261534,1.2746915,-0.50803282,-0.53100568,-0.50261534,1.2763525,-0.50803282,-0.54598566,0.56144327,1.2712856,-0.49514821,-0.53100568,-0.50261534,1.2778841,-0.50803282,-0.53100568,-0.50261534,1.2751639,-0.50803282,-0.53100568,-0.50340015,1.2781203,-0.50803282,-0.53100568,-0.50261534,1.2775945,-0.50803282,-0.53100568,-0.50261534,1.2783031,-0.50777376,-0.53100568,-0.50261534,1.279728,-0.50803282,-0.53100568,-0.50340015,1.2785241,-0.50803282,-0.53100568,-0.50340015,1.2788517,-0.50803282,-0.53100568,-0.50261534,1.2791946,-0.50803282,-0.53100568,-0.50261534,1.2792708,-0.50803282,-0.53100568,-0.50261534,1.2810385,-0.50803282,-0.53336773,1.4101666,1.2727409,-0.49074413,-0.53100568,-0.50261534,1.2815567,-0.50803282,-0.53100568,-0.50261534,1.2806957,-0.50803282,-0.53100568,-0.50340015,1.2814576,-0.50803282,-0.53100568,-0.50261534,1.2813433,-0.50803282,-0.51917256,1.9268159,1.2714227,-0.48855733,-0.53179049,-0.50261534,1.2833473,-0.50803282,-0.53179049,-0.50261534,1.2843073,-0.50803282,-0.53179049,-0.50261534,1.2834615,-0.50803282,-0.53100568,-0.50261534,1.2821662,-0.50803282,-0.53100568,-0.50261534,1.2817319,-0.50803282,-0.53100568,-0.50261534,1.2821662,-0.50803282,-0.53179049,-0.50261534,1.2809395,-0.50803282,-0.53179049,-0.50261534,1.2822043,-0.50803282,-0.53100568,-0.50261534,1.2807185,-0.50803282,-0.53100568,-0.50261534,1.2780745,-0.50803282,-0.53100568,-0.50261534,1.2801394,-0.50803282,-0.53100568,-0.50261534,1.280528,-0.50803282,-0.53100568,-0.50261534,1.2792327,-0.50803282,-0.53100568,-0.50261534,1.2808176,-0.50803282,-0.53100568,-0.50261534,1.28097,-0.50803282,-0.54598566,0.85329382,1.274341,-0.4935024,-0.53179049,-0.50261534,1.2814043,-0.50803282,-0.50813188,-0.50813188,1.2797737,-0.50813188,-0.50813188,-0.50813188,1.2812214,-0.50813188,-0.50813188,-0.50813188,1.2817091,-0.50813188,-0.50813188,-0.50813188,1.2810004,-0.50813188,-0.50813188,-0.50813188,1.2804518,-0.50813188,-0.50813188,-0.50813188,1.2819605,-0.50813188,-0.50813188,-0.50813188,1.282532,-0.50813188,-0.50813188,-0.50813188,1.2815262,-0.50813188,-0.50813188,-0.50813188,1.2836292,-0.50813188,-0.50813188,-0.50813188,1.2832939,-0.50813188,-0.50813188,-0.50813188,1.2813662,-0.50813188,-0.50813188,-0.50813188,1.2832482,-0.50813188,-0.50813188,-0.50813188,1.2824862,-0.50813188,-0.50813188,-0.50813188,1.2843835,-0.50813188,-0.50813188,-0.50813188,1.283073,-0.50813188,-0.50813188,-0.50813188,1.2829891,-0.50813188,-0.50813188,-0.50813188,1.2837892,-0.50813188,-0.53100568,-0.48289602,1.2813357,-0.50636415,-0.53179049,-0.50261534,1.2827225,-0.50803282,-0.53100568,-0.50261534,1.2819986,-0.50803282,-0.53100568,-0.50261534,1.2821967,-0.50803282,-0.53100568,-0.50261534,1.2783488,-0.50803282,-0.53100568,-0.50261534,1.2763754,-0.50803282,-0.53100568,-0.50340015,1.2740667,-0.50803282,-0.53100568,-0.50261534,1.2739143,-0.50803282,-0.53100568,-0.50261534,1.2751944,-0.50803282,-0.53100568,-0.50261534,1.2743105,-0.50803282,-0.53100568,-0.50261534,1.2740743,-0.50803282,-0.53100568,-0.50261534,1.2726799,-0.50803282,-0.53100568,-0.50261534,1.2729161,-0.50803282,-0.53100568,-0.50261534,1.2742114,-0.50803282,-0.53100568,-0.50261534,1.2757582,-0.50803282,-0.53100568,-0.50261534,1.2743867,-0.50803282,-0.5246891,7.1445654,1.240175,-0.47346305,-0.53100568,-0.50261534,1.2739829,-0.50803282,-0.53100568,-0.50261534,1.2746839,-0.50803282,-0.53100568,-0.50261534,1.2741505,-0.50803282,-0.53100568,-0.50340015,1.2745467,-0.50803282,-0.53100568,-0.50340015,1.2721618,-0.50803282,-0.53100568,-0.50261534,1.2736476,-0.50803282,-0.53100568,-0.50261534,1.2747601,-0.50803282,-0.53100568,-0.50261534,1.2759868,-0.50803282,-0.53100568,-0.50261534,1.2758649,-0.50803282,-0.53100568,-0.50261534,1.2741429,-0.50803282,-0.53100568,-0.50261534,1.2743867,-0.50803282,-0.53100568,-0.50261534,1.2762001,-0.50803282,-0.53100568,-0.50261534,1.2763144,-0.50803282,-0.53100568,-0.50261534,1.2753239,-0.50803282,-0.53100568,-0.50261534,1.2764287,-0.50803282,-0.53100568,-0.50261534,1.2769088,-0.50803282,-0.53100568,-0.50340015,1.2771526,-0.50803282,-0.53100568,-0.50340015,1.2773278,-0.50803282,-0.53100568,-0.50261534,1.2774574,-0.50803282,-0.53100568,-0.50261534,1.2777012,-0.50803282,-0.53100568,-0.50261534,1.2767259,-0.50803282,-0.53100568,-0.50261534,1.2776555,-0.50803282,-0.53100568,-0.50261534,1.2781431,-0.50803282,-0.53100568,-0.50261534,1.2787298,-0.50803282,-0.53100568,-0.50261534,1.2776326,-0.50803282,-0.53100568,-0.50261534,1.2774726,-0.50803282,-0.53100568,-0.50261534,1.2791184,-0.50803282,-0.53100568,-0.50340015,1.2797889,-0.50803282,-0.53100568,-0.50261534,1.2814195,-0.50803282,-0.53100568,-0.50261534,1.2777088,-0.50803282,-0.50813188,-0.50813188,1.2787755,-0.50813188,-0.50813188,-0.50813188,1.2768402,-0.50813188,-0.50813188,-0.50813188,1.2785698,-0.50813188,-0.50813188,-0.50813188,1.2770764,-0.50813188,-0.50813188,-0.50813188,1.2770383,-0.50813188,-0.50813188,-0.50813188,1.2759792,-0.50813188,-0.50813188,-0.50813188,1.2754306,-0.50813188,-0.50813188,-0.50813188,1.277145,-0.50813188,-0.50813188,-0.50813188,1.2766802,-0.50813188,-0.50813188,-0.50813188,1.2761087,-0.50813188,-0.50813188,-0.50813188,1.2768249,-0.50813188,-0.50813188,-0.50813188,1.2804137,-0.50813188,-0.50813188,-0.50813188,1.2796289,-0.50813188,-0.50813188,-0.50813188,1.2783184,-0.50813188,-0.50813188,-0.50813188,1.2766573,-0.50813188,-0.50813188,-0.50813188,1.2776098,-0.50813188,-0.50813188,-0.50813188,1.2789203,-0.50813188,-0.50813188,-0.50813188,1.2791718,-0.50813188,-0.50813188,-0.50813188,1.279248,-0.50813188,-0.50813188,-0.50813188,1.2792784,-0.50813188,-0.50813188,-0.50813188,1.2773583,-0.50813188,-0.50813188,-0.50813188,1.2732133,-0.50813188,-0.50813188,-0.50813188,1.2754839,-0.50813188,-0.50813188,-0.50813188,1.275423,-0.50813188,-0.50813188,-0.50813188,1.2766649,-0.50813188,-0.50813188,-0.50813188,1.2766954,-0.50813188,-0.50813188,-0.50813188,1.2778002,-0.50813188,-0.50813188,-0.50813188,1.278166,-0.50813188,-0.50813188,-0.50813188,1.2786155,-0.50813188,-0.50813188,-0.50813188,1.2789203,-0.50813188,-0.50813188,-0.50813188,1.276863,-0.50813188,-0.50813188,-0.50813188,1.2765354,-0.50813188,-0.50813188,-0.50813188,1.2762535,-0.50813188,-0.50813188,-0.50813188,1.2759944,-0.50813188,-0.50813188,-0.50813188,1.2767335,-0.50813188,-0.50813188,-0.50813188,1.2769773,-0.50813188,-0.50813188,-0.50813188,1.2776936,-0.50813188,-0.50813188,-0.50813188,1.2765354,-0.50813188,-0.50813188,-0.50813188,1.2777164,-0.50813188,-0.50813188,-0.50813188,1.2777317,-0.50813188,-0.50813188,-0.50813188,1.2783412,-0.50813188,-0.50813188,-0.50813188,1.279027,-0.50813188,-0.50813188,-0.50813188,1.2805661,-0.50813188,-0.50813188,-0.50813188,1.2791489,-0.50813188,-0.50813188,-0.50813188,1.2790117,-0.50813188,-0.50813188,-0.50813188,1.279347,-0.50813188,-0.50813188,-0.50813188,1.2802309,-0.50813188,-0.50813188,-0.50813188,1.2807033,-0.50813188,-0.50813188,-0.50813188,1.2794918,-0.50813188,-0.50813188,-0.50813188,1.2799718,-0.50813188,-0.50813188,-0.50813188,1.2800709,-0.50813188,-0.50813188,-0.50813188,1.2796213,-0.50813188,-0.50813188,-0.50813188,1.2811909,-0.50813188,-0.50813188,-0.50813188,1.2799032,-0.50813188,-0.50813188,-0.50813188,1.2815186,-0.50813188,-0.50813188,-0.50813188,1.2787603,-0.50813188,-0.50813188,-0.50813188,1.279027,-0.50813188,-0.50813188,-0.50813188,1.2811681,-0.50813188,-0.50813188,-0.50813188,1.2818386,-0.50813188,-0.50813188,-0.50813188,1.2808861,-0.50813188,-0.50813188,-0.50813188,1.2811224,-0.50813188,-0.50813188,-0.50813188,1.2821053,-0.50813188,-0.53731465,7.7913638,1.2439619,-0.47203058,-0.53179049,-0.50261534,1.2829968,-0.50803282,-0.53179049,-0.50261534,1.2818386,-0.50803282,-0.53179049,-0.50261534,1.2805661,-0.50803282,-0.53179049,-0.50261534,1.2835682,-0.50803282,-0.11926958,8.2204572,1.2431924,-0.47010284,-0.12242406,8.1810185,1.2423695,-0.47025523,-0.53809946,7.8016197,1.2428724,-0.47196201,-0.53179049,-0.50261534,1.2801318,-0.50803282,-0.53179049,-0.50261534,1.2803528,-0.50803282,-0.53179049,-0.50261534,1.2820291,-0.50803282,-0.53179049,-0.50261534,1.2821891,-0.50803282,-0.53179049,-0.50261534,1.2813586,-0.50803282,-0.53179049,-0.50261534,1.2816252,-0.50803282,-0.53100568,-0.50261534,1.2798804,-0.50803282,-0.53100568,-0.50261534,1.2798804,-0.50803282,-0.53100568,-0.50261534,1.2787832,-0.50803282,-0.53100568,-0.50261534,1.2752401,-0.50803282,-0.53179049,-0.50261534,1.2787755,-0.50803282,-0.53100568,-0.50261534,1.2789432,-0.50803282,-0.53179049,-0.50261534,1.2798423,-0.50803282,-0.53179049,-0.50261534,1.2787222,-0.50803282,-0.53100568,-0.50261534,1.2809471,-0.50803282,-0.53179049,-0.50261534,1.2784403,-0.50803282,-0.53100568,-0.50261534,1.2741124,-0.50803282,-0.53100568,-0.50261534,1.2755525,-0.50803282,-0.53100568,-0.49078223,1.2735181,-0.50680608,-0.53100568,-0.50261534,1.276985,-0.50803282,-0.53100568,-0.50261534,1.275682,-0.50803282,-0.53100568,-0.50261534,1.2750344,-0.50803282,-0.53100568,-0.50261534,1.2763754,-0.50803282,-0.54598566,0.59457295,1.2691749,-0.4949501,-0.53100568,-0.50261534,1.2743029,-0.50803282,-0.53100568,-0.50261534,1.2759487,-0.50803282,-0.51917256,0.052687794,1.2746991,-0.49874463,-0.53100568,-0.50261534,1.2773888,-0.50803282,-0.53100568,-0.50261534,1.2784784,-0.50803282,-0.53100568,-0.50261534,1.2778383,-0.50803282,-0.53100568,-0.50261534,1.2776402,-0.50803282,-0.53100568,-0.50261534,1.2791108,-0.50803282,-0.53179049,-0.50261534,1.280269,-0.50803282,-0.53179049,-0.50261534,1.279027,-0.50803282,-0.53100568,-0.50261534,1.2790575,-0.50803282,-0.53100568,-0.50261534,1.2800099,-0.50803282,-0.53179049,-0.50261534,1.2799261,-0.50803282,-0.53179049,-0.50261534,1.2791946,-0.50803282,-0.53100568,-0.50261534,1.2787374,-0.50803282,-0.53179049,-0.50261534,1.2790803,-0.50803282,-0.53100568,-0.50261534,1.2792175,-0.50803282,-0.53889189,5.142658,1.2523129,-0.47828621,-0.53179049,-0.50261534,1.2777621,-0.50803282,-0.53100568,-0.50261534,1.2764744,-0.50803282,-0.53100568,-0.50261534,1.2780517,-0.50803282,-0.53179049,-0.50261534,1.2800709,-0.50803282,-0.50813188,-0.50813188,1.2808481,-0.50813188,-0.50813188,-0.50813188,1.2811452,-0.50813188,-0.50813188,-0.50813188,1.2810233,-0.50813188,-0.50813188,-0.50813188,1.2799566,-0.50813188,-0.50813188,-0.50813188,1.279187,-0.50813188,-0.50813188,-0.50813188,1.2774802,-0.50813188,-0.50813188,-0.50813188,1.2795985,-0.50813188,-0.50813188,-0.50813188,1.2803604,-0.50813188,-0.50813188,-0.50813188,1.2794156,-0.50813188,-0.50813188,-0.50813188,1.2773888,-0.50813188,-0.50813188,-0.50813188,1.2764592,-0.50813188,-0.50813188,-0.50813188,1.2802766,-0.50813188,-0.50813188,-0.50813188,1.2809395,-0.50813188,-0.50813188,-0.50813188,1.2796213,-0.50813188,-0.50813188,-0.50813188,1.276924,-0.50813188,-0.50813188,-0.50813188,1.2772897,-0.50813188,-0.50813188,-0.50813188,1.279888,-0.50813188,-0.50813188,-0.50813188,1.279286,-0.50813188,-0.50813188,-0.50813188,1.2775259,-0.50813188,-0.50813188,-0.50813188,1.2758115,-0.50813188,-0.50813188,-0.50813188,1.2765735,-0.50813188,-0.50813188,-0.50813188,1.2775488,-0.50813188,-0.50813188,-0.50813188,1.277244,-0.50813188,-0.50813188,-0.50813188,1.2748667,-0.50813188,-0.50813188,-0.50813188,1.2786155,-0.50813188,-0.50813188,-0.50813188,1.2772897,-0.50813188,-0.50813188,-0.50813188,1.2782727,-0.50813188,-0.50813188,-0.50813188,1.2769011,-0.50813188,-0.50813188,-0.50813188,1.2778536,-0.50813188,-0.50813188,-0.50813188,1.2801242,-0.50813188,-0.50813188,-0.50813188,1.2807642,-0.50813188,-0.50813188,-0.50813188,1.2823567,-0.50813188,-0.50813188,-0.50813188,1.280429,-0.50813188,-0.50813188,-0.50813188,1.2814957,-0.50813188,-0.50813188,-0.50813188,1.2811757,-0.50813188,-0.50813188,-0.50813188,1.2803604,-0.50813188,-0.50813188,-0.50813188,1.2801699,-0.50813188,-0.50813188,-0.50813188,1.279408,-0.50813188,-0.50813188,-0.50813188,1.2789127,-0.50813188,-0.50813188,-0.50813188,1.2794461,-0.50813188,-0.50813188,-0.50813188,1.2789813,-0.50813188,-0.50813188,-0.50813188,1.2807338,-0.50813188,-0.50813188,-0.50813188,1.2809471,-0.50813188,-0.50813188,-0.50813188,1.2813586,-0.50813188,-0.50813188,-0.50813188,1.2822881,-0.50813188,-0.50813188,-0.50813188,1.2820596,-0.50813188,-0.50813188,-0.50813188,1.2804823,-0.50813188,-0.50813188,-0.50813188,1.2814652,-0.50813188,-0.50813188,-0.50813188,1.2839111,-0.50813188,-0.50813188,-0.50813188,1.2830653,-0.50813188,-0.50813188,-0.50813188,1.2808938,-0.50813188,-0.50813188,-0.50813188,1.2846426,-0.50813188,-0.50813188,-0.50813188,1.2852902,-0.50813188,-0.50813188,-0.50813188,1.2850388,-0.50813188,-0.50813188,-0.50813188,1.2867379,-0.50813188,-0.50813188,-0.50813188,1.286616,-0.50813188,-0.50813188,-0.50813188,1.2869056,-0.50813188,-0.50813188,-0.50813188,1.2863798,-0.50813188,-0.50813188,-0.50813188,1.287637,-0.50813188,-0.50813188,-0.50813188,1.2863341,-0.50813188,-0.50813188,-0.50813188,1.2868446,-0.50813188,-0.50813188,-0.50813188,1.2855798,-0.50813188,-0.50813188,-0.50813188,1.2866998,-0.50813188,-0.50813188,-0.50813188,1.2849397,-0.50813188,-0.50813188,-0.50813188,1.2860674,-0.50813188,-0.50813188,-0.50813188,1.2864255,-0.50813188,-0.50813188,-0.50813188,1.2853055,-0.50813188,-0.50813188,-0.50813188,1.2865703,-0.50813188,-0.50813188,-0.50813188,1.2869208,-0.50813188,-0.50813188,-0.50813188,1.2869056,-0.50813188,-0.50813188,-0.50813188,1.2864713,-0.50813188,-0.50813188,-0.50813188,1.2860598,-0.50813188,-0.50813188,-0.50813188,1.2876142,-0.50813188,-0.50813188,-0.50813188,1.2883152,-0.50813188,-0.50813188,-0.50813188,1.2894581,-0.50813188,-0.50813188,-0.50813188,1.2898619,-0.50813188,-0.50813188,-0.50813188,1.28958,-0.50813188,-0.50813188,-0.50813188,1.2890086,-0.50813188,-0.50813188,-0.50813188,1.2889781,-0.50813188,-0.50813188,-0.50813188,1.287919,-0.50813188,-0.50813188,-0.50813188,1.2851531,-0.50813188,-0.50813188,-0.50813188,1.2861741,-0.50813188,-0.50813188,-0.50813188,1.28878,-0.50813188,-0.50813188,-0.50813188,1.2863951,-0.50813188,-0.50813188,-0.50813188,1.2876523,-0.50813188,-0.50813188,-0.50813188,1.2861055,-0.50813188,-0.50813188,-0.50813188,1.2865932,-0.50813188,-0.50813188,-0.50813188,1.2887571,-0.50813188,-0.50813188,-0.50813188,1.2881476,-0.50813188,-0.50813188,-0.50813188,1.2871342,-0.50813188,-0.50813188,-0.50813188,1.2868218,-0.50813188,-0.50813188,-0.50813188,1.2886276,-0.50813188,-0.50813188,-0.50813188,1.2831491,-0.50813188,-0.50813188,-0.50813188,1.2842083,-0.50813188,-0.50813188,-0.50813188,1.2892752,-0.50813188,-0.50813188,-0.50813188,1.2871723,-0.50813188,-0.50813188,-0.50813188,1.2893972,-0.50813188,-0.53809946,7.8812818,1.2508729,-0.47178676,-0.5246891,6.8314259,1.2539969,-0.47414881,-0.53179049,-0.50340015,1.2878733,-0.50803282,-0.53179049,-0.50261534,1.2853207,-0.50803282,-0.53179049,-0.50261534,1.2867684,-0.50803282,-0.53179049,-0.50261534,1.2888485,-0.50803282,-0.53179049,-0.50261534,1.2876218,-0.50803282,-0.53179049,-0.50261534,1.2881628,-0.50803282,-0.53179049,-0.50340015,1.2867456,-0.50803282,-0.53179049,-0.50261534,1.2838273,-0.50803282,-0.53179049,-0.50261534,1.2846731,-0.50803282,-0.53179049,-0.50261534,1.2837739,-0.50803282,-0.53179049,-0.50261534,1.2837739,-0.50803282,-0.53179049,-0.50261534,1.2837739,-0.50803282,-0.53179049,-0.50261534,1.2837739,-0.50803282,-0.53179049,-0.50261534,1.2837739,-0.50803282,-0.53179049,-0.50261534,1.2837739,-0.50803282,-0.53179049,-0.50261534,1.2837739,-0.50803282,-0.53179049,-0.50261534,1.2837739,-0.50803282:3
-0.50828704,-0.50828704,1.3111636,-0.50828704,-0.50828704,-0.50828704,1.3114072,-0.50828704,-0.50828704,-0.50828704,1.3098234,-0.50828704,-0.50828704,-0.50828704,1.3117804,-0.50828704,-0.50828704,-0.50828704,1.3124352,-0.50828704,-0.50828704,-0.50828704,1.313448,-0.50828704,-0.50828704,-0.50828704,1.3131662,-0.50828704,-0.50828704,-0.50828704,1.3131814,-0.50828704,-0.50828704,-0.50828704,1.3128845,-0.50828704,-0.50828704,-0.50828704,1.3126941,-0.50828704,-0.50828704,-0.50828704,1.3121078,-0.50828704,-0.50828704,-0.50828704,1.314712,-0.50828704,-0.50828704,-0.50828704,1.3133261,-0.50828704,-0.50828704,-0.50828704,1.3127855,-0.50828704,-0.50828704,-0.50828704,1.3120545,-0.50828704,-0.50828704,-0.50828704,1.3116281,-0.50828704,-0.50828704,-0.50828704,1.3117118,-0.50828704,-0.50828704,-0.50828704,1.3122829,-0.50828704,-0.50828704,-0.50828704,1.3106306,-0.50828704,-0.50828704,-0.50828704,1.3119555,-0.50828704,-0.50828704,-0.50828704,1.3079883,-0.50828704,-0.50828704,-0.50828704,1.3094351,-0.50828704,-0.50828704,-0.50828704,1.308133,-0.50828704,-0.50828704,-0.50828704,1.3082777,-0.50828704,-0.50828704,-0.50828704,1.308468,-0.50828704,-0.50828704,-0.50828704,1.3084071,-0.50828704,-0.50828704,-0.50828704,1.308331,-0.50828704,-0.50828704,-0.50828704,1.3088868,-0.50828704,-0.50828704,-0.50828704,1.3085594,-0.50828704,-0.50828704,-0.50828704,1.3083843,-0.50828704,-0.50828704,-0.50828704,1.2972061,-0.50828704,-0.50828704,-0.50828704,1.2963684,-0.50828704,-0.50828704,-0.50828704,1.297069,-0.50828704,-0.50828704,-0.50828704,1.2970614,-0.50828704,-0.50828704,-0.50828704,1.2965893,-0.50828704,-0.50828704,-0.50828704,1.2954014,-0.50828704,-0.50828704,-0.50828704,1.2959496,-0.50828704,-0.50828704,-0.50828704,1.2961857,-0.50828704,-0.50828704,-0.50828704,1.2955156,-0.50828704,-0.50828704,-0.50828704,1.2962542,-0.50828704,-0.50828704,-0.50828704,1.2966959,-0.50828704,-0.50828704,-0.50828704,1.2959192,-0.50828704,-0.50828704,-0.50828704,1.2974878,-0.50828704,-0.50828704,-0.50828704,1.2991402,-0.50828704,-0.50828704,-0.50828704,1.2965664,-0.50828704,-0.50828704,-0.50828704,1.2970157,-0.50828704,-0.50828704,-0.50828704,1.2826774,-0.50828704,-0.50828704,-0.50828704,1.2840404,-0.50828704,-0.50828704,-0.50828704,1.296437,-0.50828704,-0.50828704,-0.50828704,1.2968025,-0.50828704,-0.50828704,-0.50828704,1.296673,-0.50828704,-0.50828704,-0.50828704,1.2969167,-0.50828704,-0.50828704,-0.50828704,1.2973127,-0.50828704,-0.50828704,-0.50828704,1.2989498,-0.50828704,-0.50828704,-0.50828704,1.2972061,-0.50828704,-0.50828704,-0.50828704,1.297366,-0.50828704,-0.50828704,-0.50828704,1.2962771,-0.50828704,-0.50828704,-0.50828704,1.2960182,-0.50828704,-0.50828704,-0.50828704,1.2961629,-0.50828704,-0.50828704,-0.50828704,1.2964294,-0.50828704,-0.50828704,-0.50828704,1.2966426,-0.50828704,-0.52247301,10.426517,1.2741567,-0.46156398,-0.52325731,10.413115,1.2739664,-0.46161728,-0.49331678,0.57478799,1.2931627,-0.49377366,-0.50828704,-0.48149134,1.2953557,-0.5081043,-0.50828704,-0.48149134,1.2956374,-0.5081043,-0.43892583,2.200973,1.2891727,-0.48594587,-0.50198217,-0.39004784,1.3016606,-0.50763219,-0.49410108,2.6896995,1.2960639,-0.4830904,-0.50750274,-0.48149134,1.3023764,-0.50809668,-0.50828704,-0.48149134,1.2951425,-0.5081043,-0.50828704,-0.48149134,1.29448,-0.5081043,-0.50828704,-0.48149134,1.2947389,-0.5081043,-0.50828704,-0.48149134,1.2948455,-0.5081043,-0.50828704,-0.48149134,1.2950587,-0.5081043,-0.50828704,-0.48149134,1.2958659,-0.5081043,-0.50828704,-0.48149134,1.2957517,-0.5081043,-0.50828704,-0.48149134,1.2967796,-0.5081043,-0.28284979,10.747334,1.2846877,-0.46043702,-0.50592653,-0.48149134,1.3066024,-0.50809668,-0.50592653,-0.48149134,1.3071507,-0.50809668,-0.28363409,10.755223,1.2852435,-0.46042179,-0.50592653,-0.48149134,1.3074172,-0.50808145,-0.50592653,-0.48149134,1.3069832,-0.50809668,-0.50592653,-0.48149134,1.3077827,-0.50809668,-0.50513461,-0.48149134,1.3107295,-0.50808907,-0.50513461,-0.48306756,1.3109428,-0.50809668,-0.50513461,-0.48306756,1.3116509,-0.50809668,-0.50513461,-0.48149134,1.3116357,-0.50808907,-0.50513461,-0.48149134,1.312321,-0.50808907,-0.50513461,-0.48149134,1.3119403,-0.50808907,-0.50513461,-0.48149134,1.3115062,-0.50808907,-0.50435031,-0.48149134,1.3121154,-0.50808907,-0.50435031,-0.48149134,1.313387,-0.50808907,-0.50435031,-0.48149134,1.3128159,-0.50808907,-0.50435031,-0.48149134,1.3127474,-0.50808907,-0.50435031,-0.48149134,1.312656,-0.50808907,-0.50435031,-0.48149134,1.3122829,-0.50808907,-0.50750274,-0.48227564,1.3027571,-0.50809668,-0.50513461,-0.48149134,1.3099985,-0.50808907,-0.50592653,-0.48227564,1.3076837,-0.50809668,-0.50513461,-0.48227564,1.3106153,-0.50809668,-0.50513461,-0.48227564,1.3101051,-0.50809668,-0.50435031,-0.48227564,1.3117804,-0.50808907,-0.50513461,-0.48227564,1.3108133,-0.50808907,-0.50513461,-0.48227564,1.3100823,-0.50809668,-0.50513461,-0.48227564,1.3101965,-0.50808907,-0.50513461,-0.48306756,1.3111331,-0.50808907,-0.50513461,-0.48227564,1.3111788,-0.50809668,-0.50513461,-0.48227564,1.310859,-0.50809668,-0.50513461,-0.48227564,1.3109732,-0.50809668,-0.50513461,-0.48227564,1.3105925,-0.50809668,-0.50592653,-0.48306756,1.3073334,-0.50809668,-0.50828704,-0.48306756,1.2971984,-0.5081043,-0.51143948,-0.48385186,1.2832714,-0.50811191,-0.51143948,-0.48385186,1.2821063,-0.50811952,-0.51064756,-0.48385186,1.284543,-0.50811191,-0.51064756,-0.48385186,1.285609,-0.50811191,-0.50828704,-0.48306756,1.2948684,-0.5081043,-0.50828704,-0.48306756,1.294145,-0.5081043,-0.50828704,-0.48306756,1.2951653,-0.5081043,-0.50828704,-0.48306756,1.2938176,-0.5081043,-0.50828704,-0.48306756,1.2946323,-0.5081043,-0.50828704,-0.48306756,1.2952034,-0.5081043,-0.50828704,-0.48306756,1.2945866,-0.50811191,-0.50828704,-0.48306756,1.297366,-0.5081043,-0.50828704,-0.48306756,1.2980437,-0.5081043,-0.50828704,-0.48306756,1.2982569,-0.5081043,-0.50828704,-0.48306756,1.2978914,-0.5081043,-0.50750274,-0.48306756,1.3017063,-0.5081043,-0.50828704,-0.48306756,1.2976705,-0.5081043,-0.50828704,-0.48306756,1.2961248,-0.5081043,-0.50828704,-0.48306756,1.297602,-0.5081043,-0.50828704,-0.48306756,1.2972822,-0.5081043,-0.50750274,-0.48306756,1.2996656,-0.5081043,-0.50828704,-0.48306756,1.2950892,-0.5081043,-0.50828704,-0.48306756,1.2953557,-0.5081043,-0.50828704,-0.48306756,1.2959344,-0.5081043,-0.50828704,-0.48306756,1.2957288,-0.5081043,-0.50828704,-0.48306756,1.2949902,-0.5081043,-0.50907135,-0.48306756,1.29298,-0.50811191,-0.50907135,-0.48306756,1.2925535,-0.50811191,-0.50907135,-0.48306756,1.2917312,-0.50811191,-0.50907135,-0.48306756,1.2914418,-0.50811191,-0.51143948,-0.48385186,1.2819617,-0.50811952,-0.51143948,-0.48385186,1.2817713,-0.50811952,-0.52877788,1.1423331,1.2912134,-0.49023288,-0.51143948,-0.48385186,1.2827307,-0.50811952,-0.50828704,-0.48306756,1.2943125,-0.5081043,-0.50907135,-0.48306756,1.2928201,-0.50811191,-0.50907135,-0.48306756,1.2929419,-0.50811191,-0.50828704,-0.48306756,1.2937566,-0.5081043,-0.50828704,-0.48306756,1.2940232,-0.5081043,-0.50828704,-0.48306756,1.2971147,-0.5081043,-0.50828704,-0.48306756,1.2959649,-0.5081043,-0.50828704,-0.48306756,1.2979142,-0.5081043,-0.50828704,-0.48306756,1.2972441,-0.5081043,-0.50828704,-0.48306756,1.2961476,-0.5081043,-0.50828704,-0.48306756,1.2965436,-0.5081043,-0.50828704,-0.48306756,1.2968862,-0.5081043,-0.50828704,-0.48306756,1.2955918,-0.5081043,-0.50828704,-0.48306756,1.296041,-0.5081043,-0.50828704,-0.48306756,1.2960639,-0.50808907,-0.50828704,-0.48306756,1.2955689,-0.5081043,-0.50828704,-0.48306756,1.2951806,-0.5081043,-0.50828704,-0.48306756,1.2952796,-0.5081043,-0.50828704,-0.48306756,1.2968101,-0.5081043,-0.50828704,-0.48306756,1.2954166,-0.5081043,-0.50592653,-0.48306756,1.3084756,-0.50809668,-0.50592653,-0.48306756,1.3091686,-0.50808145,-0.50592653,-0.48306756,1.3084223,-0.50809668,-0.50513461,-0.48306756,1.3094427,-0.50809668,-0.50592653,-0.48306756,1.3065491,-0.50809668,-0.50671083,-0.48306756,1.3039906,-0.50809668,-0.50671083,-0.48306756,1.3054298,-0.50809668,-0.50198217,8.6623782,1.2871624,-0.46552356,-0.50671083,-0.48306756,1.3047597,-0.50809668,-0.50671083,-0.48306756,1.3040516,-0.50809668,-0.50592653,-0.48306756,1.305407,-0.50809668,-0.50671083,-0.48306756,1.3049805,-0.50809668,-0.50592653,-0.48306756,1.3052851,-0.50809668,-0.50592653,-0.48306756,1.3062217,-0.50809668,-0.50592653,-0.48306756,1.3062217,-0.50809668,-0.50513461,-0.48306756,1.3094503,-0.50809668,-0.50513461,-0.48306756,1.3089706,-0.50809668,-0.50513461,-0.48306756,1.3102955,-0.50808907,-0.50513461,-0.48306756,1.3109351,-0.50808907,-0.50435031,-0.48306756,1.3114834,-0.50808907,-0.50435031,-0.48306756,1.3116966,-0.50808907,-0.50435031,-0.48227564,1.3125875,-0.50808907,-0.50435031,-0.48306756,1.3119098,-0.50808907,-0.50435031,-0.48227564,1.3115443,-0.50808907,-0.50435031,-0.48227564,1.3112854,-0.50808907,-0.50435031,-0.48227564,1.312321,-0.50808907,-0.50435031,-0.48227564,1.3121839,-0.50808907,-0.50435031,-0.48306756,1.3120621,-0.50808907,-0.50435031,-0.48227564,1.3124657,-0.50808907,-0.50435031,-0.48227564,1.3119707,-0.50808907,-0.50435031,-0.48306756,1.3129987,-0.50808907,-0.50513461,-0.48306756,1.3103031,-0.50808907,-0.50513461,-0.48306756,1.3096559,-0.50809668,-0.50513461,-0.48306756,1.3100975,-0.50809668,-0.50513461,-0.48306756,1.3104859,-0.50809668,-0.50513461,-0.48306756,1.3104783,-0.50809668,-0.50513461,-0.48306756,1.310463,-0.50808907,-0.50513461,-0.48306756,1.3104706,-0.50809668,-0.50513461,-0.48306756,1.3112321,-0.50809668,-0.50513461,-0.48306756,1.3094427,-0.50809668,-0.50592653,-0.48306756,1.3082396,-0.50809668,-0.50513461,-0.48306756,1.3096559,-0.50809668,-0.50435031,-0.48227564,1.3134632,-0.50808907,-0.50435031,-0.48306756,1.3132043,-0.50808907,-0.50435031,-0.48227564,1.3136612,-0.50808907,-0.50435031,-0.48227564,1.3133109,-0.50808907,-0.50435031,-0.48306756,1.3119555,-0.50808907,-0.50435031,-0.48227564,1.312618,-0.50808907,-0.50435031,-0.48227564,1.3131205,-0.50808907,-0.50435031,-0.48306756,1.3121992,-0.50808907,-0.50435031,-0.48306756,1.3120088,-0.50808907,-0.50513461,-0.48306756,1.3115595,-0.50808907,-0.50435031,-0.48227564,1.3129987,-0.50808907,-0.50435031,-0.48227564,1.3129225,-0.50808907,-0.50435031,-0.48227564,1.312717,-0.50808907,-0.50435031,-0.48227564,1.3128616,-0.50808907,-0.50435031,-0.48306756,1.3143998,-0.50808907,-0.50435031,-0.48306756,1.3138211,-0.50808907,-0.50435031,-0.48227564,1.3137297,-0.50808907,-0.5303541,5.5306004,1.3018966,-0.47357217,-0.50435031,-0.48306756,1.3135089,-0.50808907,-0.50435031,-0.48306756,1.3146663,-0.50808907,-0.50435031,-0.48306756,1.3135926,-0.50808907,-0.50435031,-0.48306756,1.3134175,-0.50808907,-0.50435031,-0.48227564,1.3133337,-0.50808907,-0.50435031,-0.48306756,1.3132804,-0.50808907,-0.50435031,-0.48306756,1.3140952,-0.50808907,-0.50435031,-0.48306756,1.3129835,-0.50808907,-0.50435031,-0.48306756,1.3130672,-0.50808907,-0.50435031,-0.48306756,1.3133566,-0.50808907,-0.50435031,-0.48227564,1.313585,-0.50808907,-0.50435031,-0.48227564,1.3125418,-0.50808907,-0.50435031,-0.48227564,1.3136535,-0.50808907,-0.50355839,-0.48227564,1.3144378,-0.50808907,-0.50513461,-0.48306756,1.3101965,-0.50808907,-0.50513461,-0.48306756,1.3104097,-0.50809668,-0.50513461,-0.48227564,1.30993,-0.50809668,-0.50513461,-0.48306756,1.3099833,-0.50809668,-0.50513461,-0.48306756,1.3106229,-0.50809668,-0.50513461,-0.48306756,1.3102498,-0.50809668,-0.48937243,0.84200645,1.3077827,-0.4920223,-0.50513461,-0.48306756,1.3102955,-0.50809668,-0.50513461,-0.48306756,1.3110037,-0.50808907,-0.50435031,-0.48227564,1.3110265,-0.50808907,-0.50435031,-0.48306756,1.311095,-0.50808907,-0.50355839,-0.48227564,1.3156943,-0.50808907,-0.50435031,-0.48227564,1.3145292,-0.50808907,-0.50355839,-0.48227564,1.3143845,-0.50808907,-0.50355839,-0.48306756,1.3149556,-0.50808907,-0.50592653,-0.48306756,1.3087193,-0.50809668,-0.50513461,-0.48306756,1.3118108,-0.50808907,-0.50513461,-0.48306756,1.3114758,-0.50808907,-0.50513461,-0.48306756,1.3104402,-0.50808907,-0.50513461,-0.48306756,1.3103945,-0.50808907,-0.50592653,-0.48306756,1.3067776,-0.50809668,-0.50592653,-0.48306756,1.3072878,-0.50809668,-0.50828704,-0.48306756,1.2969852,-0.5081043,-0.50828704,-0.48306756,1.2973203,-0.5081043,-0.50828704,-0.48306756,1.2972061,-0.5081043,-0.50828704,-0.48306756,1.2977771,-0.5081043,-0.50750274,-0.48306756,1.3021936,-0.50809668,-0.50750274,-0.48306756,1.3026733,-0.50809668,-0.50671083,-0.48306756,1.3025515,-0.50809668,-0.50671083,-0.48306756,1.3029018,-0.50809668,-0.50750274,-0.48306756,1.3023002,-0.50809668,-0.50671083,-0.48306756,1.3047749,-0.50809668,-0.50828704,-0.48306756,1.2998179,-0.5081043,-0.50828704,-0.48306756,1.3000006,-0.5081043,-0.50750274,-0.48306756,1.3003128,-0.5081043,-0.50750274,-0.48306756,1.2991478,-0.5081043,-0.50750274,-0.48306756,1.3002671,-0.5081043,-0.48937243,0.44866008,1.3047902,-0.4946341,-0.50592653,-0.48306756,1.30677,-0.50809668,-0.50671083,-0.48306756,1.3052699,-0.50809668,-0.50592653,-0.48306756,1.3067167,-0.50809668,-0.50592653,-0.48306756,1.3060923,-0.50809668,-0.50592653,-0.48306756,1.30594,-0.50809668,-0.50671083,-0.48306756,1.3057801,-0.50809668,-0.50592653,-0.48306756,1.3053917,-0.50809668,-0.50750274,-0.48306756,1.3014778,-0.5081043,-0.50750274,-0.48306756,1.3022393,-0.5081043,-0.50750274,-0.48306756,1.3020109,-0.5081043,-0.50750274,-0.48306756,1.3017291,-0.5081043,-0.50750274,-0.48306756,1.3024906,-0.5081043,-0.50671083,-0.48306756,1.3057192,-0.50809668,-0.50513461,-0.48306756,1.3104706,-0.50808907,-0.50513461,-0.48306756,1.309831,-0.50809668,-0.50671083,-0.48306756,1.3060085,-0.50809668,-0.50671083,-0.48306756,1.3063892,-0.50809668,-0.50828704,-0.48306756,1.2963532,-0.5081043,-0.50750274,-0.48306756,1.3001148,-0.5081043,-0.50592653,-0.48306756,1.3087574,-0.50809668,-0.50592653,-0.48306756,1.3063892,-0.50809668,-0.50592653,-0.48306756,1.3071583,-0.50809668,-0.50592653,-0.48306756,1.3073411,-0.50809668,-0.50513461,-0.48306756,1.311392,-0.50809668,-0.50592653,-0.48306756,1.3065187,-0.50809668,-0.50592653,-0.48306756,1.3070593,-0.50809668,-0.50592653,-0.48306756,1.3072954,-0.50809668,-0.50592653,-0.48306756,1.3077066,-0.50809668,-0.50513461,-0.48306756,1.3118032,-0.50808907,-0.50592653,-0.48306756,1.3088031,-0.50809668,-0.48858051,0.08211704,1.30345,-0.49765709,-0.50671083,-0.48306756,1.3044399,-0.50809668,-0.50671083,-0.48306756,1.3055364,-0.50809668,-0.50513461,-0.48306756,1.3086279,-0.50809668,-0.50671083,-0.48306756,1.3050871,-0.50809668,-0.50671083,-0.48306756,1.305011,-0.50809668,-0.50671083,-0.48306756,1.3045389,-0.50809668,-0.50671083,-0.48306756,1.3050338,-0.50809668,-0.50513461,-0.48306756,1.3086965,-0.50809668,-0.50513461,-0.48306756,1.3091076,-0.50809668,-0.50671083,-0.48306756,1.3050948,-0.50809668,-0.50671083,-0.48306756,1.3050948,-0.50809668,-0.50592653,-0.48306756,1.3083614,-0.50809668,-0.50592653,-0.48306756,1.3080416,-0.50809668,-0.50513461,-0.48306756,1.3114758,-0.50808907,-0.50435031,-0.48306756,1.3121306,-0.50808907,-0.50592653,-0.48306756,1.3078588,-0.50809668,-0.50592653,-0.48306756,1.3074629,-0.50809668,-0.50592653,-0.48306756,1.308232,-0.50809668,-0.50592653,-0.48306756,1.3076761,-0.50809668,-0.50435031,-0.48306756,1.3126484,-0.50808907,-0.50513461,-0.48306756,1.3116205,-0.50808907,-0.50592653,-0.48306756,1.3078284,-0.50809668,-0.50592653,-0.48306756,1.3070289,-0.50809668,-0.50671083,-0.48306756,1.3054222,-0.50809668,-0.50671083,-0.48306756,1.3040211,-0.50809668,-0.50592653,-0.48306756,1.3074172,-0.50809668,-0.50671083,-0.48306756,1.3065948,-0.50809668,-0.50671083,-0.48306756,1.3064045,-0.50809668,-0.50671083,-0.48306756,1.3062674,-0.50809668,-0.50671083,-0.48306756,1.3050871,-0.50809668,-0.49804543,-0.1827409,1.304478,-0.50050494,-0.50671083,-0.48306756,1.3061836,-0.50809668,-0.50671083,-0.48306756,1.3034805,-0.50809668,-0.50671083,-0.48306756,1.3034119,-0.50809668,-0.50671083,-0.48306756,1.3034195,-0.50809668,-0.50671083,-0.48306756,1.304516,-0.50809668,-0.50671083,-0.48306756,1.3037013,-0.50809668,-0.50671083,-0.48306756,1.3040439,-0.50809668,-0.50592653,-0.48306756,1.3059704,-0.50809668,-0.50671083,-0.48306756,1.3042419,-0.50809668,-0.50671083,-0.48306756,1.3040363,-0.50809668,-0.50750274,-0.48306756,1.3022545,-0.50809668,-0.50750274,-0.48306756,1.3017443,-0.50809668,-0.50671083,-0.48306756,1.3024068,-0.50809668,-0.50671083,-0.48306756,1.3024068,-0.50809668,-0.50671083,-0.48306756,1.3024068,-0.50809668,-0.50671083,-0.48306756,1.3024068,-0.50809668,-0.50671083,-0.48306756,1.3024068,-0.50809668,-0.50671083,-0.48306756,1.3024068,-0.50809668,-0.50671083,-0.48306756,1.3024068,-0.50809668,-0.50671083,-0.48306756,1.3024068,-0.50809668,-0.50671083,-0.48306756,1.3024068,-0.50809668,-0.50671083,-0.48306756,1.3024068,-0.50809668,-0.50671083,-0.48306756,1.3024068,-0.50809668:3
-0.60789354,-0.50207543,1.3254476,-0.50733606,-0.60789354,-0.50207543,1.3234188,-0.50733606,-0.60789354,-0.50207543,1.3244174,-0.50733606,-0.60789354,-0.50207543,1.3250151,-0.50733606,-0.62417083,2.3445711,1.3142736,-0.4854836,-0.60789354,-0.50207543,1.3280582,-0.50733606,-0.60789354,-0.50207543,1.3231357,-0.50733606,-0.60789354,-0.50207543,1.3213743,-0.50733606,-0.60789354,-0.50207543,1.3254476,-0.50733606,-0.60789354,-0.50207543,1.3232694,-0.50733606,-0.60789354,-0.50207543,1.3228133,-0.50733606,-0.60707575,-0.50207543,1.3200768,-0.50733606,-0.60789354,-0.50207543,1.3233952,-0.50733606,-0.60789354,-0.50207543,1.3225459,-0.50733606,-0.60789354,-0.50207543,1.3222707,-0.50733606,-0.60789354,-0.50207543,1.3229942,-0.50733606,-0.60707575,-0.50207543,1.319432,-0.50734392,-0.60707575,-0.50207543,1.3186614,-0.50734392,-0.60707575,-0.50288536,1.3187558,-0.50734392,-0.60707575,-0.50207543,1.3184491,-0.50734392,-0.60789354,-0.50207543,1.3244332,-0.50733606,-0.60789354,-0.50207543,1.3250229,-0.50733606,-0.60789354,-0.50207543,1.3233166,-0.50733606,-0.60789354,-0.50207543,1.327382,-0.50733606,-0.60789354,-0.50207543,1.3283649,-0.50733606,-0.62335304,2.0824517,1.3176864,-0.48652943,-0.60789354,-0.50207543,1.3272168,-0.50733606,-0.60789354,-0.50207543,1.3258564,-0.50733606,-0.60789354,-0.50207543,1.3273112,-0.50733606,-0.60789354,-0.50207543,1.3280739,-0.50733606,-0.60870348,-0.50207543,1.3297253,-0.50733606,-0.60870348,-0.50207543,1.3327999,-0.50733606,-0.60870348,-0.50207543,1.3315024,-0.50733606,-0.60870348,-0.50207543,1.3315496,-0.50733606,-0.60789354,-0.50207543,1.3288996,-0.50733606,-0.60789354,-0.50207543,1.3274055,-0.50733606,-0.60789354,-0.50207543,1.3280032,-0.50733606,-0.62498077,1.7845222,1.3203285,-0.48778758,-0.60789354,-0.50207543,1.327492,-0.50733606,-0.60789354,-0.50207543,1.3287266,-0.50733606,-0.60789354,-0.50207543,1.325133,-0.50733606,-0.60789354,-0.50207543,1.3281133,-0.50733606,-0.60789354,-0.50207543,1.3281604,-0.50733606,-0.60789354,-0.50207543,1.3277201,-0.50733606,-0.60789354,-0.50207543,1.3271775,-0.50733606,-0.60789354,-0.50207543,1.3256048,-0.50733606,-0.60789354,-0.50207543,1.3256835,-0.50733606,-0.60789354,-0.50288536,1.3261238,-0.50733606,-0.60789354,-0.50207543,1.3246376,-0.50733606,-0.60789354,-0.50207543,1.3252746,-0.50733606,-0.60789354,-0.50207543,1.3255734,-0.50733606,-0.60789354,-0.50207543,1.3268787,-0.50733606,-0.60789354,-0.50207543,1.32588,-0.50733606,-0.60789354,-0.50207543,1.3270124,-0.50733606,-0.60789354,-0.50207543,1.327437,-0.50733606,-0.60789354,-0.50207543,1.3260137,-0.50733606,-0.60789354,-0.50207543,1.3247241,-0.50733606,-0.60707575,-0.50207543,1.3230256,-0.50733606,-0.60707575,-0.50207543,1.3225695,-0.50733606,-0.60789354,-0.50207543,1.3252588,-0.50733606,-0.60789354,-0.50207543,1.3241815,-0.50733606,-0.60707575,-0.50207543,1.3233087,-0.50734392,-0.60707575,-0.50207543,1.3197466,-0.50734392,-0.60789354,-0.50207543,1.3244017,-0.50733606,-0.60707575,-0.50207543,1.3239614,-0.50734392,-0.60789354,-0.50207543,1.3234424,-0.50733606,-0.60789354,-0.50288536,1.3236232,-0.50734392,-0.60707575,-0.50207543,1.3230807,-0.50734392,-0.60707575,-0.50207543,1.3223336,-0.50734392,-0.60707575,-0.50207543,1.3210912,-0.50733606,-0.60707575,-0.50207543,1.3213586,-0.50734392,-0.60707575,-0.50207543,1.3224673,-0.50733606,-0.60707575,-0.50207543,1.320989,-0.50734392,-0.60789354,-0.50207543,1.3257228,-0.50733606,-0.60789354,-0.50207543,1.3271382,-0.50733606,-0.60789354,-0.50207543,1.3253139,-0.50733606,-0.60789354,-0.50207543,1.3254476,-0.50733606,-0.60789354,-0.50207543,1.3243624,-0.50733606,-0.60789354,-0.50207543,1.3247241,-0.50733606,-0.60707575,-0.50207543,1.3244332,-0.50733606,-0.60789354,-0.50207543,1.3243074,-0.50733606,-0.60789354,-0.50207543,1.3249128,-0.50733606,-0.61928765,-0.039706011,1.3233244,-0.49876492,-0.60707575,-0.50207543,1.322255,-0.50733606,-0.60789354,-0.50207543,1.3268394,-0.50733606,-0.60707575,-0.50288536,1.3202656,-0.50734392,-0.60707575,-0.50207543,1.3216417,-0.50734392,-0.60707575,-0.50207543,1.3206745,-0.50734392,-0.60707575,-0.50207543,1.3191725,-0.50734392,-0.60789354,-0.50207543,1.3253139,-0.50733606,-0.60707575,-0.50207543,1.32404,-0.50733606,-0.61521439,-0.4117168,1.3240636,-0.50376606,-0.60789354,-0.50207543,1.3238749,-0.50733606,-0.60707575,-0.50207543,1.3225617,-0.50733606,-0.60707575,-0.50207543,1.3233087,-0.50733606,-0.60707575,-0.50207543,1.3233873,-0.50734392,-0.60707575,-0.50207543,1.3223336,-0.50734392,-0.60707575,-0.50207543,1.3218618,-0.50734392,-0.60789354,-0.50207543,1.3241265,-0.50733606,-0.60707575,-0.50207543,1.3241815,-0.50733606,-0.60707575,-0.50207543,1.3242444,-0.50733606,-0.60707575,-0.50207543,1.3229784,-0.50734392,-0.60707575,-0.50207543,1.323521,-0.50733606,-0.60789354,-0.50207543,1.3250701,-0.50733606,-0.60707575,-0.50207543,1.3232143,-0.50734392,-0.60789354,-0.50207543,1.3256835,-0.50733606,-0.60789354,-0.50207543,1.3265248,-0.50733606,-0.60789354,-0.50207543,1.3267057,-0.50733606,-0.60789354,-0.50207543,1.3261946,-0.50733606,-0.60789354,-0.50207543,1.3258014,-0.50733606,-0.60789354,-0.50207543,1.3279874,-0.50733606,-0.60789354,-0.50207543,1.3266349,-0.50731247,-0.60789354,-0.50207543,1.3251409,-0.50733606,-0.60789354,-0.50288536,1.3243074,-0.50733606,-0.60789354,-0.50207543,1.3255105,-0.50733606,-0.60789354,-0.50207543,1.326399,-0.50733606,-0.60789354,-0.50207543,1.3306689,-0.50733606,-0.60789354,-0.50207543,1.3277909,-0.50733606,-0.60789354,-0.50207543,1.3273505,-0.50733606,-0.60707575,-0.50207543,1.3242287,-0.50734392,-0.60707575,-0.50207543,1.3227189,-0.50733606,-0.60707575,-0.50207543,1.3239535,-0.50733606,-0.60707575,-0.50207543,1.3241344,-0.50733606,-0.60707575,-0.50207543,1.3241186,-0.50733606,-0.60707575,-0.50207543,1.3240007,-0.50733606,-0.60707575,-0.50207543,1.3245983,-0.50733606,-0.60707575,-0.50207543,1.324441,-0.50726529,-0.60707575,-0.50207543,1.3204779,-0.50734392,-0.60707575,-0.50207543,1.3232694,-0.50734392,-0.60789354,-0.50288536,1.3254004,-0.50734392,-0.60707575,-0.50207543,1.3237648,-0.50734392,-0.60707575,-0.50207543,1.32312,-0.50734392,-0.60707575,-0.50207543,1.3220034,-0.50734392,-0.60789354,-0.50207543,1.3242287,-0.50733606,-0.60707575,-0.50207543,1.325133,-0.50734392,-0.60707575,-0.50288536,1.3234424,-0.50734392,-0.60707575,-0.50207543,1.3246062,-0.50734392,-0.60707575,-0.50207543,1.3245668,-0.50734392,-0.60707575,-0.50207543,1.3231514,-0.50734392,-0.60707575,-0.50207543,1.3247713,-0.50734392,-0.60707575,-0.50207543,1.3234738,-0.50734392,-0.60707575,-0.5004477,1.3235367,-0.50708443,-0.60707575,-0.50288536,1.3230807,-0.50734392,-0.60789354,-0.50207543,1.3246612,-0.50734392,-0.60707575,-0.50288536,1.3243939,-0.50734392,-0.60789354,-0.50207543,1.3251881,-0.50734392,-0.60789354,-0.50207543,1.3256363,-0.50734392,-0.60789354,-0.50207543,1.3248814,-0.50734392,-0.60707575,-0.50207543,1.3234424,-0.50734392,-0.60707575,-0.50207543,1.3236311,-0.50734392,-0.60789354,-0.50207543,1.3251094,-0.50734392,-0.60789354,-0.50288536,1.3241973,-0.50734392,-0.60707575,-0.50288536,1.3223258,-0.50734392,-0.60707575,-0.50288536,1.321508,-0.50734392,-0.60707575,-0.50207543,1.3203756,-0.50734392,-0.60707575,-0.50288536,1.3187243,-0.50734392,-0.60625795,-0.4996299,1.3193455,-0.50697434,-0.60707575,-0.50207543,1.3220663,-0.50734392,-0.60707575,-0.50288536,1.3200532,-0.50734392,-0.60707575,-0.50288536,1.3207374,-0.50734392,-0.23344509,8.8201412,1.2853441,-0.46683155,-0.2285619,1.079574,1.3165226,-0.49226974,-0.60707575,-0.50207543,1.3220506,-0.50734392,-0.60707575,-0.50207543,1.3220899,-0.50734392,-0.62172531,0.73117704,1.3143365,-0.49307967,-0.60707575,-0.50288536,1.319377,-0.50734392,-0.60625795,-0.50207543,1.3144309,-0.50734392,-0.60625795,-0.50207543,1.316153,-0.50734392,-0.60625795,-0.50288536,1.3140928,-0.50734392,-0.60625795,-0.50288536,1.3124729,-0.50734392,-0.50776855,-0.50776855,1.3170022,-0.50776855,-0.50776855,-0.50776855,1.3180088,-0.50776855,-0.50776855,-0.50776855,1.3174662,-0.50776855,-0.50776855,-0.50776855,1.3178122,-0.50776855,-0.50776855,-0.50776855,1.3178829,-0.50776855,-0.50776855,-0.50776855,1.3176234,-0.50776855,-0.50776855,-0.50776855,1.3168607,-0.50776855,-0.50776855,-0.50776855,1.3160272,-0.50776855,-0.50776855,-0.50776855,1.3182053,-0.50776855,-0.50776855,-0.50776855,1.3131649,-0.50776855,-0.50776855,-0.50776855,1.3180009,-0.50776855,-0.50776855,-0.50776855,1.3185985,-0.50776855,-0.50776855,-0.50776855,1.3183154,-0.50776855,-0.50776855,-0.50776855,1.3201555,-0.50776855,-0.50776855,-0.50776855,1.317765,-0.50776855,-0.50776855,-0.50776855,1.3192512,-0.50776855,-0.50776855,-0.50776855,1.3209575,-0.50776855,-0.50776855,-0.50776855,1.3195972,-0.50776855,-0.50776855,-0.50776855,1.3202341,-0.50776855,-0.50776855,-0.50776855,1.3212721,-0.50776855,-0.50776855,-0.50776855,1.3194792,-0.50776855,-0.50776855,-0.50776855,1.3210519,-0.50776855,-0.50776855,-0.50776855,1.3206666,-0.50776855,-0.50776855,-0.50776855,1.3207452,-0.50776855,-0.50776855,-0.50776855,1.3157755,-0.50776855,-0.50776855,-0.50776855,1.3202891,-0.50776855,-0.50776855,-0.50776855,1.3202577,-0.50776855,-0.50776855,-0.50776855,1.3184806,-0.50776855,-0.50776855,-0.50776855,1.3200847,-0.50776855,-0.50776855,-0.50776855,1.3209418,-0.50776855,-0.50776855,-0.50776855,1.322428,-0.50776855,-0.50776855,-0.50776855,1.3235131,-0.50776855,-0.50776855,-0.50776855,1.3217439,-0.50776855,-0.50776855,-0.50776855,1.3214687,-0.50776855,-0.50776855,-0.50776855,1.3202262,-0.50776855,-0.50776855,-0.50776855,1.3191411,-0.50776855,-0.50776855,-0.50776855,1.3193848,-0.50776855,-0.50776855,-0.50776855,1.319086,-0.50776855,-0.50776855,-0.50776855,1.3186378,-0.50776855,-0.50776855,-0.50776855,1.3165147,-0.50776855,-0.50776855,-0.50776855,1.3187872,-0.50776855,-0.50776855,-0.50776855,1.3175369,-0.50776855,-0.50776855,-0.50776855,1.3179537,-0.50776855,-0.50776855,-0.50776855,1.3202577,-0.50776855,-0.50776855,-0.50776855,1.3191568,-0.50776855,-0.50776855,-0.50776855,1.3194635,-0.50776855,-0.50776855,-0.50776855,1.3181031,-0.50776855,-0.50776855,-0.50776855,1.3190467,-0.50776855,-0.50776855,-0.50776855,1.3194163,-0.50776855,-0.50776855,-0.50776855,1.3191411,-0.50776855,-0.50776855,-0.50776855,1.3184176,-0.50776855,-0.50776855,-0.50776855,1.31782,-0.50776855,-0.50776855,-0.50776855,1.319259,-0.50776855,-0.50776855,-0.50776855,1.31874,-0.50776855,-0.50776855,-0.50776855,1.317647,-0.50776855,-0.50776855,-0.50776855,1.3194399,-0.50776855,-0.50776855,-0.50776855,1.3202341,-0.50776855,-0.50776855,-0.50776855,1.3158149,-0.50776855,-0.50776855,-0.50776855,1.3205722,-0.50776855,-0.50776855,-0.50776855,1.3200297,-0.50776855,-0.50776855,-0.50776855,1.3221528,-0.50776855,-0.50776855,-0.50776855,1.3200926,-0.50776855,-0.50776855,-0.50776855,1.3204779,-0.50776855,-0.50776855,-0.50776855,1.3190153,-0.50776855,-0.50776855,-0.50776855,1.3200768,-0.50776855,-0.50776855,-0.50776855,1.3201161,-0.50776855,-0.50776855,-0.50776855,1.3205722,-0.50776855,-0.50776855,-0.50776855,1.3216652,-0.50776855,-0.50776855,-0.50776855,1.320124,-0.50776855,-0.50776855,-0.50776855,1.3196522,-0.50776855,-0.50776855,-0.50776855,1.3188423,-0.50776855,-0.50776855,-0.50776855,1.3184491,-0.50776855,-0.50776855,-0.50776855,1.3205015,-0.50776855,-0.50776855,-0.50776855,1.3205722,-0.50776855,-0.50776855,-0.50776855,1.3196522,-0.50776855,-0.50776855,-0.50776855,1.3200218,-0.50776855,-0.50776855,-0.50776855,1.3183547,-0.50776855,-0.50776855,-0.50776855,1.3208553,-0.50776855,-0.50776855,-0.50776855,1.3199825,-0.50776855,-0.50776855,-0.50776855,1.3201083,-0.50776855,-0.50776855,-0.50776855,1.3176549,-0.50776855,-0.50776855,-0.50776855,1.3146904,-0.50776855,-0.50776855,-0.50776855,1.3134637,-0.50776855,-0.50776855,-0.50776855,1.31506,-0.50776855,-0.50776855,-0.50776855,1.3140928,-0.50776855,-0.50776855,-0.50776855,1.3183233,-0.50776855,-0.50776855,-0.50776855,1.3212878,-0.50776855,-0.50776855,-0.50776855,1.322601,-0.50776855,-0.50776855,-0.50776855,1.3236311,-0.50776855,-0.50776855,-0.50776855,1.3192748,-0.50776855,-0.50776855,-0.50776855,1.3241579,-0.50776855,-0.50776855,-0.50776855,1.3229863,-0.50776855,-0.50776855,-0.50776855,1.3226089,-0.50776855,-0.50776855,-0.50776855,1.3233402,-0.50776855,-0.50776855,-0.50776855,1.3223179,-0.50776855,-0.50776855,-0.50776855,1.3250465,-0.50776855,-0.50776855,-0.50776855,1.3253296,-0.50776855,-0.50776855,-0.50776855,1.3237569,-0.50776855,-0.50776855,-0.50776855,1.324787,-0.50776855,-0.50776855,-0.50776855,1.3211384,-0.50776855,-0.50776855,-0.50776855,1.3234896,-0.50776855,-0.50776855,-0.50776855,1.3241422,-0.50776855,-0.50776855,-0.50776855,1.3256913,-0.50776855,-0.50776855,-0.50776855,1.323466,-0.50776855,-0.50776855,-0.50776855,1.3237176,-0.50776855,-0.50776855,-0.50776855,1.3231278,-0.50776855,-0.50776855,-0.50776855,1.3237333,-0.50776855,-0.50776855,-0.50776855,1.3232143,-0.50776855,-0.50776855,-0.50776855,1.3244725,-0.50776855,-0.50776855,-0.50776855,1.3220977,-0.50776855,-0.60789354,-0.50207543,1.3251094,-0.50733606,-0.59486385,4.9746824,1.2993488,-0.47687315,-0.60707575,-0.50207543,1.3230178,-0.50734392,-0.60789354,-0.50207543,1.3255655,-0.50734392,-0.60789354,-0.50207543,1.3271932,-0.50732033,-0.26030655,5.2506415,1.3002531,-0.47597672,-0.22123319,-0.18378756,1.3223022,-0.50582628,-0.25461343,8.5108098,1.2861619,-0.46749994,-0.62417083,2.9396201,1.3094927,-0.48325825,-0.60707575,-0.50207543,1.3190231,-0.50734392,-0.60707575,-0.50207543,1.3200139,-0.50734392,-0.25054017,8.7802501,1.2832524,-0.46695737,-0.24891244,5.4167013,1.2999622,-0.47542628,-0.21879553,-0.19518952,1.3199903,-0.50582628,-0.60707575,-0.50207543,1.3238355,-0.50734392,-0.611149,4.0198345,1.3061979,-0.47967253,-0.60707575,-0.50207543,1.3231907,-0.50734392,-0.24809465,8.8168858,1.2847701,-0.46683155,-0.22286092,-0.19356179,1.3222078,-0.50584987,-0.60707575,-0.50207543,1.3234424,-0.50734392,-0.60707575,-0.5004477,1.3241186,-0.50702938,-0.60789354,-0.50207543,1.3247634,-0.50734392,-0.60707575,-0.50207543,1.3235525,-0.50734392,-0.25135797,8.8258344,1.2858002,-0.46681583,-0.22611637,-0.19437173,1.321909,-0.50585773,-0.60707575,-0.50207543,1.3196286,-0.50734392,-0.59486385,2.0100059,1.314769,-0.48683611,-0.60707575,-0.50207543,1.3230413,-0.50734392,-0.60707575,-0.50207543,1.3234345,-0.50734392,-0.60789354,-0.50207543,1.3259351,-0.50734392,-0.60789354,-0.50288536,1.3251959,-0.50734392,-0.60707575,-0.50288536,1.3234502,-0.50734392,-0.60707575,-0.50207543,1.3253611,-0.50734392,-0.60789354,-0.50288536,1.3249679,-0.50734392,-0.60707575,-0.50207543,1.324095,-0.50734392,-0.60707575,-0.50207543,1.3201712,-0.50734392,-0.60707575,-0.50207543,1.3201555,-0.50734392,-0.60707575,-0.50207543,1.3243703,-0.50734392,-0.59405391,2.3128264,1.314077,-0.48560941,-0.60707575,-0.50207543,1.3226246,-0.50734392,-0.60625795,-0.50207543,1.318284,-0.50734392,-0.60707575,-0.50207543,1.3185906,-0.50734392,-0.60707575,-0.50207543,1.3199196,-0.50734392,-0.60707575,-0.50207543,1.323348,-0.50734392,-0.60707575,-0.50207543,1.3195107,-0.50734392,-0.60707575,-0.50288536,1.3225853,-0.50734392,-0.60707575,-0.50207543,1.3220584,-0.50734392,-0.60707575,-0.50207543,1.3240715,-0.50734392,-0.60707575,-0.50207543,1.322255,-0.50734392,-0.60707575,-0.50207543,1.3216259,-0.50734392,-0.60707575,-0.50207543,1.3234817,-0.50734392,-0.60707575,-0.50207543,1.3208474,-0.50734392,-0.60707575,-0.50207543,1.3228919,-0.50734392,-0.60707575,-0.50288536,1.3216495,-0.50734392,-0.60707575,-0.50207543,1.3216652,-0.50734392,-0.60707575,-0.50207543,1.3211934,-0.50734392,-0.60707575,-0.50207543,1.3223179,-0.50734392,-0.60707575,-0.50207543,1.3215787,-0.50734392,-0.60707575,-0.50207543,1.3217596,-0.50734392,-0.60707575,-0.50207543,1.3210598,-0.50734392,-0.60625795,-0.50207543,1.3194084,-0.50734392,-0.60707575,-0.50207543,1.3209025,-0.50734392,-0.60707575,-0.50288536,1.3221056,-0.50734392,-0.60707575,-0.50207543,1.3199038,-0.50734392,-0.60707575,-0.50288536,1.3207531,-0.50734392,-0.59568164,3.1699948,1.3054587,-0.48246404,-0.60625795,-0.50288536,1.3194399,-0.50734392,-0.60707575,-0.50207543,1.3201555,-0.50734392,-0.60707575,-0.50207543,1.319896,-0.50734392,-0.60707575,-0.50288536,1.3215552,-0.50734392,-0.60625795,-0.50207543,1.317765,-0.50734392,-0.60707575,-0.50207543,1.3216259,-0.50734392,-0.60707575,-0.50288536,1.3197073,-0.50734392,-0.60707575,-0.50207543,1.318913,-0.50734392,-0.60707575,-0.50288536,1.3207216,-0.50734392,-0.60625795,-0.50288536,1.3158778,-0.50734392,-0.60625795,-0.50207543,1.3186929,-0.50734392,-0.60707575,-0.50288536,1.320415,-0.50734392,-0.60707575,-0.50288536,1.3189288,-0.50734392,-0.60707575,-0.50288536,1.3189288,-0.50734392,-0.60707575,-0.50288536,1.3189288,-0.50734392,-0.60707575,-0.50288536,1.3189288,-0.50734392,-0.60707575,-0.50288536,1.3189288,-0.50734392,-0.60707575,-0.50288536,1.3189288,-0.50734392,-0.60707575,-0.50288536,1.3189288,-0.50734392:3
-0.6002345,-0.49656982,1.3975898,-0.50148198,-0.6011237,-0.49656982,1.400784,-0.50148198,-0.6002345,-0.49656982,1.3936877,-0.50148198,-0.6011237,-0.49656982,1.4052127,-0.50148198,-0.6002345,-0.49656982,1.3984703,-0.50148198,-0.6011237,-0.49656982,1.4050918,-0.50148198,-0.6002345,-0.49656982,1.3964243,-0.50148198,-0.6002345,-0.49656982,1.3967955,-0.50148198,-0.6002345,-0.49656982,1.3965279,-0.50148198,-0.6002345,-0.49656982,1.3970373,-0.50148198,-0.59933667,-0.49656982,1.3899151,-0.50148198,-0.6002345,-0.49656982,1.3938085,-0.50148198,-0.6002345,-0.49656982,1.3949912,-0.50148198,-0.6002345,-0.49656982,1.3959063,-0.50148198,-0.6002345,-0.49656982,1.3964761,-0.50148198,-0.6011237,-0.49656982,1.3996962,-0.50148198,-0.6002345,-0.49656982,1.3987811,-0.50148198,-0.6002345,-0.49656982,1.3989624,-0.50148198,-0.6002345,-0.49656982,1.3971495,-0.50148198,-0.6002345,-0.49656982,1.3918488,-0.50148198,-0.6002345,-0.49656982,1.3968387,-0.50148198,-0.6002345,-0.49656982,1.3970114,-0.50148198,-0.6002345,-0.49656982,1.3921251,-0.50148198,-0.6002345,-0.49656982,1.3950171,-0.50148198,-0.6011237,-0.49656982,1.3991437,-0.50148198,-0.6011237,-0.49656982,1.4009998,-0.50148198,-0.6002345,-0.49656982,1.3989279,-0.50148198,-0.6002345,-0.49656982,1.3941366,-0.50148198,-0.59933667,-0.49656982,1.3882575,-0.50148198,-0.59933667,-0.49656982,1.3876964,-0.50148198,-0.59933667,-0.49656982,1.3907179,-0.50148198,-0.59933667,-0.49656982,1.3900791,-0.50148198,-0.6002345,-0.49656982,1.3928589,-0.50148198,-0.59933667,-0.49656982,1.3900877,-0.50148198,-0.6002345,-0.49656982,1.392997,-0.50148198,-0.59933667,-0.49656982,1.3906143,-0.50148198,-0.59933667,-0.49656982,1.3906661,-0.50148198,-0.59933667,-0.49656982,1.3885597,-0.50148198,-0.6002345,-0.49656982,1.3901654,-0.50148198,-0.6002345,-0.49656982,1.393869,-0.50148198,-0.6002345,-0.49656982,1.3958459,-0.50148198,-0.59933667,-0.49656982,1.3908215,-0.50148198,-0.59933667,-0.49656982,1.3913568,-0.50148198,-0.6002345,-0.49656982,1.3941107,-0.50148198,-0.6002345,-0.49656982,1.3925395,-0.50148198,-0.6002345,-0.49656982,1.3982459,-0.50148198,-0.6002345,-0.49656982,1.3945337,-0.50148198,-0.6002345,-0.49656982,1.3931783,-0.50148198,-0.6002345,-0.49656982,1.3907438,-0.50148198,-0.59933667,-0.49656982,1.3866086,-0.50148198,-0.6002345,-0.49656982,1.3925999,-0.50148198,-0.6002345,-0.49656982,1.3937049,-0.50148198,-0.6002345,-0.49656982,1.394456,-0.50148198,-0.6002345,-0.49656982,1.3928071,-0.50148198,-0.6002345,-0.49656982,1.3955956,-0.50148198,-0.6002345,-0.49656982,1.3942488,-0.50148198,-0.6002345,-0.49656982,1.3928416,-0.50148198,-0.6002345,-0.49656982,1.3936963,-0.50148198,-0.6002345,-0.49656982,1.3946287,-0.50148198,-0.6002345,-0.49656982,1.3939726,-0.50148198,-0.6002345,-0.49656982,1.3946287,-0.50148198,-0.6002345,-0.49656982,1.3956905,-0.50148198,-0.6011237,-0.49656982,1.3988588,-0.50148198,-0.6002345,-0.49656982,1.398548,-0.50148198,-0.6011237,-0.49656982,1.3988157,-0.50148198,-0.6002345,-0.49656982,1.3977711,-0.50148198,-0.6002345,-0.49656982,1.3964589,-0.50148198,-0.6002345,-0.49656982,1.3927639,-0.50148198,-0.6002345,-0.49656982,1.3948186,-0.50148198,-0.6002345,-0.49656982,1.3927121,-0.50148198,-0.6002345,-0.49656982,1.3941797,-0.50148198,-0.59933667,-0.49656982,1.3895093,-0.50148198,-0.6002345,-0.49656982,1.3920819,-0.50148198,-0.6002345,-0.49656982,1.3915812,-0.50148198,-0.59933667,-0.49656982,1.3852619,-0.50148198,-0.59933667,-0.49656982,1.3854777,-0.50148198,-0.6002345,-0.49656982,1.3897683,-0.50148198,-0.59933667,-0.49656982,1.3896733,-0.50148198,-0.6002345,-0.49656982,1.3946114,-0.50148198,-0.6002345,-0.49656982,1.3928244,-0.50148198,-0.6002345,-0.49656982,1.3982631,-0.50148198,-0.6002345,-0.49656982,1.3974257,-0.50148198,-0.6002345,-0.49656982,1.4004904,-0.50148198,-0.6002345,-0.49656982,1.3955783,-0.50148198,-0.6011237,-0.49656982,1.4011897,-0.50148198,-0.6002345,-0.49656982,1.3987898,-0.50148198,-0.6011237,-0.49656982,1.4026746,-0.50148198,-0.6011237,-0.49656982,1.40384,-0.50148198,-0.6011237,-0.49656982,1.4048328,-0.50148198,-0.6011237,-0.49656982,1.4060846,-0.50148198,-0.6011237,-0.49656982,1.4056702,-0.50148198,-0.6011237,-0.49656982,1.4045134,-0.50148198,-0.6011237,-0.49656982,1.4028731,-0.50148198,-0.6011237,-0.49656982,1.4055148,-0.50148198,-0.6011237,-0.49656982,1.4001969,-0.50148198,-0.6011237,-0.49656982,1.403771,-0.50148198,-0.6011237,-0.49656982,1.4034516,-0.50148198,-0.6011237,-0.49656982,1.4040041,-0.50148198,-0.6002345,-0.49656982,1.3968732,-0.50148198,-0.6011237,-0.49656982,1.4014573,-0.50148198,-0.6011237,-0.49656982,1.4000674,-0.50148198,-0.6002345,-0.49656982,1.3983408,-0.50148198,-0.6011237,-0.49656982,1.402148,-0.50148198,-0.6002345,-0.49656982,1.3985049,-0.50148198,-0.6011237,-0.49656982,1.4022429,-0.50148198,-0.6011237,-0.49656982,1.400171,-0.50148198,-0.6011237,-0.49656982,1.4032444,-0.50148198,-0.6011237,-0.49656982,1.4046429,-0.50148198,-0.6011237,-0.49656982,1.4063522,-0.50148198,-0.60202153,-0.49656982,1.4088385,-0.50148198,-0.6011237,-0.49656982,1.4074227,-0.50148198,-0.6011237,-0.49656982,1.4030372,-0.50148198,-0.6011237,-0.49656982,1.4029163,-0.50148198,-0.6011237,-0.49656982,1.402899,-0.50148198,-0.60202153,-0.49656982,1.4091579,-0.50148198,-0.60202153,-0.49656982,1.4089594,-0.50147335,-0.6011237,-0.49656982,1.4067666,-0.50148198,-0.60202153,-0.49656982,1.408217,-0.50147335,-0.6011237,-0.49656982,1.4036328,-0.50148198,-0.6011237,-0.49656982,1.406827,-0.50147335,-0.6011237,-0.49656982,1.4051523,-0.50148198,-0.60202153,-0.49656982,1.4081393,-0.50147335,-0.60202153,-0.49656982,1.4076299,-0.50147335,-0.6011237,-0.49656982,1.405394,-0.50148198,-0.6011237,-0.49656982,1.4000761,-0.50148198,-0.6002345,-0.49656982,1.3977797,-0.50148198,-0.6011237,-0.49656982,1.3994631,-0.50148198,-0.60202153,-0.49656982,1.4072414,-0.50147335,-0.60202153,-0.49656982,1.4099953,-0.50147335,-0.60202153,-0.49656982,1.4089594,-0.50148198,-0.60202153,-0.49656982,1.4076472,-0.50148198,-0.6011237,-0.49656982,1.4051523,-0.50148198,-0.60202153,-0.49656982,1.4103838,-0.50147335,-0.60202153,-0.49656982,1.4102975,-0.50147335,-0.6002345,-0.49656982,1.39582,-0.50148198,-0.6011237,-0.49656982,1.4064904,-0.50148198,-0.6011237,-0.49656982,1.40624,-0.50148198,-0.6011237,-0.49656982,1.4062141,-0.50148198,-0.6011237,-0.49656982,1.4074918,-0.50148198,-0.6011237,-0.49656982,1.4053076,-0.50148198,-0.6011237,-0.49656982,1.4044012,-0.50148198,-0.60202153,-0.49656982,1.4078975,-0.50147335,-0.60202153,-0.49656982,1.4089508,-0.50147335,-0.60202153,-0.49656982,1.4083723,-0.50147335,-0.60202153,-0.49656982,1.40965,-0.50147335,-0.6011237,-0.49656982,1.4058947,-0.50148198,-0.58592967,4.0102972,1.372347,-0.47217305,-0.59933667,8.4081385,1.3376165,-0.46010416,-0.60202153,-0.49656982,1.4082947,-0.50147335,-0.6011237,-0.49656982,1.4065681,-0.50148198,-0.59933667,8.4528227,1.3427532,-0.4600092,-0.6011237,-0.49656982,1.4068961,-0.50148198,-0.6011237,-0.49656982,1.4053335,-0.50148198,-0.24813026,8.8004637,1.3429776,-0.45835167,-0.047051156,-0.046153327,1.4042113,-0.49884892,-0.1122905,8.8245929,1.3403791,-0.45817038,-0.058662498,-0.045264131,1.4081652,-0.49889209,-0.60202153,-0.49656982,1.4089767,-0.50147335,-0.60202153,-0.49656982,1.409322,-0.50147335,-0.60202153,-0.49656982,1.4086313,-0.50147335,-0.6011237,-0.49656982,1.4043926,-0.50148198,-0.60202153,-0.49656982,1.4093651,-0.50147335,-0.60202153,-0.49656982,1.4120327,-0.50147335,-0.60202153,-0.49656982,1.4154859,-0.50147335,-0.6002345,-0.41435806,1.4126198,-0.49789066,-0.60202153,-0.49656982,1.4153737,-0.50147335,-0.60202153,-0.49656982,1.4115234,-0.50148198,-0.60202153,-0.49656982,1.4124903,-0.50147335,-0.6011237,-0.49656982,1.4065422,-0.50148198,-0.60202153,-0.49656982,1.4091148,-0.50147335,-0.60202153,-0.49656982,1.4106256,-0.50147335,-0.60202153,-0.49656982,1.4154341,-0.50147335,-0.60202153,-0.49656982,1.4096587,-0.50147335,-0.6011237,-0.49656982,1.4080702,-0.50148198,-0.60202153,-0.49656982,1.4153219,-0.50147335,-0.60202153,-0.49656982,1.4106169,-0.50147335,-0.60202153,-0.49656982,1.411368,-0.50148198,-0.60202153,-0.49656982,1.4088213,-0.50147335,-0.6011237,-0.49656982,1.40624,-0.50148198,-0.60202153,-0.49656982,1.4091752,-0.50148198,-0.6011237,-0.49656982,1.4000933,-0.50148198,-0.6011237,-0.49656982,1.4075522,-0.50148198,-0.6011237,-0.49656982,1.4056357,-0.50148198,-0.6011237,-0.49656982,1.4075436,-0.50148198,-0.6011237,-0.49656982,1.4068961,-0.50148198,-0.6011237,-0.49656982,1.4053249,-0.50148198,-0.6011237,-0.49656982,1.4045652,-0.50148198,-0.6011237,-0.49656982,1.4033998,-0.50148198,-0.5877167,-0.065819229,1.4041077,-0.49272815,-0.60202153,-0.49656982,1.409391,-0.50148198,-0.60202153,-0.49656982,1.4104961,-0.50148198,-0.60202153,-0.49656982,1.4112558,-0.50147335,-0.60202153,-0.49656982,1.4122054,-0.50147335,-0.60202153,-0.49656982,1.4117219,-0.50148198,-0.60202153,-0.49656982,1.4095464,-0.50148198,-0.6011237,-0.49656982,1.4062141,-0.50148198,-0.60202153,-0.49656982,1.4106256,-0.50148198,-0.5868275,0.18620302,1.4031235,-0.49034545,-0.6011237,-0.49656982,1.4085882,-0.50148198,-0.60202153,-0.49656982,1.4104356,-0.50148198,-0.6011237,-0.49656982,1.4086054,-0.50148198,-0.6011237,-0.49656982,1.4066544,-0.50148198,-0.60202153,-0.49656982,1.410686,-0.50148198,-0.60202153,-0.49656982,1.4132672,-0.50148198,-0.60202153,-0.49656982,1.4151233,-0.50148198,-0.60202153,-0.49656982,1.4119723,-0.50148198,-0.58504048,0.42303124,1.4029854,-0.48848936,-0.60202153,-0.49656982,1.410073,-0.50148198,-0.6011237,-0.49656982,1.4088731,-0.50148198,-0.60202153,-0.49656982,1.4114802,-0.50148198,-0.60202153,-0.49656982,1.411014,-0.50148198,-0.60202153,-0.49656982,1.4088558,-0.50148198,-0.6011237,-0.49656982,1.4048415,-0.50148198,-0.60202153,-0.49656982,1.408804,-0.50148198,-0.6011237,-0.49656982,1.4043753,-0.50148198,-0.60202153,-0.49656982,1.4093479,-0.50148198,-0.6011237,-0.49656982,1.4075091,-0.50148198,-0.6011237,-0.49656982,1.4039868,-0.50148198,-0.58592967,0.69560858,1.4010775,-0.48662464,-0.6011237,-0.49656982,1.4031408,-0.50148198,-0.6011237,-0.49656982,1.4046343,-0.50148198,-0.6011237,-0.49656982,1.405299,-0.50148198,-0.6011237,-0.49656982,1.4036933,-0.50148198,-0.6011237,-0.49656982,1.4074227,-0.50148198,-0.6011237,-0.49656982,1.4027696,-0.50148198,-0.6011237,-0.49656982,1.4074573,-0.50148198,-0.6011237,-0.49656982,1.407535,-0.50148198,-0.60202153,-0.49656982,1.4087436,-0.50148198,-0.6011237,-0.49656982,1.4014401,-0.50148198,-0.6011237,-0.49656982,1.4044616,-0.50148198,-0.6011237,-0.49656982,1.4016386,-0.50148198,-0.6011237,-0.49656982,1.4008789,-0.50148198,-0.6011237,-0.49656982,1.4043753,-0.50148198,-0.6011237,-0.49656982,1.4013278,-0.50148198,-0.6011237,-0.49656982,1.4016473,-0.50148198,-0.6011237,-0.49656982,1.4024588,-0.50148198,-0.6011237,-0.49656982,1.4039782,-0.50148198,-0.6011237,-0.49656982,1.405394,-0.50148198,-0.60202153,-0.49656982,1.410168,-0.50148198,-0.6011237,-0.49656982,1.4033221,-0.50148198,-0.6011237,-0.49656982,1.4028559,-0.50148198,-0.6011237,-0.49656982,1.4037019,-0.50148198,-0.6011237,-0.49656982,1.4067062,-0.50148198,-0.6011237,-0.49656982,1.4070429,-0.50148198,-0.60202153,-0.49656982,1.4110917,-0.50148198,-0.6011237,-0.49656982,1.4071724,-0.50148198,-0.60202153,-0.49656982,1.4099177,-0.50148198,-0.6011237,-0.49656982,1.4087695,-0.50148198,-0.60202153,-0.49656982,1.4090975,-0.50148198,-0.60202153,-0.49656982,1.4095033,-0.50148198,-0.60202153,-0.49656982,1.4089594,-0.50148198,-0.60202153,-0.49656982,1.412896,-0.50148198,-0.60202153,-0.49656982,1.4134658,-0.50147335,-0.60202153,-0.49656982,1.4103061,-0.50148198,-0.6011237,-0.49656982,1.4024242,-0.50148198,-0.6011237,-0.49656982,1.4052904,-0.50148198,-0.6011237,-0.49656982,1.4051523,-0.50148198,-0.6011237,-0.49656982,1.4069047,-0.50148198,-0.6011237,-0.49656982,1.4049796,-0.50148198,-0.6011237,-0.49656982,1.4041767,-0.50148198,-0.60202153,-0.49656982,1.410945,-0.50148198,-0.6011237,-0.49656982,1.405394,-0.50148198,-0.6011237,-0.49656982,1.4084673,-0.50148198,-0.6011237,-0.49656982,1.4060932,-0.50148198,-0.60202153,-0.49656982,1.41325,-0.50148198,-0.60202153,-0.49656982,1.4111781,-0.50148198,-0.60202153,-0.49656982,1.4118169,-0.50148198,-0.6011237,-0.49656982,1.407699,-0.50148198,-0.6011237,-0.49656982,1.4023811,-0.50148198,-0.60202153,-0.49656982,1.4104788,-0.50148198,-0.60202153,-0.49656982,1.4160816,-0.50147335,-0.60202153,-0.49656982,1.415037,-0.50147335,-0.5877167,1.9119161,1.4012588,-0.48018445,-0.60291072,-0.49656982,1.4176355,-0.50147335,-0.60291072,-0.49656982,1.4164096,-0.50147335,-0.60202153,-0.49656982,1.4146658,-0.50147335,-0.60291072,-0.49656982,1.417601,-0.50147335,-0.6011237,-0.49656982,1.4048328,-0.50148198,-0.60202153,-0.49656982,1.4127752,-0.50147335,-0.60202153,-0.49656982,1.4102802,-0.50147335,-0.60202153,-0.49656982,1.415037,-0.50147335,-0.60202153,-0.49656982,1.4144154,-0.50147335,-0.60202153,-0.49656982,1.4124126,-0.50147335,-0.60202153,-0.49656982,1.4113076,-0.50148198,-0.60202153,-0.49656982,1.4127147,-0.50147335,-0.60202153,-0.49656982,1.4103234,-0.50148198,-0.60202153,-0.49656982,1.4094083,-0.50148198,-0.6011237,-0.49656982,1.4085709,-0.50148198,-0.60202153,-0.49656982,1.4121104,-0.50148198,-0.60202153,-0.49656982,1.4092961,-0.50148198,-0.6011237,-0.49656982,1.4060587,-0.50148198,-0.6011237,-0.49656982,1.4072328,-0.50148198,-0.6011237,-0.49656982,1.407086,-0.50148198,-0.60202153,-0.49656982,1.4142946,-0.50147335,-0.60202153,-0.49656982,1.4143636,-0.50147335,-0.60202153,-0.49656982,1.4152356,-0.50147335,-0.60202153,-0.49656982,1.4133881,-0.50147335,-0.60202153,-0.49656982,1.4132327,-0.50148198,-0.60202153,-0.49656982,1.4121277,-0.50148198,-0.6011237,-0.49656982,1.4005422,-0.50148198,-0.6011237,-0.49656982,1.4017681,-0.50148198,-0.6002345,-0.49656982,1.3970891,-0.50148198,-0.6002345,-0.49656982,1.3967092,-0.50148198,-0.6011237,-0.49656982,1.4017681,-0.50148198,-0.6011237,-0.49656982,1.4008185,-0.50148198,-0.6011237,-0.49656982,1.4013278,-0.50148198,-0.6011237,-0.49656982,1.402666,-0.50148198,-0.6011237,-0.49656982,1.4024674,-0.50148198,-0.6002345,-0.49656982,1.4004387,-0.50148198,-0.6011237,-0.49656982,1.402994,-0.50148198,-0.6011237,-0.49656982,1.4013451,-0.50148198,-0.58592967,2.7484076,1.3785282,-0.47668809,-0.6011237,-0.49656982,1.4012415,-0.50148198,-0.6011237,-0.49656982,1.4028904,-0.50148198,-0.60202153,-0.49656982,1.408545,-0.50148198,-0.6011237,-0.49656982,1.4067752,-0.50148198,-0.60202153,-0.49656982,1.410945,-0.50147335,-0.6011237,-0.49656982,1.4044184,-0.50148198,-0.6011237,-0.49656982,1.4041422,-0.50148198,-0.6011237,-0.49656982,1.4001279,-0.50148198,-0.6002345,-0.49656982,1.3954229,-0.50148198,-0.59933667,-0.49656982,1.3903122,-0.50148198,-0.6011237,-0.49656982,1.4039782,-0.50148198,-0.6011237,-0.49656982,1.4030717,-0.50148198,-0.6011237,-0.49656982,1.4044357,-0.50148198,-0.6011237,-0.49656982,1.4018545,-0.50148198,-0.6011237,-0.49656982,1.4033652,-0.50148198,-0.6011237,-0.49656982,1.4038228,-0.50148198,-0.067606254,5.7949908,1.3570321,-0.46636306,-0.055088449,-0.056875474,1.3949049,-0.49890072,-0.061347351,-0.051514401,1.4011293,-0.49891799,-0.12479967,8.7691865,1.3348454,-0.45829987,-0.6011237,-0.49656982,1.4021911,-0.50148198,-0.60202153,-0.49656982,1.4098227,-0.50148198,-0.6011237,-0.49656982,1.4063695,-0.50148198,-0.60202153,-0.49656982,1.4116874,-0.50147335,-0.60202153,-0.49656982,1.4091062,-0.50148198,-0.60202153,-0.49656982,1.4102802,-0.50147335,-0.60202153,-0.49656982,1.4090716,-0.50148198,-0.60202153,-0.49656982,1.4107464,-0.50148198,-0.60202153,-0.49656982,1.4104011,-0.50148198,-0.6011237,-0.49656982,1.4036156,-0.50148198,-0.6011237,-0.49656982,1.4069134,-0.50148198,-0.6011237,-0.49656982,1.408027,-0.50148198,-0.6011237,-0.49656982,1.4068875,-0.50148198,-0.6011237,-0.49656982,1.4061364,-0.50148198,-0.6002345,-0.49656982,1.3986085,-0.50148198,-0.6011237,-0.49656982,1.4013278,-0.50148198,-0.6002345,-0.49656982,1.3991092,-0.50148198,-0.6011237,-0.49656982,1.4013019,-0.50148198,-0.6011237,-0.49656982,1.4024242,-0.50148198,-0.6011237,-0.49656982,1.4017768,-0.50148198,-0.6002345,-0.49656982,1.4009653,-0.50148198,-0.6002345,-0.49656982,1.401371,-0.50148198,-0.6002345,-0.49656982,1.4008962,-0.50148198,-0.6011237,-0.49656982,1.4009566,-0.50148198,-0.6011237,-0.49656982,1.4027955,-0.50148198,-0.6011237,-0.49656982,1.4024329,-0.50148198,-0.6011237,-0.49656982,1.4029508,-0.50148198,-0.6011237,-0.49656982,1.4029508,-0.50148198,-0.6011237,-0.49656982,1.4029508,-0.50148198,-0.6011237,-0.49656982,1.4029508,-0.50148198,-0.6011237,-0.49656982,1.4029508,-0.50148198,-0.6011237,-0.49656982,1.4029508,-0.50148198,-0.6011237,-0.49656982,1.4029508,-0.50148198:3
-0.48842868,-0.48842868,1.052952,-0.48842868,-0.48842868,-0.48842868,1.0421301,-0.48842868,-0.48842868,-0.48842868,1.0491538,-0.48842868,-0.48842868,-0.48842868,1.0476263,-0.48842868,-0.48842868,-0.48842868,1.0487446,-0.48842868,-0.48842868,-0.48842868,1.0476672,-0.48842868,-0.48842868,-0.48842868,1.0469103,-0.48842868,-0.48842868,-0.48842868,1.0484514,-0.48842868,-0.48842868,-0.48842868,1.0520382,-0.48842868,-0.48842868,-0.48842868,1.0530407,-0.48842868,-0.48842868,-0.48842868,1.0584278,-0.48842868,-0.52513601,7.0380681,1.0389728,-0.45481722,-0.52583838,6.9872452,1.0363611,-0.4549877,-0.52583838,7.0317126,1.0427233,-0.45493315,-0.52583838,6.9928914,1.040173,-0.45504907,-0.52654757,6.9561841,1.0381954,-0.455165,-0.52583838,6.935713,1.0377249,-0.45524683,-0.51948296,-0.4778454,1.0507494,-0.48829229,-0.51948296,-0.4778454,1.0540158,-0.48829229,-0.51948296,-0.4778454,1.0531293,-0.48829229,-0.52654757,7.055716,1.0426756,-0.45480358,-0.52089451,-0.47502228,1.0617078,-0.48828547,-0.52019215,-0.47502228,1.0582505,-0.48828547,-0.614787,0.7871631,1.0569958,-0.48208689,-0.51878059,-0.32536301,1.061094,-0.48598061,-0.53713084,4.9676122,1.049297,-0.459802,-0.52019215,-0.47502228,1.0595734,-0.48828547,-0.52089451,-0.47502228,1.0634194,-0.48828547,-0.52089451,-0.47502228,1.0625874,-0.48828547,-0.52019215,-0.47502228,1.0588437,-0.48828547,-0.52019215,-0.47572465,1.0589597,-0.48828547,-0.52089451,-0.47502228,1.0595734,-0.48828547,-0.52089451,-0.47502228,1.0603508,-0.48828547,-0.52019215,-0.47502228,1.0494879,-0.48828547,-0.52513601,4.0555614,1.0530884,-0.4622978,-0.42349018,0.25066186,1.0610599,-0.48466452,-0.77502955,6.1556737,1.0320787,-0.45498088,-0.20677166,7.2858477,1.039457,-0.45369889,-0.2053601,7.3444376,1.0461943,-0.45358978,-0.89856476,8.2381312,1.0470057,-0.44941648,-0.52019215,-0.47572465,1.0525974,-0.48828547,-0.52019215,-0.47502228,1.0445304,-0.48828547,-0.52089451,-0.47572465,1.0607463,-0.48828547,-0.52089451,-0.47361072,1.0562593,-0.48789678,-0.52019215,-0.47502228,1.0611418,-0.48828547,-0.52089451,-0.47502228,1.063999,-0.48828547,-0.52089451,-0.47572465,1.0635012,-0.48828547,-0.52089451,-0.47502228,1.0601257,-0.48828547,-0.52089451,-0.47502228,1.0642649,-0.48828547,-0.52089451,-0.47502228,1.0629079,-0.48828547,-0.52089451,-0.47502228,1.0595052,-0.48828547,-0.52089451,-0.47502228,1.0592324,-0.48828547,-0.52089451,-0.47078079,1.0689769,-0.4875831,-0.52089451,-0.47502228,1.0639103,-0.48828547,-0.52019215,-0.47572465,1.0562184,-0.48828547,-0.52089451,-0.47502228,1.0664539,-0.48828547,-0.52089451,-0.47502228,1.0653833,-0.48828547,-0.52089451,-0.47502228,1.0606576,-0.48828547,-0.52089451,-0.47502228,1.060419,-0.48828547,-0.52089451,-0.47502228,1.0682678,-0.48828547,-0.52089451,-0.47502228,1.0618851,-0.48828547,-0.52089451,-0.46160907,1.0611486,-0.48699666,-0.52089451,-0.47502228,1.0659765,-0.48828547,-0.52089451,-0.47502228,1.0692497,-0.48828547,-0.52089451,-0.47502228,1.0616259,-0.48828547,-0.52089451,-0.47502228,1.0604053,-0.48828547,-0.52089451,-0.47502228,1.0696589,-0.48828547,-0.52019215,-0.44396118,1.0612441,-0.48626019,-0.52089451,-0.47502228,1.0638217,-0.48828547,-0.52089451,-0.47502228,1.0675654,-0.48828547,-0.52089451,-0.47502228,1.0720251,-0.48828547,-0.52089451,-0.47502228,1.0610327,-0.48828547,-0.52019215,-0.47572465,1.0597166,-0.48828547,-0.51948296,-0.40584229,1.0700612,-0.48519641,-0.52089451,-0.47572465,1.0593211,-0.48828547,-0.52089451,-0.47502228,1.0601462,-0.48828547,-0.52089451,-0.47502228,1.0682268,-0.48828547,-0.52089451,-0.47502228,1.0698907,-0.48828547,-0.52089451,-0.47502228,1.0630443,-0.48828547,-0.51736903,-0.35501255,1.0599893,-0.48417354,-0.52089451,-0.47502228,1.0726593,-0.48828547,-0.52089451,-0.47502228,1.0664061,-0.48828547,-0.51595747,-0.31830522,1.0602553,-0.48355982,-0.52089451,-0.47502228,1.0665766,-0.48828547,-0.52089451,-0.47502228,1.0716705,-0.48828547,-0.52089451,-0.47502228,1.0608076,-0.48828547,-0.52089451,-0.47502228,1.0648173,-0.48828547,-0.52089451,-0.47502228,1.0702726,-0.48828547,-0.51383672,-0.24912523,1.0591233,-0.48259833,-0.52089451,-0.47502228,1.062492,-0.48828547,-0.52089451,-0.47502228,1.0616805,-0.48828547,-0.52089451,-0.47502228,1.0709477,-0.48828547,-0.52089451,-0.47502228,1.0604258,-0.48828547,-0.52089451,-0.47502228,1.0609304,-0.48828547,-0.52089451,-0.47502228,1.0754415,-0.48828547,-0.52089451,-0.47502228,1.0603167,-0.48828547,-0.52089451,-0.47502228,1.0630375,-0.48828547,-0.52089451,-0.47502228,1.0630239,-0.48828547,-0.52089451,-0.47502228,1.0707158,-0.48828547,-0.52089451,-0.47502228,1.0707158,-0.48828547,-0.52089451,-0.47502228,1.062451,-0.48828547,-0.50819049,0.0050029889,1.0633103,-0.47992523,-0.5216037,-0.47502228,1.0740708,-0.48828547,-0.52089451,-0.47502228,1.0668289,-0.48828547,-0.52089451,-0.47502228,1.0641695,-0.48828547,-0.52089451,-0.47502228,1.0639172,-0.48828547,-0.52089451,-0.47502228,1.069011,-0.48828547,-0.50889968,0.061478957,1.0555978,-0.47944107,-0.52089451,-0.47502228,1.0565525,-0.48828547,-0.52089451,-0.47502228,1.0703544,-0.48828547,-0.52089451,-0.47502228,1.0567775,-0.48828547,-0.52089451,-0.47572465,1.0571662,-0.48828547,-0.52089451,-0.47502228,1.0556865,-0.48828547,-0.50889968,0.17231015,1.0657992,-0.47856141,-0.52089451,-0.47502228,1.0554614,-0.48828547,-0.52089451,-0.47502228,1.057289,-0.48828547,-0.52089451,-0.47502228,1.0627306,-0.48828547,-0.52019215,-0.47502228,1.0537226,-0.48828547,-0.52089451,-0.47502228,1.0551887,-0.48828547,-0.50889968,0.20054131,1.0509131,-0.47835001,-0.52089451,-0.47502228,1.0646741,-0.48828547,-0.52089451,-0.47572465,1.0528497,-0.48828547,-0.52019215,-0.47502228,1.0497266,-0.48828547,-0.52089451,-0.47502228,1.0641558,-0.48828547,-0.52089451,-0.47502228,1.0543022,-0.48828547,-0.50889968,0.34878902,1.0590278,-0.47729987,-0.52089451,-0.47502228,1.0644422,-0.48828547,-0.52089451,-0.47502228,1.0564298,-0.48828547,-0.52089451,-0.47572465,1.062076,-0.48828547,-0.52089451,-0.47502228,1.063358,-0.48828547,-0.50889968,0.52244478,1.0611009,-0.47618153,-0.52019215,-0.47572465,1.0550864,-0.48828547,-0.52019215,-0.47572465,1.0543499,-0.48828547,-0.5216037,-0.47431309,1.0740095,-0.48828547,-0.52019215,-0.47572465,1.0540772,-0.48828547,-0.52089451,-0.47502228,1.0551205,-0.48828547,-0.51031124,0.79210696,1.067654,-0.47462677,-0.52089451,-0.47502228,1.0573162,-0.48828547,-0.52019215,-0.47502228,1.0556728,-0.48828547,-0.52019215,-0.47572465,1.046092,-0.48828547,-0.52019215,-0.47572465,1.0500675,-0.48828547,-0.52019215,-0.47502228,1.0492424,-0.48828547,-0.51031124,0.91140068,1.0400502,-0.47399259,-0.52089451,-0.47502228,1.0582232,-0.48828547,-0.52019215,-0.47572465,1.0471217,-0.48828547,-0.52019215,-0.47572465,1.0390205,-0.48828547,-0.52089451,-0.47502228,1.0527474,-0.48828547,-0.52019215,-0.47572465,1.043187,-0.48828547,-0.50960205,1.0998812,1.0360338,-0.47303792,-0.52019215,-0.47572465,1.0453351,-0.48828547,-0.52019215,-0.47572465,1.0484105,-0.48828547,-0.52019215,-0.47502228,1.0477149,-0.48828547,-0.52019215,-0.47572465,1.0431052,-0.48828547,-0.52019215,-0.47572465,1.0508244,-0.48828547,-0.50960205,1.3638972,1.049447,-0.47179684,-0.52089451,-0.47502228,1.0494947,-0.48828547,-0.52089451,-0.47572465,1.0489219,-0.48828547,-0.52089451,-0.47572465,1.0615373,-0.48828547,-0.52089451,-0.47572465,1.0591029,-0.48828547,-0.52019215,-0.47572465,1.0532521,-0.48828547,-0.50960205,1.5015548,1.0553864,-0.47118993,-0.52089451,-0.47572465,1.0570912,-0.48828547,-0.52019215,-0.47572465,1.0479945,-0.48828547,-0.52089451,-0.47502228,1.0513086,-0.48828547,-0.52089451,-0.47502228,1.0653628,-0.48828547,-0.52089451,-0.47502228,1.0557479,-0.48828547,-0.50960205,1.5679048,1.049031,-0.47089671,-0.52089451,-0.47572465,1.0612372,-0.48828547,-0.52089451,-0.47572465,1.0534703,-0.48828547,-0.52089451,-0.47572465,1.0531975,-0.48828547,-0.52019215,-0.47572465,1.0530884,-0.48828547,-0.52089451,-0.47572465,1.0568116,-0.48828547,-0.51031124,1.7253243,1.0544727,-0.47023526,-0.53430773,1.8234514,1.0493515,-0.46981929,-0.52089451,-0.47572465,1.05182,-0.48828547,-0.52019215,-0.47572465,1.0484855,-0.48828547,-0.52089451,-0.47572465,1.0508176,-0.48828547,-0.52019215,-0.47572465,1.0456828,-0.48828547,-0.52089451,-0.47502228,1.0592938,-0.48828547,-0.53501692,1.6780336,1.0527065,-0.47041937,-0.52019215,-0.47572465,1.0534021,-0.48828547,-0.52089451,-0.47572465,1.0614145,-0.48828547,-0.52089451,-0.47572465,1.0577663,-0.48828547,-0.52019215,-0.47572465,1.0468216,-0.48828547,-0.52019215,-0.47572465,1.0524747,-0.48828547,-0.53501692,1.4987248,1.053818,-0.4711763,-0.52089451,-0.47502228,1.056798,-0.48828547,-0.52019215,-0.47572465,1.0536476,-0.48828547,-0.52089451,-0.47572465,1.0608895,-0.48828547,-0.52089451,-0.47572465,1.0570435,-0.48828547,-0.52089451,-0.47572465,1.0582846,-0.48828547,-0.53360536,1.342717,1.0452396,-0.47187185,-0.52089451,-0.47502228,1.0545,-0.48828547,-0.52089451,-0.47572465,1.059812,-0.48828547,-0.52019215,-0.47572465,1.0487651,-0.48828547,-0.52089451,-0.47572465,1.0557342,-0.48828547,-0.52089451,-0.47572465,1.0582641,-0.48828547,-0.53430773,1.1401208,1.0439303,-0.47282652,-0.52019215,-0.47572465,1.0528838,-0.48828547,-0.52089451,-0.47502228,1.0572003,-0.48828547,-0.52019215,-0.47572465,1.0514791,-0.48828547,-0.52089451,-0.47572465,1.0504767,-0.48828547,-0.52089451,-0.47572465,1.0566821,-0.48828547,-0.53430773,0.9452849,1.0540158,-0.47379484,-0.52089451,-0.47572465,1.0482127,-0.48828547,-0.52019215,-0.47572465,1.0526042,-0.48828547,-0.52089451,-0.47572465,1.059212,-0.48828547,-0.52089451,-0.47572465,1.0551546,-0.48828547,-0.52089451,-0.47572465,1.0529656,-0.48828547,-0.53360536,0.74268878,1.0577527,-0.47487908,-0.52089451,-0.47502228,1.0623556,-0.48828547,-0.52089451,-0.47502228,1.0592461,-0.48828547,-0.52089451,-0.47572465,1.0590756,-0.48828547,-0.52089451,-0.47502228,1.0686905,-0.48828547,-0.52089451,-0.47502228,1.0686974,-0.48828547,-0.53360536,0.47938203,1.0505517,-0.47642702,-0.52089451,-0.47572465,1.0594779,-0.48828547,-0.52089451,-0.47572465,1.0576367,-0.48828547,-0.52019215,-0.47572465,1.0497334,-0.48828547,-0.52089451,-0.47572465,1.0546977,-0.48828547,-0.52089451,-0.47572465,1.0561434,-0.48828547,-0.53289617,0.19348352,1.0571799,-0.47838411,-0.52089451,-0.47572465,1.0532452,-0.48828547,-0.52089451,-0.47572465,1.0557001,-0.48828547,-0.52089451,-0.47572465,1.0567025,-0.48828547,-0.52089451,-0.47572465,1.0563888,-0.48828547,-0.52089451,-0.47572465,1.053368,-0.48828547,-0.5321938,-0.064879373,1.0536203,-0.48056623,-0.52089451,-0.47572465,1.0567366,-0.48828547,-0.52089451,-0.47572465,1.0512541,-0.48828547,-0.52089451,-0.47572465,1.0563479,-0.48828547,-0.52089451,-0.47572465,1.058571,-0.48828547,-0.52089451,-0.47572465,1.0594984,-0.48828547,-0.53007305,-0.24135825,1.0571321,-0.48248922,-0.52089451,-0.47572465,1.0607326,-0.48828547,-0.52089451,-0.47502228,1.0648036,-0.48828547,-0.52089451,-0.47502228,1.0612031,-0.48828547,-0.52089451,-0.47502228,1.0657447,-0.48828547,-0.52089451,-0.47572465,1.0601735,-0.48828547,-0.52795913,-0.38395291,1.065581,-0.48471907,-0.52089451,-0.47572465,1.0566412,-0.48828547,-0.52089451,-0.47502228,1.0563411,-0.48828547,-0.52089451,-0.47572465,1.0590415,-0.48828547,-0.52089451,-0.47572465,1.0595188,-0.48828547,-0.52089451,-0.47502228,1.0676472,-0.48828547,-0.52301526,-0.47290153,1.0675449,-0.48780814,-0.52089451,-0.47572465,1.057514,-0.48828547,-0.52089451,-0.47502228,1.057289,-0.48828547,-0.52089451,-0.47572465,1.0577595,-0.48828547,-0.52089451,-0.47502228,1.0620965,-0.48828547,-0.52089451,-0.47572465,1.0594847,-0.48828547,-0.52089451,-0.47502228,1.0630852,-0.48828547,-0.52089451,-0.47572465,1.0580527,-0.48828547,-0.52089451,-0.47502228,1.0658879,-0.48828547,-0.52089451,-0.47572465,1.0549977,-0.48828547,-0.52089451,-0.47502228,1.0551,-0.48828547,-0.52089451,-0.47502228,1.0629488,-0.48828547,-0.52089451,-0.47502228,1.0494606,-0.48828547,-0.52089451,-0.47502228,1.0657651,-0.48828547,-0.52089451,-0.47502228,1.0568866,-0.48828547,-0.52089451,-0.47502228,1.0626761,-0.48828547,-0.52089451,-0.47502228,1.0637944,-0.48828547,-0.52089451,-0.47572465,1.0567434,-0.48828547,-0.52089451,-0.47502228,1.061285,-0.48828547,-0.52089451,-0.47572465,1.0528429,-0.48828547,-0.52089451,-0.47502228,1.0579982,-0.48828547,-0.52089451,-0.47502228,1.066222,-0.48828547,-0.5216037,-0.47502228,1.0707022,-0.48828547,-0.52089451,-0.47502228,1.0655469,-0.48828547,-0.52089451,-0.47502228,1.0647695,-0.48828547,-0.52089451,-0.47572465,1.0678518,-0.48828547,-0.52089451,-0.47502228,1.0663379,-0.48828547,-0.52089451,-0.47502228,1.0642377,-0.48828547,-0.52089451,-0.47502228,1.0664607,-0.48828547,-0.52089451,-0.47361072,1.0702385,-0.48795816,-0.52089451,-0.47502228,1.0628125,-0.48828547,-0.52089451,-0.47502228,1.0609713,-0.48828547,-0.52089451,-0.47502228,1.070218,-0.48828547,-0.52089451,-0.47502228,1.0647832,-0.48828547,-0.52089451,-0.47502228,1.0622465,-0.48828547,-0.52089451,-0.47290153,1.0582232,-0.48778086,-0.52089451,-0.47502228,1.0673063,-0.48828547,-0.52089451,-0.47502228,1.0604803,-0.48828547,-0.52089451,-0.47502228,1.0634057,-0.48828547,-0.52089451,-0.47502228,1.0720592,-0.48828547,-0.52089451,-0.47502228,1.0674426,-0.48828547,-0.52089451,-0.47502228,1.0649741,-0.48828547,-0.52089451,-0.47502228,1.062151,-0.48828547,-0.52089451,-0.47502228,1.0696452,-0.48828547,-0.52089451,-0.47502228,1.0629284,-0.48828547,-0.52089451,-0.47572465,1.0658742,-0.48828547,-0.52089451,-0.47502228,1.0629216,-0.48828547,-0.52089451,-0.47502228,1.0678245,-0.48828547,-0.52089451,-0.47502228,1.0647082,-0.48828547,-0.52089451,-0.47502228,1.0626761,-0.48828547,-0.52089451,-0.45948832,1.0692634,-0.48689437,-0.52089451,-0.47502228,1.0674495,-0.48828547,-0.52089451,-0.47502228,1.0567162,-0.48828547,-0.52089451,-0.47502228,1.0671767,-0.48828547,-0.52089451,-0.47502228,1.0667062,-0.48828547,-0.52089451,-0.47502228,1.0614009,-0.48828547,-0.52089451,-0.47502228,1.0638967,-0.48828547,-0.52089451,-0.47502228,1.0675449,-0.48828547,-0.52089451,-0.47502228,1.0646332,-0.48828547,-0.51948296,-0.42842722,1.0601121,-0.48575558,-0.52089451,-0.47502228,1.0680359,-0.48828547,-0.52089451,-0.47572465,1.0646741,-0.48828547,-0.52089451,-0.47502228,1.0679814,-0.48828547,-0.52089451,-0.47502228,1.0666584,-0.48828547,-0.52089451,-0.47502228,1.0654378,-0.48828547,-0.5180714,-0.37054651,1.0708181,-0.48445995,-0.52089451,-0.47502228,1.0658606,-0.48828547,-0.5216037,-0.47572465,1.069502,-0.48828547,-0.5216037,-0.47502228,1.0715682,-0.48828547,-0.52089451,-0.47502228,1.0652878,-0.48828547,-0.52089451,-0.47502228,1.0656697,-0.48828547,-0.52089451,-0.47502228,1.0717114,-0.48828547,-0.52089451,-0.47502228,1.0653424,-0.48828547,-0.52089451,-0.47502228,1.0667539,-0.48828547,-0.51031124,-0.12135534,1.0633921,-0.48114585,-0.52089451,-0.47502228,1.0701567,-0.48828547,-0.52089451,-0.47502228,1.0659493,-0.48828547,-0.52089451,-0.47502228,1.0612372,-0.48828547,-0.52089451,-0.47502228,1.064865,-0.48828547,-0.52089451,-0.47502228,1.0648991,-0.48828547,-0.50960205,0.18007031,1.0571935,-0.47851367,-0.52089451,-0.47572465,1.054234,-0.48828547,-0.52089451,-0.47502228,1.0688951,-0.48828547,-0.52089451,-0.47572465,1.0656629,-0.48828547,-0.52089451,-0.47502228,1.052461,-0.48828547,-0.52019215,-0.47572465,1.0404185,-0.48828547,-0.52089451,-0.47502228,1.0580732,-0.48828547,-0.52019215,-0.47572465,1.0496311,-0.48828547,-0.52089451,-0.47502228,1.052236,-0.48828547,-0.52089451,-0.47572465,1.0579709,-0.48828547,-0.52089451,-0.47502228,1.0535112,-0.48828547,-0.52089451,-0.47572465,1.0494333,-0.48828547,-0.52089451,-0.47502228,1.0558842,-0.48828547,-0.52089451,-0.47572465,1.0551341,-0.48828547,-0.52089451,-0.47502228,1.0512063,-0.48828547,-0.52019215,-0.47572465,1.0446941,-0.48828547,-0.52089451,-0.47502228,1.061926,-0.48828547,-0.4905426,-0.25971533,1.0561843,-0.48450768,-0.60984314,0.7596343,1.0423551,-0.48215508,-0.21312708,7.3077302,1.0382568,-0.45356932,-0.21736176,7.2307833,1.0353723,-0.45384891,-0.87738457,8.0743564,1.0325833,-0.44979835,-0.48842868,-0.48842868,1.0527611,-0.48842868,-0.48842868,-0.48842868,1.0593006,-0.48842868,-0.48842868,-0.48842868,1.0547795,-0.48842868,-0.48842868,-0.48842868,1.0451782,-0.48842868,-0.48842868,-0.48842868,1.0521815,-0.48842868,-0.48842868,-0.48842868,1.0557206,-0.48842868,-0.48842868,-0.48842868,1.0436507,-0.48842868,-0.48842868,-0.48842868,1.047749,-0.48842868,-0.48842868,-0.48842868,1.061285,-0.48842868,-0.48842868,-0.48842868,1.0490583,-0.48842868,-0.48842868,-0.48842868,1.0501494,-0.48842868,-0.48842868,-0.48842868,1.0544318,-0.48842868,-0.48842868,-0.48842868,1.0544318,-0.48842868,-0.48842868,-0.48842868,1.0544318,-0.48842868,-0.48842868,-0.48842868,1.0544318,-0.48842868,-0.48842868,-0.48842868,1.0544318,-0.48842868,-0.48842868,-0.48842868,1.0544318,-0.48842868,-0.48842868,-0.48842868,1.0544318,-0.48842868:3
-0.58515754,2.319553,1.3181558,-0.50115767,-0.56837054,-0.52220224,1.3169312,-0.52370253,-0.55494094,2.6394062,1.3218457,-0.499925,-0.58432225,2.1718031,1.3139144,-0.50176589,-0.56921395,-0.52220224,1.3290308,-0.52369442,-0.56921395,-0.52220224,1.3294769,-0.52369442,-0.58432225,2.081129,1.3238001,-0.50213894,-0.56921395,-0.52220224,1.3307744,-0.52369442,-0.060470532,-0.029410527,1.3292336,-0.5208236,-0.11168305,9.157409,1.3040206,-0.4808754,-0.56921395,-0.52220224,1.3243597,-0.52369442,-0.56921395,-0.52220224,1.3255842,-0.52369442,-0.55577624,2.0525911,1.3226242,-0.50226869,-0.084815737,9.2060995,1.3065833,-0.48071321,-0.10161085,9.2304447,1.3107435,-0.4807051,-0.56921395,-0.52220224,1.3323963,-0.52369442,-0.55409754,2.0710568,1.3161365,-0.50217948,-0.56921395,-0.52220224,1.3343345,-0.52369442,-0.56921395,-0.52220224,1.3286497,-0.52369442,-0.55577624,-0.081458337,1.3354375,-0.51493598,-0.56921395,-0.52220224,1.3368972,-0.52369442,-0.56921395,-0.52220224,1.3365404,-0.52369442,-0.56921395,-0.52220224,1.3349184,-0.52369442,-0.56921395,-0.52220224,1.3335966,-0.52369442,-0.56921395,-0.52220224,1.3326964,-0.52369442,-0.56921395,-0.52220224,1.3366863,-0.52369442,-0.56921395,-0.52220224,1.3355591,-0.52369442,-0.56921395,-0.52220224,1.3355185,-0.52369442,-0.56921395,-0.52220224,1.3340912,-0.52369442,-0.56921395,-0.52220224,1.3354942,-0.52369442,-0.56921395,-0.52220224,1.3364917,-0.52369442,-0.56921395,-0.52220224,1.3353564,-0.52369442,-0.56921395,-0.52220224,1.3334425,-0.52369442,-0.56921395,-0.52220224,1.3346589,-0.52369442,-0.56921395,-0.52220224,1.33607,-0.52369442,-0.56921395,-0.52220224,1.3333695,-0.52369442,-0.56921395,-0.52220224,1.3316583,-0.52369442,-0.56921395,-0.52220224,1.3327613,-0.52369442,-0.56921395,-0.52220224,1.3305798,-0.52369442,-0.56921395,-0.52220224,1.3334019,-0.52369442,-0.56921395,-0.52220224,1.3338236,-0.52369442,-0.56921395,-0.52220224,1.3338804,-0.52369442,-0.56921395,-0.52220224,1.3356645,-0.52369442,-0.56921395,-0.52220224,1.3347562,-0.52369442,-0.56921395,-0.52220224,1.3324855,-0.52369442,-0.56921395,-0.52220224,1.3343183,-0.52369442,-0.55494094,0.10407451,1.3326072,-0.51322484,-0.56921395,-0.52220224,1.3312772,-0.52369442,-0.56921395,-0.52220224,1.3346508,-0.52369442,-0.56921395,-0.52220224,1.3353564,-0.52369442,-0.56921395,-0.52220224,1.3282199,-0.52369442,-0.56921395,-0.52220224,1.335032,-0.52369442,-0.56921395,-0.52220224,1.3334263,-0.52369442,-0.56921395,-0.52220224,1.3357051,-0.52369442,-0.56921395,-0.52220224,1.3374081,-0.52369442,-0.56921395,-0.52220224,1.3350644,-0.52369442,-0.56921395,-0.52220224,1.3342291,-0.52369442,-0.56921395,-0.52220224,1.3372621,-0.52369442,-0.56921395,-0.52220224,1.3359321,-0.52369442,-0.56921395,-0.52220224,1.3371891,-0.52369442,-0.56921395,-0.52220224,1.3368485,-0.52369442,-0.56921395,-0.52136694,1.3401492,-0.52369442,-0.56921395,-0.52220224,1.3362484,-0.52369442,-0.56921395,-0.52136694,1.3363701,-0.52369442,-0.56921395,-0.52136694,1.3366863,-0.52369442,-0.56921395,-0.52220224,1.3343994,-0.52369442,-0.56921395,-0.52136694,1.334667,-0.52369442,-0.56921395,-0.52220224,1.3379433,-0.52369442,-0.56921395,-0.52220224,1.3353807,-0.52369442,-0.56921395,-0.52220224,1.3321206,-0.52369442,-0.56921395,-0.52136694,1.3345697,-0.52369442,-0.56921395,-0.52220224,1.3346995,-0.52369442,-0.56921395,-0.52220224,1.331188,-0.52369442,-0.56921395,-0.52220224,1.3303527,-0.52369442,-0.56921395,-0.52220224,1.3369458,-0.52369442,-0.56921395,-0.52220224,1.3350563,-0.52369442,-0.56921395,-0.52220224,1.3304095,-0.52369442,-0.56921395,-0.52220224,1.332518,-0.52369442,-0.56921395,-0.52220224,1.3301662,-0.52369442,-0.56921395,-0.52220224,1.3325829,-0.52369442,-0.56921395,-0.52220224,1.3299472,-0.52369442,-0.56921395,-0.52220224,1.3305635,-0.52369442,-0.56921395,-0.52220224,1.3351617,-0.52369442,-0.56921395,-0.52220224,1.334367,-0.52369442,-0.56921395,-0.52136694,1.3333938,-0.52369442,-0.56921395,-0.52220224,1.3345697,-0.52369442,-0.56669184,-0.43573702,1.3351617,-0.51991531,-0.56921395,-0.52220224,1.3344481,-0.52369442,-0.10916094,9.2405169,1.3116924,-0.48068888,-0.58684435,4.9522736,1.3209212,-0.49235057,-0.56921395,-0.52220224,1.3321611,-0.52369442,-0.55494094,2.3841951,1.3257464,-0.50090627,-0.56921395,-0.52220224,1.3343994,-0.52369442,-0.56921395,-0.52220224,1.3366539,-0.52369442,-0.56837054,-0.48610613,1.3305717,-0.52131018,-0.56921395,-0.52220224,1.3308393,-0.52369442,-0.56921395,-0.52220224,1.3347968,-0.52369442,-0.56921395,-0.52220224,1.3325666,-0.52369442,-0.56921395,-0.52220224,1.333702,-0.52369442,-0.56921395,-0.52220224,1.3323477,-0.52369442,-0.56921395,-0.52220224,1.3347481,-0.52369442,-0.56921395,-0.52220224,1.3348211,-0.52369442,-0.56921395,-0.52220224,1.3353239,-0.52369442,-0.56921395,-0.52220224,1.336362,-0.52369442,-0.56921395,-0.52220224,1.3338966,-0.52369442,-0.56921395,-0.52220224,1.3335884,-0.52369442,-0.56921395,-0.52220224,1.3343994,-0.52369442,-0.56921395,-0.52220224,1.3364512,-0.52369442,-0.56921395,-0.52220224,1.3349833,-0.52369442,-0.56753525,-0.46428303,1.3334019,-0.52062086,-0.56921395,-0.52220224,1.3340264,-0.52369442,-0.56921395,-0.52220224,1.335697,-0.52369442,-0.56921395,-0.52220224,1.335405,-0.52369442,-0.57004924,-0.52220224,1.339841,-0.52369442,-0.56921395,-0.52220224,1.3369864,-0.52369442,-0.56921395,-0.52220224,1.3379271,-0.52369442,-0.56921395,-0.52220224,1.3361592,-0.52369442,-0.56921395,-0.52220224,1.3317313,-0.52369442,-0.56921395,-0.52220224,1.3360781,-0.52369442,-0.56921395,-0.52220224,1.3332965,-0.52369442,-0.56921395,-0.52220224,1.3372865,-0.52369442,-0.56921395,-0.52220224,1.337108,-0.52369442,-0.56921395,-0.52220224,1.3353726,-0.52369442,-0.56921395,-0.52220224,1.3346184,-0.52369442,-0.56921395,-0.52220224,1.3326477,-0.52369442,-0.57340664,4.0775006,1.3253328,-0.49498621,-0.56921395,-0.52220224,1.3363782,-0.52369442,-0.56921395,-0.52220224,1.3380974,-0.52369442,-0.56921395,-0.52220224,1.3373189,-0.52369442,-0.56921395,-0.52220224,1.3360538,-0.52369442,-0.56921395,-0.52220224,1.3382921,-0.52369442,-0.57004924,-0.52220224,1.3401654,-0.52369442,-0.56921395,-0.52220224,1.3378379,-0.52369442,-0.56921395,-0.52220224,1.3382191,-0.52369442,-0.56921395,-0.52220224,1.3361917,-0.52369442,-0.56921395,-0.52220224,1.3385272,-0.52369442,-0.56921395,-0.52220224,1.3399708,-0.52369442,-0.56921395,-0.52220224,1.3385516,-0.52369442,-0.56921395,-0.52220224,1.3375784,-0.52369442,-0.56921395,-0.52220224,1.3358916,-0.52369442,-0.56921395,-0.52220224,1.3360619,-0.52369442,-0.56921395,-0.52220224,1.3368729,-0.52369442,-0.56921395,-0.52220224,1.3344967,-0.52369442,-0.56921395,-0.52220224,1.3318611,-0.52369442,-0.56921395,-0.52220224,1.3349184,-0.52369442,-0.56921395,-0.52220224,1.3335722,-0.52369442,-0.56921395,-0.52220224,1.3318043,-0.52369442,-0.56921395,-0.52220224,1.3350968,-0.52369442,-0.56921395,-0.52220224,1.3350725,-0.52369442,-0.56921395,-0.52220224,1.3366377,-0.52369442,-0.56921395,-0.52220224,1.332964,-0.52369442,-0.56921395,-0.52220224,1.3319827,-0.52369442,-0.56921395,-0.52220224,1.3308636,-0.52369442,-0.56921395,-0.52220224,1.3348049,-0.52369442,-0.56921395,-0.52220224,1.33341,-0.52369442,-0.56921395,-0.52220224,1.3343426,-0.52369442,-0.56921395,-0.52220224,1.33474,-0.52369442,-0.56921395,-0.52220224,1.3354861,-0.52369442,-0.56921395,-0.52220224,1.3326153,-0.52369442,-0.56921395,-0.52220224,1.333775,-0.52369442,-0.56921395,-0.52220224,1.3332316,-0.52369442,-0.56921395,-0.52220224,1.3322504,-0.52369442,-0.56921395,-0.52220224,1.3333289,-0.52369442,-0.56921395,-0.52220224,1.3370432,-0.52369442,-0.57508534,4.0195733,1.3257221,-0.49516463,-0.56921395,-0.52220224,1.3348373,-0.52369442,-0.56921395,-0.52220224,1.3366863,-0.52369442,-0.56921395,-0.52220224,1.330523,-0.52369442,-0.56921395,-0.52220224,1.333483,-0.52369442,-0.56921395,-0.52220224,1.3297282,-0.52369442,-0.57676404,3.9549312,1.3217646,-0.49536737,-0.56921395,-0.52220224,1.3303284,-0.52369442,-0.56921395,-0.52220224,1.3306852,-0.52369442,-0.56921395,-0.52220224,1.3337506,-0.52369442,-0.56921395,-0.52220224,1.3335641,-0.52369442,-0.56921395,-0.52220224,1.3309771,-0.52369442,-0.10748224,4.0984884,1.3202643,-0.49496188,-0.56921395,-0.52220224,1.3316989,-0.52369442,-0.56921395,-0.52052354,1.3306771,-0.52335381,-0.58515754,3.5889016,1.3217889,-0.49655949,-0.56921395,-0.52220224,1.3310258,-0.52369442,-0.56921395,-0.52220224,1.3299391,-0.52369442,-0.58432225,3.5544842,1.3139387,-0.49667302,-0.56837054,-0.52220224,1.324457,-0.52369442,-0.56921395,-0.52220224,1.3264682,-0.52369442,-0.56921395,-0.52220224,1.3278063,-0.52369442,-0.56921395,-0.52220224,1.3292011,-0.52369442,-0.56921395,-0.52220224,1.3279036,-0.52369442,-0.56921395,-0.52220224,1.3291606,-0.52369442,-0.56921395,-0.52220224,1.3316016,-0.52369442,-0.56921395,-0.52220224,1.327563,-0.52369442,-0.56921395,-0.52220224,1.3296309,-0.52369442,-0.56921395,-0.52220224,1.3294444,-0.52369442,-0.56921395,-0.52220224,1.3272548,-0.52369442,-0.56921395,-0.52220224,1.326752,-0.52369442,-0.56837054,-0.52220224,1.3223809,-0.52369442,-0.56921395,-0.52220224,1.3230216,-0.52369442,-0.56921395,-0.52220224,1.3258113,-0.52369442,-0.56921395,-0.52220224,1.3299391,-0.52369442,-0.56921395,-0.52220224,1.333037,-0.52369442,-0.56921395,-0.52220224,1.3306122,-0.52369442,-0.56921395,-0.52220224,1.3331505,-0.52369442,-0.56921395,-0.52220224,1.3327613,-0.52369442,-0.56921395,-0.52220224,1.3334425,-0.52369442,-0.56921395,-0.52220224,1.3287875,-0.52369442,-0.56921395,-0.52220224,1.3283253,-0.52369442,-0.56921395,-0.52220224,1.3279117,-0.52369442,-0.56921395,-0.52220224,1.3328667,-0.52369442,-0.56921395,-0.52220224,1.3338723,-0.52369442,-0.56921395,-0.52220224,1.3329235,-0.52369442,-0.56921395,-0.52220224,1.3346022,-0.52369442,-0.56921395,-0.52220224,1.3302716,-0.52369442,-0.56921395,-0.52220224,1.3312934,-0.52369442,-0.56921395,-0.52220224,1.3320395,-0.52369442,-0.56921395,-0.52220224,1.3328586,-0.52369442,-0.56921395,-0.52220224,1.3334344,-0.52369442,-0.56921395,-0.52220224,1.3354212,-0.52369442,-0.56921395,-0.52220224,1.3339128,-0.52369442,-0.56921395,-0.52220224,1.3312123,-0.52369442,-0.56921395,-0.52220224,1.3283739,-0.52369442,-0.56921395,-0.52220224,1.3280577,-0.52369442,-0.58515754,2.8291398,1.3201345,-0.49921135,-0.56837054,-0.52220224,1.324684,-0.52369442,-0.56921395,-0.52220224,1.3251625,-0.52369442,-0.56837054,-0.52220224,1.3238487,-0.52369442,-0.56837054,-0.52220224,1.3225512,-0.52370253,-0.56837054,-0.52220224,1.3207995,-0.52369442,-0.58432225,2.5227163,1.3125033,-0.50037103,-0.56837054,-0.52220224,1.3209536,-0.52370253,-0.56837054,-0.52220224,1.320913,-0.52370253,-0.56837054,-0.52220224,1.3219997,-0.52369442,-0.56837054,-0.52220224,1.322535,-0.52369442,-0.56837054,-0.52220224,1.3215943,-0.52369442,-0.56837054,-0.52220224,1.3232243,-0.52369442,-0.56837054,-0.52220224,1.3243678,-0.52369442,-0.56837054,-0.52220224,1.3224296,-0.52370253,-0.56837054,-0.52220224,1.3235406,-0.52369442,-0.56837054,-0.52220224,1.3231594,-0.52369442,-0.56921395,-0.52220224,1.325276,-0.52369442,-0.56921395,-0.52220224,1.3257788,-0.52369442,-0.56837054,-0.52220224,1.3189181,-0.52370253,-0.56837054,-0.52220224,1.3184153,-0.52370253,-0.56837054,-0.52220224,1.3175881,-0.52370253,-0.56837054,-0.52220224,1.319356,-0.52369442,-0.56837054,-0.52220224,1.3179773,-0.52370253,-0.56837054,-0.52220224,1.3188289,-0.52370253,-0.56837054,-0.52220224,1.3228188,-0.52369442,-0.56837054,-0.52220224,1.3233135,-0.52370253,-0.56837054,-0.52220224,1.3220484,-0.52369442,-0.56837054,-0.52220224,1.3177584,-0.52370253,-0.56837054,-0.52220224,1.3196398,-0.52370253,-0.56837054,-0.52220224,1.3243029,-0.52369442,-0.56921395,-0.52220224,1.3272305,-0.52369442,-0.56921395,-0.52220224,1.3297607,-0.52369442,-0.56921395,-0.52220224,1.3279522,-0.52369442,-0.56921395,-0.52220224,1.326679,-0.52369442,-0.56921395,-0.52220224,1.326971,-0.52369442,-0.56921395,-0.52220224,1.3280495,-0.52369442,-0.56921395,-0.52220224,1.3289822,-0.52369442,-0.56921395,-0.52220224,1.3283577,-0.52369442,-0.58347884,0.55237661,1.3253977,-0.50990799,-0.56921395,-0.52220224,1.3330532,-0.52369442,-0.56921395,-0.52220224,1.3340345,-0.52369442,-0.56921395,-0.52220224,1.33444,-0.52369442,-0.56921395,-0.52220224,1.3342859,-0.52369442,-0.56921395,-0.52220224,1.3337344,-0.52369442,-0.58432225,0.30723776,1.328382,-0.51161102,-0.56921395,-0.52220224,1.3343994,-0.52369442,-0.56921395,-0.52220224,1.3336047,-0.52369442,-0.56921395,-0.52220224,1.3325018,-0.52369442,-0.56921395,-0.52220224,1.3325018,-0.52369442,-0.56921395,-0.52220224,1.334002,-0.52369442,-0.56921395,-0.52220224,1.3256896,-0.52369442,-0.56921395,-0.52220224,1.3317394,-0.52369442,-0.56921395,-0.52220224,1.3353888,-0.52369442,-0.56921395,-0.52220224,1.3362403,-0.52369442,-0.56921395,-0.52220224,1.3365079,-0.52369442,-0.56921395,-0.52220224,1.3352185,-0.52369442,-0.56921395,-0.52220224,1.335332,-0.52369442,-0.56921395,-0.52220224,1.3373351,-0.52369442,-0.56921395,-0.52220224,1.3361268,-0.52369442,-0.56921395,-0.52220224,1.3337263,-0.52369442,-0.56921395,-0.52220224,1.332964,-0.52369442,-0.56921395,-0.52220224,1.3322504,-0.52369442,-0.56921395,-0.52220224,1.3333695,-0.52369442,-0.56921395,-0.52220224,1.3335641,-0.52369442,-0.56921395,-0.52220224,1.332891,-0.52369442,-0.56921395,-0.52220224,1.3303365,-0.52369442,-0.56921395,-0.52220224,1.3270034,-0.52369442,-0.56921395,-0.52220224,1.3289254,-0.52368631,-0.56921395,-0.52220224,1.3270358,-0.52369442,-0.56921395,-0.52220224,1.3286659,-0.52369442,-0.56921395,-0.52220224,1.3314151,-0.52369442,-0.56921395,-0.52220224,1.3307501,-0.52369442,-0.56921395,-0.52220224,1.3341075,-0.52369442,-0.56921395,-0.52220224,1.3314394,-0.52369442,-0.56921395,-0.52220224,1.3327775,-0.52369442,-0.56921395,-0.52220224,1.3339453,-0.52369442,-0.56921395,-0.52220224,1.328674,-0.52369442,-0.56921395,-0.52220224,1.3306446,-0.52369442,-0.56921395,-0.52220224,1.328009,-0.52369442,-0.56921395,-0.52220224,1.3298742,-0.52369442,-0.56921395,-0.52220224,1.3301662,-0.52369442,-0.56921395,-0.52220224,1.3262168,-0.52369442,-0.56921395,-0.52220224,1.3293065,-0.52369442,-0.56921395,-0.52220224,1.3292336,-0.52369442,-0.56921395,-0.52220224,1.3281225,-0.52369442,-0.56921395,-0.52220224,1.328893,-0.52369442,-0.56921395,-0.52220224,1.3281469,-0.52369442,-0.56921395,-0.52220224,1.3330938,-0.52369442,-0.56921395,-0.52220224,1.3322422,-0.52369442,-0.56921395,-0.52220224,1.3353077,-0.52369442,-0.56921395,-0.52220224,1.3379596,-0.52369442,-0.56921395,-0.52220224,1.3313096,-0.52369442,-0.56921395,-0.52220224,1.3280982,-0.52369442,-0.56921395,-0.52220224,1.3286091,-0.52369442,-0.56921395,-0.52220224,1.3304176,-0.52369442,-0.56921395,-0.52220224,1.3276765,-0.52369442,-0.56921395,-0.52220224,1.3289092,-0.52369442,-0.56921395,-0.52220224,1.3287389,-0.52369442,-0.56921395,-0.52220224,1.3281712,-0.52369442,-0.56921395,-0.52220224,1.3287875,-0.52369442,-0.56921395,-0.52220224,1.3273927,-0.52369442,-0.56921395,-0.52220224,1.3289578,-0.52369442,-0.56921395,-0.52220224,1.3286902,-0.52369442,-0.56921395,-0.52220224,1.3294606,-0.52369442,-0.56921395,-0.52220224,1.3278955,-0.52369442,-0.56921395,-0.52220224,1.3269061,-0.52369442,-0.56921395,-0.52220224,1.3299634,-0.52369442,-0.56921395,-0.52220224,1.3297201,-0.52369442,-0.56921395,-0.52220224,1.3284226,-0.52369442,-0.56921395,-0.52220224,1.3290065,-0.52369442,-0.56921395,-0.52220224,1.3296634,-0.52369442,-0.56921395,-0.52220224,1.3305473,-0.52369442,-0.56921395,-0.52052354,1.3309934,-0.52335381,-0.56921395,-0.52220224,1.32749,-0.52369442,-0.56921395,-0.52220224,1.3287389,-0.52369442,-0.56921395,-0.52220224,1.331707,-0.52369442,-0.56921395,-0.52220224,1.331488,-0.52369442,-0.56921395,-0.52220224,1.3321368,-0.52369442,-0.56921395,-0.52220224,1.3316421,-0.52369442,-0.56921395,-0.52220224,1.3342534,-0.52369442,-0.56921395,-0.52220224,1.3336695,-0.52369442,-0.56921395,-0.52220224,1.3344237,-0.52369442,-0.56921395,-0.52220224,1.3370675,-0.52369442,-0.56921395,-0.52220224,1.3369702,-0.52369442,-0.56921395,-0.52220224,1.3369377,-0.52369442,-0.56921395,-0.52220224,1.3370432,-0.52369442,-0.56921395,-0.52220224,1.3351617,-0.52369442,-0.56921395,-0.52220224,1.3380893,-0.52369442,-0.56921395,-0.52220224,1.3378055,-0.52369442,-0.56921395,-0.52220224,1.3374324,-0.52369442,-0.56921395,-0.52220224,1.3355915,-0.52369442,-0.56921395,-0.52220224,1.3357943,-0.52369442,-0.56921395,-0.52220224,1.3360943,-0.52369442,-0.56921395,-0.52220224,1.3339858,-0.52369442,-0.56921395,-0.52220224,1.3366539,-0.52369442,-0.56921395,-0.52220224,1.3338074,-0.52369442,-0.56921395,-0.52220224,1.3360051,-0.52369442,-0.56921395,-0.52220224,1.3360051,-0.52369442,-0.56921395,-0.52220224,1.3360051,-0.52369442,-0.56921395,-0.52220224,1.3360051,-0.52369442,-0.56921395,-0.52220224,1.3360051,-0.52369442,-0.56921395,-0.52220224,1.3360051,-0.52369442,-0.56921395,-0.52220224,1.3360051,-0.52369442:3
-0.98236353,0.094307058,1.6062438,-0.65648892,-0.98236353,0.082906922,1.6055866,-0.65652875,-0.98029259,0.063213064,1.6055966,-0.65661836,-0.9761507,0.029022615,1.6046408,-0.65675775,-0.97304429,-0.010355144,1.6051486,-0.65691705,-0.98029259,0.079790554,1.6043122,-0.65654866,-0.98132806,0.10674266,1.6028785,-0.65643914,-0.97925712,0.049741988,1.603685,-0.65666814,-0.97822165,0.037306382,1.6028884,-0.65671792,-0.97407976,-4.3644712E-7,1.6032867,-0.65687722,-0.97304429,-0.0051777904,1.6008772,-0.65689714,-0.97304429,-0.0010359072,1.6001006,-0.65688718,-0.98029259,0.073577729,1.5991249,-0.65655862,-0.97304429,-0.0082842028,1.6017833,-0.65691705,-0.97096339,-0.0093196736,1.6008972,-0.65691705,-0.97096339,-0.012436042,1.6005586,-0.65693696,-0.98132806,0.11916831,1.6008573,-0.65638936,-0.97407976,-0.0093196736,1.6020023,-0.65691705,-0.97407976,0.0010350344,1.6023906,-0.65687722,-0.97200882,-0.002071378,1.6000011,-0.65687722,-0.9761507,0.034199969,1.6017932,-0.65673783,-0.97718618,0.044564634,1.6010963,-0.65669801,-0.97200882,-0.0041423196,1.6008474,-0.65689714,-0.97200882,0.0031159324,1.6016638,-0.65686727,-0.97304429,0.0031159324,1.6013552,-0.65686727,-0.97304429,0.0062223448,1.6021716,-0.65685731,-0.97200882,-0.002071378,1.6021915,-0.65688718,-0.97925712,0.084977864,1.6008573,-0.65652875,-0.97407976,0.0082932864,1.6000807,-0.65684735,-0.97304429,-0.0051777904,1.6002002,-0.65689714,-0.97304429,-0.0041423196,1.6009768,-0.65689714,-0.97304429,-0.002071378,1.6014448,-0.65688718,-0.97822165,0.0041514032,1.6232693,-0.65688718,-0.97718618,-0.0031068488,1.622423,-0.65691705,-0.97718618,-4.3644712E-7,1.6223633,-0.65689714,-0.9761507,-0.010355144,1.6218057,-0.65694692,-0.97822165,-0.002071378,1.6233689,-0.65690709,-0.9761507,-0.0051777904,1.6235481,-0.65691705,-0.97718618,0.041448265,1.6228412,-0.65672788,-0.97822165,0.0062223448,1.6242351,-0.65687722,-0.9761507,-0.010355144,1.6179028,-0.65692701,-0.9761507,-4.3644712E-7,1.6166582,-0.65688718,-0.97718618,0.014506111,1.6132432,-0.65682744,-0.97925712,-4.3644712E-7,1.6263458,-0.65689714,-0.98132806,0.072542258,1.626306,-0.65659844,-0.97925712,0.0020705051,1.6256588,-0.65688718,-0.98132806,0.025906246,1.6257385,-0.65678762,-0.98443447,0.12746204,1.6265748,-0.65636944,-0.98236353,0.036270911,1.6264255,-0.65674779,-0.98236353,0.054929298,1.6255892,-0.65667809,-0.98236353,0.13679123,1.6254199,-0.65633958,-0.98132806,0.032129028,1.6284765,-0.6567677,-0.98443447,0.080835981,1.6285163,-0.65656857,-0.97925712,0.01762248,1.6305276,-0.6568374,-0.9854799,0.061142123,1.6302289,-0.65665818,-0.98755084,0.046635575,1.6317621,-0.65671792,-0.98755084,0.05700024,1.6302687,-0.65667809,-0.983399,0.095342529,1.630189,-0.65651879,-0.98236353,0.041448265,1.6317024,-0.65673783,-0.98029259,0.055964769,1.6325188,-0.65667809,-0.97718618,-0.007248732,1.6321903,-0.65694692,-0.983399,0.011399699,1.6301492,-0.65686727,-0.97718618,-0.0082842028,1.6309159,-0.65694692,-0.97822165,-0.015542455,1.6316128,-0.65697679,-0.97718618,-0.013471513,1.6317024,-0.65696683,-0.97822165,-0.016577926,1.630657,-0.65697679,-0.97718618,-0.014506984,1.6303782,-0.65696683,-0.97718618,-0.017613396,1.6314435,-0.65698674,-0.97718618,-0.013471513,1.6316526,-0.65697679,-0.97822165,-0.017613396,1.6315232,-0.65697679,-0.97822165,-0.017613396,1.6312544,-0.65697679,-0.97718618,-0.016577926,1.6300098,-0.65698674,-0.97718618,-0.016577926,1.629731,-0.65696683,-0.97718618,-0.016577926,1.6294921,-0.65696683,-0.97718618,-0.016577926,1.6305475,-0.65697679,-0.97718618,-0.016577926,1.6305276,-0.65698674,-0.97718618,-0.014506984,1.6305176,-0.65695688,-0.97925712,-0.014506984,1.6319115,-0.65688718,-0.97718618,-0.012436042,1.6315929,-0.65697679,-0.97718618,-0.013471513,1.6321007,-0.65697679,-0.9761507,-0.015542455,1.6307267,-0.65698674,-0.98962178,0.14922684,1.6305375,-0.65621014,-0.98236353,0.039377323,1.6307267,-0.65673783,-0.98651537,0.080835981,1.6305475,-0.65658849,-0.98755084,0.1160619,1.6301691,-0.65640927,-0.98651537,0.10155535,1.6275008,-0.65647897,-0.98651537,0.099484412,1.6291635,-0.65648892,-0.98443447,0.05700024,1.630657,-0.65667809,-0.98962178,0.11916831,1.6310851,-0.65633958,-0.98962178,0.12228468,1.6311548,-0.65636944,-0.98755084,0.084977864,1.6299899,-0.65655862,-0.98443447,0.087048806,1.6303981,-0.65669801,-0.98236353,0.044564634,1.6277597,-0.65672788,-0.98236353,0.040412794,1.6293626,-0.65672788,-0.983399,0.047671046,1.6303483,-0.65671792,-0.983399,0.037306382,1.6302986,-0.65675775,-0.983399,0.042493692,1.6296613,-0.65671792,-0.98755084,0.11813284,1.6283869,-0.65640927,-0.98755084,0.10984908,1.6285761,-0.6564491,-0.98651537,0.082906922,1.6304877,-0.65656857,-0.983399,0.03523544,1.6306072,-0.6567677,-0.98132806,0.032129028,1.6220447,-0.6567677,-0.98029259,0.021764363,1.6230602,-0.65680753,-0.97925712,0.0072578156,1.6288847,-0.65686727,-0.97822165,-0.016577926,1.6325089,-0.65697679,-0.97718618,-0.015542455,1.6329569,-0.65697679,-0.97718618,-0.015542455,1.6317522,-0.65697679,-0.98755084,0.09326163,1.6300696,-0.65652875,-0.98132806,0.027977188,1.6311946,-0.65679757,-0.983399,0.05700024,1.6296315,-0.65666814,-0.98236353,0.031093557,1.6296414,-0.6567677,-0.9854799,0.05700024,1.6304379,-0.65667809,-0.9854799,0.054929298,1.6317721,-0.65667809,-0.98132806,0.0093287572,1.6317422,-0.65686727,-0.9854799,0.066319477,1.6322699,-0.65663827,-0.98443447,0.041448265,1.6320011,-0.65673783,-0.9854799,0.059071181,1.6333054,-0.65666814,-0.98029259,-0.0010359072,1.6342513,-0.65691705,-0.98132806,-4.3644712E-7,1.6342513,-0.65690709,-0.98755084,0.062177594,1.6337136,-0.65664823,-0.9854799,0.036270911,1.6346097,-0.65675775,-0.9854799,0.044564634,1.635456,-0.65672788,-0.98132806,0.0020705051,1.6359737,-0.65689714,-0.97925712,-0.014506984,1.6359638,-0.65696683,-0.97925712,-0.013471513,1.6337933,-0.65696683,-0.97925712,-0.016577926,1.6365811,-0.65697679,-0.97925712,-0.016577926,1.6374174,-0.65697679,-0.98236353,0.014506111,1.6356253,-0.65684735,-0.98236353,0.018657951,1.6351075,-0.65682744,-0.98236353,0.010364228,1.6369495,-0.65686727,-0.98132806,0.019693422,1.6366408,-0.65682744,-0.97925712,-0.0041423196,1.6375767,-0.65692701,-0.98132806,0.011399699,1.6376464,-0.65685731,-0.98132806,0.015551538,1.6341019,-0.65684735,-0.98443447,0.043529163,1.6330266,-0.65672788,-0.9854799,0.073577729,1.6346794,-0.6566084,-0.98443447,0.0528484,1.6342413,-0.65669801,-0.97718618,-0.016577926,1.6338231,-0.65697679,-0.98029259,-4.3644712E-7,1.6348885,-0.65690709,-0.98029259,0.0072578156,1.6334946,-0.65687722,-0.98029259,-4.3644712E-7,1.6338331,-0.65690709,-0.97822165,-0.013471513,1.6353365,-0.65696683,-0.97822165,-0.0082842028,1.6346893,-0.65694692,-0.97718618,-0.015542455,1.6322201,-0.65697679,-0.97822165,-0.0082842028,1.6326981,-0.65694692,-0.97822165,-0.014506984,1.6335244,-0.65696683,-0.97718618,-0.014506984,1.6338231,-0.65696683,-0.97718618,-0.015542455,1.6327578,-0.65697679,-0.97822165,-0.016577926,1.633624,-0.65697679,-0.97718618,-0.017613396,1.6291336,-0.65696683,-0.9761507,-0.018648867,1.6291237,-0.65697679,-0.97718618,-0.018648867,1.6305375,-0.65698674,-0.9761507,-0.013471513,1.6286856,-0.65695688,-0.97718618,-0.017613396,1.6300596,-0.65698674,-0.97718618,-0.017613396,1.6297908,-0.65696683,-0.9761507,-0.019684338,1.6301193,-0.6569967,-0.97718618,-0.015542455,1.6280982,-0.65696683,-0.9761507,-0.018648867,1.629293,-0.65697679,-0.97718618,-0.019684338,1.6311747,-0.65698674,-0.97718618,-0.018648867,1.6299999,-0.65698674,-0.9761507,-0.019684338,1.6294921,-0.65697679,-0.9761507,-0.014506984,1.6223832,-0.65695688,-0.9761507,-0.017613396,1.6223035,-0.65697679,-0.9761507,-0.017613396,1.6238567,-0.65697679,-0.97822165,-0.017613396,1.6344106,-0.65697679,-0.97718618,-0.017613396,1.6350179,-0.65698674,-0.97822165,-0.018648867,1.635675,-0.65698674,-0.97822165,-0.019684338,1.6349482,-0.65698674,-0.97925712,-0.015542455,1.6344603,-0.65696683,-0.97822165,-0.019684338,1.6348984,-0.65698674,-0.97822165,-0.015542455,1.6340123,-0.65697679,-0.97925712,-0.016577926,1.6346396,-0.65697679,-0.98029259,0.0010350344,1.6343508,-0.65690709,-0.97925712,-0.011400572,1.6333651,-0.65695688,-0.98858631,0.1575106,1.6318318,-0.65626988,-0.97925712,-0.012436042,1.6323794,-0.65695688,-0.97822165,-0.0093196736,1.6296713,-0.65693696,-0.97925712,-0.007248732,1.6319613,-0.65693696,-0.97822165,-0.015542455,1.631344,-0.65697679,-0.97822165,-0.018648867,1.6289246,-0.65697679,-0.97822165,-0.015542455,1.6297012,-0.65695688,-0.97718618,-0.019684338,1.6322201,-0.65698674,-0.98132806,0.011399699,1.6330864,-0.65685731,-0.97925712,-0.0082842028,1.631802,-0.65694692,-0.97925712,-0.0082842028,1.6319115,-0.65694692,-0.97925712,-0.007248732,1.6300994,-0.65693696,-0.97925712,-0.0082842028,1.6291536,-0.65692701,-0.97925712,-0.007248732,1.6287254,-0.65692701,-0.97822165,-0.017613396,1.6307267,-0.65697679,-0.97822165,-0.017613396,1.629044,-0.65696683,-0.97925712,-0.016577926,1.6300098,-0.65697679,-0.97407976,-0.018648867,1.6079563,-0.65695688,-0.97407976,-0.015542455,1.6074186,-0.65693696,-0.97407976,-0.018648867,1.6085238,-0.65695688,-0.97407976,-0.017613396,1.6088524,-0.65694692,-0.97407976,-0.020719809,1.6099277,-0.65695688,-0.97511523,-0.010355144,1.6081554,-0.65691705,-0.97407976,-0.019684338,1.6090515,-0.65695688,-0.97511523,-0.018648867,1.6097385,-0.65694692,-0.97407976,-0.019684338,1.6084641,-0.65695688,-0.97304429,-0.020719809,1.6086034,-0.65696683,-0.97407976,-0.018648867,1.6090117,-0.65695688,-0.97407976,-0.019684338,1.6103259,-0.65696683,-0.97511523,-0.0093196736,1.6086632,-0.65691705,-0.97407976,-0.019684338,1.608016,-0.65695688,-0.97511523,-0.016577926,1.6102562,-0.65695688,-0.97511523,-0.017613396,1.6105848,-0.65695688,-0.97407976,-0.019684338,1.6107939,-0.65696683,-0.97407976,-0.017613396,1.6095891,-0.65694692,-0.97407976,-0.015542455,1.6087628,-0.65693696,-0.97407976,-0.013471513,1.6088324,-0.65693696,-0.97925712,0.027977188,1.6098679,-0.65675775,-0.9761507,-0.007248732,1.609629,-0.65690709,-0.97511523,-0.018648867,1.6104354,-0.65696683,-0.97925712,0.031093557,1.611232,-0.65675775,-0.97511523,-0.013471513,1.6091013,-0.65692701,-0.9761507,0.005186874,1.6091112,-0.65685731,-0.97511523,-4.3644712E-7,1.6062039,-0.65687722,-0.97304429,-0.014506984,1.6066719,-0.65693696,-0.98029259,0.05700024,1.6091013,-0.65663827,-0.97511523,-4.3644712E-7,1.6083645,-0.65687722,-0.9761507,0.036270911,1.5994933,-0.65671792,-0.97822165,0.05700024,1.6002301,-0.65663827,-0.97511523,0.01243517,1.5998617,-0.65680753,-0.97304429,-0.017613396,1.6095194,-0.65694692,-0.9761507,0.016587009,1.6089221,-0.65680753,-0.97407976,-0.017613396,1.6084043,-0.65694692,-0.97304429,-0.019684338,1.6100372,-0.65697679,-0.98029259,0.047671046,1.6074485,-0.65667809,-0.97304429,-0.017613396,1.6074585,-0.65694692,-0.97511523,-0.0093196736,1.608713,-0.65691705,-0.97407976,-0.014506984,1.6081156,-0.65693696,-0.97511523,-0.0062132612,1.6090714,-0.65689714,-0.97925712,0.040412794,1.607797,-0.65670796,-0.97925712,0.034199969,1.6076476,-0.65672788,-0.97511523,-0.0062132612,1.6081952,-0.65689714,-0.98029259,0.067354948,1.6083944,-0.65659844,-0.98132806,0.061142123,1.6089221,-0.65661836,-0.98236353,0.091190689,1.6077771,-0.65649888,-0.97822165,0.037306382,1.6081355,-0.65671792,-0.9761507,0.010364228,1.608932,-0.6568374,-0.97511523,0.0020705051,1.6088922,-0.65686727,-0.97718618,0.021764363,1.6081853,-0.65678762,-0.97304429,-0.013471513,1.6087428,-0.65693696,-0.97304429,-0.016577926,1.608245,-0.65694692,-0.97407976,-0.0093196736,1.6085935,-0.65691705,-0.97407976,0.0010350344,1.6092805,-0.65687722,-0.97304429,-0.017613396,1.6081156,-0.65694692,-0.97407976,0.005186874,1.6067117,-0.65685731,-0.97511523,0.0031159324,1.6078069,-0.65686727,-0.97407976,-0.0082842028,1.6070303,-0.65690709,-0.97407976,-4.3644712E-7,1.6081056,-0.65687722,-0.97511523,-4.3644712E-7,1.6091909,-0.65687722,-0.97511523,-0.0010359072,1.6118592,-0.65689714,-0.97407976,0.0010350344,1.6104653,-0.65688718,-0.9761507,-0.0010359072,1.6122475,-0.65689714,-0.97511523,-0.0010359072,1.6130142,-0.65689714,-0.97718618,0.022799834,1.6133626,-0.65679757,-0.97822165,0.01762248,1.6141591,-0.65681748,-0.9761507,-0.0010359072,1.6139202,-0.65689714,-0.98443447,0.098448941,1.6132531,-0.65647897,-0.98443447,0.094307058,1.6145076,-0.65649888,-0.983399,0.095342529,1.6148461,-0.65649888,-0.97511523,-0.018648867,1.6167478,-0.65696683,-0.97925712,0.19378195,1.5860919,-0.65605084,-0.97511523,0.0528484,1.5852556,-0.65663827,-0.9761507,0.059071181,1.585853,-0.6566084,-0.9761507,0.086013335,1.5868287,-0.65649888,-0.97304429,0.027977188,1.5869681,-0.65673783,-0.97096339,0.0010350344,1.586988,-0.65684735,-0.97200882,0.014506111,1.5868187,-0.65679757,-0.96992792,-0.0082842028,1.5857335,-0.65688718,-0.97200882,0.016587009,1.5852157,-0.65678762,-0.97096339,0.0072578156,1.5870776,-0.65682744,-0.96992792,-0.0010359072,1.5861317,-0.65685731,-0.96889245,-0.0041423196,1.5863408,-0.65687722,-0.96992792,0.0031159324,1.5855244,-0.65684735,-0.96889245,-4.3644712E-7,1.584927,-0.65685731,-0.96992792,0.0072578156,1.5853054,-0.65682744,-0.97304429,0.049741988,1.5820894,-0.65664823,-0.97304429,0.068400375,1.5768623,-0.65655862,-0.97200882,0.051812929,1.5787042,-0.65662831,-0.97407976,0.069435846,1.5866694,-0.65656857,-0.97407976,0.068400375,1.5861317,-0.65656857,-0.97200882,0.034199969,1.5869283,-0.65671792,-0.97718618,0.05803571,1.6093203,-0.65663827,-0.97925712,0.083942393,1.6052481,-0.65652875,-0.97822165,0.059071181,1.6074684,-0.65663827,-0.97925712,0.070471316,1.6057758,-0.65658849,-0.97718618,0.047671046,1.6070801,-0.65667809,-0.97511523,0.033164498,1.6068312,-0.65674779,-0.97304429,0.0010350344,1.6078468,-0.65687722,-0.97304429,0.01243517,1.6074186,-0.65682744,-0.97511523,0.020728892,1.6081654,-0.65679757,-0.97304429,0.0082932864,1.6067416,-0.65684735,-0.97200882,-4.3644712E-7,1.6085338,-0.65688718,-0.97304429,0.0031159324,1.6087329,-0.65686727,-0.97304429,-4.3644712E-7,1.6092705,-0.65687722,-0.98132806,0.16476885,1.6080558,-0.65620018,-0.97200882,-0.0093196736,1.6089619,-0.65691705,-0.97200882,-0.0082842028,1.6067814,-0.65691705,-0.97511523,0.021764363,1.606652,-0.65678762,-0.97407976,0.0093287572,1.6090316,-0.6568374,-0.97096339,-0.016577926,1.6086234,-0.65694692,-0.9761507,0.03523544,1.6093502,-0.65673783,-0.97304429,0.005186874,1.6082649,-0.65685731,-0.97407976,0.0072578156,1.6090017,-0.65684735,-0.97304429,-4.3644712E-7,1.6099974,-0.65689714,-0.9761507,0.036270911,1.6089519,-0.65672788,-0.97925712,0.054929298,1.6101467,-0.65666814,-0.97407976,0.005186874,1.6118891,-0.65687722,-0.97925712,0.054929298,1.6113016,-0.65666814,-0.97925712,0.062177594,1.6113713,-0.65663827,-0.9761507,0.031093557,1.6121081,-0.6567677,-0.97718618,0.029022615,1.6124168,-0.6567677,-0.97718618,0.029022615,1.6122873,-0.6567677,-0.97718618,0.033164498,1.6100073,-0.65675775,-0.96992792,-0.0062132612,1.5930714,-0.65689714,-0.97096339,-0.010355144,1.594764,-0.65690709,-0.97096339,-0.0051777904,1.5949532,-0.65688718,-0.96889245,-0.015542455,1.593848,-0.65693696,-0.96785698,-0.0093196736,1.5910801,-0.65691705,-0.96682151,-0.017613396,1.5923147,-0.65694692,-0.96682151,-0.016577926,1.5910303,-0.65694692,-0.96889245,0.0041514032,1.5928324,-0.65685731,-0.97096339,-0.0010359072,1.6014746,-0.65688718,-0.97200882,-0.0041423196,1.6083048,-0.65689714,-0.97200882,-0.0082842028,1.6092108,-0.65691705,-0.97304429,-0.0093196736,1.610067,-0.65692701,-0.97304429,-0.0062132612,1.6092108,-0.65690709,-0.97304429,-0.0051777904,1.610087,-0.65691705,-0.97200882,-0.017613396,1.610764,-0.65696683,-0.97200882,-0.014506984,1.6120086,-0.65695688,-0.97511523,0.0082932864,1.6104553,-0.65685731,-0.97200882,-0.016577926,1.6103956,-0.65696683,-0.97407976,-0.0031068488,1.6110428,-0.65690709,-0.97718618,0.033164498,1.6114012,-0.65675775,-0.97718618,0.05803571,1.6061741,-0.65663827,-0.97304429,0.020728892,1.5993738,-0.65678762,-0.97200882,-0.002071378,1.6012954,-0.65688718,-0.97925712,0.081871452,1.6092705,-0.6565387,-0.98029259,0.080835981,1.6079463,-0.6565387,-0.98443447,0.14093311,1.6103558,-0.65630971,-0.97925712,0.027977188,1.6118493,-0.6567677,-0.97511523,-0.013471513,1.6130938,-0.65694692,-0.98029259,0.042493692,1.6117995,-0.65670796,-0.98029259,0.045600104,1.6127354,-0.65669801,-0.98029259,0.048706517,1.6108436,-0.65668805,-0.98029259,0.090155218,1.6052979,-0.65650883,-0.98132806,0.073577729,1.6023906,-0.65656857,-0.97925712,0.05803571,1.6027391,-0.65663827,-0.97925712,0.041448265,1.6030079,-0.65670796,-0.97925712,0.038341852,1.6047204,-0.65671792,-0.97925712,0.045600104,1.6018331,-0.65668805,-0.97407976,-0.0041423196,1.602311,-0.65689714,-0.97407976,-0.013471513,1.6048797,-0.65693696,-0.97511523,-0.0093196736,1.6074684,-0.65691705,-0.97718618,0.033164498,1.6057858,-0.65673783,-0.97822165,0.05700024,1.6045512,-0.65663827,-0.97822165,0.05700024,1.6045512,-0.65663827,-0.97822165,0.05700024,1.6045512,-0.65663827,-0.97822165,0.05700024,1.6045512,-0.65663827,-0.97822165,0.05700024,1.6045512,-0.65663827,-0.97822165,0.05700024,1.6045512,-0.65663827,-0.97822165,0.05700024,1.6045512,-0.65663827:4
-0.86369904,0.18229716,1.5713815,-0.88271241,-0.8625691,0.18681691,1.5729677,-0.88269068,-0.83768874,0.2422273,1.5738369,-0.88244079,-0.85917929,0.18003728,1.5736414,-0.88272327,-0.85351873,0.19925708,1.5755644,-0.88263635,-0.86143916,0.17664747,1.5718595,-0.88273414,-0.86482897,0.19247746,1.5759121,-0.88266895,-0.86482897,0.18003728,1.5749995,-0.88272327,-0.86708885,0.18116722,1.5738913,-0.88271241,-0.86708885,0.17890734,1.5732285,-0.88272327,-0.86482897,0.1936074,1.5749886,-0.88265808,-0.86708885,0.18229716,1.5746301,-0.88271241,-0.86934872,0.17890734,1.5699147,-0.88272327,-0.8625691,0.16985698,1.5722833,-0.88276673,-0.87500928,0.16194742,1.5717292,-0.88279933,-0.85917929,0.20943739,1.5733915,-0.88259289,-0.86369904,0.18229716,1.5744562,-0.88271241,-0.8625691,0.17777741,1.5762815,-0.88273414,-0.85803848,0.18455703,1.5751516,-0.88270154,-0.85917929,0.17890734,1.5775635,-0.88272327,-0.85803848,0.18342709,1.5801059,-0.88272327,-0.86030922,0.18342709,1.5812467,-0.88272327,-0.86030922,0.17777741,1.5770203,-0.88273414,-0.86143916,0.17437673,1.5768465,-0.882745,-0.86369904,0.17098692,1.5779981,-0.88275587,-0.8625691,0.17550667,1.5793888,-0.88275587,-0.85690855,0.18568697,1.5731416,-0.88269068,-0.86595891,0.15176711,1.5688717,-0.88284278,-0.87047866,0.14271675,1.5779221,-0.88288624,-0.86934872,0.14497662,1.5764553,-0.88287538,-0.81506826,0.30555813,1.5764227,-0.8821583,-0.8625691,0.18907678,1.5732285,-0.88267981,-0.85803848,0.19925708,1.5731524,-0.88263635,-0.85803848,0.19925708,1.5756188,-0.88263635,-0.85351873,0.19247746,1.5729134,-0.88266895,-0.8716086,0.19247746,1.5722507,-0.88266895,-0.86708885,0.20038702,1.5777048,-0.88262549,-0.85690855,0.19812715,1.564591,-0.88261462,-0.85803848,0.19021758,1.5744454,-0.88267981,-0.85464867,0.20038702,1.5794758,-0.88264722,-0.85803848,0.18342709,1.570621,-0.88270154,-0.85351873,0.1936074,1.5717943,-0.88265808,-0.85577861,0.19021758,1.5682416,-0.88266895,-0.85917929,0.18342709,1.572707,-0.88270154,-0.85690855,0.18568697,1.5753145,-0.88269068,-0.81393833,0.30668806,1.5787044,-0.88214744,-0.85125886,0.19586727,1.5789108,-0.88266895,-0.84220849,0.22187756,1.5687305,-0.88252771,-0.85012892,0.20604757,1.5786283,-0.88260376,-0.8523888,0.20830745,1.5767161,-0.88259289,-0.85351873,0.18907678,1.5750212,-0.88267981,-0.85464867,0.1936074,1.580584,-0.88267981,-0.85917929,0.19134752,1.5805405,-0.88269068,-0.86030922,0.19699721,1.5764879,-0.88264722,-0.86482897,0.18455703,1.5755536,-0.88270154,-0.85351873,0.19247746,1.5720986,-0.88266895,-0.85464867,0.19586727,1.5716531,-0.88266895,-0.86482897,0.18794684,1.5730764,-0.88267981,-0.85351873,0.18455703,1.5711751,-0.88264722,-0.84786905,0.19699721,1.5720986,-0.88259289,-0.86143916,0.19473733,1.5713054,-0.88265808,-0.85917929,0.1936074,1.5699799,-0.88265808,-0.85464867,0.18455703,1.5699147,-0.88270154,-0.8523888,0.19134752,1.5647214,-0.88264722,-0.85351873,0.18568697,1.5639174,-0.88266895,-0.84899898,0.19247746,1.566601,-0.88263635,-0.84446837,0.21056732,1.5722398,-0.88258203,-0.81506826,0.29876764,1.5759447,-0.8821909,-0.82750844,0.25579742,1.5756405,-0.8823756,-0.84333843,0.21848775,1.5767704,-0.88254944,-0.81054851,0.30215745,1.5764553,-0.88216917,-0.81959888,0.27615802,1.5739782,-0.88228868,-0.85351873,0.19247746,1.5682416,-0.88266895,-0.85803848,0.17324679,1.5678287,-0.88272327,-0.85351873,0.19021758,1.570132,-0.88266895,-0.85803848,0.18229716,1.5683611,-0.88271241,-0.85803848,0.20604757,1.5674919,-0.88258203,-0.85351873,0.20943739,1.5681112,-0.88259289,-0.86030922,0.18116722,1.5721312,-0.88271241,-0.86595891,0.17777741,1.5684806,-0.88273414,-0.84220849,0.23883749,1.568926,-0.88245165,-0.86143916,0.19134752,1.5720877,-0.88266895,-0.86482897,0.19925708,1.5679374,-0.88261462,-0.84786905,0.21169726,1.566199,-0.8825603,-0.82863838,0.25918723,1.5597344,-0.882343,-0.83090912,0.29424789,1.5607992,-0.8821909,-0.82863838,0.30328739,1.5654059,-0.88214744,-0.81393833,0.31459763,1.5657861,-0.88209311,-0.85125886,0.21508707,1.56483,-0.88253857,-0.84899898,0.21621701,1.5678396,-0.88253857,-0.84899898,0.21395714,1.5644932,-0.88254944,-0.84899898,0.21621701,1.5653189,-0.88253857,-0.83429893,0.26031717,1.5661012,-0.88233214,-0.85012892,0.21621701,1.5663511,-0.88253857,-0.85012892,0.21169726,1.5683393,-0.88258203,-0.84786905,0.22413744,1.5681112,-0.88252771,-0.85464867,0.22978713,1.5663946,-0.88247338,-0.86030922,0.2128272,1.5677309,-0.88254944,-0.84446837,0.23657762,1.5732285,-0.88246252,-0.82750844,0.30555813,1.5685566,-0.8821583,-0.84899898,0.24448718,1.5682307,-0.88242992,-0.85351873,0.23544768,1.568285,-0.88247338,-0.84899898,0.22074763,1.5658187,-0.88251684,-0.85125886,0.22639731,1.5649495,-0.88249511,-0.85577861,0.22639731,1.5658839,-0.88249511,-0.85125886,0.21734695,1.5632981,-0.88252771,-0.84446837,0.21848775,1.5592781,-0.88252771,-0.85917929,0.20717751,1.569415,-0.88260376,-0.86030922,0.21169726,1.5659708,-0.8825603,-0.85351873,0.21621701,1.5676223,-0.88253857,-0.85464867,0.21395714,1.5724136,-0.88257116,-0.84899898,0.21508707,1.5602342,-0.88253857,-0.85690855,0.20377683,1.5673724,-0.88259289,-0.85803848,0.20491764,1.5687631,-0.88260376,-0.85690855,0.20377683,1.5723702,-0.88261462,-0.85917929,0.19812715,1.5696431,-0.88263635,-0.85690855,0.20830745,1.5678504,-0.88257116,-0.86143916,0.19812715,1.5695562,-0.88263635,-0.85690855,0.22526738,1.5727722,-0.88251684,-0.86708885,0.20604757,1.5752819,-0.88260376,-0.85577861,0.21734695,1.5810294,-0.88257116,-0.82072882,0.31572756,1.569013,-0.88211484,-0.83994862,0.27954783,1.5669921,-0.88225609,-0.86821879,0.18003728,1.5679374,-0.88270154,-0.85690855,0.23091706,1.5690999,-0.88249511,-0.81959888,0.30328739,1.5725114,-0.88216917,-0.87952903,0.16872704,1.5713054,-0.88276673,-0.85351873,0.2331878,1.5737066,-0.88248425,-0.85803848,0.15063718,1.5758252,-0.88285365,-0.8817889,0.15402699,1.5708491,-0.88283192,-0.86595891,0.18003728,1.5713163,-0.88272327,-0.86708885,0.28858733,1.5718595,-0.88223436,-0.8161982,0.26710766,1.5689586,-0.88233214,-0.85917929,0.19925708,1.5674376,-0.88261462,-0.87613921,0.14610656,1.569415,-0.88287538,-0.8817889,0.14950724,1.5676005,-0.88290797,-0.88291884,0.18229716,1.5742715,-0.88279933,-0.86595891,0.14384669,1.5653407,-0.88276673,-0.8908284,0.15628686,1.5661447,-0.88287538,-0.86708885,0.17437673,1.5691651,-0.88273414,-0.87047866,0.1675971,1.5714249,-0.8827776,-0.87952903,0.15289705,1.5739782,-0.88284278,-0.85464867,0.22978713,1.5774875,-0.88249511,-0.88291884,0.15515693,1.5796061,-0.88285365,-0.86369904,0.20717751,1.5790194,-0.88262549,-0.87839909,0.16533723,1.5798886,-0.88281019,-0.85803848,0.21508707,1.5811272,-0.88258203,-0.87839909,0.1936074,1.5760642,-0.88265808,-0.8716086,0.20830745,1.5790303,-0.88261462,-0.87500928,0.19812715,1.5784219,-0.88263635,-0.86143916,0.27049747,1.5716096,-0.88232127,-0.86934872,0.22526738,1.5730438,-0.88251684,-0.87047866,0.20038702,1.5699908,-0.88262549,-0.87613921,0.18116722,1.5704906,-0.88271241,-0.87500928,0.17098692,1.5739999,-0.88275587,-0.82524857,0.30102751,1.5689152,-0.88218003,-0.82976832,0.28972814,1.5681872,-0.88223436,-0.85917929,0.20377683,1.5749995,-0.88261462,-0.86934872,0.18342709,1.5744236,-0.88270154,-0.83768874,0.28067777,1.5708057,-0.88226695,-0.85690855,0.22865719,1.5700125,-0.88250598,-0.87047866,0.19586727,1.5720225,-0.88264722,-0.86934872,0.19925708,1.56973,-0.88263635,-0.87047866,0.19812715,1.5751842,-0.88263635,-0.86030922,0.24674705,1.5657753,-0.88239733,-0.87047866,0.20491764,1.567166,-0.88259289,-0.85577861,0.2230075,1.5677852,-0.88250598,-0.85917929,0.23091706,1.5727505,-0.88249511,-0.87500928,0.18003728,1.5661338,-0.88270154,-0.84560917,0.25918723,1.5686544,-0.88236473,-0.85917929,0.22413744,1.5696866,-0.88252771,-0.86369904,0.22978713,1.5732937,-0.88249511,-0.85917929,0.22413744,1.568926,-0.88252771,-0.86369904,0.19586727,1.5677852,-0.88262549,-0.85351873,0.22865719,1.5660469,-0.88248425,-0.84899898,0.25692736,1.5688174,-0.8823756,-0.83203906,0.29650776,1.5615163,-0.88218003,-0.85917929,0.20943739,1.5672203,-0.88257116,-0.82750844,0.29424789,1.5645149,-0.8821909,-0.82298869,0.29650776,1.5579852,-0.88216917,-0.86595891,0.17437673,1.5585828,-0.88272327,-0.82411863,0.29537782,1.5608752,-0.88218003,-0.83090912,0.28067777,1.5571052,-0.88222349,-0.86595891,0.17437673,1.5607449,-0.88272327,-0.87273854,0.16985698,1.5544324,-0.88272327,-0.86030922,0.22187756,1.5555841,-0.88249511,-0.82411863,0.30894794,1.5564315,-0.88209311,-0.85464867,0.22752725,1.5582351,-0.88248425,-0.86595891,0.19473733,1.5584198,-0.88263635,-0.87613921,0.17211685,1.560169,-0.88273414,-0.86369904,0.20151696,1.5607014,-0.88260376,-0.86369904,0.19812715,1.5647974,-0.88261462,-0.85577861,0.23091706,1.5549974,-0.88245165,-0.84899898,0.25466748,1.5573225,-0.88236473,-0.86030922,0.19021758,1.5473051,-0.88263635,-0.8817889,0.16646717,1.5474898,-0.88273414,-0.8716086,0.19812715,1.5443499,-0.88257116,-0.86482897,0.19247746,1.5489457,-0.88262549,-0.86934872,0.17777741,1.5572899,-0.88271241,-0.87500928,0.17437673,1.5602668,-0.88272327,-0.87047866,0.17324679,1.5547801,-0.88271241,-0.84107856,0.26371784,1.5549974,-0.88229955,-0.87387934,0.17324679,1.5522921,-0.88271241,-0.86482897,0.18003728,1.556714,-0.88267981,-0.86369904,0.17777741,1.5549648,-0.88269068,-0.87273854,0.17211685,1.5650147,-0.88273414,-0.87952903,0.16420729,1.5619617,-0.88276673,-0.88065896,0.16307735,1.557279,-0.8827776,-0.88743859,0.14384669,1.5589304,-0.88286451,-0.8817889,0.15515693,1.5542151,-0.88278846,-0.87952903,0.14950724,1.5556927,-0.88281019,-0.88630865,0.13480719,1.5617444,-0.88289711,-0.88517871,0.138197,1.5599952,-0.88288624,-0.89421821,0.14384669,1.5553885,-0.88284278,-0.8908284,0.13253645,1.5569748,-0.88289711,-0.88291884,0.13367725,1.5368206,-0.88284278,-0.87839909,0.14497662,1.5418075,-0.88285365,-0.82524857,0.28519752,1.5398193,-0.88216917,-0.87273854,0.15289705,1.5370705,-0.88270154,-0.85917929,0.20151696,1.5434916,-0.8825603,-0.8263785,0.29876764,1.5437958,-0.88211484,-0.86030922,0.21734695,1.5393738,-0.88248425,-0.88291884,0.14950724,1.5382004,-0.88279933,-0.83881868,0.28858733,1.5540739,-0.8821909,-0.8817889,0.15176711,1.555106,-0.88281019,-0.88404878,0.15176711,1.5550191,-0.88281019,-0.87839909,0.17437673,1.5533785,-0.88270154,-0.8625691,0.19812715,1.5549648,-0.88259289,-0.84673911,0.26597772,1.5509122,-0.88228868,-0.86708885,0.2026469,1.555193,-0.88258203,-0.87047866,0.17777741,1.5529331,-0.88269068,-0.88291884,0.16307735,1.5530961,-0.88275587,-0.88969846,0.15063718,1.5522051,-0.88281019,-0.87839909,0.18229716,1.5614076,-0.88269068,-0.83429893,0.29989757,1.560169,-0.8821583,-0.83881868,0.29198801,1.5589413,-0.88220176,-0.83542887,0.31007788,1.5579635,-0.88211484,-0.87613921,0.18116722,1.5591151,-0.88269068,-0.86934872,0.19586727,1.5559426,-0.88260376,-0.88517871,0.15063718,1.5584198,-0.88283192,-0.87726915,0.18116722,1.5559752,-0.88266895,-0.88065896,0.14045687,1.5585284,-0.88287538,-0.8817889,0.14384669,1.5542477,-0.88284278,-0.87952903,0.1472365,1.5564315,-0.88282105,-0.88969846,0.13932694,1.5516728,-0.88286451,-0.88856853,0.13706706,1.5563772,-0.88287538,-0.88065896,0.1472365,1.552053,-0.88282105,-0.88743859,0.14158681,1.5576158,-0.88287538,-0.88856853,0.13593712,1.5561165,-0.88287538,-0.88404878,0.14271675,1.5457297,-0.88282105,-0.88856853,0.13593712,1.5422421,-0.88285365,-0.88743859,0.13932694,1.5438827,-0.88284278,-0.88404878,0.14158681,1.5425464,-0.88283192,-0.88291884,0.138197,1.5437632,-0.88284278,-0.88743859,0.138197,1.5446215,-0.88284278,-0.88517871,0.138197,1.5427311,-0.88284278,-0.88404878,0.138197,1.5401778,-0.88284278,-0.8817889,0.13706706,1.5360058,-0.88285365,-0.88969846,0.13706706,1.5313339,-0.88283192,-0.88630865,0.13932694,1.5352452,-0.88282105,-0.88404878,0.138197,1.5355929,-0.88284278,-0.85012892,0.22752725,1.5380918,-0.88244079,-0.86821879,0.18229716,1.53719,-0.88264722,-0.88065896,0.14158681,1.5414381,-0.88283192,-0.8523888,0.22526738,1.5391022,-0.88245165,-0.8716086,0.1675971,1.5357885,-0.88271241,-0.87500928,0.15402699,1.5340175,-0.88275587,-0.83881868,0.25805729,1.5328876,-0.88227782,-0.83316899,0.29537782,1.5295955,-0.88211484,-0.8263785,0.30328739,1.5291718,-0.88207138,-0.82524857,0.30102751,1.5366033,-0.88210398,-0.88404878,0.16307735,1.5528244,-0.88275587,-0.88517871,0.16080661,1.5524333,-0.88276673,-0.87613921,0.15967668,1.552379,-0.88276673,-0.88630865,0.1574168,1.5496628,-0.8827776,-0.88404878,0.16307735,1.5530635,-0.88275587,-0.83316899,0.29989757,1.5530309,-0.88213657,-0.87839909,0.1574168,1.5550843,-0.8827776,-0.8625691,0.20604757,1.555834,-0.8825603,-0.8908284,0.13706706,1.5542803,-0.88287538,-0.87952903,0.16420729,1.5531938,-0.882745,-0.8817889,0.14271675,1.5466206,-0.88284278,-0.88065896,0.138197,1.5493912,-0.88286451,-0.88743859,0.13253645,1.5571704,-0.88290797,-0.88743859,0.14384669,1.5532916,-0.88284278,-0.88743859,0.13480719,1.5573768,-0.88289711,-0.8908284,0.13367725,1.5508145,-0.88288624,-0.88856853,0.13593712,1.5534329,-0.88287538,-0.89195834,0.13480719,1.5470444,-0.88287538,-0.88404878,0.13367725,1.5517054,-0.88288624,-0.89308828,0.14271675,1.5440348,-0.88282105,-0.88743859,0.13480719,1.5341153,-0.88284278,-0.8817889,0.1472365,1.5366902,-0.88279933,-0.88630865,0.13253645,1.5462621,-0.88287538,-0.89195834,0.13140651,1.5492065,-0.88288624,-0.89873796,0.138197,1.5432308,-0.88285365,-0.86708885,0.17211685,1.545143,-0.88260376,-0.84107856,0.17098692,1.545708,-0.8821909,-0.88404878,0.17777741,1.553585,-0.88285365,-0.88630865,0.13367725,1.5509666,-0.88288624,-0.88630865,0.13367725,1.5528136,-0.88288624,-0.88856853,0.138197,1.5494672,-0.88286451,-0.88517871,0.14384669,1.5500539,-0.88284278,-0.88630865,0.13367725,1.556475,-0.88288624,-0.88743859,0.13027657,1.5501734,-0.88289711,-0.88404878,0.14497662,1.5557797,-0.88283192,-0.88743859,0.13932694,1.548685,-0.88286451,-0.89873796,0.138197,1.5543564,-0.88286451,-0.8908284,0.138197,1.5538783,-0.88286451,-0.88856853,0.138197,1.5564859,-0.88286451,-0.88743859,0.14271675,1.5540413,-0.88284278,-0.88517871,0.138197,1.5467184,-0.88286451,-0.88743859,0.138197,1.5494672,-0.88286451,-0.88517871,0.13706706,1.5456537,-0.88285365,-0.88630865,0.13480719,1.5438067,-0.88286451,-0.88630865,0.13706706,1.5475659,-0.88287538,-0.85351873,0.21848775,1.5376572,-0.88248425,-0.85917929,0.21508707,1.5459253,-0.88249511,-0.85917929,0.21621701,1.5421769,-0.88249511,-0.88743859,0.1472365,1.5424812,-0.88279933,-0.88969846,0.14271675,1.5444911,-0.88282105,-0.8817889,0.13932694,1.5353973,-0.88282105,-0.88291884,0.13932694,1.5369944,-0.88284278,-0.88065896,0.1472365,1.5378528,-0.88279933,-0.88404878,0.13932694,1.5421226,-0.88284278,-0.88969846,0.13932694,1.5448062,-0.88284278,-0.87952903,0.16420729,1.5429266,-0.88272327,-0.87613921,0.15515693,1.5470009,-0.88278846,-0.87613921,0.1574168,1.5443173,-0.88275587,-0.88291884,0.138197,1.549967,-0.88286451,-0.88291884,0.14158681,1.5488805,-0.88285365,-0.88291884,0.14271675,1.5509122,-0.88284278,-0.88517871,0.14384669,1.5451213,-0.88282105,-0.88404878,0.15176711,1.5454038,-0.88278846,-0.88630865,0.14950724,1.5450453,-0.88279933,-0.8817889,0.14610656,1.5458384,-0.88281019,-0.87839909,0.18229716,1.5473269,-0.88266895,-0.88856853,0.14497662,1.5498692,-0.88283192,-0.8817889,0.14384669,1.548761,-0.88284278,-0.8817889,0.14045687,1.5428397,-0.88283192,-0.88404878,0.138197,1.5401344,-0.88284278,-0.88065896,0.14158681,1.5378636,-0.88283192,-0.8817889,0.14158681,1.5341479,-0.88281019,-0.87952903,0.14158681,1.5372987,-0.88283192,-0.88630865,0.14497662,1.5364295,-0.88281019,-0.88517871,0.14158681,1.5364729,-0.88283192,-0.88065896,0.14271675,1.5374508,-0.88282105,-0.88291884,0.13932694,1.5413186,-0.88284278,-0.88743859,0.14158681,1.5625919,-0.88287538,-0.88743859,0.14045687,1.5635697,-0.88287538,-0.87839909,0.1675971,1.5591477,-0.88275587,-0.88856853,0.1472365,1.5658404,-0.88284278,-0.88404878,0.18229716,1.5682198,-0.88271241,-0.89308828,0.1472365,1.5331374,-0.88278846,-0.88856853,0.1472365,1.5351257,-0.88278846,-0.8817889,0.13932694,1.5323226,-0.88282105,-0.88065896,0.1483773,1.5372878,-0.88279933,-0.87839909,0.15515693,1.5380157,-0.88276673,-0.87839909,0.15515693,1.5380157,-0.88276673,-0.87839909,0.15515693,1.5380157,-0.88276673,-0.87839909,0.15515693,1.5380157,-0.88276673,-0.87839909,0.15515693,1.5380157,-0.88276673,-0.87839909,0.15515693,1.5380157,-0.88276673,-0.87839909,0.15515693,1.5380157,-0.88276673,-0.87839909,0.15515693,1.5380157,-0.88276673:4
-0.8914325,0.019272347,1.6428306,-0.62214385,-0.88447145,0.026233393,1.6432248,-0.62213423,-0.88447145,0.024243149,1.6450709,-0.62214385,-0.8864617,0.030213881,1.6443113,-0.62206693,-0.88546177,0.03121381,1.6422249,-0.622115,-0.88745201,0.01429193,1.6445036,-0.62216307,-0.88447145,0.023252834,1.6459747,-0.62214385,-0.89044219,0.05808691,1.6478976,-0.62200924,-0.88248121,0.022252905,1.6497917,-0.62214385,-0.8864617,0.028223637,1.6485225,-0.62213423,-0.88944226,0.036194227,1.6465611,-0.62209577,-0.88546177,0.021262591,1.6462535,-0.62214385,-0.88944226,0.034203983,1.6450132,-0.62209577,-0.89044219,0.029223566,1.6454939,-0.622115,-0.8914325,0.011311371,1.6439844,-0.62216307,-0.88447145,0.022252905,1.6403981,-0.62214385,-0.88944226,0.16657924,1.6440229,-0.62156696,-0.88049097,0.078989279,1.6429652,-0.62192271,-0.88447145,0.023252834,1.6420999,-0.62214385,-0.88845194,0.030213881,1.643321,-0.62210539,-0.88447145,0.021262591,1.6445228,-0.62214385,-0.88447145,0.046145447,1.6419845,-0.62205731,-0.88546177,0.018272417,1.6421095,-0.62215346,-0.88447145,0.033204054,1.6428883,-0.62210539,-0.88347152,0.023252834,1.6435037,-0.62213423,-0.88745201,0.0083211978,1.6429845,-0.6221823,-0.88447145,0.017282103,1.6412442,-0.62216307,-0.87452023,0.03121381,1.6388982,-0.62208616,-0.88248121,0.011311371,1.6393117,-0.62217269,-0.88845194,0.22928635,1.6358984,-0.62133621,-0.88944226,0.34473972,1.6351196,-0.62100931,-0.88248121,0.016282173,1.6314084,-0.62216307,-0.88148128,0.039174786,1.6320526,-0.62207654,-0.88248121,0.01429193,1.6353792,-0.62216307,-0.88248121,0.016282173,1.6374272,-0.62216307,-0.88148128,0.040174715,1.6380906,-0.62206693,-0.88447145,0.012301686,1.6391098,-0.62217269,-0.88248121,0.018272417,1.6370618,-0.62216307,-0.88248121,0.036194227,1.637456,-0.62209577,-0.88347152,0.010311442,1.6382829,-0.62216307,-0.88347152,0.020262661,1.6384944,-0.62213423,-0.88148128,0.039174786,1.6372349,-0.62208616,-0.88049097,0.18648168,1.636908,-0.62149005,-0.8735203,0.016282173,1.6387829,-0.62213423,-0.88447145,0.032204125,1.6381483,-0.62210539,-0.88347152,0.012301686,1.6410231,-0.62217269,-0.88447145,0.023252834,1.6432441,-0.62214385,-0.88845194,0.023252834,1.6448786,-0.62213423,-0.88546177,0.015291859,1.6444363,-0.62216307,-0.88347152,0.027233322,1.6408789,-0.62213423,-0.88745201,0.017282103,1.6440036,-0.62216307,-0.88447145,0.022252905,1.6443594,-0.62214385,-0.88347152,0.027233322,1.6420326,-0.62213423,-0.88845194,0.020262661,1.6416384,-0.62214385,-0.88347152,0.019272347,1.6412058,-0.62215346,-0.89243243,0.38654446,1.6405808,-0.62084586,-0.88049097,0.036194227,1.640427,-0.62208616,-0.88347152,0.03121381,1.6420807,-0.622115,-0.88347152,0.026233393,1.6413981,-0.62213423,-0.88546177,0.022252905,1.6424076,-0.62213423,-0.88546177,0.023252834,1.6434748,-0.62214385,-0.89342274,0.010311442,1.6413307,-0.62216307,-0.88049097,0.03121381,1.6411385,-0.62207654,-0.8864617,0.17055973,1.6382444,-0.62158619,-0.88347152,0.055096737,1.6400039,-0.62203808,-0.78593034,-0.42065809,1.6421192,-0.62395141,-0.79987167,-0.60777948,1.6457727,-0.62491288,-0.79987167,-0.60777948,1.6439363,-0.62491288,-0.79887174,-0.60877941,1.6419172,-0.62491288,-0.79887174,-0.60877941,1.6403789,-0.62491288,-0.79887174,-0.60877941,1.6387732,-0.62491288,-0.79887174,-0.60877941,1.6406673,-0.62491288,-0.79887174,-0.60877941,1.6413692,-0.62491288,-0.79887174,-0.60777948,1.6403308,-0.62491288,-0.79887174,-0.60777948,1.6380137,-0.62491288,-0.79887174,-0.60777948,1.6394751,-0.62491288,-0.79887174,-0.60877941,1.6390232,-0.62491288,-0.79887174,-0.60777948,1.6409173,-0.62491288,-0.79887174,-0.60877941,1.6373503,-0.62491288,-0.79887174,-0.60877941,1.6410231,-0.62491288,-0.79887174,-0.60877941,1.6409462,-0.62491288,-0.79987167,-0.60777948,1.6432537,-0.62491288,-0.79887174,-0.60678916,1.6433498,-0.62491288,-0.79887174,-0.60777948,1.6422249,-0.62491288,-0.79987167,-0.60877941,1.6441575,-0.62491288,-0.79987167,-0.60877941,1.6466669,-0.62491288,-0.79987167,-0.60877941,1.645292,-0.62491288,-0.79987167,-0.60877941,1.6468304,-0.62491288,-0.80086198,-0.60877941,1.649311,-0.62491288,-0.79987167,-0.60777948,1.6479553,-0.62491288,-0.79987167,-0.60777948,1.648311,-0.62491288,-0.79987167,-0.60777948,1.6480514,-0.62491288,-0.79987167,-0.60877941,1.646965,-0.62491288,-0.79987167,-0.60877941,1.6472342,-0.62491288,-0.8954226,0.17055973,1.6422057,-0.62159581,-0.87850072,0.061077084,1.6422249,-0.62197078,-0.8864617,0.06803813,1.6416192,-0.62199001,-0.8864617,0.13074524,1.6417826,-0.62179772,-0.88745201,0.086950254,1.6403308,-0.62192271,-0.8864617,0.20440349,1.6411385,-0.62149966,-0.88546177,0.14965736,1.6404847,-0.62167273,-0.88447145,0.1695598,1.633139,-0.62159581,-0.88944226,0.23724732,1.631966,-0.62135544,-0.88745201,0.19842314,1.6380906,-0.62151889,-0.88347152,0.066047886,1.6389944,-0.62199962,-0.88845194,0.074008862,1.6380425,-0.62196117,-0.88347152,0.071028303,1.6353023,-0.6219804,-0.89044219,0.22728649,1.6357638,-0.62135544,-0.8864617,0.27108147,1.6329275,-0.62125929,-0.8864617,0.12079402,1.6364753,-0.62179772,-0.88447145,0.088940498,1.6371484,-0.62192271,-0.88447145,0.10984287,1.6393117,-0.62184579,-0.88944226,0.16557931,1.6396866,-0.62161504,-0.88546177,0.083969696,1.6386867,-0.62194194,-0.88447145,0.098891718,1.6362446,-0.62187463,-0.88447145,0.12576482,1.6350331,-0.62176887,-0.88546177,0.12676475,1.6384656,-0.62177849,-0.88546177,0.12676475,1.6390424,-0.6217881,-0.88546177,0.066047886,1.6412346,-0.62200924,-0.88347152,0.049126005,1.6409558,-0.6220477,-0.8954226,0.36265192,1.6396001,-0.62088432,-0.8864617,0.050125935,1.643696,-0.6220477,-0.88845194,0.04116503,1.6469361,-0.62207654,-0.88546177,0.052116179,1.6461766,-0.62203808,-0.8864617,0.062067398,1.6462246,-0.62201885,-0.88944226,0.037184542,1.6463977,-0.62208616,-0.88546177,0.05808691,1.6451478,-0.62202847,-0.88447145,0.054106422,1.6433595,-0.62203808,-0.88546177,0.15263792,1.6304565,-0.62168234,-0.88248121,0.067047815,1.6300527,-0.62199001,-0.88148128,0.060077154,1.6281105,-0.62200924,-0.88148128,0.055096737,1.6280817,-0.62203808,-0.88447145,0.053106493,1.628697,-0.62202847,-0.88944226,0.24918878,1.6277452,-0.62126891,-0.88248121,0.1158136,1.6284567,-0.62180733,-0.88248121,0.072018618,1.6291297,-0.62197078,-0.8914325,0.10287221,1.6585795,-0.6218554,-0.89044219,0.075999105,1.6590699,-0.62197078,-0.88944226,0.065057571,1.6580315,-0.62200924,-0.88845194,0.062067398,1.6558874,-0.62199962,-0.89342274,0.18250119,1.6551855,-0.62151889,-0.89044219,0.072018618,1.6558105,-0.62199001,-0.89044219,0.060077154,1.658868,-0.62202847,-0.89243243,0.3079154,1.6559066,-0.62119199,-0.89044219,0.08496001,1.6564835,-0.62193232,-0.9003934,0.075999105,1.6596083,-0.62194194,-0.8914325,0.089940428,1.6592333,-0.62190348,-0.89442267,0.075999105,1.6577623,-0.62196117,-0.8914325,0.063067327,1.6573392,-0.62200924,-0.88944226,0.074008862,1.6570316,-0.6219804,-0.89243243,0.21634495,1.6582142,-0.62149966,-0.88944226,0.072018618,1.6559739,-0.6219804,-0.8914325,0.10486245,1.6577142,-0.62186502,-0.89940309,0.29298377,1.6569066,-0.6211343,-0.89044219,0.055096737,1.6570219,-0.6220477,-0.88944226,0.060077154,1.6552913,-0.62202847,-0.89641292,0.11880377,1.6579353,-0.62175926,-0.89044219,0.054106422,1.6563874,-0.6220477,-0.8954226,0.1695598,1.6605121,-0.62164388,-0.89840316,0.17354029,1.65807,-0.62161504,-0.8914325,0.13174516,1.6568585,-0.6217881,-0.89044219,0.09491123,1.6552528,-0.62191309,-0.8914325,0.13870621,1.6588776,-0.62174964,-0.89243243,0.04116503,1.6602044,-0.62208616,-0.89342274,0.051116249,1.6610313,-0.62203808,-0.89243243,0.034203983,1.6629927,-0.62210539,-0.89741285,0.2452083,1.6615216,-0.62129775,-0.8914325,0.026233393,1.658743,-0.62212462,-0.89044219,0.034203983,1.6588199,-0.62209577,-0.8914325,0.036194227,1.6640215,-0.62210539,-0.8914325,0.047135761,1.6635888,-0.62205731,-0.89840316,0.12278426,1.6614928,-0.62177849,-0.8914325,0.038184471,1.6616658,-0.62209577,-0.8914325,0.06803813,1.6613678,-0.62199001,-0.90139333,0.040174715,1.6616082,-0.62207654,-0.89342274,0.022252905,1.6641945,-0.62214385,-0.89342274,0.040174715,1.6652521,-0.62207654,-0.8914325,0.047135761,1.6650695,-0.62206693,-0.8954226,0.020262661,1.6613774,-0.62214385,-0.89641292,0.2322669,1.6641753,-0.62134583,-0.89243243,0.038184471,1.6663098,-0.62209577,-0.89342274,0.021262591,1.6673962,-0.62214385,-0.89243243,0.043155274,1.6666751,-0.62208616,-0.89442267,0.075008791,1.6654829,-0.62196117,-0.89243243,0.046145447,1.666579,-0.62205731,-0.8954226,0.051116249,1.6698864,-0.62205731,-0.89940309,0.04116503,1.6699249,-0.62207654,-0.89342274,0.025243078,1.6660598,-0.62213423,-0.88845194,0.034203983,1.666579,-0.62208616,-0.90238365,0.033204054,1.6684346,-0.62210539,-0.8954226,0.030213881,1.6700018,-0.62212462,-0.89442267,0.035194298,1.670271,-0.622115,-0.89840316,0.2541692,1.6702518,-0.62129775,-0.90139333,0.030213881,1.6680404,-0.622115,-0.8954226,0.036194227,1.6690596,-0.622115,-0.90238365,0.027233322,1.6710306,-0.62212462,-0.89442267,0.037184542,1.6697326,-0.62210539,-0.89840316,0.037184542,1.6702999,-0.62209577,-0.89840316,0.030213881,1.6709537,-0.622115,-0.89044219,0.1108428,1.670271,-0.62179772,-0.90437389,0.026233393,1.671944,-0.62212462,-0.89840316,0.047135761,1.6744438,-0.62207654,-0.89741285,0.047135761,1.6737131,-0.62207654,-0.90437389,0.075008791,1.6768186,-0.62197078,-0.90139333,0.043155274,1.6750111,-0.62208616,-0.90437389,0.072018618,1.6746938,-0.6219804,-0.9003934,0.038184471,1.6743573,-0.62210539,-0.89641292,0.042164959,1.6748572,-0.62209577,-0.8954226,0.045145518,1.6745303,-0.62208616,-0.89641292,0.036194227,1.6767802,-0.622115,-0.89741285,0.048135691,1.6752995,-0.62207654,-0.89741285,0.047135761,1.6744053,-0.62207654,-0.90139333,0.21037422,1.6710017,-0.62145159,-0.89940309,0.054106422,1.6733766,-0.62205731,-0.89641292,0.047135761,1.6747899,-0.62206693,-0.89641292,0.040174715,1.67304,-0.62209577,-0.89940309,0.048135691,1.6737323,-0.62207654,-0.90537382,0.039174786,1.6730112,-0.62209577,-0.9003934,0.067047815,1.6739919,-0.62200924,-0.89940309,0.049126005,1.6738285,-0.62207654,-0.89840316,0.034203983,1.672492,-0.62212462,-0.9003934,0.043155274,1.6767802,-0.62209577,-0.89940309,0.049126005,1.6782704,-0.62207654,-0.91233487,0.035194298,1.6787896,-0.62209577,-0.89840316,0.040174715,1.679578,-0.62210539,-0.90338358,0.24420837,1.6728574,-0.6213266,-0.89940309,0.037184542,1.675213,-0.62210539,-0.89840316,0.045145518,1.6760879,-0.62208616,-0.89840316,0.077989349,1.6763667,-0.62197078,-0.90238365,0.21733527,1.673915,-0.62151889,-0.89342274,0.27506196,1.6440517,-0.62129775,-0.89342274,0.28900328,1.6466861,-0.62124006,-0.8914325,0.046145447,1.6471092,-0.62207654,-0.88944226,0.047135761,1.6391578,-0.62207654,-0.8954226,0.048135691,1.636408,-0.6220477,-0.88944226,0.08595994,1.6435229,-0.62195155,-0.88944226,0.092920986,1.6432921,-0.62192271,-0.8914325,0.086950254,1.6393405,-0.62195155,-0.89741285,0.21634495,1.6441767,-0.62143236,-0.89243243,0.08595994,1.6480514,-0.62196117,-0.89342274,0.08595994,1.6518012,-0.62196117,-0.89342274,0.096901474,1.6524069,-0.62191309,-0.89243243,0.082969767,1.6497052,-0.62197078,-0.8954226,0.1158136,1.6485899,-0.62183618,-0.90338358,0.3347885,1.6487821,-0.62103815,-0.8914325,0.083969696,1.6487341,-0.62196117,-0.8914325,0.10486245,1.6506282,-0.62189386,-0.8914325,0.089940428,1.6499551,-0.62194194,-0.89342274,0.16657924,1.6498878,-0.62158619,-0.88845194,0.065057571,1.6485033,-0.62199962,-0.89243243,0.049126005,1.6493783,-0.62207654,-0.89741285,0.25615945,1.6407443,-0.62124006,-0.89044219,0.075999105,1.6485033,-0.62197078,-0.88944226,0.062067398,1.6465611,-0.62202847,-0.89044219,0.038184471,1.6464554,-0.62210539,-0.88845194,0.044155203,1.6427633,-0.62208616,-0.8864617,0.057086981,1.6423018,-0.62201885,-0.88745201,0.026233393,1.6399655,-0.62213423,-0.88845194,0.063067327,1.640552,-0.62199962,-0.8864617,0.052116179,1.6367157,-0.62205731,-0.78892052,-0.42463858,1.6361003,-0.62398025,-0.79788142,-0.60777948,1.6334659,-0.6249225,-0.79788142,-0.60678916,1.6315141,-0.62491288,-0.79788142,-0.60877941,1.6319276,-0.6249225,-0.79788142,-0.60877941,1.631168,-0.6249225,-0.79788142,-0.60877941,1.6283413,-0.6249225,-0.79788142,-0.60877941,1.6313122,-0.6249225,-0.79788142,-0.60877941,1.6305911,-0.6249225,-0.79788142,-0.60877941,1.6321295,-0.6249225,-0.79788142,-0.60777948,1.6323698,-0.62491288,-0.79788142,-0.60777948,1.6313699,-0.62491288,-0.79788142,-0.60877941,1.6306296,-0.6249225,-0.79788142,-0.60877941,1.6305238,-0.6249225,-0.79688149,-0.60877941,1.6276298,-0.6249225,-0.79688149,-0.60877941,1.6258222,-0.62491288,-0.79688149,-0.60976972,1.6262164,-0.6249225,-0.79688149,-0.60877941,1.624255,-0.62491288,-0.79588156,-0.60877941,1.6206207,-0.6249225,-0.79588156,-0.60877941,1.6188612,-0.6249225,-0.79588156,-0.60777948,1.6184189,-0.6249225,-0.79887174,-0.60479892,1.6436671,-0.62490327,-0.80086198,-0.60877941,1.6512051,-0.62491288,-0.80086198,-0.60877941,1.6497725,-0.62491288,-0.80186191,-0.60877941,1.6565316,-0.62491288,-0.80285222,-0.60877941,1.6619831,-0.62491288,-0.80285222,-0.60777948,1.6631946,-0.62491288,-0.80285222,-0.60877941,1.6637811,-0.62491288,-0.80285222,-0.60777948,1.6653194,-0.62491288,-0.80285222,-0.60877941,1.6641464,-0.62491288,-0.80285222,-0.60877941,1.6613293,-0.62491288,-0.80285222,-0.60877941,1.6595795,-0.62491288,-0.80285222,-0.60976972,1.6645887,-0.62491288,-0.80186191,-0.60678916,1.6617812,-0.62491288,-0.80285222,-0.60678916,1.6633773,-0.62491288,-0.80285222,-0.60777948,1.663435,-0.62491288,-0.80285222,-0.60877941,1.66231,-0.62491288,-0.80285222,-0.60777948,1.6651079,-0.62491288,-0.80285222,-0.60777948,1.6640599,-0.62491288,-0.80186191,-0.60777948,1.6607044,-0.62491288,-0.80285222,-0.60777948,1.6633484,-0.62491288,-0.80285222,-0.60976972,1.6640791,-0.62491288,-0.80285222,-0.60777948,1.6651752,-0.62491288,-0.80285222,-0.60777948,1.6658867,-0.62491288,-0.80285222,-0.60777948,1.6645022,-0.62491288,-0.80186191,-0.60777948,1.657445,-0.62491288,-0.80186191,-0.60877941,1.6571566,-0.62491288,-0.80285222,-0.60777948,1.6636272,-0.62491288,-0.80285222,-0.60877941,1.6621466,-0.62491288,-0.80285222,-0.60777948,1.666079,-0.62491288,-0.80285222,-0.60777948,1.6648483,-0.62491288,-0.80285222,-0.60877941,1.6657136,-0.62491288,-0.80285222,-0.60777948,1.664406,-0.62491288,-0.80285222,-0.60877941,1.6627331,-0.62491288,-0.80285222,-0.60877941,1.6615505,-0.62491288,-0.80285222,-0.60877941,1.6593872,-0.62491288,-0.80186191,-0.60877941,1.6579642,-0.62491288,-0.80186191,-0.60777948,1.6583392,-0.62491288,-0.80186191,-0.60877941,1.6607236,-0.62491288,-0.80285222,-0.60777948,1.6615793,-0.62491288,-0.80285222,-0.60877941,1.6641464,-0.62491288,-0.80285222,-0.60877941,1.6645695,-0.62491288,-0.80285222,-0.60777948,1.6642426,-0.62491288,-0.80285222,-0.60877941,1.6644733,-0.62491288,-0.80285222,-0.60877941,1.6644157,-0.62491288,-0.80285222,-0.60777948,1.6634061,-0.62491288,-0.80285222,-0.60777948,1.665829,-0.62491288,-0.80285222,-0.60777948,1.6646176,-0.62490327,-0.80285222,-0.60877941,1.6645406,-0.62491288,-0.80285222,-0.60877941,1.6656271,-0.62491288,-0.80385215,-0.60877941,1.6667809,-0.62490327,-0.80285222,-0.60777948,1.6648002,-0.62491288,-0.80285222,-0.60777948,1.6649348,-0.62491288,-0.80285222,-0.60777948,1.6663578,-0.62491288,-0.80385215,-0.60777948,1.6678385,-0.62490327,-0.80385215,-0.60777948,1.6680596,-0.62490327,-0.80385215,-0.60877941,1.6701845,-0.62490327,-0.80385215,-0.60877941,1.671194,-0.62490327,-0.80385215,-0.60877941,1.6711171,-0.62490327,-0.80385215,-0.60877941,1.6702999,-0.62490327,-0.80385215,-0.60877941,1.6705498,-0.62491288,-0.80385215,-0.60777948,1.6715786,-0.62490327,-0.80385215,-0.60777948,1.6712902,-0.62490327,-0.80385215,-0.60777948,1.6701941,-0.62490327,-0.80484247,-0.60877941,1.6718478,-0.62490327,-0.80385215,-0.60877941,1.6694057,-0.62491288,-0.80385215,-0.60877941,1.6709248,-0.62491288,-0.80385215,-0.60877941,1.6718767,-0.62491288,-0.80484247,-0.60777948,1.6722997,-0.62490327,-0.80385215,-0.60777948,1.6707998,-0.62490327,-0.80484247,-0.60777948,1.6721747,-0.62490327,-0.80484247,-0.60777948,1.6724728,-0.62490327,-0.80484247,-0.60976972,1.6712998,-0.62491288,-0.80385215,-0.60877941,1.6699345,-0.62491288,-0.80385215,-0.60877941,1.6683673,-0.62491288,-0.80385215,-0.60777948,1.6677904,-0.62491288,-0.80385215,-0.60877941,1.6704729,-0.62491288,-0.80484247,-0.60777948,1.6723189,-0.62490327,-0.80484247,-0.60777948,1.6731073,-0.62490327,-0.80484247,-0.60777948,1.6728958,-0.62490327,-0.80484247,-0.60777948,1.6728958,-0.62490327,-0.80484247,-0.60777948,1.6728958,-0.62490327,-0.80484247,-0.60777948,1.6728958,-0.62490327,-0.80484247,-0.60777948,1.6728958,-0.62490327,-0.80484247,-0.60777948,1.6728958,-0.62490327,-0.80484247,-0.60777948,1.6728958,-0.62490327:4
-0.90048899,-0.025389086,1.6326511,-0.67880799,-0.90048899,-0.020342296,1.632438,-0.67878862,-0.90048899,-0.0052212977,1.6311012,-0.6787305,-0.90048899,-0.03143361,1.6325833,-0.67883705,-0.90149641,0.0048625965,1.6329029,-0.67869175,-0.90048899,-0.032441031,1.6321086,-0.67883705,-0.90048899,-0.032441031,1.6308009,-0.67883705,-0.90754093,0.22263015,1.6301713,-0.67780057,-0.90250383,-0.026396507,1.6316243,-0.67881768,-0.90149641,-0.023364558,1.6314015,-0.6787983,-0.90149641,-0.0021990355,1.6331257,-0.67872081,-0.90250383,-0.025389086,1.6323992,-0.67880799,-0.90149641,-0.018327454,1.6329708,-0.67877893,-0.90048899,-0.025389086,1.6321571,-0.67880799,-0.90048899,0.0018403342,1.6323992,-0.67870144,-0.89948157,-0.015305192,1.6325639,-0.67876924,-0.90048899,0.064348854,1.6321183,-0.67844958,-0.89847415,-0.0072361392,1.6315177,-0.67874018,-0.89948157,0.025020698,1.6306266,-0.67861426,-0.89847415,0.047203328,1.631479,-0.67852708,-0.89847415,0.089553746,1.6170845,-0.67834303,-0.89948157,-0.018327454,1.6277496,-0.67878862,-0.90048899,0.019983594,1.6293382,-0.67863363,-0.89948157,-0.024371979,1.628602,-0.67880799,-0.90048899,-0.0032064562,1.6295998,-0.67872081,-0.90250383,-0.01329035,1.63021,-0.67875956,-0.90149641,0.018976174,1.6292317,-0.67863363,-0.90552609,0.18230426,1.629222,-0.67796524,-0.89948157,0.045188486,1.6296385,-0.67852708,-0.90048899,0.0038551757,1.6290767,-0.67869175,-0.89948157,-1.8419398E-4,1.6278852,-0.67871112,-0.90048899,-0.0092509807,1.628912,-0.67874987,-0.89948157,0.011914542,1.6295707,-0.67866269,-0.89948157,-0.022357137,1.6305006,-0.6787983,-0.90048899,-0.022357137,1.6310528,-0.6787983,-0.90149641,-0.027403927,1.6332323,-0.67881768,-0.90149641,-0.033448452,1.6321377,-0.67884674,-0.90149641,-0.017320033,1.6325155,-0.67877893,-0.90149641,-0.01329035,1.631818,-0.67875956,-0.90149641,-0.0082435599,1.633271,-0.67874018,-0.90653351,0.22061531,1.6315952,-0.67781026,-0.90149641,-0.019334875,1.6329901,-0.67878862,-0.90048899,-0.018327454,1.6341041,-0.6787983,-0.90048899,-0.03042619,1.6331064,-0.67883705,-0.90048899,-0.016312613,1.6342107,-0.67878862,-0.90048899,-0.016312613,1.6341138,-0.67878862,-0.90149641,-0.0042138769,1.6357121,-0.67874018,-0.90149641,-0.01329035,1.6358671,-0.67877893,-0.90149641,-0.035463293,1.6351503,-0.67886611,-0.90149641,-0.028411348,1.6351212,-0.67883705,-0.90048899,0.0068774379,1.6354602,-0.67869175,-0.90250383,-0.023364558,1.6356249,-0.67881768,-0.90250383,-0.026396507,1.6340557,-0.67882736,-0.90754093,0.21759305,1.6333582,-0.67781994,-0.90351125,-0.034455873,1.6360124,-0.67885642,-0.90351125,-0.03143361,1.63516,-0.67884674,-0.90250383,-0.017320033,1.6347628,-0.67878862,-0.90149641,-0.029418769,1.6333001,-0.67882736,-0.90149641,0.043173645,1.6349759,-0.67854645,-0.90149641,0.012921962,1.634201,-0.67867238,-0.90149641,-0.017320033,1.6341041,-0.67878862,-0.90149641,-0.0072361392,1.6328351,-0.67874018,-0.90250383,0.019983594,1.6340169,-0.67864332,-0.90250383,-0.01329035,1.6344819,-0.67876924,-0.90250383,0.10063537,1.6332226,-0.67830428,-0.90250383,0.0048625965,1.6342978,-0.67870144,-0.90653351,0.15810679,1.6320989,-0.67806211,-0.90351125,-0.021349716,1.6348403,-0.67880799,-0.90351125,-0.015305192,1.633581,-0.67877893,-0.90351125,0.023005857,1.6328351,-0.67861426,-0.90250383,-0.016312613,1.6327673,-0.67876924,-0.90149641,-0.020342296,1.6323992,-0.67878862,-0.90250383,-0.017320033,1.6325833,-0.67877893,-0.90250383,0.068378537,1.6317502,-0.67843021,-0.90250383,0.0068774379,1.632467,-0.67868206,-0.90250383,0.0018403342,1.6353731,-0.67871112,-0.90250383,0.0058700172,1.6360221,-0.67870144,-0.90351125,-0.010258401,1.6370876,-0.67875956,-0.90250383,-0.01329035,1.6353537,-0.67876924,-0.90451867,0.061316905,1.6361286,-0.67846895,-0.90250383,-0.0082435599,1.6359155,-0.67874987,-0.90351125,-0.017320033,1.6361093,-0.67878862,-0.90351125,-0.018327454,1.6369326,-0.67878862,-0.90351125,-0.0082435599,1.6350728,-0.67874987,-0.90351125,-0.025389086,1.6347531,-0.67881768,-0.90250383,-0.020342296,1.6360511,-0.6787983,-0.90351125,0.22868436,1.6355281,-0.67779088,-0.90754093,0.046195907,1.6352471,-0.67853676,-0.90149641,-0.0011916147,1.6345788,-0.6787305,-0.90250383,0.031074909,1.6335035,-0.67859488,-0.90250383,0.0088922794,1.6342203,-0.67868206,-0.90250383,0.0048625965,1.6348403,-0.67870144,-0.91460256,0.039143962,1.6340169,-0.67856582,-0.90351125,0.13189448,1.6330192,-0.67817835,-0.90250383,0.014946491,1.629687,-0.678653,-0.90149641,0.0078848587,1.6300647,-0.67867238,-0.90149641,0.017968753,1.6278658,-0.67864332,-0.90149641,-0.0042138769,1.6265194,-0.6787305,-0.90854835,0.085514376,1.6289604,-0.6783624,-0.90754093,0.19339558,1.6294545,-0.6779265,-0.90149641,0.0018403342,1.6289701,-0.67870144,-0.90149641,-0.010258401,1.6304328,-0.67874987,-0.90149641,0.0088922794,1.63021,-0.67867238,-0.90149641,-0.010258401,1.6307816,-0.67874987,-0.90149641,0.099627953,1.6304716,-0.67830428,-0.90250383,-0.028411348,1.629871,-0.67881768,-0.90351125,0.060309484,1.63021,-0.67845927,-0.90149641,-0.0042138769,1.6281177,-0.6787305,-0.90250383,-0.033448452,1.6277012,-0.67883705,-0.90250383,-0.025389086,1.628418,-0.67880799,-0.90048899,-0.027403927,1.627924,-0.67881768,-0.90149641,-0.036470714,1.6276721,-0.67885642,-0.90552609,0.16314389,1.6270812,-0.67805243,-0.90149641,-0.032441031,1.6297741,-0.67883705,-0.90250383,-0.035463293,1.6314499,-0.67884674,-0.90250383,-0.033448452,1.6310722,-0.67883705,-0.90250383,-0.01329035,1.6313337,-0.67875956,-0.90250383,-0.010258401,1.6329029,-0.67872081,-0.90250383,8.2322676E-4,1.6310237,-0.67878862,-0.90351125,0.1026599,1.6323508,-0.67849802,-0.90351125,-0.024371979,1.6326995,-0.6787983,-0.90250383,-0.0032064562,1.632438,-0.67882736,-0.90351125,0.21053142,1.6335907,-0.67868206,-0.90149641,-0.010258401,1.6327189,-0.67869175,-0.90250383,-0.033448452,1.6337069,-0.67882736,-0.90754093,0.16415131,1.6305684,-0.67791681,-0.90250383,-0.015305192,1.6314596,-0.67877893,-0.90250383,-0.020342296,1.6330482,-0.67874987,-0.90451867,0.10467474,1.6317115,-0.67843989,-0.90250383,-0.0032064562,1.6336973,-0.67876924,-0.90250383,-0.016312613,1.6337554,-0.67874987,-0.90250383,0.034097171,1.6341525,-0.6787983,-0.90451867,0.018976174,1.634695,-0.67866269,-0.90552609,0.018976174,1.6349178,-0.67869175,-0.90653351,-0.017320033,1.6370101,-0.67852708,-0.90451867,-0.022357137,1.6357799,-0.67880799,-0.90754093,0.11878832,1.6357218,-0.67823647,-0.90451867,-0.023364558,1.6363417,-0.67880799,-0.90956546,0.1843191,1.6351115,-0.67797493,-0.90451867,0.016961332,1.6354312,-0.678653,-0.90552609,0.05022559,1.6393059,-0.67851739,-0.90351125,-0.0021990355,1.637291,-0.6787305,-0.90351125,-0.027403927,1.6369423,-0.67882736,-0.90451867,0.038126854,1.6363611,-0.67856582,-0.90754093,0.16012163,1.6347628,-0.6780718,-0.90754093,0.12684769,1.6355959,-0.67820741,-0.90451867,0.031074909,1.634201,-0.67859488,-0.90653351,0.1026599,1.6343656,-0.67830428,-0.90451867,-0.0021990355,1.6338619,-0.6787305,-0.90451867,0.010907121,1.6339007,-0.67867238,-0.91258772,0.35268429,1.6317212,-0.6772678,-0.91258772,0.33252619,1.6321861,-0.67734529,-0.90451867,0.137939,1.6323411,-0.67814929,-0.90552609,0.12684769,1.6332226,-0.67819773,-0.90351125,0.10668959,1.6345497,-0.67829459,-0.90552609,0.15104516,1.63423,-0.67811055,-0.90451867,0.10568216,1.6346853,-0.67829459,-0.90552609,0.12584027,1.6327867,-0.67819773,-0.91258772,0.31336582,1.6314209,-0.67742279,-0.90854835,0.20851657,1.6338232,-0.67787806,-0.90552609,0.12987964,1.6337554,-0.67819773,-0.90653351,0.11677348,1.6358283,-0.67824616,-0.90754093,0.086521797,1.6348403,-0.67837209,-0.90754093,0.17423521,1.6356346,-0.67801368,-0.90653351,0.14298579,1.6370489,-0.67813961,-0.90351125,0.099627953,1.6318762,-0.67830428,-0.90351125,0.089553746,1.6336488,-0.6783624,-0.90552609,0.05426496,1.6342107,-0.67849802,-0.90451867,0.05527238,1.6334648,-0.67849802,-0.90451867,0.1329019,1.6322055,-0.67816867,-0.91258772,0.31135098,1.6297741,-0.67743247,-0.91560999,0.3738595,1.6299194,-0.67718062,-0.90552609,0.12987964,1.6292801,-0.67817835,-0.90451867,0.075430482,1.6288345,-0.67840115,-0.90552609,0.10366732,1.6299097,-0.67828491,-0.90451867,0.12987964,1.629716,-0.67817835,-0.90451867,0.1480229,1.628602,-0.67811055,-0.90250383,0.11374153,1.629067,-0.67824616,-0.90451867,0.13894642,1.6289023,-0.67814929,-0.90250383,0.12584027,1.6284374,-0.67819773,-0.90451867,0.1691981,1.6283696,-0.67802336,-0.90351125,0.122818,1.6282049,-0.6782171,-0.90552609,0.23271405,1.6228869,-0.67774245,-0.90250383,0.11979574,1.6279627,-0.67822679,-0.9115803,0.30429904,1.6266163,-0.67746153,-0.90351125,0.13592416,1.6280983,-0.67815898,-0.91258772,0.35571624,1.6260157,-0.67725811,-0.90351125,0.12584027,1.6266259,-0.67819773,-0.90451867,0.14097095,1.6266937,-0.67813961,-0.90351125,0.13189448,1.6257541,-0.67817835,-0.90250383,0.11576606,1.6270231,-0.67824616,-0.90250383,0.12684769,1.626345,-0.67819773,-0.90351125,0.13390932,1.6274106,-0.67816867,-0.90351125,0.15205258,1.6289701,-0.67809117,-0.90351125,0.12483285,1.6298226,-0.67820741,-0.90351125,0.13088706,1.628883,-0.67817835,-0.90351125,0.12080316,1.628912,-0.6782171,-0.91460256,0.38092114,1.6276624,-0.67715156,-0.90451867,0.13088706,1.6289604,-0.67817835,-0.90250383,0.12080316,1.6277205,-0.67822679,-0.90451867,0.12786479,1.628418,-0.67818804,-0.90250383,0.10870443,1.627798,-0.67827522,-0.90451867,0.13088706,1.6294351,-0.67817835,-0.90451867,0.14701548,1.6283114,-0.67811055,-0.90351125,0.13592416,1.6286311,-0.67815898,-0.90351125,0.13088706,1.62619,-0.67817835,-0.90250383,0.12080316,1.6276043,-0.67822679,-0.90351125,0.12382542,1.627614,-0.67820741,-0.90250383,0.13189448,1.6271103,-0.67817835,-0.90250383,0.14500063,1.6280015,-0.67812023,-0.91560999,0.42124702,1.628108,-0.6769772,-0.90854835,0.24682762,1.6268875,-0.6777037,-0.90451867,0.11475864,1.6298419,-0.67824616,-0.90351125,0.10870443,1.6291251,-0.67826553,-0.90451867,0.14903032,1.6289701,-0.67810086,-0.90351125,0.10164279,1.6284567,-0.67829459,-0.90250383,0.11576606,1.6279627,-0.67824616,-0.91258772,0.3224423,1.6265484,-0.67739373,-0.90451867,0.14197837,1.6263063,-0.67812992,-0.90451867,0.11677348,1.6280111,-0.67823647,-0.90351125,0.12080316,1.6265194,-0.6782171,-0.90351125,0.15709937,1.6251826,-0.6780718,-0.90250383,0.10063537,1.623439,-0.67828491,-0.90250383,0.10568216,1.624398,-0.67828491,-0.90451867,0.13693158,1.623255,-0.67813961,-0.90351125,0.11071927,1.6219182,-0.67824616,-0.91057288,0.29824483,1.623284,-0.67747122,-0.90351125,0.10971185,1.6231581,-0.67825585,-0.90250383,0.09559827,1.6226834,-0.67831397,-0.90351125,0.1329019,1.6242139,-0.67816867,-0.91258772,0.37083724,1.6203586,-0.67717093,-0.90250383,0.13390932,1.623129,-0.67814929,-0.90451867,0.21153884,1.6233712,-0.67783932,-0.90250383,0.052250118,1.6258413,-0.67849802,-0.90250383,0.053257539,1.6245142,-0.67849802,-0.90149641,0.052250118,1.6247273,-0.67849802,-0.90250383,0.076437903,1.6261222,-0.67840115,-0.90250383,0.05426496,1.6252892,-0.67848833,-0.90250383,0.011914542,1.6217923,-0.67864332,-0.90552609,0.26800283,1.6195352,-0.67760684,-0.90854835,0.3274794,1.6188959,-0.67735498,-0.93274582,0.49786912,1.6201939,-0.67662847,-0.83293368,-0.65147202,1.6265969,-0.68107469,-0.83293368,-0.65247944,1.6256476,-0.68107469,-0.83293368,-0.65247944,1.6254538,-0.68107469,-0.83293368,-0.65247944,1.6238362,-0.68107469,-0.83293368,-0.65247944,1.6246111,-0.68107469,-0.83293368,-0.65147202,1.624059,-0.68107469,-0.83293368,-0.6504646,1.6237877,-0.68107469,-0.83293368,-0.6504646,1.6248339,-0.68107469,-0.83293368,-0.65147202,1.6243108,-0.68107469,-0.83293368,-0.65247944,1.624582,-0.68107469,-0.83293368,-0.65247944,1.6243786,-0.68107469,-0.83293368,-0.65247944,1.6257541,-0.68107469,-0.83293368,-0.65247944,1.6259091,-0.68107469,-0.83395078,-0.65147202,1.62681,-0.681065,-0.83395078,-0.65147202,1.6302585,-0.681065,-0.83395078,-0.65147202,1.6336682,-0.68107469,-0.83395078,-0.65247944,1.6319246,-0.681065,-0.83395078,-0.65247944,1.6332323,-0.681065,-0.83395078,-0.65247944,1.6324089,-0.681065,-0.83395078,-0.65247944,1.6330579,-0.681065,-0.83395078,-0.65147202,1.6310334,-0.681065,-0.83395078,-0.6504646,1.6318083,-0.681065,-0.83395078,-0.65147202,1.6326608,-0.681065,-0.83395078,-0.65247944,1.6315662,-0.681065,-0.90351125,-0.050593978,1.629222,-0.67890486,-0.9115803,-0.14132965,1.6318665,-0.67925358,-0.90552609,0.099627953,1.6290186,-0.67830428,-0.90351125,-1.8419398E-4,1.6293963,-0.67871112,-0.90351125,0.012921962,1.6292026,-0.678653,-0.90351125,0.038126854,1.6298129,-0.67855614,-0.90351125,0.057287222,1.630985,-0.67847864,-0.9115803,0.28010157,1.6301616,-0.67756809,-0.90250383,0.041158803,1.6315468,-0.67854645,-0.90351125,0.033089751,1.6302875,-0.67857551,-0.90250383,0.037119434,1.6309559,-0.67855614,-0.90351125,0.087529218,1.6281758,-0.67835271,-0.90653351,0.13996353,1.6289992,-0.67813961,-0.90552609,0.090561167,1.6299194,-0.67834303,-0.90552609,0.10467474,1.6287183,-0.67828491,-0.90653351,0.097613112,1.6298226,-0.67831397,-0.90451867,0.076437903,1.6301132,-0.67840115,-0.90552609,0.13693158,1.6293867,-0.67814929,-0.90351125,0.037119434,1.6286117,-0.67855614,-0.90351125,0.024013277,1.630491,-0.67861426,-0.90956546,0.24179052,1.628757,-0.67772308,-0.90250383,0.0048625965,1.6284955,-0.67869175,-0.90250383,0.002847755,1.6284761,-0.67870144,-0.90451867,0.10971185,1.6278077,-0.67826553,-0.90351125,0.015953911,1.6291348,-0.67864332,-0.90351125,0.0068774379,1.6277496,-0.67868206,-0.90451867,-1.8419398E-4,1.6278077,-0.67871112,-0.90854835,0.22766725,1.6293285,-0.6777812,-0.90250383,0.041158803,1.6274977,-0.67854645,-0.90451867,0.012921962,1.6287473,-0.678653,-0.90351125,8.2322676E-4,1.6288636,-0.67870144,-0.90250383,0.012921962,1.6275171,-0.678653,-0.90250383,0.016961332,1.6289508,-0.67864332,-0.90552609,0.16718326,1.6282339,-0.67803305,-0.90250383,-1.8419398E-4,1.6258413,-0.67871112,-0.90250383,0.028052647,1.6264806,-0.67859488,-0.90250383,0.0078848587,1.6266259,-0.67867238,-0.91661741,0.45855065,1.6251148,-0.6768319,-0.90250383,0.0098997002,1.6265,-0.67867238,-0.90956546,0.26194862,1.6265291,-0.6776359,-0.90351125,0.015953911,1.6276043,-0.67864332,-0.90451867,0.028052647,1.6268875,-0.67859488,-0.90451867,0.0068774379,1.6282824,-0.67868206,-0.90552609,0.16112905,1.6285439,-0.67805243,-0.90451867,0.010907121,1.625512,-0.67866269,-0.90351125,0.010907121,1.6256863,-0.67866269,-0.90956546,0.2145611,1.6244367,-0.67782963,-0.90351125,0.021998436,1.6256282,-0.67861426,-0.90250383,0.040151383,1.6251342,-0.67854645,-0.90250383,-0.035463293,1.6239815,-0.67884674,-0.90250383,-0.029418769,1.6242043,-0.67882736,-0.90250383,-0.027403927,1.6242333,-0.67881768,-0.90250383,0.05022559,1.624708,-0.6785077,-0.90854835,0.18834879,1.6241849,-0.67793618,-0.90048899,-0.011265822,1.6186828,-0.67874018,-0.90149641,-0.034455873,1.618954,-0.67883705,-0.90149641,-0.036470714,1.6190509,-0.67884674,-0.90149641,-0.028411348,1.6157574,-0.67880799,-0.88233604,-0.26936895,1.6188862,-0.67978635,-0.82588173,-0.5436005,1.6205814,-0.68088095,-0.83395078,-0.66155591,1.6199615,-0.68107469,-0.83395078,-0.66155591,1.6196709,-0.68107469,-0.83395078,-0.66256333,1.6211142,-0.68107469,-0.83395078,-0.66256333,1.6201746,-0.68107469,-0.83395078,-0.66256333,1.621337,-0.68107469,-0.83395078,-0.66256333,1.6234874,-0.68107469,-0.83495821,-0.66155591,1.6255798,-0.681065,-0.83495821,-0.66256333,1.6264613,-0.68107469,-0.83495821,-0.66256333,1.6266841,-0.68107469,-0.83495821,-0.66256333,1.6249017,-0.68107469,-0.83395078,-0.66256333,1.6251923,-0.68107469,-0.83495821,-0.66256333,1.627459,-0.68107469,-0.83495821,-0.66256333,1.6257929,-0.68107469,-0.83495821,-0.66155591,1.6251051,-0.681065,-0.83395078,-0.66155591,1.623933,-0.68107469,-0.83495821,-0.66256333,1.6265872,-0.68107469,-0.83495821,-0.66256333,1.6269553,-0.68107469,-0.83495821,-0.66256333,1.6253182,-0.68107469,-0.83495821,-0.66256333,1.6265872,-0.68107469,-0.83495821,-0.66256333,1.6260835,-0.68107469,-0.83495821,-0.66256333,1.6265678,-0.68107469,-0.83495821,-0.66155591,1.6266259,-0.681065,-0.83495821,-0.66256333,1.6268487,-0.68107469,-0.83495821,-0.66256333,1.6270328,-0.68107469,-0.83596563,-0.66256333,1.6281564,-0.681065,-0.83495821,-0.66256333,1.6274977,-0.68107469,-0.83495821,-0.66256333,1.6243205,-0.68107469,-0.83495821,-0.66256333,1.6266744,-0.68107469,-0.83495821,-0.66256333,1.6256185,-0.68107469,-0.83495821,-0.66155591,1.6263257,-0.681065,-0.83495821,-0.66155591,1.6249792,-0.681065,-0.83495821,-0.66256333,1.6242914,-0.68107469,-0.83495821,-0.66256333,1.6254151,-0.68107469,-0.83495821,-0.66256333,1.6254151,-0.68107469,-0.83495821,-0.66256333,1.6254151,-0.68107469,-0.83495821,-0.66256333,1.6254151,-0.68107469,-0.83495821,-0.66256333,1.6254151,-0.68107469,-0.83495821,-0.66256333,1.6254151,-0.68107469,-0.83495821,-0.66256333,1.6254151,-0.68107469:4
-1.0740338,0.68155549,1.3165582,-0.83068551,-1.0758912,0.69549059,1.3175003,-0.83063168,-1.074967,0.67969808,1.3157327,-0.83069449,-1.0758912,0.68063127,1.3168812,-0.83069449,-1.0758912,0.68063127,1.3167735,-0.83069449,-1.0758912,0.67505903,1.3165313,-0.83071243,-1.074967,0.67691644,1.3155981,-0.83070346,-1.0758912,0.67784066,1.3158583,-0.83070346,-1.0758912,0.67691644,1.3167017,-0.83071243,-1.074967,0.67877386,1.3154007,-0.83069449,-1.074967,0.67505903,1.3165043,-0.83071243,-1.074967,0.6713442,1.3167107,-0.83073038,-1.074967,0.66669617,1.3178234,-0.83074832,-1.0768244,0.67877386,1.3180656,-0.83070346,-1.0768244,0.69177576,1.3183528,-0.83064962,-1.074967,0.67412583,1.3186579,-0.83072141,-1.0758912,0.6713442,1.3183528,-0.83073038,-1.074967,0.670411,1.3174555,-0.83073038,-1.0758912,0.67226842,1.3181464,-0.83073038,-1.074967,0.66762937,1.3179849,-0.83074832,-1.0758912,0.67505903,1.3178862,-0.83071243,-1.0758912,0.68063127,1.3155801,-0.83068551,-1.074967,0.6713442,1.3157685,-0.83072141,-1.074967,0.67320161,1.3155353,-0.83072141,-1.0758912,0.67598325,1.3156878,-0.83070346,-1.074967,0.66390556,1.3163518,-0.8307573,-1.074967,0.670411,1.3149699,-0.83073038,-1.074967,0.68155549,1.315293,-0.83068551,-1.074967,0.66390556,1.316271,-0.8307573,-1.074967,0.66577195,1.3147995,-0.83073935,-1.074967,0.66483876,1.3144405,-0.83074832,-1.0740338,0.66390556,1.3134625,-0.83074832,-1.0740338,0.66855359,1.3151404,-0.83073935,-1.074967,0.67505903,1.3156788,-0.83071243,-1.074967,0.67877386,1.3172401,-0.83070346,-1.074967,0.64533141,1.3184425,-0.83083805,-1.0731096,0.6425408,1.3177157,-0.830856,-1.0740338,0.64440719,1.3168902,-0.83083805,-1.0731096,0.63511114,1.3173837,-0.83088292,-1.0740338,0.63511114,1.3189001,-0.83088292,-1.0740338,0.65276107,1.3176529,-0.83081114,-1.0731096,0.63232951,1.3165671,-0.83089189,-1.0731096,0.63139631,1.316935,-0.83089189,-1.0731096,0.62768148,1.3174555,-0.83090984,-1.0731096,0.63047209,1.3165133,-0.83089189,-1.0731096,0.63139631,1.3174824,-0.83089189,-1.0740338,0.63604434,1.3190078,-0.83088292,-1.074967,0.64626461,1.3192949,-0.83083805,-1.0740338,0.63139631,1.3179669,-0.83089189,-1.0740338,0.63325373,1.3198782,-0.83089189,-1.0731096,0.63418692,1.3190796,-0.83089189,-1.0740338,0.63047209,1.3196808,-0.83090087,-1.0740338,0.63232951,1.3190796,-0.83089189,-1.0731096,0.63325373,1.3191245,-0.83089189,-1.0731096,0.63418692,1.3191783,-0.83089189,-1.0740338,0.63604434,1.3189809,-0.83088292,-1.0740338,0.63882597,1.3192232,-0.83087395,-1.0740338,0.64161658,1.317276,-0.830856,-1.074967,0.64068339,1.318954,-0.83086497,-1.0740338,0.64440719,1.3181554,-0.83084703,-1.0758912,0.66112393,1.318936,-0.83078422,-1.074967,0.643474,1.3178952,-0.83084703,-1.074967,0.64440719,1.3203448,-0.830856,-1.074967,0.64440719,1.3198692,-0.830856,-1.074967,0.64440719,1.3185681,-0.83084703,-1.074967,0.64161658,1.3201294,-0.830856,-1.0740338,0.63696856,1.3191693,-0.83087395,-1.074967,0.64718883,1.3185502,-0.83083805,-1.0740338,0.6425408,1.3184963,-0.83084703,-1.074967,0.64533141,1.3181643,-0.83083805,-1.0740338,0.63975917,1.3182272,-0.83086497,-1.0740338,0.63790175,1.3177606,-0.83087395,-1.0740338,0.63790175,1.317958,-0.83087395,-1.074967,0.65369427,1.3178323,-0.83080216,-1.074967,0.643474,1.3181015,-0.83084703,-1.0758912,0.63975917,1.3213498,-0.83087395,-1.0740338,0.63047209,1.3205242,-0.83090984,-1.074967,0.63975917,1.3212062,-0.83087395,-1.074967,0.63418692,1.320937,-0.83089189,-1.074967,0.643474,1.3215561,-0.830856,-1.074967,0.6425408,1.3202461,-0.830856,-1.074967,0.643474,1.3203538,-0.830856,-1.074967,0.64904624,1.3201294,-0.83082908,-1.0768244,0.6713442,1.3198782,-0.83073935,-1.0768244,0.68248869,1.318954,-0.83068551,-1.0777486,0.68155549,1.3203627,-0.83070346,-1.0777486,0.69177576,1.3204525,-0.83064962,-1.0777486,0.69920542,1.3186848,-0.83061373,-1.0879689,0.50599836,1.3189809,-0.83147514,-1.0889021,0.51714285,1.3184335,-0.8314213,-1.0916837,0.55894815,1.318936,-0.83125081,-1.0889021,0.52179087,1.3188194,-0.83140336,-1.0889021,0.51528543,1.3169979,-0.83143027,-1.0879689,0.51528543,1.3172042,-0.83143027,-1.0879689,0.52364829,1.3147995,-0.83139438,-1.0889021,0.54501305,1.3151404,-0.83130465,-1.0879689,0.53850761,1.3147725,-0.83133157,-1.0879689,0.52642992,1.3157416,-0.83138541,-1.0889021,0.53015373,1.3159211,-0.83136746,-1.0907595,0.54687046,1.3165851,-0.83129568,-1.0879689,0.52271509,1.3157685,-0.83139438,-1.0889021,0.52736312,1.3167825,-0.83137644,-1.0889021,0.53572597,1.3148623,-0.83134054,-1.0889021,0.53015373,1.3163787,-0.83136746,-1.0889021,0.53850761,1.3160647,-0.83133157,-1.0898263,0.53479278,1.316953,-0.83134952,-1.0898263,0.53479278,1.3166389,-0.83134952,-1.0907595,0.56915945,1.3140906,-0.83119698,-1.0879689,0.52736312,1.3133817,-0.83136746,-1.0889021,0.52642992,1.3141534,-0.83137644,-1.0889021,0.53293536,1.3146469,-0.83134952,-1.0879689,0.52642992,1.3140188,-0.83137644,-1.0879689,0.53479278,1.3125293,-0.83134054,-1.0879689,0.51528543,1.3161454,-0.83143027,-1.0889021,0.52085768,1.316603,-0.83140336,-1.0898263,0.54872788,1.3165941,-0.83129568,-1.0879689,0.4976355,1.3168812,-0.83150206,-1.0889021,0.52736312,1.314288,-0.83137644,-1.0889021,0.53758339,1.313624,-0.83133157,-1.0898263,0.54687046,1.3153289,-0.83129568,-1.0879689,0.52271509,1.3155532,-0.83139438,-1.0889021,0.53107795,1.3144316,-0.83135849,-1.0889021,0.52642992,1.3161723,-0.83137644,-1.0898263,0.55523332,1.3153199,-0.83125979,-1.0898263,0.52922053,1.3161813,-0.83136746,-1.0879689,0.52736312,1.3141714,-0.83137644,-1.0861115,0.47720394,1.3170786,-0.83158282,-1.0898263,0.54129822,1.3158942,-0.8313226,-1.0898263,0.54222244,1.3177965,-0.8313226,-1.0907595,0.54129822,1.319277,-0.8313226,-1.0898263,0.53015373,1.3189001,-0.83137644,-1.0907595,0.53479278,1.3198782,-0.83135849,-1.0907595,0.55150952,1.3197167,-0.83128671,-1.0926169,0.5775223,1.3210267,-0.831188,-1.0926169,0.55709073,1.3228842,-0.83126876,-1.0907595,0.5394408,1.322588,-0.83134952,-1.0907595,0.54779469,1.3221932,-0.83130465,-1.0916837,0.54129822,1.3234136,-0.83134054,-1.0907595,0.52828734,1.3224893,-0.83139438,-1.0907595,0.54129822,1.3224714,-0.83134054,-1.0796061,0.68063127,1.323593,-0.83072141,-1.0805393,0.73264787,1.3213767,-0.83048811,-1.0814635,0.73543848,1.3217625,-0.83047913,-1.0823967,0.75680324,1.3214216,-0.8303894,-1.0786818,0.69642379,1.3201474,-0.83064065,-1.0805393,0.70942569,1.320282,-0.83057784,-1.0786818,0.67877386,1.3190796,-0.83070346,-1.0786818,0.67226842,1.3184963,-0.83073038,-1.0796061,0.68712774,1.3188822,-0.83066757,-1.0796061,0.69177576,1.3191604,-0.83064962,-1.0842541,0.78745508,1.3184246,-0.83025481,-1.0786818,0.68155549,1.3192052,-0.83069449,-1.0823967,0.74286814,1.3173388,-0.83043427,-1.0796061,0.68806093,1.3184963,-0.83065859,-1.0796061,0.70106284,1.3177785,-0.83060476,-1.0814635,0.74007753,1.3179759,-0.83044324,-1.0786818,0.66855359,1.3184425,-0.83074832,-1.0777486,0.66762937,1.3164146,-0.83073935,-1.0823967,0.7642329,1.3157237,-0.83034454,-1.0833209,0.75307944,1.318281,-0.83039838,-1.0842541,0.75772746,1.3184425,-0.83038043,-1.0805393,0.67598325,1.3202102,-0.83072141,-1.0805393,0.67877386,1.3199769,-0.83071243,-1.0805393,0.68620352,1.3192949,-0.83067654,-1.0786818,0.66669617,1.3203897,-0.8307573,-1.0554597,-0.16652052,1.3223458,-0.83386196,-1.0684616,0.46977428,1.3181823,-0.83154692,-1.0768244,0.26634694,1.3184335,-0.83243525,-1.0768244,0.27563402,1.3188194,-0.83240833,-0.98114511,-0.80466376,1.3216728,-0.83648208,-0.98114511,-0.80466376,1.3203448,-0.83648208,-0.98114511,-0.80373953,1.321592,-0.83648208,-0.98022089,-0.80373953,1.3191155,-0.83648208,-0.98022089,-0.80280634,1.3193667,-0.83648208,-0.98114511,-0.80373953,1.3200846,-0.83648208,-0.98022089,-0.80466376,1.3186579,-0.83649106,-0.98022089,-0.80373953,1.3184784,-0.83649106,-0.98114511,-0.80466376,1.3197705,-0.83648208,-0.98114511,-0.80466376,1.320264,-0.83649106,-0.98114511,-0.80373953,1.3211344,-0.83648208,-0.98022089,-0.80373953,1.3201922,-0.83648208,-0.98022089,-0.80373953,1.3197077,-0.83648208,-1.0786818,0.69642379,1.3133548,-0.8306227,-1.0777486,0.6713442,1.3140278,-0.83072141,-1.0777486,0.67226842,1.3121255,-0.83071243,-1.0768244,0.66204815,1.3138304,-0.83076627,-1.0786818,0.69456637,1.3118294,-0.8306227,-1.0777486,0.68248869,1.3123588,-0.83067654,-1.0777486,0.68155549,1.311614,-0.83067654,-1.0777486,0.67598325,1.3114884,-0.83069449,-1.0777486,0.68620352,1.3118294,-0.83065859,-1.0777486,0.67784066,1.3092811,-0.83068551,-1.0786818,0.67877386,1.3106898,-0.83068551,-1.0786818,0.67969808,1.3115423,-0.83068551,-1.0805393,0.71034992,1.3121973,-0.83055989,-1.0796061,0.7084925,1.3080428,-0.83055092,-1.0796061,0.67877386,1.3092093,-0.83067654,-1.0786818,0.68155549,1.3085722,-0.83066757,-1.0786818,0.67505903,1.3090029,-0.83069449,-1.0786818,0.67784066,1.3083927,-0.83068551,-1.0786818,0.67784066,1.3085542,-0.83068551,-1.0796061,0.69456637,1.308967,-0.83061373,-1.0777486,0.67691644,1.3085722,-0.83068551,-1.0786818,0.67691644,1.3087696,-0.83068551,-1.0786818,0.67784066,1.3091016,-0.83068551,-1.0777486,0.6713442,1.3079351,-0.83070346,-1.0777486,0.67412583,1.3089311,-0.83069449,-1.0777486,0.670411,1.3077646,-0.83071243,-1.0786818,0.68806093,1.3081505,-0.83064065,-1.0786818,0.67784066,1.3085812,-0.83068551,-1.0786818,0.67505903,1.3092541,-0.83069449,-1.0777486,0.67505903,1.3074236,-0.83069449,-1.0777486,0.670411,1.3102412,-0.83072141,-1.0777486,0.6713442,1.3099092,-0.83071243,-1.0768244,0.66112393,1.3101604,-0.8307573,-1.0777486,0.66669617,1.3090478,-0.83073038,-1.0786818,0.6843461,1.3080607,-0.83065859,-1.0768244,0.66298134,1.3086888,-0.83073935,-1.0777486,0.66855359,1.3091016,-0.83072141,-1.0777486,0.66204815,1.3086619,-0.83074832,-1.0768244,0.66298134,1.3061584,-0.83073935,-1.0777486,0.68712774,1.3048394,-0.83063168,-1.0777486,0.67226842,1.3052253,-0.83069449,-1.0768244,0.66298134,1.3055842,-0.83073038,-1.0768244,0.66204815,1.3041664,-0.83073038,-1.0768244,0.66762937,1.3034576,-0.83071243,-1.0796061,0.72428502,1.3037088,-0.83047016,-1.0777486,0.68806093,1.3038972,-0.8306227,-1.0768244,0.67505903,1.3029012,-0.83067654,-1.0777486,0.67505903,1.3042382,-0.83067654,-1.0768244,0.66948678,1.3008733,-0.83069449,-1.0777486,0.68712774,1.3021385,-0.8306227,-1.0814635,0.7502978,1.3026141,-0.83036248,-1.0777486,0.68899413,1.3042203,-0.8306227,-1.0777486,0.68899413,1.3040318,-0.8306227,-1.0777486,0.67598325,1.3048304,-0.83067654,-1.0786818,0.6843461,1.3061226,-0.83064962,-1.0786818,0.70663509,1.3040049,-0.83054195,-1.0768244,0.67784066,1.3018155,-0.83065859,-1.0768244,0.67969808,1.3016809,-0.83064962,-1.0768244,0.69270896,1.3002004,-0.83059578,-1.0786818,0.70013862,1.3013399,-0.83056886,-1.0777486,0.67877386,1.3025244,-0.83065859,-1.0814635,0.75680324,1.3020309,-0.83032659,-1.0777486,0.68806093,1.3022731,-0.8306227,-1.0768244,0.67691644,1.3011784,-0.83065859,-1.0768244,0.67784066,1.3012323,-0.83065859,-1.0758912,0.66855359,1.3008554,-0.83069449,-1.0758912,0.65461849,1.3020129,-0.8307573,-1.0758912,0.65833332,1.3019232,-0.83073935,-1.0758912,0.65555168,1.3019501,-0.8307573,-1.0758912,0.65926651,1.3021834,-0.83073935,-1.0758912,0.65833332,1.3018783,-0.83073935,-1.0758912,0.6564759,1.301968,-0.83074832,-1.0777486,0.68248869,1.3035204,-0.83064962,-1.0777486,0.66204815,1.3057726,-0.83073935,-1.0777486,0.6574091,1.306966,-0.8307573,-1.0777486,0.65183685,1.3098194,-0.83079319,-1.0777486,0.66019073,1.3092093,-0.8307573,-1.0777486,0.6574091,1.309308,-0.83076627,-1.0796061,0.68806093,1.3091824,-0.83064065,-1.0823967,0.74379236,1.309954,-0.83040735,-1.0796061,0.69177576,1.3079172,-0.8306227,-1.0777486,0.66112393,1.3090567,-0.83074832,-1.0786818,0.66390556,1.3080248,-0.83073935,-1.0777486,0.66204815,1.3086799,-0.83074832,-1.0786818,0.66669617,1.3085363,-0.83073038,-1.0796061,0.68991835,1.3098733,-0.83064065,-1.0786818,0.66762937,1.3093528,-0.83073038,-1.0777486,0.66204815,1.3077467,-0.83073935,-1.0777486,0.66298134,1.3080518,-0.83073935,-1.0786818,0.66483876,1.3087696,-0.83073935,-1.0777486,0.65926651,1.3094336,-0.8307573,-1.0777486,0.66204815,1.3125113,-0.8307573,-1.0777486,0.66483876,1.311964,-0.83074832,-1.0777486,0.67320161,1.3111116,-0.83070346,-1.0777486,0.66483876,1.3115512,-0.83074832,-1.0777486,0.66483876,1.3091644,-0.83073935,-1.0768244,0.66019073,1.3108693,-0.8307573,-1.0786818,0.67877386,1.3107706,-0.83068551,-1.0786818,0.68620352,1.3100438,-0.83064962,-1.0777486,0.66483876,1.3103578,-0.83074832,-1.0823967,0.74101073,1.3116858,-0.8304253,-1.0796061,0.69085154,1.3102322,-0.83063168,-1.0796061,0.69549059,1.3104386,-0.83061373,-1.0777486,0.66204815,1.3104206,-0.8307573,-1.0796061,0.68063127,1.3100617,-0.83067654,-1.0768244,0.66112393,1.3086709,-0.83074832,-1.0777486,0.67320161,1.3080876,-0.83069449,-1.0777486,0.67784066,1.3081594,-0.83067654,-1.0786818,0.66762937,1.3102232,-0.83073038,-1.0814635,0.73171468,1.3094157,-0.83046119,-1.0786818,0.6843461,1.3100527,-0.83065859,-1.0796061,0.68248869,1.3117397,-0.83066757,-1.0777486,0.67320161,1.3105104,-0.83070346,-1.0777486,0.66948678,1.3094964,-0.83072141,-1.0805393,0.70477767,1.3102771,-0.83057784,-1.0768244,0.6574091,1.3092541,-0.83076627,-1.0786818,0.70571086,1.307289,-0.83055989,-1.0758912,0.66390556,1.30632,-0.83073038,-1.0777486,0.67691644,1.3085004,-0.83068551,-1.0777486,0.66577195,1.3092272,-0.83073038,-1.0777486,0.66019073,1.3096489,-0.8307573,-1.0777486,0.66669617,1.3096759,-0.83073038,-1.0768244,0.66390556,1.3094874,-0.83073935,-1.0777486,0.67412583,1.3096489,-0.83070346,-1.0777486,0.66390556,1.310295,-0.83074832,-1.0786818,0.69085154,1.3093439,-0.83063168,-1.0786818,0.68248869,1.3096131,-0.83066757,-1.0768244,0.67784066,1.3025513,-0.83066757,-1.0758912,0.66112393,1.3065443,-0.83073935,-1.0768244,0.66669617,1.3070827,-0.83072141,-1.0768244,0.66298134,1.3071903,-0.83073935,-1.0777486,0.67877386,1.306957,-0.83067654,-1.0768244,0.66019073,1.3071814,-0.83074832,-1.0758912,0.66204815,1.3056739,-0.83073935,-1.0768244,0.66019073,1.3060508,-0.83074832,-1.0768244,0.66019073,1.3057008,-0.83074832,-1.0758912,0.66204815,1.3060418,-0.83073935,-1.0768244,0.65833332,1.3076659,-0.8307573,-1.0758912,0.66483876,1.3017078,-0.83071243,-1.0768244,0.66855359,1.301968,-0.83069449,-1.0740338,0.66298134,1.297984,-0.83071243,-1.074967,0.66019073,1.2988365,-0.83073038,-1.074967,0.6574091,1.3007477,-0.83073935,-1.0758912,0.65369427,1.3011784,-0.8307573,-1.0758912,0.6713442,1.3000837,-0.83068551,-1.074967,0.6574091,1.2998594,-0.83073935,-1.0758912,0.65461849,1.3013489,-0.8307573,-1.0758912,0.65461849,1.3015643,-0.8307573,-1.074967,0.65276107,1.2998414,-0.8307573,-1.0758912,0.65461849,1.3010797,-0.8307573,-1.0758912,0.65276107,1.3038434,-0.83076627,-1.0768244,0.6574091,1.3042831,-0.8307573,-1.0786818,0.67412583,1.3054675,-0.83068551,-1.0768244,0.65183685,1.3041305,-0.83077524,-1.0768244,0.6574091,1.3035293,-0.83074832,-1.0768244,0.65276107,1.3052701,-0.83077524,-1.0758912,0.6564759,1.3043728,-0.8307573,-1.0768244,0.68248869,1.3037626,-0.83064065,-1.0758912,0.65926651,1.3027756,-0.83073935,-1.0768244,0.66483876,1.303987,-0.83072141,-1.0758912,0.65833332,1.3042831,-0.83074832,-1.0768244,0.65926651,1.3038255,-0.83073935,-1.0768244,0.65461849,1.3061226,-0.83076627,-1.0758912,0.65461849,1.3081056,-0.83077524,-1.0768244,0.66204815,1.3081953,-0.83074832,-1.0786818,0.70199603,1.3072352,-0.83057784,-1.0777486,0.68155549,1.3078992,-0.83065859,-1.0777486,0.67784066,1.3080966,-0.83067654,-1.0768244,0.65926651,1.307648,-0.8307573,-1.0777486,0.67784066,1.3079172,-0.83067654,-1.0768244,0.67877386,1.3054765,-0.83066757,-1.0768244,0.6564759,1.3077018,-0.83076627,-1.0758912,0.65926651,1.3061943,-0.83074832,-1.0777486,0.670411,1.3075044,-0.83070346,-1.0768244,0.66204815,1.3080338,-0.83073935,-1.0768244,0.65926651,1.3050727,-0.83074832,-1.0758912,0.6564759,1.3055573,-0.8307573,-1.0758912,0.6564759,1.3055573,-0.8307573,-1.0758912,0.6564759,1.3055573,-0.8307573,-1.0758912,0.6564759,1.3055573,-0.8307573,-1.0758912,0.6564759,1.3055573,-0.8307573,-1.0758912,0.6564759,1.3055573,-0.8307573,-1.0758912,0.6564759,1.3055573,-0.8307573:4
-0.76539087,0.24840588,1.5237403,-0.91740991,-0.75672221,0.2787306,1.5249683,-0.91728504,-0.75022851,0.29389296,1.5232512,-0.91721219,-0.7448067,0.31772399,1.5218463,-0.91708731,-0.7513108,0.28956383,1.5216278,-0.91721219,-0.75022851,0.29605753,1.5207745,-0.91718097,-0.72206836,0.39353578,1.5206392,-0.9167543,-0.75239308,0.29389296,1.5208577,-0.91719138,-0.76214403,0.26140368,1.5195881,-0.91733707,-0.75239308,0.29064612,1.5200668,-0.91721219,-0.77080228,0.23324353,1.5204102,-0.91746195,-0.76863772,0.23432581,1.5201605,-0.91745154,-0.77296685,0.23324353,1.5197338,-0.91746195,-0.77296685,0.22890399,1.5195257,-0.91748276,-0.76430859,0.25598186,1.5200252,-0.91735788,-0.77080228,0.23106855,1.5179335,-0.91747235,-0.77080228,0.23324353,1.5251764,-0.91748276,-0.77296685,0.23216124,1.5266021,-0.91748276,-0.77405954,0.23216124,1.5294535,-0.91749317,-0.76755544,0.23649037,1.4890865,-0.9173787,-0.76647316,0.25598186,1.5295056,-0.9173787,-0.77296685,0.23106855,1.530463,-0.91749317,-0.77405954,0.22998627,1.5285586,-0.91749317,-0.76863772,0.2473236,1.5291101,-0.91742032,-0.77296685,0.23216124,1.5297345,-0.91748276,-0.77188457,0.23106855,1.5266125,-0.91749317,-0.75997946,0.27331919,1.5287147,-0.91730585,-0.76755544,0.25165273,1.5254574,-0.91739951,-0.76539087,0.25598186,1.5264773,-0.9173787,-0.76972,0.23973722,1.5264669,-0.91745154,-0.77080228,0.23324353,1.5250516,-0.91748276,-0.74914623,0.30797304,1.5264877,-0.91714975,-0.76322631,0.26465053,1.5263108,-0.91734748,-0.77405954,0.23106855,1.5287147,-0.91749317,-0.76863772,0.24406635,1.5291309,-0.91743073,-0.76863772,0.24624132,1.5293495,-0.91743073,-0.76647316,0.24514863,1.5299947,-0.91743073,-0.76755544,0.24298407,1.5279238,-0.91744113,-0.75997946,0.27006194,1.5295264,-0.91731626,-0.76647316,0.2473236,1.5272369,-0.91742032,-0.76647316,0.23973722,1.5258841,-0.91745154,-0.76755544,0.23432581,1.511752,-0.91743073,-0.74155985,0.32747493,1.5277885,-0.9170665,-0.73939528,0.33613319,1.5288291,-0.91702487,-0.75997946,0.26681509,1.5277885,-0.91733707,-0.76972,0.23324353,1.5261547,-0.91748276,-0.76539087,0.2473236,1.5272161,-0.91742032,-0.73398387,0.35021327,1.5273202,-0.91696243,-0.76539087,0.24624132,1.5287667,-0.91742032,-0.76430859,0.25273501,1.5279654,-0.91739951,-0.76214403,0.26465053,1.5274243,-0.91734748,-0.76430859,0.24948817,1.5255511,-0.91740991,-0.76106174,0.27114422,1.5232096,-0.91731626,-0.76322631,0.25057045,1.5263212,-0.91739951,-0.76322631,0.25057045,1.5233449,-0.91739951,-0.76430859,0.24948817,1.5244584,-0.91740991,-0.71772882,0.4054513,1.5260402,-0.91672308,-0.73072662,0.35779965,1.5265917,-0.91693121,-0.74588898,0.31230217,1.5242815,-0.91712894,-0.75022851,0.30472619,1.5210554,-0.91714975,-0.74806395,0.30364391,1.5219192,-0.91714975,-0.74588898,0.31230217,1.5235322,-0.91712894,-0.76755544,0.24190178,1.527289,-0.91744113,-0.76214403,0.21698848,1.5285794,-0.9175452,-0.7827178,0.044780707,1.524833,-0.91828407,-0.71123513,0.2722265,1.5250828,-0.91727463,-0.99933036,-0.76322631,1.5243855,-0.92168701,-1.0112459,-0.8076311,1.5249371,-0.9218223,-1.0123282,-0.81087795,1.5241254,-0.9218327,-1.0123282,-0.80979567,1.5261338,-0.9218327,-1.0123282,-0.81196023,1.5200876,-0.9218327,-1.0134104,-0.81521749,1.5197754,-0.92184311,-1.0134104,-0.81521749,1.5200564,-0.92184311,-1.0134104,-0.81521749,1.5213364,-0.92184311,-1.0123282,-0.81629977,1.5204935,-0.92184311,-1.0144927,-0.81846433,1.5202229,-0.92185352,-1.015575,-0.8206289,1.5247394,-0.92185352,-1.015575,-0.8206289,1.5233969,-0.92185352,-1.015575,-0.8206289,1.524729,-0.92185352,-1.015575,-0.8206289,1.524552,-0.92185352,-1.015575,-0.8206289,1.5190886,-0.92185352,-1.0144927,-0.81954662,1.523501,-0.92185352,-1.0144927,-0.8206289,1.5179647,-0.92185352,-1.0144927,-0.82171118,1.5256551,-0.92186392,-1.015575,-0.82171118,1.5246873,-0.92185352,-1.015575,-0.82171118,1.524219,-0.92185352,-1.0144927,-0.82171118,1.5227309,-0.92186392,-1.0144927,-0.82171118,1.5250307,-0.92186392,-1.015575,-0.82171118,1.5306087,-0.92185352,-1.0166573,-0.82171118,1.533356,-0.92185352,-1.0166573,-0.82171118,1.5343966,-0.92185352,-0.71556426,0.44769153,1.5270392,-0.91654617,-0.70798828,0.39571075,1.5277469,-0.9167543,-0.76214403,0.26897966,1.5337098,-0.91734748,-0.75672221,0.28631699,1.5336058,-0.91727463,-0.75888677,0.27440147,1.5350106,-0.91732666,-0.73290159,0.35996422,1.5367069,-0.91695203,-0.73290159,0.35021327,1.5352292,-0.91699365,-0.72856205,0.3610465,1.5351147,-0.91694162,-0.74264213,0.31880627,1.5358536,-0.91712894,-0.72639749,0.37729114,1.5317534,-0.91684796,-0.75997946,0.25057045,1.5349482,-0.91742032,-0.76863772,0.23216124,1.5378933,-0.91750357,-0.76972,0.23649037,1.538476,-0.91749317,-0.75672221,0.28089517,1.5375707,-0.91729544,-0.76972,0.23973722,1.5396312,-0.91747235,-0.77188457,0.23216124,1.5370711,-0.91750357,-0.76972,0.23649037,1.5391733,-0.91749317,-0.76755544,0.24190178,1.5397768,-0.91746195,-0.76863772,0.23324353,1.5388507,-0.91750357,-0.75672221,0.27548376,1.537196,-0.91731626,-0.76972,0.23540809,1.5374874,-0.91749317,-0.77080228,0.23540809,1.5395895,-0.91749317,-0.77080228,0.23106855,1.5396936,-0.91751398,-0.75888677,0.27331919,1.5398809,-0.91732666,-0.77080228,0.23432581,1.5383095,-0.91749317,-0.7199038,0.40003988,1.5383615,-0.91677511,-0.76863772,0.24624132,1.5392461,-0.91745154,-0.77188457,0.23324353,1.5384344,-0.91750357,-0.76972,0.23649037,1.539319,-0.91749317,-0.75672221,0.2787306,1.5373313,-0.91730585,-0.7513108,0.2917284,1.5393918,-0.91724341,-0.75672221,0.27656604,1.5379453,-0.91731626,-0.76755544,0.23865494,1.5389859,-0.91748276,-0.76863772,0.23216124,1.5402451,-0.91750357,-0.71015285,0.43144688,1.5380285,-0.91663983,-0.75672221,0.27656604,1.5366861,-0.91731626,-0.74372441,0.31772399,1.5364988,-0.91712894,-0.75780449,0.27331919,1.5379557,-0.91732666,-0.77188457,0.23106855,1.539423,-0.91751398,-0.76863772,0.23757266,1.5376227,-0.91748276,-0.76972,0.23757266,1.5386737,-0.91748276,-0.74155985,0.32747493,1.5381118,-0.91708731,-0.68956867,0.49860042,1.5385697,-0.91633804,-0.74264213,0.32529996,1.5393918,-0.91709772,-0.76863772,0.23432581,1.5409008,-0.91749317,-0.76972,0.23216124,1.5398289,-0.91750357,-0.76755544,0.24298407,1.5415772,-0.91746195,-0.75563993,0.28305973,1.5405261,-0.91728504,-0.76755544,0.24406635,1.5380285,-0.91745154,-0.75672221,0.27548376,1.5370399,-0.91731626,-0.77080228,0.23216124,1.5339388,-0.91750357,-0.76647316,0.24406635,1.5340949,-0.91745154,-0.74698167,0.31230217,1.5338243,-0.91716016,-0.74047757,0.33396863,1.5327836,-0.91703528,-0.75239308,0.30039706,1.53269,-0.91719138,-0.73506615,0.35671737,1.536249,-0.91696243,-0.74698167,0.31555942,1.5374978,-0.91713934,-0.74588898,0.31880627,1.5365196,-0.91712894,-0.74155985,0.3296395,1.5299635,-0.91705609,-0.74914623,0.30256163,1.5286522,-0.91718097,-0.74698167,0.31121989,1.5291309,-0.91713934,-0.73506615,0.33721548,1.4859125,-0.91693121,-0.74372441,0.31555942,1.5279342,-0.91711853,-0.74372441,0.32097083,1.5264773,-0.91709772,-0.73723072,0.34480186,1.5271329,-0.91699365,-0.7448067,0.3231354,1.5357703,-0.91710812,-0.73939528,0.34046232,1.5369359,-0.91703528,-0.73614844,0.34480186,1.5384656,-0.91701447,-0.74264213,0.32855722,1.5369567,-0.91708731,-0.74047757,0.33180406,1.5376643,-0.9170665,-0.73939528,0.33721548,1.5405261,-0.91704569,-0.74372441,0.32855722,1.5385072,-0.91708731,-0.74588898,0.31880627,1.5399642,-0.91712894,-0.73072662,0.36429335,1.5358432,-0.91693121,-0.74588898,0.31988855,1.533689,-0.91712894,-0.74588898,0.31772399,1.5348545,-0.91712894,-0.74264213,0.32529996,1.5340324,-0.91709772,-0.73398387,0.35779965,1.5357599,-0.91696243,-0.74155985,0.32638225,1.5282568,-0.9170769,-0.73506615,0.34155501,1.526727,-0.91700406,-0.72856205,0.3610465,1.5248642,-0.91692081,-0.73398387,0.35021327,1.5227933,-0.91694162,-0.74047757,0.32747493,1.5253742,-0.9170665,-0.71231741,0.41736681,1.5224291,-0.91665024,-0.73939528,0.33396863,1.5252909,-0.91703528,-0.71015285,0.42603547,1.52322,-0.91662942,-0.74155985,0.32529996,1.5255927,-0.9170769,-0.73290159,0.35021327,1.5265293,-0.91696243,-0.72531521,0.36863288,1.5251452,-0.91687918,-0.74264213,0.3231354,1.5236675,-0.91708731,-0.74047757,0.32747493,1.5222938,-0.91704569,-0.7318089,0.35129555,1.5237924,-0.91696243,-0.74264213,0.32097083,1.522221,-0.9170769,-0.67548859,0.53975837,1.5197338,-0.91610909,-0.73506615,0.34371958,1.5215862,-0.91697284,-0.71448198,0.40436901,1.5208993,-0.91670227,-0.76106174,0.25706414,1.5205559,-0.91735788,-0.75997946,0.2603214,1.5248018,-0.91735788,-0.76863772,0.23757266,1.5256551,-0.91746195,-0.76755544,0.23757266,1.5270496,-0.91746195,-0.76755544,0.23865494,1.5279862,-0.91746195,-0.76972,0.23324353,1.5276948,-0.91748276,-0.76539087,0.25057045,1.5326588,-0.91740991,-0.76863772,0.2408195,1.5337723,-0.91747235,-0.76972,0.23649037,1.536145,-0.91749317,-0.76647316,0.24190178,1.5379661,-0.91746195,-0.78488236,0.044780707,1.5398705,-0.91830488,-0.7004019,0.42169594,1.5373417,-0.91667105,-1.025326,-0.85311818,1.5451778,-0.92191596,-1.0264082,-0.85745772,1.5448552,-0.92192636,-1.0264082,-0.85745772,1.5443037,-0.92192636,-1.0264082,-0.85745772,1.5454068,-0.92192636,-1.0264082,-0.85637543,1.5453964,-0.92192636,-1.0264082,-0.85745772,1.545667,-0.92192636,-1.0264082,-0.85745772,1.5452195,-0.92192636,-1.0274905,-0.85745772,1.5455525,-0.92191596,-1.0264082,-0.85745772,1.5433879,-0.92192636,-1.0264082,-0.85637543,1.5422536,-0.92191596,-1.0264082,-0.85745772,1.540932,-0.92192636,-1.0264082,-0.85854,1.5439499,-0.92192636,-1.0264082,-0.85854,1.5411297,-0.92192636,-1.0264082,-0.85854,1.5405157,-0.92192636,-1.0264082,-0.85854,1.5411297,-0.92192636,-1.0264082,-0.85745772,1.5421183,-0.92192636,-1.0264082,-0.85854,1.5405886,-0.92192636,-1.0274905,-0.85962228,1.5409736,-0.92192636,-1.0264082,-0.85962228,1.5383824,-0.92192636,-1.0274905,-0.85962228,1.5409112,-0.92192636,-1.0274905,-0.85962228,1.5390484,-0.92192636,-1.0274905,-0.85854,1.5369046,-0.92192636,-1.0274905,-0.85854,1.5374458,-0.92191596,-1.0274905,-0.85962228,1.5396416,-0.92192636,-1.0264082,-0.85962228,1.5382991,-0.92192636,-1.0264082,-0.85962228,1.538195,-0.92192636,-0.738313,0.36321106,1.5295992,-0.9169104,-0.7199038,0.24840588,1.52962,-0.91740991,-0.69065095,0.27548376,1.5331895,-0.91729544,-0.76214403,0.23324353,1.5333352,-0.91748276,-0.68199269,0.52892514,1.5344799,-0.91621316,-0.75455764,0.24624132,1.5349378,-0.91744113,-0.7513108,0.39787532,1.5348337,-0.91678552,-0.76647316,0.27656604,1.5351771,-0.91731626,-0.76539087,0.26897966,1.5358223,-0.91734748,-0.77838867,0.20399068,1.5354477,-0.91762845,-0.7762241,0.21916345,1.5327732,-0.9175452,-0.76106174,0.21482391,1.5334601,-0.91755561,-0.76647316,0.21698848,1.5351251,-0.91745154,-0.77514182,0.20724794,1.5316389,-0.91756601,-0.77188457,0.21049478,1.5331479,-0.91749317,-0.7762241,0.22998627,1.5325963,-0.91758683,-0.76322631,0.24624132,1.5351355,-0.91740991,-0.75997946,0.22349258,1.5341573,-0.91735788,-0.77296685,0.20399068,1.5352708,-0.91753479,-0.76972,0.20616565,1.5320031,-0.91749317,-0.75780449,0.30364391,1.5348858,-0.91730585,-0.74588898,0.38053799,1.535583,-0.91714975,-0.75672221,0.2722265,1.5363739,-0.91729544,-0.74155985,0.27440147,1.5339804,-0.9170769,-0.75239308,0.27981289,1.5350731,-0.91720178,-0.75022851,0.34913099,1.5364259,-0.91718097,-0.74155985,0.33288635,1.5374354,-0.91709772,-0.72423292,0.3296395,1.5342406,-0.91684796,-0.74155985,0.32747493,1.5346048,-0.91710812,-0.72423292,0.31880627,1.5359056,-0.91685837,-0.7448067,0.3166417,1.5357599,-0.91713934,-0.74372441,0.32747493,1.535916,-0.91708731,-0.74264213,0.32421768,1.5358952,-0.91710812,-0.7448067,0.31988855,1.5336162,-0.91712894,-0.73614844,0.34046232,1.5331375,-0.91701447,-0.71556426,0.41628453,1.53397,-0.91670227,-0.7448067,0.32421768,1.5330646,-0.91708731,-0.73939528,0.33829776,1.5304838,-0.91702487,-0.73723072,0.34155501,1.5243855,-0.91700406,-0.72747977,0.37079745,1.5333352,-0.91687918,-0.73072662,0.36971517,1.5326692,-0.91687918,-0.72098608,0.3989576,1.5328357,-0.9167543,-0.72747977,0.36971517,1.5346256,-0.91689999,-0.73290159,0.35455281,1.5354165,-0.91697284,-0.7448067,0.32421768,1.5332415,-0.91708731,-0.738313,0.34804871,1.5333456,-0.91698325,-0.72315064,0.38812437,1.5313371,-0.91679593,-0.72531521,0.37512658,1.5331583,-0.91685837,-0.70256646,0.44877381,1.5273514,-0.91653576,-0.74047757,0.32529996,1.527955,-0.9170769,-0.71882151,0.3989576,1.5281943,-0.9167543,-0.72098608,0.38704209,1.5272161,-0.91680633,-0.74155985,0.32205312,1.5273202,-0.91708731,-0.72639749,0.37620886,1.5258112,-0.91684796,-0.73939528,0.3296395,1.5265605,-0.91705609,-0.71556426,0.40761586,1.5269768,-0.91671268,-0.71882151,0.39679304,1.5278821,-0.91676471,-0.72315064,0.38271296,1.5273826,-0.91682715,-0.73398387,0.34480186,1.5261338,-0.91699365,-0.72098608,0.38595981,1.5267166,-0.91680633,-0.69282592,0.48019122,1.5265917,-0.91639007,-0.71231741,0.41303768,1.5275283,-0.91669186,-0.74155985,0.32421768,1.5282776,-0.9170769,-0.74155985,0.32421768,1.5284753,-0.9170769,-0.73072662,0.36212878,1.5298386,-0.9169104,-0.71556426,0.40979083,1.5261026,-0.91670227,-0.74047757,0.33396863,1.5266229,-0.91703528,-0.74806395,0.30689076,1.5237403,-0.91716016,-0.74698167,0.30689076,1.5267062,-0.91716016,-0.74264213,0.32529996,1.5277052,-0.9170769,-0.7448067,0.3166417,1.5271121,-0.91711853,-0.7199038,0.39353578,1.5241254,-0.91677511,-0.72747977,0.36971517,1.5262587,-0.91687918,-0.74372441,0.32097083,1.5266125,-0.91709772,-0.74264213,0.32205312,1.5289332,-0.91708731,-0.74806395,0.30905532,1.5297241,-0.91714975,-0.74806395,0.31230217,1.5292662,-0.91713934,-0.72423292,0.38920665,1.5307023,-0.91679593,-0.72206836,0.39353578,1.5298906,-0.91677511,-0.73506615,0.34913099,1.5302652,-0.91697284,-0.74698167,0.31230217,1.5292662,-0.91713934,-0.74372441,0.32205312,1.5304213,-0.91708731,-0.74588898,0.31555942,1.5295784,-0.91711853,-0.72856205,0.36429335,1.5292246,-0.91689999,-0.7318089,0.35563509,1.5287979,-0.91694162,-0.74698167,0.30797304,1.5273826,-0.91714975,-0.74372441,0.31772399,1.5275908,-0.91710812,-0.74047757,0.3231354,1.5286522,-0.91708731,-0.64624616,0.63507206,1.5265293,-0.91571365,-0.649493,0.62099199,1.5273202,-0.91577608,-0.65057529,0.6199097,1.5315036,-0.91577608,-0.649493,0.6199097,1.5316805,-0.91577608,-0.64624616,0.6394116,1.5314932,-0.91569283,-0.65057529,0.62099199,1.5314308,-0.91577608,-0.63867018,0.65890309,1.5300571,-0.91560958,-0.6375879,0.6578208,1.5306087,-0.91560958,-0.63867018,0.65998537,1.5305254,-0.91559917,-0.63975246,0.64590529,1.5297137,-0.91566161,-0.63541293,0.66757175,1.5333768,-0.91556795,-0.63000152,0.68922781,1.5311082,-0.91547429,-0.76214403,0.26681509,1.5342301,-0.91735788,-0.66791262,0.57334034,1.5354373,-0.91601544,-0.6689949,0.57658719,1.5363011,-0.91600503,-0.65166798,0.62423883,1.536478,-0.91578649,-0.63324836,0.68381639,1.5345944,-0.91552633,-0.63324836,0.66648947,1.4869531,-0.91545348,-0.64299931,0.64806986,1.5283504,-0.91565121,-0.63433064,0.67298316,1.5287563,-0.91554714,-0.72856205,0.35888194,1.5242503,-0.91693121,-0.74372441,0.30689076,1.5199107,-0.91712894,-0.74698167,0.30147935,1.5173091,-0.91716016,-0.64841072,0.62532111,1.5162788,-0.91572405,-0.73398387,0.35129555,1.5173507,-0.91694162,-0.71772882,0.39787532,1.5182665,-0.91673349,-0.63975246,0.65023442,1.5154255,-0.91560958,-0.6375879,0.65349168,1.5154983,-0.91559917,-0.74372441,0.31447714,1.5194112,-0.91709772,-0.74155985,0.31988855,1.5187972,-0.9170769,-0.738313,0.33829776,1.5220232,-0.91699365,-0.71556426,0.41087311,1.5222106,-0.91667105,-0.73506615,0.34804871,1.5214613,-0.91695203,-0.73506615,0.35021327,1.5180167,-0.91694162,-0.74047757,0.32855722,1.5178086,-0.91703528,-0.73506615,0.34588414,1.520431,-0.91696243,-0.72747977,0.37187973,1.5127926,-0.91684796,-0.70473103,0.43578642,1.5130216,-0.91656698,-0.72423292,0.37620886,1.5126157,-0.91680633,-0.69607277,0.46611114,1.5113253,-0.91640048,-0.738313,0.32638225,1.5126782,-0.91702487,-0.73723072,0.33180406,1.5133234,-0.91702487,-0.69065095,0.49102445,1.5136668,-0.91631723,-0.68848639,0.49318901,1.5141455,-0.91630682,-0.73939528,0.32421768,1.5136772,-0.91705609,-0.73939528,0.32421768,1.5136772,-0.91705609,-0.73939528,0.32421768,1.5136772,-0.91705609,-0.73939528,0.32421768,1.5136772,-0.91705609,-0.73939528,0.32421768,1.5136772,-0.91705609,-0.73939528,0.32421768,1.5136772,-0.91705609,-0.73939528,0.32421768,1.5136772,-0.91705609,-0.73939528,0.32421768,1.5136772,-0.91705609:4
-1.0984324,0.59349929,1.3406115,-0.7983341,-1.0993757,0.63387883,1.3386886,-0.79814363,-1.0974982,0.61791567,1.3386886,-0.79821619,-1.096555,0.60570748,1.3376909,-0.79827061,-1.0993757,0.6507762,1.3376547,-0.79805293,-1.0974982,0.59256508,1.3379358,-0.79832503,-1.096555,0.61040573,1.3374914,-0.79825247,-1.0974982,0.60289579,1.3365391,-0.79827968,-1.0974982,0.60852824,1.3349972,-0.79825247,-1.0984324,0.62542561,1.335623,-0.79817084,-1.1003099,0.67800427,1.3351786,-0.79792595,-1.0956207,0.60007502,1.3336276,-0.79828875,-1.0956207,0.59444257,1.3334734,-0.79830689,-1.096555,0.60289579,1.3346706,-0.79827968,-1.096555,0.60946245,1.3321038,-0.7982434,-1.096555,0.6010183,1.3358316,-0.79828875,-1.0974982,0.60758497,1.3347341,-0.79825247,-1.0984324,0.61228321,1.3410106,-0.79825247,-1.096555,0.59819754,1.3400491,-0.79831596,-1.0993757,0.61603818,1.3409471,-0.7982434,-1.0993757,0.6010183,1.3424255,-0.79830689,-1.0993757,0.60383,1.341455,-0.79829782,-1.0993757,0.60289579,1.3408654,-0.79828875,-1.0993757,0.60477327,1.3416817,-0.79828875,-1.0993757,0.60289579,1.3420989,-0.79829782,-1.1003099,0.6010183,1.342752,-0.79830689,-1.1003099,0.60195251,1.3424617,-0.79829782,-1.0993757,0.59819754,1.3408926,-0.79830689,-1.0993757,0.60946245,1.3403757,-0.79827061,-1.0984324,0.60383,1.3404936,-0.79829782,-1.0974982,0.60289579,1.3395231,-0.79829782,-1.0974982,0.61509491,1.3405026,-0.7982434,-1.0993757,0.59256508,1.3415094,-0.79834317,-1.0984324,0.60195251,1.3400673,-0.79829782,-1.0993757,0.61133994,1.3413099,-0.79826154,-1.1012532,0.57942269,1.3434413,-0.79838852,-1.104074,0.78316159,1.3426794,-0.79752687,-1.1003099,0.60665076,1.3440036,-0.79827968,-1.0993757,0.54749637,1.3437225,-0.79852457,-1.0993757,0.56439373,1.3430059,-0.79845201,-1.0993757,0.58035689,1.3428155,-0.79838852,-1.0974982,0.55218554,1.3416908,-0.79849736,-1.0984324,0.55876128,1.340294,-0.79847015,-1.0974982,0.60007502,1.3424164,-0.79830689,-1.0993757,0.58130017,1.3436681,-0.79838852,-1.0984324,0.56251625,1.3431692,-0.79846108,-1.0984324,0.56158204,1.3405933,-0.79846108,-1.0993757,0.57190367,1.3431511,-0.7984248,-1.0984324,0.55594958,1.3428518,-0.79849736,-1.0984324,0.55312882,1.3445116,-0.79850643,-1.0993757,0.56063876,1.3433415,-0.79847015,-1.0984324,0.61133994,1.340548,-0.79826154,-1.0984324,0.58693263,1.3423348,-0.79836131,-1.0993757,0.55500631,1.3423348,-0.79849736,-1.0993757,0.55970456,1.3429606,-0.79847922,-1.0984324,0.57190367,1.341845,-0.79843387,-1.0993757,0.58881011,1.342498,-0.79836131,-1.0984324,0.56627122,1.340811,-0.79845201,-1.0984324,0.54561888,1.341464,-0.79853364,-1.0984324,0.61791567,1.3408654,-0.79823433,-1.0984324,0.61133994,1.3393054,-0.79826154,-1.0984324,0.61133994,1.3415275,-0.79827061,-1.096555,0.57660192,1.3395775,-0.79839759,-1.0984324,0.62542561,1.3410559,-0.79820712,-1.0993757,0.63012386,1.3424345,-0.79818898,-1.0974982,0.55782707,1.3384165,-0.79847015,-1.0974982,0.55970456,1.3413189,-0.79847922,-1.096555,0.55312882,1.3398042,-0.79849736,-1.0984324,0.55970456,1.3390696,-0.79847015,-1.096555,0.5672145,1.3391331,-0.79843387,-1.0993757,0.66204111,1.3409561,-0.79802572,-1.096555,0.55030806,1.3383349,-0.79850643,-1.0956207,0.55218554,1.3362125,-0.79848829,-1.0946775,0.5681487,1.3368656,-0.7984248,-1.0946775,0.56439373,1.3369563,-0.79844294,-1.0974982,0.54937385,1.3370016,-0.79849736,-1.0946775,0.56345953,1.3349518,-0.79844294,-1.096555,0.55970456,1.3362488,-0.79845201,-1.0946775,0.55688379,1.333682,-0.79846108,-1.0928,0.55688379,1.3354325,-0.79847015,-1.0946775,0.55876128,1.334843,-0.79846108,-1.0946775,0.5681487,1.3338362,-0.79841573,-1.0937433,0.5672145,1.3329927,-0.79841573,-1.0946775,0.55688379,1.3345074,-0.79846108,-1.0946775,0.55688379,1.3344711,-0.79846108,-1.0946775,0.55782707,1.3338453,-0.79846108,-1.0937433,0.5540721,1.3326118,-0.79847922,-1.0937433,0.55030806,1.3313964,-0.79848829,-1.0928,0.54749637,1.3330018,-0.79850643,-1.0974982,0.59537678,1.3396682,-0.79832503,-1.0984324,0.58317766,1.3429243,-0.79837945,-1.0984324,0.61791567,1.3428064,-0.79823433,-1.0974982,0.57472444,1.341845,-0.79840666,-1.0974982,0.57190367,1.3427066,-0.7984248,-1.0993757,0.61133994,1.3461714,-0.79827968,-1.0993757,0.60758497,1.3465523,-0.79829782,-1.1021874,0.69303322,1.3478675,-0.79791688,-1.1003099,0.62261392,1.3493459,-0.79823433,-1.1012532,0.59913175,1.3515227,-0.79834317,-1.1012532,0.60007502,1.3515861,-0.7983341,-1.0993757,0.60195251,1.3500533,-0.79832503,-1.1003099,0.61697239,1.3499717,-0.79826154,-1.1012532,0.60383,1.3505522,-0.79831596,-1.1012532,0.57942269,1.3517585,-0.79841573,-1.1012532,0.56251625,1.3515861,-0.79848829,-1.1021874,0.58786683,1.3514682,-0.79837945,-1.1021874,0.58881011,1.352221,-0.79837945,-1.1012532,0.55030806,1.3512868,-0.79854271,-1.1012532,0.56251625,1.3515408,-0.79848829,-1.1021874,0.57190367,1.3518764,-0.79845201,-1.1012532,0.56533701,1.3501712,-0.79847015,-1.1003099,0.57284695,1.3494184,-0.79844294,-1.1012532,0.5681487,1.3502256,-0.79846108,-1.1012532,0.58317766,1.3512687,-0.79840666,-1.1012532,0.58317766,1.3510782,-0.79840666,-1.1012532,0.58130017,1.3517041,-0.79841573,-1.1003099,0.57660192,1.3493821,-0.7984248,-1.1012532,0.57378116,1.3520034,-0.79844294,-1.1012532,0.60289579,1.3510419,-0.79831596,-1.1003099,0.55782707,1.3502256,-0.79850643,-1.0993757,0.55970456,1.3520941,-0.79850643,-1.1003099,0.58130017,1.3502982,-0.79840666,-1.1012532,0.60570748,1.3514592,-0.79831596,-1.1012532,0.57660192,1.349237,-0.7984248,-1.1021874,0.5672145,1.3506066,-0.79847015,-1.1012532,0.60007502,1.3515499,-0.7983341,-1.1003099,0.56158204,1.350661,-0.79848829,-1.1003099,0.60852824,1.3493821,-0.79828875,-1.1012532,0.60477327,1.3501803,-0.79831596,-1.1003099,0.55125134,1.3506973,-0.79853364,-1.1003099,0.55970456,1.3514047,-0.79849736,-1.1012532,0.55594958,1.3522755,-0.7985155,-1.1021874,0.60758497,1.3494728,-0.79830689,-1.1031307,0.57190367,1.3483572,-0.79843387,-1.1003099,0.55594958,1.350788,-0.79850643,-1.1012532,0.55688379,1.3511689,-0.79850643,-1.1021874,0.56439373,1.3523027,-0.79848829,-1.1021874,0.5672145,1.3515317,-0.79847015,-1.1031307,0.61603818,1.352085,-0.79827061,-1.1021874,0.57096947,1.3523027,-0.79845201,-1.1021874,0.58881011,1.3494638,-0.79837038,-1.1012532,0.58317766,1.3494728,-0.79839759,-1.1003099,0.60758497,1.3461169,-0.79828875,-1.1021874,0.30150044,1.3480035,-0.79961296,-1.1190938,1.1315122,1.3449379,-0.79609381,-1.1284813,0.78316159,1.3467246,-0.79767199,-0.94914968,-0.76700639,1.3527834,-0.80380329,-0.94914968,-0.76606312,1.3545702,-0.80379422,-0.94914968,-0.76606312,1.3541167,-0.80379422,-0.94914968,-0.76606312,1.3540895,-0.80379422,-0.9482064,-0.76606312,1.3488924,-0.80379422,-0.9482064,-0.76700639,1.3469695,-0.80379422,-0.9472722,-0.76512891,1.3466702,-0.80378515,-0.9472722,-0.76512891,1.3473233,-0.80379422,-0.9482064,-0.76700639,1.3471691,-0.80380329,-0.9472722,-0.76512891,1.3448925,-0.80379422,-0.9472722,-0.76700639,1.3451555,-0.80379422,-1.1181506,1.1315122,1.3463256,-0.79612102,-1.1021874,0.58223438,1.3484117,-0.79840666,-1.1012532,0.58411186,1.3500805,-0.79839759,-1.1031307,0.63481304,1.3484026,-0.79817084,-1.1012532,0.64702123,1.3501349,-0.79814363,-1.1021874,0.58130017,1.3521938,-0.79841573,-1.1012532,0.65359696,1.3504705,-0.79811642,-1.1050082,0.6244914,1.3522301,-0.7982434,-1.1021874,0.62918058,1.3482665,-0.79821619,-1.1012532,0.58223438,1.3464435,-0.79839759,-1.1003099,0.57660192,1.34716,-0.7984248,-1.1012532,0.5775452,1.3457269,-0.79841573,-1.104074,0.59256508,1.3466067,-0.79836131,-1.0993757,0.58881011,1.3401308,-0.79835224,-1.0993757,0.57190367,1.3401489,-0.7984248,-1.0974982,0.57096947,1.3377998,-0.7984248,-1.0974982,0.55594958,1.3369019,-0.79847922,-1.0984324,0.58317766,1.3376093,-0.79837038,-1.0984324,0.56439373,1.3399131,-0.79845201,-1.0974982,0.5681487,1.3378995,-0.79843387,-1.0974982,0.58411186,1.3360493,-0.79836131,-1.0993757,0.62072736,1.3377635,-0.79821619,-1.0984324,0.55125134,1.3384982,-0.79850643,-1.0984324,0.59256508,1.336666,-0.7983341,-1.0984324,0.59162181,1.3381263,-0.7983341,-1.0984324,0.57190367,1.3370651,-0.79841573,-1.0993757,0.58505514,1.3375821,-0.79836131,-1.0974982,0.56251625,1.3360493,-0.79845201,-1.0974982,0.5540721,1.3350879,-0.79848829,-1.096555,0.56909198,1.333945,-0.7984248,-1.0984324,0.60665076,1.3340811,-0.79826154,-1.0974982,0.58786683,1.3332013,-0.79834317,-1.0993757,0.59162181,1.338353,-0.79834317,-1.0993757,0.5775452,1.3394868,-0.79839759,-1.0984324,0.56627122,1.3394052,-0.79844294,-1.0984324,0.57002619,1.3397226,-0.79843387,-1.0993757,0.57096947,1.3406024,-0.79843387,-1.1003099,0.57378116,1.3444844,-0.79843387,-1.1003099,0.59256508,1.3459083,-0.79835224,-1.1012532,0.62542561,1.3472598,-0.79822526,-1.1003099,0.63105807,1.3487745,-0.79820712,-1.1021874,0.60570748,1.3496452,-0.79831596,-1.1003099,0.59632005,1.3482756,-0.79835224,-1.1012532,0.59537678,1.3492098,-0.79835224,-1.1003099,0.63105807,1.348203,-0.79820712,-1.1012532,0.63951129,1.347423,-0.79817084,-1.1012532,0.63012386,1.3483844,-0.79820712,-1.1012532,0.62824637,1.3499263,-0.79821619,-1.1021874,0.66956012,1.3484842,-0.79803479,-1.1021874,0.65922942,1.3481849,-0.79808014,-1.1021874,0.6273031,1.3493731,-0.79821619,-1.1021874,0.6244914,1.3480035,-0.79822526,-1.1012532,0.63293555,1.3471237,-0.79818898,-1.1003099,0.62824637,1.3471419,-0.79820712,-1.1003099,0.62918058,1.348067,-0.79820712,-1.0993757,0.56158204,1.3468698,-0.79847922,-1.0993757,0.58693263,1.3469514,-0.79837038,-1.1003099,0.61979316,1.3467156,-0.7982434,-1.1003099,0.57565865,1.3467065,-0.7984248,-1.1003099,0.61228321,1.3456,-0.79826154,-1.1012532,0.58974432,1.3475228,-0.79837038,-1.1087631,0.92118851,1.3446748,-0.7969736,-1.1012532,0.61603818,1.3468244,-0.79826154,-1.0993757,0.57284695,1.3451646,-0.79843387,-1.0984324,0.56345953,1.3445206,-0.79847015,-1.0984324,0.5681487,1.3449832,-0.79844294,-1.0993757,0.57847941,1.34638,-0.79840666,-1.0993757,0.5681487,1.3451827,-0.79845201,-1.0993757,0.56533701,1.3457904,-0.79846108,-1.1003099,0.62918058,1.3453641,-0.79820712,-1.0984324,0.58505514,1.3450286,-0.79837945,-1.1003099,0.62072736,1.3470512,-0.7982434,-1.0993757,0.58130017,1.349101,-0.79840666,-1.1003099,0.59444257,1.3488561,-0.79835224,-1.1012532,0.57565865,1.3483028,-0.79841573,-1.1012532,0.57472444,1.3485205,-0.7984248,-1.1012532,0.57565865,1.3477768,-0.7984248,-1.1021874,0.59349929,1.3491645,-0.79835224,-1.1021874,0.57378116,1.3485386,-0.79843387,-1.1012532,0.58035689,1.3473414,-0.79840666,-1.1021874,0.57002619,1.3481668,-0.79845201,-1.1021874,0.58693263,1.3485568,-0.79837945,-1.1012532,0.58035689,1.346389,-0.79839759,-1.1021874,0.60007502,1.3463981,-0.79832503,-1.1021874,0.59256508,1.3469423,-0.79835224,-1.1021874,0.56439373,1.3497177,-0.79847922,-1.1012532,0.58505514,1.3486928,-0.79838852,-1.1012532,0.5775452,1.3481305,-0.7984248,-1.1021874,0.57096947,1.3487926,-0.79845201,-1.1021874,0.60195251,1.3487654,-0.79832503,-1.1031307,0.62918058,1.3502982,-0.79821619,-1.1021874,0.61133994,1.3494184,-0.79827968,-1.1021874,0.57847941,1.3487926,-0.79841573,-1.1031307,0.65640865,1.3492007,-0.79809828,-1.104074,0.69208995,1.3493005,-0.79793502,-1.1021874,0.58786683,1.3504977,-0.79837945,-1.1021874,0.5681487,1.3501803,-0.79846108,-1.1031307,0.6376338,1.3494093,-0.79817084,-1.1012532,0.55970456,1.3507154,-0.79849736,-1.1021874,0.56627122,1.3504615,-0.79847015,-1.1012532,0.57284695,1.347423,-0.79844294,-1.1012532,0.56533701,1.3481123,-0.79847015,-1.1012532,0.60665076,1.3463528,-0.79830689,-1.1003099,0.57002619,1.3474684,-0.79845201,-1.1012532,0.63012386,1.3472235,-0.79820712,-1.1012532,0.59162181,1.3465977,-0.79836131,-1.1003099,0.59725426,1.3443664,-0.7983341,-1.1003099,0.58411186,1.344693,-0.79838852,-1.0993757,0.56063876,1.345092,-0.79847922,-1.1012532,0.61603818,1.3463618,-0.79826154,-1.1012532,0.5906876,1.3473867,-0.79837038,-1.1012532,0.58223438,1.3499354,-0.79840666,-1.1012532,0.59349929,1.3488652,-0.79835224,-1.1012532,0.58881011,1.3491191,-0.79837945,-1.1012532,0.60946245,1.3485658,-0.79829782,-1.1021874,0.60289579,1.3485931,-0.79831596,-1.1003099,0.60007502,1.3457723,-0.79831596,-1.0984324,0.60665076,1.3396773,-0.79827968,-1.0984324,0.56627122,1.3436227,-0.79845201,-1.0984324,0.5906876,1.3424527,-0.79834317,-1.0993757,0.60195251,1.3425978,-0.79830689,-1.0984324,0.5775452,1.3431511,-0.79840666,-1.0984324,0.58881011,1.3407385,-0.79835224,-1.0984324,0.58411186,1.341074,-0.79837038,-1.0974982,0.56439373,1.3407022,-0.79845201,-1.0984324,0.57190367,1.3426069,-0.7984248,-1.0993757,0.58974432,1.3425887,-0.79835224,-1.0984324,0.6273031,1.3410106,-0.79819805,-1.0993757,0.65922942,1.3416273,-0.79805293,-1.0974982,0.59349929,1.3406387,-0.79832503,-1.0974982,0.56909198,1.3425706,-0.79843387,-1.0974982,0.57190367,1.3420445,-0.7984248,-1.0984324,0.56251625,1.3422894,-0.79846108,-1.0984324,0.58786683,1.3433234,-0.79836131,-1.0974982,0.58505514,1.3420627,-0.79837038,-1.0974982,0.57472444,1.3410922,-0.79840666,-1.0974982,0.57942269,1.3401217,-0.79838852,-1.0984324,0.59162181,1.3407475,-0.7983341,-1.0974982,0.57565865,1.3412282,-0.79840666,-1.0974982,0.57002619,1.3422531,-0.79843387,-1.0974982,0.55500631,1.341065,-0.79848829,-1.0984324,0.58223438,1.3400582,-0.79837945,-1.0984324,0.57284695,1.3417815,-0.7984248,-1.0984324,0.58223438,1.3414006,-0.79838852,-1.0974982,0.57096947,1.3413824,-0.7984248,-1.0984324,0.5672145,1.3428699,-0.79845201,-1.0984324,0.56439373,1.3441669,-0.79846108,-1.0984324,0.57660192,1.3441125,-0.79840666,-1.0974982,0.56627122,1.3438313,-0.79845201,-1.0984324,0.60758497,1.3435864,-0.79827061,-1.0984324,0.5775452,1.3444118,-0.79839759,-1.0984324,0.55970456,1.3436136,-0.79847922,-1.0993757,0.57190367,1.3449832,-0.7984248,-1.0984324,0.58411186,1.3427973,-0.79837945,-1.096555,0.5540721,1.3423257,-0.79848829,-1.0974982,0.5775452,1.3420355,-0.79839759,-1.096555,0.55500631,1.3420989,-0.79848829,-1.0974982,0.61133994,1.3423529,-0.79826154,-1.096555,0.5681487,1.3425343,-0.79844294,-1.0993757,0.56345953,1.3469332,-0.79847015,-1.0993757,0.56063876,1.3466067,-0.79847922,-1.0993757,0.58035689,1.3462439,-0.79839759,-1.0984324,0.56533701,1.3461714,-0.79846108,-1.0993757,0.58693263,1.345863,-0.79837038,-1.0993757,0.58223438,1.3460353,-0.79838852,-1.0984324,0.57847941,1.3429062,-0.79839759,-1.0974982,0.57565865,1.3438767,-0.79840666,-1.0993757,0.57002619,1.346126,-0.79844294,-1.0984324,0.56439373,1.3457269,-0.79846108,-1.0993757,0.56533701,1.3466521,-0.79847015,-1.1003099,0.5681487,1.3475228,-0.79846108,-1.1012532,0.61884988,1.3484479,-0.79825247,-1.1021874,0.63951129,1.3493731,-0.79816177,-1.1012532,0.6376338,1.3478584,-0.79817084,-1.0993757,0.63200135,1.3432871,-0.79818898,-1.0984324,0.56158204,1.3415547,-0.79847015,-1.0984324,0.57660192,1.341718,-0.79840666,-1.0956207,0.55876128,1.3357409,-0.79846108,-1.0946775,0.57284695,1.3337455,-0.79839759,-1.0946775,0.59537678,1.3330471,-0.79829782,-1.0946775,0.57284695,1.332385,-0.79838852,-1.0956207,0.61884988,1.3315415,-0.79819805,-1.0956207,0.6141607,1.3318227,-0.79822526,-1.0946775,0.5681487,1.3314961,-0.79841573,-1.0946775,0.57002619,1.3317138,-0.79840666,-1.0956207,0.5540721,1.3329564,-0.79847015,-1.0946775,0.57378116,1.3327841,-0.79838852,-1.096555,0.56909198,1.3329292,-0.79840666,-1.0946775,0.56063876,1.3343623,-0.79844294,-1.0956207,0.57284695,1.336149,-0.79839759,-1.0946775,0.56251625,1.3355414,-0.79844294,-1.0946775,0.56345953,1.3340267,-0.79843387,-1.0956207,0.55688379,1.3340629,-0.79846108,-1.0937433,0.56909198,1.3297003,-0.79840666,-1.0928,0.57002619,1.3307252,-0.79840666,-1.0928,0.56345953,1.3284305,-0.7984248,-1.0928,0.55970456,1.3275688,-0.79843387,-1.0918658,0.56063876,1.3269884,-0.79843387,-1.0928,0.55688379,1.3272514,-0.79844294,-1.0928,0.55594958,1.3287661,-0.79845201,-1.0918658,0.56627122,1.326943,-0.79840666,-1.0928,0.56251625,1.3272786,-0.7984248,-1.0928,0.56251625,1.3272786,-0.7984248,-1.0928,0.56251625,1.3272786,-0.7984248,-1.0928,0.56251625,1.3272786,-0.7984248,-1.0928,0.56251625,1.3272786,-0.7984248,-1.0928,0.56251625,1.3272786,-0.7984248,-1.0928,0.56251625,1.3272786,-0.7984248:4
-0.94617513,0.52931076,1.3155488,-0.98289933,-0.95161186,0.54234633,1.3136805,-0.98288883,-0.95812965,0.52496557,1.3142263,-0.98299379,-0.95595705,0.53908219,1.3175849,-0.98294131,-0.95595705,0.54451893,1.3217307,-0.98292032,-0.95052032,0.53582855,1.3210275,-0.98292032,-0.95595705,0.54342738,1.3223184,-0.98292032,-0.96247484,0.52604662,1.322224,-0.98301478,-0.95812965,0.54017374,1.3225598,-0.98294131,-0.96030224,0.53148336,1.3224024,-0.98299379,-0.96030224,0.52931076,1.3206496,-0.98299379,-0.9592107,0.53365595,1.3150974,-0.98295181,-0.96355589,0.52170143,1.3175114,-0.98303577,-0.95812965,0.54125479,1.3165249,-0.98294131,-0.96355589,0.51952884,1.3157482,-0.98304627,-0.96030224,0.53365595,1.3174485,-0.9829833,-0.96682003,0.51301105,1.3187079,-0.98309875,-0.96464743,0.52060989,1.3212059,-0.98309875,-0.96572848,0.52604662,1.3260864,-0.98307776,-0.96572848,0.52060989,1.3237353,-0.98309875,-0.96247484,0.52713817,1.3240292,-0.98303577,-0.96464743,0.51301105,1.32341,-0.98310924,-0.96247484,0.52713817,1.3222765,-0.98303577,-0.96791157,0.51191951,1.32108,-0.98310924,-0.96682003,0.52060989,1.3233365,-0.98305676,-0.96247484,0.53148336,1.328175,-0.98299379,-0.96572848,0.5162647,1.3236409,-0.98308825,-0.9592107,0.53148336,1.3275033,-0.98300429,-0.93748475,0.63796151,1.3282065,-0.98243752,-0.9592107,0.54886412,1.3224234,-0.98286784,-0.96791157,0.52604662,1.3261598,-0.98303577,-0.96138329,0.53039181,1.320996,-0.9829728,-0.96355589,0.53582855,1.3248059,-0.9829728,-0.96138329,0.54777257,1.3240817,-0.98290983,-0.96030224,0.55103671,1.3215523,-0.98287834,-0.94074889,0.62926063,1.3242286,-0.98246901,-0.94292148,0.6216618,1.3239872,-0.98251099,-0.93748475,0.61514401,1.3218042,-0.98251099,-0.94617513,0.60753468,1.3228852,-0.98260545,-0.93965734,0.62600699,1.3252362,-0.98252149,-0.92662177,0.67489562,1.3237039,-0.9822486,-0.9363932,0.6216618,1.3233575,-0.98251099,-0.93748475,0.61839765,1.3074671,-0.98247951,-0.93748475,0.63252477,1.3188024,-0.98245851,-0.94509408,0.61079882,1.3223709,-0.98258446,-0.93965734,0.62491544,1.3161155,-0.98247951,-0.94074889,0.62491544,1.3122216,-0.9825005,-0.84947891,0.94109624,1.3033633,-0.98075822,-0.8310066,0.9975942,1.2988607,-0.98045385,-0.94617513,0.59992535,1.3027966,-0.98260545,-0.94509408,0.60862623,1.3304211,-0.98263694,-0.89619495,0.7889831,1.3229377,-0.98165035,-0.92553023,0.68685014,1.3258555,-0.98220662,-0.90488533,0.73573878,1.3168922,-0.98187076,-0.92770282,0.66186005,1.3144992,-0.9822486,-0.88750457,0.80636386,1.3167663,-0.98148242,-0.88750457,0.82049097,1.3119278,-0.98142994,-0.9385658,0.62817958,1.3175114,-0.98247951,-0.94726667,0.60209794,1.3169867,-0.98261595,-0.91032206,0.69119533,1.3175009,-0.98208067,-0.9385658,0.60536208,1.3189808,-0.98256347,-0.94292148,0.59015392,1.3209225,-0.98266843,-0.94074889,0.62600699,1.3198835,-0.98247951,-0.94074889,0.6194892,1.3269995,-0.98252149,-0.92010399,0.68576909,1.3303791,-0.98218563,-0.94400253,0.60427054,1.3332549,-0.98262644,-0.9157588,0.70749504,1.3314916,-0.98207018,-0.94182994,0.61622506,1.3336117,-0.98255297,-0.94943927,0.58363613,1.3341365,-0.9827314,-0.9385658,0.6216618,1.3400141,-0.98253198,-0.95052032,0.58471718,1.3398881,-0.98276289,-0.93313956,0.65316967,1.3363721,-0.98239554,-0.95052032,0.60101689,1.3375896,-0.98268942,-0.94834772,0.59449911,1.3403919,-0.98268942,-0.94726667,0.6216618,1.3431523,-0.98260545,-0.94509408,0.63143322,1.3440444,-0.98255297,-0.92987542,0.65316967,1.3451044,-0.98240604,-0.95052032,0.60318949,1.3334963,-0.98267892,-0.94074889,0.61622506,1.3386706,-0.98260545,-0.92553023,0.6423067,1.3377785,-0.98240604,-0.93096696,0.61297142,1.3274193,-0.98249,-0.9385658,0.60536208,1.3277027,-0.98257397,-0.92879437,0.63686996,1.3348817,-0.98243752,-0.93422061,0.61839765,1.3313237,-0.98254248,-0.94182994,0.60209794,1.3429423,-0.98265793,-0.94726667,0.60645363,1.3399196,-0.98266843,-0.93965734,0.61622506,1.3420712,-0.98262644,-0.9363932,0.61731661,1.3326356,-0.98257397,-0.93748475,0.6401341,1.3427114,-0.98249,-0.9363932,0.65316967,1.3403499,-0.98242703,-0.90163168,0.75964782,1.3360047,-0.9817763,-0.93531215,0.64338775,1.3393948,-0.98242703,-0.9385658,0.62817958,1.3367919,-0.98253198,-0.94074889,0.61187987,1.3381458,-0.98259496,-0.9385658,0.60645363,1.3359418,-0.98258446,-0.92770282,0.67164198,1.3399196,-0.98229058,-0.94400253,0.60862623,1.3388386,-0.98263694,-0.93965734,0.61839765,1.336498,-0.98257397,-0.94617513,0.60101689,1.3378625,-0.98271041,-0.88206783,0.83679068,1.3363826,-0.98144044,-0.94617513,0.60970727,1.3413155,-0.98265793,-0.93204801,0.66403265,1.3392374,-0.98238504,-0.93748475,0.61297142,1.3411581,-0.98259496,-0.91140311,0.71618542,1.3370018,-0.98203869,-0.9385658,0.6216618,1.3407173,-0.98258446,-0.92444918,0.67055043,1.339017,-0.98229058,-0.92227658,0.68467755,1.3424281,-0.9822486,-0.94943927,0.61187987,1.3440444,-0.98267892,-0.92987542,0.68576909,1.3412421,-0.98226959,-0.94726667,0.61514401,1.3481797,-0.98266843,-0.89945909,0.79115569,1.3451674,-0.98172382,-0.95052032,0.60970727,1.3460386,-0.98269991,-0.95378446,0.59123497,1.3433412,-0.98279437,-0.94400253,0.60318949,1.3429109,-0.98269991,-0.95269291,0.59232651,1.3420607,-0.98277338,-0.94943927,0.60536208,1.3373902,-0.98269991,-0.93965734,0.64338775,1.3401925,-0.9825005,-0.95161186,0.58798132,1.3412735,-0.98280487,-0.94509408,0.61622506,1.3417354,-0.98266843,-0.95161186,0.58688978,1.3370438,-0.98278388,-0.94509408,0.61079882,1.3401925,-0.98266843,-0.95269291,0.59340756,1.3443593,-0.98278388,-0.94943927,0.5988443,1.3446636,-0.9827419,-0.92662177,0.69336793,1.3464059,-0.9822591,-0.94292148,0.63035218,1.346259,-0.98257397,-0.95052032,0.5988443,1.3447056,-0.9827419,-0.94834772,0.61297142,1.3445692,-0.98266843,-0.94943927,0.5966717,1.3422811,-0.9827209,-0.93531215,0.64665189,1.3418613,-0.98245851,-0.94509408,0.61405246,1.3442963,-0.98265793,-0.92987542,0.65860641,1.3465004,-0.98240604,-0.94834772,0.60101689,1.3456922,-0.98271041,-0.92987542,0.67055043,1.3444432,-0.98233257,-0.93422061,0.64773294,1.3432992,-0.98244802,-0.9363932,0.64121515,1.3427324,-0.98247951,-0.94834772,0.5966717,1.3430998,-0.9827209,-0.94292148,0.62057025,1.34374,-0.98258446,-0.94726667,0.60318949,1.3429109,-0.98268942,-0.94726667,0.59558016,1.3453354,-0.9827314,-0.94509408,0.60753468,1.3451044,-0.98266843,-0.94943927,0.59340756,1.3461645,-0.9827419,-0.94617513,0.60645363,1.345073,-0.98267892,-0.94943927,0.58471718,1.3434042,-0.98279437,-0.9363932,0.62926063,1.34501,-0.98256347,-0.94726667,0.60318949,1.3458391,-0.98269991,-0.95161186,0.59232651,1.3462275,-0.98276289,-0.94074889,0.62274284,1.342554,-0.98259496,-0.93531215,0.64556034,1.3464059,-0.98246901,-0.94726667,0.60970727,1.3458182,-0.98267892,-0.93748475,0.6401341,1.3455138,-0.98251099,-0.94617513,0.61405246,1.3523359,-0.98267892,-0.93965734,0.62926063,1.3483476,-0.98257397,-0.92662177,0.69445947,1.3432152,-0.98220662,-0.92335763,0.69988571,1.3443907,-0.98215414,-0.94617513,0.61731661,1.3493027,-0.98262644,-0.94400253,0.62383439,1.349754,-0.98259496,-0.95052032,0.60101689,1.3495966,-0.9827209,-0.94182994,0.6194892,1.3494391,-0.98261595,-0.93204801,0.64121515,1.3493552,-0.98247951,-0.9385658,0.63686996,1.3501004,-0.98255297,-0.93748475,0.62383439,1.3492502,-0.98257397,-0.94400253,0.60645363,1.3506251,-0.98268942,-0.94182994,0.62274284,1.3505727,-0.98261595,-0.9385658,0.61079882,1.3502893,-0.98263694,-0.94074889,0.61731661,1.3515907,-0.98262644,-0.92770282,0.65968746,1.3500689,-0.98240604,-0.90163168,0.75855627,1.344884,-0.98188125,-0.9385658,0.62491544,1.3432887,-0.98261595,-0.93748475,0.64773294,1.3469937,-0.98247951,-0.95052032,0.5966717,1.3450415,-0.9827419,-0.94617513,0.59232651,1.3477389,-0.98275239,-0.93748475,0.61514401,1.3459966,-0.98261595,-0.94400253,0.60970727,1.3445272,-0.98266843,-0.94292148,0.60536208,1.3472456,-0.98267892,-0.90705792,0.73356618,1.3460595,-0.98198621,-0.93313956,0.64447929,1.3460386,-0.98249,-0.91249466,0.72379475,1.3417354,-0.98204918,-0.94726667,0.5966717,1.342512,-0.9827419,-0.93313956,0.61731661,1.3422286,-0.98256347,-0.92879437,0.65860641,1.3412421,-0.98239554,-0.94182994,0.60536208,1.3445167,-0.98267892,-0.9385658,0.60536208,1.3444537,-0.98269991,-0.94509408,0.60753468,1.3440654,-0.98271041,-0.92770282,0.63143322,1.3496176,-0.9825005,-0.93748475,0.60536208,1.349859,-0.98267892,-0.92010399,0.68250495,1.3412211,-0.9822591,-0.9385658,0.62708803,1.341452,-0.98258446,-0.94182994,0.60753468,1.3389645,-0.98266843,-0.93531215,0.62274284,1.3385657,-0.98256347,-0.94400253,0.60427054,1.3499534,-0.9827209,-0.94182994,0.60209794,1.3504677,-0.9827209,-0.94292148,0.60209794,1.3509715,-0.9827314,-0.94074889,0.59775275,1.3483371,-0.98275239,-0.9363932,0.61297142,1.3495441,-0.98267892,-0.94182994,0.59232651,1.3513284,-0.98279437,-0.94509408,0.5988443,1.3501843,-0.98278388,-0.94726667,0.59558016,1.3443698,-0.98278388,-0.94182994,0.60101689,1.3430893,-0.9827209,-0.93096696,0.64882448,1.3467313,-0.98249,-0.93204801,0.64773294,1.3493132,-0.98253198,-0.92987542,0.63578891,1.3496281,-0.98257397,-0.94509408,0.61187987,1.3506566,-0.98275239,-0.93965734,0.61839765,1.3471091,-0.98267892,-0.94074889,0.60645363,1.3496071,-0.98271041,-0.93096696,0.64556034,1.348526,-0.9825005,-0.93965734,0.60318949,1.3314811,-0.98269991,-0.93965734,0.62057025,1.3297703,-0.98258446,-0.91466725,0.67706822,1.3278496,-0.98226959,-0.93531215,0.6194892,1.3320899,-0.98261595,-0.91466725,0.69228688,1.3337797,-0.98221711,-0.95269291,0.54451893,1.3313027,-0.98295181,-0.94182994,0.59123497,1.3298858,-0.9827209,-0.94617513,0.57276266,1.3282905,-0.98282586,-0.95052032,0.5553819,1.3280491,-0.98292032,-0.95812965,0.53365595,1.3283009,-0.98305676,-0.9592107,0.52278248,1.3291931,-0.98307776,-0.94400253,0.53256441,1.3264747,-0.98292032,-0.95378446,0.52604662,1.3273563,-0.98301478,-0.96138329,0.53256441,1.3357109,-0.98307776,-0.96030224,0.5369096,1.3347558,-0.98303577,-0.96138329,0.52713817,1.3359523,-0.98309875,-0.9570381,0.5553819,1.3287942,-0.98292032,-0.96138329,0.53256441,1.3354905,-0.98305676,-0.96138329,0.5369096,1.3348187,-0.98302528,-0.96572848,0.51952884,1.3359837,-0.98313023,-0.96247484,0.53256441,1.3390695,-0.98308825,-0.96899262,0.5162647,1.3358998,-0.98315123,-0.95486551,0.54994517,1.340182,-0.98295181,-0.95161186,0.55972709,1.3401505,-0.98288883,-0.96355589,0.52713817,1.3407383,-0.98309875,-0.95595705,0.53908219,1.3382298,-0.9829728,-0.9592107,0.52931076,1.340224,-0.98307776,-0.95486551,0.54234633,1.3395733,-0.98295181,-0.95161186,0.54234633,1.3418298,-0.98294131,-0.95595705,0.54777257,1.3448001,-0.9829833,-0.95486551,0.55647345,1.3426485,-0.9829623,-0.95486551,0.5781994,1.343677,-0.98285735,-0.92553023,0.65860641,1.3424071,-0.98236405,-0.95812965,0.54559998,1.3368654,-0.9829833,-0.95812965,0.55320931,1.3412421,-0.9829833,-0.94726667,0.59558016,1.3422181,-0.9827419,-0.96355589,0.53256441,1.3442858,-0.98307776,-0.94943927,0.54342738,1.3412945,-0.98290983,-0.9592107,0.53582855,1.3424071,-0.98303577,-0.95378446,0.54669152,1.3446112,-0.9829728,-0.9592107,0.52496557,1.3434986,-0.98305676,-0.95269291,0.5369096,1.3421867,-0.9829833,-0.96030224,0.53582855,1.3430788,-0.98302528,-0.96464743,0.53256441,1.3418088,-0.98306726,-0.96138329,0.54342738,1.3429633,-0.98303577,-0.96464743,0.534737,1.3367079,-0.98306726,-0.95486551,0.54886412,1.3372852,-0.98294131,-0.96899262,0.53582855,1.343698,-0.98309875,-0.95812965,0.55212826,1.3442438,-0.98299379,-0.95812965,0.5575545,1.331817,-0.98293082,-0.96355589,0.52713817,1.3313447,-0.98307776,-0.96572848,0.53148336,1.3432047,-0.98310924,-0.95269291,0.56189969,1.3379254,-0.98288883,-0.94292148,0.59558016,1.3358053,-0.98267892,-0.96899262,0.52604662,1.3345144,-0.98310924,-0.9363932,0.63796151,1.3354905,-0.9825005,-0.95486551,0.54017374,1.3395628,-0.9829833,-0.95486551,0.54017374,1.3395628,-0.9829833,-0.95812965,0.54342738,1.3388386,-0.98300429,-0.95812965,0.54342738,1.3388386,-0.98300429,-0.95269291,0.55103671,1.3391849,-0.98295181,-0.96138329,0.53039181,1.3392899,-0.98308825,-0.95486551,0.54886412,1.3382613,-0.98295181,-0.96572848,0.534737,1.3385657,-0.98307776,-0.96030224,0.5553819,1.3342625,-0.98295181,-0.94074889,0.59992535,1.330568,-0.98266843,-0.96030224,0.54559998,1.3243861,-0.9829728,-0.96138329,0.54342738,1.3376316,-0.98304627,-0.9592107,0.54017374,1.3369913,-0.98306726,-0.96030224,0.54342738,1.3334543,-0.98302528,-0.96138329,0.52278248,1.3289202,-0.98307776,-0.95269291,0.54669152,1.3285423,-0.98294131,-0.95378446,0.53908219,1.3384922,-0.98302528,-0.95378446,0.54017374,1.3394998,-0.98301478,-0.94509408,0.56516383,1.3419348,-0.98286784,-0.95486551,0.55430085,1.3409062,-0.9829728,-0.95812965,0.54777257,1.3406123,-0.98302528,-0.95595705,0.54886412,1.3398147,-0.98301478,-0.95161186,0.56081864,1.3404654,-0.98293082,-0.9570381,0.54559998,1.3396467,-0.98301478,-0.9570381,0.54777257,1.3407488,-0.98301478,-0.95378446,0.54994517,1.3315231,-0.9829728,-0.95378446,0.55103671,1.3301482,-0.98295181,-0.95595705,0.54886412,1.3334963,-0.9829833,-0.94400253,0.57710785,1.3344829,-0.98279437,-0.95161186,0.54994517,1.330589,-0.98293082,-0.95378446,0.54886412,1.3336747,-0.98295181,-0.95161186,0.56299123,1.3338426,-0.98289933,-0.95486551,0.55320931,1.3310928,-0.98293082,-0.95812965,0.54017374,1.3343989,-0.98301478,-0.95595705,0.54451893,1.3361307,-0.98299379,-0.95269291,0.55320931,1.3362986,-0.98295181,-0.9570381,0.54342738,1.3364875,-0.98299379,-0.95269291,0.54234633,1.3342415,-0.9829623,-0.9592107,0.53365595,1.3362251,-0.98305676,-0.95378446,0.55647345,1.3298123,-0.98294131,-0.95378446,0.54559998,1.3344934,-0.9829833,-0.94834772,0.55972709,1.3368444,-0.98287834,-0.95269291,0.54994517,1.3428374,-0.9829833,-0.94726667,0.5553819,1.3435931,-0.98293082,-0.95052032,0.54234633,1.3424491,-0.9829833,-0.95378446,0.5575545,1.3454193,-0.9829728,-0.9570381,0.55103671,1.3441913,-0.98300429,-0.95486551,0.54886412,1.3468362,-0.98302528,-0.95161186,0.55103671,1.346259,-0.98299379,-0.95486551,0.53908219,1.3410636,-0.98304627,-0.95052032,0.54559998,1.342554,-0.9829833,-0.95595705,0.53800114,1.3466368,-0.98305676,-0.95486551,0.54017374,1.346091,-0.98305676,-0.95269291,0.54777257,1.3356479,-0.9829833,-0.95052032,0.54451893,1.3354485,-0.9829833,-0.94726667,0.54342738,1.3319429,-0.9829623,-0.95486551,0.53256441,1.3309249,-0.98301478,-0.94509408,0.54559998,1.3303476,-0.98292032,-0.95161186,0.54451893,1.3272724,-0.9829833,-0.9570381,0.53908219,1.3209225,-0.98300429,-0.95595705,0.54451893,1.328133,-0.9829833,-0.95486551,0.534737,1.3300852,-0.98303577,-0.94292148,0.54994517,1.329424,-0.98292032,-0.94943927,0.53039181,1.3308409,-0.98302528,-0.94943927,0.54451893,1.3308934,-0.9829728,-0.95052032,0.534737,1.3266951,-0.98300429,-0.94726667,0.54777257,1.3268945,-0.98295181,-0.95052032,0.54451893,1.326968,-0.98299379,-0.86685967,0.8487452,1.3276817,-0.98139846,-0.95378446,0.54451893,1.3288362,-0.98303577,-0.86251448,0.86720701,1.3252677,-0.98131449,-0.95052032,0.53800114,1.329445,-0.98308825,-0.94617513,0.54669152,1.331796,-0.98301478,-0.9570381,0.53800114,1.3354905,-0.98307776,-0.95161186,0.54342738,1.3388386,-0.98306726,-0.94509408,0.54125479,1.341473,-0.98305676,-0.95052032,0.54669152,1.3444117,-0.98304627,-0.94726667,0.54234633,1.341326,-0.98301478,-0.95812965,0.54125479,1.3436246,-0.98308825,-0.95378446,0.53148336,1.3439394,-0.98311974,-0.9570381,0.54017374,1.3480642,-0.98313023,-0.95269291,0.54886412,1.3546555,-0.98309875,-0.95595705,0.54342738,1.3559359,-0.98314073,-0.94617513,0.5760268,1.3561144,-0.9829623,-0.95161186,0.5369096,1.3570695,-0.98311974,-0.9363932,0.54994517,1.361866,-0.98302528,-0.94182994,0.54125479,1.3584969,-0.98310924,-0.94074889,0.5369096,1.3607219,-0.98314073,-0.94182994,0.54886412,1.3512969,-0.98304627,-0.94292148,0.52931076,1.3482531,-0.98311974,-0.9385658,0.54125479,1.3569225,-0.98307776,-0.94292148,0.52604662,1.3552432,-0.98318271,-0.8951139,0.69445947,1.3538893,-0.9822486,-0.94182994,0.54017374,1.3543826,-0.98311974,-0.93204801,0.54234633,1.343845,-0.98299379,-0.93965734,0.54234633,1.3544036,-0.98308825,-0.93748475,0.52604662,1.3550648,-0.98313023,-0.93748475,0.54017374,1.3548759,-0.98311974,-0.94182994,0.53256441,1.3582765,-0.98316172,-0.94182994,0.53256441,1.3582765,-0.98316172,-0.94182994,0.53256441,1.3582765,-0.98316172,-0.94182994,0.53256441,1.3582765,-0.98316172,-0.94182994,0.53256441,1.3582765,-0.98316172,-0.94182994,0.53256441,1.3582765,-0.98316172:4
-0.88158172,0.8479546,1.0531615,-1.1068511,-0.87748411,0.87561839,1.0528547,-1.1067818,-0.83035174,1.0354547,1.0798059,-1.1060395,-0.86416194,0.91660435,1.0804393,-1.1067026,-0.8692889,0.89405762,1.080667,-1.1067719,-0.89079638,0.84897405,1.079796,-1.1070391,-0.87850356,0.88073545,1.0817161,-1.106861,-0.87440596,0.90328218,1.0807165,-1.106762,-0.8713377,0.91454565,1.0837649,-1.1067323,-0.86621075,0.91147739,1.0816072,-1.1066927,-0.88669878,0.85819861,1.079499,-1.1069897,-0.88260117,0.8817648,1.0812707,-1.1068412,-0.88772813,0.86126687,1.0842301,-1.10696,-0.88158172,0.87561839,1.0831315,-1.1068709,-0.88055237,0.87663784,1.082884,-1.1069006,-0.8672302,0.91044804,1.0832008,-1.1067224,-0.88772813,0.86024741,1.0793011,-1.10696,-0.86621075,0.92172141,1.0838144,-1.1066432,-0.85391793,0.96270737,1.0820724,-1.1064156,-0.86313259,0.92684836,1.084042,-1.1066432,-0.8672302,0.91147739,1.0787468,-1.1067026,-0.85596673,0.95348281,1.0842301,-1.1064849,-0.84059576,1.0077909,1.0839629,-1.106188,-0.87748411,0.8858624,1.0857741,-1.1068511,-0.88669878,0.8500034,1.0838243,-1.1070391,-0.88669878,0.8500034,1.0850912,-1.1070589,-0.88772813,0.86331567,1.0827554,-1.1069798,-0.87645476,0.89098936,1.0808847,-1.1068115,-0.87748411,0.8838136,1.0823001,-1.106861,-0.87850356,0.88073545,1.0829236,-1.1068907,-0.87440596,0.87561839,1.0817953,-1.1069006,-0.85801553,0.94528759,1.0809342,-1.1065344,-0.87953292,0.87254023,1.0823891,-1.1069204,-0.85288858,0.96680498,1.0810332,-1.1063958,-0.87953292,0.8858624,1.0772721,-1.1068511,-0.86825955,0.90533098,1.0826861,-1.1067719,-0.87850356,0.87971599,1.078727,-1.1068808,-0.84161521,0.99344932,1.0815281,-1.106277,-0.88567932,0.89713577,1.0806274,-1.1067917,-0.88260117,0.90225283,1.0809342,-1.1067818,-0.89387454,0.86639382,1.0761933,-1.1069402,-0.89079638,0.87561839,1.0791031,-1.1069204,-0.89387454,0.86742317,1.0811816,-1.1069501,-0.88874758,0.88278425,1.083082,-1.1068709,-0.87953292,0.92070196,1.0889018,-1.1066927,-0.87953292,0.89918457,1.0880506,-1.1067818,-0.89490389,0.86742317,1.0864868,-1.1069501,-0.88669878,0.90225283,1.0839431,-1.1067521,-0.89900149,0.86229622,1.085398,-1.1069699,-0.89900149,0.86331567,1.0882683,-1.1069798,-0.86313259,0.95860976,1.0854574,-1.1064552,-0.86825955,0.95860976,1.0858731,-1.106475,-0.89592334,0.88688186,1.087625,-1.106861,-0.89182573,0.89713577,1.0809936,-1.1067818,-0.91334312,0.84487644,1.0811223,-1.1070688,-0.88464997,0.92070196,1.0762229,-1.1066729,-0.89797214,0.87868664,1.0767376,-1.1069006,-0.89592334,0.87868664,1.0811915,-1.1068808,-0.87953292,0.9176238,1.0818151,-1.106663,-0.89695269,0.87868664,1.0831909,-1.1069006,-0.90206975,0.86639382,1.0861007,-1.1070194,-0.90821616,0.8500034,1.0833294,-1.1070787,-0.9030991,0.87458904,1.0844281,-1.1069996,-0.9010503,0.86434502,1.0835472,-1.1070194,-0.90411855,0.85410101,1.0844874,-1.1070688,-0.89182573,0.90123338,1.0830127,-1.1068313,-0.90616736,0.84077884,1.0838639,-1.107148,-0.88874758,0.89918457,1.0829929,-1.1068412,-0.89900149,0.8858624,1.080756,-1.1069105,-0.87748411,0.93504358,1.0787864,-1.106574,-0.89900149,0.86844263,1.0816765,-1.1069501,-0.89797214,0.87356958,1.0819932,-1.1069501,-0.90924551,0.83565188,1.0830127,-1.107148,-0.88363052,0.91147739,1.0787072,-1.1067224,-0.89797214,0.86126687,1.0778462,-1.1069897,-0.89490389,0.86434502,1.0769851,-1.1069699,-0.90002095,0.84692525,1.0763417,-1.1070688,-0.89387454,0.86229622,1.0761636,-1.1069699,-0.9030991,0.85307165,1.0772919,-1.1070095,-0.89182573,0.88483305,1.0767871,-1.1068412,-0.89079638,0.8817648,1.0752233,-1.1068511,-0.89387454,0.87971599,1.0805977,-1.1068808,-0.89182573,0.87049143,1.0826366,-1.1069501,-0.88977693,0.89303816,1.0814093,-1.1068313,-0.90616736,0.84180819,1.0814291,-1.1070787,-0.9051479,0.86537437,1.087427,-1.1069798,-0.89592334,0.90635044,1.0834878,-1.1067818,-0.88977693,0.89815522,1.0850219,-1.1068115,-0.89387454,0.89508697,1.0859226,-1.1068313,-0.90411855,0.88893066,1.083468,-1.106861,-0.90616736,0.87561839,1.0833789,-1.1069402,-0.89182573,0.9196726,1.0850615,-1.1067026,-0.88669878,0.91454565,1.0816468,-1.1067422,-0.88669878,0.92275076,1.076609,-1.106663,-0.88055237,0.94426814,1.0836362,-1.1065938,-0.85903499,1.0221326,1.0809639,-1.1061682,-0.90002095,0.89508697,1.0833195,-1.1068412,-0.90719671,0.87049143,1.0801127,-1.10696,-0.90002095,0.87663784,1.0827158,-1.1069303,-0.89490389,0.9176238,1.0856554,-1.1067323,-0.9051479,0.88483305,1.0853386,-1.1068907,-0.89592334,0.9176238,1.0829137,-1.1066927,-0.89695269,0.90328218,1.0839827,-1.1067818,-0.9030991,0.8858624,1.0840618,-1.1068709,-0.9010503,0.89610642,1.0822506,-1.1068214,-0.88772813,0.92377021,1.0826267,-1.1066432,-0.89797214,0.90020403,1.0836758,-1.1067719,-0.88464997,0.94836575,1.0828345,-1.1065344,-0.89695269,0.89713577,1.0808055,-1.1068016,-0.87645476,0.96065857,1.0813202,-1.106475,-0.84469336,1.0579916,1.0803898,-1.1059504,-0.78423882,1.2393453,1.082013,-1.10502,-0.80575621,1.1860665,1.0814192,-1.1052873,-0.91436257,0.83565188,1.082498,-1.1070886,-0.86211314,0.99344932,1.0799246,-1.1062869,-0.88669878,0.95041455,1.0789844,-1.1065047,-0.88158172,0.95246335,1.0834581,-1.1065245,-0.88772813,0.92275076,1.0824287,-1.106663,-0.89490389,0.90737979,1.0816666,-1.1067422,-0.78833643,1.226033,1.0820427,-1.1050695,-0.79756099,1.210662,1.0798653,-1.1051289,-0.79346339,1.2188573,1.0819438,-1.1050695,-0.83444935,1.0979581,1.0817755,-1.105703,-0.88772813,0.92479956,1.0809045,-1.106663,-0.89900149,0.89200881,1.086556,-1.106861,-0.83035174,1.0979581,1.0817953,-1.1057525,-0.81498077,1.1512369,1.0841707,-1.1054951,-0.88363052,0.93401423,1.0839134,-1.1066234,-0.88363052,0.93196542,1.0812113,-1.1066136,-0.85493738,1.0047128,1.08231,-1.1062374,-0.85596673,0.99856637,1.0801424,-1.1062671,-0.88260117,0.92275076,1.0788755,-1.1066432,-0.88977693,0.89610642,1.0783509,-1.1067917,-0.89284519,0.89508697,1.0783905,-1.1067818,-0.88363052,0.90942859,1.0768168,-1.1067125,-0.88464997,0.8858624,1.0780342,-1.1068313,-0.89284519,0.88073545,1.0776581,-1.1068511,-0.89079638,0.87766719,1.0738376,-1.1068412,-0.87953292,0.91147739,1.0784004,-1.1066927,-0.79346339,1.1645491,1.0766485,-1.1053071,-0.86621075,0.951434,1.0679288,-1.1064354,-0.88669878,0.89303816,1.0740158,-1.1067323,-0.88363052,0.89610642,1.0752629,-1.1067323,-0.89079638,0.90123338,1.0739762,-1.1067422,-0.89592334,0.87766719,1.0726697,-1.1068511,-0.89797214,0.87049143,1.0721451,-1.1068808,-0.89490389,0.87152078,1.0684929,-1.1068412,-0.88464997,0.90020403,1.0710069,-1.1066828,-0.89695269,0.86639382,1.0685226,-1.1068808,-0.79654154,1.1584027,1.0633858,-1.1052873,-0.9010503,0.8520522,1.065682,-1.1069006,-0.88260117,0.9196726,1.0689878,-1.1065641,-0.89182573,0.89303816,1.0702151,-1.1067125,-0.88772813,0.9135262,1.0679881,-1.1066234,-0.8672302,0.97090258,1.0642963,-1.1062869,-0.87748411,0.94426814,1.0670182,-1.1064255,-0.88772813,0.90839924,1.0686117,-1.1066037,-0.89592334,0.89200881,1.0684632,-1.1067224,-0.89387454,0.90123338,1.0690373,-1.106663,-0.89387454,0.8817648,1.0636332,-1.1067422,-0.89695269,0.87868664,1.0620199,-1.106762,-0.89900149,0.87356958,1.06684,-1.1068214,-0.88772813,0.90635044,1.0633066,-1.1066333,-0.9010503,0.8838136,1.0640489,-1.106762,-0.89490389,0.87561839,1.0646428,-1.1068115,-0.9010503,0.85921806,1.0660383,-1.1068907,-0.9051479,0.86844263,1.064425,-1.1068709,-0.88669878,0.915575,1.0648506,-1.1066136,-0.89387454,0.88688186,1.0638114,-1.106762,-0.89695269,0.8838136,1.0666817,-1.1067917,-0.89797214,0.87561839,1.0658107,-1.1067818,-0.90206975,0.88278425,1.056012,-1.1067125,-0.83240054,1.1092215,1.0613567,-1.105604,-0.89490389,0.90737979,1.0574571,-1.106663,-0.90206975,0.8838136,1.0555766,-1.106762,-0.9030991,0.88483305,1.0639697,-1.1068709,-0.86621075,0.99754692,1.0623168,-1.1062572,-0.9051479,0.87663784,1.0641875,-1.1069006,-0.9030991,0.89815522,1.0591199,-1.1067521,-0.84674217,1.0549233,1.062782,-1.1059405,-0.89592334,0.8858624,1.0610301,-1.1068214,-0.89387454,0.88483305,1.0607926,-1.1068016,-0.89695269,0.8838136,1.0620694,-1.1068412,-0.89284519,0.89098936,1.0631482,-1.1068214,-0.89490389,0.87356958,1.0635144,-1.1069105,-0.87850356,0.92889717,1.0632373,-1.1065938,-0.89592334,0.88073545,1.0606342,-1.1068313,-0.88669878,0.90020403,1.0609905,-1.1067125,-0.88363052,0.91044804,1.0611291,-1.1066828,-0.88772813,0.90430163,1.0617922,-1.1067224,-0.86416194,0.97193193,1.0612083,-1.1063661,-0.87235716,0.94836575,1.0593079,-1.106475,-0.86621075,0.97090258,1.0586349,-1.1063463,-0.88977693,0.89303816,1.0595455,-1.1067521,-0.88874758,0.89405762,1.0567346,-1.1067719,-0.89079638,0.88893066,1.0569523,-1.1067818,-0.89592334,0.87356958,1.0586547,-1.1068808,-0.89900149,0.87356958,1.0592783,-1.1069006,-0.89387454,0.88278425,1.0595554,-1.1068412,-0.89797214,0.87663784,1.0600503,-1.1069105,-0.88464997,0.91454565,1.0590902,-1.1066927,-0.88874758,0.90430163,1.0617428,-1.106762,-0.89797214,0.87766719,1.0617428,-1.1069006,-0.89182573,0.89610642,1.0620298,-1.1068016,-0.89182573,0.88278425,1.0643755,-1.1068907,-0.89592334,0.87561839,1.0653158,-1.1069402,-0.89900149,0.87561839,1.0644745,-1.1069204,-0.88977693,0.90328218,1.0662759,-1.1067917,-0.90002095,0.87663784,1.0701557,-1.1069798,-0.89490389,0.8858624,1.0730953,-1.1069303,-0.89387454,0.88483305,1.0685919,-1.1069105,-0.88772813,0.91147739,1.0694728,-1.106762,-0.88669878,0.9196726,1.0684434,-1.1067125,-0.82317598,1.0887335,1.0709376,-1.1058118,-0.89387454,0.87152078,1.0706506,-1.1069699,-0.87850356,0.92581901,1.0691363,-1.1066432,-0.88772813,0.90635044,1.0688888,-1.1067422,-0.90719671,0.83463243,1.0683445,-1.1070985,-0.87645476,0.92070196,1.0678892,-1.106663,-0.87543531,0.92479956,1.0697301,-1.1066531,-0.89490389,0.86844263,1.0648011,-1.1069402,-0.89182573,0.87356958,1.0649793,-1.1068907,-0.87850356,0.90737979,1.06491,-1.1067125,-0.87748411,0.90635044,1.0653257,-1.1067323,-0.88669878,0.89303816,1.0654643,-1.1068115,-0.88055237,0.91454565,1.0645834,-1.1067125,-0.88055237,0.90839924,1.0659987,-1.1067521,-0.88567932,0.89405762,1.0651673,-1.1068115,-0.87748411,0.91044804,1.0630591,-1.1067026,-0.88772813,0.8858624,1.0656919,-1.1068709,-0.88772813,0.90020403,1.0668895,-1.1068115,-0.87850356,0.92275076,1.0658008,-1.1066729,-0.89079638,0.8817648,1.0674636,-1.1068907,-0.83035174,1.0610697,1.0543591,-1.1058217,-0.88669878,0.89918457,1.0529537,-1.1067719,-0.88464997,0.89815522,1.0562199,-1.1067719,-0.87440596,0.93196542,1.0690373,-1.1066234,-0.87850356,0.92172141,1.0693243,-1.1066828,-0.88464997,0.90430163,1.0684335,-1.106762,-0.88055237,0.92070196,1.0686414,-1.1067026,-0.87953292,0.91044804,1.0678298,-1.1067422,-0.83854695,1.053894,1.0659492,-1.1059702,-0.85083977,1.0118885,1.0625049,-1.1061781,-0.85391793,1.002664,1.0684038,-1.1062572,-0.84674217,1.0231619,1.0691858,-1.1061583,-0.85596673,0.99344932,1.0693639,-1.1062869,-0.85083977,1.0108592,1.0671666,-1.106188,-0.84674217,1.0272595,1.0697004,-1.1061088,-0.84264456,1.0364742,1.0707496,-1.1060494,-0.84264456,1.0467281,1.0659294,-1.1060197,-0.85493738,1.0170155,1.0703438,-1.1062176,-0.84059576,1.0313571,1.0687503,-1.1060791,-0.86108379,0.99446877,1.0712346,-1.1063265,-0.88669878,0.92479956,1.0705516,-1.1066927,-0.88567932,0.92070196,1.0716997,-1.1067224,-0.89079638,0.88073545,1.0694629,-1.1068808,-0.89182573,0.88893066,1.0715018,-1.1068907,-0.89797214,0.8817648,1.0693441,-1.1069402,-0.88055237,0.91660435,1.0687799,-1.1067125,-0.89182573,0.8858624,1.069067,-1.1068709,-0.88260117,0.915575,1.0679189,-1.1066927,-0.87953292,0.93504358,1.0645735,-1.1065938,-0.89695269,0.89200881,1.0669588,-1.106861,-0.88874758,0.89098936,1.0668598,-1.1068412,-0.87440596,0.93606303,1.0688591,-1.1065839,-0.87440596,0.92581901,1.0660185,-1.1066136,-0.86621075,0.96680498,1.0661472,-1.1064552,-0.84879097,1.0221326,1.0666322,-1.1061682,-0.88363052,0.88791121,1.0630987,-1.1068214,-0.88874758,0.87868664,1.0628315,-1.1068709,-0.88669878,0.88688186,1.0583974,-1.1068214,-0.88669878,0.87868664,1.056982,-1.1068412,-0.88363052,0.89815522,1.0581697,-1.1067521,-0.88669878,0.87971599,1.0604561,-1.1068412,-0.88567932,0.8817648,1.0607431,-1.1068214,-0.88363052,0.88791121,1.067226,-1.1068115,-0.88260117,0.91044804,1.0651079,-1.1067323,-0.88874758,0.88893066,1.0620694,-1.1068313,-0.87645476,0.92889717,1.0665629,-1.1066531,-0.88158172,0.89405762,1.0673151,-1.1068313,-0.87645476,0.9196726,1.0699182,-1.1066927,-0.88567932,0.91044804,1.0666124,-1.106762,-0.88363052,0.9135262,1.065484,-1.106762,-0.88464997,0.88791121,1.0676912,-1.1068511,-0.87953292,0.90737979,1.0595059,-1.1067323,-0.88977693,0.87663784,1.0653554,-1.1068907,-0.88260117,0.90635044,1.0602086,-1.1067323,-0.88874758,0.91044804,1.0641083,-1.1067521,-0.89182573,0.87971599,1.0575264,-1.1068412,-0.88772813,0.89508697,1.0574076,-1.1067917,-0.88977693,0.89098936,1.056982,-1.1067917,-0.87748411,0.93709238,1.056695,-1.1065641,-0.89387454,0.87561839,1.0551707,-1.1068709,-0.88363052,0.90635044,1.056596,-1.1067224,-0.88772813,0.88996001,1.0576353,-1.1068115,-0.88260117,0.92275076,1.0563387,-1.1066333,-0.89797214,0.91044804,1.0813499,-1.1068313,-0.89695269,0.9135262,1.0838837,-1.1068214,-0.89490389,0.90737979,1.0816171,-1.1068214,-0.9010503,0.89303816,1.0906437,-1.1069501,-0.90206975,0.89713577,1.0833294,-1.1069105,-0.91231377,0.87356958,1.0801127,-1.1070194,-0.89900149,0.9135262,1.0751045,-1.1067818,-0.87440596,0.97704899,1.0759359,-1.1064354,-0.89490389,0.89918457,1.0753816,-1.1068412,-0.89387454,0.91454565,1.0723827,-1.1067719,-0.90206975,0.89098936,1.0723233,-1.106861,-0.88567932,0.93094597,1.0724421,-1.1066432,-0.89284519,0.90839924,1.0773711,-1.1068016,-0.90719671,0.87458904,1.0760151,-1.1069996,-0.89900149,0.89405762,1.0787468,-1.1068808,-0.89490389,0.91660435,1.0797069,-1.1067917,-0.90002095,0.90020403,1.0821021,-1.1069006,-0.89900149,0.89508697,1.0681366,-1.1068313,-0.87440596,0.96578552,1.0716404,-1.1064849,-0.89695269,0.88483305,1.0706605,-1.1069006,-0.9010503,0.8858624,1.0736892,-1.1068808,-0.88977693,0.91660435,1.0655533,-1.1067026,-0.88363052,0.92275076,1.0665629,-1.1066729,-0.88874758,0.90942859,1.0726598,-1.1067719,-0.89900149,0.88073545,1.0743226,-1.1069204,-0.89695269,0.87458904,1.0745601,-1.1069798,-0.9051479,0.86434502,1.0742236,-1.1070293,-0.89592334,0.89713577,1.0730854,-1.1068709,-0.90206975,0.86844263,1.067612,-1.1069798,-0.89900149,0.87868664,1.0692352,-1.1069204,-0.88977693,0.89918457,1.0751837,-1.1068313,-0.89284519,0.90020403,1.074283,-1.1068214,-0.88874758,0.90123338,1.0740356,-1.1067818,-0.90002095,0.88073545,1.074095,-1.1069402,-0.89900149,0.87049143,1.0651574,-1.1069303,-0.89079638,0.90533098,1.0741346,-1.1068115,-0.90411855,0.87766719,1.0731844,-1.1069501,-0.89592334,0.87458904,1.0747383,-1.1069402,-0.89490389,0.87561839,1.0771632,-1.1070194,-0.89695269,0.88996001,1.0706704,-1.1069204,-0.9030991,0.87049143,1.0707298,-1.1070391,-0.88464997,0.9196726,1.0762526,-1.1067521,-0.89900149,0.88073545,1.0750946,-1.1069897,-0.90206975,0.87254023,1.0761339,-1.1070293,-0.90206975,0.87458904,1.0692847,-1.1069996,-0.89900149,0.87458904,1.0615349,-1.1069105,-0.89900149,0.87356958,1.0660482,-1.1069501,-0.89284519,0.89610642,1.0676417,-1.1068313,-0.9010503,0.88278425,1.0729963,-1.1069204,-0.89695269,0.87766719,1.0749264,-1.1069303,-0.89695269,0.88278425,1.0699281,-1.1069204,-0.88977693,0.89713577,1.0721847,-1.106861,-0.90206975,0.85921806,1.064425,-1.1070194,-0.89592334,0.8858624,1.0681267,-1.1069204,-0.89387454,0.89303816,1.0652564,-1.1068511,-0.88260117,0.92581901,1.0636827,-1.1066828,-0.87748411,0.91865315,1.0685523,-1.1067026,-0.88260117,0.9135262,1.0683741,-1.1067323,-0.88464997,0.915575,1.0685226,-1.1067521,-0.87645476,0.93196542,1.0662759,-1.1066333,-0.88158172,0.9196726,1.0644547,-1.1066927,-0.89592334,0.87868664,1.0684632,-1.1069303,-0.82522478,1.0969287,1.0744216,-1.1057921,-0.82522478,1.0969287,1.0744216,-1.1057921,-0.82522478,1.0969287,1.0744216,-1.1057921,-0.82522478,1.0969287,1.0744216,-1.1057921,-0.82522478,1.0969287,1.0744216,-1.1057921,-0.82522478,1.0969287,1.0744216,-1.1057921,-0.82522478,1.0969287,1.0744216,-1.1057921:4
-0.8863048,0.41546693,1.5109906,-0.88289296,-0.94235635,0.19457505,1.5085211,-0.88411689,-0.95020899,0.17215442,1.5079578,-0.88426853,-0.93227249,0.24391125,1.5080337,-0.88385694,-0.91882012,0.29100539,1.5095609,-0.88357533,-0.93675661,0.24166919,1.5099724,-0.8838786,-0.95469311,0.1676703,1.5078062,-0.88430102,-0.95133544,0.18224912,1.5099833,-0.8842252,-0.90984104,0.34034159,1.5095067,-0.88332621,-0.9535775,0.17327004,1.5134493,-0.88427936,-0.8403371,0.58141203,1.5061274,-0.88193981,-0.86501062,0.50180257,1.5054991,-0.88247054,-0.86388417,0.50404464,1.503647,-0.88244888,-0.95245105,0.17439648,1.507752,-0.8842577,-0.93003043,0.26297419,1.5079362,-0.88377029,-0.94572486,0.20018562,1.5059649,-0.88411689,-0.95020899,0.18784886,1.4979931,-0.88416021,-0.92666192,0.27082683,1.5061382,-0.88367281,-0.85491592,0.53431789,1.5027913,-0.88228641,-0.90199923,0.36276221,1.5029213,-0.88312042,-0.95020899,0.18897531,1.5015999,-0.88418188,-0.91545161,0.32913128,1.5051092,-0.88341286,-0.77979059,0.77314627,1.4980906,-0.88083503,-0.64411874,1.1924877,1.4972566,-0.87866879,-0.82800034,0.61841148,1.5005168,-0.88176652,-0.93899868,0.22260624,1.5068639,-0.88400858,-0.87397887,0.44349812,1.506409,-0.88273049,-0.86725268,0.45919256,1.5094092,-0.88267634,-0.84257916,0.55225439,1.5005493,-0.88218893,-0.9434828,0.20242768,1.5092684,-0.88412772,-0.91993573,0.29100539,1.5082936,-0.88362948,-0.86051566,0.496192,1.5020657,-0.88248138,-0.82912679,0.59374879,1.504546,-0.88193981,-0.92106218,0.26858477,1.5060949,-0.88372697,-0.90984104,0.30669983,1.5045568,-0.88348868,-0.93338811,0.23270094,1.5120954,-0.88394359,-0.93787223,0.22373269,1.5090301,-0.88399775,-0.9255463,0.2663427,1.5092684,-0.88377029,-0.92666192,0.25960568,1.5110122,-0.88380278,-0.89751511,0.36276221,1.5106765,-0.88320707,-0.9255463,0.25960568,1.5079037,-0.88379195,-0.92666192,0.26184775,1.5106223,-0.88378112,-0.92778836,0.27082683,1.5164495,-0.8837378,-0.92666192,0.26858477,1.5126261,-0.8837378,-0.92441986,0.27531095,1.5141533,-0.88371613,-0.92666192,0.26970038,1.5134601,-0.8837378,-0.92106218,0.28987894,1.5043185,-0.88359699,-0.93227249,0.25960568,1.5062357,-0.88379195,-0.90648336,0.36052015,1.508586,-0.88320707,-0.84818974,0.55225439,1.5071563,-0.88218893,-0.93227249,0.25063744,1.5057699,-0.88383528,-0.93451455,0.24615331,1.5025747,-0.88384611,-0.93451455,0.24952182,1.5105465,-0.88385694,-0.92330424,0.28987894,1.5178467,-0.88364032,-0.93451455,0.25849007,1.5231974,-0.88382445,-0.93338811,0.26073213,1.5204787,-0.88381362,-0.90311485,0.35940454,1.5195472,-0.88322873,-0.91432516,0.32127865,1.5170777,-0.88344535,-0.93563017,0.25624801,1.5223525,-0.88384611,-0.93338811,0.25176388,1.5208037,-0.88385694,-0.93114604,0.25624801,1.5179009,-0.88382445,-0.93338811,0.25512156,1.5160812,-0.88382445,-0.93227249,0.26073213,1.522515,-0.88381362,-0.91882012,0.31679452,1.5179875,-0.88349951,-0.90759897,0.33585747,1.5049793,-0.88332621,-0.92330424,0.2943739,1.5059757,-0.88358616,-0.92890398,0.26521626,1.5081636,-0.88375946,-0.93003043,0.26297419,1.5099291,-0.88377029,-0.93003043,0.26073213,1.5104274,-0.88379195,-0.84482123,0.56683321,1.5120087,-0.88212395,-0.92330424,0.27866863,1.5129619,-0.88368364,-0.92217779,0.28987894,1.5126478,-0.88361865,-0.9255463,0.27306889,1.5097883,-0.88371613,-0.91993573,0.29100539,1.5103515,-0.88361865,-0.93227249,0.25512156,1.5090193,-0.88384611,-0.93227249,0.25736362,1.5152148,-0.88384611,-0.85940005,0.51862346,1.5154097,-0.88239473,-0.90872542,0.3336154,1.5101674,-0.8833912,-0.92666192,0.27306889,1.511153,-0.8837378,-0.92666192,0.26745832,1.515843,-0.88378112,-0.93003043,0.25400594,1.5176409,-0.88385694,-0.89638866,0.37734104,1.5151389,-0.88315291,-0.93451455,0.24952182,1.5205112,-0.88390027,-0.93338811,0.25512156,1.5179984,-0.88385694,-0.93563017,0.25176388,1.5162545,-0.8838786,-0.91993573,0.29773158,1.5203271,-0.88361865,-0.93227249,0.24839537,1.5241938,-0.88390027,-0.92890398,0.2663427,1.5283314,-0.88382445,-0.94235635,0.24615331,1.4712508,-0.88367281,-0.93003043,0.28091069,1.4731571,-0.88347785,-0.92778836,0.25512156,1.5201213,-0.88384611,-0.92217779,0.27531095,1.516677,-0.88371613,-0.93003043,0.2528795,1.5222334,-0.88386777,-0.93114604,0.25063744,1.5206195,-0.8838786,-0.93227249,0.2528795,1.5233707,-0.8838786,-0.93338811,0.25736362,1.5236089,-0.88385694,-0.93227249,0.25063744,1.5182258,-0.8838786,-0.93227249,0.26521626,1.5213236,-0.88380278,-0.93227249,0.25736362,1.5213885,-0.88385694,-0.85491592,0.52198113,1.513341,-0.88237306,-0.92778836,0.2528795,1.5192331,-0.88385694,-0.90424129,0.33809953,1.5157563,-0.8833587,-0.92106218,0.2842792,1.5163845,-0.88368364,-0.92441986,0.27755301,1.5179984,-0.88372697,-0.92890398,0.25960568,1.5168503,-0.88382445,-0.91432516,0.31679452,1.5214535,-0.88351034,-0.93338811,0.25176388,1.5209228,-0.88388943,-0.92666192,0.27866863,1.5183016,-0.88371613,-0.89527305,0.38519367,1.5140017,-0.88310959,-0.92441986,0.28652126,1.5200671,-0.88367281,-0.93227249,0.25176388,1.5221142,-0.88386777,-0.93227249,0.25063744,1.5225908,-0.88386777,-0.93227249,0.25400594,1.5206412,-0.88385694,-0.91656722,0.31679452,1.5240422,-0.88352117,-0.93114604,0.26410064,1.52232,-0.88380278,-0.9120831,0.32240509,1.5194173,-0.88343452,-0.93338811,0.26073213,1.5222767,-0.88382445,-0.93227249,0.25849007,1.5192223,-0.88382445,-0.93227249,0.26521626,1.5211719,-0.88379195,-0.92106218,0.3022157,1.5166986,-0.88357533,-0.93338811,0.26858477,1.5208686,-0.88378112,-0.91320954,0.33697308,1.521876,-0.88338037,-0.93227249,0.26073213,1.5199913,-0.88381362,-0.92778836,0.26858477,1.5119654,-0.88374863,-0.92666192,0.28203714,1.5199047,-0.88369447,-0.89975717,0.36613072,1.5132651,-0.8831854,-0.92666192,0.27306889,1.5131785,-0.88372697,-0.93338811,0.25400594,1.5139042,-0.88383528,-0.93227249,0.26410064,1.5205112,-0.88379195,-0.93563017,0.2528795,1.513146,-0.88384611,-0.93227249,0.25400594,1.5183558,-0.88384611,-0.93003043,0.26745832,1.5169153,-0.88375946,-0.93451455,0.2528795,1.5115971,-0.88384611,-0.93451455,0.2528795,1.5190165,-0.88385694,-0.9120831,0.31342601,1.5150739,-0.88347785,-0.92666192,0.26521626,1.5132976,-0.88377029,-0.93227249,0.2528795,1.5174027,-0.88385694,-0.91432516,0.30334215,1.5113913,-0.88354284,-0.93227249,0.24615331,1.5199372,-0.88390027,-0.93003043,0.2528795,1.5135901,-0.88385694,-0.92778836,0.25960568,1.5097342,-0.88380278,-0.91882012,0.2842792,1.5123661,-0.88366198,-0.87846299,0.44237167,1.5115213,-0.88277382,-0.93114604,0.2528795,1.512312,-0.88384611,-0.92890398,0.25624801,1.5099399,-0.88381362,-0.93227249,0.24391125,1.5132326,-0.88388943,-0.92666192,0.24727976,1.509745,-0.88383528,-0.93003043,0.26073213,1.5184208,-0.88379195,-0.93003043,0.24952182,1.5150848,-0.88384611,-0.92106218,0.28763688,1.5152689,-0.88362948,-0.92778836,0.26858477,1.514944,-0.88375946,-0.92217779,0.27194244,1.5124745,-0.88371613,-0.92778836,0.24839537,1.5122253,-0.88384611,-0.92890398,0.25960568,1.5135034,-0.88379195,-0.93003043,0.26297419,1.5204787,-0.88382445,-0.93338811,0.24727976,1.5215185,-0.88390027,-0.93675661,0.24727976,1.5257969,-0.88392193,-0.92441986,0.29548951,1.525147,-0.88367281,-0.93114604,0.26521626,1.5273457,-0.88383528,-0.93338811,0.25176388,1.5261976,-0.8839111,-0.93114604,0.25063744,1.5158646,-0.88390027,-0.91656722,0.30445776,1.5187457,-0.88359699,-0.92890398,0.26858477,1.519114,-0.88380278,-0.91882012,0.32576277,1.5189299,-0.88346702,-0.93338811,0.27306889,1.5187241,-0.88378112,-0.93003043,0.27194244,1.5194606,-0.88377029,-0.91656722,0.27418451,1.5200996,-0.88371613,-0.91545161,0.27418451,1.5183883,-0.8837053,-0.91769367,0.26970038,1.5138933,-0.88372697,-0.91882012,0.27194244,1.5186158,-0.88372697,-0.91993573,0.27306889,1.5212694,-0.88371613,-0.91882012,0.27194244,1.5193739,-0.88372697,-0.91993573,0.27194244,1.5160163,-0.88371613,-0.90648336,0.31791014,1.5156697,-0.88345619,-0.91769367,0.27866863,1.5068206,-0.88368364,-0.91769367,0.27082683,1.5042536,-0.88371613,-0.91545161,0.27306889,1.5075571,-0.88369447,-0.91432516,0.27194244,1.500181,-0.88369447,-0.91320954,0.27306889,1.5049793,-0.88369447,-0.91432516,0.26970038,1.5066364,-0.88372697,-0.9120831,0.27082683,1.5028563,-0.88369447,-0.91432516,0.27082683,1.4998236,-0.88369447,-0.9120831,0.27082683,1.5007876,-0.8837053,-0.90872542,0.27082683,1.503452,-0.88369447,-0.91096748,0.27082683,1.5061382,-0.8837053,-0.89638866,0.32688922,1.5057699,-0.8833912,-0.91432516,0.27531095,1.5124311,-0.8837053,-0.91432516,0.26970038,1.5136767,-0.8837378,-0.9120831,0.28203714,1.5150415,-0.88367281,-0.91320954,0.27082683,1.5142833,-0.88372697,-0.91545161,0.27418451,1.5144782,-0.88371613,-0.91545161,0.27306889,1.5169153,-0.88372697,-0.91545161,0.27194244,1.5162654,-0.88372697,-0.91769367,0.27082683,1.5162979,-0.8837378,-0.91656722,0.27755301,1.5141966,-0.88369447,-0.91882012,0.27642657,1.5063332,-0.8837053,-0.91882012,0.27194244,1.5110881,-0.8837378,-0.90424129,0.32688922,1.5126261,-0.88342369,-0.91882012,0.27866863,1.5144024,-0.8837053,-0.91432516,0.27306889,1.5239447,-0.88374863,-0.91545161,0.27755301,1.5208037,-0.88371613,-0.91545161,0.27082683,1.5230132,-0.88374863,-0.9120831,0.26970038,1.5148682,-0.88372697,-0.91096748,0.28091069,1.5137309,-0.88367281,-0.91656722,0.27306889,1.5204246,-0.8837378,-0.91320954,0.27306889,1.5178359,-0.88371613,-0.91320954,0.27418451,1.5147923,-0.88371613,-0.91096748,0.27082683,1.5107956,-0.8837053,-0.90984104,0.29100539,1.5147382,-0.88360782,-0.90311485,0.3123104,1.5082178,-0.88347785,-0.9120831,0.27194244,1.5147057,-0.88372697,-0.90984104,0.27306889,1.512182,-0.88371613,-0.9120831,0.27082683,1.515009,-0.8837378,-0.91096748,0.27418451,1.5144891,-0.88371613,-0.9120831,0.27082683,1.5122145,-0.88372697,-0.90984104,0.27194244,1.5135034,-0.8837053,-0.90872542,0.27755301,1.5144891,-0.88368364,-0.9120831,0.28091069,1.5227966,-0.88368364,-0.91545161,0.27194244,1.5126044,-0.8837378,-0.91432516,0.27194244,1.5113047,-0.88372697,-0.86949474,0.4188246,1.507817,-0.88281714,-0.9120831,0.27418451,1.5111097,-0.8837053,-0.91432516,0.26970038,1.5110231,-0.8837378,-0.9120831,0.27306889,1.5103624,-0.88372697,-0.9120831,0.26970038,1.510579,-0.88372697,-0.91545161,0.27642657,1.5191465,-0.8837053,-0.91432516,0.27531095,1.5166445,-0.8837053,-0.91432516,0.27418451,1.5203163,-0.88371613,-0.91320954,0.28652126,1.5184749,-0.88365115,-0.91432516,0.27306889,1.5136984,-0.88371613,-0.9120831,0.27531095,1.5104815,-0.88369447,-0.91545161,0.26858477,1.5122578,-0.8837378,-0.91656722,0.27306889,1.5128535,-0.88371613,-0.91432516,0.27979508,1.511608,-0.88367281,-0.91545161,0.27418451,1.5066364,-0.88369447,-0.91545161,0.27194244,1.502174,-0.88368364,-0.91545161,0.27418451,1.5076762,-0.88368364,-0.91545161,0.27642657,1.5158105,-0.88369447,-0.91882012,0.27082683,1.5157238,-0.88371613,-0.91769367,0.27194244,1.5110014,-0.88369447,-0.91545161,0.27082683,1.5185724,-0.88371613,-0.91656722,0.27082683,1.5192006,-0.8837378,-0.91656722,0.27194244,1.5169044,-0.88372697,-0.91769367,0.26970038,1.5217893,-0.88374863,-0.91769367,0.27531095,1.5221034,-0.88372697,-0.91432516,0.28091069,1.5196772,-0.88369447,-0.91432516,0.27866863,1.5228616,-0.88369447,-0.91882012,0.27306889,1.5200996,-0.88372697,-0.91882012,0.27306889,1.5255802,-0.88374863,-0.92217779,0.26745832,1.5192331,-0.88377029,-0.91769367,0.26970038,1.5127452,-0.8837378,-0.92106218,0.26970038,1.5183341,-0.88375946,-0.92330424,0.26858477,1.525017,-0.88377029,-0.91993573,0.27642657,1.5208903,-0.88372697,-0.92106218,0.27194244,1.5188432,-0.88374863,-0.92106218,0.27418451,1.5200346,-0.88372697,-0.91993573,0.27194244,1.519688,-0.88374863,-0.91769367,0.28315275,1.5221251,-0.88369447,-0.91882012,0.27418451,1.5164387,-0.88372697,-0.91993573,0.27082683,1.5138284,-0.88374863,-0.91656722,0.27642657,1.5100808,-0.88369447,-0.91320954,0.27418451,1.5054558,-0.88368364,-0.90759897,0.2943739,1.5110989,-0.88358616,-0.91882012,0.27306889,1.5076762,-0.8837053,-0.91432516,0.27418451,1.5082286,-0.88369447,-0.92217779,0.27082683,1.5134168,-0.8837378,-0.92330424,0.2663427,1.5170561,-0.88377029,-0.91882012,0.27194244,1.5108173,-0.8837378,-0.91882012,0.27194244,1.5161896,-0.8837378,-0.91432516,0.28763688,1.5146407,-0.88365115,-0.91769367,0.27531095,1.5163954,-0.88372697,-0.91769367,0.27531095,1.5181392,-0.88372697,-0.91656722,0.27642657,1.5164495,-0.88371613,-0.91656722,0.27418451,1.5165687,-0.88372697,-0.91882012,0.27531095,1.5238797,-0.8837378,-0.91882012,0.27642657,1.5075246,-0.88371613,-0.91432516,0.27082683,1.5089326,-0.88372697,-0.91096748,0.27531095,1.5086944,-0.8837053,-0.90759897,0.27082683,1.5091601,-0.88371613,-0.9120831,0.27306889,1.5075787,-0.88371613,-0.91096748,0.27531095,1.5087052,-0.8837053,-0.90984104,0.28539482,1.5094742,-0.88366198,-0.9120831,0.27642657,1.5092684,-0.88371613,-0.91432516,0.27194244,1.5125178,-0.8837378,-0.91432516,0.27418451,1.5134601,-0.88372697,-0.91432516,0.27306889,1.5103732,-0.88372697,-0.91656722,0.27306889,1.5168828,-0.88372697,-0.90984104,0.27642657,1.5042861,-0.88369447,-0.91545161,0.27194244,1.5133193,-0.88374863,-0.91656722,0.27306889,1.5123445,-0.8837378,-0.91545161,0.27642657,1.5128427,-0.88371613,-0.91769367,0.27194244,1.5148465,-0.88374863,-0.91656722,0.26970038,1.5124311,-0.88375946,-0.91545161,0.27979508,1.5112505,-0.88369447,-0.91769367,0.27306889,1.5155397,-0.8837378,-0.91993573,0.27306889,1.5120087,-0.8837378,-0.91545161,0.27082683,1.5120087,-0.8837378,-0.9120831,0.27306889,1.5059432,-0.8837053,-0.91432516,0.27755301,1.511478,-0.8837053,-0.91656722,0.27306889,1.5104923,-0.88372697,-0.91656722,0.27194244,1.5081203,-0.88371613,-0.91545161,0.27531095,1.507113,-0.8837053,-0.91545161,0.27979508,1.506019,-0.88367281,-0.91320954,0.27642657,1.5079037,-0.88367281,-0.91545161,0.27531095,1.510644,-0.88369447,-0.90535691,0.31006833,1.5116838,-0.88351034,-0.91320954,0.27642657,1.5134059,-0.8837053,-0.91432516,0.27418451,1.5167311,-0.88372697,-0.91432516,0.27418451,1.5169694,-0.88372697,-0.91545161,0.27418451,1.5190815,-0.88372697,-0.91320954,0.2663427,1.5145649,-0.88375946,-0.9120831,0.27642657,1.5162004,-0.8837053,-0.91320954,0.26970038,1.5026397,-0.88371613,-0.91545161,0.27082683,1.516287,-0.88372697,-0.91545161,0.27531095,1.5187241,-0.88372697,-0.91769367,0.27194244,1.5144349,-0.8837378,-0.91656722,0.27306889,1.5162221,-0.88372697,-0.91320954,0.28315275,1.513276,-0.88367281,-0.91656722,0.27531095,1.5167311,-0.88372697,-0.91993573,0.27306889,1.5157347,-0.8837378,-0.9120831,0.27866863,1.5090085,-0.88367281,-0.92106218,0.27194244,1.5139692,-0.8837378,-0.91769367,0.27194244,1.5177493,-0.88372697,-0.91320954,0.27306889,1.5155722,-0.8837053,-0.91656722,0.27306889,1.5125069,-0.88372697,-0.91320954,0.27082683,1.5145324,-0.88371613,-0.91432516,0.27194244,1.5187891,-0.88372697,-0.91545161,0.26970038,1.5136334,-0.88372697,-0.91882012,0.26970038,1.5204896,-0.88374863,-0.91320954,0.28091069,1.5137092,-0.88369447,-0.91545161,0.26073213,1.4921009,-0.88372697,-0.91769367,0.26745832,1.494982,-0.88369447,-0.91432516,0.27194244,1.4912994,-0.88366198,-0.91320954,0.26410064,1.4890249,-0.88369447,-0.91993573,0.27642657,1.4998128,-0.88365115,-0.91656722,0.28652126,1.5006143,-0.88360782,-0.93003043,0.27531095,1.4958485,-0.88367281,-0.93114604,0.27642657,1.5021306,-0.88365115,-0.93003043,0.27418451,1.497679,-0.88369447,-0.91656722,0.27531095,1.4998994,-0.88368364,-0.92441986,0.27418451,1.5033762,-0.88367281,-0.92666192,0.27755301,1.5014483,-0.88366198,-0.91432516,0.27979508,1.5032463,-0.88361865,-0.91545161,0.27082683,1.514619,-0.8837378,-0.91656722,0.27306889,1.5118137,-0.88371613,-0.91993573,0.27082683,1.5174568,-0.88374863,-0.91993573,0.26970038,1.5171752,-0.88375946,-0.92217779,0.27082683,1.5192006,-0.88374863,-0.91993573,0.26970038,1.5198613,-0.88375946,-0.91656722,0.26970038,1.5198722,-0.88377029,-0.91769367,0.26970038,1.5161787,-0.88374863,-0.91769367,0.26970038,1.5144132,-0.88374863,-0.91882012,0.27306889,1.5196014,-0.88374863,-0.91320954,0.29213184,1.518919,-0.88362948,-0.91993573,0.27306889,1.5161787,-0.8837378,-0.91993573,0.26970038,1.5160379,-0.88374863,-0.91882012,0.27306889,1.5146299,-0.88372697,-0.91882012,0.26858477,1.5128969,-0.88374863,-0.91882012,0.27082683,1.5124745,-0.8837378,-0.91882012,0.27082683,1.5124745,-0.8837378,-0.91882012,0.27082683,1.5124745,-0.8837378,-0.91882012,0.27082683,1.5124745,-0.8837378,-0.91882012,0.27082683,1.5124745,-0.8837378,-0.91882012,0.27082683,1.5124745,-0.8837378,-0.91882012,0.27082683,1.5124745,-0.8837378:4
0.92478509,0.41412334,1.385312,-0.89332089,0.92160257,0.41412334,1.3833229,-0.89333109,0.92266341,0.41625522,1.3838941,-0.89333109,0.92160257,0.41200166,1.3833535,-0.89334129,0.90992313,0.40987998,1.3772435,-0.89334129,0.90992313,0.41519438,1.3774067,-0.89333109,0.90992313,0.40669746,1.3774577,-0.89335149,0.91204481,0.4077583,1.3786613,-0.89334129,0.91204481,0.40881914,1.3786919,-0.89334129,0.90886229,0.40881914,1.3772333,-0.89335149,0.91098397,0.40351494,1.3779167,-0.89336169,0.90673041,0.40139326,1.3756114,-0.89338209,0.91204481,0.40457578,1.3784981,-0.89335149,0.91098397,0.40881914,1.3783961,-0.89334129,0.90354789,0.4024541,1.3749688,-0.89338209,0.89612201,0.39501802,1.3707254,-0.89339229,0.90354789,0.3971397,1.3748668,-0.89340249,0.90460873,0.40032222,1.3755706,-0.89339229,0.90142621,0.39289634,1.3738365,-0.89342289,0.90142621,0.39289634,1.3734897,-0.89342289,0.90780145,0.39820054,1.376713,-0.89338209,0.91098397,0.39289634,1.3790387,-0.89338209,0.90780145,0.40032222,1.3771721,-0.89337189,0.91098397,0.38865298,1.3787327,-0.89339229,0.91098397,0.3918355,1.3781921,-0.89339229,0.91204481,0.38546026,1.3790081,-0.89340249,0.91628817,0.38227774,1.3817622,-0.89343309,0.91947069,0.3812169,1.3836901,-0.89343309,0.91840985,0.38227774,1.3833229,-0.89343309,0.91947069,0.38015606,1.3837411,-0.89343309,0.91947069,0.38758194,1.3836085,-0.89341269,0.91947069,0.38227774,1.3839247,-0.89342289,0.92160257,0.37909522,1.3850773,-0.89342289,0.91416649,0.3812169,1.3811298,-0.89340249,0.91416649,0.37909522,1.3813338,-0.89341269,-0.90125679,-0.80464896,1.3838533,-0.90293985,-0.90125679,-0.80358812,1.3848937,-0.90293985,-0.90125679,-0.80358812,1.3863524,-0.90293985,-0.90125679,-0.80358812,1.3860464,-0.90293985,-0.90125679,-0.80358812,1.3851794,-0.90293985,-0.90125679,-0.80358812,1.3855772,-0.90293985,-0.90125679,-0.80358812,1.3857812,-0.90293985,-0.90125679,-0.80358812,1.3862708,-0.90293985,-0.90125679,-0.80358812,1.3849447,-0.90293985,-0.90125679,-0.80358812,1.3872704,-0.90293985,-0.90125679,-0.80358812,1.3876886,-0.90293985,-0.90125679,-0.80358812,1.3880253,-0.90293985,-0.90125679,-0.80358812,1.3869848,-0.90293985,-0.90125679,-0.80358812,1.3889535,-0.90293985,-0.90125679,-0.80358812,1.3870868,-0.90293985,-0.90125679,-0.80358812,1.3842715,-0.90293985,-0.90125679,-0.80358812,1.3853834,-0.90293985,-0.90125679,-0.80464896,1.3697054,-0.90293985,-0.90125679,-0.80464896,1.3833025,-0.90293985,-0.90125679,-0.80358812,1.3844143,-0.90293985,-0.90125679,-0.80358812,1.3842817,-0.90293985,-0.90125679,-0.80358812,1.3852406,-0.90293985,-0.90125679,-0.80464896,1.3841695,-0.90293985,-0.90125679,-0.80464896,1.3813236,-0.90293985,-0.90125679,-0.80464896,1.3815684,-0.90293985,-0.90125679,-0.80464896,1.3833943,-0.90293985,-0.90125679,-0.80464896,1.3834963,-0.90293985,-0.90125679,-0.80464896,1.3778657,-0.90293985,-0.90125679,-0.80464896,1.3774577,-0.90293985,-0.90125679,-0.80464896,1.3779881,-0.90293985,-0.90125679,-0.80464896,1.3762438,-0.90293985,-0.90125679,-0.80464896,1.3761724,-0.90293985,-0.90125679,-0.80464896,1.376968,-0.90293985,-0.90125679,-0.80464896,1.3773455,-0.90293985,-0.90125679,-0.80464896,1.3782941,-0.90293985,-0.90125679,-0.80464896,1.3751524,-0.90293985,-0.90125679,-0.80464896,1.3752544,-0.90293985,-0.90125679,-0.80464896,1.3745404,-0.90293985,-0.90125679,-0.80464896,1.3762234,-0.90293985,-0.90125679,-0.80464896,1.3742751,-0.90293985,-0.90125679,-0.80464896,1.3751218,-0.90293985,-0.90125679,-0.80464896,1.3813746,-0.90293985,-0.90125679,-0.80464896,1.3825885,-0.90293985,-0.90125679,-0.80464896,1.3772333,-0.90293985,-0.90125679,-0.80464896,1.3814256,-0.90293985,-0.90125679,-0.80464896,1.3799976,-0.90293985,-0.90125679,-0.80464896,1.381242,-0.90293985,-0.90125679,-0.80464896,1.3794977,-0.90293985,-0.90125679,-0.80464896,1.3802322,-0.90293985,-0.90125679,-0.80464896,1.3831495,-0.90293985,-0.90125679,-0.80358812,1.386128,-0.90293985,-0.90125679,-0.80464896,1.3784675,-0.90293985,-0.90125679,-0.80464896,1.3802424,-0.90293985,-0.90125679,-0.80464896,1.3794569,-0.90293985,-0.90125679,-0.80358812,1.3866584,-0.90293985,-0.90125679,-0.80358812,1.3857812,-0.90293985,-0.90125679,-0.80358812,1.3851283,-0.90293985,-0.90125679,-0.80464896,1.3853426,-0.90293985,-0.90125679,-0.80464896,1.3824762,-0.90293985,-0.90125679,-0.80464896,1.3821702,-0.90293985,-0.90125679,-0.80464896,1.380885,-0.90293985,-0.90125679,-0.80464896,1.3832209,-0.90293985,-0.90125679,-0.80464896,1.3829659,-0.90293985,-0.90125679,-0.80464896,1.3830679,-0.90293985,-0.90125679,-0.80464896,1.3848529,-0.90293985,-0.90125679,-0.80358812,1.3849243,-0.90293985,-0.90125679,-0.80358812,1.3855976,-0.90293985,-0.90125679,-0.80358812,1.3850773,-0.90293985,-0.90125679,-0.80464896,1.3843429,-0.90293985,-0.90125679,-0.80358812,1.3856384,-0.90293985,-0.90125679,-0.80358812,1.38776,-0.90293985,-0.90125679,-0.80358812,1.3854548,-0.90293985,-0.90125679,-0.80464896,1.3827415,-0.90293985,-0.90125679,-0.80464896,1.3832005,-0.90293985,-0.90125679,-0.80358812,1.3848631,-0.90293985,-0.90125679,-0.80358812,1.3849753,-0.90293985,-0.90125679,-0.80464896,1.3847101,-0.90293985,-0.90125679,-0.80464896,1.3841899,-0.90293985,-0.90125679,-0.80464896,1.3836901,-0.90293985,-0.90125679,-0.80358812,1.3850263,-0.90293985,-0.90125679,-0.80358812,1.3853018,-0.90293985,-0.90125679,-0.80464896,1.3859036,-0.90293985,-0.90125679,-0.80358812,1.3880457,-0.90293985,-0.90125679,-0.80358812,1.3857608,-0.90293985,-0.90125679,-0.80358812,1.3848835,-0.90293985,-0.90125679,-0.80358812,1.3847815,-0.90293985,-0.90125679,-0.80358812,1.3882395,-0.90293985,-0.90125679,-0.80464896,1.3816092,-0.90293985,-0.90125679,-0.80464896,1.3806606,-0.90293985,-0.90125679,-0.80464896,1.3852712,-0.90293985,-0.90125679,-0.80358812,1.3869236,-0.90293985,-0.90125679,-0.80358812,1.386485,-0.90293985,-0.90125679,-0.80358812,1.3854548,-0.90293985,-0.90125679,-0.80464896,1.3840573,-0.90293985,-0.90125679,-0.80358812,1.3845265,-0.90293985,-0.90125679,-0.80464896,1.3803954,-0.90293985,-0.90125679,-0.80464896,1.3792223,-0.90293985,-0.90125679,-0.80464896,1.3831699,-0.90293985,-0.90125679,-0.80464896,1.3826905,-0.90293985,-0.90125679,-0.80464896,1.382007,-0.90293985,-0.90125679,-0.80464896,1.3819866,-0.90293985,-0.90125679,-0.80464896,1.3831801,-0.90293985,-0.90125679,-0.80464896,1.3825885,-0.90293985,-0.90125679,-0.80464896,1.3819152,-0.90293985,-0.90125679,-0.80464896,1.3837003,-0.90293985,-0.90125679,-0.80464896,1.3826191,-0.90293985,-0.90125679,-0.80358812,1.3830679,-0.90293985,-0.90125679,-0.80358812,1.3837003,-0.90293985,-0.90125679,-0.80464896,1.3840981,-0.90293985,-0.90125679,-0.80464896,1.3836493,-0.90293985,-0.90125679,-0.80358812,1.3854038,-0.90293985,-0.90125679,-0.80358812,1.385465,-0.90293985,-0.90125679,-0.80464896,1.3830781,-0.90293985,-0.90125679,-0.80358812,1.3847815,-0.90293985,-0.90125679,-0.80358812,1.387403,-0.90293985,-0.90125679,-0.80358812,1.3882293,-0.90293985,-0.90125679,-0.80358812,1.3888923,-0.90293985,-0.90125679,-0.80358812,1.3889025,-0.90293985,-0.90125679,-0.80358812,1.3881375,-0.90293985,-0.90125679,-0.80358812,1.3870052,-0.90293985,-0.90125679,-0.80358812,1.3863932,-0.90293985,-0.90125679,-0.80358812,1.3868216,-0.90293985,-0.90125679,-0.80358812,1.3879641,-0.90293985,-0.90125679,-0.80358812,1.3868522,-0.90293985,-0.90125679,-0.80358812,1.387148,-0.90293985,-0.90125679,-0.80358812,1.3872806,-0.90293985,-0.90125679,-0.80464896,1.374826,-0.90293985,-0.90125679,-0.80464896,1.376152,-0.90293985,-0.90125679,-0.80464896,1.3745404,-0.90293985,-0.90125679,-0.8057098,1.3622999,-0.90293985,-0.90125679,-0.8057098,1.3630445,-0.90293985,-0.90125679,-0.8057098,1.3620041,-0.90293985,-0.90125679,-0.8057098,1.3615757,-0.90293985,-0.90125679,-0.80677064,1.3605658,-0.90295005,-0.90125679,-0.80464896,1.3748362,-0.90293985,-0.90125679,-0.80464896,1.3739487,-0.90293985,-0.90125679,-0.80464896,1.375591,-0.90293985,-0.90125679,-0.80464896,1.3735203,-0.90293985,-0.90125679,-0.80464896,1.374775,-0.90293985,-0.90125679,-0.80464896,1.3743873,-0.90293985,-0.90125679,-0.80464896,1.3758256,-0.90293985,-0.90125679,-0.80464896,1.3744894,-0.90293985,-0.90125679,-0.80464896,1.3759174,-0.90293985,-0.90125679,-0.80464896,1.3753972,-0.90293985,-0.90125679,-0.80464896,1.3753972,-0.90293985,-0.90125679,-0.80464896,1.376764,-0.90293985,-0.90125679,-0.80464896,1.374622,-0.90293985,-0.90125679,-0.80464896,1.3780799,-0.90293985,-0.90125679,-0.80464896,1.3791203,-0.90293985,-0.90125679,-0.80464896,1.3788041,-0.90293985,0.91098397,0.60947086,1.3754584,-0.89279047,0.91098397,0.61690694,1.3751014,-0.89277007,0.91098397,0.6052275,1.3758766,-0.89280067,0.90992313,0.58186863,1.3760602,-0.89287207,0.91204481,0.59673059,1.3757236,-0.89283127,0.91098397,0.59354807,1.376356,-0.89283127,0.90354789,0.59460891,1.3725309,-0.89285167,0.90780145,0.59142639,1.3755298,-0.89285167,0.90566957,0.58080779,1.3742547,-0.89288227,0.90886229,0.57231087,1.3747954,-0.89290267,0.90992313,0.56594583,1.3758154,-0.89292307,0.90992313,0.56382415,1.3758256,-0.89292307,0.91098397,0.55957059,1.3769782,-0.89293327,0.91310565,0.55532723,1.3777229,-0.89294348,0.90886229,0.55426639,1.375846,-0.89296388,0.91098397,0.55002303,1.3768048,-0.89296388,0.91628817,0.55320555,1.379967,-0.89293327,0.90780145,0.55214471,1.3749892,-0.89296388,0.90248705,0.54790135,1.3726125,-0.89299448,0.89930453,0.54258696,1.3707662,-0.89297408,0.90886229,0.54258696,1.3756624,-0.89298428,0.90780145,0.54046528,1.37554,-0.89299448,0.90886229,0.53622192,1.3759174,-0.89300468,0.90673041,0.53409004,1.3751218,-0.89301488,0.90886229,0.52878584,1.3759072,-0.89302508,0.89186845,0.52135996,1.3662882,-0.89305568,0.89292929,0.51604556,1.3669921,-0.89307608,0.89506117,0.51074136,1.3685527,-0.89307608,0.89506117,0.50968052,1.3683895,-0.89307608,0.89824369,0.50754864,1.3705622,-0.89307608,0.89824369,0.50436612,1.3703888,-0.89308628,0.89612201,0.5011836,1.3691341,-0.89309648,0.89718285,0.49694024,1.3700522,-0.89310668,0.89930453,0.49694024,1.3714496,-0.89314748,0.89930453,0.49374752,1.3713068,-0.89315768,0.89930453,0.49694024,1.3711028,-0.89310668,0.89930453,0.49374752,1.3709702,-0.89310668,0.89718285,0.48207829,1.3707458,-0.89314748,0.89930453,0.47888557,1.3711436,-0.89314748,0.89292929,0.47782473,1.3682467,-0.89317808,0.89186845,0.47782473,1.3676551,-0.89317808,0.88974677,0.47252053,1.3664004,-0.89319848,0.88762509,0.47252053,1.3652376,-0.89320869,0.88762509,0.46508445,1.3654008,-0.89322909,0.89292929,0.46827717,1.3681141,-0.89319848,0.89506117,0.46190193,1.3688893,-0.89320869,0.89718285,0.46614529,1.371011,-0.89319848,0.89186845,0.46508445,1.3679917,-0.89321889,0.88868593,0.45659773,1.3661352,-0.89324949,0.89400033,0.46190193,1.3688485,-0.89321889,0.89400033,0.45553689,1.3685425,-0.89322909,0.90354789,0.45022249,1.3743159,-0.89325969,0.90248705,0.45128333,1.3737141,-0.89325969,0.91098397,0.44703997,1.3785185,-0.89323929,0.91098397,0.44597913,1.3787531,-0.89324949,0.90780145,0.44066473,1.3768252,-0.89326989,0.90354789,0.43536053,1.3748668,-0.89330049,0.90673041,0.43854305,1.3762234,-0.89328009,0.90992313,0.43748221,1.3781411,-0.89326989,0.90460873,0.44066473,1.3756012,-0.89328009,0.90354789,0.43323885,1.3748566,-0.89330049,0.90673041,0.43111718,1.3769782,-0.89330049,0.90780145,0.42686362,1.3773353,-0.89331069,0.90780145,0.42155942,1.3775495,-0.89332089,0.90886229,0.4183769,1.3775597,-0.89332089,0.90354789,0.41731606,1.3753156,-0.89335149,0.90992313,0.4183769,1.3784471,-0.89332089,0.91204481,0.42049858,1.3799364,-0.89331069,0.90886229,0.41731606,1.3781615,-0.89333109,0.90992313,0.41731606,1.3783451,-0.89332089,0.90886229,0.41625522,1.3778657,-0.89333109,0.90780145,0.41094082,1.3773047,-0.89335149,0.90673041,0.41412334,1.3766212,-0.89334129,0.90780145,0.41200166,1.3777637,-0.89334129,0.90566957,0.40669746,1.3765396,-0.89337189,0.90992313,0.40563662,1.3790897,-0.89335149,0.91098397,0.40351494,1.3783961,-0.89336169,0.90886229,0.40457578,1.3785389,-0.89336169,0.90780145,0.40457578,1.3779473,-0.89336169,0.90992313,0.39926138,1.3794569,-0.89337189,0.90566957,0.5383436,1.3785899,-0.89300468,0.90886229,0.3971397,1.3790693,-0.89338209,0.90886229,0.4024541,1.3790591,-0.89336169,0.90780145,0.39501802,1.3788755,-0.89339229,0.91098397,0.39607886,1.3798956,-0.89338209,0.90886229,0.3918355,1.3785083,-0.89340249,0.90780145,0.38971382,1.3778453,-0.89340249,0.91416649,0.39077466,1.3813032,-0.89337189,0.91416649,0.39077466,1.3816194,-0.89342289,0.91204481,0.39607886,1.3802526,-0.89337189,0.91204481,0.39501802,1.3807626,-0.89337189,0.90673041,0.39077466,1.3780595,-0.89340249,0.90354789,0.39077466,1.3760704,-0.89341269,0.90673041,0.38333858,1.3775393,-0.89342289,0.91098397,0.38546026,1.3802322,-0.89340249,0.90780145,0.38758194,1.3786409,-0.89341269,0.90460873,0.38439942,1.3768456,-0.89343309,0.90673041,0.38546026,1.3782737,-0.89342289,0.90566957,0.3865211,1.3779779,-0.89342289,0.90992313,0.38227774,1.3795283,-0.89341269,0.91204481,0.3865211,1.3808748,-0.89340249,0.91204481,0.38227774,1.3812522,-0.89341269,0.90673041,0.37485187,1.3779983,-0.89344329,0.90460873,0.37697354,1.3768966,-0.89345349,0.90780145,0.37378083,1.3787633,-0.89344329,0.91204481,0.37059831,1.3811298,-0.89344329,0.90992313,0.37378083,1.3795589,-0.89344329,0.90992313,0.37271999,1.3794569,-0.89344329,0.91098397,0.37059831,1.3799976,-0.89344329,0.91310565,0.36529411,1.3816092,-0.8934943,0.69759197,0.21772517,1.3909018,-0.89465714,-0.90125679,-0.80358812,1.3934621,-0.90293985,-0.90125679,-0.80358812,1.3922686,-0.90293985,-0.90125679,-0.80358812,1.3890861,-0.90293985,-0.90125679,-0.80358812,1.3884435,-0.90293985,-0.90125679,-0.80358812,1.3920748,-0.90293985,-0.90125679,-0.80358812,1.390708,-0.90293985,-0.90125679,-0.80358812,1.3945637,-0.90293985,-0.90125679,-0.80358812,1.3910038,-0.90293985,-0.90125679,-0.80358812,1.3894329,-0.90293985,-0.90125679,-0.80358812,1.3893615,-0.90293985,-0.90125679,-0.80358812,1.3882497,-0.90293985,-0.90125679,-0.80358812,1.3881375,-0.90293985,-0.90125679,-0.80358812,1.3878008,-0.90293985,-0.90125679,-0.80358812,1.3900959,-0.90293985,-0.90125679,-0.80358812,1.3914628,-0.90293985,-0.90125679,-0.80358812,1.39285,-0.90293985,-0.90125679,-0.80358812,1.3905244,-0.90293985,-0.90125679,-0.80358812,1.3929214,-0.90293985,-0.90125679,-0.80358812,1.3928806,-0.90293985,-0.90125679,-0.80358812,1.392238,-0.90293985,-0.90125679,-0.80358812,1.3904121,-0.90293985,-0.90125679,-0.80464896,1.375846,-0.90293985,-0.90125679,-0.80358812,1.3940333,-0.90293985,-0.90125679,-0.80358812,1.3955735,-0.90293985,-0.90125679,-0.80358812,1.3970118,-0.90293985,-0.90125679,-0.80358812,1.3950023,-0.90293985,-0.90125679,-0.80252728,1.3977768,-0.90293985,-0.90125679,-0.80252728,1.3962162,-0.90293985,-0.90125679,-0.80358812,1.3955225,-0.90293985,-0.90125679,-0.80358812,1.3941557,-0.90293985,-0.90125679,-0.80358812,1.3941863,-0.90293985,-0.90125679,-0.80358812,1.3935131,-0.90293985,-0.90125679,-0.80358812,1.3943903,-0.90293985,-0.90125679,-0.80358812,1.392085,-0.90293985,-0.90125679,-0.80358812,1.3916362,-0.90293985,-0.90125679,-0.80358812,1.3907998,-0.90293985,-0.90125679,-0.80358812,1.3935641,-0.90293985,-0.90125679,-0.80358812,1.3935845,-0.90293985,-0.90125679,-0.80252728,1.3954205,-0.90293985,-0.90125679,-0.80464896,1.3766416,-0.90293985,-0.90125679,-0.80358812,1.3943801,-0.90293985,-0.90125679,-0.80358812,1.3934621,-0.90293985,-0.90125679,-0.80358812,1.3947167,-0.90293985,-0.90125679,-0.80358812,1.3939721,-0.90293985,-0.90125679,-0.80358812,1.3953287,-0.90293985,-0.90125679,-0.80358812,1.3933193,-0.90293985,-0.90125679,-0.80358812,1.3923706,-0.90293985,-0.90125679,-0.80358812,1.392238,-0.90293985,-0.90125679,-0.80358812,1.3919422,-0.90293985,-0.90125679,-0.80358812,1.3925848,-0.90293985,-0.90125679,-0.80358812,1.3908814,-0.90293985,-0.90231763,-0.65814087,1.3900449,-0.90228703,-0.90231763,-0.65814087,1.3905856,-0.90228703,-0.90125679,-0.80358812,1.3901775,-0.90293985,-0.90125679,-0.80358812,1.3884231,-0.90293985,-0.90125679,-0.80358812,1.3933907,-0.90293985,-0.90125679,-0.80358812,1.3919728,-0.90293985,-0.90125679,-0.80358812,1.390963,-0.90293985,-0.90125679,-0.80358812,1.3905448,-0.90293985,-0.90125679,-0.80358812,1.3896675,-0.90293985,-0.90125679,-0.80358812,1.3899735,-0.90293985,-0.90125679,-0.80358812,1.3904529,-0.90293985,-0.90125679,-0.80358812,1.3899939,-0.90293985,-0.90125679,-0.80358812,1.3901061,-0.90293985,-0.90125679,-0.80358812,1.3901061,-0.90293985,-0.90125679,-0.80358812,1.3901061,-0.90293985,-0.90125679,-0.80358812,1.3901061,-0.90293985,-0.90125679,-0.80358812,1.3901061,-0.90293985,-0.90125679,-0.80358812,1.3901061,-0.90293985:0
-0.68337663,-0.68337663,1.7137391,-0.68337663,-0.68337663,-0.68337663,1.7150536,-0.68337663,-0.68337663,-0.68337663,1.7115449,-0.68337663,-0.68337663,-0.68337663,1.7131802,-0.68337663,-0.68337663,-0.68337663,1.7141014,-0.68337663,-0.68337663,-0.68337663,1.7072496,-0.68337663,-0.68337663,-0.68337663,1.709951,-0.68337663,-0.68337663,-0.68337663,1.7125592,-0.68337663,-0.68337663,-0.68337663,1.7092264,-0.68337663,-0.68337663,-0.68337663,1.7172789,-0.68337663,-0.68337663,-0.68337663,1.7146603,-0.68337663,-0.68337663,-0.68337663,1.7133665,-0.68337663,-0.68337663,-0.68337663,1.7156642,-0.68337663,-0.68337663,-0.68337663,1.7174859,-0.68337663,-0.68337663,-0.68337663,1.7201045,-0.68337663,-0.68337663,-0.68337663,1.7158505,-0.68337663,-0.68337663,-0.68337663,1.7114517,-0.68337663,-0.68337663,-0.68337663,1.7104478,-0.68337663,-0.68337663,-0.68337663,1.707291,-0.68337663,-0.68337663,-0.68337663,1.7068045,-0.68337663,-0.68337663,-0.68337663,1.7024988,-0.68337663,-0.68337663,-0.68337663,1.7041963,-0.68337663,-0.68337663,-0.68337663,1.7055521,-0.68337663,-0.68337663,-0.68337663,1.7071875,-0.68337663,-0.68337663,-0.68337663,1.708564,-0.68337663,-0.68337663,-0.68337663,1.7116173,-0.68337663,-0.68337663,-0.68337663,1.7135218,-0.68337663,-0.68337663,-0.68337663,1.7134907,-0.68337663,-0.68337663,-0.68337663,1.7126316,-0.68337663,-0.68337663,-0.68337663,1.7133355,-0.68337663,-0.68337663,-0.68337663,1.713884,-0.68337663,-0.68337663,-0.68337663,1.7147327,-0.68337663,-0.68337663,-0.68337663,1.7137805,-0.68337663,-0.68337663,-0.68337663,1.7141635,-0.68337663,-0.68337663,-0.68337663,1.7125488,-0.68337663,-0.68337663,-0.68337663,1.7167614,-0.68337663,-0.68337663,-0.68337663,1.7156849,-0.68337663,-0.68337663,-0.68337663,1.7161817,-0.68337663,-0.68337663,-0.68337663,1.7146603,-0.68337663,-0.68337663,-0.68337663,1.7158919,-0.68337663,-0.68337663,-0.68337663,1.7139254,-0.68337663,-0.68337663,-0.68337663,1.7127455,-0.68337663,-0.68337663,-0.68337663,1.7114931,-0.68337663,-0.68337663,-0.68337663,1.7112965,-0.68337663,-0.68337663,-0.68337663,1.7123729,-0.68337663,-0.68337663,-0.68337663,1.7145464,-0.68337663,-0.68337663,-0.68337663,1.7131285,-0.68337663,-0.68337663,-0.68337663,1.7057281,-0.68337663,-0.68337663,-0.68337663,1.7091229,-0.68337663,-0.68337663,-0.68337663,1.7125385,-0.68337663,-0.68337663,-0.68337663,1.7102097,-0.68337663,-0.68337663,-0.68337663,1.7083881,-0.68337663,-0.68337663,-0.68337663,1.7142049,-0.68337663,-0.68337663,-0.68337663,1.714505,-0.68337663,-0.68337663,-0.68337663,1.7161921,-0.68337663,-0.68337663,-0.68337663,1.7120313,-0.68337663,-0.68337663,-0.68337663,1.7088124,-0.68337663,-0.68337663,-0.68337663,1.7115656,-0.68337663,-0.68337663,-0.68337663,1.7105202,-0.68337663,-0.68337663,-0.68337663,1.7086054,-0.68337663,-0.68337663,-0.68337663,1.7090194,-0.68337663,-0.68337663,-0.68337663,1.7084605,-0.68337663,-0.68337663,-0.68337663,1.7072392,-0.68337663,-0.68337663,-0.68337663,1.709951,-0.68337663,-0.68337663,-0.68337663,1.709951,-0.68337663,-0.68337663,-0.68337663,1.705666,-0.68337663,-0.68337663,-0.68337663,1.7050553,-0.68337663,-0.68337663,-0.68337663,1.7091333,-0.68337663,-0.68337663,-0.68337663,1.7056556,-0.68337663,-0.68337663,-0.68337663,1.7016191,-0.68337663,-0.68337663,-0.68337663,1.7035753,-0.68337663,-0.68337663,-0.68337663,1.705283,-0.68337663,-0.68337663,-0.68337663,1.7047241,-0.68337663,-0.68337663,-0.68337663,1.7040617,-0.68337663,-0.68337663,-0.68337663,1.7021676,-0.68337663,-0.68337663,-0.68337663,1.7045792,-0.68337663,-0.68337663,-0.68337663,1.7023953,-0.68337663,-0.68337663,-0.68337663,1.7050864,-0.68337663,-0.68337663,-0.68337663,1.704631,-0.68337663,-0.68337663,-0.68337663,1.7068149,-0.68337663,-0.68337663,-0.68337663,1.7050346,-0.68337663,-0.68337663,-0.68337663,1.7045896,-0.68337663,-0.68337663,-0.68337663,1.7096301,-0.68337663,-0.68337663,-0.68337663,1.7094128,-0.68337663,-0.68337663,-0.68337663,1.7100959,-0.68337663,-0.68337663,-0.68337663,1.7085847,-0.68337663,-0.68337663,-0.68337663,1.709744,-0.68337663,-0.68337663,-0.68337663,1.7068252,-0.68337663,-0.68337663,-0.68337663,1.7076429,-0.68337663,-0.68337663,-0.68337663,1.7061214,-0.68337663,-0.68337663,-0.68337663,1.7073634,-0.68337663,-0.68337663,-0.68337663,1.7040307,-0.68337663,-0.68337663,-0.68337663,1.7059972,-0.68337663,-0.68337663,-0.68337663,1.7081293,-0.68337663,-0.68337663,-0.68337663,1.7095784,-0.68337663,-0.68337663,-0.68337663,1.7096508,-0.68337663,-0.68337663,-0.68337663,1.7107169,-0.68337663,-0.68337663,-0.68337663,1.7099924,-0.68337663,-0.68337663,-0.68337663,1.7094438,-0.68337663,-0.68337663,-0.68337663,1.7086675,-0.68337663,-0.68337663,-0.68337663,1.7093196,-0.68337663,-0.68337663,-0.68337663,1.7076118,-0.68337663,-0.68337663,-0.68337663,1.700967,-0.68337663,-0.68337663,-0.68337663,1.7020745,-0.68337663,-0.68337663,-0.68337663,1.7060283,-0.68337663,-0.68337663,-0.68337663,1.703596,-0.68337663,-0.68337663,-0.68337663,1.704869,-0.68337663,-0.68337663,-0.68337663,1.7016708,-0.68337663,-0.68337663,-0.68337663,1.7021573,-0.68337663,-0.68337663,-0.68337663,1.7070115,-0.68337663,-0.68337663,-0.68337663,1.7085537,-0.68337663,-0.68337663,-0.68337663,1.7089573,-0.68337663,-0.68337663,-0.68337663,1.7100545,-0.68337663,-0.4862373,-0.086586906,1.7072185,-0.68062349,-0.48730336,-0.06837064,1.7067735,-0.68055104,-0.4862373,-0.069436705,1.7066493,-0.68055104,-0.48516088,-0.079083046,1.7089159,-0.68058209,-0.48516088,-0.094080416,1.7084916,-0.68064419,-0.48516088,-0.096222897,1.7132734,-0.68066489,-0.48516088,-0.096222897,1.7107583,-0.68066489,-0.48409482,-0.098365378,1.7123936,-0.68066489,-0.48409482,-0.10265034,1.7147845,-0.68068559,-0.48409482,-0.10479282,1.7124453,-0.68069594,-0.48409482,-0.10694565,1.7139254,-0.68070629,-0.48409482,-0.10908813,1.7123625,-0.68071664,-0.48516088,-0.11123062,1.7101166,-0.68071664,-0.48409482,-0.1133731,1.7112551,-0.68072699,-0.48409482,-0.11658164,1.7062974,-0.68073734,-0.48409482,-0.11765806,1.7077981,-0.68074769,-0.48516088,-0.12086661,1.7063284,-0.68075804,-0.48409482,-0.12300909,1.7092161,-0.68076839,-0.48516088,-0.1240855,1.7076015,-0.68076839,-0.48409482,-0.1240855,1.7116484,-0.68076839,-0.48409482,-0.12622799,1.7109342,-0.68077874,-0.48409482,-0.12943653,1.7106962,-0.68078909,-0.48409482,-0.12837047,1.7085123,-0.68078909,-0.48409482,-0.13265543,1.7080569,-0.68079944,-0.48409482,-0.13265543,1.7061628,-0.68079944,-0.48409482,-0.13265543,1.7073427,-0.68079944,-0.48516088,-0.13265543,1.704662,-0.68079944,-0.48516088,-0.13373185,1.7051588,-0.68080979,-0.48516088,-0.13265543,1.7045792,-0.68079944,-0.48516088,-0.13479791,1.702975,-0.68080979,-0.48516088,-0.13587433,1.7061525,-0.68080979,-0.48516088,-0.13587433,1.7042791,-0.68082014,-0.48516088,-0.13587433,1.7073738,-0.68082014,-0.48516088,-0.13801681,1.7046827,-0.68082014,-0.48516088,-0.13908287,1.7045275,-0.68083049,-0.48516088,-0.13908287,1.7061732,-0.68083049,-0.48516088,-0.13801681,1.7064837,-0.68083049,-0.48516088,-0.14015929,1.7072082,-0.68083049,-0.48516088,-0.14015929,1.707529,-0.68083049,-0.48409482,-0.13908287,1.708119,-0.68083049,-0.48409482,-0.14015929,1.7087917,-0.68084084,-0.48409482,-0.14336784,1.7088228,-0.68085119,-0.48409482,-0.14230177,1.7097129,-0.68084084,-0.48409482,-0.14230177,1.7084502,-0.68084084,-0.48409482,-0.14336784,1.7105202,-0.68085119,-0.48409482,-0.14444425,1.710365,-0.68085119,-0.48409482,-0.14230177,1.712466,-0.68085119,-0.48516088,-0.14444425,1.7098371,-0.68085119,-0.48409482,-0.14336784,1.7107376,-0.68085119,-0.48409482,-0.14551032,1.7135321,-0.68086154,-0.48516088,-0.14658673,1.7101373,-0.68086154,-0.48516088,-0.14658673,1.7084812,-0.68086154,-0.48516088,-0.1476528,1.7075083,-0.68086154,-0.48516088,-0.14872921,1.7082328,-0.68087189,-0.48409482,-0.1476528,1.7102925,-0.68086154,-0.48516088,-0.14872921,1.7057902,-0.68087189,-0.48730336,-0.049077958,1.7040514,-0.68046824,-0.48730336,-0.048011892,1.7051278,-0.68045789,-0.4862373,-0.049077958,1.7058833,-0.68046824,-0.48730336,-0.048011892,1.7043722,-0.68045789,-0.48730336,-0.050154373,1.7036995,-0.68046824,-0.4862373,-0.1508717,1.7028611,-0.68087189,-0.48516088,-0.15193776,1.7047759,-0.68088224,-0.48516088,-0.15408024,1.7053348,-0.68089259,-0.48730336,-0.15408024,1.7018985,-0.68089259,-0.4862373,-0.15301418,1.7028611,-0.68088224,-0.4862373,-0.15408024,1.7028094,-0.68089259,-0.4862373,-0.15408024,1.7026334,-0.68089259,-0.48516088,-0.15301418,1.7038547,-0.68088224,-0.4862373,-0.15515666,1.7035442,-0.68089259,-0.4862373,-0.15515666,1.7030681,-0.68089259,-0.48516088,-0.15515666,1.7052934,-0.68089259,-0.4862373,-0.15729914,1.7040721,-0.68090294,-0.48516088,-0.15622272,1.7068873,-0.68090294,-0.48516088,-0.15729914,1.7053244,-0.68090294,-0.4862373,-0.15837556,1.7041652,-0.68090294,-0.48730336,-0.15944162,1.7016191,-0.68091329,-0.4862373,-0.15944162,1.7053865,-0.68091329,-0.4862373,-0.15729914,1.706701,-0.68090294,-0.4862373,-0.16051804,1.7050553,-0.68091329,-0.4862373,-0.16051804,1.7047241,-0.68091329,-0.4862373,-0.15837556,1.7039065,-0.68090294,-0.48730336,-0.15944162,1.7018054,-0.68091329,-0.4862373,-0.16051804,1.7045482,-0.68091329,-0.4862373,-0.15944162,1.706877,-0.68091329,-0.48730336,-0.16051804,1.7036995,-0.68091329,-0.4862373,-0.16051804,1.703213,-0.68091329,-0.4862373,-0.16372658,1.7040514,-0.68092364,-0.4862373,-0.1615841,1.7033476,-0.68091329,-0.4862373,-0.16266052,1.703596,-0.68092364,-0.4862373,-0.16266052,1.7054486,-0.68092364,-0.48837978,-0.16266052,1.7035132,-0.68092364,-0.48837978,-0.16372658,1.7011223,-0.68092364,-0.48730336,-0.16372658,1.7017536,-0.68092364,-0.48837978,-0.16266052,1.7017122,-0.68092364,-0.48837978,-0.16372658,1.7008221,-0.68092364,-0.48730336,-0.164803,1.7020434,-0.68093399,-0.48730336,-0.16586907,1.7022815,-0.68093399,-0.48730336,-0.164803,1.7035028,-0.68093399,-0.48730336,-0.16694548,1.7000666,-0.68093399,-0.48730336,-0.16801155,1.7018571,-0.68094435,-0.48730336,-0.16586907,1.7022297,-0.68093399,-0.48837978,-0.16694548,1.7016087,-0.68094435,-0.48837978,-0.16801155,1.6991454,-0.68094435,-0.48837978,-0.16586907,1.6970857,-0.68093399,-0.48837978,-0.16694548,1.7005737,-0.68094435,-0.48730336,-0.16801155,1.7004288,-0.68094435,-0.48730336,-0.16801155,1.6993421,-0.68094435,-0.48730336,-0.16801155,1.6997768,-0.68094435,-0.48730336,-0.17015403,1.7006151,-0.6809547,-0.48837978,-0.17123044,1.6988659,-0.6809547,-0.48730336,-0.16908796,1.6984623,-0.68094435,-0.48730336,-0.17015403,1.702592,-0.6809547,-0.48730336,-0.17229651,1.7016605,-0.68096505,-0.48730336,-0.17015403,1.7042687,-0.6809547,-0.48730336,-0.17015403,1.7040203,-0.6809547,-0.48730336,-0.17229651,1.7025817,-0.68096505,-0.48730336,-0.17229651,1.7009153,-0.68096505,-0.48837978,-0.17443899,1.6992282,-0.68096505,-0.48730336,-0.17337292,1.7045068,-0.68096505,-0.48730336,-0.17337292,1.7034407,-0.68096505,-0.4862373,-0.17337292,1.7071875,-0.6809754,-0.48730336,-0.17337292,1.7050967,-0.68096505,-0.48516088,-0.17229651,1.7084916,-0.68096505,-0.4862373,-0.17443899,1.7071875,-0.6809754,-0.4862373,-0.17551541,1.7063698,-0.6809754,-0.4862373,-0.17551541,1.7050139,-0.6809754,-0.4862373,-0.17443899,1.7057591,-0.6809754,-0.4862373,-0.17443899,1.7055211,-0.6809754,-0.48730336,-0.17551541,1.7051485,-0.6809754,-0.4862373,-0.17443899,1.7044861,-0.6809754,-0.4862373,-0.17551541,1.7055832,-0.6809754,-0.4862373,-0.17551541,1.705904,-0.6809754,-0.4862373,-0.17551541,1.7076325,-0.6809754,-0.48730336,-0.17551541,1.7059869,-0.6809754,-0.48730336,-0.17658147,1.704455,-0.6809754,-0.48730336,-0.17658147,1.7039789,-0.6809754,-0.4862373,-0.17658147,1.7047138,-0.6809754,-0.48730336,-0.17980037,1.705045,-0.6809961,-0.48730336,-0.17765789,1.7059869,-0.68098575,-0.48837978,-0.17658147,1.7031095,-0.68098575,-0.48837978,-0.17872395,1.7028611,-0.6809961,-0.48837978,-0.17872395,1.7029439,-0.6809961,-0.48730336,-0.17765789,1.7046517,-0.68098575,-0.48837978,-0.17872395,1.6992903,-0.68098575,-0.48837978,-0.17980037,1.7004288,-0.6809961,-0.48944585,-0.18086643,1.6984002,-0.6809961,-0.48837978,-0.17980037,1.7024781,-0.6809961,-0.48837978,-0.17980037,1.7019399,-0.6809961,-0.48944585,-0.18086643,1.7005737,-0.6809961,-0.48944585,-0.18086643,1.6993007,-0.6809961,-0.48944585,-0.18086643,1.6973548,-0.6809961,-0.49052226,-0.18086643,1.6972617,-0.6809961,-0.48944585,-0.18194285,1.7007807,-0.6809961,-0.48944585,-0.18194285,1.7002632,-0.68100645,-0.48944585,-0.18086643,1.7011533,-0.6809961,-0.48944585,-0.18300892,1.69928,-0.68100645,-0.48837978,-0.18300892,1.7020848,-0.68100645,-0.48944585,-0.18300892,1.7005634,-0.68100645,-0.48944585,-0.18300892,1.6994042,-0.68100645,-0.48837978,-0.18408533,1.7038444,-0.6810168,-0.48837978,-0.18408533,1.7041135,-0.68100645,-0.48730336,-0.18300892,1.7067217,-0.68100645,-0.48837978,-0.18408533,1.7051071,-0.68100645,-0.48837978,-0.18622781,1.7036788,-0.6810168,-0.48837978,-0.18516175,1.7049622,-0.6810168,-0.48730336,-0.18300892,1.7072806,-0.68100645,-0.48837978,-0.18516175,1.7060593,-0.6810168,-0.48837978,-0.18622781,1.7051071,-0.6810168,-0.48944585,-0.18622781,1.7018261,-0.6810168,-0.48944585,-0.18516175,1.7033476,-0.6810168,-0.68337663,-0.68337663,1.7047966,-0.68337663,-0.68337663,-0.68337663,1.7088228,-0.68337663,-0.68337663,-0.68337663,1.7061214,-0.68337663,-0.68337663,-0.68337663,1.7060593,-0.68337663,-0.68337663,-0.68337663,1.7032027,-0.68337663,-0.68337663,-0.68337663,1.7050139,-0.68337663,-0.68337663,-0.68337663,1.707322,-0.68337663,-0.68337663,-0.68337663,1.7065044,-0.68337663,-0.68337663,-0.68337663,1.7025713,-0.68337663,-0.68337663,-0.68337663,1.7039168,-0.68337663,-0.68337663,-0.68337663,1.7040307,-0.68337663,-0.68337663,-0.68337663,1.7021883,-0.68337663,-0.68337663,-0.68337663,1.7023022,-0.68337663,-0.68337663,-0.68337663,1.7070529,-0.68337663,-0.68337663,-0.68337663,1.7081293,-0.68337663,-0.68337663,-0.68337663,1.7072806,-0.68337663,-0.68337663,-0.68337663,1.7091333,-0.68337663,-0.68337663,-0.68337663,1.7084398,-0.68337663,-0.68337663,-0.68337663,1.7080672,-0.68337663,-0.68337663,-0.68337663,1.7074462,-0.68337663,-0.68337663,-0.68337663,1.7074048,-0.68337663,-0.68337663,-0.68337663,1.7084295,-0.68337663,-0.68337663,-0.68337663,1.7086986,-0.68337663,-0.68337663,-0.68337663,1.7056453,-0.68337663,-0.6844427,-0.58159324,1.7082639,-0.68295227,-0.68337663,-0.68337663,1.7105409,-0.68337663,-0.68337663,-0.68337663,1.7094231,-0.68337663,-0.68337663,-0.68337663,1.710986,-0.68337663,-0.68337663,-0.68337663,1.7092782,-0.68337663,-0.68337663,-0.68337663,1.7106134,-0.68337663,-0.68337663,-0.68337663,1.709537,-0.68337663,-0.68337663,-0.68337663,1.7089987,-0.68337663,-0.68337663,-0.68337663,1.7042791,-0.68337663,-0.68337663,-0.68337663,1.7097647,-0.68337663,-0.68337663,-0.68337663,1.7118036,-0.68337663,-0.68337663,-0.68337663,1.707498,-0.68337663,-0.68337663,-0.68337663,1.708533,-0.68337663,-0.68337663,-0.68337663,1.7127972,-0.68337663,-0.68337663,-0.68337663,1.7119175,-0.68337663,-0.68337663,-0.68337663,1.7125799,-0.68337663,-0.68337663,-0.68337663,1.7134597,-0.68337663,-0.68337663,-0.68337663,1.7201873,-0.68337663,-0.68337663,-0.68337663,1.7201769,-0.68337663,-0.68337663,-0.68337663,1.7217605,-0.68337663,-0.68337663,-0.68337663,1.717755,-0.68337663,-0.68337663,-0.68337663,1.715302,-0.68337663,-0.68337663,-0.68337663,1.7181172,-0.68337663,-0.68337663,-0.68337663,1.7200631,-0.68337663,-0.68337663,-0.68337663,1.7198871,-0.68337663,-0.68337663,-0.68337663,1.7163784,-0.68337663,-0.68337663,-0.68337663,1.7173099,-0.68337663,-0.68337663,-0.68337663,1.7100855,-0.68337663,-0.68337663,-0.68337663,1.7111723,-0.68337663,-0.68337663,-0.68337663,1.7110895,-0.68337663,-0.68337663,-0.68337663,1.7102822,-0.68337663,-0.68337663,-0.68337663,1.7102718,-0.68337663,-0.68337663,-0.68337663,1.7102201,-0.68337663,-0.68337663,-0.68337663,1.7107479,-0.68337663,-0.68337663,-0.68337663,1.7119485,-0.68337663,-0.68337663,-0.68337663,1.7099096,-0.68337663,-0.68337663,-0.68337663,1.7094024,-0.68337663,-0.68337663,-0.68337663,1.7082639,-0.68337663,-0.68337663,-0.68337663,1.7110895,-0.68337663,-0.68337663,-0.68337663,1.7111102,-0.68337663,-0.68337663,-0.68337663,1.7102511,-0.68337663,-0.68337663,-0.68337663,1.7128904,-0.68337663,-0.68337663,-0.68337663,1.7124557,-0.68337663,-0.68337663,-0.68337663,1.7157988,-0.68337663,-0.68337663,-0.68337663,1.7140186,-0.68337663,-0.68337663,-0.68337663,1.7154883,-0.68337663,-0.68337663,-0.68337663,1.7141531,-0.68337663,-0.68337663,-0.68337663,1.7140496,-0.68337663,-0.68337663,-0.68337663,1.7155814,-0.68337663,-0.68337663,-0.68337663,1.7153848,-0.68337663,-0.68337663,-0.68337663,1.7153848,-0.68337663,-0.68337663,-0.68337663,1.7153848,-0.68337663,-0.68337663,-0.68337663,1.7153848,-0.68337663,-0.68337663,-0.68337663,1.7153848,-0.68337663,-0.68337663,-0.68337663,1.7153848,-0.68337663,-0.68337663,-0.68337663,1.7153848,-0.68337663,-0.68337663,-0.68337663,1.7153848,-0.68337663:0
-0.91673176,-0.91673176,1.5280892,-0.91673176,-0.91673176,-0.91673176,1.5296924,-0.91673176,-0.91673176,-0.91673176,1.5244693,-0.91673176,-0.91673176,-0.91673176,1.5170019,-0.91673176,-0.91673176,-0.91673176,1.5195772,-0.91673176,-0.91673176,-0.91673176,1.5143025,-0.91673176,-0.91673176,-0.91673176,1.5140542,-0.91673176,-0.91673176,-0.91673176,1.5175294,-0.91673176,-0.91673176,-0.91673176,1.5167537,-0.91673176,-0.91673176,-0.91673176,1.5182844,-0.91673176,-0.91673176,-0.91673176,1.5166502,-0.91673176,-0.91673176,-0.91673176,1.5147369,-0.91673176,-0.91673176,-0.91673176,1.5150885,-0.91673176,-0.91673176,-0.91673176,1.5153264,-0.91673176,-0.91673176,-0.91673176,1.5177466,-0.91673176,-0.91673176,-0.91673176,1.5225973,-0.91673176,-0.91673176,-0.91673176,1.5250071,-0.91673176,-0.91673176,-0.91673176,1.5261965,-0.91673176,-0.91673176,-0.91673176,1.5254105,-0.91673176,-0.91673176,-0.91673176,1.5207356,-0.91673176,-0.91673176,-0.91673176,1.5195876,-0.91673176,-0.91673176,-0.91673176,1.5194945,-0.91673176,-0.91673176,-0.91673176,1.5181913,-0.91673176,-0.91673176,-0.91673176,1.5210562,-0.91673176,-0.91673176,-0.91673176,1.522618,-0.91673176,-0.91673176,-0.91673176,1.5190187,-0.91673176,-0.91673176,-0.91673176,1.5213975,-0.91673176,-0.91673176,-0.91673176,1.5201564,-0.91673176,-0.91673176,-0.91673176,1.5204253,-0.91673176,-0.91673176,-0.91673176,1.5197634,-0.91673176,-0.91673176,-0.91673176,1.5173846,-0.91673176,-0.91673176,-0.91673176,1.5152747,-0.91673176,-0.91673176,-0.91673176,1.5131544,-0.91673176,-0.91673176,-0.91673176,1.5098758,-0.91673176,-0.91673176,-0.91673176,1.5111997,-0.91673176,-0.91673176,-0.91673176,1.5111686,-0.91673176,-0.91673176,-0.91673176,1.5111893,-0.91673176,-0.91673176,-0.91673176,1.5110032,-0.91673176,-0.91673176,-0.91673176,1.5090587,-0.91673176,-0.91673176,-0.91673176,1.5118306,-0.91673176,-0.91673176,-0.91673176,1.5160607,-0.91673176,-0.91673176,-0.91673176,1.5187498,-0.91673176,-0.91673176,-0.91673176,1.51785,-0.91673176,-0.91673176,-0.91673176,1.528927,-0.91673176,-0.91673176,-0.91673176,1.5301371,-0.91673176,-0.91673176,-0.91673176,1.5283168,-0.91673176,-0.91673176,-0.91673176,1.5276238,-0.91673176,-0.91673176,-0.91673176,1.5261965,-0.91673176,-0.91673176,-0.91673176,1.5267654,-0.91673176,-0.91673176,-0.91673176,1.5288546,-0.91673176,-0.91673176,-0.91673176,1.5317505,-0.91673176,-0.91673176,-0.91673176,1.5299613,-0.91673176,-0.91673176,-0.91673176,1.5309128,-0.91673176,-0.91673176,-0.91673176,1.530437,-0.91665936,-0.91673176,-0.91673176,1.5318436,-0.91673176,-0.91673176,-0.91673176,1.5331158,-0.91673176,-0.91673176,-0.91673176,1.5336226,-0.91673176,-0.91673176,-0.91673176,1.5329606,-0.91673176,-0.91673176,-0.91673176,1.5334985,-0.91673176,-0.91673176,-0.91673176,1.5348223,-0.91673176,-0.91673176,-0.91673176,1.5307059,-0.91673176,-0.91673176,-0.91673176,1.5347499,-0.91673176,-0.91673176,-0.91673176,1.5341707,-0.91673176,-0.91673176,-0.91673176,1.5339432,-0.91673176,-0.91673176,-0.91673176,1.5317712,-0.91673176,-0.91673176,-0.91673176,1.5343569,-0.91673176,-0.91673176,-0.91673176,1.5342742,-0.91673176,-0.91673176,-0.91673176,1.5340673,-0.91673176,-0.91673176,-0.91673176,1.5358566,-0.91673176,-0.91673176,-0.91673176,1.5357532,-0.91673176,-0.91780739,-0.74665689,1.5335502,-0.91601811,-0.91780739,-0.74665689,1.5347809,-0.91601811,-0.91780739,-0.74665689,1.5358359,-0.91601811,-0.91780739,-0.74558126,1.5366116,-0.91601811,-0.91673176,-0.74665689,1.5364461,-0.91601811,-0.91673176,-0.91673176,1.5362082,-0.91673176,-0.91673176,-0.91673176,1.5367667,-0.91673176,-0.91673176,-0.91673176,1.535898,-0.91673176,-0.91673176,-0.91673176,1.5369115,-0.91673176,-0.91673176,-0.91673176,1.5378424,-0.91673176,-0.91673176,-0.91673176,1.5362186,-0.91673176,-0.91673176,-0.91673176,1.5373563,-0.91673176,-0.91673176,-0.91673176,1.535629,-0.91673176,-0.91673176,-0.91673176,1.5364565,-0.91673176,-0.91673176,-0.91673176,1.5358669,-0.91673176,-0.91673176,-0.91673176,1.535898,-0.91673176,-0.91673176,-0.91673176,1.536653,-0.91673176,-0.91673176,-0.91673176,1.5340259,-0.91673176,-0.91673176,-0.91673176,1.5369736,-0.91673176,-0.91673176,-0.91673176,1.5344396,-0.91673176,-0.91673176,-0.91673176,1.5353498,-0.91673176,-0.91673176,-0.91673176,1.5344293,-0.91673176,-0.91673176,-0.91673176,1.5349775,-0.91673176,-0.91673176,-0.91673176,1.5334778,-0.91673176,-0.91673176,-0.91673176,1.5351016,-0.91673176,-0.91673176,-0.91673176,1.5321539,-0.91673176,-0.91673176,-0.91673176,1.5335088,-0.91673176,-0.91673176,-0.91673176,1.5342948,-0.91673176,-0.91673176,-0.91673176,1.5342121,-0.91673176,-0.91673176,-0.91673176,1.5332192,-0.91673176,-0.91673176,-0.91673176,1.53626,-0.91673176,-0.91673176,-0.91673176,1.5359497,-0.91673176,-0.91673176,-0.91673176,1.5346568,-0.91673176,-0.91673176,-0.91673176,1.5325469,-0.91673176,-0.91673176,-0.91673176,1.5313989,-0.91673176,-0.91673176,-0.91673176,1.5297854,-0.91673176,-0.91673176,-0.91673176,1.5315023,-0.91673176,-0.91673176,-0.91673176,1.5317609,-0.91673176,-0.91673176,-0.91673176,1.5300647,-0.91673176,-0.91673176,-0.91673176,1.5300647,-0.91673176,-0.91673176,-0.91673176,1.5319057,-0.91673176,-0.9339523,-0.91673176,1.5325159,-0.91665936,-0.91673176,-0.91673176,1.5335191,-0.91673176,-0.91673176,-0.91673176,1.5339432,-0.91673176,-0.91673176,-0.91673176,1.5342431,-0.91673176,-0.91673176,-0.91673176,1.5322263,-0.91673176,-0.91673176,-0.91673176,1.5329606,-0.91673176,-0.91673176,-0.91673176,1.532609,-0.91673176,-0.91673176,-0.91673176,1.5333433,-0.91673176,-0.91673176,-0.91673176,1.5340466,-0.91673176,-0.91673176,-0.91673176,1.5324125,-0.91673176,-0.91673176,-0.91673176,1.5339846,-0.91673176,-0.91673176,-0.91673176,1.5362393,-0.91673176,-0.91673176,-0.91673176,1.5338087,-0.91673176,-0.91673176,-0.91673176,1.5356808,-0.91673176,-0.91673176,-0.91673176,1.5335915,-0.91673176,-0.91673176,-0.91673176,1.533695,-0.91673176,-0.91673176,-0.91673176,1.5328676,-0.91673176,-0.91673176,-0.91673176,1.5343052,-0.91673176,-0.91673176,-0.91673176,1.5321849,-0.91673176,-0.91673176,-0.91673176,1.5322056,-0.91673176,-0.91673176,-0.91673176,1.5323918,-0.91673176,-0.91673176,-0.91673176,1.5319471,-0.91673176,-0.91673176,-0.91673176,1.5329606,-0.91673176,-0.93287666,-0.91135357,1.5314816,-0.9166697,-0.91780739,-0.74665689,1.528958,-0.91601811,-0.91780739,-0.74665689,1.5307059,-0.91601811,-0.91673176,-0.74773253,1.5308197,-0.91601811,-0.91673176,-0.74880817,1.5277169,-0.91602846,-0.91780739,-0.74773253,1.5265999,-0.91601811,-0.91673176,-0.91673176,1.5291235,-0.91673176,-0.91673176,-0.91673176,1.5334778,-0.91673176,-0.91673176,-0.91673176,1.5319988,-0.91673176,-0.91673176,-0.91673176,1.5327641,-0.91673176,-0.91673176,-0.91673176,1.532671,-0.91673176,-0.91673176,-0.91673176,1.5318436,-0.91673176,-0.91673176,-0.91673176,1.5334778,-0.91673176,-0.91673176,-0.91673176,1.53264,-0.91673176,-0.91673176,-0.91673176,1.5316988,-0.91673176,-0.91673176,-0.91673176,1.5329813,-0.91673176,-0.91673176,-0.91673176,1.5328882,-0.91673176,-0.91673176,-0.91673176,1.5328055,-0.91673176,-0.91673176,-0.91673176,1.5324642,-0.91673176,-0.91673176,-0.91673176,1.5274273,-0.91673176,-0.91673176,-0.91673176,1.5291235,-0.91673176,-0.91673176,-0.91673176,1.5235281,-0.91673176,-0.91673176,-0.91673176,1.5251002,-0.91673176,-0.91673176,-0.91673176,1.5285547,-0.91673176,-0.91673176,-0.91673176,1.5265792,-0.91673176,-0.91673176,-0.91673176,1.5274687,-0.91673176,-0.91673176,-0.91673176,1.5257725,-0.91673176,-0.91673176,-0.91673176,1.5260104,-0.91673176,0.33088383,0.12958444,1.5194841,-0.90981251,0.33195947,0.12635753,1.5206115,-0.90981251,0.32980819,0.15004225,1.5191325,-0.9097608,0.33195947,0.10913699,1.5199185,-0.90986422,0.33195947,0.11343954,1.5199289,-0.90984354,0.33518638,0.10805101,1.5216975,-0.90985388,0.33518638,0.10805101,1.5220078,-0.90985388,0.33841329,0.10913699,1.5238487,-0.90984354,0.33733766,0.10374846,1.5230317,-0.90985388,0.33733766,0.10589973,1.5233833,-0.90985388,0.33733766,0.099445905,1.5230317,-0.90986422,0.33518638,0.094057374,1.5221629,-0.90989525,0.34272619,0.092981736,1.5269619,-0.90989525,0.34380182,0.089754823,1.5280892,-0.90990559,0.34487746,0.088679185,1.528565,-0.90990559,0.34380182,0.085452272,1.5276652,-0.90991594,0.34918001,0.084376635,1.5312851,-0.90989525,0.35133129,0.084376635,1.5334467,-0.90989525,0.35349291,0.084376635,1.5349775,-0.90991594,0.35456854,0.080063741,1.5356808,-0.90992628,0.35671982,0.076836828,1.5372115,-0.90992628,0.36102237,0.077912466,1.540397,-0.90990559,0.36317364,0.075761191,1.5416588,-0.90990559,0.35564418,0.074685553,1.5364978,-0.90992628,0.35133129,0.070383002,1.5333743,-0.90992628,0.35133129,0.068221384,1.5331572,-0.90993662,0.34918001,0.067145746,1.5314816,-0.90994697,0.34918001,0.066070109,1.5311507,-0.90994697,0.34918001,0.067145746,1.531192,-0.90994697,0.35025565,0.064994471,1.5317712,-0.90994697,0.34918001,0.062843196,1.5314196,-0.90995731,0.34810437,0.063918833,1.5306956,-0.90995731,0.35025565,0.059616283,1.5317712,-0.90995731,0.35133129,0.059616283,1.5331882,-0.90995731,0.35133129,0.057465007,1.5326504,-0.90995731,0.35241727,0.055313732,1.5328262,-0.90996765,0.35349291,0.052076476,1.5344603,-0.90996765,0.35456854,0.054227752,1.5349361,-0.90998834,0.35349291,0.048849563,1.5341707,-0.90997799,0.35349291,0.049925201,1.5341087,-0.90997799,0.35241727,0.042395737,1.5334261,-0.90999868,0.35025565,0.040234119,1.5312955,-0.91000902,0.35133129,0.039158482,1.5329503,-0.91000902,0.35241727,0.037007206,1.5332192,-0.91000902,0.35349291,0.034855931,1.5338398,-0.91000902,0.35564418,0.031629018,1.5360014,-0.91004005,0.35564418,0.028402105,1.5362082,-0.91005039,0.35671982,0.028402105,1.5364047,-0.91005039,0.35349291,0.025164849,1.5346362,-0.91006073,0.35456854,0.023013574,1.5347913,-0.91007108,0.35887109,0.020862299,1.5376045,-0.91006073,0.35564418,0.018711023,1.5357842,-0.91007108,0.35994673,0.017635386,1.5380699,-0.91006073,0.35887109,0.01548411,1.5379458,-0.91007108,0.35456854,0.01548411,1.5342742,-0.91006073,0.35349291,0.012246855,1.5339742,-0.91007108,0.35241727,0.010095579,1.5333847,-0.91008142,0.35456854,0.010095579,1.5343466,-0.91007108,0.35349291,0.0090199416,1.5342638,-0.91008142,0.35456854,0.0068686663,1.5349981,-0.91010211,0.35025565,0.0036417533,1.5331675,-0.91009176,0.35564418,0.0036417533,1.5342845,-0.91009176,0.35671982,0.0014904779,1.5365495,-0.91011245,0.35564418,0.0014904779,1.5358359,-0.91011245,0.35671982,-6.711401E-4,1.5364358,-0.91012279,0.35671982,-0.0028224154,1.5365909,-0.91012279,0.35349291,-0.0028224154,1.5351947,-0.91013313,0.35994673,-0.0028224154,1.5393421,-0.91011245,0.35994673,-0.0028224154,1.5395696,-0.91011245,0.35994673,-0.0049736908,1.5391042,-0.91012279,0.35887109,-0.0060493285,1.5404384,-0.91011245,0.35994673,-0.0082006038,1.5403867,-0.91012279,0.35887109,-0.010351879,1.5395489,-0.91012279,0.36102237,-0.0092762415,1.5399213,-0.91012279,0.36317364,-0.011427517,1.5428172,-0.91012279,0.36532492,-0.013589135,1.5432102,-0.91012279,0.36424928,-0.013589135,1.5428999,-0.91012279,0.36532492,-0.014664772,1.543293,-0.91012279,0.36424928,-0.01574041,1.542631,-0.91013313,0.36856218,-0.01574041,1.5457442,-0.91014348,0.36532492,-0.018967323,1.5434688,-0.91013313,0.36532492,-0.020042961,1.5434274,-0.91013313,0.36317364,-0.021118599,1.5414623,-0.91014348,0.36102237,-0.022194236,1.5401591,-0.91015382,0.36102237,-0.023269874,1.5400971,-0.91015382,0.35994673,-0.025421149,1.5390628,-0.91016416,0.36209801,-0.024345512,1.540428,-0.91016416,0.35994673,-0.02650713,1.5392904,-0.9101745,0.36317364,-0.027582767,1.5413175,-0.91016416,0.35994673,-0.027582767,1.5401074,-0.9101745,0.35887109,-0.028658405,1.5386801,-0.9101745,0.36102237,-0.029734043,1.5402522,-0.9101745,0.36209801,-0.03080968,1.5410176,-0.9101745,0.35779546,-0.032960956,1.5375011,-0.91019519,0.36209801,-0.032960956,1.5407073,-0.9101745,0.36102237,-0.034036593,1.5397868,-0.91018485,0.36102237,-0.035112231,1.5401488,-0.91018485,0.36209801,-0.035112231,1.5400454,-0.91018485,0.35994673,-0.037263506,1.5391766,-0.91019519,0.36102237,-0.038339144,1.5400867,-0.91019519,0.36209801,-0.038339144,1.5402315,-0.91019519,0.36317364,-0.040500762,1.5416175,-0.91019519,0.36317364,-0.0415764,1.5412658,-0.91019519,0.36317364,-0.0415764,1.5408624,-0.91019519,0.35887109,-0.043727675,1.5380803,-0.91021587,0.35994673,-0.043727675,1.538887,-0.91021587,0.36102237,-0.04587895,1.5394352,-0.91021587,0.36209801,-0.04587895,1.5401695,-0.91020553,0.36209801,-0.046954588,1.5397558,-0.91021587,0.36102237,-0.049105863,1.5394248,-0.91021587,0.35994673,-0.049105863,1.5385767,-0.91022622,0.35887109,-0.050181501,1.5379561,-0.91022622,0.35887109,-0.051257139,1.5377493,-0.91023656,0.35994673,-0.052332776,1.5381527,-0.91023656,0.35994673,-0.053418757,1.5383905,-0.91023656,0.36102237,-0.052332776,1.5394145,-0.91022622,0.36102237,-0.054494394,1.5389697,-0.91023656,0.36209801,-0.055570032,1.5396006,-0.91023656,0.36209801,-0.055570032,1.5391973,-0.91023656,0.36424928,-0.05664567,1.540428,-0.91022622,0.36102237,-0.059872583,1.5386595,-0.9102469,0.35994673,-0.06094822,1.5376045,-0.91025725,0.36102237,-0.059872583,1.5378631,-0.9102469,0.36317364,-0.06094822,1.5397351,-0.91023656,0.36424928,-0.062023858,1.5408107,-0.91023656,0.36424928,-0.062023858,1.5401695,-0.91023656,0.36102237,-0.063099496,1.5380182,-0.91025725,0.36317364,-0.064175133,1.5397144,-0.9102469,0.35994673,-0.064175133,1.5375321,-0.91025725,0.35994673,-0.065250771,1.5373563,-0.91026759,0.35779546,-0.066326409,1.5356394,-0.91026759,0.35779546,-0.065250771,1.5357221,-0.91026759,0.35994673,-0.067412389,1.5375218,-0.91026759,0.35887109,-0.069563664,1.5366323,-0.91027793,0.35779546,-0.070639302,1.535929,-0.91027793,0.38148017,0.10267282,1.5415657,-0.90977114,0.3664109,-0.069563664,1.5421139,-0.9102469,0.36748654,-0.068488027,1.5431378,-0.9102469,0.36748654,-0.068488027,1.5434274,-0.9102469,0.3664109,-0.069563664,1.542538,-0.9102469,0.36424928,-0.07171494,1.5405522,-0.91025725,0.36856218,-0.07171494,1.5434998,-0.9102469,0.36532492,-0.07171494,1.5416795,-0.91025725,0.36532492,-0.072790577,1.5417933,-0.91025725,0.3664109,-0.073866215,1.5417002,-0.91025725,0.36748654,-0.072790577,1.5425069,-0.91025725,0.36748654,-0.073866215,1.542993,-0.91025725,0.36963781,-0.073866215,1.5445651,-0.9102469,0.37071345,-0.074941853,1.5448754,-0.91027793,0.3664109,-0.074941853,1.5421036,-0.91025725,0.36102237,-0.077093128,1.5376252,-0.91028827,0.36424928,-0.078168766,1.5399213,-0.91027793,0.36424928,-0.078168766,1.5402522,-0.91027793,0.36209801,-0.079244403,1.5387008,-0.91028827,0.35133129,-0.081406021,1.5311403,-0.91029862,0.36209801,-0.079244403,1.5392283,-0.91028827,0.36209801,-0.080330384,1.5388146,-0.91028827,0.36209801,-0.080330384,1.5382871,-0.91028827,0.35994673,-0.081406021,1.5373976,-0.91029862,0.35779546,-0.082481659,1.5357118,-0.91030896,0.36209801,-0.081406021,1.5385871,-0.91028827,0.36209801,-0.082481659,1.5388456,-0.91029862,0.36209801,-0.082481659,1.5385147,-0.91029862,0.36102237,-0.084632934,1.5378941,-0.91029862,0.36424928,-0.083557297,1.5401902,-0.91028827,0.36209801,-0.084632934,1.5387008,-0.91029862,0.36856218,-0.083557297,1.5433654,-0.91027793,0.36856218,-0.084632934,1.5429103,-0.91027793,0.36856218,-0.084632934,1.543355,-0.91027793,0.37178909,-0.083557297,1.5450926,-0.91028827,0.37178909,-0.084632934,1.5452891,-0.91028827,0.37071345,-0.084632934,1.5445755,-0.91026759,0.36963781,-0.085708572,1.5437998,-0.91027793,0.37071345,-0.085708572,1.5443686,-0.91026759,0.37178909,-0.085708572,1.5451133,-0.91029862,0.36963781,-0.08678421,1.543355,-0.91027793,0.36963781,-0.08678421,1.5435308,-0.91027793,0.37178909,-0.087859847,1.5446065,-0.91026759,0.37286473,-0.087859847,1.5457132,-0.91029862,0.37286473,-0.087859847,1.5456821,-0.91029862,0.37394036,-0.088935485,1.5467371,-0.91029862,0.37178909,-0.088935485,1.5452374,-0.91029862,0.37178909,-0.088935485,1.5453615,-0.91029862,0.37178909,-0.090011123,1.5453408,-0.91030896,0.37286473,-0.090011123,1.5458683,-0.91029862,0.37178909,-0.090011123,1.5448444,-0.91030896,0.37394036,-0.09108676,1.546282,-0.91029862,0.37609164,-0.090011123,1.5475231,-0.91028827,0.375016,-0.090011123,1.5469336,-0.91029862,0.37609164,-0.09108676,1.5480816,-0.91028827,0.37286473,-0.092162398,1.5459097,-0.91030896,0.37286473,-0.092162398,1.5459717,-0.91030896,0.37286473,-0.093238036,1.5459924,-0.91030896,0.37178909,-0.093238036,1.5452788,-0.91030896,0.37286473,-0.093238036,1.5458476,-0.91030896,0.37178909,-0.094324016,1.5448754,-0.9103193,0.37286473,-0.094324016,1.5457028,-0.91030896,0.37286473,-0.094324016,1.5457028,-0.91030896,0.37286473,-0.094324016,1.5457028,-0.91030896,0.37286473,-0.094324016,1.5457028,-0.91030896,0.37286473,-0.094324016,1.5457028,-0.91030896,0.37286473,-0.094324016,1.5457028,-0.91030896,0.37286473,-0.094324016,1.5457028,-0.91030896:0
-0.69868325,-0.69868325,1.6585966,-0.69868325,-0.69868325,-0.69868325,1.664828,-0.69868325,-0.69868325,-0.69868325,1.6625349,-0.69868325,-0.69868325,-0.69868325,1.6568917,-0.69868325,-0.69868325,-0.69868325,1.6615777,-0.69868325,-0.69868325,-0.69868325,1.6617771,-0.69868325,-0.69868325,-0.69868325,1.6622457,-0.69868325,-0.69868325,-0.69868325,1.6629835,-0.69868325,-0.69868325,-0.69868325,1.6623654,-0.69868325,-0.69868325,-0.69868325,1.6611191,-0.69868325,-0.69868325,-0.69868325,1.6636416,-0.69868325,-0.69868325,-0.69868325,1.6625249,-0.69868325,-0.69868325,-0.69868325,1.6599925,-0.69868325,-0.69868325,-0.69868325,1.6610493,-0.69868325,-0.69868325,-0.69868325,1.6638609,-0.69868325,-0.69868325,-0.69868325,1.6595837,-0.69868325,-0.69868325,-0.69868325,1.6591649,-0.69868325,-0.69868325,-0.69868325,1.6577192,-0.69868325,-0.69868325,-0.69868325,1.6599127,-0.69868325,-0.69868325,-0.69868325,1.6620264,-0.69868325,-0.69868325,-0.69868325,1.6606704,-0.69868325,-0.69868325,-0.69868325,1.6605907,-0.69868325,-0.69868325,-0.69868325,1.6587761,-0.69868325,-0.69868325,-0.69868325,1.6607402,-0.69868325,-0.69868325,-0.69868325,1.6622557,-0.69868325,-0.69868325,-0.69868325,1.6649277,-0.69868325,-0.69868325,-0.69868325,1.6650474,-0.69868325,-0.69868325,-0.69868325,1.6645788,-0.69868325,-0.69868325,-0.69868325,1.6639706,-0.69868325,-0.69868325,-0.69868325,1.663811,-0.69868325,-0.69868325,-0.69868325,1.6635718,-0.69868325,-0.69868325,-0.69868325,1.6663535,-0.69868325,-0.69868325,-0.69868325,1.6673804,-0.69868325,-0.69868325,-0.69868325,1.6618768,-0.69868325,-0.69868325,-0.69868325,1.661468,-0.69868325,-0.69868325,-0.69868325,1.6623953,-0.69868325,-0.69868325,-0.69868325,1.659474,-0.69868325,-0.69868325,-0.69868325,1.6590154,-0.69868325,-0.69868325,-0.69868325,1.6619666,-0.69868325,-0.69868325,-0.69868325,1.6537511,-0.69868325,-0.69868325,-0.69868325,1.655466,-0.69868325,-0.69868325,-0.69868325,1.6556753,-0.69868325,-0.69868325,-0.69868325,1.6583075,-0.69868325,-0.69868325,-0.69868325,1.6583673,-0.69868325,-0.69868325,-0.69868325,1.6584371,-0.69868325,-0.69868325,-0.69868325,1.6620862,-0.69868325,-0.69868325,-0.69868325,1.6592547,-0.69868325,-0.69868325,-0.69868325,1.6578489,-0.69868325,-0.69868325,-0.69868325,1.6562835,-0.69868325,-0.69868325,-0.69868325,1.6546584,-0.69868325,-0.69868325,-0.69868325,1.661468,-0.69868325,-0.69868325,-0.69868325,1.658457,-0.69868325,-0.69868325,-0.69868325,1.6606206,-0.69868325,-0.69868325,-0.69868325,1.6586864,-0.69868325,-0.69868325,-0.69868325,1.6580782,-0.69868325,-0.69868325,-0.69868325,1.6538707,-0.69868325,-0.69868325,-0.69868325,1.6547182,-0.69868325,-0.69868325,-0.69868325,1.654788,-0.69868325,-0.69868325,-0.69868325,1.6552267,-0.69868325,-0.69868325,-0.69868325,1.6550572,-0.69868325,-0.69868325,-0.69868325,1.6590353,-0.69868325,-0.69868325,-0.69868325,1.6586564,-0.69868325,-0.69868325,-0.69868325,1.6592048,-0.69868325,-0.69868325,-0.69868325,1.6599526,-0.69868325,-0.69868325,-0.69868325,1.6616375,-0.69868325,-0.69868325,-0.69868325,1.6589755,-0.69868325,-0.69868325,-0.69868325,1.6590154,-0.69868325,-0.69868325,-0.69868325,1.6586465,-0.69868325,-0.69868325,-0.69868325,1.6584072,-0.69868325,-0.69868325,-0.69868325,1.6579286,-0.69868325,-0.69868325,-0.69868325,1.6508398,-0.69868325,-0.69868325,-0.69868325,1.6593145,-0.69868325,-0.69868325,-0.69868325,1.6614481,-0.69868325,-0.69868325,-0.69868325,1.659145,-0.69868325,-0.69868325,-0.69868325,1.6595139,-0.69868325,-0.69868325,-0.69868325,1.6581181,-0.69868325,-0.69868325,-0.69868325,1.6592746,-0.69868325,-0.69868325,-0.69868325,1.6608599,-0.69868325,-0.69868325,-0.69868325,1.6615478,-0.69868325,-0.69868325,-0.69868325,1.6596335,-0.69868325,-0.69868325,-0.69868325,1.6598828,-0.69868325,-0.69868325,-0.69868325,1.6596136,-0.69868325,-0.69868325,-0.69868325,1.6606305,-0.69868325,-0.69868325,-0.69868325,1.6583175,-0.69868325,-0.69868325,-0.69868325,1.6568817,-0.69868325,-0.69868325,-0.69868325,1.6593743,-0.69868325,-0.69868325,-0.69868325,1.6611889,-0.69868325,-0.69868325,-0.69868325,1.6624451,-0.69868325,-0.69868325,-0.69868325,1.6627941,-0.69868325,-0.69868325,-0.69868325,1.6619965,-0.69868325,-0.69868325,-0.69868325,1.6622956,-0.69868325,-0.69868325,-0.69868325,1.6623355,-0.69868325,-0.69868325,-0.69868325,1.6641401,-0.69868325,-0.69868325,-0.69868325,1.6645289,-0.69868325,-0.69868325,-0.69868325,1.6614581,-0.69868325,-0.69868325,-0.69868325,1.6596734,-0.69868325,-0.69868325,-0.69868325,1.6612686,-0.69868325,-0.69868325,-0.69868325,1.6601021,-0.69868325,-0.69868325,-0.69868325,1.6603813,-0.69868325,-0.69868325,-0.69868325,1.6620264,-0.69868325,-0.69868325,-0.69868325,1.663163,-0.69868325,-0.69868325,-0.69868325,1.6616475,-0.69868325,-0.69868325,-0.69868325,1.6606904,-0.69868325,-0.69868325,-0.69868325,1.6625349,-0.69868325,-0.69868325,-0.69868325,1.6622557,-0.69868325,-0.69868325,-0.69868325,1.662156,-0.69868325,-0.69868325,-0.69868325,1.6624651,-0.69868325,-0.69868325,-0.69868325,1.6626047,-0.69868325,-0.69868325,-0.69868325,1.6634421,-0.69868325,-0.69868325,-0.69868325,1.6641201,-0.69868325,-0.69868325,-0.69868325,1.6639207,-0.69868325,-0.69868325,-0.69868325,1.6597233,-0.69868325,-0.69868325,-0.69868325,1.6629237,-0.69868325,-0.69868325,-0.69868325,1.6626246,-0.69868325,-0.69868325,-0.69868325,1.6617173,-0.69868325,-0.69868325,-0.69868325,1.6619666,-0.69868325,-0.69868325,-0.69868325,1.661498,-0.69868325,-0.69868325,-0.69868325,1.6595737,-0.69868325,-0.69868325,-0.69868325,1.6546484,-0.69868325,-0.69868325,-0.69868325,1.6551968,-0.69868325,-0.69868325,-0.69868325,1.6549974,-0.69868325,-0.69868325,-0.69868325,1.6579585,-0.69868325,-0.69868325,-0.69868325,1.6566624,-0.69868325,-0.69868325,-0.69868325,1.6594241,-0.69868325,-0.69868325,-0.69868325,1.6597731,-0.69868325,-0.69868325,-0.69868325,1.662485,-0.69868325,0.30268611,0.054676801,1.6595039,-0.6933791,0.30164921,0.037039476,1.6584969,-0.69342895,0.30164921,0.044307769,1.6588658,-0.69340901,0.30164921,0.033928766,1.6589256,-0.69343892,0.30164921,0.024586667,1.6588359,-0.69345886,0.30164921,0.017328344,1.6591051,-0.6934788,0.30164921,0.0090231478,1.6588957,-0.69349874,0.3006123,0.0038286614,1.657799,-0.69350871,0.3006123,-0.0034296613,1.6575697,-0.69352865,0.2995754,-0.0096610509,1.656473,-0.69354859,0.3006123,-0.012771761,1.6576195,-0.69354859,0.30373298,-0.016919374,1.6602018,-0.69354859,0.30164921,-0.020030083,1.6579087,-0.69356853,0.3006123,-0.023150763,1.6573902,-0.6935785,0.30164921,-0.027298376,1.6582875,-0.69358847,0.30268611,-0.029372183,1.6590652,-0.69358847,0.30164921,-0.031445989,1.6567023,-0.69358847,0.30268611,-0.031445989,1.6576295,-0.69358847,0.30373298,-0.032482892,1.658816,-0.69358847,0.30373298,-0.037677379,1.6587661,-0.69359844,0.30373298,-0.037677379,1.6589555,-0.69359844,0.30164921,-0.040788089,1.65745,-0.69361838,0.30164921,-0.041824992,1.6576594,-0.69361838,0.30373298,-0.044935702,1.6585368,-0.69361838,0.3078806,-0.042861895,1.6617372,-0.69359844,0.30476989,-0.048046411,1.6594441,-0.69361838,0.30164921,-0.048046411,1.6574899,-0.69362835,0.30268611,-0.050130188,1.6573304,-0.69363832,0.30164921,-0.050130188,1.6568518,-0.69363832,0.3006123,-0.052203994,1.6562436,-0.69364829,0.2985385,-0.055314704,1.6529934,-0.69363832,0.3006123,-0.054277801,1.6557551,-0.69364829,0.3006123,-0.055314704,1.6549375,-0.69364829,0.29646469,-0.057388511,1.6522755,-0.69364829,0.3006123,-0.057388511,1.6556654,-0.69365826,0.30164921,-0.059462317,1.6565029,-0.69365826,0.3006123,-0.06049922,1.6559246,-0.69366823,0.3006123,-0.062582997,1.6545088,-0.69366823,0.30164921,-0.062582997,1.6563533,-0.69366823,0.2995754,-0.062582997,1.6559346,-0.69366823,0.2985385,-0.06673061,1.6536514,-0.69366823,0.29439088,-0.065693707,1.6495835,-0.6936782,0.2985385,-0.065693707,1.6540103,-0.69365826,0.2995754,-0.064656804,1.6561739,-0.6936782,0.30268611,-0.06673061,1.6587262,-0.69366823,0.30268611,-0.06673061,1.658467,-0.69366823,0.30373298,-0.06673061,1.6585268,-0.69366823,0.30476989,-0.068804417,1.6596335,-0.69366823,0.3006123,-0.071915126,1.6559146,-0.69368817,0.30373298,-0.071915126,1.6591948,-0.6936782,0.30580679,-0.07295203,1.6616774,-0.6936782,0.30684369,-0.07295203,1.6625548,-0.69366823,0.30684369,-0.076072709,1.6603813,-0.6936782,0.3089175,-0.073988933,1.6614182,-0.69366823,0.30684369,-0.076072709,1.6616475,-0.6936782,0.3089175,-0.075035806,1.6635917,-0.69366823,0.3089175,-0.076072709,1.6625149,-0.69366823,0.3099544,-0.075035806,1.6625648,-0.69366823,-0.69868325,-0.69868325,1.6649277,-0.69868325,-0.69868325,-0.69868325,1.6641999,-0.69868325,-0.69868325,-0.68208283,1.6655359,-0.69861346,-0.69868325,-0.69868325,1.667191,-0.69868325,-0.69868325,-0.69868325,1.6664033,-0.69868325,-0.69868325,-0.69868325,1.6665329,-0.69868325,-0.69868325,-0.69868325,1.6616774,-0.69868325,-0.69868325,-0.69868325,1.6674103,-0.69868325,-0.69868325,-0.69868325,1.6704911,-0.69868325,-0.69868325,-0.69868325,1.6675997,-0.69868325,-0.69868325,-0.69868325,1.6684073,-0.69868325,-0.69868325,-0.69868325,1.6682179,-0.69868325,-0.69868325,-0.69868325,1.6706107,-0.69868325,-0.69868325,-0.69868325,1.6686167,-0.69868325,-0.69868325,-0.69868325,1.6700424,-0.69868325,-0.69868325,-0.69868325,1.6691052,-0.69868325,-0.69868325,-0.69868325,1.6680185,-0.69868325,-0.69868325,-0.69868325,1.6667423,-0.69868325,-0.69868325,-0.69868325,1.669843,-0.69868325,-0.69868325,-0.69868325,1.6681282,-0.69868325,-0.69868325,-0.69868325,1.6694442,-0.69868325,-0.69868325,-0.69868325,1.6676097,-0.69868325,-0.69868325,-0.69868325,1.6637413,-0.69868325,-0.69868325,-0.69868325,1.6693844,-0.69868325,-0.69868325,-0.69868325,1.6699427,-0.69868325,-0.69868325,-0.69868325,1.6706107,-0.69868325,-0.69868325,-0.69868325,1.6695938,-0.69868325,-0.69868325,-0.69868325,1.6737713,-0.69868325,-0.69868325,-0.69868325,1.6750275,-0.69868325,-0.69868325,-0.69868325,1.6774503,-0.69868325,-0.69868325,-0.69868325,1.673871,-0.69868325,-0.69868325,-0.69868325,1.6696735,-0.69868325,-0.69868325,-0.69868325,1.6689956,-0.69868325,-0.69868325,-0.69868325,1.6677593,-0.69868325,-0.69868325,-0.69868325,1.6706905,-0.69868325,-0.69868325,-0.69868325,1.669504,-0.69868325,-0.69868325,-0.69868325,1.6721462,-0.69868325,-0.69868325,-0.69868325,1.6687962,-0.69868325,-0.69868325,-0.69868325,1.6692249,-0.69868325,-0.69868325,-0.69868325,1.6708301,-0.69868325,-0.69868325,-0.69868325,1.6686067,-0.69868325,-0.69868325,-0.69868325,1.6700424,-0.69868325,-0.69868325,-0.69868325,1.6636416,-0.69868325,-0.69868325,-0.69868325,1.6701721,-0.69868325,-0.69868325,-0.69868325,1.6715779,-0.69868325,-0.69868325,-0.69868325,1.6678988,-0.69868325,-0.69868325,-0.69868325,1.6662039,-0.69868325,-0.69868325,-0.69868325,1.6711691,-0.69868325,-0.69868325,-0.69868325,1.6705409,-0.69868325,-0.69868325,-0.69868325,1.6672408,-0.69868325,-0.69868325,-0.69868325,1.6688759,-0.69868325,-0.69868325,-0.69868325,1.6689457,-0.69868325,-0.69868325,-0.69868325,1.6694542,-0.69868325,-0.69868325,-0.69868325,1.6690953,-0.69868325,-0.69868325,-0.69868325,1.6716078,-0.69868325,-0.69868325,-0.69868325,1.6760645,-0.69868325,-0.69868325,-0.69868325,1.6709497,-0.69868325,-0.69868325,-0.69868325,1.6726546,-0.69868325,-0.69868325,-0.69868325,1.6734124,-0.69868325,-0.69868325,-0.69868325,1.6698331,-0.69868325,-0.69868325,-0.69868325,1.675885,-0.69868325,-0.69868325,-0.69868325,1.6766328,-0.69868325,-0.69868325,-0.69868325,1.6777893,-0.69868325,-0.69868325,-0.69868325,1.679225,-0.69868325,-0.69868325,-0.69868325,1.6491149,-0.69868325,-0.69868325,-0.69868325,1.6522456,-0.69868325,-0.69868325,-0.69868325,1.6542695,-0.69868325,-0.69868325,-0.69868325,1.6517072,-0.69868325,-0.69868325,-0.69868325,1.6451169,-0.69868325,-0.69868325,-0.69868325,1.6450271,-0.69868325,-0.69868325,-0.69868325,1.6460541,-0.69868325,-0.69868325,-0.69868325,1.6429234,-0.69868325,-0.69868325,-0.69868325,1.6428138,-0.69868325,-0.69868325,-0.69868325,1.6415276,-0.69868325,-0.69868325,-0.69868325,1.6432624,-0.69868325,-0.69868325,-0.69868325,1.6416572,-0.69868325,-0.69868325,-0.69868325,1.6406303,-0.69868325,-0.69868325,-0.69868325,1.6415475,-0.69868325,-0.69868325,-0.69868325,1.6435316,-0.69868325,-0.69868325,-0.69868325,1.6422554,-0.69868325,-0.69868325,-0.69868325,1.6420859,-0.69868325,-0.69868325,-0.69868325,1.6442096,-0.69868325,-0.69868325,-0.69868325,1.6426144,-0.69868325,-0.69868325,-0.69868325,1.6445685,-0.69868325,-0.69868325,-0.69868325,1.6465825,-0.69868325,-0.69868325,-0.69868325,1.6465825,-0.69868325,-0.69868325,-0.69868325,1.650092,-0.69868325,-0.69868325,-0.69868325,1.6509893,-0.69868325,-0.69868325,-0.69868325,1.6574002,-0.69868325,-0.69868325,-0.69868325,1.6570811,-0.69868325,-0.69868325,-0.69868325,1.6619466,-0.69868325,-0.69868325,-0.69868325,1.6667224,-0.69868325,-0.69868325,-0.69868325,1.6601819,-0.69868325,-0.69868325,-0.69868325,1.6564131,-0.69868325,-0.69868325,-0.69868325,1.6576694,-0.69868325,-0.69868325,-0.69868325,1.6570213,-0.69868325,-0.69868325,-0.69868325,1.6605608,-0.69868325,-0.69868325,-0.69868325,1.6496134,-0.69868325,-0.69868325,-0.69868325,1.6475396,-0.69868325,-0.69868325,-0.69868325,1.6452266,-0.69868325,-0.69868325,-0.69868325,1.6453562,-0.69868325,-0.69868325,-0.69868325,1.6418865,-0.69868325,-0.69868325,-0.69868325,1.6378785,-0.69868325,-0.69868325,-0.69868325,1.6363531,-0.69868325,-0.69868325,-0.69868325,1.6280778,-0.69868325,-0.69868325,-0.69868325,1.6261635,-0.69868325,-0.69868325,-0.69868325,1.6295135,-0.69868325,-0.69868325,-0.69868325,1.6291446,-0.69868325,-0.69868325,-0.69868325,1.6296232,-0.69868325,-0.69868325,-0.69868325,1.6296331,-0.69868325,-0.69868325,-0.69868325,1.6284766,-0.69868325,-0.69868325,-0.69868325,1.6271505,-0.69868325,-0.69868325,-0.69868325,1.6202511,-0.69868325,-0.69868325,-0.69868325,1.6269113,-0.69868325,-0.69868325,-0.69868325,1.6275294,-0.69868325,-0.69868325,-0.69868325,1.631667,-0.69868325,-0.69868325,-0.69868325,1.6303709,-0.69868325,-0.69868325,-0.69868325,1.631029,-0.69868325,-0.69868325,-0.69868325,1.6298226,-0.69868325,-0.69868325,-0.69868325,1.6285962,-0.69868325,-0.69868325,-0.69868325,1.6349672,-0.69868325,-0.69868325,-0.69868325,1.6333022,-0.69868325,-0.69868325,-0.69868325,1.636034,-0.69868325,-0.69868325,-0.69868325,1.6328236,-0.69868325,-0.69868325,-0.69868325,1.6358845,-0.69868325,-0.69868325,-0.69868325,1.6350968,-0.69868325,-0.69868325,-0.69868325,1.6357349,-0.69868325,-0.69868325,-0.69868325,1.6339303,-0.69868325,-0.69868325,-0.69868325,1.6337907,-0.69868325,-0.69868325,-0.69868325,1.6342593,-0.69868325,-0.69868325,-0.69868325,1.6338206,-0.69868325,-0.69868325,-0.69868325,1.6317667,-0.69868325,-0.69868325,-0.69868325,1.6349273,-0.69868325,-0.69868325,-0.69868325,1.6364627,-0.69868325,-0.69868325,-0.69868325,1.6353261,-0.69868325,-0.69868325,-0.69868325,1.6348874,-0.69868325,-0.69868325,-0.69868325,1.6359842,-0.69868325,-0.69868325,-0.69868325,1.6365425,-0.69868325,-0.69868325,-0.69868325,1.6334318,-0.69868325,-0.69868325,-0.69868325,1.6336212,-0.69868325,-0.69868325,-0.69868325,1.6310987,-0.69868325,-0.69868325,-0.69868325,1.63069,-0.69868325,-0.69868325,-0.69868325,1.6312284,-0.69868325,-0.69868325,-0.69868325,1.633372,-0.69868325,0.78626189,3.3089079,1.6151663,-0.67063702,0.26844836,0.02562357,1.6285663,-0.69349874,0.26637456,0.021475957,1.6274397,-0.69351868,0.26948527,0.020439054,1.6301217,-0.69350871,0.26948527,0.012133858,1.6302214,-0.69353862,0.27052217,0.0059124381,1.6307897,-0.69354859,0.27155907,0.0017548549,1.6317568,-0.69354859,0.27259598,-0.0075772742,1.6329034,-0.69356853,0.27363288,-0.012771761,1.6335614,-0.6935785,0.27466978,-0.01899318,1.6343889,-0.69361838,0.27155907,-0.02210389,1.6317967,-0.69360841,0.27155907,-0.027298376,1.6318864,-0.69362835,0.27259598,-0.028335279,1.6322453,-0.69362835,0.27259598,-0.031445989,1.6325943,-0.69362835,0.27570669,-0.033519796,1.6344886,-0.69364829,0.27570669,-0.037677379,1.6345484,-0.69365826,0.27779046,-0.038714282,1.6369313,-0.69364829,0.27882737,-0.041824992,1.6375794,-0.69365826,0.28090117,-0.040788089,1.6395336,-0.69364829,0.27570669,-0.045972605,1.635356,-0.6936782,0.27363288,-0.045972605,1.6324348,-0.69365826,0.27155907,-0.052203994,1.6295434,-0.69368817,0.27674359,-0.049093285,1.6343291,-0.69365826,0.27466978,-0.052203994,1.6329333,-0.6936782,0.26844836,-0.053240898,1.6281376,-0.69369814,0.27259598,-0.054277801,1.6318565,-0.69368817,0.27570669,-0.056351607,1.6352065,-0.69369814,0.27674359,-0.054277801,1.6360938,-0.69368817,0.27882737,-0.057388511,1.6376891,-0.69368817,0.27986427,-0.058425414,1.6376592,-0.69368817,0.27986427,-0.058425414,1.6376592,-0.69368817,0.27986427,-0.058425414,1.6376592,-0.69368817,0.27986427,-0.058425414,1.6376592,-0.69368817,0.27986427,-0.058425414,1.6376592,-0.69368817,0.27986427,-0.058425414,1.6376592,-0.69368817,0.27986427,-0.058425414,1.6376592,-0.69368817,0.27986427,-0.058425414,1.6376592,-0.69368817:0
-0.86708758,-0.76305352,1.4164543,-0.76956283,-0.86808312,-0.76305352,1.4185699,-0.76956283,-0.86907866,-0.76305352,1.4318469,-0.76956283,-0.86808312,-0.76305352,1.4281711,-0.76956283,-0.86907866,-0.76305352,1.4285923,-0.76956283,-0.86610161,-0.76305352,1.3997312,-0.76956283,-0.86610161,-0.76305352,1.4002864,-0.76956283,-0.86708758,-0.76305352,1.4056661,-0.76956283,-0.86610161,-0.76305352,1.3975869,-0.76956283,-0.86610161,-0.76305352,1.3985537,-0.76956283,-0.86610161,-0.76305352,1.4036367,-0.76956283,-0.86708758,-0.76305352,1.4164448,-0.76956283,-0.86808312,-0.76305352,1.4166649,-0.76956283,-0.86907866,-0.76305352,1.4304685,-0.76956283,-0.86808312,-0.76305352,1.4234614,-0.76956283,-0.86907866,-0.76305352,1.4285923,-0.76956283,-0.86907866,-0.76305352,1.4344219,-0.76956283,-0.86708758,-0.76305352,1.4074562,-0.76956283,-0.86708758,-0.76205798,1.4072934,-0.76956283,-0.86708758,-0.76305352,1.408021,-0.76956283,-0.86708758,-0.76305352,1.4120031,-0.76956283,-0.86610161,-0.76305352,1.4018275,-0.76956283,-0.86708758,-0.76305352,1.4070446,-0.76956283,-0.86610161,-0.76305352,1.3967445,-0.76956283,-0.86610161,-0.76305352,1.4007937,-0.76956283,-0.86510607,-0.76305352,1.3903692,-0.7695724,-0.86510607,-0.76305352,1.3946673,-0.76956283,-0.86610161,-0.76305352,1.4037516,-0.76956283,-0.86610161,-0.76305352,1.399645,-0.76956283,-0.86510607,-0.76305352,1.3935186,-0.76956283,-0.86510607,-0.76305352,1.3928964,-0.7695724,-0.86610161,-0.76305352,1.4025359,-0.76956283,-0.86708758,-0.76305352,1.4072934,-0.76956283,-0.86610161,-0.76305352,1.3983432,-0.76956283,-0.8641201,-0.76305352,1.3846449,-0.7695724,-0.8641201,-0.76305352,1.3839461,-0.7695724,-0.86510607,-0.76305352,1.39304,-0.76956283,-0.86312456,-0.76305352,1.3719039,-0.7695724,-0.8641201,-0.76305352,1.3790067,-0.7695724,-0.86510607,-0.76305352,1.3927337,-0.76956283,-0.86510607,-0.76305352,1.3909723,-0.7695724,-0.86510607,-0.76305352,1.3862052,-0.7695724,-0.86510607,-0.76305352,1.3863105,-0.7695724,-0.86510607,-0.76305352,1.3866264,-0.7695724,-0.8641201,-0.76305352,1.3819454,-0.7695724,-0.8641201,-0.76305352,1.3762498,-0.7695724,-0.8641201,-0.76305352,1.3780973,-0.7695724,-0.8641201,-0.76305352,1.3772645,-0.7695724,-0.8641201,-0.76305352,1.373378,-0.7695724,-0.8641201,-0.76305352,1.379447,-0.7695724,-0.8641201,-0.76305352,1.3825868,-0.7695724,-0.86610161,-0.76305352,1.4024019,-0.76956283,-0.86610161,-0.76305352,1.3997982,-0.76956283,-0.86510607,-0.76305352,1.3911446,-0.7695724,-0.86610161,-0.76305352,1.3962276,-0.76956283,-0.86708758,-0.76305352,1.4172489,-0.76956283,-0.86808312,-0.76305352,1.4203982,-0.76956283,-0.86708758,-0.76305352,1.4169713,-0.76956283,-0.86708758,-0.76305352,1.4105098,-0.76956283,-0.86808312,-0.76305352,1.4196228,-0.76956283,2.5447376,7.7938055,1.3714827,-0.71784254,0.74517235,0.56977521,1.3953757,-0.761005,0.74319084,0.57671529,1.3925709,-0.76097628,0.75409394,0.58166427,1.3987356,-0.76095714,0.75607545,0.58464133,1.399913,-0.76093799,0.76103401,0.58166427,1.4029954,-0.76094757,0.75607545,0.5677937,1.4004682,-0.76099543,0.76499703,0.54103853,1.4073413,-0.76107201,0.75706141,0.50734329,1.40446,-0.76117731,0.75309839,0.48653265,1.402086,-0.76124431,0.74418639,0.47266208,1.3972902,-0.76129218,0.75904292,0.47365762,1.4067957,-0.7612826,0.74418639,0.46869906,1.3965722,-0.76130175,0.75111688,0.46473604,1.4020956,-0.76131132,0.74715386,0.4637405,1.3989462,-0.76132089,0.73724631,0.46077302,1.392839,-0.76134004,0.73228775,0.45681,1.3899385,-0.76134961,0.73626035,0.45482849,1.3917381,-0.76134961,0.72436171,0.45185144,1.3848938,-0.76137833,0.73030624,0.44986993,1.3893163,-0.76137833,0.71743121,0.44788842,1.3801841,-0.7613879,0.74120933,0.44690245,1.3961798,-0.76137833,0.74319084,0.44492094,1.3970509,-0.76137833,0.75904292,0.44492094,1.4067574,-0.76135918,0.75211243,0.44094835,1.4033974,-0.76137833,0.75805696,0.43996238,1.407035,-0.76137833,0.75607545,0.43896684,1.4058767,-0.76137833,0.75904292,0.43698533,1.4078104,-0.7613879,-0.86708758,-0.76305352,1.4093707,-0.76956283,-0.86708758,-0.76305352,1.4096579,-0.76956283,-0.86610161,-0.76305352,1.3996833,-0.76956283,-0.86510607,-0.76305352,1.3905128,-0.7695724,-0.86610161,-0.76305352,1.4023253,-0.76956283,-0.86610161,-0.76305352,1.4037038,-0.76956283,-0.86708758,-0.76305352,1.4090356,-0.76956283,-0.86708758,-0.76305352,1.416014,-0.76956283,-0.86708758,-0.76305352,1.4149897,-0.76956283,-0.86610161,-0.76305352,1.4056566,-0.76956283,-0.86610161,-0.76305352,1.3974242,-0.76956283,-0.86510607,-0.76305352,1.394562,-0.76956283,-0.86610161,-0.76305352,1.4018371,-0.76956283,-0.8641201,-0.76305352,1.3813711,-0.7695724,-0.8641201,-0.76305352,1.3819646,-0.7695724,-0.86708758,-0.76305352,1.4130561,-0.76956283,-0.86708758,-0.76305352,1.4068148,-0.76956283,-0.86610161,-0.76305352,1.3983336,-0.76956283,-0.86510607,-0.76305352,1.3949162,-0.76956283,-0.86610161,-0.76305352,1.4050726,-0.76956283,-0.86708758,-0.76305352,1.411199,-0.76956283,-0.86610161,-0.76305352,1.4004682,-0.76956283,-0.86610161,-0.76305352,1.4029092,-0.76956283,-0.86610161,-0.76305352,1.4064702,-0.76956283,-0.86708758,-0.76305352,1.4102992,-0.76956283,-0.86708758,-0.76305352,1.4085187,-0.76956283,-0.86610161,-0.76305352,1.4016074,-0.76956283,-0.86708758,-0.76305352,1.406901,-0.76956283,-0.86610161,-0.76305352,1.4004778,-0.76956283,-0.86610161,-0.76305352,1.4008703,-0.76956283,-0.86610161,-0.76305352,1.3960075,-0.76956283,-0.86708758,-0.76305352,1.408758,-0.76956283,-0.86610161,-0.76305352,1.4038952,-0.76956283,-0.86610161,-0.76305352,1.3972232,-0.76956283,-0.86708758,-0.76305352,1.4087102,-0.76956283,-0.87006463,-0.76205798,1.4438509,-0.76955325,-0.86708758,-0.76305352,1.4138506,-0.76956283,-0.86610161,-0.76305352,1.4057331,-0.76956283,-0.86708758,-0.76305352,1.4104715,-0.76956283,-0.86708758,-0.76305352,1.4092271,-0.76956283,-0.86708758,-0.76305352,1.4169043,-0.76956283,-0.86708758,-0.76305352,1.4125775,-0.76956283,-0.86610161,-0.76305352,1.400832,-0.76956283,-0.86708758,-0.76305352,1.4072647,-0.76956283,-0.86610161,-0.76305352,1.4065947,-0.76956283,-0.86708758,-0.76305352,1.4105194,-0.76956283,-0.86708758,-0.76305352,1.4093324,-0.76956283,-0.86708758,-0.76305352,1.4086815,-0.76956283,-0.86708758,-0.76305352,1.4131231,-0.76956283,-0.86610161,-0.76305352,1.3984963,-0.76956283,-0.86510607,-0.76305352,1.3958926,-0.76956283,-0.86610161,-0.76305352,1.4021722,-0.76956283,-0.86907866,-0.76305352,1.4332254,-0.76956283,-0.86808312,-0.76305352,1.4228871,-0.76956283,-0.86907866,-0.76305352,1.4291188,-0.76956283,-0.86907866,-0.76305352,1.4313109,-0.76956283,-0.86907866,-0.76305352,1.4315215,-0.76956283,-0.86907866,-0.76305352,1.4347283,-0.76956283,-0.87006463,-0.76205798,1.4492881,-0.76955325,-0.87106017,-0.76205798,1.459052,-0.76955325,-0.87106017,-0.76205798,1.4552134,-0.76955325,-0.87106017,-0.76205798,1.4532415,-0.76955325,-0.87006463,-0.76205798,1.4439753,-0.76955325,0.80958579,0.6767959,1.4364992,-0.76063167,0.83832247,0.58364578,1.4529256,-0.76089013,0.83435945,0.59058586,1.4492019,-0.76087099,0.83832247,0.59454888,1.4519779,-0.76086141,0.85120707,0.59752593,1.4601146,-0.76084227,0.85417455,0.59256737,1.461426,-0.76085184,0.84328103,0.57175672,1.4559697,-0.76092842,0.81949334,0.54004299,1.442683,-0.76104329,0.85219304,0.51230185,1.4626704,-0.76108158,0.82048888,0.49149121,1.4441668,-0.76117731,0.82741938,0.48256963,1.4489626,-0.76118688,0.82147485,0.4766251,1.4467513,-0.7612156,0.82741938,0.47563913,1.449738,-0.7612156,0.81553032,0.47167611,1.4422906,-0.76123474,0.81058133,0.47068057,1.4399836,-0.76124431,0.81652586,0.47068057,1.4433435,-0.76123474,0.83535499,0.47167611,1.4540552,-0.7612156,0.84030398,0.46671755,1.4580278,-0.76122517,0.81949334,0.4637405,1.4446071,-0.76125389,0.82048888,0.46275453,1.4452293,-0.76125389,0.82048888,0.45879151,1.4455452,-0.76126346,0.83237794,0.45879151,1.4527054,-0.76125389,0.81652586,0.45383295,1.4445114,-0.76129218,0.82841492,0.45383295,1.4505038,-0.76127303,0.8313824,0.45284698,1.4528107,-0.76127303,0.83832247,0.45185144,1.4559792,-0.76126346,0.83337348,0.44986993,1.4546391,-0.7612826,0.82345636,0.44492094,1.4486371,-0.76131132,0.83535499,0.44590691,1.4552709,-0.76129218,-0.87204614,-0.76205798,1.4656188,-0.76955325,-0.87006463,-0.76305352,1.4503123,-0.76955325,-0.87106017,-0.76205798,1.4559027,-0.76955325,-0.87106017,-0.76205798,1.4515472,-0.76955325,-0.87106017,-0.76205798,1.4562186,-0.76955325,-0.87006463,-0.76205798,1.4480915,-0.76955325,-0.87006463,-0.76305352,1.4429893,-0.76955325,-0.86907866,-0.76305352,1.4349197,-0.76956283,-0.87006463,-0.76205798,1.4477182,-0.76955325,-0.87006463,-0.76305352,1.4378968,-0.76955325,-0.87006463,-0.76305352,1.4427117,-0.76955325,-0.86907866,-0.76305352,1.4323639,-0.76956283,-0.87006463,-0.76205798,1.4452676,-0.76955325,-0.86907866,-0.76305352,1.4333211,-0.76956283,-0.86907866,-0.76305352,1.4375426,-0.76956283,-0.86907866,-0.76205798,1.4347761,-0.76956283,-0.86907866,-0.76305352,1.4381935,-0.76956283,-0.86808312,-0.76305352,1.4252132,-0.76956283,-0.87006463,-0.76205798,1.439706,-0.76956283,-0.87006463,-0.76305352,1.4429893,-0.76955325,-0.87006463,-0.76305352,1.4436786,-0.76955325,-0.87006463,-0.76205798,1.4406824,-0.76955325,-0.87006463,-0.76305352,1.4472587,-0.76955325,-0.87006463,-0.76205798,1.4470768,-0.76955325,-0.87006463,-0.76205798,1.4479096,-0.76955325,-0.87006463,-0.76205798,1.4488094,-0.76955325,-0.87006463,-0.76305352,1.4429606,-0.76955325,-0.87006463,-0.76305352,1.4431904,-0.76955325,-0.86907866,-0.76305352,1.4367289,-0.76956283,-0.87006463,-0.76305352,1.4479,-0.76955325,-0.86907866,-0.76305352,1.4383754,-0.76956283,-0.87006463,-0.76205798,1.4425011,-0.76955325,-0.87006463,-0.76305352,1.4453346,-0.76955325,-0.86907866,-0.76305352,1.439505,-0.76956283,-0.86907866,-0.76305352,1.438921,-0.76956283,-0.87006463,-0.76305352,1.4426447,-0.76955325,-0.87006463,-0.76205798,1.4448847,-0.76955325,-0.87006463,-0.76305352,1.4431617,-0.76955325,-0.86907866,-0.76205798,1.4380595,-0.76955325,-0.86907866,-0.76305352,1.4409217,-0.76956283,-0.87006463,-0.76205798,1.4415726,-0.76955325,-0.86907866,-0.76305352,1.4336753,-0.76956283,-0.86907866,-0.76305352,1.435226,-0.76956283,-0.87006463,-0.76305352,1.4395528,-0.76955325,-0.86907866,-0.76305352,1.4385094,-0.76956283,-0.87006463,-0.76205798,1.4429606,-0.76955325,-0.87006463,-0.76305352,1.4431808,-0.76955325,-0.87106017,-0.76205798,1.4518248,-0.76955325,-0.87006463,-0.76305352,1.4495082,-0.76955325,-0.87006463,-0.76205798,1.4479383,-0.76955325,-0.87106017,-0.76305352,1.4535383,-0.76955325,-0.87006463,-0.76205798,1.451327,-0.76955325,-0.87006463,-0.76305352,1.4498624,-0.76955325,-0.87006463,-0.76205798,1.4494987,-0.76955325,-0.87006463,-0.76205798,1.4483021,-0.76955325,-0.87006463,-0.76305352,1.4453346,-0.76955325,-0.87006463,-0.76205798,1.4445975,-0.76955325,-0.86907866,-0.76205798,1.4362982,-0.76956283,-0.87006463,-0.76205798,1.4431329,-0.76955325,-0.87006463,-0.76305352,1.4417066,-0.76955325,-0.87006463,-0.76205798,1.4446358,-0.76955325,-0.87006463,-0.76305352,1.4404813,-0.76955325,0.80264572,0.94336165,1.4284966,-0.75958827,0.80264572,0.57571974,1.4321341,-0.76094757,0.81652586,0.5876088,1.4389306,-0.7608997,0.82147485,0.59256737,1.4416205,-0.76088056,0.83435945,0.59554442,1.4496135,-0.76086141,0.844267,0.58860435,1.4554432,-0.76087099,0.844267,0.57473378,1.4568982,-0.76090928,0.82345636,0.54103853,1.4459281,-0.76103372,0.82247039,0.5093248,1.4457271,-0.76112944,0.83535499,0.49347272,1.4537393,-0.76115816,0.83237794,0.48256963,1.452246,-0.76118688,0.80364126,0.47365762,1.4358004,-0.76124431,0.8244519,0.47464359,1.4471055,-0.7612156,0.82048888,0.47167611,1.4454973,-0.76122517,0.83237794,0.47167611,1.4522172,-0.7612156,0.82940089,0.4696946,1.4508962,-0.76122517,0.8244519,0.46671755,1.4470002,-0.76123474,0.82940089,0.46572201,1.4500539,-0.76123474,0.8313824,0.46572201,1.4519588,-0.76123474,0.83237794,0.46275453,1.4516429,-0.76124431,0.82345636,0.45879151,1.4476703,-0.76126346,0.83931801,0.45879151,1.4558548,-0.76124431,0.82841492,0.45482849,1.4508771,-0.76127303,0.82048888,0.45284698,1.4449134,-0.7612826,0.80562277,0.44986993,1.4373128,-0.76131132,0.8373365,0.45185144,1.4555676,-0.76126346,0.83237794,0.44788842,1.4535287,-0.7612826,0.83634096,0.44888396,1.4557782,-0.7612826,0.8373365,0.44788842,1.4553666,-0.76127303,-0.87204614,-0.76205798,1.4646041,-0.76955325,-0.87106017,-0.76205798,1.4577885,-0.76955325,-0.87106017,-0.76205798,1.4535957,-0.76955325,-0.87006463,-0.76205798,1.4493551,-0.76955325,-0.87106017,-0.76205798,1.4570705,-0.76955325,-0.87204614,-0.76205798,1.4703476,-0.76955325,-0.87204614,-0.76205798,1.4638096,-0.76955325,-0.87204614,-0.76205798,1.4644031,-0.76955325,-0.87204614,-0.76205798,1.4678779,-0.76955325,-0.87204614,-0.76205798,1.462479,-0.76955325,-0.87106017,-0.76205798,1.4575683,-0.76955325,-0.87106017,-0.76205798,1.4568312,-0.76955325,-0.87106017,-0.76205798,1.4547827,-0.76955325,-0.87106017,-0.76205798,1.4575779,-0.76955325,-0.87106017,-0.76305352,1.4541796,-0.76955325,-0.87106017,-0.76205798,1.4536148,-0.76955325,-0.87106017,-0.76205798,1.4574438,-0.76955325,-0.87106017,-0.76205798,1.4551943,-0.76955325,-0.87106017,-0.76205798,1.4567259,-0.76955325,-0.87106017,-0.76205798,1.4600859,-0.76955325,-0.87106017,-0.76205798,1.4586117,-0.76955325,-0.87204614,-0.76205798,1.4634267,-0.76955325,-0.87106017,-0.76205798,1.4557016,-0.76955325,-0.87106017,-0.76305352,1.4582384,-0.76955325,-0.87204614,-0.76205798,1.4651019,-0.76955325,-0.87204614,-0.76205798,1.4638383,-0.76955325,-0.87106017,-0.76305352,1.4617323,-0.76955325,-0.87204614,-0.76205798,1.461426,-0.76955325,-0.87106017,-0.76205798,1.4601146,-0.76955325,-0.87204614,-0.76205798,1.4627087,-0.76955325,-0.87204614,-0.76205798,1.4627662,-0.76955325,-0.87204614,-0.76205798,1.4679545,-0.76955325,-0.87204614,-0.76205798,1.4716686,-0.76955325,-0.87204614,-0.76205798,1.4694669,-0.76955325,-0.87106017,-0.76205798,1.4593296,-0.76955325,-0.87106017,-0.76205798,1.4598944,-0.76955325,-0.87106017,-0.76205798,1.4589563,-0.76955325,-0.87106017,-0.76205798,1.4568408,-0.76955325,-0.87006463,-0.76205798,1.445057,-0.76955325,-0.87106017,-0.76205798,1.4547444,-0.76955325,-0.87106017,-0.76205798,1.4594349,-0.76955325,-0.87106017,-0.76305352,1.4538063,-0.76955325,-0.87006463,-0.76305352,1.4505038,-0.76955325,-0.87106017,-0.76305352,1.4519301,-0.76955325,-0.87006463,-0.76205798,1.4471055,-0.76955325,-0.87006463,-0.76205798,1.4474023,-0.76955325,-0.87006463,-0.76305352,1.4417545,-0.76955325,-0.86907866,-0.76305352,1.4350059,-0.76956283,-0.87006463,-0.76205798,1.4457462,-0.76955325,-0.87006463,-0.76305352,1.4461483,-0.76955325,-0.87006463,-0.76305352,1.4398017,-0.76955325,-0.87006463,-0.76305352,1.4401655,-0.76955325,-0.87006463,-0.76205798,1.4418311,-0.76955325,-0.87006463,-0.76305352,1.444004,-0.76955325,-0.87006463,-0.76305352,1.4444252,-0.76955325,-0.86907866,-0.76305352,1.4361546,-0.76955325,-0.87006463,-0.76305352,1.4431042,-0.76955325,-0.87006463,-0.76205798,1.4418981,-0.76955325,-0.86907866,-0.76305352,1.4371405,-0.76955325,-0.86907866,-0.76305352,1.4403473,-0.76955325,-0.87006463,-0.76305352,1.443535,-0.76955325,-0.86907866,-0.76305352,1.4350729,-0.76955325,0.7917522,0.81751183,1.4255961,-0.76017219,0.79571522,0.57175672,1.4277978,-0.76096671,0.79670119,0.58364578,1.4278073,-0.76092842,0.80462723,0.58860435,1.4324117,-0.76090928,0.74319084,0.58166427,1.3904267,-0.76095714,0.73030624,0.57275227,1.3848076,-0.761005,0.76003847,0.56085363,1.4071307,-0.76103372,0.77292307,0.53311249,1.4145686,-0.76110073,0.75409394,0.49941725,1.400899,-0.76120602,0.76103401,0.48256963,1.4104715,-0.76126346,0.77490458,0.47266208,1.4183497,-0.7612826,0.77787206,0.47167611,1.4200345,-0.7612826,0.75309839,0.4637405,1.4066904,-0.76133047,0.76301552,0.46275453,1.4097153,-0.76131132,0.77390904,0.46077302,1.4175648,-0.76132089,0.765983,0.45879151,1.4142144,-0.76133047,0.76400149,0.45779597,1.4113713,-0.76133047,0.76994602,0.45779597,1.4141952,-0.76132089,0.76301552,0.45581446,1.4110363,-0.76134004,0.77390904,0.45383295,1.4179668,-0.76133047,0.76697854,0.45086547,1.4136113,-0.76134961,0.76896005,0.44986993,1.4150089,-0.76134961,0.76896005,0.44590691,1.4152674,-0.76135918,0.77094156,0.44590691,1.4166171,-0.76135918,0.78084911,0.44492094,1.4243804,-0.76135918,0.78977069,0.4439254,1.428219,-0.76134961,0.79670119,0.4439254,1.4327372,-0.76134004,0.79670119,0.4439254,1.4327372,-0.76134004,0.79670119,0.4439254,1.4327372,-0.76134004,0.79670119,0.4439254,1.4327372,-0.76134004,0.79670119,0.4439254,1.4327372,-0.76134004,0.79670119,0.4439254,1.4327372,-0.76134004:0
-0.74456227,0.08741795,1.6781531,-0.62856582,-0.74349479,0.089542653,1.6768393,-0.62856582,-0.74456227,0.093792058,1.6931903,-0.62855556,-0.74456227,0.093792058,1.6933237,-0.62855556,-0.74561949,0.08741795,1.6882326,-0.62857609,-0.74456227,0.085293247,1.6689666,-0.62856582,-0.74137009,0.092724575,1.661176,-0.62852476,-0.74243757,0.091667355,1.6659079,-0.62853503,-0.74137009,0.08741795,1.6595748,-0.62854529,-0.74349479,0.083168544,1.6641424,-0.62857609,-0.74349479,0.08741795,1.6654665,-0.62855556,-0.74456227,0.089542653,1.6813966,-0.62856582,-0.74456227,0.088475169,1.678964,-0.62856582,-0.67017715,-0.61387766,1.6909321,-0.63176827,-0.67017715,-0.61281018,1.6858924,-0.63176827,-0.67017715,-0.61281018,1.6869496,-0.63176827,-0.67124463,-0.61281018,1.6971933,-0.63176827,-0.67017715,-0.61387766,1.6735753,-0.63176827,-0.67017715,-0.61387766,1.6701778,-0.63176827,-0.67017715,-0.61281018,1.6766135,-0.63175801,-0.67017715,-0.61387766,1.675505,-0.63176827,-0.67017715,-0.61387766,1.6651586,-0.63176827,-0.67017715,-0.61387766,1.6718611,-0.63176827,-0.67017715,-0.61387766,1.6566392,-0.63175801,-0.67017715,-0.61387766,1.6620588,-0.63176827,-0.67017715,-0.61387766,1.6576657,-0.63176827,-0.67017715,-0.61387766,1.657368,-0.63176827,-0.67017715,-0.61281018,1.6661747,-0.63176827,-0.67017715,-0.61387766,1.6599854,-0.63176827,-0.67017715,-0.61387766,1.6561568,-0.63176827,-0.67017715,-0.61387766,1.655931,-0.63176827,-0.67017715,-0.61281018,1.6658565,-0.63176827,-0.67017715,-0.61387766,1.6695927,-0.63176827,-0.67017715,-0.61387766,1.6653741,-0.63176827,-0.67017715,-0.61387766,1.647812,-0.63176827,-0.67017715,-0.61387766,1.6495056,-0.63176827,-0.67017715,-0.61387766,1.6529852,-0.63176827,-0.66911993,-0.61387766,1.6398366,-0.63176827,-0.66911993,-0.61387766,1.6375888,-0.63176827,-0.67017715,-0.61387766,1.6574912,-0.63176827,-0.67017715,-0.61387766,1.6508912,-0.63176827,-0.67017715,-0.61387766,1.6537139,-0.63176827,-0.67017715,-0.61387766,1.6474732,-0.63176827,-0.67017715,-0.61387766,1.6502651,-0.63176827,-0.66911993,-0.61387766,1.6424848,-0.63176827,-0.67017715,-0.61387766,1.6413147,-0.63176827,-0.66911993,-0.61387766,1.6384818,-0.63176827,-0.67017715,-0.61387766,1.6437165,-0.63176827,-0.66911993,-0.61387766,1.6427414,-0.63176827,-0.67017715,-0.61387766,1.6493927,-0.63176827,-0.66911993,-0.61387766,1.6441989,-0.63176827,-0.67017715,-0.61387766,1.6644298,-0.63176827,-0.67017715,-0.61387766,1.6612889,-0.63176827,-0.67017715,-0.61387766,1.6561158,-0.63176827,-0.67017715,-0.61387766,1.6597596,-0.63175801,-0.67017715,-0.61281018,1.6665237,-0.63176827,-0.67017715,-0.61387766,1.6852663,-0.63176827,-0.67017715,-0.61387766,1.6821767,-0.63176827,-0.67017715,-0.61387766,1.6739551,-0.63176827,-0.67017715,-0.61281018,1.6839217,-0.63176827,-0.67017715,-0.61387766,1.6795696,-0.63176827,-0.67017715,-0.61387766,1.6614326,-0.63176827,-0.67017715,-0.61387766,1.6565263,-0.63176827,-0.67017715,-0.61387766,1.6644401,-0.63176827,-0.67017715,-0.61387766,1.6623872,-0.63176827,-0.67017715,-0.61387766,1.6705371,-0.63176827,-0.67017715,-0.61387766,1.6628389,-0.63176827,-0.67017715,-0.61387766,1.6694593,-0.63176827,-0.67017715,-0.61387766,1.6685971,-0.63176827,-0.67017715,-0.61387766,1.6681557,-0.63176827,-0.67017715,-0.61387766,1.6591437,-0.63176827,-0.67017715,-0.61387766,1.6703934,-0.63176827,-0.67017715,-0.61387766,1.6572551,-0.63176827,-0.67017715,-0.61387766,1.6683405,-0.63176827,-0.67017715,-0.61387766,1.6614737,-0.63176827,-0.67017715,-0.61387766,1.6554794,-0.63176827,-0.67017715,-0.61387766,1.6517432,-0.63176827,-0.67017715,-0.61387766,1.6563313,-0.63176827,-0.67017715,-0.61387766,1.6491566,-0.63176827,-0.67017715,-0.61387766,1.6507681,-0.63176827,-0.67017715,-0.61387766,1.6453999,-0.63176827,-0.67017715,-0.61387766,1.658302,-0.63176827,-0.67017715,-0.61387766,1.6598417,-0.63176827,-0.67017715,-0.61387766,1.6691514,-0.63176827,-0.67017715,-0.61387766,1.6640603,-0.63176827,-0.67017715,-0.61387766,1.6713993,-0.63176827,-0.67017715,-0.61387766,1.6691103,-0.63176827,-0.67017715,-0.61281018,1.6702497,-0.63176827,-0.67017715,-0.61281018,1.6722922,-0.63176827,-0.67017715,-0.61387766,1.6696133,-0.63176827,-0.67017715,-0.61387766,1.6597185,-0.63176827,-0.67017715,-0.61387766,1.6503986,-0.63176827,-0.67017715,-0.61387766,1.6650251,-0.63176827,-0.67017715,-0.61387766,1.6725796,-0.63176827,-0.67017715,-0.61281018,1.6648096,-0.63176827,-0.67017715,-0.61387766,1.6695414,-0.63176827,-0.67017715,-0.61281018,1.6810785,-0.63176827,-0.67017715,-0.61387766,1.675895,-0.63176827,-0.67017715,-0.61387766,1.6592669,-0.63176827,-0.67017715,-0.61387766,1.6575836,-0.63176827,-0.67017715,-0.61387766,1.6549559,-0.63176827,-0.66911993,-0.61387766,1.6393747,-0.63176827,-0.66911993,-0.61387766,1.6397648,-0.63176827,-0.67017715,-0.61387766,1.6765724,-0.63176827,-0.67017715,-0.61387766,1.6670061,-0.63176827,-0.67017715,-0.61387766,1.6634752,-0.63176827,-0.67017715,-0.61387766,1.6572243,-0.63176827,-0.67017715,-0.61281018,1.6736061,-0.63176827,-0.67017715,-0.61387766,1.672826,-0.63176827,-0.67017715,-0.61387766,1.6633418,-0.63176827,-0.67017715,-0.61281018,1.6636395,-0.63176827,-0.67017715,-0.61387766,1.6623564,-0.63176827,-0.67017715,-0.61387766,1.6719022,-0.63176827,-0.67017715,-0.61387766,1.6711221,-0.63176827,-0.67017715,-0.61387766,1.6664519,-0.63176827,-0.67017715,-0.61387766,1.6691001,-0.63176827,-0.67017715,-0.61387766,1.668669,-0.63176827,-0.67017715,-0.61387766,1.6645017,-0.63176827,-0.67017715,-0.61387766,1.6638242,-0.63176827,-0.67017715,-0.61281018,1.6727336,-0.63176827,-0.67017715,-0.61281018,1.6678889,-0.63176827,-0.67017715,-0.61387766,1.6605602,-0.63176827,-0.67017715,-0.61387766,1.6717277,-0.63176827,-0.67124463,-0.61281018,1.6983327,-0.63175801,-0.67017715,-0.61281018,1.6770549,-0.63176827,-0.67017715,-0.61387766,1.6695722,-0.63176827,-0.67017715,-0.61387766,1.6742425,-0.63176827,-0.67017715,-0.61387766,1.6721485,-0.63176827,-0.67017715,-0.61281018,1.6800726,-0.63176827,-0.67017715,-0.61387766,1.6763056,-0.63176827,-0.67017715,-0.61387766,1.6643785,-0.63176827,-0.67017715,-0.61387766,1.6690693,-0.63176827,-0.67017715,-0.61281018,1.6697878,-0.63176827,-0.67017715,-0.61387766,1.6750533,-0.63176827,-0.67017715,-0.61387766,1.6727849,-0.63176827,-0.67017715,-0.61387766,1.6725488,-0.63176827,-0.67017715,-0.61281018,1.6755973,-0.63176827,-0.67017715,-0.61387766,1.6617508,-0.63176827,-0.67017715,-0.61387766,1.657717,-0.63176827,-0.67017715,-0.61387766,1.6640603,-0.63176827,-0.67124463,-0.61281018,1.7012888,-0.63175801,-0.67017715,-0.61281018,1.6880068,-0.63176827,-0.67124463,-0.61281018,1.6935701,-0.63176827,-0.67124463,-0.61281018,1.6955408,-0.63176827,-0.67124463,-0.61281018,1.6961361,-0.63176827,-0.67124463,-0.61281018,1.7000776,-0.63176827,-0.67124463,-0.61281018,1.7156896,-0.63176827,-0.67124463,-0.61281018,1.7255022,-0.63175801,-0.67124463,-0.61281018,1.7213657,-0.63175801,-0.67124463,-0.61281018,1.720175,-0.63175801,-0.67124463,-0.61281018,1.7070881,-0.63176827,-0.67124463,-0.61281018,1.7019354,-0.63176827,-0.67124463,-0.61281018,1.7194463,-0.63176827,-0.67124463,-0.61281018,1.7171573,-0.63175801,-0.67124463,-0.61281018,1.7183891,-0.63176827,-0.67124463,-0.61281018,1.7275653,-0.63175801,-0.67124463,-0.61281018,1.7287765,-0.63175801,-0.67124463,-0.61281018,1.7247016,-0.63175801,-0.67124463,-0.61281018,1.7083917,-0.63176827,-0.67124463,-0.61281018,1.7310141,-0.63175801,-0.67124463,-0.61281018,1.7090999,-0.63175801,-0.67124463,-0.61281018,1.716757,-0.63175801,-0.67124463,-0.61281018,1.7156382,-0.63176827,-0.67124463,-0.61281018,1.715279,-0.63175801,-0.67124463,-0.61281018,1.7076937,-0.63176827,-0.67124463,-0.61281018,1.7069547,-0.63175801,-0.67124463,-0.61281018,1.7086072,-0.63176827,-0.67124463,-0.61281018,1.7205138,-0.63175801,-0.67124463,-0.61281018,1.7257691,-0.63175801,-0.67124463,-0.61281018,1.711902,-0.63175801,-0.67124463,-0.61281018,1.7103316,-0.63176827,-0.67124463,-0.61281018,1.7107935,-0.63176827,-0.67124463,-0.61281018,1.7203803,-0.63175801,-0.67124463,-0.61281018,1.7118815,-0.63175801,-0.67124463,-0.61281018,1.7172805,-0.63176827,-0.67124463,-0.61281018,1.7195797,-0.63175801,-0.67124463,-0.61281018,1.7236033,-0.63175801,-0.67124463,-0.61281018,1.7220431,-0.63175801,-0.67124463,-0.61281018,1.7166749,-0.63176827,-0.67124463,-0.61281018,1.7221252,-0.63175801,-0.67124463,-0.61281018,1.7327385,-0.63175801,-0.67124463,-0.61281018,1.7175884,-0.63175801,-0.67124463,-0.61281018,1.7216223,-0.63176827,-0.67124463,-0.61281018,1.7182864,-0.63176827,-0.67124463,-0.61281018,1.7219405,-0.63175801,-0.67124463,-0.61281018,1.7150634,-0.63175801,-0.67124463,-0.61281018,1.7082172,-0.63176827,-0.67124463,-0.61281018,1.699431,-0.63176827,-0.67124463,-0.61281018,1.7126103,-0.63175801,-0.67124463,-0.61281018,1.7045426,-0.63176827,-0.67124463,-0.61281018,1.706811,-0.63176827,-0.67124463,-0.61281018,1.6966185,-0.63175801,-0.67124463,-0.61281018,1.7108756,-0.63176827,-0.67124463,-0.61281018,1.6997491,-0.63176827,-0.67124463,-0.61281018,1.7029413,-0.63176827,-0.67124463,-0.61281018,1.699277,-0.63176827,-0.67124463,-0.61281018,1.7027258,-0.63175801,-0.67017715,-0.61281018,1.6925744,-0.63176827,-0.67124463,-0.61281018,1.7031056,-0.63176827,-0.67124463,-0.61281018,1.7084532,-0.63176827,-0.67124463,-0.61281018,1.7093668,-0.63176827,-0.67124463,-0.61281018,1.7064414,-0.63175801,-0.67124463,-0.61281018,1.7131645,-0.63176827,-0.67124463,-0.61281018,1.7128977,-0.63176827,-0.67124463,-0.61281018,1.7128669,-0.63175801,-0.67124463,-0.61281018,1.7163773,-0.63175801,-0.67124463,-0.61281018,1.7069136,-0.63176827,-0.67124463,-0.61281018,1.708248,-0.63176827,-0.67124463,-0.61281018,1.700016,-0.63176827,-0.67124463,-0.61281018,1.7151353,-0.63175801,-0.67124463,-0.61281018,1.7053021,-0.63176827,-0.67124463,-0.61281018,1.7047273,-0.63175801,-0.67124463,-0.61281018,1.7105472,-0.63175801,-0.67124463,-0.61281018,1.7060206,-0.63176827,-0.67124463,-0.61281018,1.7037112,-0.63176827,-0.67124463,-0.61281018,1.707201,-0.63176827,-0.67124463,-0.61281018,1.7097055,-0.63175801,-0.67124463,-0.61281018,1.7106087,-0.63175801,-0.67124463,-0.61281018,1.7022434,-0.63176827,-0.72118028,0.23192853,1.7056614,-0.62799102,-0.71374895,0.26486655,1.7068212,-0.62784732,-0.71693087,0.24573397,1.6998107,-0.62792944,-0.72012306,0.22767912,1.6995439,-0.62800129,-0.72330498,0.20961402,1.7047581,-0.62809367,-0.72755439,0.19154891,1.7048094,-0.62816552,-0.72862187,0.18198262,1.7079811,-0.62820657,-0.73287128,0.16391751,1.7082274,-0.62828869,-0.74031287,0.13522889,1.7183377,-0.62842212,-0.74031287,0.13204697,1.7146426,-0.62843239,-0.74137009,0.12885479,1.715125,-0.62845291,-0.74243757,0.12248068,1.7197337,-0.62847344,-0.74456227,0.10760776,1.7154329,-0.62853503,-0.74561949,0.10548306,1.7123537,-0.62853503,-0.74668698,0.10654027,1.7163978,-0.62853503,-0.74561949,0.10654027,1.7156074,-0.62853503,-0.74561949,0.10548306,1.7123845,-0.62853503,-0.74561949,0.10229087,1.7096747,-0.62854529,-0.74561949,0.10654027,1.7038651,-0.62852476,-0.74349479,0.10973246,1.7081556,-0.6285145,-0.74561949,0.10335835,1.7071599,-0.62854529,-0.74668698,0.10229087,1.7093668,-0.62854529,-0.74561949,0.10229087,1.7064517,-0.62854529,-0.74456227,0.10016617,1.6730518,-0.62850424,-0.74456227,0.10229087,1.6939396,-0.62852476,-0.74349479,0.10441557,1.6977476,-0.6285145,-0.74561949,0.10123365,1.7033827,-0.62853503,-0.74456227,0.10654027,1.7112964,-0.62852476,-0.74561949,0.10654027,1.7197953,-0.62853503,-0.74561949,0.10760776,1.7224434,-0.62853503,-0.74456227,0.10760776,1.7202777,-0.62853503,-0.74456227,0.10654027,1.7156588,-0.62853503,-0.74456227,0.10441557,1.7192513,-0.62853503,-0.74456227,0.10760776,1.7196208,-0.62853503,-0.74349479,0.10548306,1.705374,-0.6285145,-0.74456227,0.10229087,1.7105266,-0.62853503,-0.74456227,0.10548306,1.7171265,-0.62853503,-0.74456227,0.10548306,1.718738,-0.62854529,-0.74456227,0.10548306,1.7203085,-0.62854529,-0.74456227,0.10335835,1.7154124,-0.62853503,-0.74349479,0.10654027,1.711317,-0.62852476,-0.74349479,0.10866498,1.714735,-0.6285145,-0.74561949,0.099108947,1.7184506,-0.62856582,-0.74349479,0.10548306,1.710465,-0.62853503,-0.74561949,0.10229087,1.7197337,-0.62854529,-0.74561949,0.10229087,1.7175371,-0.62854529,-0.74349479,0.10760776,1.7106395,-0.6285145,-0.74456227,0.10123365,1.7045734,-0.62853503,-0.74561949,0.10441557,1.7248863,-0.62855556,-0.74456227,0.10441557,1.7189228,-0.62854529,-0.74561949,0.10548306,1.7257485,-0.62855556,-0.74561949,0.10016617,1.720524,-0.62857609,-0.74456227,0.10548306,1.726816,-0.62855556,-0.74561949,0.10229087,1.7238394,-0.62857609,-0.74561949,0.10335835,1.7243834,-0.62855556,-0.74456227,0.10123365,1.7146529,-0.62856582,-0.74456227,0.10548306,1.7235725,-0.62855556,-0.74561949,0.10441557,1.7309422,-0.62856582,-0.74561949,0.10548306,1.7357767,-0.62856582,-0.74668698,0.10123365,1.7316402,-0.62857609,-0.74668698,0.10548306,1.7341652,-0.62855556,-0.74668698,0.10335835,1.7290742,-0.62856582,-0.74668698,0.10123365,1.7283351,-0.62857609,-0.74668698,0.10123365,1.7215094,-0.62856582,-0.74668698,0.099108947,1.7203393,-0.62857609,-0.74668698,0.10123365,1.7242602,-0.62856582,-0.74561949,0.10229087,1.7270316,-0.62856582,-0.74668698,0.09697398,1.7204932,-0.62857609,-0.74668698,0.10123365,1.7238188,-0.62855556,-0.74561949,0.10016617,1.7232646,-0.62856582,-0.74456227,0.10548306,1.7268776,-0.62854529,-0.74561949,0.10229087,1.7278835,-0.62855556,-0.74668698,0.10016617,1.7249069,-0.62856582,-0.7477442,0.10123365,1.7387636,-0.62858635,-0.74668698,0.09697398,1.7240036,-0.62858635,-0.74561949,0.10016617,1.7305317,-0.62857609,-0.74561949,0.10441557,1.7314041,-0.62855556,-0.74561949,0.10229087,1.7303469,-0.62856582,-0.74561949,0.10016617,1.7292794,-0.62857609,-0.7477442,0.095916761,1.7295053,-0.62858635,-0.74668698,0.098041464,1.7273908,-0.62857609,-0.74561949,0.10123365,1.7262925,-0.62855556,-0.74668698,0.10016617,1.7352224,-0.62857609,-0.74561949,0.10016617,1.7334057,-0.62857609,-0.74561949,0.10441557,1.7396669,-0.62856582,-0.74668698,0.10229087,1.7357049,-0.62856582,-0.74668698,0.10016617,1.728212,-0.62857609,-0.74668698,0.09697398,1.7255535,-0.62857609,-0.74668698,0.094849277,1.7248555,-0.62859661,-0.74668698,0.095916761,1.7262515,-0.62859661,-0.74561949,0.098041464,1.7152892,-0.62857609,-0.74668698,0.095916761,1.7197131,-0.62858635,-0.74561949,0.098041464,1.7222279,-0.62857609,-0.74561949,0.09697398,1.7192513,-0.62857609,-0.74561949,0.098041464,1.720719,-0.62857609,-0.74561949,0.095916761,1.716911,-0.62858635,-0.74561949,0.092724575,1.7102905,-0.62858635,-0.74561949,0.09697398,1.712405,-0.62857609,-0.74561949,0.094849277,1.7126,-0.62858635,-0.74561949,0.091667355,1.6987638,-0.62857609,-0.74668698,0.093792058,1.7106395,-0.62858635,-0.7477442,0.093792058,1.7113478,-0.62858635,-0.74668698,0.094849277,1.711009,-0.62857609,-0.74668698,0.094849277,1.7092128,-0.62857609,-0.74561949,0.095916761,1.7068623,-0.62855556,-0.74561949,0.098041464,1.708638,-0.62855556,-0.74668698,0.094849277,1.7150737,-0.62856582,-0.74561949,0.092724575,1.7058153,-0.62856582,-0.74561949,0.093792058,1.7083711,-0.62856582,-0.74561949,0.093792058,1.7067083,-0.62856582,-0.74561949,0.093792058,1.7060925,-0.62857609,-0.74456227,0.093792058,1.7016891,-0.62856582,-0.67124463,-0.61281018,1.708094,-0.63175801,-0.67124463,-0.61281018,1.7099724,-0.63175801,-0.67017715,-0.61387766,1.6696543,-0.63176827,-0.67124463,-0.61387766,1.6910758,-0.63176827,-0.67124463,-0.61281018,1.6905421,-0.63176827,-0.67124463,-0.61281018,1.6985585,-0.63176827,-0.67017715,-0.61387766,1.6497519,-0.63176827,-0.67017715,-0.61387766,1.6593387,-0.63176827,-0.67017715,-0.61387766,1.6758847,-0.63176827,-0.67017715,-0.61387766,1.6447737,-0.63176827,-0.67017715,-0.61387766,1.6434497,-0.63176827,-0.67017715,-0.61387766,1.6783482,-0.63176827,-0.67017715,-0.61281018,1.6820433,-0.63176827,-0.67017715,-0.61387766,1.6559413,-0.63176827,-0.67017715,-0.61387766,1.6798981,-0.63176827,-0.67017715,-0.61387766,1.6756076,-0.63176827,-0.67017715,-0.61387766,1.6591848,-0.63176827,-0.67017715,-0.61281018,1.6814685,-0.63176827,-0.67017715,-0.61387766,1.6799596,-0.63176827,-0.67017715,-0.61387766,1.6767983,-0.63176827,-0.67017715,-0.61281018,1.6743348,-0.63176827,-0.67017715,-0.61281018,1.6825052,-0.63176827,-0.67017715,-0.61387766,1.6804831,-0.63176827,-0.67017715,-0.61387766,1.6770651,-0.63176827,-0.67017715,-0.61281018,1.678379,-0.63176827,-0.67017715,-0.61281018,1.6807808,-0.63176827,-0.67124463,-0.61387766,1.6944631,-0.63176827,-0.67124463,-0.61281018,1.6904805,-0.63176827,-0.67124463,-0.61281018,1.6970907,-0.63176827,-0.67124463,-0.61281018,1.6970907,-0.63176827,-0.67124463,-0.61281018,1.6970907,-0.63176827,-0.67124463,-0.61281018,1.6970907,-0.63176827,-0.67124463,-0.61281018,1.6970907,-0.63176827,-0.67124463,-0.61281018,1.6970907,-0.63176827:0
-0.72298589,-0.72298589,1.6841167,-0.72298589,-0.72298589,-0.72298589,1.6894288,-0.72298589,-0.72298589,-0.72298589,1.6871887,-0.72298589,-0.72298589,-0.72298589,1.6845754,-0.72298589,-0.72298589,-0.72298589,1.6860901,-0.72298589,-0.72298589,-0.72298589,1.6833913,-0.72298589,-0.72298589,-0.72298589,1.6814713,-0.72298589,-0.72298589,-0.72298589,1.6886501,-0.72298589,-0.72298589,-0.72298589,1.682058,-0.72298589,-0.72298589,-0.72298589,1.6882661,-0.72298589,-0.72298589,-0.72298589,1.6842447,-0.72298589,-0.72298589,-0.72298589,1.683274,-0.72298589,-0.72298589,-0.72298589,1.6920848,-0.72298589,-0.72298589,-0.72298589,1.6821753,-0.72298589,-0.72298589,-0.72298589,1.6879248,-0.72298589,-0.72298589,-0.72298589,1.6888314,-0.72298589,-0.72298589,-0.72298589,1.6855034,-0.72298589,-0.72298589,-0.72298589,1.6894608,-0.72298589,-0.72298589,-0.72298589,1.6906768,-0.72298589,-0.72298589,-0.72298589,1.6859621,-0.72298589,-0.72298589,-0.72298589,1.6813006,-0.72298589,-0.72298589,-0.72298589,1.6884901,-0.72298589,-0.72298589,-0.72298589,1.6892048,-0.72298589,-0.72298589,-0.72298589,1.6865594,-0.72298589,-0.72298589,-0.72298589,1.6866767,-0.72298589,-0.72298589,-0.72298589,1.6924262,-0.72298589,-0.72298589,-0.72298589,1.6837647,-0.72298589,-0.72298589,-0.72298589,1.680202,-0.72298589,-0.72298589,-0.72298589,1.6893008,-0.72298589,-0.72298589,-0.72298589,1.6865807,-0.72298589,-0.72298589,-0.72298589,1.683466,-0.72298589,-0.72298589,-0.72298589,1.6714765,-0.72298589,-0.2216653,0.16260795,1.6793059,-0.71838848,-0.2216653,0.18138161,1.6727245,-0.71830314,-0.22608137,0.16039991,1.6714125,-0.71838848,-0.22387334,0.15266645,1.6769059,-0.71842048,-0.22387334,0.15598384,1.6730658,-0.71839914,-0.22387334,0.15598384,1.6754125,-0.71840981,-0.2216653,0.15156776,1.6791246,-0.71842048,-0.22387334,0.15156776,1.6748365,-0.71842048,-0.22277465,0.14935972,1.6789219,-0.71843114,-0.2216653,0.14272494,1.683818,-0.71846314,-0.2216653,0.1438343,1.6824953,-0.71846314,-0.22056661,0.13941822,1.685866,-0.71848448,-0.22719073,0.13279411,1.6768206,-0.71850581,-0.22277465,0.12947672,1.6837753,-0.71851648,-0.2216653,0.1129111,1.6876154,-0.71858048,-0.2316068,0.098564187,1.6752099,-0.71864448,-0.22608137,0.097454835,1.6866127,-0.71864448,-0.22828941,0.093038759,1.6832847,-0.71866581,-0.22939877,0.090830722,1.6839674,-0.71867648,-0.22719073,0.090830722,1.6866767,-0.71867648,-0.23049745,0.089732036,1.6809486,-0.71867648,-0.2316068,0.086414646,1.6783993,-0.71868715,-0.22939877,0.086414646,1.6836687,-0.71869782,-0.23602288,0.084206608,1.6718711,-0.71869782,-0.22939877,0.085305294,1.6851727,-0.71869782,-0.23049745,0.083097256,1.6812793,-0.71869782,-0.23602288,0.076473142,1.6706338,-0.71871915,-0.2316068,0.07868118,1.6764686,-0.71871915,-0.23049745,0.076473142,1.6799459,-0.71872982,-0.23491353,0.074265104,1.6763726,-0.71874048,-0.23713223,0.069849029,1.6712525,-0.71875115,-0.2316068,0.068750343,1.6806926,-0.71875115,-0.23602288,0.065432953,1.6752205,-0.71877248,-0.23934027,0.063224915,1.6681377,-0.71877248,-0.23491353,0.064334268,1.6725858,-0.71876182,-0.23602288,0.063224915,1.6767459,-0.71877248,-0.23381484,0.063224915,1.6784739,-0.71877248,-0.23602288,0.059907525,1.6742605,-0.71879382,-0.23381484,0.05880884,1.6768206,-0.71879382,-0.2316068,0.059907525,1.68321,-0.71879382,-0.23934027,0.056600802,1.6689378,-0.71880448,-0.24485503,0.052184726,1.6606603,-0.71881515,-0.23491353,0.051075374,1.6781539,-0.71882582,-0.72298589,-0.72298589,1.6661004,-0.72298589,-0.72298589,-0.72298589,1.6658977,-0.72298589,-0.72298589,-0.72298589,1.6721805,-0.72298589,-0.72298589,-0.72298589,1.6669004,-0.72298589,-0.72298589,-0.72298589,1.6585589,-0.72298589,-0.72298589,-0.72298589,1.662815,-0.72298589,-0.72298589,-0.72298589,1.6641163,-0.72298589,-0.72298589,-0.72298589,1.6653537,-0.72298589,-0.72298589,-0.72298589,1.6593696,-0.72298589,-0.72298589,-0.72298589,1.6628683,-0.72298589,-0.72298589,-0.72298589,1.6703138,-0.72298589,-0.72298589,-0.72298589,1.6682977,-0.72298589,-0.72298589,-0.72298589,1.6747939,-0.72298589,-0.72298589,-0.72298589,1.6726285,-0.72298589,-0.72298589,-0.72298589,1.6568096,-0.72298589,-0.72298589,-0.72298589,1.6567776,-0.72298589,-0.72298589,-0.72298589,1.6596363,-0.72298589,-0.72298589,-0.72298589,1.6729912,-0.72298589,-0.72298589,-0.72298589,1.6658444,-0.72298589,-0.72298589,-0.72298589,1.6578336,-0.72298589,-0.72298589,-0.72298589,1.6699084,-0.72298589,-0.72298589,-0.72298589,1.6572682,-0.72298589,-0.72298589,-0.72298589,1.6512948,-0.72298589,-0.72298589,-0.72298589,1.6575349,-0.72298589,-0.72298589,-0.72298589,1.6545908,-0.72298589,-0.72298589,-0.72298589,1.6400306,-0.72298589,-0.72298589,-0.72298589,1.6465374,-0.72298589,-0.72298589,-0.72298589,1.6528948,-0.72298589,-0.72298589,-0.72298589,1.6534282,-0.72298589,-0.72298589,-0.72298589,1.6509108,-0.72298589,-0.72298589,-0.72298589,1.6523615,-0.72298589,-0.72298589,-0.72298589,1.6524361,-0.72298589,-0.72298589,-0.72298589,1.6507614,-0.72298589,-0.72298589,-0.72298589,1.6573002,-0.72298589,-0.72298589,-0.72298589,1.6551775,-0.72298589,-0.72298589,-0.72298589,1.6562869,-0.72298589,-0.72298589,-0.72298589,1.6484894,-0.72298589,-0.72298589,-0.72298589,1.6503668,-0.72298589,-0.72298589,-0.72298589,1.6479347,-0.72298589,-0.72298589,-0.72298589,1.6393266,-0.72298589,-0.72298589,-0.72298589,1.6464734,-0.72298589,-0.72298589,-0.72298589,1.6622176,-0.72298589,-0.72298589,-0.72298589,1.661247,-0.72298589,-0.72298589,-0.72298589,1.6427933,-0.72298589,-0.72298589,-0.72298589,1.6626337,-0.72298589,-0.72298589,-0.72298589,1.6566815,-0.72298589,-0.72298589,-0.72298589,1.6383132,-0.72298589,-0.72298589,-0.72298589,1.6298331,-0.72298589,-0.72298589,-0.72298589,1.662303,-0.72298589,-0.72298589,-0.72298589,1.646228,-0.72298589,-0.72298589,-0.72298589,1.6540575,-0.72298589,-0.72298589,-0.72298589,1.6559775,-0.72298589,-0.72298589,-0.72298589,1.6514335,-0.72298589,-0.72298589,-0.72298589,1.644628,-0.72298589,-0.72298589,-0.72298589,1.6695244,-0.72298589,-0.72298589,-0.72298589,1.6557322,-0.72298589,-0.72298589,-0.72298589,1.6519241,-0.72298589,-0.72298589,-0.72298589,1.6516148,-0.72298589,-0.72298589,-0.72298589,1.6371719,-0.72298589,-0.72298589,-0.72298589,1.6305478,-0.72298589,-0.72298589,-0.72298589,1.6155822,-0.72298589,-0.72298589,-0.72298589,1.6198596,-0.72298589,-0.72298589,-0.72298589,1.6311344,-0.72298589,-0.72298589,-0.72298589,1.6208089,-0.72298589,-0.72298589,-0.72298589,1.6318065,-0.72298589,-0.72298589,-0.72298589,1.6252463,-0.72298589,-0.72298589,-0.72298589,1.6301424,-0.72298589,-0.72298589,-0.72298589,1.6343772,-0.72298589,-0.72298589,-0.72298589,1.6227503,-0.72298589,-0.72298589,-0.72298589,1.6201476,-0.72298589,-0.72298589,-0.72298589,1.6286384,-0.72298589,-0.72298589,-0.72298589,1.6131821,-0.72298589,-0.72298589,-0.72298589,1.6359132,-0.72298589,-0.72298589,-0.72298589,1.6335238,-0.72298589,-0.72298589,-0.72298589,1.6208729,-0.72298589,-0.72298589,-0.72298589,1.6306651,-0.72298589,-0.72298589,-0.72298589,1.6485427,-0.72298589,-0.72298589,-0.72298589,1.6581109,-0.72298589,-0.72298589,-0.72298589,1.6578656,-0.72298589,-0.72298589,-0.72298589,1.6574602,-0.72298589,-0.72298589,-0.72298589,1.6631883,-0.72298589,-0.72298589,-0.72298589,1.6613643,-0.72298589,-0.72298589,-0.72298589,1.6599669,-0.72298589,-0.72298589,-0.72298589,1.6642123,-0.72298589,-0.72298589,-0.72298589,1.6631777,-0.72298589,-0.72298589,-0.72298589,1.6713165,-0.72298589,-0.72298589,-0.72298589,1.6551135,-0.72298589,-0.72298589,-0.72298589,1.6750392,-0.72298589,-0.72298589,-0.72298589,1.6759245,-0.72298589,-0.23381484,0.15598384,1.6566922,-0.71839914,-0.22719073,0.17585618,1.665503,-0.71832448,-0.22719073,0.15819188,1.6676897,-0.71838848,-0.22608137,0.15487449,1.6732472,-0.71840981,-0.2216653,0.15819188,1.6793806,-0.71839914,-0.22277465,0.15819188,1.6757219,-0.71839914,-0.2316068,0.31830129,1.6692578,-0.71778047,-0.22939877,0.31609325,1.6707725,-0.71779113,-0.22608137,0.31388521,1.6780686,-0.7178018,-0.22608137,0.3172026,1.6791673,-0.7178018,-0.2316068,0.31499456,1.6690231,-0.71779113,-0.22828941,0.31167717,1.6740792,-0.71781247,-0.22608137,0.22665172,1.6760099,-0.71813247,-0.23049745,0.14494365,1.6660897,-0.71845248,-0.22719073,0.1438343,1.6759352,-0.71846314,-0.23270549,0.12506064,1.6679031,-0.71853781,-0.23381484,0.11511914,1.6684258,-0.71856981,-0.23270549,0.1129111,1.6720205,-0.71858048,-0.23049745,0.10960438,1.6749432,-0.71859115,-0.22719073,0.1051883,1.6791459,-0.71861248,-0.22828941,0.10628699,1.6794446,-0.71861248,-0.22828941,0.099662873,1.6786446,-0.71863381,-0.22387334,0.10407895,1.685034,-0.71862315,-0.23491353,0.10187091,1.6688098,-0.71861248,-0.23713223,0.098564187,1.6618656,-0.71861248,-0.22498269,0.099662873,1.681482,-0.71863381,-0.2316068,0.09635615,1.6713698,-0.71864448,-0.22608137,0.091940074,1.6807033,-0.71865515,-0.22387334,0.091940074,1.6889914,-0.71866581,-0.2216653,0.093038759,1.6879461,-0.71865515,-0.22277465,0.090830722,1.6890981,-0.71866581,-0.22608137,0.087513331,1.6798926,-0.71867648,-0.22387334,0.088622684,1.684746,-0.71866581,-0.22828941,0.085305294,1.6811833,-0.71868715,-0.23934027,0.07868118,1.6604896,-0.71870848,-0.23602288,0.07868118,1.6672417,-0.71870848,-0.23602288,0.076473142,1.6673271,-0.71871915,-0.23713223,0.073166419,1.6667191,-0.71872982,-0.23823092,0.073166419,1.6630177,-0.71872982,-0.24154831,0.073166419,1.6587403,-0.71872982,-0.23381484,0.074265104,1.6740045,-0.71872982,-0.23823092,0.069849029,1.662495,-0.71874048,-0.23602288,0.070958381,1.6686498,-0.71874048,-0.23381484,0.072057067,1.6734178,-0.71874048,-0.24043895,0.067640991,1.663455,-0.71875115,-0.23602288,0.064334268,1.6702178,-0.71876182,-0.23270549,0.063224915,1.6755085,-0.71877248,-0.72298589,-0.72298589,1.6756685,-0.72298589,-0.72298589,-0.72298589,1.6611616,-0.72298589,-0.72298589,-0.72298589,1.6724472,-0.72298589,-0.72298589,-0.72298589,1.6745059,-0.72298589,-0.72298589,-0.72298589,1.6738978,-0.72298589,-0.72298589,-0.72298589,1.6749752,-0.72298589,-0.72298589,-0.72298589,1.6747939,-0.72298589,-0.72298589,-0.72298589,1.6767672,-0.72298589,-0.72298589,-0.72298589,1.6689271,-0.72298589,-0.72298589,-0.72298589,1.6816526,-0.72298589,-0.72298589,-0.72298589,1.662431,-0.72298589,-0.72298589,-0.72298589,1.6723618,-0.72298589,-0.72298589,-0.72298589,1.6805006,-0.72298589,-0.72298589,-0.72298589,1.6729058,-0.72298589,-0.72298589,-0.72298589,1.6818126,-0.72298589,-0.72298589,-0.72298589,1.6777379,-0.72298589,-0.72298589,-0.72298589,1.6750819,-0.72298589,-0.72298589,-0.72298589,1.6840314,-0.72298589,-0.72298589,-0.72298589,1.6775672,-0.72298589,-0.72298589,-0.72298589,1.6669431,-0.72298589,-0.72298589,-0.72298589,1.6734818,-0.72298589,-0.72298589,-0.72298589,1.6666444,-0.72298589,-0.72298589,-0.72298589,1.6727672,-0.72298589,-0.72298589,-0.72298589,1.6743245,-0.72298589,-0.72298589,-0.72298589,1.6848314,-0.72298589,-0.72298589,-0.72298589,1.681482,-0.72298589,-0.72298589,-0.72298589,1.6839887,-0.72298589,-0.72298589,-0.72298589,1.6877541,-0.72298589,-0.72298589,-0.72298589,1.6873381,-0.72298589,-0.72298589,-0.72298589,1.6876367,-0.72298589,-0.72298589,-0.72298589,1.6899195,-0.72298589,-0.72298589,-0.72298589,1.6914341,-0.72298589,-0.72298589,-0.72298589,1.6867941,-0.72298589,-0.72298589,-0.72298589,1.6887034,-0.72298589,-0.72298589,-0.72298589,1.6859834,-0.72298589,-0.72298589,-0.72298589,1.6740472,-0.72298589,-0.72298589,-0.72298589,1.6717858,-0.72298589,-0.72298589,-0.72298589,1.6771086,-0.72298589,-0.72298589,-0.72298589,1.68289,-0.72298589,-0.72298589,-0.72298589,1.6798179,-0.72298589,-0.72298589,-0.72298589,1.6991996,-0.72298589,-0.72298589,-0.72298589,1.6890874,-0.72298589,-0.72298589,-0.72298589,1.6868901,-0.72298589,-0.72298589,-0.72298589,1.6871887,-0.72298589,-0.72298589,-0.72298589,1.6776846,-0.72298589,-0.72298589,-0.72298589,1.6916368,-0.72298589,-0.72298589,-0.72298589,1.6946875,-0.72298589,-0.72298589,-0.72298589,1.6941862,-0.72298589,-0.72298589,-0.72298589,1.6917115,-0.72298589,-0.72298589,-0.72298589,1.6913808,-0.72298589,-0.72298589,-0.72298589,1.6898981,-0.72298589,-0.72298589,-0.72298589,1.6978663,-0.72298589,-0.72298589,-0.72298589,1.6914875,-0.72298589,-0.72298589,-0.72298589,1.6895781,-0.72298589,-0.72298589,-0.72298589,1.6827193,-0.72298589,-0.72298589,-0.72298589,1.6860047,-0.72298589,-0.72298589,-0.72298589,1.6875621,-0.72298589,-0.72298589,-0.72298589,1.6822607,-0.72298589,-0.72298589,-0.72298589,1.68369,-0.72298589,-0.72298589,-0.72298589,1.6836687,-0.72298589,-0.72298589,-0.72298589,1.6874981,-0.72298589,-0.72298589,-0.72298589,1.6903035,-0.72298589,-0.72298589,-0.72298589,1.6870074,-0.72298589,-0.72298589,-0.72298589,1.6781433,-0.72298589,-0.72298589,-0.72298589,1.6883941,-0.72298589,-0.72298589,-0.72298589,1.684682,-0.72298589,-0.72298589,-0.72298589,1.6824953,-0.72298589,-0.72298589,-0.72298589,1.681834,-0.72298589,-0.72298589,-0.72298589,1.6794766,-0.72298589,-0.72298589,-0.72298589,1.6921275,-0.72298589,-0.72298589,-0.72298589,1.6874341,-0.72298589,-0.72298589,-0.72298589,1.6993916,-0.72298589,-0.72298589,-0.72298589,1.6947835,-0.72298589,-0.72298589,-0.72298589,1.6907088,-0.72298589,-0.72298589,-0.72298589,1.6981329,-0.72298589,-0.72298589,-0.72298589,1.6969702,-0.72298589,-0.72298589,-0.72298589,1.6931515,-0.72298589,-0.21724922,0.1537758,1.6946662,-0.71843114,-0.21283315,0.17696553,1.6932368,-0.71833514,-0.21945726,0.16260795,1.6852047,-0.71838848,-0.21835858,0.15487449,1.6895888,-0.71842048,-0.20841707,0.16702403,1.7016743,-0.71837781,-0.20841707,0.16702403,1.7037224,-0.71837781,-0.21615054,0.16039991,1.6920315,-0.71839914,-0.21615054,0.14825037,1.6965542,-0.71845248,-0.21835858,0.14494365,1.6939622,-0.71846314,-0.21945726,0.14162626,1.6895568,-0.71847381,-0.22277465,0.14272494,1.6841807,-0.71847381,-0.21945726,0.13941822,1.6905381,-0.71848448,-0.2139425,0.13941822,1.6993169,-0.71849514,-0.21615054,0.13279411,1.6956262,-0.71850581,-0.21504119,0.12616999,1.7014076,-0.71853781,-0.21835858,0.10849502,1.6987516,-0.71861248,-0.22387334,0.099662873,1.6925648,-0.71864448,-0.2316068,0.099662873,1.6780259,-0.71863381,-0.2316068,0.098564187,1.6759992,-0.71864448,-0.2316068,0.095246797,1.6749645,-0.71865515,-0.23381484,0.095246797,1.6722658,-0.71865515,-0.23713223,0.094148112,1.6671031,-0.71865515,-0.23491353,0.089732036,1.6695031,-0.71866581,-0.23934027,0.089732036,1.6629963,-0.71866581,-0.23713223,0.087513331,1.6685858,-0.71867648,-0.23602288,0.087513331,1.6707725,-0.71868715,-0.23602288,0.084206608,1.6712525,-0.71869782,-0.24154831,0.080889218,1.6594443,-0.71869782,-0.24043895,0.075374457,1.6633057,-0.71872982,-0.23713223,0.07868118,1.6683831,-0.71870848,-0.23934027,0.076473142,1.6650444,-0.71872982,-0.23713223,0.075374457,1.6698444,-0.71872982,-0.23823092,0.070958381,1.6695671,-0.71875115,-0.24154831,0.072057067,1.664255,-0.71874048,-0.23713223,0.069849029,1.6731725,-0.71875115,-0.23934027,0.068750343,1.6674124,-0.71875115,-0.23713223,0.066542305,1.6713058,-0.71876182,-0.23934027,0.063224915,1.6689271,-0.71877248,-0.23491353,0.063224915,1.6783139,-0.71878315,-0.24043895,0.061016877,1.6666017,-0.71878315,-0.23713223,0.059907525,1.6754659,-0.71879382,-0.23602288,0.05880884,1.6747725,-0.71879382,-0.24264699,0.056600802,1.6645217,-0.71880448,-0.24375634,0.053283412,1.663519,-0.71881515,-0.23491353,0.054392764,1.6796579,-0.71881515,-0.23823092,0.053283412,1.6726498,-0.71881515,-0.72298589,-0.72298589,1.680138,-0.72298589,-0.72298589,-0.72298589,1.68225,-0.72298589,-0.72298589,-0.72298589,1.6760632,-0.72298589,-0.72298589,-0.72298589,1.6760312,-0.72298589,-0.72298589,-0.72298589,1.6792526,-0.72298589,-0.72298589,-0.72298589,1.6798073,-0.72298589,-0.72298589,-0.72298589,1.6811193,-0.72298589,-0.72298589,-0.72298589,1.6752845,-0.72298589,-0.72298589,-0.72298589,1.6864207,-0.72298589,-0.72298589,-0.72298589,1.6741965,-0.72298589,-0.72298589,-0.72298589,1.6716898,-0.72298589,-0.72298589,-0.72298589,1.6836153,-0.72298589,-0.72298589,-0.72298589,1.6919782,-0.72298589,-0.72298589,-0.72298589,1.684394,-0.72298589,-0.72298589,-0.72298589,1.6829967,-0.72298589,-0.72298589,-0.72298589,1.6868794,-0.72298589,-0.72298589,-0.72298589,1.6647884,-0.72298589,-0.72298589,-0.72298589,1.6644363,-0.72298589,-0.72298589,-0.72298589,1.6713805,-0.72298589,-0.72298589,-0.72298589,1.6889168,-0.72298589,-0.72298589,-0.72298589,1.6805006,-0.72298589,-0.72298589,-0.72298589,1.6760525,-0.72298589,-0.72298589,-0.72298589,1.6807353,-0.72298589,-0.72298589,-0.72298589,1.6702711,-0.72298589,-0.72298589,-0.72298589,1.6721271,-0.72298589,-0.72298589,-0.72298589,1.6721271,-0.72298589,-0.72298589,-0.72298589,1.6721271,-0.72298589,-0.72298589,-0.72298589,1.6721271,-0.72298589,-0.72298589,-0.72298589,1.6721271,-0.72298589,-0.72298589,-0.72298589,1.6721271,-0.72298589,-0.72298589,-0.72298589,1.6721271,-0.72298589:0
-0.69009389,-0.69009389,1.649865,-0.69009389,-0.69009389,-0.69009389,1.6518164,-0.69009389,-0.69009389,-0.69009389,1.6534905,-0.69009389,-0.69009389,-0.69009389,1.655122,-0.69009389,-0.69009389,-0.69009389,1.6500996,-0.69009389,-0.69009389,-0.69009389,1.6534052,-0.69009389,-0.69009389,-0.69009389,1.6531813,-0.69009389,-0.69009389,-0.69009389,1.6500249,-0.69009389,-0.69009389,-0.69009389,1.6318757,-0.69009389,-0.69009389,-0.69009389,1.6388496,-0.69009389,-0.69009389,-0.69009389,1.6490225,-0.69009389,-0.69009389,-0.69009389,1.6494597,-0.69009389,-0.69009389,-0.69009389,1.647583,-0.69009389,-0.69009389,-0.69009389,1.6503555,-0.69009389,-0.69009389,-0.69009389,1.6512725,-0.69009389,-0.69009389,-0.69009389,1.6468045,-0.69009389,-0.69009389,-0.69009389,1.6512619,-0.69009389,-0.69009389,-0.69009389,1.6518164,-0.69009389,-0.69009389,-0.69009389,1.6532666,-0.69009389,-0.69009389,-0.69009389,1.6521469,-0.69009389,-0.69009389,-0.69009389,1.6496943,-0.69009389,-0.69009389,-0.69009389,1.6500782,-0.69009389,-0.69009389,-0.69009389,1.6479775,-0.69009389,-0.69009389,-0.69009389,1.647487,-0.69009389,-0.69009389,-0.69009389,1.6323342,-0.69009389,-0.69009389,-0.69009389,1.642987,-0.69009389,-0.69009389,-0.69009389,1.6478282,-0.69009389,-0.69009389,-0.69009389,1.6456955,-0.69009389,-0.69009389,-0.69009389,1.6457595,-0.69009389,-0.69009389,-0.69009389,1.6439787,-0.69009389,-0.69009389,-0.69009389,1.6404171,-0.69009389,-0.69009389,-0.69009389,1.6417714,-0.69009389,-0.69009389,-0.69009389,1.644288,-0.69009389,-0.69009389,-0.69009389,1.6426351,-0.69009389,-0.69009389,-0.69009389,1.6410463,-0.69009389,-0.69009389,-0.69009389,1.611018,-0.69009389,-0.69009389,-0.69009389,1.6411956,-0.69009389,-0.69009389,-0.69009389,1.645173,-0.69009389,-0.69009389,-0.69009389,1.6449384,-0.69009389,-0.69009389,-0.69009389,1.6443413,-0.69009389,-0.69009389,-0.69009389,1.6439361,-0.69009389,-0.69009389,-0.69009389,1.6455143,-0.69009389,-0.69009389,-0.69009389,1.6431683,-0.69009389,-0.69009389,-0.69009389,1.6473804,-0.69009389,-0.69009389,-0.69009389,1.6475083,-0.69009389,-0.69009389,-0.69009389,1.6468685,-0.69009389,-0.69009389,-0.69009389,1.647455,-0.69009389,-0.69009389,-0.69009389,1.6485107,-0.69009389,-0.69009389,-0.69009389,1.6495344,-0.69009389,-0.69009389,-0.69009389,1.6336565,-0.69009389,-0.69009389,-0.69009389,1.6456955,-0.69009389,-0.69009389,-0.69009389,1.647391,-0.69009389,-0.69009389,-0.69009389,1.6484361,-0.69009389,-0.69009389,-0.69009389,1.6482761,-0.69009389,0.31885121,0.74274529,1.6462074,-0.68188302,0.3133382,0.386191,1.6495984,-0.68336524,0.30670553,0.39612935,1.6406197,-0.68333325,0.31443654,0.41378805,1.6470605,-0.68326927,0.3122292,0.39170401,1.6473377,-0.68334391,0.31554554,0.38839833,1.6517631,-0.68335458,0.3122292,0.37845998,1.6481801,-0.68339723,0.30891286,0.37515431,1.6449278,-0.68340789,0.31443654,0.36963064,1.6510806,-0.68342922,0.31443654,0.36521596,1.6524882,-0.68343988,0.31664388,0.36963064,1.6543116,-0.68342922,0.3133382,0.35859395,1.6517204,-0.68346121,0.30781453,0.3486556,1.646314,-0.68350387,0.31113086,0.34314259,1.6515178,-0.68352519,0.29898518,0.33650991,1.6376126,-0.68354652,0.31002186,0.32326589,1.6521576,-0.68358917,0.31002186,0.32326589,1.6525308,-0.68359984,0.29015583,0.30891286,1.6300949,-0.68364249,0.30781453,0.31443654,1.6508353,-0.68362116,0.30229085,0.30560719,1.6457489,-0.68365315,0.30119251,0.29677784,1.6447572,-0.68368514,0.30781453,0.2934615,1.6521896,-0.68369581,0.28794849,0.27801014,1.6306494,-0.68374912,0.30449819,0.27910848,1.6500889,-0.68374912,0.30560719,0.27359547,1.6526055,-0.68377045,0.2945705,0.26697345,1.6403958,-0.68379178,0.28904683,0.25924244,1.6334112,-0.68382377,0.30339985,0.25814411,1.6512299,-0.68382377,0.29898518,0.24930409,1.6469432,-0.68385576,0.30119251,0.24488942,1.6496304,-0.68386642,0.30119251,0.23385273,1.6495344,-0.68389841,0.29898518,0.23164539,1.6482121,-0.68390908,0.30008351,0.22723072,1.6500462,-0.6839304,0.29787618,0.22060871,1.6479989,-0.68395173,0.28352315,0.21729237,1.6315984,-0.68396239,0.2934615,0.2139867,1.6417821,-0.68397306,0.29566884,0.21067036,1.6461008,-0.68398372,-0.69009389,-0.69009389,1.6528934,-0.69009389,-0.69009389,-0.69009389,1.6538424,-0.69009389,-0.69009389,-0.69009389,1.6502275,-0.69009389,-0.69009389,-0.69009389,1.6526375,-0.69009389,-0.69009389,-0.69009389,1.63966,-0.69009389,-0.69009389,-0.69009389,1.65091,-0.69009389,-0.69009389,-0.69009389,1.6539811,-0.69009389,-0.69009389,-0.69009389,1.6542796,-0.69009389,-0.69009389,-0.69009389,1.6525735,-0.69009389,-0.69009389,-0.69009389,1.6548981,-0.69009389,-0.69009389,-0.69009389,1.6499823,-0.69009389,-0.69009389,-0.69009389,1.6527867,-0.69009389,-0.69009389,-0.69009389,1.637506,-0.69009389,-0.69009389,-0.69009389,1.6530853,-0.69009389,-0.69009389,-0.69009389,1.6514751,-0.69009389,-0.69009389,-0.69009389,1.650846,-0.69009389,-0.69009389,-0.69009389,1.6527334,-0.69009389,-0.69009389,-0.69009389,1.6518164,-0.69009389,-0.69009389,-0.69009389,1.6485747,-0.69009389,-0.69009389,-0.69009389,1.6458448,-0.69009389,-0.69009389,-0.69009389,1.6515604,-0.69009389,-0.69009389,-0.69009389,1.6414835,-0.69009389,-0.69009389,-0.69009389,1.6438081,-0.69009389,-0.69009389,-0.69009389,1.6397453,-0.69009389,-0.69009389,-0.69009389,1.6503128,-0.69009389,-0.69009389,-0.69009389,1.6365143,-0.69009389,-0.69009389,-0.69009389,1.6473804,-0.69009389,-0.69009389,-0.69009389,1.6536505,-0.69009389,-0.69009389,-0.69009389,1.6489372,-0.69009389,-0.69009389,-0.69009389,1.649609,-0.69009389,-0.69009389,-0.69009389,1.652019,-0.69009389,-0.69009389,-0.69009389,1.6457275,-0.69009389,-0.69009389,-0.69009389,1.6523069,-0.69009389,-0.69009389,-0.69009389,1.6526694,-0.69009389,-0.69009389,-0.69009389,1.6505048,-0.69009389,-0.69009389,-0.69009389,1.6384657,-0.69009389,-0.69009389,-0.69009389,1.6504195,-0.69009389,-0.69009389,-0.69009389,1.6523709,-0.69009389,-0.69009389,-0.69009389,1.6534052,-0.69009389,-0.69009389,-0.69009389,1.6529467,-0.69009389,-0.69009389,-0.69009389,1.6543436,-0.69009389,-0.69009389,-0.69009389,1.6313105,-0.69009389,-0.69009389,-0.69009389,1.6502808,-0.69009389,-0.69009389,-0.69009389,1.6399479,-0.69009389,-0.69009389,-0.69009389,1.6527441,-0.69009389,-0.69009389,-0.69009389,1.6468152,-0.69009389,-0.69009389,-0.69009389,1.6501955,-0.69009389,-0.69009389,-0.69009389,1.6509633,-0.69009389,-0.69009389,-0.69009389,1.6491185,-0.69009389,-0.69009389,-0.69009389,1.6495557,-0.69009389,-0.69009389,-0.69009389,1.6375487,-0.69009389,-0.69009389,-0.69009389,1.652019,-0.69009389,-0.69009389,-0.69009389,1.6413129,-0.69009389,-0.69009389,-0.69009389,1.6546315,-0.69009389,-0.69009389,-0.69009389,1.6547915,-0.69009389,-0.69009389,-0.69009389,1.6565509,-0.69009389,-0.69009389,-0.69009389,1.6477109,-0.69009389,-0.69009389,-0.69009389,1.6602512,-0.69009389,-0.69009389,-0.69009389,1.6457275,-0.69009389,-0.69009389,-0.69009389,1.6558152,-0.69009389,-0.69009389,-0.69009389,1.6563057,-0.69009389,-0.69009389,-0.69009389,1.6503661,-0.69009389,-0.69009389,-0.69009389,1.6549621,-0.69009389,-0.69009389,-0.69009389,1.6533732,-0.69009389,-0.69009389,-0.69009389,1.6538531,-0.69009389,-0.69009389,-0.69009389,1.6114232,-0.69009389,-0.69009389,-0.69009389,1.6449811,-0.69009389,-0.69009389,-0.69009389,1.6508567,-0.69009389,-0.69009389,-0.69009389,1.6564123,-0.69009389,-0.69009389,-0.69009389,1.655186,-0.69009389,-0.69009389,-0.69009389,1.6645592,-0.69009389,-0.69009389,-0.69009389,1.6658282,-0.69009389,-0.69009389,-0.69009389,1.6591955,-0.69009389,-0.69009389,-0.69009389,1.6626718,-0.69009389,-0.69009389,-0.69009389,1.657564,-0.69009389,-0.69009389,-0.69009389,1.6525202,-0.69009389,-0.69009389,-0.69009389,1.6539064,-0.69009389,-0.69009389,-0.69009389,1.6496943,-0.69009389,-0.69009389,-0.69009389,1.6541623,-0.69009389,-0.69009389,-0.69009389,1.638455,-0.69009389,-0.69009389,-0.69009389,1.6570201,-0.69009389,-0.69009389,-0.69009389,1.6591208,-0.69009389,-0.69009389,-0.69009389,1.6556979,-0.69009389,-0.69009389,-0.69009389,1.6569562,-0.69009389,-0.69009389,-0.69009389,1.6561244,-0.69009389,-0.69009389,-0.69009389,1.6544396,-0.69009389,-0.69009389,-0.69009389,1.6554633,-0.69009389,-0.69009389,-0.69009389,1.6569135,-0.69009389,-0.69009389,-0.69009389,1.6404704,-0.69009389,-0.69009389,-0.69009389,1.6576706,-0.69009389,-0.69009389,-0.69009389,1.6569242,-0.69009389,-0.69009389,-0.69009389,1.6542903,-0.69009389,-0.69009389,-0.69009389,1.6569668,-0.69009389,-0.69009389,-0.69009389,1.6554419,-0.69009389,-0.69009389,-0.69009389,1.6549514,-0.69009389,-0.69009389,-0.69009389,1.6413342,-0.69009389,-0.69009389,-0.69009389,1.6521789,-0.69009389,-0.69009389,-0.69009389,1.6544822,-0.69009389,-0.69009389,-0.69009389,1.6564017,-0.69009389,-0.69009389,-0.69009389,1.6569775,-0.69009389,-0.69009389,-0.69009389,1.6546209,-0.69009389,-0.69009389,-0.69009389,1.6551754,-0.69009389,-0.69009389,-0.69009389,1.6400332,-0.69009389,-0.69009389,-0.69009389,1.656519,-0.69009389,-0.69009389,-0.69009389,1.6538211,-0.69009389,-0.69009389,-0.69009389,1.6330167,-0.69009389,-0.69009389,-0.69009389,1.6383271,-0.69009389,-0.69009389,-0.69009389,1.645269,-0.69009389,-0.69009389,-0.69009389,1.6533199,-0.69009389,-0.69009389,-0.69009389,1.6514858,-0.69009389,-0.69009389,-0.69009389,1.6426351,-0.69009389,-0.69119222,-0.53997362,1.6495877,-0.68942209,-0.69119222,-0.53997362,1.6467406,-0.68942209,-0.69119222,-0.53997362,1.6492358,-0.68942209,-0.69009389,-0.69009389,1.6337311,-0.69009389,-0.69009389,-0.69009389,1.6505581,-0.69009389,-0.69009389,-0.69009389,1.6445759,-0.69009389,-0.69009389,-0.69009389,1.6477216,-0.69009389,-0.69009389,-0.69009389,1.6482548,-0.69009389,-0.69009389,-0.69009389,1.6469005,-0.69009389,-0.69009389,-0.69009389,1.6477003,-0.69009389,-0.69009389,-0.69009389,1.6388923,-0.69009389,-0.69009389,-0.69009389,1.6319077,-0.69009389,-0.69009389,-0.69009389,1.6460368,-0.69009389,-0.69009389,-0.69009389,1.6484147,-0.69009389,0.58489401,3.3192198,1.6364397,-0.65930846,0.29566884,0.38287466,1.629807,-0.6833759,0.30781453,0.40054402,1.6426245,-0.68331192,0.31113086,0.41488638,1.6445119,-0.68325861,0.31113086,0.41047171,1.6440747,-0.68327993,0.28463215,0.386191,1.6158165,-0.68336524,0.30670553,0.38949667,1.6421766,-0.68335458,0.28794849,0.37625265,1.6212442,-0.68339723,0.27690114,0.37404531,1.6065713,-0.68339723,0.25482777,0.3685323,1.5788996,-0.68340789,0.29898518,0.36521596,1.6356506,-0.68343988,0.29015583,0.35859395,1.6248058,-0.68346121,0.29125416,0.35417927,1.6272904,-0.68348254,0.28352315,0.35417927,1.6180345,-0.68348254,0.29787618,0.34424092,1.6372074,-0.68352519,0.2945705,0.33761891,1.6339124,-0.68354652,0.28463215,0.3298879,1.621916,-0.68356785,0.29677784,0.32326589,1.6373674,-0.68359984,0.29566884,0.31996021,1.6360131,-0.68359984,0.29677784,0.30891286,1.6393721,-0.68364249,0.29787618,0.30891286,1.6405877,-0.68364249,0.28794849,0.29677784,1.6294444,-0.68368514,0.29787618,0.2945705,1.6414621,-0.68369581,0.29677784,0.28683949,1.6418247,-0.6837278,0.29898518,0.28242482,1.6439041,-0.68373846,0.29898518,0.2758028,1.6450024,-0.68375979,0.29677784,0.27359547,1.6421553,-0.68377045,0.29787618,0.26918079,1.6437548,-0.68378112,0.29566884,0.26035144,1.6426565,-0.68381311,0.29125416,0.24599842,1.6390095,-0.68386642,0.2934615,0.24158374,1.6418567,-0.68388775,0.29236317,0.23716907,1.6411636,-0.68389841,0.29236317,0.23164539,1.6406837,-0.68391974,0.2934615,0.22832906,1.6429124,-0.6839304,0.29015583,0.22612172,1.6399053,-0.6839304,0.27910848,0.22170704,1.627397,-0.68395173,0.28021748,0.21729237,1.6294444,-0.68397306,0.29236317,0.21508503,1.643179,-0.68397306,0.29015583,0.20515735,1.6415901,-0.68400505,-0.69009389,-0.69009389,1.6304788,-0.69009389,-0.69009389,-0.69009389,1.6437655,-0.69009389,-0.69009389,-0.69009389,1.6426565,-0.69009389,-0.69009389,-0.69009389,1.6464633,-0.69009389,-0.69009389,-0.69009389,1.6411636,-0.69009389,-0.69009389,-0.69009389,1.647423,-0.69009389,-0.69009389,-0.69009389,1.6483401,-0.69009389,-0.69009389,-0.69009389,1.6495131,-0.69009389,-0.69009389,-0.69009389,1.649577,-0.69009389,-0.69009389,-0.69009389,1.6489052,-0.69009389,-0.69009389,-0.69009389,1.6261068,-0.69009389,-0.69009389,-0.69009389,1.647519,-0.69009389,-0.69009389,-0.69009389,1.6370581,-0.69009389,-0.69009389,-0.69009389,1.6437441,-0.69009389,-0.69009389,-0.69009389,1.6423046,-0.69009389,-0.69009389,-0.69009389,1.6445652,-0.69009389,-0.69009389,-0.69009389,1.637602,-0.69009389,-0.69009389,-0.69009389,1.6437868,-0.69009389,-0.69009389,-0.69009389,1.6291778,-0.69009389,-0.69009389,-0.69009389,1.643211,-0.69009389,-0.69009389,-0.69009389,1.6293484,-0.69009389,-0.69009389,-0.69009389,1.6396813,-0.69009389,-0.69009389,-0.69009389,1.6313852,-0.69009389,-0.69009389,-0.69009389,1.6394787,-0.69009389,-0.69009389,-0.69009389,1.6415688,-0.69009389,-0.69009389,-0.69009389,1.6393721,-0.69009389,-0.69009389,-0.69009389,1.6425392,-0.69009389,-0.69009389,-0.69009389,1.6435948,-0.69009389,-0.69009389,-0.69009389,1.6422193,-0.69009389,-0.69009389,-0.69009389,1.6301909,-0.69009389,-0.69009389,-0.69009389,1.6458022,-0.69009389,-0.69009389,-0.69009389,1.6472524,-0.69009389,-0.69009389,-0.69009389,1.646346,-0.69009389,-0.69009389,-0.69009389,1.6450557,-0.69009389,-0.69009389,-0.69009389,1.6461434,-0.69009389,-0.69009389,-0.69009389,1.6448958,-0.69009389,-0.69009389,-0.69009389,1.6464953,-0.69009389,-0.69009389,-0.69009389,1.6465486,-0.69009389,-0.69009389,-0.69009389,1.6468792,-0.69009389,-0.69009389,-0.69009389,1.6301589,-0.69009389,-0.69009389,-0.69009389,1.6445546,-0.69009389,-0.69009389,-0.69009389,1.6405131,-0.69009389,-0.69009389,-0.69009389,1.6457169,-0.69009389,-0.69009389,-0.69009389,1.6450877,-0.69009389,-0.69009389,-0.69009389,1.6438188,-0.69009389,-0.69009389,-0.69009389,1.6281648,-0.69009389,-0.69009389,-0.69009389,1.6433496,-0.69009389,-0.69009389,-0.69009389,1.6455463,-0.69009389,-0.69009389,-0.69009389,1.6435309,-0.69009389,-0.69009389,-0.69009389,1.6260001,-0.69009389,-0.69009389,-0.69009389,1.6414835,-0.69009389,-0.69009389,-0.69009389,1.6388709,-0.69009389,-0.69009389,-0.69009389,1.6399906,-0.69009389,-0.69009389,-0.69009389,1.6278982,-0.69009389,-0.69009389,-0.69009389,1.6433389,-0.69009389,-0.69009389,-0.69009389,1.6431576,-0.69009389,-0.69009389,-0.69009389,1.640929,-0.69009389,-0.69009389,-0.69009389,1.6305108,-0.69009389,-0.69009389,-0.69009389,1.6442133,-0.69009389,-0.69009389,-0.69009389,1.639756,-0.69009389,-0.69009389,-0.69009389,1.619666,-0.69009389,-0.69009389,-0.69009389,1.6247418,-0.69009389,-0.69009389,-0.69009389,1.6370901,-0.69009389,-0.69009389,-0.69009389,1.6337631,-0.69009389,-0.69009389,-0.69009389,1.6371328,-0.69009389,-0.69009389,-0.69009389,1.6229824,-0.69009389,-0.69009389,-0.69009389,1.6391055,-0.69009389,-0.69009389,-0.69009389,1.6380392,-0.69009389,-0.69009389,-0.69009389,1.6366743,-0.69009389,-0.69009389,-0.69009389,1.6029457,-0.69009389,-0.69009389,-0.69009389,1.6368022,-0.69009389,-0.69009389,-0.69009389,1.6365676,-0.69009389,-0.69009389,-0.69009389,1.6371434,-0.69009389,-0.69009389,-0.69009389,1.6396813,-0.69009389,-0.69009389,-0.69009389,1.6423899,-0.69009389,-0.69009389,-0.69009389,1.6235262,-0.69009389,-0.69009389,-0.69009389,1.6338271,-0.69009389,-0.69009389,-0.69009389,1.636397,-0.69009389,-0.69009389,-0.69009389,1.6355546,-0.69009389,-0.69009389,-0.69009389,1.6348081,-0.69009389,-0.69009389,-0.69009389,1.6356399,-0.69009389,-0.69009389,-0.69009389,1.637346,-0.69009389,-0.69009389,-0.69009389,1.6346482,-0.69009389,-0.69009389,-0.69009389,1.6388709,-0.69009389,-0.69009389,-0.69009389,1.6380605,-0.69009389,-0.69009389,-0.69009389,1.6397133,-0.69009389,-0.69009389,-0.69009389,1.6279622,-0.69009389,-0.69009389,-0.69009389,1.6399693,-0.69009389,-0.69009389,-0.69009389,1.6401185,-0.69009389,-0.69009389,-0.69009389,1.6396707,-0.69009389,-0.69009389,-0.69009389,1.614217,-0.69009389,-0.69009389,-0.69009389,1.6368982,-0.69009389,-0.69009389,-0.69009389,1.6353093,-0.69009389,-0.69009389,-0.69009389,1.6175333,-0.69009389,-0.69009389,-0.69009389,1.6415475,-0.69009389,-0.69009389,-0.69009389,1.6392548,-0.69009389,-0.69009389,-0.69009389,1.6254243,-0.69009389,-0.69009389,-0.69009389,1.6415688,-0.69009389,-0.69009389,-0.69009389,1.6423579,-0.69009389,-0.69009389,-0.69009389,1.6389242,-0.69009389,-0.69009389,-0.69009389,1.6352453,-0.69009389,-0.69009389,-0.69009389,1.6436055,-0.69009389,-0.69009389,-0.69009389,1.6377193,-0.69009389,-0.69009389,-0.69009389,1.6377939,-0.69009389,-0.69009389,-0.69009389,1.6377939,-0.69009389,-0.69009389,-0.69009389,1.6377939,-0.69009389,-0.69009389,-0.69009389,1.6377939,-0.69009389,-0.69009389,-0.69009389,1.6377939,-0.69009389,-0.69009389,-0.69009389,1.6377939,-0.69009389,-0.69009389,-0.69009389,1.6377939,-0.69009389:0
0.10464832,-0.12715083,1.5880258,-0.93246152,0.10820128,-0.12832754,1.590859,-0.93245009,0.099918654,-0.13188049,1.5825421,-0.93247294,0.10110678,-0.1330572,1.5837531,-0.93247294,0.11411907,-0.13188049,1.5984333,-0.93246152,0.1164839,-0.1330572,1.6000556,-0.93246152,0.11529577,-0.1330572,1.5991074,-0.93246152,0.10347161,-0.13188049,1.5864035,-0.93247294,0.10347161,-0.12832754,1.5874317,-0.93246152,0.10347161,-0.13778686,1.5870433,-0.93248437,0.10702457,-0.14015169,1.5898308,-0.93248437,0.096377119,-0.13778686,1.5791034,-0.93249579,0.10464832,-0.14251652,1.5878658,-0.93249579,0.10228349,-0.14724618,1.5849298,-0.93250721,0.098741951,-0.14133982,1.5817538,-0.93249579,0.10347161,-0.14133982,1.5871347,-0.93249579,0.10820128,-0.14724618,1.5912246,-0.93250721,0.10583644,-0.15197585,1.5894652,-0.93251864,0.10702457,-0.15789364,1.5904934,-0.93253006,0.10347161,-0.15908176,1.5864606,-0.93254149,0.096377119,-0.15789364,1.5791605,-0.93255291,0.10347161,-0.15434068,1.5867805,-0.93253006,0.10347161,-0.15316397,1.5878544,-0.93253006,0.099918654,-0.15434068,1.5841872,-0.93254149,0.10464832,-0.15434068,1.5885856,-0.93253006,0.10583644,-0.15434068,1.5899108,-0.93253006,0.10820128,-0.16498813,1.5920014,-0.93255291,0.10820128,-0.16498813,1.5921157,-0.93255291,0.10110678,-0.1614466,1.5844385,-0.93255291,0.095188992,-0.16971779,1.5780638,-0.93258718,0.096377119,-0.17917712,1.5784979,-0.93261003,0.096377119,-0.17800041,1.5801887,-0.93261003,0.095188992,-0.17917712,1.5775383,-0.93261003,0.099918654,-0.18154195,1.5825992,-0.93261003,0.095188992,-0.18745974,1.5776182,-0.93263288,0.099918654,-0.18745974,1.5833989,-0.93262146,0.097553823,-0.1910127,1.5802344,-0.93263288,0.098741951,-0.18273008,1.5818338,-0.93261003,0.099918654,-0.18982457,1.5820166,-0.93263288,0.096377119,-0.18628304,1.5791377,-0.93262146,0.10228349,-0.18864787,1.5846213,-0.93262146,0.10110678,-0.18390678,1.5848155,-0.93261003,0.097553823,-0.19574236,1.5800059,-0.93265573,0.096377119,-0.19337753,1.5795832,-0.93264431,0.10110678,-0.18864787,1.5844614,-0.93263288,0.098741951,-0.18982457,1.582108,-0.93263288,0.10583644,-0.18864787,1.5893624,-0.93262146,0.10110678,-0.19691906,1.5846099,-0.93264431,0.099918654,-0.19455423,1.5831933,-0.93264431,0.097553823,-0.19574236,1.5799716,-0.93265573,0.095188992,-0.20520168,1.577584,-0.93267858,0.098741951,-0.20756652,1.5804286,-0.93267858,0.10228349,-0.20164873,1.585204,-0.93265573,0.10110678,-0.20756652,1.584667,-0.93267858,0.10110678,-0.20874322,1.5835474,-0.93267858,0.10228349,-0.20993135,1.5855581,-0.93267858,0.10228349,-0.21702584,1.5838788,-0.93270143,0.10228349,-0.21347288,1.5848955,-0.93269,0.098741951,-0.21821397,1.5804515,-0.93270143,0.10820128,-0.20993135,1.5911903,-0.93267858,0.10228349,-0.21702584,1.5851354,-0.93270143,0.10228349,-0.21702584,1.5852839,-0.93270143,0.096377119,-0.21939067,1.5776182,-0.93271285,0.10702457,-0.22530846,1.5897394,-0.93271285,0.10583644,-0.21821397,1.5890654,-0.93269,0.10583644,-0.22412033,1.5885741,-0.93271285,0.10820128,-0.23121483,1.5897508,-0.93272428,0.10583644,-0.23121483,1.5879458,-0.93272428,0.10110678,-0.23476779,1.582485,-0.93274712,0.10228349,-0.23713262,1.5839359,-0.93274712,0.10228349,-0.24067415,1.5829762,-0.93275855,0.10228349,-0.24422711,1.5837531,-0.93275855,0.098741951,-0.24186228,1.5807256,-0.93276997,0.096377119,-0.24422711,1.5770584,-0.93276997,0.095188992,-0.24778007,1.5761217,-0.9327814,0.094012288,-0.2501449,1.5735398,-0.93279282,0.098741951,-0.24778007,1.5785779,-0.9327814,0.097553823,-0.24659194,1.5781095,-0.9327814,0.098741951,-0.2513216,1.5788635,-0.9327814,0.10228349,-0.25368643,1.5830676,-0.9327814,0.10228349,-0.25605127,1.5825764,-0.93279282,0.10702457,-0.25605127,1.5876945,-0.9327814,0.11056611,-0.2584161,1.5909847,-0.9327814,0.11293094,-0.2584161,1.5931439,-0.9327814,0.1093894,-0.25960422,1.5899565,-0.93279282,0.11175423,-0.25960422,1.5915902,-0.93279282,0.11411907,-0.26078093,1.5943777,-0.93279282,0.11529577,-0.26196906,1.5953602,-0.93279282,0.1176606,-0.26314576,1.5979992,-0.93279282,0.1164839,-0.26314576,1.5974965,-0.93279282,0.11884873,-0.26433389,1.5989474,-0.93279282,0.11884873,-0.26551059,1.5994044,-0.93279282,0.11529577,-0.26669872,1.5955658,-0.93280425,0.1176606,-0.26787542,1.5976679,-0.93280425,0.11884873,-0.26787542,1.5990274,-0.93279282,0.1176606,-0.26906355,1.5975765,-0.93280425,0.11411907,-0.27024025,1.5941721,-0.93280425,0.1176606,-0.27024025,1.5975536,-0.93280425,0.11411907,-0.27261651,1.5940007,-0.93281567,0.1093894,-0.27498134,1.5882657,-0.93282709,0.11529577,-0.27498134,1.5945948,-0.93281567,0.11175423,-0.27498134,1.591316,-0.93282709,0.11293094,-0.27615804,1.592287,-0.93282709,0.1176606,-0.27615804,1.5969253,-0.93281567,0.11411907,-0.27734617,1.5939207,-0.93282709,0.11529577,-0.27734617,1.5945605,-0.93281567,0.11529577,-0.27852287,1.5948689,-0.93282709,0.1164839,-0.279711,1.5957372,-0.93282709,0.1176606,-0.28088771,1.5973366,-0.93282709,0.1164839,-0.28088771,1.5958057,-0.93282709,0.12357839,-0.28088771,1.6026489,-0.93281567,0.12239026,-0.28207583,1.602409,-0.93282709,0.1176606,-0.28444066,1.5967882,-0.93283852,0.1176606,-0.28444066,1.5971309,-0.93283852,0.12239026,-0.28444066,1.6021919,-0.93282709,0.12357839,-0.28444066,1.6034143,-0.93282709,0.12357839,-0.28561737,1.6029802,-0.93282709,0.11884873,-0.2879822,1.5979992,-0.93283852,0.12475509,-0.2868055,1.6040998,-0.93282709,0.12002543,-0.2879822,1.5999642,-0.93283852,0.12357839,-0.28917033,1.6024432,-0.93283852,0.11884873,-0.29034703,1.5979421,-0.93284994,0.12121356,-0.29034703,1.600364,-0.93283852,0.12121356,-0.29153516,1.5999528,-0.93284994,0.11884873,-0.29153516,1.5971995,-0.93284994,0.11175423,-0.29389999,1.590185,-0.93287279,0.10702457,-0.29626482,1.5861065,-0.93287279,0.11175423,-0.29507669,1.5910189,-0.93287279,0.12002543,-0.29507669,1.5992787,-0.93284994,0.12475509,-0.29389999,1.604294,-0.93284994,0.12357839,-0.29507669,1.6033115,-0.93284994,0.12594322,-0.29507669,1.6058134,-0.93284994,0.12239026,-0.29626482,1.6020891,-0.93284994,0.12594322,-0.29626482,1.6053107,-0.93284994,0.12830805,-0.29626482,1.6071958,-0.93284994,0.10583644,-0.30218261,1.5845642,-0.93289564,0.12239026,-0.29862965,1.6011637,-0.93286137,0.12121356,-0.29980635,1.5999528,-0.93286137,0.12239026,-0.29980635,1.6009924,-0.93286137,0.12357839,-0.30099448,1.6023861,-0.93286137,0.12239026,-0.30218261,1.6013122,-0.93287279,0.12357839,-0.30335931,1.6020434,-0.93287279,0.12239026,-0.30218261,1.6018606,-0.93287279,0.12239026,-0.30335931,1.6017121,-0.93287279,0.12357839,-0.30335931,1.6021805,-0.93287279,0.12594322,-0.30335931,1.604751,-0.93286137,0.12357839,-0.30572414,1.6029802,-0.93287279,0.052622031,-0.31991313,1.5269286,-0.93302131,0.088094498,-0.31281864,1.5671193,-0.93295276,0.12357839,-0.30572414,1.6020662,-0.93287279,0.12239026,-0.30572414,1.6011637,-0.93287279,0.095188992,-0.31281864,1.5750363,-0.93294134,0.12475509,-0.30691227,1.6033001,-0.93287279,0.12002543,-0.3092771,1.5982505,-0.93288422,0.098741951,-0.31518347,1.5775383,-0.93294134,0.078635174,-0.3163716,1.551765,-0.93296419,0.092824161,-0.3163716,1.5712777,-0.93295276,0.12239026,-0.31045381,1.6012437,-0.93288422,0.12475509,-0.3092771,1.6036999,-0.93288422,0.12711992,-0.31164193,1.6052879,-0.93288422,0.12594322,-0.31281864,1.6037799,-0.93288422,0.12239026,-0.31281864,1.6001698,-0.93289564,0.12594322,-0.31281864,1.6037799,-0.93288422,0.12830805,-0.31281864,1.6063275,-0.93288422,0.13303771,-0.31281864,1.611834,-0.93287279,0.10228349,-0.31991313,1.5808742,-0.93294134,0.13184959,-0.31400677,1.6101204,-0.93288422,0.12357839,-0.31518347,1.6023519,-0.93289564,0.12357839,-0.3163716,1.6011295,-0.93289564,0.12121356,-0.3163716,1.5996443,-0.93289564,0.12594322,-0.31518347,1.604134,-0.93289564,0.12830805,-0.3163716,1.6061561,-0.93289564,0.12830805,-0.3163716,1.6068759,-0.93288422,0.12594322,-0.3163716,1.604591,-0.93289564,0.12475509,-0.3175483,1.6028088,-0.93289564,0.13540255,-0.3163716,1.6135705,-0.93288422,0.12948476,-0.31873643,1.6072872,-0.93289564,0.12830805,-0.3175483,1.6068759,-0.93289564,0.12711992,-0.31873643,1.6055964,-0.93289564,0.12121356,-0.31991313,1.5985476,-0.93290707,0.12594322,-0.31991313,1.6044996,-0.93290707,0.11411907,-0.32227796,1.5913502,-0.93292991,0.12594322,-0.32110126,1.6038941,-0.93290707,0.12357839,-0.32110126,1.6014379,-0.93290707,0.12357839,-0.32227796,1.6019634,-0.93290707,0.12357839,-0.32227796,1.6016664,-0.93290707,0.12121356,-0.32346609,1.5991873,-0.93291849,0.12002543,-0.32346609,1.598262,-0.93291849,0.1176606,-0.32464279,1.5957143,-0.93291849,0.10347161,-0.32700762,1.5820623,-0.93295276,0.12594322,-0.32227796,1.6043511,-0.93290707,0.12830805,-0.32227796,1.6059277,-0.93290707,0.13067288,-0.32227796,1.6093093,-0.93289564,0.12594322,-0.32464279,1.6039056,-0.93290707,0.12948476,-0.32346609,1.6075271,-0.93290707,0.12475509,-0.32346609,1.6018835,-0.93290707,0.12594322,-0.32464279,1.6029231,-0.93290707,0.12948476,-0.32464279,1.6067845,-0.93290707,0.10347161,-0.33056058,1.5828049,-0.93296419,0.12594322,-0.32464279,1.6037685,-0.93291849,0.12594322,-0.32464279,1.6038827,-0.93290707,0.12239026,-0.32583092,1.6000784,-0.93291849,0.12830805,-0.32464279,1.6067502,-0.93290707,0.12594322,-0.32583092,1.6045453,-0.93291849,0.13067288,-0.32583092,1.6086581,-0.93290707,0.13540255,-0.32583092,1.6128165,-0.93289564,0.13067288,-0.32700762,1.6076756,-0.93290707,0.11293094,-0.33174871,1.5919786,-0.93295276,0.13067288,-0.32819575,1.6079383,-0.93290707,0.12711992,-0.32819575,1.6044882,-0.93291849,0.12948476,-0.32937246,1.6068645,-0.93291849,0.12830805,-0.32819575,1.6047624,-0.93291849,0.12830805,-0.32937246,1.6056992,-0.93291849,0.12357839,-0.33056058,1.6003869,-0.93292991,0.12594322,-0.32937246,1.6036085,-0.93291849,0.12239026,-0.32464279,1.6014379,-0.93291849,0.12475509,-0.32583092,1.6033572,-0.93291849,0.12121356,-0.32700762,1.5989703,-0.93292991,0.1176606,-0.31873643,1.5968453,-0.93291849,0.10820128,-0.32700762,1.5882543,-0.93295276,0.11884873,-0.32937246,1.5971424,-0.93292991,0.12357839,-0.33056058,1.6011637,-0.93292991,0.12357839,-0.33056058,1.6013579,-0.93292991,0.12357839,-0.33056058,1.6011066,-0.93292991,0.12357839,-0.33292541,1.6014836,-0.93292991,0.12475509,-0.33292541,1.6018035,-0.93292991,0.12594322,-0.33292541,1.6036428,-0.93292991,0.12121356,-0.33411354,1.5987532,-0.93294134,0.12594322,-0.33411354,1.604294,-0.93292991,0.12239026,-0.33411354,1.600821,-0.93294134,0.12121356,-0.33529025,1.5980335,-0.93294134,0.1164839,-0.33647837,1.5932467,-0.93295276,0.1164839,-0.33647837,1.5940007,-0.93295276,0.12239026,-0.33647837,1.6002612,-0.93294134,0.12002543,-0.33647837,1.5977821,-0.93294134,0.1176606,-0.33647837,1.5954744,-0.93295276,0.12002543,-0.33765508,1.5969824,-0.93295276,0.12121356,-0.33647837,1.5986161,-0.93294134,0.12121356,-0.33647837,1.5979763,-0.93294134,0.12121356,-0.33765508,1.5990845,-0.93294134,0.12002543,-0.33765508,1.5975422,-0.93295276,0.12239026,-0.3388432,1.5985361,-0.93295276,0.1176606,-0.3388432,1.5946404,-0.93295276,0.12475509,-0.33765508,1.6015979,-0.93294134,0.12475509,-0.3388432,1.6024547,-0.93294134,0.12711992,-0.33647837,1.6046824,-0.93292991,0.12475509,-0.3388432,1.6015065,-0.93294134,0.12830805,-0.33765508,1.6056421,-0.93292991,0.12594322,-0.3388432,1.6031744,-0.93294134,0.12711992,-0.3388432,1.603163,-0.93294134,0.12830805,-0.3388432,1.604511,-0.93294134,0.12830805,-0.3388432,1.6047281,-0.93294134,0.13303771,-0.3388432,1.6101661,-0.93292991,0.13067288,-0.3388432,1.6072415,-0.93292991,0.12948476,-0.34001991,1.606933,-0.93294134,0.11884873,-0.34001991,1.59576,-0.93295276,0.12121356,-0.34120804,1.5972566,-0.93295276,0.12121356,-0.34238474,1.5978964,-0.93295276,-0.93843643,-0.93843643,1.603163,-0.93843643,-0.93843643,-0.93843643,1.5993473,-0.93843643,-0.93843643,-0.93843643,1.5977479,-0.93843643,-0.93843643,-0.93843643,1.6061676,-0.93843643,-0.93843643,-0.93843643,1.5996557,-0.93843643,-0.93843643,-0.93843643,1.600741,-0.93843643,-0.93843643,-0.93843643,1.5954973,-0.93843643,-0.93843643,-0.93843643,1.6096291,-0.93843643,-0.93843643,-0.93843643,1.6066131,-0.93843643,-0.93843643,-0.93843643,1.6095035,-0.93843643,-0.93843643,-0.93843643,1.6086238,-0.93843643,-0.93843643,-0.93843643,1.6005011,-0.93843643,-0.93843643,-0.93843643,1.6063961,-0.93843643,-0.93843643,-0.93843643,1.61509,-0.93843643,-0.93843643,-0.93843643,1.6127137,-0.93843643,-0.93843643,-0.93843643,1.6124624,-0.93843643,-0.93843643,-0.93843643,1.6157183,-0.93843643,-0.93843643,-0.93843643,1.6170892,-0.93843643,-0.93843643,-0.93843643,1.6088866,-0.93843643,-0.93843643,-0.93843643,1.6126909,-0.93843643,-0.93843643,-0.93843643,1.5938065,-0.93843643,-0.93843643,-0.93843643,1.6088294,-0.93843643,-0.93843643,-0.93843643,1.6061676,-0.93843643,-0.93843643,-0.93843643,1.6121768,-0.93843643,-0.93843643,-0.93843643,1.6086809,-0.93843643,-0.93843643,-0.93843643,1.6083725,-0.93843643,-0.93843643,-0.93843643,1.6036885,-0.93843643,-0.93843643,-0.93843643,1.6093435,-0.93843643,-0.93843643,-0.93843643,1.6063846,-0.93843643,-0.93843643,-0.93843643,1.6040427,-0.93843643,-0.93843643,-0.93843643,1.6067045,-0.93843643,-0.93843643,-0.93843643,1.6078012,-0.93843643,-0.93843643,-0.93843643,1.6047167,-0.93843643,-0.93843643,-0.93843643,1.6019177,-0.93843643,-0.93843643,-0.93843643,1.6020434,-0.93843643,-0.93843643,-0.93843643,1.6015864,-0.93843643,-0.93843643,-0.93843643,1.6116055,-0.93843643,-0.93843643,-0.93843643,1.6098462,-0.93843643,-0.93843643,-0.93843643,1.6124624,-0.93843643,-0.93843643,-0.93843643,1.575539,-0.93843643,-0.93843643,-0.93843643,1.6094463,-0.93843643,-0.93843643,-0.93843643,1.6108858,-0.93843643,-0.93843643,-0.93843643,1.5980449,-0.93843643,-0.93843643,-0.93843643,1.5945719,-0.93843643,-0.93843643,-0.93843643,1.5833532,-0.93843643,-0.93843643,-0.93843643,1.5882428,-0.93843643,-0.93843643,-0.93843643,1.5959657,-0.93843643,-0.93843643,-0.93843643,1.5933495,-0.93843643,-0.93843643,-0.93843643,1.5953259,-0.93843643,-0.93843643,-0.93843643,1.5954516,-0.93843643,-0.93843643,-0.93843643,1.5953488,-0.93843643,-0.93843643,-0.93843643,1.5923556,-0.93843643,-0.93843643,-0.93843643,1.5947775,-0.93843643,-0.93843643,-0.93843643,1.5935094,-0.93843643,-0.93843643,-0.93843643,1.5587796,-0.93843643,-0.93843643,-0.93843643,1.5948918,-0.93843643,-0.93843643,-0.93843643,1.5960228,-0.93843643,-0.93843643,-0.93843643,1.6008553,-0.93843643,-0.93843643,-0.93843643,1.6001698,-0.93843643,-0.93843643,-0.93843643,1.6066131,-0.93843643,-0.93843643,-0.93843643,1.5982848,-0.93843643,-0.93843643,-0.93843643,1.5980449,-0.93843643,-0.93843643,-0.93843643,1.5937836,-0.93843643,-0.93843643,-0.93843643,1.5882428,-0.93843643,-0.93843643,-0.93843643,1.5806228,-0.93843643,-0.93843643,-0.93843643,1.5969025,-0.93843643,-0.93843643,-0.93843643,1.5962855,-0.93843643,-0.93843643,-0.93843643,1.5968796,-0.93843643,-0.93843643,-0.93843643,1.5949146,-0.93843643,-0.93843643,-0.93843643,1.5963427,-0.93843643,-0.93843643,-0.93843643,1.5973594,-0.93843643,-0.93843643,-0.93843643,1.5330177,-0.93843643,-0.93843643,-0.93843643,1.5845414,-0.93843643,-0.93843643,-0.93843643,1.5941835,-0.93843643,-0.93843643,-0.93843643,1.5207823,-0.93843643,-0.93843643,-0.93843643,1.5956686,-0.93843643,-0.93843643,-0.93843643,1.6020662,-0.93843643,-0.93843643,-0.93843643,1.6038256,-0.93843643,-0.93843643,-0.93843643,1.6011752,-0.93843643,-0.93843643,-0.93843643,1.6045225,-0.93843643,-0.93843643,-0.93843643,1.6059734,-0.93843643,-0.93843643,-0.93843643,1.6048309,-0.93843643,-0.93843643,-0.93843643,1.6068073,-0.93843643,-0.93843643,-0.93843643,1.6052422,-0.93843643,-0.93843643,-0.93843643,1.5979192,-0.93843643,-0.93843643,-0.93843643,1.6014722,-0.93843643,-0.93843643,-0.93843643,1.60354,-0.93843643,-0.93843643,-0.93843643,1.5988674,-0.93843643,-0.93843643,-0.93843643,1.6012323,-0.93843643,-0.93843643,-0.93843643,1.5940692,-0.93843643,-0.93843643,-0.93843643,1.5936351,-0.93843643,-0.93843643,-0.93843643,1.590859,-0.93843643,-0.93843643,-0.93843643,1.5926412,-0.93843643,-0.93843643,-0.93843643,1.594709,-0.93843643,-0.93843643,-0.93843643,1.5940807,-0.93843643,-0.93843643,-0.93843643,1.5918986,-0.93843643,-0.93843643,-0.93843643,1.5936351,-0.93843643,-0.93843643,-0.93843643,1.5936237,-0.93843643,-0.93843643,-0.93843643,1.5964112,-0.93843643,-0.93843643,-0.93843643,1.5950974,-0.93843643,-0.93843643,-0.93843643,1.5957715,-0.93843643,-0.93843643,-0.93843643,1.596971,-0.93843643,-0.93843643,-0.93843643,1.596971,-0.93843643,-0.93843643,-0.93843643,1.596971,-0.93843643,-0.93843643,-0.93843643,1.596971,-0.93843643,-0.93843643,-0.93843643,1.596971,-0.93843643,-0.93843643,-0.93843643,1.596971,-0.93843643:0
-0.61353411,-0.61353411,1.7108986,-0.61353411,-0.61353411,-0.61353411,1.7111566,-0.61353411,-0.61353411,-0.61353411,1.7132406,-0.61353411,-0.61353411,-0.61353411,1.7144017,-0.61353411,-0.61353411,-0.61353411,1.7157314,-0.61353411,-0.61353411,-0.61353411,1.7152154,-0.61353411,-0.61353411,-0.61353411,1.7139055,-0.61353411,-0.61353411,-0.61353411,1.7143818,-0.61353411,-0.61353411,-0.61353411,1.7128536,-0.61353411,-0.61353411,-0.61353411,1.7084177,-0.61353411,-0.61353411,-0.61353411,1.7137566,-0.61353411,-0.61353411,-0.61353411,1.7123673,-0.61353411,-0.61353411,-0.61353411,1.7132505,-0.61353411,-0.61353411,-0.61353411,1.7124963,-0.61353411,-0.61353411,-0.61353411,1.7117917,-0.61353411,-0.61353411,-0.61353411,1.7123078,-0.61353411,-0.61353411,-0.61353411,1.711504,-0.61353411,-0.61353411,-0.61353411,1.7118116,-0.61353411,-0.61353411,-0.61353411,1.7127246,-0.61353411,-0.61353411,-0.61353411,1.711881,-0.61353411,-0.61353411,-0.61353411,1.7135085,-0.61353411,-0.61353411,-0.61353411,1.7119604,-0.61353411,-0.61353411,-0.61353411,1.7095291,-0.61353411,-0.61353411,-0.61353411,1.7085864,-0.61353411,-0.61353411,-0.61353411,1.7139055,-0.61353411,-0.61353411,-0.61353411,1.714362,-0.61353411,-0.61353411,-0.61353411,1.7142826,-0.61353411,-0.61353411,-0.61353411,1.7130917,-0.61353411,-0.61353411,-0.61353411,1.7125162,-0.61353411,-0.61353411,-0.61353411,1.7144513,-0.61353411,-0.61353411,-0.61353411,1.7146597,-0.61353411,-0.61353411,-0.61353411,1.7156421,-0.61353411,-0.61353411,-0.61353411,1.7130421,-0.61353411,-0.61353411,-0.61353411,1.7122185,-0.61353411,-0.61353411,-0.61353411,1.7106009,-0.61353411,-0.61353411,-0.61353411,1.7087849,-0.61353411,-0.61353411,-0.61353411,1.709033,-0.61353411,-0.61353411,-0.61353411,1.7086856,-0.61353411,-0.61353411,-0.61353411,1.7024437,-0.61353411,-0.61353411,-0.61353411,1.7055597,-0.61353411,-0.72858873,-0.091670028,1.7005483,-0.61111274,-0.72858873,-0.090647893,1.7053017,-0.61111274,-0.72961086,-0.098864663,1.7058078,-0.61114251,-0.72961086,-0.099886797,1.7050437,-0.61115244,-0.73064292,-0.10708143,1.7047063,-0.61118221,-0.73064292,-0.11016768,1.7041704,-0.61119213,-0.73064292,-0.11427607,1.7079612,-0.61121198,-0.73064292,-0.11838445,1.7061154,-0.6112219,-0.73166505,-0.12249284,1.7087154,-0.61124175,-0.73166505,-0.12556916,1.7091024,-0.6112616,-0.73269711,-0.12967755,1.7109185,-0.61127152,-0.73269711,-0.13173174,1.7100154,-0.61128145,-0.73269711,-0.13481799,1.7113749,-0.61129137,-0.73269711,-0.13790424,1.7112856,-0.61130129,-0.73269711,-0.14098057,1.7103627,-0.61132114,-0.73269711,-0.14508895,1.7112162,-0.61133106,-0.73269711,-0.14714314,1.7108291,-0.61134099,-0.73269711,-0.14919734,1.7095589,-0.61134099,-0.73371925,-0.15022939,1.7133597,-0.61135091,-0.73371925,-0.15125153,1.713965,-0.61135091,-0.73371925,-0.15330572,1.7128039,-0.61136083,-0.7347513,-0.15535991,1.7163169,-0.61137076,-0.7347513,-0.15741411,1.7138459,-0.61137076,-0.7347513,-0.1594683,1.7138559,-0.61138068,-0.7347513,-0.16153241,1.7092215,-0.61140053,-0.73371925,-0.16153241,1.707078,-0.61139061,-0.7347513,-0.16460874,1.7071673,-0.61140053,-0.7347513,-0.16460874,1.7075543,-0.61141045,-0.7347513,-0.16666293,1.7060658,-0.61141045,-0.73371925,-0.16769499,1.7067902,-0.61142038,-0.73371925,-0.16871712,1.7050139,-0.61142038,-0.7347513,-0.17077132,1.7058177,-0.61142038,-0.7347513,-0.16974918,1.7074948,-0.61142038,-0.7347513,-0.17385757,1.7066811,-0.61144022,-0.7347513,-0.17385757,1.7074154,-0.61144022,-0.61353411,-0.61353411,1.7196513,-0.61353411,-0.61353411,-0.58579755,1.7136772,-0.61329594,-0.61353411,-0.61353411,1.7154536,-0.61353411,-0.61353411,-0.61353411,1.715007,-0.61353411,-0.61353411,-0.61353411,1.7166543,-0.61353411,-0.61353411,-0.61353411,1.7151062,-0.61353411,-0.61353411,-0.61353411,1.7145307,-0.61353411,-0.61353411,-0.61353411,1.7153146,-0.61353411,-0.61353411,-0.61353411,1.7151856,-0.61353411,-0.61353411,-0.61353411,1.708249,-0.61353411,-0.61353411,-0.61353411,1.7073757,-0.61353411,-0.61353411,-0.61353411,1.7081101,-0.61353411,-0.61353411,-0.61353411,1.7107398,-0.61353411,-0.61353411,-0.61353411,1.709807,-0.61353411,-0.61353411,-0.61353411,1.7090826,-0.61353411,-0.61353411,-0.61353411,1.7104223,-0.61353411,-0.61353411,-0.61353411,1.7119207,-0.61353411,-0.61353411,-0.61353411,1.7111169,-0.61353411,-0.61353411,-0.61353411,1.7122085,-0.61353411,-0.61353411,-0.61353411,1.7134887,-0.61353411,-0.61353411,-0.61353411,1.7165253,-0.61353411,-0.61353411,-0.61353411,1.7180139,-0.61353411,-0.61353411,-0.61353411,1.7182421,-0.61353411,-0.61353411,-0.61353411,1.7174681,-0.61353411,-0.61353411,-0.61353411,1.7128933,-0.61353411,-0.61353411,-0.61353411,1.7127742,-0.61353411,-0.61353411,-0.61353411,1.7134788,-0.61353411,-0.61353411,-0.61353411,1.711762,-0.61353411,-0.61353411,-0.61353411,1.7090925,-0.61353411,-0.61353411,-0.61353411,1.7167833,-0.61353411,-0.61353411,-0.61353411,1.715781,-0.61353411,-0.61353411,-0.61353411,1.7157612,-0.61353411,-0.61353411,-0.61353411,1.716178,-0.61353411,-0.61353411,-0.61353411,1.7172597,-0.61353411,-0.61353411,-0.61353411,1.7155627,-0.61353411,-0.61353411,-0.61353411,1.7168826,-0.61353411,-0.61353411,-0.61353411,1.7188077,-0.61353411,-0.61353411,-0.61353411,1.7144314,-0.61353411,-0.61353411,-0.61353411,1.7165452,-0.61353411,-0.61353411,-0.61353411,1.7142726,-0.61353411,-0.61353411,-0.61353411,1.7167337,-0.61353411,-0.61353411,-0.61353411,1.7162971,-0.61353411,-0.61353411,-0.61353411,1.7164955,-0.61353411,-0.61353411,-0.61353411,1.7184703,-0.61353411,-0.61353411,-0.61353411,1.7164558,-0.61353411,-0.61353411,-0.61353411,1.7189864,-0.61353411,-0.61353411,-0.61353411,1.7168726,-0.61353411,-0.61353411,-0.61353411,1.7158902,-0.61353411,-0.61353411,-0.61353411,1.7151558,-0.61353411,-0.61353411,-0.61353411,1.7115238,-0.61353411,-0.61353411,-0.61353411,1.7087452,-0.61353411,-0.61353411,-0.61353411,1.7089734,-0.61353411,-0.61353411,-0.61353411,1.715136,-0.61353411,-0.61353411,-0.61353411,1.7180535,-0.61353411,-0.61353411,-0.61353411,1.7163665,-0.61353411,-0.61353411,-0.61353411,1.7168925,-0.61353411,-0.61353411,-0.61353411,1.7140246,-0.61353411,-0.61353411,-0.61353411,1.7084872,-0.61353411,-0.61353411,-0.61353411,1.7122383,-0.61353411,-0.61353411,-0.61353411,1.7149276,-0.61353411,-0.61353411,-0.61353411,1.7159894,-0.61353411,-0.61353411,-0.61353411,1.7184703,-0.61353411,-0.61353411,-0.61353411,1.7169719,-0.61353411,-0.61353411,-0.61353411,1.7174284,-0.61353411,-0.61353411,-0.61353411,1.7205146,-0.61353411,-0.61353411,-0.61353411,1.7208719,-0.61353411,-0.61353411,-0.61353411,1.7179047,-0.61353411,-0.61353411,-0.61353411,1.7208619,-0.61353411,-0.61353411,-0.61353411,1.7208818,-0.61353411,-0.61353411,-0.61353411,1.7199986,-0.61353411,-0.61353411,-0.61353411,1.7194726,-0.61353411,-0.61353411,-0.61353411,1.71852,-0.61353411,-0.61353411,-0.61353411,1.7188474,-0.61353411,-0.72961086,-0.079344874,1.7168826,-0.61108297,-0.73166505,-0.09372422,1.7171703,-0.61113259,-0.73166505,-0.09681047,1.7168032,-0.61114251,-0.73166505,-0.095778412,1.7175772,-0.61114251,-0.73166505,-0.098864663,1.7166047,-0.61115244,-0.73166505,-0.10604937,1.7166543,-0.61118221,-0.73166505,-0.10913562,1.7151955,-0.61119213,-0.73269711,-0.11324401,1.716565,-0.61121198,-0.73269711,-0.11633026,1.7147986,-0.6112219,-0.73269711,-0.12043864,1.7142429,-0.61124175,-0.73269711,-0.12454703,1.7137963,-0.61125167,-0.73371925,-0.12660122,1.7162871,-0.6112616,-0.73371925,-0.12967755,1.7163665,-0.61127152,-0.73371925,-0.13481799,1.7159001,-0.61129137,-0.73371925,-0.13481799,1.7145009,-0.61129137,-0.73371925,-0.13790424,1.7176864,-0.61131122,-0.7347513,-0.14201262,1.7136673,-0.61132114,-0.73371925,-0.14098057,1.7124963,-0.61132114,-0.7347513,-0.14201262,1.7145009,-0.61133106,-0.73371925,-0.14406682,1.713052,-0.61133106,-0.7347513,-0.14714314,1.7130818,-0.61134099,-0.7347513,-0.14612101,1.7137268,-0.61134099,-0.73371925,-0.14919734,1.7128536,-0.61135091,-0.7347513,-0.15125153,1.7136871,-0.61136083,-0.73371925,-0.15228359,1.7118414,-0.61136083,-0.73371925,-0.15433778,1.7117123,-0.61137076,-0.7347513,-0.15433778,1.7127444,-0.61137076,-0.73371925,-0.15741411,1.707078,-0.61138068,-0.73371925,-0.1594683,1.7095986,-0.61139061,-0.7347513,-0.16050036,1.7108391,-0.61140053,-0.7347513,-0.16050036,1.7094696,-0.61140053,-0.73577344,-0.16153241,1.7154933,-0.61140053,-0.73577344,-0.16153241,1.7149177,-0.61140053,-0.73577344,-0.16358661,1.7133299,-0.61141045,-0.7347513,-0.16460874,1.7110375,-0.61142038,-0.7347513,-0.1656408,1.7106207,-0.61142038,-0.7347513,-0.16666293,1.712407,-0.6114303,-0.73577344,-0.16769499,1.7120795,-0.6114303,-0.73577344,-0.16871712,1.7149375,-0.6114303,-0.73577344,-0.17077132,1.7144017,-0.61144022,-0.7368055,-0.16974918,1.7158703,-0.6114303,-0.73577344,-0.17282551,1.7127047,-0.61145015,-0.73577344,-0.17180337,1.7130024,-0.61144022,-0.73577344,-0.17385757,1.7126154,-0.61145015,-0.73577344,-0.1748797,1.7143421,-0.61146007,-0.73577344,-0.17591176,1.7143818,-0.61146007,-0.73577344,-0.17796595,1.7157413,-0.61146999,-0.61353411,-0.61353411,1.7149772,-0.61353411,-0.61353411,-0.61353411,1.7156223,-0.61353411,-0.61353411,-0.61353411,1.7172795,-0.61353411,-0.61353411,-0.61353411,1.7178848,-0.61353411,-0.61353411,-0.61353411,1.7158406,-0.61353411,-0.61353411,-0.61353411,1.719165,-0.61353411,-0.61353411,-0.61353411,1.7192642,-0.61353411,-0.61353411,-0.61353411,1.7209711,-0.61353411,-0.61353411,-0.61353411,1.7230154,-0.61353411,-0.61353411,-0.61353411,1.7189864,-0.61353411,-0.61353411,-0.61353411,1.7191154,-0.61353411,-0.61353411,-0.61353411,1.7156024,-0.61353411,-0.61353411,-0.61353411,1.7157711,-0.61353411,-0.61353411,-0.61353411,1.7181528,-0.61353411,-0.61353411,-0.61353411,1.713965,-0.61353411,-0.61353411,-0.61353411,1.7130123,-0.61353411,-0.61353411,-0.61353411,1.7139849,-0.61353411,-0.61353411,-0.61353411,1.7133299,-0.61353411,-0.61353411,-0.61353411,1.712407,-0.61353411,-0.61353411,-0.61353411,1.7118711,-0.61353411,-0.61353411,-0.61353411,1.7107398,-0.61353411,-0.61353411,-0.61353411,1.7133398,-0.61353411,-0.61353411,-0.61353411,1.7137169,-0.61353411,-0.61353411,-0.61353411,1.7124963,-0.61353411,-0.61353411,-0.61353411,1.7151459,-0.61353411,-0.61353411,-0.61353411,1.7147787,-0.61353411,-0.61353411,-0.61353411,1.7158406,-0.61353411,-0.61353411,-0.61353411,1.7156322,-0.61353411,-0.61353411,-0.61353411,1.7150169,-0.61353411,-0.61353411,-0.61353411,1.7155032,-0.61353411,-0.61353411,-0.61353411,1.7190062,-0.61353411,-0.61353411,-0.61353411,1.7177062,-0.61353411,-0.61353411,-0.61353411,1.7189764,-0.61353411,-0.61353411,-0.61353411,1.7203062,-0.61353411,-0.61353411,-0.61353411,1.7167932,-0.61353411,-0.61353411,-0.61353411,1.718123,-0.61353411,-0.61353411,-0.61353411,1.7153642,-0.61353411,-0.61353411,-0.61353411,1.7158703,-0.61353411,-0.61353411,-0.61353411,1.717478,-0.61353411,-0.61353411,-0.61353411,1.7185993,-0.61353411,-0.61353411,-0.61353411,1.7177161,-0.61353411,-0.61353411,-0.61353411,1.7189368,-0.61353411,-0.61353411,-0.61353411,1.7176368,-0.61353411,-0.61353411,-0.61353411,1.718381,-0.61353411,-0.61353411,-0.61353411,1.7194925,-0.61353411,-0.61353411,-0.61353411,1.7220032,-0.61353411,-0.61353411,-0.61353411,1.7188971,-0.61353411,-0.61353411,-0.61353411,1.7184207,-0.61353411,-0.61353411,-0.61353411,1.7197108,-0.61353411,-0.61353411,-0.61353411,1.7169024,-0.61353411,-0.61353411,-0.61353411,1.7163963,-0.61353411,-0.61353411,-0.61353411,1.7183314,-0.61353411,-0.61353411,-0.61353411,1.7188971,-0.61353411,-0.61353411,-0.61353411,1.718778,-0.61353411,-0.61353411,-0.61353411,1.7171108,-0.61353411,-0.61353411,-0.61353411,1.7174482,-0.61353411,-0.61353411,-0.61353411,1.7173093,-0.61353411,-0.61353411,-0.61353411,1.7154436,-0.61353411,-0.61353411,-0.61353411,1.7150864,-0.61353411,-0.61353411,-0.61353411,1.7131513,-0.61353411,-0.61353411,-0.61353411,1.7132704,-0.61353411,-0.61353411,-0.61353411,1.7127742,-0.61353411,-0.61353411,-0.61353411,1.7122482,-0.61353411,-0.61353411,-0.61353411,1.7120101,-0.61353411,-0.61353411,-0.61353411,1.713191,-0.61353411,-0.61353411,-0.61353411,1.711365,-0.61353411,-0.61353411,-0.61353411,1.7111467,-0.61353411,-0.61353411,-0.61353411,1.710591,-0.61353411,-0.61353411,-0.61353411,1.7122681,-0.61353411,-0.61353411,-0.61353411,1.7099658,-0.61353411,-0.61353411,-0.61353411,1.7127246,-0.61353411,-0.61353411,-0.61353411,1.713707,-0.61353411,-0.61353411,-0.61353411,1.7177658,-0.61353411,-0.61353411,-0.61353411,1.719165,-0.61353411,-0.61353411,-0.61353411,1.7185795,-0.61353411,-0.61353411,-0.61353411,1.71332,-0.61353411,-0.61353411,-0.61353411,1.7130818,-0.61353411,-0.61353411,-0.61353411,1.7174681,-0.61353411,-0.61353411,-0.61353411,1.718123,-0.61353411,-0.61353411,-0.61353411,1.7168131,-0.61353411,-0.61353411,-0.61353411,1.7180635,-0.61353411,-0.61353411,-0.61353411,1.7190856,-0.61353411,-0.61353411,-0.61353411,1.7147291,-0.61353411,-0.39575003,1.309567,1.7100154,-0.59913492,-0.73166505,-0.087561643,1.7147093,-0.61112267,-0.73166505,-0.094756278,1.7139154,-0.61114251,-0.73166505,-0.091670028,1.7155627,-0.61113259,-0.73166505,-0.094756278,1.712933,-0.61114251,-0.73269711,-0.10297305,1.7128337,-0.61117229,-0.73269711,-0.10708143,1.7125658,-0.61119213,-0.73269711,-0.11222187,1.7151261,-0.61121198,-0.73371925,-0.11735239,1.7142131,-0.61123183,-0.73371925,-0.11940659,1.7141536,-0.61123183,-0.73371925,-0.12454703,1.7102139,-0.6112616,-0.73371925,-0.12660122,1.7139551,-0.6112616,-0.73371925,-0.12967755,1.7117917,-0.61128145,-0.73371925,-0.1327638,1.710978,-0.61129137,-0.7347513,-0.13790424,1.7126551,-0.61131122,-0.7347513,-0.13892637,1.7131215,-0.61131122,-0.73371925,-0.14201262,1.7120498,-0.61133106,-0.73371925,-0.14303476,1.712407,-0.61133106,-0.73371925,-0.14508895,1.7116528,-0.61134099,-0.73371925,-0.14508895,1.7079314,-0.61133106,-0.73371925,-0.1481752,1.7084177,-0.61134099,-0.7347513,-0.14919734,1.7099559,-0.61136083,-0.7347513,-0.15125153,1.7075543,-0.61136083,-0.7347513,-0.15433778,1.7063734,-0.61138068,-0.7347513,-0.15535991,1.7069986,-0.61138068,-0.7347513,-0.15433778,1.7089734,-0.61137076,-0.7347513,-0.15844616,1.7100353,-0.61139061,-0.7347513,-0.15741411,1.7097177,-0.61139061,-0.7347513,-0.16050036,1.7092215,-0.61139061,-0.7347513,-0.1594683,1.7099459,-0.61139061,-0.7347513,-0.16255455,1.7078322,-0.61140053,-0.7347513,-0.16358661,1.7103627,-0.61140053,-0.7347513,-0.16460874,1.7092811,-0.61141045,-0.7347513,-0.1656408,1.7120894,-0.61141045,-0.73577344,-0.1656408,1.7134986,-0.61142038,-0.73577344,-0.16666293,1.7149673,-0.61142038,-0.73577344,-0.16769499,1.7132704,-0.61142038,-0.73577344,-0.16974918,1.7135581,-0.6114303,-0.73577344,-0.16974918,1.7140742,-0.6114303,-0.73577344,-0.17180337,1.7132505,-0.61144022,-0.73577344,-0.17180337,1.7132604,-0.61144022,-0.73577344,-0.17385757,1.7150864,-0.61145015,-0.7368055,-0.1748797,1.7146696,-0.61145015,-0.7368055,-0.1748797,1.7154635,-0.61145015,-0.73577344,-0.17591176,1.7149177,-0.61146007,-0.61353411,-0.61353411,1.7136574,-0.61353411,-0.61353411,-0.61353411,1.7153642,-0.61353411,-0.61353411,-0.61353411,1.7150368,-0.61353411,-0.61353411,-0.61353411,1.7138856,-0.61353411,-0.61353411,-0.61353411,1.7124467,-0.61353411,-0.61353411,-0.61353411,1.7113948,-0.61353411,-0.61353411,-0.61353411,1.7085666,-0.61353411,-0.61353411,-0.61353411,1.7105314,-0.61353411,-0.61353411,-0.61353411,1.709807,-0.61353411,-0.61353411,-0.61353411,1.7110971,-0.61353411,-0.61353411,-0.61353411,1.7099856,-0.61353411,-0.61353411,-0.61353411,1.7083185,-0.61353411,-0.61353411,-0.61353411,1.7091322,-0.61353411,-0.61353411,-0.61353411,1.7069292,-0.61353411,-0.61353411,-0.61353411,1.7073261,-0.61353411,-0.61353411,-0.61353411,1.7071376,-0.61353411,-0.61353411,-0.61353411,1.7040315,-0.61353411,-0.61353411,-0.61353411,1.7081101,-0.61353411,-0.61353411,-0.61353411,1.7063238,-0.61353411,-0.61353411,-0.61353411,1.7022055,-0.61353411,-0.61353411,-0.61353411,1.7031086,-0.61353411,-0.61353411,-0.61353411,1.7035253,-0.61353411,-0.61353411,-0.61353411,1.705778,-0.61353411,-0.61353411,-0.61353411,1.7063635,-0.61353411,-0.61353411,-0.61353411,1.7068299,-0.61353411,-0.61353411,-0.61353411,1.710323,-0.61353411,-0.61353411,-0.61353411,1.7119505,-0.61353411,-0.61353411,-0.61353411,1.7098666,-0.61353411,-0.61353411,-0.61353411,1.7117223,-0.61353411,-0.61353411,-0.61353411,1.7100353,-0.61353411,-0.61353411,-0.61353411,1.7075841,-0.61353411,-0.61353411,-0.61353411,1.7116826,-0.61353411,-0.61353411,-0.61353411,1.7097078,-0.61353411,-0.61353411,-0.61353411,1.7172597,-0.61353411,-0.61353411,-0.61353411,1.7145009,-0.61353411,-0.61353411,-0.61353411,1.7138856,-0.61353411,-0.61353411,-0.61353411,1.7138856,-0.61353411,-0.61353411,-0.61353411,1.7138856,-0.61353411,-0.61353411,-0.61353411,1.7138856,-0.61353411,-0.61353411,-0.61353411,1.7138856,-0.61353411,-0.61353411,-0.61353411,1.7138856,-0.61353411,-0.61353411,-0.61353411,1.7138856,-0.61353411:0
-0.55705001,-0.57544984,1.7348829,-0.60010769,-0.55596889,-0.57436872,1.7373778,-0.60009729,-0.55596889,-0.57436872,1.7407875,-0.60010769,-0.55705001,-0.57436872,1.7330637,-0.60010769,-0.55705001,-0.57436872,1.7334795,-0.60010769,-0.55596889,-0.57436872,1.7365566,-0.60009729,-0.55596889,-0.57544984,1.7363071,-0.60010769,-0.55705001,-0.57436872,1.7351844,-0.60010769,-0.55596889,-0.57436872,1.7392594,-0.60010769,-0.55705001,-0.57436872,1.7345606,-0.60010769,-0.55705001,-0.57544984,1.7305272,-0.60010769,-0.55705001,-0.57544984,1.7257869,-0.60010769,-0.55705001,-0.57544984,1.7264938,-0.60010769,-0.55705001,-0.57544984,1.7277932,-0.60010769,-0.55705001,-0.57544984,1.7262339,-0.60010769,-0.55705001,-0.57544984,1.7281467,-0.60010769,-0.55813113,-0.57544984,1.7209219,-0.60010769,-0.55705001,-0.57436872,1.7285521,-0.60010769,-0.55705001,-0.57436872,1.7273358,-0.60010769,-0.55596889,-0.57436872,1.7357457,-0.60009729,-0.55705001,-0.57436872,1.7340201,-0.60010769,-0.55596889,-0.57436872,1.7360888,-0.60009729,-0.55705001,-0.57436872,1.7376793,-0.60009729,-0.55705001,-0.57544984,1.7337082,-0.60010769,-0.55705001,-0.57436872,1.7378976,-0.60009729,-0.55705001,-0.57544984,1.7312237,-0.60010769,-0.55813113,-0.57544984,1.7226891,-0.60010769,-0.55813113,-0.57544984,1.7212338,-0.60010769,-0.55813113,-0.57544984,1.7165246,-0.60010769,-0.55813113,-0.57544984,1.7207452,-0.60010769,-0.55705001,-0.57544984,1.7266394,-0.60010769,-0.55705001,-0.57544984,1.7280012,-0.60010769,-0.55705001,-0.57544984,1.7308079,-0.60010769,-0.55705001,-0.57436872,1.7287912,-0.60010769,-0.55705001,-0.57544984,1.731941,-0.60010769,-0.55705001,-0.57544984,1.7278556,-0.60010769,-0.55705001,-0.57436872,1.7348101,-0.60010769,-0.55705001,-0.57436872,1.7340617,-0.60010769,-0.55596889,-0.57436872,1.7407355,-0.60010769,-0.55813113,-0.57544984,1.7198824,-0.60010769,-0.55705001,-0.57544984,1.7261924,-0.60010769,-0.55813113,-0.57544984,1.714456,-0.60010769,-0.55813113,-0.57544984,1.7200279,-0.60010769,-0.55813113,-0.57544984,1.7096949,-0.60010769,-0.55705001,-0.57544984,1.7237806,-0.60010769,-0.55813113,-0.57544984,1.7196848,-0.60010769,-0.55705001,-0.57544984,1.7239885,-0.60010769,-0.55813113,-0.57544984,1.7153396,-0.60010769,-0.55705001,-0.57544984,1.7217951,-0.60010769,-0.55813113,-0.57544984,1.7130318,-0.60010769,-0.55705001,-0.57544984,1.7223461,-0.60010769,-0.55813113,-0.57544984,1.7156618,-0.60010769,-0.55813113,-0.57544984,1.7197888,-0.60010769,-0.55813113,-0.57544984,1.7123977,-0.60010769,-0.55813113,-0.57544984,1.7182503,-0.60010769,-0.55705001,-0.57544984,1.7211818,-0.60010769,-0.55705001,-0.57544984,1.7287808,-0.60010769,-0.55705001,-0.57544984,1.7270864,-0.60010769,-0.55705001,-0.57436872,1.7315148,-0.60010769,-0.55596889,-0.57544984,1.7359432,-0.60010769,-0.55705001,-0.57436872,1.7362031,-0.60010769,-0.55705001,-0.57544984,1.7307663,-0.60010769,-0.55705001,-0.57544984,1.729259,-0.60010769,-0.55705001,-0.57544984,1.7308807,-0.60010769,-0.55705001,-0.57436872,1.7334171,-0.60010769,-0.55596889,-0.57436872,1.7363902,-0.60009729,-0.55596889,-0.57436872,1.7374817,-0.60009729,-0.55596889,-0.57436872,1.7429081,-0.60010769,-0.55596889,-0.57436872,1.7442387,-0.60010769,-0.55596889,-0.57436872,1.738646,-0.60010769,-0.55596889,-0.57436872,1.7358601,-0.60009729,-0.55596889,-0.57436872,1.7433655,-0.60010769,-0.55596889,-0.57436872,1.7415879,-0.60010769,-0.55705001,-0.57436872,1.7337082,-0.60010769,-0.55596889,-0.57436872,1.7350284,-0.60009729,-0.55705001,-0.57544984,1.7301426,-0.60010769,-0.55705001,-0.57544984,1.7283338,-0.60010769,-0.55705001,-0.57544984,1.7268681,-0.60010769,-0.55705001,-0.57544984,1.7268161,-0.60010769,-0.55705001,-0.57436872,1.7295501,-0.60010769,-0.55705001,-0.57544984,1.7299243,-0.60010769,-0.55705001,-0.57436872,1.7327207,-0.60010769,-0.55705001,-0.57544984,1.7345191,-0.60010769,-0.55596889,-0.57436872,1.7362863,-0.60009729,-0.55596889,-0.57544984,1.7352675,-0.60010769,-0.55596889,-0.57436872,1.7348413,-0.60009729,-0.55705001,-0.57436872,1.7309326,-0.60010769,-0.55705001,-0.57544984,1.726182,-0.60010769,-0.55596889,-0.57436872,1.7380223,-0.60009729,-0.55596889,-0.57436872,1.7384693,-0.60009729,-0.55705001,-0.57436872,1.7366293,-0.60010769,-0.55596889,-0.57436872,1.7384277,-0.60009729,-0.55596889,-0.57436872,1.7416191,-0.60010769,-0.55705001,-0.57436872,1.7343423,-0.60010769,-0.55596889,-0.57436872,1.7385421,-0.60010769,-0.55596889,-0.57436872,1.7371075,-0.60009729,-0.55596889,-0.57436872,1.7377832,-0.60009729,-0.55596889,-0.57436872,1.7423156,-0.60010769,-0.55596889,-0.57436872,1.744457,-0.60010769,-0.55596889,-0.57436872,1.7457877,-0.60010769,-0.55596889,-0.57436872,1.7457253,-0.60010769,-0.55596889,-0.57436872,1.7442699,-0.60010769,-0.55596889,-0.57436872,1.7373258,-0.60009729,-0.55705001,-0.57544984,1.7351948,-0.60010769,-0.55596889,-0.57436872,1.7367645,-0.60009729,-0.55705001,-0.57436872,1.7351012,-0.60010769,-0.55596889,-0.57436872,1.7384277,-0.60009729,-0.55596889,-0.57436872,1.7426586,-0.60010769,-0.55596889,-0.57436872,1.743719,-0.60010769,-0.55705001,-0.57544984,1.7326895,-0.60010769,-0.55705001,-0.57436872,1.7330013,-0.60010769,-0.55596889,-0.57436872,1.7385837,-0.60009729,-0.55596889,-0.57436872,1.7428146,-0.60010769,-0.55596889,-0.57436872,1.7396024,-0.60010769,-0.55596889,-0.57436872,1.7380535,-0.60009729,-0.55596889,-0.57436872,1.7407459,-0.60010769,-0.55596889,-0.57436872,1.7415255,-0.60010769,-0.55596889,-0.57436872,1.7399454,-0.60010769,-0.55596889,-0.57436872,1.7379495,-0.60009729,-0.55596889,-0.57436872,1.7350596,-0.60009729,-0.55705001,-0.57544984,1.7302362,-0.60010769,-0.55705001,-0.57436872,1.7318267,-0.60010769,-0.55705001,-0.57544984,1.7286561,-0.60010769,-0.55705001,-0.57436872,1.7320138,-0.60010769,-0.55596889,-0.57436872,1.7366189,-0.60009729,-0.55596889,-0.57436872,1.7388124,-0.60010769,-0.55596889,-0.57436872,1.740143,-0.60010769,-0.55596889,-0.57436872,1.7378872,-0.60009729,-0.55596889,-0.57436872,1.7404756,-0.60010769,-0.55596889,-0.57436872,1.7389787,-0.60010769,-0.55596889,-0.57436872,1.7408395,-0.60010769,-0.55596889,-0.57436872,1.7467128,-0.60010769,-0.55596889,-0.57436872,1.7413384,-0.60010769,-0.55596889,-0.57436872,1.7433136,-0.60010769,-0.55596889,-0.57436872,1.7481162,-0.60010769,-0.55596889,-0.57436872,1.747243,-0.60010769,-0.55596889,-0.57436872,1.7435319,-0.60010769,-0.55596889,-0.57436872,1.7426482,-0.60010769,-0.55596889,-0.57436872,1.744457,-0.60010769,-0.55488777,-0.57436872,1.7477732,-0.60009729,-0.55488777,-0.57436872,1.7493221,-0.60009729,-0.55596889,-0.57436872,1.745351,-0.60010769,-0.55596889,-0.57436872,1.7409018,-0.60010769,-0.55596889,-0.57436872,1.744904,-0.60010769,-0.55596889,-0.57436872,1.7445194,-0.60010769,-0.55596889,-0.57436872,1.7403717,-0.60010769,-0.55705001,-0.57436872,1.7329494,-0.60010769,-0.55705001,-0.57436872,1.7331365,-0.60010769,-0.55705001,-0.57436872,1.7344775,-0.60010769,-0.55596889,-0.57436872,1.7374817,-0.60009729,-0.55596889,-0.57436872,1.7412449,-0.60010769,-0.55596889,-0.57436872,1.7390514,-0.60010769,-0.55596889,-0.57436872,1.7407147,-0.60010769,-0.55596889,-0.57436872,1.7425651,-0.60010769,-0.55596889,-0.57436872,1.7406835,-0.60010769,-0.55596889,-0.57436872,1.7423052,-0.60010769,-0.55596889,-0.57436872,1.7447169,-0.60010769,-0.55596889,-0.57436872,1.74401,-0.60010769,-0.55596889,-0.57436872,1.7440724,-0.60010769,-0.55488777,-0.57436872,1.752711,-0.60009729,-0.55488777,-0.57436872,1.7509438,-0.60009729,-0.55488777,-0.57436872,1.7523783,-0.60009729,-0.55596889,-0.57436872,1.7493845,-0.60010769,-0.55488777,-0.57436872,1.7548108,-0.60009729,-0.55488777,-0.57436872,1.756734,-0.60009729,-0.55488777,-0.57436872,1.7534698,-0.60009729,-0.55488777,-0.57436872,1.7540416,-0.60009729,-0.55488777,-0.57436872,1.7557672,-0.60009729,-0.55488777,-0.57436872,1.7546653,-0.60009729,-0.55488777,-0.57436872,1.7541455,-0.60009729,-0.55488777,-0.57436872,1.7500082,-0.60009729,-0.55488777,-0.57436872,1.748584,-0.60009729,-0.55596889,-0.57436872,1.7478979,-0.60010769,-0.55596889,-0.57436872,1.7468688,-0.60010769,-0.55596889,-0.57436872,1.7460475,-0.60010769,-0.55596889,-0.57436872,1.7477524,-0.60010769,-0.55596889,-0.57436872,1.7435734,-0.60010769,-0.55596889,-0.57436872,1.7491246,-0.60010769,-0.55596889,-0.57436872,1.7481474,-0.60010769,-0.55488777,-0.57436872,1.7496443,-0.60009729,-0.55488777,-0.57436872,1.7501329,-0.60009729,-0.55705001,-0.57436872,1.7348517,-0.60010769,-0.55596889,-0.57436872,1.7380327,-0.60009729,-0.55596889,-0.57436872,1.7430537,-0.60010769,-0.55596889,-0.57436872,1.7435319,-0.60010769,-0.55596889,-0.57436872,1.7396336,-0.60010769,-0.55596889,-0.57436872,1.7458084,-0.60010769,-0.55596889,-0.57436872,1.7461515,-0.60010769,-0.55596889,-0.57436872,1.7443843,-0.60010769,-0.55596889,-0.57436872,1.7432408,-0.60010769,-0.55596889,-0.57436872,1.7428977,-0.60010769,-0.55596889,-0.57436872,1.7452263,-0.60010769,-0.55596889,-0.57436872,1.7481994,-0.60010769,-0.55488777,-0.57436872,1.7494884,-0.60009729,-0.55596889,-0.57436872,1.745954,-0.60010769,-0.55488777,-0.57436872,1.7566924,-0.60009729,-0.55488777,-0.57436872,1.7547277,-0.60009729,-0.55488777,-0.57436872,1.7546549,-0.60009729,-0.55488777,-0.57436872,1.7551955,-0.60009729,-0.55488777,-0.57436872,1.7567132,-0.60009729,-0.55488777,-0.57436872,1.7539065,-0.60009729,-0.55488777,-0.57436872,1.7567028,-0.60009729,-0.55488777,-0.57436872,1.7578983,-0.60009729,-0.55488777,-0.57436872,1.7586675,-0.60009729,-0.55488777,-0.57436872,1.7591041,-0.60009729,-0.55488777,-0.57436872,1.7525447,-0.60009729,-0.55488777,-0.57436872,1.7534075,-0.60009729,-0.55488777,-0.57436872,1.7560687,-0.60009729,-0.55488777,-0.57436872,1.7525343,-0.60009729,-0.55488777,-0.57436872,1.7494988,-0.60009729,-0.55488777,-0.57436872,1.7493845,-0.60009729,-0.55488777,-0.57436872,1.7527318,-0.60009729,-0.55488777,-0.57436872,1.7513388,-0.60009729,-0.55488777,-0.57436872,1.7511829,-0.60009729,-0.55488777,-0.57436872,1.7520457,-0.60009729,-0.55488777,-0.57436872,1.7491869,-0.60009729,-0.55596889,-0.57436872,1.7450288,-0.60010769,-0.55596889,-0.57436872,1.7401014,-0.60010769,-0.55596889,-0.57436872,1.7415671,-0.60010769,-0.55596889,-0.57436872,1.742825,-0.60010769,-0.55596889,-0.57436872,1.7391866,-0.60010769,-0.55596889,-0.57436872,1.7399766,-0.60010769,-0.55596889,-0.57436872,1.7429809,-0.60010769,-0.55596889,-0.57436872,1.7465361,-0.60010769,-0.55596889,-0.57436872,1.7447897,-0.60010769,-0.55596889,-0.57436872,1.7438541,-0.60010769,-0.55705001,-0.57436872,1.7366085,-0.60009729,-0.55596889,-0.57436872,1.7400598,-0.60010769,-0.55596889,-0.57436872,1.738251,-0.60009729,-0.55813113,-0.57436872,1.7324296,-0.60010769,-0.55921225,-0.57544984,1.6983639,-0.60011809,-0.55813113,-0.57544984,1.7114933,-0.60010769,-0.55813113,-0.57544984,1.7099444,-0.60010769,-0.55813113,-0.57544984,1.7099652,-0.60010769,-0.55813113,-0.57544984,1.7161296,-0.60010769,-0.55813113,-0.57544984,1.7201734,-0.60010769,-0.55813113,-0.57544984,1.7182711,-0.60010769,-0.55813113,-0.57544984,1.7197992,-0.60010769,-0.55813113,-0.57544984,1.7200175,-0.60010769,-0.55705001,-0.57544984,1.7224396,-0.60010769,-0.55813113,-0.57544984,1.7192794,-0.60010769,-0.55813113,-0.57544984,1.7200799,-0.60010769,-0.55813113,-0.57544984,1.7149238,-0.60010769,-0.55813113,-0.57544984,1.7201318,-0.60010769,-0.55813113,-0.57544984,1.7185933,-0.60010769,-0.55813113,-0.57544984,1.7168365,-0.60010769,-0.55813113,-0.57544984,1.7153812,-0.60010769,-0.55705001,-0.57544984,1.7228866,-0.60010769,-0.55705001,-0.57544984,1.7254543,-0.60010769,-0.55813113,-0.57544984,1.7183542,-0.60010769,-0.55813113,-0.57544984,1.7151629,-0.60010769,-0.55813113,-0.57544984,1.711774,-0.60010769,-0.55813113,-0.57544984,1.7160776,-0.60010769,-0.55921225,-0.57544984,1.7079381,-0.60011809,-0.55813113,-0.57544984,1.7125744,-0.60010769,-0.55813113,-0.57544984,1.712221,-0.60010769,-0.55813113,-0.57544984,1.7121378,-0.60010769,-0.55921225,-0.57544984,1.7070441,-0.60011809,-0.55921225,-0.57544984,1.705017,-0.60011809,-0.55921225,-0.57544984,1.7074079,-0.60011809,-0.55813113,-0.57977432,1.7116908,-0.60011809,-0.55813113,-0.54948216,1.7150693,-0.60003492,-0.55813113,-0.55705001,1.7171796,-0.60005571,-0.55813113,-0.55596889,1.7162232,-0.60005571,-0.55813113,-0.55813113,1.7112334,-0.60006611,-0.55813113,-0.55705001,1.7138322,-0.60005571,-0.55813113,-0.55705001,1.7182087,-0.60005571,-0.55813113,-0.55705001,1.7240613,-0.60005571,-0.55705001,-0.55705001,1.7245083,-0.60005571,-0.55813113,-0.55705001,1.7226891,-0.60005571,-0.55813113,-0.55596889,1.7216808,-0.60005571,-0.55813113,-0.55705001,1.7216808,-0.60005571,-0.55813113,-0.55813113,1.7202046,-0.60006611,-0.55813113,-0.55488777,1.7186141,-0.60005571,-0.55921225,-0.55596889,1.7111087,-0.60005571,-0.55813113,-0.55380664,1.7185829,-0.60004532,-0.55921225,-0.55596889,1.7064307,-0.60005571,-0.55921225,-0.55380664,1.7102978,-0.60005571,-0.55813113,-0.55813113,1.7200071,-0.60006611,-0.55813113,-0.55705001,1.719716,-0.60005571,-0.55813113,-0.55705001,1.7191339,-0.60005571,-0.55813113,-0.55813113,1.7212649,-0.60006611,-0.55813113,-0.55488777,1.7217015,-0.60005571,-0.55813113,-0.55596889,1.722845,-0.60005571,-0.55813113,-0.55380664,1.7210051,-0.60004532,-0.55813113,-0.55596889,1.7227619,-0.60005571,-0.55813113,-0.55380664,1.7187597,-0.60004532,-0.55813113,-0.51377402,1.7225436,-0.59989978,-0.55813113,-0.51485514,1.723344,-0.59989978,-0.55813113,-0.51161178,1.7133125,-0.59988939,-0.55813113,-0.57977432,1.7123977,-0.60011809,-0.55921225,-0.57977432,1.7069089,-0.60012848,-0.55813113,-0.57977432,1.716982,-0.60011809,-0.55813113,-0.57977432,1.7099859,-0.60011809,-0.55813113,-0.57977432,1.7174498,-0.60011809,-0.55813113,-0.57977432,1.7169509,-0.60011809,-0.55813113,-0.57977432,1.7182191,-0.60011809,-0.55813113,-0.58085544,1.7122833,-0.60011809,-0.55813113,-0.57977432,1.7109111,-0.60011809,-0.55813113,-0.57977432,1.7138011,-0.60011809,-0.55813113,-0.57977432,1.7140298,-0.60011809,-0.55813113,-0.57977432,1.712616,-0.60011809,-0.55813113,-0.57977432,1.7128551,-0.60011809,-0.55813113,-0.57977432,1.7196641,-0.60011809,-0.55813113,-0.57977432,1.7168469,-0.60011809,-0.55813113,-0.57977432,1.7150901,-0.60011809,-0.55813113,-0.57977432,1.7128863,-0.60011809,-0.55813113,-0.58626104,1.7201111,-0.60012848,-0.55813113,-0.58735255,1.7196744,-0.60013888,-0.55813113,-0.58735255,1.7128031,-0.60012848,-0.55705001,-0.58626104,1.723843,-0.60012848,-0.55813113,-0.58735255,1.7166286,-0.60012848,-0.55813113,-0.58626104,1.7215976,-0.60012848,-0.55705001,-0.58626104,1.724342,-0.60012848,-0.55705001,-0.58626104,1.7201318,-0.60012848,-0.55705001,-0.58735255,1.7223565,-0.60012848,-0.55705001,-0.58735255,1.7224604,-0.60012848,-0.55705001,-0.58626104,1.7244667,-0.60012848,-0.55705001,-0.58626104,1.7237806,-0.60012848,-0.55705001,-0.58735255,1.7217951,-0.60012848,-0.55705001,-0.58626104,1.7230218,-0.60012848,-0.55705001,-0.58626104,1.7207868,-0.60012848,-0.55705001,-0.58626104,1.7243732,-0.60012848,-0.55705001,-0.58626104,1.7229282,-0.60012848,-0.55705001,-0.58626104,1.7237183,-0.60012848,-0.55813113,-0.58735255,1.717034,-0.60012848,-0.55705001,-0.58626104,1.7233752,-0.60012848,-0.55705001,-0.58626104,1.7205996,-0.60012848,-0.55705001,-0.58626104,1.7259637,-0.60012848,-0.55705001,-0.58626104,1.725579,-0.60012848,-0.55705001,-0.58626104,1.7281987,-0.60012848,-0.55705001,-0.58626104,1.7285209,-0.60012848,-0.55705001,-0.58626104,1.7223876,-0.60012848,-0.55705001,-0.58626104,1.7267225,-0.60012848,-0.55705001,-0.58735255,1.723739,-0.60012848,-0.55705001,-0.58626104,1.7272007,-0.60012848,-0.55705001,-0.58626104,1.7284793,-0.60012848,-0.55705001,-0.58626104,1.7274086,-0.60012848,-0.55705001,-0.58626104,1.7253815,-0.60012848,-0.55705001,-0.58626104,1.7245707,-0.60012848,-0.55705001,-0.58626104,1.7242484,-0.60012848,-0.55705001,-0.58626104,1.7223876,-0.60012848,-0.55813113,-0.58735255,1.7190819,-0.60013888,-0.55813113,-0.58626104,1.7173771,-0.60012848,-0.55813113,-0.58735255,1.7189884,-0.60013888,-0.55813113,-0.58735255,1.7200071,-0.60013888,-0.55705001,-0.58735255,1.7209011,-0.60012848,-0.55813113,-0.58626104,1.7203501,-0.60012848,-0.55705001,-0.58626104,1.729259,-0.60012848,-0.55705001,-0.58626104,1.7283026,-0.60012848,-0.55705001,-0.58626104,1.7288744,-0.60012848,-0.55705001,-0.58626104,1.7299139,-0.60012848,-0.55705001,-0.58626104,1.7315356,-0.60012848,-0.55705001,-0.58626104,1.7331988,-0.60012848,-0.55705001,-0.58626104,1.7330013,-0.60012848,-0.55705001,-0.58626104,1.7291758,-0.60012848,-0.55705001,-0.58626104,1.7324712,-0.60012848,-0.55705001,-0.58626104,1.7347374,-0.60012848,-0.55596889,-0.57977432,1.735912,-0.60011809,-0.55596889,-0.57977432,1.735912,-0.60011809,-0.55596889,-0.57977432,1.735912,-0.60011809,-0.55596889,-0.57977432,1.735912,-0.60011809,-0.55596889,-0.57977432,1.735912,-0.60011809,-0.55596889,-0.57977432,1.735912,-0.60011809,-0.55596889,-0.57977432,1.735912,-0.60011809:6
-0.61178351,-0.50973383,1.7267227,-0.60688362,-0.61279898,-0.5107493,1.729079,-0.60689348,-0.6138243,-0.50973383,1.7314846,-0.60689348,-0.61279898,-0.5107493,1.7273537,-0.60689348,-0.61279898,-0.5107493,1.7185891,-0.60688362,-0.61279898,-0.5107493,1.7200088,-0.60689348,-0.61279898,-0.5107493,1.7116977,-0.60688362,-0.61279898,-0.5107493,1.7108203,-0.60687377,-0.61279898,-0.5107493,1.7123977,-0.60688362,-0.61279898,-0.5107493,1.7145272,-0.60688362,-0.61279898,-0.50973383,1.7176919,-0.60688362,-0.61279898,-0.5107493,1.7225524,-0.60689348,-0.61279898,-0.5107493,1.7183328,-0.60688362,-0.61279898,-0.50973383,1.7187271,-0.60688362,-0.61178351,-0.5107493,1.7188356,-0.60688362,-0.61178351,-0.5107493,1.7111357,-0.60688362,-0.61279898,-0.5107493,1.720975,-0.60689348,-0.61279898,-0.5107493,1.713216,-0.60687377,-0.61279898,-0.5107493,1.7138667,-0.60689348,-0.61279898,-0.5107493,1.7117569,-0.60688362,-0.61178351,-0.5107493,1.7067485,-0.60687377,-0.61279898,-0.5107493,1.7064725,-0.60688362,-0.61279898,-0.5107493,1.7047373,-0.60687377,-0.61279898,-0.5107493,1.7075668,-0.60688362,-0.61279898,-0.5107493,1.7111555,-0.60688362,-0.61279898,-0.5107493,1.7181652,-0.60688362,-0.61178351,-0.5107493,1.7171497,-0.60687377,-0.61279898,-0.5107493,1.7127723,-0.60688362,-0.61178351,-0.5107493,1.7064528,-0.60688362,-0.61279898,-0.5107493,1.714823,-0.60688362,-0.61279898,-0.5107493,1.7153849,-0.60688362,-0.61279898,-0.5107493,1.7179483,-0.60689348,-0.61279898,-0.5107493,1.7227003,-0.60689348,-0.61279898,-0.5107493,1.7139751,-0.60689348,-0.61279898,-0.5107493,1.7125259,-0.60688362,-0.61279898,-0.5107493,1.7159666,-0.60688362,-0.61279898,-0.5107493,1.7175342,-0.60687377,-0.61279898,-0.5107493,1.7227298,-0.60688362,-0.61279898,-0.5107493,1.7227101,-0.60688362,-0.61279898,-0.5107493,1.7274523,-0.60688362,-0.61279898,-0.5107493,1.7212411,-0.60688362,-0.61279898,-0.5107493,1.7200186,-0.60689348,-0.61279898,-0.5107493,1.7239326,-0.60688362,-0.61279898,-0.50973383,1.7202947,-0.60688362,-0.61279898,-0.5107493,1.7194172,-0.60688362,-0.61279898,-0.5107493,1.7227989,-0.60688362,-0.6138243,-0.5107493,1.7277677,-0.60689348,-0.61279898,-0.50973383,1.723627,-0.60689348,-0.6138243,-0.5107493,1.7221482,-0.60689348,-0.61279898,-0.5107493,1.7164004,-0.60687377,-0.61279898,-0.5107493,1.7180173,-0.60688362,-0.61279898,-0.5107493,1.7159469,-0.60688362,-0.61279898,-0.5107493,1.7226805,-0.60688362,-0.61178351,-0.5107493,1.725865,-0.60687377,-0.61279898,-0.5107493,1.7211524,-0.60688362,-0.61279898,-0.5107493,1.7235383,-0.60688362,-0.61279898,-0.5107493,1.723489,-0.60688362,-0.61279898,-0.5107493,1.7206792,-0.60688362,-0.61279898,-0.5107493,1.722789,-0.60688362,-0.61279898,-0.50973383,1.7261114,-0.60689348,-0.6158651,-0.50973383,1.7195947,-0.60687377,-0.61279898,-0.50973383,1.7214876,-0.60688362,-0.6138243,-0.5107493,1.7166074,-0.60689348,-0.6138243,-0.5107493,1.7170314,-0.60689348,-0.6138243,-0.5107493,1.7165187,-0.60688362,-0.61279898,-0.5107493,1.7165286,-0.60688362,-0.61279898,-0.5107493,1.718037,-0.60688362,-0.6138243,-0.5107493,1.7231341,-0.60689348,-0.6138243,-0.5107493,1.7228087,-0.60688362,-0.6138243,-0.5107493,1.7247805,-0.60688362,-0.61279898,-0.5107493,1.7255593,-0.60688362,-0.61279898,-0.5107493,1.7248002,-0.60688362,-0.61279898,-0.5107493,1.7231932,-0.60688362,-0.61279898,-0.5107493,1.7238833,-0.60688362,-0.6138243,-0.5107493,1.7233115,-0.60688362,-0.61279898,-0.5107493,1.7261706,-0.60688362,-0.61279898,-0.5107493,1.7247904,-0.60688362,-0.61279898,-0.50973383,1.7275706,-0.60687377,-0.61279898,-0.50973383,1.7309719,-0.60687377,-0.61279898,-0.50973383,1.7330324,-0.60689348,-0.61279898,-0.5107493,1.730548,-0.60689348,-0.61279898,-0.50973383,1.7334662,-0.60689348,-0.61279898,-0.5107493,1.730617,-0.60689348,-0.61279898,-0.5107493,1.729986,-0.60688362,-0.61279898,-0.5107493,1.7336732,-0.60689348,-0.61279898,-0.50973383,1.7354774,-0.60688362,-0.61279898,-0.50973383,1.737252,-0.60689348,-0.61279898,-0.50973383,1.7356549,-0.60689348,-0.6138243,-0.5107493,1.7340972,-0.60689348,-0.61279898,-0.50973383,1.7355662,-0.60688362,-0.61279898,-0.5107493,1.7293057,-0.60689348,-0.61279898,-0.50973383,1.7319676,-0.60688362,-0.61279898,-0.50973383,1.7334958,-0.60689348,-0.6138243,-0.50973383,1.7321451,-0.60689348,-0.61279898,-0.50973383,1.7329338,-0.60688362,-0.6138243,-0.50973383,1.7285663,-0.60689348,-0.61279898,-0.5107493,1.7255791,-0.60688362,-0.61279898,-0.5107493,1.7290001,-0.60688362,-0.61279898,-0.50973383,1.7282114,-0.60688362,-0.61279898,-0.50973383,1.7304789,-0.60688362,-0.61279898,-0.5107493,1.7242383,-0.60688362,-0.61279898,-0.5107493,1.7265452,-0.60688362,-0.6138243,-0.50973383,1.730755,-0.60689348,-0.61279898,-0.50973383,1.7307649,-0.60688362,-0.6138243,-0.5107493,1.7282015,-0.60689348,-0.61279898,-0.5107493,1.7277776,-0.60688362,-0.6138243,-0.50973383,1.7326282,-0.60689348,-0.61279898,-0.50973383,1.7292564,-0.60689348,-0.61279898,-0.5107493,1.729848,-0.60689348,-0.6138243,-0.50973383,1.7293353,-0.60689348,-0.6138243,-0.5107493,1.7299761,-0.60689348,-0.6138243,-0.50973383,1.733693,-0.60689348,-0.61279898,-0.50973383,1.7250861,-0.60688362,-0.61279898,-0.5107493,1.7256185,-0.60688362,-0.6138243,-0.5107493,1.7310902,-0.60689348,-0.61279898,-0.50973383,1.7305085,-0.60688362,-0.61279898,-0.5107493,1.7288522,-0.60689348,-0.61279898,-0.5107493,1.7284184,-0.60689348,-0.61279898,-0.5107493,1.7262495,-0.60688362,-0.61279898,-0.5107493,1.7206299,-0.60688362,-0.61279898,-0.50973383,1.7237749,-0.60688362,-0.61279898,-0.5107493,1.7273044,-0.60688362,-0.61279898,-0.5107493,1.725441,-0.60688362,-0.61279898,-0.5107493,1.7261312,-0.60688362,-0.61279898,-0.5107493,1.7310803,-0.60688362,-0.6138243,-0.5107493,1.7332592,-0.60688362,-0.6138243,-0.50973383,1.7337028,-0.60689348,-0.61279898,-0.5107493,1.7298776,-0.60689348,-0.61279898,-0.50973383,1.728941,-0.60689348,-0.61279898,-0.50973383,1.7319381,-0.60688362,-0.61279898,-0.5107493,1.7293452,-0.60689348,-0.61279898,-0.50973383,1.7333873,-0.60688362,-0.6138243,-0.50973383,1.7313564,-0.60688362,-0.61279898,-0.5107493,1.7296508,-0.60689348,-0.61279898,-0.5107493,1.7279452,-0.60689348,-0.61279898,-0.5107493,1.7284579,-0.60688362,-0.61279898,-0.50973383,1.728448,-0.60689348,-0.61279898,-0.5107493,1.7294339,-0.60688362,-0.6138243,-0.5107493,1.7335944,-0.60689348,-0.61279898,-0.5107493,1.7319972,-0.60688362,-0.61279898,-0.5107493,1.7322634,-0.60688362,-0.61178351,-0.5107493,1.7293649,-0.60687377,-0.61279898,-0.5107493,1.7334366,-0.60687377,-0.61178351,-0.50973383,1.7336239,-0.60686391,-0.61279898,-0.50973383,1.7325296,-0.60688362,-0.61279898,-0.50973383,1.7357338,-0.60688362,-0.61279898,-0.50973383,1.7370253,-0.60688362,-0.61279898,-0.50973383,1.7381689,-0.60688362,-0.61279898,-0.50973383,1.729217,-0.60689348,-0.61279898,-0.50973383,1.7308437,-0.60688362,-0.61279898,-0.5107493,1.7254016,-0.60688362,-0.61279898,-0.50973383,1.734107,-0.60689348,-0.61279898,-0.5107493,1.7344324,-0.60688362,-0.61279898,-0.50973383,1.7325493,-0.60688362,-0.61279898,-0.50973383,1.7361084,-0.60688362,-0.6138243,-0.5107493,1.7370253,-0.60689348,-0.6138243,-0.5107493,1.7355662,-0.60689348,-0.6138243,-0.5107493,1.7357042,-0.60689348,-0.6138243,-0.50973383,1.7342549,-0.60689348,-0.6138243,-0.5107493,1.7310508,-0.60689348,-0.6138243,-0.5107493,1.7304494,-0.60687377,-0.61279898,-0.5107493,1.7305381,-0.60687377,-0.61279898,-0.50973383,1.7311592,-0.60688362,-0.6138243,-0.50973383,1.731524,-0.60689348,-0.6138243,-0.50973383,1.7331211,-0.60689348,-0.6138243,-0.50973383,1.7311198,-0.60689348,-0.61483977,-0.5107493,1.7324606,-0.6069132,-0.6138243,-0.5107493,1.7337423,-0.60689348,-0.61483977,-0.50973383,1.7341859,-0.60690334,-0.6138243,-0.50973383,1.734531,-0.60690334,-0.6138243,-0.50973383,1.7366901,-0.60690334,-0.6138243,-0.50973383,1.7349549,-0.60690334,-0.61279898,-0.50973383,1.7377351,-0.60688362,-0.6138243,-0.5107493,1.7389971,-0.60689348,-0.6138243,-0.50973383,1.7400914,-0.60688362,-0.6138243,-0.5107493,1.7410083,-0.60689348,-0.6138243,-0.50973383,1.7423294,-0.60688362,-0.61483977,-0.50973383,1.7351521,-0.60690334,-0.6138243,-0.50973383,1.7323127,-0.60690334,-0.6138243,-0.50973383,1.7285367,-0.60689348,-0.6138243,-0.50973383,1.7287931,-0.60689348,-0.6138243,-0.5107493,1.7324606,-0.60689348,-0.6138243,-0.50973383,1.733131,-0.60690334,-0.6138243,-0.50973383,1.7334366,-0.60690334,-0.6138243,-0.5107493,1.7336141,-0.60690334,-0.6138243,-0.50973383,1.7362366,-0.60690334,-0.6138243,-0.5107493,1.7366901,-0.60690334,-0.6138243,-0.50973383,1.7350929,-0.60690334,-0.6138243,-0.5107493,1.7358028,-0.60690334,-0.61483977,-0.50973383,1.7352309,-0.6069132,-0.61483977,-0.50973383,1.7362563,-0.60690334,-0.61483977,-0.50973383,1.7352802,-0.60690334,-0.6138243,-0.5107493,1.7375577,-0.60690334,-0.6138243,-0.50973383,1.7386914,-0.60690334,-0.6138243,-0.50973383,1.7377943,-0.60690334,-0.6138243,-0.50973383,1.733762,-0.60689348,-0.61483977,-0.50973383,1.7301832,-0.60689348,-0.61483977,-0.50973383,1.7327169,-0.60689348,-0.6138243,-0.50973383,1.7397266,-0.60689348,-0.6138243,-0.50973383,1.7414716,-0.60690334,-0.6138243,-0.5107493,1.7380407,-0.60690334,-0.6138243,-0.50973383,1.740535,-0.60689348,-0.6138243,-0.50973383,1.7387703,-0.60690334,-0.6138243,-0.50973383,1.7389083,-0.60690334,-0.6138243,-0.5107493,1.7382281,-0.60690334,-0.6138243,-0.5107493,1.7390661,-0.60690334,-0.6138243,-0.50973383,1.7406632,-0.60689348,-0.61483977,-0.50973383,1.7400027,-0.6069132,-0.61483977,-0.50973383,1.740959,-0.6069132,-0.6138243,-0.5107493,1.7378041,-0.6069132,-0.6138243,-0.50973383,1.7428322,-0.6069132,-0.6138243,-0.50973383,1.739283,-0.60690334,-0.6138243,-0.50973383,1.7375577,-0.6069132,-0.6138243,-0.50973383,1.7313268,-0.60690334,-0.6138243,-0.5107493,1.7255002,-0.6069132,-0.6138243,-0.5107493,1.7356943,-0.6069132,-0.6138243,-0.50973383,1.7364535,-0.6069132,-0.6138243,-0.5107493,1.7376168,-0.6069132,-0.6138243,-0.5107493,1.7368971,-0.6069132,-0.61483977,-0.50973383,1.7397562,-0.60690334,-0.61483977,-0.50973383,1.734738,-0.6069132,-0.61483977,-0.50973383,1.7376365,-0.6069132,-0.6138243,-0.5107493,1.7343929,-0.60690334,-0.61483977,-0.50973383,1.7362661,-0.6069132,-0.61483977,-0.5107493,1.7359408,-0.6069132,-0.6138243,-0.50973383,1.7367985,-0.60689348,-0.6138243,-0.5107493,1.7367098,-0.6069132,-0.61483977,-0.50973383,1.7371041,-0.6069132,-0.6138243,-0.5107493,1.7291086,-0.6069132,-0.61483977,-0.50973383,1.7320662,-0.60690334,-0.61483977,-0.50973383,1.7298381,-0.6069132,-0.61483977,-0.50973383,1.7305578,-0.60690334,-0.61483977,-0.5107493,1.7244946,-0.6069132,-0.61483977,-0.5107493,1.7240411,-0.6069132,-0.6138243,-0.5107493,1.7223552,-0.60689348,-0.61483977,-0.5107493,1.7271565,-0.6069132,-0.61483977,-0.5107493,1.7254115,-0.6069132,-0.61483977,-0.50973383,1.7266143,-0.6069132,-0.61483977,-0.5107493,1.7251157,-0.60689348,-0.61483977,-0.5107493,1.7279058,-0.6069132,-0.61483977,-0.5107493,1.7236664,-0.60690334,-0.61483977,-0.5107493,1.7258847,-0.60690334,-0.61483977,-0.5107493,1.730686,-0.6069132,-0.6138243,-0.5107493,1.7294142,-0.60690334,-0.6138243,-0.50973383,1.7311691,-0.60690334,-0.6138243,-0.50973383,1.7323719,-0.60690334,-0.6138243,-0.50973383,1.7359901,-0.60689348,-0.6138243,-0.50973383,1.7358619,-0.60689348,-0.61279898,-0.50973383,1.7332986,-0.60688362,-0.61178351,-0.50973383,1.7280832,-0.60687377,-0.61279898,-0.50973383,1.7375872,-0.60689348,-0.61279898,-0.5107493,1.7333972,-0.60688362,-0.6138243,-0.50973383,1.7369365,-0.60690334,-0.6138243,-0.50973383,1.7372619,-0.60690334,-0.6138243,-0.50973383,1.7373999,-0.60689348,-0.6138243,-0.50973383,1.7399632,-0.60690334,-0.6138243,-0.5107493,1.7374098,-0.60690334,-0.6158651,-0.50973383,1.7355366,-0.60686391,-0.6158651,-0.50973383,1.7365422,-0.60687377,-0.6138243,-0.50973383,1.7378436,-0.60688362,-0.6138243,-0.5107493,1.7387703,-0.60689348,-0.61279898,-0.50973383,1.7392238,-0.60688362,-0.61279898,-0.50973383,1.7375675,-0.60688362,-0.61279898,-0.50973383,1.7424575,-0.60688362,-0.6138243,-0.50973383,1.7425857,-0.60688362,-0.6138243,-0.50973383,1.7429801,-0.60688362,-0.61279898,-0.50973383,1.739697,-0.60687377,-0.61279898,-0.50973383,1.7404759,-0.60687377,-0.61279898,-0.50973383,1.7351028,-0.60687377,-0.6138243,-0.50973383,1.7373605,-0.60688362,-0.6138243,-0.50973383,1.7381492,-0.60688362,-0.6138243,-0.50973383,1.7398548,-0.60688362,-0.6138243,-0.50973383,1.7336732,-0.60688362,-0.6138243,-0.50973383,1.7324507,-0.60689348,-0.61279898,-0.50973383,1.7273142,-0.60687377,-0.6138243,-0.5107493,1.7288325,-0.60688362,-0.61483977,-0.5107493,1.7296902,-0.60689348,-0.6138243,-0.50973383,1.7312184,-0.60689348,-0.61483977,-0.50973383,1.7294635,-0.60689348,-0.6138243,-0.50973383,1.7291776,-0.60688362,-0.61483977,-0.50973383,1.7360098,-0.60689348,-0.6138243,-0.50973383,1.7351225,-0.60688362,-0.6138243,-0.5107493,1.7350732,-0.60689348,-0.6138243,-0.50973383,1.7376069,-0.60689348,-0.6138243,-0.50973383,1.7410181,-0.60689348,-0.6138243,-0.50973383,1.739628,-0.60688362,-0.6138243,-0.50973383,1.7425463,-0.60689348,-0.6138243,-0.50973383,1.7416294,-0.60688362,-0.6138243,-0.50973383,1.736552,-0.60688362,-0.6138243,-0.50973383,1.7381393,-0.60689348,-0.6138243,-0.50973383,1.7382379,-0.60688362,-0.6138243,-0.50973383,1.7387506,-0.60689348,-0.61483977,-0.50973383,1.7430294,-0.60690334,-0.61483977,-0.50973383,1.7436603,-0.60690334,-0.61483977,-0.50973383,1.745011,-0.60689348,-0.6138243,-0.50973383,1.7412449,-0.60689348,-0.6138243,-0.50973383,1.7374985,-0.60689348,-0.6138243,-0.50973383,1.736976,-0.60689348,-0.6138243,-0.50973383,1.7385731,-0.60689348,-0.6138243,-0.50973383,1.7384647,-0.60688362,-0.61483977,-0.5107493,1.736552,-0.60688362,-0.6138243,-0.50973383,1.7379027,-0.60688362,-0.6138243,-0.50973383,1.7347479,-0.60688362,-0.61279898,-0.50973383,1.7357338,-0.60688362,-0.6138243,-0.5107493,1.7296705,-0.60688362,-0.6138243,-0.50973383,1.7382478,-0.60689348,-0.6138243,-0.50973383,1.7407224,-0.60689348,-0.61279898,-0.50973383,1.7389872,-0.60688362,-0.61279898,-0.50973383,1.7398548,-0.60687377,-0.61279898,-0.50973383,1.7377253,-0.60687377,-0.61279898,-0.5107493,1.7344915,-0.60687377,-0.6138243,-0.50973383,1.7367689,-0.60689348,-0.6138243,-0.50973383,1.7361971,-0.60688362,-0.6138243,-0.50973383,1.7369464,-0.60689348,-0.6138243,-0.50973383,1.7386619,-0.60689348,-0.61279898,-0.50973383,1.7365422,-0.60688362,-0.6138243,-0.50973383,1.736414,-0.60688362,-0.6138243,-0.5107493,1.734876,-0.60688362,-0.61279898,-0.50973383,1.7311198,-0.60688362,-0.6138243,-0.50973383,1.7366408,-0.60690334,-0.6138243,-0.50973383,1.731662,-0.60689348,-0.6138243,-0.50973383,1.7343634,-0.60689348,-0.6138243,-0.50973383,1.7397069,-0.60689348,-0.6138243,-0.50973383,1.7379027,-0.60689348,-0.6138243,-0.50973383,1.7394407,-0.60688362,-0.6138243,-0.5107493,1.7322141,-0.60689348,-0.61279898,-0.5107493,1.7364732,-0.60688362,-0.6138243,-0.5107493,1.7410379,-0.60689348,-0.61279898,-0.50973383,1.7409984,-0.60687377,-0.61279898,-0.50973383,1.7373309,-0.60688362,-0.6138243,-0.50973383,1.738928,-0.60688362,-0.6138243,-0.50973383,1.7425561,-0.60689348,-0.6138243,-0.50973383,1.7421913,-0.60690334,-0.6158651,-0.50973383,1.7369563,-0.60685405,-0.6138243,-0.50973383,1.7395787,-0.60688362,-0.6138243,-0.50973383,1.738021,-0.60689348,-0.6138243,-0.50973383,1.7373703,-0.60688362,-0.6138243,-0.50973383,1.7389576,-0.60689348,-0.6138243,-0.50973383,1.737883,-0.60688362,-0.6138243,-0.50973383,1.7417083,-0.60689348,-0.61279898,-0.50973383,1.7374492,-0.60688362,-0.6138243,-0.50973383,1.7381098,-0.60689348,-0.6138243,-0.50973383,1.7336141,-0.60689348,-0.6138243,-0.5107493,1.7343436,-0.60687377,-0.61279898,-0.5107493,1.7372422,-0.60687377,-0.6138243,-0.50973383,1.7314944,-0.60687377,-0.6138243,-0.5107493,1.725796,-0.60688362,-0.6138243,-0.50973383,1.7248692,-0.60688362,-0.6138243,-0.5107493,1.7255199,-0.60689348,-0.6138243,-0.5107493,1.7259143,-0.60689348,-0.6138243,-0.50973383,1.7288325,-0.60688362,-0.6138243,-0.50973383,1.7326381,-0.60688362,-0.6138243,-0.50973383,1.7293452,-0.60688362,-0.6138243,-0.5107493,1.7264664,-0.60688362,-0.6138243,-0.5107493,1.7296607,-0.60688362,-0.6138243,-0.5107493,1.7297494,-0.60688362,-0.6138243,-0.5107493,1.7227397,-0.60689348,-0.6138243,-0.5107493,1.7227397,-0.60689348,-0.6138243,-0.5107493,1.7227397,-0.60689348,-0.6138243,-0.5107493,1.7227397,-0.60689348,-0.6138243,-0.5107493,1.7227397,-0.60689348,-0.6138243,-0.5107493,1.7227397,-0.60689348,-0.6138243,-0.5107493,1.7227397,-0.60689348,-0.6138243,-0.5107493,1.7227397,-0.60689348,-0.6138243,-0.5107493,1.7227397,-0.60689348:6
-0.66043859,-0.58500739,1.7433787,-0.58878825,-0.65024201,-0.52383769,1.7432612,-0.58870989,-0.65024201,-0.50752904,1.7424384,-0.58866092,-0.65024201,-0.50752904,1.7460625,-0.58866092,-0.65024201,-0.50854771,1.745181,-0.58866092,-0.65024201,-0.50854771,1.744368,-0.58866092,-0.65024201,-0.50854771,1.7443582,-0.58866092,-0.65024201,-0.50345432,1.7451712,-0.58864133,-0.65024201,-0.50345432,1.7445247,-0.58864133,-0.65024201,-0.4902017,1.7441721,-0.58860215,-0.65024201,-0.48918302,1.7433101,-0.58859235,-0.65534519,-0.48918302,1.7422327,-0.58858256,-0.65024201,-0.48918302,1.7434963,-0.58859235,-0.65024201,-0.48918302,1.7452789,-0.58859235,-0.65024201,-0.48918302,1.7433983,-0.58859235,-0.65024201,-0.4902017,1.7462682,-0.58860215,-0.65126068,-0.48918302,1.7429477,-0.58859235,-0.65024201,-0.4902017,1.7449753,-0.58860215,-0.64922333,-0.48918302,1.7360717,-0.58859235,-0.64820465,-0.4902017,1.7358072,-0.58860215,-0.64922333,-0.4902017,1.7377662,-0.58860215,-0.64820465,-0.48918302,1.7359541,-0.58860215,-0.64820465,-0.48918302,1.7361794,-0.58860215,-0.65126068,-0.48918302,1.7376095,-0.58859235,-0.64820465,-0.4902017,1.7353076,-0.58860215,-0.64922333,-0.48918302,1.7382168,-0.58859235,-0.64922333,-0.48918302,1.7378641,-0.58859235,-0.64820465,-0.48918302,1.7371883,-0.58860215,-0.64820465,-0.4902017,1.7368944,-0.58860215,-0.65738255,-0.4902017,1.7292641,-0.58858256,-0.64820465,-0.4902017,1.7371589,-0.58860215,-0.65227936,-0.49122038,1.7304787,-0.58859235,-0.64820465,-0.49122038,1.7334172,-0.58860215,-0.65024201,-0.49122038,1.7326434,-0.58860215,-0.64922333,-0.4902017,1.7285883,-0.58859235,-0.64922333,-0.49122038,1.7306648,-0.58860215,-0.65330784,-0.49122038,1.7254735,-0.58859235,-0.64820465,-0.48918302,1.7301457,-0.58859235,-0.64820465,-0.48918302,1.7302828,-0.58859235,-0.64922333,-0.4902017,1.7284609,-0.58859235,-0.64820465,-0.48918302,1.7304199,-0.58859235,-0.64820465,-0.48918302,1.7297441,-0.58859235,-0.64820465,-0.48918302,1.7322908,-0.58859235,-0.64820465,-0.4902017,1.7317814,-0.58860215,-0.64820465,-0.49122038,1.7265607,-0.58860215,-0.65024201,-0.49122038,1.7309978,-0.58859235,-0.64820465,-0.49122038,1.7305571,-0.58860215,-0.64820465,-0.49122038,1.7332311,-0.58860215,-0.64820465,-0.4902017,1.7338776,-0.58860215,-0.64820465,-0.4902017,1.7328785,-0.58860215,-0.64820465,-0.4902017,1.73376,-0.58860215,-0.64820465,-0.4902017,1.7332801,-0.58860215,-0.64820465,-0.48918302,1.7304885,-0.58859235,-0.64820465,-0.49122038,1.7268154,-0.58860215,-0.64820465,-0.49122038,1.7289997,-0.58860215,-0.64922333,-0.49122038,1.7260122,-0.58860215,-0.64922333,-0.4902017,1.7250621,-0.58859235,-0.64820465,-0.48918302,1.724396,-0.58859235,-0.64820465,-0.49122038,1.7230149,-0.58860215,-0.64820465,-0.49122038,1.7235341,-0.58860215,-0.64820465,-0.4902017,1.723583,-0.58860215,-0.64820465,-0.48918302,1.7232696,-0.58859235,-0.64820465,-0.4902017,1.7234949,-0.58860215,-0.64820465,-0.49122038,1.7229562,-0.58860215,-0.64820465,-0.4902017,1.7204486,-0.58859235,-0.65227936,-0.4902017,1.7254637,-0.58859235,-0.65227936,-0.4902017,1.7329275,-0.58859235,-0.64820465,-0.4902017,1.7332899,-0.58860215,-0.64820465,-0.49122038,1.732996,-0.58860215,-0.64820465,-0.4902017,1.7336817,-0.58860215,-0.64820465,-0.49122038,1.7329079,-0.58860215,-0.64820465,-0.48918302,1.7337502,-0.58860215,-0.64820465,-0.49122038,1.7335641,-0.58860215,-0.64820465,-0.4902017,1.729176,-0.58860215,-0.64820465,-0.49122038,1.7279222,-0.58860215,-0.65024201,-0.49122038,1.7314876,-0.58860215,-0.64922333,-0.4902017,1.7326336,-0.58860215,-0.64820465,-0.49122038,1.7318598,-0.58860215,-0.65024201,-0.4902017,1.7272366,-0.58859235,-0.64922333,-0.4902017,1.7346808,-0.58860215,-0.64820465,-0.49122038,1.7335054,-0.58860215,-0.64820465,-0.49122038,1.7264236,-0.58860215,-0.64820465,-0.4902017,1.7283238,-0.58860215,-0.64718597,-0.4902017,1.7285099,-0.58860215,-0.64820465,-0.4902017,1.724876,-0.58860215,-0.64820465,-0.49122038,1.7303318,-0.58860215,-0.64820465,-0.4902017,1.7310076,-0.58860215,-0.65330784,-0.4902017,1.7233578,-0.58859235,-0.64820465,-0.49122038,1.7287156,-0.58860215,-0.64820465,-0.49122038,1.7314484,-0.58860215,-0.64922333,-0.4902017,1.7297637,-0.58859235,-0.64820465,-0.49122038,1.7247486,-0.58860215,-0.64820465,-0.49223906,1.7299106,-0.58860215,-0.64820465,-0.48918302,1.7268056,-0.58859235,-0.64820465,-0.4902017,1.7239944,-0.58860215,-0.64820465,-0.49122038,1.7311448,-0.58860215,-0.64820465,-0.49122038,1.7296755,-0.58860215,-0.64820465,-0.49122038,1.7254833,-0.58860215,-0.64820465,-0.49122038,1.7291074,-0.58860215,-0.64820465,-0.49122038,1.7290291,-0.58860215,-0.64922333,-0.49122038,1.7345436,-0.58860215,-0.64820465,-0.4902017,1.732183,-0.58860215,-0.64820465,-0.4902017,1.7310958,-0.58860215,-0.64820465,-0.49122038,1.7340049,-0.58860215,-0.64922333,-0.4902017,1.7332311,-0.58860215,-0.64820465,-0.49122038,1.7333486,-0.58860215,-0.64820465,-0.4902017,1.7342596,-0.58860215,-0.64820465,-0.49122038,1.7356701,-0.58860215,-0.64820465,-0.49122038,1.7365516,-0.58860215,-0.64820465,-0.49122038,1.7348081,-0.58860215,-0.64820465,-0.49122038,1.7323985,-0.58860215,-0.64820465,-0.49122038,1.7310664,-0.58860215,-0.64922333,-0.4902017,1.7270505,-0.58860215,-0.64820465,-0.49122038,1.7260906,-0.58860215,-0.64820465,-0.49122038,1.7268644,-0.58860215,-0.64718597,-0.49122038,1.7228778,-0.58860215,-0.64922333,-0.49122038,1.7261787,-0.58860215,-0.64820465,-0.49122038,1.7268252,-0.58860215,-0.64820465,-0.49122038,1.726835,-0.58860215,-0.64820465,-0.4902017,1.7286373,-0.58860215,-0.64820465,-0.49122038,1.7285295,-0.58860215,-0.64820465,-0.4902017,1.7289311,-0.58860215,-0.64820465,-0.49223906,1.7285393,-0.58860215,-0.64820465,-0.49122038,1.7303808,-0.58860215,-0.65330784,-0.4902017,1.7362088,-0.58859235,-0.65024201,-0.49122038,1.7381874,-0.58860215,-0.65024201,-0.49122038,1.7379915,-0.58860215,-0.64922333,-0.49122038,1.7386086,-0.58860215,-0.64922333,-0.4902017,1.7371785,-0.58860215,-0.64922333,-0.49122038,1.7327903,-0.58860215,-0.65330784,-0.49122038,1.7316051,-0.58859235,-0.64922333,-0.4902017,1.7368748,-0.58860215,-0.64922333,-0.4902017,1.722966,-0.58859235,-0.64820465,-0.49122038,1.7258555,-0.58860215,-0.64820465,-0.49122038,1.7263354,-0.58860215,-0.64718597,-0.49122038,1.7221628,-0.58860215,-0.64718597,-0.49223906,1.7234361,-0.58861194,-0.64718597,-0.4902017,1.7224762,-0.58860215,-0.64718597,-0.4902017,1.7242981,-0.58860215,-0.64718597,-0.49223906,1.7232402,-0.58861194,-0.64718597,-0.49122038,1.7227701,-0.58860215,-0.64718597,-0.49122038,1.7210951,-0.58860215,-0.64820465,-0.49122038,1.7235732,-0.58860215,-0.64718597,-0.49223906,1.7240532,-0.58861194,-0.64820465,-0.49122038,1.7261101,-0.58860215,-0.64820465,-0.49122038,1.725209,-0.58860215,-0.64718597,-0.49122038,1.724925,-0.58860215,-0.64718597,-0.49122038,1.7250523,-0.58860215,-0.64922333,-0.49122038,1.7376878,-0.58860215,-0.64922333,-0.49122038,1.7408418,-0.58860215,-0.64922333,-0.49223906,1.7405186,-0.58860215,-0.64922333,-0.48918302,1.7426049,-0.58860215,-0.64922333,-0.49122038,1.7396664,-0.58860215,-0.64922333,-0.49122038,1.7427518,-0.58860215,-0.64922333,-0.49122038,1.7428694,-0.58860215,-0.64922333,-0.49223906,1.7423502,-0.58861194,-0.64922333,-0.49122038,1.7409202,-0.58860215,-0.64922333,-0.49122038,1.7413512,-0.58860215,-0.64718597,-0.49223906,1.7303024,-0.58861194,-0.64820465,-0.49122038,1.7301947,-0.58860215,-0.64718597,-0.49122038,1.7281867,-0.58860215,-0.64718597,-0.49122038,1.7273737,-0.58860215,-0.64718597,-0.4902017,1.730322,-0.58860215,-0.65024201,-0.49122038,1.7241414,-0.58860215,-0.64718597,-0.4902017,1.7293523,-0.58860215,-0.64616729,-0.4902017,1.7266881,-0.58860215,-0.64718597,-0.4902017,1.7290095,-0.58860215,-0.64718597,-0.49122038,1.7310174,-0.58860215,-0.64718597,-0.4902017,1.7306942,-0.58860215,-0.64718597,-0.49122038,1.7304885,-0.58860215,-0.64718597,-0.4902017,1.7309685,-0.58860215,-0.64820465,-0.4902017,1.7303612,-0.58860215,-0.64922333,-0.49122038,1.7397448,-0.58860215,-0.64922333,-0.4902017,1.7376878,-0.58860215,-0.64922333,-0.49223906,1.7376976,-0.58860215,-0.64922333,-0.49122038,1.7394901,-0.58860215,-0.64922333,-0.4902017,1.7379523,-0.58860215,-0.65227936,-0.4902017,1.7379131,-0.58859235,-0.64922333,-0.49122038,1.7399896,-0.58860215,-0.64922333,-0.48918302,1.7386967,-0.58859235,-0.64922333,-0.49122038,1.7386967,-0.58860215,-0.64922333,-0.4902017,1.738971,-0.58860215,-0.64820465,-0.49122038,1.7385988,-0.58860215,-0.64820465,-0.49223906,1.7279614,-0.58860215,-0.64820465,-0.4902017,1.7299694,-0.58860215,-0.64718597,-0.49122038,1.7300086,-0.58860215,-0.64820465,-0.49122038,1.7301751,-0.58860215,-0.64820465,-0.49122038,1.7294209,-0.58860215,-0.64718597,-0.49122038,1.7300086,-0.58860215,-0.64718597,-0.4902017,1.7290095,-0.58860215,-0.64718597,-0.49122038,1.7291074,-0.58860215,-0.64718597,-0.49223906,1.7285295,-0.58861194,-0.64718597,-0.49122038,1.7275304,-0.58860215,-0.64718597,-0.49122038,1.7275696,-0.58860215,-0.64922333,-0.4902017,1.7371981,-0.58860215,-0.65024201,-0.49122038,1.7323887,-0.58860215,-0.64922333,-0.4902017,1.7377564,-0.58860215,-0.64922333,-0.49122038,1.7383539,-0.58860215,-0.64922333,-0.49122038,1.7386869,-0.58860215,-0.64922333,-0.49122038,1.736581,-0.58860215,-0.64922333,-0.49223906,1.7363949,-0.58860215,-0.64922333,-0.4902017,1.7358562,-0.58860215,-0.64922333,-0.49122038,1.7367475,-0.58860215,-0.64922333,-0.49122038,1.7323789,-0.58860215,-0.64922333,-0.49122038,1.7320753,-0.58860215,-0.64718597,-0.4902017,1.7212812,-0.58860215,-0.64718597,-0.49122038,1.7214771,-0.58860215,-0.64922333,-0.49223906,1.7213988,-0.58860215,-0.64718597,-0.49122038,1.7214869,-0.58860215,-0.64718597,-0.49223906,1.7205858,-0.58860215,-0.64718597,-0.49122038,1.7226133,-0.58860215,-0.64718597,-0.49122038,1.7214771,-0.58860215,-0.64820465,-0.49122038,1.7203899,-0.58860215,-0.64718597,-0.4902017,1.7213694,-0.58860215,-0.64718597,-0.49122038,1.7212714,-0.58860215,-0.64718597,-0.49122038,1.7235145,-0.58860215,-0.64718597,-0.4902017,1.7234165,-0.58860215,-0.64718597,-0.4902017,1.7234753,-0.58860215,-0.64718597,-0.49223906,1.7253168,-0.58861194,-0.64718597,-0.4902017,1.7238769,-0.58860215,-0.64718597,-0.49122038,1.7237985,-0.58860215,-0.64718597,-0.49122038,1.7231423,-0.58860215,-0.64718597,-0.49122038,1.7232402,-0.58860215,-0.64718597,-0.49122038,1.7233773,-0.58860215,-0.64820465,-0.4902017,1.7238671,-0.58860215,-0.64922333,-0.49223906,1.7337013,-0.58860215,-0.64922333,-0.49223906,1.7345828,-0.58860215,-0.64820465,-0.4902017,1.7331136,-0.58860215,-0.64922333,-0.49122038,1.7336719,-0.58860215,-0.64922333,-0.48918302,1.7353664,-0.58859235,-0.64922333,-0.49223906,1.7343379,-0.58860215,-0.64922333,-0.49223906,1.7359541,-0.58860215,-0.64922333,-0.49122038,1.7356896,-0.58860215,-0.64922333,-0.49223906,1.7350334,-0.58860215,-0.64922333,-0.49122038,1.7358268,-0.58860215,-0.64922333,-0.49122038,1.7338188,-0.58860215,-0.64922333,-0.4902017,1.7320753,-0.58859235,-0.64922333,-0.49122038,1.7410965,-0.58860215,-0.64922333,-0.49122038,1.7403814,-0.58860215,-0.64922333,-0.49122038,1.7411455,-0.58860215,-0.64922333,-0.49122038,1.7406459,-0.58860215,-0.64922333,-0.49223906,1.7428204,-0.58861194,-0.64922333,-0.49223906,1.7418017,-0.58860215,-0.64820465,-0.49223906,1.7319871,-0.58860215,-0.64820465,-0.49122038,1.7317227,-0.58860215,-0.64820465,-0.49122038,1.7301653,-0.58860215,-0.64820465,-0.49122038,1.7331234,-0.58860215,-0.64820465,-0.49122038,1.7317227,-0.58860215,-0.64820465,-0.49223906,1.7326434,-0.58861194,-0.64820465,-0.49122038,1.7323985,-0.58860215,-0.64820465,-0.49223906,1.7310566,-0.58861194,-0.64820465,-0.49122038,1.7292543,-0.58860215,-0.64820465,-0.49122038,1.7307824,-0.58860215,-0.64820465,-0.49122038,1.7254245,-0.58860215,-0.64820465,-0.49223906,1.7259142,-0.58860215,-0.64820465,-0.49223906,1.7298812,-0.58860215,-0.64820465,-0.49223906,1.7289115,-0.58860215,-0.64820465,-0.49122038,1.7271288,-0.58860215,-0.65024201,-0.4902017,1.7338678,-0.58859235,-0.64922333,-0.49223906,1.7347689,-0.58860215,-0.64922333,-0.49122038,1.7359443,-0.58860215,-0.65024201,-0.49223906,1.734906,-0.58860215,-0.64922333,-0.49122038,1.7338188,-0.58860215,-0.64922333,-0.4902017,1.7330352,-0.58860215,-0.64922333,-0.4902017,1.7357484,-0.58860215,-0.65024201,-0.49122038,1.7348375,-0.58860215,-0.64922333,-0.49223906,1.7355819,-0.58860215,-0.64922333,-0.4902017,1.7354448,-0.58860215,-0.64922333,-0.49122038,1.7355819,-0.58860215,-0.64922333,-0.49223906,1.7330548,-0.58860215,-0.64922333,-0.49223906,1.7370805,-0.58860215,-0.64922333,-0.49223906,1.7366594,-0.58860215,-0.64922333,-0.4902017,1.7376193,-0.58860215,-0.64922333,-0.4902017,1.7351901,-0.58860215,-0.64820465,-0.49122038,1.7277067,-0.58860215,-0.64718597,-0.49223906,1.7261395,-0.58861194,-0.64820465,-0.49223906,1.7275598,-0.58860215,-0.64820465,-0.49223906,1.7277263,-0.58860215,-0.64820465,-0.4902017,1.7262179,-0.58860215,-0.64820465,-0.4902017,1.725542,-0.58860215,-0.64718597,-0.49122038,1.7251307,-0.58860215,-0.64820465,-0.49223906,1.7264432,-0.58860215,-0.64820465,-0.4902017,1.7261297,-0.58860215,-0.64820465,-0.4902017,1.7262473,-0.58860215,-0.64718597,-0.49223906,1.7259142,-0.58861194,-0.64820465,-0.49223906,1.7261493,-0.58860215,-0.64718597,-0.49223906,1.7237496,-0.58861194,-0.64718597,-0.49122038,1.722917,-0.58860215,-0.64718597,-0.49223906,1.7229464,-0.58861194,-0.64820465,-0.49122038,1.7211441,-0.58860215,-0.64820465,-0.49223906,1.721722,-0.58860215,-0.64820465,-0.4902017,1.7221824,-0.58859235,-0.64718597,-0.49122038,1.7195475,-0.58860215,-0.64922333,-0.49223906,1.7207327,-0.58860215,-0.64820465,-0.49122038,1.7216632,-0.58860215,-0.64718597,-0.49122038,1.7198609,-0.58860215,-0.65024201,-0.48918302,1.7290291,-0.58859235,-0.64922333,-0.49223906,1.7299204,-0.58860215,-0.64922333,-0.49223906,1.7287156,-0.58860215,-0.64922333,-0.49122038,1.7286862,-0.58860215,-0.64922333,-0.49122038,1.7293131,-0.58860215,-0.64922333,-0.49122038,1.7293523,-0.58860215,-0.64922333,-0.49223906,1.7308117,-0.58860215,-0.64922333,-0.49223906,1.7312231,-0.58860215,-0.65024201,-0.49223906,1.7303808,-0.58860215,-0.64922333,-0.49122038,1.7315855,-0.58860215,-0.64922333,-0.49122038,1.7351117,-0.58860215,-0.64820465,-0.49223906,1.7300771,-0.58860215,-0.64820465,-0.49223906,1.7298322,-0.58860215,-0.64922333,-0.4902017,1.7323104,-0.58859235,-0.65024201,-0.49223906,1.7339657,-0.58860215,-0.64820465,-0.49223906,1.7342988,-0.58861194,-0.64922333,-0.49122038,1.7368455,-0.58860215,-0.64922333,-0.49223906,1.7349844,-0.58860215,-0.65330784,-0.49223906,1.7248956,-0.58859235,-0.65024201,-0.49223906,1.7153455,-0.58860215,-0.65024201,-0.49223906,1.7124461,-0.58860215,-0.65126068,-0.4902017,1.7131612,-0.58859235,-0.65024201,-0.49223906,1.7179607,-0.58860215,-0.64922333,-0.49223906,1.7186366,-0.58860215,-0.65024201,-0.49223906,1.7191753,-0.58860215,-0.65024201,-0.49122038,1.719381,-0.58860215,-0.64922333,-0.49223906,1.7194496,-0.58860215,-0.65024201,-0.49223906,1.7192243,-0.58860215,-0.64922333,-0.49325774,1.7168147,-0.58860215,-0.64922333,-0.49223906,1.7016521,-0.58860215,-0.65024201,-0.49223906,1.7021908,-0.58859235,-0.65126068,-0.49223906,1.711114,-0.58859235,-0.65126068,-0.49223906,1.7136411,-0.58860215,-0.65227936,-0.49122038,1.7147186,-0.58859235,-0.65126068,-0.49122038,1.7139742,-0.58859235,-0.65126068,-0.49223906,1.7172163,-0.58860215,-0.65227936,-0.49223906,1.7176179,-0.58859235,-0.65227936,-0.49223906,1.7163543,-0.58859235,-0.65227936,-0.49223906,1.7171281,-0.58859235,-0.65126068,-0.49223906,1.7188129,-0.58860215,-0.65126068,-0.49223906,1.7223489,-0.58860215,-0.65126068,-0.49122038,1.7223489,-0.58859235,-0.65126068,-0.49223906,1.7227015,-0.58860215,-0.65126068,-0.49223906,1.7231129,-0.58860215,-0.65126068,-0.49223906,1.7239259,-0.58860215,-0.65126068,-0.4902017,1.7212518,-0.58859235,-0.65126068,-0.49223906,1.7211931,-0.58860215,-0.65126068,-0.49122038,1.7209286,-0.58859235,-0.65126068,-0.4902017,1.72086,-0.58859235,-0.65024201,-0.4902017,1.7188521,-0.58859235,-0.65126068,-0.49122038,1.720625,-0.58859235,-0.64922333,-0.49122038,1.7115352,-0.58859235,-0.64922333,-0.49223906,1.7124266,-0.58860215,-0.64922333,-0.49223906,1.7115058,-0.58860215,-0.64922333,-0.49122038,1.7117801,-0.58859235,-0.64922333,-0.49223906,1.7131318,-0.58860215,-0.64922333,-0.49223906,1.7107614,-0.58860215,-0.64922333,-0.49223906,1.7127204,-0.58860215,-0.65024201,-0.49122038,1.7149243,-0.58859235,-0.65024201,-0.49122038,1.7149243,-0.58859235,-0.65024201,-0.49122038,1.7149243,-0.58859235,-0.65024201,-0.49122038,1.7149243,-0.58859235,-0.65024201,-0.49122038,1.7149243,-0.58859235,-0.65024201,-0.49122038,1.7149243,-0.58859235,-0.65024201,-0.49122038,1.7149243,-0.58859235,-0.65024201,-0.49122038,1.7149243,-0.58859235,-0.65024201,-0.49122038,1.7149243,-0.58859235,-0.65024201,-0.49122038,1.7149243,-0.58859235,-0.65024201,-0.49122038,1.7149243,-0.58859235:6
-0.57541085,-0.44970834,1.7249371,-0.66255763,-0.57437721,-0.43516715,1.7281785,-0.66249742,-0.57437721,-0.43932177,1.7308579,-0.66251749,-0.57437721,-0.43828814,1.7272652,-0.66250745,-0.57541085,-0.43724446,1.7270746,-0.66250745,-0.57748816,-0.44970834,1.7267936,-0.66255763,-0.57748816,-0.44036545,1.7270946,-0.66250745,-0.57437721,-0.43621082,1.7294128,-0.66249742,-0.57541085,-0.44970834,1.7257599,-0.66255763,-0.57437721,-0.45075201,1.7283691,-0.66256767,-0.57437721,-0.44139909,1.7279276,-0.66252752,-0.57541085,-0.44036545,1.7269542,-0.66251749,-0.57541085,-0.44139909,1.7267635,-0.66251749,-0.57437721,-0.44970834,1.7272452,-0.66256767,-0.57437721,-0.44139909,1.7269441,-0.66252752,-0.57437721,-0.4434764,1.7272151,-0.66252752,-0.57645452,-0.45075201,1.7230203,-0.66256767,-0.57541085,-0.44036545,1.7287404,-0.66251749,-0.57437721,-0.44970834,1.7290214,-0.66256767,-0.57645452,-0.44970834,1.7264223,-0.66255763,-0.57541085,-0.44139909,1.7242948,-0.66251749,-0.57541085,-0.44970834,1.7264223,-0.66256767,-0.57541085,-0.45075201,1.7247564,-0.66256767,-0.57541085,-0.4434764,1.7249571,-0.66252752,-0.57541085,-0.44555371,1.7246661,-0.66253756,-0.57541085,-0.43621082,1.7253686,-0.66249742,-0.57541085,-0.44970834,1.727777,-0.66256767,-0.57541085,-0.44970834,1.7265929,-0.66256767,-0.57541085,-0.44763103,1.723793,-0.66255763,-0.57541085,-0.45075201,1.7231508,-0.66256767,-0.57541085,-0.44452007,1.723211,-0.66253756,-0.57853183,-0.44452007,1.7210032,-0.66252752,-0.57853183,-0.43932177,1.7215551,-0.66249742,-0.57748816,-0.44555371,1.7229099,-0.66253756,-0.57437721,-0.45075201,1.7275864,-0.66256767,-0.57437721,-0.44555371,1.7271047,-0.6625476,-0.57437721,-0.44970834,1.7281985,-0.66255763,-0.57437721,-0.43724446,1.7290014,-0.66250745,-0.57437721,-0.43828814,1.7291419,-0.66250745,-0.57541085,-0.44970834,1.7275563,-0.66255763,-0.57541085,-0.44139909,1.7263019,-0.66251749,-0.57437721,-0.44139909,1.7269843,-0.66252752,-0.57437721,-0.44970834,1.7283892,-0.66256767,-0.57541085,-0.44970834,1.7262316,-0.66256767,-0.57645452,-0.43932177,1.7250976,-0.66250745,-0.57645452,-0.45075201,1.7223379,-0.66256767,-0.57541085,-0.44452007,1.7231809,-0.66253756,-0.57541085,-0.43621082,1.7255492,-0.66249742,-0.57541085,-0.44970834,1.7245256,-0.66256767,-0.57541085,-0.45075201,1.7251578,-0.66256767,-0.57541085,-0.43932177,1.7246761,-0.66251749,-0.57541085,-0.44036545,1.7233715,-0.66251749,-0.57645452,-0.44244276,1.7197889,-0.66251749,-0.57541085,-0.45075201,1.7227293,-0.66256767,-0.57541085,-0.43621082,1.7248267,-0.66249742,-0.57645452,-0.44970834,1.7195581,-0.66255763,-0.57541085,-0.44659739,1.7234318,-0.6625476,-0.57541085,-0.44452007,1.7238733,-0.66253756,-0.57541085,-0.44659739,1.7259506,-0.66253756,-0.57541085,-0.44970834,1.7252983,-0.66255763,-0.57645452,-0.44555371,1.719538,-0.66253756,-0.57541085,-0.43932177,1.7237328,-0.66250745,-0.57541085,-0.4486747,1.7232612,-0.66255763,-0.57541085,-0.44970834,1.7243149,-0.66256767,-0.57645452,-0.44244276,1.7238633,-0.66251749,-0.57645452,-0.45075201,1.7224985,-0.66256767,-0.58060915,-0.43412348,1.7166378,-0.66246731,-0.57541085,-0.44452007,1.7246761,-0.66253756,-0.57541085,-0.44970834,1.7239436,-0.66256767,-0.57645452,-0.44970834,1.7211236,-0.66255763,-0.57541085,-0.44244276,1.723492,-0.66252752,-0.57541085,-0.44244276,1.7244654,-0.66251749,-0.57541085,-0.44970834,1.7253284,-0.66256767,-0.57541085,-0.43724446,1.7233113,-0.66249742,-0.57645452,-0.44970834,1.7230203,-0.66256767,-0.57541085,-0.45075201,1.7236525,-0.66256767,-0.57541085,-0.44970834,1.7213043,-0.66255763,-0.57645452,-0.45075201,1.7202405,-0.66256767,-0.57645452,-0.44970834,1.7212842,-0.66255763,-0.57645452,-0.45075201,1.7211136,-0.66255763,-0.57541085,-0.44555371,1.7224684,-0.66253756,-0.57645452,-0.45075201,1.7222877,-0.66256767,-0.57541085,-0.43828814,1.7213845,-0.66250745,-0.57645452,-0.45075201,1.7211236,-0.66256767,-0.57645452,-0.45075201,1.7229902,-0.66256767,-0.57541085,-0.44244276,1.7241643,-0.66252752,-0.57541085,-0.44036545,1.7236626,-0.66251749,-0.57541085,-0.44244276,1.7244754,-0.66252752,-0.57645452,-0.44970834,1.7227795,-0.66255763,-0.57541085,-0.43724446,1.7239134,-0.66249742,-0.57645452,-0.45075201,1.7214949,-0.66256767,-0.57645452,-0.4434764,1.7195581,-0.66252752,-0.57645452,-0.45075201,1.7221773,-0.66255763,-0.57541085,-0.43828814,1.7235622,-0.66250745,-0.57541085,-0.44452007,1.7223981,-0.66253756,-0.57645452,-0.44555371,1.7238633,-0.66253756,-0.57853183,-0.45075201,1.7210132,-0.66255763,-0.57541085,-0.45075201,1.7264223,-0.66256767,-0.57748816,-0.43724446,1.7246761,-0.66249742,-0.57541085,-0.45075201,1.7256295,-0.66256767,-0.57541085,-0.45075201,1.7241844,-0.66256767,-0.57748816,-0.44970834,1.7242948,-0.66255763,-0.57541085,-0.44970834,1.7236726,-0.66255763,-0.57541085,-0.44970834,1.7269341,-0.66256767,-0.57541085,-0.44970834,1.726613,-0.66255763,-0.57541085,-0.4486747,1.726332,-0.66255763,-0.57541085,-0.44452007,1.7242245,-0.66253756,-0.57956547,-0.43828814,1.7193574,-0.66249742,-0.57541085,-0.44970834,1.726342,-0.66255763,-0.57333354,-0.43621082,1.7345007,-0.66249742,-0.57956547,-0.4486747,1.7273255,-0.6625476,-0.57333354,-0.44970834,1.7333567,-0.66256767,-0.57333354,-0.4434764,1.7344104,-0.66253756,-0.57333354,-0.44763103,1.733738,-0.66255763,-0.57333354,-0.4486747,1.7341093,-0.66256767,-0.57645452,-0.4434764,1.7308579,-0.66252752,-0.57956547,-0.43828814,1.7259908,-0.66248738,-0.57541085,-0.44970834,1.7330757,-0.66256767,-0.57333354,-0.43932177,1.7368088,-0.66251749,-0.57333354,-0.44970834,1.7358455,-0.66256767,-0.57333354,-0.43516715,1.7373508,-0.66249742,-0.57333354,-0.4486747,1.7359057,-0.66255763,-0.57645452,-0.44555371,1.7364375,-0.66253756,-0.57437721,-0.4486747,1.7357451,-0.66256767,-0.57437721,-0.43621082,1.737411,-0.66249742,-0.57333354,-0.44036545,1.7395385,-0.66251749,-0.57333354,-0.44763103,1.7363573,-0.66255763,-0.57333354,-0.4486747,1.7377722,-0.66256767,-0.57333354,-0.4486747,1.7384446,-0.66256767,-0.57437721,-0.44036545,1.7382038,-0.66251749,-0.57333354,-0.43412348,1.7385851,-0.66249742,-0.57333354,-0.4486747,1.7388159,-0.66256767,-0.57333354,-0.4486747,1.7354942,-0.66256767,-0.57437721,-0.43932177,1.7323732,-0.66251749,-0.57437721,-0.44970834,1.7357852,-0.66256767,-0.57333354,-0.43412348,1.7377321,-0.66249742,-0.57437721,-0.44970834,1.7355043,-0.66256767,-0.57333354,-0.43308984,1.7359157,-0.66248738,-0.57333354,-0.4486747,1.7361064,-0.66256767,-0.57541085,-0.44659739,1.7346111,-0.6625476,-0.57541085,-0.44659739,1.7346211,-0.66255763,-0.57437721,-0.44659739,1.7342298,-0.6625476,-0.57541085,-0.4486747,1.7308579,-0.66256767,-0.57437721,-0.44244276,1.7322628,-0.66253756,-0.57437721,-0.44555371,1.7347516,-0.6625476,-0.57541085,-0.44970834,1.7310084,-0.66256767,-0.57541085,-0.4486747,1.7296637,-0.66255763,-0.57541085,-0.44970834,1.7278674,-0.66256767,-0.57541085,-0.4486747,1.7308579,-0.66255763,-0.57541085,-0.44659739,1.7305368,-0.6625476,-0.57645452,-0.44244276,1.7256696,-0.66252752,-0.57645452,-0.44139909,1.7269542,-0.66252752,-0.57645452,-0.44763103,1.7309783,-0.66255763,-0.57437721,-0.43724446,1.729172,-0.66250745,-0.57645452,-0.4486747,1.7296938,-0.66255763,-0.57437721,-0.44970834,1.7295332,-0.66256767,-0.57437721,-0.43828814,1.7293827,-0.66250745,-0.57437721,-0.44970834,1.7306973,-0.66256767,-0.57748816,-0.43828814,1.7283792,-0.66249742,-0.57645452,-0.44139909,1.7300149,-0.66252752,-0.57437721,-0.43932177,1.7299748,-0.66251749,-0.57437721,-0.44970834,1.7307876,-0.66256767,-0.57541085,-0.43308984,1.728038,-0.66248738,-0.57437721,-0.44970834,1.7310084,-0.66256767,-0.57437721,-0.43101252,1.730617,-0.66247735,-0.57437721,-0.44970834,1.7296336,-0.66256767,-0.57437721,-0.43204616,1.7290214,-0.66247735,-0.57541085,-0.44970834,1.7299246,-0.66256767,-0.57333354,-0.43308984,1.7359558,-0.66248738,-0.57541085,-0.44970834,1.7306572,-0.66256767,-0.57541085,-0.44452007,1.729172,-0.66253756,-0.57541085,-0.44970834,1.7302357,-0.66256767,-0.57437721,-0.43724446,1.7323331,-0.66250745,-0.57541085,-0.44970834,1.7301554,-0.66256767,-0.57437721,-0.43724446,1.7332062,-0.66250745,-0.57437721,-0.4486747,1.7319819,-0.66255763,-0.57437721,-0.43621082,1.733728,-0.66249742,-0.57437721,-0.4486747,1.7318815,-0.66255763,-0.57541085,-0.43932177,1.7299045,-0.66251749,-0.57333354,-0.44036545,1.7370597,-0.66251749,-0.57333354,-0.4486747,1.734581,-0.66255763,-0.57437721,-0.4486747,1.7332965,-0.66255763,-0.57437721,-0.4434764,1.733738,-0.66253756,-0.57437721,-0.48711,1.7333166,-0.6627483,-0.57437721,-0.48607636,1.73714,-0.6627483,-0.57437721,-0.48607636,1.7335875,-0.6627483,-0.57541085,-0.49438562,1.7326643,-0.66277841,-0.57541085,-0.47775708,1.7327144,-0.66269812,-0.57541085,-0.49438562,1.7321826,-0.66277841,-0.57541085,-0.49438562,1.729182,-0.66277841,-0.57541085,-0.49438562,1.7283089,-0.66278844,-0.57541085,-0.49334194,1.7343,-0.66277841,-0.57437721,-0.49334194,1.737431,-0.66277841,-0.57437721,-0.49438562,1.7347616,-0.66277841,-0.57437721,-0.49334194,1.7380231,-0.66277841,-0.57437721,-0.49334194,1.7356548,-0.66277841,-0.57541085,-0.49438562,1.7319819,-0.66277841,-0.57541085,-0.49438562,1.738003,-0.66277841,-0.57437721,-0.49438562,1.7353638,-0.66277841,-0.57541085,-0.49438562,1.733457,-0.66278844,-0.57437721,-0.49438562,1.7373407,-0.66277841,-0.57437721,-0.49438562,1.736859,-0.66277841,-0.57437721,-0.49438562,1.7380432,-0.66277841,-0.57645452,-0.49438562,1.7366483,-0.66277841,-0.57541085,-0.49438562,1.7359057,-0.66277841,-0.57437721,-0.49438562,1.7396789,-0.66277841,-0.57437721,-0.49438562,1.7354139,-0.66277841,-0.57437721,-0.49438562,1.7387356,-0.66278844,-0.57541085,-0.49541925,1.7298142,-0.66278844,-0.57541085,-0.49541925,1.7281183,-0.66278844,-0.57541085,-0.49541925,1.7302056,-0.66278844,-0.57541085,-0.49541925,1.7294931,-0.66278844,-0.57645452,-0.49541925,1.7263721,-0.66278844,-0.57645452,-0.49541925,1.7256797,-0.66278844,-0.57645452,-0.49541925,1.7234418,-0.66278844,-0.57541085,-0.49541925,1.7264323,-0.66278844,-0.57541085,-0.49541925,1.7298142,-0.66278844,-0.57541085,-0.49541925,1.7278774,-0.66278844,-0.57645452,-0.49541925,1.7264223,-0.66278844,-0.57645452,-0.49646293,1.7251478,-0.66278844,-0.57645452,-0.49541925,1.7264122,-0.66278844,-0.57645452,-0.49646293,1.7264825,-0.66278844,-0.57645452,-0.49541925,1.7268137,-0.66277841,-0.57645452,-0.49541925,1.7248267,-0.66278844,-0.57748816,-0.49541925,1.724345,-0.66278844,-0.57645452,-0.49646293,1.7231508,-0.66278844,-0.57645452,-0.49646293,1.7234418,-0.66278844,-0.57645452,-0.49646293,1.721796,-0.66278844,-0.57956547,-0.49646293,1.7202104,-0.66278844,-0.57748816,-0.49646293,1.7210333,-0.66278844,-0.57645452,-0.49646293,1.7227092,-0.66278844,-0.57645452,-0.49646293,1.7251277,-0.66278844,-0.57748816,-0.49646293,1.7201201,-0.66278844,-0.57645452,-0.49646293,1.7231909,-0.66278844,-0.57645452,-0.49646293,1.7234117,-0.66278844,-0.57645452,-0.49646293,1.7243851,-0.66278844,-0.57645452,-0.49646293,1.7248969,-0.66278844,-0.57645452,-0.49646293,1.7247062,-0.66278844,-0.57748816,-0.49646293,1.7218161,-0.66278844,-0.58060915,-0.49646293,1.7164873,-0.66277841,-0.57645452,-0.49646293,1.7225185,-0.66278844,-0.57748816,-0.49646293,1.7212441,-0.66278844,-0.57645452,-0.49646293,1.7241643,-0.66278844,-0.57748816,-0.49646293,1.7212541,-0.66278844,-0.57748816,-0.49646293,1.7237629,-0.66278844,-0.57645452,-0.49646293,1.7228999,-0.66278844,-0.57645452,-0.49646293,1.7254288,-0.66278844,-0.57645452,-0.49646293,1.7243249,-0.66278844,-0.57748816,-0.49646293,1.723211,-0.66278844,-0.57645452,-0.49646293,1.7240138,-0.66278844,-0.57748816,-0.49646293,1.7227494,-0.66278844,-0.57645452,-0.49646293,1.7226992,-0.66278844,-0.57645452,-0.49646293,1.7242547,-0.66278844,-0.57748816,-0.49646293,1.7223981,-0.66278844,-0.57645452,-0.49646293,1.7249872,-0.66278844,-0.57748816,-0.49646293,1.7217759,-0.66278844,-0.57748816,-0.49646293,1.7223279,-0.66278844,-0.57748816,-0.49646293,1.7227092,-0.66278844,-0.57748816,-0.49646293,1.7275462,-0.66278844,-0.58060915,-0.49646293,1.7222677,-0.66277841,-0.58060915,-0.49646293,1.7222777,-0.66277841,-0.57748816,-0.49646293,1.7238131,-0.66278844,-0.57748816,-0.49646293,1.721505,-0.66278844,-0.57645452,-0.49646293,1.7232712,-0.66278844,-0.57645452,-0.49646293,1.7241944,-0.66278844,-0.57748816,-0.49646293,1.7228798,-0.66278844,-0.57748816,-0.49646293,1.7218361,-0.66278844,-0.57748816,-0.49646293,1.7226791,-0.66278844,-0.57748816,-0.49646293,1.7222175,-0.66278844,-0.57645452,-0.49646293,1.7237328,-0.66278844,-0.57645452,-0.49646293,1.7239034,-0.66278844,-0.57645452,-0.49646293,1.7224684,-0.66278844,-0.57748816,-0.49646293,1.7227092,-0.66278844,-0.57748816,-0.49646293,1.7223379,-0.66278844,-0.57645452,-0.49646293,1.7238532,-0.66278844,-0.57748816,-0.49646293,1.7218662,-0.66278844,-0.57748816,-0.49749657,1.7203108,-0.66278844,-0.57748816,-0.49646293,1.7239837,-0.66278844,-0.57748816,-0.49646293,1.7264223,-0.66278844,-0.57645452,-0.49646293,1.7277269,-0.66278844,-0.57645452,-0.49646293,1.7259406,-0.66278844,-0.57645452,-0.49646293,1.7261212,-0.66278844,-0.57645452,-0.49646293,1.7267936,-0.66278844,-0.57645452,-0.48711,1.7276064,-0.6627483,-0.57645452,-0.48918732,1.727767,-0.66275834,-0.57645452,-0.48918732,1.7282286,-0.66275834,-0.57645452,-0.48918732,1.7258402,-0.66275834,-0.57645452,-0.48918732,1.7252582,-0.66275834,-0.57645452,-0.48918732,1.7268638,-0.66275834,-0.57645452,-0.48918732,1.7268036,-0.66275834,-0.57541085,-0.48918732,1.7273054,-0.66275834,-0.57541085,-0.48918732,1.7289512,-0.66275834,-0.57645452,-0.48918732,1.7275663,-0.66275834,-0.57645452,-0.48918732,1.7282086,-0.66275834,-0.57645452,-0.48918732,1.7278373,-0.66275834,-0.57645452,-0.48918732,1.7281885,-0.66275834,-0.57645452,-0.48918732,1.7247464,-0.6627483,-0.57645452,-0.48918732,1.7225587,-0.66275834,-0.57645452,-0.48918732,1.7257901,-0.66275834,-0.57645452,-0.48918732,1.726914,-0.66275834,-0.57645452,-0.48918732,1.7278874,-0.66275834,-0.57645452,-0.48918732,1.7252582,-0.66275834,-0.57541085,-0.48918732,1.7268638,-0.66275834,-0.57645452,-0.48918732,1.7250474,-0.66275834,-0.57645452,-0.48918732,1.7262718,-0.66275834,-0.57748816,-0.48918732,1.7241142,-0.6627483,-0.57645452,-0.48918732,1.7242245,-0.66275834,-0.57748816,-0.48918732,1.7224884,-0.66275834,-0.57645452,-0.48918732,1.7219967,-0.66275834,-0.57645452,-0.49023099,1.7224784,-0.66275834,-0.57748816,-0.49023099,1.7219766,-0.66275834,-0.57645452,-0.49023099,1.7223178,-0.66275834,-0.5837201,-0.62216544,1.7241443,-0.66331028,-0.5837201,-0.62527639,1.7248869,-0.66332032,-0.5837201,-0.62527639,1.7223379,-0.66333035,-0.5837201,-0.62632006,1.723512,-0.66333035,-0.5837201,-0.62527639,1.7255291,-0.66332032,-0.58476377,-0.62632006,1.7211036,-0.66333035,-0.5837201,-0.62632006,1.7216254,-0.66333035,-0.5837201,-0.62527639,1.7234217,-0.66332032,-0.58476377,-0.62632006,1.7217257,-0.66333035,-0.58476377,-0.62632006,1.7204814,-0.66333035,-0.58476377,-0.62527639,1.7197187,-0.66333035,-0.58476377,-0.62632006,1.720662,-0.66333035,-0.5837201,-0.62527639,1.7222978,-0.66333035,-0.58476377,-0.62632006,1.7224784,-0.66333035,-0.5837201,-0.62527639,1.7235522,-0.66333035,-0.58476377,-0.62527639,1.7214749,-0.66333035,-0.5837201,-0.62527639,1.7230705,-0.66333035,-0.5837201,-0.62527639,1.725479,-0.66332032,-0.58268646,-0.62527639,1.7319016,-0.66332032,-0.58268646,-0.62527639,1.7292121,-0.66332032,-0.58268646,-0.62527639,1.7335173,-0.66332032,-0.58268646,-0.62527639,1.7316306,-0.66332032,-0.58268646,-0.62527639,1.7320421,-0.66332032,-0.58268646,-0.62527639,1.7327746,-0.66332032,-0.58268646,-0.62527639,1.7325238,-0.66332032,-0.58268646,-0.62527639,1.7319317,-0.66332032,-0.58164279,-0.62527639,1.7355645,-0.66332032,-0.58164279,-0.62527639,1.7354641,-0.66332032,-0.58164279,-0.62527639,1.7366583,-0.66332032,-0.58164279,-0.62527639,1.7383141,-0.66332032,-0.58164279,-0.62527639,1.7355043,-0.66332032,-0.58164279,-0.62527639,1.7345308,-0.66332032,-0.58164279,-0.62527639,1.7349122,-0.66332032,-0.58164279,-0.62527639,1.7362569,-0.66332032,-0.58164279,-0.62527639,1.739137,-0.66331028,-0.58164279,-0.62527639,1.7357852,-0.66332032,-0.58060915,-0.62527639,1.7399399,-0.66331028,-0.58164279,-0.62527639,1.738284,-0.66331028,-0.58164279,-0.62527639,1.7374712,-0.66332032,-0.58164279,-0.62527639,1.7387356,-0.66331028,-0.58060915,-0.62527639,1.7414753,-0.66331028,-0.58164279,-0.62527639,1.7379027,-0.66331028,-0.58164279,-0.62527639,1.7375214,-0.66332032,-0.58164279,-0.62527639,1.7373106,-0.66332032,-0.58164279,-0.62527639,1.735153,-0.66332032,-0.58164279,-0.62527639,1.7359458,-0.66332032,-0.58164279,-0.62527639,1.7378927,-0.66332032,-0.58164279,-0.62527639,1.7378927,-0.66332032,-0.58164279,-0.62527639,1.7378927,-0.66332032,-0.58164279,-0.62527639,1.7378927,-0.66332032,-0.58164279,-0.62527639,1.7378927,-0.66332032,-0.58164279,-0.62527639,1.7378927,-0.66332032,-0.58164279,-0.62527639,1.7378927,-0.66332032:6
-0.536108,-0.46142863,1.7251618,-0.70446968,-0.536108,-0.46142863,1.7242189,-0.70446968,-0.53504203,-0.46142863,1.7265455,-0.70446968,-0.536108,-0.46142863,1.7252951,-0.70446968,-0.53717397,-0.46142863,1.7251311,-0.70446968,-0.536108,-0.46142863,1.7252233,-0.70446968,-0.536108,-0.46142863,1.7255001,-0.70446968,-0.536108,-0.46142863,1.7259306,-0.70446968,-0.536108,-0.46142863,1.7254591,-0.70446968,-0.536108,-0.46036266,1.7270273,-0.70446968,-0.536108,-0.46142863,1.7245366,-0.70446968,-0.536108,-0.46142863,1.7263406,-0.70446968,-0.536108,-0.46036266,1.7264328,-0.70446968,-0.536108,-0.46142863,1.7250388,-0.70446968,-0.536108,-0.46142863,1.7251311,-0.70446968,-0.536108,-0.46142863,1.7247723,-0.70446968,-0.536108,-0.46142863,1.7257358,-0.70446968,-0.536108,-0.46142863,1.7261561,-0.70446968,-0.536108,-0.46142863,1.7269453,-0.70446968,-0.536108,-0.46142863,1.7256128,-0.70446968,-0.536108,-0.46142863,1.7250901,-0.70446968,-0.536108,-0.46142863,1.7254693,-0.70446968,-0.536108,-0.46142863,1.7244546,-0.70446968,-0.53717397,-0.46142863,1.7235219,-0.70446968,-0.536108,-0.46142863,1.7252951,-0.70446968,-0.536108,-0.46142863,1.7247518,-0.70446968,-0.53823994,-0.46142863,1.7209185,-0.70446968,-0.53717397,-0.46142863,1.7221689,-0.70446968,-0.536108,-0.46142863,1.7245879,-0.70446968,-0.536108,-0.46142863,1.7251721,-0.70446968,-0.536108,-0.46142863,1.7251618,-0.70446968,-0.536108,-0.46142863,1.7251721,-0.70446968,-0.53717397,-0.46142863,1.7252336,-0.70446968,-0.53717397,-0.46142863,1.7253258,-0.70446968,-0.53717397,-0.46142863,1.7250798,-0.70446968,-0.53717397,-0.46142863,1.7248543,-0.70446968,-0.53930591,-0.4624946,1.7175361,-0.70447993,-0.53717397,-0.46142863,1.7210722,-0.70446968,-0.53823994,-0.4624946,1.7194117,-0.70446968,-0.53717397,-0.46142863,1.7221279,-0.70446968,-0.53717397,-0.46356057,1.7230709,-0.70447993,-0.53717397,-0.46142863,1.7240139,-0.70446968,-0.536108,-0.4624946,1.7242086,-0.70446968,-0.536108,-0.46570276,1.7253361,-0.70449018,-0.536108,-0.4624946,1.7263713,-0.70446968,-0.53717397,-0.4624946,1.7227429,-0.70446968,-0.53823994,-0.46356057,1.7211542,-0.70447993,-0.53717397,-0.4624946,1.7211747,-0.70446968,-0.53717397,-0.4624946,1.7211747,-0.70446968,-0.53717397,-0.46356057,1.720365,-0.70447993,-0.53717397,-0.46142863,1.7202112,-0.70446968,-0.53823994,-0.46462654,1.7214617,-0.70447993,-0.53823994,-0.46142863,1.720488,-0.70446968,-0.53717397,-0.46570276,1.7236859,-0.70449018,-0.53717397,-0.46142863,1.7218307,-0.70446968,-0.53717397,-0.46036266,1.7219024,-0.70445943,-0.53717397,-0.4624946,1.7231324,-0.70446968,-0.536108,-0.45823073,1.7249568,-0.70445943,-0.536108,-0.4624946,1.7257051,-0.70446968,-0.53717397,-0.46036266,1.7237269,-0.70446968,-0.536108,-0.46462654,1.7254488,-0.70447993,-0.536108,-0.46142863,1.7250798,-0.70446968,-0.53717397,-0.46142863,1.7245776,-0.70446968,-0.53717397,-0.4624946,1.7240856,-0.70447993,-0.54037188,-0.46142863,1.7243521,-0.70447993,-0.53930591,-0.45929669,1.7249876,-0.70446968,-0.536108,-0.46356057,1.7268838,-0.70447993,-0.53717397,-0.46036266,1.7253156,-0.70446968,-0.53717397,-0.45929669,1.7247826,-0.70447993,-0.53717397,-0.4624946,1.7246903,-0.70447993,-0.536108,-0.45929669,1.7250593,-0.70445943,-0.536108,-0.46462654,1.7256538,-0.70447993,-0.536108,-0.46036266,1.7261151,-0.70446968,-0.53717397,-0.46570276,1.7260126,-0.70449018,-0.53717397,-0.46356057,1.7246698,-0.70447993,-0.53717397,-0.4624946,1.7243111,-0.70447993,-0.53717397,-0.46142863,1.7242291,-0.70446968,-0.536108,-0.46142863,1.7263611,-0.70446968,-0.53717397,-0.46142863,1.7260536,-0.70446968,-0.53717397,-0.45929669,1.7244751,-0.70446968,-0.53717397,-0.46356057,1.7260023,-0.70447993,-0.53717397,-0.46036266,1.7248441,-0.70446968,-0.53717397,-0.46570276,1.7240446,-0.70449018,-0.53717397,-0.46356057,1.7251926,-0.70447993,-0.53823994,-0.4624946,1.7240139,-0.70447993,-0.53717397,-0.46036266,1.7248031,-0.70446968,-0.536108,-0.46142863,1.7255411,-0.70446968,-0.53717397,-0.4624946,1.7251823,-0.70447993,-0.536108,-0.45929669,1.7256026,-0.70445943,-0.536108,-0.46462654,1.7263303,-0.70447993,-0.536108,-0.46142863,1.7264328,-0.70446968,-0.536108,-0.4624946,1.727222,-0.70446968,-0.536108,-0.46036266,1.7263098,-0.70446968,-0.536108,-0.46462654,1.7263611,-0.70447993,-0.53717397,-0.46142863,1.7224764,-0.70446968,-0.53717397,-0.46036266,1.7224457,-0.70445943,-0.53717397,-0.46462654,1.7233681,-0.70447993,-0.53717397,-0.46356057,1.7229889,-0.70447993,-0.53717397,-0.4624946,1.7233579,-0.70446968,-0.536108,-0.46036266,1.7243726,-0.70446968,-0.53717397,-0.45929669,1.7211644,-0.70445943,-0.53717397,-0.46356057,1.7214514,-0.70447993,-0.53717397,-0.46142863,1.7221177,-0.70446968,-0.53717397,-0.4624946,1.7216667,-0.70446968,-0.53717397,-0.46356057,1.720939,-0.70447993,-0.53717397,-0.46462654,1.7206212,-0.70447993,-0.53717397,-0.4624946,1.7213489,-0.70446968,-0.53717397,-0.45929669,1.7215642,-0.70445943,-0.53823994,-0.46462654,1.719914,-0.70447993,-0.53717397,-0.46142863,1.7219537,-0.70446968,-0.53823994,-0.46356057,1.7203035,-0.70447993,-0.53717397,-0.46142863,1.7214104,-0.70446968,-0.53717397,-0.4624946,1.7212362,-0.70446968,-0.53717397,-0.4624946,1.7218922,-0.70446968,-0.536108,-0.46036266,1.7240446,-0.70446968,-0.53717397,-0.46570276,1.7219434,-0.70447993,-0.536108,-0.46142863,1.7234296,-0.70446968,-0.53717397,-0.46462654,1.7232144,-0.70447993,-0.536108,-0.46142863,1.7234194,-0.70446968,-0.536108,-0.45929669,1.7236654,-0.70445943,-0.536108,-0.46462654,1.7228762,-0.70447993,-0.53717397,-0.46356057,1.7214924,-0.70447993,-0.53717397,-0.46462654,1.7220972,-0.70447993,-0.53717397,-0.46142863,1.7218204,-0.70446968,-0.53717397,-0.46036266,1.7227532,-0.70445943,-0.536108,-0.46462654,1.7262073,-0.70447993,-0.536108,-0.4624946,1.7281035,-0.70446968,-0.536108,-0.46356057,1.726812,-0.70447993,-0.536108,-0.46142863,1.7254078,-0.70446968,-0.536108,-0.45929669,1.7266583,-0.70445943,-0.53504203,-0.46462654,1.7272118,-0.70447993,-0.53504203,-0.4624946,1.7273143,-0.70446968,-0.53504203,-0.4624946,1.729313,-0.70446968,-0.53504203,-0.46036266,1.7274783,-0.70446968,-0.53504203,-0.45929669,1.7258793,-0.70445943,-0.53504203,-0.46462654,1.7261253,-0.70447993,-0.53504203,-0.4624946,1.7259306,-0.70446968,-0.536108,-0.46356057,1.7233579,-0.70446968,-0.536108,-0.46142863,1.7225277,-0.70446968,-0.536108,-0.46036266,1.7229889,-0.70445943,-0.536108,-0.46570276,1.7230811,-0.70447993,-0.53504203,-0.4624946,1.7244751,-0.70446968,-0.536108,-0.46356057,1.7236244,-0.70447993,-0.536108,-0.46142863,1.7239626,-0.70446968,-0.53504203,-0.45929669,1.7233476,-0.70445943,-0.536108,-0.46462654,1.7234809,-0.70447993,-0.536108,-0.46036266,1.7218819,-0.70445943,-0.536108,-0.46142863,1.7232144,-0.70446968,-0.536108,-0.4624946,1.7213489,-0.70446968,-0.536108,-0.46142863,1.7209492,-0.70446968,-0.53717397,-0.4624946,1.7203547,-0.70446968,-0.53717397,-0.46142863,1.7192683,-0.70446968,-0.54571197,-0.62038109,1.7219127,-0.70496167,-0.54571197,-0.62038109,1.7230811,-0.70496167,-0.54571197,-0.62038109,1.7210107,-0.70496167,-0.54571197,-0.62038109,1.7221894,-0.70496167,-0.54571197,-0.62038109,1.7239216,-0.70496167,-0.54571197,-0.62038109,1.7240344,-0.70496167,-0.54571197,-0.62038109,1.7229581,-0.70496167,-0.54571197,-0.62038109,1.7230811,-0.70496167,-0.54571197,-0.62038109,1.7214924,-0.70496167,-0.54571197,-0.62038109,1.7227429,-0.70496167,-0.54571197,-0.62038109,1.7234194,-0.70496167,-0.54571197,-0.62038109,1.7235731,-0.70496167,-0.54463575,-0.62038109,1.7248338,-0.70496167,-0.54463575,-0.62038109,1.7255513,-0.70496167,-0.54463575,-0.62038109,1.7247211,-0.70496167,-0.54571197,-0.62038109,1.7248953,-0.70496167,-0.54463575,-0.62038109,1.7253566,-0.70496167,-0.54463575,-0.62038109,1.7249876,-0.70496167,-0.54463575,-0.62038109,1.7245776,-0.70496167,-0.54463575,-0.62038109,1.7267403,-0.70496167,-0.54571197,-0.62038109,1.7253771,-0.70496167,-0.54463575,-0.62038109,1.7261561,-0.70496167,-0.54463575,-0.62038109,1.7257768,-0.70496167,-0.54463575,-0.62038109,1.7259306,-0.70496167,-0.54463575,-0.62038109,1.7264533,-0.70496167,-0.54571197,-0.62038109,1.7253258,-0.70496167,-0.54463575,-0.62038109,1.7272118,-0.70496167,-0.54463575,-0.62038109,1.7271195,-0.70496167,-0.54463575,-0.62038109,1.7263098,-0.70496167,-0.54571197,-0.62038109,1.7262176,-0.70496167,-0.54463575,-0.62038109,1.7272835,-0.70496167,-0.54463575,-0.62038109,1.727755,-0.70496167,-0.54463575,-0.62038109,1.7273553,-0.70496167,-0.54463575,-0.62038109,1.7276935,-0.70496167,-0.54463575,-0.62038109,1.7274578,-0.70496167,-0.54463575,-0.62038109,1.72755,-0.70496167,-0.54890988,-0.62144706,1.7162856,-0.70497192,-0.54890988,-0.62144706,1.7158551,-0.70497192,-0.54890988,-0.62144706,1.7164086,-0.70497192,-0.54890988,-0.62144706,1.7169006,-0.70497192,-0.54890988,-0.62144706,1.7146969,-0.70497192,-0.54890988,-0.62144706,1.7147584,-0.70497192,-0.54890988,-0.62144706,1.7155784,-0.70497192,-0.54890988,-0.62144706,1.7146149,-0.70497192,-0.54890988,-0.62144706,1.7147379,-0.70497192,-0.54890988,-0.62144706,1.7155681,-0.70497192,-0.54890988,-0.62144706,1.7159063,-0.70497192,-0.54890988,-0.62144706,1.7154759,-0.70497192,-0.54890988,-0.62144706,1.7155784,-0.70497192,-0.54037188,-0.56704161,1.7162651,-0.70482842,-0.54143785,-0.49557041,1.7161318,-0.70459268,-0.54037188,-0.45503282,1.7154041,-0.70444918,-0.54037188,-0.46570276,1.7169621,-0.70449018,-0.54143785,-0.4678347,1.7163676,-0.70450043,-0.53930591,-0.4624946,1.7175053,-0.70446968,-0.53930591,-0.46356057,1.7169006,-0.70447993,-0.53930591,-0.46570276,1.7164496,-0.70449018,-0.53930591,-0.46462654,1.7171978,-0.70447993,-0.54037188,-0.46570276,1.7167673,-0.70449018,-0.53930591,-0.46142863,1.7163471,-0.70446968,-0.54037188,-0.46356057,1.7156091,-0.70447993,-0.53930591,-0.46570276,1.7164188,-0.70449018,-0.53930591,-0.46462654,1.7171466,-0.70447993,-0.54037188,-0.46676873,1.7167776,-0.70449018,-0.53930591,-0.4624946,1.7178435,-0.70447993,-0.54037188,-0.46462654,1.7160703,-0.70449018,-0.53930591,-0.46142863,1.7176795,-0.70446968,-0.54037188,-0.4624946,1.7167468,-0.70447993,-0.54037188,-0.46462654,1.7164906,-0.70449018,-0.54250382,-0.46356057,1.7158449,-0.70449018,-0.54250382,-0.46676873,1.7164906,-0.70450043,-0.53930591,-0.46142863,1.7180588,-0.70446968,-0.53930591,-0.46356057,1.7185815,-0.70447993,-0.53930591,-0.46142863,1.7181613,-0.70446968,-0.53930591,-0.4624946,1.7188788,-0.70447993,-0.53930591,-0.46462654,1.7175873,-0.70447993,-0.54143785,-0.46570276,1.7129339,-0.70449018,-0.54143785,-0.4678347,1.7135387,-0.70450043,-0.54143785,-0.46356057,1.7144406,-0.70449018,-0.54143785,-0.46676873,1.7134874,-0.70450043,-0.54037188,-0.4624946,1.7143074,-0.70447993,-0.54037188,-0.46570276,1.7142561,-0.70449018,-0.54037188,-0.46036266,1.7150659,-0.70446968,-0.53930591,-0.4624946,1.7178025,-0.70447993,-0.54037188,-0.4624946,1.7194322,-0.70447993,-0.53930591,-0.4624946,1.7196065,-0.70447993,-0.53930591,-0.46462654,1.7193605,-0.70447993,-0.53930591,-0.46462654,1.7202112,-0.70447993,-0.53930591,-0.46356057,1.7202317,-0.70447993,-0.53930591,-0.46462654,1.7183868,-0.70447993,-0.53930591,-0.46356057,1.7185713,-0.70447993,-0.53930591,-0.46356057,1.719955,-0.70447993,-0.54250382,-0.46676873,1.7176385,-0.70450043,-0.53930591,-0.46356057,1.7197807,-0.70447993,-0.53930591,-0.46570276,1.718848,-0.70449018,-0.53930591,-0.4624946,1.7189813,-0.70447993,-0.53504203,-0.46462654,1.7329824,-0.70447993,-0.53504203,-0.46036266,1.7325519,-0.70446968,-0.53504203,-0.46356057,1.7334743,-0.70447993,-0.53397606,-0.46036266,1.7346223,-0.70446968,-0.53397606,-0.46356057,1.7342226,-0.70447993,-0.53397606,-0.46036266,1.7356268,-0.70446968,-0.53397606,-0.46356057,1.7340688,-0.70447993,-0.53397606,-0.46036266,1.7354935,-0.70446968,-0.53397606,-0.46356057,1.7358113,-0.70447993,-0.53291009,-0.46036266,1.7358215,-0.70446968,-0.53291009,-0.4624946,1.737933,-0.70446968,-0.53291009,-0.46036266,1.738179,-0.70446968,-0.53291009,-0.46462654,1.7380252,-0.70447993,-0.53397606,-0.46142863,1.7381482,-0.70446968,-0.53397606,-0.46142863,1.7371335,-0.70446968,-0.53291009,-0.46142863,1.7383327,-0.70446968,-0.53291009,-0.46142863,1.7389067,-0.70446968,-0.53291009,-0.46036266,1.7391219,-0.70446968,-0.53291009,-0.46142863,1.7393577,-0.70446968,-0.53291009,-0.46142863,1.7394192,-0.70446968,-0.53291009,-0.4624946,1.7388862,-0.70446968,-0.53291009,-0.45929669,1.7384045,-0.70445943,-0.53291009,-0.4624946,1.7387222,-0.70446968,-0.53291009,-0.46036266,1.7379125,-0.70446968,-0.53291009,-0.45823073,1.7372975,-0.70445943,-0.53504203,-0.4624946,1.7332489,-0.70446968,-0.53504203,-0.45929669,1.7320189,-0.70445943,-0.536108,-0.46570276,1.7272118,-0.70447993,-0.536108,-0.4624946,1.7224764,-0.70446968,-0.53291009,-0.46356057,1.7323981,-0.70446968,-0.53183387,-0.46142863,1.7343968,-0.70446968,-0.53183387,-0.46142863,1.7331976,-0.70445943,-0.53291009,-0.4624946,1.7298357,-0.70446968,-0.53397606,-0.46356057,1.7290567,-0.70446968,-0.53291009,-0.46036266,1.7320189,-0.70445943,-0.53717397,-0.46142863,1.720119,-0.70446968,-0.53717397,-0.46356057,1.71934,-0.70447993,-0.53823994,-0.46142863,1.718356,-0.70446968,-0.53717397,-0.46570276,1.7200062,-0.70447993,-0.53717397,-0.4624946,1.7198217,-0.70446968,-0.53717397,-0.46356057,1.720201,-0.70447993,-0.53717397,-0.46462654,1.7217794,-0.70447993,-0.536108,-0.46356057,1.7223534,-0.70446968,-0.536108,-0.4624946,1.7222714,-0.70446968,-0.536108,-0.4624946,1.7242599,-0.70446968,-0.536108,-0.4624946,1.7244239,-0.70446968,-0.536108,-0.46036266,1.7241471,-0.70446968,-0.536108,-0.46462654,1.7241574,-0.70447993,-0.536108,-0.4624946,1.7238396,-0.70446968,-0.53183387,-0.46036266,1.7361085,-0.70445943,-0.53183387,-0.4624946,1.73576,-0.70446968,-0.53183387,-0.4624946,1.7359445,-0.70446968,-0.53183387,-0.46036266,1.7361188,-0.70445943,-0.53183387,-0.45716476,1.735145,-0.70444918,-0.53183387,-0.46142863,1.7347863,-0.70446968,-0.53183387,-0.45929669,1.7345506,-0.70445943,-0.53291009,-0.46356057,1.7345916,-0.70447993,-0.53291009,-0.4624946,1.7346838,-0.70446968,-0.53183387,-0.46142863,1.7347248,-0.70446968,-0.53183387,-0.45929669,1.7349811,-0.70445943,-0.53183387,-0.45823073,1.7351143,-0.70445943,-0.53291009,-0.4624946,1.7317421,-0.70446968,-0.53291009,-0.46036266,1.7316089,-0.70445943,-0.53397606,-0.46142863,1.7308504,-0.70446968,-0.53291009,-0.4624946,1.7314039,-0.70446968,-0.53291009,-0.46356057,1.7315987,-0.70446968,-0.53291009,-0.46142863,1.7308197,-0.70445943,-0.53291009,-0.45823073,1.7313014,-0.70444918,-0.53291009,-0.46356057,1.7313117,-0.70446968,-0.53823994,-0.46036266,1.7286877,-0.70446968,-0.53397606,-0.46142863,1.7312297,-0.70446968,-0.53397606,-0.46036266,1.7306557,-0.70445943,-0.53291009,-0.46142863,1.7315884,-0.70445943,-0.53291009,-0.46142863,1.7327466,-0.70445943,-0.53291009,-0.45929669,1.7321419,-0.70445943,-0.53397606,-0.46462654,1.7303379,-0.70447993,-0.53291009,-0.4624946,1.7304609,-0.70446968,-0.53291009,-0.4624946,1.7304404,-0.70446968,-0.53291009,-0.46036266,1.729395,-0.70445943,-0.53397606,-0.45929669,1.7295282,-0.70445943,-0.53291009,-0.46356057,1.7308197,-0.70446968,-0.53291009,-0.46142863,1.7307684,-0.70445943,-0.53397606,-0.4624946,1.7305532,-0.70446968,-0.53397606,-0.46036266,1.7306352,-0.70445943,-0.53397606,-0.45929669,1.7280933,-0.70445943,-0.53291009,-0.4624946,1.7310349,-0.70446968,-0.53291009,-0.46142863,1.7326749,-0.70445943,-0.53291009,-0.46142863,1.7317626,-0.70445943,-0.53291009,-0.45929669,1.7326031,-0.70445943,-0.53291009,-0.45823073,1.7328696,-0.70444918,-0.53291009,-0.4624946,1.7330439,-0.70446968,-0.53291009,-0.46142863,1.7314757,-0.70445943,-0.53397606,-0.4624946,1.7309222,-0.70446968,-0.53291009,-0.45929669,1.7321931,-0.70445943,-0.53291009,-0.45823073,1.7319471,-0.70444918,-0.53291009,-0.4624946,1.7317729,-0.70446968,-0.53291009,-0.46036266,1.7328594,-0.70445943,-0.53291009,-0.46142863,1.7339253,-0.70446968,-0.53291009,-0.45929669,1.7330336,-0.70445943,-0.53183387,-0.45823073,1.7356473,-0.70444918,-0.53183387,-0.46142863,1.7354218,-0.70446968,-0.53183387,-0.45929669,1.7354935,-0.70445943,-0.53183387,-0.46036266,1.7372462,-0.70445943,-0.5307679,-0.45929669,1.7376562,-0.70445943,-0.53183387,-0.45716476,1.7372667,-0.70444918,-0.53183387,-0.4624946,1.7368158,-0.70446968,-0.53183387,-0.46036266,1.736498,-0.70445943,-0.53183387,-0.46142863,1.7355755,-0.70446968,-0.5307679,-0.45929669,1.7371847,-0.70445943,-0.53183387,-0.45716476,1.7371847,-0.70444918,-0.53291009,-0.4624946,1.7366313,-0.70446968,-0.53291009,-0.4624946,1.7366313,-0.70446968,-0.53291009,-0.4624946,1.7366313,-0.70446968,-0.53291009,-0.4624946,1.7366313,-0.70446968,-0.53291009,-0.4624946,1.7366313,-0.70446968,-0.53291009,-0.4624946,1.7366313,-0.70446968,-0.53291009,-0.4624946,1.7366313,-0.70446968:6
-0.56323211,-0.54042033,1.7222765,-0.60847999,-0.56323211,-0.54260133,1.7238523,-0.60849043,-0.56323211,-0.54260133,1.7277864,-0.60849043,-0.56323211,-0.54042033,1.7223809,-0.60847999,-0.56323211,-0.53933505,1.7242175,-0.60847999,-0.56323211,-0.54042033,1.7260959,-0.60847999,-0.56323211,-0.54151604,1.7269412,-0.60849043,-0.56431739,-0.54151604,1.7206486,-0.60849043,-0.56323211,-0.54042033,1.7251254,-0.60847999,-0.56323211,-0.54151604,1.7243741,-0.60849043,-0.56323211,-0.54151604,1.7275256,-0.60849043,-0.56323211,-0.54151604,1.7317519,-0.60849043,-0.56323211,-0.54042033,1.7305831,-0.60847999,-0.56214683,-0.54042033,1.7321276,-0.60847999,-0.56323211,-0.54042033,1.7233201,-0.60847999,-0.56323211,-0.54260133,1.7174763,-0.60849043,-0.56214683,-0.54042033,1.7219739,-0.60847999,-0.56323211,-0.54042033,1.7282978,-0.60847999,-0.56214683,-0.54151604,1.7334633,-0.60847999,-0.56214683,-0.54151604,1.7375435,-0.60847999,-0.56214683,-0.54042033,1.7377627,-0.60847999,-0.56323211,-0.54151604,1.7296335,-0.60849043,-0.56323211,-0.54151604,1.727943,-0.60849043,-0.56431739,-0.54042033,1.7234766,-0.60847999,-0.56323211,-0.54151604,1.7271499,-0.60849043,-0.56323211,-0.54151604,1.7235392,-0.60849043,-0.56323211,-0.54151604,1.7296231,-0.60849043,-0.56323211,-0.53933505,1.723341,-0.60847999,-0.56323211,-0.53933505,1.7312092,-0.60847999,-0.56214683,-0.54042033,1.7256367,-0.60847999,-0.56214683,-0.54260133,1.7324198,-0.60847999,-0.56214683,-0.54042033,1.7325241,-0.60847999,-0.56214683,-0.53933505,1.7388167,-0.60847999,-0.56431739,-0.57626592,1.7311362,-0.60860522,-0.56323211,-0.57626592,1.737387,-0.60860522,-0.56431739,-0.57626592,1.7329415,-0.60860522,-0.56323211,-0.57626592,1.7371157,-0.60860522,-0.56431739,-0.57626592,1.7312092,-0.60860522,-0.56323211,-0.57626592,1.7385245,-0.60860522,-0.56431739,-0.57626592,1.7332442,-0.60860522,-0.56431739,-0.57626592,1.7360095,-0.60860522,-0.56540267,-0.5773512,1.723007,-0.60860522,-0.56431739,-0.5773512,1.7278386,-0.60860522,-0.56540267,-0.5773512,1.7207321,-0.60860522,-0.56431739,-0.5773512,1.7287048,-0.60860522,-0.56540267,-0.5773512,1.724061,-0.60860522,-0.56431739,-0.5773512,1.7290178,-0.60860522,-0.56540267,-0.5773512,1.725115,-0.60860522,-0.56431739,-0.5773512,1.7297483,-0.60860522,-0.56540267,-0.5773512,1.7242071,-0.60860522,-0.56431739,-0.5773512,1.7311675,-0.60860522,-0.56431739,-0.5773512,1.7263464,-0.60860522,-0.56431739,-0.5773512,1.7310945,-0.60860522,-0.56431739,-0.5773512,1.7265864,-0.60860522,-0.56431739,-0.5773512,1.7285795,-0.60860522,-0.56431739,-0.5773512,1.7240923,-0.60860522,-0.56431739,-0.5773512,1.7294561,-0.60860522,-0.56540267,-0.5773512,1.7239566,-0.60860522,-0.56431739,-0.5773512,1.724948,-0.60860522,-0.56540267,-0.5773512,1.7213687,-0.60860522,-0.56431739,-0.5773512,1.7256159,-0.60860522,-0.56431739,-0.5773512,1.7254176,-0.60860522,-0.56648795,-0.57843648,1.6975342,-0.60861565,-0.56757323,-0.57843648,1.6877667,-0.60861565,-0.56431739,-0.57843648,1.7241967,-0.60860522,-0.56540267,-0.5773512,1.7169649,-0.60860522,-0.56431739,-0.5773512,1.7244367,-0.60860522,-0.56648795,-0.5773512,1.7080322,-0.60861565,-0.56540267,-0.5773512,1.7156605,-0.60860522,-0.56648795,-0.5773512,1.7090966,-0.60861565,-0.56431739,-0.5773512,1.7232783,-0.60860522,-0.56540267,-0.5773512,1.7167354,-0.60860522,-0.56431739,-0.5773512,1.7253341,-0.60860522,-0.56648795,-0.5773512,1.7084183,-0.60861565,-0.56540267,-0.5773512,1.7142204,-0.60860522,-0.56540267,-0.5773512,1.720106,-0.60860522,-0.56540267,-0.57843648,1.7119664,-0.60860522,-0.56648795,-0.5773512,1.708554,-0.60861565,-0.56540267,-0.5773512,1.7194799,-0.60860522,-0.56540267,-0.5773512,1.7181754,-0.60860522,-0.56540267,-0.5773512,1.7175284,-0.60860522,-0.56540267,-0.5773512,1.7161301,-0.60860522,-0.56540267,-0.5773512,1.716224,-0.60860522,-0.56540267,-0.5773512,1.7148987,-0.60860522,-0.56540267,-0.5773512,1.7194903,-0.60860522,-0.56540267,-0.5773512,1.7164014,-0.60860522,-0.56540267,-0.5773512,1.7198242,-0.60860522,-0.56540267,-0.5773512,1.7182902,-0.60860522,-0.56540267,-0.5773512,1.7177163,-0.60860522,-0.56540267,-0.5773512,1.7220783,-0.60860522,-0.56540267,-0.5773512,1.7183633,-0.60860522,-0.56540267,-0.5773512,1.7173615,-0.60860522,-0.56540267,-0.5773512,1.7197094,-0.60860522,-0.56540267,-0.5773512,1.7197929,-0.60860522,-0.56540267,-0.5773512,1.7155979,-0.60860522,-0.56540267,-0.5773512,1.7130517,-0.60860522,-0.56540267,-0.5773512,1.7149092,-0.60860522,-0.56431739,-0.56757323,1.7163492,-0.60855304,-0.56648795,-0.59147029,1.7164327,-0.60864696,-0.56648795,-0.59147029,1.7154518,-0.60864696,-0.56648795,-0.59147029,1.7165684,-0.60864696,-0.56648795,-0.59147029,1.7148465,-0.60864696,-0.56648795,-0.59255558,1.7137404,-0.60864696,-0.56648795,-0.59255558,1.7138239,-0.60864696,-0.56648795,-0.59255558,1.7148779,-0.60864696,-0.56648795,-0.59255558,1.7143143,-0.60864696,-0.56540267,-0.59255558,1.7211182,-0.60864696,-0.56648795,-0.59255558,1.717998,-0.60864696,-0.56540267,-0.59364086,1.7209721,-0.60864696,-0.56648795,-0.59364086,1.7190938,-0.60864696,-0.56648795,-0.59364086,1.717518,-0.60864696,-0.56648795,-0.59364086,1.716704,-0.60864696,-0.56648795,-0.59364086,1.7145126,-0.60864696,-0.56648795,-0.59364086,1.7159944,-0.60864696,-0.56648795,-0.59364086,1.7119142,-0.60864696,-0.56648795,-0.59364086,1.7138969,-0.60864696,-0.56648795,-0.59364086,1.709368,-0.60864696,-0.56648795,-0.59364086,1.7123838,-0.60864696,-0.56757323,-0.59364086,1.7014162,-0.60864696,-0.56757323,-0.59364086,1.6985256,-0.60864696,-0.56540267,-0.59364086,1.7301135,-0.60864696,-0.56648795,-0.59364086,1.7125925,-0.60864696,-0.56648795,-0.59364086,1.7148361,-0.60864696,-0.56540267,-0.59364086,1.7199181,-0.60864696,-0.56648795,-0.59364086,1.7157962,-0.60864696,-0.56540267,-0.59364086,1.7218278,-0.60864696,-0.56648795,-0.59364086,1.7153996,-0.60864696,-0.56648795,-0.59364086,1.7208678,-0.60864696,-0.56540267,-0.59364086,1.7205025,-0.60864696,-0.56540267,-0.59364086,1.7241758,-0.60864696,-0.56648795,-0.59364086,1.7180293,-0.60864696,-0.56540267,-0.59364086,1.7232575,-0.60864696,-0.56648795,-0.59364086,1.7182276,-0.60864696,-0.56540267,-0.59364086,1.7236853,-0.60864696,-0.56648795,-0.59364086,1.7193546,-0.60864696,-0.56540267,-0.59364086,1.7251985,-0.60864696,-0.56648795,-0.59364086,1.7173093,-0.60864696,-0.56540267,-0.59364086,1.7227983,-0.60864696,-0.56648795,-0.59364086,1.7196573,-0.60864696,-0.56540267,-0.59364086,1.7230905,-0.60864696,-0.56648795,-0.59364086,1.7171319,-0.60864696,-0.56540267,-0.59364086,1.7213478,-0.60864696,-0.56648795,-0.59364086,1.7167875,-0.60864696,-0.56540267,-0.59364086,1.7201373,-0.60864696,-0.56648795,-0.59364086,1.7125195,-0.60864696,-0.56540267,-0.59364086,1.7207739,-0.60864696,-0.56648795,-0.59364086,1.7169441,-0.60864696,-0.56540267,-0.59364086,1.7214313,-0.60864696,-0.56648795,-0.59364086,1.7152013,-0.60864696,-0.56540267,-0.59364086,1.7211704,-0.60864696,-0.56648795,-0.59364086,1.7144396,-0.60864696,-0.56648795,-0.59364086,1.7192816,-0.60864696,-0.56648795,-0.59364086,1.7145335,-0.60864696,-0.56540267,-0.59364086,1.7213061,-0.60864696,-0.56648795,-0.59364086,1.7188955,-0.60864696,-0.56648795,-0.59364086,1.7139804,-0.60864696,-0.56648795,-0.59364086,1.7203251,-0.60864696,-0.56648795,-0.59364086,1.7160571,-0.60864696,-0.56540267,-0.59364086,1.7211391,-0.60864696,-0.56648795,-0.59364086,1.7135943,-0.60864696,-0.56648795,-0.59364086,1.7200747,-0.60864696,-0.56648795,-0.59364086,1.7121542,-0.60864696,-0.56648795,-0.59364086,1.7184572,-0.60864696,-0.56648795,-0.59364086,1.7136152,-0.60864696,-0.56540267,-0.59364086,1.7189998,-0.60864696,-0.56648795,-0.59364086,1.7113716,-0.60864696,-0.56648795,-0.59364086,1.7134482,-0.60864696,-0.56757323,-0.59364086,1.7070304,-0.60864696,-0.56648795,-0.59364086,1.7113089,-0.60864696,-0.56757323,-0.59364086,1.7046199,-0.60864696,-0.56431739,-0.59255558,1.740288,-0.60863652,-0.56540267,-0.59364086,1.7219009,-0.60864696,-0.56540267,-0.59364086,1.7278386,-0.60864696,-0.56540267,-0.59364086,1.7261794,-0.60864696,-0.56431739,-0.59255558,1.7421977,-0.60863652,-0.56431739,-0.59364086,1.7370009,-0.60863652,-0.56431739,-0.59255558,1.7428134,-0.60863652,-0.56431739,-0.59364086,1.737627,-0.60863652,-0.56431739,-0.59255558,1.7436274,-0.60863652,-0.56431739,-0.59255558,1.7390567,-0.60863652,-0.56323211,-0.59255558,1.7442118,-0.60863652,-0.56431739,-0.59364086,1.7355086,-0.60863652,-0.56431739,-0.59255558,1.7413525,-0.60863652,-0.56431739,-0.59364086,1.7373766,-0.60863652,-0.56431739,-0.59255558,1.7420412,-0.60863652,-0.56214683,-0.55672042,1.7374809,-0.6085426,-0.56323211,-0.56975423,1.7390254,-0.60858435,-0.56214683,-0.54042033,1.7326911,-0.60847999,-0.56214683,-0.54042033,1.7385349,-0.60847999,-0.56214683,-0.53933505,1.7320754,-0.60847999,-0.56214683,-0.54042033,1.7372618,-0.60847999,-0.56214683,-0.54151604,1.7327746,-0.60847999,-0.56214683,-0.54042033,1.7386914,-0.60847999,-0.56214683,-0.54042033,1.7336198,-0.60847999,-0.56106154,-0.53716448,1.7383366,-0.60846956,-0.56214683,-0.53824976,1.7349243,-0.60846956,-0.56106154,-0.53933505,1.7425212,-0.60847999,-0.56214683,-0.53933505,1.7363435,-0.60847999,-0.56214683,-0.54042033,1.7402046,-0.60847999,-0.56214683,-0.53933505,1.7332546,-0.60847999,-0.56106154,-0.53933505,1.7412272,-0.60847999,-0.56214683,-0.53933505,1.7329207,-0.60847999,-0.56214683,-0.54042033,1.7404341,-0.60847999,-0.56214683,-0.54151604,1.7336616,-0.60847999,-0.56214683,-0.53824976,1.7390358,-0.60846956,-0.56214683,-0.53933505,1.7337868,-0.60847999,-0.56214683,-0.54042033,1.7313136,-0.60847999,-0.56323211,-0.53933505,1.7205651,-0.60847999,-0.56214683,-0.54151604,1.7279221,-0.60847999,-0.56323211,-0.54042033,1.721233,-0.60847999,-0.56323211,-0.54151604,1.7256054,-0.60849043,-0.56323211,-0.54260133,1.7192398,-0.60849043,-0.56214683,-0.53933505,1.7357486,-0.60847999,-0.56323211,-0.54042033,1.7276925,-0.60847999,-0.56214683,-0.53933505,1.7359052,-0.60847999,-0.56214683,-0.54042033,1.7299257,-0.60847999,-0.56214683,-0.54042033,1.7366983,-0.60847999,-0.56214683,-0.54151604,1.7301031,-0.60847999,-0.56214683,-0.53933505,1.7338703,-0.60847999,-0.56214683,-0.53933505,1.7306666,-0.60847999,-0.56214683,-0.53933505,1.7349451,-0.60847999,-0.56214683,-0.54042033,1.7298213,-0.60847999,-0.56214683,-0.54151604,1.7307083,-0.60847999,-0.56323211,-0.54260133,1.7232366,-0.60849043,-0.56214683,-0.53933505,1.7306562,-0.60847999,-0.56431739,-0.54151604,1.7105159,-0.60849043,-0.56323211,-0.54042033,1.7192398,-0.60847999,-0.56214683,-0.53933505,1.7351121,-0.60847999,-0.56214683,-0.54151604,1.7400689,-0.60849043,-0.56214683,-0.53824976,1.7330459,-0.60846956,-0.56214683,-0.54042033,1.7419786,-0.60847999,-0.56214683,-0.54042033,1.7374079,-0.60847999,-0.56214683,-0.54151604,1.7418429,-0.60849043,-0.56214683,-0.53824976,1.7368339,-0.60846956,-0.56106154,-0.54042033,1.7429804,-0.60847999,-0.56214683,-0.53933505,1.7385975,-0.60847999,-0.56106154,-0.53933505,1.7428134,-0.60847999,-0.56214683,-0.54151604,1.7377835,-0.60847999,-0.56106154,-0.53824976,1.7433978,-0.60846956,-0.56106154,-0.54042033,1.739088,-0.60847999,-0.56106154,-0.53933505,1.7431891,-0.60847999,-0.56106154,-0.54151604,1.7399228,-0.60847999,-0.56106154,-0.53933505,1.7434187,-0.60847999,-0.56214683,-0.54042033,1.7381697,-0.60847999,-0.56106154,-0.54042033,1.7438048,-0.60847999,-0.56214683,-0.54151604,1.7356965,-0.60847999,-0.56106154,-0.54042033,1.740288,-0.60847999,-0.56214683,-0.54042033,1.7349556,-0.60847999,-0.56106154,-0.53933505,1.7401837,-0.60847999,-0.56214683,-0.54151604,1.7359052,-0.60847999,-0.56106154,-0.54042033,1.7421769,-0.60847999,-0.56214683,-0.54042033,1.7372513,-0.60847999,-0.56214683,-0.54042033,1.7416968,-0.60847999,-0.56214683,-0.54151604,1.7366357,-0.60847999,-0.56106154,-0.53933505,1.7430639,-0.60847999,-0.56106154,-0.54042033,1.7410707,-0.60847999,-0.56106154,-0.54042033,1.7447231,-0.60847999,-0.56214683,-0.54151604,1.7402359,-0.60849043,-0.56106154,-0.53933505,1.7488451,-0.60847999,-0.56106154,-0.53824976,1.7450883,-0.60846956,-0.56106154,-0.53933505,1.7496277,-0.60847999,-0.56106154,-0.54151604,1.7434291,-0.60847999,-0.56106154,-0.53933505,1.7503165,-0.60847999,-0.56106154,-0.53933505,1.7444726,-0.60847999,-0.56106154,-0.53933505,1.7488138,-0.60847999,-0.56106154,-0.54151604,1.7443265,-0.60847999,-0.56106154,-0.54042033,1.7474676,-0.60847999,-0.56106154,-0.54042033,1.742156,-0.60847999,-0.56106154,-0.54151604,1.7490955,-0.60847999,-0.56106154,-0.53824976,1.7440761,-0.60846956,-0.56106154,-0.54042033,1.7498573,-0.60847999,-0.56106154,-0.54042033,1.7445248,-0.60847999,-0.56106154,-0.54151604,1.7499304,-0.60849043,-0.56106154,-0.54042033,1.7454744,-0.60847999,-0.56106154,-0.54042033,1.7499825,-0.60847999,-0.56106154,-0.54151604,1.7447857,-0.60847999,-0.56106154,-0.53933505,1.7491373,-0.60847999,-0.56214683,-0.54042033,1.7347573,-0.60847999,-0.56214683,-0.54151604,1.7374809,-0.60847999,-0.56214683,-0.54042033,1.7351851,-0.60847999,-0.56106154,-0.53933505,1.7500869,-0.60847999,-0.56106154,-0.54151604,1.7482398,-0.60847999,-0.55997626,-0.53824976,1.7556385,-0.60846956,-0.56106154,-0.53933505,1.747645,-0.60847999,-0.55997626,-0.54042033,1.7553568,-0.60847999,-0.56106154,-0.54042033,1.7479372,-0.60847999,-0.55997626,-0.53933505,1.7549393,-0.60847999,-0.56106154,-0.54151604,1.7473424,-0.60847999,-0.55997626,-0.54151604,1.7555133,-0.60847999,-0.56106154,-0.54042033,1.7514539,-0.60847999,-0.55997626,-0.53933505,1.7556072,-0.60847999,-0.56106154,-0.54151604,1.7520279,-0.60849043,-0.55997626,-0.53933505,1.7549915,-0.60847999,-0.56106154,-0.53933505,1.7498051,-0.60847999,-0.55997626,-0.54151604,1.7582369,-0.60847999,-0.55997626,-0.53933505,1.7535201,-0.60847999,-0.55997626,-0.54042033,1.7578926,-0.60847999,-0.55997626,-0.54151604,1.7554194,-0.60847999,-0.55997626,-0.53933505,1.7572977,-0.60847999,-0.55997626,-0.54042033,1.753541,-0.60847999,-0.55997626,-0.54151604,1.7571308,-0.60847999,-0.56106154,-0.53933505,1.751527,-0.60847999,-0.56106154,-0.54042033,1.7547619,-0.60847999,-0.56106154,-0.54151604,1.7503791,-0.60849043,-0.55997626,-0.53933505,1.7581326,-0.60847999,-0.56106154,-0.54042033,1.7495129,-0.60847999,-0.55997626,-0.53933505,1.7565464,-0.60847999,-0.56106154,-0.53933505,1.7505773,-0.60847999,-0.56106154,-0.54151604,1.7554924,-0.60849043,-0.55997626,-0.53933505,1.752247,-0.60847999,-0.56106154,-0.54042033,1.7537601,-0.60847999,-0.56106154,-0.54151604,1.7510678,-0.60849043,-0.56106154,-0.54042033,1.7538436,-0.60847999,-0.56106154,-0.53933505,1.7476346,-0.60847999,-0.56106154,-0.54042033,1.7559307,-0.60847999,-0.56106154,-0.54042033,1.7504208,-0.60847999,-0.55997626,-0.53933505,1.7572038,-0.60847999,-0.56106154,-0.53824976,1.7497112,-0.60846956,-0.56106154,-0.53933505,1.7536349,-0.60847999,-0.56214683,-0.54151604,1.7349034,-0.60847999,-0.56214683,-0.54151604,1.7400376,-0.60849043,-0.56214683,-0.54042033,1.7333485,-0.60847999,-0.56214683,-0.54260133,1.7351121,-0.60849043,-0.56214683,-0.54042033,1.734152,-0.60847999,-0.56214683,-0.54151604,1.7384305,-0.60847999,-0.56214683,-0.54042033,1.7357069,-0.60847999,-0.56214683,-0.54042033,1.7379088,-0.60847999,-0.56214683,-0.54151604,1.7326076,-0.60847999,-0.56214683,-0.54042033,1.7392445,-0.60847999,-0.56214683,-0.54151604,1.7303744,-0.60847999,-0.56214683,-0.54151604,1.7385036,-0.60847999,-0.56323211,-0.54151604,1.7222139,-0.60849043,-0.56323211,-0.54151604,1.7281517,-0.60849043,-0.56323211,-0.53933505,1.7221096,-0.60847999,-0.56214683,-0.54042033,1.7365313,-0.60847999,-0.56214683,-0.54151604,1.7322632,-0.60847999,-0.56214683,-0.53933505,1.7341729,-0.60847999,-0.56106154,-0.53933505,1.7504834,-0.60847999,-0.56106154,-0.54042033,1.7532906,-0.60847999,-0.56106154,-0.53933505,1.7505669,-0.60847999,-0.56106154,-0.54042033,1.7534262,-0.60847999,-0.56106154,-0.53933505,1.7496382,-0.60847999,-0.56106154,-0.53933505,1.756442,-0.60847999,-0.56106154,-0.54042033,1.750066,-0.60847999,-0.55997626,-0.54042033,1.7562333,-0.60847999,-0.56106154,-0.53933505,1.7516522,-0.60847999,-0.55997626,-0.53824976,1.7559411,-0.60846956,-0.55997626,-0.53824976,1.7680566,-0.60846956,-0.56106154,-0.54151604,1.7541671,-0.60849043,-0.56214683,-0.54042033,1.7308544,-0.60847999,-0.56214683,-0.54042033,1.7316162,-0.60847999,-0.56214683,-0.53933505,1.7320441,-0.60847999,-0.56214683,-0.53933505,1.7383262,-0.60847999,-0.56214683,-0.54260133,1.7307814,-0.60849043,-0.56214683,-0.54151604,1.7354982,-0.60847999,-0.56214683,-0.54042033,1.7314806,-0.60847999,-0.56214683,-0.53933505,1.7382949,-0.60847999,-0.56214683,-0.54042033,1.7340372,-0.60847999,-0.56214683,-0.54042033,1.7340372,-0.60847999,-0.56214683,-0.54042033,1.7340372,-0.60847999,-0.56214683,-0.54042033,1.7340372,-0.60847999,-0.56214683,-0.54042033,1.7340372,-0.60847999,-0.56214683,-0.54042033,1.7340372,-0.60847999,-0.56214683,-0.54042033,1.7340372,-0.60847999,-0.56214683,-0.54042033,1.7340372,-0.60847999:6
-0.54100004,-0.5796522,1.7117459,-0.61688917,-0.54100004,-0.5796522,1.7130808,-0.61688917,-0.54100004,-0.5796522,1.7097385,-0.61688917,-0.54100004,-0.5796522,1.7127997,-0.61688917,-0.54100004,-0.5796522,1.712589,-0.61688917,-0.54100004,-0.5796522,1.710682,-0.61688917,-0.54204388,-0.5796522,1.7066572,-0.61688917,-0.54204388,-0.5796522,1.7054527,-0.61688917,-0.54204388,-0.5796522,1.7062456,-0.61688917,-0.54204388,-0.5796522,1.706607,-0.61688917,-0.54204388,-0.5796522,1.7069984,-0.61688917,-0.54204388,-0.5796522,1.7035256,-0.61688917,-0.54204388,-0.5796522,1.7052018,-0.61688917,-0.54100004,-0.5796522,1.7112139,-0.61688917,-0.54100004,-0.5796522,1.7113344,-0.61688917,-0.5399562,-0.5796522,1.7151584,-0.61688917,-0.54100004,-0.5796522,1.709347,-0.61688917,-0.54204388,-0.5796522,1.707159,-0.61688917,-0.54100004,-0.5796522,1.7093772,-0.61688917,-0.54100004,-0.5796522,1.7121273,-0.61688917,-0.54100004,-0.5796522,1.7135425,-0.61688917,-0.54100004,-0.5796522,1.7094775,-0.61688917,-0.54204388,-0.5796522,1.7079419,-0.61688917,-0.54100004,-0.5796522,1.7086344,-0.61688917,-0.54100004,-0.5796522,1.7134321,-0.61688917,-0.5399562,-0.5796522,1.7145562,-0.61688917,-0.54100004,-0.5796522,1.7142752,-0.61688917,-0.5399562,-0.5796522,1.7167443,-0.61688917,-0.5399562,-0.57860837,1.7173866,-0.61687913,-0.5399562,-0.5796522,1.7156803,-0.61688917,-0.5399562,-0.57860837,1.7171357,-0.61687913,-0.5399562,-0.5796522,1.7157606,-0.61688917,-0.5399562,-0.5796522,1.7146767,-0.61688917,-0.5399562,-0.57860837,1.7163327,-0.61687913,-0.5399562,-0.5796522,1.7150681,-0.61688917,-0.54100004,-0.5796522,1.7126291,-0.61688917,-0.54100004,-0.5796522,1.7097686,-0.61688917,-0.54100004,-0.5796522,1.7110031,-0.61688917,-0.54100004,-0.5796522,1.711505,-0.61688917,-0.54100004,-0.5796522,1.7108124,-0.61688917,-0.54100004,-0.5796522,1.7102504,-0.61688917,-0.54100004,-0.5796522,1.7117559,-0.61688917,-0.54100004,-0.5796522,1.7106117,-0.61688917,-0.54100004,-0.5796522,1.7091764,-0.61688917,-0.54204388,-0.5796522,1.7082731,-0.61688917,-0.54100004,-0.5796522,1.7088352,-0.61688917,-0.54100004,-0.5796522,1.712057,-0.61688917,-0.5399562,-0.5796522,1.7149175,-0.61688917,-0.54100004,-0.5796522,1.7126392,-0.61688917,-0.54100004,-0.5796522,1.7128499,-0.61688917,-0.5399562,-0.5796522,1.7150781,-0.61688917,-0.5399562,-0.5796522,1.7159212,-0.61688917,-0.5399562,-0.57860837,1.7207088,-0.61687913,-0.5399562,-0.57860837,1.7202271,-0.61687913,-0.53891236,-0.57860837,1.7226861,-0.61687913,-0.53891236,-0.57860837,1.7226259,-0.61687913,-0.53891236,-0.57860837,1.7243723,-0.61687913,-0.53891236,-0.57860837,1.723469,-0.61687913,-0.53891236,-0.57860837,1.7213913,-0.61687913,-0.53891236,-0.57860837,1.721562,-0.61687913,-0.53891236,-0.57860837,1.7216222,-0.61687913,-0.53785848,-0.57860837,1.7291599,-0.61687913,-0.53785848,-0.57860837,1.7286982,-0.61687913,-0.53891236,-0.57860837,1.7235493,-0.61687913,-0.53785848,-0.57860837,1.7287886,-0.61687913,-0.53891236,-0.57860837,1.7232381,-0.61687913,-0.53891236,-0.57860837,1.7216122,-0.61687913,-0.53891236,-0.57860837,1.7225155,-0.61687913,-0.53891236,-0.57860837,1.722395,-0.61687913,-0.53891236,-0.57860837,1.72374,-0.61687913,-0.53891236,-0.57860837,1.7261288,-0.61687913,-0.53891236,-0.57860837,1.7244426,-0.61687913,-0.53891236,-0.57860837,1.7239809,-0.61687913,-0.53891236,-0.57860837,1.7228166,-0.61687913,-0.5399562,-0.57860837,1.720478,-0.61687913,-0.5399562,-0.57860837,1.7195245,-0.61687913,-0.5399562,-0.57860837,1.7197654,-0.61687913,-0.5399562,-0.57860837,1.7175271,-0.61687913,-0.5399562,-0.5796522,1.7165636,-0.61688917,-0.5399562,-0.57860837,1.719655,-0.61687913,-0.5399562,-0.5796522,1.7206386,-0.61688917,-0.54100004,-0.5796522,1.7147369,-0.61688917,-0.54100004,-0.5796522,1.7126191,-0.61688917,-0.54100004,-0.5796522,1.7132614,-0.61688917,-0.5399562,-0.5796522,1.7165536,-0.61688917,-0.5399562,-0.57860837,1.7170353,-0.61687913,-0.5399562,-0.5796522,1.7179989,-0.61688917,-0.5399562,-0.57860837,1.7165435,-0.61687913,-0.5399562,-0.57860837,1.716684,-0.61687913,-0.5399562,-0.5796522,1.7145964,-0.61688917,-0.5399562,-0.5796522,1.7156201,-0.61688917,-0.5399562,-0.57860837,1.7191029,-0.61687913,-0.5399562,-0.57860837,1.7202873,-0.61687913,-0.5399562,-0.57860837,1.7175874,-0.61687913,-0.5399562,-0.57860837,1.7175171,-0.61687913,-0.5399562,-0.57860837,1.7177981,-0.61687913,-0.5399562,-0.57860837,1.7179688,-0.61687913,-0.5399562,-0.57860837,1.7175071,-0.61687913,-0.5399562,-0.57860837,1.7190829,-0.61687913,-0.53891236,-0.57860837,1.7223147,-0.61687913,-0.53891236,-0.57860837,1.7245831,-0.61687913,-0.53891236,-0.57860837,1.7233285,-0.61687913,-0.53891236,-0.57860837,1.72374,-0.61687913,-0.5399562,-0.57860837,1.7213211,-0.61687913,-0.5399562,-0.57860837,1.7202672,-0.61687913,-0.5399562,-0.5796522,1.7201869,-0.61688917,-0.53891236,-0.57860837,1.7242218,-0.61687913,-0.53891236,-0.57860837,1.7246433,-0.61687913,-0.53891236,-0.57860837,1.7256169,-0.61687913,-0.53891236,-0.57860837,1.7255767,-0.61687913,-0.53891236,-0.57860837,1.7252054,-0.61687913,-0.53785848,-0.57860837,1.7274436,-0.61687913,-0.53891236,-0.57860837,1.7266607,-0.61687913,-0.53891236,-0.57860837,1.725386,-0.61687913,-0.53785848,-0.57860837,1.7278451,-0.61687913,-0.53785848,-0.57860837,1.7270923,-0.61687913,-0.53891236,-0.57860837,1.7270421,-0.61687913,-0.53785848,-0.57860837,1.7270923,-0.61687913,-0.53785848,-0.57860837,1.7290194,-0.61687913,-0.53891236,-0.57860837,1.7243422,-0.61687913,-0.53785848,-0.57860837,1.7284272,-0.61687913,-0.53785848,-0.57860837,1.7272931,-0.61687913,-0.53785848,-0.57860837,1.7270722,-0.61687913,-0.53785848,-0.57860837,1.72646,-0.61687913,-0.53785848,-0.57860837,1.7262392,-0.61687913,-0.53785848,-0.57860837,1.7278953,-0.61687913,-0.53785848,-0.57860837,1.7271525,-0.61687913,-0.53891236,-0.57860837,1.7246032,-0.61687913,-0.53785848,-0.57860837,1.7262191,-0.61687913,-0.53785848,-0.57860837,1.7266206,-0.61687913,-0.53785848,-0.57860837,1.7265001,-0.61687913,-0.53785848,-0.57860837,1.7256269,-0.61687913,-0.53785848,-0.57860837,1.7275841,-0.61687913,-0.53785848,-0.57860837,1.7260384,-0.61687913,-0.53785848,-0.57860837,1.7268213,-0.61687913,-0.53785848,-0.57860837,1.7295112,-0.61687913,-0.5357708,-0.57860837,1.7382734,-0.61686909,-0.5357708,-0.57860837,1.7394779,-0.61686909,-0.53472696,-0.57755449,1.741967,-0.61686909,-0.53472696,-0.57860837,1.7416358,-0.61686909,-0.5357708,-0.57860837,1.7377917,-0.61686909,-0.5357708,-0.57860837,1.7399095,-0.61686909,-0.5357708,-0.57860837,1.7392872,-0.61686909,-0.53681464,-0.57860837,1.734901,-0.61687913,-0.5357708,-0.57860837,1.7387753,-0.61686909,-0.5357708,-0.57860837,1.7382935,-0.61686909,-0.5357708,-0.57860837,1.7379422,-0.61686909,-0.5357708,-0.57860837,1.7369285,-0.61686909,-0.5357708,-0.57860837,1.7375809,-0.61686909,-0.53681464,-0.57860837,1.7350616,-0.61687913,-0.53681464,-0.57860837,1.734901,-0.61687913,-0.53681464,-0.57860837,1.7348308,-0.61687913,-0.53681464,-0.57860837,1.7316792,-0.61687913,-0.53681464,-0.57442297,1.7332449,-0.61686909,-0.53681464,-0.57442297,1.732432,-0.61686909,-0.53681464,-0.57546681,1.7312576,-0.61686909,-0.53785848,-0.57546681,1.7271124,-0.61686909,-0.53785848,-0.57546681,1.7303342,-0.61686909,-0.53785848,-0.57546681,1.7308562,-0.61686909,-0.53785848,-0.57442297,1.7312175,-0.61686909,-0.53785848,-0.57442297,1.7307658,-0.61686909,-0.53681464,-0.57442297,1.7335762,-0.61686909,-0.53785848,-0.57442297,1.7318799,-0.61686909,-0.53785848,-0.57442297,1.7308762,-0.61686909,-0.53785848,-0.57546681,1.728377,-0.61686909,-0.53681464,-0.57442297,1.7331245,-0.61686909,-0.53681464,-0.57442297,1.733536,-0.61686909,-0.53681464,-0.57442297,1.7325925,-0.61686909,-0.53785848,-0.57755449,1.7297421,-0.61687913,-0.53785848,-0.57755449,1.7273232,-0.61687913,-0.53785848,-0.57755449,1.7319502,-0.61687913,-0.53785848,-0.57755449,1.7298725,-0.61687913,-0.53681464,-0.57755449,1.731348,-0.61686909,-0.53785848,-0.57755449,1.7298424,-0.61687913,-0.5357708,-0.57755449,1.7365772,-0.61686909,-0.53681464,-0.56502842,1.7338672,-0.61684902,-0.53681464,-0.56502842,1.7335461,-0.61684902,-0.53681464,-0.56502842,1.7346401,-0.61684902,-0.53681464,-0.56502842,1.734078,-0.61684902,-0.53681464,-0.56502842,1.7347706,-0.61684902,-0.53681464,-0.56502842,1.7338271,-0.61684902,-0.53681464,-0.56502842,1.7347906,-0.61684902,-0.53785848,-0.56502842,1.727273,-0.61684902,-0.53785848,-0.56502842,1.7264801,-0.61684902,-0.53785848,-0.56502842,1.7305852,-0.61684902,-0.53681464,-0.56502842,1.731639,-0.61684902,-0.53681464,-0.56502842,1.7322513,-0.61684902,-0.53681464,-0.56502842,1.7328334,-0.61684902,-0.53785848,-0.56502842,1.732161,-0.61684902,-0.53681464,-0.56502842,1.7326126,-0.61684902,-0.53681464,-0.56502842,1.732703,-0.61684902,-0.53681464,-0.56502842,1.7344795,-0.61684902,-0.53681464,-0.56502842,1.7328937,-0.61684902,-0.53681464,-0.56502842,1.7322011,-0.61684902,-0.53785848,-0.56502842,1.7310669,-0.61684902,-0.53681464,-0.56502842,1.7327833,-0.61684902,-0.53681464,-0.56502842,1.7331345,-0.61684902,-0.53681464,-0.56502842,1.7328736,-0.61684902,-0.53681464,-0.56502842,1.7357241,-0.61684902,-0.53681464,-0.56502842,1.7346401,-0.61684902,-0.53681464,-0.56502842,1.7337468,-0.61684902,-0.53681464,-0.56502842,1.7336765,-0.61684902,-0.53681464,-0.56502842,1.7356036,-0.61684902,-0.5357708,-0.56502842,1.7391165,-0.61683898,-0.53681464,-0.56502842,1.7376913,-0.61684902,-0.5357708,-0.56502842,1.7385344,-0.61683898,-0.53681464,-0.56502842,1.732984,-0.61684902,-0.53681464,-0.56502842,1.73463,-0.61684902,-0.53681464,-0.56502842,1.7369285,-0.61684902,-0.5357708,-0.56502842,1.7390563,-0.61683898,-0.53681464,-0.56502842,1.7371895,-0.61684902,-0.53681464,-0.56502842,1.7383939,-0.61684902,-0.5357708,-0.56502842,1.7406723,-0.61683898,-0.53681464,-0.56502842,1.737601,-0.61684902,-0.5357708,-0.56502842,1.7395481,-0.61683898,-0.5357708,-0.56502842,1.7399697,-0.61683898,-0.5357708,-0.56502842,1.7394678,-0.61683898,-0.5357708,-0.56502842,1.7404615,-0.61683898,-0.5357708,-0.56502842,1.7390864,-0.61683898,-0.5357708,-0.56397454,1.7423685,-0.61683898,-0.5357708,-0.56502842,1.7405016,-0.61683898,-0.5357708,-0.56502842,1.7410537,-0.61683898,-0.5357708,-0.56502842,1.7383437,-0.61683898,-0.53681464,-0.56502842,1.7346903,-0.61684902,-0.53681464,-0.56502842,1.7345397,-0.61684902,-0.53681464,-0.56502842,1.736517,-0.61684902,-0.5357708,-0.56397454,1.7424488,-0.61683898,-0.5357708,-0.56397454,1.7421678,-0.61683898,-0.53472696,-0.56397454,1.7447573,-0.61683898,-0.5357708,-0.56502842,1.7427499,-0.61684902,-0.53681464,-0.56502842,1.7376612,-0.61684902,-0.5357708,-0.56502842,1.7385946,-0.61683898,-0.53681464,-0.56502842,1.7366073,-0.61684902,-0.5357708,-0.56502842,1.7392169,-0.61683898,-0.5357708,-0.56502842,1.7393273,-0.61683898,-0.5357708,-0.56502842,1.7409734,-0.61683898,-0.5357708,-0.56502842,1.7396585,-0.61683898,-0.5357708,-0.56502842,1.7387753,-0.61683898,-0.5357708,-0.56502842,1.7428402,-0.61684902,-0.5357708,-0.56502842,1.7431413,-0.61684902,-0.5357708,-0.56502842,1.740592,-0.61683898,-0.5357708,-0.56502842,1.7414451,-0.61684902,-0.5357708,-0.56502842,1.7389861,-0.61683898,-0.5357708,-0.56397454,1.7424588,-0.61683898,-0.5357708,-0.56502842,1.7414351,-0.61684902,-0.5357708,-0.56397454,1.7420273,-0.61683898,-0.5357708,-0.56397454,1.7427399,-0.61683898,-0.53472696,-0.56397454,1.7473368,-0.61683898,-0.53472696,-0.56397454,1.7476178,-0.61683898,-0.53368312,-0.56397454,1.7506189,-0.61683898,-0.53368312,-0.56397454,1.7500267,-0.61683898,-0.53368312,-0.56397454,1.7507393,-0.61683898,-0.53368312,-0.56397454,1.7508698,-0.61683898,-0.5357708,-0.56397454,1.7447573,-0.61683898,-0.53472696,-0.56397454,1.7452892,-0.61683898,-0.5357708,-0.56815993,1.7448577,-0.61684902,-0.53472696,-0.57651065,1.7452391,-0.61686909,-0.5357708,-0.57651065,1.7447272,-0.61686909,-0.53681464,-0.57651065,1.7382032,-0.61686909,-0.53472696,-0.57651065,1.7445264,-0.61686909,-0.5357708,-0.57651065,1.740612,-0.61686909,-0.53472696,-0.57651065,1.7461825,-0.61686909,-0.53472696,-0.57651065,1.7450283,-0.61686909,-0.53472696,-0.57651065,1.7459918,-0.61686909,-0.5357708,-0.57651065,1.7447774,-0.61686909,-0.5357708,-0.57651065,1.7424689,-0.61686909,-0.5357708,-0.57651065,1.7453997,-0.61686909,-0.5357708,-0.57651065,1.7461123,-0.61686909,-0.5357708,-0.57651065,1.7452591,-0.61686909,-0.53472696,-0.57651065,1.7453093,-0.61686909,-0.53472696,-0.57651065,1.74548,-0.61686909,-0.53472696,-0.57651065,1.7452591,-0.61686909,-0.5357708,-0.57651065,1.742228,-0.61686909,-0.53681464,-0.57651065,1.7402106,-0.61686909,-0.5357708,-0.57651065,1.7403009,-0.61686909,-0.5357708,-0.57651065,1.7389961,-0.61686909,-0.53681464,-0.57651065,1.7393976,-0.61686909,-0.53681464,-0.57651065,1.7387853,-0.61686909,-0.53681464,-0.57651065,1.7393474,-0.61686909,-0.53681464,-0.57651065,1.7380426,-0.61686909,-0.5357708,-0.57651065,1.7395381,-0.61686909,-0.53681464,-0.57651065,1.7385244,-0.61686909,-0.53681464,-0.57651065,1.7383738,-0.61686909,-0.53681464,-0.57651065,1.7360352,-0.61686909,-0.53681464,-0.57651065,1.7360352,-0.61686909,-0.53681464,-0.57651065,1.7377515,-0.61686909,-0.53681464,-0.57651065,1.7385143,-0.61686909,-0.53681464,-0.57755449,1.7365069,-0.61686909,-0.53681464,-0.57651065,1.7368281,-0.61686909,-0.5357708,-0.57546681,1.74005,-0.61686909,-0.5357708,-0.57651065,1.740592,-0.61686909,-0.5357708,-0.57651065,1.7415053,-0.61686909,-0.5357708,-0.57651065,1.7406422,-0.61686909,-0.5357708,-0.57651065,1.7393675,-0.61686909,-0.5357708,-0.57651065,1.7390563,-0.61686909,-0.5357708,-0.57651065,1.7404816,-0.61686909,-0.53681464,-0.57755449,1.7351821,-0.61686909,-0.53681464,-0.57651065,1.7369285,-0.61686909,-0.5357708,-0.57651065,1.7413648,-0.61686909,-0.5357708,-0.57651065,1.7420373,-0.61686909,-0.5357708,-0.57651065,1.7440748,-0.61686909,-0.5357708,-0.57651065,1.7434123,-0.61686909,-0.5357708,-0.57651065,1.741686,-0.61686909,-0.5357708,-0.57755449,1.7392671,-0.61686909,-0.53681464,-0.57651065,1.7370289,-0.61686909,-0.5357708,-0.57651065,1.7403009,-0.61686909,-0.5357708,-0.57651065,1.7394578,-0.61686909,-0.53681464,-0.57651065,1.7381028,-0.61686909,-0.5357708,-0.57755449,1.7386348,-0.61686909,-0.5357708,-0.57651065,1.7401102,-0.61686909,-0.5357708,-0.57651065,1.741676,-0.61686909,-0.5357708,-0.57651065,1.7401503,-0.61686909,-0.5357708,-0.57651065,1.738163,-0.61686909,-0.5357708,-0.57651065,1.7397288,-0.61686909,-0.5357708,-0.57651065,1.7413447,-0.61686909,-0.5357708,-0.57651065,1.738695,-0.61686909,-0.53681464,-0.57651065,1.7382132,-0.61686909,-0.53681464,-0.58904676,1.7355735,-0.61688917,-0.53681464,-0.59218831,1.736788,-0.6168992,-0.53785848,-0.59218831,1.7331044,-0.6168992,-0.53785848,-0.59218831,1.7320204,-0.6168992,-0.53681464,-0.59218831,1.7356036,-0.6168992,-0.53681464,-0.59218831,1.7392069,-0.6168992,-0.53681464,-0.59218831,1.7398292,-0.6168992,-0.5357708,-0.59218831,1.7410035,-0.61688917,-0.5357708,-0.59218831,1.7406422,-0.61688917,-0.53681464,-0.59218831,1.740612,-0.6168992,-0.53681464,-0.59218831,1.7400901,-0.6168992,-0.5357708,-0.59218831,1.7407927,-0.61688917,-0.5357708,-0.59218831,1.74278,-0.61688917,-0.53681464,-0.59218831,1.738956,-0.6168992,-0.5357708,-0.59218831,1.7409332,-0.61688917,-0.5357708,-0.59218831,1.7418566,-0.61688917,-0.53681464,-0.59218831,1.7364166,-0.6168992,-0.53681464,-0.59218831,1.7374203,-0.6168992,-0.53681464,-0.59218831,1.7385143,-0.6168992,-0.53681464,-0.59218831,1.7397087,-0.6168992,-0.53681464,-0.59218831,1.7387853,-0.6168992,-0.53681464,-0.59218831,1.739779,-0.6168992,-0.53681464,-0.59218831,1.7395883,-0.6168992,-0.5357708,-0.59218831,1.7425391,-0.61688917,-0.5357708,-0.59114448,1.7425994,-0.61688917,-0.53681464,-0.59218831,1.7392671,-0.6168992,-0.53681464,-0.59218831,1.7402708,-0.6168992,-0.5357708,-0.59218831,1.7411942,-0.61688917,-0.5357708,-0.59218831,1.7418265,-0.61688917,-0.5357708,-0.59218831,1.7431012,-0.61688917,-0.5357708,-0.59218831,1.7427399,-0.61688917,-0.53472696,-0.59218831,1.7459216,-0.61688917,-0.53472696,-0.59218831,1.7466643,-0.61688917,-0.53472696,-0.59114448,1.7482401,-0.61688917,-0.53472696,-0.59218831,1.7465439,-0.61688917,-0.53472696,-0.59218831,1.7471461,-0.61688917,-0.5357708,-0.59114448,1.7447372,-0.61688917,-0.53472696,-0.59218831,1.7460019,-0.61688917,-0.53472696,-0.59218831,1.7469353,-0.61688917,-0.53472696,-0.59114448,1.7472464,-0.61688917,-0.53472696,-0.59114448,1.7478988,-0.61688917,-0.53472696,-0.59114448,1.7480695,-0.61688917,-0.53472696,-0.59114448,1.7480695,-0.61688917,-0.53472696,-0.59114448,1.7480695,-0.61688917,-0.53472696,-0.59114448,1.7480695,-0.61688917,-0.53472696,-0.59114448,1.7480695,-0.61688917,-0.53472696,-0.59114448,1.7480695,-0.61688917,-0.53472696,-0.59114448,1.7480695,-0.61688917:6
-0.75390903,-0.75390903,1.680194,-0.75390903,-0.75390903,-0.75390903,1.6857636,-0.75390903,-0.75390903,-0.75390903,1.6845621,-0.75390903,-0.75390903,-0.75390903,1.6850916,-0.75390903,-0.75390903,-0.75390903,1.6836355,-0.75390903,-0.75390903,-0.75390903,1.6846028,-0.75390903,-0.75390903,-0.75390903,1.6845417,-0.75390903,-0.75390903,-0.75390903,1.684949,-0.75390903,-0.75390903,-0.75390903,1.6851425,-0.75390903,-0.75390903,-0.75390903,1.684725,-0.75390903,-0.75390903,-0.75390903,1.6845214,-0.75390903,-0.75390903,-0.75390903,1.6854988,-0.75390903,-0.75390903,-0.75390903,1.6840632,-0.75390903,-0.75390903,-0.75390903,1.6834217,-0.75390903,-0.75390903,-0.75390903,1.683157,-0.75390903,-0.75390903,-0.75390903,1.6841956,-0.75390903,-0.75390903,-0.75390903,1.6844807,-0.75390903,-0.75390903,-0.75390903,1.6848879,-0.75390903,-0.75390903,-0.75390903,1.6856516,-0.75390903,-0.75390903,-0.75390903,1.6859367,-0.75390903,-0.75390903,-0.75390903,1.6863745,-0.75390903,-0.75390903,-0.75390903,1.6885229,-0.75390903,-0.75390903,-0.75390903,1.6883498,-0.75390903,-0.75390903,-0.75390903,1.688024,-0.75390903,-0.75390903,-0.75390903,1.688808,-0.75390903,-0.75390903,-0.75390903,1.6872094,-0.75390903,-0.75390903,-0.75390903,1.6875149,-0.75390903,-0.75390903,-0.75390903,1.6870872,-0.75390903,-0.75390903,-0.75390903,1.6866392,-0.75390903,-0.75390903,-0.75390903,1.6874538,-0.75390903,-0.75390903,-0.75390903,1.692107,-0.75390903,-0.75390903,-0.75390903,1.6938175,-0.75390903,-0.75390903,-0.75390903,1.6962103,-0.75390903,-0.75390903,-0.75390903,1.6922597,-0.75390903,-0.75390903,-0.75390903,1.6938684,-0.75390903,-0.75390903,-0.75390903,1.6923615,-0.75390903,-0.75390903,-0.75390903,1.6947543,-0.75390903,-0.75390903,-0.75390903,1.6938786,-0.75390903,-0.75390903,-0.75390903,1.6937361,-0.75390903,-0.75390903,-0.75390903,1.6943572,-0.75390903,-0.75390903,-0.75390903,1.6940517,-0.75390903,-0.75390903,-0.75390903,1.6932371,-0.75390903,-0.75390903,-0.75390903,1.6959456,-0.75390903,-0.75390903,-0.75390903,1.6929521,-0.75390903,-0.75390903,-0.75390903,1.6930335,-0.75390903,-0.75390903,-0.75390903,1.6967092,-0.75390903,-0.75390903,-0.75390903,1.6962205,-0.75390903,-0.75390903,-0.75390903,1.6960983,-0.75390903,-0.75390903,-0.75390903,1.6931659,-0.75390903,-0.75390903,-0.75390903,1.6933084,-0.75390903,-0.75390903,-0.75390903,1.6940517,-0.75390903,-0.75390903,-0.75390903,1.6902131,-0.75390903,-0.75390903,-0.75390903,1.6905593,-0.75390903,-0.75390903,-0.75390903,1.6902335,-0.75390903,-0.75390903,-0.75390903,1.6903455,-0.75390903,-0.75390903,-0.75390903,1.6898364,-0.75390903,-0.75390903,-0.75390903,1.6905186,-0.75390903,-0.66116141,-0.16049331,1.6891134,-0.74910313,-0.68856111,-0.13940644,1.6877592,-0.75040643,-0.69277645,-0.087763461,1.6875149,-0.75015188,-0.6917277,-0.094086468,1.6901316,-0.75018242,-0.69066878,-0.079322604,1.6895513,-0.75010097,-0.69066878,-0.084596867,1.6886247,-0.75011115,-0.68962003,-0.079322604,1.6872298,-0.7500806,-0.68962003,-0.072999597,1.6869447,-0.75006024,-0.69066878,-0.079322604,1.6868225,-0.75010097,-0.69066878,-0.058245914,1.6748485,-0.74994824,-0.69488412,-0.085655792,1.6741358,-0.75012133,-0.69277645,-0.063520178,1.6757751,-0.74997878,-0.69699178,-0.10778123,1.6734943,-0.75023333,-0.69488412,-0.082489198,1.6886451,-0.7501417,-0.69066878,-0.11832975,1.6895716,-0.75030461,-0.69066878,-0.093027543,1.6864967,-0.75016206,-0.69066878,-0.1257015,1.6886349,-0.75034534,-0.69488412,-0.090919874,1.6882174,-0.75019261,-0.69066878,-0.12148616,1.687576,-0.75032497,-0.69066878,-0.12043742,1.6903149,-0.75032497,-0.68962003,-0.11622208,1.6917913,-0.75030461,-0.6917277,-0.1193785,1.6890727,-0.75032497,-0.6917277,-0.12359383,1.6873112,-0.75034534,-0.69277645,-0.11832975,1.6854174,-0.75031479,-0.6917277,-0.1193785,1.6875862,-0.75032497,-0.69277645,-0.12043742,1.6856719,-0.75032497,-0.69277645,-0.12148616,1.6845723,-0.75032497,-0.69277645,-0.12676043,1.6846537,-0.75035552,-0.6917277,-0.12359383,1.6847148,-0.75034534,-0.69277645,-0.12148616,1.6853665,-0.75033515,-0.6917277,-0.12148616,1.6864254,-0.75032497,-0.69277645,-0.12359383,1.6856516,-0.75034534,-0.69277645,-0.12465276,1.6854683,-0.75034534,-0.69383537,-0.1193785,1.6843686,-0.75031479,-0.69277645,-0.12254509,1.6852036,-0.75034534,-0.69383537,-0.12359383,1.6845519,-0.75034534,-0.6917277,-0.12254509,1.6857025,-0.75034534,-0.69277645,-0.1193785,1.6857127,-0.75032497,-0.69277645,-0.12254509,1.6861301,-0.75033515,-0.69066878,-0.12465276,1.6868531,-0.75034534,-0.69066878,-0.12465276,1.6874843,-0.75034534,-0.69277645,-0.12359383,1.6864254,-0.75033515,-0.69277645,-0.12254509,1.685845,-0.75033515,-0.69277645,-0.12148616,1.6855396,-0.75032497,-0.69277645,-0.12359383,1.6844603,-0.75033515,-0.69383537,-0.1288681,1.6840225,-0.7503657,-0.69488412,-0.1288681,1.6835134,-0.7503657,-0.69383537,-0.1288681,1.6845927,-0.7503657,-0.69488412,-0.12780917,1.6850916,-0.75035552,-0.69383537,-0.1288681,1.6850814,-0.7503657,-0.69383537,-0.1257015,1.6863236,-0.75035552,-0.69383537,-0.1288681,1.6864254,-0.7503657,-0.69383537,-0.12359383,1.6860181,-0.75033515,-0.69277645,-0.12676043,1.6873621,-0.75035552,-0.69383537,-0.12465276,1.6878407,-0.75034534,-0.69594304,-0.12148616,1.6861098,-0.75032497,-0.69277645,-0.12465276,1.690712,-0.75034534,-0.69805071,-0.12991684,1.67941,-0.7503657,-0.69909945,-0.1288681,1.6790944,-0.75035552,-0.69277645,-0.12780917,1.6905084,-0.75035552,-0.6917277,-0.1288681,1.689928,-0.7503657,-0.69277645,-0.12780917,1.6897244,-0.7503657,-0.69383537,-0.12780917,1.6887978,-0.7503657,-0.6917277,-0.12676043,1.6908444,-0.75035552,-0.69066878,-0.12254509,1.6902538,-0.75033515,-0.69277645,-0.12676043,1.6892356,-0.75035552,-0.69066878,-0.12359383,1.6927179,-0.75034534,-0.68962003,-0.1257015,1.6944081,-0.75035552,-0.68962003,-0.12676043,1.6932982,-0.75034534,-0.69066878,-0.1257015,1.691496,-0.75034534,-0.69277645,-0.1351911,1.6877287,-0.75039625,-0.68962003,-0.12043742,1.6860487,-0.75030461,-0.68856111,-0.1257015,1.6895411,-0.75034534,-0.68962003,-0.1257015,1.6873825,-0.75033515,-0.69066878,-0.12465276,1.6853868,-0.75032497,-0.69488412,-0.13729877,1.6776791,-0.75039625,-0.68856111,-0.1288681,1.6883803,-0.7503657,-0.69383537,-0.12991684,1.6872196,-0.7503657,-0.69277645,-0.13202451,1.6888284,-0.75038606,-0.69277645,-0.1288681,1.6879323,-0.7503657,-0.69383537,-0.13308343,1.6877592,-0.75038606,-0.6917277,-0.12991684,1.6895105,-0.7503657,-0.69277645,-0.1288681,1.6895309,-0.7503657,-0.69277645,-0.13308343,1.6894902,-0.75037588,-0.69383537,-0.12991684,1.6891949,-0.7503657,-0.6917277,-0.13308343,1.6899789,-0.75037588,-0.69066878,-0.1288681,1.6913738,-0.75035552,-0.69277645,-0.1288681,1.6871381,-0.75035552,-0.6917277,-0.12359383,1.6854479,-0.75032497,-0.68962003,-0.13414236,1.6897244,-0.75038606,-0.69066878,-0.12359383,1.6890931,-0.75032497,-0.69277645,-0.1288681,1.6884516,-0.7503657,-0.69594304,-0.13308343,1.684837,-0.75038606,-0.69277645,-0.1257015,1.6885025,-0.75035552,-0.6917277,-0.12780917,1.6863949,-0.7503657,-0.69383537,-0.12465276,1.684165,-0.75033515,-0.69277645,-0.13097577,1.6885636,-0.75037588,-0.69383537,-0.1288681,1.68948,-0.75037588,-0.69594304,-0.12465276,1.6849694,-0.75034534,-0.69488412,-0.12780917,1.6872196,-0.75035552,-0.69383537,-0.12991684,1.6875352,-0.7503657,-0.69594304,-0.1288681,1.6849694,-0.75035552,-0.69488412,-0.12991684,1.6856007,-0.75035552,-0.69488412,-0.12465276,1.6866494,-0.75032497,-0.69594304,-0.13097577,1.6841446,-0.75035552,-0.69594304,-0.12991684,1.6854276,-0.75035552,-0.69488412,-0.1288681,1.6859876,-0.75035552,-0.69805071,-0.1383577,1.6819657,-0.75039625,-0.69594304,-0.12359383,1.6853665,-0.75032497,-0.69699178,-0.1257015,1.6797868,-0.75032497,-0.69699178,-0.12359383,1.6810799,-0.75031479,-0.69594304,-0.13202451,1.6799191,-0.75035552,-0.69699178,-0.1288681,1.6801839,-0.75035552,-0.69909945,-0.13414236,1.67997,-0.75038606,-0.69805071,-0.13414236,1.6804995,-0.75038606,-0.69699178,-0.1351911,1.6818639,-0.75039625,-0.69594304,-0.13729877,1.6825868,-0.75041661,-0.69594304,-0.1351911,1.683493,-0.75039625,-0.69594304,-0.1351911,1.6832894,-0.75039625,-0.69699178,-0.13625003,1.682485,-0.75040643,-0.69699178,-0.13308343,1.6816399,-0.75038606,-0.69383537,-0.12780917,1.6844094,-0.7503657,-0.69594304,-0.12991684,1.6837475,-0.7503657,-0.69594304,-0.13097577,1.6819657,-0.75038606,-0.69488412,-0.12991684,1.6828719,-0.75037588,-0.69488412,-0.13625003,1.6836355,-0.75039625,-0.69594304,-0.12991684,1.6819352,-0.7503657,-0.69594304,-0.12991684,1.6812326,-0.7503657,-0.69909945,-0.13940644,1.678514,-0.75040643,-0.69805071,-0.12991684,1.6794813,-0.75035552,-0.69805071,-0.1351911,1.6786871,-0.75038606,-0.69699178,-0.13414236,1.6808864,-0.75040643,-0.69594304,-0.13414236,1.6818537,-0.75039625,-0.69594304,-0.13308343,1.6829635,-0.75039625,-0.69699178,-0.12780917,1.682485,-0.75035552,-0.69594304,-0.13308343,1.6825155,-0.75038606,-0.69594304,-0.1257015,1.6838494,-0.75035552,-0.69699178,-0.13414236,1.6832283,-0.75039625,-0.69699178,-0.13202451,1.6812937,-0.75038606,-0.69488412,-0.13202451,1.6833301,-0.75037588,-0.69699178,-0.13097577,1.6802144,-0.7503657,-0.69805071,-0.13414236,1.6792878,-0.75038606,-0.69699178,-0.13097577,1.6833708,-0.75037588,-0.69699178,-0.1351911,1.6819657,-0.75039625,-0.69699178,-0.1351911,1.6809984,-0.75039625,-0.69594304,-0.13202451,1.6831061,-0.75038606,-0.69699178,-0.13625003,1.681477,-0.75039625,-0.69699178,-0.13625003,1.6815992,-0.75039625,-0.69699178,-0.12991684,1.6824035,-0.7503657,-0.69909945,-0.14257304,1.6790129,-0.75042679,-0.69594304,-0.13202451,1.6813446,-0.75037588,-0.69699178,-0.13625003,1.6802042,-0.75039625,-0.69909945,-0.13940644,1.6790944,-0.75040643,-0.69805071,-0.12991684,1.6825155,-0.7503657,-0.69805071,-0.1288681,1.681701,-0.75035552,-0.69699178,-0.13308343,1.683829,-0.75038606,-0.69594304,-0.12991684,1.6836559,-0.75035552,-0.69594304,-0.13414236,1.6821592,-0.75038606,-0.69805071,-0.13625003,1.6825563,-0.75039625,-0.69594304,-0.13202451,1.6821592,-0.7503657,-0.69909945,-0.13414236,1.680357,-0.75038606,-0.69699178,-0.13414236,1.6785344,-0.75037588,-0.69805071,-0.12991684,1.6796035,-0.75037588,-0.69699178,-0.13414236,1.6797664,-0.75039625,-0.69699178,-0.13202451,1.6800006,-0.75037588,-0.69805071,-0.13308343,1.6795831,-0.75038606,-0.69805071,-0.13308343,1.6798682,-0.75038606,-0.69805071,-0.1351911,1.6814464,-0.75039625,-0.69805071,-0.13308343,1.6801431,-0.75039625,-0.69909945,-0.13625003,1.680805,-0.75040643,-0.69805071,-0.13729877,1.6801737,-0.75040643,-0.69805071,-0.13414236,1.6800922,-0.75039625,-0.69805071,-0.13729877,1.6798479,-0.75041661,-0.69805071,-0.1351911,1.683157,-0.75040643,-0.69805071,-0.13308343,1.6821999,-0.75039625,-0.70015838,-0.1351911,1.681029,-0.75040643,-0.69805071,-0.13414236,1.6839105,-0.75039625,-0.69805071,-0.13625003,1.6837781,-0.75041661,-0.70226605,-0.13414236,1.6785751,-0.75038606,-0.69699178,-0.12991684,1.6834726,-0.75035552,-0.69909945,-0.13308343,1.6817722,-0.75037588,-0.69805071,-0.13625003,1.6825766,-0.75039625,-0.69805071,-0.13308343,1.6816297,-0.75037588,-0.69909945,-0.13308343,1.6813242,-0.75037588,-0.69909945,-0.13308343,1.6815992,-0.75037588,-0.69594304,-0.13940644,1.6832283,-0.75041661,-0.69699178,-0.1351911,1.6822508,-0.75038606,-0.69805071,-0.1351911,1.6803366,-0.75037588,-0.69805071,-0.12991684,1.6832894,-0.7503657,-0.69699178,-0.13625003,1.6818944,-0.75039625,-0.69909945,-0.13414236,1.681029,-0.75037588,-0.69699178,-0.13308343,1.6837679,-0.75038606,-0.69805071,-0.13308343,1.6825053,-0.75038606,-0.69805071,-0.1351911,1.6822712,-0.75038606,-0.69594304,-0.1351911,1.6841854,-0.75038606,-0.69594304,-0.13308343,1.684725,-0.75039625,-0.69699178,-0.13308343,1.685061,-0.75038606,-0.69909945,-0.13625003,1.6822203,-0.75040643,-0.69699178,-0.13729877,1.6848574,-0.75041661,-0.69805071,-0.13414236,1.6840021,-0.75039625,-0.69909945,-0.13097577,1.6814159,-0.7503657,-0.69594304,-0.13729877,1.6861709,-0.75041661,-0.69594304,-0.13729877,1.6843076,-0.75039625,-0.69805071,-0.13729877,1.6826886,-0.75040643,-0.69805071,-0.13414236,1.6847556,-0.75038606,-0.69805071,-0.13729877,1.6833505,-0.75040643,-0.70120712,-0.13202451,1.6791351,-0.75037588,-0.69805071,-0.13625003,1.6831264,-0.75040643,-0.69699178,-0.13414236,1.6839919,-0.75039625,-0.69594304,-0.13414236,1.6852239,-0.75038606,-0.69699178,-0.1288681,1.6846436,-0.7503657,-0.70332497,-0.13202451,1.6842974,-0.75040643,-0.70437372,-0.12991684,1.6797155,-0.75038606,-0.70120712,-0.13202451,1.6860181,-0.75041661,-0.70120712,-0.13202451,1.686904,-0.75040643,-0.70120712,-0.12991684,1.6874436,-0.75039625,-0.70120712,-0.13202451,1.688248,-0.75041661,-0.69699178,-0.13097577,1.685957,-0.75038606,-0.69699178,-0.13308343,1.6866087,-0.75040643,-0.69594304,-0.12465276,1.6868429,-0.75035552,-0.69699178,-0.1288681,1.6850101,-0.7503657,-0.69699178,-0.13308343,1.6858858,-0.75038606,-0.69594304,-0.12991684,1.6883702,-0.75038606,-0.69699178,-0.12991684,1.6847759,-0.75037588,-0.69699178,-0.13097577,1.6841345,-0.75037588,-0.69805071,-0.1351911,1.685061,-0.75040643,-0.69805071,-0.13414236,1.6831366,-0.75040643,-0.69699178,-0.1351911,1.6850916,-0.75039625,-0.69699178,-0.13414236,1.6855803,-0.75039625,-0.69594304,-0.13308343,1.6841446,-0.75038606,-0.69909945,-0.13625003,1.6777911,-0.75038606,-0.70120712,-0.1383577,1.6764369,-0.75041661,-0.69805071,-0.1351911,1.6797868,-0.75039625,-0.70015838,-0.13308343,1.6783409,-0.75038606,-0.69909945,-0.13414236,1.6803366,-0.75038606,-0.69699178,-0.1288681,1.6800413,-0.75035552,-0.69805071,-0.1351911,1.6803162,-0.75039625,-0.69699178,-0.12991684,1.6843177,-0.75037588,-0.69805071,-0.13202451,1.6825359,-0.75037588,-0.69909945,-0.13414236,1.6809373,-0.75038606,-0.69699178,-0.1351911,1.6829126,-0.75040643,-0.69699178,-0.13729877,1.6841956,-0.75041661,-0.69699178,-0.13940644,1.6830043,-0.75041661,-0.69699178,-0.1383577,1.6819453,-0.75040643,-0.69909945,-0.13729877,1.6818842,-0.75041661,-0.69805071,-0.1351911,1.6813853,-0.75039625,-0.69594304,-0.13097577,1.6847657,-0.75037588,-0.69699178,-0.1351911,1.6815279,-0.75039625,-0.69909945,-0.1383577,1.6812122,-0.75041661,-0.69805071,-0.13625003,1.6808762,-0.75040643,-0.70015838,-0.13625003,1.6792268,-0.75040643,-0.69909945,-0.1351911,1.6837272,-0.75040643,-0.70015838,-0.13625003,1.6798071,-0.75040643,-0.69909945,-0.1351911,1.6823832,-0.75040643,-0.69805071,-0.13202451,1.6813853,-0.75037588,-0.69699178,-0.13414236,1.6810697,-0.75038606,-0.69594304,-0.13097577,1.6845519,-0.75037588,-0.69699178,-0.13202451,1.686293,-0.75039625,-0.69699178,-0.13729877,1.6830755,-0.75041661,-0.69805071,-0.13097577,1.682597,-0.75038606,-0.69805071,-0.13202451,1.6828108,-0.75038606,-0.69805071,-0.13729877,1.6845417,-0.75042679,-0.69805071,-0.13414236,1.6851323,-0.75040643,-0.69805071,-0.13729877,1.682821,-0.75041661,-0.69805071,-0.13414236,1.6837781,-0.75040643,-0.69805071,-0.13625003,1.6817315,-0.75041661,-0.69699178,-0.13202451,1.6838188,-0.75038606,-0.70015838,-0.1383577,1.6776384,-0.75041661,-0.70015838,-0.13414236,1.6792573,-0.75039625,-0.70120712,-0.14151411,1.6758056,-0.75042679,-0.70226605,-0.14151411,1.6743699,-0.75042679,-0.70015838,-0.1383577,1.6775264,-0.75041661,-0.69909945,-0.14046537,1.6783206,-0.75042679,-0.69909945,-0.14257304,1.680754,-0.75044716,-0.69909945,-0.13729877,1.6793489,-0.75040643,-0.69909945,-0.13940644,1.677842,-0.75042679,-0.70015838,-0.14046537,1.6779235,-0.75042679,-0.70015838,-0.13940644,1.6753169,-0.75041661,-0.70015838,-0.13097577,1.6741052,-0.75035552,-0.70226605,-0.1383577,1.6724456,-0.75039625,-0.70120712,-0.13729877,1.6733416,-0.75039625,-0.70226605,-0.14046537,1.6724557,-0.75040643,-0.70226605,-0.13940644,1.6718448,-0.75040643,-0.70226605,-0.14151411,1.6715597,-0.75041661,-0.70226605,-0.13625003,1.6725474,-0.75038606,-0.70332497,-0.1383577,1.6708164,-0.75040643,-0.70332497,-0.14046537,1.669951,-0.75041661,-0.70332497,-0.13940644,1.6706739,-0.75040643,-0.70120712,-0.1383577,1.6706332,-0.75039625,-0.70226605,-0.13625003,1.6706128,-0.75038606,-0.70332497,-0.1383577,1.6700324,-0.75039625,-0.70332497,-0.13729877,1.6712644,-0.75039625,-0.70226605,-0.1288681,1.6721503,-0.75035552,-0.70543264,-0.1446807,1.6649313,-0.75042679,-0.70332497,-0.14151411,1.6712339,-0.75041661,-0.70332497,-0.1383577,1.6721605,-0.75040643,-0.70332497,-0.14046537,1.6716514,-0.75040643,-0.70437372,-0.14151411,1.6726696,-0.75041661,-0.70437372,-0.14151411,1.6726696,-0.75041661,-0.70437372,-0.14151411,1.6726696,-0.75041661,-0.70437372,-0.14151411,1.6726696,-0.75041661,-0.70437372,-0.14151411,1.6726696,-0.75041661,-0.70437372,-0.14151411,1.6726696,-0.75041661,-0.70437372,-0.14151411,1.6726696,-0.75041661,-0.70437372,-0.14151411,1.6726696,-0.75041661,-0.70437372,-0.14151411,1.6726696,-0.75041661,-0.70437372,-0.14151411,1.6726696,-0.75041661,-0.70437372,-0.14151411,1.6726696,-0.75041661:6
-0.60936714,-0.47765467,1.7396248,-0.68884098,-0.60414631,-0.48915667,1.7394834,-0.68886117,-0.60414631,-0.48915667,1.740675,-0.68887127,-0.60936714,-0.44524914,1.7393319,-0.6886794,-0.60936714,-0.44524914,1.7401903,-0.6886794,-0.60936714,-0.44524914,1.7395743,-0.6886794,-0.61041737,-0.40552232,1.7388775,-0.68849763,-0.61041737,-0.38774927,1.7394632,-0.68841685,-0.61041737,-0.40343197,1.739231,-0.68848753,-0.6114575,-0.39611068,1.7402913,-0.68845724,-0.61041737,-0.38042798,1.7389886,-0.68838655,-0.6114575,-0.39611068,1.7392613,-0.68846734,-0.6114575,-0.40343197,1.7402206,-0.68849763,-0.60936714,-0.44524914,1.7398672,-0.6886794,-0.60936714,-0.44628927,1.7394632,-0.6886794,-0.60936714,-0.44524914,1.7406649,-0.6886794,-0.60936714,-0.44628927,1.7400792,-0.6886794,-0.60936714,-0.44628927,1.7407659,-0.6886794,-0.60936714,-0.44628927,1.7399782,-0.6886794,-0.60936714,-0.44628927,1.74119,-0.6886794,-0.60936714,-0.44628927,1.7402711,-0.6886794,-0.60936714,-0.44628927,1.740776,-0.6886794,-0.60936714,-0.44628927,1.7425533,-0.6886794,-0.60832702,-0.44628927,1.7422908,-0.6886794,-0.60936714,-0.44628927,1.7422605,-0.6886794,-0.60832702,-0.44524914,1.7448658,-0.6886794,-0.60832702,-0.44524914,1.7452698,-0.6886794,-0.60832702,-0.44524914,1.745805,-0.6886794,-0.60832702,-0.44524914,1.746532,-0.6886794,-0.60832702,-0.44524914,1.7447547,-0.6886794,-0.60832702,-0.44524914,1.7458757,-0.6886794,-0.60832702,-0.44524914,1.7463806,-0.6886794,-0.60832702,-0.44524914,1.7456434,-0.6886794,-0.60832702,-0.44524914,1.7461887,-0.6886794,-0.60727679,-0.44524914,1.7478953,-0.6886794,-0.60727679,-0.44524914,1.7477943,-0.6886794,-0.60832702,-0.44524914,1.7480165,-0.6886794,-0.60832702,-0.44524914,1.747653,-0.6886794,-0.60832702,-0.44524914,1.7477539,-0.6886794,-0.60832702,-0.44524914,1.7477035,-0.6886794,-0.60832702,-0.44524914,1.7480266,-0.6886794,-0.60832702,-0.44524914,1.747865,-0.6886794,-0.60832702,-0.44524914,1.7468754,-0.6886794,-0.60936714,-0.44419892,1.7460473,-0.6886794,-0.60832702,-0.44524914,1.7457242,-0.6886794,-0.60936714,-0.44419892,1.7457848,-0.6886794,-0.60727679,-0.44628927,1.7472288,-0.6886794,-0.60936714,-0.44315879,1.7473298,-0.6886693,-0.60727679,-0.44524914,1.7476328,-0.6886794,-0.61041737,-0.44419892,1.7459766,-0.6886794,-0.60832702,-0.44524914,1.7459262,-0.6886794,-0.60936714,-0.44419892,1.7463806,-0.6886693,-0.60936714,-0.44524914,1.7452193,-0.6886794,-0.60936714,-0.44419892,1.7459262,-0.6886794,-0.60936714,-0.44524914,1.7437853,-0.6886794,-0.60832702,-0.44524914,1.7456939,-0.6886794,-0.60936714,-0.44419892,1.747037,-0.6886794,-0.60727679,-0.44628927,1.7470976,-0.6886794,-0.60936714,-0.44315879,1.7478751,-0.6886794,-0.60832702,-0.44628927,1.7458757,-0.6886794,-0.60936714,-0.44419892,1.7477539,-0.6886794,-0.60832702,-0.44524914,1.7475116,-0.6886794,-0.60936714,-0.44419892,1.7476328,-0.6886794,-0.60832702,-0.44524914,1.7456333,-0.6886794,-0.60936714,-0.44419892,1.7469764,-0.6886794,-0.60936714,-0.44524914,1.7442397,-0.6886794,-0.60936714,-0.44524914,1.743856,-0.6886794,-0.60936714,-0.44524914,1.7445528,-0.6886794,-0.60832702,-0.4473395,1.7427553,-0.6886794,-0.60936714,-0.44419892,1.7443306,-0.6886794,-0.60832702,-0.44628927,1.7435934,-0.6886895,-0.60936714,-0.44419892,1.74427,-0.6886794,-0.60832702,-0.44628927,1.7445932,-0.6886794,-0.60936714,-0.44419892,1.7443811,-0.6886693,-0.60832702,-0.44524914,1.7462897,-0.6886794,-0.60936714,-0.44315879,1.7472894,-0.6886794,-0.60832702,-0.44419892,1.750632,-0.6886794,-0.60936714,-0.44419892,1.7479862,-0.6886794,-0.60936714,-0.44419892,1.7469259,-0.6886794,-0.60832702,-0.44524914,1.7480569,-0.6886794,-0.60936714,-0.44315879,1.7488345,-0.6886693,-0.61041737,-0.44942985,1.7284157,-0.6886794,-0.61355795,-0.4473395,1.7216498,-0.6886794,-0.61250772,-0.45046998,1.7191656,-0.6886794,-0.61355795,-0.44837962,1.7181759,-0.6886794,-0.61250772,-0.45046998,1.7167521,-0.6886794,-0.61355795,-0.44837962,1.719307,-0.6886794,-0.61250772,-0.44942985,1.7178427,-0.6886794,-0.61355795,-0.44837962,1.7159139,-0.6886794,-0.61250772,-0.44942985,1.7167824,-0.6886794,-0.61250772,-0.45046998,1.7146819,-0.6886794,-0.61355795,-0.44942985,1.7138741,-0.6886794,-0.61355795,-0.45256033,1.7090067,-0.6886895,-0.61459808,-0.45046998,1.7074414,-0.6886794,-0.61355795,-0.4515202,1.7084816,-0.6886895,-0.61459808,-0.45046998,1.7074515,-0.6886895,-0.61355795,-0.4515202,1.7071587,-0.6886895,-0.6156483,-0.45046998,1.7062902,-0.6886895,-0.61355795,-0.4515202,1.7062498,-0.6886895,-0.6156483,-0.45046998,1.7070375,-0.6886895,-0.61355795,-0.45046998,1.7128844,-0.6886895,-0.61355795,-0.45046998,1.7114909,-0.6886895,-0.61459808,-0.45046998,1.7083907,-0.6886895,-0.61250772,-0.45256033,1.7096429,-0.6886895,-0.61459808,-0.45046998,1.7098852,-0.6886895,-0.61355795,-0.4515202,1.7092793,-0.6886895,-0.61459808,-0.44942985,1.7093702,-0.6886794,-0.61355795,-0.4515202,1.7087845,-0.6886895,-0.61459808,-0.45046998,1.7083099,-0.6886895,-0.61355795,-0.4515202,1.7085119,-0.6886895,-0.61459808,-0.45046998,1.7078959,-0.6886895,-0.61459808,-0.4515202,1.70832,-0.6886895,-0.61355795,-0.4515202,1.7089764,-0.6886895,-0.61459808,-0.45046998,1.7091581,-0.6886794,-0.61355795,-0.45256033,1.708936,-0.6886895,-0.61459808,-0.44942985,1.7114303,-0.6886794,-0.61250772,-0.4515202,1.7112283,-0.6886895,-0.61459808,-0.44942985,1.7123593,-0.6886794,-0.61250772,-0.4515202,1.7116423,-0.6886895,-0.61459808,-0.44942985,1.7120362,-0.6886794,-0.61355795,-0.4515202,1.7117534,-0.6886794,-0.61459808,-0.44942985,1.7103497,-0.6886794,-0.61355795,-0.45046998,1.709037,-0.6886794,-0.61459808,-0.45046998,1.7101781,-0.6886794,-0.61355795,-0.45046998,1.7100165,-0.6886794,-0.61250772,-0.4515202,1.7097136,-0.6886895,-0.61459808,-0.45046998,1.7101175,-0.6886794,-0.61250772,-0.45256033,1.7094106,-0.6886895,-0.61459808,-0.44942985,1.7100468,-0.6886794,-0.61250772,-0.4515202,1.7099458,-0.6886895,-0.61459808,-0.44942985,1.7100771,-0.6886794,-0.61355795,-0.4515202,1.7094914,-0.6886895,-0.61459808,-0.45046998,1.7089865,-0.6886895,-0.61355795,-0.4515202,1.7091278,-0.6886895,-0.61459808,-0.45046998,1.709764,-0.6886895,-0.61355795,-0.45046998,1.7099458,-0.6886895,-0.61355795,-0.45256033,1.7067547,-0.6886895,-0.61459808,-0.45046998,1.7095015,-0.6886895,-0.61355795,-0.41284361,1.709764,-0.68850773,-0.6156483,-0.39507056,1.7096227,-0.68843704,-0.61459808,-0.40656245,1.7107335,-0.68848753,-0.6156483,-0.40029139,1.7102892,-0.68846734,-0.61459808,-0.40970303,1.7126724,-0.68850773,-0.61355795,-0.40761268,1.712228,-0.68849763,-0.61355795,-0.40970303,1.7121271,-0.68850773,-0.61355795,-0.41284361,1.7126825,-0.68851783,-0.61459808,-0.4086629,1.7128844,-0.68849763,-0.61459808,-0.41075326,1.7128137,-0.68850773,-0.61459808,-0.40970303,1.7148738,-0.68850773,-0.61459808,-0.4086629,1.7127531,-0.68849763,-0.61459808,-0.40656245,1.7138438,-0.68848753,-0.61459808,-0.41179339,1.7126623,-0.68851783,-0.61459808,-0.40761268,1.7149344,-0.68849763,-0.61459808,-0.40761268,1.714995,-0.68849763,-0.61459808,-0.40656245,1.7150455,-0.68848753,-0.61459808,-0.4086629,1.7155908,-0.68850773,-0.61355795,-0.40970303,1.7148536,-0.68849763,-0.61459808,-0.40970303,1.7152474,-0.68850773,-0.61459808,-0.4044721,1.7143992,-0.68848753,-0.61459808,-0.41075326,1.7154494,-0.68850773,-0.61459808,-0.40656245,1.7145002,-0.68848753,-0.61459808,-0.40656245,1.7145809,-0.68848753,-0.61459808,-0.4086629,1.7131773,-0.68849763,-0.61459808,-0.40761268,1.7144901,-0.68849763,-0.61459808,-0.40552232,1.7149344,-0.68848753,-0.61459808,-0.40552232,1.7140255,-0.68848753,-0.61459808,-0.41075326,1.713763,-0.68850773,-0.61459808,-0.40656245,1.7137428,-0.68849763,-0.61459808,-0.40970303,1.7135004,-0.68850773,-0.61459808,-0.4086629,1.7145002,-0.68849763,-0.61459808,-0.40970303,1.7141265,-0.68850773,-0.61459808,-0.40656245,1.7144598,-0.68848753,-0.61355795,-0.4086629,1.7151061,-0.68849763,-0.61459808,-0.40970303,1.7139044,-0.68850773,-0.61459808,-0.4086629,1.714591,-0.68849763,-0.61459808,-0.4086629,1.7143588,-0.68849763,-0.61459808,-0.40656245,1.7138438,-0.68848753,-0.61459808,-0.41179339,1.7143487,-0.68851783,-0.61459808,-0.4086629,1.7134802,-0.68849763,-0.61459808,-0.40970303,1.7113798,-0.68850773,-0.61459808,-0.40552232,1.7113697,-0.68848753,-0.61459808,-0.41179339,1.7111879,-0.68850773,-0.61459808,-0.4086629,1.7119655,-0.68849763,-0.61459808,-0.4086629,1.7174691,-0.68850773,-0.61459808,-0.41075326,1.7148132,-0.68850773,-0.61459808,-0.40552232,1.7152777,-0.68848753,-0.61459808,-0.40656245,1.7167117,-0.68849763,-0.6156483,-0.40761268,1.7155504,-0.68849763,-0.61459808,-0.40970303,1.717257,-0.68850773,-0.61459808,-0.4044721,1.7173984,-0.68847744,-0.61459808,-0.40552232,1.7173883,-0.68848753,-0.61459808,-0.40656245,1.7177215,-0.68849763,-0.61459808,-0.40761268,1.7182264,-0.68849763,-0.61459808,-0.40761268,1.7183678,-0.68849763,-0.61459808,-0.40552232,1.718287,-0.68848753,-0.61459808,-0.40656245,1.7181154,-0.68849763,-0.61355795,-0.40970303,1.7178124,-0.68850773,-0.61459808,-0.40761268,1.7191959,-0.68849763,-0.61459808,-0.4044721,1.7195695,-0.68848753,-0.61355795,-0.40656245,1.7190949,-0.68848753,-0.61355795,-0.41075326,1.7191757,-0.68850773,-0.61355795,-0.40656245,1.7189838,-0.68849763,-0.61355795,-0.4086629,1.7193776,-0.68849763,-0.61355795,-0.40656245,1.7188525,-0.68848753,-0.61355795,-0.41179339,1.7180851,-0.68851783,-0.61355795,-0.4086629,1.7180245,-0.68849763,-0.61355795,-0.4086629,1.7180245,-0.68849763,-0.61355795,-0.40761268,1.7185597,-0.68849763,-0.61355795,-0.41179339,1.7192161,-0.68851783,-0.61355795,-0.40761268,1.7186304,-0.68849763,-0.61355795,-0.40552232,1.7200037,-0.68848753,-0.61459808,-0.4086629,1.7149243,-0.68849763,-0.61459808,-0.41075326,1.7148637,-0.68850773,-0.61355795,-0.41075326,1.7156312,-0.68850773,-0.61459808,-0.40761268,1.7160755,-0.68849763,-0.61355795,-0.4086629,1.7161765,-0.68850773,-0.61355795,-0.40970303,1.7168935,-0.68850773,-0.61355795,-0.41075326,1.7170348,-0.68850773,-0.61355795,-0.4086629,1.7167521,-0.68849763,-0.61355795,-0.40970303,1.7155201,-0.68850773,-0.61459808,-0.40970303,1.7157322,-0.68850773,-0.61355795,-0.41179339,1.7161361,-0.68851783,-0.61459808,-0.4086629,1.71551,-0.68849763,-0.61459808,-0.41075326,1.7157826,-0.68850773,-0.61459808,-0.40552232,1.7176205,-0.68848753,-0.61459808,-0.41284361,1.7153383,-0.68851783,-0.61355795,-0.4086629,1.7166208,-0.68849763,-0.61250772,-0.41075326,1.724447,-0.68850773,-0.61250772,-0.40552232,1.7229121,-0.68848753,-0.61355795,-0.41075326,1.7234574,-0.68851783,-0.61250772,-0.40761268,1.7230332,-0.68849763,-0.61250772,-0.40552232,1.7254871,-0.68848753,-0.61250772,-0.40656245,1.724861,-0.68849763,-0.61355795,-0.40761268,1.7255477,-0.68849763,-0.61250772,-0.40970303,1.7264364,-0.68850773,-0.61250772,-0.40656245,1.7264061,-0.68849763,-0.61250772,-0.40761268,1.7266888,-0.68849763,-0.61250772,-0.4044721,1.7263657,-0.68848753,-0.61250772,-0.41075326,1.72578,-0.68851783,-0.61355795,-0.40656245,1.72578,-0.68849763,-0.61355795,-0.4086629,1.7262445,-0.68850773,-0.61250772,-0.40656245,1.7254467,-0.68849763,-0.61250772,-0.40970303,1.7259517,-0.68850773,-0.61250772,-0.4086629,1.7255679,-0.68850773,-0.61355795,-0.40656245,1.7228414,-0.68849763,-0.61355795,-0.40761268,1.7230332,-0.68849763,-0.61355795,-0.40970303,1.7221446,-0.68850773,-0.61355795,-0.41179339,1.7224677,-0.68851783,-0.61355795,-0.40761268,1.7203976,-0.68849763,-0.61355795,-0.40970303,1.7208116,-0.68850773,-0.61355795,-0.40552232,1.7202663,-0.68848753,-0.61355795,-0.41179339,1.7186506,-0.68851783,-0.61355795,-0.4086629,1.7186506,-0.68850773,-0.61355795,-0.40761268,1.7184587,-0.68849763,-0.61355795,-0.40970303,1.7191555,-0.68850773,-0.61459808,-0.40761268,1.7199634,-0.68849763,-0.61355795,-0.41179339,1.7190242,-0.68851783,-0.61459808,-0.40761268,1.719105,-0.68850773,-0.61355795,-0.41075326,1.719519,-0.68851783,-0.61459808,-0.40761268,1.7175902,-0.68849763,-0.61459808,-0.41075326,1.7179235,-0.68851783,-0.61459808,-0.41075326,1.7173277,-0.68851783,-0.61459808,-0.4086629,1.7169036,-0.68850773,-0.61459808,-0.41075326,1.7160452,-0.68851783,-0.61459808,-0.40656245,1.7179942,-0.68849763,-0.61459808,-0.41179339,1.7188727,-0.68851783,-0.61250772,-0.40970303,1.7199129,-0.68849763,-0.61355795,-0.40761268,1.7187415,-0.68849763,-0.61459808,-0.4086629,1.7179538,-0.68850773,-0.61459808,-0.4086629,1.7190949,-0.68850773,-0.61355795,-0.41179339,1.7179336,-0.68851783,-0.61355795,-0.4086629,1.7181356,-0.68850773,-0.61355795,-0.41179339,1.7178225,-0.68851783,-0.61355795,-0.4086629,1.7177215,-0.68849763,-0.61355795,-0.41075326,1.7177417,-0.68850773,-0.61355795,-0.40970303,1.7186001,-0.68850773,-0.61355795,-0.4086629,1.7186405,-0.68849763,-0.61355795,-0.41075326,1.7186809,-0.68850773,-0.61250772,-0.40656245,1.7209732,-0.68848753,-0.61250772,-0.40970303,1.7213569,-0.68850773,-0.61250772,-0.41075326,1.7211045,-0.68850773,-0.61355795,-0.40656245,1.7212458,-0.68849763,-0.61355795,-0.4086629,1.7208015,-0.68850773,-0.61355795,-0.40552232,1.7212761,-0.68848753,-0.61355795,-0.41179339,1.7211752,-0.68851783,-0.61355795,-0.4086629,1.7203673,-0.68849763,-0.61355795,-0.40656245,1.7196301,-0.68848753,-0.61355795,-0.40761268,1.7197109,-0.68849763,-0.61355795,-0.4044721,1.7201148,-0.68848753,-0.61355795,-0.4086629,1.7195796,-0.68849763,-0.61250772,-0.41179339,1.7215185,-0.68851783,-0.61355795,-0.40761268,1.7197917,-0.68849763,-0.61355795,-0.40761268,1.7204481,-0.68849763,-0.61355795,-0.40552232,1.7212256,-0.68848753,-0.61355795,-0.41179339,1.7222759,-0.68851783,-0.61355795,-0.40761268,1.7239623,-0.68849763,-0.61355795,-0.40552232,1.7220638,-0.68849763,-0.61355795,-0.40761268,1.7233665,-0.68850773,-0.61355795,-0.41075326,1.7211752,-0.68851783,-0.61355795,-0.41075326,1.7221749,-0.68851783,-0.61355795,-0.40656245,1.7223769,-0.68849763,-0.61355795,-0.40552232,1.7218012,-0.68848753,-0.61355795,-0.40761268,1.7209833,-0.68849763,-0.61355795,-0.41075326,1.721569,-0.68851783,-0.61355795,-0.41179339,1.7223163,-0.68851783,-0.61250772,-0.40970303,1.7215791,-0.68850773,-0.61355795,-0.40656245,1.7214074,-0.68849763,-0.61355795,-0.40761268,1.7213569,-0.68849763,-0.61355795,-0.41075326,1.7217003,-0.68850773,-0.61250772,-0.41179339,1.7229424,-0.68851783,-0.61250772,-0.40761268,1.7231039,-0.68849763,-0.61250772,-0.40656245,1.7234271,-0.68849763,-0.61355795,-0.40761268,1.7229828,-0.68849763,-0.61355795,-0.4086629,1.7229222,-0.68850773,-0.6114575,-0.41284361,1.7237401,-0.68851783,-0.61250772,-0.4086629,1.7232655,-0.68850773,-0.61250772,-0.40656245,1.7240734,-0.68849763,-0.61250772,-0.4086629,1.7239421,-0.68849763,-0.61250772,-0.40552232,1.7244571,-0.68848753,-0.61250772,-0.41179339,1.7272442,-0.68851783,-0.61250772,-0.4086629,1.7264364,-0.68850773,-0.6114575,-0.40656245,1.7278804,-0.68849763,-0.6114575,-0.4086629,1.7274058,-0.68850773,-0.6114575,-0.40552232,1.72886,-0.68848753,-0.61250772,-0.41075326,1.7287085,-0.68851783,-0.61250772,-0.40761268,1.7293649,-0.68849763,-0.61250772,-0.40656245,1.7289913,-0.68849763,-0.61355795,-0.40970303,1.7221951,-0.68850773,-0.61355795,-0.40656245,1.7225788,-0.68849763,-0.61355795,-0.40970303,1.7219325,-0.68850773,-0.61355795,-0.41075326,1.7211146,-0.68851783,-0.61355795,-0.4086629,1.7205592,-0.68850773,-0.61355795,-0.40970303,1.7215286,-0.68850773,-0.61355795,-0.40761268,1.7214579,-0.68849763,-0.61355795,-0.41075326,1.7240936,-0.68851783,-0.61355795,-0.40656245,1.7206399,-0.68849763,-0.61355795,-0.41075326,1.7192868,-0.68850773,-0.61459808,-0.40970303,1.7196705,-0.68850773,-0.61459808,-0.40656245,1.7219123,-0.68849763,-0.61459808,-0.40970303,1.7205289,-0.68850773,-0.61355795,-0.41179339,1.7202259,-0.68852793,-0.61355795,-0.4086629,1.7201956,-0.68850773,-0.61459808,-0.40656245,1.7207914,-0.68849763,-0.61459808,-0.4086629,1.720135,-0.68850773,-0.61355795,-0.40552232,1.7211247,-0.68849763,-0.61355795,-0.41179339,1.7214882,-0.68851783,-0.61355795,-0.40970303,1.7203471,-0.68850773,-0.61459808,-0.4086629,1.7202966,-0.68850773,-0.61355795,-0.41179339,1.720438,-0.68851783,-0.61459808,-0.40761268,1.7204784,-0.68849763,-0.61459808,-0.41075326,1.7199936,-0.68851783,-0.61250772,-0.40656245,1.7258608,-0.68849763,-0.61250772,-0.4086629,1.7267696,-0.68850773,-0.61250772,-0.40552232,1.7260627,-0.68849763,-0.61250772,-0.40761268,1.7268201,-0.68850773,-0.61250772,-0.40552232,1.7261839,-0.68848753,-0.61250772,-0.41075326,1.7258507,-0.68851783,-0.6114575,-0.40970303,1.7270625,-0.68850773,-0.61250772,-0.40761268,1.7270019,-0.68849763,-0.6114575,-0.40970303,1.7275674,-0.68850773,-0.6114575,-0.40970303,1.7275674,-0.68850773,-0.6114575,-0.40970303,1.7275674,-0.68850773,-0.6114575,-0.40970303,1.7275674,-0.68850773,-0.6114575,-0.40970303,1.7275674,-0.68850773,-0.6114575,-0.40970303,1.7275674,-0.68850773:6
-0.71359442,-0.71359442,1.723209,-0.71359442,-0.71359442,-0.71359442,1.7044972,-0.71359442,-0.71359442,-0.71359442,1.7223134,-0.71359442,-0.71359442,-0.71359442,1.7239553,-0.71359442,-0.71359442,-0.71359442,1.7153404,-0.71359442,-0.71359442,-0.71359442,1.7229531,-0.71359442,-0.71359442,-0.71359442,1.7261624,-0.71359442,-0.71359442,-0.71359442,1.7148713,-0.71359442,-0.71359442,-0.71359442,1.721695,-0.71359442,-0.71359442,-0.71359442,1.7275911,-0.71359442,-0.71359442,-0.71359442,1.7194453,-0.71359442,-0.71359442,-0.71359442,1.7155323,-0.71359442,-0.71359442,-0.71359442,1.7268554,-0.71359442,-0.71359442,-0.71359442,1.7211726,-0.71359442,-0.71359442,-0.71359442,1.7218229,-0.71359442,-0.71359442,-0.71359442,1.7323463,-0.71359442,-0.71359442,-0.71359442,1.730875,-0.71359442,-0.71359442,-0.71359442,1.7321438,-0.71359442,-0.71359442,-0.71359442,1.7268981,-0.71359442,-0.71359442,-0.71359442,1.7364512,-0.71359442,-0.71359442,-0.71359442,1.7295742,-0.71359442,-0.71359442,-0.71359442,1.7247017,-0.71359442,-0.71359442,-0.71359442,1.7288919,-0.71359442,-0.71359442,-0.71359442,1.7306298,-0.71359442,-0.71359442,-0.71359442,1.7357369,-0.71359442,-0.71359442,-0.71359442,1.7198824,-0.71359442,-0.71359442,-0.71359442,1.7221961,-0.71359442,-0.71359442,-0.71359442,1.7274418,-0.71359442,-0.71359442,-0.71359442,1.7191574,-0.71359442,-0.71359442,-0.71359442,1.709391,-0.71359442,-0.71359442,-0.71359442,1.7286573,-0.71359442,-0.71359442,-0.71359442,1.7185284,-0.71359442,-0.71359442,-0.71359442,1.6999658,-0.71359442,-0.71359442,-0.71359442,1.7088153,-0.71359442,-0.71359442,-0.71359442,1.707909,-0.71359442,-0.71359442,-0.71359442,1.7031111,-0.71359442,-0.5425224,-0.45753548,1.7036122,-0.71205909,-0.54031536,-0.40014186,1.7197225,-0.71181386,-0.53479244,-0.45532844,1.7182725,-0.71203777,-0.53479244,-0.43766148,1.7204369,-0.71195247,-0.52707314,-0.45091437,1.7319412,-0.71200578,-0.53590129,-0.43104037,1.7198398,-0.71193115,-0.53920651,-0.40014186,1.7202343,-0.7118032,-0.52928018,-0.45091437,1.726365,-0.71200578,-0.53699947,-0.42221223,1.7202556,-0.71189916,-0.53479244,-0.42441926,1.7236781,-0.71190982,-0.53479244,-0.42221223,1.723934,-0.71189916,-0.53369425,-0.42111404,1.7255013,-0.7118885,-0.53148721,-0.42221223,1.7294783,-0.7118885,-0.53699947,-0.42221223,1.7221215,-0.71189916,-0.53590129,-0.42552811,1.7216417,-0.71190982,-0.53479244,-0.42552811,1.7238274,-0.71190982,-0.53479244,-0.42221223,1.7245844,-0.71189916,-0.53590129,-0.42221223,1.7232197,-0.71189916,-0.53590129,-0.42111404,1.7234649,-0.71189916,-0.53479244,-0.42221223,1.7245524,-0.71189916,-0.5325854,-0.42552811,1.7269834,-0.71190982,-0.53920651,-0.4266263,1.7168118,-0.71192048,-0.5325854,-0.42441926,1.7278043,-0.71189916,-0.5325854,-0.42441926,1.7265889,-0.71190982,-0.53920651,-0.42773515,1.7170464,-0.71193115,-0.5325854,-0.42332108,1.7285507,-0.71189916,-0.53148721,-0.42221223,1.7304378,-0.7118885,-0.53810832,-0.4266263,1.719296,-0.71192048,-0.53590129,-0.4266263,1.7228785,-0.71192048,-0.53148721,-0.42552811,1.7290198,-0.71190982,-0.53920651,-0.42552811,1.7191041,-0.71192048,-0.53369425,-0.42221223,1.7257039,-0.71189916,-0.53148721,-0.42111404,1.7300114,-0.7118885,-0.53479244,-0.42552811,1.7245418,-0.71190982,-0.53369425,-0.42773515,1.7262903,-0.71192048,-0.52928018,-0.42441926,1.7335725,-0.71189916,-0.53148721,-0.42552811,1.7292437,-0.71190982,-0.5325854,-0.42221223,1.7276444,-0.71189916,-0.53148721,-0.42552811,1.7291051,-0.71190982,-0.53369425,-0.42552811,1.7262583,-0.71190982,-0.52928018,-0.42552811,1.7312695,-0.71189916,-0.53479244,-0.4266263,1.7247443,-0.71192048,-0.53479244,-0.42441926,1.7232197,-0.71190982,-0.52817133,-0.42332108,1.7322184,-0.7118885,-0.53479244,-0.4266263,1.7231983,-0.71192048,-0.53479244,-0.42552811,1.7239873,-0.71190982,-0.53479244,-0.42883334,1.7245418,-0.71192048,-0.53699947,-0.42441926,1.7225053,-0.71190982,-0.5325854,-0.42552811,1.7273245,-0.71190982,-0.53810832,-0.42994219,1.717782,-0.71194181,-0.53479244,-0.42773515,1.7238381,-0.71192048,-0.53148721,-0.4266263,1.7296169,-0.71190982,-0.53590129,-0.42552811,1.7223667,-0.71190982,-0.53148721,-0.42552811,1.7300753,-0.71190982,-0.53148721,-0.42552811,1.7299154,-0.71190982,-0.53920651,-0.42883334,1.717782,-0.71193115,-0.53590129,-0.42552811,1.7227719,-0.71190982,-0.53148721,-0.42552811,1.730054,-0.71190982,-0.53810832,-0.42773515,1.7194453,-0.71193115,-0.52928018,-0.42773515,1.7328261,-0.71190982,-0.53369425,-0.42441926,1.7266635,-0.71190982,-0.53037836,-0.42441926,1.7310562,-0.71189916,-0.5325854,-0.4266263,1.7279962,-0.71190982,-0.53479244,-0.42883334,1.7241473,-0.71193115,-0.52817133,-0.42332108,1.7347986,-0.7118885,-0.5325854,-0.42552811,1.7280176,-0.71190982,-0.5325854,-0.42773515,1.7279216,-0.71192048,-0.53810832,-0.42883334,1.7193174,-0.71193115,-0.53590129,-0.4266263,1.7228465,-0.71192048,-0.53590129,-0.42552811,1.7232516,-0.71192048,-0.53369425,-0.42773515,1.7250855,-0.71192048,-0.53369425,-0.42883334,1.7256293,-0.71192048,-0.53037836,-0.42332108,1.7316213,-0.71189916,-0.53369425,-0.42773515,1.7268981,-0.71192048,-0.5325854,-0.4266263,1.7283374,-0.71192048,-0.53148721,-0.42773515,1.7292224,-0.71192048,-0.5325854,-0.42441926,1.7281455,-0.71190982,-0.53369425,-0.4266263,1.72709,-0.71192048,-0.53148721,-0.4266263,1.7293823,-0.71190982,-0.53590129,-0.42994219,1.7236142,-0.71193115,-0.53590129,-0.4266263,1.7234755,-0.71192048,-0.53479244,-0.42773515,1.7245737,-0.71192048,-0.53037836,-0.4266263,1.7324743,-0.71190982,-0.53810832,-0.42994219,1.7202769,-0.71193115,-0.53369425,-0.42552811,1.7266955,-0.71190982,-0.52155022,-0.4266263,1.7443518,-0.7118885,-0.52596429,-0.42773515,1.7380825,-0.71190982,-0.5248661,-0.42221223,1.7407693,-0.71187784,-0.52707314,-0.42552811,1.7373148,-0.71189916,-0.52707314,-0.42552811,1.7368351,-0.71189916,-0.52596429,-0.42773515,1.7374428,-0.71190982,-0.52596429,-0.42441926,1.7384663,-0.7118885,-0.5248661,-0.4266263,1.7396605,-0.71189916,-0.53148721,-0.42883334,1.7298408,-0.71192048,-0.5325854,-0.42773515,1.7282521,-0.71192048,-0.52707314,-0.42552811,1.736867,-0.71189916,-0.53148721,-0.42883334,1.7290838,-0.71192048,-0.52707314,-0.42332108,1.7364406,-0.7118885,-0.5226484,-0.42441926,1.7433495,-0.7118885,-0.52817133,-0.4266263,1.7347773,-0.71189916,-0.52596429,-0.42773515,1.7378053,-0.71190982,-0.52928018,-0.42552811,1.7334872,-0.71189916,-0.53369425,-0.42883334,1.7266528,-0.71193115,-0.52928018,-0.42773515,1.7327728,-0.71190982,-0.5325854,-0.42552811,1.7285293,-0.71190982,-0.53369425,-0.42994219,1.7258852,-0.71193115,-0.52707314,-0.4266263,1.7359608,-0.71189916,-0.53369425,-0.42552811,1.727026,-0.71190982,-0.52928018,-0.4266263,1.7332526,-0.71190982,-0.5325854,-0.42883334,1.7282948,-0.71192048,-0.53037836,-0.42552811,1.731568,-0.71189916,-0.53037836,-0.42883334,1.7318346,-0.71192048,-0.53369425,-0.42994219,1.7260131,-0.71193115,-0.52817133,-0.42332108,1.7346387,-0.7118885,-0.52928018,-0.42883334,1.7321438,-0.71192048,-0.53037836,-0.42883334,1.730843,-0.71192048,-0.52928018,-0.42441926,1.7337857,-0.71189916,-0.53590129,-0.42994219,1.723177,-0.71193115,-0.5325854,-0.42883334,1.7265355,-0.71192048,-0.52928018,-0.42441926,1.7335405,-0.71189916,-0.5325854,-0.42883334,1.7273565,-0.71192048,-0.5325854,-0.43104037,1.7259171,-0.71193115,-0.52707314,-0.42441926,1.7357582,-0.71189916,-0.5325854,-0.42883334,1.7268447,-0.71192048,-0.53369425,-0.43104037,1.7248509,-0.71193115,-0.53479244,-0.42883334,1.7250215,-0.71193115,-0.53699947,-0.42994219,1.7205435,-0.71193115,-0.53590129,-0.43104037,1.7227612,-0.71194181,-0.53479244,-0.42883334,1.7247657,-0.71193115,-0.53590129,-0.43104037,1.722452,-0.71194181,-0.53590129,-0.42883334,1.7220362,-0.71193115,-0.5325854,-0.42883334,1.727026,-0.71192048,-0.5325854,-0.43104037,1.7276124,-0.71193115,-0.54141355,-0.42994219,1.71469,-0.71194181,-0.53479244,-0.43214922,1.7219509,-0.71194181,-0.53369425,-0.43214922,1.7237741,-0.71194181,-0.5425224,-0.42994219,1.7122804,-0.71194181,-0.53590129,-0.43104037,1.7224307,-0.71194181,-0.5325854,-0.4266263,1.7283054,-0.71190982,-0.53148721,-0.42883334,1.7288279,-0.71192048,-0.54031536,-0.43324741,1.7152765,-0.71195247,-0.53699947,-0.42883334,1.7201064,-0.71193115,-0.53590129,-0.43104037,1.7219935,-0.71194181,-0.53148721,-0.42994219,1.7280496,-0.71193115,-0.53810832,-0.42994219,1.7187736,-0.71194181,-0.53590129,-0.42994219,1.7221321,-0.71193115,-0.53037836,-0.42883334,1.7297555,-0.71192048,-0.53148721,-0.42883334,1.7296808,-0.71192048,-0.53590129,-0.43214922,1.7219722,-0.71194181,-0.53590129,-0.42773515,1.7220575,-0.71193115,-0.52928018,-0.42773515,1.7327728,-0.71192048,-0.53479244,-0.42883334,1.7250002,-0.71193115,-0.53369425,-0.42994219,1.7254693,-0.71193115,-0.53369425,-0.43104037,1.7254267,-0.71194181,-0.53148721,-0.4266263,1.7298941,-0.71190982,-0.52928018,-0.42773515,1.732389,-0.71192048,-0.53148721,-0.43324741,1.7274312,-0.71194181,-0.5325854,-0.42883334,1.7264183,-0.71193115,-0.54031536,-0.43435626,1.7139864,-0.71196313,-0.53479244,-0.42994219,1.7241579,-0.71193115,-0.52928018,-0.42883334,1.730811,-0.71192048,-0.5325854,-0.4266263,1.7282948,-0.71190982,-0.53037836,-0.42883334,1.7299154,-0.71192048,-0.52707314,-0.42552811,1.735513,-0.71189916,-0.53037836,-0.42883334,1.7305871,-0.71192048,-0.5325854,-0.42994219,1.7276231,-0.71193115,-0.52707314,-0.42441926,1.7357795,-0.71189916,-0.52817133,-0.42883334,1.7335725,-0.71192048,-0.5248661,-0.4266263,1.7389461,-0.71189916,-0.53369425,-0.42994219,1.725384,-0.71193115,-0.53590129,-0.43104037,1.7222388,-0.71194181,-0.52817133,-0.42773515,1.7331353,-0.71190982,-0.53148721,-0.43104037,1.7274845,-0.71193115,-0.53479244,-0.42773515,1.7236035,-0.71192048,-0.53369425,-0.42773515,1.7259811,-0.71192048,-0.5325854,-0.43104037,1.7268128,-0.71193115,-0.53369425,-0.42994219,1.7243285,-0.71193115,-0.53699947,-0.43104037,1.7191574,-0.71194181,-0.53037836,-0.42773515,1.7300327,-0.71192048,-0.53479244,-0.42883334,1.7235395,-0.71193115,-0.53369425,-0.42773515,1.7255973,-0.71192048,-0.52928018,-0.42773515,1.7318452,-0.71192048,-0.52817133,-0.42883334,1.7329754,-0.71190982,-0.53699947,-0.43104037,1.7194027,-0.71194181,-0.5325854,-0.42994219,1.7271113,-0.71193115,-0.52707314,-0.42773515,1.7348199,-0.71190982,-0.5325854,-0.43104037,1.7265462,-0.71193115,-0.5325854,-0.42773515,1.7274418,-0.71192048,-0.52707314,-0.42773515,1.7353104,-0.71190982,-0.52928018,-0.4266263,1.7328475,-0.71190982,-0.53148721,-0.43104037,1.7275911,-0.71193115,-0.53369425,-0.43214922,1.7256399,-0.71194181,-0.53037836,-0.42883334,1.730907,-0.71192048,-0.5325854,-0.43104037,1.7275911,-0.71193115,-0.52817133,-0.4266263,1.7343295,-0.71190982,-0.52817133,-0.43104037,1.7344361,-0.71192048,-0.52928018,-0.4266263,1.7329647,-0.71190982,-0.5325854,-0.42994219,1.7267061,-0.71193115,-0.53148721,-0.4266263,1.7285933,-0.71192048,-0.53699947,-0.43104037,1.7196799,-0.71194181,-0.5325854,-0.4266263,1.7287639,-0.71192048,-0.5325854,-0.42994219,1.7281242,-0.71193115,-0.52928018,-0.42883334,1.732325,-0.71192048,-0.52928018,-0.42883334,1.73305,-0.71192048,-0.5325854,-0.43104037,1.7283374,-0.71193115,-0.5325854,-0.42883334,1.7279643,-0.71192048,-0.53037836,-0.43104037,1.7313121,-0.71193115,-0.52928018,-0.42552811,1.73321,-0.71190982,-0.53699947,-0.43104037,1.7217483,-0.71194181,-0.53148721,-0.42883334,1.7302246,-0.71192048,-0.5248661,-0.42883334,1.7390954,-0.71190982,-0.53479244,-0.42883334,1.72403,-0.71193115,-0.52596429,-0.42773515,1.7366538,-0.71190982,-0.52596429,-0.42994219,1.7365259,-0.71192048,-0.5502417,-0.43545445,1.6976202,-0.71198446,-0.53148721,-0.42994219,1.7305125,-0.71192048,-0.53369425,-0.42994219,1.7266422,-0.71193115,-0.53479244,-0.43214922,1.7239553,-0.71194181,-0.53590129,-0.42883334,1.7229638,-0.71193115,-0.5325854,-0.43104037,1.727783,-0.71193115,-0.53148721,-0.4266263,1.7318346,-0.71190982,-0.53479244,-0.43214922,1.7250855,-0.71194181,-0.53920651,-0.43104037,1.7187203,-0.71194181,-0.53037836,-0.42994219,1.7303632,-0.71193115,-0.53369425,-0.43104037,1.7266528,-0.71193115,-0.53479244,-0.43104037,1.7243712,-0.71194181,-0.53148721,-0.42883334,1.7308537,-0.71192048,-0.53699947,-0.43214922,1.7204369,-0.71195247,-0.53148721,-0.42994219,1.7289452,-0.71193115,-0.53699947,-0.43104037,1.7213965,-0.71194181,-0.53810832,-0.43324741,1.7187416,-0.71195247,-0.53479244,-0.42883334,1.7239127,-0.71193115,-0.53699947,-0.43324741,1.7199784,-0.71195247,-0.53699947,-0.42883334,1.7214391,-0.71193115,-0.5325854,-0.42773515,1.7284121,-0.71192048,-0.5325854,-0.42883334,1.727719,-0.71193115,-0.53810832,-0.43324741,1.7181552,-0.71196313,-0.5325854,-0.43104037,1.7269514,-0.71193115,-0.53369425,-0.43214922,1.724627,-0.71194181,-0.5425224,-0.43104037,1.7123231,-0.71195247,-0.53369425,-0.43104037,1.7257999,-0.71194181,-0.53369425,-0.43214922,1.7254907,-0.71194181,-0.53369425,-0.42994219,1.7263543,-0.71193115,-0.53699947,-0.43214922,1.7207567,-0.71195247,-0.54141355,-0.43324741,1.7142636,-0.71196313,-0.53369425,-0.43324741,1.7249256,-0.71195247,-0.53590129,-0.43104037,1.7228038,-0.71194181,-0.54141355,-0.43324741,1.7139544,-0.71196313,-0.54141355,-0.43324741,1.7135172,-0.71196313,-0.54031536,-0.43435626,1.7143809,-0.71196313,-0.54362059,-0.43324741,1.7104466,-0.71196313,-0.53699947,-0.43104037,1.720842,-0.71194181,-0.54141355,-0.43324741,1.713368,-0.71196313,-0.5425224,-0.43324741,1.7111396,-0.71196313,-0.53920651,-0.42883334,1.7182512,-0.71194181,-0.54472943,-0.43435626,1.7070774,-0.71197379,-0.5425224,-0.43214922,1.712515,-0.71196313,-0.54472943,-0.43545445,1.7073013,-0.71197379,-0.54472943,-0.43104037,1.7074932,-0.71196313,-0.53920651,-0.43214922,1.7173129,-0.71195247,-0.54472943,-0.43214922,1.7083781,-0.71196313,-0.54472943,-0.43545445,1.7075039,-0.71197379,-0.53920651,-0.43104037,1.71775,-0.71194181,-0.5425224,-0.43435626,1.7116301,-0.71196313,-0.54693647,-0.43545445,1.7045185,-0.71197379,-0.5425224,-0.43214922,1.7126429,-0.71195247,-0.5425224,-0.43104037,1.7128242,-0.71195247,-0.54362059,-0.43435626,1.7096896,-0.71196313,-0.54362059,-0.43214922,1.7111503,-0.71196313,-0.54472943,-0.43545445,1.707845,-0.71197379,-0.54362059,-0.43545445,1.7108091,-0.71197379,-0.54693647,-0.43435626,1.7046038,-0.71197379,-0.5425224,-0.43435626,1.7120992,-0.71197379,-0.5425224,-0.43324741,1.7116087,-0.71196313,-0.54693647,-0.43545445,1.7056806,-0.71197379,-0.54031536,-0.43324741,1.7160228,-0.71196313,-0.54031536,-0.43545445,1.7143169,-0.71196313,-0.54582762,-0.43435626,1.7061711,-0.71197379,-0.54582762,-0.43214922,1.706395,-0.71196313,-0.53920651,-0.43214922,1.7171103,-0.71195247,-0.54141355,-0.43435626,1.7125683,-0.71196313,-0.54141355,-0.43214922,1.7141036,-0.71195247,-0.54031536,-0.43324741,1.7140717,-0.71195247,-0.5425224,-0.43214922,1.7122804,-0.71196313,-0.54141355,-0.43435626,1.7133893,-0.71196313,-0.54472943,-0.43324741,1.7075572,-0.71196313,-0.54362059,-0.43435626,1.7104039,-0.71197379,-0.54914351,-0.43435626,1.698857,-0.71197379,-0.54582762,-0.4365633,1.7063417,-0.71198446,-0.54582762,-0.43324741,1.7069068,-0.71196313,-0.54141355,-0.43214922,1.7142529,-0.71195247,-0.54362059,-0.43324741,1.709359,-0.71196313,-0.54582762,-0.43435626,1.70712,-0.71197379,-0.54472943,-0.43324741,1.7082715,-0.71196313,-0.53920651,-0.43324741,1.7161614,-0.71196313,-0.54141355,-0.43214922,1.7144235,-0.71195247,-0.53920651,-0.43324741,1.717121,-0.71196313,-0.53920651,-0.43324741,1.7172489,-0.71195247,-0.54582762,-0.43104037,1.7075145,-0.71196313,-0.54693647,-0.43435626,1.7038788,-0.71197379,-0.54362059,-0.43545445,1.7092418,-0.71197379,-0.54472943,-0.43435626,1.7068855,-0.71197379,-0.5524594,-0.4365633,1.6944322,-0.71199512,-0.54582762,-0.4365633,1.7040067,-0.71198446,-0.54693647,-0.43214922,1.7032924,-0.71196313,-0.5502417,-0.43545445,1.6964367,-0.71198446,-0.54693647,-0.43214922,1.7044865,-0.71196313,-0.54362059,-0.43324741,1.7083675,-0.71196313,-0.54472943,-0.43104037,1.7069494,-0.71196313,-0.5425224,-0.43324741,1.7113955,-0.71196313,-0.54472943,-0.43104037,1.7087726,-0.71195247,-0.5425224,-0.43545445,1.7103719,-0.71197379,-0.5502417,-0.43435626,1.6967992,-0.71198446,-0.54914351,-0.43545445,1.7009894,-0.71198446,-0.5425224,-0.43104037,1.7116087,-0.71195247,-0.54362059,-0.43435626,1.7098175,-0.71197379,-0.54472943,-0.43545445,1.7075891,-0.71197379,-0.54693647,-0.43545445,1.7032604,-0.71197379,-0.54582762,-0.43435626,1.705702,-0.71197379,-0.54362059,-0.43545445,1.7086234,-0.71197379,-0.54472943,-0.43324741,1.7067788,-0.71197379,-0.54362059,-0.43104037,1.7100947,-0.71195247,-0.53699947,-0.43214922,1.7196372,-0.71195247,-0.53699947,-0.43214922,1.7196372,-0.71195247,-0.53699947,-0.43214922,1.7196372,-0.71195247,-0.53699947,-0.43214922,1.7196372,-0.71195247,-0.53699947,-0.43214922,1.7196372,-0.71195247,-0.53699947,-0.43214922,1.7196372,-0.71195247,-0.53699947,-0.43214922,1.7196372,-0.71195247:6
-0.62873193,-0.49726079,1.7219884,-0.58483351,-0.58526139,-0.58526139,1.7206334,-0.58526139,-0.58526139,-0.58526139,1.7226098,-0.58526139,-0.58526139,-0.58526139,1.7202157,-0.58526139,-0.58526139,-0.58526139,1.7205825,-0.58526139,-0.58526139,-0.58526139,1.7255846,-0.58526139,-0.58526139,-0.58526139,1.725717,-0.58526139,-0.58526139,-0.58526139,1.724576,-0.58526139,-0.58526139,-0.58526139,1.725768,-0.58526139,-0.58526139,-0.58526139,1.7251873,-0.58526139,-0.58526139,-0.58526139,1.7268988,-0.58526139,-0.58526139,-0.58526139,1.7272656,-0.58526139,-0.58526139,-0.58526139,1.7279074,-0.58526139,-0.58526139,-0.58526139,1.7273369,-0.58526139,-0.58526139,-0.58526139,1.7261144,-0.58526139,-0.58526139,-0.58526139,1.7263283,-0.58526139,-0.58526139,-0.58526139,1.7256152,-0.58526139,-0.58526139,-0.58526139,1.7255642,-0.58526139,-0.58526139,-0.58526139,1.7260023,-0.58526139,-0.58526139,-0.58526139,1.72588,-0.58526139,-0.58526139,-0.58526139,1.7255846,-0.58526139,-0.58526139,-0.58526139,1.7238629,-0.58526139,-0.58526139,-0.58526139,1.7233739,-0.58526139,-0.58526139,-0.58526139,1.723109,-0.58526139,-0.58526139,-0.58526139,1.7218967,-0.58526139,-0.58526139,-0.58526139,1.7224163,-0.58526139,-0.58526139,-0.58526139,1.7254827,-0.58526139,-0.58526139,-0.58526139,1.7228441,-0.58526139,-0.58526139,-0.58526139,1.7219374,-0.58526139,-0.58526139,-0.58526139,1.7228238,-0.58526139,-0.58526139,-0.58526139,1.7220597,-0.58526139,-0.58526139,-0.58526139,1.722783,-0.58526139,-0.58526139,-0.58526139,1.7239546,-0.58526139,-0.58526139,-0.58526139,1.7234045,-0.58526139,-0.58526139,-0.58526139,1.7263487,-0.58526139,-0.58526139,-0.58526139,1.7269905,-0.58526139,-0.58526139,-0.58526139,1.7279481,-0.58526139,-0.58526139,-0.58526139,1.726043,-0.58526139,-0.58526139,-0.58526139,1.7265219,-0.58526139,-0.58526139,-0.58526139,1.7268581,-0.58526139,-0.58526139,-0.58526139,1.7260329,-0.58526139,-0.58526139,-0.58526139,1.7266441,-0.58526139,-0.58526139,-0.58526139,1.7266951,-0.58526139,-0.58526139,-0.58526139,1.7266339,-0.58526139,-0.58526139,-0.58526139,1.7247696,-0.58526139,-0.58526139,-0.58526139,1.7241176,-0.58526139,-0.58526139,-0.58526139,1.7227117,-0.58526139,-0.58526139,-0.58526139,1.7238527,-0.58526139,-0.58526139,-0.58526139,1.7247594,-0.58526139,-0.58526139,-0.58526139,1.7229358,-0.58526139,-0.58526139,-0.58526139,1.7215911,-0.58526139,-0.58526139,-0.58526139,1.7224978,-0.58526139,-0.58526139,-0.58526139,1.7241685,-0.58526139,-0.58526139,-0.58526139,1.7208779,-0.58526139,-0.58526139,-0.58526139,1.7205519,-0.58526139,-0.58526139,-0.58526139,1.7224264,-0.58526139,-0.58526139,-0.58526139,1.7213771,-0.58526139,-0.58526139,-0.58526139,1.7225283,-0.58526139,-0.58526139,-0.58526139,1.7203074,-0.58526139,-0.58526139,-0.58526139,1.719961,-0.58526139,-0.58526139,-0.58526139,1.7219171,-0.58526139,-0.58526139,-0.58526139,1.7209798,-0.58526139,-0.58526139,-0.58526139,1.7231498,-0.58526139,-0.58526139,-0.58526139,1.7260329,-0.58526139,-0.58526139,-0.58526139,1.726532,-0.58526139,-0.58526139,-0.58526139,1.7282334,-0.58526139,-0.58526139,-0.58526139,1.7270822,-0.58526139,-0.58526139,-0.58526139,1.7267256,-0.58526139,-0.58526139,-0.58526139,1.7268784,-0.58526139,-0.58526139,-0.58526139,1.7273165,-0.58526139,-0.58526139,-0.58526139,1.7266849,-0.58526139,-0.58526139,-0.58526139,1.7271127,-0.58526139,-0.58526139,-0.58526139,1.7288956,-0.58526139,-0.58526139,-0.58526139,1.7284575,-0.58526139,-0.58526139,-0.58526139,1.7280704,-0.58526139,-0.58526139,-0.58526139,1.7288446,-0.58526139,-0.58526139,-0.58526139,1.7315342,-0.58526139,-0.58526139,-0.58526139,1.7287733,-0.58526139,-0.58526139,-0.58526139,1.7305052,-0.58526139,-0.58526139,-0.58526139,1.7281009,-0.58526139,-0.58526139,-0.58526139,1.7298125,-0.58526139,-0.58526139,-0.58526139,1.727887,-0.58526139,-0.58526139,-0.58526139,1.7279685,-0.58526139,-0.58526139,-0.58526139,1.7237406,-0.58526139,-0.58526139,-0.58526139,1.7246881,-0.58526139,-0.58526139,-0.58526139,1.7250345,-0.58526139,-0.58526139,-0.58526139,1.728916,-0.58526139,-0.58526139,-0.58526139,1.7253095,-0.58526139,-0.58526139,-0.58526139,1.7289363,-0.58526139,-0.58526139,-0.58526139,1.729242,-0.58526139,-0.58526139,-0.58526139,1.7296087,-0.58526139,-0.58526139,-0.58526139,1.7309127,-0.58526139,-0.58526139,-0.58526139,1.7310146,-0.58526139,-0.58526139,-0.58526139,1.7304543,-0.58526139,-0.58526139,-0.58526139,1.7315444,-0.58526139,-0.58526139,-0.58526139,1.733806,-0.58526139,-0.58526139,-0.58526139,1.7306478,-0.58526139,-0.58526139,-0.58526139,1.729843,-0.58526139,-0.58526139,-0.58526139,1.7288141,-0.58526139,-0.58526139,-0.58526139,1.7298838,-0.58526139,-0.58526139,-0.58526139,1.7294253,-0.58526139,-0.58526139,-0.58526139,1.7292012,-0.58526139,-0.58526139,-0.58526139,1.7291605,-0.58526139,-0.58526139,-0.58526139,1.7292012,-0.58526139,-0.58526139,-0.58526139,1.7286816,-0.58526139,-0.58526139,-0.58526139,1.7287224,-0.58526139,-0.58526139,-0.58526139,1.7309738,-0.58526139,-0.58526139,-0.58526139,1.7268071,-0.58526139,-0.58526139,-0.58526139,1.7290382,-0.58526139,-0.58526139,-0.58526139,1.7285594,-0.58526139,-0.58526139,-0.58526139,1.7322269,-0.58526139,-0.58526139,-0.58526139,1.7349776,-0.58526139,-0.58526139,-0.58526139,1.73511,-0.58526139,-0.58526139,-0.58526139,1.7367095,-0.58526139,-0.58526139,-0.58526139,1.7363529,-0.58526139,-0.58526139,-0.58526139,1.7362816,-0.58526139,-0.58526139,-0.58526139,1.7377282,-0.58526139,-0.58526139,-0.58526139,1.737443,-0.58526139,-0.58526139,-0.58526139,1.7372698,-0.58526139,-0.58526139,-0.58526139,1.7268377,-0.58526139,-0.58526139,-0.58526139,1.7286816,-0.58526139,-0.58526139,-0.58526139,1.7288956,-0.58526139,-0.58526139,-0.58526139,1.7263487,-0.58526139,-0.58526139,-0.58526139,1.7278157,-0.58526139,-0.58526139,-0.58526139,1.7272757,-0.58526139,-0.58526139,-0.58526139,1.7288039,-0.58526139,-0.58526139,-0.58526139,1.7273165,-0.58526139,-0.58526139,-0.58526139,1.7245251,-0.58526139,-0.58526139,-0.58526139,1.7258393,-0.58526139,-0.58526139,-0.58526139,1.7263385,-0.58526139,-0.58526139,-0.58526139,1.7287224,-0.58526139,-0.58526139,-0.58526139,1.7278768,-0.58526139,-0.58526139,-0.58526139,1.7291706,-0.58526139,-0.58526139,-0.58526139,1.7280704,-0.58526139,-0.58526139,-0.58526139,1.7288752,-0.58526139,-0.58526139,-0.58526139,1.72805,-0.58526139,-0.58526139,-0.58526139,1.7298023,-0.58526139,-0.58526139,-0.58526139,1.7306988,-0.58526139,-0.58526139,-0.58526139,1.7317685,-0.58526139,-0.58526139,-0.58526139,1.7327567,-0.58526139,-0.58526139,-0.58526139,1.7312999,-0.58526139,-0.58526139,-0.58526139,1.7306173,-0.58526139,-0.58526139,-0.58526139,1.7311674,-0.58526139,-0.58526139,-0.58526139,1.7291299,-0.58526139,-0.58526139,-0.58526139,1.7277444,-0.58526139,-0.58526139,-0.58526139,1.7277546,-0.58526139,-0.58526139,-0.58526139,1.7275814,-0.58526139,-0.58526139,-0.58526139,1.7277342,-0.58526139,-0.58526139,-0.58526139,1.7292929,-0.58526139,-0.58526139,-0.58526139,1.7291605,-0.58526139,-0.58526139,-0.58526139,1.728916,-0.58526139,-0.58526139,-0.58526139,1.7297717,-0.58526139,-0.58526139,-0.58526139,1.7299653,-0.58526139,-0.58526139,-0.58526139,1.7311572,-0.58526139,-0.58526139,-0.58526139,1.7319824,-0.58526139,-0.58526139,-0.58526139,1.7297004,-0.58526139,-0.58526139,-0.58526139,1.7331438,-0.58526139,-0.58526139,-0.58526139,1.7292114,-0.58526139,-0.58526139,-0.58526139,1.7297208,-0.58526139,-0.58526139,-0.58526139,1.7309229,-0.58526139,-0.58526139,-0.58526139,1.7328891,-0.58526139,-0.58526139,-0.58526139,1.730495,-0.58526139,-0.58526139,-0.58526139,1.7288548,-0.58526139,-0.58526139,-0.58526139,1.7335921,-0.58526139,-0.58526139,-0.58526139,1.7321556,-0.58526139,-0.58526139,-0.58526139,1.7321047,-0.58526139,-0.58526139,-0.58526139,1.7343765,-0.58526139,-0.61812663,-0.51104463,1.7322677,-0.58490482,-0.61812663,-0.51104463,1.7322371,-0.58490482,-0.61812663,-0.51104463,1.731687,-0.58490482,-0.61706712,-0.51104463,1.7303015,-0.58491501,-0.61812663,-0.51104463,1.7308007,-0.58490482,-0.61812663,-0.51104463,1.7317889,-0.58490482,-0.61812663,-0.51104463,1.7315138,-0.58490482,-0.61812663,-0.50998512,1.7327771,-0.58490482,-0.61918614,-0.50998512,1.7320334,-0.58490482,-0.61918614,-0.50892561,1.7307905,-0.58489464,-0.62024565,-0.50892561,1.7307497,-0.58489464,-0.62024565,-0.5078661,1.7302607,-0.58489464,-0.62236468,-0.50680659,1.7292318,-0.58488445,-0.62342419,-0.50467738,1.7300977,-0.58487426,-0.62342419,-0.50361786,1.731361,-0.58487426,-0.6244837,-0.50255835,1.7306275,-0.58486407,-0.6255534,-0.50149884,1.7312591,-0.58485389,-0.6255534,-0.50043933,1.730821,-0.58485389,-0.62661291,-0.49937982,1.7308822,-0.5848437,-0.62767242,-0.49937982,1.7296087,-0.5848437,-0.62767242,-0.4983203,1.7310655,-0.5848437,-0.62767242,-0.4983203,1.7302403,-0.5848437,-0.62873193,-0.49726079,1.7308822,-0.58483351,-0.62873193,-0.49620128,1.7312897,-0.58483351,-0.62873193,-0.49620128,1.7304033,-0.58483351,-0.62873193,-0.49620128,1.7308007,-0.58483351,-0.62873193,-0.49620128,1.7320537,-0.58483351,-0.62979145,-0.49514177,1.7295781,-0.58482332,-0.62979145,-0.49620128,1.7293031,-0.58482332,-0.62979145,-0.49514177,1.730658,-0.58482332,-0.62979145,-0.49514177,1.7291299,-0.58482332,-0.62979145,-0.49514177,1.7320945,-0.58482332,-0.62979145,-0.49514177,1.7334494,-0.58482332,-0.62979145,-0.49514177,1.7324205,-0.58482332,-0.62979145,-0.49514177,1.7336532,-0.58482332,-0.62979145,-0.49514177,1.7341422,-0.58482332,-0.62979145,-0.49514177,1.7319315,-0.58482332,-0.62979145,-0.49514177,1.7327261,-0.58482332,-0.62979145,-0.49514177,1.731636,-0.58482332,-0.62979145,-0.49514177,1.7325427,-0.58482332,-0.62979145,-0.49514177,1.7317685,-0.58482332,-0.62979145,-0.49514177,1.7299551,-0.58482332,-0.62979145,-0.49514177,1.732665,-0.58482332,-0.62979145,-0.49514177,1.7339996,-0.58482332,-0.62979145,-0.49514177,1.7338569,-0.58482332,-0.62979145,-0.49514177,1.7326039,-0.58482332,-0.62979145,-0.49514177,1.7329706,-0.58482332,-0.62979145,-0.49514177,1.7332457,-0.58482332,-0.62979145,-0.49514177,1.7328993,-0.58482332,-0.62979145,-0.49514177,1.7327872,-0.58482332,-0.62979145,-0.49514177,1.7348859,-0.58482332,-0.62979145,-0.49514177,1.7320945,-0.58482332,-0.62979145,-0.49514177,1.7336226,-0.58482332,-0.62979145,-0.49514177,1.7339894,-0.58482332,-0.62979145,-0.49514177,1.7323492,-0.58482332,-0.62979145,-0.49514177,1.7331744,-0.58482332,-0.62979145,-0.49514177,1.7318092,-0.58482332,-0.62979145,-0.49514177,1.7321454,-0.58482332,-0.62979145,-0.49514177,1.7324409,-0.58482332,-0.62979145,-0.49514177,1.7337958,-0.58482332,-0.62979145,-0.49514177,1.7328586,-0.58482332,-0.62979145,-0.49514177,1.733969,-0.58482332,-0.62979145,-0.49514177,1.7326039,-0.58482332,-0.62979145,-0.49514177,1.7328687,-0.58482332,-0.62979145,-0.49514177,1.7327057,-0.58482332,-0.62979145,-0.49514177,1.7325733,-0.58482332,-0.62979145,-0.49514177,1.7292216,-0.58482332,-0.62979145,-0.49620128,1.727072,-0.58482332,-0.62979145,-0.49620128,1.73022,-0.58482332,-0.62979145,-0.49514177,1.7328076,-0.58482332,-0.62979145,-0.49514177,1.7330725,-0.58482332,-0.62979145,-0.49514177,1.7341524,-0.58482332,-0.62979145,-0.49514177,1.7325427,-0.58482332,-0.62979145,-0.49514177,1.7279583,-0.58482332,-0.62979145,-0.49620128,1.7289465,-0.58482332,-0.62979145,-0.49514177,1.730821,-0.58482332,-0.62979145,-0.49620128,1.7315545,-0.58482332,-0.62979145,-0.49620128,1.730546,-0.58482332,-0.62979145,-0.49514177,1.7298328,-0.58482332,-0.62979145,-0.49514177,1.7297004,-0.58482332,-0.62979145,-0.49620128,1.7289975,-0.58482332,-0.62979145,-0.49620128,1.7293031,-0.58482332,-0.62979145,-0.49620128,1.7286511,-0.58482332,-0.62979145,-0.49620128,1.7274795,-0.58482332,-0.62979145,-0.49620128,1.7274082,-0.58482332,-0.62979145,-0.49620128,1.7268275,-0.58482332,-0.62979145,-0.49620128,1.7301996,-0.58482332,-0.62979145,-0.49620128,1.7304237,-0.58482332,-0.62979145,-0.49620128,1.7313406,-0.58482332,-0.62873193,-0.49620128,1.7320028,-0.58483351,-0.62979145,-0.49620128,1.7330521,-0.58482332,-0.62873193,-0.49620128,1.7329299,-0.58483351,-0.62873193,-0.49620128,1.7335309,-0.58483351,-0.62979145,-0.49620128,1.734621,-0.58482332,-0.62873193,-0.49620128,1.7326242,-0.58483351,-0.62979145,-0.49620128,1.7316768,-0.58482332,-0.62873193,-0.49620128,1.7320537,-0.58483351,-0.62873193,-0.49620128,1.7315647,-0.58483351,-0.62873193,-0.49620128,1.7327771,-0.58483351,-0.62873193,-0.49620128,1.7340607,-0.58483351,-0.62873193,-0.49620128,1.7328687,-0.58483351,-0.62873193,-0.49620128,1.7319213,-0.58483351,-0.62873193,-0.49620128,1.7325427,-0.58483351,-0.62873193,-0.49620128,1.731799,-0.58483351,-0.62873193,-0.49620128,1.7338569,-0.58483351,-0.62873193,-0.49620128,1.7356907,-0.58483351,-0.62873193,-0.49620128,1.733154,-0.58483351,-0.62873193,-0.49620128,1.7333272,-0.58483351,-0.62873193,-0.49620128,1.7336532,-0.58483351,-0.62873193,-0.49620128,1.7325224,-0.58483351,-0.62873193,-0.49620128,1.7378505,-0.58483351,-0.62873193,-0.49620128,1.7394907,-0.58483351,-0.62873193,-0.49620128,1.7394194,-0.58483351,-0.62873193,-0.49620128,1.7382274,-0.58483351,-0.62979145,-0.49620128,1.7368012,-0.58482332,-0.62873193,-0.49620128,1.7389711,-0.58483351,-0.62873193,-0.49620128,1.7369947,-0.58483351,-0.62873193,-0.49620128,1.7372902,-0.58483351,-0.62873193,-0.49620128,1.736088,-0.58483351,-0.62873193,-0.49620128,1.736954,-0.58483351,-0.62873193,-0.49620128,1.7362001,-0.58483351,-0.62873193,-0.49620128,1.7374837,-0.58483351,-0.62873193,-0.49620128,1.7364955,-0.58483351,-0.62873193,-0.49620128,1.7379727,-0.58483351,-0.62873193,-0.49620128,1.7379218,-0.58483351,-0.62873193,-0.49620128,1.7373717,-0.58483351,-0.62873193,-0.49620128,1.7370253,-0.58483351,-0.62873193,-0.49620128,1.7368419,-0.58483351,-0.62873193,-0.49620128,1.7373717,-0.58483351,-0.62873193,-0.49620128,1.7368623,-0.58483351,-0.62873193,-0.49620128,1.7361288,-0.58483351,-0.62873193,-0.49620128,1.736903,-0.58483351,-0.62873193,-0.49620128,1.7377384,-0.58483351,-0.62873193,-0.49620128,1.7388387,-0.58483351,-0.62873193,-0.49620128,1.7365057,-0.58483351,-0.62873193,-0.49620128,1.7356194,-0.58483351,-0.62873193,-0.49726079,1.7386553,-0.58483351,-0.62873193,-0.49620128,1.7386044,-0.58483351,-0.62873193,-0.49620128,1.7396028,-0.58483351,-0.62873193,-0.49620128,1.7390832,-0.58483351,-0.62873193,-0.49620128,1.7360371,-0.58483351,-0.62873193,-0.49620128,1.7375958,-0.58483351,-0.62873193,-0.49620128,1.7360269,-0.58483351,-0.62873193,-0.49620128,1.7363529,-0.58483351,-0.62873193,-0.49620128,1.7352628,-0.58483351,-0.62873193,-0.49620128,1.7351915,-0.58483351,-0.62873193,-0.49620128,1.7340913,-0.58483351,-0.62873193,-0.49620128,1.7334494,-0.58483351,-0.62873193,-0.49620128,1.7348044,-0.58483351,-0.62873193,-0.49620128,1.7338875,-0.58483351,-0.62873193,-0.49620128,1.7345599,-0.58483351,-0.62873193,-0.49620128,1.7335208,-0.58483351,-0.62873193,-0.49620128,1.7342543,-0.58483351,-0.62873193,-0.49620128,1.7330419,-0.58483351,-0.62873193,-0.49620128,1.7339283,-0.58483351,-0.62873193,-0.49620128,1.7323492,-0.58483351,-0.62873193,-0.49620128,1.7352323,-0.58483351,-0.62873193,-0.49620128,1.7350387,-0.58483351,-0.62873193,-0.49726079,1.7319926,-0.58483351,-0.62873193,-0.49620128,1.7344478,-0.58483351,-0.62873193,-0.49620128,1.7358741,-0.58483351,-0.62873193,-0.49620128,1.7350489,-0.58483351,-0.62873193,-0.49620128,1.7347025,-0.58483351,-0.62873193,-0.49620128,1.734458,-0.58483351,-0.62873193,-0.49620128,1.7331438,-0.58483351,-0.62873193,-0.49620128,1.7358333,-0.58483351,-0.62873193,-0.49620128,1.7345803,-0.58483351,-0.62873193,-0.49620128,1.7356296,-0.58483351,-0.62873193,-0.49620128,1.7355073,-0.58483351,-0.62873193,-0.49620128,1.7377792,-0.58483351,-0.62873193,-0.49620128,1.7356805,-0.58483351,-0.62873193,-0.49620128,1.7360065,-0.58483351,-0.62873193,-0.49620128,1.7362918,-0.58483351,-0.62873193,-0.49726079,1.7367298,-0.58483351,-0.62873193,-0.49620128,1.7378607,-0.58483351,-0.62873193,-0.49620128,1.7383701,-0.58483351,-0.62873193,-0.49620128,1.7396028,-0.58483351,-0.62873193,-0.49620128,1.7388998,-0.58483351,-0.62873193,-0.49620128,1.7340709,-0.58483351,-0.62873193,-0.49620128,1.734458,-0.58483351,-0.62873193,-0.49620128,1.7365974,-0.58483351,-0.62873193,-0.49620128,1.7360371,-0.58483351,-0.62873193,-0.49620128,1.736088,-0.58483351,-0.62873193,-0.49620128,1.7340607,-0.58483351,-0.62873193,-0.49726079,1.7337449,-0.58483351,-0.62873193,-0.49620128,1.7337958,-0.58483351,-0.62873193,-0.49620128,1.7355888,-0.58483351,-0.62873193,-0.49620128,1.7362918,-0.58483351,-0.62873193,-0.49620128,1.7400714,-0.58483351,-0.62873193,-0.49620128,1.7398065,-0.58483351,-0.62873193,-0.49620128,1.7390424,-0.58483351,-0.62873193,-0.49620128,1.7388794,-0.58483351,-0.62873193,-0.49620128,1.7388794,-0.58483351,-0.62873193,-0.49620128,1.7388794,-0.58483351,-0.62873193,-0.49620128,1.7388794,-0.58483351,-0.62873193,-0.49620128,1.7388794,-0.58483351,-0.62873193,-0.49620128,1.7388794,-0.58483351,-0.62873193,-0.49620128,1.7388794,-0.58483351:5
-0.61088454,-0.61088454,1.7215896,-0.61088454,-0.61088454,-0.61088454,1.7223463,-0.61088454,-0.61088454,-0.61088454,1.7241189,-0.61088454,-0.61088454,-0.61088454,1.7206049,-0.61088454,-0.61088454,-0.61088454,1.7208848,-0.61088454,-0.61088454,-0.61088454,1.7202006,-0.61088454,-0.61088454,-0.61088454,1.7241915,-0.61088454,-0.61088454,-0.61088454,1.7242329,-0.61088454,-0.69287813,-0.42532609,1.7232067,-0.60999308,-0.69395618,-0.42424804,1.7209884,-0.60998271,-0.69611227,-0.42100354,1.7239738,-0.60996198,-0.69719031,-0.41884745,1.7150384,-0.60995161,-0.69826836,-0.41776941,1.717464,-0.60994125,-0.69719031,-0.41776941,1.7161061,-0.60994125,-0.69719031,-0.41776941,1.7199311,-0.60994125,-0.69826836,-0.41669136,1.7185732,-0.60994125,-0.6993464,-0.41453527,1.7300067,-0.60993088,-0.70042445,-0.41237918,1.7324737,-0.60993088,-0.70150249,-0.41130114,1.7306079,-0.60992052,-0.70258053,-0.40914505,1.7325878,-0.60991015,-0.70365858,-0.40806701,1.7302244,-0.60989978,-0.70473662,-0.40590055,1.7294055,-0.60988942,-0.70582503,-0.40374446,1.7275707,-0.60987905,-0.70690308,-0.40266642,1.7291463,-0.60986869,-0.70798112,-0.40051033,1.7293847,-0.60985832,-0.70905917,-0.39943228,1.7299134,-0.60985832,-0.71013721,-0.39835424,1.7270732,-0.60984796,-0.71013721,-0.39727619,1.7301622,-0.60984796,-0.71121526,-0.39619815,1.7304835,-0.60983759,-0.7122933,-0.3951201,1.7315927,-0.60982722,-0.7122933,-0.3951201,1.7298823,-0.60982722,-0.7122933,-0.39403169,1.7306494,-0.60982722,-0.7122933,-0.3951201,1.7203146,-0.60982722,-0.71337135,-0.3951201,1.7178372,-0.60982722,-0.7122933,-0.39403169,1.7214445,-0.60982722,-0.71337135,-0.39295365,1.7271768,-0.60981686,-0.71337135,-0.39403169,1.7259329,-0.60982722,-0.71337135,-0.39295365,1.72755,-0.60981686,-0.71337135,-0.39295365,1.7263476,-0.60981686,-0.7122933,-0.39403169,1.724378,-0.60982722,-0.71337135,-0.39403169,1.7282238,-0.60982722,-0.71337135,-0.39403169,1.7275811,-0.60982722,-0.7122933,-0.39403169,1.7289908,-0.60982722,-0.7122933,-0.39403169,1.7289494,-0.60982722,-0.7122933,-0.39403169,1.7283274,-0.60982722,-0.71121526,-0.3951201,1.7271975,-0.60983759,-0.71121526,-0.3951201,1.7309189,-0.60983759,-0.71121526,-0.3951201,1.7314164,-0.60983759,-0.71013721,-0.39619815,1.7347646,-0.60984796,-0.71013721,-0.39835424,1.7216622,-0.60984796,-0.71013721,-0.39835424,1.7217037,-0.60984796,-0.70905917,-0.39943228,1.7174122,-0.60984796,-0.71013721,-0.39727619,1.729478,-0.60984796,-0.71013721,-0.39619815,1.7295299,-0.60983759,-0.71121526,-0.39619815,1.7306494,-0.60983759,-0.71013721,-0.39619815,1.7279439,-0.60983759,-0.71013721,-0.39619815,1.7266171,-0.60983759,-0.71013721,-0.39727619,1.7245439,-0.60984796,-0.71013721,-0.39727619,1.7207293,-0.60983759,-0.71013721,-0.39835424,1.7194336,-0.60984796,-0.71013721,-0.39835424,1.7224293,-0.60984796,-0.71013721,-0.39835424,1.7210506,-0.60984796,-0.71013721,-0.39943228,1.7192262,-0.60984796,-0.70905917,-0.39943228,1.7204805,-0.60984796,-0.70905917,-0.39835424,1.7254872,-0.60984796,-0.70905917,-0.39943228,1.7229476,-0.60985832,-0.70798112,-0.40051033,1.7135147,-0.60985832,-0.70798112,-0.40051033,1.7103946,-0.60984796,-0.70798112,-0.40158837,1.7092647,-0.60985832,-0.70798112,-0.39943228,1.7237976,-0.60985832,-0.70798112,-0.40051033,1.7218799,-0.60985832,-0.70798112,-0.39943228,1.7241085,-0.60985832,-0.70905917,-0.39943228,1.7251555,-0.60985832,-0.70905917,-0.39835424,1.7242329,-0.60984796,-0.70905917,-0.39727619,1.7303799,-0.60984796,-0.70905917,-0.39727619,1.7296957,-0.60984796,-0.70905917,-0.39727619,1.730867,-0.60984796,-0.70905917,-0.39727619,1.7284933,-0.60984796,-0.70905917,-0.39727619,1.7294262,-0.60984796,-0.70905917,-0.39835424,1.7252177,-0.60984796,-0.70905917,-0.39835424,1.7275604,-0.60984796,-0.70905917,-0.39835424,1.7256841,-0.60984796,-0.70798112,-0.39943228,1.712561,-0.60984796,-0.70798112,-0.39943228,1.7140848,-0.60984796,-0.70798112,-0.39943228,1.7163653,-0.60984796,-0.70798112,-0.39943228,1.7177854,-0.60984796,-0.70798112,-0.39943228,1.7226573,-0.60985832,-0.70798112,-0.39943228,1.7177439,-0.60984796,-0.70798112,-0.39835424,1.7296439,-0.60984796,-0.70798112,-0.39835424,1.7289597,-0.60984796,-0.70798112,-0.39835424,1.7297475,-0.60984796,-0.70798112,-0.39835424,1.730442,-0.60984796,-0.70798112,-0.39835424,1.7303695,-0.60984796,-0.70798112,-0.39943228,1.7295299,-0.60985832,-0.70798112,-0.39943228,1.7296957,-0.60985832,-0.70798112,-0.39943228,1.7324012,-0.60985832,-0.70798112,-0.39943228,1.7287732,-0.60985832,-0.70690308,-0.39943228,1.7297475,-0.60985832,-0.70798112,-0.40051033,1.7299445,-0.60985832,-0.70690308,-0.40158837,1.7179409,-0.60985832,-0.70690308,-0.40158837,1.7181482,-0.60985832,-0.70690308,-0.40158837,1.7141677,-0.60985832,-0.70798112,-0.40158837,1.7181067,-0.60985832,-0.70690308,-0.40158837,1.7217762,-0.60986869,-0.70690308,-0.40051033,1.7264408,-0.60985832,-0.70690308,-0.40051033,1.7281408,-0.60985832,-0.70690308,-0.40051033,1.7276433,-0.60985832,-0.70690308,-0.40266642,1.7152665,-0.60986869,-0.70690308,-0.40266642,1.7158366,-0.60986869,-0.70690308,-0.40266642,1.7147171,-0.60986869,-0.70690308,-0.40266642,1.7177543,-0.60986869,-0.70690308,-0.40266642,1.7136702,-0.60986869,-0.70582503,-0.40266642,1.7136598,-0.60986869,-0.70582503,-0.40266642,1.7121257,-0.60986869,-0.70690308,-0.40266642,1.7157952,-0.60986869,-0.70582503,-0.40266642,1.7147689,-0.60986869,-0.70582503,-0.40266642,1.7146756,-0.60986869,-0.70582503,-0.40374446,1.7066421,-0.60986869,-0.70582503,-0.40266642,1.7204909,-0.60986869,-0.70582503,-0.40266642,1.722761,-0.60986869,-0.70582503,-0.40266642,1.720211,-0.60986869,-0.70690308,-0.40266642,1.7217866,-0.60986869,-0.70690308,-0.40266642,1.7236939,-0.60986869,-0.70690308,-0.40266642,1.7239116,-0.60986869,-0.70582503,-0.40266642,1.7234244,-0.60986869,-0.70582503,-0.40266642,1.7243573,-0.60986869,-0.70582503,-0.40374446,1.7212683,-0.60986869,-0.70582503,-0.40266642,1.7245854,-0.60986869,-0.70582503,-0.40374446,1.7193714,-0.60986869,-0.70582503,-0.40374446,1.7198482,-0.60986869,-0.70582503,-0.40374446,1.7197342,-0.60986869,-0.70582503,-0.40374446,1.7217037,-0.60987905,-0.70582503,-0.40374446,1.7155256,-0.60986869,-0.70582503,-0.40374446,1.7161994,-0.60986869,-0.70582503,-0.40374446,1.7188738,-0.60986869,-0.70582503,-0.40374446,1.7174951,-0.60986869,-0.70582503,-0.40374446,1.7178683,-0.60986869,-0.70582503,-0.40374446,1.7169561,-0.60986869,-0.70582503,-0.40374446,1.7169354,-0.60986869,-0.70582503,-0.40374446,1.7167592,-0.60986869,-0.70582503,-0.40374446,1.7169458,-0.60986869,-0.70582503,-0.40374446,1.7205738,-0.60986869,-0.70582503,-0.40374446,1.7158573,-0.60986869,-0.70690308,-0.40374446,1.7194854,-0.60986869,-0.70582503,-0.40374446,1.71905,-0.60986869,-0.70582503,-0.40374446,1.7178683,-0.60986869,-0.70582503,-0.40266642,1.7192573,-0.60986869,-0.70582503,-0.40374446,1.7168836,-0.60986869,-0.70582503,-0.40374446,1.7164067,-0.60986869,-0.70690308,-0.40266642,1.7177128,-0.60986869,-0.70582503,-0.40374446,1.7165622,-0.60986869,-0.70582503,-0.40266642,1.7169976,-0.60986869,-0.70582503,-0.40374446,1.7138878,-0.60986869,-0.70582503,-0.40374446,1.7109543,-0.60986869,-0.70582503,-0.40374446,1.7131622,-0.60986869,-0.70582503,-0.40374446,1.7110061,-0.60986869,-0.70582503,-0.40374446,1.7124159,-0.60986869,-0.70690308,-0.40266642,1.7138256,-0.60986869,-0.70690308,-0.40266642,1.7161994,-0.60986869,-0.70690308,-0.40266642,1.7143439,-0.60986869,-0.70690308,-0.40266642,1.7157122,-0.60986869,-0.70690308,-0.40266642,1.7173811,-0.60986869,-0.70690308,-0.40374446,1.7137013,-0.60986869,-0.70690308,-0.40266642,1.7145824,-0.60986869,-0.70690308,-0.40266642,1.7166348,-0.60986869,-0.70798112,-0.40266642,1.7144476,-0.60986869,-0.70690308,-0.40266642,1.7151421,-0.60986869,-0.70690308,-0.40266642,1.7144994,-0.60986869,-0.70798112,-0.40266642,1.7170701,-0.60986869,-0.70690308,-0.40266642,1.7138982,-0.60986869,-0.70690308,-0.40266642,1.7139708,-0.60986869,-0.70690308,-0.40266642,1.7138982,-0.60986869,-0.70798112,-0.40158837,1.7222012,-0.60986869,-0.70798112,-0.40266642,1.7144476,-0.60986869,-0.70690308,-0.40266642,1.7109854,-0.60985832,-0.70798112,-0.40266642,1.7135043,-0.60986869,-0.70798112,-0.40266642,1.7127994,-0.60986869,-0.70798112,-0.40266642,1.7132555,-0.60986869,-0.70798112,-0.40266642,1.712872,-0.60986869,-0.70798112,-0.40158837,1.7137945,-0.60985832,-0.70798112,-0.40266642,1.7138049,-0.60986869,-0.70798112,-0.40158837,1.7131622,-0.60985832,-0.70798112,-0.40158837,1.7154945,-0.60985832,-0.70798112,-0.40158837,1.7175262,-0.60985832,-0.70798112,-0.40158837,1.7183866,-0.60985832,-0.70798112,-0.40158837,1.7164689,-0.60985832,-0.70798112,-0.40158837,1.7177439,-0.60985832,-0.70798112,-0.40051033,1.7215067,-0.60985832,-0.70905917,-0.40158837,1.7202939,-0.60985832,-0.70905917,-0.40051033,1.7222634,-0.60985832,-0.70905917,-0.40051033,1.7213616,-0.60985832,-0.70798112,-0.40158837,1.7170701,-0.60985832,-0.70798112,-0.40051033,1.7172775,-0.60985832,-0.70905917,-0.40158837,1.7180653,-0.60985832,-0.70905917,-0.40051033,1.7194854,-0.60985832,-0.70905917,-0.40051033,1.7212372,-0.60985832,-0.70905917,-0.39943228,1.7250311,-0.60985832,-0.71013721,-0.39943228,1.7241604,-0.60984796,-0.70905917,-0.39943228,1.7278713,-0.60985832,-0.70905917,-0.39943228,1.7253213,-0.60985832,-0.70905917,-0.39943228,1.7280786,-0.60985832,-0.70905917,-0.40051033,1.7229787,-0.60985832,-0.70905917,-0.39943228,1.7260469,-0.60985832,-0.70905917,-0.40051033,1.7244506,-0.60985832,-0.70905917,-0.40051033,1.7248652,-0.60985832,-0.70905917,-0.40051033,1.7228439,-0.60985832,-0.70905917,-0.39943228,1.7278091,-0.60985832,-0.70905917,-0.39943228,1.7268347,-0.60985832,-0.70905917,-0.39943228,1.7251555,-0.60985832,-0.70905917,-0.39943228,1.7233311,-0.60985832,-0.70905917,-0.39943228,1.7253006,-0.60985832,-0.70905917,-0.39943228,1.7252384,-0.60984796,-0.70905917,-0.39943228,1.7227402,-0.60985832,-0.70905917,-0.39943228,1.722647,-0.60985832,-0.70905917,-0.39943228,1.7245439,-0.60985832,-0.70905917,-0.39943228,1.7248549,-0.60985832,-0.70905917,-0.39943228,1.7237872,-0.60985832,-0.71013721,-0.39943228,1.7218903,-0.60984796,-0.71013721,-0.39943228,1.7254457,-0.60984796,-0.70905917,-0.39943228,1.7277677,-0.60985832,-0.70905917,-0.39943228,1.727353,-0.60985832,-0.70905917,-0.39943228,1.7262439,-0.60985832,-0.70905917,-0.39943228,1.7271146,-0.60985832,-0.70905917,-0.39943228,1.7273219,-0.60985832,-0.70905917,-0.39943228,1.7270213,-0.60985832,-0.70905917,-0.39943228,1.7281927,-0.60985832,-0.70905917,-0.39835424,1.7292811,-0.60984796,-0.70905917,-0.39943228,1.7281097,-0.60985832,-0.70905917,-0.39835424,1.7291463,-0.60984796,-0.70905917,-0.39943228,1.7287006,-0.60985832,-0.70905917,-0.39835424,1.7279439,-0.60984796,-0.70905917,-0.39835424,1.7297268,-0.60984796,-0.70905917,-0.39835424,1.7293122,-0.60984796,-0.70905917,-0.39943228,1.7261817,-0.60985832,-0.70905917,-0.39943228,1.7252799,-0.60985832,-0.70905917,-0.39943228,1.7227506,-0.60985832,-0.70905917,-0.39943228,1.722989,-0.60985832,-0.70905917,-0.39943228,1.7242744,-0.60985832,-0.70905917,-0.39943228,1.7238183,-0.60985832,-0.70905917,-0.39943228,1.7228543,-0.60985832,-0.70905917,-0.39943228,1.7247719,-0.60985832,-0.70905917,-0.39943228,1.7241396,-0.60985832,-0.70905917,-0.39943228,1.7256219,-0.60985832,-0.70905917,-0.39943228,1.7239945,-0.60985832,-0.70905917,-0.39943228,1.724886,-0.60985832,-0.70905917,-0.39943228,1.7246268,-0.60985832,-0.70905917,-0.39943228,1.7234866,-0.60985832,-0.70905917,-0.39943228,1.7220146,-0.60985832,-0.70905917,-0.39943228,1.7248238,-0.60985832,-0.70905917,-0.39943228,1.7223982,-0.60985832,-0.70905917,-0.39835424,1.7266482,-0.60984796,-0.70905917,-0.39835424,1.7282238,-0.60984796,-0.70905917,-0.39835424,1.728711,-0.60984796,-0.70905917,-0.39835424,1.7282549,-0.60984796,-0.70905917,-0.39835424,1.7268555,-0.60984796,-0.70905917,-0.39835424,1.7281201,-0.60984796,-0.70905917,-0.39943228,1.7267726,-0.60985832,-0.70905917,-0.39943228,1.7247927,-0.60985832,-0.70905917,-0.39943228,1.7235177,-0.60985832,-0.70905917,-0.39943228,1.7245128,-0.60985832,-0.70905917,-0.39943228,1.7236421,-0.60985832,-0.70905917,-0.39943228,1.7220976,-0.60985832,-0.70905917,-0.39835424,1.7263786,-0.60984796,-0.71013721,-0.39835424,1.7257049,-0.60984796,-0.71013721,-0.39943228,1.7226262,-0.60984796,-0.71013721,-0.39943228,1.7229994,-0.60984796,-0.71013721,-0.39943228,1.7243573,-0.60984796,-0.71013721,-0.39943228,1.7239634,-0.60984796,-0.71013721,-0.39943228,1.7253524,-0.60984796,-0.71013721,-0.39943228,1.7264512,-0.60984796,-0.71013721,-0.39943228,1.7256841,-0.60984796,-0.70905917,-0.39943228,1.7231341,-0.60985832,-0.71013721,-0.39943228,1.7223152,-0.60984796,-0.70905917,-0.39943228,1.7226573,-0.60985832,-0.71013721,-0.39943228,1.7240878,-0.60984796,-0.70905917,-0.39943228,1.7199622,-0.60984796,-0.70905917,-0.39943228,1.7239012,-0.60985832,-0.71013721,-0.39943228,1.7237043,-0.60984796,-0.70905917,-0.39943228,1.7220146,-0.60985832,-0.71013721,-0.39943228,1.7223671,-0.60984796,-0.70905917,-0.39943228,1.7225018,-0.60984796,-0.71013721,-0.39943228,1.7227402,-0.60984796,-0.71013721,-0.39835424,1.7271457,-0.60984796,-0.71013721,-0.39943228,1.7265238,-0.60984796,-0.71013721,-0.39943228,1.7256323,-0.60984796,-0.71013721,-0.39943228,1.7236317,-0.60984796,-0.71013721,-0.39943228,1.7241604,-0.60984796,-0.71013721,-0.39943228,1.7251762,-0.60984796,-0.71013721,-0.39943228,1.7235177,-0.60984796,-0.71013721,-0.39835424,1.727975,-0.60984796,-0.71013721,-0.39835424,1.7276433,-0.60984796,-0.71013721,-0.39943228,1.7268347,-0.60984796,-0.71013721,-0.39943228,1.7265341,-0.60984796,-0.71013721,-0.39943228,1.7249067,-0.60984796,-0.71013721,-0.39835424,1.7250726,-0.60984796,-0.71013721,-0.39943228,1.7259122,-0.60984796,-0.71013721,-0.39835424,1.7257463,-0.60984796,-0.71013721,-0.39943228,1.724575,-0.60984796,-0.71121526,-0.39835424,1.7253835,-0.60984796,-0.71013721,-0.39943228,1.7243573,-0.60984796,-0.71013721,-0.39943228,1.7217659,-0.60984796,-0.71013721,-0.39943228,1.7222738,-0.60984796,-0.71013721,-0.39943228,1.7224915,-0.60984796,-0.71013721,-0.39943228,1.7216,-0.60984796,-0.71121526,-0.39943228,1.724461,-0.60984796,-0.71013721,-0.40051033,1.7169043,-0.60984796,-0.71013721,-0.40051033,1.7165726,-0.60984796,-0.71013721,-0.40051033,1.7160958,-0.60984796,-0.71013721,-0.40051033,1.7146756,-0.60984796,-0.71013721,-0.40051033,1.7172671,-0.60984796,-0.71121526,-0.39943228,1.7176921,-0.60984796,-0.71013721,-0.40051033,1.7129446,-0.60984796,-0.71121526,-0.40051033,1.7163964,-0.60984796,-0.71121526,-0.40051033,1.7176817,-0.60984796,-0.71013721,-0.40051033,1.7156915,-0.60984796,-0.71013721,-0.40051033,1.7143543,-0.60984796,-0.71121526,-0.40051033,1.7166866,-0.60984796,-0.71121526,-0.39943228,1.7162616,-0.60984796,-0.71121526,-0.40051033,1.7169976,-0.60984796,-0.71013721,-0.40051033,1.7146134,-0.60984796,-0.71121526,-0.40051033,1.7170287,-0.60984796,-0.71013721,-0.40051033,1.7138049,-0.60984796,-0.71013721,-0.40051033,1.7149763,-0.60984796,-0.71013721,-0.40051033,1.7161269,-0.60984796,-0.71013721,-0.39943228,1.7165519,-0.60984796,-0.71121526,-0.39943228,1.7171945,-0.60984796,-0.71013721,-0.39943228,1.7171842,-0.60984796,-0.71013721,-0.40158837,1.7092543,-0.60984796,-0.71013721,-0.40051033,1.7151006,-0.60984796,-0.71013721,-0.39943228,1.7169147,-0.60984796,-0.71013721,-0.40051033,1.7137842,-0.60984796,-0.71013721,-0.40051033,1.710747,-0.60984796,-0.71013721,-0.40158837,1.7106433,-0.60984796,-0.71013721,-0.40051033,1.7121049,-0.60984796,-0.71013721,-0.40051033,1.7102909,-0.60984796,-0.71013721,-0.40051033,1.7113689,-0.60984796,-0.71121526,-0.40051033,1.7139397,-0.60984796,-0.71121526,-0.40051033,1.7143025,-0.60984796,-0.71013721,-0.40051033,1.7144994,-0.60984796,-0.71013721,-0.40051033,1.7112757,-0.60984796,-0.71013721,-0.40051033,1.7126025,-0.60984796,-0.71013721,-0.40051033,1.7140019,-0.60984796,-0.71013721,-0.40051033,1.7137427,-0.60984796,-0.71013721,-0.39943228,1.7164171,-0.60984796,-0.71013721,-0.40051033,1.7145513,-0.60984796,-0.71121526,-0.39943228,1.7156604,-0.60984796,-0.71121526,-0.40051033,1.7168006,-0.60984796,-0.71013721,-0.40051033,1.7159714,-0.60984796,-0.71121526,-0.39943228,1.7182726,-0.60984796,-0.71013721,-0.39943228,1.7172775,-0.60984796,-0.71121526,-0.39943228,1.7197134,-0.60984796,-0.71013721,-0.39943228,1.7201384,-0.60984796,-0.71121526,-0.39943228,1.7197342,-0.60984796,-0.71013721,-0.39943228,1.7169769,-0.60984796,-0.71013721,-0.39943228,1.7205427,-0.60984796,-0.71121526,-0.39943228,1.7205842,-0.60984796,-0.71013721,-0.39943228,1.717039,-0.60984796,-0.71013721,-0.39943228,1.7189049,-0.60984796,-0.71013721,-0.39943228,1.719247,-0.60984796,-0.71013721,-0.39943228,1.719247,-0.60984796,-0.71013721,-0.39943228,1.719247,-0.60984796,-0.71013721,-0.39943228,1.719247,-0.60984796,-0.71013721,-0.39943228,1.719247,-0.60984796,-0.71013721,-0.39943228,1.719247,-0.60984796,-0.71013721,-0.39943228,1.719247,-0.60984796:5
-0.58514559,-0.58514559,1.7267155,-0.58514559,-0.58514559,-0.58514559,1.7279325,-0.58514559,-0.58514559,-0.58514559,1.7264496,-0.58514559,-0.58514559,-0.58514559,1.7251099,-0.58514559,-0.58514559,-0.58514559,1.7246088,-0.58514559,-0.61388215,-0.53086316,1.721684,-0.5848797,-0.61388215,-0.53193694,1.7211727,-0.5848797,-0.61388215,-0.53193694,1.7216329,-0.5848797,-0.61388215,-0.53193694,1.721817,-0.5848797,-0.61388215,-0.53193694,1.7201705,-0.5848797,-0.61281859,-0.53193694,1.7200376,-0.5848797,-0.61388215,-0.53193694,1.722042,-0.5848797,-0.61281859,-0.53193694,1.722809,-0.5848797,-0.61281859,-0.53193694,1.7217761,-0.5848797,-0.61281859,-0.53193694,1.724435,-0.5848797,-0.61281859,-0.53193694,1.7257337,-0.5848797,-0.61281859,-0.53193694,1.7289244,-0.58488993,-0.61281859,-0.53193694,1.7277075,-0.58488993,-0.61281859,-0.53193694,1.7274314,-0.58488993,-0.61281859,-0.53193694,1.7288119,-0.58488993,-0.61281859,-0.53193694,1.7298755,-0.58488993,-0.61281859,-0.5330005,1.7304789,-0.58488993,-0.61281859,-0.53193694,1.7304891,-0.58488993,-0.61281859,-0.53193694,1.7275643,-0.58488993,-0.61281859,-0.53193694,1.7318901,-0.58488993,-0.61281859,-0.5330005,1.728137,-0.58488993,-0.61281859,-0.5330005,1.7296914,-0.58488993,-0.61281859,-0.5330005,1.7349683,-0.58488993,-0.61281859,-0.5330005,1.7338127,-0.58488993,-0.61281859,-0.5330005,1.7341706,-0.58488993,-0.61281859,-0.5330005,1.7327901,-0.58488993,-0.61281859,-0.5330005,1.729446,-0.58488993,-0.61281859,-0.5330005,1.7304891,-0.58488993,-0.61281859,-0.5330005,1.7343752,-0.58488993,-0.61281859,-0.5330005,1.7309391,-0.58488993,-0.61281859,-0.5330005,1.7332502,-0.58488993,-0.61281859,-0.5330005,1.7349069,-0.58488993,-0.61281859,-0.5330005,1.7348456,-0.58488993,-0.61281859,-0.5330005,1.7345592,-0.58488993,-0.61281859,-0.5330005,1.7350092,-0.58488993,-0.61281859,-0.53193694,1.734774,-0.58488993,-0.61281859,-0.5330005,1.7343854,-0.58488993,-0.61281859,-0.5330005,1.7349785,-0.58488993,-0.61281859,-0.5330005,1.7337207,-0.58488993,-0.61281859,-0.5330005,1.7343854,-0.58488993,-0.61281859,-0.5330005,1.7337207,-0.58488993,-0.61281859,-0.5330005,1.7343752,-0.58488993,-0.61281859,-0.5330005,1.7298346,-0.58488993,-0.6117448,-0.5330005,1.734682,-0.58488993,-0.61281859,-0.5330005,1.7355717,-0.58488993,-0.61281859,-0.5330005,1.7343547,-0.58488993,-0.61281859,-0.5330005,1.7344979,-0.58488993,-0.61281859,-0.5330005,1.733373,-0.58488993,-0.6117448,-0.5330005,1.7314299,-0.58488993,-0.61281859,-0.5330005,1.7345592,-0.58488993,-0.61281859,-0.5330005,1.7362466,-0.58488993,-0.6117448,-0.5330005,1.7350501,-0.58488993,-0.61281859,-0.5330005,1.7360932,-0.58488993,-0.6117448,-0.5330005,1.7352853,-0.58488993,-0.6117448,-0.5330005,1.7363489,-0.58488993,-0.6117448,-0.5330005,1.7346104,-0.58488993,-0.6117448,-0.5330005,1.7349069,-0.58488993,-0.61281859,-0.5330005,1.736308,-0.58488993,-0.6117448,-0.5330005,1.7362671,-0.58488993,-0.6117448,-0.5330005,1.7335264,-0.58488993,-0.6117448,-0.5330005,1.7337616,-0.58488993,-0.6117448,-0.53406406,1.7348865,-0.58490016,-0.6117448,-0.53406406,1.7360932,-0.58490016,-0.6117448,-0.5330005,1.7385987,-0.58488993,-0.6117448,-0.5330005,1.7376068,-0.58488993,-0.6117448,-0.5330005,1.7368193,-0.58488993,-0.61281859,-0.5330005,1.7356944,-0.58488993,-0.6117448,-0.53406406,1.7350399,-0.58490016,-0.6117448,-0.53406406,1.7308675,-0.58490016,-0.6117448,-0.53406406,1.7344161,-0.58490016,-0.6117448,-0.5330005,1.7310413,-0.58488993,-0.6117448,-0.53406406,1.7327287,-0.58490016,-0.6117448,-0.53406406,1.7289244,-0.58490016,-0.6117448,-0.53406406,1.7305504,-0.58490016,-0.6117448,-0.53406406,1.7268996,-0.58490016,-0.6117448,-0.53406406,1.7354387,-0.58490016,-0.61281859,-0.5330005,1.7308879,-0.58488993,-0.6117448,-0.53406406,1.7337616,-0.58490016,-0.6117448,-0.53406406,1.7295891,-0.58490016,-0.6117448,-0.53406406,1.7320435,-0.58490016,-0.6117448,-0.53406406,1.729446,-0.58490016,-0.6117448,-0.53406406,1.7326776,-0.58490016,-0.6117448,-0.53406406,1.7344774,-0.58490016,-0.6117448,-0.53406406,1.7357967,-0.58490016,-0.6117448,-0.53406406,1.7307038,-0.58490016,-0.6117448,-0.53406406,1.7347024,-0.58490016,-0.6117448,-0.53406406,1.73008,-0.58490016,-0.6117448,-0.5330005,1.7335468,-0.58488993,-0.6117448,-0.53406406,1.7325344,-0.58490016,-0.6117448,-0.53406406,1.736175,-0.58490016,-0.6117448,-0.53406406,1.7309186,-0.58490016,-0.6117448,-0.53406406,1.7239543,-0.58490016,-0.6117448,-0.53406406,1.7154049,-0.58488993,-0.6117448,-0.53406406,1.7177571,-0.58490016,-0.6117448,-0.53406406,1.7222772,-0.58490016,-0.6117448,-0.53406406,1.7279836,-0.58490016,-0.6117448,-0.53406406,1.7240975,-0.58490016,-0.6117448,-0.53406406,1.7237703,-0.58490016,-0.6117448,-0.53406406,1.7220113,-0.58490016,-0.6117448,-0.53406406,1.7239134,-0.58490016,-0.6117448,-0.53406406,1.7240464,-0.58490016,-0.6117448,-0.53406406,1.7221545,-0.58490016,-0.6117448,-0.53406406,1.7265007,-0.58490016,-0.6117448,-0.53406406,1.7250077,-0.58490016,-0.6117448,-0.53406406,1.7250077,-0.58490016,-0.6117448,-0.53406406,1.7248747,-0.58490016,-0.6117448,-0.53406406,1.7234635,-0.58490016,-0.6117448,-0.53406406,1.7246191,-0.58490016,-0.6117448,-0.53406406,1.7213466,-0.58490016,-0.6117448,-0.53406406,1.7222465,-0.58490016,-0.6117448,-0.53406406,1.7216738,-0.58490016,-0.6117448,-0.53406406,1.720958,-0.58490016,-0.6117448,-0.53406406,1.7172457,-0.58490016,-0.6117448,-0.53406406,1.7209273,-0.58490016,-0.6117448,-0.53406406,1.7228499,-0.58490016,-0.6117448,-0.53406406,1.7256826,-0.58490016,-0.6117448,-0.53406406,1.7280143,-0.58490016,-0.6117448,-0.53406406,1.725744,-0.58490016,-0.6117448,-0.53406406,1.7241486,-0.58490016,-0.6117448,-0.53406406,1.7244861,-0.58490016,-0.6117448,-0.53406406,1.7248747,-0.58490016,-0.6117448,-0.53406406,1.7256519,-0.58490016,-0.6117448,-0.53406406,1.7243634,-0.58490016,-0.6117448,-0.53406406,1.7233101,-0.58490016,-0.6117448,-0.53406406,1.7236373,-0.58490016,-0.6117448,-0.53406406,1.7212341,-0.58490016,-0.6117448,-0.53406406,1.7208761,-0.58490016,-0.6117448,-0.53406406,1.7214181,-0.58490016,-0.6117448,-0.53406406,1.7225124,-0.58490016,-0.6117448,-0.53406406,1.7244452,-0.58490016,-0.6117448,-0.53406406,1.7239952,-0.58490016,-0.6117448,-0.53406406,1.7217761,-0.58490016,-0.6117448,-0.53406406,1.7212341,-0.58490016,-0.6117448,-0.53406406,1.7212238,-0.58490016,-0.6117448,-0.53406406,1.7201194,-0.58490016,-0.6117448,-0.53406406,1.7224203,-0.58490016,-0.6117448,-0.53406406,1.7222567,-0.58490016,-0.6117448,-0.53406406,1.7248134,-0.58490016,-0.6117448,-0.53406406,1.7199967,-0.58490016,-0.6117448,-0.53406406,1.7230442,-0.58490016,-0.6117448,-0.53406406,1.7192194,-0.58490016,-0.6117448,-0.53406406,1.7234328,-0.58490016,-0.6117448,-0.53406406,1.7213159,-0.58490016,-0.6117448,-0.53406406,1.7242611,-0.58490016,-0.6117448,-0.53406406,1.7215102,-0.58490016,-0.6117448,-0.53406406,1.7219908,-0.58490016,-0.6117448,-0.53406406,1.7210091,-0.58490016,-0.6117448,-0.53406406,1.7230135,-0.58490016,-0.6117448,-0.53406406,1.7210807,-0.58490016,-0.6117448,-0.53406406,1.7250179,-0.58490016,-0.6117448,-0.53406406,1.7214795,-0.58490016,-0.6117448,-0.53406406,1.7241589,-0.58490016,-0.6117448,-0.53406406,1.7192501,-0.58490016,-0.6117448,-0.53406406,1.7211727,-0.58490016,-0.6117448,-0.53512762,1.7190865,-0.58490016,-0.6117448,-0.53406406,1.7253042,-0.58490016,-0.6117448,-0.53406406,1.7164378,-0.58490016,-0.6117448,-0.53406406,1.7196694,-0.58490016,-0.6117448,-0.53406406,1.7214795,-0.58490016,-0.6117448,-0.53406406,1.7261428,-0.58490016,-0.6117448,-0.53406406,1.722042,-0.58490016,-0.6117448,-0.53406406,1.7197819,-0.58490016,-0.6117448,-0.53406406,1.7216636,-0.58490016,-0.6117448,-0.53406406,1.7216329,-0.58490016,-0.6117448,-0.53406406,1.7192604,-0.58490016,-0.6117448,-0.53512762,1.7208352,-0.58490016,-0.6117448,-0.53512762,1.7169594,-0.58490016,-0.6117448,-0.53406406,1.7200989,-0.58490016,-0.6117448,-0.53406406,1.7184013,-0.58490016,-0.6117448,-0.53406406,1.7217352,-0.58490016,-0.6117448,-0.53512762,1.7214386,-0.58490016,-0.6117448,-0.53406406,1.734007,-0.58490016,-0.6117448,-0.53406406,1.7295687,-0.58490016,-0.6117448,-0.53406406,1.7334446,-0.58490016,-0.6117448,-0.53406406,1.7307141,-0.58490016,-0.6117448,-0.53406406,1.7344672,-0.58490016,-0.6117448,-0.53406406,1.7333525,-0.58490016,-0.6117448,-0.53406406,1.734682,-0.58490016,-0.6117448,-0.53406406,1.7316242,-0.58490016,-0.6117448,-0.53406406,1.7334343,-0.58490016,-0.6117448,-0.53406406,1.7343956,-0.58490016,-0.6117448,-0.53406406,1.7341093,-0.58490016,-0.6117448,-0.53406406,1.7348865,-0.58490016,-0.6117448,-0.53406406,1.7347024,-0.58490016,-0.6117448,-0.53406406,1.7364512,-0.58490016,-0.6117448,-0.53406406,1.7350092,-0.58490016,-0.6117448,-0.53406406,1.7365125,-0.58490016,-0.6117448,-0.53406406,1.7357046,-0.58490016,-0.6117448,-0.53406406,1.7298653,-0.58490016,-0.6117448,-0.53406406,1.7335264,-0.58490016,-0.6117448,-0.53406406,1.7350603,-0.58490016,-0.6117448,-0.53406406,1.7345183,-0.58490016,-0.6117448,-0.53406406,1.7342934,-0.58490016,-0.6117448,-0.53406406,1.7376272,-0.58490016,-0.6117448,-0.53406406,1.7353058,-0.58490016,-0.6117448,-0.53406406,1.7340172,-0.58490016,-0.6117448,-0.53406406,1.733915,-0.58490016,-0.6117448,-0.53406406,1.7352035,-0.58490016,-0.6117448,-0.53406406,1.7354592,-0.58490016,-0.6117448,-0.53406406,1.7338638,-0.58490016,-0.6117448,-0.53406406,1.7345695,-0.58490016,-0.6117448,-0.53406406,1.7344365,-0.58490016,-0.6117448,-0.53406406,1.7358171,-0.58490016,-0.6117448,-0.53406406,1.7333116,-0.58490016,-0.6117448,-0.53406406,1.7364307,-0.58490016,-0.6117448,-0.53406406,1.7345899,-0.58490016,-0.6117448,-0.53406406,1.7384453,-0.58490016,-0.6117448,-0.53406406,1.7351013,-0.58490016,-0.6117448,-0.53406406,1.7395089,-0.58490016,-0.6117448,-0.53406406,1.736533,-0.58490016,-0.6117448,-0.53406406,1.7364716,-0.58490016,-0.61068125,-0.53406406,1.7350808,-0.58490016,-0.6117448,-0.53406406,1.7267871,-0.58490016,-0.6117448,-0.53406406,1.7320333,-0.58490016,-0.6117448,-0.53406406,1.7358376,-0.58490016,-0.6117448,-0.53406406,1.7322174,-0.58490016,-0.6117448,-0.53406406,1.7366557,-0.58490016,-0.61068125,-0.53406406,1.7321867,-0.58490016,-0.6117448,-0.53406406,1.7350399,-0.58490016,-0.6117448,-0.53406406,1.7369523,-0.58490016,-0.6117448,-0.53406406,1.7325242,-0.58490016,-0.6117448,-0.53406406,1.7364614,-0.58490016,-0.6117448,-0.53406406,1.7371057,-0.58490016,-0.6117448,-0.53406406,1.736533,-0.58490016,-0.6117448,-0.53406406,1.7346206,-0.58490016,-0.6117448,-0.53406406,1.737842,-0.58490016,-0.6117448,-0.53406406,1.7399998,-0.58490016,-0.6117448,-0.53406406,1.738251,-0.58490016,-0.6117448,-0.53406406,1.7383431,-0.58490016,-0.6117448,-0.53406406,1.7390078,-0.58490016,-0.6117448,-0.53406406,1.7386396,-0.58490016,-0.6117448,-0.53512762,1.7356433,-0.58490016,-0.6117448,-0.53406406,1.7377601,-0.58490016,-0.6117448,-0.53406406,1.7338229,-0.58490016,-0.6117448,-0.53406406,1.7377499,-0.58490016,-0.6117448,-0.53406406,1.7329946,-0.58490016,-0.6117448,-0.53406406,1.7383737,-0.58490016,-0.6117448,-0.53406406,1.7340991,-0.58490016,-0.6117448,-0.53406406,1.7393657,-0.58490016,-0.6117448,-0.53406406,1.7327798,-0.58490016,-0.6117448,-0.53406406,1.7356024,-0.58490016,-0.6117448,-0.53406406,1.7341809,-0.58490016,-0.6117448,-0.53406406,1.7385067,-0.58490016,-0.6117448,-0.53406406,1.7358989,-0.58490016,-0.6117448,-0.53406406,1.7405724,-0.58490016,-0.6117448,-0.53406406,1.7340991,-0.58490016,-0.6117448,-0.53406406,1.7345592,-0.58490016,-0.6117448,-0.53406406,1.7314504,-0.58490016,-0.6117448,-0.53406406,1.735408,-0.58490016,-0.6117448,-0.53406406,1.7269609,-0.58490016,-0.6117448,-0.53406406,1.7330662,-0.58490016,-0.6117448,-0.53406406,1.7268484,-0.58490016,-0.6117448,-0.53406406,1.7328719,-0.58490016,-0.6117448,-0.53406406,1.7290778,-0.58490016,-0.6117448,-0.53406406,1.7337002,-0.58490016,-0.6117448,-0.53406406,1.7336695,-0.58490016,-0.6117448,-0.53406406,1.7371261,-0.58490016,-0.6117448,-0.53406406,1.7376272,-0.58490016,-0.6117448,-0.53406406,1.7323196,-0.58490016,-0.6117448,-0.53406406,1.7381181,-0.58490016,-0.6117448,-0.53406406,1.7361035,-0.58490016,-0.6117448,-0.53406406,1.7385067,-0.58490016,-0.6117448,-0.53406406,1.7386396,-0.58490016,-0.6117448,-0.53406406,1.7375965,-0.58490016,-0.6117448,-0.53406406,1.7380669,-0.58490016,-0.6117448,-0.53406406,1.7378011,-0.58490016,-0.6117448,-0.53406406,1.737709,-0.58490016,-0.6117448,-0.53406406,1.7391816,-0.58490016,-0.6117448,-0.53406406,1.7370545,-0.58490016,-0.6117448,-0.53406406,1.7327185,-0.58490016,-0.6117448,-0.53406406,1.7354796,-0.58490016,-0.6117448,-0.53406406,1.7353876,-0.58490016,-0.6117448,-0.53406406,1.7357046,-0.58490016,-0.6117448,-0.53406406,1.7304073,-0.58490016,-0.6117448,-0.53406406,1.7358989,-0.58490016,-0.6117448,-0.53406406,1.7266644,-0.58490016,-0.6117448,-0.53406406,1.7368193,-0.58490016,-0.6117448,-0.53406406,1.7307652,-0.58490016,-0.6117448,-0.53406406,1.7345081,-0.58490016,-0.6117448,-0.53406406,1.7289551,-0.58490016,-0.6117448,-0.53512762,1.7355614,-0.58490016,-0.6117448,-0.53406406,1.7316242,-0.58490016,-0.6117448,-0.53512762,1.7364716,-0.58490016,-0.6117448,-0.53406406,1.7311334,-0.58490016,-0.6117448,-0.53406406,1.7357046,-0.58490016,-0.6117448,-0.53406406,1.7313583,-0.58490016,-0.6117448,-0.53406406,1.736175,-0.58490016,-0.6117448,-0.53406406,1.7306834,-0.58490016,-0.6117448,-0.53406406,1.7339763,-0.58490016,-0.6117448,-0.53406406,1.7312663,-0.58490016,-0.6117448,-0.53406406,1.7359501,-0.58490016,-0.6117448,-0.53406406,1.7328412,-0.58490016,-0.6117448,-0.53406406,1.7333116,-0.58490016,-0.6117448,-0.53406406,1.734549,-0.58490016,-0.6117448,-0.53406406,1.7355308,-0.58490016,-0.6117448,-0.53406406,1.7359194,-0.58490016,-0.6117448,-0.53406406,1.7356944,-0.58490016,-0.6117448,-0.53406406,1.7366148,-0.58490016,-0.6117448,-0.53406406,1.738609,-0.58490016,-0.6117448,-0.53406406,1.7377192,-0.58490016,-0.6117448,-0.53406406,1.7364614,-0.58490016,-0.6117448,-0.53406406,1.7367784,-0.58490016,-0.6117448,-0.53406406,1.7349888,-0.58490016,-0.6117448,-0.53406406,1.7347126,-0.58490016,-0.6117448,-0.53406406,1.7360319,-0.58490016,-0.6117448,-0.53406406,1.737167,-0.58490016,-0.6117448,-0.53406406,1.7382715,-0.58490016,-0.6117448,-0.53406406,1.7358478,-0.58490016,-0.6117448,-0.53406406,1.737484,-0.58490016,-0.6117448,-0.53406406,1.7321356,-0.58490016,-0.6117448,-0.53406406,1.7401634,-0.58490016,-0.6117448,-0.53406406,1.7331071,-0.58490016,-0.6117448,-0.53406406,1.7342218,-0.58490016,-0.6117448,-0.53406406,1.7265723,-0.58490016,-0.6117448,-0.53406406,1.7361853,-0.58490016,-0.6117448,-0.53406406,1.7303357,-0.58490016,-0.6117448,-0.53406406,1.7343854,-0.58490016,-0.6117448,-0.53406406,1.7333423,-0.58490016,-0.6117448,-0.53406406,1.7296505,-0.58490016,-0.6117448,-0.53406406,1.7353876,-0.58490016,-0.6117448,-0.53406406,1.7355921,-0.58490016,-0.6117448,-0.53406406,1.7353671,-0.58490016,-0.6117448,-0.53406406,1.7367068,-0.58490016,-0.6117448,-0.53406406,1.7359398,-0.58490016,-0.6117448,-0.53406406,1.7360319,-0.58490016,-0.6117448,-0.53406406,1.7350399,-0.58490016,-0.6117448,-0.53406406,1.7330048,-0.58490016,-0.6117448,-0.53406406,1.7335366,-0.58490016,-0.6117448,-0.53406406,1.7332298,-0.58490016,-0.6117448,-0.53406406,1.7318901,-0.58490016,-0.6117448,-0.53406406,1.7338536,-0.58490016,-0.6117448,-0.53406406,1.7325548,-0.58490016,-0.6117448,-0.53406406,1.7335366,-0.58490016,-0.6117448,-0.53406406,1.7326673,-0.58490016,-0.6117448,-0.53406406,1.7275438,-0.58490016,-0.6117448,-0.53406406,1.7339866,-0.58490016,-0.6117448,-0.53406406,1.7367784,-0.58490016,-0.6117448,-0.53406406,1.7328514,-0.58490016,-0.6117448,-0.53406406,1.7375658,-0.58490016,-0.6117448,-0.53406406,1.7363796,-0.58490016,-0.6117448,-0.53406406,1.7373409,-0.58490016,-0.6117448,-0.53406406,1.7381488,-0.58490016,-0.6117448,-0.53406406,1.7385067,-0.58490016,-0.6117448,-0.53406406,1.7358887,-0.58490016,-0.6117448,-0.53406406,1.7375352,-0.58490016,-0.6117448,-0.53406406,1.7367579,-0.58490016,-0.6117448,-0.53406406,1.7342627,-0.58490016,-0.6117448,-0.53406406,1.7387419,-0.58490016,-0.6117448,-0.53406406,1.7385374,-0.58490016,-0.6117448,-0.53406406,1.7368602,-0.58490016,-0.6117448,-0.53406406,1.7366659,-0.58490016,-0.6117448,-0.53406406,1.7373306,-0.58490016,-0.6117448,-0.53406406,1.7389873,-0.58490016,-0.6117448,-0.53406406,1.7387112,-0.58490016,-0.58514559,-0.58514559,1.7420757,-0.58514559,-0.58514559,-0.58514559,1.7420757,-0.58514559,-0.58514559,-0.58514559,1.7420757,-0.58514559,-0.58514559,-0.58514559,1.7420757,-0.58514559,-0.58514559,-0.58514559,1.7420757,-0.58514559,-0.58514559,-0.58514559,1.7420757,-0.58514559:5
-0.59202333,-0.59202333,1.7309664,-0.59202333,-0.59202333,-0.59202333,1.7290065,-0.59202333,-0.59202333,-0.59202333,1.7287812,-0.59202333,-0.59202333,-0.59202333,1.7296435,-0.59202333,-0.59202333,-0.59202333,1.7272231,-0.59202333,-0.59202333,-0.59202333,1.7272916,-0.59202333,-0.59202333,-0.59202333,1.7278796,-0.59202333,-0.59202333,-0.59202333,1.7289477,-0.59202333,-0.59202333,-0.59202333,1.7290947,-0.59202333,-0.59202333,-0.59202333,1.7301237,-0.59202333,-0.59202333,-0.59202333,1.7292123,-0.59202333,-0.59202333,-0.59202333,1.7275366,-0.59202333,-0.59202333,-0.59202333,1.7278796,-0.59202333,-0.59202333,-0.59202333,1.7267331,-0.59202333,-0.59202333,-0.59202333,1.7286244,-0.59202333,-0.59202333,-0.59202333,1.7275856,-0.59202333,-0.59202333,-0.59202333,1.7276542,-0.59202333,-0.59202333,-0.59202333,1.7259393,-0.59202333,-0.59202333,-0.59202333,1.7267135,-0.59202333,-0.59202333,-0.59202333,1.7268115,-0.59202333,-0.62752645,-0.50276086,1.7263607,-0.59033784,-0.65592502,-0.46116254,1.7280854,-0.59104339,-0.65795349,-0.45609626,1.7265763,-0.59101399,-0.65998196,-0.45203932,1.7252142,-0.59100419,-0.65998196,-0.45203932,1.7241852,-0.59099439,-0.65998196,-0.45304866,1.7215492,-0.59100419,-0.65998196,-0.45304866,1.7218138,-0.59099439,-0.65897263,-0.45406779,1.7191876,-0.5909846,-0.65897263,-0.45406779,1.722392,-0.59099439,-0.65897263,-0.45507713,1.7229701,-0.59100419,-0.65795349,-0.45609626,1.7222254,-0.59102379,-0.65694416,-0.4571056,1.7215884,-0.59102379,-0.65694416,-0.45812473,1.7209025,-0.59102379,-0.65694416,-0.45913407,1.7216374,-0.59102379,-0.65592502,-0.4601532,1.7226565,-0.59103359,-0.65592502,-0.4601532,1.7229603,-0.59104339,-0.65592502,-0.46116254,1.7235287,-0.59103359,-0.65491569,-0.46116254,1.7228133,-0.59104339,-0.65491569,-0.46218167,1.7238227,-0.59104339,-0.65491569,-0.46319101,1.7253024,-0.59104339,-0.65491569,-0.46319101,1.7257923,-0.59105319,-0.65389655,-0.46319101,1.7245772,-0.59105319,-0.65389655,-0.46319101,1.7262529,-0.59105319,-0.65389655,-0.46421014,1.7244008,-0.59105319,-0.65389655,-0.46421014,1.724979,-0.59103359,-0.65389655,-0.46421014,1.7277718,-0.59105319,-0.65389655,-0.46421014,1.728007,-0.59106299,-0.65389655,-0.46421014,1.728497,-0.59105319,-0.65389655,-0.46421014,1.7292613,-0.59105319,-0.65389655,-0.46421014,1.7308586,-0.59106299,-0.65389655,-0.46521948,1.7319757,-0.59106299,-0.65389655,-0.46521948,1.7315348,-0.59105319,-0.65389655,-0.46521948,1.7328577,-0.59106299,-0.65389655,-0.46521948,1.7315838,-0.59106299,-0.65288722,-0.46521948,1.7327597,-0.59105319,-0.65288722,-0.46521948,1.7320443,-0.59106299,-0.65389655,-0.46421014,1.7305156,-0.59105319,-0.65389655,-0.46421014,1.731084,-0.59105319,-0.65389655,-0.46421014,1.7313976,-0.59104339,-0.65389655,-0.46421014,1.7294573,-0.59105319,-0.65389655,-0.46421014,1.7308586,-0.59105319,-0.65389655,-0.46521948,1.7310252,-0.59105319,-0.65389655,-0.46521948,1.7298885,-0.59105319,-0.65389655,-0.46421014,1.7306332,-0.59106299,-0.65389655,-0.46421014,1.7304568,-0.59105319,-0.65389655,-0.46521948,1.7291731,-0.59106299,-0.65389655,-0.46521948,1.728595,-0.59105319,-0.65389655,-0.46521948,1.7288301,-0.59106299,-0.65389655,-0.46521948,1.7287322,-0.59106299,-0.65389655,-0.46521948,1.728693,-0.59105319,-0.65389655,-0.46521948,1.7297807,-0.59105319,-0.65389655,-0.46521948,1.7291829,-0.59106299,-0.65389655,-0.46421014,1.7283794,-0.59105319,-0.65389655,-0.46421014,1.7288595,-0.59105319,-0.65389655,-0.46421014,1.7285656,-0.59104339,-0.65389655,-0.46421014,1.7261353,-0.59105319,-0.65389655,-0.46421014,1.7270663,-0.59105319,-0.65389655,-0.46421014,1.7268507,-0.59105319,-0.65389655,-0.46421014,1.7269389,-0.59105319,-0.65491569,-0.46421014,1.7264391,-0.59104339,-0.65389655,-0.46421014,1.7275072,-0.59105319,-0.65389655,-0.46421014,1.728252,-0.59105319,-0.65491569,-0.46421014,1.7287126,-0.59105319,-0.65389655,-0.46319101,1.7286832,-0.59103359,-0.65389655,-0.46421014,1.7284872,-0.59105319,-0.65389655,-0.46421014,1.7262431,-0.59104339,-0.65389655,-0.46421014,1.7275072,-0.59104339,-0.65389655,-0.46421014,1.7290359,-0.59105319,-0.65389655,-0.46421014,1.7297709,-0.59105319,-0.65389655,-0.46319101,1.7300845,-0.59105319,-0.65491569,-0.46319101,1.7322501,-0.59104339,-0.65491569,-0.46319101,1.7319267,-0.59104339,-0.65389655,-0.46421014,1.7296337,-0.59105319,-0.65491569,-0.46421014,1.7276934,-0.59105319,-0.65389655,-0.46421014,1.728399,-0.59105319,-0.65389655,-0.46421014,1.7266939,-0.59105319,-0.65389655,-0.46421014,1.7263019,-0.59103359,-0.59202333,-0.59202333,1.7278502,-0.59202333,-0.59202333,-0.59202333,1.7267331,-0.59202333,-0.59202333,-0.59202333,1.7267429,-0.59202333,-0.59202333,-0.59202333,1.7262333,-0.59202333,-0.59202333,-0.59202333,1.7264685,-0.59202333,-0.59202333,-0.59202333,1.7294083,-0.59202333,-0.59202333,-0.59202333,1.7295357,-0.59202333,-0.59202333,-0.59202333,1.7268801,-0.59202333,-0.59202333,-0.59202333,1.7263607,-0.59202333,-0.59202333,-0.59202333,1.7290555,-0.59202333,-0.59202333,-0.59202333,1.7296925,-0.59202333,-0.59202333,-0.59202333,1.7288987,-0.59202333,-0.59202333,-0.59202333,1.7291241,-0.59202333,-0.59202333,-0.59202333,1.7293691,-0.59202333,-0.59202333,-0.59202333,1.7278796,-0.59202333,-0.59202333,-0.59202333,1.7304764,-0.59202333,-0.59202333,-0.59202333,1.7310252,-0.59202333,-0.59202333,-0.59202333,1.7326911,-0.59202333,-0.59202333,-0.59202333,1.7320149,-0.59202333,-0.59202333,-0.59202333,1.7333281,-0.59202333,-0.59202333,-0.59202333,1.7311526,-0.59202333,-0.59202333,-0.59202333,1.7323383,-0.59202333,-0.59202333,-0.59202333,1.7327107,-0.59202333,-0.59202333,-0.59202333,1.7332399,-0.59202333,-0.59202333,-0.59202333,1.7313584,-0.59202333,-0.59202333,-0.59202333,1.7323579,-0.59202333,-0.59202333,-0.59202333,1.7334848,-0.59202333,-0.59202333,-0.59202333,1.7336416,-0.59202333,-0.59202333,-0.59202333,1.7317602,-0.59202333,-0.59202333,-0.59202333,1.7330439,-0.59202333,-0.59202333,-0.59202333,1.7315054,-0.59202333,-0.59202333,-0.59202333,1.7322305,-0.59202333,-0.59202333,-0.59202333,1.7317504,-0.59202333,-0.59202333,-0.59202333,1.7324461,-0.59202333,-0.59202333,-0.59202333,1.7332007,-0.59202333,-0.59202333,-0.59202333,1.7314074,-0.59202333,-0.59202333,-0.59202333,1.7319659,-0.59202333,-0.59202333,-0.59202333,1.7331125,-0.59202333,-0.59202333,-0.59202333,1.7333869,-0.59202333,-0.59202333,-0.59202333,1.733867,-0.59202333,-0.59202333,-0.59202333,1.7317896,-0.59202333,-0.59202333,-0.59202333,1.7324755,-0.59202333,-0.59202333,-0.59202333,1.7331517,-0.59202333,-0.59202333,-0.59202333,1.7302609,-0.59202333,-0.59202333,-0.59202333,1.730545,-0.59202333,-0.59202333,-0.59202333,1.7292809,-0.59202333,-0.59202333,-0.59202333,1.7286146,-0.59202333,-0.59202333,-0.59202333,1.7292417,-0.59202333,-0.59202333,-0.59202333,1.7304568,-0.59202333,-0.59202333,-0.59202333,1.7304078,-0.59202333,-0.59202333,-0.59202333,1.7317504,-0.59202333,-0.59202333,-0.59202333,1.7267135,-0.59202333,-0.59202333,-0.59202333,1.7265861,-0.59202333,-0.59202333,-0.59202333,1.7278502,-0.59202333,-0.59202333,-0.59202333,1.7257433,-0.59202333,-0.59202333,-0.59202333,1.724587,-0.59202333,-0.59202333,-0.59202333,1.7271545,-0.59202333,-0.59202333,-0.59202333,1.7270957,-0.59202333,-0.59202333,-0.59202333,1.730692,-0.59202333,-0.59202333,-0.59202333,1.7308684,-0.59202333,-0.59202333,-0.59202333,1.731476,-0.59202333,-0.65186808,-0.46826708,1.731084,-0.59106299,-0.65389655,-0.46521948,1.7274386,-0.59105319,-0.65592502,-0.46116254,1.7288889,-0.59104339,-0.65795349,-0.4571056,1.7286832,-0.59102379,-0.65998196,-0.45304866,1.7268605,-0.59099439,-0.6610011,-0.45203932,1.7263705,-0.5909846,-0.6610011,-0.45203932,1.7276346,-0.59099439,-0.65998196,-0.45406779,1.7274484,-0.59100419,-0.65897263,-0.45406779,1.7269977,-0.59099439,-0.65897263,-0.45507713,1.7269977,-0.59100419,-0.65795349,-0.45609626,1.7269781,-0.59101399,-0.65795349,-0.4571056,1.7273308,-0.59101399,-0.65694416,-0.45812473,1.7261549,-0.59100419,-0.65694416,-0.45913407,1.7280462,-0.59102379,-0.65592502,-0.4601532,1.7271447,-0.59102379,-0.65592502,-0.4601532,1.7284284,-0.59103359,-0.65592502,-0.46116254,1.7282422,-0.59103359,-0.65592502,-0.46116254,1.7261353,-0.59103359,-0.65491569,-0.46218167,1.7271251,-0.59104339,-0.65491569,-0.46218167,1.7266547,-0.59104339,-0.65491569,-0.46218167,1.7261451,-0.59104339,-0.65491569,-0.46218167,1.7282324,-0.59103359,-0.65592502,-0.46116254,1.7292613,-0.59102379,-0.65592502,-0.4601532,1.7293299,-0.59101399,-0.65592502,-0.4601532,1.7299179,-0.59103359,-0.65592502,-0.4601532,1.7288595,-0.59102379,-0.65592502,-0.4601532,1.7282422,-0.59103359,-0.65592502,-0.4601532,1.7289281,-0.59103359,-0.65592502,-0.4601532,1.7309468,-0.59103359,-0.65592502,-0.4601532,1.7278306,-0.59102379,-0.65592502,-0.46116254,1.7276444,-0.59104339,-0.65592502,-0.46116254,1.7288007,-0.59103359,-0.65592502,-0.46116254,1.7283206,-0.59102379,-0.65592502,-0.46116254,1.7294181,-0.59104339,-0.65592502,-0.46116254,1.7295161,-0.59104339,-0.65592502,-0.46116254,1.7295063,-0.59104339,-0.65491569,-0.46116254,1.7288301,-0.59103359,-0.65592502,-0.46116254,1.7296141,-0.59104339,-0.65592502,-0.46116254,1.7312408,-0.59104339,-0.65592502,-0.46116254,1.731574,-0.59104339,-0.65592502,-0.46218167,1.7301629,-0.59104339,-0.65592502,-0.46218167,1.7327401,-0.59104339,-0.65491569,-0.46218167,1.7332007,-0.59105319,-0.65491569,-0.46218167,1.7322697,-0.59104339,-0.65491569,-0.46218167,1.7329263,-0.59104339,-0.65491569,-0.46218167,1.7332497,-0.59104339,-0.65491569,-0.46218167,1.7333379,-0.59104339,-0.65491569,-0.46218167,1.7321521,-0.59103359,-0.65491569,-0.46218167,1.7317014,-0.59103359,-0.65491569,-0.46218167,1.7312702,-0.59103359,-0.65491569,-0.46319101,1.7329949,-0.59104339,-0.65491569,-0.46319101,1.7330243,-0.59104339,-0.65491569,-0.46218167,1.7332693,-0.59105319,-0.65491569,-0.46218167,1.734798,-0.59104339,-0.65491569,-0.46218167,1.7332301,-0.59103359,-0.65491569,-0.46218167,1.7299669,-0.59103359,-0.65491569,-0.46218167,1.7299179,-0.59103359,-0.65491569,-0.46319101,1.730496,-0.59104339,-0.65491569,-0.46319101,1.7299963,-0.59104339,-0.65491569,-0.46319101,1.7300845,-0.59104339,-0.65491569,-0.46319101,1.7283206,-0.59104339,-0.65491569,-0.46319101,1.7281246,-0.59104339,-0.65491569,-0.46319101,1.7292319,-0.59105319,-0.65491569,-0.46319101,1.7311624,-0.59104339,-0.65491569,-0.46319101,1.7307508,-0.59104339,-0.65491569,-0.46319101,1.7338278,-0.59105319,-0.65491569,-0.46319101,1.733867,-0.59105319,-0.65491569,-0.46319101,1.7344158,-0.59103359,-0.65491569,-0.46319101,1.7341708,-0.59104339,-0.65491569,-0.46319101,1.7349254,-0.59105319,-0.65491569,-0.46319101,1.7360817,-0.59105319,-0.65491569,-0.46319101,1.7333869,-0.59105319,-0.65491569,-0.46319101,1.7310154,-0.59105319,-0.65491569,-0.46319101,1.7319267,-0.59105319,-0.65491569,-0.46319101,1.7324559,-0.59104339,-0.65491569,-0.46319101,1.731721,-0.59105319,-0.65491569,-0.46319101,1.7329067,-0.59105319,-0.65491569,-0.46421014,1.7301335,-0.59104339,-0.65491569,-0.46421014,1.7312506,-0.59105319,-0.65491569,-0.46421014,1.7320443,-0.59105319,-0.65491569,-0.46421014,1.7318582,-0.59105319,-0.65389655,-0.46421014,1.7312702,-0.59105319,-0.65389655,-0.46421014,1.7311232,-0.59105319,-0.65491569,-0.46421014,1.7333477,-0.59105319,-0.65491569,-0.46319101,1.7310448,-0.59105319,-0.65491569,-0.46319101,1.7329753,-0.59105319,-0.65491569,-0.46319101,1.7320345,-0.59105319,-0.65491569,-0.46319101,1.7322011,-0.59104339,-0.65491569,-0.46319101,1.7298003,-0.59103359,-0.65491569,-0.46319101,1.7293789,-0.59104339,-0.65491569,-0.46421014,1.7287909,-0.59103359,-0.65389655,-0.46421014,1.7297807,-0.59105319,-0.65389655,-0.46421014,1.7294769,-0.59105319,-0.65389655,-0.46421014,1.7283598,-0.59105319,-0.65389655,-0.46421014,1.7293397,-0.59105319,-0.65389655,-0.46421014,1.7258609,-0.59105319,-0.65389655,-0.46421014,1.7267233,-0.59105319,-0.65389655,-0.46421014,1.7257531,-0.59105319,-0.65389655,-0.46421014,1.7280364,-0.59105319,-0.65389655,-0.46421014,1.725665,-0.59104339,-0.65389655,-0.46421014,1.7288301,-0.59104339,-0.65389655,-0.46421014,1.728056,-0.59105319,-0.65389655,-0.46421014,1.7282422,-0.59104339,-0.65389655,-0.46421014,1.7283304,-0.59103359,-0.65389655,-0.46421014,1.7308292,-0.59105319,-0.65389655,-0.46421014,1.7313486,-0.59105319,-0.65389655,-0.46421014,1.7305646,-0.59105319,-0.65389655,-0.46421014,1.7298395,-0.59105319,-0.65389655,-0.46421014,1.7300257,-0.59105319,-0.65491569,-0.46421014,1.7314368,-0.59105319,-0.65389655,-0.46421014,1.7313878,-0.59105319,-0.65491569,-0.46421014,1.7318582,-0.59105319,-0.65389655,-0.46421014,1.7304862,-0.59105319,-0.65389655,-0.46421014,1.7301335,-0.59105319,-0.65389655,-0.46421014,1.7296141,-0.59105319,-0.65389655,-0.46421014,1.7294867,-0.59105319,-0.65389655,-0.46421014,1.7289477,-0.59104339,-0.65389655,-0.46421014,1.7292515,-0.59105319,-0.65389655,-0.46421014,1.7296435,-0.59106299,-0.65389655,-0.46421014,1.731035,-0.59105319,-0.65389655,-0.46421014,1.7292515,-0.59105319,-0.65389655,-0.46421014,1.7300257,-0.59104339,-0.65389655,-0.46421014,1.73079,-0.59105319,-0.65389655,-0.46421014,1.7277816,-0.59103359,-0.65389655,-0.46421014,1.7295063,-0.59105319,-0.65491569,-0.46421014,1.7289085,-0.59105319,-0.65389655,-0.46421014,1.7285754,-0.59103359,-0.65491569,-0.46421014,1.7294769,-0.59105319,-0.65491569,-0.46421014,1.7291731,-0.59105319,-0.65389655,-0.46421014,1.7293397,-0.59105319,-0.65491569,-0.46421014,1.7288497,-0.59105319,-0.65389655,-0.46421014,1.7292025,-0.59105319,-0.65491569,-0.46421014,1.7287812,-0.59105319,-0.65491569,-0.46421014,1.7275072,-0.59105319,-0.65389655,-0.46421014,1.7271055,-0.59106299,-0.65389655,-0.46421014,1.7270957,-0.59105319,-0.65389655,-0.46421014,1.7275366,-0.59106299,-0.65389655,-0.46421014,1.7263803,-0.59106299,-0.65389655,-0.46421014,1.7269095,-0.59105319,-0.65389655,-0.46421014,1.7267625,-0.59106299,-0.65491569,-0.46421014,1.7271839,-0.59105319,-0.65389655,-0.46421014,1.7274778,-0.59105319,-0.65389655,-0.46421014,1.7260863,-0.59105319,-0.65389655,-0.46421014,1.7266057,-0.59105319,-0.65389655,-0.46421014,1.7262921,-0.59105319,-0.65389655,-0.46421014,1.7252436,-0.59104339,-0.65389655,-0.46421014,1.7233033,-0.59103359,-0.65389655,-0.46421014,1.7251358,-0.59105319,-0.65389655,-0.46421014,1.7252926,-0.59105319,-0.65389655,-0.46421014,1.7224214,-0.59105319,-0.59202333,-0.59202333,1.7265371,-0.59202333,-0.59202333,-0.59202333,1.7260079,-0.59202333,-0.59202333,-0.59202333,1.7266547,-0.59202333,-0.59202333,-0.59202333,1.7257335,-0.59202333,-0.59202333,-0.59202333,1.7264979,-0.59202333,-0.59202333,-0.59202333,1.7270369,-0.59202333,-0.59202333,-0.59202333,1.7275268,-0.59202333,-0.59202333,-0.59202333,1.7275758,-0.59202333,-0.59202333,-0.59202333,1.7261647,-0.59202333,-0.59202333,-0.59202333,1.7261745,-0.59202333,-0.59202333,-0.59202333,1.7267135,-0.59202333,-0.59202333,-0.59202333,1.7264587,-0.59202333,-0.59202333,-0.59202333,1.7292613,-0.59202333,-0.59202333,-0.59202333,1.7296043,-0.59202333,-0.59202333,-0.59202333,1.7292221,-0.59202333,-0.59202333,-0.59202333,1.7259883,-0.59202333,-0.59202333,-0.59202333,1.7260863,-0.59202333,-0.59202333,-0.59202333,1.7272818,-0.59202333,-0.59202333,-0.59202333,1.7298787,-0.59202333,-0.59202333,-0.59202333,1.7285558,-0.59202333,-0.65592502,-0.46218167,1.7270467,-0.59103359,-0.65795349,-0.45812473,1.7304666,-0.59101399,-0.65998196,-0.45406779,1.7293397,-0.5909846,-0.66201043,-0.45203932,1.7292907,-0.5909846,-0.6610011,-0.45203932,1.7282128,-0.5909846,-0.65998196,-0.45406779,1.7284872,-0.59099439,-0.65998196,-0.45507713,1.7288889,-0.59099439,-0.65897263,-0.45609626,1.7297807,-0.59100419,-0.65897263,-0.4571056,1.7296141,-0.5909846,-0.65795349,-0.45812473,1.7297415,-0.59100419,-0.65795349,-0.45812473,1.7288693,-0.59101399,-0.65694416,-0.45913407,1.7298003,-0.59102379,-0.65694416,-0.45913407,1.7296827,-0.59102379,-0.65694416,-0.4601532,1.7289379,-0.59100419,-0.65694416,-0.4601532,1.7286832,-0.59101399,-0.65592502,-0.46116254,1.7298885,-0.59103359,-0.65592502,-0.46116254,1.7294867,-0.59103359,-0.65592502,-0.46116254,1.7287028,-0.59103359,-0.65592502,-0.46218167,1.7304666,-0.59104339,-0.65592502,-0.46218167,1.7314858,-0.59104339,-0.65592502,-0.46218167,1.731525,-0.59103359,-0.65592502,-0.46218167,1.7325735,-0.59104339,-0.65592502,-0.46218167,1.7312408,-0.59104339,-0.65592502,-0.46218167,1.7316818,-0.59104339,-0.65491569,-0.46319101,1.7304568,-0.59104339,-0.65491569,-0.46319101,1.7306038,-0.59105319,-0.65491569,-0.46319101,1.7303784,-0.59105319,-0.59202333,-0.59202333,1.7317014,-0.59202333,-0.59202333,-0.59202333,1.7310252,-0.59202333,-0.59202333,-0.59202333,1.7314858,-0.59202333,-0.59202333,-0.59202333,1.7302511,-0.59202333,-0.59202333,-0.59202333,1.7302511,-0.59202333,-0.59202333,-0.59202333,1.7302511,-0.59202333,-0.59202333,-0.59202333,1.7302511,-0.59202333,-0.59202333,-0.59202333,1.7302511,-0.59202333,-0.59202333,-0.59202333,1.7302511,-0.59202333,-0.59202333,-0.59202333,1.7302511,-0.59202333:5
-1.3068457,-1.3068457,1.4297018,-1.3068457,-1.3068457,-1.3068457,1.4331073,-1.3068457,-1.3068457,-1.3068457,1.4342011,-1.3068457,-1.3068457,-1.3068457,1.4338515,-1.3068457,-1.3068457,-1.3068457,1.4333554,-1.3068457,-1.3068457,-1.3068457,1.4325998,-1.3068457,-1.3068457,-1.3068457,1.4337613,-1.3068457,-1.3068457,-1.3068457,1.4342011,-1.3068457,-1.3068457,-1.3068457,1.4340658,-1.3068457,-1.3068457,-1.3068457,1.4347085,-1.3068457,-1.3068457,-1.3068457,1.43322,-1.3068457,-1.3068457,-1.3068457,1.4342349,-1.3068457,-1.3068457,-1.3068457,1.4359038,-1.3068457,-1.3068457,-1.3068457,1.4365804,-1.3068457,-1.3068457,-1.3068457,1.4346522,-1.3068457,-1.3068457,-1.3068457,1.4346747,-1.3068457,-1.3068457,-1.3068457,1.4330171,-1.3068457,-1.3068457,-1.3068457,1.4330509,-1.3068457,-1.3068457,-1.3068457,1.4339192,-1.3068457,-1.3068457,-1.3068457,1.434686,-1.3068457,-1.3068457,-1.3068457,1.4331975,-1.3068457,-1.2368077,1.6161805,1.4275367,-1.2947574,-1.2368077,1.6126736,1.4265557,-1.2947687,-0.21071794,0.30291331,1.4295552,-1.2971029,-0.21071794,0.30291331,1.4312467,-1.2971142,-0.21187941,0.30875451,1.4302994,-1.2970916,-0.21187941,0.31342296,1.4306716,-1.2970578,-0.21421364,0.30408606,1.4279201,-1.2971142,-0.21772062,0.29708338,1.4226202,-1.2971254,-0.21772062,0.2935764,1.4240636,-1.2971367,-0.21772062,0.30758176,1.4239508,-1.2970803,-0.21772062,0.29941761,1.4245033,-1.2971254,-0.21772062,0.29941761,1.4242778,-1.2971254,-0.21772062,0.30291331,1.4246161,-1.2971254,-0.21888209,0.29473788,1.424447,-1.2971593,-0.21772062,0.30291331,1.4251461,-1.2971254,-0.21772062,0.30991599,1.4243793,-1.2970803,-0.21888209,0.30057908,1.4231614,-1.2971254,-0.21888209,0.30408606,1.4251574,-1.2971142,-0.22005484,0.29941761,1.4227442,-1.2971254,-0.21888209,0.30291331,1.4248416,-1.2971029,-0.22005484,0.29708338,1.4214023,-1.2971367,-0.22122759,0.29473788,1.4204777,-1.297148,-0.22122759,0.29240365,1.4218872,-1.297148,-0.22122759,0.29708338,1.4208949,-1.2971367,-0.22122759,0.29591063,1.4200717,-1.2971367,-0.22005484,0.30057908,1.4228006,-1.2971254,-0.22122759,0.29708338,1.4209625,-1.2971367,-0.22122759,0.29824486,1.4214136,-1.2971367,-0.22238907,0.2935764,1.4174781,-1.297148,-0.22356182,0.28890795,1.4151439,-1.2971593,-0.22356182,0.29006943,1.4159107,-1.2971593,-0.22356182,0.29240365,1.4167113,-1.297148,-0.22356182,0.29124218,1.4170947,-1.297148,-0.22356182,0.29124218,1.4170947,-1.297148,-0.22356182,0.2877352,1.4166888,-1.2971593,-0.22356182,0.29124218,1.4174668,-1.2971593,-0.22005484,0.30175183,1.4224398,-1.2971254,-0.22005484,0.30291331,1.4236012,-1.2971254,-0.21888209,0.30408606,1.4243116,-1.2971254,-0.22122759,0.29591063,1.4196206,-1.297148,-0.22122759,0.30175183,1.4201619,-1.2971254,-0.2247233,0.2877352,1.4146252,-1.2971593,-0.22238907,0.29473788,1.4185719,-1.297148,-0.22356182,0.2935764,1.4176473,-1.297148,-0.22238907,0.29708338,1.4196432,-1.2971367,-0.22122759,0.29941761,1.4210866,-1.2971367,-0.22122759,0.29941761,1.42147,-1.2971367,-0.22122759,0.29941761,1.4209964,-1.2971367,-0.22122759,0.29941761,1.421064,-1.2971254,-0.22122759,0.30057908,1.4214813,-1.2971367,-0.22122759,0.29941761,1.4208949,-1.2971367,-0.22005484,0.30175183,1.4237929,-1.2971367,-0.21772062,0.31108874,1.4285967,-1.2971029,-0.21888209,0.30524753,1.4259355,-1.2971254,-0.21654787,0.31342296,1.4307054,-1.2971029,-0.21772062,0.30991599,1.4287997,-1.2971142,-0.22005484,0.30642029,1.4253604,-1.2971142,-0.21888209,0.30875451,1.4274352,-1.2971142,-0.22122759,0.30175183,1.4222481,-1.2971254,-0.21772062,0.31108874,1.4291154,-1.2971142,-0.21888209,0.30991599,1.4271759,-1.2971029,-0.22238907,0.29824486,1.4208385,-1.2971367,-0.22005484,0.30291331,1.4229021,-1.2971254,-0.22005484,0.30291331,1.4233983,-1.2971254,-0.22005484,0.30291331,1.4231276,-1.2971254,-0.22238907,0.29824486,1.4199928,-1.2971367,-0.22005484,0.30408606,1.42359,-1.2971254,-0.22005484,0.30524753,1.4244921,-1.2971254,-0.22122759,0.30057908,1.4211655,-1.2971367,-0.22122759,0.30057908,1.42147,-1.2971254,-0.22122759,0.30057908,1.421797,-1.2971254,-0.22122759,0.30057908,1.4212219,-1.2971254,-0.22122759,0.29941761,1.4208159,-1.2971367,-0.22238907,0.29708338,1.4186509,-1.2971367,-0.22122759,0.29941761,1.4207145,-1.2971367,-0.22238907,0.29941761,1.4209964,-1.2971367,-0.22356182,0.2935764,1.4168579,-1.297148,-0.22356182,0.2935764,1.4165309,-1.297148,-0.2247233,0.29124218,1.4156739,-1.297148,-0.2247233,0.29006943,1.4145801,-1.297148,-0.2247233,0.29006943,1.4147379,-1.2971593,-0.22356182,0.2935764,1.4170271,-1.297148,-0.23172597,0.26906139,1.4014655,-1.2972044,-0.2399014,0.2433849,1.3856334,-1.2972608,-0.23756718,0.25154906,1.3911476,-1.2972382,-0.23872865,0.24805335,1.3890163,-1.2972495,-0.23872865,0.2468806,1.3877308,-1.2972495,-0.23872865,0.24805335,1.3885202,-1.2972495,-0.2399014,0.2433849,1.3862987,-1.2972608,-0.24223563,0.23871645,1.3826451,-1.2972608,-0.2399014,0.2433849,1.3849117,-1.2972495,-0.2399014,0.2433849,1.3854304,-1.2972608,-0.24106288,0.24105068,1.3839758,-1.2972608,-0.2399014,0.24454638,1.3856898,-1.2972495,-0.24106288,0.24221215,1.3846862,-1.2972608,-0.24106288,0.23987792,1.3826903,-1.2972608,-0.23872865,0.2468806,1.3863777,-1.2972495,-0.2399014,0.24571913,1.3858815,-1.2972495,-0.24106288,0.24105068,1.3828932,-1.2972608,-0.24106288,0.24105068,1.3826903,-1.2972608,-0.23756718,0.25038758,1.3890502,-1.2972382,-0.2399014,0.2433849,1.3850019,-1.2972495,-0.24106288,0.2433849,1.3838743,-1.2972495,-0.2399014,0.24571913,1.3855206,-1.2972495,-0.2399014,0.24571913,1.3865355,-1.2972495,-0.24106288,0.24105068,1.3830173,-1.2972608,-0.24106288,0.24221215,1.3833781,-1.2972608,-0.23523295,0.26088596,1.397079,-1.2972269,-0.23172597,0.26789992,1.3997515,-1.2972044,-0.2340602,0.26205871,1.3976541,-1.2972157,-0.23756718,0.25154906,1.3898057,-1.2972382,-0.23639443,0.25505603,1.3917678,-1.2972269,-0.2340602,0.26088596,1.3965603,-1.2972269,-0.23756718,0.25038758,1.3889149,-1.2972382,-0.23289873,0.26205871,1.3969099,-1.2972157,-0.23756718,0.25272181,1.391001,-1.2972382,-0.24106288,0.24221215,1.3845283,-1.2972608,-0.2340602,0.26088596,1.3957258,-1.2972157,-0.23639443,0.25739026,1.3943727,-1.2972269,-0.23639443,0.25739026,1.3941359,-1.2972269,-0.23639443,0.25621751,1.392794,-1.2972269,-0.23756718,0.25505603,1.3921174,-1.2972269,-0.23523295,0.25855173,1.3937863,-1.2972269,-0.23523295,0.26088596,1.3956807,-1.2972157,-0.23639443,0.25739026,1.3934931,-1.2972269,-0.23523295,0.26088596,1.3955003,-1.2972157,-0.2340602,0.26439294,1.3974624,-1.2972044,-0.23523295,0.26088596,1.3961543,-1.2972157,-0.23639443,0.25972449,1.3947786,-1.2972157,-0.23172597,0.27256837,1.4033825,-1.2971931,-0.23172597,0.27139562,1.4022662,-1.2971931,-0.23289873,0.26672716,1.4003717,-1.2972044,-0.23172597,0.27023414,1.4014881,-1.2971931,-0.2340602,0.26555441,1.3986577,-1.2972157,-0.23289873,0.26906139,1.400056,-1.2971931,-0.2340602,0.26439294,1.398139,-1.2972157,-0.23523295,0.26205871,1.3958048,-1.2972157,-0.23289873,0.26672716,1.398872,-1.2972044,-0.2340602,0.26555441,1.3979586,-1.2972044,-0.23523295,0.26088596,1.3948801,-1.2972157,-0.2340602,0.26555441,1.398342,-1.2972044,-0.2340602,0.26322019,1.3970452,-1.2972157,-0.23523295,0.26205871,1.3959739,-1.2972157,-0.23639443,0.26088596,1.3950041,-1.2972157,-0.23523295,0.26322019,1.3961318,-1.2972157,-0.2340602,0.26439294,1.3977443,-1.2972044,-0.23523295,0.26088596,1.3965377,-1.2972157,-0.23639443,0.25739026,1.3935946,-1.2972269,-0.2340602,0.26555441,1.3985224,-1.2972044,-0.2340602,0.26439294,1.3979022,-1.2972157,-0.23523295,0.26205871,1.397282,-1.2972157,-0.23523295,0.26205871,1.3959739,-1.2972157,-0.2340602,0.26439294,1.3979135,-1.2972044,-0.23289873,0.26672716,1.3995937,-1.2972044,-0.2340602,0.26439294,1.3981728,-1.2972044,-0.23523295,0.26205871,1.3958273,-1.2972157,-0.2340602,0.26439294,1.3975301,-1.2972157,-0.2340602,0.26439294,1.3972707,-1.2972157,-0.2340602,0.26555441,1.3977556,-1.2972044,-0.23289873,0.26789992,1.4000222,-1.2972044,-0.2340602,0.26439294,1.3979135,-1.2972044,-0.23289873,0.26789992,1.3995937,-1.2971931,-0.23289873,0.26789992,1.4000785,-1.2972044,-0.2340602,0.26555441,1.3977894,-1.2971931,-0.23289873,0.27256837,1.3980037,-1.2971705,-0.2340602,0.26439294,1.3980713,-1.2972044,-0.2340602,0.26322019,1.3978571,-1.2972157,-0.2247233,0.29006943,1.4138358,-1.2971593,-0.22589605,0.29006943,1.4138471,-1.2971593,-0.22589605,0.29124218,1.4148733,-1.297148,-0.2247233,0.29124218,1.4148169,-1.297148,-0.22589605,0.29240365,1.4149184,-1.297148,-0.22823027,0.27957105,1.4082314,-1.2971705,-0.22823027,0.27957105,1.4084908,-1.2971818,-0.22939175,0.27256837,1.4070136,-1.2972044,-0.22823027,0.28190527,1.4090546,-1.2971705,-0.22589605,0.29006943,1.413926,-1.297148,-0.2247233,0.2935764,1.4161137,-1.297148,-0.22705752,0.28890795,1.4126631,-1.2971593,-0.22589605,0.29006943,1.4135426,-1.2971593,-0.2247233,0.2935764,1.4150424,-1.297148,-0.22589605,0.29240365,1.4146139,-1.297148,-0.22939175,0.27839829,1.4065061,-1.2971818,-0.22939175,0.27839829,1.4061904,-1.2971818,-0.23289873,0.26672716,1.3989735,-1.2972044,-0.23172597,0.27256837,1.4022436,-1.2971931,-0.2305645,0.27606407,1.4041493,-1.2971818,-0.22939175,0.27606407,1.4060889,-1.2971818,-0.22939175,0.27957105,1.4069234,-1.2971818,-0.2305645,0.27490259,1.404544,-1.2971931,-0.2305645,0.27372984,1.4042057,-1.2971931,-0.22939175,0.28190527,1.4085021,-1.2971705,-0.23172597,0.27490259,1.4037208,-1.2971931,-0.23523295,0.26322019,1.3982969,-1.2972157,-0.24223563,0.24221215,1.3831188,-1.2972608,-0.2399014,0.24221215,1.3894787,-1.297272,-0.2399014,0.25038758,1.3880804,-1.2972382,-0.24339711,0.23637095,1.3817543,-1.2972946,-0.24339711,0.23987792,1.3819009,-1.297272,-0.24223563,0.23987792,1.3825098,-1.2972608,-0.2399014,0.24921483,1.3870091,-1.2972382,-0.2399014,0.2468806,1.3866708,-1.2972495,-0.23872865,0.25154906,1.3885427,-1.2972382,-0.2399014,0.25038758,1.3874489,-1.2972382,-0.22823027,0.28540097,1.4095846,-1.2971593,-0.22939175,0.28190527,1.4075323,-1.2971705,-0.22939175,0.27839829,1.4087389,-1.2971931,-0.22939175,0.28190527,1.4080961,-1.2971705,-0.22823027,0.28540097,1.4099229,-1.2971593,-0.22939175,0.28190527,1.4086487,-1.2971705,-0.22823027,0.2842395,1.4103288,-1.2971705,-0.22823027,0.2842395,1.4094944,-1.2971705,-0.22705752,0.28540097,1.4106108,-1.2971593,-0.22705752,0.28306675,1.4108025,-1.2971705,-0.22823027,0.28190527,1.4086261,-1.2971705,-0.22823027,0.28540097,1.4102837,-1.2971593,-0.2305645,0.27839829,1.4059874,-1.2971818,-0.23756718,0.25272181,1.3903921,-1.2972382,-0.23872865,0.24921483,1.3880466,-1.2972382,-0.23756718,0.25388328,1.3906853,-1.2972382,-0.23639443,0.25855173,1.3918806,-1.2972044,-0.23756718,0.25505603,1.3922301,-1.2972382,-0.23756718,0.25505603,1.3911025,-1.2972382,-0.22939175,0.28190527,1.4079721,-1.2971705,-0.22939175,0.27957105,1.4066302,-1.2971818,-0.22823027,0.28657372,1.4069346,-1.297148,-0.22939175,0.27957105,1.4065061,-1.2971931,-0.22939175,0.28540097,1.4055025,-1.297148,-0.22939175,0.28073252,1.4074985,-1.2971705,-0.22939175,0.27957105,1.406258,-1.2971818,-0.2305645,0.27606407,1.4045327,-1.2971818,-0.22939175,0.27957105,1.4063708,-1.2971818,-0.23172597,0.27372984,1.4027623,-1.2971931,-0.23172597,0.27372984,1.4023789,-1.2971818,-0.2305645,0.27839829,1.4053785,-1.2971818,-0.23172597,0.27372984,1.4028187,-1.2971931,-0.23172597,0.27372984,1.4031232,-1.2971931,-0.23172597,0.27372984,1.4029315,-1.2971931,-0.23172597,0.27256837,1.4020519,-1.2971931,-0.23172597,0.27606407,1.4039689,-1.2971818,-0.2305645,0.27606407,1.4040591,-1.2971818,-0.23172597,0.27490259,1.4032698,-1.2971818,-0.23172597,0.27372984,1.4024353,-1.2971931,-0.23172597,0.27606407,1.4041832,-1.2971818,-0.23172597,0.27490259,1.4040028,-1.2971818,-0.2305645,0.27606407,1.4045891,-1.2971931,-0.23289873,0.27139562,1.4009468,-1.2971931,-0.2305645,0.27723682,1.4047921,-1.2971818,-0.2305645,0.27723682,1.4050853,-1.2971818,-0.23172597,0.27139562,1.402706,-1.2971931,-0.2305645,0.27490259,1.4031796,-1.2971931,-0.23172597,0.27372984,1.4036306,-1.2971931,-0.23172597,0.27372984,1.402627,-1.2971931,-0.2305645,0.27839829,1.4056717,-1.2971818,-0.23172597,0.27372984,1.4025255,-1.2971931,-0.23872865,0.25154906,1.3885427,-1.2972382,-0.24106288,0.2433849,1.3847087,-1.2972495,-0.2399014,0.24571913,1.3867611,-1.2972495,-0.23639443,0.25855173,1.3933127,-1.2972269,-0.23523295,0.26205871,1.3955905,-1.2972157,-0.23523295,0.25972449,1.3940231,-1.2972269,-0.2340602,0.26205871,1.3959401,-1.2972157,-0.23523295,0.26088596,1.3953086,-1.2972157,-0.23523295,0.26322019,1.3958724,-1.2972157,-0.2340602,0.26789992,1.3980488,-1.2971818,-0.2340602,0.26555441,1.3975188,-1.2972044,-0.23639443,0.26205871,1.3944403,-1.2972157,-0.2340602,0.26555441,1.3980037,-1.2972044,-0.23523295,0.26555441,1.3968309,-1.2972044,-0.23523295,0.26322019,1.3967745,-1.2972157,-0.2340602,0.26439294,1.3971579,-1.2972157,-0.23523295,0.26439294,1.3967971,-1.2972269,-0.23639443,0.25739026,1.3947335,-1.2972382,-0.23289873,0.27023414,1.4003266,-1.2971931,-0.23172597,0.27023414,1.4036757,-1.2972157,-0.23289873,0.27139562,1.4004619,-1.2971931,-0.23172597,0.27372984,1.4021647,-1.2971818,-0.23289873,0.27256837,1.401567,-1.2971931,-0.23289873,0.27139562,1.40177,-1.2971931,-0.23289873,0.27139562,1.4011047,-1.2972044,-0.23289873,0.27023414,1.4011611,-1.2972044,-0.23289873,0.27023414,1.3999207,-1.2971931,-0.23289873,0.26906139,1.3995034,-1.2972044,-0.2340602,0.26789992,1.3984886,-1.2972044,-0.2340602,0.26789992,1.3984209,-1.2972044,-0.2340602,0.26672716,1.3986013,-1.2972044,-0.2340602,0.26789992,1.3984096,-1.2972044,-0.2340602,0.26789992,1.3986577,-1.2972044,-0.23523295,0.26439294,1.3955454,-1.2972044,-0.2340602,0.26789992,1.397936,-1.2972044,-0.23523295,0.26555441,1.3964701,-1.2972044,-0.23523295,0.26555441,1.3973835,-1.2972044,-0.23639443,0.25972449,1.3938539,-1.2972157,-0.23523295,0.26322019,1.3952071,-1.2972044,-0.23523295,0.26322019,1.3951958,-1.2972157,-0.23756718,0.25855173,1.3926699,-1.2972269,-0.23523295,0.26322019,1.3952297,-1.2972157,-0.23523295,0.26439294,1.3966956,-1.2972157,-0.23639443,0.25972449,1.3937637,-1.2972157,-0.23523295,0.26205871,1.3959401,-1.2972157,-0.23639443,0.26088596,1.3939893,-1.2972157,-0.23756718,0.25739026,1.3917452,-1.2972269,-0.23639443,0.25855173,1.3929744,-1.2972269,-0.23639443,0.25972449,1.3930984,-1.2972269,-0.23639443,0.25972449,1.3930533,-1.2971931,-0.23639443,0.25739026,1.3940005,-1.2972269,-0.23756718,0.25388328,1.391531,-1.2972382,-0.2399014,0.24805335,1.3861747,-1.2972495,-0.2399014,0.25154906,1.3882383,-1.2972382,-0.2399014,0.24221215,1.3869866,-1.2972608,-0.24106288,0.24571913,1.3856672,-1.2972495,-0.23756718,0.25505603,1.3914972,-1.2972269,-0.23639443,0.25621751,1.3925684,-1.2972269,-0.23756718,0.25272181,1.3930082,-1.2972382,-0.23172597,0.26789992,1.4030781,-1.2972269,-0.2340602,0.26322019,1.3996049,-1.2972157,-0.23172597,0.27023414,1.4008792,-1.2971931,-0.23172597,0.27256837,1.4024804,-1.2971931,-0.2305645,0.27372984,1.4019392,-1.2971931,-0.2305645,0.27606407,1.4034277,-1.2971818,-0.23172597,0.27023414,1.4029089,-1.2972044,-0.23172597,0.27372984,1.4031345,-1.2971931,-0.23172597,0.27490259,1.4029428,-1.2971818,-0.23289873,0.27023414,1.4012964,-1.2971931,-0.23289873,0.26088596,1.4004958,-1.2972382,-0.23172597,0.27372984,1.4017024,-1.2971818,-0.23172597,0.27139562,1.4017249,-1.2971931,-0.23172597,0.27372984,1.4028977,-1.2971931,-0.23172597,0.27372984,1.4035291,-1.2971931,-0.23172597,0.27372984,1.4031232,-1.2971931,-0.23172597,0.27256837,1.4023677,-1.2971931,-0.2305645,0.27606407,1.4044313,-1.2971818,-0.23172597,0.27372984,1.4024015,-1.2971818,-0.22939175,0.27957105,1.4063257,-1.2971705,-0.22823027,0.28190527,1.4068782,-1.2971705,-0.22939175,0.27839829,1.4046568,-1.2971818,-0.22939175,0.27256837,1.4061678,-1.2972044,-0.22939175,0.28073252,1.4067993,-1.2971818,-0.2305645,0.27139562,1.4035968,-1.2972044,-0.2305645,0.27139562,1.4035968,-1.2972044,-0.2305645,0.27139562,1.4035968,-1.2972044,-0.2305645,0.27139562,1.4035968,-1.2972044,-0.2305645,0.27139562,1.4035968,-1.2972044,-0.2305645,0.27139562,1.4035968,-1.2972044:5
-0.58362343,-0.58362343,1.7311651,-0.58362343,-0.58362343,-0.58362343,1.7309098,-0.58362343,-0.58362343,-0.58362343,1.7303208,-0.58362343,-0.58362343,-0.58362343,1.729987,-0.58362343,-0.58362343,-0.58362343,1.7292311,-0.58362343,-0.58362343,-0.58362343,1.7287598,-0.58362343,-0.58362343,-0.58362343,1.7306742,-0.58362343,-0.58362343,-0.58362343,1.7284751,-0.58362343,-0.58362343,-0.58362343,1.7285929,-0.58362343,-0.58362343,-0.58362343,1.7295943,-0.58362343,-0.58362343,-0.58362343,1.7279057,-0.58362343,-0.58362343,-0.58362343,1.7307528,-0.58362343,-0.58362343,-0.58362343,1.729398,-0.58362343,-0.58362343,-0.58362343,1.7291623,-0.58362343,-0.58362343,-0.58362343,1.7288384,-0.58362343,-0.58362343,-0.58362343,1.7302913,-0.58362343,-0.58362343,-0.58362343,1.7331678,-0.58362343,-0.58362343,-0.58362343,1.7315676,-0.58362343,-0.58362343,-0.58362343,1.7290445,-0.58362343,-0.58362343,-0.58362343,1.725039,-0.58362343,-0.58362343,-0.58362343,1.7241947,-0.58362343,-0.58362343,-0.58362343,1.724666,-0.58362343,-0.58362343,-0.58362343,1.7255888,-0.58362343,-0.58362343,-0.58362343,1.7252354,-0.58362343,-0.58362343,-0.58362343,1.7243714,-0.58362343,-0.58362343,-0.58362343,1.7264724,-0.58362343,-0.58362343,-0.58362343,1.7249409,-0.58362343,-0.58362343,-0.58362343,1.7265509,-0.58362343,-0.58362343,-0.58362343,1.7253139,-0.58362343,-0.58362343,-0.58362343,1.7237431,-0.58362343,-0.58362343,-0.58362343,1.7238315,-0.58362343,-0.58362343,-0.58362343,1.7213379,-0.58362343,-0.58362343,-0.58362343,1.7228988,-0.58362343,-0.58362343,-0.58362343,1.7218778,-0.58362343,-0.58362343,-0.58362343,1.7224276,-0.58362343,-0.58362343,-0.58362343,1.7242536,-0.58362343,-0.58362343,-0.58362343,1.7229479,-0.58362343,-0.58362343,-0.58362343,1.7238806,-0.58362343,-0.58362343,-0.58362343,1.724234,-0.58362343,-0.58362343,-0.58362343,1.7268062,-0.58362343,-0.58362343,-0.58362343,1.7266982,-0.58362343,-0.58362343,-0.58362343,1.7247936,-0.58362343,-0.58362343,-0.58362343,1.7260895,-0.58362343,-0.58362343,-0.58362343,1.7265018,-0.58362343,-0.58362343,-0.58362343,1.7265313,-0.58362343,-0.58362343,-0.58362343,1.7255103,-0.58362343,-0.58362343,-0.58362343,1.7253237,-0.58362343,-0.60089225,-0.53891494,1.7255299,-0.58332891,-0.60191327,-0.53586172,1.7255692,-0.58331909,-0.60292446,-0.53485053,1.7260895,-0.58330927,-0.60292446,-0.53485053,1.7248525,-0.58330927,-0.60191327,-0.53586172,1.7258342,-0.58330927,-0.60191327,-0.53586172,1.7258539,-0.58330927,-0.60191327,-0.53688273,1.7267374,-0.58331909,-0.60191327,-0.53688273,1.7268651,-0.58331909,-0.60089225,-0.53789393,1.7283573,-0.58331909,-0.60089225,-0.53789393,1.7277585,-0.58331909,-0.60089225,-0.53789393,1.7258735,-0.58331909,-0.60089225,-0.53789393,1.7235173,-0.58331909,-0.60089225,-0.53891494,1.7240867,-0.58331909,-0.60089225,-0.53891494,1.7237726,-0.58332891,-0.60089225,-0.53891494,1.7250881,-0.58332891,-0.60089225,-0.53891494,1.7253336,-0.58332891,-0.60089225,-0.53891494,1.7262466,-0.58332891,-0.59988106,-0.53891494,1.72606,-0.58332891,-0.59988106,-0.53891494,1.7240082,-0.58332891,-0.59988106,-0.53891494,1.7246463,-0.58332891,-0.59988106,-0.53992613,1.7233406,-0.58332891,-0.59988106,-0.53992613,1.7234781,-0.58332891,-0.59988106,-0.53992613,1.7226141,-0.58332891,-0.59988106,-0.53992613,1.7247838,-0.58332891,-0.59988106,-0.53992613,1.7248623,-0.58332891,-0.59988106,-0.53992613,1.7251274,-0.58332891,-0.59988106,-0.53992613,1.7230166,-0.58332891,-0.59988106,-0.53992613,1.7229774,-0.58333872,-0.59988106,-0.53992613,1.722673,-0.58332891,-0.59988106,-0.53992613,1.7241555,-0.58332891,-0.59988106,-0.53992613,1.7259619,-0.58333872,-0.59988106,-0.53992613,1.724234,-0.58332891,-0.59988106,-0.53992613,1.7223294,-0.58333872,-0.59988106,-0.53992613,1.7239493,-0.58333872,-0.59988106,-0.54094714,1.7233014,-0.58333872,-0.59886005,-0.54094714,1.7208961,-0.58333872,-0.59988106,-0.54094714,1.7207979,-0.58333872,-0.59988106,-0.54094714,1.7215146,-0.58333872,-0.59988106,-0.54094714,1.7217011,-0.58333872,-0.59988106,-0.54094714,1.721279,-0.58333872,-0.59988106,-0.54094714,1.7209157,-0.58333872,-0.59886005,-0.54094714,1.7215735,-0.58333872,-0.59886005,-0.54094714,1.7213575,-0.58333872,-0.59886005,-0.54094714,1.7190406,-0.58333872,-0.59886005,-0.54094714,1.7183436,-0.58333872,-0.59886005,-0.54094714,1.7188933,-0.58333872,-0.59886005,-0.54094714,1.7211121,-0.58333872,-0.59886005,-0.54094714,1.7220447,-0.58333872,-0.59886005,-0.54094714,1.7220742,-0.58333872,-0.59886005,-0.54094714,1.7236253,-0.58333872,-0.59886005,-0.54094714,1.7232523,-0.58333872,-0.59886005,-0.54094714,1.7256183,-0.58333872,-0.59886005,-0.54094714,1.7243813,-0.58333872,-0.59886005,-0.54094714,1.7257852,-0.58333872,-0.59886005,-0.54094714,1.7263349,-0.58333872,-0.59886005,-0.54094714,1.7269043,-0.58333872,-0.59886005,-0.54094714,1.7257852,-0.58333872,-0.59886005,-0.54094714,1.7271989,-0.58333872,-0.59886005,-0.54094714,1.7275523,-0.58333872,-0.59886005,-0.54094714,1.7285438,-0.58333872,-0.59886005,-0.54195833,1.7282591,-0.58333872,-0.59886005,-0.54094714,1.727513,-0.58333872,-0.59886005,-0.54195833,1.7253139,-0.58333872,-0.59886005,-0.54195833,1.7280726,-0.58333872,-0.59886005,-0.54195833,1.7283475,-0.58333872,-0.59886005,-0.54195833,1.7304975,-0.58333872,-0.59886005,-0.54195833,1.7277977,-0.58333872,-0.59886005,-0.54195833,1.7266098,-0.58333872,-0.59886005,-0.54195833,1.7260208,-0.58333872,-0.59886005,-0.54195833,1.7285242,-0.58333872,-0.59886005,-0.54195833,1.7268553,-0.58333872,-0.59886005,-0.54195833,1.7280628,-0.58333872,-0.59886005,-0.54195833,1.7254121,-0.58333872,-0.59886005,-0.54195833,1.7238806,-0.58333872,-0.59886005,-0.54195833,1.7254808,-0.58333872,-0.59886005,-0.54195833,1.7246856,-0.58333872,-0.59886005,-0.54195833,1.7248034,-0.58333872,-0.59886005,-0.54195833,1.7266098,-0.58333872,-0.59886005,-0.54195833,1.725687,-0.58333872,-0.59886005,-0.54195833,1.7274934,-0.58333872,-0.59886005,-0.54195833,1.7274541,-0.58333872,-0.59886005,-0.54195833,1.727621,-0.58333872,-0.59886005,-0.54195833,1.7262564,-0.58333872,-0.59886005,-0.54195833,1.7271203,-0.58333872,-0.59886005,-0.54195833,1.7294274,-0.58333872,-0.59886005,-0.54195833,1.7301539,-0.58333872,-0.59886005,-0.54195833,1.7281708,-0.58333872,-0.59886005,-0.54094714,1.7308902,-0.58333872,-0.59886005,-0.54195833,1.7299477,-0.58334854,-0.59886005,-0.54195833,1.729506,-0.58333872,-0.59886005,-0.54195833,1.7277192,-0.58333872,-0.59886005,-0.54195833,1.7278075,-0.58333872,-0.59886005,-0.54195833,1.7286518,-0.58333872,-0.59886005,-0.54195833,1.7290249,-0.58333872,-0.59886005,-0.54195833,1.7283475,-0.58333872,-0.59886005,-0.54195833,1.7281315,-0.58333872,-0.59886005,-0.54195833,1.7301735,-0.58334854,-0.59886005,-0.54195833,1.7291231,-0.58334854,-0.59886005,-0.54195833,1.7287206,-0.58333872,-0.59886005,-0.54195833,1.7278959,-0.58333872,-0.59886005,-0.54195833,1.7292213,-0.58334854,-0.59886005,-0.54195833,1.7302619,-0.58333872,-0.59886005,-0.54195833,1.7239002,-0.58333872,-0.59886005,-0.54195833,1.727248,-0.58333872,-0.59886005,-0.54195833,1.7277977,-0.58334854,-0.59886005,-0.54195833,1.7263153,-0.58334854,-0.59886005,-0.54195833,1.7266589,-0.58333872,-0.59886005,-0.54195833,1.7296729,-0.58334854,-0.59886005,-0.54195833,1.7279646,-0.58334854,-0.59886005,-0.54195833,1.7283966,-0.58334854,-0.59886005,-0.54195833,1.7284359,-0.58333872,-0.59886005,-0.54195833,1.7299281,-0.58333872,-0.59886005,-0.54195833,1.7293194,-0.58334854,-0.59886005,-0.54195833,1.7284162,-0.58333872,-0.59886005,-0.54195833,1.7297219,-0.58334854,-0.59886005,-0.54195833,1.7290249,-0.58333872,-0.59886005,-0.54195833,1.7277192,-0.58333872,-0.59886005,-0.54195833,1.7241064,-0.58334854,-0.59886005,-0.54195833,1.724882,-0.58333872,-0.59886005,-0.54195833,1.7230657,-0.58334854,-0.59886005,-0.54195833,1.7232915,-0.58334854,-0.59886005,-0.54195833,1.7240278,-0.58334854,-0.59886005,-0.54195833,1.7230265,-0.58333872,-0.59886005,-0.54195833,1.7243616,-0.58334854,-0.59886005,-0.54195833,1.7241358,-0.58334854,-0.59886005,-0.54195833,1.7249114,-0.58334854,-0.59886005,-0.54195833,1.7224472,-0.58333872,-0.59886005,-0.54195833,1.7229774,-0.58334854,-0.59886005,-0.54195833,1.7244304,-0.58334854,-0.59886005,-0.54195833,1.7235173,-0.58334854,-0.59886005,-0.54195833,1.7230657,-0.58333872,-0.59886005,-0.54195833,1.7230559,-0.58334854,-0.59886005,-0.54195833,1.7235959,-0.58334854,-0.59886005,-0.54195833,1.7243027,-0.58334854,-0.59886005,-0.54195833,1.7223,-0.58334854,-0.59886005,-0.54195833,1.7238511,-0.58334854,-0.59886005,-0.54195833,1.7229479,-0.58334854,-0.59886005,-0.54195833,1.7253434,-0.58333872,-0.59886005,-0.54195833,1.7261386,-0.58334854,-0.59886005,-0.54195833,1.7286715,-0.58334854,-0.59886005,-0.54195833,1.7285046,-0.58333872,-0.59886005,-0.54195833,1.7277486,-0.58333872,-0.59886005,-0.54195833,1.7296729,-0.58334854,-0.59886005,-0.54195833,1.7283279,-0.58334854,-0.59886005,-0.54195833,1.7291329,-0.58333872,-0.59886005,-0.54195833,1.7269829,-0.58333872,-0.59886005,-0.54195833,1.727729,-0.58333872,-0.59886005,-0.54195833,1.7262858,-0.58333872,-0.59886005,-0.54195833,1.7284064,-0.58333872,-0.59886005,-0.54195833,1.7300361,-0.58333872,-0.59886005,-0.54195833,1.7288678,-0.58333872,-0.59886005,-0.54195833,1.7286911,-0.58333872,-0.59886005,-0.54195833,1.729506,-0.58333872,-0.59886005,-0.54195833,1.729182,-0.58333872,-0.59886005,-0.54195833,1.729398,-0.58334854,-0.59886005,-0.54195833,1.728053,-0.58333872,-0.59886005,-0.54195833,1.729074,-0.58333872,-0.59886005,-0.54195833,1.7300852,-0.58333872,-0.59886005,-0.54195833,1.7292409,-0.58333872,-0.59886005,-0.54195833,1.7304779,-0.58333872,-0.59886005,-0.54195833,1.7297318,-0.58333872,-0.59886005,-0.54195833,1.7287598,-0.58333872,-0.59886005,-0.54195833,1.7309982,-0.58333872,-0.59886005,-0.54195833,1.7297318,-0.58333872,-0.59886005,-0.54195833,1.7298397,-0.58333872,-0.59886005,-0.54195833,1.7307037,-0.58333872,-0.59886005,-0.54195833,1.7290544,-0.58333872,-0.59886005,-0.54195833,1.7310178,-0.58333872,-0.59886005,-0.54195833,1.7307135,-0.58333872,-0.59886005,-0.54195833,1.731656,-0.58333872,-0.59886005,-0.54195833,1.7307822,-0.58333872,-0.59886005,-0.54195833,1.7298103,-0.58333872,-0.59886005,-0.54195833,1.7282788,-0.58333872,-0.59886005,-0.54195833,1.7296532,-0.58333872,-0.59886005,-0.54195833,1.7296041,-0.58334854,-0.59886005,-0.54195833,1.7297219,-0.58333872,-0.59886005,-0.54195833,1.7299968,-0.58333872,-0.59886005,-0.54195833,1.7327653,-0.58333872,-0.59886005,-0.54195833,1.7321763,-0.58333872,-0.59886005,-0.54195833,1.7308509,-0.58333872,-0.59886005,-0.54195833,1.7287009,-0.58333872,-0.59886005,-0.54195833,1.7300165,-0.58333872,-0.59886005,-0.54195833,1.7304877,-0.58333872,-0.59886005,-0.54195833,1.7277486,-0.58333872,-0.59886005,-0.54195833,1.7314302,-0.58333872,-0.59886005,-0.54195833,1.7309393,-0.58333872,-0.59886005,-0.54195833,1.7308313,-0.58333872,-0.59886005,-0.54195833,1.7299183,-0.58333872,-0.59886005,-0.54195833,1.7280922,-0.58334854,-0.59886005,-0.54195833,1.726168,-0.58333872,-0.59886005,-0.54195833,1.7264233,-0.58333872,-0.59886005,-0.54195833,1.7268062,-0.58334854,-0.59886005,-0.54195833,1.7252157,-0.58333872,-0.59886005,-0.54195833,1.7244893,-0.58334854,-0.59886005,-0.54195833,1.7261189,-0.58333872,-0.59886005,-0.54195833,1.727297,-0.58334854,-0.59886005,-0.54195833,1.7233995,-0.58334854,-0.59886005,-0.54195833,1.7258146,-0.58333872,-0.59886005,-0.54195833,1.7265705,-0.58333872,-0.59886005,-0.54195833,1.7272185,-0.58333872,-0.59886005,-0.54195833,1.7279057,-0.58333872,-0.59886005,-0.54195833,1.7288482,-0.58333872,-0.59886005,-0.54195833,1.7275228,-0.58334854,-0.59886005,-0.54195833,1.7282984,-0.58334854,-0.59886005,-0.54195833,1.7280333,-0.58333872,-0.59886005,-0.54195833,1.7290642,-0.58333872,-0.59886005,-0.54195833,1.7289464,-0.58333872,-0.59886005,-0.54195833,1.7308019,-0.58333872,-0.59886005,-0.54195833,1.7293587,-0.58334854,-0.59886005,-0.54195833,1.7299183,-0.58334854,-0.59886005,-0.54195833,1.7293881,-0.58333872,-0.59886005,-0.54195833,1.7300361,-0.58333872,-0.59886005,-0.54195833,1.7311455,-0.58333872,-0.59886005,-0.54195833,1.7306448,-0.58334854,-0.59886005,-0.54195833,1.7294372,-0.58333872,-0.58362343,-0.58362343,1.7337765,-0.58362343,-0.58362343,-0.58362343,1.7336391,-0.58362343,-0.58362343,-0.58362343,1.733001,-0.58362343,-0.58362343,-0.58362343,1.7338649,-0.58362343,-0.58362343,-0.58362343,1.7350528,-0.58362343,-0.58362343,-0.58362343,1.736761,-0.58362343,-0.58362343,-0.58362343,1.7385576,-0.58362343,-0.58362343,-0.58362343,1.740796,-0.58362343,-0.58362343,-0.58362343,1.7449291,-0.58362343,-0.58362343,-0.58362343,1.7445855,-0.58362343,-0.58362343,-0.58362343,1.7480118,-0.58362343,-0.58362343,-0.58362343,1.7462741,-0.58362343,-0.58362343,-0.58362343,1.7449291,-0.58362343,-0.58362343,-0.58362343,1.7487874,-0.58362343,-0.58362343,-0.58362343,1.748483,-0.58362343,-0.58362343,-0.58362343,1.7501029,-0.58362343,-0.58362343,-0.58362343,1.7502992,-0.58362343,-0.58362343,-0.58362343,1.7504956,-0.58362343,-0.58362343,-0.58362343,1.7508883,-0.58362343,-0.58362343,-0.58362343,1.7507116,-0.58362343,-0.58362343,-0.58362343,1.7480805,-0.58362343,-0.58362343,-0.58362343,1.749023,-0.58362343,-0.58362343,-0.58362343,1.7478645,-0.58362343,-0.58362343,-0.58362343,1.7499949,-0.58362343,-0.58362343,-0.58362343,1.7506723,-0.58362343,-0.58362343,-0.58362343,1.7498673,-0.58362343,-0.58362343,-0.58362343,1.7481198,-0.58362343,-0.58362343,-0.58362343,1.7505741,-0.58362343,-0.58362343,-0.58362343,1.7506723,-0.58362343,-0.58362343,-0.58362343,1.7490721,-0.58362343,-0.58362343,-0.58362343,1.7493568,-0.58362343,-0.58362343,-0.58362343,1.7481787,-0.58362343,-0.58362343,-0.58362343,1.746873,-0.58362343,-0.58362343,-0.58362343,1.7457243,-0.58362343,-0.58362343,-0.58362343,1.7466373,-0.58362343,-0.58362343,-0.58362343,1.7498476,-0.58362343,-0.58362343,-0.58362343,1.7482081,-0.58362343,-0.58362343,-0.58362343,1.7490721,-0.58362343,-0.58362343,-0.58362343,1.7479529,-0.58362343,-0.58362343,-0.58362343,1.7458716,-0.58362343,-0.58362343,-0.58362343,1.7470006,-0.58362343,-0.58362343,-0.58362343,1.7448898,-0.58362343,-0.58362343,-0.58362343,1.7451549,-0.58362343,-0.58362343,-0.58362343,1.7449193,-0.58362343,-0.58362343,-0.58362343,1.7457341,-0.58362343,-0.58362343,-0.58362343,1.7453414,-0.58362343,-0.58362343,-0.58362343,1.7456163,-0.58362343,-0.58362343,-0.58362343,1.746225,-0.58362343,-0.58362343,-0.58362343,1.7460581,-0.58362343,-0.58362343,-0.58362343,1.7460876,-0.58362343,-0.58362343,-0.58362343,1.7480707,-0.58362343,-0.58362343,-0.58362343,1.7484339,-0.58362343,-0.58362343,-0.58362343,1.7473638,-0.58362343,-0.58362343,-0.58362343,1.7467944,-0.58362343,-0.58362343,-0.58362343,1.7494942,-0.58362343,-0.58362343,-0.58362343,1.7502501,-0.58362343,-0.58362343,-0.58362343,1.7505643,-0.58362343,-0.58362343,-0.58362343,1.7489052,-0.58362343,-0.58362343,-0.58362343,1.7490033,-0.58362343,-0.58362343,-0.58362343,1.7506919,-0.58362343,-0.58362343,-0.58362343,1.7493273,-0.58362343,-0.58362343,-0.58362343,1.7497691,-0.58362343,-0.60191327,-0.53485053,1.7475405,-0.58329945,-0.60292446,-0.53382952,1.7507901,-0.58329945,-0.60292446,-0.53485053,1.7496513,-0.58329945,-0.60292446,-0.53485053,1.7489248,-0.58330927,-0.60191327,-0.53586172,1.7510454,-0.58330927,-0.60191327,-0.53688273,1.7514086,-0.58331909,-0.60089225,-0.53688273,1.7517228,-0.58331909,-0.60089225,-0.53688273,1.7508785,-0.58331909,-0.60089225,-0.53789393,1.7498378,-0.58331909,-0.60089225,-0.53789393,1.750957,-0.58331909,-0.60089225,-0.53789393,1.7516737,-0.58331909,-0.60089225,-0.53789393,1.7479332,-0.58332891,-0.60089225,-0.53891494,1.74918,-0.58331909,-0.60089225,-0.53891494,1.7461661,-0.58332891,-0.59988106,-0.53891494,1.7471478,-0.58332891,-0.59988106,-0.53891494,1.7484536,-0.58332891,-0.59988106,-0.53891494,1.7492488,-0.58332891,-0.59988106,-0.53891494,1.7472166,-0.58332891,-0.59988106,-0.53891494,1.7480412,-0.58332891,-0.59988106,-0.53891494,1.7481787,-0.58332891,-0.59988106,-0.53891494,1.7467159,-0.58332891,-0.59988106,-0.53992613,1.7457832,-0.58332891,-0.59988106,-0.53992613,1.7496611,-0.58332891,-0.59988106,-0.53992613,1.7493469,-0.58332891,-0.59988106,-0.53992613,1.749396,-0.58332891,-0.59988106,-0.53992613,1.7496218,-0.58332891,-0.59988106,-0.53992613,1.7510159,-0.58332891,-0.59988106,-0.53992613,1.7520369,-0.58332891,-0.59988106,-0.53992613,1.7510944,-0.58332891,-0.59988106,-0.54094714,1.7142006,-0.58332891,-0.59988106,-0.54094714,1.7203365,-0.58333872,-0.59886005,-0.54094714,1.7212986,-0.58333872,-0.59988106,-0.54094714,1.7217011,-0.58333872,-0.59886005,-0.54094714,1.7212299,-0.58333872,-0.59886005,-0.54094714,1.7221429,-0.58333872,-0.59886005,-0.54094714,1.7221429,-0.58333872,-0.59886005,-0.54094714,1.7221429,-0.58333872,-0.59886005,-0.54094714,1.7221429,-0.58333872,-0.59886005,-0.54094714,1.7221429,-0.58333872,-0.59886005,-0.54094714,1.7221429,-0.58333872,-0.59886005,-0.54094714,1.7221429,-0.58333872:5
-0.61769073,-0.61769073,1.7339779,-0.61769073,-0.61769073,-0.61769073,1.7369594,-0.61769073,-0.61769073,-0.61769073,1.7381617,-0.61769073,-0.61769073,-0.61769073,1.7358548,-0.61769073,-0.61769073,-0.61769073,1.737018,-0.61769073,-0.61769073,-0.61769073,1.7366759,-0.61769073,-0.61769073,-0.61769073,1.7376632,-0.61769073,-0.61769073,-0.61769073,1.7378098,-0.61769073,-0.61769073,-0.61769073,1.7385136,-0.61769073,-0.61769073,-0.61769073,1.7379858,-0.61769073,-0.61769073,-0.61769073,1.7369985,-0.61769073,-0.61769073,-0.61769073,1.7379662,-0.61769073,-0.61769073,-0.61769073,1.7390904,-0.61769073,-0.61769073,-0.61769073,1.7401852,-0.61769073,-0.61769073,-0.61769073,1.7386407,-0.61769073,-0.61769073,-0.61769073,1.7373602,-0.61769073,-0.61769073,-0.61769073,1.7366466,-0.61769073,-0.61769073,-0.61769073,1.737673,-0.61769073,-0.61769073,-0.61769073,1.7370376,-0.61769073,-0.61769073,-0.61769073,1.7377316,-0.61769073,-0.61769073,-0.61769073,1.7369496,-0.61769073,-0.86459375,-0.16636789,1.732668,-0.61462131,-0.74822929,-0.33940919,1.7324432,-0.61566726,-0.76037014,-0.32524487,1.7355713,-0.61555973,-0.76340047,-0.32019107,1.7356006,-0.61553041,-0.76239362,-0.32119792,1.7342614,-0.61553041,-0.76037014,-0.32423802,1.734584,-0.61554996,-0.75834667,-0.32828497,1.7333034,-0.61557928,-0.75632319,-0.33131529,1.7288362,-0.61559883,-0.75530657,-0.33333877,1.7291783,-0.61560861,-0.75429972,-0.33435539,1.7299408,-0.61561838,-0.75328309,-0.33536224,1.7306739,-0.61562816,-0.75328309,-0.33637887,1.7302731,-0.61562816,-0.75328309,-0.33738572,1.7296866,-0.61562816,-0.75328309,-0.33738572,1.729452,-0.61562816,-0.75227624,-0.33840234,1.7314461,-0.61562816,-0.75125962,-0.33840234,1.7296084,-0.61563793,-0.75125962,-0.33840234,1.7293738,-0.61562816,-0.75227624,-0.33840234,1.7304002,-0.61562816,-0.75125962,-0.33940919,1.7289241,-0.61562816,-0.75125962,-0.33940919,1.7276729,-0.61562816,-0.75125962,-0.33940919,1.7275751,-0.61561838,-0.75125962,-0.33940919,1.7277413,-0.61563793,-0.75125962,-0.33940919,1.7278684,-0.61562816,-0.75125962,-0.33940919,1.7278,-0.61562816,-0.75227624,-0.34042582,1.7268518,-0.61562816,-0.75125962,-0.33940919,1.7283376,-0.61562816,-0.75227624,-0.33940919,1.727888,-0.61563793,-0.75125962,-0.33940919,1.7265292,-0.61563793,-0.75125962,-0.33940919,1.7256885,-0.61562816,-0.75025277,-0.34042582,1.7228928,-0.61563793,-0.75025277,-0.33940919,1.7251802,-0.61563793,-0.75025277,-0.33940919,1.7237921,-0.61562816,-0.75025277,-0.34042582,1.7233327,-0.61563793,-0.75125962,-0.34042582,1.726363,-0.61563793,-0.75125962,-0.34042582,1.7235966,-0.61563793,-0.75025277,-0.33940919,1.7296768,-0.61564771,-0.75125962,-0.33940919,1.7302829,-0.61564771,-0.75125962,-0.33940919,1.7299603,-0.61563793,-0.75125962,-0.33940919,1.7263044,-0.61563793,-0.75025277,-0.34042582,1.7260209,-0.61563793,-0.75125962,-0.34042582,1.7228342,-0.61563793,-0.75125962,-0.33940919,1.7253464,-0.61562816,-0.75125962,-0.34042582,1.7215732,-0.61563793,-0.75227624,-0.33840234,1.7275067,-0.61561838,-0.75227624,-0.33940919,1.7269886,-0.61562816,-0.75227624,-0.33940919,1.7283669,-0.61562816,-0.75125962,-0.34042582,1.7272917,-0.61563793,-0.75227624,-0.33940919,1.7281226,-0.61562816,-0.75227624,-0.33940919,1.7261577,-0.61563793,-0.75227624,-0.33940919,1.7272917,-0.61562816,-0.75227624,-0.33940919,1.729061,-0.61562816,-0.75227624,-0.33840234,1.7344276,-0.61562816,-0.75227624,-0.33840234,1.7308108,-0.61562816,-0.75227624,-0.33840234,1.735542,-0.61562816,-0.75227624,-0.33840234,1.7356984,-0.61562816,-0.75227624,-0.33840234,1.7315928,-0.61562816,-0.75125962,-0.33840234,1.7288459,-0.61562816,-0.75125962,-0.33840234,1.7282301,-0.61562816,-0.75125962,-0.33738572,1.7326485,-0.61562816,-0.75025277,-0.33840234,1.7291196,-0.61562816,-0.75025277,-0.33940919,1.7267834,-0.61562816,-0.75125962,-0.33840234,1.729364,-0.61562816,-0.75025277,-0.33840234,1.7297355,-0.61562816,-0.75125962,-0.33840234,1.7288557,-0.61562816,-0.75025277,-0.33940919,1.726451,-0.61563793,-0.75025277,-0.33840234,1.7303709,-0.61562816,-0.75125962,-0.33840234,1.7299994,-0.61561838,-0.75125962,-0.33840234,1.7285429,-0.61561838,-0.75125962,-0.33840234,1.7275947,-0.61561838,-0.75025277,-0.33840234,1.7280346,-0.61561838,-0.75025277,-0.33840234,1.7279075,-0.61561838,-0.75025277,-0.33840234,1.7271939,-0.61562816,-0.75025277,-0.33940919,1.7239094,-0.61562816,-0.75025277,-0.33940919,1.7262555,-0.61561838,-0.75125962,-0.33840234,1.7271353,-0.61561838,-0.75125962,-0.33940919,1.7246328,-0.61561838,-0.75125962,-0.33940919,1.7228048,-0.61562816,-0.75125962,-0.33940919,1.7239876,-0.61561838,-0.75125962,-0.33940919,1.7219153,-0.61561838,-0.75025277,-0.33940919,1.7236064,-0.61562816,-0.75125962,-0.33940919,1.7232545,-0.61562816,-0.75025277,-0.34143267,1.7096962,-0.61563793,-0.74923614,-0.34345614,1.6989435,-0.61565748,-0.74822929,-0.34244929,1.7004489,-0.61565748,-0.74822929,-0.34244929,1.7009278,-0.61565748,-0.74923614,-0.34345614,1.6982299,-0.61564771,-0.74923614,-0.34345614,1.700615,-0.61564771,-0.74923614,-0.34345614,1.6973794,-0.61565748,-0.74822929,-0.34447277,1.6953266,-0.61565748,-0.74822929,-0.34447277,1.6959522,-0.61565748,-0.74923614,-0.34447277,1.6968907,-0.61564771,-0.74822929,-0.34345614,1.6948085,-0.61565748,-0.74822929,-0.34345614,1.6964215,-0.61565748,-0.74822929,-0.34447277,1.695092,-0.61564771,-0.74822929,-0.34447277,1.692482,-0.61565748,-0.74822929,-0.34447277,1.6957763,-0.61564771,-0.74923614,-0.34345614,1.6969395,-0.61564771,-0.74923614,-0.34447277,1.6935964,-0.61564771,-0.74923614,-0.34447277,1.695004,-0.61564771,-0.74822929,-0.34345614,1.6988848,-0.61564771,-0.74822929,-0.34345614,1.6951507,-0.61564771,-0.74822929,-0.34447277,1.6939288,-0.61565748,-0.74923614,-0.34345614,1.6961673,-0.61564771,-0.74822929,-0.34447277,1.6963237,-0.61564771,-0.74822929,-0.34447277,1.6937528,-0.61564771,-0.74822929,-0.34447277,1.6943491,-0.61565748,-0.75025277,-0.34244929,1.7056688,-0.61562816,-0.75025277,-0.34143267,1.7088165,-0.61563793,-0.74923614,-0.34143267,1.7064509,-0.61563793,-0.75025277,-0.34345614,1.7003218,-0.61563793,-0.75025277,-0.34345614,1.7013286,-0.61563793,-0.75025277,-0.34244929,1.7025114,-0.61563793,-0.75025277,-0.34345614,1.6992563,-0.61563793,-0.75025277,-0.34244929,1.7056493,-0.61562816,-0.75025277,-0.34244929,1.7033228,-0.61563793,-0.74822929,-0.34244929,1.6958252,-0.61564771,-0.74923614,-0.34244929,1.7060501,-0.61564771,-0.74923614,-0.34244929,1.7049846,-0.61563793,-0.74923614,-0.34244929,1.704965,-0.61563793,-0.74923614,-0.34244929,1.7027558,-0.61563793,-0.74923614,-0.34244929,1.7020715,-0.61563793,-0.75025277,-0.34244929,1.7033228,-0.61563793,-0.74923614,-0.34143267,1.7047988,-0.61563793,-0.74923614,-0.34244929,1.70301,-0.61563793,-0.75025277,-0.34244929,1.7047109,-0.61563793,-0.75025277,-0.34143267,1.706617,-0.61563793,-0.74923614,-0.34143267,1.7058448,-0.61563793,-0.75025277,-0.34143267,1.7045349,-0.61563793,-0.74923614,-0.34042582,1.7120814,-0.61564771,-0.74923614,-0.34042582,1.7113873,-0.61563793,-0.74822929,-0.34042582,1.7095789,-0.61564771,-0.74822929,-0.33940919,1.7105467,-0.61564771,-0.74923614,-0.34042582,1.7081126,-0.61563793,-0.74822929,-0.34042582,1.7096474,-0.61563793,-0.74822929,-0.34042582,1.7078389,-0.61564771,-0.74923614,-0.34143267,1.7057666,-0.61564771,-0.74923614,-0.34143267,1.7082299,-0.61564771,-0.74822929,-0.34143267,1.7075359,-0.61565748,-0.74822929,-0.34143267,1.7046913,-0.61565748,-0.74822929,-0.34143267,1.707966,-0.61564771,-0.74822929,-0.34143267,1.7069983,-0.61565748,-0.74822929,-0.34143267,1.7057861,-0.61565748,-0.74822929,-0.34143267,1.7048379,-0.61566726,-0.74923614,-0.34143267,1.7059132,-0.61565748,-0.74822929,-0.34042582,1.7073893,-0.61564771,-0.74822929,-0.34143267,1.7056493,-0.61565748,-0.74822929,-0.34143267,1.7037138,-0.61564771,-0.74923614,-0.34042582,1.7077705,-0.61564771,-0.74923614,-0.34143267,1.7072329,-0.61564771,-0.74822929,-0.34143267,1.7067637,-0.61564771,-0.74923614,-0.34143267,1.7065388,-0.61565748,-0.74923614,-0.34143267,1.7075946,-0.61564771,-0.74923614,-0.34042582,1.7087089,-0.61564771,-0.74923614,-0.34042582,1.7078976,-0.61564771,-0.74923614,-0.34143267,1.7061869,-0.61564771,-0.74923614,-0.34042582,1.7066073,-0.61564771,-0.74923614,-0.34042582,1.7070765,-0.61564771,-0.74923614,-0.34143267,1.7065486,-0.61564771,-0.74923614,-0.34042582,1.708924,-0.61564771,-0.74923614,-0.34042582,1.7068712,-0.61563793,-0.74923614,-0.34042582,1.7079856,-0.61564771,-0.74923614,-0.34042582,1.708836,-0.61564771,-0.74923614,-0.34042582,1.7073013,-0.61564771,-0.74923614,-0.34042582,1.706617,-0.61564771,-0.74923614,-0.34042582,1.7076141,-0.61564771,-0.74923614,-0.34244929,1.7063629,-0.61565748,-0.75125962,-0.33840234,1.7214167,-0.61562816,-0.75125962,-0.33840234,1.7208987,-0.61563793,-0.75125962,-0.33738572,1.7217198,-0.61562816,-0.75025277,-0.33738572,1.722492,-0.61563793,-0.75125962,-0.33840234,1.7225702,-0.61562816,-0.75025277,-0.33940919,1.7165291,-0.61564771,-0.75025277,-0.33840234,1.7165878,-0.61563793,-0.75025277,-0.33940919,1.7149846,-0.61563793,-0.75025277,-0.33940919,1.7166073,-0.61563793,-0.75025277,-0.33738572,1.7216514,-0.61562816,-0.75025277,-0.33738572,1.7237726,-0.61563793,-0.75025277,-0.33738572,1.7238997,-0.61563793,-0.75025277,-0.33738572,1.7212994,-0.61562816,-0.75025277,-0.33738572,1.7226778,-0.61563793,-0.75025277,-0.33738572,1.7219446,-0.61562816,-0.75025277,-0.33940919,1.7152583,-0.61563793,-0.75025277,-0.33840234,1.7163532,-0.61563793,-0.75025277,-0.33940919,1.7150237,-0.61563793,-0.75125962,-0.33940919,1.7136845,-0.61562816,-0.74923614,-0.34042582,1.707966,-0.61563793,-0.75125962,-0.33940919,1.7138214,-0.61561838,-0.75025277,-0.33940919,1.712707,-0.61563793,-0.75025277,-0.33940919,1.713186,-0.61563793,-0.75025277,-0.33940919,1.7144763,-0.61562816,-0.75025277,-0.33840234,1.7153659,-0.61563793,-0.75025277,-0.33940919,1.7070374,-0.61563793,-0.74923614,-0.34143267,1.6940558,-0.61564771,-0.75025277,-0.34143267,1.6946619,-0.61563793,-0.74923614,-0.34143267,1.6992074,-0.61563793,-0.75025277,-0.34042582,1.6994127,-0.61563793,-0.74923614,-0.34143267,1.6939679,-0.61563793,-0.74923614,-0.34244929,1.6935182,-0.61564771,-0.74923614,-0.34143267,1.6932738,-0.61564771,-0.75025277,-0.34042582,1.6983472,-0.61563793,-0.75025277,-0.34143267,1.6965681,-0.61563793,-0.75025277,-0.34042582,1.6989435,-0.61563793,-0.75125962,-0.34042582,1.701358,-0.61563793,-0.75025277,-0.33637887,1.7169788,-0.61562816,-0.75125962,-0.33738572,1.7162456,-0.61562816,-0.75125962,-0.33738572,1.716187,-0.61562816,-0.75025277,-0.33738572,1.7166562,-0.61562816,-0.75025277,-0.33738572,1.7172818,-0.61562816,-0.75125962,-0.33840234,1.7143199,-0.61562816,-0.75125962,-0.33637887,1.7184157,-0.61562816,-0.75227624,-0.33738572,1.7171547,-0.61562816,-0.75125962,-0.33536224,1.7190023,-0.61562816,-0.75125962,-0.33637887,1.7185428,-0.61562816,-0.75125962,-0.33840234,1.7172818,-0.61562816,-0.75025277,-0.33738572,1.7176337,-0.61562816,-0.75025277,-0.33840234,1.7145448,-0.61563793,-0.75025277,-0.34143267,1.7010647,-0.61563793,-0.75025277,-0.34143267,1.7007421,-0.61564771,-0.75025277,-0.34143267,1.7014557,-0.61563793,-0.75025277,-0.34042582,1.7027851,-0.61563793,-0.74923614,-0.34143267,1.7011038,-0.61564771,-0.75025277,-0.34143267,1.7011429,-0.61563793,-0.75125962,-0.33840234,1.7159719,-0.61562816,-0.75125962,-0.33940919,1.7143004,-0.61562816,-0.75125962,-0.33840234,1.7154538,-0.61562816,-0.75025277,-0.33840234,1.7117295,-0.61562816,-0.75025277,-0.33840234,1.7151899,-0.61562816,-0.75125962,-0.33840234,1.7146132,-0.61562816,-0.75125962,-0.33840234,1.7124822,-0.61562816,-0.75125962,-0.33840234,1.7128536,-0.61561838,-0.75025277,-0.33840234,1.7149358,-0.61562816,-0.75125962,-0.33840234,1.7129807,-0.61561838,-0.75125962,-0.33940919,1.7105174,-0.61561838,-0.75125962,-0.33840234,1.7134793,-0.61562816,-0.75125962,-0.33840234,1.7101263,-0.61561838,-0.75125962,-0.33940919,1.7107226,-0.61562816,-0.75025277,-0.33940919,1.7113971,-0.61563793,-0.75025277,-0.33940919,1.7080344,-0.61562816,-0.75025277,-0.33840234,1.7123062,-0.61562816,-0.75025277,-0.33840234,1.7124235,-0.61562816,-0.75125962,-0.33940919,1.7098135,-0.61563793,-0.75025277,-0.33940919,1.7118663,-0.61563793,-0.74923614,-0.33940919,1.7129123,-0.61563793,-0.75025277,-0.33940919,1.7100481,-0.61563793,-0.75025277,-0.33840234,1.7131567,-0.61563793,-0.75025277,-0.33940919,1.7101068,-0.61563793,-0.75025277,-0.33940919,1.7110941,-0.61563793,-0.75125962,-0.33840234,1.713186,-0.61562816,-0.75125962,-0.33840234,1.7119641,-0.61561838,-0.75125962,-0.33840234,1.7116904,-0.61562816,-0.75125962,-0.33840234,1.7116904,-0.61562816,-0.75125962,-0.33840234,1.7111136,-0.61562816,-0.75125962,-0.33840234,1.7137921,-0.61562816,-0.75125962,-0.33840234,1.7121987,-0.61562816,-0.74822929,-0.34244929,1.6915045,-0.61564771,-0.74822929,-0.34143267,1.6961575,-0.61563793,-0.74923614,-0.34244929,1.6982201,-0.61563793,-0.74923614,-0.34042582,1.7043883,-0.61563793,-0.74923614,-0.34042582,1.7045251,-0.61563793,-0.74923614,-0.34042582,1.7039875,-0.61563793,-0.74923614,-0.34042582,1.7058448,-0.61562816,-0.74923614,-0.33940919,1.7053951,-0.61563793,-0.74923614,-0.34042582,1.7045642,-0.61563793,-0.74923614,-0.33840234,1.7080051,-0.61563793,-0.74923614,-0.33940919,1.7074088,-0.61562816,-0.74923614,-0.33940919,1.7056004,-0.61563793,-0.75025277,-0.33840234,1.7074577,-0.61562816,-0.75025277,-0.33940919,1.7066464,-0.61562816,-0.75025277,-0.33940919,1.7060598,-0.61562816,-0.74923614,-0.33940919,1.7066268,-0.61563793,-0.75025277,-0.33940919,1.7052094,-0.61562816,-0.75025277,-0.33940919,1.705923,-0.61562816,-0.75025277,-0.33840234,1.7088458,-0.61562816,-0.75025277,-0.33738572,1.7123355,-0.61563793,-0.75025277,-0.33738572,1.7098038,-0.61562816,-0.75125962,-0.33840234,1.7108693,-0.61562816,-0.75025277,-0.33840234,1.7113873,-0.61563793,-0.75025277,-0.33840234,1.7081224,-0.61563793,-0.75125962,-0.33840234,1.7104001,-0.61562816,-0.75125962,-0.33840234,1.7100579,-0.61563793,-0.75125962,-0.33840234,1.7100677,-0.61563793,-0.75125962,-0.33940919,1.7082984,-0.61563793,-0.75125962,-0.33940919,1.7077216,-0.61563793,-0.75125962,-0.33940919,1.7050432,-0.61562816,-0.75125962,-0.33940919,1.7069201,-0.61563793,-0.75025277,-0.33840234,1.706881,-0.61563793,-0.75125962,-0.33840234,1.7057275,-0.61562816,-0.75025277,-0.33840234,1.7071449,-0.61563793,-0.75025277,-0.33840234,1.706314,-0.61562816,-0.75125962,-0.33940919,1.7045056,-0.61563793,-0.75025277,-0.33940919,1.704271,-0.61563793,-0.75125962,-0.33940919,1.7053267,-0.61562816,-0.75125962,-0.33940919,1.7046229,-0.61562816,-0.75025277,-0.33940919,1.7030491,-0.61562816,-0.75125962,-0.33940919,1.7046033,-0.61563793,-0.75025277,-0.33940919,1.7056786,-0.61563793,-0.75025277,-0.34042582,1.7042319,-0.61563793,-0.75025277,-0.33940919,1.7056004,-0.61564771,-0.75025277,-0.34042582,1.7044958,-0.61563793,-0.74923614,-0.34143267,1.7019933,-0.61564771,-0.75025277,-0.34042582,1.7035867,-0.61564771,-0.75025277,-0.34042582,1.7026678,-0.61563793,-0.75025277,-0.34042582,1.701094,-0.61563793,-0.75025277,-0.34143267,1.7017978,-0.61564771,-0.75025277,-0.34143267,1.6962846,-0.61564771,-0.74923614,-0.34143267,1.6960695,-0.61564771,-0.74923614,-0.34042582,1.6979171,-0.61563793,-0.75025277,-0.34042582,1.6971839,-0.61563793,-0.74923614,-0.34143267,1.6967734,-0.61564771,-0.74923614,-0.34042582,1.7017099,-0.61563793,-0.74923614,-0.34042582,1.701876,-0.61563793,-0.74923614,-0.34042582,1.7007617,-0.61563793,-0.74923614,-0.33840234,1.7121694,-0.61564771,-0.74923614,-0.33840234,1.7111136,-0.61563793,-0.74923614,-0.33940919,1.7093443,-0.61564771,-0.74923614,-0.33840234,1.7106444,-0.61564771,-0.74923614,-0.33840234,1.7111918,-0.61564771,-0.74923614,-0.33840234,1.7113189,-0.61564771,-0.74923614,-0.33840234,1.7112212,-0.61563793,-0.75025277,-0.33840234,1.7115438,-0.61563793,-0.75025277,-0.33840234,1.7115926,-0.61563793,-0.74923614,-0.33840234,1.7102925,-0.61564771,-0.74923614,-0.33840234,1.7091977,-0.61563793,-0.74923614,-0.33840234,1.7103023,-0.61564771,-0.74923614,-0.33840234,1.7116024,-0.61564771,-0.74923614,-0.33840234,1.7108399,-0.61563793,-0.74822929,-0.33840234,1.71214,-0.61564771,-0.74923614,-0.33840234,1.7118272,-0.61564771,-0.74923614,-0.33840234,1.7112603,-0.61563793,-0.74923614,-0.33840234,1.7124822,-0.61563793,-0.74923614,-0.33840234,1.7110159,-0.61563793,-0.74923614,-0.33738572,1.7139973,-0.61564771,-0.74923614,-0.33738572,1.7150922,-0.61563793,-0.74923614,-0.33738572,1.7124431,-0.61563793,-0.75025277,-0.33738572,1.713577,-0.61564771,-0.75025277,-0.33738572,1.714271,-0.61563793,-0.74923614,-0.33840234,1.7124529,-0.61563793,-0.74923614,-0.33840234,1.7120618,-0.61564771,-0.74923614,-0.33840234,1.7120618,-0.61564771,-0.74923614,-0.33840234,1.7120618,-0.61564771,-0.74923614,-0.33840234,1.7120618,-0.61564771,-0.74923614,-0.33840234,1.7120618,-0.61564771,-0.74923614,-0.33840234,1.7120618,-0.61564771,-0.74923614,-0.33840234,1.7120618,-0.61564771:5
-0.60531641,-0.60531641,1.7467115,-0.60531641,-0.60531641,-0.60531641,1.7396541,-0.60531641,-0.60531641,-0.60531641,1.7406136,-0.60531641,-0.60531641,-0.60531641,1.7460615,-0.60531641,-0.60531641,-0.60531641,1.7310696,-0.60531641,-0.60531641,-0.60531641,1.7285417,-0.60531641,-0.60531641,-0.60531641,1.7345777,-0.60531641,-0.60531641,-0.60531641,1.7454012,-0.60531641,-0.60531641,-0.60531641,1.7488989,-0.60531641,-0.60531641,-0.60531641,1.7442971,-0.60531641,-0.60531641,-0.60531641,1.742182,-0.60531641,-0.60531641,-0.60531641,1.7317196,-0.60531641,-0.60531641,-0.60531641,1.7250852,-0.60531641,-0.60531641,-0.60531641,1.7377865,-0.60531641,-0.60531641,-0.60531641,1.7439154,-0.60531641,-0.60531641,-0.60531641,1.7471655,-0.60531641,-0.60531641,-0.60531641,1.7467322,-0.60531641,-0.60531641,-0.60531641,1.7443384,-0.60531641,-0.6672651,-0.44510001,1.7367857,-0.6042124,-0.66832785,-0.44403727,1.7228772,-0.60420208,-0.67153672,-0.43976566,1.7322768,-0.60417113,-0.67259946,-0.43655679,1.7454424,-0.60416081,-0.67367252,-0.43549404,1.7444416,-0.60415049,-0.67473527,-0.43442098,1.7445654,-0.60414017,-0.67473527,-0.43442098,1.7436265,-0.60414017,-0.67473527,-0.43442098,1.7450813,-0.60412985,-0.67473527,-0.43549404,1.7244764,-0.60412985,-0.67473527,-0.43549404,1.7278401,-0.60414017,-0.67473527,-0.43549404,1.7320911,-0.60414017,-0.67473527,-0.43442098,1.7467528,-0.60412985,-0.67473527,-0.43549404,1.7425121,-0.60412985,-0.67473527,-0.43442098,1.7491672,-0.60412985,-0.67473527,-0.43549404,1.7317609,-0.60414017,-0.67473527,-0.43762985,1.7159435,-0.60414017,-0.67473527,-0.43762985,1.7229804,-0.60414017,-0.67367252,-0.43762985,1.7236923,-0.60414017,-0.67367252,-0.43762985,1.7351658,-0.60414017,-0.67367252,-0.43762985,1.7342062,-0.60414017,-0.67367252,-0.43869259,1.7326482,-0.60414017,-0.67473527,-0.43655679,1.7403144,-0.60414017,-0.67367252,-0.43976566,1.7176563,-0.60415049,-0.67367252,-0.43869259,1.7240328,-0.60415049,-0.67367252,-0.43869259,1.726994,-0.60415049,-0.67367252,-0.43869259,1.7304196,-0.60414017,-0.67473527,-0.43762985,1.7356507,-0.60414017,-0.67473527,-0.43762985,1.7342165,-0.60412985,-0.67473527,-0.43655679,1.7347531,-0.60412985,-0.67367252,-0.43762985,1.7239709,-0.60414017,-0.67473527,-0.43762985,1.7233827,-0.60412985,-0.67473527,-0.43655679,1.7297798,-0.60412985,-0.67580833,-0.43549404,1.7338141,-0.60412985,-0.67580833,-0.43549404,1.7300275,-0.60412985,-0.67473527,-0.43549404,1.7309767,-0.60412985,-0.67473527,-0.43655679,1.7309045,-0.60412985,-0.67367252,-0.43762985,1.7184095,-0.60412985,-0.67473527,-0.43655679,1.727252,-0.60412985,-0.67473527,-0.43762985,1.7251058,-0.60412985,-0.67473527,-0.43655679,1.741697,-0.60412985,-0.67473527,-0.43762985,1.7335046,-0.60412985,-0.67367252,-0.43869259,1.7292536,-0.60414017,-0.67367252,-0.43869259,1.7345261,-0.60414017,-0.67367252,-0.43976566,1.7235994,-0.60414017,-0.67367252,-0.43869259,1.7366103,-0.60414017,-0.67259946,-0.43976566,1.7280877,-0.60415049,-0.67259946,-0.4408284,1.7282115,-0.60415049,-0.67259946,-0.43976566,1.7420375,-0.60415049,-0.67259946,-0.4408284,1.7323593,-0.60415049,-0.67153672,-0.44190146,1.7320704,-0.60416081,-0.67153672,-0.44190146,1.7352999,-0.60416081,-0.67153672,-0.44296421,1.7283972,-0.60416081,-0.67153672,-0.44190146,1.7267464,-0.60415049,-0.67153672,-0.44190146,1.7394684,-0.60415049,-0.67153672,-0.44403727,1.7259313,-0.60416081,-0.67153672,-0.44403727,1.7259313,-0.60416081,-0.67153672,-0.44403727,1.7286449,-0.60416081,-0.67046365,-0.44510001,1.7180484,-0.60417113,-0.67046365,-0.44617307,1.7157372,-0.60417113,-0.67046365,-0.44510001,1.7229081,-0.60417113,-0.67046365,-0.44510001,1.729429,-0.60417113,-0.67046365,-0.44617307,1.7248685,-0.60417113,-0.67046365,-0.44617307,1.7327205,-0.60417113,-0.66940091,-0.44617307,1.7266742,-0.60418144,-0.66940091,-0.44723582,1.7197818,-0.60418144,-0.66940091,-0.44830888,1.7167896,-0.60418144,-0.66940091,-0.44830888,1.7155411,-0.60419176,-0.66940091,-0.44723582,1.7338451,-0.60418144,-0.66832785,-0.44830888,1.7228978,-0.60419176,-0.66832785,-0.44830888,1.7317815,-0.60419176,-0.66832785,-0.44830888,1.7296664,-0.60419176,-0.66832785,-0.45044469,1.7147983,-0.60419176,-0.6672651,-0.45044469,1.7151594,-0.60420208,-0.66832785,-0.44938194,1.7254773,-0.60419176,-0.66832785,-0.44938194,1.7379104,-0.60419176,-0.66832785,-0.44938194,1.7349594,-0.60419176,-0.66832785,-0.44938194,1.740397,-0.60419176,-0.66832785,-0.44830888,1.7476711,-0.60419176,-0.6672651,-0.45044469,1.7304402,-0.60420208,-0.6672651,-0.45151775,1.7178524,-0.60420208,-0.6672651,-0.44938194,1.7389731,-0.60420208,-0.6672651,-0.44938194,1.7441836,-0.60420208,-0.6672651,-0.45044469,1.7412946,-0.60420208,-0.6672651,-0.44938194,1.746629,-0.60420208,-0.6672651,-0.44938194,1.7499204,-0.60420208,-0.6672651,-0.45044469,1.7364968,-0.60420208,-0.66619204,-0.45365355,1.7028708,-0.6042124,-0.66619204,-0.45365355,1.7050375,-0.6042124,-0.66619204,-0.45258049,1.7149427,-0.6042124,-0.66619204,-0.45365355,1.7108878,-0.6042124,-0.66619204,-0.45258049,1.7181928,-0.60420208,-0.6672651,-0.45151775,1.7373738,-0.60420208,-0.66619204,-0.45258049,1.7299037,-0.6042124,-0.66619204,-0.45258049,1.7174087,-0.6042124,-0.66619204,-0.45151775,1.726571,-0.6042124,-0.66619204,-0.45258049,1.7222478,-0.6042124,-0.66619204,-0.45258049,1.7220724,-0.6042124,-0.66619204,-0.45258049,1.7186675,-0.6042124,-0.66619204,-0.45151775,1.7394684,-0.60420208,-0.66619204,-0.45151775,1.7336387,-0.6042124,-0.66619204,-0.45365355,1.7172745,-0.6042124,-0.66619204,-0.45365355,1.7171817,-0.6042124,-0.66619204,-0.45365355,1.7227637,-0.6042124,-0.6651293,-0.45365355,1.7155102,-0.6042124,-0.6651293,-0.4547163,1.7117957,-0.6042124,-0.6651293,-0.45365355,1.7203596,-0.6042124,-0.66619204,-0.45258049,1.7342165,-0.6042124,-0.6651293,-0.4547163,1.7068431,-0.60422271,-0.6651293,-0.45365355,1.7238367,-0.6042124,-0.6651293,-0.45365355,1.7273448,-0.6042124,-0.6651293,-0.4547163,1.7137252,-0.6042124,-0.6651293,-0.45365355,1.7198437,-0.6042124,-0.6651293,-0.45365355,1.7188841,-0.60422271,-0.6651293,-0.45365355,1.7218247,-0.6042124,-0.6651293,-0.45578936,1.7012612,-0.60422271,-0.6651293,-0.4547163,1.7086591,-0.6042124,-0.6651293,-0.45365355,1.7181619,-0.6042124,-0.6651293,-0.4547163,1.7019421,-0.6042124,-0.6651293,-0.45365355,1.7096083,-0.6042124,-0.66619204,-0.45365355,1.7154792,-0.6042124,-0.66619204,-0.45365355,1.7098353,-0.6042124,-0.6651293,-0.45365355,1.7115275,-0.6042124,-0.66619204,-0.45258049,1.7119092,-0.6042124,-0.66619204,-0.45365355,1.713168,-0.6042124,-0.66619204,-0.45365355,1.7115791,-0.6042124,-0.66619204,-0.45365355,1.7135292,-0.6042124,-0.66619204,-0.45151775,1.7261273,-0.6042124,-0.66619204,-0.45578936,1.6911703,-0.6042124,-0.66619204,-0.45578936,1.6832152,-0.60422271,-0.66619204,-0.4547163,1.7001984,-0.6042124,-0.66619204,-0.4547163,1.7006111,-0.6042124,-0.66619204,-0.4547163,1.6979801,-0.6042124,-0.66619204,-0.45365355,1.7088861,-0.60420208,-0.66619204,-0.45365355,1.7104647,-0.60420208,-0.6651293,-0.4547163,1.700477,-0.6042124,-0.6651293,-0.45578936,1.6928005,-0.6042124,-0.66619204,-0.4547163,1.7000333,-0.6042124,-0.66619204,-0.4547163,1.7030874,-0.6042124,-0.66619204,-0.45578936,1.695607,-0.6042124,-0.66619204,-0.4547163,1.7063685,-0.6042124,-0.66619204,-0.45365355,1.7108259,-0.6042124,-0.66619204,-0.45578936,1.693791,-0.6042124,-0.66619204,-0.4547163,1.6986404,-0.6042124,-0.66619204,-0.4547163,1.6998786,-0.6042124,-0.6651293,-0.45578936,1.6926148,-0.60422271,-0.6651293,-0.45578936,1.692037,-0.60422271,-0.6651293,-0.45578936,1.6978769,-0.60422271,-0.66619204,-0.4547163,1.7100727,-0.6042124,-0.6651293,-0.45578936,1.6901591,-0.60422271,-0.6651293,-0.45578936,1.6937291,-0.60422271,-0.6651293,-0.45365355,1.7105782,-0.6042124,-0.6651293,-0.45578936,1.6950498,-0.60422271,-0.6651293,-0.4568521,1.6920989,-0.60422271,-0.6651293,-0.45578936,1.6989293,-0.60422271,-0.6651293,-0.4547163,1.6997754,-0.60422271,-0.6651293,-0.45578936,1.6910258,-0.60422271,-0.6651293,-0.45578936,1.6945752,-0.60422271,-0.6651293,-0.45578936,1.6995278,-0.60422271,-0.6651293,-0.45578936,1.6972475,-0.60422271,-0.6651293,-0.4568521,1.6845462,-0.60422271,-0.6651293,-0.45578936,1.695607,-0.60422271,-0.6651293,-0.4547163,1.7045423,-0.60422271,-0.6651293,-0.45578936,1.6936362,-0.60422271,-0.6651293,-0.45578936,1.7032422,-0.60422271,-0.6651293,-0.4547163,1.7091853,-0.60422271,-0.6651293,-0.4547163,1.7061312,-0.60422271,-0.6651293,-0.45578936,1.7017358,-0.60422271,-0.6651293,-0.45578936,1.698465,-0.60422271,-0.6651293,-0.45365355,1.7145609,-0.6042124,-0.6651293,-0.45578936,1.6991769,-0.60422271,-0.6651293,-0.45578936,1.7012302,-0.60422271,-0.6651293,-0.4547163,1.7151181,-0.60422271,-0.6651293,-0.4547163,1.7101346,-0.60422271,-0.6651293,-0.45578936,1.7022826,-0.60422271,-0.6651293,-0.45578936,1.7010445,-0.60422271,-0.6651293,-0.4547163,1.7125283,-0.60422271,-0.66405624,-0.45578936,1.6987333,-0.60422271,-0.6651293,-0.45578936,1.6974745,-0.60422271,-0.6651293,-0.4547163,1.7155411,-0.60422271,-0.6651293,-0.45578936,1.7066781,-0.60422271,-0.6651293,-0.45578936,1.7016223,-0.60422271,-0.6651293,-0.45578936,1.7036549,-0.60422271,-0.6651293,-0.45365355,1.7259622,-0.6042124,-0.6651293,-0.45578936,1.7077821,-0.60422271,-0.6651293,-0.4547163,1.7119918,-0.6042124,-0.6651293,-0.45365355,1.7299656,-0.6042124,-0.6651293,-0.45365355,1.7283353,-0.6042124,-0.6651293,-0.4547163,1.7186778,-0.6042124,-0.6651293,-0.4547163,1.7172436,-0.60422271,-0.6651293,-0.45258049,1.7348666,-0.6042124,-0.6651293,-0.4547163,1.7170991,-0.6042124,-0.6651293,-0.4547163,1.7175944,-0.6042124,-0.6651293,-0.45365355,1.7288822,-0.6042124,-0.6651293,-0.45365355,1.7265607,-0.6042124,-0.6651293,-0.4547163,1.7170888,-0.6042124,-0.6651293,-0.4547163,1.7173365,-0.6042124,-0.6651293,-0.45258049,1.7354134,-0.6042124,-0.66405624,-0.4547163,1.7171817,-0.60422271,-0.6651293,-0.4547163,1.7170579,-0.60422271,-0.6651293,-0.45258049,1.745752,-0.6042124,-0.6651293,-0.45258049,1.7405517,-0.6042124,-0.6651293,-0.4547163,1.7260551,-0.6042124,-0.6651293,-0.4547163,1.7294806,-0.6042124,-0.6651293,-0.45151775,1.7489608,-0.6042124,-0.6651293,-0.45258049,1.735888,-0.6042124,-0.6651293,-0.45365355,1.7288409,-0.6042124,-0.6651293,-0.45258049,1.7486926,-0.6042124,-0.66619204,-0.45258049,1.7496212,-0.6042124,-0.6651293,-0.45365355,1.7271075,-0.6042124,-0.6651293,-0.45365355,1.7323696,-0.6042124,-0.6651293,-0.45258049,1.7452154,-0.6042124,-0.6651293,-0.45365355,1.7397263,-0.6042124,-0.6651293,-0.45258049,1.7397263,-0.6042124,-0.66619204,-0.45151775,1.748641,-0.6042124,-0.6651293,-0.45151775,1.7522007,-0.6042124,-0.6651293,-0.45258049,1.7367548,-0.6042124,-0.6651293,-0.45365355,1.7283044,-0.6042124,-0.6651293,-0.45151775,1.7521078,-0.6042124,-0.6651293,-0.45365355,1.7322355,-0.6042124,-0.6651293,-0.45365355,1.7378484,-0.6042124,-0.66619204,-0.45151775,1.7534698,-0.6042124,-0.6651293,-0.45151775,1.747083,-0.6042124,-0.6651293,-0.45258049,1.7398811,-0.6042124,-0.6651293,-0.45365355,1.7326792,-0.6042124,-0.6651293,-0.45258049,1.7441836,-0.60420208,-0.66405624,-0.4547163,1.7190389,-0.60422271,-0.66405624,-0.45578936,1.7146435,-0.6042124,-0.6651293,-0.4547163,1.727871,-0.60420208,-0.6651293,-0.45365355,1.7322355,-0.6042124,-0.6651293,-0.45365355,1.7271385,-0.6042124,-0.6651293,-0.45365355,1.7324212,-0.6042124,-0.6651293,-0.45365355,1.7421613,-0.6042124,-0.6651293,-0.4547163,1.7272726,-0.6042124,-0.6651293,-0.45365355,1.7319569,-0.6042124,-0.6651293,-0.45365355,1.7402319,-0.6042124,-0.6651293,-0.45365355,1.7382302,-0.6042124,-0.6651293,-0.4547163,1.7289028,-0.6042124,-0.6651293,-0.4547163,1.729006,-0.6042124,-0.6651293,-0.45258049,1.7440186,-0.6042124,-0.6651293,-0.4547163,1.720958,-0.60422271,-0.6651293,-0.4547163,1.7199263,-0.60422271,-0.6651293,-0.45365355,1.7393136,-0.6042124,-0.6651293,-0.4547163,1.7292433,-0.60422271,-0.6651293,-0.45578936,1.7237851,-0.60422271,-0.6651293,-0.45365355,1.739716,-0.6042124,-0.66619204,-0.45258049,1.7471965,-0.6042124,-0.6651293,-0.45365355,1.7406549,-0.6042124,-0.6651293,-0.4547163,1.7305227,-0.6042124,-0.6651293,-0.45258049,1.7478775,-0.6042124,-0.6651293,-0.45365355,1.7361047,-0.6042124,-0.6651293,-0.4547163,1.7335356,-0.60422271,-0.6651293,-0.45365355,1.7453083,-0.6042124,-0.6651293,-0.45258049,1.7479187,-0.6042124,-0.6651293,-0.45365355,1.7336594,-0.6042124,-0.6651293,-0.4547163,1.737281,-0.60422271,-0.6651293,-0.4547163,1.7315752,-0.6042124,-0.6651293,-0.4547163,1.723197,-0.6042124,-0.6651293,-0.45578936,1.7188119,-0.60422271,-0.6651293,-0.45365355,1.7319466,-0.6042124,-0.6651293,-0.45365355,1.744421,-0.6042124,-0.6651293,-0.4547163,1.7260654,-0.6042124,-0.6651293,-0.4547163,1.726086,-0.6042124,-0.66619204,-0.45365355,1.7448956,-0.6042124,-0.6651293,-0.4547163,1.7289338,-0.6042124,-0.6651293,-0.4547163,1.7205866,-0.6042124,-0.6651293,-0.45365355,1.7337729,-0.60422271,-0.6651293,-0.45365355,1.7390144,-0.6042124,-0.66619204,-0.45365355,1.7407065,-0.6042124,-0.6651293,-0.4547163,1.7248995,-0.6042124,-0.66619204,-0.45365355,1.7441424,-0.6042124,-0.6651293,-0.45365355,1.7389112,-0.6042124,-0.6651293,-0.45578936,1.7238986,-0.60422271,-0.6651293,-0.4547163,1.7337832,-0.6042124,-0.66619204,-0.45365355,1.7455147,-0.6042124,-0.6651293,-0.45365355,1.7407375,-0.6042124,-0.66619204,-0.4547163,1.7348356,-0.6042124,-0.66619204,-0.45365355,1.7424709,-0.6042124,-0.6651293,-0.45365355,1.7374873,-0.6042124,-0.6651293,-0.4547163,1.7283353,-0.6042124,-0.66619204,-0.4547163,1.7306878,-0.6042124,-0.66619204,-0.45258049,1.7463194,-0.6042124,-0.6651293,-0.45365355,1.7371262,-0.6042124,-0.6651293,-0.4547163,1.7341443,-0.6042124,-0.6651293,-0.45365355,1.7391485,-0.6042124,-0.66619204,-0.45365355,1.7366928,-0.6042124,-0.6651293,-0.4547163,1.7333395,-0.6042124,-0.66619204,-0.45365355,1.7364349,-0.6042124,-0.6651293,-0.45365355,1.7440082,-0.6042124,-0.6651293,-0.4547163,1.7324315,-0.6042124,-0.6651293,-0.4547163,1.7278401,-0.6042124,-0.6651293,-0.45365355,1.7389628,-0.60420208,-0.66619204,-0.45365355,1.7458551,-0.60420208,-0.6651293,-0.4547163,1.7358468,-0.6042124,-0.6651293,-0.45365355,1.7431519,-0.6042124,-0.66619204,-0.45365355,1.7463091,-0.60420208,-0.66619204,-0.45365355,1.7442662,-0.6042124,-0.6651293,-0.4547163,1.7334737,-0.6042124,-0.66619204,-0.45365355,1.7431106,-0.60420208,-0.66619204,-0.45258049,1.7474647,-0.6042124,-0.6651293,-0.4547163,1.7364968,-0.6042124,-0.66619204,-0.45258049,1.7456075,-0.60420208,-0.6651293,-0.45258049,1.7500339,-0.6042124,-0.6651293,-0.45365355,1.7436058,-0.60420208,-0.6651293,-0.4547163,1.7315752,-0.6042124,-0.66619204,-0.45365355,1.7440186,-0.6042124,-0.66619204,-0.45365355,1.7414391,-0.60420208,-0.6651293,-0.4547163,1.7333086,-0.6042124,-0.66619204,-0.45365355,1.7430384,-0.6042124,-0.66619204,-0.45258049,1.7516435,-0.60420208,-0.6651293,-0.45258049,1.7473409,-0.6042124,-0.6651293,-0.4547163,1.7361357,-0.6042124,-0.6651293,-0.45365355,1.7406033,-0.6042124,-0.6651293,-0.45365355,1.7450916,-0.6042124,-0.66619204,-0.45365355,1.7370849,-0.6042124,-0.6651293,-0.45365355,1.743513,-0.6042124,-0.6651293,-0.45258049,1.7517673,-0.60420208,-0.6651293,-0.45365355,1.7476401,-0.6042124,-0.6651293,-0.4547163,1.7376215,-0.6042124,-0.6651293,-0.45258049,1.7518395,-0.60420208,-0.6651293,-0.45365355,1.7412224,-0.60420208,-0.6651293,-0.45365355,1.7376627,-0.6042124,-0.66619204,-0.45258049,1.7504466,-0.60420208,-0.66619204,-0.45258049,1.7539134,-0.60420208,-0.6651293,-0.45258049,1.7492085,-0.60420208,-0.6651293,-0.45578936,1.7136633,-0.6042124,-0.6651293,-0.45578936,1.7218763,-0.6042124,-0.6651293,-0.4547163,1.7284282,-0.6042124,-0.66405624,-0.4568521,1.7064098,-0.60422271,-0.6651293,-0.4547163,1.7193897,-0.6042124,-0.6651293,-0.4547163,1.727706,-0.6042124,-0.6651293,-0.45578936,1.7194516,-0.6042124,-0.6651293,-0.45578936,1.7203286,-0.6042124,-0.6651293,-0.4547163,1.7253432,-0.6042124,-0.6651293,-0.4547163,1.723651,-0.6042124,-0.6651293,-0.4547163,1.7248582,-0.6042124,-0.6651293,-0.45578936,1.7224954,-0.6042124,-0.6651293,-0.4547163,1.7234962,-0.6042124,-0.6651293,-0.4547163,1.7263749,-0.6042124,-0.6651293,-0.45578936,1.7174396,-0.6042124,-0.6651293,-0.4547163,1.7289751,-0.6042124,-0.6651293,-0.4547163,1.7289751,-0.6042124,-0.6651293,-0.4547163,1.7289751,-0.6042124,-0.6651293,-0.4547163,1.7289751,-0.6042124,-0.6651293,-0.4547163,1.7289751,-0.6042124,-0.6651293,-0.4547163,1.7289751,-0.6042124,-0.6651293,-0.4547163,1.7289751,-0.6042124,-0.6651293,-0.4547163,1.7289751,-0.6042124:5
-0.97278982,1.2319299,0.77679074,-1.0024617,-0.97278982,1.2287108,0.77508788,-1.0024694,-0.97278982,1.2238821,0.77266188,-1.0024772,-0.97278982,1.2295194,0.77575658,-1.0024617,-0.97278982,1.2254917,0.77354053,-1.0024694,-0.97278982,1.2214717,0.77163549,-1.0024772,-0.97198115,1.2246908,0.77316729,-1.0024694,-0.97278982,1.2254917,0.77349387,-1.0024694,-0.97278982,1.2214717,0.77163549,-1.0024772,-0.97278982,1.2230812,0.77246749,-1.0024772,-0.97278982,1.2230812,0.77253747,-1.0024772,-0.97278982,1.2174439,0.7696216,-1.002485,-0.97278982,1.2190534,0.770197,-1.002485,-0.97278982,1.2190534,0.77043027,-1.0024772,-0.97278982,1.2190534,0.77015035,-1.002485,-0.97278982,1.2166352,0.76897623,-1.002485,-0.97278982,1.2150257,0.76842416,-1.002485,-0.97278982,1.2246908,0.77318285,-1.0024694,-0.97198115,1.2222725,0.77181433,-1.0024772,-0.97278982,1.2158343,0.76864965,-1.002485,-0.97278982,1.220663,0.77102899,-1.0024772,-0.97278982,1.220663,0.7711223,-1.0024772,-0.97278982,1.220663,0.77119228,-1.0024772,-0.97278982,1.2166352,0.76903066,-1.002485,-0.97278982,1.2254917,0.77344722,-1.0024694,-0.97198115,1.2214717,0.77158884,-1.0024772,-0.97198115,1.2150257,0.76798094,-1.002485,-0.97278982,1.2254917,0.77369604,-1.0024694,-0.97278982,1.2222725,0.7720165,-1.0024772,-0.97278982,1.2263003,0.77378157,-1.0024694,-0.97278982,1.2198621,0.77039917,-1.0024772,-0.97278982,1.2279099,0.77455136,-1.0024694,-0.97278982,1.2230812,0.77245194,-1.0024772,-0.97198115,1.2182525,0.76973824,-1.002485,-0.97278982,1.2279099,0.77455913,-1.0024694,-0.97278982,1.2214717,0.77133224,-1.0024772,-0.97278982,1.2182525,0.77001039,-1.002485,-0.97278982,1.2142248,0.76776323,-1.002485,-0.97278982,1.2190534,0.77049248,-1.0024772,-0.97278982,1.2166352,0.76882849,-1.002485,-0.97278982,1.2093961,0.76533723,-1.0024928,-0.97278982,1.2182525,0.77003371,-1.002485,-0.97278982,1.2142248,0.76768547,-1.0024928,-0.97278982,1.2142248,0.76784876,-1.002485,-0.97278982,1.2142248,0.76752218,-1.002485,-0.97278982,1.210197,0.76571823,-1.0024928,-0.97278982,1.2142248,0.76783321,-1.002485,-0.97278982,1.2134161,0.76719561,-1.0024928,-0.97278982,1.2110056,0.76594373,-1.0024928,-0.97278982,1.2053683,0.76289568,-1.0025005,-0.97278982,1.2005396,0.76050856,-1.0025083,-0.97278982,1.2069779,0.764132,-1.0025005,-0.97278982,1.210197,0.76573379,-1.0024928,-0.97278982,1.2069779,0.76402315,-1.0025005,-0.97278982,1.2037588,0.76216477,-1.0025083,-0.97278982,1.2077865,0.76462965,-1.0025005,-0.97278982,1.2021492,0.76130945,-1.0025083,-0.97278982,1.2085874,0.76477738,-1.0025005,-0.97198115,1.2053683,0.76299676,-1.0025005,-0.97278982,1.2085874,0.76476961,-1.0025005,-0.97198115,1.2093961,0.7652517,-1.0024928,-0.97278982,1.210197,0.76540721,-1.0024928,-0.97278982,1.2134161,0.76732779,-1.0024928,-0.97278982,1.2126152,0.7668146,-1.0024928,-0.97278982,1.2150257,0.76825309,-1.002485,-0.97278982,1.2037588,0.76244469,-1.0025005,-0.97278982,1.2150257,0.76822977,-1.002485,-0.97278982,1.1941014,0.75741385,-1.0025161,-0.97278982,1.2029579,0.76207924,-1.0025083,-0.97278982,1.2029579,0.76197815,-1.0025083,-0.97278982,1.2005396,0.76095177,-1.0025083,-0.97278982,1.206177,0.76347885,-1.0025005,-0.97278982,1.2093961,0.76538388,-1.0024928,-0.97278982,1.2126152,0.76671352,-1.0024928,-0.97278982,1.2077865,0.76443525,-1.0025005,-0.97278982,1.2158343,0.76864187,-1.002485,-0.97278982,1.2077865,0.76443525,-1.0025005,-0.97278982,1.2069779,0.76389874,-1.0025005,-0.97278982,1.1989301,0.75987096,-1.0025161,-0.97278982,1.1981292,0.75942774,-1.0025161,-0.97278982,1.2021492,0.76172933,-1.0025083,-0.97278982,1.1997387,0.76027529,-1.0025083,-0.97278982,1.2029579,0.76211811,-1.0025083,-0.97198115,1.2029579,0.76203258,-1.0025083,-0.97278982,1.2037588,0.76238249,-1.0025083,-0.97278982,1.1989301,0.75975432,-1.0025161,-0.97278982,1.2093961,0.76518949,-1.0025005,-0.97278982,1.2142248,0.76776323,-1.002485,-0.97278982,1.2085874,0.76481626,-1.0025005,-0.97278982,1.210197,0.7655705,-1.0024928,-0.97278982,1.2085874,0.76503398,-1.0025005,-0.97278982,1.2077865,0.76428752,-1.0025005,-0.97278982,1.2021492,0.76176821,-1.0025083,-0.97198115,1.2021492,0.76139498,-1.0025083,-0.97278982,1.2077865,0.76443525,-1.0025005,-0.97278982,1.2021492,0.7615816,-1.0025083,-0.97278982,1.2037588,0.7622192,-1.0025083,-0.97278982,1.2029579,0.76206368,-1.0025083,-0.97278982,1.2029579,0.76195483,-1.0025083,-0.97278982,1.2037588,0.762538,-1.0025083,-0.97278982,1.2045674,0.76305897,-1.0025005,-0.97278982,1.195711,0.75852577,-1.0025161,-0.97278982,1.195711,0.75840136,-1.0025161,-0.97278982,1.1989301,0.75994871,-1.0025161,-0.97278982,1.1981292,0.75946662,-1.0025161,-0.97278982,1.1989301,0.75991761,-1.0025161,-0.97278982,1.195711,0.75818364,-1.0025161,-0.97278982,1.2013483,0.76091289,-1.0025083,-0.97278982,1.1965119,0.75870461,-1.0025161,-0.97278982,1.195711,0.75843246,-1.0025161,-0.97278982,1.1973205,0.75900786,-1.0025161,-0.97278982,1.1973205,0.75907784,-1.0025161,-0.97198115,1.2021492,0.76141831,-1.0025083,-0.97278982,1.1965119,0.75886012,-1.0025161,-0.97278982,1.206177,0.76353328,-1.0025005,-0.97198115,1.2045674,0.762919,-1.0025005,-0.97198115,1.2085874,0.76483959,-1.0025005,-0.97278982,1.2053683,0.76331556,-1.0025005,-0.97278982,1.1997387,0.76060964,-1.0025083,-0.97278982,1.210197,0.76588152,-1.0024928,-0.97278982,1.2021492,0.76171378,-1.0025083,-0.97278982,1.2085874,0.76471518,-1.0025005,-0.97278982,1.2029579,0.76183042,-1.0025083,-0.97278982,1.2077865,0.7644197,-1.0025005,-0.97278982,1.2029579,0.76215699,-1.0025083,-0.97278982,1.2045674,0.76276349,-1.0025005,-0.97198115,1.2118065,0.76663576,-1.0024928,-0.97198115,1.2069779,0.76419421,-1.0025005,-0.97278982,1.2158343,0.7683464,-1.002485,-0.97278982,1.2045674,0.76284125,-1.0025005,-0.97198115,1.2093961,0.76548497,-1.0024928,-0.97278982,1.2045674,0.76295788,-1.0025005,-0.97278982,1.2085874,0.76473073,-1.0025005,-0.97198115,1.2077865,0.76426419,-1.0025005,-0.97278982,1.2053683,0.76324558,-1.0025005,-0.97198115,1.2150257,0.76813646,-1.002485,-0.97278982,1.2037588,0.76264686,-1.0025083,-0.97278982,1.2069779,0.76415533,-1.0025005,-0.97278982,1.206177,0.76353328,-1.0025005,-0.97278982,1.2093961,0.76544609,-1.0024928,-0.97278982,1.1973205,0.7589301,-1.0025161,-0.97278982,1.2013483,0.76104508,-1.0025083,-0.97278982,1.2085874,0.76517394,-1.0025005,-0.97198115,1.2005396,0.76086624,-1.0025083,-0.97278982,1.206177,0.76353328,-1.0025005,-0.97278982,1.1981292,0.75952105,-1.0025161,-0.97278982,1.2037588,0.76229695,-1.0025083,-0.97278982,1.2085874,0.76482404,-1.0025005,-0.97198115,1.2134161,0.7674833,-1.0024928,-0.97278982,1.2134161,0.76729669,-1.0024928,-0.97278982,1.2077865,0.76441193,-1.0025005,-0.97278982,1.2126152,0.76700121,-1.0024928,-0.97278982,1.1965119,0.75886012,-1.0025161,-0.97278982,1.1844441,0.7522275,-1.0025394,-0.97278982,1.2013483,0.76095954,-1.0025083,-0.97278982,1.2085874,0.76462965,-1.0025005,-0.97278982,1.2222725,0.77176768,-1.0024772,-0.97278982,1.210197,0.76580377,-1.0024928,-0.97198115,1.2158343,0.76864187,-1.002485,-0.97278982,1.2166352,0.76910841,-1.002485,-0.97198115,1.2150257,0.76830752,-1.002485,-0.97278982,1.2166352,0.76904621,-1.002485,-0.97278982,1.2150257,0.76826864,-1.002485,-0.97278982,1.220663,0.77071797,-1.0024772,-0.97278982,1.2166352,0.76874296,-1.002485,-0.97278982,1.2021492,0.76165935,-1.0025083,-0.97278982,1.2142248,0.7674522,-1.002485,-0.97278982,1.2134161,0.7671645,-1.002485,-0.97278982,1.2134161,0.76730446,-1.002485,-0.97278982,1.2134161,0.76694678,-1.002485,-0.97278982,1.2182525,0.76938056,-1.002485,-0.97198115,1.2134161,0.76736667,-1.002485,-0.97278982,1.2126152,0.76669019,-1.0024928,-0.97278982,1.2126152,0.76689236,-1.0024928,-0.97278982,1.2158343,0.76816756,-1.002485,-0.97198115,1.2126152,0.76665909,-1.0024928,-0.97278982,1.2134161,0.76718005,-1.002485,-0.97278982,1.2174439,0.76931835,-1.002485,-0.97278982,1.2126152,0.76641804,-1.0024928,-0.97278982,1.2085874,0.76463742,-1.0024928,-0.97278982,1.2085874,0.76444303,-1.0024928,-0.97278982,1.206177,0.76348663,-1.0025005,-0.97278982,1.2069779,0.76385208,-1.0025005,-0.97278982,1.2085874,0.76455966,-1.0024928,-0.97278982,1.2085874,0.76450523,-1.0025005,-0.97278982,1.2085874,0.76433417,-1.0024928,-0.97278982,1.2093961,0.76490957,-1.0024928,-0.97278982,1.2093961,0.76488624,-1.0024928,-0.97278982,1.2077865,0.764132,-1.0025005,-0.97278982,1.2126152,0.76651135,-1.002485,-0.97198115,1.2093961,0.76494845,-1.0024928,-0.97278982,1.2118065,0.76618477,-1.0024928,-0.97198115,1.2126152,0.76653468,-1.0024928,-0.97278982,1.2118065,0.76604481,-1.0024928,-0.97198115,1.2118065,0.76618477,-1.0024928,-0.97278982,1.2134161,0.76725003,-1.002485,-0.97278982,1.2142248,0.76740555,-1.002485,-0.97278982,1.2134161,0.7671023,-1.002485,-0.97198115,1.2134161,0.76676017,-1.002485,-0.97278982,1.2118065,0.76625475,-1.0024928,-0.97198115,1.2126152,0.76677572,-1.002485,-0.97278982,1.2150257,0.76793429,-1.002485,-0.97278982,1.2142248,0.7674833,-1.002485,-0.97198115,1.2150257,0.76796539,-1.002485,-0.97278982,1.2134161,0.76706342,-1.002485,-0.97198115,1.2118065,0.76637139,-1.0024928,-0.97198115,1.2085874,0.76436527,-1.0024928,-0.97278982,1.2037588,0.76214922,-1.0025005,-0.97198115,1.2222725,0.77144888,-1.0024772,-0.97198115,1.2190534,0.77006482,-1.0024772,-0.97278982,1.2190534,0.76997151,-1.0024772,-0.97278982,1.2182525,0.76990153,-1.0024772,-0.97278982,1.2182525,0.76968381,-1.002485,-0.97278982,1.2190534,0.76987042,-1.0024772,-0.97198115,1.2190534,0.77007259,-1.0024772,-0.97198115,1.2214717,0.77130892,-1.0024772,-0.97278982,1.2174439,0.76915507,-1.002485,-0.97278982,1.2166352,0.76850191,-1.002485,-0.97278982,1.2158343,0.76822977,-1.002485,-0.97278982,1.2142248,0.7674211,-1.002485,-0.97278982,1.2142248,0.76736667,-1.002485,-0.97278982,1.2150257,0.76775545,-1.002485,-0.97278982,1.2190534,0.7699093,-1.0024772,-0.97198115,1.2166352,0.76857189,-1.002485,-0.97278982,1.2174439,0.76902288,-1.002485,-0.97198115,1.2190534,0.77000261,-1.0024772,-0.97278982,1.2190534,0.76990153,-1.0024772,-0.97198115,1.2190534,0.77011924,-1.0024772,-0.97278982,1.2174439,0.76904621,-1.002485,-0.97198115,1.2198621,0.77044582,-1.0024772,-0.97278982,1.2142248,0.7674211,-1.002485,-0.97198115,1.2142248,0.7674211,-1.002485,-0.97278982,1.2166352,0.76884404,-1.002485,-0.97198115,1.2182525,0.76964493,-1.0024772,-0.97278982,1.2174439,0.7693028,-1.002485,-0.97278982,1.2182525,0.76966048,-1.0024772,-0.97278982,1.2198621,0.77050803,-1.0024772,-0.97278982,1.2150257,0.76807425,-1.002485,-0.97278982,1.2150257,0.76771657,-1.002485,-0.97198115,1.2142248,0.76734334,-1.002485,-0.97198115,1.2118065,0.76637139,-1.0024928,-0.97278982,1.2126152,0.76641027,-1.0024928,-0.97278982,1.2142248,0.76749108,-1.002485,-0.97198115,1.2158343,0.76843193,-1.002485,-0.97198115,1.2150257,0.76768547,-1.002485,-0.97198115,1.206177,0.76339332,-1.0025005,-0.97198115,1.2053683,0.76298121,-1.0025005,-0.97198115,1.2085874,0.76438082,-1.0024928,-0.97278982,1.2085874,0.76453634,-1.0024928,-0.97278982,1.206177,0.76333889,-1.0025005,-0.97198115,1.2093961,0.76476961,-1.0024928,-0.97278982,1.1997387,0.76021308,-1.0025083,-0.97278982,1.2021492,0.76098287,-1.0025083,-0.97278982,1.2029579,0.76188485,-1.0025005,-0.97198115,1.2053683,0.76279459,-1.0025005,-0.97278982,1.2053683,0.7628257,-1.0025005,-0.97278982,1.2005396,0.76026751,-1.0025083,-0.97278982,1.2013483,0.76071072,-1.0025083,-0.97198115,1.1908823,0.75530666,-1.0025239,-0.97278982,1.1908823,0.75546217,-1.0025239,-0.97278982,1.1932927,0.7566985,-1.0025161,-0.97198115,1.1973205,0.75857242,-1.0025161,-0.97278982,1.195711,0.75801258,-1.0025161,-0.97278982,1.1924919,0.756473,-1.0025239,-0.97278982,1.1908823,0.75550882,-1.0025239,-0.97198115,1.1900736,0.75504228,-1.0025239,-0.97198115,1.1876632,0.75377486,-1.0025316,-0.97278982,1.1916832,0.75593648,-1.0025239,-0.97278982,1.1916832,0.75585095,-1.0025239,-0.97198115,1.1932927,0.75657409,-1.0025161,-0.97198115,1.195711,0.75811366,-1.0025161,-0.97278982,1.2029579,0.76176821,-1.0025005,-0.97198115,1.2021492,0.76113838,-1.0025083,-0.97198115,1.2037588,0.76189262,-1.0025005,-0.97198115,1.2053683,0.76264686,-1.0025005,-0.97278982,1.1916832,0.7558665,-1.0025239,-0.97278982,1.1941014,0.75686178,-1.0025161,-0.97198115,1.1916832,0.7558976,-1.0025239,-0.97198115,1.1868545,0.75325389,-1.0025316,-0.97278982,1.1941014,0.75721169,-1.0025161,-0.97278982,1.1949023,0.75761602,-1.0025161,-0.97278982,1.1997387,0.75967656,-1.0025083,-0.97198115,1.1941014,0.75735165,-1.0025161,-0.97198115,1.1941014,0.75714171,-1.0025161,-0.97198115,1.1965119,0.75840914,-1.0025161,-0.97198115,1.1981292,0.75936554,-1.0025083,-0.97198115,1.2093961,0.76480071,-1.0024928,-0.97198115,1.2093961,0.76495622,-1.0024928,-0.97278982,1.220663,0.77087348,-1.0024772,-0.97198115,1.2142248,0.76759994,-1.002485,-0.97278982,1.2158343,0.76825309,-1.002485,-0.97198115,1.2166352,0.76840083,-1.002485,-0.97198115,1.2093961,0.76505731,-1.0024928,-0.97198115,1.2126152,0.76660466,-1.0024928,-0.97198115,1.2118065,0.76602926,-1.0024928,-0.97198115,1.2077865,0.76410868,-1.0025005,-0.97198115,1.2134161,0.76679127,-1.002485,-0.97198115,1.2126152,0.76676017,-1.002485,-0.97278982,1.2150257,0.76763882,-1.002485,-0.97278982,1.2134161,0.76685348,-1.002485,-0.97198115,1.2126152,0.76660466,-1.002485,-0.97198115,1.2198621,0.77031364,-1.0024772,-0.97198115,1.2230812,0.7719854,-1.0024694,-0.97278982,1.2150257,0.76779433,-1.002485,-0.97198115,1.2085874,0.76455189,-1.0024928,-0.97198115,1.2069779,0.76389096,-1.0025005,-0.97198115,1.1941014,0.75704062,-1.0025161,-0.97198115,1.2110056,0.76571823,-1.0024928,-0.97198115,1.2110056,0.7659204,-1.0024928,-0.97198115,1.2166352,0.76855634,-1.002485,-0.97198115,1.2085874,0.76428752,-1.0024928,-0.97278982,1.2110056,0.76561715,-1.0024928,-0.97278982,1.2110056,0.76565603,-1.0024928,-0.97198115,1.2110056,0.76564825,-1.0024928,-0.97278982,1.2093961,0.76497955,-1.0024928,-0.97198115,1.206177,0.76330001,-1.0025005,-0.97198115,1.2110056,0.76590485,-1.0024928,-0.97278982,1.2093961,0.76469185,-1.0024928,-0.97198115,1.2069779,0.76367324,-1.0025005,-0.97198115,1.2110056,0.7656327,-1.0024928,-0.97198115,1.1981292,0.75916337,-1.0025083,-0.97198115,1.2110056,0.76578044,-1.0024928,-0.97198115,1.206177,0.76327668,-1.0025005,-0.97198115,1.2142248,0.76730446,-1.002485,-0.97198115,1.210197,0.76527502,-1.0024928,-0.97278982,1.2118065,0.76614589,-1.0024928,-0.97198115,1.2110056,0.76588152,-1.0024928,-0.97278982,1.185245,0.75284955,-1.0025316,-0.97198115,1.2085874,0.76422531,-1.0024928,-0.97198115,1.2085874,0.76451301,-1.0024928,-0.97198115,1.2118065,0.76594373,-1.0024928,-0.97198115,1.2077865,0.76392206,-1.0024928,-0.97198115,1.2093961,0.76497955,-1.0024928,-0.97198115,1.210197,0.76520504,-1.0024928,-0.97278982,1.2093961,0.76500288,-1.0024928,-0.97198115,1.2085874,0.76448968,-1.0024928,-0.97278982,1.2110056,0.76571823,-1.0024928,-0.97278982,1.2134161,0.76680682,-1.002485,-0.97278982,1.2085874,0.76452079,-1.0024928,-0.97198115,1.2093961,0.76500288,-1.0024928,-0.97278982,1.2110056,0.76578044,-1.0024928,-0.97278982,1.2093961,0.76474628,-1.0024928,-0.97198115,1.2126152,0.76667464,-1.002485,-0.97198115,1.2134161,0.76693123,-1.002485,-0.97198115,1.2142248,0.76725781,-1.002485,-0.97198115,1.2150257,0.76801205,-1.002485,-0.97198115,1.2150257,0.76796539,-1.002485,-0.97278982,1.2069779,0.76368102,-1.0025005,-0.97198115,1.2118065,0.7659515,-1.0024928,-0.97198115,1.2110056,0.76571046,-1.0024928,-0.97198115,1.2126152,0.76648025,-1.002485,-0.97198115,1.2110056,0.76556272,-1.0024928,-0.97278982,1.2110056,0.76553939,-1.0024928,-0.97278982,1.2093961,0.76487069,-1.0024928,-0.97278982,1.2134161,0.76699344,-1.002485,-0.97278982,1.2085874,0.7646452,-1.0024928,-0.97278982,1.2085874,0.7643575,-1.0024928,-0.97198115,1.2126152,0.76667464,-1.0024928,-0.97198115,1.2118065,0.76610702,-1.0024928,-0.97198115,1.2118065,0.76610702,-1.0024928,-0.97198115,1.2118065,0.76610702,-1.0024928,-0.97198115,1.2118065,0.76610702,-1.0024928,-0.97198115,1.2118065,0.76610702,-1.0024928,-0.97198115,1.2118065,0.76610702,-1.0024928,-0.97198115,1.2118065,0.76610702,-1.0024928:5
-0.59599968,-0.59599968,1.7502512,-0.59599968,-0.59599968,-0.59599968,1.7409647,-0.59599968,-0.59599968,-0.59599968,1.7421023,-0.59599968,-0.59599968,-0.59599968,1.7560112,-0.59599968,-0.59599968,-0.59599968,1.734398,-0.59599968,-0.59599968,-0.59599968,1.7314922,-0.59599968,-0.59599968,-0.59599968,1.738669,-0.59599968,-0.59599968,-0.59599968,1.7482656,-0.59599968,-0.59599968,-0.59599968,1.7436741,-0.59599968,-0.59599968,-0.59599968,1.7493722,-0.59599968,-0.59599968,-0.59599968,1.7501684,-0.59599968,-0.59599968,-0.59599968,1.7328572,-0.59599968,-0.59599968,-0.59599968,1.7268386,-0.59599968,-0.59599968,-0.59599968,1.7408923,-0.59599968,-0.59599968,-0.59599968,1.7472108,-0.59599968,-0.59599968,-0.59599968,1.7427227,-0.59599968,-0.59599968,-0.59599968,1.7501374,-0.59599968,-0.59599968,-0.59599968,1.7498996,-0.59599968,-0.64202852,-0.49002268,1.735701,-0.59525511,-0.64416916,-0.48680656,1.725577,-0.59523442,-0.64737494,-0.48252528,1.7359906,-0.59521374,-0.64952592,-0.47717886,1.7506234,-0.59519306,-0.65166655,-0.47503823,1.7424539,-0.59517238,-0.6527317,-0.47396274,1.7483587,-0.59516203,-0.65166655,-0.47503823,1.7454115,-0.59517238,-0.65059106,-0.47717886,1.7388655,-0.59518272,-0.64952592,-0.47824401,1.7251737,-0.59518272,-0.64952592,-0.4793195,1.731275,-0.59519306,-0.64952592,-0.4793195,1.73567,-0.59519306,-0.64845043,-0.4793195,1.7488344,-0.59519306,-0.64845043,-0.48038465,1.7456907,-0.5952034,-0.64845043,-0.48038465,1.7525573,-0.5952034,-0.64737494,-0.48146014,1.735639,-0.5952034,-0.64737494,-0.48252528,1.7205098,-0.59521374,-0.64737494,-0.48252528,1.7248531,-0.59521374,-0.64630979,-0.48252528,1.7268283,-0.59521374,-0.64630979,-0.48252528,1.7404477,-0.59521374,-0.64630979,-0.48252528,1.7366835,-0.59521374,-0.64630979,-0.48360077,1.7346359,-0.59521374,-0.64630979,-0.48360077,1.7433949,-0.59522408,-0.64630979,-0.48466592,1.7228262,-0.59522408,-0.64630979,-0.48466592,1.7270454,-0.59522408,-0.6452343,-0.48466592,1.7278107,-0.59522408,-0.6452343,-0.48466592,1.7339534,-0.59522408,-0.6452343,-0.48466592,1.7377383,-0.59522408,-0.6452343,-0.48466592,1.7324332,-0.59522408,-0.6452343,-0.48466592,1.7377796,-0.59522408,-0.6452343,-0.48574141,1.7303443,-0.59522408,-0.6452343,-0.48574141,1.7259389,-0.59522408,-0.6452343,-0.48466592,1.7349668,-0.59522408,-0.6452343,-0.48466592,1.7345325,-0.59522408,-0.6452343,-0.48574141,1.7324125,-0.59523442,-0.64416916,-0.48574141,1.7268696,-0.59523442,-0.64416916,-0.48574141,1.7336225,-0.59523442,-0.64416916,-0.48574141,1.7234156,-0.59523442,-0.6452343,-0.48574141,1.7289068,-0.59522408,-0.6452343,-0.48574141,1.7275211,-0.59522408,-0.6452343,-0.48466592,1.744367,-0.59522408,-0.6452343,-0.48574141,1.7341705,-0.59522408,-0.64416916,-0.48574141,1.7245946,-0.59523442,-0.64416916,-0.48466592,1.7381829,-0.59523442,-0.64416916,-0.48574141,1.7237466,-0.59523442,-0.64416916,-0.48574141,1.7395376,-0.59523442,-0.64416916,-0.48574141,1.7306649,-0.59523442,-0.64416916,-0.48574141,1.7399513,-0.59523442,-0.64416916,-0.48574141,1.7443567,-0.59523442,-0.64416916,-0.48574141,1.7271282,-0.59523442,-0.64416916,-0.48574141,1.7361871,-0.59523442,-0.64416916,-0.48574141,1.7392584,-0.59523442,-0.64416916,-0.48574141,1.7307269,-0.59523442,-0.64416916,-0.48574141,1.7327641,-0.59522408,-0.64416916,-0.48574141,1.7427021,-0.59522408,-0.64416916,-0.48574141,1.7320092,-0.59522408,-0.6452343,-0.48574141,1.7292274,-0.59523442,-0.64416916,-0.48680656,1.7284829,-0.59523442,-0.64416916,-0.48574141,1.7313577,-0.59523442,-0.64416916,-0.48680656,1.7212026,-0.59523442,-0.64416916,-0.48680656,1.718669,-0.59523442,-0.64416916,-0.48680656,1.7256804,-0.59523442,-0.64416916,-0.48680656,1.7334466,-0.59523442,-0.64416916,-0.48680656,1.7252357,-0.59523442,-0.64416916,-0.48680656,1.7354839,-0.59523442,-0.64416916,-0.48680656,1.729062,-0.59523442,-0.64416916,-0.48680656,1.7221954,-0.59523442,-0.64416916,-0.48680656,1.7205511,-0.59523442,-0.64416916,-0.48680656,1.7192171,-0.59523442,-0.64416916,-0.48680656,1.7368179,-0.59523442,-0.64416916,-0.48680656,1.7251323,-0.59523442,-0.64416916,-0.48680656,1.7344497,-0.59523442,-0.64416916,-0.48680656,1.732154,-0.59523442,-0.64416916,-0.48788204,1.7177383,-0.59523442,-0.64416916,-0.48788204,1.7202202,-0.59523442,-0.64416916,-0.48680656,1.7279244,-0.59523442,-0.64416916,-0.48680656,1.7419885,-0.59523442,-0.64416916,-0.48680656,1.7346876,-0.59523442,-0.64416916,-0.48680656,1.743064,-0.59523442,-0.64416916,-0.48680656,1.7449151,-0.59523442,-0.64416916,-0.48680656,1.7329089,-0.59523442,-0.64416916,-0.48788204,1.7232088,-0.59523442,-0.64416916,-0.48680656,1.7415542,-0.59523442,-0.64416916,-0.48680656,1.7471488,-0.59523442,-0.64416916,-0.48680656,1.7438913,-0.59523442,-0.64416916,-0.48574141,1.749641,-0.59523442,-0.64416916,-0.48680656,1.7521436,-0.59523442,-0.64416916,-0.48788204,1.7275728,-0.59523442,-0.64309367,-0.48894719,1.7060527,-0.59523442,-0.64416916,-0.48894719,1.7103236,-0.59523442,-0.64416916,-0.48788204,1.7175418,-0.59523442,-0.64416916,-0.48894719,1.7127952,-0.59523442,-0.64416916,-0.48788204,1.720789,-0.59523442,-0.64416916,-0.48788204,1.734367,-0.59523442,-0.64309367,-0.48788204,1.7293102,-0.59523442,-0.64309367,-0.48894719,1.709455,-0.59523442,-0.64416916,-0.48788204,1.7291964,-0.59523442,-0.64309367,-0.48788204,1.7207683,-0.59523442,-0.64416916,-0.48788204,1.723002,-0.59523442,-0.64309367,-0.48788204,1.7251426,-0.59523442,-0.64416916,-0.48680656,1.7398996,-0.59523442,-0.64309367,-0.48788204,1.7317817,-0.59523442,-0.64309367,-0.48788204,1.7210475,-0.59523442,-0.64309367,-0.48788204,1.7200961,-0.59523442,-0.64309367,-0.48788204,1.7314094,-0.59523442,-0.64309367,-0.48894719,1.7091447,-0.59523442,-0.64309367,-0.48788204,1.7145325,-0.59523442,-0.64416916,-0.48788204,1.7220816,-0.59523442,-0.64416916,-0.48680656,1.7364973,-0.59523442,-0.64309367,-0.48894719,1.7056184,-0.59523442,-0.64309367,-0.48788204,1.7263939,-0.59523442,-0.64309367,-0.48788204,1.7298065,-0.59523442,-0.64309367,-0.48788204,1.7167249,-0.59523442,-0.64309367,-0.48788204,1.7223608,-0.59523442,-0.64309367,-0.48788204,1.7209751,-0.59523442,-0.64309367,-0.48788204,1.7254529,-0.59523442,-0.64309367,-0.48894719,1.7035088,-0.59523442,-0.64309367,-0.48894719,1.7112647,-0.59523442,-0.64309367,-0.48788204,1.7235294,-0.59523442,-0.64309367,-0.48894719,1.7046463,-0.59523442,-0.64309367,-0.48894719,1.7130124,-0.59524476,-0.64309367,-0.48788204,1.7180072,-0.59524476,-0.64309367,-0.48894719,1.710396,-0.59524476,-0.64309367,-0.48894719,1.7141809,-0.59523442,-0.64309367,-0.48894719,1.7143567,-0.59523442,-0.64309367,-0.48788204,1.7161044,-0.59523442,-0.64309367,-0.48894719,1.7143257,-0.59523442,-0.64309367,-0.48788204,1.7162905,-0.59523442,-0.64309367,-0.48788204,1.7300547,-0.59523442,-0.64309367,-0.49002268,1.6872523,-0.59524476,-0.64309367,-0.49002268,1.685908,-0.59524476,-0.64309367,-0.48894719,1.7027332,-0.59523442,-0.64309367,-0.48894719,1.7033226,-0.59523442,-0.64309367,-0.48894719,1.7009131,-0.59523442,-0.64309367,-0.48894719,1.7109855,-0.59523442,-0.64309367,-0.48894719,1.7126194,-0.59523442,-0.64309367,-0.48894719,1.7010993,-0.59524476,-0.64309367,-0.48894719,1.6952875,-0.59523442,-0.64309367,-0.48894719,1.7045326,-0.59523442,-0.64309367,-0.48894719,1.705577,-0.59524476,-0.64309367,-0.49002268,1.6983071,-0.59523442,-0.64309367,-0.48894719,1.7092171,-0.59523442,-0.64309367,-0.48894719,1.7130848,-0.59523442,-0.64309367,-0.48894719,1.6962596,-0.59523442,-0.64309367,-0.48894719,1.7009545,-0.59523442,-0.64309367,-0.48894719,1.7074384,-0.59523442,-0.64309367,-0.48894719,1.6970558,-0.59523442,-0.64309367,-0.49002268,1.6931675,-0.59523442,-0.64309367,-0.48894719,1.7001168,-0.59524476,-0.64309367,-0.48788204,1.7136122,-0.59523442,-0.64309367,-0.49002268,1.6940465,-0.59524476,-0.64309367,-0.48894719,1.6964354,-0.59524476,-0.64309367,-0.48894719,1.714729,-0.59523442,-0.64309367,-0.48894719,1.6975832,-0.59523442,-0.64309367,-0.49002268,1.6948325,-0.59523442,-0.64309367,-0.48894719,1.7028159,-0.59523442,-0.64309367,-0.48894719,1.7022058,-0.59523442,-0.64309367,-0.49002268,1.6943361,-0.59524476,-0.64309367,-0.48894719,1.6971489,-0.59523442,-0.64309367,-0.48894719,1.7028366,-0.59523442,-0.64309367,-0.48894719,1.6968283,-0.59523442,-0.64309367,-0.49002268,1.6895274,-0.59523442,-0.64309367,-0.48894719,1.7004374,-0.59523442,-0.64309367,-0.48894719,1.7071282,-0.59523442,-0.64309367,-0.49002268,1.6965905,-0.59524476,-0.64309367,-0.48894719,1.7084622,-0.59523442,-0.64309367,-0.48894719,1.711606,-0.59523442,-0.64309367,-0.48788204,1.7184312,-0.59523442,-0.64309367,-0.48894719,1.7041499,-0.59524476,-0.64309367,-0.48894719,1.7032089,-0.59524476,-0.64309367,-0.48894719,1.7165801,-0.59524476,-0.64309367,-0.48894719,1.700789,-0.59524476,-0.64309367,-0.48894719,1.7077694,-0.59524476,-0.64309367,-0.48894719,1.7189379,-0.59524476,-0.64309367,-0.48894719,1.7141602,-0.59524476,-0.64309367,-0.48894719,1.7054219,-0.59524476,-0.64309367,-0.48894719,1.704729,-0.59524476,-0.64309367,-0.48788204,1.7142119,-0.59523442,-0.64309367,-0.48894719,1.7013681,-0.59524476,-0.64309367,-0.48894719,1.698576,-0.59524476,-0.64309367,-0.48894719,1.7181003,-0.59524476,-0.64309367,-0.48894719,1.7100858,-0.59524476,-0.64309367,-0.48894719,1.7026194,-0.59524476,-0.64309367,-0.48894719,1.7129607,-0.59523442,-0.64309367,-0.48788204,1.7283588,-0.59523442,-0.64309367,-0.48894719,1.7112544,-0.59523442,-0.64309367,-0.48894719,1.715153,-0.59523442,-0.64309367,-0.48788204,1.7314301,-0.59523442,-0.64309367,-0.48788204,1.7310578,-0.59523442,-0.64309367,-0.48788204,1.719548,-0.59523442,-0.64309367,-0.48788204,1.7197652,-0.59524476,-0.64309367,-0.48788204,1.7380278,-0.59523442,-0.64309367,-0.48894719,1.7196514,-0.59523442,-0.64309367,-0.48894719,1.719941,-0.59524476,-0.64309367,-0.48788204,1.7302926,-0.59523442,-0.64309367,-0.48894719,1.7203857,-0.59523442,-0.64309367,-0.48894719,1.7212854,-0.59524476,-0.64309367,-0.48894719,1.720427,-0.59523442,-0.64309367,-0.48788204,1.7388241,-0.59523442,-0.64309367,-0.48894719,1.7200961,-0.59524476,-0.64309367,-0.48894719,1.7196721,-0.59524476,-0.64309367,-0.48680656,1.7489585,-0.59523442,-0.64309367,-0.48788204,1.7319472,-0.59524476,-0.64309367,-0.48788204,1.7297859,-0.59524476,-0.64309367,-0.48788204,1.7313164,-0.59523442,-0.64309367,-0.48680656,1.7488965,-0.59523442,-0.64309367,-0.48788204,1.7371281,-0.59523442,-0.64309367,-0.48788204,1.7323608,-0.59524476,-0.64309367,-0.48680656,1.7513266,-0.59523442,-0.64309367,-0.48788204,1.7419678,-0.59524476,-0.64309367,-0.48788204,1.7312646,-0.59524476,-0.64309367,-0.48788204,1.736942,-0.59524476,-0.64309367,-0.48680656,1.7479761,-0.59524476,-0.64309367,-0.48788204,1.7422987,-0.59524476,-0.64309367,-0.48788204,1.7405614,-0.59524476,-0.64309367,-0.48680656,1.7504063,-0.59523442,-0.64309367,-0.48680656,1.748338,-0.59523442,-0.64309367,-0.48788204,1.7356493,-0.59524476,-0.64309367,-0.48788204,1.7375521,-0.59523442,-0.64309367,-0.48680656,1.7522884,-0.59523442,-0.64309367,-0.48788204,1.7372522,-0.59524476,-0.64309367,-0.48788204,1.741275,-0.59523442,-0.64309367,-0.48680656,1.7550909,-0.59523442,-0.64309367,-0.48680656,1.7430433,-0.59523442,-0.64309367,-0.48788204,1.7423711,-0.59524476,-0.64309367,-0.48788204,1.7427331,-0.59523442,-0.64309367,-0.48680656,1.7481726,-0.59523442,-0.64309367,-0.48894719,1.7172109,-0.59524476,-0.64309367,-0.48894719,1.718245,-0.59524476,-0.64309367,-0.48788204,1.7327848,-0.59523442,-0.64309367,-0.48894719,1.7272419,-0.59524476,-0.64309367,-0.48788204,1.7291861,-0.59523442,-0.64309367,-0.48788204,1.7429606,-0.59523442,-0.64309367,-0.48788204,1.7453598,-0.59523442,-0.64309367,-0.48788204,1.7310061,-0.59523442,-0.64309367,-0.48788204,1.7336638,-0.59523442,-0.64309367,-0.48680656,1.7458148,-0.59523442,-0.64309367,-0.48788204,1.7418748,-0.59523442,-0.64309367,-0.48788204,1.7307993,-0.59523442,-0.64309367,-0.48788204,1.7377796,-0.59523442,-0.64309367,-0.48680656,1.746611,-0.59523442,-0.64309367,-0.48894719,1.724698,-0.59523442,-0.64309367,-0.48788204,1.7264043,-0.59523442,-0.64309367,-0.48788204,1.7381933,-0.59523442,-0.64309367,-0.48788204,1.7325987,-0.59523442,-0.64309367,-0.48788204,1.7299617,-0.59523442,-0.64309367,-0.48788204,1.7445428,-0.59523442,-0.64416916,-0.48680656,1.7497031,-0.59523442,-0.64309367,-0.48788204,1.7422884,-0.59523442,-0.64309367,-0.48788204,1.7333019,-0.59523442,-0.64309367,-0.48680656,1.7503029,-0.59523442,-0.64309367,-0.48788204,1.736942,-0.59523442,-0.64309367,-0.48788204,1.7364249,-0.59523442,-0.64416916,-0.48680656,1.748338,-0.59523442,-0.64309367,-0.48680656,1.7506855,-0.59523442,-0.64309367,-0.48788204,1.7387724,-0.59523442,-0.64309367,-0.48788204,1.737004,-0.59524476,-0.64309367,-0.48788204,1.7359803,-0.59523442,-0.64309367,-0.48894719,1.7280072,-0.59523442,-0.64309367,-0.48894719,1.7234467,-0.59524476,-0.64309367,-0.48788204,1.7334673,-0.59524476,-0.64309367,-0.48788204,1.7451943,-0.59523442,-0.64309367,-0.48788204,1.7290206,-0.59523442,-0.64309367,-0.48788204,1.7286897,-0.59523442,-0.64309367,-0.48788204,1.7429813,-0.59523442,-0.64309367,-0.48788204,1.7290826,-0.59523442,-0.64309367,-0.48894719,1.7250496,-0.59523442,-0.64309367,-0.48788204,1.7363008,-0.59523442,-0.64416916,-0.48788204,1.7465283,-0.59523442,-0.64416916,-0.48788204,1.7312336,-0.59523442,-0.64416916,-0.48788204,1.7308303,-0.59523442,-0.64416916,-0.48680656,1.7469833,-0.59523442,-0.64309367,-0.48680656,1.7423608,-0.59523442,-0.64309367,-0.48788204,1.7276142,-0.59523442,-0.64416916,-0.48788204,1.7402925,-0.59523442,-0.64416916,-0.48680656,1.7480071,-0.59523442,-0.64309367,-0.48788204,1.7384518,-0.59523442,-0.64309367,-0.48788204,1.7363319,-0.59523442,-0.64416916,-0.48788204,1.746125,-0.59523442,-0.64309367,-0.48788204,1.7296618,-0.59523442,-0.64309367,-0.48788204,1.730913,-0.59523442,-0.64416916,-0.48680656,1.7403856,-0.59523442,-0.64416916,-0.48680656,1.7488344,-0.59523442,-0.64309367,-0.48788204,1.7376866,-0.59523442,-0.64416916,-0.48788204,1.7381623,-0.59523442,-0.64416916,-0.48680656,1.7481829,-0.59523442,-0.64309367,-0.48788204,1.7342636,-0.59523442,-0.64309367,-0.48788204,1.7354218,-0.59523442,-0.64309367,-0.48788204,1.7394963,-0.59523442,-0.64416916,-0.48680656,1.7466938,-0.59523442,-0.64309367,-0.48788204,1.7340671,-0.59523442,-0.64309367,-0.48788204,1.7286483,-0.59523442,-0.64416916,-0.48680656,1.7485655,-0.59523442,-0.64416916,-0.48680656,1.7479244,-0.59523442,-0.64309367,-0.48788204,1.7404787,-0.59523442,-0.64309367,-0.48788204,1.7439327,-0.59523442,-0.64309367,-0.48788204,1.7497755,-0.59523442,-0.64416916,-0.48680656,1.7468075,-0.59523442,-0.64309367,-0.48788204,1.7362801,-0.59523442,-0.64309367,-0.48788204,1.7476865,-0.59523442,-0.64309367,-0.48788204,1.7458355,-0.59523442,-0.64309367,-0.48788204,1.7401891,-0.59523442,-0.64309367,-0.48788204,1.7472212,-0.59523442,-0.64309367,-0.48680656,1.7515748,-0.59523442,-0.64309367,-0.48680656,1.7447703,-0.59523442,-0.64309367,-0.48788204,1.735246,-0.59523442,-0.64416916,-0.48680656,1.745215,-0.59523442,-0.64416916,-0.48680656,1.7441498,-0.59523442,-0.64309367,-0.48788204,1.7323195,-0.59523442,-0.64309367,-0.48680656,1.7488448,-0.59523442,-0.64416916,-0.48680656,1.7499823,-0.59523442,-0.64416916,-0.48680656,1.7502925,-0.59523442,-0.64416916,-0.48788204,1.7391136,-0.59523442,-0.64309367,-0.48788204,1.7425056,-0.59523442,-0.64309367,-0.48680656,1.7482139,-0.59523442,-0.64416916,-0.48788204,1.7398996,-0.59523442,-0.64416916,-0.48680656,1.7424435,-0.59523442,-0.64309367,-0.48680656,1.7498272,-0.59523442,-0.64309367,-0.48680656,1.7491446,-0.59523442,-0.64309367,-0.48788204,1.7436017,-0.59523442,-0.64416916,-0.48680656,1.7612749,-0.59523442,-0.64309367,-0.48788204,1.74355,-0.59523442,-0.64309367,-0.48788204,1.7398375,-0.59523442,-0.64416916,-0.48680656,1.7503649,-0.59523442,-0.64309367,-0.48680656,1.7488241,-0.59523442,-0.64416916,-0.48680656,1.7550702,-0.59523442,-0.64309367,-0.48894719,1.7182864,-0.59523442,-0.64309367,-0.48894719,1.7252771,-0.59524476,-0.64309367,-0.48788204,1.7297445,-0.59523442,-0.64309367,-0.48894719,1.7101478,-0.59523442,-0.64309367,-0.48894719,1.7221747,-0.59524476,-0.64309367,-0.48788204,1.7245842,-0.59523442,-0.64309367,-0.48894719,1.7187311,-0.59523442,-0.64309367,-0.48788204,1.7307166,-0.59523442,-0.64309367,-0.48788204,1.7238086,-0.59523442,-0.64309367,-0.48788204,1.7263939,-0.59523442,-0.64309367,-0.48788204,1.7269213,-0.59523442,-0.64309367,-0.48788204,1.7253081,-0.59523442,-0.64309367,-0.48788204,1.7269627,-0.59523442,-0.64309367,-0.48788204,1.726942,-0.59523442,-0.64416916,-0.48788204,1.7266421,-0.59523442,-0.64416916,-0.48788204,1.7315542,-0.59523442,-0.64416916,-0.48788204,1.7315542,-0.59523442,-0.64416916,-0.48788204,1.7315542,-0.59523442,-0.64416916,-0.48788204,1.7315542,-0.59523442,-0.64416916,-0.48788204,1.7315542,-0.59523442,-0.64416916,-0.48788204,1.7315542,-0.59523442,-0.64416916,-0.48788204,1.7315542,-0.59523442:5
-0.77938851,-0.22655322,1.7082521,-0.64624999,-0.7629704,-0.24808599,1.70839,-0.64635839,-0.77836361,-0.23988678,1.7081437,-0.64631898,-0.78758772,-0.22141886,1.7028812,-0.64622043,-0.76092059,-0.24091168,1.7081042,-0.64633868,-0.78041341,-0.22860302,1.7055814,-0.64625985,-0.76605495,-0.23681208,1.7045171,-0.64630912,-0.7629704,-0.24296148,1.7049507,-0.64633868,-0.77015455,-0.23681208,1.7063994,-0.64630912,-0.76912965,-0.24091168,1.7033739,-0.64631898,-0.78041341,-0.24296148,1.7048521,-0.64631898,-0.77015455,-0.24603618,1.7056602,-0.64633868,-0.76503005,-0.24706108,1.7050887,-0.64634854,-0.75887079,-0.25731994,1.7040933,-0.64639781,-0.77527906,-0.2634792,1.7040342,-0.64640767,-0.75682099,-0.26962861,1.701196,-0.64645694,-0.79067227,-0.061416119,1.7029502,-0.64557001,-0.77322926,-0.25731994,1.7021913,-0.64638796,-0.75477119,-0.25322034,1.7044087,-0.64638796,-0.74041273,-0.24911089,1.7034331,-0.64638796,-0.78553792,-0.13424319,1.7051576,-0.64587551,-0.77630396,-0.23988678,1.7060544,-0.64630912,-0.75169649,-0.25424524,1.7053547,-0.64639781,-0.78451302,-0.16705971,1.7066457,-0.64600362,-0.77630396,-0.24706108,1.705335,-0.64633868,-0.75169649,-0.25834485,1.7072863,-0.64641752,-0.77733871,-0.24603618,1.7071188,-0.64632883,-0.75066173,-0.25527014,1.7019647,-0.64639781,-0.75374629,-0.25219544,1.7039159,-0.64638796,-0.76605495,-0.25936975,1.7106763,-0.64640767,-0.77117945,-0.24911089,1.7085378,-0.64635839,-0.75066173,-0.25834485,1.7092474,-0.64641752,-0.77733871,-0.23065282,1.7110015,-0.64627956,-0.78758772,-0.11167566,1.7081929,-0.64578682,-0.75887079,-0.27065351,1.7128148,-0.6464668,-0.77630396,-0.25219544,1.7093065,-0.64636825,-0.77117945,-0.265529,1.709001,-0.64642738,-0.76092059,-0.25629504,1.7102821,-0.64639781,-0.7629704,-0.25731994,1.7103511,-0.64640767,-0.76092059,-0.2665539,1.7095135,-0.64644709,-0.75579609,-0.2624543,1.710903,-0.64643723,-0.75989569,-0.2645041,1.7089025,-0.64643723,-0.76503005,-0.2665539,1.7091686,-0.64643723,-0.76707985,-0.2645041,1.7107453,-0.64642738,-0.78041341,-0.26039465,1.7110311,-0.64639781,-0.75272139,-0.2645041,1.707375,-0.64644709,-0.78041341,-0.2665539,1.7044185,-0.64640767,-0.76912965,-0.27065351,1.7053646,-0.64644709,-0.75784589,-0.26860371,1.7072074,-0.64645694,-0.77836361,-0.265529,1.7075918,-0.64641752,-0.76810475,-0.27372821,1.7071188,-0.64645694,-0.75682099,-0.25322034,1.7036104,-0.64638796,-0.75784589,-0.26860371,1.7082816,-0.64645694,-0.75579609,-0.26962861,1.7069512,-0.64645694,-0.76400515,-0.26757881,1.7046058,-0.64643723,-0.76503005,-0.27475311,1.7048916,-0.6464668,-0.76605495,-0.2634792,1.7066063,-0.64641752,-0.75887079,-0.27578786,1.7060741,-0.64647665,-0.75477119,-0.26141955,1.7075819,-0.64642738,-0.74963683,-0.27167841,1.7087547,-0.64647665,-0.78451302,-0.27475311,1.7076805,-0.64644709,-0.79374698,-0.078849283,1.6990575,-0.64563899,-0.78964737,-0.077824382,1.7050985,-0.64563899,-0.78964737,-0.07269988,1.7038962,-0.64561928,-0.78758772,-0.092182845,1.7050788,-0.64569812,-0.78861262,-0.089108143,1.7042116,-0.64568827,-0.78451302,-0.13013373,1.7032754,-0.6458558,-0.79067227,-0.048082557,1.7033444,-0.64552074,-0.78964737,-0.074749681,1.7062909,-0.64562914,-0.78861262,-0.086033441,1.7038667,-0.64567841,-0.76503005,-0.2645041,1.7036991,-0.64642738,-0.77015455,-0.27578786,1.7053055,-0.64645694,-0.76605495,-0.25936975,1.704113,-0.64639781,-0.77015455,-0.27372821,1.705069,-0.64645694,-0.75066173,-0.27372821,1.7047437,-0.64647665,-0.76605495,-0.27578786,1.7052562,-0.6464668,-0.76194549,-0.27783767,1.7051379,-0.64647665,-0.77425416,-0.27372821,1.7065373,-0.64644709,-0.76503005,-0.28091237,1.7047043,-0.64648651,-0.76503005,-0.27270331,1.7052562,-0.64645694,-0.75682099,-0.27886257,1.7081535,-0.64649636,-0.75272139,-0.27988747,1.7038568,-0.64649636,-0.75887079,-0.27988747,1.7052168,-0.64649636,-0.75066173,-0.27681276,1.7057686,-0.64648651,-0.75887079,-0.27475311,1.7033739,-0.6464668,-0.75169649,-0.28296217,1.7047043,-0.64651607,-0.75887079,-0.27065351,1.706695,-0.64645694,-0.76605495,-0.27886257,1.6983972,-0.64647665,-0.76194549,-0.27681276,1.7042313,-0.64647665,-0.75784589,-0.27783767,1.7034232,-0.64648651,-0.75477119,-0.28398707,1.7022209,-0.64651607,-0.74963683,-0.27681276,1.7029305,-0.64648651,-0.7629704,-0.28603687,1.7009989,-0.64651607,-0.75784589,-0.26860371,1.7022308,-0.64644709,-0.76810475,-0.28296217,1.7019154,-0.64649636,-0.76092059,-0.28501197,1.7038864,-0.64650622,-0.74758703,-0.28603687,1.7023096,-0.64652593,-0.75169649,-0.28912143,1.7039258,-0.64653578,-0.75066173,-0.28706177,1.7056602,-0.64653578,-0.73836293,-0.28912143,1.7005949,-0.64655549,-0.75169649,-0.28398707,1.7022111,-0.64651607,-0.74451233,-0.28809653,1.7022012,-0.64654564,-0.73732817,-0.29117123,1.7054533,-0.64656535,-0.75066173,-0.28603687,1.707444,-0.64653578,-0.74963683,-0.29117123,1.7075031,-0.64655549,-0.75887079,-0.28706177,1.7068231,-0.64652593,-0.74861193,-0.29219613,1.7058869,-0.64655549,-0.74553723,-0.28398707,1.7049507,-0.64652593,-0.75887079,-0.28603687,1.7023983,-0.64652593,-0.75784589,-0.265529,1.7032064,-0.64642738,-0.74143763,-0.29014633,1.7039751,-0.64653578,-0.74758703,-0.30039533,1.70296,-0.64659491,-0.74861193,-