/*******************************************************************************
 * Copyright 2014 Adobe Systems Incorporated
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package io.sightly.tck;

/**
 * Defines the constants used throughout the TCK code.
 */
public final class Constants {

    /**
     * System property for retrieving the username used for HTTP Basic Auth when running the TCK.
     */
    public static final String SYS_PROP_USER = "io.sightly.tck.user";

    /**
     * System property for retrieving the password used for HTTP Basic Auth when running the TCK.
     */
    public static final String SYS_PROP_PASS = "io.sightly.tck.pass";

    /**
     * System property for retrieving the URL used for running the TCK.
     */
    public static final String SYS_PROP_SERVER_URL = "io.sightly.tck.serverURL";
}
