---
sidebarDepth: 0
---

# Community

We welcome issues, contributions and discussion from all users, regardless of background or experience level. In order to create a positive and welcoming environment, all interactions are governed by Prefect's [Code of Conduct](code_of_conduct.md).

Please consider [Chris White](https://github.com/cicdw) the main point of contact for the Prefect repo.

## Discussion

- We have a public [Slack](https://join.slack.com/t/prefect-community/shared_invite/enQtODQ3MTA2MjI4OTgyLTliYjEyYzljNTc2OThlMDE4YmViYzk3NDU4Y2EzMWZiODM0NmU3NjM0NjIyNWY0MGIxOGQzODMxNDMxYWYyOTE) for chatting about Prefect, asking questions, and sharing tips.
- For feature requests or bug reports, please open a [new GitHub issue](https://github.com/PrefectHQ/prefect/issues/new).
- Important architectural and design decisions are memorialized in [Prefect Improvement Notices (PINs)](../PINs/PIN-01-Introduce-PINs.html).

## Contributing

Prefect encourages users to contribute in any way they can!

There are a number of ways you can get started contributing:

- **closing issues**: the [issue board](https://github.com/PrefectHQ/prefect/issues) contains issues with the tag ["good first issue"](https://github.com/PrefectHQ/prefect/issues?q=is%3Aissue+is%3Aopen+label%3A%22good+first+issue%22) which should be approachable for first time contributors
- **documentation**: Prefect prioritizes its documentation, as this is usually the first place users go to look for help. If you find any typos, or want to update something for clarity, users everywhere will thank you!
- **the task library**: Prefect's task library helps users build workflows even quicker by abstracting away common boilerplate. If you know of a common operation that isn't represented, open a Pull Request to add a new task to the library!
- **joining us at sprints**: join Prefect at an upcoming in-person event and jumpstart your contributions. See more information at [Join Prefect at Sprints](../development/sprints.html).

See our [Development Guide](../development/overview.html) for more information on how to get started.

## The Prefect Cloud Platform

The "Prefect Core" engine is maintained by [Prefect Technologies, Inc.](https://www.prefect.io/) and is the driving engine of the Prefect Cloud Platform, which extends Prefect Core to include:

- a full GraphQL API
- a complete UI for flows and jobs
- remote execution clusters
- automatic and asynchronous scheduling
- permissions and authorization
- projects for flow organization
- secure runtime secrets and parameters
- many more features...

Please [get in touch](mailto:hello@prefect.io) to apply for access.
