---
title: Kubernetes
---

# Kubernetes

Tasks for interacting with various Kubernetes API objects.

Note that depending on how you choose to authenticate, tasks in this collection might require
a Prefect Secret called `"KUBERNETES_API_KEY"` that stores your Kubernetes API Key;
this Secret must be a string and in BearerToken format.

## Deployments

### CreateNamespacedDeployment <Badge text="task"/>

Task for creating a namespaced deployment on Kubernetes.

[API Reference](/api/latest/tasks/kubernetes.html#prefect-tasks-kubernetes-createnamespaceddeployment)

### DeleteNamespacedDeployment <Badge text="task"/>

Task for deleting a namespaced deployment on Kubernetes.

[API Reference](/api/latest/tasks/kubernetes.html#prefect-tasks-kubernetes-deletenamespaceddeployment)

### ListNamespacedDeployment <Badge text="task"/>

Task for listing a namespaced deployment on Kubernetes.

[API Reference](/api/latest/tasks/kubernetes.html#prefect-tasks-kubernetes-listnamespaceddeployment)

### PatchNamespacedDeployment <Badge text="task"/>

Task for patching a namespaced deployment on Kubernetes.

[API Reference](/api/latest/tasks/kubernetes.html#prefect-tasks-kubernetes-patchnamespaceddeployment)

### ReadNamespacedDeployment <Badge text="task"/>

Task for reading a namespaced deployment on Kubernetes.

[API Reference](/api/latest/tasks/kubernetes.html#prefect-tasks-kubernetes-readnamespaceddeployment)

### ReplaceNamespacedDeployment <Badge text="task"/>

Task for replacing a namespaced deployment on Kubernetes.

[API Reference](/api/latest/tasks/kubernetes.html#prefect-tasks-kubernetes-replacenamespaceddeployment)


## Jobs

### CreateNamespacedJob <Badge text="task"/>

Task for creating a namespaced job on Kubernetes.

[API Reference](/api/latest/tasks/kubernetes.html#prefect-tasks-kubernetes-createnamespacedjob)

### DeleteNamespacedJob <Badge text="task"/>

Task for deleting a namespaced job on Kubernetes.

[API Reference](/api/latest/tasks/kubernetes.html#prefect-tasks-kubernetes-deletenamespacedjob)

### ListNamespacedJob <Badge text="task"/>

Task for listing a namespaced job on Kubernetes.

[API Reference](/api/latest/tasks/kubernetes.html#prefect-tasks-kubernetes-listnamespacedjob)

### PatchNamespacedJob <Badge text="task"/>

Task for patching a namespaced job on Kubernetes.

[API Reference](/api/latest/tasks/kubernetes.html#prefect-tasks-kubernetes-patchnamespacedjob)

### ReadNamespacedJob <Badge text="task"/>

Task for reading a namespaced job on Kubernetes.

[API Reference](/api/latest/tasks/kubernetes.html#prefect-tasks-kubernetes-readnamespacedjob)

### ReplaceNamespacedJob <Badge text="task"/>

Task for replacing a namespaced job on Kubernetes.

[API Reference](/api/latest/tasks/kubernetes.html#prefect-tasks-kubernetes-replacenamespacedjob)


## Pods

### CreateNamespacedPod <Badge text="task"/>

Task for creating a namespaced pod on Kubernetes.

[API Reference](/api/latest/tasks/kubernetes.html#prefect-tasks-kubernetes-createnamespacedpod)

### DeleteNamespacedPod <Badge text="task"/>

Task for deleting a namespaced pod on Kubernetes.

[API Reference](/api/latest/tasks/kubernetes.html#prefect-tasks-kubernetes-deletenamespacedpod)

### ListNamespacedPod <Badge text="task"/>

Task for listing a namespaced pod on Kubernetes.

[API Reference](/api/latest/tasks/kubernetes.html#prefect-tasks-kubernetes-listnamespacedpod)

### PatchNamespacedPod <Badge text="task"/>

Task for patching a namespaced pod on Kubernetes.

[API Reference](/api/latest/tasks/kubernetes.html#prefect-tasks-kubernetes-patchnamespacedpod)

### ReadNamespacedPod <Badge text="task"/>

Task for reading a namespaced pod on Kubernetes.

[API Reference](/api/latest/tasks/kubernetes.html#prefect-tasks-kubernetes-readnamespacedpod)

### ReplaceNamespacedPod <Badge text="task"/>

Task for replacing a namespaced pod on Kubernetes.

[API Reference](/api/latest/tasks/kubernetes.html#prefect-tasks-kubernetes-replacenamespacedpod)


## Services

### CreateNamespacedService <Badge text="task"/>

Task for creating a namespaced service on Kubernetes.

[API Reference](/api/latest/tasks/kubernetes.html#prefect-tasks-kubernetes-createnamespacedservice)

### DeleteNamespacedService <Badge text="task"/>

Task for deleting a namespaced service on Kubernetes.

[API Reference](/api/latest/tasks/kubernetes.html#prefect-tasks-kubernetes-deletenamespacedservice)

### ListNamespacedService <Badge text="task"/>

Task for listing a namespaced service on Kubernetes.

[API Reference](/api/latest/tasks/kubernetes.html#prefect-tasks-kubernetes-listnamespacedservice)

### PatchNamespacedService <Badge text="task"/>

Task for patching a namespaced service on Kubernetes.

[API Reference](/api/latest/tasks/kubernetes.html#prefect-tasks-kubernetes-patchnamespacedservice)

### ReadNamespacedService <Badge text="task"/>

Task for reading a namespaced service on Kubernetes.

[API Reference](/api/latest/tasks/kubernetes.html#prefect-tasks-kubernetes-readnamespacedservice)

### ReplaceNamespacedService <Badge text="task"/>

Task for replacing a namespaced service on Kubernetes.

[API Reference](/api/latest/tasks/kubernetes.html#prefect-tasks-kubernetes-replacenamespacedservice)
