# Tokens

## Token Types

### `USER`

`USER`-scoped API tokens function as _personal access tokens_. These tokens have very few permissions on their own, but can be used to authenticate with the Cloud API. Once authenticated, `USER` tokens can be used to generate short-lived JWT auth tokens for any tenant the user belongs to. These auth tokens inherit any permissions the user has in that tenant, allowing full API access. The Client manages the process of provisioning and refreshing these tokens.

### `TENANT`

`TENANT`-scoped API tokens are used for long-lived programmatic access to a specific Cloud tenant. Unlike `USER` tokens, which can adopt any tenant membership the user has, `TENANT` tokens are fixed to a specific membership in a specific tenant. They adopt whatever permissions the user has in the tenant.

### `RUNNER`

`RUNNER`-scoped API tokens are used for processes like the Prefect Agent, which require the ability to execute flows on behalf of a tenant. Unlike the other token types, `RUNNER` tokens are not scoped to a particular user. Consequently, they can only be generated by tenant admins.

## Creating Tokens

### UI

To create a token in the UI navigate to Team Settings -> API Tokens.

![token screen](/token_screen.png)

Click on _Create A Token_. Give the token a name and assign its scope.

![token naming](/token_naming.png)

After you click create you will be prompted with the token which you can copy and store in a safe place. Then you should see the token added to your list of tokens.

![token_created](/token_created.png)

### CLI

To create a token with the CLI run the `create-token` command with the desired token name and role. For more information on how to use the CLI go [here](cli.html).

```
$ prefect auth create-token -n my-runner-token -r RUNNER
```

### GraphQL

To create a token using GraphQL execute the `createAPIToken` mutation against `https://api.prefect.io`. For more information on how to use the GraphQL API go [here](graphql.html).

```graphql
mutation {
  createAPIToken(input: {name: "my-runner-token", role: RUNNER}) {
    token
  }
}
```

## Revoking Tokens

### UI

To revoke a token in the UI navigate to Team Settings -> API Tokens. On your list of API tokens click the trash bin icon next to any token in order to delete it. A confirmation box should appear asking if you are sure you want to delete the token.

![token delete](/token_delete.png)

### CLI

To revoke a token with the CLI run the `revoke-token` command with the ID of the token you want to revoke. For information on how to find a token's ID look under [Querying for Token Information](tokens.html#querying-for-token-information).

```
$ prefect auth revoke-token -i $MY_TOKEN_ID
```

### GraphQL

To revoke a token using GraphQL execute the `deleteAPIToken` mutation against `https://api.prefect.io`. For information on how to find a token's ID look under [Querying for Token Information](tokens.html#querying-for-token-information).

```graphql
mutation {
  deleteAPIToken(input: {tokenId: "MY_TOKEN_ID"}) {
    success
  }
}
```

## Querying for Token Information

To query for information about a specific token GraphQL execute the following query against `https://api.prefect.io`. This will allow you to query for token information however it never returns the value of the token itself.

```graphql
query {
  api_token {
    id
    name
    scope
  }
}
```

## Use and Persistence of `RUNNER` Tokens

`RUNNER` tokens are generally used by Prefect Agents and flows to communicate with Prefect Cloud. A `RUNNER` token is provided to an agent at start and every time it deploys a flow to run it is given that token that it then uses to communicate state back to Prefect Cloud. This means that whenever a `RUNNER` token is revoked all agents and flows which are currently using it are unable to communicate with Prefect Cloud and will need to be started with a new token in order to resume their work.

There are a few ways in which you can give a `RUNNER` token to an agent. Each method has an extra level of persistence.

- Provide the token when the agent is started via the CLI. This method means the token will need to be provided each time the agent is started.

```
$ prefect agent start -t TOKEN_VALUE
```

- Specify the token as an environment variable. This method means the token will only be available to processes which have the variable set.

```bash
$ export PREFECT__CLOUD__AGENT__AUTH_TOKEN=TOKEN_VALUE
```

- Manually save your token in `$HOME/.prefect/config.toml`. This method ensures that the token will be available at all times if it is not overridden.

```toml
[cloud.agent]
auth_token = TOKEN_VALUE
```

For information on the use of your `USER` personal access tokens visit the [Prefect Cloud API](api.html) page.
