---
sidebarDepth: 2
editLink: false
---
# Storage
---
The Prefect Storage interface encapsulates logic for storing, serializing and even running Flows.  Each storage unit is able to store _multiple_ flows (possibly with the constraint of name uniqueness within a given unit), and exposes the following methods and attributes:

- a name attribute
- a `flows` attribute that is a dictionary of Flows -> location
- an `add_flow(flow: Flow) -> str` method for adding flows to Storage, and that will return the location of the given flow in the Storage unit
- the `__contains__(self, obj) -> bool` special method for determining whether the Storage contains a given Flow
- one of `get_flow(flow_location: str)` or `get_env_runner(flow_location: str)` for retrieving a way of interfacing with either `flow.run` or a `FlowRunner` for the flow; `get_env_runner` is intended for situations where flow execution can only be interacted with via environment variables
- a `build() -> Storage` method for "building" the storage
- a `serialize() -> dict` method for serializing the relevant information about this Storage for later re-use.
 ## Docker
 <div class='class-sig' id='prefect-environments-storage-docker-docker'><p class="prefect-sig">class </p><p class="prefect-class">prefect.environments.storage.docker.Docker</p>(registry_url=None, base_image=None, dockerfile=None, python_dependencies=None, image_name=None, image_tag=None, env_vars=None, files=None, base_url=None, prefect_version=None, local_image=False)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/docker.py#L23">[source]</a></span></div>

Docker storage provides a mechanism for storing Prefect flows in Docker images and optionally pushing them to a registry.

A user specifies a `registry_url`, `base_image` and other optional dependencies (e.g., `python_dependencies`) and `build()` will create a temporary Dockerfile that is used to build the image.

Note that the `base_image` must be capable of `pip` installing.  Note that registry behavior with respect to image names can differ between providers - for example, Google's GCR registry allows for registry URLs of the form `gcr.io/my-registry/subdir/my-image-name` whereas DockerHub requires the registry URL to be separate from the image name.

**Args**:     <ul class="args"><li class="args">`registry_url (str, optional)`: URL of a registry to push the image to; image will not be pushed if not provided     </li><li class="args">`base_image (str, optional)`: the base image for this environment (e.g. `python:3.6`), defaults to the `prefecthq/prefect` image         matching your python version and prefect core library version used at runtime.     </li><li class="args">`dockerfile (str, optional)`: a path to a Dockerfile to use in building this storage; note that, if provided,         your present working directory will be used as the build context     </li><li class="args">`python_dependencies (List[str], optional)`: list of pip installable dependencies for the image     </li><li class="args">`image_name (str, optional)`: name of the image to use when building, populated with a UUID after build     </li><li class="args">`image_tag (str, optional)`: tag of the image to use when building, populated with a UUID after build     </li><li class="args">`env_vars (dict, optional)`: a dictionary of environment variables to use when building     </li><li class="args">`files (dict, optional)`: a dictionary of files to copy into the image when building     </li><li class="args">`base_url`: (str, optional): a URL of a Docker daemon to use when for Docker related functionality     </li><li class="args">`prefect_version (str, optional)`: an optional branch, tag, or commit specifying the version of prefect         you want installed into the container; defaults to the version you are currently using or `"master"` if your version is ahead of         the latest tag     </li><li class="args">`local_image(bool, optional)`: an optional flag whether or not to use a local docker image, if True then a pull will not be attempted</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if both `base_image` and `dockerfile` are provided</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-environments-storage-docker-docker-add-flow'><p class="prefect-class">prefect.environments.storage.docker.Docker.add_flow</p>(flow)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/docker.py#L181">[source]</a></span></div>
<p class="methods">Method for adding a new flow to this Storage object.<br><br>**Args**:     <ul class="args"><li class="args">`flow (Flow)`: a Prefect Flow to add</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: the location of the newly added flow in this Storage object</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-docker-docker-build'><p class="prefect-class">prefect.environments.storage.docker.Docker.build</p>(push=True)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/docker.py#L237">[source]</a></span></div>
<p class="methods">Build the Docker storage object.  If image name and tag are not set, they will be autogenerated.<br><br>**Args**:     <ul class="args"><li class="args">`push (bool, optional)`: Whether or not to push the built Docker image, this         requires the `registry_url` to be set</li></ul>**Returns**:     <ul class="args"><li class="args">`Docker`: a new Docker storage object that contains information about how and         where the flow is stored. Image name and tag are generated during the         build process.</li></ul>**Raises**:     <ul class="args"><li class="args">`InterruptedError`: if either pushing or pulling the image fails</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-docker-docker-create-dockerfile-object'><p class="prefect-class">prefect.environments.storage.docker.Docker.create_dockerfile_object</p>(directory)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/docker.py#L337">[source]</a></span></div>
<p class="methods">Writes a dockerfile to the provided directory using the specified arguments on this Docker storage object.<br><br>In order for the docker python library to build a container it needs a Dockerfile that it can use to define the container. This function takes the specified arguments then writes them to a temporary file called Dockerfile.<br><br>*Note*: if `files` are added to this container, they will be copied to this directory as well.<br><br>**Args**:     <ul class="args"><li class="args">`directory (str, optional)`: A directory where the Dockerfile will be created,         if no directory is specified is will be created in the current working directory</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: the absolute file path to the Dockerfile</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-docker-docker-get-env-runner'><p class="prefect-class">prefect.environments.storage.docker.Docker.get_env_runner</p>(flow_location)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/docker.py#L141">[source]</a></span></div>
<p class="methods">Given a flow_location within this Storage object, returns something with a `run()` method which accepts the standard runner kwargs and can run the flow.<br><br>**Args**:     <ul class="args"><li class="args">`flow_location (str)`: the location of a flow within this Storage</li></ul>**Returns**:     <ul class="args"><li class="args">a runner interface (something with a `run()` method for running the flow)</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-docker-docker-get-flow'><p class="prefect-class">prefect.environments.storage.docker.Docker.get_flow</p>(flow_location)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/docker.py#L202">[source]</a></span></div>
<p class="methods">Given a file path within this Docker container, returns the underlying Flow. Note that this method should only be run _within_ the container itself.<br><br>**Args**:     <ul class="args"><li class="args">`flow_location (str)`: the file path of a flow within this container</li></ul>**Returns**:     <ul class="args"><li class="args">`Flow`: the requested flow</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-docker-docker-pull-image'><p class="prefect-class">prefect.environments.storage.docker.Docker.pull_image</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/docker.py#L463">[source]</a></span></div>
<p class="methods">Pull the image specified so it can be built.<br><br>In order for the docker python library to use a base image it must be pulled from either the main docker registry or a separate registry that must be set as `registry_url` on this class.<br><br>**Raises**:     <ul class="args"><li class="args">`InterruptedError`: if either pulling the image fails</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-docker-docker-push-image'><p class="prefect-class">prefect.environments.storage.docker.Docker.push_image</p>(image_name, image_tag)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/docker.py#L483">[source]</a></span></div>
<p class="methods">Push this environment to a registry<br><br>**Args**:     <ul class="args"><li class="args">`image_name (str)`: Name for the image     </li><li class="args">`image_tag (str)`: Tag for the image</li></ul>**Raises**:     <ul class="args"><li class="args">`InterruptedError`: if either pushing the image fails</li></ul></p>|

---
<br>

 ## Local
 <div class='class-sig' id='prefect-environments-storage-local-local'><p class="prefect-sig">class </p><p class="prefect-class">prefect.environments.storage.local.Local</p>(directory=None, validate=True)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/local.py#L15">[source]</a></span></div>

Local storage class.  This class represents the Storage interface for Flows stored as bytes in the local filesystem. Note that if you register a Flow with Prefect Cloud using this storage, your flow's environment will automatically be labeled with your machine's hostname. This ensures that only agents who are known to be running on the same filesystem can run your flow.

**Note**: Flows registered with this Storage option will automatically be  labeled with `hostname.local`.

**Args**:     <ul class="args"><li class="args">`directory (str, optional)`: the directory the flows will be stored in;         defaults to `~/.prefect/flows`.  If it doesn't already exist, it will be         created for you.     </li><li class="args">`validate (bool, optional)`: a boolean specifying whether to validate the         provided directory path; if `True`, the directory will be converted to an         absolute path and created.  Defaults to `True`</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-environments-storage-local-local-add-flow'><p class="prefect-class">prefect.environments.storage.local.Local.add_flow</p>(flow)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/local.py#L73">[source]</a></span></div>
<p class="methods">Method for storing a new flow as bytes in the local filesytem.<br><br>**Args**:     <ul class="args"><li class="args">`flow (Flow)`: a Prefect Flow to add</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: the location of the newly added flow in this Storage object</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if a flow with the same name is already contained in this storage</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-local-local-build'><p class="prefect-class">prefect.environments.storage.local.Local.build</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/local.py#L108">[source]</a></span></div>
<p class="methods">Build the Storage object.<br><br>**Returns**:     <ul class="args"><li class="args">`Storage`: a Storage object that contains information about how and where         each flow is stored</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-local-local-get-flow'><p class="prefect-class">prefect.environments.storage.local.Local.get_flow</p>(flow_location)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/local.py#L54">[source]</a></span></div>
<p class="methods">Given a flow_location within this Storage object, returns the underlying Flow (if possible).<br><br>**Args**:     <ul class="args"><li class="args">`flow_location (str)`: the location of a flow within this Storage; in this case,         a file path where a Flow has been serialized to</li></ul>**Returns**:     <ul class="args"><li class="args">`Flow`: the requested flow</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if the flow is not contained in this storage</li></ul></p>|

---
<br>

 ## S3
 <div class='class-sig' id='prefect-environments-storage-s3-s3'><p class="prefect-sig">class </p><p class="prefect-class">prefect.environments.storage.s3.S3</p>(bucket, aws_access_key_id=None, aws_secret_access_key=None, aws_session_token=None, key=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/s3.py#L16">[source]</a></span></div>

S3 storage class.  This class represents the Storage interface for Flows stored as bytes in an S3 bucket.

This storage class optionally takes a `key` which will be the name of the Flow object when stored in S3. If this key is not provided the Flow upload name will take the form `slugified-flow-name/slugified-current-timestamp`.

**Note**: Flows registered with this Storage option will automatically be  labeled with `s3-flow-storage`.

**Args**:     <ul class="args"><li class="args">`bucket (str)`: the name of the S3 Bucket to store Flows     </li><li class="args">`aws_access_key_id (str, optional)`: AWS access key id for connecting to S3.         Defaults to the value set in the environment variable         `AWS_ACCESS_KEY_ID` or `None`     </li><li class="args">`aws_secret_access_key (str, optional)`: AWS secret access key for connecting to S3.         Defaults to the value set in the environment variable         `AWS_SECRET_ACCESS_KEY` or `None`     </li><li class="args">`aws_session_token (str, optional)`: AWS session key for connecting to S3         Defaults to the value set in the environment variable         `AWS_SESSION_TOKEN` or `None`     </li><li class="args">`key (str, optional)`: a unique key to use for uploading a Flow to S3. This         is only useful when storing a single Flow using this storage object.</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-environments-storage-s3-s3-add-flow'><p class="prefect-class">prefect.environments.storage.s3.S3.add_flow</p>(flow)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/s3.py#L106">[source]</a></span></div>
<p class="methods">Method for storing a new flow as bytes in the local filesytem.<br><br>**Args**:     <ul class="args"><li class="args">`flow (Flow)`: a Prefect Flow to add</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: the location of the newly added flow in this Storage object</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if a flow with the same name is already contained in this storage</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-s3-s3-build'><p class="prefect-class">prefect.environments.storage.s3.S3.build</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/s3.py#L135">[source]</a></span></div>
<p class="methods">Build the S3 storage object by uploading Flows to an S3 bucket. This will upload all of the flows found in `storage.flows`. If there is an issue uploading to the S3 bucket an error will be logged.<br><br>**Returns**:     <ul class="args"><li class="args">`Storage`: an S3 object that contains information about how and where         each flow is stored</li></ul>**Raises**:     <ul class="args"><li class="args">`botocore.ClientError`: if there is an issue uploading a Flow to S3</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-s3-s3-get-flow'><p class="prefect-class">prefect.environments.storage.s3.S3.get_flow</p>(flow_location)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/s3.py#L66">[source]</a></span></div>
<p class="methods">Given a flow_location within this Storage object, returns the underlying Flow (if possible). If the Flow is not found an error will be logged and `None` will be returned.<br><br>**Args**:     <ul class="args"><li class="args">`flow_location (str)`: the location of a flow within this Storage; in this case,         a file path where a Flow has been serialized to</li></ul>**Returns**:     <ul class="args"><li class="args">`Flow`: the requested Flow</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if the Flow is not contained in this storage     </li><li class="args">`botocore.ClientError`: if there is an issue downloading the Flow from S3</li></ul></p>|

---
<br>

 ## GCS
 <div class='class-sig' id='prefect-environments-storage-gcs-gcs'><p class="prefect-sig">class </p><p class="prefect-class">prefect.environments.storage.gcs.GCS</p>(bucket, key=None, project=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/gcs.py#L16">[source]</a></span></div>

GoogleCloudStorage storage class.  This class represents the Storage interface for Flows stored as bytes in an GCS bucket.

This storage class optionally takes a `key` which will be the name of the Flow object when stored in GCS. If this key is not provided the Flow upload name will take the form `slugified-flow-name/slugified-current-timestamp`.

**Note**: Flows registered with this Storage option will automatically be  labeled with `gcs-flow-storage`.

**Args**:     <ul class="args"><li class="args">`bucket (str, optional)`: the name of the GCS Bucket to store the Flow     </li><li class="args">`key (str, optional)`: a unique key to use for uploading this Flow to GCS. This         is only useful when storing a single Flow using this storage object.     </li><li class="args">`project (str, optional)`: the google project where any GCS API requests are billed to</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-environments-storage-gcs-gcs-add-flow'><p class="prefect-class">prefect.environments.storage.gcs.GCS.add_flow</p>(flow)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/gcs.py#L80">[source]</a></span></div>
<p class="methods">Method for storing a new flow as bytes in a GCS bucket.<br><br>**Args**:     <ul class="args"><li class="args">`flow (Flow)`: a Prefect Flow to add</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: the key of the newly added flow in the GCS bucket</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if a flow with the same name is already contained in this storage</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-gcs-gcs-build'><p class="prefect-class">prefect.environments.storage.gcs.GCS.build</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/gcs.py#L118">[source]</a></span></div>
<p class="methods">Build the GCS storage object by uploading Flows to an GCS bucket. This will upload all of the flows found in `storage.flows`.<br><br>**Returns**:     <ul class="args"><li class="args">`Storage`: an GCS object that contains information about how and where         each flow is stored</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-gcs-gcs-get-flow'><p class="prefect-class">prefect.environments.storage.gcs.GCS.get_flow</p>(flow_location)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/gcs.py#L49">[source]</a></span></div>
<p class="methods">Given a flow_location within this Storage object, returns the underlying Flow (if possible).<br><br>**Args**:     <ul class="args"><li class="args">`flow_location (str)`: the location of a flow within this Storage; in this case,         a file path where a Flow has been serialized to</li></ul>**Returns**:     <ul class="args"><li class="args">`Flow`: the requested flow</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if the flow is not contained in this storage</li></ul></p>|

---
<br>

 ## Azure
 <div class='class-sig' id='prefect-environments-storage-azure-azure'><p class="prefect-sig">class </p><p class="prefect-class">prefect.environments.storage.azure.Azure</p>(container, connection_string=None, blob_name=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/azure.py#L15">[source]</a></span></div>

Azure Blob storage class.  This class represents the Storage interface for Flows stored as bytes in an Azure container.

This storage class optionally takes a `blob_name` which will be the name of the Flow object when stored in Azure. If this key is not provided the Flow upload name will take the form `slugified-flow-name/slugified-current-timestamp`.

**Note**: Flows registered with this Storage option will automatically be  labeled with `azure-flow-storage`.

**Args**:     <ul class="args"><li class="args">`container (str)`: the name of the Azure Blob Container to store the Flow     </li><li class="args">`connection_string (str, optional)`: an Azure connection string for communicating with         Blob storage. If not provided the value set in the environment as `CONNECTION_STRING`         will be used     </li><li class="args">`blob_name (str, optional)`: a unique key to use for uploading this Flow to Azure. This         is only useful when storing a single Flow using this storage object.</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-environments-storage-azure-azure-add-flow'><p class="prefect-class">prefect.environments.storage.azure.Azure.add_flow</p>(flow)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/azure.py#L79">[source]</a></span></div>
<p class="methods">Method for storing a new flow as bytes in an Azure Blob container.<br><br>**Args**:     <ul class="args"><li class="args">`flow (Flow)`: a Prefect Flow to add</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: the key of the newly added Flow in the container</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if a flow with the same name is already contained in this storage</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-azure-azure-build'><p class="prefect-class">prefect.environments.storage.azure.Azure.build</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/azure.py#L117">[source]</a></span></div>
<p class="methods">Build the Azure storage object by uploading Flows to an Azure Blob container. This will upload all of the flows found in `storage.flows`.<br><br>**Returns**:     <ul class="args"><li class="args">`Storage`: an Azure object that contains information about how and where         each flow is stored</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-azure-azure-get-flow'><p class="prefect-class">prefect.environments.storage.azure.Azure.get_flow</p>(flow_location)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/azure.py#L53">[source]</a></span></div>
<p class="methods">Given a flow_location within this Storage object, returns the underlying Flow (if possible).<br><br>**Args**:     <ul class="args"><li class="args">`flow_location (str)`: the location of a flow within this Storage; in this case,         a file path where a Flow has been serialized to</li></ul>**Returns**:     <ul class="args"><li class="args">`Flow`: the requested flow</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if the flow is not contained in this storage</li></ul></p>|

---
<br>

 ## Memory
 <div class='class-sig' id='prefect-environments-storage-memory-memory'><p class="prefect-sig">class </p><p class="prefect-class">prefect.environments.storage.memory.Memory</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/memory.py#L10">[source]</a></span></div>

Memory Storage class, mainly used for testing.  This class represents the Storage interface for Flows contained in memory, i.e., flows are simply stored as attributes of this class.

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-environments-storage-memory-memory-add-flow'><p class="prefect-class">prefect.environments.storage.memory.Memory.add_flow</p>(flow)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/memory.py#L38">[source]</a></span></div>
<p class="methods">Method for adding a new flow to this Storage object.<br><br>**Args**:     <ul class="args"><li class="args">`flow (Flow)`: a Prefect Flow to add</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: the location of the newly added flow in this Storage object</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if a flow with the same name is already contained in this storage</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-memory-memory-build'><p class="prefect-class">prefect.environments.storage.memory.Memory.build</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/memory.py#L68">[source]</a></span></div>
<p class="methods">Build the Storage object.<br><br>**Returns**:     <ul class="args"><li class="args">`Storage`: a Storage object that contains information about how and where         each flow is stored</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-memory-memory-get-flow'><p class="prefect-class">prefect.environments.storage.memory.Memory.get_flow</p>(flow_location)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/memory.py#L21">[source]</a></span></div>
<p class="methods">Given a flow_location within this Storage object, returns the underlying Flow (if possible).<br><br>**Args**:     <ul class="args"><li class="args">`flow_location (str)`: the location of a flow within this Storage</li></ul>**Returns**:     <ul class="args"><li class="args">`Flow`: the requested flow</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if the flow is not contained in this storage</li></ul></p>|

---
<br>

 ## Bytes
 <div class='class-sig' id='prefect-environments-storage-bytes-bytes'><p class="prefect-sig">class </p><p class="prefect-class">prefect.environments.storage.bytes.Bytes</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/bytes.py#L12">[source]</a></span></div>

Bytes Storage class, mainly used for testing.  This class represents the Storage interface for Flows stored directly as bytes.

The main difference between this class and `Memory` storage is that `Bytes` can be serialized and deserialized while preserving all relevant information.

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-environments-storage-bytes-bytes-add-flow'><p class="prefect-class">prefect.environments.storage.bytes.Bytes.add_flow</p>(flow)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/bytes.py#L44">[source]</a></span></div>
<p class="methods">Method for adding a new flow to this Storage object.<br><br>**Args**:     <ul class="args"><li class="args">`flow (Flow)`: a Prefect Flow to add</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: the location of the newly added flow in this Storage object</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if a flow with the same name is already contained in this storage</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-bytes-bytes-build'><p class="prefect-class">prefect.environments.storage.bytes.Bytes.build</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/bytes.py#L74">[source]</a></span></div>
<p class="methods">Build the Storage object.<br><br>**Returns**:     <ul class="args"><li class="args">`Storage`: a Storage object that contains information about how and where         each flow is stored</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-bytes-bytes-get-flow'><p class="prefect-class">prefect.environments.storage.bytes.Bytes.get_flow</p>(flow_location)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/bytes.py#L25">[source]</a></span></div>
<p class="methods">Given a flow_location within this Storage object, returns the underlying Flow (if possible).<br><br>**Args**:     <ul class="args"><li class="args">`flow_location (str)`: the location of a flow within this Storage; in this case,         a flow location is simply a Flow's name</li></ul>**Returns**:     <ul class="args"><li class="args">`Flow`: the requested flow</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if the flow is not contained in this storage</li></ul></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on December 17, 2019 at 21:20 UTC</p>