---
sidebarDepth: 2
editLink: false
---
# TaskRunner
---
 ## TaskRunner
 <div class='class-sig' id='prefect-engine-task-runner-taskrunner'><p class="prefect-sig">class </p><p class="prefect-class">prefect.engine.task_runner.TaskRunner</p>(task, state_handlers=None, result_handler=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/task_runner.py#L60">[source]</a></span></div>

TaskRunners handle the execution of Tasks and determine the State of a Task before, during and after the Task is run.

In particular, through the TaskRunner you can specify the states of any upstream dependencies and what state the Task should be initialized with.

**Args**:     <ul class="args"><li class="args">`task (Task)`: the Task to be run / executed     </li><li class="args">`state_handlers (Iterable[Callable], optional)`: A list of state change handlers         that will be called whenever the task changes state, providing an         opportunity to inspect or modify the new state. The handler         will be passed the task runner instance, the old (prior) state, and the new         (current) state, with the following signature: `state_handler(TaskRunner, old_state, new_state) -> Optional[State]`;         If multiple functions are passed, then the `new_state` argument will be the         result of the previous handler.     </li><li class="args">`result_handler (ResultHandler, optional)`: the handler to use for         retrieving and storing state results during execution (if the Task doesn't already have one);         if not provided here or by the Task, will default to the one specified in your config</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-engine-task-runner-taskrunner-cache-result'><p class="prefect-class">prefect.engine.task_runner.TaskRunner.cache_result</p>(state, inputs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/task_runner.py#L911">[source]</a></span></div>
<p class="methods">Caches the result of a successful task, if appropriate. Alternatively, if the task is failed, caches the inputs.<br><br>Tasks are cached if:     - task.cache_for is not None     - the task state is Successful     - the task state is not Skipped (which is a subclass of Successful)<br><br>**Args**:     <ul class="args"><li class="args">`state (State)`: the current state of this task     </li><li class="args">`inputs (Dict[str, Result], optional)`: a dictionary of inputs whose keys correspond         to the task's `run()` arguments.</li></ul>**Returns**:     <ul class="args"><li class="args">`State`: the state of the task after running the check</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-task-runner-taskrunner-call-runner-target-handlers'><p class="prefect-class">prefect.engine.task_runner.TaskRunner.call_runner_target_handlers</p>(old_state, new_state)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/task_runner.py#L100">[source]</a></span></div>
<p class="methods">A special state handler that the TaskRunner uses to call its task's state handlers. This method is called as part of the base Runner's `handle_state_change()` method.<br><br>**Args**:     <ul class="args"><li class="args">`old_state (State)`: the old (previous) state     </li><li class="args">`new_state (State)`: the new (current) state</li></ul>**Returns**:     <ul class="args"><li class="args">`State`: the new state</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-task-runner-taskrunner-check-for-retry'><p class="prefect-class">prefect.engine.task_runner.TaskRunner.check_for_retry</p>(state, inputs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/task_runner.py#L951">[source]</a></span></div>
<p class="methods">Checks to see if a FAILED task should be retried.<br><br>**Args**:     <ul class="args"><li class="args">`state (State)`: the current state of this task     </li><li class="args">`inputs (Dict[str, Result], optional)`: a dictionary of inputs whose keys correspond         to the task's `run()` arguments.</li></ul>**Returns**:     <ul class="args"><li class="args">`State`: the state of the task after running the check</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-task-runner-taskrunner-check-task-is-cached'><p class="prefect-class">prefect.engine.task_runner.TaskRunner.check_task_is_cached</p>(state, inputs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/task_runner.py#L605">[source]</a></span></div>
<p class="methods">Checks if task is cached and whether the cache is still valid.<br><br>**Args**:     <ul class="args"><li class="args">`state (State)`: the current state of this task     </li><li class="args">`inputs (Dict[str, Result])`: a dictionary of inputs whose keys correspond         to the task's `run()` arguments.</li></ul>**Returns**:     <ul class="args"><li class="args">`State`: the state of the task after running the check</li></ul>**Raises**:     <ul class="args"><li class="args">`ENDRUN`: if the task is not ready to run</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-task-runner-taskrunner-check-task-is-looping'><p class="prefect-class">prefect.engine.task_runner.TaskRunner.check_task_is_looping</p>(state, inputs=None, upstream_states=None, context=None, executor=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/task_runner.py#L993">[source]</a></span></div>
<p class="methods">Checks to see if the task is in a `Looped` state and if so, rerun the pipeline with an incremeneted `loop_count`.<br><br>**Args**:     <ul class="args"><li class="args">`state (State, optional)`: initial `State` to begin task run from;         defaults to `Pending()`     </li><li class="args">`inputs (Dict[str, Result], optional)`: a dictionary of inputs whose keys correspond         to the task's `run()` arguments.     </li><li class="args">`upstream_states (Dict[Edge, State])`: a dictionary         representing the states of any tasks upstream of this one. The keys of the         dictionary should correspond to the edges leading to the task.     </li><li class="args">`context (dict, optional)`: prefect Context to use for execution     </li><li class="args">`executor (Executor, optional)`: executor to use when performing         computation; defaults to the executor specified in your prefect configuration</li></ul>**Returns**:     <ul class="args"><li class="args">`State` object representing the final post-run state of the Task</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-task-runner-taskrunner-check-task-is-ready'><p class="prefect-class">prefect.engine.task_runner.TaskRunner.check_task_is_ready</p>(state)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/task_runner.py#L479">[source]</a></span></div>
<p class="methods">Checks to make sure the task is ready to run (Pending or Mapped).<br><br>**Args**:     <ul class="args"><li class="args">`state (State)`: the current state of this task</li></ul>**Returns**:     <ul class="args"><li class="args">`State`: the state of the task after running the check</li></ul>**Raises**:     <ul class="args"><li class="args">`ENDRUN`: if the task is not ready to run</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-task-runner-taskrunner-check-task-reached-start-time'><p class="prefect-class">prefect.engine.task_runner.TaskRunner.check_task_reached_start_time</p>(state)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/task_runner.py#L539">[source]</a></span></div>
<p class="methods">Checks if a task is in a Scheduled state and, if it is, ensures that the scheduled time has been reached. Note: Scheduled states include Retry states.<br><br>**Args**:     <ul class="args"><li class="args">`state (State)`: the current state of this task</li></ul>**Returns**:     <ul class="args"><li class="args">`State`: the state of the task after performing the check</li></ul>**Raises**:     <ul class="args"><li class="args">`ENDRUN`: if the task is Scheduled with a future scheduled time</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-task-runner-taskrunner-check-task-trigger'><p class="prefect-class">prefect.engine.task_runner.TaskRunner.check_task_trigger</p>(state, upstream_states)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/task_runner.py#L417">[source]</a></span></div>
<p class="methods">Checks if the task's trigger function passes.<br><br>**Args**:     <ul class="args"><li class="args">`state (State)`: the current state of this task     </li><li class="args">`upstream_states (Dict[Edge, Union[State, List[State]]])`: the upstream states</li></ul>**Returns**:     <ul class="args"><li class="args">`State`: the state of the task after running the check</li></ul>**Raises**:     <ul class="args"><li class="args">`ENDRUN`: if the trigger raises an error</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-task-runner-taskrunner-check-upstream-finished'><p class="prefect-class">prefect.engine.task_runner.TaskRunner.check_upstream_finished</p>(state, upstream_states)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/task_runner.py#L338">[source]</a></span></div>
<p class="methods">Checks if the upstream tasks have all finshed.<br><br>**Args**:     <ul class="args"><li class="args">`state (State)`: the current state of this task     </li><li class="args">`upstream_states (Dict[Edge, Union[State, List[State]]])`: the upstream states</li></ul>**Returns**:     <ul class="args"><li class="args">`State`: the state of the task after running the check</li></ul>**Raises**:     <ul class="args"><li class="args">`ENDRUN`: if upstream tasks are not finished.</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-task-runner-taskrunner-check-upstream-skipped'><p class="prefect-class">prefect.engine.task_runner.TaskRunner.check_upstream_skipped</p>(state, upstream_states)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/task_runner.py#L374">[source]</a></span></div>
<p class="methods">Checks if any of the upstream tasks have skipped.<br><br>**Args**:     <ul class="args"><li class="args">`state (State)`: the current state of this task     </li><li class="args">`upstream_states (Dict[Edge, State])`: the upstream states</li></ul>**Returns**:     <ul class="args"><li class="args">`State`: the state of the task after running the check</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-task-runner-taskrunner-get-task-inputs'><p class="prefect-class">prefect.engine.task_runner.TaskRunner.get_task_inputs</p>(state, upstream_states)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/task_runner.py#L564">[source]</a></span></div>
<p class="methods">Given the task's current state and upstream states, generates the inputs for this task. Upstream state result values are used. If the current state has `cached_inputs`, they will override any upstream values which are `NoResult`.<br><br>**Args**:     <ul class="args"><li class="args">`state (State)`: the task's current state.     </li><li class="args">`upstream_states (Dict[Edge, State])`: the upstream state_handlers</li></ul>**Returns**:     <ul class="args"><li class="args">`Dict[str, Result]`: the task inputs</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-task-runner-taskrunner-get-task-run-state'><p class="prefect-class">prefect.engine.task_runner.TaskRunner.get_task_run_state</p>(state, inputs, timeout_handler)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/task_runner.py#L822">[source]</a></span></div>
<p class="methods">Runs the task and traps any signals or errors it raises. Also checkpoints the result of a successful task, if `task.checkpoint` is `True`.<br><br>**Args**:     <ul class="args"><li class="args">`state (State)`: the current state of this task     </li><li class="args">`inputs (Dict[str, Result], optional)`: a dictionary of inputs whose keys correspond         to the task's `run()` arguments.     </li><li class="args">`timeout_handler (Callable, optional)`: function for timing out         task execution, with call signature `handler(fn, *args, **kwargs)`. Defaults to         `prefect.utilities.executors.timeout_handler`</li></ul>**Returns**:     <ul class="args"><li class="args">`State`: the state of the task after running the check</li></ul>**Raises**:     <ul class="args"><li class="args">`signals.PAUSE`: if the task raises PAUSE     </li><li class="args">`ENDRUN`: if the task is not ready to run</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-task-runner-taskrunner-initialize-run'><p class="prefect-class">prefect.engine.task_runner.TaskRunner.initialize_run</p>(state, context)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/task_runner.py#L124">[source]</a></span></div>
<p class="methods">Initializes the Task run by initializing state and context appropriately.<br><br>If the task is being retried, then we retrieve the run count from the initial Retry state. Otherwise, we assume the run count is 1. The run count is stored in context as task_run_count.<br><br>Also, if the task is being resumed through a `Resume` state, updates context to have `resume=True`.<br><br>**Args**:     <ul class="args"><li class="args">`state (Optional[State])`: the initial state of the run     </li><li class="args">`context (Dict[str, Any])`: the context to be updated with relevant information</li></ul>**Returns**:     <ul class="args"><li class="args">`tuple`: a tuple of the updated state, context, upstream_states, and inputs objects</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-task-runner-taskrunner-run'><p class="prefect-class">prefect.engine.task_runner.TaskRunner.run</p>(state=None, upstream_states=None, context=None, executor=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/task_runner.py#L180">[source]</a></span></div>
<p class="methods">The main endpoint for TaskRunners.  Calling this method will conditionally execute `self.task.run` with any provided inputs, assuming the upstream dependencies are in a state which allow this Task to run.<br><br>**Args**:     <ul class="args"><li class="args">`state (State, optional)`: initial `State` to begin task run from;         defaults to `Pending()`     </li><li class="args">`upstream_states (Dict[Edge, State])`: a dictionary         representing the states of any tasks upstream of this one. The keys of the         dictionary should correspond to the edges leading to the task.     </li><li class="args">`context (dict, optional)`: prefect Context to use for execution     </li><li class="args">`executor (Executor, optional)`: executor to use when performing         computation; defaults to the executor specified in your prefect configuration</li></ul>**Returns**:     <ul class="args"><li class="args">`State` object representing the final post-run state of the Task</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-task-runner-taskrunner-run-mapped-task'><p class="prefect-class">prefect.engine.task_runner.TaskRunner.run_mapped_task</p>(state, upstream_states, context, executor)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/task_runner.py#L655">[source]</a></span></div>
<p class="methods">If the task is being mapped, submits children tasks for execution. Returns a `Mapped` state.<br><br>**Args**:     <ul class="args"><li class="args">`state (State)`: the current task state     </li><li class="args">`upstream_states (Dict[Edge, State])`: the upstream states     </li><li class="args">`context (dict, optional)`: prefect Context to use for execution     </li><li class="args">`executor (Executor)`: executor to use when performing computation</li></ul>**Returns**:     <ul class="args"><li class="args">`State`: the state of the task after running the check</li></ul>**Raises**:     <ul class="args"><li class="args">`ENDRUN`: if the current state is not `Running`</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-task-runner-taskrunner-set-task-to-running'><p class="prefect-class">prefect.engine.task_runner.TaskRunner.set_task_to_running</p>(state)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/task_runner.py#L796">[source]</a></span></div>
<p class="methods">Sets the task to running<br><br>**Args**:     <ul class="args"><li class="args">`state (State)`: the current state of this task</li></ul>**Returns**:     <ul class="args"><li class="args">`State`: the state of the task after running the check</li></ul>**Raises**:     <ul class="args"><li class="args">`ENDRUN`: if the task is not ready to run</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-task-runner-taskrunner-wait-for-mapped-task'><p class="prefect-class">prefect.engine.task_runner.TaskRunner.wait_for_mapped_task</p>(state, executor)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/task_runner.py#L777">[source]</a></span></div>
<p class="methods">Blocks until a mapped state's children have finished running.<br><br>**Args**:     <ul class="args"><li class="args">`state (State)`: the current `Mapped` state     </li><li class="args">`executor (Executor)`: the run's executor</li></ul>**Returns**:     <ul class="args"><li class="args">`State`: the new state</li></ul></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on November 26, 2019 at 16:53 UTC</p>