---
sidebarDepth: 2
editLink: false
---
# FlowRunner
---
 ## FlowRunner
 <div class='class-sig' id='prefect-engine-flow-runner-flowrunner'><p class="prefect-sig">class </p><p class="prefect-class">prefect.engine.flow_runner.FlowRunner</p>(flow, task_runner_cls=None, state_handlers=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/flow_runner.py#L48">[source]</a></span></div>

FlowRunners handle the execution of Flows and determine the State of a Flow before, during and after the Flow is run.

In particular, through the FlowRunner you can specify which tasks should be the first tasks to run, which tasks should be returned after the Flow is finished, and what states each task should be initialized with.

**Args**:     <ul class="args"><li class="args">`flow (Flow)`: the `Flow` to be run     </li><li class="args">`task_runner_cls (TaskRunner, optional)`: The class used for running         individual Tasks. Defaults to [TaskRunner](task_runner.html)     </li><li class="args">`state_handlers (Iterable[Callable], optional)`: A list of state change handlers         that will be called whenever the flow changes state, providing an         opportunity to inspect or modify the new state. The handler         will be passed the flow runner instance, the old (prior) state, and the new         (current) state, with the following signature:             `state_handler(fr: FlowRunner, old_state: State, new_state: State) -> Optional[State]`         If multiple functions are passed, then the `new_state` argument will be the         result of the previous handler.</li></ul>Note: new FlowRunners are initialized within the call to `Flow.run()` and in general, this is the endpoint through which FlowRunners will be interacted with most frequently.

**Example**: 
```python
@task
def say_hello():
    print('hello')

with Flow("My Flow") as f:
    say_hello()

fr = FlowRunner(flow=f)
flow_state = fr.run()

```

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-engine-flow-runner-flowrunner-call-runner-target-handlers'><p class="prefect-class">prefect.engine.flow_runner.FlowRunner.call_runner_target_handlers</p>(old_state, new_state)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/flow_runner.py#L103">[source]</a></span></div>
<p class="methods">A special state handler that the FlowRunner uses to call its flow's state handlers. This method is called as part of the base Runner's `handle_state_change()` method.<br><br>**Args**:     <ul class="args"><li class="args">`old_state (State)`: the old (previous) state     </li><li class="args">`new_state (State)`: the new (current) state</li></ul>**Returns**:     <ul class="args"><li class="args">`State`: the new state</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-flow-runner-flowrunner-check-flow-is-pending-or-running'><p class="prefect-class">prefect.engine.flow_runner.FlowRunner.check_flow_is_pending_or_running</p>(state)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/flow_runner.py#L306">[source]</a></span></div>
<p class="methods">Checks if the flow is in either a Pending state or Running state. Either are valid starting points (because we allow simultaneous runs of the same flow run).<br><br>**Args**:     <ul class="args"><li class="args">`state (State)`: the current state of this flow</li></ul>**Returns**:     <ul class="args"><li class="args">`State`: the state of the flow after running the check</li></ul>**Raises**:     <ul class="args"><li class="args">`ENDRUN`: if the flow is not pending or running</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-flow-runner-flowrunner-check-flow-reached-start-time'><p class="prefect-class">prefect.engine.flow_runner.FlowRunner.check_flow_reached_start_time</p>(state)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/flow_runner.py#L281">[source]</a></span></div>
<p class="methods">Checks if the Flow is in a Scheduled state and, if it is, ensures that the scheduled time has been reached.<br><br>**Args**:     <ul class="args"><li class="args">`state (State)`: the current state of this Flow</li></ul>**Returns**:     <ul class="args"><li class="args">`State`: the state of the flow after performing the check</li></ul>**Raises**:     <ul class="args"><li class="args">`ENDRUN`: if the flow is Scheduled with a future scheduled time</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-flow-runner-flowrunner-determine-final-state'><p class="prefect-class">prefect.engine.flow_runner.FlowRunner.determine_final_state</p>(state, key_states, return_states, terminal_states)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/flow_runner.py#L497">[source]</a></span></div>
<p class="methods">Implements the logic for determining the final state of the flow run.<br><br>**Args**:     <ul class="args"><li class="args">`state (State)`: the current state of the Flow     </li><li class="args">`key_states (Set[State])`: the states which will determine the success / failure of the flow run     </li><li class="args">`return_states (Dict[Task, State])`: states to return as results     </li><li class="args">`terminal_states (Set[State])`: the states of the terminal tasks for this flow</li></ul>**Returns**:     <ul class="args"><li class="args">`State`: the final state of the flow run</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-flow-runner-flowrunner-get-flow-run-state'><p class="prefect-class">prefect.engine.flow_runner.FlowRunner.get_flow_run_state</p>(state, task_states, task_contexts, return_tasks, task_runner_state_handlers, executor)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/flow_runner.py#L356">[source]</a></span></div>
<p class="methods">Runs the flow.<br><br>**Args**:     <ul class="args"><li class="args">`state (State)`: starting state for the Flow. Defaults to         `Pending`     </li><li class="args">`task_states (dict)`: dictionary of task states to begin         computation with, with keys being Tasks and values their corresponding state     </li><li class="args">`task_contexts (Dict[Task, Dict[str, Any]])`: contexts that will be provided to each task     </li><li class="args">`return_tasks ([Task], optional)`: list of Tasks to include in the         final returned Flow state. Defaults to `None`     </li><li class="args">`task_runner_state_handlers (Iterable[Callable])`: A list of state change         handlers that will be provided to the task_runner, and called whenever a task changes         state.     </li><li class="args">`executor (Executor)`: executor to use when performing         computation; defaults to the executor provided in your prefect configuration</li></ul>**Returns**:     <ul class="args"><li class="args">`State`: `State` representing the final post-run state of the `Flow`.</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-flow-runner-flowrunner-initialize-run'><p class="prefect-class">prefect.engine.flow_runner.FlowRunner.initialize_run</p>(state, task_states, context, task_contexts, parameters)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/flow_runner.py#L127">[source]</a></span></div>
<p class="methods">Initializes the Task run by initializing state and context appropriately.<br><br>If the provided state is a Submitted state, the state it wraps is extracted.<br><br>**Args**:     <ul class="args"><li class="args">`state (Optional[State])`: the initial state of the run     </li><li class="args">`task_states (Dict[Task, State])`: a dictionary of any initial task states     </li><li class="args">`context (Dict[str, Any], optional)`: prefect.Context to use for execution         to use for each Task run     </li><li class="args">`task_contexts (Dict[Task, Dict[str, Any]], optional)`: contexts that will be provided to each task     </li><li class="args">`parameters(dict)`: the parameter values for the run</li></ul>**Returns**:     <ul class="args"><li class="args">`NamedTuple`: a tuple of initialized objects:         `(state, task_states, context, task_contexts)`</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-flow-runner-flowrunner-run'><p class="prefect-class">prefect.engine.flow_runner.FlowRunner.run</p>(state=None, task_states=None, return_tasks=None, parameters=None, task_runner_state_handlers=None, executor=None, context=None, task_contexts=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/flow_runner.py#L188">[source]</a></span></div>
<p class="methods">The main endpoint for FlowRunners.  Calling this method will perform all computations contained within the Flow and return the final state of the Flow.<br><br>**Args**:     <ul class="args"><li class="args">`state (State, optional)`: starting state for the Flow. Defaults to         `Pending`     </li><li class="args">`task_states (dict, optional)`: dictionary of task states to begin         computation with, with keys being Tasks and values their corresponding state     </li><li class="args">`return_tasks ([Task], optional)`: list of Tasks to include in the         final returned Flow state. Defaults to `None`     </li><li class="args">`parameters (dict, optional)`: dictionary of any needed Parameter         values, with keys being strings representing Parameter names and values being         their corresponding values     </li><li class="args">`task_runner_state_handlers (Iterable[Callable], optional)`: A list of state change         handlers that will be provided to the task_runner, and called whenever a task changes         state.     </li><li class="args">`executor (Executor, optional)`: executor to use when performing         computation; defaults to the executor specified in your prefect configuration     </li><li class="args">`context (Dict[str, Any], optional)`: prefect.Context to use for execution         to use for each Task run     </li><li class="args">`task_contexts (Dict[Task, Dict[str, Any]], optional)`: contexts that will be provided to each task</li></ul>**Returns**:     <ul class="args"><li class="args">`State`: `State` representing the final post-run state of the `Flow`.</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-flow-runner-flowrunner-run-task'><p class="prefect-class">prefect.engine.flow_runner.FlowRunner.run_task</p>(task, state, upstream_states, context, task_runner_state_handlers, executor)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/flow_runner.py#L540">[source]</a></span></div>
<p class="methods">Runs a specific task. This method is intended to be called by submitting it to an executor.<br><br>**Args**:     <ul class="args"><li class="args">`task (Task)`: the task to run     </li><li class="args">`state (State)`: starting state for the Flow. Defaults to         `Pending`     </li><li class="args">`upstream_states (Dict[Edge, State])`: dictionary of upstream states     </li><li class="args">`context (Dict[str, Any])`: a context dictionary for the task run     </li><li class="args">`task_runner_state_handlers (Iterable[Callable])`: A list of state change         handlers that will be provided to the task_runner, and called whenever a task changes         state.     </li><li class="args">`executor (Executor)`: executor to use when performing         computation; defaults to the executor provided in your prefect configuration</li></ul>**Returns**:     <ul class="args"><li class="args">`State`: `State` representing the final post-run state of the `Flow`.</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-flow-runner-flowrunner-set-flow-to-running'><p class="prefect-class">prefect.engine.flow_runner.FlowRunner.set_flow_to_running</p>(state)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/flow_runner.py#L334">[source]</a></span></div>
<p class="methods">Puts Pending flows in a Running state; leaves Running flows Running.<br><br>**Args**:     <ul class="args"><li class="args">`state (State)`: the current state of this flow</li></ul>**Returns**:     <ul class="args"><li class="args">`State`: the state of the flow after running the check</li></ul>**Raises**:     <ul class="args"><li class="args">`ENDRUN`: if the flow is not pending or running</li></ul></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on November 26, 2019 at 16:53 UTC</p>