/*
 * Copyright (c) 2022, AcmeStack
 * All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package log

import (
	"testing"
	"time"
)

func TestInfo(t *testing.T) {
	Info("123")
	Info("", 5, 1.1, "test")
	Info("%d %s", 5, "test")
	InnerLog("123")
}

func TestDebug(t *testing.T) {
	Debug("123")
	Debug("", 5, 1.1, "test", time.Now())
}

func TestError(t *testing.T) {
	Error("123")
	Error("", 5, 1.1, "test", time.Now())
}
