﻿namespace ScriptCs.Tests.Acceptance
{
    using System;
    using System.Reflection;
    using ScriptCs.Tests.Acceptance.Support;
    using Should;
    using Xbehave;
    using Xunit;

    public static class ScriptExecution
    {
        [Scenario]
        [Example(true)]
        [Example(false)]
        public static void HelloWorld(bool debug, ScenarioDirectory directory, string output)
        {
            var scenario = MethodBase.GetCurrentMethod().GetFullName();

            "Given a hello world script"
                .f(() => directory = ScenarioDirectory.Create(scenario)
                    .WriteLine("foo.csx", @"Console.WriteLine(""Hello world!"");"));

            "When I execute the script with debug set to {0}"
                .f(() => output = ScriptCsExe.Run("foo.csx", debug, directory));

            "Then I see 'Hello world!'"
                .f(() => output.ShouldContain("Hello world!"));
        }

        [Scenario]
        [Example(true)]
        [Example(false)]
        public static void ScriptThrowsAnException(bool debug, ScenarioDirectory directory, Exception exception)
        {
            var scenario = MethodBase.GetCurrentMethod().GetFullName();

            "Given a script which throws an exception"
                .f(() => directory = ScenarioDirectory.Create(scenario)
                    .WriteLine("foo.csx", @"throw new Exception(""BOOM!"");"));

            "When I execute the script with debug set to {0}"
                .f(() => exception = Record.Exception(() => ScriptCsExe.Run("foo.csx", debug, directory)));

            "Then scriptcs fails"
                .f(() => exception.ShouldBeType<ScriptCsException>());

            "And I see the exception message"
                .f(() => exception.Message.ShouldContain("BOOM!"));
        }
    }
}
