# Generated by Django 4.2.6 on 2024-01-18 13:14

import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("packagedb", "0081_apiuser"),
    ]

    operations = [
        migrations.CreateModel(
            name="PackageWatch",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "package_url",
                    models.CharField(
                        db_index=True,
                        help_text="Package-URL to watch. If the PURL has a version, qualifiers or subpath, they are stripped and ignored.",
                        max_length=2048,
                        unique=True,
                    ),
                ),
                (
                    "type",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="A short code to identify the type of this package.",
                        max_length=16,
                        null=True,
                    ),
                ),
                (
                    "namespace",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="Package name prefix, such as Maven groupid, Docker image owner, GitHub user or organization, etc.",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="Name of the package.",
                        max_length=100,
                        null=True,
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(
                        db_index=True,
                        default=True,
                        help_text="When set to True (Yes), this Package Watch is active. When set to False (No), this watch is inactive and not processed.",
                        null=True,
                    ),
                ),
                (
                    "depth",
                    models.PositiveSmallIntegerField(
                        choices=[(1, "Version"), (2, "Metadata"), (3, "Scan")],
                        default=3,
                        help_text="Depth of data collection from listing versions up to a full scan.",
                    ),
                ),
                (
                    "watch_interval",
                    models.PositiveSmallIntegerField(
                        default=7,
                        help_text="Number of days to wait between watches of this package.",
                        validators=[
                            django.core.validators.MinValueValidator(
                                1, message="Interval must be at least 1 day."
                            ),
                            django.core.validators.MaxValueValidator(
                                365, message="Interval must be at most 365 days."
                            ),
                        ],
                    ),
                ),
                (
                    "creation_date",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Timestamp indicating when this watch object was created.",
                    ),
                ),
                (
                    "last_watch_date",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        help_text="Timestamp indicating when this PURL was last watched.",
                        null=True,
                    ),
                ),
                (
                    "watch_error",
                    models.TextField(
                        blank=True,
                        help_text="Watch error messages of the last watch, if any. When present this means the watch failed. This is reset on each new watch.",
                        null=True,
                    ),
                ),
                (
                    "schedule_work_id",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="Identifier used to manage the periodic watch job.",
                        max_length=255,
                        null=True,
                        unique=True,
                    ),
                ),
            ],
        ),
    ]
