# Generated by Django 5.0.1 on 2024-03-04 19:33

from django.db import migrations


from django.contrib.auth.models import Group, Permission
from django.contrib.contenttypes.models import ContentType


def create_scan_queue_workers_group_and_permissions(apps, schema_editor):
    """
    Create the `scan_workers` groups and set permissions for it
    """
    ScannableURI = apps.get_model('minecode', 'ScannableURI')
    scan_queue_workers_group, _ = Group.objects.get_or_create(name='scan_queue_workers')
    # Add permissions to `scan_queue_workers` group
    scannable_uri_content_type = ContentType.objects.get_for_model(ScannableURI)
    names_by_codenames = {
        'change_scannableuri': 'Can change Scannable URI',
        'view_scannableuri': 'Can view Scannable URI',
    }
    for codename, name in names_by_codenames.items():
        permission, _ = Permission.objects.get_or_create(
            codename=codename,
            name=name,
            content_type=scannable_uri_content_type
        )
        scan_queue_workers_group.permissions.add(permission)


class Migration(migrations.Migration):

    dependencies = [
        ("minecode", "0034_scannableuri_alter_uuid_field"),
    ]

    operations = [
        migrations.RunPython(create_scan_queue_workers_group_and_permissions, migrations.RunPython.noop),
    ]
