# Generated by Django 5.0.1 on 2024-02-16 00:16

from django.db import migrations
import uuid


def populate_uuid(apps, schema_editor):
    ScannableURI = apps.get_model("minecode", "ScannableURI")
    unupdated = []
    scannable_uris = ScannableURI.objects.all().iterator(chunk_size=5000)
    for i, scannable_uri in enumerate(scannable_uris):
        if  i > 0 and not i % 5000:
            ScannableURI.objects.bulk_update(
                objs=unupdated,
                fields=[
                    "uuid"
                ]
            )
            unupdated = []
        scannable_uri.uuid = uuid.uuid4()
        unupdated.append(scannable_uri)

    if unupdated:
        ScannableURI.objects.bulk_update(
            objs=unupdated,
            fields=[
                "uuid",
            ]
        )


class Migration(migrations.Migration):

    dependencies = [
        (
            "minecode",
            "0032_remove_scannableuri_minecode_sc_scan_st_d6a459_idx_and_more",
        ),
    ]

    operations = [
        migrations.RunPython(populate_uuid, reverse_code=migrations.RunPython.noop),
    ]
