# Generated by Django 4.1.2 on 2022-11-17 17:23

from django.db import migrations
from django.db.models import Q


def populate_has_error_fields(apps, _):
    ResourceURI = apps.get_model("minecode", "ResourceURI")
    resource_uris = ResourceURI.objects.filter(
        Q(map_error__isnull=False) | Q(visit_error__isnull=False)
    ).iterator(chunk_size=5000)
    updated = []
    for i, resource_uri in enumerate(resource_uris):
        if not i % 5000:
            ResourceURI.objects.bulk_update(
                objs=updated,
                fields=[
                    "has_map_error",
                    "has_visit_error",
                ]
            )
            updated = []
        if resource_uri.map_error:
            resource_uri.has_map_error = True
        if resource_uri.visit_error:
            resource_uri.has_visit_error = True
        updated.append(resource_uri)
    if updated:
        ResourceURI.objects.bulk_update(
            objs=updated,
            fields=[
                "has_map_error",
                "has_visit_error",
            ]
        )

class Migration(migrations.Migration):

    dependencies = [
        ("minecode", "0024_remove_resourceuri_minecode_re_is_visi_51562c_idx_and_more"),
    ]

    operations = [
        migrations.RunPython(populate_has_error_fields, migrations.RunPython.noop),
    ]
