# -*- coding: utf-8 -*-
# Generated by Django 1.9.4 on 2016-07-07 19:49
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('minecode', '0001_initial'),
    ]

    operations = [
        migrations.RemoveField(
            model_name='resourceuri',
            name='error',
        ),
        migrations.AddField(
            model_name='resourceuri',
            name='last_map_date',
            field=models.DateTimeField(blank=True, db_index=True, help_text='Timestamp set to the date of the last mapping. Used to track mappinf status.', null=True),
        ),
        migrations.AddField(
            model_name='resourceuri',
            name='map_error',
            field=models.TextField(blank=True, help_text='Mapping errors messages. . When present this means the mapping failed.'),
        ),
        migrations.AddField(
            model_name='resourceuri',
            name='sha256',
            field=models.CharField(blank=True, db_index=True, help_text='SHA256 checksum hex-encoded (as in the sha256sum command) of the content of the file represented by this ResourceURI.', max_length=64, null=True),
        ),
        migrations.AddField(
            model_name='resourceuri',
            name='visit_error',
            field=models.TextField(blank=True, help_text='Visit errors messages. When present this means the visit failed.'),
        ),
        migrations.AlterField(
            model_name='resourceuri',
            name='canonical',
            field=models.CharField(db_index=True, help_text='Canonical form of the URI for this resource that must be unique across all ResourceURI.', max_length=3000, unique=True),
        ),
        migrations.AlterField(
            model_name='resourceuri',
            name='data',
            field=models.TextField(blank=True, help_text='Text content of the file represented by this ResourceURI. This contains the data that was fetched or extracted from a remote ResourceURI such as HTML or JSON.'),
        ),
        migrations.AlterField(
            model_name='resourceuri',
            name='file_name',
            field=models.CharField(blank=True, db_index=True, help_text='File name of a resource sometimes part of the URI proper and sometimes only available through an HTTP header.', max_length=255, null=True),
        ),
        migrations.AlterField(
            model_name='resourceuri',
            name='last_modified_date',
            field=models.DateTimeField(blank=True, db_index=True, help_text='Timestamp set to the last modified date of the remote resource represented by this URI such as the modified date of a file, the lastmod value on a sitemap or the modified date returned by an HTTP resource.', null=True),
        ),
        migrations.AlterField(
            model_name='resourceuri',
            name='last_visit_date',
            field=models.DateTimeField(blank=True, db_index=True, help_text='Timestamp set to the date of the last visit.  Used to track visit status.', null=True),
        ),
        migrations.AlterField(
            model_name='resourceuri',
            name='md5',
            field=models.CharField(blank=True, db_index=True, help_text='MD5 checksum hex-encoded (as in the md5sum command) of the content of the file represented by this ResourceURI.', max_length=32, null=True),
        ),
        migrations.AlterField(
            model_name='resourceuri',
            name='priority',
            field=models.PositiveIntegerField(db_index=True, default=0, help_text='Absolute procdssing priority of a URI (default to zero), higher number means higher priority, zero means lowest priority.'),
        ),
        migrations.AlterField(
            model_name='resourceuri',
            name='rank',
            field=models.PositiveIntegerField(blank=True, db_index=True, help_text='Relative rank of an URI inside a domain (such as the highest ranking project on sourceforge would be rank 1). Use to prioritize processing. Several URI may have the same rank, even inside the same domain.', null=True),
        ),
        migrations.AlterField(
            model_name='resourceuri',
            name='sha1',
            field=models.CharField(blank=True, db_index=True, help_text='SHA1 checksum hex-encoded (as in the sha1sum command) of the content of the file represented by this ResourceURI.', max_length=40, null=True),
        ),
        migrations.AlterField(
            model_name='resourceuri',
            name='sig',
            field=models.TextField(blank=True, help_text='PGP signature of the content of the file represented by this ResourceURI (such as an "asc" file at Apache.org).', null=True),
        ),
        migrations.AlterField(
            model_name='resourceuri',
            name='size',
            field=models.PositiveIntegerField(blank=True, db_index=True, help_text='Size in bytes of the file represented by this ResourceURI.', null=True),
        ),
        migrations.AlterField(
            model_name='resourceuri',
            name='uri',
            field=models.CharField(db_index=True, help_text='URI for this resource. This is the unmodified original URI.', max_length=2048),
        ),
        migrations.AlterField(
            model_name='resourceuri',
            name='wip_date',
            field=models.DateTimeField(blank=True, db_index=True, help_text='Work In Progress. This is a timestamp set at the start of a visit or mapping or null when mo processing is in progress.', null=True),
        ),
    ]
