# Generated by Django 4.1.2 on 2023-02-09 20:29

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("packagedb", "0052_package_index_error_package_last_indexed_date"),
    ]

    operations = [
        migrations.CreateModel(
            name="ExactPackageArchiveIndex",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "sha1",
                    models.BinaryField(
                        db_index=True,
                        help_text="Binary form of a SHA1 checksum in lowercase hex for a file",
                        max_length=20,
                    ),
                ),
                (
                    "package",
                    models.ForeignKey(
                        help_text="The Package that this file is from",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="packagedb.package",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ExactFileIndex",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "sha1",
                    models.BinaryField(
                        db_index=True,
                        help_text="Binary form of a SHA1 checksum in lowercase hex for a file",
                        max_length=20,
                    ),
                ),
                (
                    "package",
                    models.ForeignKey(
                        help_text="The Package that this file is from",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="packagedb.package",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ApproximateDirectoryStructureIndex",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "indexed_elements_count",
                    models.IntegerField(
                        help_text="Number of elements that went into the fingerprint"
                    ),
                ),
                (
                    "chunk1",
                    models.BinaryField(
                        db_index=True,
                        help_text="Binary form of the first 8 (0-7) hex digits of the fingerprint",
                        max_length=4,
                    ),
                ),
                (
                    "chunk2",
                    models.BinaryField(
                        db_index=True,
                        help_text="Binary form of the second 8 (8-15) hex digits of the fingerprint",
                        max_length=4,
                    ),
                ),
                (
                    "chunk3",
                    models.BinaryField(
                        db_index=True,
                        help_text="Binary form of the third 8 (16-23) hex digits of the fingerprint",
                        max_length=4,
                    ),
                ),
                (
                    "chunk4",
                    models.BinaryField(
                        db_index=True,
                        help_text="Binary form of the fourth 8 (24-32) hex digits of the fingerprint",
                        max_length=4,
                    ),
                ),
                (
                    "path",
                    models.CharField(
                        help_text="The full path value of this directory",
                        max_length=2000,
                    ),
                ),
                (
                    "package",
                    models.ForeignKey(
                        help_text="The Package that this directory is a part of",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="packagedb.package",
                    ),
                ),
            ],
            options={
                "abstract": False,
                "unique_together": {
                    ("chunk1", "chunk2", "chunk3", "chunk4", "package", "path")
                },
            },
        ),
        migrations.CreateModel(
            name="ApproximateDirectoryContentIndex",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "indexed_elements_count",
                    models.IntegerField(
                        help_text="Number of elements that went into the fingerprint"
                    ),
                ),
                (
                    "chunk1",
                    models.BinaryField(
                        db_index=True,
                        help_text="Binary form of the first 8 (0-7) hex digits of the fingerprint",
                        max_length=4,
                    ),
                ),
                (
                    "chunk2",
                    models.BinaryField(
                        db_index=True,
                        help_text="Binary form of the second 8 (8-15) hex digits of the fingerprint",
                        max_length=4,
                    ),
                ),
                (
                    "chunk3",
                    models.BinaryField(
                        db_index=True,
                        help_text="Binary form of the third 8 (16-23) hex digits of the fingerprint",
                        max_length=4,
                    ),
                ),
                (
                    "chunk4",
                    models.BinaryField(
                        db_index=True,
                        help_text="Binary form of the fourth 8 (24-32) hex digits of the fingerprint",
                        max_length=4,
                    ),
                ),
                (
                    "path",
                    models.CharField(
                        help_text="The full path value of this directory",
                        max_length=2000,
                    ),
                ),
                (
                    "package",
                    models.ForeignKey(
                        help_text="The Package that this directory is a part of",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="packagedb.package",
                    ),
                ),
            ],
            options={
                "abstract": False,
                "unique_together": {
                    ("chunk1", "chunk2", "chunk3", "chunk4", "package", "path")
                },
            },
        ),
    ]
