# Generated by Django 3.0.5 on 2020-05-04 18:33

from django.db import migrations, models
import uuid


def create_uuid(apps, schema_editor):
    CDitem = apps.get_model('clearcode', 'CDitem')
    # Use `iterator()` to prevent queryset from cacheing.
    # See: https://docs.djangoproject.com/en/3.0/ref/models/querysets/#iterator
    for item in CDitem.objects.iterator():
        item.uuid = uuid.uuid4()
        item.save(update_fields=['uuid'])


class Migration(migrations.Migration):

    dependencies = [
        ('clearcode', '0002_auto_20200331_1052'),
    ]

    operations = [
        migrations.AddField(
            model_name='cditem',
            name='uuid',
            field=models.UUIDField(blank=True, null=True)
        ),
        migrations.RunPython(create_uuid),
        migrations.AlterField(
            model_name='cditem',
            name='uuid',
            field=models.UUIDField(default=uuid.uuid4, unique=True, editable=False)
        )
    ]
