# Generated by Django 3.1.5 on 2021-03-10 19:04

from django.contrib.postgres.search import SearchVector, SearchVectorField
from django.db import migrations


def populate_search_vector_field(apps, schema_editor):
    """
    Data migration used to lowercase any purl field values that currently exist.
    """
    Package = apps.get_model('packagedb', 'Package')
    resource_uris = Package.objects.iterator(chunk_size=5000)
    updated = []
    for i, package in enumerate(resource_uris):
        if not i % 5000:
            Package.objects.bulk_update(
                objs=updated,
                fields=[
                    'search_vector',
                ]
            )
            updated = []
        package.search_vector = SearchVector('namespace', 'name', 'version', 'download_url')
        updated.append(package)
    if updated:
        Package.objects.bulk_update(
            objs=updated,
            fields=[
                'search_vector',
            ]
        )


class Migration(migrations.Migration):

    dependencies = [
        ('packagedb', '0046_add_extra_data_to_package'),
    ]

    operations = [
        migrations.AddField(
            model_name='package',
            name='search_vector',
            field=SearchVectorField(null=True),
        ),
        migrations.RunPython(populate_search_vector_field),
    ]
