# Generated by Django 3.1.3 on 2020-11-18 00:43

from django.db import migrations
import packagedb.models


def lowercase_purl_fields(apps, schema_editor):
    """
    Data migration used to lowercase any purl field values that currently exist.
    """
    Package = apps.get_model('packagedb', 'Package')

    for pkg in Package.objects.iterator():
        for field in ['type', 'namespace', 'name', 'version', 'qualifiers', 'subpath']:
            if hasattr(pkg, field):
                setattr(pkg, field, getattr(pkg, field).lower())

        pkg.save()


class Migration(migrations.Migration):

    dependencies = [
        ('packagedb', '0042_update_fields_to_django3_standards'),
    ]

    operations = [
        migrations.RunPython(lowercase_purl_fields),
        migrations.AlterField(
            model_name='package',
            name='name',
            field=packagedb.models.LowerCaseField(max_length=100),
        ),
        migrations.AlterField(
            model_name='package',
            name='namespace',
            field=packagedb.models.LowerCaseField(max_length=255),
        ),
        migrations.AlterField(
            model_name='package',
            name='qualifiers',
            field=packagedb.models.LowerCaseField(max_length=1024),
        ),
        migrations.AlterField(
            model_name='package',
            name='subpath',
            field=packagedb.models.LowerCaseField(max_length=200),
        ),
        migrations.AlterField(
            model_name='package',
            name='type',
            field=packagedb.models.LowerCaseField(max_length=16),
        ),
        migrations.AlterField(
            model_name='package',
            name='version',
            field=packagedb.models.LowerCaseField(max_length=100),
        ),
    ]
